# Change history for `swift_too` module

`swifttools` 2.2 / `swift_too` 1.2.3

December 17th, 2021 `swift_too` module updated to version 1.2.3. Updates made in response to feedback from original release, and various quality of life improvements. Also new products can be fetched from the TOO API.

* `keyring` support. If you have `keyring` installed and it works on your system, your `shared_secret` will be saved to it when you first pass it as an argument. On subsequent uses, you can give just your `username`.
* `SkyCoord` support. `astropy` `SkyCoord` objects can be returned instead of RA and Dec from any Class now, if `astropy` is installed. Note `astropy` will not be installed as a dependency of swifttools. 
* Anonymous login by default: The default username for requests (except TOO requests) is now `anonymous`, meaning that requests can now be made without passing `username` and `shared_secret` at all.
* `Swift_TOO_Requests` support. This new request allows for the querying of approved Swift TOO requests sent to Swift by yourself and others. The approved XRT/BAT/UVOT modes and exposure time are reported. You can also choose to retrieve detailed information from the TOO Request, including justification texts. However, this detailed information is only available for TOOs you submitted. 
* `Swift_Calendar` support. In this version you may retrieve calendar information for any TOO. These are automatically attached to entries in a `Swift_TOO_Requests` entry. The Calendar shows all planned observations for a TOO, along with an estimate of how much time was actually observed during the calendar window. Note that this is different from the Swift Plan, insofar as the Swift Calendar lists requested observations and can go much farther into the future. However, due to Swift’s oversubscription, and other issues, even if an object is in the Calendar, that is not guarantee that Swift will observe it on that day, only that it is in the queue to be observed.
* `ra_point` and `dec_point` renamed to `ra_object` and `dec_object`. These attributes give the RA/Dec of the object that was the intended target of an observation. We note that the original choice of using “point” to indicate this is not consistent with other missions where “point” is used to indicate where the telescope pointed. For now, these new variables are simply aliases of `ra_point` and `dec_point`. These will be deprecated upon the release of the next API version (1.3), but not necessarily the next release of `swifttools`. API version will only be updated if compatibility of the API format needs to be broken, and every effort will be made to make API changes transparent to `swifttools` module users.
