Build or run agent service deployments.

This command group consists of a number of functionalities for building service deployments, run locally stored service deployments, and run service deployments defined in the on-chain protocol. See the appropriate subcommands for more information.


## `autonomy deploy build`

Build a service deployment.

This command must be executed within a service folder. That is, a folder containing the service configuration file (`service.yaml`). The deployment will be created in the subfolder `./abci_build`.

### Usage

```bash
autonomy deploy build [OPTIONS] [KEYS_FILE]
```

### Options

`--o PATH`
:   Path to output directory.

`--n INTEGER`
:   Number of agents.

`--docker`
:   Use docker as a backend.

`--kubernetes`
:   Use kubernetes as a backend.

`--dev`
:   Create development environment.

`--force`
:   Remove existing build and overwrite with new one.

`--log-level [INFO|DEBUG|WARNING|ERROR|CRITICAL]`
:   Logging level for runtime.

`--packages-dir PATH`
:   Path to packages directory (Use with `dev` mode).

`--open-aea-dir PATH`
:   Path to open-aea repo (Use with `dev` mode).

`--open-autonomy-dir PATH`
:   Path to open-autonomy repo (Use with `dev` mode).

`--aev`
:   Apply environment variable when loading service config.

`--use-hardhat`
:   Include a hardhat node in the deployment setup.

`--use-acn`
:   Include an ACN node in the deployment setup.

`--image-version TEXT`
:   Define runtime image version.

`--remote`
:   To use a remote registry.

`--local`
:   To use a local registry.

`-p`
:   Ask for password interactively.

`--password PASSWORD`
:   Set password for key encryption/decryption.

`--help`
:   Show the help message and exit.


### Examples
```bash
autonomy deploy build keys.json
```

Builds a service deployment using the keys stored in the file `keys.json` and applying environment variables to the service configuration file. The deployment will be generated by default for as many agents as keys are stored in `keys.json`. By default, the command searches for the file `keys.json`, if no file name is provided.




## `autonomy deploy run`

Run a service deployment locally stored.

This command is a wrapper around `docker-compose up` to run the service deployment. To execute this command you need to be located within the deployment environment subfolder (`./abci_build`), or specify it with the option `--build-dir`.

### Usage

```bash
autonomy deploy run [OPTIONS]
```

### Options

`--build-dir PATH`
:   Path where the deployment is located.

`--no-recreate`
:   If containers already exist, don not recreate them.

`--remove-orphans`
:   Remove containers for services not defined in the Compose file.

`--help`
:   Show the help message and exit.

### Examples
```bash
autonomy deploy run --build-dir ./abci_build
```

Runs the service deployment stored locally in the directory `./abci_build`.


## `autonomy deploy from-token`

Run a service deployment registered in the on-chain protocol.

This command allows to deploy services directly without having the need to explicitly fetch them locally (also known as "one-click deployment"). The command requires the `TOKEN_ID` which can be checked in the {{on_chain_frontend}}. See the [register a service on-chain](../../guides/register_packages_on_chain.md#register-a-service) guide for more information.

Currently, the command supports Autonolas staging chain, Görli testnet and Ethereum mainnet for resolving `TOKEN_ID`s, but if you have a contract deployed on some other chain you can provide the RPC URL to the chain and contract address using `--rpc` and `--sca`, respectively.

### Usage

```bash
autonomy deploy from-token [OPTIONS] TOKEN_ID KEYS_FILE
```

### Options
`--rpc RPC_URL`
:   Custom RPC URL.

`--sca SERVICE_CONTRACT_ADDRESS`
:   Service contract address for custom RPC URL.

`--n INTEGER`
:   Number of agents to include in the build.

`--skip-image`
:   Skip building images.

`--aev`
:   Apply environment variable when loading service config.

`--use-goerli`
:   Use Görli chain to resolve the `TOKEN_ID`.

`--use-ethereum`
:   Use Ethereum chain to resolve the `TOKEN_ID`.

`--use-staging`
:   Use staging chain to resolve the `TOKEN_ID`.

`--help`
:   Show the help message and exit.


### Examples

```bash
autonomy deploy from-token --use-goerli 2 keys.json
```

Runs the service deployment registered with `TOKEN_ID`=2 in the Görli on-chain protocol. The deployment will be run for as many agents as keys are defined in the `keys.json` file.
