# python-logger
Python3 ?????????

## ????

### ??

```shell
pip install colorful-logger
```

### ??

#### 1 ?? logger

?????????`logger`???????????????`warning`?

```python
from colorful_logger import logger

with logger:
    logger.debug("This is a debug message.")
    logger.info("This is a info message.")
    logger.warning("This is a warning message.")
    logger.error("This is a error message.")
    logger.critical("This is a critical message.")
    logger.fatal("This is a fatal message.")
```

?????`logger`???`with`??????????????`QueueListener`?????????`logger`?????????`start`????????????`stop`??????????????`with`??????????????????`start`?`stop`???

> ?????`start`???????????????`stop`??

![2022-01-12_23-20](https://s4.ax1x.com/2022/01/12/7K7VK0.png)

#### 2 ??? logger

??????`name`????????????????????????

```python
from colorful_logger import get_logger, DEBUG

logger = get_logger(name="sample_logger", level=DEBUG, file_path="./test.log")

with get_logger(name="sample_logger", level=DEBUG, file_path="./test.log", file_colorful=True) as logger:
    logger.debug("This is a debug message.")
    logger.info("This is a info message.")
    logger.warning("This is a warning message.")
    logger.error("This is a error message.")
    logger.critical("This is a critical message.")
    logger.fatal("This is a fatal message.")
```

?`with`?????????????????????????

![2022-01-12_23-23](https://s4.ax1x.com/2022/01/12/7K73x1.png)

????`./test.log`????????????????

```
[90m23:22:42[0m [35m[DEBUG] [0m[36msample_logger - [0mThis is a debug message.
[90m23:22:42[0m [32m[INFO]  [0m[36msample_logger - [0mThis is a info message.
[90m23:22:42[0m [93m[WARN]  [0m[36msample_logger - [0mThis is a warning message.
[90m23:22:42[0m [31m[ERROR] [0m[33mtest.py:17[0m [36msample_logger - [0mThis is a error message.
[90m23:22:42[0m [31m[FATAL] [0m[33mtest.py:18[0m [36msample_logger - [0mThis is a critical message.
[90m23:22:42[0m [31m[FATAL] [0m[33mtest.py:19[0m [36msample_logger - [0mThis is a fatal message.
```

?????????????????

?????????????????`file_colorful`?????`True`????????????????

???????????????????????????

```shell
tail -f test.log
# ?
cat test.log
```

?????????????

>`FATAL`?`CRITICAL`???????????????? python ?????????????????????????????????????????`fatal`??????`sys.exit(1)`??????????????????????????????`critical`???

`get_logger`???

```python
def get_logger(
    name: Optional[str] = None,
    level: int = default_level,
    datefmt: str = TIME_FORMAT_WITHOUT_DATE,
    show: bool = True,
    file_path: Optional[str] = None,
    file_colorful: bool = False,
) -> Logger: ...
```

- *name* logger ????????????????????????
- *level* ????
- *datefmt* ??????????????????24?????
- *show* ??????????????????????????????????
- *file_path* ???????????`None`?????`None`????????????
- *file_colorful* ????????????????? False?? python ?????????

#### 3 ? logger

?????`logger`??????`logger`??`name`??????????????????`child_logger`????? logger?? logger ???? logger ?`with`??????

```python
from colorful_logger import get_logger, DEBUG

# parent logger
logger = get_logger(name="sample_logger", level=DEBUG, file_path="./test.log")

with logger:
    logger.error("parent error")
    l1 = child_logger("l1", logger)
    l1.error("l1 error")
    l1.fatal("l1 fatal")
```

? logger ?? name ?? logger ??????????????????????

? logger ?? logger ?`with`?????????????`with`?????????`with`?????????????????

```python
from colorful_logger import get_logger, DEBUG

from other_file import test

# parent logger
logger = get_logger(name="sample_logger", level=DEBUG, file_path="./test.log")

with logger:
    test()
```

```python
# other_file.py

test_logger = child_logger("test_logger", logger)

def test():
  test_logger.error("test error")
```
