import numpy as np

NUM_SHEKEL_PROBLEMS = 1000
NUM_SHEKEL_COEFF = 10

kShekel = np.array([
    [23.93246, 17.63833, 18.27250, 19.15204, 14.05667, 9.04614, 17.96243, 20.56200, 21.70278, 10.51653],
    [20.21043, 14.19828, 18.60210, 9.56008, 24.36399, 6.35990, 22.81732, 11.09943, 8.32163, 15.35493],
    [13.42311, 5.92776, 5.65432, 12.62902, 9.60097, 5.92471, 22.45170, 24.72961, 7.27302, 6.65654],
    [12.02170, 21.69851, 16.39683, 7.98532, 15.57100, 7.54830, 12.05344, 13.30897, 6.97577, 18.42814],
    [22.44865, 18.06070, 9.79385, 24.10825, 6.95074, 8.08786, 24.61486, 18.41472, 7.29682, 18.54472],
    [14.89471, 14.22941, 5.08240, 13.91018, 9.39039, 8.69091, 8.66955, 19.77157, 9.32020, 14.20988],
    [22.63298, 6.98492, 18.37565, 20.93310, 22.86981, 18.84686, 23.70907, 6.27750, 10.49699, 21.89627],
    [6.02603, 17.15979, 7.66732, 10.97430, 6.90313, 20.54369, 8.41868, 9.17310, 11.45161, 7.93649],
    [7.69234, 13.28333, 14.46745, 9.45509, 21.63503, 5.37782, 8.17576, 23.08222, 22.32109, 21.15772],
    [19.70321, 14.75005, 20.01083, 15.67415, 16.40538, 14.86541, 16.07028, 17.06397, 7.16376, 6.90680],
    [19.68551, 8.91186, 17.79458, 13.71487, 11.48579, 11.87887, 8.67138, 17.10303, 7.21015, 5.20325],
    [12.71142, 16.41697, 24.53490, 18.71990, 21.83096, 21.66189, 6.18961, 16.00070, 20.00351, 6.82196],
    [22.49443, 19.26801, 11.04633, 19.00983, 6.42216, 16.67394, 19.26069, 9.04675, 24.34385, 22.60186],
    [11.03900, 19.12946, 15.54109, 11.59017, 15.58565, 13.17652, 23.65474, 16.52257, 12.85730, 5.50966],
    [13.15332, 11.69149, 6.85614, 13.46950, 13.98160, 11.38142, 12.39891, 9.60341, 7.48299, 24.57335],
    [13.49086, 19.05805, 16.75268, 16.41209, 21.42201, 17.77627, 14.51079, 17.05969, 10.71612, 17.15491],
    [11.65914, 8.55113, 21.06128, 10.76128, 19.61287, 10.28642, 23.33125, 8.75317, 9.54909, 13.77590],
    [17.84585, 15.61373, 21.70339, 7.27485, 22.97296, 16.83264, 7.81442, 20.92334, 22.21305, 10.16129],
    [19.87594, 13.01294, 7.88217, 7.05878, 8.28379, 8.02377, 9.52467, 19.96017, 22.54204, 7.03131],
    [5.17151, 20.99048, 17.61208, 21.12903, 23.58333, 7.74545, 19.07208, 8.48155, 15.58626, 21.77786],
    [10.17106, 5.63662, 22.64458, 15.38728, 13.93826, 13.71670, 20.77319, 12.37144, 13.44203, 10.12162],
    [7.93710, 18.33964, 23.35200, 6.36540, 13.04590, 6.22074, 15.90304, 22.66411, 14.67742, 12.59789],
    [14.40641, 19.91440, 7.65084, 10.47990, 17.42225, 19.67513, 5.58168, 14.15006, 6.71697, 12.78283],
    [17.53151, 21.70827, 22.14713, 7.22663, 6.88665, 10.92914, 16.56224, 15.90365, 10.59343, 14.07498],
    [13.89554, 14.88128, 6.86163, 7.26753, 23.52290, 12.79870, 9.47401, 20.06516, 14.04752, 22.01651],
    [16.82531, 20.85070, 19.62264, 12.15842, 13.80398, 23.67611, 21.93350, 16.65563, 14.66094, 12.16636],
    [20.97217, 12.92138, 24.97253, 6.12613, 17.72622, 6.79388, 10.83270, 6.46367, 21.90542, 21.84927],
    [13.39686, 24.05820, 7.83212, 24.23032, 16.90161, 8.20139, 11.62252, 23.60714, 8.28562, 20.23606],
    [12.78100, 20.89099, 16.54027, 8.00363, 13.33094, 23.33979, 9.90432, 6.75481, 17.61574, 17.66091],
    [19.04706, 22.11234, 5.88321, 21.75405, 24.34019, 20.74206, 24.78576, 5.70925, 15.36592, 24.33958],
    [7.92062, 22.69097, 20.77013, 12.55882, 9.53444, 20.32151, 16.59764, 10.52019, 24.51353, 13.20826],
    [11.22394, 6.50395, 17.79214, 7.22175, 15.01801, 15.46968, 16.29856, 16.15757, 12.85241, 14.01883],
    [6.56438, 21.40736, 7.59285, 22.43034, 11.12384, 15.26154, 12.69005, 19.38765, 6.82623, 18.47087],
    [21.99454, 5.02869, 18.18827, 12.69127, 14.92401, 17.94229, 8.90942, 18.43364, 5.11292, 21.72903],
    [24.67956, 19.14838, 10.65630, 6.76519, 10.39384, 22.06961, 14.08048, 22.78375, 14.91668, 16.43773],
    [10.17167, 7.89377, 6.49846, 19.73556, 9.77676, 9.68703, 11.99240, 12.55028, 17.70302, 24.02036],
    [22.97418, 12.69982, 12.85180, 7.13141, 21.91153, 9.23841, 8.69640, 6.69683, 11.48946, 6.96905],
    [22.24052, 7.45735, 20.23057, 22.09464, 9.57595, 17.04077, 7.52510, 19.61715, 16.17344, 7.60628],
    [21.20228, 13.13013, 20.01267, 18.93292, 10.76373, 17.61147, 15.70040, 18.57585, 9.41115, 15.85238],
    [17.68471, 24.72411, 7.97983, 9.14380, 10.69842, 7.37129, 13.91934, 12.84448, 5.54872, 13.43837],
    [18.43181, 7.45735, 8.39244, 11.46077, 24.90356, 5.84109, 21.60207, 21.47511, 21.74978, 7.17475],
    [24.36888, 5.72451, 12.79626, 18.30973, 11.14887, 5.81118, 8.32835, 13.12586, 16.09104, 21.91397],
    [9.92752, 10.52385, 21.56606, 19.70687, 12.22007, 21.67531, 18.91644, 20.59679, 14.66643, 7.14728],
    [19.56893, 20.90503, 6.51799, 14.55168, 24.61058, 15.61861, 18.05765, 17.30811, 10.97674, 12.33909],
    [21.25538, 5.17762, 22.36259, 11.04999, 12.96594, 7.17658, 22.98029, 15.33174, 23.78903, 17.49428],
    [22.30277, 10.64287, 5.71535, 5.04639, 8.90149, 15.30061, 21.69485, 17.28980, 21.51601, 19.78133],
    [10.23148, 18.91034, 15.46724, 19.96139, 8.15622, 16.03000, 12.55882, 19.93637, 24.67895, 6.53813],
    [12.56859, 10.02762, 9.85549, 7.18513, 14.47539, 15.61800, 10.60259, 18.05704, 5.52980, 22.42119],
    [17.36366, 15.05768, 6.31046, 13.83084, 14.57244, 11.02680, 9.87259, 5.96438, 18.03079, 16.11057],
    [23.12983, 16.02268, 12.31895, 18.02042, 8.58165, 9.59548, 11.37837, 12.79565, 14.52788, 22.54265],
    [15.37690, 6.70110, 11.87094, 23.06269, 6.98920, 19.88205, 5.65432, 9.58998, 20.22324, 12.40013],
    [19.44929, 10.12955, 24.89807, 23.28242, 20.72008, 18.66985, 19.92111, 23.19575, 5.28504, 14.28129],
    [18.47880, 11.38447, 9.01624, 18.54656, 18.25846, 17.49062, 24.87487, 16.92419, 19.84237, 18.87677],
    [13.43348, 19.69344, 6.38737, 14.09024, 5.00183, 8.08847, 7.72042, 23.07672, 21.47084, 21.25172],
    [21.96951, 14.78118, 16.01169, 9.63637, 17.86111, 12.75842, 18.75652, 10.47746, 10.80889, 19.40962],
    [6.56987, 10.95904, 15.91464, 9.48378, 5.06043, 14.69939, 11.00238, 13.45790, 20.93188, 17.18421],
    [12.82861, 21.42750, 12.81396, 5.76846, 19.57137, 8.12449, 18.70464, 9.87625, 22.73675, 9.70412],
    [8.12021, 17.01453, 21.60695, 12.90124, 17.11707, 20.24155, 23.34773, 7.20222, 14.27274, 12.69616],
    [21.91031, 20.65111, 15.78219, 14.83062, 18.83953, 9.90555, 17.77139, 9.95621, 19.13129, 5.18616],
    [23.96542, 13.74111, 5.24598, 20.72497, 16.83630, 13.27296, 22.41325, 11.34846, 10.34623, 21.32130],
    [18.35185, 5.82461, 12.42454, 21.41530, 10.52751, 17.58461, 15.28840, 9.37208, 24.07834, 23.45454],
    [21.74734, 6.89337, 13.52077, 11.02435, 5.60244, 12.85363, 11.37898, 5.27100, 14.28129, 7.91513],
    [16.84912, 15.06256, 11.81234, 18.08390, 7.62581, 10.17289, 10.28825, 12.83593, 8.02316, 9.43068],
    [7.92123, 23.44356, 16.50365, 10.62273, 21.83035, 17.11341, 5.74892, 22.78191, 13.67702, 12.58019],
    [18.39763, 11.48091, 16.28208, 12.76086, 11.56453, 17.76345, 19.33699, 20.11155, 13.28455, 21.32862],
    [22.35038, 10.29984, 23.98434, 8.59935, 12.93542, 9.82620, 6.12613, 16.29978, 18.58745, 13.21253],
    [15.13825, 11.16535, 10.04776, 5.38881, 14.75677, 16.40782, 24.40855, 24.89685, 9.91165, 5.56764],
    [6.05594, 13.54274, 20.27451, 14.37223, 13.60439, 8.11655, 7.58919, 11.22333, 10.91571, 19.81246],
    [19.93210, 16.94922, 10.36088, 16.95959, 5.99124, 14.43449, 6.42033, 16.70812, 22.52861, 18.75958],
    [7.77169, 21.28346, 8.11655, 8.47056, 5.96805, 24.42808, 6.29826, 8.61339, 8.85449, 23.67611],
    [11.28315, 6.14261, 16.82531, 24.06064, 19.30403, 8.34422, 10.06668, 8.90332, 18.76873, 24.88586],
    [24.89563, 23.28913, 22.32231, 24.13083, 7.32307, 5.86673, 13.94986, 24.33164, 21.98050, 14.59380],
    [14.24039, 10.32914, 24.50743, 22.05252, 16.94494, 16.39134, 15.55147, 5.95645, 19.94369, 5.80081],
    [24.49095, 10.48601, 23.75484, 7.83273, 21.01001, 24.06125, 20.70605, 22.73797, 22.64824, 9.18714],
    [7.89865, 15.35676, 16.45543, 9.99954, 7.08075, 7.99448, 22.87042, 13.12098, 24.56297, 13.17652],
    [19.95163, 7.47261, 14.29411, 16.91321, 16.08371, 18.64971, 17.23365, 13.09595, 9.28968, 23.49483],
    [20.12986, 19.65377, 21.26331, 20.48997, 6.84149, 17.08716, 24.25779, 21.59658, 5.32472, 20.01938],
    [8.94910, 21.16199, 23.40449, 22.36869, 11.40156, 7.52632, 16.46031, 6.78777, 7.26081, 12.94519],
    [20.16037, 18.98358, 11.29536, 7.45796, 11.34663, 17.53945, 10.41643, 12.33055, 10.21683, 19.87899],
    [8.30210, 18.68816, 6.92022, 14.98138, 9.74319, 6.97211, 5.68728, 23.48140, 22.84478, 12.84265],
    [9.63149, 15.77853, 7.19794, 15.14435, 19.33149, 8.77697, 6.16520, 11.57857, 8.33445, 11.88375],
    [11.37959, 17.68899, 8.69579, 22.88995, 17.59926, 14.79034, 9.68032, 24.36155, 16.04526, 22.47490],
    [22.75689, 21.15894, 24.33164, 21.30726, 16.00436, 9.71816, 21.12781, 21.34571, 11.05792, 19.71541],
    [23.66878, 22.10196, 5.71902, 18.73272, 16.24790, 19.57625, 15.35432, 20.56444, 7.80221, 5.98880],
    [16.20640, 7.77779, 6.73406, 17.82510, 23.74935, 9.15784, 11.07501, 17.83303, 9.20240, 22.65740],
    [22.13553, 6.58635, 7.33711, 24.47935, 19.74593, 9.24757, 18.69488, 14.92523, 7.23579, 13.14478],
    [19.34492, 21.61489, 24.25596, 21.80044, 21.30909, 10.72039, 15.57527, 21.02588, 16.77038, 6.83538],
    [13.99258, 22.71477, 9.19996, 12.09311, 5.45839, 21.95303, 24.52391, 5.17579, 14.56023, 13.07581],
    [5.44496, 10.82965, 18.47636, 20.29710, 22.06900, 20.51012, 7.53853, 8.52977, 21.93045, 14.78545],
    [20.51683, 10.03128, 12.56432, 8.12876, 12.75414, 12.49046, 19.74410, 6.70965, 5.28321, 24.18577],
    [14.50163, 19.82345, 13.04224, 21.83950, 12.06809, 15.57649, 20.31297, 16.79540, 15.84872, 21.45619],
    [21.51601, 5.13184, 9.56557, 20.40819, 15.48372, 17.36000, 10.68743, 23.04437, 11.32771, 13.29920],
    [8.27403, 6.60894, 14.03958, 17.79153, 18.35856, 21.33473, 7.93832, 22.84906, 19.99557, 14.79095],
    [6.09989, 11.87155, 5.09705, 14.88372, 23.88241, 11.57125, 5.18494, 22.09952, 24.67895, 7.20099],
    [8.17820, 11.63656, 16.02939, 6.74261, 8.34605, 16.04526, 24.19736, 9.65529, 22.55364, 9.00098],
    [5.35646, 5.82583, 15.91525, 20.83117, 21.50136, 20.33677, 9.99344, 6.43010, 19.20881, 9.67666],
    [16.65746, 16.17893, 19.37727, 5.02747, 10.72954, 10.49821, 16.06723, 8.24229, 24.55382, 8.65978],
    [12.56676, 16.14414, 17.59194, 12.47948, 12.81213, 18.77056, 24.19431, 15.51973, 16.28208, 7.18818],
    [12.65160, 18.42448, 14.49309, 16.50670, 18.66680, 21.01062, 17.22388, 19.70260, 6.36113, 11.74215],
    [6.58879, 17.90139, 19.94919, 5.21546, 7.09235, 22.72088, 19.19660, 8.27342, 9.77798, 16.31199],
    [21.79861, 5.37904, 18.61003, 24.72350, 5.79287, 23.87265, 17.20191, 10.20524, 15.14130, 9.73464],
    [24.02890, 18.08939, 21.59291, 14.48393, 14.23063, 23.86105, 5.96744, 23.83236, 16.15207, 16.05075],
    [11.97897, 8.72021, 20.72863, 20.57482, 15.71627, 9.36598, 11.84835, 22.14347, 23.92087, 12.94031],
    [15.82125, 8.36192, 24.17112, 15.50508, 18.06681, 12.16147, 20.11216, 8.82885, 5.15992, 18.16141],
    [14.84588, 22.71844, 20.35142, 8.61217, 15.61190, 23.47285, 10.68682, 14.53398, 22.88079, 19.10504],
    [13.85830, 7.66610, 16.98706, 11.93930, 22.90216, 18.87310, 5.42787, 9.22132, 16.87292, 18.61248],
    [23.95016, 12.35618, 15.62716, 5.10132, 14.54680, 15.40925, 6.82134, 15.80844, 13.50124, 13.48659],
    [23.27387, 7.87729, 12.58873, 11.62435, 18.79070, 23.13837, 6.56926, 14.81048, 20.60595, 23.29768],
    [10.09415, 9.76394, 6.53874, 10.96210, 17.15247, 19.10077, 5.00793, 22.09891, 6.17924, 18.49712],
    [6.01810, 5.57009, 23.95749, 17.50160, 21.25111, 15.36287, 11.42720, 14.58831, 21.38356, 11.13605],
    [24.54100, 7.10700, 8.75378, 12.71874, 13.27845, 6.73040, 13.51100, 24.17112, 11.95090, 21.04053],
    [11.35456, 13.04590, 23.92331, 11.86911, 11.01520, 20.47288, 13.86746, 11.02802, 9.57228, 7.67769],
    [10.68987, 24.03500, 23.76217, 14.58464, 14.24039, 22.48344, 15.37385, 16.10385, 8.93811, 15.66561],
    [18.88531, 11.74459, 17.43507, 22.07938, 9.43922, 14.17386, 17.44606, 11.44002, 19.30342, 12.34031],
    [14.86663, 17.83120, 20.92822, 14.80010, 16.30406, 14.60479, 24.73327, 8.85998, 14.14762, 11.67257],
    [9.74380, 21.16260, 7.30415, 5.79897, 15.20600, 15.34822, 10.72283, 24.53246, 11.30085, 12.40745],
    [16.83081, 14.38688, 17.08655, 9.35743, 22.01224, 13.91507, 23.79025, 21.85720, 21.24989, 22.28263],
    [11.58162, 6.40141, 24.05271, 23.97824, 17.94229, 7.70577, 14.80193, 20.28062, 5.76296, 6.90985],
    [10.63555, 8.10923, 9.29640, 16.22898, 19.99252, 16.88208, 6.07913, 15.67782, 14.95148, 24.00632],
    [12.96350, 17.48268, 20.48082, 19.62508, 14.37040, 13.82229, 13.72707, 21.25294, 20.89465, 13.50795],
    [16.47069, 8.91003, 6.38676, 23.23542, 13.86746, 21.39882, 21.64174, 19.03363, 22.60491, 24.33042],
    [12.80297, 23.53389, 21.59719, 10.53789, 22.62993, 14.67986, 8.34849, 23.49910, 22.73309, 21.51601],
    [14.09940, 24.38536, 14.91729, 12.66137, 20.88916, 13.37672, 9.74624, 13.11365, 13.65871, 5.85391],
    [20.46312, 14.99054, 10.51714, 14.10123, 20.38377, 17.84524, 24.29868, 15.13825, 21.89444, 24.17844],
    [18.52580, 15.31465, 5.17335, 5.76662, 10.92425, 12.28477, 14.76836, 6.44108, 7.59346, 24.99084],
    [12.14560, 16.93030, 20.96545, 12.27622, 22.34245, 7.40242, 14.68169, 10.76434, 22.84783, 13.32972],
    [8.51024, 12.60826, 12.83410, 20.29405, 6.42094, 13.75942, 10.86261, 23.36177, 20.95447, 13.36451],
    [19.19294, 6.66082, 17.00293, 14.91729, 22.82098, 18.77178, 8.13364, 9.79873, 21.36219, 9.56557],
    [8.57067, 13.82229, 21.91885, 24.11313, 13.97061, 17.41127, 11.04389, 19.28877, 14.11039, 20.03464],
    [13.93338, 18.69488, 10.61235, 9.52651, 18.96893, 11.53218, 22.83990, 16.91321, 15.73763, 11.03961],
    [15.07172, 7.37190, 24.65636, 18.12723, 8.10068, 17.94839, 6.31596, 5.83377, 8.36680, 22.65618],
    [8.68419, 10.22843, 17.75063, 15.58626, 20.28123, 23.38130, 17.16468, 12.64611, 7.45369, 14.02738],
    [7.04962, 22.55974, 23.88791, 11.55660, 17.91849, 7.74728, 10.45366, 18.94574, 14.05484, 5.71535],
    [13.54946, 10.25895, 23.51009, 11.57918, 20.02731, 18.34696, 17.50771, 12.34153, 16.85583, 8.36375],
    [12.39036, 13.55617, 13.63552, 22.73309, 17.22816, 8.99670, 16.08432, 13.17774, 20.21958, 13.96268],
    [8.62743, 5.45167, 17.00171, 12.83715, 14.21842, 12.38914, 14.00723, 21.53371, 9.50148, 20.89831],
    [9.97391, 15.44527, 23.46370, 8.52428, 8.75500, 23.53145, 17.67373, 15.21577, 6.53630, 19.15815],
    [16.26133, 5.89846, 6.59490, 8.32469, 23.74020, 9.50514, 24.72228, 5.89541, 18.80596, 10.06973],
    [18.43242, 20.46678, 22.24540, 15.52095, 23.09259, 18.48857, 7.06000, 19.79171, 8.08298, 8.27158],
    [8.94910, 23.87814, 16.12949, 14.50468, 5.26856, 11.46626, 18.91766, 23.89584, 20.58885, 24.75524],
    [12.12607, 12.58080, 6.97821, 16.09897, 22.99921, 15.91159, 17.14576, 21.09668, 13.57814, 11.24836],
    [18.54900, 8.74950, 12.72729, 14.38993, 6.61260, 14.31669, 20.07248, 20.26048, 5.17090, 10.48601],
    [14.97528, 8.47606, 12.25791, 22.50053, 13.67824, 24.42320, 19.38154, 22.83929, 7.73141, 16.46702],
    [22.39128, 11.10920, 6.83966, 19.92050, 12.07907, 14.75127, 19.24360, 8.39183, 22.62932, 16.18442],
    [12.76513, 23.14570, 6.04068, 22.03543, 9.65163, 21.08936, 10.66118, 20.04746, 18.31706, 12.02597],
    [11.93564, 19.32356, 15.13764, 5.78310, 13.51527, 19.50423, 19.40291, 19.85336, 6.84088, 24.52269],
    [14.55901, 8.16416, 7.32368, 6.54973, 18.86639, 21.61122, 15.25971, 15.76571, 18.59416, 20.96728],
    [19.58846, 21.57094, 6.87872, 12.80358, 12.63390, 20.86779, 21.37867, 9.04553, 13.94559, 19.04584],
    [23.82870, 20.78173, 11.36189, 19.27534, 14.64934, 6.95624, 17.43324, 5.75320, 5.70986, 8.57372],
    [9.31227, 16.52135, 24.38475, 9.03150, 10.25468, 11.47176, 12.01926, 11.21235, 20.84094, 11.18000],
    [9.94278, 11.96066, 18.04849, 12.18101, 16.13865, 24.56297, 10.30595, 14.31608, 5.70498, 9.86587],
    [6.64617, 5.77029, 18.23222, 6.64922, 8.08420, 21.44154, 5.21424, 21.88345, 19.34736, 20.23850],
    [20.63280, 11.48824, 9.08521, 16.96631, 7.81808, 12.23777, 16.67760, 14.39543, 5.73611, 15.40925],
    [13.76919, 11.15375, 7.80648, 22.82342, 18.65825, 11.06830, 16.38890, 15.88900, 11.65914, 9.57106],
    [6.05472, 18.28104, 9.56984, 22.80511, 18.77850, 22.87713, 7.36091, 15.04486, 24.16257, 23.57601],
    [5.22095, 10.07218, 7.82785, 22.62444, 9.07544, 22.11173, 21.09607, 14.07620, 22.71050, 11.96615],
    [15.08148, 14.01028, 19.61592, 23.97458, 12.32688, 18.13089, 12.69250, 9.40870, 19.09955, 17.37342],
    [9.92141, 11.95151, 11.47542, 12.14805, 14.14701, 20.85559, 18.34452, 15.83590, 15.07660, 7.43416],
    [14.44731, 8.17270, 11.64083, 10.49516, 6.57720, 9.13526, 12.82311, 6.33732, 6.07730, 13.96634],
    [15.09491, 8.95520, 10.74358, 19.95102, 24.57762, 16.05197, 9.27076, 5.58229, 22.05069, 6.50456],
    [11.36494, 12.73156, 18.94574, 24.89929, 16.63976, 12.44774, 22.43278, 18.75652, 5.43031, 5.02319],
    [17.73965, 24.08444, 24.64782, 14.93622, 5.81851, 24.87060, 11.78915, 11.30024, 24.49278, 22.14896],
    [10.24857, 14.45219, 11.20136, 18.25785, 19.03546, 19.29060, 15.47456, 11.92282, 10.02884, 16.00436],
    [19.25703, 9.78225, 15.90548, 18.80413, 13.20826, 9.98123, 21.84561, 23.28730, 7.10761, 23.46553],
    [24.16318, 23.06146, 22.48344, 8.59203, 8.96802, 6.25370, 5.59084, 24.68810, 13.99442, 22.52251],
    [8.87402, 20.17502, 6.72002, 21.20289, 19.02203, 20.89404, 21.89627, 11.21357, 19.75448, 14.24894],
    [11.61885, 23.34712, 7.46040, 14.79339, 11.06525, 5.55666, 7.81198, 6.88971, 13.01538, 11.89657],
    [11.47786, 10.06546, 14.29228, 15.69735, 17.06702, 22.68242, 7.23701, 7.63863, 19.42061, 9.56130],
    [19.35163, 9.32936, 11.38264, 9.17066, 14.22636, 23.01202, 17.17505, 6.00955, 16.88818, 8.02988],
    [5.48769, 23.81588, 16.68126, 24.68383, 20.43687, 5.21424, 10.81439, 16.08127, 18.48552, 13.44325],
    [21.69851, 8.63414, 9.47401, 21.76443, 11.19526, 21.80288, 9.87381, 6.20304, 24.91028, 7.72835],
    [6.39286, 7.23090, 9.64125, 11.37532, 18.05887, 16.01718, 17.12806, 11.79769, 14.90326, 10.87542],
    [17.20130, 15.17365, 21.37135, 19.53413, 13.48354, 20.21653, 22.58477, 12.84814, 24.74792, 6.59246],
    [21.58071, 5.58351, 5.06531, 6.98004, 5.65188, 9.89517, 5.87161, 13.37489, 9.91348, 17.12867],
    [13.06421, 18.28532, 16.22166, 13.56044, 22.27287, 21.43788, 15.56734, 5.71780, 5.41078, 22.60552],
    [12.07541, 20.88672, 11.64815, 11.20502, 16.72521, 18.44096, 15.91708, 13.26930, 8.92773, 17.62062],
    [18.08451, 6.43193, 14.07437, 17.37770, 5.91556, 23.54183, 15.19196, 13.91690, 24.94873, 15.53560],
    [6.81890, 11.55660, 8.40526, 14.19767, 9.24207, 12.53868, 10.27665, 5.41993, 11.19770, 21.40370],
    [14.68474, 13.60317, 19.18439, 9.56313, 24.66796, 7.80770, 21.49770, 15.69674, 23.49788, 10.29374],
    [5.11658, 7.58309, 11.67013, 18.06558, 13.57021, 21.01856, 12.67235, 18.04971, 23.89950, 21.41163],
    [10.67583, 6.53264, 10.84979, 23.71212, 13.26197, 13.47743, 16.41758, 16.28086, 22.31132, 22.35160],
    [12.86523, 24.32920, 6.18534, 6.08524, 17.34840, 18.55205, 16.32237, 9.79202, 6.25736, 24.58800],
    [21.36830, 20.86413, 7.42500, 18.91400, 21.97378, 17.08289, 18.29569, 6.82318, 19.38276, 13.36085],
    [8.20505, 8.08664, 20.93127, 17.73782, 12.88965, 5.94180, 15.58809, 17.26295, 19.33454, 5.02503],
    [22.65801, 24.38475, 9.11084, 13.87356, 6.77252, 24.47142, 18.31034, 17.62246, 22.30216, 15.09247],
    [22.20389, 16.52501, 20.29466, 17.68044, 22.75323, 15.91342, 21.08997, 12.20054, 7.10211, 23.23420],
    [5.71841, 15.45686, 15.16572, 17.77627, 9.21339, 13.64772, 24.44700, 8.72082, 8.96252, 9.81643],
    [10.20402, 7.13630, 11.22394, 16.79724, 9.09803, 7.54219, 8.93262, 16.30345, 24.43907, 24.67101],
    [13.91934, 14.76775, 21.15589, 21.04541, 16.66845, 16.56774, 8.62377, 11.00909, 16.73925, 5.25941],
    [19.46821, 16.81860, 16.97974, 13.44325, 22.46086, 22.43828, 24.65087, 11.88498, 17.65542, 20.64745],
    [12.58995, 18.52580, 11.86361, 19.10382, 23.54244, 17.99417, 22.61895, 20.96606, 10.77532, 12.25242],
    [8.72692, 5.71657, 18.11319, 13.00317, 15.56001, 5.80874, 12.50633, 16.47740, 13.18812, 24.75219],
    [12.26524, 11.22578, 15.49593, 12.26890, 24.08811, 19.55245, 18.39640, 22.15506, 11.99179, 23.19697],
    [5.27345, 8.44493, 11.29902, 13.90408, 17.77627, 5.54140, 10.76922, 19.50240, 20.08652, 7.89804],
    [16.03610, 6.11087, 14.79278, 14.90631, 17.44728, 7.10883, 18.48857, 16.60314, 15.45015, 19.48347],
    [15.22004, 5.81912, 6.63884, 18.19010, 15.91342, 12.40318, 23.59066, 9.14014, 21.90359, 5.13428],
    [11.61458, 11.45405, 20.68651, 16.96265, 15.54415, 9.58815, 12.02658, 19.18928, 19.68795, 5.97537],
    [12.54112, 20.21958, 14.07437, 14.79888, 16.87963, 14.50957, 10.10880, 7.51839, 23.63765, 17.33802],
    [18.76629, 10.78631, 24.11863, 11.01276, 14.45463, 7.36702, 22.07266, 18.16324, 17.66152, 20.68896],
    [22.53716, 7.71004, 19.51949, 13.65566, 17.90139, 9.17371, 21.40431, 22.34184, 9.32875, 20.91113],
    [12.70470, 15.19257, 11.64876, 7.93405, 19.87716, 18.35917, 19.85519, 14.92279, 9.91226, 17.79153],
    [5.32716, 10.04959, 21.34632, 18.71197, 19.90768, 5.25941, 5.93081, 13.09900, 15.95126, 8.61583],
    [14.09818, 15.80416, 20.47777, 14.34050, 7.33100, 19.92233, 11.55293, 6.17679, 10.58306, 12.05161],
    [15.01862, 19.69527, 7.85287, 18.05643, 9.69924, 19.17341, 14.05362, 19.96200, 19.21308, 14.66582],
    [6.29582, 14.61333, 18.50505, 14.89959, 7.70638, 14.70977, 13.23817, 21.61122, 6.91412, 22.85150],
    [20.15183, 20.95508, 6.32328, 19.21735, 6.53142, 17.60842, 22.30277, 13.50124, 16.89978, 7.19550],
    [10.41032, 21.73147, 5.05737, 12.65709, 18.78887, 18.59478, 19.60738, 20.19089, 22.83990, 5.89969],
    [21.07105, 20.38499, 24.32432, 7.79244, 18.74248, 10.17411, 7.98959, 13.35536, 5.38270, 21.24378],
    [18.87371, 17.21473, 17.90201, 10.49577, 13.38527, 18.78582, 22.13004, 18.22062, 7.30842, 10.76495],
    [9.82559, 9.57839, 13.84060, 17.51747, 6.03336, 5.03601, 14.79461, 13.96146, 14.91241, 15.36714],
    [18.09549, 5.59328, 22.17277, 6.84881, 24.68383, 20.26536, 22.23502, 12.28416, 17.96121, 12.34825],
    [8.24290, 13.45973, 18.90362, 9.90493, 13.05445, 10.68316, 19.95651, 5.48952, 19.32722, 5.01099],
    [20.85070, 21.21082, 6.83966, 8.79955, 19.45173, 8.67321, 15.15839, 10.19608, 20.77868, 14.43510],
    [9.78103, 7.20649, 17.30689, 11.58528, 9.88540, 16.95532, 23.68954, 8.08908, 5.80325, 15.76571],
    [19.01349, 12.51427, 24.34202, 15.68514, 19.72396, 7.76254, 10.08621, 13.08252, 16.33518, 13.43654],
    [20.80493, 14.93805, 17.05420, 7.45918, 5.07508, 18.45744, 11.44856, 7.58736, 20.26841, 9.62539],
    [17.27149, 23.41914, 19.00189, 16.33946, 23.58333, 19.54451, 22.20450, 21.72414, 13.27845, 20.44969],
    [6.89520, 13.28028, 18.16202, 17.80374, 6.82806, 13.47316, 9.67910, 10.75457, 14.10001, 7.38716],
    [18.44340, 19.85702, 19.86801, 13.08435, 5.67019, 5.25880, 22.29179, 10.27482, 19.65987, 9.77065],
    [19.82589, 12.94031, 20.43199, 17.44118, 17.99112, 21.52028, 5.65981, 8.26548, 7.74483, 20.29954],
    [21.01611, 19.65682, 23.58150, 15.61373, 8.04941, 15.29145, 19.47798, 20.49913, 12.73949, 11.97043],
    [10.82354, 21.41469, 7.82907, 5.10804, 20.44786, 12.65709, 12.07541, 23.48201, 16.87170, 14.10184],
    [19.54024, 13.86258, 22.91742, 17.87820, 22.04154, 6.15421, 22.78802, 19.62935, 17.89834, 19.66720],
    [5.75198, 19.95346, 10.08866, 21.14490, 14.55779, 11.67684, 6.94159, 15.17792, 16.68981, 18.56548],
    [8.49925, 17.62673, 6.60955, 21.10645, 11.66646, 12.67113, 17.09998, 14.99115, 17.27088, 24.12473],
    [7.82479, 17.91116, 12.16758, 21.62526, 9.25489, 10.30412, 9.50636, 12.33848, 10.05692, 5.67080],
    [20.28367, 18.79376, 6.09378, 16.08066, 19.31196, 13.47255, 19.14655, 8.50658, 18.73150, 10.78753],
    [23.48811, 17.59865, 12.17917, 7.06366, 8.43516, 10.53056, 22.75201, 9.15235, 15.00458, 9.54237],
    [17.88125, 22.30949, 14.78484, 7.80099, 24.24802, 17.94534, 9.17554, 24.20835, 5.86062, 11.89535],
    [17.08960, 12.77551, 18.42509, 13.81314, 9.26283, 12.20237, 23.12311, 18.32560, 17.29286, 11.26362],
    [12.93420, 18.57158, 15.52156, 15.65035, 14.62249, 12.74743, 23.90378, 11.87948, 19.50911, 24.28404],
    [9.96719, 13.89554, 6.15787, 6.28239, 18.01065, 7.99570, 8.10862, 10.83636, 23.64193, 21.70278],
    [9.76089, 13.85403, 21.80044, 12.19810, 23.55953, 16.02023, 6.37761, 19.96384, 11.58528, 10.51286],
    [9.56862, 23.23420, 24.69176, 18.10526, 19.06659, 18.89813, 22.29972, 20.26902, 21.24134, 5.46999],
    [5.98453, 10.92120, 8.41929, 13.75759, 9.97818, 17.41798, 18.38603, 20.84460, 21.70522, 11.43635],
    [24.24009, 13.02820, 15.48921, 20.36790, 22.72881, 13.31812, 12.54601, 19.83322, 19.18195, 19.13495],
    [10.38774, 17.96976, 17.17017, 5.82888, 14.77081, 12.08701, 11.02069, 21.64296, 17.30567, 8.34422],
    [9.30128, 9.74563, 11.85324, 5.04639, 7.41646, 22.96197, 12.84143, 10.21073, 17.41920, 6.82012],
    [8.61522, 14.00784, 13.18140, 16.54881, 12.95251, 6.71392, 19.04035, 23.64071, 7.86996, 22.79717],
    [20.04257, 17.61208, 20.84399, 21.75466, 21.91885, 18.58440, 9.56313, 6.34404, 18.90912, 6.31108],
    [17.35939, 8.81359, 17.56203, 21.27308, 12.41173, 5.76540, 14.63897, 23.46675, 13.87478, 12.28416],
    [17.24464, 24.52147, 18.04422, 15.93844, 23.30439, 18.75408, 7.68319, 21.29810, 10.52446, 8.79528],
    [17.64321, 5.57924, 11.95273, 11.41438, 19.89181, 16.05319, 6.26041, 19.16242, 21.08570, 9.82620],
    [20.88122, 23.45637, 15.80660, 6.64251, 16.12461, 14.74395, 8.58226, 15.31037, 8.39244, 5.35401],
    [7.82785, 24.38536, 20.62059, 10.67156, 24.82055, 17.74026, 18.06925, 14.25687, 20.83911, 5.64577],
    [17.59743, 12.53746, 15.59969, 11.97531, 8.53160, 24.68993, 20.09507, 8.17392, 13.26685, 23.34773],
    [6.97882, 14.60784, 5.71047, 11.75314, 21.61672, 19.92355, 15.71749, 22.97662, 6.91412, 19.03729],
    [17.60842, 6.83294, 5.07813, 20.38499, 10.93097, 20.12009, 9.39772, 23.05170, 11.56392, 5.79836],
    [9.20118, 14.41252, 21.29810, 16.74657, 21.10034, 8.90332, 14.02249, 9.70595, 9.64187, 18.55266],
    [6.63335, 5.05188, 10.51042, 15.88961, 12.79870, 18.00455, 19.38337, 19.87045, 7.69234, 16.91321],
    [19.57991, 5.42726, 21.84133, 14.23673, 11.62557, 7.28095, 12.18467, 5.83926, 17.85623, 18.63506],
    [8.49986, 24.24192, 5.17762, 15.37568, 23.29218, 21.42750, 19.12946, 6.40751, 23.29279, 6.86041],
    [12.34642, 20.74755, 10.68255, 16.31199, 20.57237, 11.99667, 12.16758, 17.13721, 9.32752, 10.82537],
    [24.02829, 5.62136, 24.37681, 6.08768, 11.27155, 22.02200, 9.09680, 5.19654, 9.01563, 18.92987],
    [21.89932, 14.37834, 24.21506, 8.57616, 16.80151, 9.43800, 5.86917, 24.71068, 20.29893, 17.65725],
    [21.83584, 24.67345, 7.64718, 21.44459, 10.36027, 7.28767, 11.67928, 24.37986, 24.46837, 12.20237],
    [7.29377, 10.25346, 17.32582, 16.29307, 24.72777, 15.74923, 6.70598, 12.77306, 14.74273, 7.37739],
    [6.68218, 8.61339, 18.85601, 23.29463, 24.66979, 5.91617, 7.72774, 10.62944, 11.94479, 22.85028],
    [20.84338, 18.94513, 5.76907, 19.78927, 10.60686, 20.45213, 11.23737, 6.26652, 23.97458, 17.61269],
    [20.97461, 14.37712, 24.75219, 8.74584, 20.81408, 14.24589, 9.68032, 12.26890, 19.57564, 17.19703],
    [21.43910, 20.19639, 11.06952, 22.24052, 11.68111, 21.52028, 6.45146, 11.50105, 17.24036, 6.10172],
    [5.05860, 10.22660, 22.62383, 9.69069, 21.83767, 16.97974, 11.91427, 10.70574, 19.51094, 19.65926],
    [23.22443, 19.39741, 23.58577, 22.96319, 8.79589, 10.01785, 8.34422, 22.92230, 13.90835, 16.62755],
    [11.93442, 14.12748, 17.68654, 23.14936, 8.68419, 5.28199, 8.95276, 8.31919, 16.77343, 8.69518],
    [20.24644, 16.13437, 9.37574, 19.34492, 13.12403, 12.43858, 7.40791, 9.13953, 17.88369, 18.26456],
    [22.00125, 12.00095, 20.81957, 20.55773, 24.82665, 5.38697, 22.14652, 10.91144, 14.39543, 23.88913],
    [17.70913, 12.93176, 16.46458, 10.52202, 7.61116, 8.85937, 6.66143, 21.33961, 24.87609, 6.07852],
    [13.47072, 8.98755, 7.27668, 14.12992, 9.68642, 20.83422, 5.45534, 12.85730, 10.47380, 17.28980],
    [10.45183, 22.31315, 6.15482, 5.95401, 13.77712, 15.04425, 7.84616, 17.20130, 23.14753, 21.39149],
    [14.06949, 16.83935, 7.00568, 8.41258, 16.47069, 21.46474, 10.96454, 23.07367, 12.76025, 12.13523],
    [19.27961, 20.31175, 5.00610, 11.99240, 24.49095, 6.61687, 11.40522, 23.44966, 18.35368, 19.74105],
    [9.65346, 10.57573, 7.18390, 15.16022, 20.04440, 22.30461, 24.73998, 19.93271, 6.41911, 22.08243],
    [5.76846, 24.54894, 23.09381, 19.59029, 13.34559, 13.42799, 5.88382, 10.16129, 23.12250, 24.66369],
    [15.36348, 17.51747, 17.61757, 19.65499, 10.46648, 5.44923, 13.66909, 13.24854, 20.57299, 14.07132],
    [16.17893, 5.00732, 14.18973, 6.26774, 21.26820, 22.24235, 12.36412, 19.96261, 21.97317, 15.42207],
    [24.94507, 11.83126, 19.60555, 16.59948, 17.82083, 8.08420, 13.90164, 21.45802, 9.26038, 7.94748],
    [15.08515, 5.62624, 23.48079, 15.46052, 10.96820, 15.87252, 19.56404, 5.22217, 12.21885, 6.80364],
    [23.85434, 17.70425, 8.91552, 23.70235, 23.95138, 9.76150, 21.51662, 22.11722, 12.43675, 15.96530],
    [19.36811, 24.83947, 18.44829, 6.37516, 9.87686, 6.88421, 15.22797, 16.38829, 11.47237, 9.10901],
    [21.78030, 14.27946, 13.47987, 11.08417, 6.74505, 22.06351, 16.03732, 23.85128, 12.63512, 15.30061],
    [13.17347, 13.18506, 8.53832, 17.47780, 12.17551, 13.99319, 9.43007, 14.57793, 12.36900, 6.46977],
    [10.20768, 5.47304, 16.44261, 14.63286, 12.57714, 13.76614, 17.42897, 17.86905, 12.91833, 16.69530],
    [14.47966, 16.11362, 9.24818, 16.74108, 20.55651, 19.28510, 15.41597, 11.54805, 15.15290, 21.60451],
    [20.64196, 7.79794, 5.18921, 11.42109, 22.54143, 14.64751, 7.19245, 17.17505, 11.74581, 22.36137],
    [13.88882, 20.11093, 16.24912, 21.77297, 18.33781, 14.37895, 23.60775, 10.18082, 18.72967, 5.14466],
    [9.11878, 19.32295, 16.97241, 5.32716, 8.09641, 11.03961, 14.19095, 21.59963, 20.37645, 16.26499],
    [16.26926, 10.26872, 5.17029, 22.95526, 12.54906, 13.66543, 14.40275, 8.59264, 20.82873, 17.66640],
    [22.64092, 22.88385, 21.76443, 20.97400, 21.75649, 16.27537, 15.82003, 16.77770, 18.43852, 19.92111],
    [5.87405, 17.42714, 22.68303, 12.71203, 18.62224, 22.73247, 5.38026, 21.00879, 7.88522, 22.52556],
    [13.13562, 6.68645, 12.96472, 14.10733, 18.43425, 9.13465, 15.15961, 5.19532, 13.28822, 16.81860],
    [5.56703, 23.01080, 24.48363, 14.03897, 7.30842, 20.11826, 18.55144, 18.51665, 5.28077, 17.65419],
    [14.59441, 15.41292, 6.58330, 16.55675, 13.08741, 23.43196, 24.72839, 17.43385, 18.78033, 18.60637],
    [10.76434, 19.68490, 5.82766, 11.41255, 24.44517, 20.50890, 23.26960, 22.82769, 8.55296, 24.41649],
    [8.98694, 14.95514, 19.52071, 23.87814, 10.26688, 21.84927, 17.46071, 21.72964, 19.08002, 16.15757],
    [8.73730, 15.95798, 20.22446, 17.20923, 24.20103, 17.49977, 20.43504, 16.17344, 6.21220, 21.66433],
    [16.60192, 23.91537, 7.58003, 23.82504, 11.21113, 17.16590, 15.53804, 19.98459, 13.13746, 8.64635],
    [23.88730, 22.85455, 11.91488, 16.75634, 6.42277, 14.06095, 23.60958, 20.45885, 14.78362, 23.11640],
    [16.41392, 14.98444, 13.83084, 13.76553, 14.10245, 13.98587, 17.69692, 8.34605, 5.45289, 13.75515],
    [19.62325, 10.77960, 17.77627, 5.14283, 18.70830, 18.81756, 22.67022, 8.79467, 16.69897, 6.17313],
    [12.12607, 19.33149, 7.94321, 5.16358, 13.11182, 14.10367, 15.63509, 10.47929, 18.75408, 12.13889],
    [17.46620, 14.71343, 24.24986, 18.90912, 13.82778, 16.27598, 5.62868, 22.54509, 21.66616, 10.31327],
    [9.49416, 17.11890, 7.13263, 23.26228, 11.85812, 18.62407, 20.14878, 21.65944, 14.21232, 9.27320],
    [24.00571, 15.83712, 14.94659, 15.74618, 23.12983, 9.12305, 24.24253, 17.00049, 22.14225, 13.17652],
    [20.56871, 7.28401, 19.32234, 20.08103, 16.90771, 9.96658, 7.61971, 11.81478, 14.82818, 7.81320],
    [6.32756, 17.74087, 14.53642, 5.33143, 16.53966, 20.71764, 19.02875, 8.81481, 23.52901, 22.47307],
    [20.47288, 19.70077, 19.16242, 8.86303, 6.93609, 6.88055, 7.47810, 5.63478, 17.59621, 13.57753],
    [6.55400, 5.32228, 24.54711, 24.41649, 9.78896, 15.90243, 9.33485, 8.31919, 19.72396, 11.83248],
    [12.34886, 22.84295, 17.52663, 18.09488, 23.18171, 15.58626, 21.26637, 7.87667, 10.09354, 8.29905],
    [16.09897, 24.50560, 16.70995, 19.29975, 9.49843, 8.26548, 24.05759, 9.84878, 14.64568, 18.72906],
    [6.08890, 10.08927, 15.10712, 13.21009, 16.80639, 10.18021, 13.93094, 11.98874, 17.10242, 12.25181],
    [20.28184, 10.90350, 19.46638, 8.80932, 16.73315, 11.96615, 18.65764, 23.20063, 20.36058, 12.59789],
    [6.48381, 17.78481, 20.73534, 24.12900, 18.80718, 5.41871, 7.96884, 20.18174, 12.89575, 9.88968],
    [13.91446, 5.55666, 23.26167, 10.91632, 19.66109, 6.25919, 14.09085, 19.34614, 12.43675, 11.27338],
    [16.40660, 18.17667, 5.05860, 6.72918, 8.07871, 15.01556, 21.04175, 13.07093, 24.81689, 21.61611],
    [18.49528, 5.86062, 20.25498, 6.10477, 15.93844, 10.84002, 23.27326, 13.53298, 13.15149, 13.87295],
    [10.66362, 20.36851, 10.19242, 16.39805, 23.27754, 18.56243, 17.70119, 17.01331, 23.76827, 14.80987],
    [21.61916, 9.81643, 24.06858, 20.62975, 15.44771, 20.13413, 20.71215, 18.88836, 23.17194, 8.24900],
    [6.13651, 22.40104, 5.96805, 21.77297, 14.08719, 10.21744, 15.83468, 7.26081, 7.24189, 17.23975],
    [9.25062, 21.72842, 5.19837, 22.77337, 24.01120, 14.65545, 20.92761, 13.65871, 12.33787, 21.14063],
    [23.83175, 7.59224, 13.41700, 16.80273, 17.53456, 12.27073, 18.46538, 15.06806, 10.51469, 5.97842],
    [11.46809, 17.46803, 7.72042, 15.24689, 18.70281, 17.56447, 21.28651, 15.20600, 10.17472, 9.13892],
    [8.47301, 8.26243, 6.09622, 19.26008, 14.96246, 6.71819, 11.52791, 16.85766, 11.62618, 14.95880],
    [12.30674, 17.43629, 22.89972, 16.83813, 15.39338, 14.54070, 14.87640, 23.88791, 6.75176, 18.60698],
    [21.26148, 9.96414, 9.90066, 13.81680, 15.29511, 7.97128, 18.24686, 13.59340, 5.78310, 14.27763],
    [24.33531, 5.34669, 5.34913, 16.45116, 19.14228, 5.10559, 9.04126, 9.94400, 24.52574, 12.65709],
    [11.41438, 19.34370, 11.96860, 7.81808, 20.21470, 9.81826, 10.73748, 18.46660, 14.78973, 24.39146],
    [18.57585, 20.95019, 7.35054, 12.64550, 18.06497, 23.51253, 15.21332, 6.51677, 11.77206, 13.34010],
    [22.13431, 8.76537, 19.31623, 17.88003, 16.88025, 9.77798, 9.46608, 21.02832, 7.14789, 18.31400],
    [10.40971, 24.83398, 16.95715, 21.81753, 11.30757, 17.33192, 5.64516, 21.92923, 18.26273, 17.13843],
    [16.59581, 20.81652, 17.82754, 15.42390, 13.80825, 23.95138, 11.17878, 5.89419, 14.45219, 14.95148],
    [12.07724, 23.41182, 15.51851, 8.12754, 11.74398, 21.86209, 22.69951, 14.34233, 23.77438, 11.91549],
    [19.61959, 5.81668, 12.21458, 9.28907, 5.54323, 15.50996, 15.93539, 14.14457, 19.68490, 16.68920],
    [12.40623, 12.24143, 20.24155, 18.32560, 14.02371, 18.47758, 16.28330, 21.93106, 20.08835, 13.43043],
    [20.61510, 15.46663, 17.58583, 13.53908, 21.74245, 9.94766, 13.87051, 5.53896, 23.06513, 14.36796],
    [14.39421, 5.77944, 7.41646, 14.56816, 8.59630, 15.05280, 15.08942, 11.67684, 17.08594, 9.55092],
    [13.45119, 5.74526, 23.23359, 18.58562, 6.29765, 20.20432, 22.30583, 9.68642, 21.04968, 12.76269],
    [11.26301, 11.70980, 21.92862, 8.37962, 12.34458, 16.57933, 7.23640, 19.93332, 13.57021, 10.28336],
    [18.86090, 12.20298, 19.28022, 13.75881, 22.12699, 14.80621, 13.83755, 24.27732, 24.13450, 19.69771],
    [11.62069, 17.96976, 8.68786, 8.86792, 16.43162, 24.10520, 15.96164, 7.86386, 23.44111, 11.75130],
    [5.00671, 10.74786, 6.79693, 19.44929, 7.24555, 12.13401, 6.02603, 8.51329, 9.05713, 11.91671],
    [14.34538, 10.59221, 11.59627, 8.32102, 22.01224, 10.11551, 5.96194, 24.89563, 17.84524, 12.24143],
    [11.84286, 7.07648, 22.02445, 16.94555, 17.76284, 13.95291, 13.31446, 9.85855, 11.05243, 20.84094],
    [23.82076, 10.49699, 15.67965, 18.31339, 24.41099, 8.48888, 6.04434, 23.29646, 13.92972, 8.44737],
    [14.88433, 7.85714, 15.32075, 14.08780, 23.40571, 21.32130, 11.79342, 12.23716, 11.75985, 11.32466],
    [6.15116, 7.34809, 18.00699, 19.44502, 16.40782, 7.14606, 23.66878, 17.02002, 10.82049, 10.03250],
    [14.01883, 16.79540, 15.46113, 14.87335, 11.21723, 6.01077, 17.44911, 23.79574, 8.42662, 16.55858],
    [16.97729, 18.61370, 23.02423, 17.83731, 11.24836, 21.51723, 17.04627, 7.92673, 23.45393, 20.63768],
    [22.98151, 8.70922, 19.91379, 11.12690, 23.04010, 20.55589, 8.50597, 12.36656, 20.02426, 22.21488],
    [21.51357, 11.93503, 7.93039, 11.51387, 16.00436, 16.95593, 20.39476, 12.51732, 14.88128, 23.45943],
    [5.11963, 24.73876, 21.71621, 24.36827, 22.40715, 20.06455, 12.50328, 6.75115, 15.90304, 22.98700],
    [17.44667, 18.95306, 13.71364, 19.78805, 15.91403, 18.22977, 7.98166, 12.29087, 17.67983, 19.52559],
    [11.07257, 21.80776, 13.58180, 16.00131, 16.48412, 18.90851, 8.71654, 11.94540, 22.61040, 24.63439],
    [21.30177, 18.69549, 7.47749, 18.77911, 20.32029, 14.19218, 12.58812, 20.87268, 5.08728, 16.78930],
    [23.98434, 19.47493, 19.85214, 13.94681, 8.66832, 15.42512, 6.55950, 16.43529, 14.49858, 14.65361],
    [8.91369, 18.66680, 11.68172, 16.19480, 10.83819, 15.79073, 24.00204, 11.01398, 22.49016, 18.16630],
    [7.88888, 17.28797, 16.93091, 13.84610, 7.47566, 7.74667, 10.58672, 19.69283, 23.74874, 14.71892],
    [10.62639, 11.75130, 5.92349, 8.48888, 22.37297, 15.50691, 23.18354, 14.60906, 19.88388, 6.64617],
    [24.88037, 5.77456, 12.81884, 22.95953, 7.34504, 13.89615, 12.72179, 17.98746, 15.42817, 17.99295],
    [11.84103, 17.06824, 16.88025, 13.53114, 17.61330, 6.37577, 17.71889, 18.83526, 15.93905, 15.60030],
    [16.69408, 24.18699, 6.37089, 24.88586, 6.98065, 19.25336, 22.33879, 16.64525, 23.22016, 24.45555],
    [19.54207, 22.89300, 22.04093, 21.90909, 5.62990, 8.69640, 14.18058, 11.55721, 14.29594, 22.40226],
    [16.33580, 8.12937, 16.91076, 13.22779, 20.85864, 24.54100, 14.81841, 6.87567, 11.43269, 17.36061],
    [5.42421, 19.77279, 22.85577, 19.98398, 5.19715, 22.56401, 13.03858, 19.11603, 22.70379, 13.50063],
    [5.36439, 20.20310, 24.81750, 12.32627, 9.52040, 17.43629, 9.20789, 15.29817, 18.93170, 13.94925],
    [6.24943, 21.96829, 12.92077, 7.83700, 23.46614, 14.34416, 21.72292, 9.61684, 15.64119, 19.06293],
    [22.47063, 6.76519, 13.71609, 13.18995, 24.28831, 20.94409, 15.60640, 24.28282, 10.60564, 13.55129],
    [12.04733, 5.33448, 16.83020, 5.21485, 10.61724, 15.22614, 11.48579, 24.86084, 11.03778, 5.30763],
    [18.96649, 13.96695, 14.89532, 22.74590, 12.00461, 21.65029, 22.89911, 11.24348, 11.99789, 16.18809],
    [22.80145, 19.77706, 5.30946, 8.61705, 21.11255, 19.95956, 13.67275, 14.02432, 21.72414, 22.66533],
    [6.81646, 6.15726, 24.57335, 14.53581, 15.45259, 10.98224, 7.47322, 24.99573, 12.72485, 14.81292],
    [24.23032, 24.39512, 22.27775, 12.63085, 22.17277, 23.91964, 21.03320, 12.23045, 12.22495, 17.87515],
    [14.83306, 19.80514, 14.64324, 18.98358, 15.05341, 22.60918, 13.53481, 7.31147, 14.31486, 14.30876],
    [23.30134, 23.45759, 9.43007, 18.65825, 20.11093, 6.61626, 9.69375, 17.11890, 21.54408, 8.16233],
    [18.65459, 16.04831, 7.52022, 21.35304, 7.48360, 19.08734, 5.64394, 17.79885, 8.07688, 20.36424],
    [14.08719, 11.31367, 24.00327, 24.14548, 5.13672, 19.77401, 7.42805, 6.55705, 22.53227, 5.60427],
    [20.14573, 5.00427, 15.71383, 5.53163, 6.82928, 10.90228, 24.11374, 10.21439, 18.64238, 11.36250],
    [14.61028, 24.38047, 15.31343, 15.44588, 5.26795, 8.10007, 23.82809, 10.60564, 18.49834, 9.81765],
    [21.83401, 24.96216, 16.75085, 11.76107, 23.90744, 21.00940, 23.87753, 18.36406, 18.78765, 16.40477],
    [5.27711, 8.31797, 15.72054, 17.44484, 9.96292, 20.88610, 8.02377, 20.86352, 7.66121, 17.09265],
    [12.00827, 9.57900, 24.07956, 6.42705, 9.36659, 18.01065, 7.45918, 19.68184, 11.17756, 12.58202],
    [9.54909, 18.53679, 11.62435, 23.06024, 14.10855, 22.54143, 9.56923, 10.32487, 16.08371, 24.09482],
    [6.10782, 6.21891, 24.56786, 12.05954, 16.21982, 11.08722, 12.67479, 14.64141, 22.64763, 24.63988],
    [7.45796, 22.13797, 10.12894, 15.75777, 22.98456, 20.20798, 8.10495, 6.87201, 9.70473, 14.26603],
    [20.02792, 18.53740, 23.23542, 15.63997, 7.39448, 9.82009, 5.67629, 10.10514, 6.63945, 20.14451],
    [22.60186, 19.43098, 6.99286, 8.19224, 8.82641, 16.56041, 7.44881, 13.51588, 6.10050, 5.04456],
    [20.95813, 16.45543, 5.83254, 23.36360, 23.96725, 22.01163, 19.98215, 24.74914, 19.44380, 23.28669],
    [13.23878, 13.14722, 11.49495, 10.11612, 19.61959, 5.93692, 19.71664, 18.52886, 16.59642, 24.02768],
    [11.39180, 6.64251, 19.89975, 19.96506, 19.66964, 12.64183, 12.10105, 24.67711, 5.83926, 20.43809],
    [8.11533, 23.46980, 13.83938, 8.65795, 10.73870, 21.90725, 15.10895, 8.58043, 19.35469, 12.20359],
    [11.92160, 6.63213, 24.92309, 20.74450, 17.32276, 17.08960, 14.39055, 7.36274, 19.78561, 20.59557],
    [17.63466, 17.00842, 10.72588, 14.12320, 20.07309, 14.41130, 22.99066, 8.01035, 14.06522, 22.39067],
    [18.44707, 15.68636, 12.22068, 14.41130, 12.80114, 11.72323, 15.75655, 22.03177, 15.76632, 23.82931],
    [21.00940, 7.85165, 14.70489, 14.41496, 17.24158, 24.60082, 19.87960, 17.35267, 18.86212, 10.97674],
    [19.42366, 5.55727, 5.18250, 24.87304, 22.16605, 15.01251, 10.84185, 24.61180, 16.43345, 20.86535],
    [20.01633, 18.80718, 22.95160, 11.21967, 7.54280, 15.49287, 9.97696, 14.24772, 20.08957, 11.12384],
    [8.77575, 24.24680, 20.47838, 10.09537, 17.58278, 22.26432, 8.30454, 15.38606, 12.15842, 16.92663],
    [19.97238, 20.96301, 11.07624, 21.07593, 21.25782, 6.57170, 13.86135, 9.86099, 15.55086, 5.53102],
    [20.10056, 15.89816, 20.87634, 6.15848, 7.65877, 7.12043, 18.83221, 17.46071, 18.12540, 22.95648],
    [8.56639, 19.69832, 7.60079, 14.44609, 8.91858, 10.46403, 10.97064, 23.93551, 21.84927, 6.89337],
    [17.77749, 9.95621, 20.28489, 14.63103, 7.81564, 12.93664, 13.50063, 24.18027, 24.58739, 7.34687],
    [13.16858, 5.26063, 14.71892, 15.92746, 13.19422, 19.80209, 11.50044, 11.59688, 6.46489, 24.18821],
    [10.63005, 22.69707, 11.64205, 21.39088, 16.32664, 7.16865, 13.11304, 13.60988, 5.90823, 11.30818],
    [7.23395, 16.04282, 10.97919, 18.71319, 17.98807, 22.41630, 23.33857, 5.05005, 15.17853, 22.89789],
    [23.74203, 24.27244, 18.29142, 5.01709, 21.64235, 21.89505, 19.14289, 18.21818, 24.03134, 20.98254],
    [6.44230, 12.67052, 21.50014, 16.44383, 5.39552, 12.96472, 9.66628, 23.27754, 15.46846, 17.31117],
    [14.06156, 14.38688, 19.44563, 22.87713, 16.63366, 13.59096, 6.89520, 7.87729, 11.96432, 19.45479],
    [5.18250, 11.04999, 11.34968, 5.56154, 21.13819, 19.14045, 22.84783, 12.86767, 6.51921, 23.01386],
    [5.43092, 19.73434, 10.39018, 13.03186, 5.36866, 5.29420, 11.53035, 14.30815, 12.95618, 11.76168],
    [14.01761, 12.47215, 7.71981, 21.30238, 19.09345, 10.56597, 10.23209, 13.11182, 16.44566, 7.69906],
    [8.64086, 16.30894, 8.02988, 20.08774, 18.06192, 24.26939, 7.55257, 15.09613, 20.93799, 6.03824],
    [8.74706, 18.91949, 6.50700, 20.43565, 5.55849, 8.51756, 17.49611, 8.47362, 17.37587, 8.43333],
    [22.15812, 9.73586, 22.41691, 23.12128, 19.79843, 18.30851, 12.41295, 5.40284, 17.89346, 23.92148],
    [11.70248, 11.69210, 8.93872, 13.90042, 13.86196, 24.58556, 5.15015, 21.57033, 19.00678, 13.47560],
    [19.13923, 16.72521, 24.87426, 13.79299, 8.68969, 23.79452, 14.82513, 15.50020, 13.76431, 23.33064],
    [15.88595, 21.47816, 23.85922, 22.43950, 9.94827, 6.40996, 23.83724, 9.78591, 11.26484, 16.80822],
    [16.36082, 20.78906, 13.35353, 22.78985, 9.05469, 8.63964, 18.44584, 22.24296, 24.51720, 6.76702],
    [12.59362, 7.99387, 21.30604, 18.36955, 19.57259, 18.61492, 24.03439, 18.64422, 16.68981, 23.47774],
    [10.68255, 5.33631, 5.64028, 22.70501, 15.27131, 23.23664, 21.52089, 12.61864, 14.00052, 18.23893],
    [13.13440, 17.32398, 13.00195, 6.61016, 17.71340, 17.05176, 5.80935, 15.06317, 23.17194, 13.88577],
    [18.68450, 17.28675, 21.03381, 5.49318, 11.91427, 22.53960, 23.14081, 7.49153, 15.22126, 21.94266],
    [5.27833, 15.07050, 5.38575, 8.09214, 10.84246, 24.50255, 24.23154, 13.61599, 17.66457, 5.14954],
    [5.07935, 24.29807, 21.13208, 22.61956, 5.81057, 12.40623, 16.71911, 23.66329, 16.65014, 5.83193],
    [15.05768, 23.46492, 20.80248, 18.68023, 12.67113, 5.93814, 16.06784, 18.92621, 11.50166, 17.65481],
    [15.55635, 18.77300, 10.34257, 6.02725, 15.63143, 23.32148, 21.32252, 22.38151, 9.20118, 23.19269],
    [14.53825, 20.53148, 12.48863, 6.71758, 23.99350, 11.48946, 23.40571, 17.32276, 17.93558, 24.93347],
    [19.64766, 11.73238, 6.74383, 18.05460, 14.64568, 24.62462, 11.47603, 22.42058, 19.49324, 15.34883],
    [6.20243, 9.46120, 8.97046, 22.34306, 17.25867, 5.21912, 19.80453, 20.87085, 12.53258, 14.98138],
    [19.26801, 9.70534, 23.92392, 8.41746, 12.26829, 22.37846, 16.07761, 5.85208, 5.02808, 8.62865],
    [24.55077, 16.29612, 13.49757, 21.67531, 16.49876, 7.85531, 14.61394, 16.92175, 17.04382, 21.15528],
    [8.54259, 17.74819, 14.41679, 6.39164, 10.01968, 13.98526, 7.02582, 14.64385, 16.91198, 8.71532],
    [5.55361, 24.06491, 14.14335, 19.01898, 13.22718, 11.58589, 21.08386, 6.28361, 17.37159, 10.75274],
    [20.54857, 21.72231, 15.37690, 6.31169, 17.52174, 22.69707, 8.21238, 6.19205, 5.73061, 5.49806],
    [24.59288, 21.48366, 10.19547, 10.19242, 8.94238, 15.05341, 23.88424, 23.15851, 16.27171, 9.42213],
    [6.58940, 12.95434, 7.08930, 14.51811, 24.16440, 5.12146, 5.48219, 5.94058, 16.22410, 11.56453],
    [13.48415, 14.35881, 10.45793, 20.12131, 24.85473, 16.66601, 11.66707, 19.95834, 11.40156, 9.51552],
    [23.64620, 8.40648, 24.96826, 15.87130, 12.05222, 14.87396, 8.20139, 5.17701, 6.36845, 7.44514],
    [17.24647, 17.80313, 9.09497, 17.80984, 9.46791, 14.35514, 10.29252, 10.12833, 19.34614, 20.50890],
    [15.60457, 9.47584, 15.65218, 7.96457, 5.87588, 15.47273, 23.04621, 22.16605, 16.50365, 16.74535],
    [21.20899, 17.40150, 14.63469, 11.82211, 24.64049, 9.90860, 22.34245, 12.10959, 16.24302, 9.61989],
    [23.90561, 12.55394, 17.82693, 21.15711, 5.31190, 5.63112, 10.64470, 14.71343, 24.11618, 24.27915],
    [9.09986, 17.44484, 17.76589, 9.39711, 20.73473, 5.98880, 8.54564, 7.54646, 15.63997, 10.74786],
    [13.22901, 14.46928, 18.40007, 12.54784, 15.59481, 10.04776, 5.70254, 22.31254, 9.91653, 20.34288],
    [22.73858, 24.36338, 13.54946, 12.31712, 21.51296, 13.98160, 16.75024, 16.89245, 14.19828, 9.85549],
    [7.84494, 5.93631, 24.65209, 12.02658, 21.87307, 18.83343, 11.21784, 5.97659, 10.83453, 24.23948],
    [23.95016, 23.47163, 23.66390, 12.66686, 9.36659, 20.78234, 14.05240, 5.51027, 5.87649, 24.92309],
    [24.25352, 16.13926, 22.98700, 8.51207, 22.98151, 8.69335, 7.43110, 23.89950, 5.54262, 10.19181],
    [9.33241, 17.16956, 14.31791, 21.59169, 11.53340, 12.65709, 7.71493, 23.41426, 15.21210, 8.59569],
    [15.73580, 21.57033, 24.91455, 14.51994, 10.25346, 8.99854, 6.12552, 11.05365, 8.15561, 8.76049],
    [18.50566, 22.70623, 15.45503, 14.19340, 17.91055, 24.29991, 10.50676, 11.76534, 10.33219, 11.65670],
    [14.44853, 22.25333, 10.87664, 17.16712, 6.99530, 5.85696, 10.90228, 20.86535, 15.70833, 6.89459],
    [6.45146, 17.64077, 16.86804, 23.68526, 11.09638, 11.20380, 16.07089, 19.25153, 6.31840, 15.43733],
    [6.67913, 18.47636, 12.56005, 13.75271, 14.24955, 7.32063, 14.05728, 17.08167, 5.05676, 19.74105],
    [20.59313, 11.12629, 6.85125, 7.92428, 19.28510, 13.48659, 19.96567, 21.47328, 19.54085, 11.30390],
    [6.89215, 11.15558, 24.29868, 20.03037, 18.47453, 22.85455, 10.68499, 13.95779, 24.81201, 17.33558],
    [13.21192, 9.13343, 9.02295, 21.45924, 12.63390, 9.27808, 11.98874, 6.46489, 23.60042, 15.33967],
    [6.18656, 18.95367, 24.21384, 9.30433, 6.75970, 20.17991, 20.63646, 12.89087, 17.93924, 19.30342],
    [9.85549, 11.75192, 22.93207, 16.20029, 13.73684, 5.80813, 15.42268, 19.47432, 7.49336, 16.34129],
    [20.79699, 15.28718, 15.69735, 10.46770, 5.21119, 12.63451, 18.94818, 13.62392, 20.65111, 20.69323],
    [24.33714, 10.68010, 24.07712, 23.86105, 22.81976, 6.31352, 18.80840, 10.11795, 6.63518, 5.26734],
    [16.25401, 18.33781, 9.87991, 23.11274, 6.11637, 20.15976, 5.37721, 8.14402, 13.20643, 22.06473],
    [20.96118, 5.03845, 8.97229, 23.26777, 8.29173, 20.89038, 15.89328, 15.05585, 7.34626, 24.25596],
    [12.83776, 17.19764, 19.69039, 17.83425, 19.53352, 17.04566, 13.66298, 15.40132, 8.25510, 6.96234],
    [14.61028, 23.62972, 20.87146, 5.68972, 23.27021, 19.41328, 19.36262, 19.28816, 15.45564, 23.33125],
    [7.94321, 7.27058, 6.14933, 19.85946, 14.91119, 9.56313, 11.13605, 24.97559, 12.34336, 19.89914],
    [9.29884, 11.76412, 21.77786, 21.29566, 18.70830, 14.65911, 23.98740, 9.21583, 9.61928, 22.93939],
    [20.98437, 18.06192, 7.51534, 24.11374, 8.37840, 16.59948, 9.30799, 7.80831, 6.20914, 7.96579],
    [5.83132, 10.78814, 6.37700, 19.86435, 13.74844, 13.73806, 24.80834, 20.58519, 9.99710, 10.42436],
    [16.46092, 6.46611, 11.90023, 19.86557, 21.32313, 16.42918, 16.06357, 22.13553, 19.49324, 19.20576],
    [19.18989, 8.42418, 23.50459, 8.88989, 13.93094, 5.98331, 5.98758, 14.43083, 22.90277, 8.57555],
    [10.82171, 18.69732, 23.99106, 13.05994, 5.87588, 12.73949, 10.07157, 12.73461, 5.48402, 20.86901],
    [16.26743, 8.06162, 20.77074, 22.18436, 17.87027, 5.39918, 5.95035, 24.16623, 12.05405, 24.37010],
    [18.73272, 13.97244, 6.49968, 24.47874, 22.94916, 23.04559, 8.05918, 11.62618, 11.53523, 10.67278],
    [14.58403, 15.11872, 17.99051, 22.11295, 23.04437, 15.81515, 14.43266, 6.91717, 17.05725, 16.03366],
    [24.38719, 13.07642, 6.96173, 11.83798, 8.42174, 22.60430, 5.55300, 18.33354, 10.76312, 24.19919],
    [12.60277, 8.59325, 5.01038, 8.59813, 11.30085, 16.84912, 7.07648, 22.25211, 9.73098, 6.55461],
    [13.48354, 24.94018, 10.51103, 13.96512, 13.13013, 6.96722, 21.72597, 7.84738, 10.66546, 11.54378],
    [12.26768, 15.94455, 9.58632, 17.99356, 24.72411, 18.82855, 13.18873, 11.40278, 8.91919, 21.75710],
    [11.48946, 14.34477, 9.25794, 5.16358, 12.25852, 6.29215, 8.96863, 24.40855, 24.27305, 6.35685],
    [24.39940, 19.40657, 10.91876, 24.97192, 12.46544, 24.76989, 22.28019, 20.14084, 24.39695, 21.07593],
    [23.81771, 23.88913, 8.89294, 17.90139, 9.77981, 14.53093, 17.81838, 9.23292, 19.47066, 20.38316],
    [17.56325, 11.88620, 24.48057, 10.54582, 19.19172, 7.56111, 5.03174, 18.38725, 10.50493, 19.15326],
    [23.54488, 13.33583, 23.14386, 21.94510, 13.55373, 6.63152, 17.85379, 20.30931, 12.10654, 6.63701],
    [21.04297, 10.54399, 13.75637, 9.34767, 15.74618, 20.46495, 14.28861, 19.72579, 20.13840, 6.37638],
    [22.29240, 9.47035, 16.70446, 18.06192, 6.71453, 6.87017, 5.20142, 12.39280, 18.51115, 24.34080],
    [22.53471, 6.20548, 14.52605, 19.28632, 22.66839, 9.05652, 21.72475, 13.90957, 19.70931, 6.48747],
    [9.89883, 9.58693, 7.27302, 14.42167, 10.97674, 21.44215, 17.26478, 15.31831, 13.05811, 8.73791],
    [11.19953, 16.70995, 7.30293, 6.71697, 7.18818, 22.75079, 15.79379, 15.50996, 15.71200, 19.39009],
    [18.50139, 11.73605, 7.30842, 23.81344, 7.47627, 18.43242, 5.30091, 18.75591, 6.39348, 18.92010],
    [6.68828, 22.33390, 23.57295, 10.24552, 24.32493, 14.00235, 16.59581, 21.81631, 13.51344, 7.27180],
    [16.66051, 14.85443, 16.14414, 9.80789, 10.77715, 8.30027, 5.48341, 21.54225, 9.94644, 6.78167],
    [24.76989, 11.40889, 21.43422, 16.28147, 22.70440, 23.34712, 13.27906, 23.12250, 18.99823, 12.17856],
    [9.14808, 21.90176, 23.07428, 20.00046, 21.66738, 7.99142, 19.05622, 13.70510, 22.35649, 20.24094],
    [20.18052, 14.25993, 16.29124, 9.48622, 5.73733, 18.37138, 19.61470, 18.52153, 23.68648, 23.15363],
    [8.02438, 9.12915, 12.04672, 14.43144, 14.36491, 21.80960, 22.22098, 9.30433, 23.44417, 23.82992],
    [17.33741, 13.58791, 22.19962, 11.21845, 8.77270, 24.76623, 13.34803, 20.33189, 23.95444, 21.07349],
    [10.62700, 14.61150, 8.57860, 7.34260, 23.77255, 22.16910, 16.37303, 18.22489, 11.33930, 9.80667],
    [9.51430, 9.42396, 9.50514, 9.11878, 22.84295, 17.56325, 14.97406, 20.27879, 14.98505, 19.30830],
    [10.10269, 9.15357, 19.52315, 10.37248, 8.38450, 23.36055, 19.31745, 15.03327, 8.40464, 22.89422],
    [17.12867, 6.77679, 14.40153, 10.94928, 5.64699, 10.70391, 11.54988, 20.56505, 10.06607, 8.31797],
    [14.10062, 22.70928, 6.31413, 15.32014, 14.49187, 11.44307, 8.07932, 13.03613, 11.56758, 11.77145],
    [5.74831, 24.10520, 6.01566, 5.81668, 10.38408, 13.04407, 21.16565, 22.94183, 5.86428, 22.33146],
    [17.25318, 9.43434, 22.31498, 24.60936, 17.29713, 23.39961, 13.94925, 21.65395, 12.69494, 10.45854],
    [14.45891, 10.72771, 6.67241, 5.90396, 13.05445, 8.93323, 23.71212, 18.92010, 24.30479, 16.20701],
    [23.07672, 24.49644, 14.88678, 7.56600, 24.56725, 18.66924, 20.37523, 15.24140, 24.62951, 22.70135],
    [15.19684, 11.31306, 10.93219, 11.83248, 8.87219, 11.48885, 13.55678, 14.23246, 11.67318, 10.62639],
    [20.90381, 15.76266, 22.81854, 10.65264, 18.45561, 16.19419, 24.33103, 11.47847, 18.51726, 12.49107],
    [13.69167, 5.55666, 19.05499, 14.78607, 18.40007, 6.69012, 19.76485, 10.68377, 5.57436, 13.72585],
    [13.48720, 23.50398, 9.72121, 19.75753, 21.10828, 20.09384, 11.78793, 7.46040, 8.05002, 13.84365],
    [12.63329, 21.18213, 10.49760, 18.51238, 14.03470, 16.41881, 9.47340, 18.50627, 10.36210, 17.29774],
    [20.88610, 11.22394, 24.03867, 22.69280, 19.68551, 7.09845, 7.91513, 11.59810, 6.24149, 22.95953],
    [7.68746, 8.38572, 13.07703, 14.33744, 7.47078, 18.56731, 20.07065, 22.34733, 11.67135, 15.69246],
    [16.26926, 20.75365, 6.26652, 10.00443, 16.42369, 18.86883, 12.62535, 19.47615, 10.37553, 5.89114],
    [16.99377, 13.85525, 13.42006, 12.31101, 8.76720, 12.34458, 15.77242, 14.01700, 10.68316, 5.53713],
    [19.25886, 14.71892, 14.04202, 22.23380, 19.36079, 12.31773, 22.10196, 11.77023, 20.73412, 24.84802],
    [14.75799, 22.47917, 24.33226, 21.60756, 17.63771, 6.90313, 14.25199, 15.11872, 8.73180, 14.39909],
    [22.43706, 19.52681, 5.69399, 21.74306, 19.34797, 11.07013, 6.92633, 22.37114, 8.74706, 16.24973],
    [9.57961, 24.88037, 14.69817, 23.31172, 17.59255, 21.40797, 18.92438, 22.68426, 22.89666, 16.52135],
    [16.63854, 11.97531, 12.90796, 17.23975, 8.98206, 11.17634, 7.43477, 14.81353, 20.17991, 23.67306],
    [18.12174, 18.88958, 17.55593, 8.71410, 13.55983, 14.67559, 22.52190, 20.94348, 23.18903, 23.75179],
    [10.66485, 22.62871, 23.10602, 19.12275, 9.06934, 24.21140, 16.91870, 15.16999, 8.97961, 18.79925],
    [14.76287, 23.09748, 21.95059, 6.23539, 23.60775, 12.51732, 17.58766, 12.35557, 11.97104, 9.79446],
    [11.02741, 19.06720, 22.18497, 13.77102, 18.25785, 10.87970, 13.30958, 19.49568, 7.41829, 13.49818],
    [7.85226, 10.59343, 24.20713, 10.11307, 5.38697, 10.88824, 19.50606, 11.01581, 16.22349, 15.90854],
    [17.36488, 22.15384, 18.23222, 14.90204, 11.45772, 8.25755, 9.96536, 23.98129, 8.14158, 16.16550],
    [23.18598, 21.03137, 24.24253, 13.96329, 7.93893, 22.99493, 17.69143, 11.57674, 13.28822, 16.16733],
    [19.14106, 18.42631, 16.83935, 20.12803, 22.67815, 23.78536, 6.17496, 15.92318, 23.76644, 15.44954],
    [5.33692, 19.13617, 22.54143, 22.36198, 9.46242, 8.46324, 20.57787, 16.79724, 20.71825, 10.42558],
    [9.26283, 21.75222, 8.64086, 10.83270, 17.89529, 19.14716, 8.02499, 13.63552, 19.63179, 24.48057],
    [17.46620, 17.78237, 23.41731, 23.54610, 11.69759, 12.71203, 10.00931, 16.85339, 10.84552, 23.09992],
    [20.23545, 7.36091, 19.71297, 23.49055, 13.59523, 17.16163, 20.23606, 13.43593, 5.34852, 8.73241],
    [10.22538, 13.76980, 20.19395, 16.38524, 11.52669, 14.63347, 10.68194, 23.52962, 20.71093, 15.89328],
    [18.47819, 11.39302, 5.43641, 10.55620, 6.59917, 14.79949, 19.60128, 11.82638, 20.75671, 10.65020],
    [20.39964, 14.41496, 7.92062, 14.72381, 20.43077, 10.73321, 10.23942, 12.41844, 17.95877, 12.59667],
    [22.43645, 19.07025, 18.47392, 19.05683, 10.80279, 15.46052, 10.65569, 20.99414, 21.92495, 14.14701],
    [9.88601, 23.09442, 19.25459, 22.24174, 12.42027, 13.83023, 15.66500, 16.25340, 13.34620, 24.07834],
    [20.10117, 14.63408, 11.46321, 24.99145, 6.45634, 23.63643, 14.19401, 5.75381, 22.81121, 22.12149],
    [5.66408, 21.84988, 9.13038, 20.93982, 11.07196, 14.45585, 21.58315, 22.49870, 20.46678, 11.59749],
    [11.56880, 16.16062, 5.06897, 11.68722, 17.61086, 15.07721, 9.26160, 20.06943, 18.21696, 10.10086],
    [11.35701, 19.19843, 23.84701, 6.38798, 16.28697, 23.07489, 16.10202, 18.32255, 13.33155, 16.56407],
    [12.27073, 8.38450, 22.00980, 10.22294, 23.34712, 5.59450, 19.25703, 11.26118, 23.65291, 9.14502],
    [11.02191, 21.25477, 20.18662, 12.85607, 21.40126, 21.24866, 19.82101, 16.07761, 22.43156, 14.86541],
    [22.48283, 16.65990, 17.68044, 10.04349, 18.42570, 11.62008, 22.74712, 10.03800, 17.74087, 21.13086],
    [15.79867, 14.30143, 10.20585, 21.44765, 21.27674, 19.87045, 23.62484, 22.41691, 19.88754, 23.89157],
    [18.75530, 15.17060, 8.01157, 17.89895, 8.97290, 5.64516, 19.64827, 14.47783, 22.78497, 19.54390],
    [14.02249, 16.93335, 17.31422, 14.37101, 21.99026, 12.59545, 20.89343, 24.16318, 14.34477, 20.37950],
    [12.88110, 12.53441, 5.17335, 13.22901, 18.82916, 19.67391, 13.37245, 6.06937, 9.12915, 18.91034],
    [15.45015, 9.89090, 19.25825, 8.47056, 12.74865, 22.59148, 19.75082, 14.06400, 6.20182, 17.20069],
    [14.02615, 7.90231, 21.75649, 18.11441, 12.18894, 19.80331, 19.58357, 5.95950, 18.92987, 5.97476],
    [10.20524, 21.71926, 23.65719, 11.13239, 10.66057, 10.73382, 10.97674, 9.55336, 23.82992, 17.22388],
    [19.65072, 20.70421, 14.05484, 9.92813, 8.15439, 5.06531, 22.17154, 9.51491, 14.96490, 15.77303],
    [13.07947, 18.36650, 11.69515, 11.70614, 18.97626, 23.37458, 17.21046, 7.64840, 11.38264, 12.36839],
    [10.84124, 7.13874, 5.08057, 14.80438, 12.82800, 13.64895, 7.08869, 7.32978, 10.11063, 5.69948],
    [13.80520, 14.86175, 15.60396, 11.55416, 9.43678, 7.79733, 19.06354, 9.10047, 8.84350, 5.98086],
    [17.68777, 6.55828, 17.92215, 10.05142, 24.56664, 9.63088, 14.65300, 10.80340, 23.10602, 10.72344],
    [23.93735, 17.17811, 5.55849, 5.86245, 9.34645, 13.50856, 23.77682, 14.93194, 14.91241, 6.65349],
    [10.31816, 10.85284, 20.08164, 13.63674, 18.02896, 13.34010, 20.95691, 10.41765, 16.22776, 12.84631],
    [20.95325, 12.42210, 11.61519, 20.33250, 23.99655, 7.45491, 12.03818, 8.47850, 13.38038, 11.61885],
    [21.22730, 19.97177, 9.41847, 8.86975, 22.63665, 8.47972, 9.00281, 24.82788, 20.51317, 7.95541],
    [20.21043, 15.46846, 16.31077, 15.87741, 15.06561, 21.32740, 8.59081, 6.06693, 13.59890, 7.83273],
    [14.51506, 16.69897, 22.31376, 22.39982, 21.06861, 9.12976, 20.19395, 8.90271, 24.13633, 23.17682],
    [15.37935, 10.16007, 23.55281, 24.45982, 5.62502, 19.05072, 12.25669, 9.44777, 5.67690, 8.88379],
    [7.66976, 23.81771, 14.68657, 23.66207, 23.42586, 19.76180, 6.79022, 18.83648, 9.58022, 7.86447],
    [17.97525, 13.21192, 19.41939, 9.17798, 12.36351, 22.59758, 10.99384, 23.11335, 21.03137, 15.84445],
    [21.50868, 16.77587, 16.49388, 23.89401, 22.68426, 11.38020, 15.97995, 22.45109, 15.22431, 11.34968],
    [16.61962, 18.92499, 10.50615, 11.74215, 15.67110, 24.24619, 17.62490, 9.61989, 18.91217, 20.19211],
    [23.91171, 14.98749, 10.31999, 22.84845, 7.05756, 6.92999, 6.16703, 12.82434, 6.96234, 10.56658],
    [6.65044, 12.85607, 15.43001, 20.45335, 8.19346, 23.41060, 11.84957, 6.05045, 9.53017, 16.92846],
    [22.97052, 24.89441, 14.70611, 21.32252, 14.90631, 19.07880, 6.11637, 13.35963, 15.49471, 20.69201],
    [10.71368, 12.54784, 15.12482, 21.81570, 12.49474, 16.16123, 24.17478, 14.72442, 14.41191, 6.01627],
    [15.17121, 17.90323, 22.81793, 7.63680, 7.80099, 13.51039, 17.57363, 12.42576, 24.90173, 11.91305],
    [20.94958, 23.46370, 17.54982, 8.91247, 8.43760, 15.57344, 7.37861, 11.29963, 14.60356, 10.26444],
    [24.24741, 16.34190, 17.10181, 16.18320, 7.38472, 20.85437, 11.98325, 15.69491, 8.13730, 5.45717],
    [23.41243, 8.23191, 22.44072, 9.65835, 20.92456, 11.01337, 11.14521, 23.37519, 7.35298, 7.78024],
    [16.31809, 10.53484, 10.53484, 6.16276, 11.64388, 10.36515, 21.94082, 14.29960, 15.05707, 12.00400],
    [15.33479, 17.34901, 21.72048, 8.05857, 8.60912, 24.49950, 5.48219, 22.73309, 21.89688, 7.11798],
    [6.93915, 20.15000, 15.10529, 18.65581, 16.21738, 8.49254, 17.98807, 16.93457, 8.61156, 5.59755],
    [15.87741, 19.44075, 21.20045, 21.60939, 24.21079, 12.25791, 8.55785, 24.33348, 14.96551, 23.24946],
    [5.70009, 22.91559, 8.13974, 20.12558, 16.37425, 15.45686, 11.39241, 24.02646, 14.83184, 16.20701],
    [20.97034, 19.22529, 19.19843, 7.94565, 7.05573, 9.59792, 24.57335, 15.19318, 16.64953, 22.47551],
    [13.97549, 23.85678, 17.11585, 10.49760, 15.27680, 22.95282, 13.52260, 12.10593, 22.22343, 14.02554],
    [22.88873, 21.29322, 7.69173, 23.88302, 18.47392, 7.23151, 7.29743, 6.27567, 7.23457, 14.41679],
    [21.47389, 8.15500, 13.56471, 23.93429, 14.15860, 6.11698, 12.45140, 6.49297, 16.20334, 8.67077],
    [5.17457, 7.83700, 11.63594, 9.95193, 20.66332, 17.16590, 14.90020, 10.50737, 15.64486, 19.18744],
    [17.19459, 10.77471, 16.71056, 20.42894, 10.04105, 12.87866, 17.41493, 10.43046, 24.20103, 16.37974],
    [13.54274, 8.44859, 12.07297, 23.58394, 9.66445, 16.28941, 11.68661, 20.05905, 20.10666, 7.89987],
    [20.42955, 5.96072, 17.45705, 16.34434, 16.61718, 23.81161, 11.73971, 8.78735, 17.04749, 18.34208],
    [13.37550, 10.10880, 8.65307, 14.03897, 23.05780, 5.77761, 22.38151, 6.00345, 21.66677, 24.60936],
    [7.42195, 9.75723, 23.34834, 12.02597, 13.91934, 5.62197, 24.88159, 14.46013, 22.27775, 23.29218],
    [14.45891, 5.50356, 7.19794, 22.22587, 13.01172, 14.44792, 14.56877, 13.48598, 11.18915, 7.82785],
    [19.32173, 18.64788, 15.13642, 24.60265, 22.40532, 11.40156, 24.18149, 15.58870, 14.97162, 17.47963],
    [13.55922, 7.78024, 7.92245, 18.52336, 5.30885, 24.17722, 14.92767, 15.52461, 20.44908, 19.74044],
    [7.04779, 17.46132, 15.57222, 24.11435, 7.08075, 10.75030, 16.98035, 11.72201, 21.76504, 15.15351],
    [15.48189, 9.87747, 19.94980, 21.74245, 14.97650, 5.52370, 14.88006, 18.57036, 17.95633, 21.23218],
    [18.69610, 19.65621, 21.04663, 21.08264, 7.28889, 22.91742, 23.70785, 17.05481, 23.63887, 12.67174],
    [23.22932, 16.54881, 17.74148, 12.33726, 19.13495, 21.66555, 11.27400, 22.94733, 20.13047, 20.86779],
    [5.10498, 13.11487, 16.71300, 23.65291, 17.78481, 16.06845, 12.56737, 18.85540, 13.13440, 19.37849],
    [17.88491, 7.20527, 5.06226, 23.00653, 17.70730, 8.77758, 17.73476, 11.30268, 18.45073, 15.93722],
    [9.21705, 14.56877, 5.70559, 12.42882, 16.72643, 5.81606, 16.46031, 9.21644, 11.59749, 8.35093],
    [18.85296, 17.70913, 22.11417, 19.79720, 22.60125, 10.99384, 12.30430, 8.19285, 13.20826, 13.70205],
    [14.84832, 5.78249, 13.09168, 11.13117, 6.20487, 16.12949, 22.74590, 18.25358, 22.09464, 20.17014],
    [5.07019, 19.22895, 21.45375, 16.84423, 5.99063, 18.05094, 16.99622, 23.91781, 14.48698, 10.95294],
    [20.49974, 14.62371, 15.16449, 21.19800, 20.94104, 15.75228, 16.49205, 6.86712, 23.61080, 22.80877],
    [7.82113, 22.29667, 8.32774, 17.86782, 8.32896, 23.75668, 14.88372, 5.74831, 20.99109, 20.02365],
    [13.83145, 14.13236, 14.72442, 18.45683, 10.76128, 13.25404, 7.81869, 7.20710, 22.16849, 20.78845],
    [15.77853, 24.18516, 11.04999, 7.55074, 16.70690, 13.40785, 20.36058, 9.65651, 17.35450, 19.36384],
    [12.43126, 22.73309, 12.95434, 19.99496, 12.50328, 23.84091, 23.97214, 8.95276, 24.48057, 16.71239],
    [22.89727, 7.72408, 17.03284, 5.92898, 14.19462, 18.27494, 8.18247, 15.67782, 20.55040, 16.81799],
    [6.48564, 18.69732, 18.52336, 19.34553, 16.94555, 11.04450, 16.74657, 19.54024, 9.77126, 18.31217],
    [19.78439, 9.69802, 20.11887, 8.90698, 10.78021, 5.27833, 16.93091, 20.03525, 16.02206, 23.71761],
    [9.00525, 11.99423, 24.54344, 18.11930, 6.40996, 16.42491, 5.88870, 16.46153, 5.38087, 14.12076],
    [19.17035, 6.92633, 14.81841, 8.04086, 16.53478, 19.99435, 12.50816, 7.13996, 14.17570, 7.91940],
    [9.19813, 6.64556, 14.00052, 12.21213, 8.65062, 20.40086, 9.09680, 19.75448, 21.79128, 10.90838],
    [16.10508, 18.17240, 23.09198, 12.69372, 7.63314, 11.09577, 7.29987, 14.60906, 7.83822, 23.92026],
    [14.64690, 16.71239, 24.28953, 20.70177, 22.65740, 7.33955, 19.25214, 22.81732, 12.68273, 15.99948],
    [13.50978, 9.99649, 9.29090, 7.70821, 5.84780, 14.37162, 20.62975, 14.40397, 21.32740, 8.15256],
    [17.88919, 9.04370, 11.47176, 15.56490, 21.99820, 18.03385, 19.49751, 9.66689, 15.66439, 17.59560],
    [13.70083, 24.67833, 8.89538, 9.70717, 22.14286, 24.43785, 16.12217, 23.23908, 11.73727, 17.62246],
    [13.04224, 15.90732, 24.89135, 20.34654, 11.32405, 22.67876, 16.79601, 16.76733, 19.28327, 6.23539],
    [6.51860, 18.33171, 6.65593, 15.14985, 24.99817, 12.26707, 21.60878, 5.36317, 13.08802, 19.96994],
    [18.09061, 10.62334, 12.75903, 15.88961, 21.66738, 17.48573, 24.59105, 7.55379, 11.95517, 10.50920],
    [14.67986, 7.34565, 9.78103, 23.27631, 24.08628, 16.66845, 7.19672, 20.85620, 23.94040, 13.11487],
    [8.46324, 9.33729, 9.34462, 21.27125, 20.14756, 18.05887, 15.18525, 17.77627, 18.43242, 10.15519],
    [6.98492, 11.26728, 11.79037, 7.05756, 9.91897, 7.83273, 7.12592, 22.55303, 9.11878, 22.59392],
    [17.52480, 12.04611, 24.39390, 8.04575, 19.72274, 12.64183, 12.48680, 19.78866, 19.43281, 19.66903],
    [19.99985, 10.25529, 12.64855, 15.27741, 20.10300, 11.07807, 21.04419, 14.72869, 16.15940, 14.71343],
    [9.60219, 6.00894, 5.39308, 15.94821, 24.60082, 8.38694, 5.71413, 23.91171, 20.06333, 5.53774],
    [18.83770, 5.22523, 10.82415, 18.87005, 12.81579, 8.90759, 20.31175, 16.66540, 17.10913, 13.65688],
    [21.18274, 24.66857, 13.31935, 8.15378, 16.94128, 13.74660, 14.71587, 24.98413, 22.65130, 10.24247],
    [17.67190, 18.82672, 12.87805, 24.64904, 18.14066, 9.52345, 14.98321, 24.22605, 16.30100, 20.65355],
    [15.89328, 5.19654, 22.48222, 14.24467, 20.47227, 10.12650, 7.51106, 12.24021, 9.61928, 6.13163],
    [10.59526, 5.34852, 16.21982, 9.53139, 7.86935, 19.90219, 7.06793, 12.56371, 14.73235, 23.34590],
    [8.89966, 17.80923, 5.09705, 18.98785, 6.64251, 15.92135, 20.68224, 10.63128, 12.02475, 12.31346],
    [13.46217, 7.71187, 10.65508, 18.40800, 14.41313, 11.56941, 5.71047, 13.08618, 11.66768, 13.47926],
    [6.34281, 9.95437, 11.21174, 5.06409, 18.94391, 16.05930, 23.24396, 11.71529, 9.38246, 17.67129],
    [7.32368, 9.64370, 14.34538, 18.76080, 19.43770, 17.19398, 9.90555, 7.80160, 14.09635, 21.03565],
    [15.43794, 18.51421, 24.60509, 7.86508, 21.01611, 20.17747, 14.61516, 22.24357, 16.40904, 23.14447],
    [24.09848, 21.18336, 9.80361, 15.16755, 22.84967, 6.12796, 14.38017, 14.17936, 14.66216, 22.93512],
    [10.86138, 13.13501, 5.28871, 10.48540, 24.16929, 22.55547, 17.31849, 8.56700, 22.30033, 6.38798],
    [5.08667, 5.62197, 15.55879, 16.81677, 12.76025, 17.01697, 24.26450, 23.63521, 8.69945, 14.43571],
    [13.05933, 23.82199, 19.24238, 17.03711, 19.94736, 6.93304, 15.02594, 24.99207, 18.17667, 21.94388],
    [12.96960, 6.02542, 19.10810, 21.14917, 7.05084, 15.60213, 14.17631, 6.77618, 10.99078, 21.35426],
    [24.08567, 15.90487, 5.98392, 12.40501, 13.34986, 9.33607, 16.58727, 24.19553, 18.31584, 20.03464],
    [7.90048, 19.44075, 6.78045, 6.76275, 7.16254, 15.85055, 17.34535, 8.53771, 22.88263, 21.22913],
    [16.60924, 5.52797, 24.63683, 6.57964, 22.34916, 22.03055, 16.65746, 17.85012, 10.79730, 17.13172],
    [8.33140, 16.92785, 16.14536, 18.69976, 14.74151, 12.52159, 20.39842, 6.31108, 10.36699, 11.55354],
    [21.71010, 18.75713, 9.07971, 11.67623, 19.31623, 11.74032, 13.54823, 5.55788, 23.19391, 21.39149],
    [7.18513, 17.54006, 6.57537, 19.23505, 11.75619, 23.31233, 9.43739, 14.22025, 23.78048, 13.21070],
    [11.08844, 7.45430, 12.84021, 9.78408, 19.98825, 15.24628, 14.93805, 20.23484, 18.91522, 6.10599],
    [24.00754, 14.36979, 13.61232, 7.30720, 14.72137, 8.68786, 23.03339, 6.64739, 19.71236, 7.21870],
    [19.31440, 5.03052, 14.32646, 19.75143, 15.60213, 5.49013, 12.04978, 8.06345, 9.85122, 14.28739],
    [23.71883, 20.79028, 22.73003, 19.70199, 23.64437, 7.54585, 17.74819, 24.14426, 15.77792, 12.93176],
    [21.73757, 15.21027, 23.04010, 21.04846, 13.81252, 11.31428, 12.93664, 11.14338, 20.92517, 7.50618],
    [22.59331, 15.01862, 8.15256, 17.11707, 16.32237, 16.81249, 21.83706, 14.84710, 18.86090, 5.80020],
    [13.69228, 16.92358, 17.39479, 22.82037, 24.02768, 23.95810, 15.49287, 10.96026, 12.18345, 22.11539],
    [12.09006, 11.12506, 12.32810, 8.23801, 8.62194, 13.11609, 22.72637, 14.53398, 17.46071, 22.83746],
    [6.61016, 18.46171, 14.75433, 16.26560, 12.78100, 13.43654, 10.81439, 20.79821, 14.05423, 5.98086],
    [21.16016, 14.61272, 11.68844, 14.94659, 11.35578, 24.65758, 23.91171, 18.43059, 18.76385, 13.89859],
    [6.67852, 24.01059, 24.32920, 18.45317, 24.77294, 7.92856, 17.53639, 5.22706, 21.39271, 18.84564],
    [7.65328, 10.68804, 24.33287, 11.78426, 24.38475, 11.39485, 16.89550, 7.89926, 21.06983, 6.90863],
    [11.65426, 5.69399, 23.54183, 5.71718, 15.19196, 19.29853, 17.77627, 14.78301, 21.93838, 9.45143],
    [19.45723, 23.35932, 5.24171, 22.80145, 18.57341, 21.67837, 23.78475, 5.14649, 22.19047, 5.15992],
    [11.47725, 24.25474, 8.50047, 24.74059, 8.95886, 7.86874, 15.29756, 13.96634, 24.81689, 12.54295],
    [15.97934, 13.47011, 24.66185, 8.91308, 6.22440, 23.45454, 16.18015, 19.04645, 14.45280, 24.80407],
    [8.28806, 11.48030, 19.19904, 19.46272, 12.50755, 9.58754, 6.52715, 10.68804, 24.69970, 18.88043],
    [10.61480, 13.81741, 15.27070, 8.88989, 10.61235, 18.16263, 5.98331, 15.23713, 6.93060, 10.66362],
    [21.49159, 17.52846, 10.05997, 21.93228, 13.72463, 18.69060, 5.05493, 5.28932, 7.25654, 21.38356],
    [24.80895, 9.45021, 23.76705, 7.09906, 15.23957, 15.45686, 13.73379, 13.59279, 5.52065, 18.49590],
    [13.47926, 16.24485, 6.46794, 5.22828, 15.68697, 9.00708, 10.22416, 7.24799, 11.52364, 10.53423],
    [14.34843, 21.29810, 12.49046, 11.14093, 23.45454, 16.86926, 10.11856, 6.20182, 11.50227, 21.81448],
    [21.64846, 11.62557, 17.89163, 6.58025, 19.80514, 7.01666, 20.45640, 17.71401, 14.80499, 22.16544],
    [18.50688, 21.23829, 6.71148, 12.47948, 9.03272, 6.54546, 16.26682, 18.98602, 9.19630, 11.41682],
    [12.32322, 18.53008, 8.23923, 18.80230, 24.01120, 19.79232, 21.92740, 5.98270, 15.74252, 10.75030],
    [12.66076, 16.74352, 13.20704, 13.21741, 8.37413, 17.17444, 18.45805, 10.06546, 23.34956, 5.73000],
    [22.23014, 20.77929, 14.06461, 18.17911, 11.60848, 10.94745, 13.21497, 18.04788, 21.17481, 11.33137],
    [15.01434, 13.21253, 5.75014, 12.12058, 14.91607, 9.23658, 22.87347, 8.01767, 16.87109, 20.09751],
    [23.12128, 19.76180, 11.25019, 6.91900, 16.41148, 7.72408, 16.55553, 5.33876, 12.40684, 23.20368],
    [8.04453, 12.12912, 23.14203, 13.03247, 6.39897, 11.70492, 6.00589, 23.13959, 9.54787, 13.13807],
    [15.20112, 16.67333, 20.78845, 18.30424, 19.79781, 12.32688, 16.31809, 11.78610, 16.52440, 18.48003],
    [5.30274, 13.16309, 15.40376, 8.78735, 5.61525, 22.30644, 6.36357, 14.83978, 8.35643, 18.30546],
    [24.95727, 21.51357, 14.29350, 22.65679, 5.29969, 20.64928, 15.33845, 7.32917, 18.36711, 8.66894],
    [24.18821, 18.34513, 23.76095, 23.76705, 5.25391, 15.48555, 13.08313, 8.29295, 10.00748, 18.75958],
    [13.03552, 11.96371, 9.86343, 22.25578, 6.36418, 21.50502, 9.72610, 5.99551, 18.79131, 12.38060],
    [15.32624, 6.43071, 10.03922, 8.20383, 17.47169, 16.18503, 17.08777, 23.47835, 6.33732, 13.68984],
    [7.77718, 15.27497, 18.91827, 13.32118, 12.89392, 19.49080, 12.77123, 16.67516, 14.85137, 17.29102],
    [9.17432, 15.59236, 21.10279, 7.38044, 18.82061, 7.57454, 20.40269, 9.71572, 13.17713, 14.20377],
    [10.04654, 16.28941, 14.63775, 23.19636, 12.20908, 14.60784, 8.58043, 24.71191, 7.51411, 19.49263],
    [10.47502, 22.54875, 23.95016, 18.82244, 11.14521, 10.84613, 9.26527, 8.85083, 13.32545, 16.91748],
    [24.96887, 24.71618, 22.63176, 20.84338, 10.04654, 21.76748, 6.06449, 12.44530, 12.54295, 13.34681],
    [21.18885, 16.27110, 17.10730, 20.63402, 9.08765, 5.20753, 6.64739, 20.18357, 14.24528, 13.35841],
    [6.21281, 24.79125, 24.45494, 8.79345, 7.22053, 23.30012, 13.90103, 16.82226, 20.16587, 14.97772],
    [22.52800, 14.38139, 13.92972, 24.08750, 14.81658, 6.19694, 9.81521, 10.28397, 11.11225, 23.31843],
    [8.43516, 20.45030, 14.60417, 14.66338, 17.57607, 17.60598, 7.10028, 12.19749, 19.16059, 12.51244],
    [16.71728, 20.37217, 23.44356, 13.59767, 10.60625, 10.43840, 8.55235, 20.82263, 15.84384, 10.27787],
    [13.50978, 19.12458, 21.61245, 10.36088, 22.85211, 17.05176, 5.79409, 16.46397, 10.97797, 6.21708],
    [19.10627, 9.76821, 24.35362, 7.20099, 9.89395, 24.97131, 9.67971, 17.52297, 22.72271, 7.02155],
    [6.17740, 7.30415, 13.87295, 17.12500, 10.08866, 18.26090, 16.88391, 8.61950, 9.53200, 11.62862],
    [21.25538, 23.36726, 17.83731, 20.67248, 17.44057, 9.27503, 23.47835, 13.37916, 11.25263, 9.57778],
    [24.73327, 20.97827, 20.81225, 24.49644, 7.19672, 17.90323, 19.15387, 15.91037, 12.27195, 8.82763],
    [15.62777, 15.66195, 14.75555, 8.39183, 19.21247, 8.11472, 17.65786, 9.25367, 16.86621, 7.59957],
    [22.37114, 24.08322, 10.04227, 21.36708, 22.31376, 17.12622, 22.49748, 18.66741, 18.17728, 10.96576],
    [22.50542, 16.59825, 22.90033, 24.10337, 12.62169, 23.32698, 14.49065, 24.98291, 10.10147, 9.32203],
    [24.83032, 18.08756, 11.11347, 7.22358, 22.57439, 7.73202, 21.86270, 10.96210, 18.28471, 15.17548],
    [9.75723, 14.76775, 9.90616, 14.67498, 17.73782, 22.68242, 16.72826, 24.11496, 14.89227, 9.20728],
    [19.94247, 15.83163, 6.48991, 21.71072, 17.92581, 23.25312, 16.55187, 5.20936, 14.38261, 8.98999],
    [6.08341, 20.17258, 7.45552, 9.99405, 20.10239, 13.93948, 17.93985, 5.40895, 6.57292, 16.41575],
    [24.72777, 22.75018, 20.38682, 20.63524, 5.59938, 8.01767, 15.49837, 18.84014, 11.49678, 15.39399],
    [18.36222, 14.68841, 12.39097, 22.12210, 5.77090, 22.22343, 22.88202, 24.21445, 20.24400, 12.22129],
    [5.64882, 18.60393, 6.06815, 16.55187, 20.87695, 7.36518, 19.14289, 11.16535, 19.78256, 9.63088],
    [13.72158, 8.34666, 10.37065, 16.82531, 19.20820, 18.84075, 13.53847, 16.85217, 10.10636, 14.49431],
    [17.65969, 22.84356, 22.26676, 12.02963, 9.76638, 12.10715, 18.53740, 8.57128, 11.46443, 10.89740],
    [16.96448, 9.56069, 17.68838, 10.62517, 24.65209, 19.67574, 6.44658, 11.14399, 10.40727, 17.38319],
    [17.65847, 16.72948, 19.30830, 23.75240, 9.22254, 20.37584, 22.30094, 6.14566, 8.43394, 22.04215],
    [23.97031, 7.42317, 6.88055, 16.46825, 21.59108, 21.27552, 16.93823, 16.18381, 18.60088, 24.31516],
    [17.99478, 5.33876, 5.60488, 5.55361, 10.52507, 9.98001, 12.05283, 23.88546, 6.14139, 20.39781],
    [21.69424, 14.19889, 11.74825, 11.16352, 14.95819, 12.75414, 15.91769, 14.49858, 11.36860, 22.43950],
    [15.62410, 12.57591, 15.11994, 8.52977, 11.45039, 24.39817, 16.94555, 5.59328, 9.39711, 12.87133],
    [15.40071, 6.13712, 17.41859, 7.69967, 10.68316, 11.65059, 14.80865, 9.72121, 14.11649, 16.64647],
    [22.56584, 12.31712, 6.42521, 6.34342, 12.85730, 5.51576, 7.92367, 18.60027, 5.71352, 18.41960],
    [13.74172, 10.73260, 11.06952, 5.56825, 17.21412, 21.84378, 24.28465, 12.88720, 14.56572, 11.27888],
    [13.26380, 8.81542, 14.00052, 23.85006, 5.30824, 16.26682, 22.33940, 22.42607, 11.81356, 11.02496],
    [12.31223, 18.55022, 18.94513, 22.22159, 23.64986, 21.67531, 22.41691, 20.49547, 21.08081, 17.66213],
    [14.49553, 9.48500, 22.37297, 17.16529, 21.35853, 6.25858, 19.53536, 24.51659, 18.92254, 6.31596],
    [6.31169, 7.75094, 5.27955, 18.78765, 15.08942, 20.38560, 17.85989, 7.45003, 16.34007, 15.58077],
    [13.43898, 23.19391, 23.73531, 23.31233, 19.13251, 23.55220, 18.03934, 11.17328, 12.48131, 24.93408],
    [12.92932, 19.43709, 18.77178, 23.17072, 15.84140, 10.99811, 23.70235, 8.01157, 6.98920, 6.82684],
    [9.52895, 7.19001, 9.66933, 7.55257, 12.81335, 5.68178, 14.97955, 11.80441, 11.89352, 15.78646],
    [14.07804, 11.93930, 22.21000, 23.65352, 21.10462, 17.77261, 7.60567, 7.87606, 19.89242, 8.94543],
    [5.73244, 15.78951, 17.59621, 6.54607, 15.67537, 13.07337, 18.35246, 24.62035, 5.93692, 12.31590],
    [20.11032, 12.17917, 10.89496, 16.13865, 7.74850, 6.35258, 13.85830, 20.51988, 5.61037, 7.29133],
    [24.85717, 13.93704, 22.56890, 15.45259, 11.27461, 17.95572, 12.76513, 21.89871, 9.46791, 24.88769],
    [5.13184, 12.22251, 15.47578, 18.14554, 24.83215, 14.73846, 22.96625, 10.91754, 19.73373, 13.54335],
    [6.52593, 8.78552, 15.05341, 17.10120, 18.43486, 11.91671, 9.28541, 22.94671, 17.03284, 22.44682],
    [14.54558, 9.15540, 14.82025, 12.68761, 14.45463, 13.19544, 24.40916, 19.77767, 22.68731, 8.77941],
    [10.44572, 22.40226, 15.30549, 21.36219, 5.64150, 5.20997, 20.01267, 12.88415, 19.02692, 6.55217],
    [15.44038, 16.40599, 14.55535, 15.16083, 23.60286, 11.24531, 8.18857, 11.40339, 8.63903, 19.25214],
    [21.57949, 18.73272, 24.97253, 12.83227, 20.48082, 20.94958, 8.00119, 15.36775, 16.01169, 10.92120],
    [10.46464, 24.63256, 16.89184, 6.36296, 17.58583, 19.84420, 10.78570, 18.31645, 24.13938, 22.98090],
    [22.86737, 7.95053, 6.55034, 14.96979, 9.73708, 17.30506, 13.16431, 17.39174, 16.82226, 9.60463],
    [5.79592, 20.31297, 17.36671, 24.77355, 15.70528, 6.87994, 21.15955, 5.75869, 7.10150, 15.29572],
    [11.10675, 21.31336, 11.31794, 8.79650, 15.78463, 20.83728, 24.77172, 14.27580, 16.08921, 6.92206],
    [13.83816, 20.15122, 14.12015, 21.21143, 19.76974, 14.12381, 22.40898, 9.20728, 6.77007, 11.44185],
    [21.62465, 19.65072, 6.36540, 14.29838, 24.88769, 24.08994, 21.18274, 12.98425, 16.80212, 12.27683],
    [21.27186, 9.42824, 5.34425, 9.00525, 16.09165, 13.73989, 14.72564, 8.01706, 15.28413, 14.38871],
    [17.35755, 8.60973, 21.35975, 12.64183, 13.04529, 10.55742, 7.42561, 21.87979, 13.53114, 12.98242],
    [23.07917, 22.42546, 20.51073, 12.79443, 21.58437, 12.50267, 15.26032, 8.32652, 11.46748, 5.95401],
    [7.98044, 23.78964, 5.65249, 17.34169, 24.99878, 20.17380, 11.25568, 5.05127, 21.94266, 8.22092],
    [13.17286, 13.03919, 21.02100, 9.08826, 14.57976, 21.82485, 20.52660, 18.33903, 7.47322, 9.37513],
    [14.69146, 18.87005, 16.37181, 12.49474, 12.02170, 18.41777, 8.31065, 9.34400, 10.22782, 17.25501],
    [12.24876, 13.72463, 15.89084, 21.70766, 21.01123, 21.73574, 6.96844, 9.12061, 18.90423, 21.44826],
    [6.28788, 19.88998, 8.10923, 6.20853, 24.13572, 22.19108, 17.00049, 22.19718, 18.07169, 5.02808],
    [23.49178, 10.87359, 8.10190, 5.23316, 16.55614, 16.92846, 15.32136, 24.02463, 9.03211, 22.36808],
    [22.15934, 18.76995, 24.84008, 17.35511, 22.35466, 5.56764, 13.73928, 8.43516, 18.77911, 18.27372],
    [16.75756, 14.77020, 17.23975, 19.59212, 15.39277, 13.00317, 14.38139, 9.87381, 7.74606, 21.38112],
    [7.81503, 9.22498, 24.68444, 23.76217, 6.59978, 18.56304, 9.16395, 24.13083, 10.20096, 15.24506],
    [11.85812, 12.24143, 14.04691, 8.89233, 6.17862, 11.02924, 9.81765, 13.03186, 15.85360, 6.39042],
    [18.57952, 18.18278, 18.15958, 9.98367, 24.90112, 22.01956, 15.94516, 15.65462, 10.06485, 22.22221],
    [21.56972, 20.12375, 12.51549, 7.65206, 5.88015, 8.55358, 13.64650, 13.47194, 15.35310, 15.62838],
    [17.07434, 15.83407, 10.52324, 22.75994, 19.50911, 11.76778, 8.82946, 22.05802, 21.35182, 19.88449],
    [24.99573, 7.67769, 15.14435, 7.52571, 12.08090, 5.17945, 19.99741, 19.99008, 16.31443, 19.51949],
    [20.11643, 17.44301, 8.84533, 12.29637, 15.55696, 15.15839, 7.53426, 8.88562, 23.32942, 12.69982],
    [11.90512, 6.07547, 16.98279, 7.67098, 24.38963, 20.84155, 22.78924, 19.66720, 20.98071, 10.87481],
    [20.65233, 20.03769, 24.43236, 7.49580, 7.87240, 13.10450, 23.11640, 11.57308, 13.88272, 24.44578],
    [8.67321, 13.07886, 24.09177, 21.86880, 15.57466, 24.89807, 20.94775, 24.71740, 15.72542, 11.52120],
    [20.35936, 7.11066, 11.22822, 23.25129, 11.59017, 10.76189, 18.44096, 16.53050, 18.75469, 12.98425],
    [6.44475, 11.04022, 12.04123, 5.52675, 23.05414, 24.17112, 6.78838, 9.84573, 11.48396, 13.50612],
    [18.53496, 24.45372, 10.81988, 7.93954, 12.17124, 9.95804, 23.38435, 18.04849, 13.32179, 7.42744],
    [22.15751, 6.34770, 20.07431, 15.69491, 21.35365, 8.05673, 23.18720, 23.23603, 23.28852, 22.99615],
    [12.89941, 20.24155, 24.66185, 9.23780, 20.46556, 6.51372, 15.37812, 19.15204, 12.54295, 20.80126],
    [13.03064, 8.44310, 6.55583, 7.20588, 6.17679, 18.83282, 5.16053, 24.29441, 9.52406, 24.99634],
    [17.93802, 12.51305, 24.15952, 6.37761, 8.43577, 5.56520, 5.93814, 14.52300, 14.68902, 21.34754],
    [15.16694, 16.53111, 21.34144, 18.08390, 10.69414, 5.27833, 11.49495, 11.28498, 21.54653, 17.01575],
    [16.40843, 17.14698, 19.22529, 6.97516, 11.17267, 18.02164, 23.79269, 23.61568, 14.49126, 15.58504],
    [6.87078, 12.11264, 20.68102, 7.32246, 24.68627, 7.74972, 22.03116, 11.96188, 24.26634, 9.80117],
    [9.63454, 19.47676, 15.93722, 16.55553, 10.82354, 11.28132, 15.23041, 12.09555, 11.32710, 6.25065],
    [7.32551, 5.46083, 20.28611, 18.18583, 17.16224, 12.81945, 6.23905, 20.34165, 18.33903, 23.26838],
    [22.21793, 22.66350, 23.92575, 18.89508, 8.05734, 17.32887, 12.31529, 9.72549, 8.07077, 18.24931],
    [11.24226, 14.17081, 12.19016, 10.12894, 13.08435, 5.61281, 18.71502, 12.72973, 24.58495, 15.74923],
    [6.78289, 15.94760, 24.10703, 15.31465, 16.69897, 11.34297, 9.56130, 22.81610, 6.23173, 15.73397],
    [10.11429, 21.89810, 21.02161, 12.48680, 24.81384, 17.96609, 7.20283, 6.13102, 21.25294, 14.69329],
    [24.39390, 15.91586, 17.40089, 21.03504, 7.14545, 23.93429, 19.71969, 9.37269, 13.00745, 23.44966],
    [20.69445, 15.42390, 5.30763, 23.03705, 8.90698, 20.52538, 8.79650, 12.17246, 14.76775, 6.92938],
    [6.25309, 23.89096, 5.04151, 6.73528, 14.20743, 20.13901, 9.28602, 15.07172, 5.87588, 15.45381],
    [11.32588, 8.16538, 19.46089, 24.57640, 8.89721, 16.92175, 19.91623, 9.64614, 14.57671, 16.62877],
    [12.31956, 12.58629, 21.12415, 23.42952, 14.97467, 8.30393, 24.36766, 18.16813, 10.35417, 24.34935],
    [6.75054, 8.25205, 22.03238, 22.62932, 14.66948, 8.13852, 15.70711, 8.82763, 12.71935, 9.08460],
    [12.45994, 5.14344, 7.99020, 18.78033, 12.35923, 11.96982, 7.51534, 21.48427, 16.54088, 14.14640],
    [22.01712, 19.29914, 5.89541, 17.41005, 19.06171, 5.19898, 24.47874, 10.66057, 18.75530, 8.44432],
    [5.77090, 19.67574, 15.10529, 22.99982, 9.91897, 7.89132, 16.16916, 19.58785, 10.07523, 9.88601],
    [6.11393, 12.00217, 15.96408, 13.17591, 22.32414, 18.29997, 12.79992, 13.96084, 10.66179, 7.50130],
    [23.68526, 22.43889, 12.02597, 12.42821, 13.60195, 23.31782, 23.32026, 19.29426, 23.14142, 7.14301],
    [5.96072, 14.67925, 10.07096, 18.07840, 5.05127, 20.51256, 6.89337, 13.74599, 12.33909, 17.68960],
    [12.49351, 22.77276, 16.09714, 8.94604, 6.02176, 15.64913, 11.03168, 21.61184, 21.12171, 14.53825],
    [11.36799, 20.87634, 8.63903, 17.65358, 20.21348, 14.18546, 5.93326, 23.82809, 18.33903, 17.39845],
    [20.90869, 12.91223, 5.50233, 23.32209, 8.90332, 7.60872, 17.43324, 23.25617, 10.55620, 12.38426],
    [11.60298, 22.17582, 8.76720, 15.06867, 24.91821, 18.16324, 12.89209, 6.78533, 16.44261, 6.72857],
    [8.28440, 5.81668, 18.29264, 20.63707, 19.31867, 21.04480, 7.81503, 5.86428, 24.00693, 20.58763],
    [24.18149, 24.32188, 8.35215, 21.25416, 22.52129, 23.94833, 18.54411, 24.44517, 8.72021, 6.82196],
    [19.13678, 14.12381, 8.00729, 15.90243, 15.32685, 22.48405, 10.45305, 11.02618, 7.45796, 18.93536],
    [6.51006, 14.78912, 15.87619, 8.03537, 15.71688, 18.93658, 24.26267, 11.99301, 21.69118, 11.88437],
    [19.56648, 23.36665, 16.53539, 17.99844, 16.66845, 23.58028, 7.78268, 9.25794, 5.89053, 12.88720],
    [11.00848, 19.92599, 11.48579, 7.40730, 21.22669, 24.85168, 19.22834, 8.85083, 6.20426, 12.03146],
    [21.22974, 22.57134, 14.81414, 10.05509, 16.10874, 9.55824, 23.54854, 21.05457, 12.63634, 8.00302],
    [14.32707, 19.78866, 14.97955, 10.06058, 6.71453, 9.48805, 17.67861, 9.42579, 17.67983, 15.07660],
    [8.46812, 5.36256, 12.01621, 24.40855, 7.08136, 18.80230, 16.55736, 18.12845, 18.15165, 6.12674],
    [21.29688, 18.80169, 6.33976, 6.29215, 20.55834, 19.91440, 11.81906, 6.87445, 17.31910, 5.39247],
    [14.23002, 24.70580, 23.83358, 20.24705, 23.23969, 6.69012, 21.65822, 22.97540, 23.82870, 6.45268],
    [14.22819, 20.35508, 14.42656, 22.42424, 15.08942, 15.23530, 6.02664, 13.00012, 24.92309, 7.96518],
    [20.40330, 14.39604, 20.48204, 22.08304, 15.54781, 16.82226, 8.57128, 14.88006, 16.46886, 24.59960],
    [8.18613, 23.48140, 19.45906, 15.85421, 13.94436, 7.05206, 7.96518, 7.40059, 23.92880, 15.76937],
    [8.18979, 20.44725, 5.06958, 7.16681, 22.53960, 12.74682, 19.19721, 20.49730, 9.04920, 12.81884],
    [22.87042, 9.71877, 24.91333, 21.86636, 24.13511, 5.74831, 22.23746, 19.00922, 9.30799, 8.58898],
    [14.14518, 15.47090, 22.93268, 19.97177, 19.36262, 13.32911, 14.02188, 17.12439, 23.39900, 14.46257],
    [11.71468, 18.30546, 24.45982, 15.32014, 23.47163, 20.71398, 22.20695, 13.13318, 18.93353, 21.41102],
    [17.50099, 19.20148, 12.57347, 21.87063, 21.23768, 24.86938, 8.25755, 6.79449, 20.41673, 15.82675],
    [18.84747, 17.80496, 19.55977, 20.35447, 23.96542, 12.64245, 5.60610, 7.13569, 19.05072, 10.50676],
    [14.40947, 18.27189, 18.83038, 14.14274, 6.95746, 13.10755, 8.32408, 9.32020, 13.45302, 8.51024],
    [24.51964, 12.31590, 13.35963, 11.21418, 21.83035, 6.02603, 9.55702, 7.86386, 24.47630, 15.34455],
    [24.72045, 8.37413, 18.89325, 22.41508, 18.04971, 8.23740, 9.31532, 12.39830, 10.48051, 5.40345],
    [9.64064, 10.36821, 16.48900, 17.34840, 14.71404, 19.96628, 10.63128, 13.97061, 24.14548, 24.43724],
    [6.92694, 11.92953, 21.79922, 20.67919, 19.22773, 6.05045, 24.06308, 6.91717, 20.67736, 23.43379],
    [20.04074, 14.64385, 10.40666, 15.87497, 16.77465, 5.43153, 5.57680, 16.23630, 12.64122, 23.26716],
    [6.89947, 14.38749, 12.02780, 23.00348, 15.75716, 18.33781, 24.42869, 5.58412, 11.05121, 16.19602],
    [21.07654, 20.63890, 23.90439, 24.56786, 12.24204, 7.09052, 18.33293, 19.02753, 18.31950, 12.40135],
    [16.02878, 12.28599, 17.82754, 21.06494, 13.35963, 15.67721, 5.44618, 12.99280, 8.72814, 9.58937],
    [23.22565, 22.40104, 8.40403, 18.46721, 18.07230, 17.83120, 8.95581, 16.01108, 8.66222, 13.93277],
    [24.41465, 16.19419, 14.88311, 15.62532, 16.28269, 15.72604, 12.94336, 5.26673, 14.52788, 23.58699],
    [9.27259, 13.45851, 7.66671, 23.25434, 16.33763, 24.10581, 10.08744, 23.25556, 23.48689, 14.36186],
    [24.71618, 21.66066, 5.97354, 20.07920, 9.15845, 20.14817, 5.25941, 7.39448, 23.45393, 13.26319],
    [23.73043, 21.07105, 7.54097, 8.50169, 6.95807, 10.22233, 6.58757, 22.83258, 16.62267, 22.04825],
    [12.28965, 11.29597, 7.22114, 24.19614, 18.27311, 13.29554, 9.69680, 6.38737, 17.72500, 12.20725],
    [15.10041, 21.92557, 21.37623, 13.93948, 21.42018, 19.70504, 23.95383, 20.05966, 16.69958, 7.36274],
    [17.24403, 21.11499, 21.56972, 16.18320, 17.87881, 5.77883, 24.31761, 8.38023, 7.96884, 11.43757],
    [11.62435, 17.40028, 16.72094, 11.84835, 8.08664, 21.84439, 21.15223, 7.49336, 7.65633, 23.65780],
    [14.03043, 14.25687, 10.11551, 11.19648, 17.17078, 16.04099, 5.71963, 17.80679, 8.20322, 16.95654],
    [21.12781, 16.53111, 18.94513, 18.71197, 9.74319, 21.57949, 13.49818, 18.81329, 19.60311, 17.17444],
    [24.20042, 15.21943, 21.91885, 24.41465, 13.54946, 13.06055, 13.41762, 6.76092, 20.23545, 19.05683],
    [15.59236, 24.78820, 17.38746, 19.25336, 23.98801, 20.81286, 21.18824, 5.70254, 10.65691, 24.03745],
    [17.94900, 7.71920, 12.90429, 16.81738, 7.79916, 13.32423, 11.44124, 12.69311, 13.09534, 16.51524],
    [11.08051, 6.80425, 9.68032, 15.97873, 7.09967, 9.30616, 9.12793, 20.87512, 10.38713, 22.42729],
    [10.07767, 9.31715, 14.50529, 11.77572, 6.80486, 15.16938, 17.79458, 12.53746, 13.13868, 8.79040],
    [23.63826, 21.17542, 9.85427, 7.35237, 12.01559, 13.26502, 13.67580, 20.34776, 5.47609, 18.08573],
    [15.99155, 5.91983, 22.64336, 10.59526, 9.43556, 23.64254, 22.38823, 11.41682, 10.43352, 19.35957],
    [11.79220, 15.44893, 15.86093, 7.73385, 21.02161, 19.74288, 21.91763, 8.10373, 18.24137, 11.25752],
    [23.35994, 19.29304, 7.69417, 5.12452, 21.21082, 8.98572, 24.07102, 14.04386, 17.06702, 23.30317],
    [6.28605, 19.44014, 22.13370, 12.19016, 23.80673, 24.99878, 19.11359, 16.26194, 18.62835, 23.21223],
    [5.06897, 10.70574, 16.05686, 15.55818, 13.39015, 11.88864, 7.39204, 16.93701, 22.98273, 22.28141],
    [17.65664, 24.98657, 12.81335, 19.32478, 21.48488, 24.91333, 9.93240, 23.87509, 20.30625, 10.44755],
    [9.09131, 13.83511, 23.93612, 11.56636, 12.09250, 18.61126, 9.71145, 9.58754, 24.98962, 20.01511],
    [22.28935, 10.28153, 21.26270, 15.23164, 7.22724, 15.61129, 9.09558, 7.49092, 21.49281, 24.72961],
    [10.88397, 20.04929, 13.99442, 24.86145, 13.08679, 19.12458, 19.29060, 22.69341, 14.55962, 21.39882],
    [17.58095, 16.89489, 11.49190, 11.71468, 24.11313, 22.39921, 7.06488, 6.59429, 21.12659, 7.06366],
    [23.96298, 9.20240, 15.46602, 11.34236, 7.86508, 11.37959, 14.97833, 11.58956, 20.03403, 8.37230],
    [6.82379, 17.61757, 7.13141, 21.88162, 10.83392, 5.14466, 6.39103, 17.05664, 11.01886, 13.74477],
    [14.25748, 9.06201, 18.38176, 10.93036, 16.63732, 24.83764, 8.13059, 12.99829, 8.87097, 15.67598],
    [24.44212, 23.25190, 23.55831, 6.25126, 15.87924, 18.23527, 14.35514, 15.71688, 14.60601, 22.59941],
    [13.88455, 16.49205, 22.51335, 23.22382, 13.85891, 6.37638, 17.37892, 23.22565, 5.56337, 19.61043],
    [22.20267, 6.46977, 8.81542, 12.49596, 10.81805, 13.22230, 7.52022, 9.22376, 12.92810, 17.54799],
    [19.95895, 23.51680, 11.67440, 7.10211, 21.92434, 21.71438, 16.87231, 15.92563, 10.83514, 22.93573],
    [7.03436, 10.87176, 8.95398, 21.93228, 23.31050, 22.29484, 13.82412, 10.25895, 8.45958, 19.61470],
    [14.06705, 21.40065, 13.99808, 22.39860, 18.64971, 15.45442, 8.62560, 7.56478, 17.75918, 9.01929],
    [11.06830, 23.35810, 23.39839, 5.90213, 20.46617, 10.68987, 7.83517, 14.26664, 7.41585, 22.50481],
    [8.03293, 5.85330, 18.81146, 21.76443, 14.17264, 22.90094, 19.59090, 8.70251, 10.41154, 8.37657],
    [24.52940, 17.95083, 5.98636, 5.16541, 23.18903, 16.18198, 24.79980, 19.81735, 11.16474, 20.87756],
    [11.59688, 16.49510, 10.73992, 10.86261, 22.88568, 16.74535, 14.08292, 9.21522, 20.69201, 10.71062],
    [12.10471, 9.18714, 17.30079, 15.41292, 22.10929, 23.75790, 9.09619, 5.73061, 17.35694, 9.44411],
    [7.62947, 13.70388, 11.66646, 24.99695, 6.03580, 21.77114, 22.18070, 15.59908, 8.92956, 5.58962],
    [23.42036, 23.20368, 23.90194, 12.04550, 15.75716, 13.62209, 22.74346, 8.08054, 21.41774, 21.00391],
    [10.51775, 5.97354, 11.15741, 20.31541, 10.61602, 20.68102, 14.72564, 8.45836, 23.90622, 24.88159],
    [18.23405, 24.64232, 10.11246, 17.33863, 21.57643, 10.63982, 9.55092, 10.20463, 19.00616, 21.55446],
    [13.33033, 10.90106, 16.00314, 7.71187, 20.16709, 24.19187, 5.55666, 18.32072, 7.91574, 10.07035],
    [16.98523, 7.50496, 17.96243, 23.10724, 20.42039, 13.35414, 20.58153, 8.84960, 20.08408, 10.59771],
    [19.40657, 22.93512, 19.47310, 7.54280, 23.11945, 8.50414, 11.58712, 7.89315, 22.49382, 17.58156],
    [17.32276, 8.07443, 20.91723, 12.00766, 5.14832, 10.69658, 16.51036, 9.57839, 15.20356, 24.76745],
    [23.97702, 10.99933, 20.92822, 13.29493, 14.30021, 13.28700, 11.36189, 18.89508, 20.42467, 5.23743],
    [7.23151, 8.03293, 7.02887, 10.59832, 13.94925, 24.51964, 12.53258, 14.54985, 24.65453, 12.89392],
    [21.45131, 19.14045, 16.41331, 22.31498, 15.22980, 23.28791, 12.71752, 11.57674, 19.67574, 12.97754],
    [15.38606, 5.89663, 17.12012, 17.28004, 19.01349, 6.07242, 21.43056, 15.81576, 11.07746, 20.65355],
    [23.99838, 13.28639, 10.84185, 21.74490, 8.82885, 6.70598, 10.16495, 15.06806, 24.86206, 20.94958],
    [9.35499, 24.90600, 13.63552, 18.24625, 11.18366, 24.55199, 20.43321, 17.24708, 6.19388, 12.89636],
    [7.03070, 7.28339, 12.41661, 7.76925, 14.16898, 13.44813, 22.63176, 16.66417, 11.87765, 18.12052],
    [22.28690, 15.46968, 5.77883, 14.56389, 11.21235, 15.83956, 17.48756, 18.21574, 12.24570, 11.81051],
    [7.24067, 11.30085, 19.89486, 6.31474, 16.88330, 6.38737, 12.16758, 8.18918, 21.31764, 24.51537],
    [18.68938, 20.32456, 6.56865, 13.51711, 8.23496, 9.56923, 22.56890, 22.16422, 8.79955, 19.01959],
    [8.79101, 15.75228, 23.33430, 13.31080, 20.87024, 8.76110, 14.26664, 17.54860, 16.30955, 20.21043],
    [19.94247, 20.49486, 7.42866, 7.32795, 16.10263, 22.63543, 19.65682, 23.17927, 5.52065, 19.75570],
    [23.29768, 13.84671, 8.93811, 22.65496, 16.90771, 20.82446, 20.40391, 23.60652, 10.39018, 24.21506],
    [20.16037, 10.21378, 5.94607, 12.38853, 8.18918, 17.26661, 24.99939, 13.69778, 11.55110, 17.22938],
    [19.22651, 15.89694, 8.63109, 19.99313, 13.80886, 8.88012, 23.43257, 22.50420, 21.04236, 16.36021],
    [13.02698, 18.90484, 12.41356, 12.12241, 21.30238, 11.80563, 7.29133, 6.47465, 22.11234, 15.31404],
    [6.33061, 18.51176, 24.97925, 10.44755, 7.74056, 19.83016, 6.44780, 23.55342, 14.51872, 5.31373],
    [20.23972, 8.36192, 10.79302, 16.60985, 9.31227, 22.30094, 15.39033, 13.93033, 12.96228, 17.68349],
    [10.75213, 21.79434, 12.09250, 18.41411, 15.33113, 24.34690, 5.76479, 22.82220, 17.58705, 15.86459],
    [22.17338, 23.25373, 19.71175, 22.08975, 17.14698, 23.04559, 9.19996, 18.00516, 23.32881, 21.51173],
    [6.40568, 17.67861, 23.13044, 7.55379, 6.19083, 21.80715, 8.61217, 12.54173, 21.80715, 18.57707],
    [21.39821, 23.06207, 9.12305, 23.47224, 15.74984, 24.18760, 19.33943, 13.64895, 17.93802, 13.87234],
    [18.28898, 22.51396, 5.02503, 19.10810, 20.47838, 10.11063, 16.18198, 14.45769, 15.97385, 14.96368],
    [19.67635, 13.60683, 18.26395, 22.98334, 8.64452, 14.53642, 11.22578, 19.07086, 8.78185, 8.96252],
    [23.31721, 17.04382, 11.06769, 16.65258, 7.11737, 13.50612, 12.65526, 15.25300, 12.35313, 21.28529],
    [19.05683, 6.25065, 10.51347, 8.06833, 10.73199, 7.68746, 19.20270, 15.86154, 7.22480, 14.25993],
    [24.33592, 6.88360, 11.96066, 15.43062, 8.31980, 11.54500, 10.83209, 12.16575, 22.32780, 24.10947],
    [7.69784, 22.93512, 10.80401, 21.68020, 9.92569, 19.59212, 6.32206, 12.13706, 7.09235, 23.76461],
    [22.91437, 6.63396, 15.98117, 24.37681, 6.00589, 22.29911, 14.98138, 6.92633, 7.08014, 10.75152],
    [21.04297, 15.15229, 21.18580, 18.06681, 12.27744, 15.69918, 15.42634, 11.80746, 9.36415, 6.42338],
    [6.55217, 20.75549, 18.86029, 18.95611, 15.77792, 22.95953, 11.55049, 16.14292, 18.94879, 7.72835],
    [18.96832, 14.99969, 20.18540, 7.20099, 21.19617, 15.79257, 7.13324, 23.10114, 9.08765, 7.88522],
    [15.93356, 24.31883, 14.02676, 12.95984, 24.04782, 20.93921, 8.34483, 16.25217, 19.06049, 10.33647],
    [9.53993, 6.41545, 21.58071, 20.96789, 11.39546, 14.64812, 10.37187, 9.47890, 15.14740, 13.69411],
    [7.83395, 16.77038, 23.81466, 7.36152, 13.95840, 18.61675, 12.81274, 11.16901, 6.88849, 16.49449],
    [19.98947, 14.74761, 18.20780, 24.22300, 8.19346, 6.63213, 21.07166, 16.05319, 23.50948, 12.05527],
    [19.32539, 11.82638, 22.28202, 24.37437, 15.71810, 24.82910, 10.05387, 20.75854, 7.34443, 7.96396],
    [5.54445, 22.75750, 6.43986, 23.87631, 12.78832, 12.37938, 14.64690, 14.63469, 14.56633, 24.29930],
    [8.89111, 16.62511, 10.24979, 24.82360, 6.97455, 16.25095, 11.18488, 18.24625, 11.03168, 12.08518],
    [16.73925, 11.20075, 16.94861, 19.09284, 24.13755, 15.65523, 7.89499, 20.54674, 15.21271, 21.15833],
    [20.08042, 23.26289, 13.19727, 16.97119, 18.85418, 21.78518, 12.67296, 14.70611, 13.29249, 7.13507],
    [15.81698, 12.10166, 7.38227, 5.76296, 18.05704, 8.54686, 15.93112, 24.31333, 16.26743, 13.00012],
    [23.32759, 5.83682, 22.62932, 14.90326, 13.28211, 13.07886, 17.27943, 18.74065, 7.66793, 24.45433],
    [22.87225, 12.84570, 22.58721, 18.34880, 14.18302, 13.09717, 19.78744, 11.36128, 5.87405, 12.11997],
    [21.55934, 6.12369, 11.54988, 14.62127, 7.23212, 14.30509, 17.22449, 9.47829, 19.39741, 10.44633],
    [22.33268, 19.22040, 17.98318, 22.23563, 11.39973, 17.50465, 10.30412, 12.85180, 9.50575, 15.23652],
    [15.21760, 21.01001, 24.65819, 5.94180, 9.49904, 14.31974, 10.20646, 11.02374, 14.57732, 21.59536],
    [10.42497, 15.52461, 11.73666, 19.72945, 22.37602, 15.02594, 23.93246, 20.77074, 17.19092, 24.30235],
    [12.32017, 14.81231, 13.89676, 8.35643, 5.64760, 14.33256, 8.89538, 6.46916, 10.61663, 15.60457],
    [14.23978, 9.87381, 21.34877, 22.79717, 7.82052, 23.69503, 16.07578, 10.40056, 8.59691, 13.76308],
    [19.18561, 9.59975, 19.98276, 8.94726, 16.74169, 14.20804, 14.52971, 19.61104, 23.60225, 11.80563],
    [23.02057, 22.82708, 10.27055, 15.69613, 21.10279, 14.98383, 7.59651, 23.30561, 16.58605, 22.38945],
    [17.44789, 16.65380, 10.52873, 10.51042, 7.49214, 10.52202, 15.23774, 22.47612, 18.19987, 23.94040],
    [22.30888, 7.45369, 20.19944, 20.61510, 23.82992, 9.54299, 10.11185, 13.93826, 19.87228, 17.79397],
    [22.98395, 22.18009, 15.40010, 7.98776, 9.44533, 9.50880, 19.71541, 16.80334, 15.72848, 18.45439],
    [11.56575, 18.97931, 14.64934, 9.44166, 23.04621, 8.12632, 5.70376, 13.01965, 5.40895, 11.78182],
    [12.37999, 10.41032, 9.92080, 21.35792, 14.83062, 8.00485, 6.87201, 7.58858, 6.01444, 21.42628],
    [15.88839, 22.11966, 9.44533, 14.78973, 10.64470, 15.84506, 6.66509, 10.78692, 11.12690, 14.63897],
    [12.56798, 17.20740, 6.55461, 23.08161, 6.69927, 5.53591, 22.08914, 16.82897, 18.66497, 7.24677],
    [12.46117, 14.23612, 15.75167, 23.41182, 15.63692, 7.86264, 10.91571, 13.25892, 9.64370, 6.48808],
    [19.23811, 17.30079, 5.68850, 8.25632, 20.98132, 20.65600, 20.69201, 15.58260, 19.37727, 12.19199],
    [22.35527, 12.44163, 11.26423, 5.11536, 9.89761, 14.66033, 18.70098, 14.62981, 23.58089, 13.84854],
    [19.68001, 18.28776, 6.14444, 5.58412, 6.07120, 14.66704, 9.28663, 22.48222, 6.91717, 5.99063],
    [8.30027, 22.76971, 5.19837, 20.31724, 18.00882, 14.99847, 6.20853, 18.92254, 13.10572, 9.51003],
    [5.65188, 24.50987, 6.03946, 17.28675, 15.59236, 15.85665, 5.56398, 6.80731, 16.38035, 24.53978],
    [9.06934, 19.54329, 12.68029, 19.34858, 11.83554, 14.69939, 21.72536, 14.02432, 6.32328, 23.85311],
    [11.92160, 23.94101, 14.62554, 6.08646, 19.93576, 7.35542, 7.20893, 24.26572, 24.37132, 16.86132],
    [11.07379, 13.06177, 24.18638, 16.65075, 20.44908, 19.37361, 19.95163, 11.23066, 13.14905, 5.73855],
    [6.09073, 21.20777, 5.72695, 17.39296, 12.22129, 11.76351, 10.53545, 23.57845, 21.71987, 9.45814],
    [7.82723, 13.73745, 5.64089, 12.97205, 16.02573, 19.21735, 20.11399, 13.42067, 13.27418, 21.10034],
    [5.33631, 9.86709, 13.41090, 14.79827, 14.30021, 15.65218, 9.47340, 12.02841, 9.36537, 21.16626],
    [7.87179, 10.79485, 14.80987, 8.70190, 6.35197, 14.00479, 23.48445, 24.99145, 18.86944, 7.34260],
    [5.69033, 7.06732, 20.50218, 17.02490, 18.41227, 7.07404, 15.53316, 18.06497, 23.02423, 11.64205],
    [21.81570, 13.67214, 9.59792, 21.46168, 14.55473, 16.40294, 15.94211, 6.67364, 22.62993, 11.70064],
    [19.48469, 23.71456, 20.57848, 14.44121, 10.13993, 9.21461, 9.36781, 19.11054, 22.27470, 16.61351],
    [9.08826, 14.23978, 13.89554, 11.07440, 16.67638, 21.72658, 11.19709, 8.36192, 11.80441, 11.65792],
    [6.58086, 13.27540, 24.06735, 13.27540, 8.27403, 23.28913, 24.56908, 12.68578, 9.68093, 13.00378],
    [15.06012, 17.96609, 16.58238, 5.05127, 17.73659, 22.26981, 20.30869, 23.06330, 18.82122, 5.56581],
    [15.02228, 12.33848, 9.06934, 5.64211, 7.21809, 23.82931, 14.30387, 18.98053, 15.58321, 7.07343],
    [19.12336, 22.15018, 9.32447, 7.69967, 16.89062, 14.32829, 23.10785, 15.11994, 9.14136, 11.58162],
    [16.71545, 16.05136, 7.53059, 13.52443, 17.55898, 19.47981, 21.44215, 12.99463, 14.16837, 8.68969],
    [24.38597, 9.35316, 18.78399, 5.99918, 22.31254, 16.04648, 7.16803, 5.80386, 16.96509, 23.04987],
    [13.78140, 21.57521, 7.39570, 24.81933, 10.42009, 22.42058, 22.77032, 14.37590, 6.46672, 24.85107],
    [9.58632, 14.14945, 18.86517, 15.35371, 6.43315, 24.20164, 9.93789, 9.42518, 9.41481, 18.45805],
    [21.19739, 22.66228, 21.35914, 9.57778, 21.23951, 19.55489, 7.94382, 13.07459, 15.87924, 15.59908],
    [13.86319, 11.32099, 18.62957, 18.35368, 22.15506, 8.06772, 9.65712, 23.06757, 9.81704, 14.08597],
    [21.34571, 8.50047, 22.84234, 14.57427, 18.57646, 8.57128, 23.78475, 18.94635, 11.86972, 5.44069],
    [14.99908, 23.62545, 11.49678, 19.67208, 10.66362, 8.47179, 20.69506, 23.08710, 20.71459, 17.47353],
    [16.10935, 9.93667, 19.82772, 24.30906, 13.58852, 12.02475, 24.55748, 13.42555, 7.45125, 13.39503],
    [11.76656, 17.25318, 21.36097, 10.21683, 21.47206, 20.16648, 18.92132, 11.49129, 17.22571, 9.83535],
    [12.12851, 6.20182, 7.16498, 6.58635, 15.79562, 12.53746, 18.84747, 11.39180, 6.08036, 14.80377],
    [11.00055, 23.11640, 11.24287, 23.66634, 15.31220, 5.64882, 12.74621, 5.32716, 11.38569, 15.54537],
    [24.84252, 15.28352, 7.97861, 10.79608, 10.75640, 22.26859, 13.66420, 11.35884, 23.59615, 18.02408],
    [10.02335, 12.06809, 10.11307, 18.51238, 10.50737, 18.55937, 5.44496, 12.20054, 18.08390, 6.81890],
    [16.95288, 21.03931, 24.80346, 16.99866, 5.28809, 9.76028, 6.39653, 22.10562, 20.81408, 9.12549],
    [15.04669, 22.20573, 23.49544, 8.73791, 23.43928, 24.75951, 24.40062, 5.05127, 23.23298, 21.71194],
    [16.92114, 20.20554, 11.06952, 23.97031, 15.84811, 17.29652, 5.24537, 23.88302, 12.42393, 7.72835],
    [6.17008, 6.35990, 23.49239, 16.24973, 23.74752, 19.24421, 22.88018, 19.31928, 24.78454, 23.56563],
    [13.12891, 22.40959, 23.57295, 14.30937, 5.70009, 11.88742, 8.75744, 12.31101, 7.78573, 7.08625],
    [9.61623, 17.91055, 23.84335, 8.19651, 14.88128, 6.99042, 9.98367, 5.60732, 7.22358, 20.02365],
    [9.33363, 6.31352, 6.52959, 24.74609, 6.50334, 23.02057, 5.08484, 23.09870, 9.27625, 21.56545],
    [7.80404, 23.04193, 15.65340, 12.29209, 20.62120, 5.88443, 14.37223, 20.98865, 20.17014, 9.74502],
    [17.03101, 5.01831, 7.87729, 19.76363, 9.93423, 10.28459, 21.59902, 5.70620, 23.79330, 14.62188],
    [7.91269, 17.57241, 9.40260, 13.27418, 8.20994, 19.83383, 17.41859, 12.05710, 21.69240, 14.93377],
    [10.36088, 23.84762, 18.41105, 16.67150, 24.97375, 14.01395, 5.47426, 24.08628, 13.05139, 10.41887],
    [19.53658, 16.48106, 18.87921, 23.61934, 8.70495, 20.20676, 21.39027, 12.87988, 16.98950, 7.81625],
    [19.17707, 23.64193, 14.40703, 20.24522, 6.48259, 12.05161, 5.88382, 12.60399, 18.29203, 22.19474],
    [22.06961, 14.24833, 12.64306, 11.63961, 5.18372, 23.71822, 8.30088, 10.93768, 13.03919, 9.19019],
    [5.90213, 12.68517, 14.34233, 15.06256, 10.69842, 15.78280, 18.41350, 5.29786, 5.03113, 20.51866],
    [12.44530, 24.14731, 8.65795, 20.09323, 9.42579, 24.88220, 15.05219, 24.21445, 19.85031, 7.16376],
    [21.80532, 20.38987, 10.34257, 13.66298, 23.25617, 8.54015, 22.32658, 6.56865, 23.47407, 14.55412],
    [13.84854, 14.60112, 17.71584, 18.41655, 17.69814, 11.15864, 20.48204, 22.53044, 18.93963, 14.22269],
    [8.30515, 15.86215, 24.98230, 8.64696, 15.38789, 19.52803, 11.31428, 21.45009, 10.21317, 9.45265],
    [16.03000, 10.74419, 11.26301, 21.72658, 6.26286, 18.92621, 9.95804, 16.27293, 9.66811, 10.73687],
    [18.95367, 24.47752, 14.05850, 6.84759, 13.90591, 16.36753, 8.33934, 13.56349, 6.84698, 13.00745],
    [7.84799, 19.29121, 19.28266, 19.69649, 17.24219, 18.39213, 13.13929, 5.62258, 14.04202, 13.03858],
    [7.69295, 5.58596, 5.97171, 13.70266, 20.59740, 9.41115, 5.20631, 8.90820, 21.13514, 14.68657],
    [12.66259, 24.86023, 13.82656, 8.44493, 15.45259, 5.58290, 20.51378, 13.41884, 10.62578, 14.19523],
    [19.03851, 24.48485, 18.32743, 5.93692, 6.65960, 10.93219, 17.49123, 13.58303, 6.31230, 10.18021],
    [7.20405, 15.86459, 23.84518, 8.55663, 6.84942, 9.51918, 14.36247, 14.77935, 18.17423, 15.60762],
    [5.79348, 21.75466, 22.39006, 20.70055, 17.80557, 22.32353, 15.43733, 23.58516, 24.20347, 14.57488],
    [14.54314, 8.09824, 16.92358, 22.35710, 19.18989, 12.71996, 19.75875, 6.60649, 19.62203, 17.54494],
    [9.93118, 13.12647, 16.01962, 19.26801, 15.64547, 12.43065, 21.45985, 14.80132, 7.73995, 17.28675],
    [11.79220, 24.14548, 13.56838, 13.57509, 15.55330, 13.14539, 11.22700, 10.10025, 7.04474, 6.75665],
    [12.26524, 22.96564, 15.70223, 13.44203, 10.99567, 20.14573, 14.87518, 11.32466, 8.52428, 21.88040],
    [23.15058, 16.72704, 9.64492, 22.51396, 21.33351, 5.71535, 20.69811, 9.40138, 18.22611, 9.27992],
    [6.53569, 24.51781, 8.31065, 12.76940, 14.71831, 24.37315, 14.48210, 20.20859, 5.05249, 23.89157]
],
    dtype=np.double)
aShekel = np.array([
    [6.96615, 4.56374, 3.80749, 7.42302, 5.16861, 3.25999, 8.68618, 7.24754, 0.22309, 0.78036],
    [9.26481, 2.51930, 4.10901, 7.85272, 8.36482, 4.75875, 7.30796, 2.89865, 6.11469, 2.39326],
    [3.09763, 5.40605, 1.08982, 3.58959, 0.30305, 3.92560, 7.56340, 0.74770, 1.06479, 9.01364],
    [7.93481, 9.46745, 5.19120, 6.42506, 4.39589, 9.79797, 7.65496, 0.87558, 8.89889, 2.58858],
    [0.79592, 5.68163, 5.48448, 8.74691, 7.79595, 8.59004, 4.04096, 4.22040, 8.98038, 9.11496],
    [9.54649, 8.51375, 7.52098, 7.68944, 5.86413, 9.55260, 6.09027, 1.94403, 8.15180, 2.70852],
    [1.03824, 0.43184, 2.94473, 6.79739, 5.65111, 9.10154, 9.98077, 4.85977, 9.05240, 0.83956],
    [4.81948, 2.54311, 2.31269, 3.39518, 6.33259, 1.89062, 8.33125, 5.98773, 8.11457, 3.35520],
    [7.04398, 9.92676, 7.88293, 3.84594, 2.53090, 3.54289, 3.93048, 3.62651, 3.57891, 6.75130],
    [2.69021, 9.86816, 4.26313, 5.55345, 6.47511, 9.68047, 6.11194, 1.79418, 5.45640, 0.42390],
    [8.41578, 8.48720, 2.94473, 0.12177, 8.24274, 6.01428, 8.03217, 5.78143, 6.72384, 9.52177],
    [4.65926, 2.43843, 3.17148, 2.81686, 1.17496, 0.73641, 3.58989, 9.08292, 9.44243, 5.85314],
    [5.14542, 3.72051, 7.55913, 5.58824, 3.15378, 9.63408, 5.25620, 0.42360, 2.15217, 0.26795],
    [6.03107, 3.36772, 7.61345, 0.71413, 5.08438, 2.39723, 9.86755, 2.19275, 7.11844, 3.31217],
    [6.79464, 0.22858, 3.06253, 5.80920, 6.84774, 1.83111, 9.78698, 0.59328, 8.97153, 1.98706],
    [1.86438, 0.33601, 0.97720, 4.78805, 9.45006, 2.29316, 2.93741, 9.49278, 1.33183, 5.39689],
    [7.16361, 6.84957, 7.22465, 9.63103, 1.32511, 5.98102, 8.35902, 0.50478, 6.28132, 7.14866],
    [0.43947, 6.43849, 5.17624, 0.70925, 8.02454, 1.86804, 5.36943, 7.57714, 4.39497, 3.88836],
    [9.76196, 1.49663, 5.97522, 5.24247, 9.07498, 8.45210, 5.36729, 1.47008, 1.65380, 3.51085],
    [2.05786, 5.03220, 2.34870, 0.42756, 4.86923, 4.21583, 7.04398, 4.30921, 5.20310, 9.64202],
    [4.39131, 2.66091, 5.15671, 6.17817, 1.31474, 5.12619, 9.55718, 3.07810, 3.84716, 7.22526],
    [5.98743, 0.15473, 9.86023, 8.41487, 1.86468, 2.80068, 5.25163, 9.77386, 2.62764, 3.66802],
    [0.15442, 1.63244, 0.10285, 3.82397, 6.72445, 6.45436, 5.11002, 1.18778, 5.07462, 7.28324],
    [3.36344, 9.06919, 8.91629, 7.07297, 8.74294, 2.61177, 7.46879, 9.20438, 2.98471, 5.96576],
    [5.20310, 4.50880, 5.86627, 7.98944, 5.97766, 5.10666, 4.93576, 9.30265, 3.13272, 0.37660],
    [8.86074, 8.49879, 2.10425, 5.36393, 3.44798, 0.32929, 7.11905, 6.94327, 4.40474, 3.67412],
    [8.53511, 8.05048, 5.89923, 2.10913, 2.38777, 5.28855, 8.98343, 4.88296, 8.70876, 0.23103],
    [8.94528, 1.11881, 0.17182, 9.72259, 5.64470, 5.05020, 7.63848, 5.50127, 5.90381, 5.10178],
    [4.15632, 8.44722, 2.00812, 4.63637, 3.98022, 7.77367, 5.38621, 7.16819, 8.17408, 0.47121],
    [9.52361, 3.86486, 3.35520, 1.31962, 1.18137, 6.14704, 5.15091, 8.77590, 3.97656, 1.19663],
    [2.91818, 7.05679, 3.38755, 3.18888, 7.30125, 9.72503, 7.24906, 8.05872, 7.17887, 5.08866],
    [0.79623, 4.61531, 7.57286, 8.73348, 0.32472, 9.81841, 5.07218, 3.49345, 4.52345, 1.02237],
    [2.34230, 2.17780, 7.54845, 3.01218, 8.27815, 3.36344, 2.89438, 2.63070, 5.36149, 5.56383],
    [2.13324, 8.82138, 0.79257, 0.09369, 7.57469, 0.88870, 2.95053, 7.93634, 2.91818, 2.79824],
    [9.74792, 0.92227, 0.95401, 6.32191, 0.44496, 2.54616, 2.37709, 0.84323, 7.48161, 8.71700],
    [4.77889, 2.63680, 9.89105, 3.76446, 5.87481, 1.43101, 4.85855, 2.01605, 0.03479, 7.07083],
    [8.98953, 0.24506, 2.17597, 4.08734, 5.84094, 1.31748, 8.08100, 6.99454, 1.29246, 4.33912],
    [5.20371, 4.11573, 3.30699, 1.61779, 3.02957, 2.76315, 7.64885, 7.75964, 7.04489, 3.57341],
    [6.12354, 1.20029, 5.38255, 6.81845, 8.89767, 3.49528, 2.20985, 8.49910, 7.46483, 6.67440],
    [6.91214, 9.03928, 9.81597, 3.97443, 3.14127, 2.38777, 4.38307, 4.26557, 6.79342, 8.34437],
    [4.31196, 5.47929, 6.96890, 5.91937, 8.63002, 7.35405, 8.98862, 0.54292, 1.87170, 8.80947],
    [3.51939, 2.93313, 8.72463, 0.26246, 0.87863, 2.43690, 5.25407, 6.19709, 4.57411, 2.65603],
    [3.27616, 8.29829, 3.14707, 2.17170, 9.43571, 4.46944, 4.37666, 8.17835, 5.55315, 4.03790],
    [0.91159, 5.83941, 1.80609, 4.46455, 1.39012, 1.18015, 9.30326, 9.87091, 6.10828, 0.32777],
    [3.61461, 6.69424, 1.30558, 2.90902, 5.82476, 6.78549, 1.12278, 2.42409, 2.66366, 3.25846],
    [1.29978, 1.40446, 2.28614, 9.40916, 3.67443, 4.16639, 7.25517, 6.00940, 5.54308, 4.97696],
    [1.29643, 7.29698, 2.94839, 4.44288, 1.38493, 0.96530, 1.95624, 1.93243, 1.72582, 2.47169],
    [6.97958, 6.84683, 1.19022, 8.97519, 0.22004, 6.55049, 0.77578, 3.21207, 1.28330, 3.77544],
    [2.64260, 2.63161, 1.03183, 1.30924, 7.29942, 4.09162, 8.74050, 6.78274, 0.49348, 9.43693],
    [6.61336, 5.36424, 6.37135, 2.26814, 0.72817, 3.18064, 8.47133, 1.21433, 2.46864, 9.27213],
    [5.10910, 0.02258, 9.50529, 8.89157, 0.72451, 9.77538, 0.39247, 5.96942, 9.74242, 3.54930],
    [1.84149, 7.54723, 4.51918, 8.83084, 2.72774, 7.99829, 3.93384, 7.99310, 3.90423, 5.84399],
    [4.18256, 2.15644, 7.87347, 0.98300, 8.34895, 8.73898, 7.38823, 5.14145, 6.29902, 8.00775],
    [7.04093, 3.35734, 1.47710, 8.95199, 6.90023, 9.31578, 6.15497, 9.78149, 2.26478, 2.33955],
    [1.70141, 3.36589, 8.59066, 8.85952, 5.43504, 2.93222, 5.65813, 6.16077, 0.61922, 8.32240],
    [0.03723, 1.23508, 1.16672, 8.13593, 9.92126, 2.53945, 7.61223, 8.05933, 1.37791, 7.47581],
    [5.91632, 0.70223, 0.09919, 3.41014, 5.66607, 7.24998, 7.69280, 5.03586, 9.23246, 6.24134],
    [6.59108, 5.89892, 8.44295, 9.79339, 2.63680, 6.89413, 0.34333, 2.57515, 9.40458, 9.54955],
    [8.59920, 3.85205, 3.32408, 6.90451, 2.10273, 7.90429, 3.66741, 9.80132, 7.35710, 3.14158],
    [6.46016, 1.39683, 6.18244, 5.21928, 6.38295, 7.71386, 5.32517, 4.46974, 5.72283, 7.03146],
    [9.51933, 2.96640, 4.43800, 5.94562, 4.56832, 1.52501, 0.39796, 4.89608, 2.01056, 1.96173],
    [3.86273, 0.97934, 1.92785, 4.91623, 5.26109, 0.86154, 5.45976, 8.55464, 0.33509, 1.59856],
    [3.59172, 8.46187, 1.70873, 2.18116, 3.77026, 4.04126, 0.94241, 3.61431, 0.91556, 1.72735],
    [0.14344, 0.34333, 4.39161, 0.33021, 7.18589, 0.84201, 7.49260, 8.81771, 3.60576, 0.17212],
    [1.01535, 1.85553, 9.24009, 2.32795, 7.47337, 3.41197, 2.65694, 5.17960, 7.51946, 3.74096],
    [1.46031, 5.82507, 5.13718, 0.05646, 1.51128, 9.16684, 3.16416, 6.21357, 9.14212, 7.52098],
    [5.71154, 1.70110, 5.42009, 4.07605, 9.03714, 5.26872, 6.52547, 8.01263, 7.44255, 3.48979],
    [9.30357, 4.09223, 5.74847, 9.58373, 6.05609, 4.53505, 4.91592, 2.79885, 7.63390, 5.99353],
    [2.37617, 3.68114, 8.89126, 9.43632, 3.62651, 5.52660, 5.56780, 5.75426, 6.66219, 7.34458],
    [6.65822, 4.90402, 5.79913, 8.63186, 1.33030, 1.39592, 6.45650, 1.28056, 4.46211, 3.94391],
    [7.45781, 8.92331, 9.84710, 2.08808, 2.41340, 9.03500, 5.14389, 7.60308, 6.74825, 8.09900],
    [7.62535, 3.50139, 1.93640, 5.15488, 4.78774, 8.44996, 3.50566, 4.03424, 8.89035, 9.40764],
    [4.37361, 9.60417, 9.47905, 0.29817, 0.07721, 8.32240, 2.96487, 9.53215, 7.46269, 8.42677],
    [3.31217, 4.18500, 3.39061, 0.06134, 2.90445, 3.65490, 5.02670, 0.66103, 7.64855, 0.59694],
    [8.27540, 5.89648, 5.37828, 1.96326, 5.91968, 1.50395, 1.62358, 7.94671, 2.03314, 6.30482],
    [1.80303, 1.65197, 4.22071, 1.72521, 3.90637, 7.29911, 0.25758, 8.13837, 0.72604, 9.77569],
    [0.68087, 3.33048, 5.70513, 3.34819, 3.90515, 3.41105, 1.45695, 2.34931, 5.41704, 1.47618],
    [5.02701, 1.64434, 7.61498, 4.33821, 8.95169, 9.70214, 1.85766, 2.63405, 2.18421, 2.06977],
    [9.27946, 4.62569, 9.94415, 8.07642, 1.93884, 9.00388, 6.55385, 8.56563, 0.86398, 7.00858],
    [0.32960, 7.48070, 2.54952, 9.17844, 4.58296, 5.10788, 0.47853, 7.04093, 3.79833, 5.79119],
    [3.22489, 5.05722, 9.04965, 7.93542, 5.69720, 3.13395, 1.71697, 9.10306, 5.09445, 5.01175],
    [9.56816, 4.02478, 8.12769, 2.84677, 4.26222, 8.33155, 1.07517, 3.29691, 4.34736, 5.81866],
    [9.23307, 5.42314, 2.80313, 2.06397, 7.31895, 5.71825, 3.20017, 2.20038, 7.40104, 0.58168],
    [3.53435, 5.66271, 5.90442, 1.54302, 1.79907, 5.72192, 6.26484, 3.55571, 2.35878, 6.61367],
    [8.78689, 1.66692, 7.18528, 6.07990, 4.27412, 6.38112, 1.02023, 6.13025, 2.98959, 3.02591],
    [4.52620, 9.84252, 5.51317, 5.43565, 4.48714, 7.00461, 7.05191, 9.26206, 5.12345, 6.42537],
    [1.77343, 5.22813, 9.58342, 7.70837, 8.72188, 7.63573, 5.67003, 0.31892, 5.87329, 8.43806],
    [4.87320, 2.74422, 3.90423, 2.19214, 8.75942, 9.56511, 6.22669, 2.20344, 1.79266, 9.24955],
    [6.85446, 3.17301, 4.64156, 0.48219, 2.66610, 0.66134, 7.03421, 9.84405, 1.62389, 2.68227],
    [4.23231, 8.64437, 3.51146, 3.73608, 6.17634, 1.73498, 4.75539, 6.59902, 3.37046, 6.10431],
    [3.88958, 2.17750, 8.56929, 2.06793, 9.22849, 2.74178, 8.32606, 4.87381, 5.30656, 8.85189],
    [3.46690, 9.52666, 9.65453, 5.28397, 2.55684, 6.64785, 6.46626, 6.27949, 7.40989, 2.18574],
    [8.72341, 5.41581, 4.71847, 8.78170, 5.34135, 0.42451, 2.85653, 1.61290, 4.89608, 8.25953],
    [7.92016, 6.51784, 2.49428, 0.73366, 8.06879, 3.21970, 1.35289, 6.03381, 0.23286, 1.46184],
    [5.64653, 6.42598, 8.24274, 2.86294, 6.18732, 7.46666, 6.44856, 6.31001, 5.49913, 9.02982],
    [7.89178, 9.69695, 3.85022, 3.46080, 1.08646, 5.82446, 2.80313, 1.17466, 4.48042, 5.27390],
    [7.84814, 9.00693, 2.65114, 4.06171, 6.68050, 1.62877, 3.30576, 8.89737, 4.68551, 1.34709],
    [9.14121, 7.84692, 4.19294, 6.58834, 3.63170, 9.22208, 9.06247, 4.39131, 4.80575, 6.50197],
    [1.16398, 7.21580, 6.07044, 2.10578, 0.31770, 9.37864, 8.15332, 7.82220, 4.24879, 3.43059],
    [1.21586, 4.71236, 0.12696, 1.79205, 1.20914, 0.30091, 4.25245, 3.94726, 9.52696, 5.86108],
    [1.44475, 4.52467, 0.02350, 1.60955, 0.70376, 2.56417, 2.45918, 2.62917, 8.70235, 7.29118],
    [6.42933, 3.32041, 7.67296, 0.70315, 4.84878, 3.20475, 9.25199, 2.29194, 1.04801, 1.88574],
    [0.84231, 6.19892, 8.54457, 5.98590, 6.06189, 6.12995, 7.55181, 5.86352, 5.82873, 8.33613],
    [7.29118, 4.93362, 1.66265, 7.97113, 8.16645, 9.39329, 7.75018, 9.14151, 2.86203, 1.17344],
    [3.34208, 3.96100, 0.43275, 1.92419, 2.04871, 0.92044, 2.44179, 0.84719, 9.58983, 7.88781],
    [5.21317, 4.19050, 6.56178, 0.04761, 7.25944, 9.21354, 7.79321, 8.09687, 5.94836, 0.43855],
    [4.83871, 7.00461, 2.47017, 1.00009, 3.18339, 0.65340, 9.16746, 6.90329, 0.71444, 2.66976],
    [8.29035, 7.00552, 9.02890, 8.75942, 6.24317, 6.53401, 4.12885, 0.85818, 2.37770, 6.94998],
    [8.08222, 8.41456, 6.40248, 9.97284, 8.19605, 7.10868, 3.46629, 8.57814, 5.27512, 0.33143],
    [0.98178, 2.77902, 7.52586, 3.72448, 6.24805, 3.00851, 1.66356, 8.10175, 8.93674, 8.90774],
    [7.79382, 1.06204, 7.50572, 6.33839, 9.62279, 2.60628, 3.59844, 0.43367, 6.56178, 5.06943],
    [3.49651, 7.49199, 9.29258, 2.68258, 0.68270, 3.53191, 5.34715, 1.07578, 8.58394, 2.32337],
    [6.27369, 2.03650, 7.54723, 0.69979, 2.94473, 3.83099, 5.12101, 3.96924, 0.57253, 2.40822],
    [3.69823, 9.23704, 9.99573, 3.79345, 4.58327, 9.44853, 6.79556, 2.98502, 2.55074, 5.96973],
    [4.80880, 9.67009, 9.95148, 2.51442, 5.59587, 6.06586, 4.43434, 8.22993, 0.42970, 7.20542],
    [9.34355, 2.75735, 6.36769, 8.97549, 0.85177, 1.07822, 2.96304, 4.22040, 0.89846, 0.95462],
    [1.19205, 2.22755, 9.98749, 0.78402, 1.14078, 1.90100, 8.91049, 0.67354, 0.03265, 3.94086],
    [3.46294, 4.55061, 7.14377, 2.33802, 1.20701, 6.12171, 7.18009, 0.50050, 4.34797, 6.49068],
    [8.67122, 2.31635, 7.78771, 6.24928, 8.94772, 3.47484, 6.41591, 9.85443, 2.26142, 3.35246],
    [0.70223, 5.10056, 2.61635, 2.77718, 4.65194, 5.50523, 7.86309, 7.98547, 5.18632, 8.41517],
    [6.63137, 6.08142, 7.01193, 6.64754, 4.65346, 2.31452, 2.04199, 6.48030, 2.04596, 4.48500],
    [7.42912, 9.80132, 8.11060, 4.78988, 1.27323, 3.23099, 5.21744, 4.42427, 0.07172, 2.03009],
    [8.33247, 1.24912, 6.96615, 1.60375, 1.75207, 5.83697, 4.85336, 4.41786, 9.60814, 6.20899],
    [3.42326, 5.13627, 1.70141, 6.57735, 4.18622, 1.79388, 1.23661, 0.40254, 2.54646, 5.81896],
    [6.00665, 3.08023, 0.99368, 8.71120, 9.60051, 4.56984, 2.46834, 8.19788, 4.19324, 7.27500],
    [7.96503, 1.67119, 1.48076, 9.49492, 7.43675, 9.72564, 3.31858, 9.74883, 8.06391, 7.60308],
    [8.63369, 2.29682, 8.94681, 7.36290, 8.16553, 9.16166, 6.28712, 8.58669, 3.60485, 8.96786],
    [8.12311, 0.42909, 2.68685, 7.91009, 2.67159, 2.83181, 6.80471, 3.16233, 9.35392, 9.70641],
    [2.70394, 4.04157, 6.55232, 1.90466, 4.82467, 1.23661, 5.17319, 2.78817, 9.84802, 9.41801],
    [2.06977, 4.20301, 0.01068, 3.53648, 2.39265, 5.68316, 6.75802, 4.12946, 4.92843, 4.68337],
    [1.28178, 1.93854, 9.48698, 0.66500, 3.52550, 7.16025, 0.40468, 0.83804, 6.20075, 3.63689],
    [5.22324, 0.37629, 5.39018, 3.30027, 2.60414, 4.92080, 4.29395, 1.18381, 8.54701, 8.17713],
    [1.68340, 6.31123, 4.96872, 2.42409, 1.62328, 8.77865, 9.71221, 4.74807, 6.02649, 8.33918],
    [2.03650, 6.80654, 6.60421, 4.80544, 2.66640, 0.94333, 7.77276, 5.57939, 2.44758, 0.46602],
    [7.07846, 0.62410, 8.68282, 6.88986, 4.70565, 0.19044, 3.20292, 1.97150, 8.63186, 5.60869],
    [1.24180, 7.33970, 6.98294, 8.45882, 5.17197, 9.53459, 4.16639, 8.43501, 2.16620, 3.27128],
    [2.33070, 5.21043, 9.85015, 0.73855, 4.72091, 4.62172, 9.00143, 9.74303, 2.49123, 4.47829],
    [7.36686, 8.51588, 1.53905, 0.31831, 3.65032, 9.99176, 0.91678, 6.41408, 5.74389, 3.37199],
    [9.39268, 2.34535, 2.25501, 5.78631, 1.71453, 0.45259, 1.40202, 1.86377, 1.14872, 4.48103],
    [6.33015, 4.02844, 9.84344, 4.72701, 0.91983, 1.32664, 3.59294, 0.00275, 5.14512, 9.60540],
    [2.55684, 1.73101, 4.04187, 0.84872, 4.49812, 0.47578, 9.35759, 4.48897, 2.10211, 0.23469],
    [7.93420, 8.49971, 0.94424, 0.79073, 5.89557, 3.08969, 9.66124, 3.44798, 2.69478, 4.80605],
    [8.89096, 0.45442, 4.09101, 3.85815, 0.54872, 3.43364, 8.11090, 2.47902, 3.99457, 1.12766],
    [3.06253, 7.13431, 0.65767, 1.77313, 1.66448, 2.38899, 3.68175, 0.41536, 0.34700, 9.25108],
    [4.15235, 6.47938, 7.79412, 5.79455, 0.46724, 1.90497, 1.78442, 2.88553, 2.41615, 5.16160],
    [8.39869, 2.81655, 6.52638, 1.45512, 2.64870, 3.66100, 4.24482, 4.43861, 4.59792, 7.16697],
    [9.51262, 9.73663, 0.03143, 2.99631, 7.29392, 5.60350, 9.73968, 7.12394, 9.63042, 1.01810],
    [6.47572, 7.21030, 0.77151, 6.53737, 3.65581, 2.75887, 7.95465, 8.20948, 4.85641, 2.87149],
    [9.38658, 9.87365, 8.17408, 9.41313, 6.00055, 4.14624, 4.51521, 8.40052, 8.54122, 7.41203],
    [3.87097, 7.42424, 6.54500, 9.13266, 8.64284, 1.92053, 0.77822, 0.78249, 8.08344, 8.10236],
    [5.69506, 4.72854, 2.91116, 5.36119, 3.47575, 8.35994, 4.16517, 5.95782, 6.21052, 3.78857],
    [5.35752, 4.80728, 7.79168, 8.42616, 1.99377, 7.17643, 2.07221, 6.75222, 7.51549, 7.10227],
    [8.86044, 8.58730, 9.73052, 4.34675, 4.30403, 4.18165, 6.79891, 2.69875, 7.23685, 1.43468],
    [6.82577, 7.43645, 8.04132, 5.55223, 0.13489, 4.76119, 1.59337, 6.46138, 8.27876, 1.01871],
    [0.85330, 4.28968, 8.84732, 4.51613, 2.66305, 8.22413, 0.14405, 7.74957, 2.31208, 9.06095],
    [4.78622, 2.85501, 8.43684, 0.75900, 6.29078, 8.09351, 4.81307, 1.31199, 7.71508, 8.18476],
    [0.60732, 8.24549, 6.40858, 6.30024, 5.64562, 9.05850, 3.94055, 0.52950, 2.26539, 1.91839],
    [5.26688, 2.63161, 0.31281, 6.92190, 6.19678, 1.88299, 6.84530, 3.23466, 3.22275, 1.83813],
    [7.10349, 2.42225, 4.77767, 2.80953, 8.31843, 3.28623, 7.97784, 7.88568, 2.90902, 8.51466],
    [9.91943, 5.29466, 2.64016, 8.46339, 7.58599, 4.93057, 0.29756, 2.37831, 5.43352, 1.84851],
    [0.44588, 2.37007, 4.71236, 4.54878, 5.83239, 0.45747, 3.59050, 0.85604, 0.99460, 3.98785],
    [2.14057, 9.21049, 9.64202, 9.74944, 1.25156, 8.17927, 7.36442, 2.08838, 9.53032, 2.00659],
    [6.24042, 5.34196, 7.25181, 5.00809, 2.89865, 5.89953, 1.42491, 2.62703, 6.59963, 4.20576],
    [1.03244, 1.96265, 8.90103, 2.01849, 6.50990, 9.58556, 1.46641, 5.23087, 2.52510, 9.44548],
    [3.58074, 7.57561, 8.12067, 8.69655, 5.93585, 5.51653, 3.28318, 4.23994, 2.24769, 9.64873],
    [5.99963, 7.80297, 5.26902, 2.91025, 8.86563, 2.36610, 8.75790, 0.92746, 9.30509, 7.75109],
    [1.96570, 4.79751, 2.46834, 8.17957, 8.20917, 1.62725, 0.86703, 9.61882, 4.08307, 3.13883],
    [9.80956, 9.72350, 0.88504, 7.65282, 2.69845, 8.18995, 4.80605, 5.76220, 5.25956, 0.32991],
    [7.45293, 5.01267, 2.74972, 1.68279, 3.26853, 3.89782, 9.22575, 6.47298, 5.40605, 0.48311],
    [2.91787, 7.72759, 6.62343, 5.97186, 6.78488, 1.86804, 6.76107, 8.52351, 8.30439, 5.58855],
    [3.36192, 7.64122, 7.56523, 7.82556, 7.00217, 4.43678, 7.72271, 4.64553, 7.88598, 8.08588],
    [6.88009, 9.85046, 5.27757, 3.78796, 5.45671, 9.11832, 6.32557, 2.54524, 8.11029, 0.49501],
    [5.84368, 8.06574, 4.26801, 9.04263, 3.61187, 1.11026, 6.33747, 8.46126, 0.76052, 6.59597],
    [9.65361, 7.49748, 1.79632, 3.75958, 3.22611, 3.94971, 3.83831, 4.70748, 5.35325, 4.08216],
    [9.62127, 1.65014, 3.15683, 0.26429, 5.83148, 8.14570, 0.10926, 4.64248, 3.33872, 4.65590],
    [0.60945, 1.66143, 0.88321, 3.73516, 5.67248, 7.24601, 8.78353, 5.15702, 8.79513, 7.45293],
    [4.22407, 6.29627, 6.05976, 4.41053, 4.69131, 8.07886, 9.53948, 2.35603, 1.11332, 1.80670],
    [8.06391, 1.58025, 7.27012, 7.18039, 4.41511, 3.09763, 7.03696, 6.81784, 3.00882, 1.85125],
    [6.01978, 7.59514, 7.12638, 1.26347, 9.15128, 4.11573, 9.76043, 6.94937, 0.80264, 4.61806],
    [7.13828, 2.40028, 8.98038, 4.63912, 8.98099, 4.45509, 0.16419, 8.74538, 4.56343, 1.36723],
    [6.35853, 5.64013, 8.63979, 1.28269, 0.90365, 6.96432, 6.29200, 3.93933, 4.62844, 5.10025],
    [0.76907, 3.40403, 8.89248, 0.29145, 3.37565, 4.65529, 7.08487, 2.39326, 9.47386, 1.82684],
    [1.14628, 7.56218, 9.66124, 0.92318, 4.66964, 5.20066, 0.18677, 4.82131, 9.14609, 5.46892],
    [1.67028, 3.36894, 4.91836, 2.67403, 0.17914, 6.39515, 3.40495, 4.85153, 9.73724, 2.43934],
    [2.15400, 4.85061, 0.31648, 1.02145, 9.29319, 3.23557, 0.38606, 1.25340, 8.93490, 8.31660],
    [8.06726, 4.61592, 4.10413, 3.62072, 9.96887, 4.70412, 8.74630, 8.12037, 1.76000, 1.76122],
    [5.37828, 9.52177, 9.54436, 4.80850, 9.94934, 5.93890, 6.09302, 9.18546, 0.46968, 6.25538],
    [1.01199, 2.31178, 0.97324, 4.48988, 8.88974, 5.48753, 7.37083, 8.48079, 4.49721, 4.53688],
    [6.76412, 8.19605, 9.10733, 7.11539, 6.77847, 3.98785, 6.98019, 9.48729, 6.47633, 0.09949],
    [6.09577, 0.58992, 5.41673, 3.73791, 2.18116, 6.19617, 2.42073, 5.02670, 0.10407, 0.98422],
    [0.60671, 8.15027, 1.69256, 1.33213, 0.25849, 9.00052, 4.03943, 6.64846, 6.08722, 9.64232],
    [7.36259, 2.04718, 0.44801, 4.90555, 6.47359, 0.18677, 9.08322, 1.41972, 4.92630, 5.07950],
    [0.93814, 4.40291, 5.90106, 5.68499, 8.62911, 2.51473, 8.89065, 2.10486, 1.11423, 6.09241],
    [6.24866, 2.18482, 5.13627, 9.07376, 8.66543, 1.33915, 6.99515, 9.92798, 3.63018, 3.41258],
    [1.21555, 1.89886, 5.94684, 5.38835, 7.67510, 7.88141, 4.35774, 3.75530, 3.74584, 0.23530],
    [3.35032, 5.35081, 3.02286, 0.85635, 4.19630, 0.48616, 7.19565, 1.81127, 4.29395, 1.16977],
    [2.62459, 1.85278, 8.87417, 2.24250, 8.19208, 9.12656, 4.12976, 8.23328, 5.97949, 5.38011],
    [5.83819, 3.75164, 1.34281, 1.99103, 2.52785, 0.22645, 3.94543, 3.12174, 7.26463, 6.80715],
    [6.30604, 6.31611, 7.10868, 8.23359, 1.43437, 5.85009, 4.31410, 7.49626, 6.10858, 9.15006],
    [8.32575, 6.08875, 1.35807, 1.58818, 2.64107, 9.67589, 6.71957, 9.97101, 5.59893, 1.97821],
    [9.82208, 0.02747, 9.15189, 4.69863, 7.86828, 8.22230, 4.69649, 6.29109, 2.57179, 3.18796],
    [0.01038, 7.39158, 5.11521, 7.10532, 6.36952, 5.72222, 2.68868, 2.33467, 9.89929, 8.27967],
    [3.17331, 3.61492, 6.23188, 3.62194, 9.53398, 1.14109, 2.52358, 2.06427, 0.47700, 4.83169],
    [5.89648, 6.59963, 8.94498, 5.10300, 2.37251, 2.35023, 5.00229, 0.45778, 5.35539, 7.37358],
    [4.68001, 7.20328, 7.72546, 2.62062, 1.33854, 1.60955, 6.61367, 3.87341, 1.11423, 9.82513],
    [4.90921, 3.46416, 9.00815, 5.85345, 8.57204, 4.59212, 7.18406, 2.91543, 3.80627, 6.05243],
    [2.03528, 8.49696, 3.16050, 0.18586, 1.58330, 8.40236, 4.61440, 1.86529, 9.76989, 0.12635],
    [2.71950, 1.32756, 9.20835, 0.85391, 5.85101, 8.66878, 8.95322, 0.39796, 8.63460, 2.80740],
    [8.85250, 4.39711, 3.61400, 2.73965, 7.04245, 8.07489, 1.21738, 3.88440, 2.15247, 5.87939],
    [2.08808, 7.34458, 6.77816, 7.31651, 0.83987, 4.88815, 3.78430, 4.28266, 5.30320, 7.46452],
    [2.00629, 0.21851, 0.31709, 0.06989, 2.90628, 6.38844, 0.14130, 0.77212, 4.74807, 5.60198],
    [8.53847, 6.70614, 5.85620, 8.69106, 0.59603, 4.85855, 3.51878, 4.05072, 5.35234, 0.44649],
    [0.09613, 5.56230, 3.27921, 0.70925, 2.90078, 9.20316, 7.69799, 6.91946, 9.40825, 3.66497],
    [4.17768, 2.43171, 4.36171, 5.28733, 6.98843, 9.58007, 0.33784, 2.61757, 6.66402, 3.23069],
    [8.32575, 0.91494, 7.74377, 3.81420, 9.89288, 1.90741, 0.75106, 7.63604, 7.49321, 9.11649],
    [7.47307, 7.28935, 4.48439, 4.05622, 3.60271, 9.97742, 1.41179, 3.63140, 7.80847, 6.55599],
    [0.12635, 4.03211, 1.28941, 9.11344, 2.29682, 1.44841, 6.88620, 9.89868, 3.87799, 4.91531],
    [1.79754, 9.40641, 2.10028, 1.59337, 2.98105, 6.43880, 6.53981, 9.81170, 9.28617, 7.94885],
    [0.83254, 0.16785, 9.38902, 1.48473, 6.59871, 0.01617, 9.59471, 8.04163, 6.13208, 1.63945],
    [0.55849, 8.13593, 5.42497, 9.42930, 7.00247, 8.91812, 4.08582, 6.38050, 9.47569, 5.12986],
    [3.71502, 5.21714, 2.23457, 1.72277, 1.29917, 4.45631, 6.29444, 0.94913, 9.18882, 4.72915],
    [1.72063, 1.73772, 8.21772, 5.66546, 8.22169, 4.16883, 5.53331, 8.65993, 8.10297, 6.85751],
    [3.69457, 5.82781, 0.64852, 0.05982, 2.60048, 0.46449, 1.99225, 2.31666, 0.81484, 9.32402],
    [9.53490, 3.44066, 7.84906, 2.02216, 4.97909, 1.66753, 3.96191, 7.88507, 5.03922, 7.77795],
    [9.04324, 5.54979, 3.88806, 4.00464, 7.14072, 5.63066, 6.40492, 0.53865, 8.19544, 1.76641],
    [6.28803, 7.44316, 3.54564, 0.35768, 8.09076, 4.79171, 6.76290, 4.30830, 7.24845, 8.84335],
    [6.38325, 1.08188, 7.15415, 7.05985, 2.09326, 0.39094, 7.34825, 9.78942, 0.94028, 1.82318],
    [1.88421, 1.41942, 5.11917, 7.72485, 1.93304, 8.81497, 7.90704, 1.64769, 1.68554, 9.85504],
    [9.30357, 7.67876, 1.62297, 9.87915, 7.94305, 0.95553, 8.20917, 8.85739, 0.83468, 4.69344],
    [4.07147, 7.09372, 7.50206, 4.02020, 7.73614, 2.27851, 0.07324, 1.94739, 6.97104, 5.70055],
    [5.89953, 7.77764, 4.81063, 0.43092, 4.24574, 3.26884, 2.31300, 9.29563, 3.63414, 6.86453],
    [7.12302, 5.43992, 1.38951, 1.30070, 1.89428, 3.30851, 1.95746, 4.90860, 1.64129, 2.84494],
    [5.55101, 1.91534, 4.07575, 4.72701, 3.69518, 2.06732, 1.99591, 9.45158, 3.22703, 4.87747],
    [1.78961, 8.07489, 5.31571, 8.81649, 7.11142, 7.43217, 1.06326, 0.75808, 1.79785, 7.63695],
    [0.25239, 5.98956, 1.08768, 4.67940, 4.79843, 4.10047, 5.19944, 5.93707, 3.47270, 1.06632],
    [4.33699, 1.40507, 9.45891, 2.83212, 9.18760, 8.46431, 7.29942, 0.71352, 5.96240, 2.99417],
    [0.80477, 3.92926, 0.05860, 4.64949, 8.47896, 9.57183, 7.39250, 9.10520, 8.02637, 5.33219],
    [7.47093, 5.09079, 6.50472, 5.29527, 7.26524, 9.02097, 7.68609, 4.10749, 9.94903, 5.03250],
    [3.18461, 9.84222, 7.55852, 3.25175, 8.91812, 0.86367, 1.64495, 4.08918, 3.46324, 7.01254],
    [0.97446, 1.38676, 9.86999, 0.41444, 0.34455, 2.22358, 7.49138, 6.23676, 9.57305, 6.19434],
    [5.39995, 8.69259, 6.72597, 1.97302, 3.94574, 2.61605, 4.65102, 3.97443, 6.02222, 5.91418],
    [4.86618, 6.92587, 4.60097, 3.21055, 7.88049, 1.16031, 8.10114, 5.99353, 3.99976, 6.44795],
    [0.14832, 9.57945, 3.68633, 7.17002, 5.29740, 2.20618, 1.52715, 6.65914, 7.26707, 6.56819],
    [2.88278, 3.50688, 1.26347, 9.10337, 7.27165, 7.66045, 6.94357, 7.34886, 7.55486, 9.11344],
    [3.58806, 0.67507, 8.98679, 7.00980, 4.04309, 4.70962, 7.18986, 1.96936, 8.99289, 4.76699],
    [9.11588, 9.44914, 8.12922, 8.59310, 6.06250, 6.94815, 9.77569, 3.74065, 2.79794, 2.88034],
    [5.53362, 9.88464, 1.86651, 9.91302, 1.50761, 1.39073, 7.12729, 0.59297, 2.67830, 0.45320],
    [5.59771, 8.07245, 1.97851, 6.10767, 1.65868, 9.73998, 0.64394, 9.43937, 2.68624, 6.58010],
    [1.39042, 0.29115, 0.16907, 6.06372, 0.99094, 5.79363, 5.38072, 1.38737, 3.80474, 6.01642],
    [3.66161, 4.87411, 2.83029, 7.06778, 6.37928, 8.34407, 9.83673, 6.94479, 4.62539, 8.27357],
    [1.14231, 4.45112, 3.71410, 8.54946, 0.59999, 6.49190, 2.54311, 8.63460, 6.34938, 4.06171],
    [6.88253, 9.95544, 2.90445, 2.23762, 0.64852, 8.32606, 5.13352, 4.48469, 4.23170, 5.21714],
    [5.69842, 6.59444, 3.93475, 5.68957, 2.50893, 0.56093, 1.59001, 5.79485, 7.76605, 3.71685],
    [8.41151, 7.26646, 5.14145, 3.42692, 2.15033, 2.30445, 6.67196, 2.66945, 1.61260, 6.27400],
    [5.91784, 6.80288, 7.60308, 1.12125, 8.95657, 6.83889, 4.35560, 7.33177, 9.76836, 9.53215],
    [0.51820, 7.22892, 1.58116, 9.59807, 3.74706, 7.43858, 0.73458, 4.37117, 7.97967, 3.32286],
    [4.62447, 6.22089, 7.44285, 3.19956, 0.29237, 3.02774, 6.46596, 5.16099, 5.22568, 2.04566],
    [9.15342, 4.30128, 6.92007, 7.44957, 7.98486, 3.16599, 2.78146, 6.88986, 5.40391, 3.23954],
    [6.91855, 7.36381, 7.45567, 0.27619, 5.39171, 5.71337, 3.54045, 1.29551, 6.48427, 4.06690],
    [1.34098, 6.04724, 7.55333, 5.53331, 0.98910, 0.76266, 5.02640, 0.46266, 7.53197, 7.00369],
    [9.10550, 8.58760, 5.76281, 3.42204, 9.73937, 7.35221, 6.47786, 3.24076, 5.42741, 1.74871],
    [8.21924, 5.27116, 1.42125, 5.97064, 3.57158, 1.27598, 8.88058, 2.18909, 4.06903, 7.49748],
    [1.54698, 6.77969, 2.78085, 3.15073, 1.50578, 9.29411, 8.63369, 3.70830, 0.58504, 4.50453],
    [1.53264, 1.78045, 8.96847, 2.82510, 2.35206, 3.40464, 7.57134, 9.42320, 6.84408, 2.55898],
    [5.75335, 7.33634, 7.54112, 1.70965, 0.92532, 4.90555, 2.70638, 1.20731, 1.60985, 2.83639],
    [6.40004, 5.34349, 0.52522, 1.20304, 8.71761, 7.87744, 9.24863, 1.70385, 0.27039, 4.85153],
    [1.02451, 5.48692, 9.96521, 7.50175, 3.28349, 1.85034, 0.14435, 3.07932, 6.42445, 8.13807],
    [8.15851, 6.39607, 0.43214, 6.13514, 8.42036, 9.90173, 5.89221, 5.28459, 4.01318, 5.11155],
    [0.95614, 8.02881, 1.91229, 3.19529, 0.83346, 7.59362, 0.88137, 7.53471, 1.35960, 3.52794],
    [6.10797, 6.06922, 3.21207, 5.30717, 9.63775, 6.23981, 8.33308, 9.31852, 0.67507, 0.33937],
    [5.11948, 9.53398, 4.80819, 4.09070, 3.94848, 7.19077, 6.22089, 6.25538, 9.59532, 9.78607],
    [1.95685, 2.09235, 2.10700, 4.70199, 2.29835, 8.47743, 2.69875, 7.77001, 6.31672, 3.49193],
    [6.23066, 2.09204, 6.66555, 8.30226, 6.82791, 7.42485, 2.67220, 4.13007, 8.21039, 5.44633],
    [5.79241, 2.14026, 5.28977, 1.21097, 6.49281, 9.04416, 8.60012, 6.11072, 6.61885, 6.24256],
    [8.12159, 2.65023, 6.31581, 5.31693, 8.06269, 6.35456, 9.56236, 7.67632, 9.16074, 5.11399],
    [7.37907, 1.18137, 0.06470, 1.28544, 2.77596, 1.55187, 4.36445, 6.86178, 6.50288, 1.37059],
    [4.82253, 7.01407, 7.65709, 4.49995, 1.38096, 2.33222, 8.22474, 8.71883, 4.49629, 5.06577],
    [5.60320, 4.39650, 0.36958, 9.68108, 2.17994, 2.01361, 9.63652, 3.04758, 6.02100, 6.34175],
    [6.07105, 4.56862, 1.73620, 0.09796, 6.87857, 1.56041, 5.58458, 4.88418, 1.12705, 0.20234],
    [3.87616, 2.22144, 7.88903, 7.36381, 8.74233, 2.49886, 0.65157, 3.62255, 0.32807, 4.64125],
    [9.55992, 2.78878, 9.47508, 4.31379, 8.05139, 8.24335, 9.95239, 3.47423, 5.45366, 1.40477],
    [4.30372, 9.08536, 2.09479, 2.64107, 2.37037, 3.79864, 8.50063, 9.93103, 6.54836, 6.42598],
    [5.23362, 5.59374, 2.85104, 5.00565, 4.94156, 6.40004, 1.83325, 0.28047, 3.17240, 7.36961],
    [8.44111, 2.39967, 9.52513, 4.57533, 4.84817, 8.65291, 5.69018, 7.26615, 5.34776, 5.05295],
    [1.95227, 4.61226, 7.35313, 9.58159, 8.70876, 7.40013, 7.57439, 9.90326, 4.57137, 9.97314],
    [7.43767, 3.36741, 7.61406, 2.74514, 6.79952, 2.10761, 1.32389, 0.59023, 0.02869, 1.05014],
    [1.82684, 7.42302, 3.51238, 1.64525, 7.94000, 2.28309, 8.64895, 9.13480, 0.62258, 7.23960],
    [9.39512, 6.16565, 3.38298, 2.41829, 8.42250, 0.56642, 0.20203, 8.47652, 0.95401, 0.09278],
    [2.54524, 1.82623, 0.33448, 1.96051, 2.01086, 2.92886, 4.40504, 9.97620, 0.19349, 2.96457],
    [6.73940, 7.07602, 2.31025, 9.19584, 1.80486, 6.09119, 6.16413, 4.33241, 8.11609, 6.54317],
    [2.99814, 0.21699, 8.43348, 0.29206, 1.80853, 1.13376, 1.07913, 3.84045, 3.67779, 7.06442],
    [1.42796, 0.11322, 7.68792, 2.19245, 7.63482, 7.52129, 4.97971, 8.97946, 9.66521, 9.12107],
    [2.51900, 3.11502, 5.68743, 9.68871, 3.13150, 9.66308, 4.89303, 3.51299, 3.36985, 5.70666],
    [0.80081, 0.72451, 5.77746, 9.81445, 4.11664, 4.97330, 7.10471, 3.63292, 9.20316, 0.26490],
    [9.04965, 5.92029, 3.22703, 9.77172, 3.07810, 4.33576, 2.04505, 4.42579, 5.88824, 5.29344],
    [1.88757, 4.11451, 7.08274, 7.19657, 0.90945, 9.28098, 5.61083, 7.36229, 9.66430, 5.74938],
    [6.54256, 7.95068, 4.56709, 0.58748, 4.73464, 1.20975, 3.40953, 1.81341, 6.95914, 9.35118],
    [6.98538, 9.76409, 9.04508, 9.36308, 5.89526, 2.93649, 9.60692, 8.08252, 6.58620, 6.11499],
    [6.91610, 7.83044, 5.69506, 3.59264, 0.47792, 7.92596, 6.75344, 5.30839, 3.88195, 2.39357],
    [8.31812, 8.70144, 0.47853, 9.17264, 7.59117, 4.10321, 8.45668, 1.14383, 8.59004, 6.47908],
    [6.87246, 4.28663, 8.93094, 1.32450, 9.20347, 3.27342, 4.28785, 7.54112, 5.97797, 9.82208],
    [4.59029, 5.09079, 3.05612, 4.11237, 1.02115, 0.25269, 7.11264, 4.58357, 7.87988, 6.28956],
    [4.89059, 6.41957, 8.36665, 2.33192, 7.78863, 4.04279, 8.36146, 8.30561, 8.34162, 7.92016],
    [7.24845, 8.69900, 0.15748, 1.00131, 9.85656, 2.99600, 7.87652, 5.09629, 8.57356, 5.57939],
    [8.70754, 2.50618, 9.70244, 2.91818, 2.11402, 3.22398, 3.11258, 0.85543, 9.20530, 3.01126],
    [9.26176, 9.80468, 8.39473, 2.66518, 2.63466, 0.66744, 8.89462, 3.79406, 5.67949, 9.29044],
    [8.60164, 1.40385, 2.28767, 2.26478, 7.94061, 8.61873, 4.89120, 1.89032, 6.22944, 3.83709],
    [4.23322, 3.10892, 2.12378, 5.64867, 5.87970, 0.22492, 4.70687, 5.81225, 2.52846, 6.22333],
    [6.78762, 5.61419, 6.18488, 2.49641, 6.96554, 5.91845, 9.25962, 1.79571, 2.03162, 6.22242],
    [8.65902, 2.21625, 6.25996, 3.02377, 1.92297, 5.03067, 9.15860, 2.82388, 9.47722, 4.18165],
    [8.23908, 0.06500, 2.06061, 0.24903, 8.36848, 5.32670, 7.39280, 6.70095, 4.26527, 4.08643],
    [5.14054, 1.24119, 7.70409, 1.35899, 4.24726, 0.07111, 5.98621, 2.52907, 1.69073, 7.86828],
    [3.24686, 5.68499, 6.72628, 1.30497, 1.15360, 5.77044, 9.68261, 8.91324, 0.56246, 5.86627],
    [9.36888, 5.10666, 0.69460, 5.91144, 8.16156, 1.18198, 7.39463, 4.17920, 8.82412, 1.09806],
    [7.03177, 1.81860, 2.13233, 4.85763, 7.61132, 5.77654, 9.36003, 7.29637, 3.65246, 0.40986],
    [8.69076, 5.09812, 6.40065, 3.10251, 9.62035, 9.84008, 5.93127, 4.19660, 4.40596, 9.89074],
    [6.71529, 6.55660, 0.63295, 8.96512, 3.19864, 5.07035, 3.95398, 4.15235, 6.96860, 1.40751],
    [5.06821, 1.23173, 2.06091, 4.34309, 0.00061, 0.08179, 9.97864, 0.95798, 7.74560, 8.00317],
    [0.97262, 9.03623, 4.33393, 3.76080, 3.16446, 5.95782, 7.39189, 0.16694, 6.05457, 4.41847],
    [0.24659, 8.00531, 9.99268, 0.26826, 9.64934, 9.11802, 8.16553, 2.79763, 6.16993, 1.46733],
    [2.66884, 2.77627, 1.33305, 3.97961, 1.22135, 8.55708, 0.55483, 3.98755, 6.08753, 5.55925],
    [5.94012, 5.08377, 1.76763, 9.44487, 8.00806, 8.19544, 3.02408, 8.29676, 0.40498, 3.69549],
    [9.79736, 4.11420, 6.66982, 7.36076, 0.58168, 8.93765, 3.10923, 7.99066, 0.82186, 5.91296],
    [6.85171, 9.49675, 7.88690, 0.61190, 3.13883, 5.28153, 9.19309, 2.91971, 0.91647, 7.70989],
    [5.03250, 4.79629, 0.79165, 0.49440, 2.67067, 4.23627, 4.41206, 6.80227, 3.27647, 0.72665],
    [9.33622, 0.89602, 8.24580, 2.52449, 8.45332, 6.12384, 6.48427, 1.06296, 8.01752, 7.06900],
    [9.20804, 2.79672, 3.35612, 8.67244, 3.82580, 3.80383, 6.31764, 0.13916, 3.46812, 7.45354],
    [3.51939, 6.44612, 3.72021, 0.44984, 9.46104, 5.25315, 3.12754, 7.57347, 3.55846, 2.04505],
    [9.03134, 0.41810, 5.17380, 1.30253, 5.29893, 0.45259, 5.68743, 6.52333, 3.51238, 1.70537],
    [1.69073, 6.90298, 4.17524, 3.39335, 8.35139, 3.48857, 9.50224, 7.80358, 7.01437, 2.61849],
    [4.35224, 3.74218, 6.11042, 9.45677, 6.87033, 0.86215, 9.42106, 9.44029, 5.39689, 5.18113],
    [0.77242, 0.44954, 3.21116, 1.10416, 9.21934, 3.51115, 7.66839, 0.26399, 3.77483, 4.85061],
    [5.29191, 2.48848, 1.75878, 7.10410, 9.38871, 9.20896, 9.81811, 2.50343, 1.74444, 4.62477],
    [1.68676, 5.84643, 4.96292, 4.93362, 1.74810, 0.06409, 7.01376, 0.93753, 8.45729, 2.19886],
    [4.54878, 4.34675, 6.69057, 2.60414, 6.55110, 3.08023, 3.08634, 5.18082, 4.87777, 5.88763],
    [3.43089, 1.46001, 3.26060, 1.59825, 6.16321, 6.34663, 1.32511, 3.31248, 1.04984, 8.33583],
    [5.19364, 2.84494, 7.10532, 2.01300, 1.23020, 5.73656, 8.80490, 5.65447, 4.49507, 2.14393],
    [4.66811, 1.73467, 8.46706, 3.92102, 7.26310, 3.15989, 7.59819, 3.20383, 8.70144, 3.03232],
    [9.26389, 2.81320, 0.68392, 0.76785, 6.66890, 3.78307, 3.15806, 2.36763, 9.27427, 0.33509],
    [0.65310, 7.66808, 2.30354, 7.60277, 0.35157, 2.37037, 1.89703, 2.42317, 0.96408, 7.67479],
    [7.47154, 2.51045, 6.46413, 5.31602, 7.84753, 4.31593, 3.75164, 0.82980, 2.71218, 4.89608],
    [8.30317, 2.84982, 5.97522, 8.09473, 6.87368, 1.25309, 2.58034, 0.35432, 1.31077, 1.96631],
    [5.33799, 6.47114, 2.54585, 1.24454, 3.33995, 0.59969, 8.82168, 7.23411, 8.51863, 2.82815],
    [7.22282, 1.63518, 1.91137, 6.62954, 2.56844, 9.27274, 6.19800, 7.50694, 2.73110, 8.39015],
    [6.06586, 8.13929, 4.44288, 9.47905, 2.97372, 0.34700, 8.65352, 5.45732, 5.86993, 9.18546],
    [9.50102, 1.00436, 4.43068, 9.47661, 5.95935, 3.87280, 6.38203, 0.10010, 0.22187, 5.98132],
    [5.46251, 6.34816, 1.88971, 7.10929, 1.59734, 5.65630, 2.01697, 8.99838, 9.84008, 7.03146],
    [6.08905, 2.67861, 9.64385, 9.47905, 9.98444, 6.82913, 1.03275, 9.74975, 7.98822, 9.98474],
    [9.22575, 4.71206, 6.91977, 4.40657, 4.27992, 8.67031, 5.43657, 4.42213, 7.32017, 0.93112],
    [2.57332, 7.05191, 9.90875, 3.94299, 4.58663, 7.73156, 8.12342, 7.30796, 4.15754, 8.94864],
    [7.90613, 7.98944, 1.02481, 4.59700, 3.24320, 2.02307, 8.10389, 7.87072, 3.73913, 8.04224],
    [2.15552, 5.50127, 3.14798, 7.93329, 3.07199, 6.15925, 5.42467, 4.93332, 0.83377, 5.82507],
    [9.85870, 4.48134, 4.20820, 7.94824, 1.84973, 8.13440, 0.24751, 1.19968, 0.89541, 5.86383],
    [8.65078, 2.64077, 2.34260, 7.04398, 0.05066, 9.10825, 4.47462, 5.44237, 2.28980, 4.63790],
    [7.49199, 8.52840, 3.74645, 6.73635, 5.95019, 6.40980, 7.77490, 9.31181, 1.21738, 0.71017],
    [7.31956, 5.07614, 5.51317, 8.70266, 3.77117, 5.23515, 4.09162, 3.00668, 9.11924, 9.27488],
    [7.13401, 2.16651, 5.46983, 2.65633, 7.90796, 2.41951, 0.99124, 5.23789, 8.75973, 5.96942],
    [6.34419, 8.22687, 1.50182, 6.07379, 0.66347, 2.48146, 3.75774, 4.26496, 1.15696, 5.97613],
    [7.82281, 0.00671, 5.37461, 3.23191, 3.61248, 8.10907, 0.22004, 4.54054, 2.25135, 4.20728],
    [6.76046, 7.77856, 1.86987, 3.62102, 4.90066, 0.63784, 2.17231, 3.90423, 6.98447, 6.07501],
    [9.33348, 6.39943, 4.38002, 8.79604, 7.79382, 7.10685, 6.12201, 5.59069, 0.50813, 2.18543],
    [3.66070, 7.32658, 4.21735, 8.39228, 0.79257, 5.41276, 1.29765, 3.77728, 2.82479, 0.55391],
    [4.75906, 8.94559, 4.04279, 6.59719, 7.94794, 4.19446, 7.54143, 7.29148, 5.51927, 2.84799],
    [6.47908, 8.77010, 7.24357, 6.09058, 0.82400, 5.56688, 1.20304, 9.61821, 8.64986, 2.98044],
    [7.95251, 7.41935, 6.04053, 3.59966, 2.19092, 2.99753, 4.67940, 0.80020, 3.52245, 3.34666],
    [1.16764, 7.02811, 2.85775, 5.99292, 7.15079, 9.67772, 6.02435, 4.41633, 4.30189, 2.38441],
    [1.14475, 2.16346, 3.23740, 4.53627, 1.34922, 0.96316, 0.41505, 6.82272, 9.37986, 3.16050],
    [2.08686, 5.62944, 5.65355, 3.77758, 9.36338, 4.09497, 6.34571, 2.51656, 3.45347, 2.63955],
    [3.05277, 1.01840, 5.14451, 6.77755, 0.60244, 5.68438, 7.58080, 5.03067, 4.56862, 1.37913],
    [6.40645, 4.74776, 5.05722, 6.32557, 6.33473, 8.65017, 8.32392, 3.50047, 8.20429, 9.91058],
    [2.78451, 8.85037, 5.58672, 8.57967, 0.98636, 1.63366, 5.00809, 7.17460, 4.09589, 7.20634],
    [8.84579, 8.23756, 0.46724, 7.55730, 4.96200, 1.68004, 4.86068, 9.91699, 2.14148, 4.72884],
    [9.86267, 8.73836, 5.38987, 2.27424, 6.07715, 1.37211, 0.15748, 0.44923, 2.65114, 2.74728],
    [9.55504, 1.23783, 4.69161, 9.36552, 3.61400, 0.93448, 9.13999, 7.92444, 4.66720, 0.26215],
    [5.66881, 8.88485, 7.89972, 8.96359, 4.15723, 0.28932, 1.14017, 2.67586, 5.31297, 2.14972],
    [2.95511, 4.90768, 6.00024, 6.71010, 3.10038, 1.91992, 5.83819, 4.90310, 4.40626, 3.33506],
    [6.62954, 4.31227, 0.14405, 6.27705, 1.18717, 8.94681, 5.94714, 5.86138, 3.11380, 6.14734],
    [0.34455, 9.84558, 4.10382, 0.93356, 2.97098, 0.24964, 0.32594, 3.10434, 4.51216, 9.76684],
    [4.45173, 7.40532, 7.45537, 5.76434, 4.88876, 2.07434, 1.69927, 9.70275, 8.78567, 6.08112],
    [4.09284, 4.77096, 0.36805, 0.36500, 5.95996, 9.56114, 1.17038, 3.39732, 7.67632, 0.58840],
    [3.72143, 6.36433, 4.35774, 1.47282, 5.25315, 8.29707, 1.72857, 1.59124, 2.98990, 6.45375],
    [6.22272, 2.01788, 7.58232, 2.26753, 8.38893, 1.55950, 6.24683, 8.17438, 3.65886, 0.70284],
    [2.17780, 5.63128, 9.54192, 6.28254, 1.78961, 9.63927, 3.30424, 4.68642, 6.35273, 0.08271],
    [9.20408, 6.40767, 9.58800, 5.19822, 9.33592, 9.75677, 7.78130, 7.48100, 7.15323, 6.54500],
    [3.97778, 7.35130, 7.72912, 7.55699, 2.82205, 4.88357, 3.81451, 0.61617, 7.60643, 4.91379],
    [1.76550, 9.06369, 6.08600, 5.84094, 6.39058, 3.45805, 6.62893, 7.42973, 8.79055, 4.31166],
    [1.25767, 7.93207, 6.24561, 8.67306, 7.15171, 5.83514, 8.22047, 8.37092, 3.16538, 6.55416],
    [7.53838, 2.73019, 2.93008, 9.37437, 0.80111, 3.57372, 1.10141, 4.96292, 7.10440, 5.31907],
    [4.31196, 8.76095, 9.11679, 7.99066, 3.39335, 0.56032, 5.58855, 5.94867, 8.43318, 5.59465],
    [9.34477, 0.15778, 3.22214, 7.43492, 9.82971, 6.80074, 0.66286, 8.02423, 4.26588, 0.05249],
    [5.69475, 5.14817, 6.49007, 1.82958, 7.30125, 2.66121, 7.52251, 6.32038, 6.16321, 3.77758],
    [6.94205, 2.11615, 9.51994, 2.74453, 9.12381, 9.75219, 9.79553, 5.20280, 3.39824, 7.46788],
    [8.56227, 2.55409, 2.20588, 3.00882, 2.39479, 0.64486, 6.29536, 4.26984, 2.18482, 8.07611],
    [1.03977, 6.60115, 2.47169, 4.45692, 2.92642, 9.58769, 2.35633, 3.91430, 0.28657, 1.11209],
    [4.56252, 4.16211, 7.32444, 1.51799, 4.19965, 6.45772, 5.50920, 5.67797, 3.80078, 6.74245],
    [1.39439, 5.79119, 6.18854, 3.29173, 4.92569, 2.71096, 1.73711, 1.17771, 7.29667, 8.62209],
    [1.59276, 8.86410, 2.42073, 8.87814, 3.41044, 7.23685, 1.07883, 5.81103, 1.17496, 6.39729],
    [1.80242, 2.32673, 5.66668, 0.51332, 7.56066, 8.09687, 7.13279, 6.05457, 2.30873, 6.16199],
    [6.72994, 3.71715, 6.46413, 2.75735, 8.29707, 9.35240, 5.36729, 8.17286, 7.02353, 4.21216],
    [9.79827, 1.46123, 6.57521, 9.82452, 2.60140, 6.80807, 1.23844, 7.80663, 0.49043, 4.36995],
    [4.64766, 9.93744, 5.08927, 3.40373, 1.65593, 8.79086, 2.27180, 0.48799, 4.91379, 4.25306],
    [3.87097, 0.65950, 2.71645, 6.22700, 0.80660, 4.26710, 9.68505, 8.84396, 1.70721, 7.36534],
    [6.83950, 6.48824, 6.07776, 8.45424, 2.63161, 6.95578, 6.08539, 9.37773, 1.49480, 2.04749],
    [6.01764, 3.19620, 1.47832, 0.92288, 3.47942, 6.84561, 7.52373, 6.51631, 1.39256, 1.38981],
    [1.94922, 0.33235, 4.85641, 7.68853, 8.70602, 5.93493, 1.93487, 0.28352, 2.96213, 6.43666],
    [2.43416, 7.32261, 2.58431, 6.30940, 3.72600, 9.32981, 3.07566, 2.81869, 7.69036, 4.63607],
    [2.53212, 7.40349, 7.82861, 4.28449, 8.18323, 2.30628, 0.61831, 4.21705, 1.07395, 2.77444],
    [0.16907, 7.56188, 0.45839, 0.13520, 0.23774, 4.82955, 4.45692, 6.06555, 2.67342, 4.83291],
    [8.55129, 3.36406, 6.34968, 4.14045, 8.47011, 3.54137, 5.64592, 7.87896, 9.03287, 6.53768],
    [2.54494, 9.69543, 5.51469, 2.88064, 1.40385, 3.69182, 9.09055, 3.60149, 0.46358, 6.14612],
    [2.92550, 8.21253, 9.16105, 9.82727, 0.47273, 6.06647, 5.30137, 8.72585, 2.54006, 1.40660],
    [1.15909, 6.00360, 4.68703, 7.42119, 2.56691, 2.97769, 1.51952, 9.61272, 0.05219, 1.95624],
    [9.44121, 3.79772, 6.09149, 0.72970, 4.41939, 9.04843, 7.53746, 1.53813, 6.34144, 0.88504],
    [7.28507, 2.32215, 6.50777, 5.03952, 4.23933, 3.07077, 9.83734, 7.09311, 5.64470, 5.08286],
    [8.33888, 8.30866, 0.84201, 5.94623, 7.41661, 2.96579, 0.51271, 8.05597, 1.57018, 7.51366],
    [0.47334, 3.47850, 1.05045, 6.84805, 4.08429, 2.97647, 6.03595, 8.03766, 2.33497, 2.00568],
    [9.88983, 6.79647, 5.66515, 1.49785, 8.06391, 7.02780, 6.58834, 6.24104, 4.20789, 8.74477],
    [7.17887, 8.66878, 0.04852, 4.68368, 0.48433, 0.87405, 0.59999, 0.91861, 9.92615, 2.65816],
    [1.27049, 1.79724, 5.74938, 8.42402, 8.42494, 4.49934, 2.59041, 0.73397, 9.96643, 3.54228],
    [7.21549, 3.33842, 7.50145, 0.53652, 0.49867, 1.48808, 6.64876, 9.51140, 2.70425, 2.34748],
    [7.05435, 3.11411, 6.12659, 3.31370, 8.67824, 0.00671, 4.16059, 1.06357, 5.90960, 8.76278],
    [0.85726, 9.13114, 6.08203, 8.57997, 0.03296, 6.83462, 3.93872, 2.12531, 7.98914, 7.36503],
    [8.62514, 0.81851, 8.90927, 7.84417, 4.75509, 7.87042, 6.99393, 9.17081, 4.12976, 9.38749],
    [4.39680, 8.46339, 9.65819, 8.85586, 9.02402, 1.91137, 8.04804, 5.31602, 1.25767, 0.85269],
    [2.83029, 0.54292, 3.67077, 8.88333, 4.27808, 5.53941, 2.78970, 2.81442, 7.78100, 1.66204],
    [6.97226, 5.29313, 7.23930, 6.68569, 9.46013, 1.89184, 5.04196, 1.12400, 0.66988, 0.48494],
    [5.18784, 5.11551, 8.78750, 5.72344, 1.11362, 1.18686, 2.71889, 6.41682, 4.79141, 3.21146],
    [6.47603, 8.64254, 8.65963, 6.86758, 9.04294, 2.38563, 6.94601, 1.91656, 8.79757, 4.52956],
    [7.95160, 1.60772, 6.54408, 6.00543, 3.84838, 9.52483, 6.22364, 5.91418, 9.56572, 9.18729],
    [7.36015, 0.43397, 7.31529, 6.71773, 8.30988, 9.32615, 8.32759, 1.88757, 4.37208, 7.84845],
    [8.35444, 7.85516, 9.82757, 6.89627, 8.50673, 4.90707, 7.96228, 9.17234, 7.98425, 8.51497],
    [8.14661, 4.20942, 0.26307, 7.02383, 4.02173, 0.05127, 9.30479, 9.27976, 1.86865, 4.40565],
    [7.34214, 7.51122, 3.20902, 3.08237, 0.81698, 5.77807, 0.71078, 8.53114, 6.01886, 9.29991],
    [1.45665, 6.28681, 0.99490, 4.97269, 6.63656, 2.13965, 5.29466, 8.39412, 1.73009, 7.83898],
    [4.10413, 7.69951, 6.23951, 8.14539, 8.34223, 9.53368, 7.03482, 7.04276, 7.27256, 7.45689],
    [4.37635, 5.92334, 5.20035, 8.10999, 4.67421, 1.55736, 8.81130, 5.44420, 9.04965, 6.66128],
    [6.71987, 8.32881, 1.75817, 0.87466, 7.78466, 1.85156, 7.54082, 4.96139, 9.75829, 7.62383],
    [1.95990, 6.04480, 4.82986, 3.39915, 3.79162, 6.69149, 3.62590, 7.32322, 3.52458, 5.65386],
    [4.22926, 7.12485, 7.03970, 3.08695, 7.78100, 9.56053, 8.52596, 8.04926, 7.22770, 0.42482],
    [1.69744, 1.10202, 0.77395, 0.44099, 3.37504, 9.81811, 6.60573, 7.34184, 8.48964, 0.01190],
    [0.44435, 9.45494, 0.57863, 0.51057, 2.49763, 1.10416, 6.83157, 4.26405, 5.36515, 5.14115],
    [1.74566, 3.62102, 9.46409, 2.91543, 8.46461, 2.57820, 7.53807, 7.00217, 1.84606, 3.81024],
    [4.80941, 6.99271, 2.33894, 3.30119, 6.33869, 3.66710, 4.71755, 0.38423, 8.15485, 1.85583],
    [0.74526, 6.00543, 3.71349, 7.30735, 9.82482, 7.02078, 2.25684, 7.86828, 6.69851, 9.34233],
    [0.62258, 4.29823, 0.26551, 7.74438, 5.07920, 1.02206, 2.56966, 5.14237, 4.73708, 2.13569],
    [2.03040, 9.15555, 3.11106, 2.98166, 9.97040, 8.76888, 9.38322, 2.59896, 4.50911, 8.90500],
    [5.93951, 7.36930, 0.88260, 5.71703, 3.73760, 1.16367, 2.24921, 0.42024, 2.06824, 2.30628],
    [0.04608, 4.46730, 4.27412, 2.66823, 7.96289, 3.88531, 5.98895, 9.20164, 8.58638, 5.58611],
    [7.45750, 3.22642, 6.78610, 3.46232, 6.50075, 7.78893, 8.90072, 7.07785, 3.68877, 8.39137],
    [1.78533, 0.77212, 6.28132, 7.41935, 0.78921, 5.98560, 2.50160, 7.57012, 0.71596, 4.61898],
    [2.70608, 4.59761, 8.83969, 6.24378, 9.00754, 4.68734, 4.02997, 6.96799, 9.92096, 6.77206],
    [1.05716, 2.77932, 1.58940, 5.10056, 4.13312, 5.17045, 2.15827, 2.37403, 8.75149, 1.86316],
    [0.84964, 8.76186, 5.89434, 0.44191, 8.31294, 7.10623, 7.66411, 7.71172, 9.80316, 9.63408],
    [8.40144, 2.58766, 7.75719, 6.48213, 0.35615, 5.33769, 5.32334, 1.35380, 7.97082, 0.97934],
    [7.41386, 4.61562, 9.83917, 9.65423, 0.83743, 9.14701, 2.40425, 1.78259, 0.07691, 9.25901],
    [4.45692, 0.82278, 0.27314, 7.98975, 6.49648, 1.43254, 3.98053, 3.09214, 4.01959, 5.85864],
    [3.25175, 7.02597, 8.79452, 6.36006, 3.61950, 1.26316, 7.18711, 6.47847, 1.53417, 0.22889],
    [9.60295, 8.96939, 1.82043, 5.17563, 0.09980, 3.20475, 6.71743, 3.31736, 0.24415, 9.86419],
    [3.06131, 2.52785, 6.26362, 5.71734, 9.17844, 6.91763, 3.56548, 6.32405, 8.04254, 3.60302],
    [7.68090, 9.45250, 8.26991, 5.97858, 5.69597, 7.03177, 9.50560, 3.80688, 7.23472, 8.45698],
    [3.76598, 5.43626, 9.05515, 3.04849, 9.30540, 2.45857, 2.32063, 4.48897, 8.55770, 2.12622],
    [6.61061, 5.04135, 6.72964, 7.82830, 9.73083, 2.36885, 2.59651, 2.95022, 7.38639, 6.76016],
    [8.06909, 8.42586, 1.78442, 1.58147, 8.09229, 9.28800, 3.21970, 4.76241, 7.43828, 0.54109],
    [3.71410, 4.12763, 5.95691, 7.66137, 6.76931, 4.39222, 8.84518, 2.03345, 2.29469, 8.62606],
    [3.49925, 6.65029, 0.77334, 2.00507, 9.51140, 2.36915, 5.72954, 0.66286, 3.37230, 0.05493],
    [8.55800, 3.44554, 4.44411, 8.91079, 4.78072, 9.39695, 3.76659, 6.31123, 5.79241, 8.77255],
    [2.25471, 9.45708, 5.15366, 0.40712, 9.85687, 4.15296, 3.50017, 3.23679, 2.22907, 1.03153],
    [1.12827, 4.79781, 6.49617, 4.52803, 2.31544, 4.50789, 2.64962, 4.92264, 0.44435, 4.54726],
    [2.16224, 8.76156, 7.99036, 6.14917, 0.36317, 7.97021, 0.43123, 4.11145, 4.15235, 2.96915],
    [8.15241, 7.34611, 1.60344, 0.10681, 5.39323, 8.27418, 5.02884, 8.72250, 0.31465, 8.88211],
    [4.06018, 8.14692, 5.24003, 6.24928, 0.31404, 9.96216, 1.13132, 5.36393, 0.19959, 5.82324],
    [5.37217, 2.03223, 7.43583, 6.16230, 6.90664, 3.70098, 1.83477, 0.07965, 7.81152, 1.00162],
    [5.92242, 1.74474, 5.35112, 7.82952, 5.94653, 3.60729, 3.58592, 2.77017, 8.84915, 1.74291],
    [8.59218, 9.68932, 1.75237, 3.63506, 6.36036, 0.28748, 5.53209, 3.71563, 7.42912, 6.45131],
    [9.02921, 6.96799, 7.32139, 5.19059, 5.47441, 5.91174, 6.84286, 3.99457, 7.67968, 1.27659],
    [1.30802, 9.40580, 3.56120, 1.68310, 2.75246, 6.63076, 8.55739, 2.63619, 4.19691, 2.99966],
    [6.50502, 0.15046, 0.02411, 3.08267, 5.53331, 9.31608, 1.53294, 8.28242, 0.54079, 3.11594],
    [1.72826, 8.70968, 8.81771, 1.81616, 8.41365, 0.15748, 0.37233, 8.22748, 9.64721, 3.98511],
    [9.53093, 9.16135, 0.62075, 2.72408, 9.36613, 8.39290, 6.03259, 9.22178, 5.52232, 1.43437],
    [7.00430, 2.12836, 0.99673, 7.44438, 6.61580, 5.54949, 8.44172, 8.57021, 3.11380, 5.66576],
    [1.54424, 2.05206, 4.86160, 2.14148, 2.05847, 5.39018, 6.08356, 7.13065, 4.03668, 9.88922],
    [7.47978, 9.69085, 1.83447, 2.89590, 0.76205, 8.42097, 3.44707, 4.04340, 1.18015, 0.13550],
    [5.74053, 5.80523, 7.09830, 7.38609, 3.13822, 3.68450, 0.68270, 2.63894, 6.32984, 6.34144],
    [8.77163, 1.93182, 2.55837, 0.97568, 7.97388, 5.81194, 4.05683, 4.27412, 3.07718, 0.37019],
    [6.18641, 4.23872, 2.81381, 6.19190, 1.84851, 3.20597, 2.05634, 8.02118, 3.72662, 7.36839],
    [4.49660, 2.96915, 0.92318, 3.11380, 4.88144, 0.06348, 1.55431, 5.49516, 4.85580, 8.96298],
    [7.86248, 9.13694, 1.48686, 0.63845, 5.41215, 6.90085, 2.52266, 7.84814, 2.93008, 6.61489],
    [7.45384, 8.19971, 4.35347, 1.18168, 8.43593, 7.63207, 9.64415, 2.37892, 0.14100, 7.11417],
    [5.93951, 3.66283, 2.59560, 0.38057, 5.59465, 2.28919, 6.06922, 5.51561, 2.68319, 6.06220],
    [2.07587, 8.19544, 4.51674, 5.02487, 9.55351, 9.40550, 9.74609, 3.40403, 0.27833, 5.43992],
    [9.60906, 2.12195, 2.58492, 3.00333, 3.88165, 7.18497, 7.44316, 7.21641, 8.10419, 4.26466],
    [5.96576, 5.34989, 3.63292, 4.78500, 2.40364, 4.09131, 7.09098, 3.82153, 1.68981, 3.15806],
    [0.77517, 5.13382, 5.59801, 3.07352, 0.58168, 3.63659, 6.57674, 9.91424, 3.01401, 0.62471],
    [3.32316, 4.84024, 7.83532, 2.06763, 7.15476, 1.22929, 7.92840, 5.27818, 3.24625, 7.21305],
    [2.92489, 4.27595, 5.79272, 6.44246, 8.16706, 9.15494, 1.15909, 4.88479, 5.56108, 9.76440],
    [8.08313, 6.47023, 7.89361, 9.02188, 8.98862, 5.39659, 3.15989, 6.16626, 1.47588, 7.90948],
    [0.48189, 5.26475, 4.05225, 1.36357, 4.16456, 9.28648, 5.15976, 3.38786, 7.46208, 5.05387],
    [9.56908, 8.95291, 2.61422, 9.38810, 1.19633, 8.16736, 8.71395, 1.75542, 6.41346, 2.60750],
    [3.96680, 3.73272, 6.90237, 2.99326, 3.91339, 0.59877, 6.12690, 6.02618, 2.16590, 5.37004],
    [8.48140, 3.19834, 5.22904, 0.58779, 5.17319, 9.38810, 7.96472, 8.17499, 5.90930, 4.05164],
    [1.26499, 2.66640, 0.44618, 2.82846, 8.49361, 8.13837, 9.06461, 2.36305, 2.25837, 4.13251],
    [6.03076, 6.16810, 8.08161, 0.90579, 5.11246, 4.33180, 6.52303, 9.30174, 1.20548, 4.88693],
    [0.32655, 5.56688, 7.13706, 9.65087, 8.14570, 6.42109, 9.70550, 2.35237, 1.41575, 4.69253],
    [4.02448, 1.85614, 5.93158, 0.83377, 0.22675, 8.29585, 4.69558, 0.62685, 1.59642, 4.93027],
    [3.59813, 4.39375, 8.18659, 3.53740, 6.49190, 8.02393, 4.99130, 6.15192, 1.22257, 1.12827],
    [8.72860, 0.96530, 3.18125, 2.63771, 2.29835, 5.19883, 7.93603, 9.15311, 0.98209, 2.76009],
    [9.51048, 6.36158, 9.43999, 9.49950, 5.86779, 8.83541, 3.57128, 3.87280, 8.16614, 8.51650],
    [6.30451, 5.83270, 5.34288, 7.20969, 1.37028, 1.74963, 0.59694, 3.39000, 4.12946, 8.18293],
    [1.32572, 8.64040, 3.51238, 2.31086, 9.08261, 4.02722, 4.13404, 1.83721, 1.11576, 1.73559],
    [2.64809, 2.17597, 0.05341, 2.26630, 7.40165, 3.74065, 3.29356, 2.51320, 5.45244, 7.14011],
    [8.66390, 5.03189, 6.01337, 9.09635, 7.91528, 3.81298, 4.38276, 6.90085, 4.60799, 6.87033],
    [5.42985, 4.21552, 7.95740, 0.96042, 0.68697, 6.03565, 9.19462, 8.74111, 8.12525, 5.62273],
    [2.01392, 3.68328, 8.66115, 1.22684, 3.66344, 3.05399, 8.46919, 5.40361, 8.24061, 4.27259],
    [1.15604, 4.74044, 8.75942, 4.96109, 8.86013, 2.80892, 9.54955, 1.99896, 6.33839, 4.14930],
    [5.54918, 9.89288, 7.10746, 2.10456, 0.05524, 3.77575, 5.69414, 8.31355, 7.49443, 7.34825],
    [5.06516, 6.67531, 2.77139, 1.07242, 3.29051, 9.60356, 3.76995, 0.93387, 8.51405, 9.37315],
    [8.55281, 3.08054, 6.28040, 2.37953, 3.83587, 4.65407, 8.29463, 9.12198, 6.29322, 6.12598],
    [6.66280, 7.71691, 3.25632, 5.44816, 2.69021, 3.76659, 4.37086, 9.33409, 4.28846, 4.38124],
    [0.77120, 1.97974, 1.05960, 9.17692, 3.34178, 6.54225, 1.11942, 6.05792, 6.61550, 9.67833],
    [8.72005, 4.59700, 9.88708, 4.46699, 6.73605, 4.82589, 2.08930, 2.02338, 3.07871, 4.24818],
    [2.00659, 7.11417, 5.09476, 0.88656, 0.37904, 8.08954, 1.01840, 5.17991, 5.46617, 6.44642],
    [2.53609, 8.53847, 8.62819, 6.33045, 7.52739, 1.37211, 1.49113, 9.29472, 7.04276, 8.40480],
    [1.25553, 4.62081, 5.58367, 4.08551, 5.71245, 0.52370, 8.74630, 5.90960, 4.52803, 6.54439],
    [7.28782, 8.46431, 8.36177, 2.44636, 1.68584, 6.00513, 2.37861, 3.93262, 6.24531, 6.38661],
    [5.71734, 0.48616, 6.81722, 4.14686, 3.47880, 5.65600, 1.19938, 5.56810, 2.79824, 5.09323],
    [6.26789, 3.52184, 9.55809, 2.65908, 0.91433, 4.91134, 7.31101, 9.90631, 8.84640, 8.52412],
    [4.97269, 9.25413, 0.30854, 6.10767, 4.84359, 6.16840, 6.80013, 4.48103, 7.52892, 0.65584],
    [7.83563, 1.49052, 5.31175, 3.39030, 3.82336, 3.63079, 0.55055, 6.77511, 4.11878, 8.13501],
    [0.65401, 6.26514, 4.31471, 7.34916, 6.20258, 2.25257, 1.83386, 8.20978, 3.77667, 7.83135],
    [3.88440, 4.62447, 0.05646, 2.75277, 6.84103, 5.58031, 8.74966, 8.88760, 1.11301, 6.78518],
    [6.91610, 7.50023, 0.56734, 8.65810, 2.25043, 3.65642, 0.55910, 8.47743, 7.88354, 8.06940],
    [3.64208, 9.50407, 6.26240, 1.69927, 7.01621, 4.88907, 8.68221, 3.42326, 0.77578, 9.17875],
    [2.01636, 6.07898, 1.02145, 5.22904, 9.22575, 1.20334, 6.89688, 9.34477, 5.18906, 7.77459],
    [5.61419, 2.45186, 4.43922, 5.26841, 4.53139, 0.11811, 2.34626, 6.34602, 4.34126, 9.23551],
    [6.32862, 9.48271, 2.43721, 4.17035, 8.63948, 6.84744, 0.51698, 0.20631, 7.30186, 7.75536],
    [5.48723, 7.07816, 6.74978, 2.99112, 7.73095, 0.41810, 4.73800, 0.33082, 5.80157, 3.92712],
    [7.08518, 6.56240, 1.60405, 0.07660, 6.80990, 6.32618, 5.12986, 2.16254, 9.22483, 3.08267],
    [2.79885, 5.51683, 9.55107, 2.52083, 8.48537, 0.69094, 4.61318, 3.72387, 1.27476, 6.42872],
    [5.17930, 8.39625, 9.02676, 5.23087, 0.50752, 3.47331, 1.79754, 9.33561, 1.66478, 7.42271],
    [4.19141, 9.91607, 5.17228, 5.54643, 0.69704, 7.31895, 3.55174, 4.60219, 3.07810, 5.14542],
    [4.32356, 2.05176, 3.87432, 5.99597, 4.02753, 0.25361, 5.07981, 1.68554, 8.82534, 0.90487],
    [6.05945, 5.74572, 8.24488, 0.05463, 9.76623, 1.02237, 3.63506, 8.99228, 1.32023, 0.18586],
    [7.88903, 1.32908, 8.01721, 1.96203, 7.99799, 1.58452, 4.81948, 0.89908, 7.00156, 5.58672],
    [4.40474, 3.48277, 6.89352, 8.00287, 5.82202, 8.40999, 9.04843, 7.31193, 0.82675, 3.83648],
    [3.72936, 3.53008, 1.95379, 9.41038, 5.24094, 9.00357, 1.38951, 5.90045, 4.28816, 7.57775],
    [4.70962, 0.23774, 4.10627, 2.46254, 8.53999, 8.77895, 1.92175, 8.09717, 6.20960, 6.60176],
    [2.30781, 6.33320, 0.44893, 5.65386, 3.99731, 2.24586, 7.20847, 9.55779, 6.71468, 9.88952],
    [9.64476, 7.88812, 9.59136, 3.30088, 6.35273, 7.73705, 7.72301, 3.07657, 2.89346, 5.37492],
    [8.43684, 3.82214, 0.68789, 5.82202, 3.82550, 2.79824, 2.33528, 3.14188, 1.11637, 5.06729],
    [7.41874, 9.27213, 7.43248, 5.45701, 7.86493, 4.19996, 0.51057, 2.65542, 6.91336, 5.30107],
    [1.94159, 5.74267, 0.76418, 8.64742, 4.48988, 8.48170, 6.96341, 0.10346, 0.05829, 1.67089],
    [8.58730, 9.01914, 9.86206, 8.88058, 8.29218, 2.33100, 3.36680, 5.87390, 1.29002, 1.88971],
    [7.56676, 9.04019, 1.31077, 2.81930, 3.14920, 3.13700, 8.61690, 5.72558, 9.12168, 3.66680],
    [4.12824, 0.56459, 2.45582, 4.19050, 8.72921, 4.98428, 4.31623, 3.89843, 1.80609, 4.94949],
    [9.42808, 5.74664, 8.09198, 0.46754, 0.15839, 0.46937, 6.86941, 4.22071, 1.86407, 6.78915],
    [2.60414, 5.92364, 1.06998, 3.12357, 1.06235, 0.21485, 3.04422, 1.11332, 9.98291, 0.89663],
    [0.33021, 6.27888, 8.35810, 9.33531, 8.79757, 6.11408, 3.39518, 9.83093, 2.77352, 0.94119],
    [9.21354, 9.77783, 5.82354, 7.82495, 6.34175, 7.41874, 8.73318, 2.86935, 6.08081, 5.00931],
    [1.26286, 2.20710, 8.78964, 0.20631, 9.23612, 6.98843, 0.16175, 3.49193, 3.51665, 2.68960],
    [4.55336, 4.44288, 2.45003, 8.05231, 9.41923, 4.66170, 4.31806, 3.95764, 9.93103, 0.18128],
    [1.37852, 7.56127, 7.83044, 1.15299, 2.05084, 1.99042, 3.58379, 1.63244, 2.80435, 6.92251],
    [5.89923, 7.27714, 6.32130, 0.35249, 7.67083, 3.76446, 7.48711, 6.86697, 2.41066, 3.74706],
    [3.77819, 2.73141, 0.23133, 5.15488, 1.60649, 3.11106, 7.44133, 8.65658, 5.18235, 1.72704],
    [8.81741, 7.09342, 9.45982, 8.27265, 6.61458, 4.70260, 3.72723, 3.89050, 5.37675, 8.93185],
    [7.40501, 0.03327, 6.61061, 2.66701, 4.61043, 1.01321, 2.38563, 9.68566, 9.05820, 5.55498],
    [1.92267, 1.13895, 5.85223, 7.66717, 0.23194, 5.88763, 1.73711, 2.14087, 2.86630, 2.49306],
    [0.36683, 4.99161, 5.84796, 5.68651, 4.15784, 4.15204, 4.83566, 5.11673, 9.28343, 0.73428],
    [2.59194, 9.20164, 5.37858, 6.16962, 8.81283, 1.88513, 6.51357, 5.53941, 1.38310, 5.12101],
    [4.99680, 2.41066, 3.12387, 4.88845, 4.57564, 5.48723, 3.08329, 3.55663, 4.59304, 2.39051],
    [6.44856, 6.40950, 1.66204, 0.88229, 2.12836, 5.14267, 0.42665, 2.83853, 2.07648, 6.14795],
    [9.96124, 1.29368, 1.41392, 6.38966, 7.38212, 5.86077, 3.41655, 4.69893, 5.22629, 6.84347],
    [8.42647, 1.28422, 4.16242, 3.35398, 0.75289, 3.27952, 7.59728, 5.74480, 2.62520, 9.14182],
    [9.73663, 7.67113, 9.25474, 9.70397, 3.66955, 8.09320, 4.07758, 8.70693, 1.03244, 8.53450],
    [8.23206, 0.61037, 9.81658, 5.90350, 3.33934, 8.50673, 1.88452, 6.19892, 1.64495, 9.93988],
    [6.75710, 9.40031, 2.58919, 3.45073, 3.22794, 0.86764, 9.86175, 3.65856, 5.37828, 9.55596],
    [8.01111, 7.68365, 4.54360, 8.35597, 2.66457, 0.73855, 3.80383, 6.88070, 3.42601, 3.68572],
    [6.55385, 2.00293, 3.50963, 0.38240, 5.71673, 6.46046, 5.17685, 7.62505, 5.16800, 0.83895],
    [5.03403, 5.49974, 9.92676, 9.24802, 8.25922, 0.95920, 6.67806, 3.99792, 5.81347, 2.43355],
    [1.19236, 9.59868, 3.70556, 8.28730, 4.20179, 1.38096, 8.36970, 6.93808, 2.29194, 9.06339],
    [7.21763, 1.44902, 5.38163, 0.57131, 8.42952, 6.40370, 7.34214, 6.42415, 9.04813, 9.88037],
    [1.32664, 9.99878, 5.43168, 8.33522, 6.36830, 3.98602, 5.13596, 7.21091, 6.80960, 8.35200],
    [4.28449, 5.07645, 1.12674, 0.11353, 9.48729, 4.11817, 1.71209, 0.24476, 8.37489, 4.78896],
    [2.17383, 8.02271, 7.80786, 7.42912, 3.71960, 8.12891, 3.82397, 8.67672, 7.18528, 0.81637],
    [2.38746, 5.46983, 2.26691, 0.45717, 4.99832, 4.46364, 0.52767, 2.77749, 8.23206, 9.66826],
    [3.73302, 6.10065, 1.26377, 6.12049, 4.08002, 6.90451, 0.44588, 2.40608, 7.88751, 5.00870],
    [4.99649, 9.84039, 9.30113, 8.70266, 2.86538, 1.12033, 5.58428, 5.12650, 0.83834, 6.26606],
    [0.55116, 6.22211, 7.94153, 8.65413, 7.70837, 5.55742, 6.20746, 8.96603, 9.66399, 6.34754],
    [7.87164, 9.85778, 5.37065, 5.97644, 3.05246, 9.16227, 1.76336, 7.33634, 6.98477, 4.44258],
    [1.35289, 2.29591, 0.86398, 6.70431, 2.33802, 7.60949, 5.37126, 6.08020, 2.80343, 8.57936],
    [0.92990, 7.29942, 5.55803, 0.78738, 3.76873, 7.75567, 5.18235, 5.20341, 1.84423, 5.98529],
    [3.84655, 6.98325, 9.69237, 3.36741, 7.45720, 3.27494, 6.26453, 6.85965, 8.70113, 0.33784],
    [4.81857, 5.58092, 8.54671, 5.29283, 8.91995, 9.05545, 2.76223, 2.81167, 3.61888, 9.92798],
    [5.01877, 2.06305, 5.86901, 8.96664, 3.13547, 4.22254, 3.24137, 5.16007, 0.03357, 5.86291],
    [5.00748, 8.72707, 5.95965, 8.53542, 4.64339, 9.84893, 3.53984, 9.85412, 7.82617, 0.93478],
    [2.22907, 6.39973, 4.97574, 5.23820, 3.71929, 3.74767, 2.41798, 9.62981, 4.86343, 3.94116],
    [1.21433, 4.34584, 9.68413, 5.71764, 7.73766, 7.52037, 7.02658, 7.79931, 5.04318, 7.31498],
    [5.41856, 0.56551, 9.10733, 9.45952, 1.69897, 6.41591, 8.98770, 3.01462, 4.97879, 4.13434],
    [4.97574, 2.17078, 2.49702, 7.57500, 3.79650, 6.89322, 8.93399, 3.97137, 4.92538, 0.22706],
    [5.74297, 2.19153, 7.07602, 5.07859, 2.06458, 6.24439, 8.93124, 8.27540, 3.78613, 4.35194],
    [3.17087, 4.73037, 2.30659, 8.90408, 7.86706, 9.51262, 9.57274, 7.60033, 4.29945, 0.64089],
    [0.94607, 1.09836, 5.26475, 0.41414, 2.46559, 7.47917, 2.93374, 8.08771, 4.06598, 8.83786],
    [0.32136, 1.70965, 5.31602, 0.31922, 5.43474, 1.93304, 5.24003, 6.90756, 2.15674, 5.60930],
    [2.78237, 8.27784, 6.93381, 1.97943, 9.47935, 7.03269, 5.32243, 9.28007, 0.90152, 0.62593],
    [7.46605, 4.56618, 8.42708, 2.29194, 6.55721, 4.57350, 7.90918, 1.29093, 9.35270, 0.42482],
    [6.80319, 7.78283, 2.79794, 4.00098, 6.30909, 2.64321, 5.83392, 8.77956, 0.10071, 7.53349],
    [0.43489, 2.96152, 6.19495, 5.53575, 0.95279, 7.69738, 3.53099, 7.66869, 5.82141, 8.21741],
    [9.81903, 5.59313, 0.68667, 0.69124, 2.21839, 5.82293, 7.02933, 2.61971, 7.41417, 5.75091],
    [5.33067, 9.57244, 2.64595, 6.80502, 6.85965, 6.08844, 4.26222, 5.04471, 3.12967, 3.54930],
    [5.35051, 4.51186, 7.09830, 2.83517, 9.01669, 3.64818, 5.16282, 4.58144, 8.86868, 0.09186],
    [4.02448, 4.84207, 3.27067, 4.16456, 1.47435, 8.97977, 4.93057, 6.36158, 5.16953, 1.58696],
    [2.37892, 9.16227, 8.45882, 5.25864, 4.90768, 8.46553, 7.32292, 6.02130, 7.52739, 4.96719],
    [7.49046, 8.23756, 7.50572, 0.79379, 5.79119, 6.79525, 9.05301, 1.69958, 4.80972, 9.39238],
    [7.71111, 0.14527, 4.90524, 6.73544, 1.01505, 9.56511, 2.65358, 3.45683, 6.98599, 5.14054],
    [9.77966, 7.57134, 7.01590, 1.39042, 1.63945, 1.27506, 4.71358, 1.88726, 9.31761, 0.91067],
    [7.26890, 1.41728, 4.39711, 8.90133, 0.89450, 5.89404, 0.47121, 5.46831, 6.92099, 0.33692],
    [0.45289, 2.95267, 0.09003, 0.23286, 3.74920, 0.53987, 5.62304, 6.58223, 2.36122, 2.21168],
    [6.61885, 9.95605, 9.97284, 5.73107, 8.34803, 3.86425, 3.08817, 5.47594, 1.00192, 2.75735],
    [8.28547, 6.93197, 7.46361, 4.96414, 4.64339, 5.65996, 7.65862, 5.88885, 5.40941, 8.54518],
    [6.05152, 1.76977, 7.96442, 0.14771, 3.84991, 9.32218, 6.15467, 1.96173, 2.47749, 1.56621],
    [4.04736, 7.39494, 9.87701, 5.16495, 5.17563, 0.28779, 6.21235, 9.57427, 6.33259, 9.77752],
    [0.52278, 3.32347, 9.98077, 9.32127, 4.90158, 7.73888, 4.33485, 2.69570, 7.75109, 3.41716],
    [5.18693, 4.77798, 2.68685, 9.77020, 8.52748, 9.92584, 4.64766, 2.94290, 8.03156, 5.76861],
    [9.77447, 2.42988, 6.47420, 5.21989, 0.62014, 1.68828, 5.12711, 4.52528, 3.25724, 3.07291],
    [0.21332, 0.15870, 7.83990, 2.39692, 0.46999, 2.37800, 9.18485, 3.43516, 4.89029, 8.25343],
    [8.93826, 7.68151, 4.69985, 1.98126, 5.88214, 9.67193, 8.63887, 5.29618, 5.95264, 3.18735],
    [5.60381, 5.79089, 8.52229, 8.64803, 3.71593, 5.96210, 0.52095, 7.00919, 9.87823, 0.78921],
    [4.94491, 0.47670, 8.88333, 6.66158, 5.32762, 5.35142, 6.13392, 9.46440, 2.72744, 7.30949],
    [3.04025, 4.64003, 6.79861, 4.44502, 9.15494, 7.03330, 7.50542, 8.37245, 0.10773, 3.33201],
    [9.04599, 8.71059, 5.40666, 4.92172, 2.54189, 1.25797, 5.16007, 3.96039, 9.06400, 5.17228],
    [9.79278, 0.48891, 9.54894, 9.46409, 1.80700, 3.38939, 3.17484, 4.12244, 3.66283, 3.00394],
    [0.75686, 6.18061, 0.82858, 8.22535, 4.72335, 6.03504, 4.07270, 5.87329, 2.23640, 4.33119],
    [0.05615, 5.16861, 3.02194, 4.72945, 4.28816, 5.11704, 8.46644, 2.86081, 5.50645, 7.61559],
    [3.54656, 6.78640, 5.54674, 4.09497, 8.15546, 9.27519, 3.76324, 8.50917, 9.38200, 7.20939],
    [0.06226, 4.48408, 1.31260, 8.43013, 5.61113, 9.44151, 3.91614, 1.34037, 5.28550, 3.50414],
    [7.56829, 7.57042, 0.91769, 6.00391, 4.78774, 3.02408, 9.40977, 7.39463, 5.74145, 7.61834],
    [4.76730, 9.39116, 9.07895, 9.02127, 8.12952, 1.14170, 4.66353, 0.71322, 4.84207, 4.24970],
    [9.76165, 9.67254, 2.64870, 4.45418, 5.24705, 4.00159, 0.05615, 2.78237, 3.39335, 5.81286],
    [8.93826, 3.99060, 3.80566, 9.67406, 0.43916, 5.09781, 9.06247, 1.93670, 8.24335, 1.83508],
    [6.62557, 1.25523, 8.26716, 5.81256, 8.58272, 5.60991, 8.84182, 0.22462, 5.78478, 6.14429],
    [0.44588, 6.90298, 7.93909, 3.13547, 9.05148, 2.52571, 6.22394, 4.40168, 2.14515, 6.80624],
    [9.98321, 1.46672, 1.48869, 0.45991, 4.06659, 3.78948, 1.67943, 5.77349, 8.37794, 6.37196],
    [8.57570, 7.58141, 6.18946, 1.06021, 6.64327, 7.46849, 2.79336, 6.84805, 9.29777, 9.00327],
    [1.04282, 9.49675, 1.29032, 6.82211, 5.35295, 5.78478, 7.21244, 7.37327, 0.72054, 2.69875],
    [5.17106, 4.13221, 8.32667, 6.87857, 9.70672, 5.10239, 4.28114, 4.62600, 3.01035, 5.41551],
    [3.07779, 7.79717, 8.50398, 2.83914, 2.31666, 5.88275, 5.84521, 9.00998, 0.25819, 9.59349],
    [1.42308, 4.19782, 2.77444, 6.26057, 3.40342, 8.42433, 1.25340, 2.36824, 5.38621, 6.73360],
    [8.02728, 3.52489, 7.73980, 1.44200, 0.87771, 7.18741, 0.67446, 9.17051, 3.19193, 8.45576],
    [8.11609, 5.47227, 1.31962, 4.24207, 6.43971, 4.87686, 5.70269, 6.13544, 7.13553, 9.14975],
    [7.33726, 7.26615, 7.45750, 1.59246, 6.12842, 3.48949, 8.12555, 0.18799, 2.70363, 4.19782],
    [2.13935, 7.40593, 0.24476, 3.07321, 3.76995, 9.48119, 7.90246, 4.09497, 1.78777, 2.97861],
    [2.35420, 3.11289, 5.99261, 1.45390, 9.07224, 0.29908, 1.10538, 0.02411, 9.85626, 3.79345],
    [7.08853, 0.66439, 8.20246, 9.84954, 9.95178, 6.03381, 9.06644, 9.79919, 2.10913, 4.65560],
    [4.57900, 9.14640, 6.35182, 5.25193, 2.28889, 9.10062, 2.49275, 3.05612, 7.47948, 5.86566],
    [0.75381, 5.90503, 6.13605, 7.99463, 0.94913, 2.93283, 0.11719, 7.12333, 1.53691, 3.67504],
    [1.09714, 2.39448, 7.59178, 0.39186, 4.83871, 3.88897, 1.76916, 1.42979, 2.36152, 5.36790],
    [7.31986, 8.43013, 9.56755, 1.64983, 7.21488, 5.19639, 1.88574, 0.92502, 8.45149, 1.03641],
    [5.49974, 7.32566, 5.59252, 6.38874, 1.71667, 4.06049, 2.60811, 3.54472, 6.04907, 2.43110],
    [7.08274, 0.28474, 8.56014, 7.03879, 5.84490, 9.23368, 7.04398, 2.49214, 6.08692, 0.75228],
    [9.60112, 1.93609, 1.03488, 2.17841, 8.16980, 2.70730, 4.23322, 1.22562, 9.57579, 9.42930],
    [1.50182, 6.35487, 5.66668, 9.86480, 4.63607, 1.93274, 9.08963, 3.83221, 5.90258, 0.98697],
    [6.27461, 0.50325, 7.40318, 3.37107, 4.18989, 4.38826, 4.35987, 2.15217, 2.42714, 5.32945],
    [6.39302, 6.03442, 7.18375, 2.80740, 5.84552, 0.62990, 8.69839, 9.87976, 7.22373, 6.38936],
    [8.71029, 7.05588, 6.81295, 6.00574, 9.49705, 1.43376, 6.53005, 9.10245, 1.05960, 1.39439],
    [1.07974, 7.02048, 8.01294, 2.18146, 2.47108, 5.51500, 2.74483, 2.66884, 0.96164, 8.17408],
    [6.41133, 8.63430, 6.48915, 8.37275, 4.32051, 2.84738, 9.65423, 2.57576, 7.27897, 7.28996],
    [6.31581, 2.79916, 5.45366, 7.81182, 4.86496, 1.04556, 6.31886, 6.54775, 0.23164, 3.52397],
    [3.24442, 2.39418, 3.69854, 7.46727, 6.29566, 4.87075, 2.57271, 8.35932, 1.79632, 1.66753],
    [8.78750, 0.38728, 2.23121, 5.20127, 0.48860, 7.92596, 3.03598, 8.48445, 5.67583, 0.86978],
    [7.84997, 5.62456, 1.95135, 1.62938, 8.78384, 7.26585, 1.45146, 6.59505, 3.27342, 6.28254],
    [5.01114, 9.88861, 4.07453, 4.04096, 4.63027, 2.21259, 3.96710, 2.53792, 8.30592, 2.60964],
    [1.72735, 2.73476, 6.28681, 5.94317, 0.93387, 4.38887, 2.81838, 3.91461, 8.16614, 7.70898],
    [2.43843, 2.42866, 2.16102, 2.13233, 4.88479, 3.11686, 0.48952, 2.54921, 7.67907, 1.83538],
    [5.31449, 8.27815, 0.45076, 1.94800, 4.79232, 5.10636, 0.05921, 5.20493, 1.68401, 5.71368],
    [0.58107, 8.03430, 5.73382, 8.78292, 7.22190, 6.05457, 1.37944, 2.11737, 8.21711, 4.62325],
    [7.36015, 0.07385, 3.78307, 8.23176, 9.77630, 0.62349, 6.18305, 6.56117, 5.17350, 2.35603],
    [9.96582, 0.01190, 5.20798, 6.73544, 6.44581, 2.51717, 9.45280, 5.92517, 1.48228, 4.45357],
    [7.91589, 1.48930, 0.62166, 3.46324, 9.82391, 4.28724, 0.66744, 5.99780, 0.24049, 0.86978],
    [1.73528, 7.39769, 1.07913, 6.69576, 8.86196, 3.31980, 8.07001, 1.47252, 7.22526, 0.32319],
    [0.24964, 6.94235, 0.04212, 8.43135, 3.53252, 2.41920, 3.20353, 3.47392, 4.92386, 8.39442],
    [5.70818, 2.03192, 8.94406, 3.52031, 9.96368, 6.79037, 2.81808, 5.28520, 1.01108, 5.11093],
    [2.00171, 9.69176, 8.73775, 8.64681, 2.59743, 0.25208, 2.13996, 6.79739, 2.23090, 1.61504],
    [9.70367, 1.82836, 5.94562, 8.12738, 4.95254, 8.46370, 8.67946, 2.65572, 1.24393, 5.75793],
    [0.88565, 5.97339, 4.85824, 4.07544, 8.86288, 2.02368, 0.45442, 4.97024, 6.35029, 9.37712],
    [7.95221, 6.79495, 8.96023, 4.19019, 4.89975, 3.84136, 8.00134, 4.98428, 3.39579, 1.83081],
    [5.25956, 4.54939, 5.62212, 7.56340, 5.30045, 9.29197, 7.05222, 5.54033, 6.85202, 1.33396],
    [1.39988, 9.37193, 9.83123, 3.68419, 6.36738, 0.78127, 9.57915, 3.77941, 4.25520, 4.02173],
    [4.86587, 5.72527, 6.50258, 8.51344, 1.22593, 6.53645, 6.21082, 7.51549, 6.18946, 6.69515],
    [7.71935, 5.64898, 7.96838, 0.33662, 7.29820, 3.07688, 4.16669, 5.37980, 4.00983, 9.15677],
    [2.06671, 8.90652, 4.81643, 3.38023, 7.06503, 8.11151, 2.98105, 6.41011, 0.81210, 2.12958],
    [3.83892, 9.02554, 5.62334, 5.05509, 6.98782, 1.79174, 6.72170, 5.46342, 8.97183, 3.26518],
    [8.87356, 2.75002, 5.51378, 9.54405, 8.98343, 5.60076, 7.36076, 2.98105, 1.20823, 2.89804],
    [8.80673, 2.86935, 6.15192, 2.38655, 2.95053, 5.91082, 0.70498, 7.40165, 2.75948, 9.28434],
    [0.09339, 6.97897, 1.99103, 4.12397, 8.69381, 9.65423, 5.04410, 2.21870, 1.18168, 6.26576],
    [9.79675, 3.74889, 0.57711, 2.07801, 2.49367, 8.86898, 4.74227, 3.52733, 8.75210, 0.95004],
    [7.90277, 9.91546, 9.73571, 4.29823, 8.74874, 5.35112, 7.57286, 4.15326, 1.68157, 1.26438],
    [9.07376, 1.78930, 2.76742, 4.79476, 1.81005, 2.52297, 6.95975, 3.37199, 1.62206, 9.44517],
    [8.15394, 0.80203, 5.61144, 0.68819, 8.63735, 5.16923, 9.68780, 3.04086, 9.49583, 3.86517],
    [4.72640, 9.72137, 8.53969, 6.06250, 0.40254, 5.12558, 7.31101, 7.93939, 0.76510, 4.36048],
    [3.73730, 0.97201, 0.60732, 0.37294, 1.99103, 8.60714, 6.70644, 6.49068, 6.11774, 1.62175],
    [2.98349, 7.18436, 8.99777, 7.49290, 3.65520, 4.86709, 3.20231, 4.07697, 3.43577, 5.53880],
    [5.30656, 2.92489, 8.85067, 1.09317, 0.22034, 2.53365, 9.72716, 1.09561, 7.10440, 6.85293],
    [4.92325, 1.84698, 3.42753, 9.35911, 1.35777, 5.54552, 8.73318, 8.00806, 0.40315, 7.35771],
    [4.67544, 1.37852, 0.70284, 3.21207, 2.88553, 1.32023, 1.47923, 6.13117, 7.23411, 2.41676],
    [5.39109, 3.90423, 2.05023, 3.58074, 5.00412, 5.92822, 2.86050, 2.08533, 1.93854, 2.01575],
    [1.20792, 5.35600, 2.75399, 0.99033, 0.11933, 0.82186, 0.63387, 1.87963, 1.77557, 9.15250],
    [6.93655, 5.51683, 3.95428, 1.17985, 1.66784, 9.36735, 6.80258, 3.83038, 6.94723, 3.38908],
    [6.50655, 5.36760, 2.51808, 9.74090, 7.41508, 5.26811, 7.37877, 4.15052, 9.18638, 9.03653],
    [6.58193, 1.75573, 0.51271, 3.27494, 7.27805, 5.23087, 5.99353, 1.32023, 3.05704, 8.01080],
    [7.71294, 4.75723, 0.65371, 0.42360, 8.08710, 1.12583, 8.07825, 1.55004, 5.54582, 3.13089],
    [8.23542, 4.61226, 9.60570, 9.66948, 7.09586, 8.71578, 6.90115, 3.98572, 0.47884, 4.74685],
    [4.73769, 9.26786, 8.51192, 8.24763, 3.72204, 6.99942, 1.82714, 7.07053, 6.04266, 8.37642],
    [8.56166, 6.63625, 0.95096, 4.10291, 6.21601, 0.59633, 4.01990, 2.87881, 7.44560, 9.72442],
    [1.72521, 3.89233, 3.83221, 6.83462, 7.93054, 3.62560, 6.71377, 0.55696, 3.82183, 2.29438],
    [9.12168, 5.76647, 7.86676, 0.22370, 7.89789, 3.48552, 7.35252, 9.48119, 0.04700, 8.07459],
    [8.07154, 1.07456, 2.39357, 4.51674, 3.71014, 3.03110, 8.59676, 3.61583, 1.51097, 9.66430],
    [2.59499, 7.91559, 5.76373, 7.34733, 2.53945, 6.15192, 5.69292, 7.10227, 4.27503, 9.05728],
    [9.30235, 9.31852, 8.43623, 4.32142, 9.73754, 0.91037, 0.22004, 3.52702, 5.73229, 0.23347],
    [5.89526, 8.86990, 2.69814, 0.06134, 5.11277, 2.47444, 6.02161, 3.94696, 3.08054, 6.12506],
    [3.13089, 6.26972, 1.66356, 4.21247, 5.89526, 1.29154, 3.47056, 7.72301, 9.91638, 1.52715],
    [7.99493, 2.06946, 2.28034, 0.74282, 3.86456, 6.58589, 4.32752, 1.89673, 6.27247, 8.49208],
    [1.00253, 5.33372, 3.64116, 9.14701, 3.35246, 7.54723, 2.59041, 5.39567, 5.72954, 5.81774],
    [5.26688, 3.82885, 4.26344, 9.04477, 8.10144, 0.76571, 8.16797, 0.08271, 6.05213, 5.76922],
    [0.43733, 9.89166, 1.40080, 1.51067, 9.50743, 8.81710, 1.16092, 7.79656, 8.42647, 5.31419],
    [2.16102, 2.56203, 3.11716, 7.42119, 7.86798, 7.65801, 6.27766, 7.30338, 6.01062, 2.22694],
    [8.49086, 4.17280, 1.06540, 1.49602, 3.10404, 5.90258, 0.66988, 3.78887, 6.44093, 4.64156],
    [0.02258, 3.57402, 9.90539, 6.74795, 3.33415, 3.36009, 5.54521, 2.35145, 6.39271, 2.25257],
    [1.63579, 4.85611, 9.30387, 3.98236, 9.84222, 5.69689, 3.46995, 2.21809, 0.52828, 4.66414],
    [1.86956, 5.97949, 7.77459, 1.10477, 6.69973, 2.95694, 0.66103, 6.31825, 3.44462, 3.55785],
    [2.38716, 2.45064, 5.43352, 3.48369, 3.78094, 8.21253, 7.94702, 7.65893, 2.77017, 6.72018],
    [5.93860, 3.31645, 6.37074, 5.77960, 4.43190, 5.05966, 6.75588, 5.92578, 5.65538, 9.70489],
    [7.97235, 6.52699, 1.97699, 3.72539, 4.86251, 5.26902, 8.70540, 1.10477, 0.75533, 1.32878],
    [5.81225, 4.41084, 5.49120, 7.55547, 2.64809, 6.90695, 0.33815, 1.96326, 4.70443, 8.51100],
    [1.36998, 3.85846, 6.49098, 3.41197, 7.85791, 4.90280, 9.58922, 2.16346, 7.24967, 0.43367],
    [9.94415, 6.05762, 3.28990, 1.35105, 3.45439, 6.60024, 8.84915, 1.88177, 3.93048, 7.89483],
    [0.02014, 3.53496, 2.47291, 4.74868, 3.05063, 0.56398, 2.34352, 4.31501, 0.66408, 7.24143],
    [8.38496, 4.08307, 9.34507, 2.26569, 5.05387, 4.02631, 4.13678, 0.60732, 2.13111, 5.72619],
    [2.52693, 8.11029, 2.16803, 6.27949, 3.97382, 9.15891, 8.73562, 9.80193, 6.64113, 2.72317],
    [9.53581, 4.34553, 7.90185, 7.09922, 3.43822, 7.03513, 0.17518, 8.64681, 5.50768, 5.24155],
    [8.65749, 4.84970, 9.07834, 6.60390, 2.50832, 7.00247, 8.94467, 5.70818, 6.06006, 2.83731],
    [4.72610, 0.24232, 1.60436, 4.40718, 8.47285, 4.43495, 0.32899, 1.53386, 5.56719, 2.59011],
    [2.95724, 6.13605, 2.99387, 0.53682, 6.65761, 7.74651, 4.03333, 7.79565, 9.78729, 5.53636],
    [3.44249, 8.28303, 1.02908, 7.15384, 2.18787, 2.36549, 4.48561, 9.69237, 5.79211, 8.07001],
    [7.29148, 3.09854, 5.35569, 4.26923, 1.30985, 1.33824, 5.31571, 3.65154, 5.47349, 1.62420],
    [7.00827, 8.28852, 0.32960, 7.02445, 2.09143, 5.61266, 1.35868, 2.76406, 4.89547, 7.61864],
    [2.62154, 1.52837, 7.76147, 1.09745, 7.30369, 8.08252, 8.42860, 1.72124, 6.71468, 8.52138],
    [3.53862, 9.78607, 4.30830, 4.46059, 7.31285, 0.42604, 6.28498, 7.48100, 9.46715, 6.11927],
    [5.33708, 4.13862, 1.43040, 4.28114, 9.10306, 6.85629, 4.92599, 7.77795, 9.88922, 1.00284],
    [1.97424, 1.15482, 7.22587, 3.48064, 0.39033, 0.40651, 9.81719, 3.12571, 3.82824, 9.08841],
    [8.44600, 8.23786, 0.43855, 8.59279, 6.40065, 1.55400, 9.20377, 5.39567, 8.98343, 7.97357],
    [8.00897, 3.09061, 8.66298, 5.34928, 2.51808, 2.01666, 7.43309, 3.66070, 9.90814, 4.30067],
    [2.94351, 2.87484, 6.53157, 7.11844, 9.95972, 4.81399, 3.56883, 1.99377, 3.71868, 9.33744],
    [9.72777, 2.94504, 6.74245, 0.15320, 5.05875, 1.28941, 5.66973, 0.57314, 4.94644, 9.92218],
    [9.67071, 4.51796, 8.33674, 4.88052, 7.00552, 3.09061, 9.26756, 7.00552, 1.28971, 2.03009],
    [5.76098, 1.51189, 4.03088, 0.35524, 5.14267, 8.28455, 4.99527, 5.51073, 9.84802, 0.70559],
    [6.96951, 5.33250, 2.77932, 5.83361, 6.47969, 2.14087, 6.27857, 3.73821, 7.03085, 9.27458],
    [3.77239, 8.81252, 6.42598, 5.37828, 8.15760, 0.86612, 4.73281, 6.75954, 5.98743, 8.81954],
    [4.45448, 3.11991, 1.52013, 4.80453, 9.47233, 6.98202, 9.69451, 1.49174, 4.31776, 2.11646],
    [2.09082, 0.45045, 0.34333, 1.29002, 4.94827, 4.35743, 0.34547, 8.63704, 3.28959, 0.86337],
    [8.21039, 6.97653, 0.22462, 0.93661, 5.14023, 5.38163, 5.49181, 9.48820, 9.02524, 7.31590],
    [2.30018, 1.09439, 8.52199, 4.64705, 6.53432, 8.63399, 8.40052, 7.85455, 7.38639, 7.64092],
    [7.72485, 7.73949, 3.47453, 4.19965, 7.42759, 8.95047, 3.51299, 9.18332, 8.84091, 0.63967],
    [5.59679, 6.65151, 9.74853, 4.56038, 4.15967, 9.22697, 9.51689, 5.91662, 8.67214, 8.24824],
    [9.87548, 7.28111, 3.13913, 1.52837, 2.89834, 0.89084, 0.46358, 6.51845, 2.76101, 9.63622],
    [0.73122, 1.69561, 2.82540, 2.04962, 7.48741, 3.98694, 4.61989, 1.61687, 1.06326, 5.03983],
    [0.27833, 5.71062, 3.01645, 4.15235, 4.99649, 4.47066, 0.74526, 0.67721, 1.07212, 4.93515],
    [6.34297, 3.71166, 0.08789, 0.73977, 8.75179, 1.88086, 4.80331, 2.69417, 3.28135, 1.03824],
    [7.31315, 0.55116, 7.55333, 2.68136, 5.04257, 1.28025, 7.93085, 0.90823, 1.13254, 4.15479],
    [5.50249, 0.71902, 0.78341, 7.97266, 5.67858, 5.47716, 0.11963, 0.71291, 0.46297, 6.34571],
    [9.13511, 6.95151, 7.46208, 1.50548, 5.28153, 3.33934, 4.69619, 7.97540, 9.26817, 7.46178],
    [5.27329, 3.83679, 9.62706, 0.38789, 0.99002, 3.68694, 7.61132, 8.22657, 8.91842, 5.12253],
    [8.98923, 2.99295, 0.04517, 9.07498, 4.29426, 8.11243, 4.02478, 1.80059, 4.09497, 8.85678],
    [9.10642, 1.35105, 0.84597, 3.04209, 1.29978, 6.32038, 3.88531, 2.28889, 1.84423, 9.69665],
    [9.13755, 9.16074, 7.03726, 5.61937, 0.08576, 0.49623, 9.49095, 1.86285, 1.57811, 2.24616],
    [4.87655, 5.85101, 3.02622, 6.12201, 3.21970, 7.02353, 2.56142, 3.37779, 8.80947, 3.35948],
    [8.71181, 6.03290, 7.78069, 4.87594, 1.15909, 0.84628, 7.43828, 1.90802, 7.14286, 6.36036],
    [6.38050, 0.99246, 5.06790, 8.32057, 9.48424, 6.15436, 1.88574, 3.78887, 6.81845, 8.42280],
    [5.80401, 9.26023, 0.54415, 1.37700, 0.89236, 3.09458, 8.86685, 5.54430, 5.14756, 7.58049],
    [1.09928, 9.45341, 8.57204, 0.93509, 2.90445, 0.16449, 2.84036, 4.56557, 5.77288, 1.08402],
    [9.10886, 5.88824, 9.80132, 9.87335, 5.52873, 2.03406, 3.83709, 4.27198, 1.03488, 4.74044],
    [2.04688, 8.64254, 6.96036, 1.75085, 0.97232, 9.04721, 3.04971, 5.02701, 6.13849, 9.67864],
    [9.42869, 1.09348, 2.27393, 8.44356, 1.09012, 3.82061, 6.20960, 4.52467, 6.46840, 4.96414],
    [6.51051, 5.72558, 6.65090, 2.76986, 8.91537, 8.41212, 6.80166, 3.95581, 1.63152, 7.86584],
    [6.35426, 9.38932, 9.56389, 1.86010, 9.53276, 8.76431, 1.52470, 5.26994, 2.77169, 4.59761],
    [9.50041, 8.53023, 0.59175, 0.85299, 4.02539, 7.75445, 6.49373, 6.50746, 4.73830, 9.32554],
    [0.43397, 9.36888, 0.17182, 6.77236, 9.44914, 0.46388, 5.84429, 2.74331, 2.98105, 4.30311],
    [4.71572, 3.89080, 9.47691, 5.33464, 9.06888, 1.47679, 5.81774, 5.90747, 7.87805, 5.51653],
    [6.14490, 6.04633, 8.73043, 5.26597, 1.63854, 0.35768, 8.35780, 3.87280, 7.82189, 2.37709],
    [0.84750, 9.99939, 0.94119, 1.66845, 7.58934, 4.22712, 9.99664, 3.99335, 8.02301, 3.06558],
    [5.97339, 9.85565, 5.25040, 8.36543, 4.84848, 1.73956, 5.57421, 4.95590, 5.92608, 5.35142],
    [6.02069, 4.32051, 2.06793, 5.17716, 8.91873, 7.11478, 3.38145, 9.66918, 7.58812, 2.34840],
    [0.92654, 6.37379, 2.20527, 6.04022, 2.00629, 2.31513, 9.90753, 7.15445, 3.59813, 9.94232],
    [8.19697, 3.63872, 5.49791, 3.95581, 5.70879, 6.36982, 9.72777, 9.32951, 9.40458, 3.82336],
    [7.77978, 5.82904, 2.25410, 5.27818, 2.25257, 9.35545, 0.46846, 5.36790, 4.44594, 5.40971],
    [4.34584, 7.79290, 4.47310, 5.00351, 1.79235, 1.00589, 5.45732, 8.32270, 8.58455, 3.68236],
    [8.37184, 6.45711, 4.42610, 2.78542, 9.08689, 6.50838, 8.87631, 2.04749, 4.18531, 0.39094],
    [6.19709, 3.66771, 7.11356, 2.63558, 3.19163, 1.04831, 1.22257, 7.50969, 9.09482, 5.37950],
    [1.26988, 0.76571, 1.57262, 3.88043, 9.93774, 6.33503, 7.90277, 2.51625, 0.93539, 3.26792],
    [5.38957, 1.00009, 5.24766, 3.24778, 0.08148, 2.89132, 2.08350, 3.98083, 7.85119, 8.60408],
    [1.10416, 8.77560, 6.90146, 4.13923, 7.47490, 7.62932, 5.76037, 3.35215, 6.31458, 0.13001],
    [5.82537, 6.56636, 8.10419, 5.48662, 2.52297, 3.34758, 1.60985, 10.00000, 4.14197, 2.25257],
    [5.89496, 7.28996, 2.40577, 5.36088, 7.96808, 1.58635, 3.84747, 0.40376, 7.64550, 9.40275],
    [6.04419, 8.30714, 6.18061, 9.89471, 7.78008, 8.95199, 0.22340, 9.23002, 7.19840, 2.97342],
    [7.67724, 9.27061, 7.00095, 2.40699, 7.01132, 5.88275, 0.76388, 7.99432, 6.59261, 7.19230],
    [9.42869, 5.96026, 5.60106, 7.09037, 2.02826, 2.07892, 3.08817, 4.30738, 9.72076, 5.83331],
    [6.74184, 2.36610, 7.17795, 2.48756, 7.92291, 0.72359, 0.40742, 5.88122, 4.53200, 2.42103],
    [5.05722, 9.75829, 8.27235, 8.54610, 4.27412, 0.44343, 7.86706, 4.82742, 0.17487, 8.68221],
    [4.79934, 0.66744, 7.99371, 3.44615, 3.13303, 5.93310, 6.96463, 5.53209, 9.97620, 5.80767],
    [7.01010, 3.75256, 8.15424, 9.02615, 5.28886, 1.53844, 7.65130, 9.80071, 1.67089, 6.76565],
    [7.38517, 8.74783, 7.20054, 2.61483, 3.87310, 3.13547, 4.60982, 2.27943, 8.35932, 1.75695],
    [4.94766, 5.33494, 8.95810, 4.74563, 9.38047, 8.57967, 9.38200, 3.64544, 0.23408, 9.16044],
    [0.81179, 2.04627, 0.33692, 2.79672, 8.47652, 2.09998, 4.72457, 4.91531, 9.49980, 7.22495],
    [3.76995, 7.50633, 3.58013, 6.31794, 1.80425, 9.51506, 3.06650, 9.77935, 0.28657, 3.58135],
    [3.98846, 2.67006, 9.58678, 6.94021, 4.60768, 5.30747, 8.44508, 9.29319, 3.05063, 6.61611],
    [5.16984, 5.46587, 0.58779, 0.54567, 9.63622, 5.66362, 2.11585, 0.86734, 0.14588, 1.13620],
    [0.41353, 4.65987, 4.21705, 8.06635, 5.72710, 9.80193, 7.35832, 7.49229, 7.25181, 6.78091],
    [8.89462, 4.07819, 8.06787, 0.12726, 8.90896, 1.54668, 0.10010, 9.79675, 5.35569, 7.58141],
    [0.65615, 7.79687, 5.41673, 6.01367, 7.10959, 0.39064, 0.15320, 9.11374, 1.29154, 1.17069],
    [6.52608, 7.78191, 0.15137, 5.33006, 5.83697, 2.47169, 4.24848, 0.43275, 2.66243, 2.64260],
    [0.63936, 4.00525, 3.33628, 7.56188, 1.72277, 3.25297, 8.04346, 6.26698, 6.60085, 7.21976],
    [5.59374, 9.50102, 6.52699, 6.70186, 4.93240, 1.43132, 0.99460, 2.22724, 2.44819, 3.96924],
    [6.03534, 5.41490, 9.15067, 1.49480, 1.28361, 4.02326, 6.76656, 8.81069, 7.37877, 6.00604],
    [6.83187, 0.12482, 0.25422, 2.88156, 1.82714, 1.88574, 3.89111, 7.73247, 2.43202, 7.27470],
    [8.08618, 8.14570, 9.95270, 5.17197, 2.80374, 9.40794, 7.98669, 1.40873, 5.67339, 8.26594],
    [2.39204, 5.11582, 4.19111, 2.56691, 3.61736, 7.98151, 9.19431, 7.08975, 0.45564, 9.23429],
    [1.16550, 0.87954, 9.29197, 4.16059, 5.93219, 6.40034, 7.89514, 8.96695, 1.32328, 5.81439],
    [7.82983, 9.80682, 1.34556, 4.70565, 4.53780, 8.77651, 9.44060, 8.55403, 9.16227, 4.69832],
    [7.38792, 2.27790, 1.16916, 1.50090, 1.41575, 8.15668, 5.83758, 2.00873, 2.07831, 2.44179],
    [5.66668, 9.95605, 9.46867, 5.97369, 9.78149, 8.03278, 0.32228, 9.11435, 0.38057, 4.78408],
    [8.58303, 6.31001, 0.30305, 8.16279, 5.98163, 0.59359, 0.76815, 8.55922, 4.20301, 3.34147],
    [3.35368, 9.11527, 5.19395, 9.59807, 5.27635, 6.13544, 1.17862, 4.27656, 2.03375, 7.40867],
    [0.94455, 9.55473, 6.47420, 1.25095, 3.96039, 8.77102, 8.35200, 4.08826, 8.88638, 7.13950],
    [3.43638, 9.37895, 8.04498, 4.59273, 6.23157, 5.70391, 4.40840, 1.06571, 5.37461, 6.82669],
    [2.67006, 9.53520, 5.76922, 1.53630, 0.95889, 7.12302, 6.52211, 6.09149, 4.76150, 9.58129],
    [8.74233, 7.07297, 9.61394, 9.46593, 2.26539, 7.45872, 4.12549, 3.31736, 5.36729, 3.73516],
    [9.89776, 8.15455, 6.52760, 6.85507, 9.89715, 2.59865, 2.30689, 4.85549, 1.85308, 2.94107],
    [0.40040, 9.94934, 8.23298, 9.46135, 1.92816, 7.90216, 9.36338, 3.31248, 2.02826, 2.50465],
    [1.25828, 9.28800, 2.81075, 2.95785, 4.71908, 4.77584, 7.74010, 6.97958, 7.26188, 0.22034],
    [1.50334, 7.44530, 4.44288, 1.39897, 4.43220, 5.37950, 2.14026, 8.82626, 5.53362, 7.10349],
    [6.35548, 4.60097, 3.20170, 8.35902, 2.09479, 2.00903, 7.66381, 3.21482, 7.89941, 8.18873],
    [4.22895, 0.57222, 7.57622, 5.17655, 1.39988, 6.08142, 5.70635, 9.64690, 2.91025, 2.27638],
    [8.47896, 6.65120, 7.74957, 4.75173, 6.42109, 7.67754, 7.24052, 7.18101, 0.58748, 8.33644],
    [3.22855, 2.99753, 8.76736, 5.98926, 6.44704, 6.55019, 3.27250, 2.63039, 9.12076, 1.53905],
    [6.87246, 3.33537, 0.87069, 9.55535, 8.43410, 5.58916, 1.98309, 6.52394, 4.83413, 9.80377],
    [3.10068, 9.87609, 0.69887, 6.34175, 5.40635, 4.25123, 2.54341, 9.35484, 0.35554, 8.55098],
    [8.86441, 2.75277, 3.02133, 2.14942, 2.75338, 8.61232, 8.11701, 3.07993, 8.59401, 3.33903],
    [2.75613, 6.00330, 9.40031, 1.90039, 5.01267, 2.77596, 6.36402, 5.43107, 2.34565, 3.42875],
    [7.17277, 2.53456, 8.94894, 0.36592, 4.65682, 9.58800, 6.08814, 3.60210, 2.33406, 0.35951],
    [4.49232, 9.84344, 8.40815, 0.26154, 2.85348, 3.23344, 4.79049, 5.53850, 1.50517, 0.56795],
    [2.70058, 2.71218, 5.34074, 8.79635, 1.41270, 8.59279, 5.02640, 7.61986, 1.70965, 6.16901],
    [0.58596, 5.00137, 0.60549, 6.68935, 6.40400, 8.39808, 8.90042, 3.24717, 1.72094, 9.52574],
    [8.12952, 6.18244, 5.67888, 5.47502, 8.47011, 5.61144, 0.97934, 3.98663, 4.16822, 1.39988],
    [5.21805, 5.69689, 8.04590, 5.88855, 3.95642, 1.17100, 1.65288, 9.68444, 4.59609, 5.53423],
    [2.62856, 5.83300, 5.11460, 8.51009, 5.82904, 2.68044, 6.72872, 2.68471, 9.78912, 0.74068],
    [4.54360, 7.80541, 5.07828, 3.87646, 5.25559, 3.92468, 6.11286, 0.11261, 5.96637, 1.20792],
    [2.98898, 2.38990, 3.17331, 9.21079, 4.89608, 4.56984, 5.99872, 3.44249, 1.67577, 3.00974],
    [2.71798, 2.02948, 5.08927, 9.01547, 4.65468, 0.28443, 6.35060, 2.48360, 6.49739, 6.00238],
    [1.49510, 2.05084, 7.10715, 3.28776, 1.14200, 2.05725, 9.87548, 7.73431, 6.21204, 1.63945],
    [6.69362, 0.75930, 6.16688, 6.26514, 4.60250, 5.91662, 1.32939, 7.02017, 9.17478, 4.98795],
    [5.84918, 7.96594, 3.70128, 6.67867, 2.87393, 6.87063, 8.24213, 5.71886, 8.49178, 9.63561],
    [7.59758, 5.18906, 6.00421, 3.72326, 2.27577, 9.88159, 7.09525, 0.90365, 1.50273, 3.50719],
    [1.45573, 4.62813, 2.35267, 7.56554, 1.42918, 2.34382, 4.04859, 4.68459, 3.23771, 8.06665],
    [1.50456, 4.24757, 1.35319, 5.51256, 7.16819, 3.11686, 7.57683, 7.11661, 5.22446, 9.26817],
    [1.38493, 9.23704, 7.22892, 1.14597, 3.11258, 8.86593, 3.22520, 0.55727, 6.52333, 2.15583],
    [7.41691, 1.91015, 2.34413, 0.07599, 2.44850, 5.61266, 9.31578, 1.50822, 1.36784, 8.44661],
    [4.32386, 9.09787, 1.32084, 8.72372, 8.18049, 8.17133, 8.05170, 9.04233, 8.60408, 4.03241],
    [5.26261, 4.45051, 6.97714, 7.95007, 7.90338, 8.83663, 0.43062, 7.14896, 3.44493, 7.34977],
    [5.82568, 9.11771, 0.20692, 7.67235, 7.19047, 5.54552, 6.79800, 7.95038, 3.17759, 6.20167],
    [1.72887, 4.19691, 6.10462, 8.06574, 7.26890, 4.98093, 9.13633, 0.02655, 6.59932, 6.21418],
    [3.17545, 8.46095, 8.33003, 3.84655, 0.02564, 4.00037, 7.44591, 7.28660, 3.38084, 4.80514],
    [6.73544, 1.35411, 4.21400, 6.65365, 7.77642, 9.58525, 2.11982, 5.15946, 5.52995, 6.69057],
    [9.18058, 0.43062, 5.61235, 2.99295, 7.90826, 9.48454, 8.30592, 8.64742, 9.83795, 6.72597],
    [8.36970, 0.45595, 6.32282, 7.80663, 4.71206, 9.09940, 8.10205, 7.17521, 8.99350, 9.58403],
    [5.19822, 4.63057, 7.21122, 2.72958, 3.71166, 1.19297, 3.34056, 0.50233, 1.07089, 9.60387],
    [9.08658, 3.00729, 6.30085, 9.76379, 8.81161, 9.95483, 6.87582, 4.43068, 3.70159, 4.41237],
    [8.71609, 5.47838, 4.23414, 1.65288, 0.88992, 6.03687, 5.00717, 0.91433, 1.58879, 8.82473],
    [0.99582, 2.88003, 6.92953, 5.98254, 9.29807, 0.69735, 9.15586, 0.72634, 5.42680, 7.34092],
    [5.79363, 6.12720, 8.22230, 7.13767, 6.32832, 1.33244, 2.43263, 4.26374, 7.96106, 0.54353],
    [3.03903, 6.02863, 7.01285, 5.05570, 0.37721, 3.75286, 7.53410, 3.68114, 0.12513, 9.06003],
    [3.68236, 1.86102, 7.21549, 8.38862, 7.43522, 4.78164, 7.73461, 3.54106, 8.19483, 4.80667],
    [7.87622, 1.07944, 5.85131, 8.54091, 4.00403, 8.38069, 3.86486, 3.83099, 2.89438, 9.16532],
    [3.92987, 2.02460, 6.21296, 6.31123, 8.78414, 5.79272, 8.29554, 4.76577, 4.72396, 7.83258],
    [1.29032, 2.36610, 0.39064, 0.76022, 6.72689, 1.38432, 3.38694, 3.51085, 7.57256, 8.60683],
    [1.29002, 4.54970, 9.84069, 6.75985, 8.61904, 7.21824, 7.81121, 5.09842, 6.32527, 7.51518],
    [1.92724, 1.96570, 5.36119, 9.63836, 3.43089, 7.13736, 0.89694, 9.58678, 4.79812, 6.76443],
    [8.74172, 2.14484, 0.03754, 8.72646, 0.53468, 1.55919, 3.91736, 1.20670, 9.27061, 1.21525],
    [4.17554, 2.30323, 1.71545, 2.63405, 5.78631, 3.48552, 9.28526, 9.09513, 1.33549, 4.71511],
    [3.93628, 4.20423, 6.57521, 4.03516, 0.64577, 0.71078, 5.21317, 9.44700, 3.03201, 9.89624],
    [2.00598, 5.88397, 3.68114, 6.83615, 8.21528, 5.09629, 5.74786, 1.85827, 8.48659, 1.25614],
    [7.38273, 3.50352, 3.21970, 0.10163, 5.55803, 3.29966, 5.49059, 4.42366, 0.84994, 7.67052],
    [6.58162, 3.71776, 9.73785, 7.27927, 9.19370, 0.80538, 5.98804, 9.13205, 2.39174, 3.24259],
    [7.68181, 1.74383, 7.35435, 2.32246, 1.44932, 8.68587, 7.98425, 7.49382, 0.47548, 0.82003],
    [5.44633, 8.99655, 7.83319, 2.54524, 0.69399, 6.53584, 1.71606, 2.35054, 4.04370, 6.80288],
    [4.12641, 3.00485, 5.86627, 7.65526, 9.58159, 1.68371, 7.45140, 1.77160, 5.40300, 5.35295],
    [6.11194, 7.58904, 0.15107, 1.71422, 3.58837, 0.33998, 1.76580, 1.03580, 1.81677, 0.99948],
    [1.97638, 9.16990, 5.12223, 5.95294, 8.54488, 7.07389, 2.89956, 5.20157, 1.90130, 7.15201],
    [1.84881, 1.91443, 7.74041, 1.72216, 1.81890, 1.13987, 2.13233, 3.92499, 4.32936, 0.49043],
    [0.71963, 6.38783, 7.83135, 0.61403, 8.55831, 7.95404, 8.76858, 8.25953, 2.16163, 3.79192],
    [2.49977, 9.75646, 0.32105, 9.19492, 3.15043, 7.71416, 5.25224, 2.38441, 6.45039, 8.75820],
    [0.63753, 6.63259, 4.62142, 5.11277, 8.12952, 7.00858, 7.38151, 7.84570, 8.86715, 2.07129],
    [8.12098, 4.58174, 1.57964, 5.81347, 9.32005, 9.50743, 3.83282, 0.17243, 6.26545, 8.46614],
    [7.98181, 3.42051, 3.13028, 6.97012, 8.39351, 4.74502, 0.48158, 3.93109, 1.50273, 0.33509],
    [8.27265, 8.92636, 5.26139, 1.28239, 3.38878, 5.81439, 9.54436, 8.61202, 5.80798, 0.50935],
    [4.07514, 5.75396, 2.43171, 5.72771, 5.43596, 3.76904, 2.65999, 0.52126, 9.71801, 9.64232],
    [4.76333, 7.40745, 2.38197, 2.95175, 7.11997, 4.90890, 1.88818, 1.23325, 3.37748, 8.31721],
    [8.65658, 9.34629, 5.60472, 6.49007, 5.92181, 3.15531, 4.49171, 7.49809, 4.04767, 2.84402],
    [0.66591, 0.93051, 4.85916, 6.16688, 6.18091, 9.67284, 7.55516, 6.95639, 0.24689, 8.97122],
    [2.76833, 9.19736, 8.25922, 5.59374, 6.33259, 1.97790, 8.19117, 4.90280, 9.31486, 5.63494],
    [3.41258, 8.64803, 5.88549, 4.40046, 5.99811, 1.29490, 5.57970, 5.86657, 9.58281, 7.70562],
    [1.51524, 2.57790, 5.83422, 9.97101, 1.13285, 6.06647, 3.59905, 6.22394, 1.01505, 8.63948],
    [4.78805, 9.23399, 2.35237, 3.23466, 6.06189, 7.59819, 8.61446, 6.65395, 0.37935, 7.34550],
    [1.99286, 6.48732, 7.47459, 6.76199, 0.17457, 7.04398, 7.31681, 2.25043, 0.00916, 4.59487],
    [5.62731, 8.04071, 9.63530, 7.24998, 5.50523, 7.55486, 5.62426, 9.77172, 4.22987, 9.25138],
    [6.70797, 8.64498, 9.30357, 4.74990, 0.64943, 7.71386, 2.79275, 2.05542, 5.82232, 9.69665],
    [8.03369, 1.69225, 4.05683, 3.89050, 7.76299, 8.56044, 6.32160, 5.38347, 7.73705, 7.32780],
    [7.79748, 6.08051, 4.90341, 4.16974, 3.90790, 2.85836, 4.18256, 2.66884, 3.87188, 3.16324],
    [2.92856, 6.68661, 3.33659, 3.36161, 7.12577, 8.02149, 2.65267, 0.15656, 8.38649, 1.66356],
    [2.36274, 0.38575, 5.81408, 6.46107, 2.45186, 9.50713, 1.78961, 4.00616, 6.93625, 4.09040],
    [5.74725, 3.55998, 0.34211, 8.62728, 5.00107, 5.82202, 7.64611, 1.96448, 6.68416, 3.36253],
    [4.22864, 3.68603, 9.86480, 0.52431, 7.41722, 5.74175, 1.89947, 0.61312, 6.16749, 9.64843],
    [8.08893, 3.18308, 0.45473, 4.56435, 8.69381, 9.23276, 6.93625, 6.56209, 2.37953, 7.12546],
    [2.44026, 4.39741, 0.14893, 7.04367, 1.85583, 2.09967, 8.82321, 6.78915, 1.97516, 3.69152],
    [8.13868, 6.74764, 7.85882, 0.34547, 0.51820, 6.82241, 3.27860, 5.29923, 7.58263, 3.15317],
    [1.81066, 6.83462, 2.45949, 7.43645, 0.13062, 4.63668, 1.95837, 6.64998, 0.08087, 9.84375],
    [7.67052, 6.00665, 1.06906, 4.09955, 0.05615, 2.93710, 9.36186, 7.92749, 4.58541, 4.92477],
    [5.83392, 3.72600, 3.98785, 8.99869, 8.73928, 3.71105, 5.68316, 5.69964, 3.06192, 8.11090],
    [8.44539, 5.33097, 3.01340, 3.92590, 7.36991, 9.30876, 9.23460, 9.57030, 1.20609, 4.41877],
    [7.26951, 5.70086, 1.11118, 2.80038, 8.87051, 7.55516, 4.89486, 5.46190, 2.69662, 9.10062],
    [5.81500, 2.14545, 5.97186, 4.31593, 9.98688, 5.35203, 3.65947, 5.91388, 1.46519, 1.33824],
    [6.72079, 6.81539, 9.06949, 5.89892, 6.01794, 4.69405, 4.00403, 7.74773, 3.42265, 4.89456],
    [2.34779, 7.30705, 6.69729, 2.04718, 1.46428, 3.72021, 9.70336, 5.68438, 4.40352, 7.90185],
    [4.50911, 0.17182, 1.35289, 4.43068, 6.95273, 4.27259, 2.20191, 0.10743, 2.22175, 0.64730],
    [9.28343, 1.98309, 2.02094, 0.61495, 4.35072, 2.67220, 9.87915, 4.47310, 8.85891, 5.76403],
    [6.16474, 2.70180, 1.60619, 9.14518, 9.37284, 8.35780, 2.80465, 9.04233, 5.24064, 5.97034],
    [8.63399, 2.60292, 0.26093, 7.25791, 5.35142, 1.82134, 1.15116, 8.96939, 7.01285, 6.62679],
    [6.84072, 3.16874, 5.86779, 9.94171, 4.54146, 5.27360, 9.49644, 2.52815, 6.46504, 0.16022],
    [3.74279, 0.43001, 8.74233, 1.64708, 5.51744, 2.82601, 9.11679, 5.66942, 4.51918, 3.10434],
    [4.96689, 2.45827, 7.94977, 0.97354, 8.22626, 8.03674, 7.27653, 8.42189, 8.75637, 0.34242],
    [1.11118, 7.33390, 2.74300, 0.29603, 3.26243, 1.58269, 7.67327, 3.11777, 0.02594, 1.40660],
    [0.45564, 0.21516, 5.77807, 2.88156, 0.24964, 6.94784, 0.92929, 0.30580, 2.56233, 6.58284],
    [1.30772, 4.30769, 6.18000, 5.75610, 3.02683, 3.48552, 9.49095, 1.74810, 1.90527, 2.39845],
    [7.76788, 6.89047, 1.50151, 3.71563, 7.96869, 0.41108, 8.82321, 7.33940, 2.62001, 3.03690],
    [1.77282, 4.31013, 9.34416, 4.65987, 7.39830, 8.31599, 7.59362, 0.38331, 5.00259, 2.60231],
    [9.15586, 5.26048, 3.18278, 5.11582, 3.98938, 3.03415, 4.85458, 9.67223, 7.95404, 9.19675],
    [9.32859, 5.98041, 3.99854, 3.67443, 5.50096, 6.32191, 3.36924, 3.45775, 5.21836, 1.70507],
    [8.39778, 0.48250, 0.88168, 5.30381, 3.43486, 5.07828, 6.35029, 5.99322, 5.49303, 0.29603],
    [5.21043, 9.79644, 1.15513, 7.42759, 5.46861, 2.05420, 1.31748, 8.02576, 4.73373, 8.12983],
    [0.32685, 2.74728, 4.94888, 5.45885, 1.07456, 2.31758, 0.73855, 4.76394, 2.60964, 0.94180],
    [0.42909, 3.23801, 1.83477, 7.46879, 3.80993, 7.51488, 5.84613, 4.61806, 5.69292, 9.23643],
    [6.48000, 1.59124, 9.33836, 1.03030, 3.63109, 0.37111, 8.80276, 5.71154, 8.89920, 1.02573],
    [4.27839, 6.51692, 6.13392, 6.32832, 9.48210, 1.18809, 0.43367, 1.00589, 5.15641, 7.71661],
    [2.16712, 5.93310, 7.74895, 4.55763, 7.57317, 2.57210, 7.32749, 3.13334, 2.50771, 7.98822],
    [3.79803, 5.43077, 0.89877, 5.73565, 5.48448, 4.51033, 4.46699, 2.94229, 9.13450, 0.73855],
    [5.28184, 8.89279, 5.41459, 1.55461, 7.71111, 5.43046, 8.95535, 7.58446, 1.32633, 4.48866],
    [7.00858, 2.91574, 1.33061, 3.06192, 5.78356, 2.34535, 8.06543, 0.93204, 8.51741, 3.41166],
    [2.16254, 1.46062, 4.34980, 6.02405, 6.90603, 0.75900, 2.05939, 7.50420, 4.35896, 5.55284],
    [7.72637, 5.84857, 6.82546, 5.04624, 0.38118, 9.02707, 0.20722, 7.10715, 4.70931, 3.12723],
    [0.81545, 4.07605, 4.86251, 7.16178, 2.20283, 8.52290, 8.45149, 7.34672, 3.57830, 4.25031],
    [4.77371, 8.66482, 6.36586, 2.87027, 6.34449, 6.52638, 0.47090, 1.25401, 7.78680, 6.34266],
    [6.81478, 0.17792, 1.15299, 3.81756, 7.70257, 9.47020, 1.72979, 3.78002, 1.58452, 9.97406],
    [3.39671, 0.35737, 3.77667, 7.64245, 7.59697, 6.31611, 9.69787, 0.07172, 4.98337, 4.36842],
    [2.19001, 0.79073, 3.80505, 8.26991, 9.48546, 1.61351, 4.09101, 6.51082, 5.37553, 8.37550],
    [1.70171, 6.41865, 8.15577, 0.35554, 1.30161, 1.48412, 9.89746, 8.70907, 2.32368, 9.72259],
    [2.61605, 4.20881, 6.98325, 5.87970, 2.89773, 9.62310, 4.40443, 5.30259, 1.54271, 7.02811],
    [9.92370, 2.27973, 9.79247, 5.38041, 3.63079, 0.66713, 8.70083, 8.65078, 7.21183, 9.61241],
    [3.21329, 9.84008, 3.15256, 2.18757, 7.51457, 1.18534, 5.37187, 9.74914, 3.20750, 5.87115],
    [5.33952, 9.82543, 6.88864, 1.55278, 2.74636, 0.35981, 8.67946, 1.01657, 4.78866, 8.10877],
    [8.27723, 0.27223, 3.12723, 4.01349, 0.08820, 9.40794, 2.58339, 3.35917, 4.00494, 6.50288],
    [0.63967, 3.52855, 3.39183, 9.92798, 1.79968, 7.16788, 6.83767, 9.33073, 5.87603, 3.57524],
    [5.24308, 0.62685, 4.26557, 6.12262, 0.80111, 5.30961, 3.27647, 8.52748, 9.43480, 9.38444],
    [8.56746, 7.78375, 3.25327, 2.24921, 9.76318, 6.56392, 4.59395, 0.82492, 9.30845, 2.91055],
    [8.20368, 9.25504, 4.62264, 0.01984, 3.12998, 9.48180, 7.61711, 3.93994, 0.88290, 3.01553],
    [0.63875, 1.98889, 1.42613, 9.20927, 2.90353, 9.71038, 3.56487, 0.34394, 6.47633, 9.17386],
    [1.28849, 8.85006, 5.86932, 6.43880, 2.63558, 6.96463, 0.31190, 0.98819, 2.63833, 4.14624],
    [2.76284, 4.94919, 6.91366, 2.55379, 4.71847, 4.90951, 7.45964, 5.90533, 0.88900, 4.14716],
    [7.22159, 2.02826, 2.79733, 8.07886, 4.99222, 4.41328, 5.36699, 0.74679, 7.20420, 3.08451],
    [5.56169, 5.15275, 8.17957, 0.09888, 7.13645, 5.24888, 5.40117, 9.98749, 0.56764, 2.40608],
    [1.36235, 0.44801, 2.21686, 4.16456, 8.56594, 3.60912, 1.79968, 8.08222, 9.22452, 3.16691],
    [2.21503, 8.49452, 6.23615, 7.71905, 0.80142, 8.99533, 6.98782, 5.59771, 6.08234, 8.45424],
    [6.55477, 1.52226, 9.05972, 3.38084, 1.85797, 0.38026, 3.12357, 4.45051, 3.33934, 8.44905],
    [1.63579, 9.99969, 5.71978, 7.36961, 7.25333, 4.30921, 4.40260, 1.19236, 2.04993, 3.48582],
    [9.08200, 1.79601, 2.50496, 6.75039, 1.12308, 2.99997, 8.41365, 5.95172, 6.27338, 8.68221],
    [9.78851, 1.11515, 9.26634, 5.21012, 0.81118, 4.83749, 1.88665, 3.50505, 4.89700, 3.34330],
    [1.05228, 1.04282, 9.93500, 7.01346, 8.47652, 9.11283, 7.76666, 8.19849, 8.47896, 5.63860],
    [6.96585, 9.13083, 5.50127, 8.88485, 2.98196, 7.74529, 7.89087, 2.34626, 4.70779, 4.22437],
    [9.52086, 6.14948, 1.53600, 6.07654, 5.79974, 5.26414, 9.96887, 4.56374, 5.64165, 9.84680],
    [3.83648, 0.28871, 5.95477, 8.02637, 7.19626, 0.75411, 0.21088, 6.44124, 3.96466, 7.70928],
    [7.66289, 8.84487, 3.35673, 7.08945, 4.76363, 8.08802, 5.18204, 9.37254, 5.35966, 1.79601],
    [4.07147, 3.15134, 1.21525, 7.04581, 6.68966, 9.74700, 9.42930, 4.36201, 0.99796, 1.66356],
    [8.31050, 6.34114, 1.63396, 2.71126, 8.27357, 1.21708, 0.46236, 2.59224, 9.31486, 6.68203],
    [6.36738, 3.78155, 1.63427, 4.26954, 3.34361, 3.49712, 0.96347, 9.62310, 0.95309, 8.58699],
    [5.16343, 8.94894, 6.20472, 6.13361, 3.65429, 6.97867, 0.92471, 7.59697, 6.24104, 6.74459],
    [3.67656, 9.30418, 2.89315, 6.48671, 0.29389, 7.09769, 1.04801, 3.99731, 2.09052, 7.95984],
    [1.99133, 3.72417, 5.80737, 6.41804, 2.88614, 6.93594, 4.36140, 8.55220, 6.00787, 0.26948],
    [2.45582, 1.40751, 1.74718, 2.96731, 6.11957, 0.63448, 6.94723, 8.11823, 0.23072, 4.16120],
    [5.13413, 8.21558, 3.09458, 4.71358, 0.20356, 0.34455, 2.13263, 8.99747, 0.13062, 1.31046],
    [9.74853, 6.35090, 2.25654, 8.01935, 3.42967, 4.68368, 6.72353, 3.42784, 9.15586, 6.51418],
    [9.61577, 3.37016, 2.16315, 2.91421, 2.36976, 4.57686, 4.14045, 8.18018, 9.01700, 9.19767],
    [0.90854, 3.03507, 7.82006, 6.14032, 9.65545, 9.18394, 8.86715, 4.53871, 9.78057, 3.02194],
    [4.18592, 9.66338, 6.41682, 1.32267, 1.93915, 6.58193, 0.69155, 6.70583, 1.26377, 1.89215],
    [5.78661, 5.70635, 9.31913, 8.82931, 2.86142, 7.25059, 7.10196, 6.06464, 5.90503, 4.35835]
],
    dtype=np.double)
cShekel = np.array([
    [1.11196, 1.11025, 1.19145, 1.13756, 1.17645, 1.18894, 1.18148, 1.16138, 1.10642, 1.04509],
    [1.12357, 1.05692, 1.09382, 1.14248, 1.00779, 1.00990, 1.01361, 1.05976, 1.18727, 1.19349],
    [1.14875, 1.04077, 1.15250, 1.17027, 1.00923, 1.06228, 1.15296, 1.15243, 1.17654, 1.02562],
    [1.04725, 1.17641, 1.00475, 1.17840, 1.06295, 1.14821, 1.10956, 1.17253, 1.04756, 1.01570],
    [1.07633, 1.06483, 1.09163, 1.02412, 1.11870, 1.06648, 1.10545, 1.11101, 1.11868, 1.14755],
    [1.03055, 1.19684, 1.17975, 1.10279, 1.06710, 1.02767, 1.12402, 1.18510, 1.19868, 1.12591],
    [1.06481, 1.11278, 1.19551, 1.10559, 1.08593, 1.15683, 1.17748, 1.10833, 1.15871, 1.11463],
    [1.11817, 1.01624, 1.12833, 1.07619, 1.17112, 1.19804, 1.10041, 1.18917, 1.19969, 1.04465],
    [1.05932, 1.12903, 1.19158, 1.05047, 1.04937, 1.08057, 1.13947, 1.09654, 1.15010, 1.13688],
    [1.06884, 1.09207, 1.17703, 1.12226, 1.19437, 1.03024, 1.13892, 1.14518, 1.08605, 1.01484],
    [1.18314, 1.08758, 1.02634, 1.11380, 1.05992, 1.13665, 1.03963, 1.19590, 1.03722, 1.16563],
    [1.17512, 1.00699, 1.09709, 1.06949, 1.12450, 1.04191, 1.14496, 1.06206, 1.15579, 1.06832],
    [1.06314, 1.04071, 1.04417, 1.05875, 1.13959, 1.02481, 1.18158, 1.18712, 1.10343, 1.17438],
    [1.14593, 1.04593, 1.09831, 1.19492, 1.11141, 1.14049, 1.02487, 1.03493, 1.18102, 1.01619],
    [1.18370, 1.08227, 1.02260, 1.07541, 1.04982, 1.16546, 1.08972, 1.03999, 1.11014, 1.16645],
    [1.00848, 1.11574, 1.19500, 1.15094, 1.01162, 1.01508, 1.03517, 1.02244, 1.00112, 1.09424],
    [1.07540, 1.00656, 1.12066, 1.16102, 1.07595, 1.17147, 1.01892, 1.00961, 1.13318, 1.09101],
    [1.08534, 1.03865, 1.05062, 1.05672, 1.03927, 1.00855, 1.09159, 1.14472, 1.15389, 1.09474],
    [1.04475, 1.14418, 1.09625, 1.09273, 1.03383, 1.05317, 1.06441, 1.13142, 1.00269, 1.14842],
    [1.00325, 1.15088, 1.10704, 1.13516, 1.18000, 1.10075, 1.14405, 1.18330, 1.10067, 1.11577],
    [1.05112, 1.15611, 1.04895, 1.02426, 1.00503, 1.03783, 1.02848, 1.04631, 1.15270, 1.06631],
    [1.18992, 1.03746, 1.10489, 1.17695, 1.12400, 1.13451, 1.02401, 1.06424, 1.10199, 1.15938],
    [1.03731, 1.06721, 1.04447, 1.03754, 1.00678, 1.18482, 1.09998, 1.18709, 1.18683, 1.02772],
    [1.01472, 1.13478, 1.00120, 1.01268, 1.17444, 1.11527, 1.07022, 1.00575, 1.09987, 1.10982],
    [1.11975, 1.12051, 1.07692, 1.08070, 1.10293, 1.07766, 1.10293, 1.05752, 1.16617, 1.03225],
    [1.03009, 1.03181, 1.19046, 1.07460, 1.08750, 1.11601, 1.13934, 1.11144, 1.06287, 1.12319],
    [1.14477, 1.13329, 1.12539, 1.02373, 1.16217, 1.17447, 1.17065, 1.03516, 1.12574, 1.17186],
    [1.06930, 1.00149, 1.03554, 1.02885, 1.10034, 1.01826, 1.10746, 1.09055, 1.15047, 1.15948],
    [1.01720, 1.13655, 1.16067, 1.06283, 1.16979, 1.09757, 1.00134, 1.02929, 1.02564, 1.00219],
    [1.05722, 1.19348, 1.01461, 1.15984, 1.10321, 1.02094, 1.06905, 1.08642, 1.15265, 1.08866],
    [1.10736, 1.17877, 1.05888, 1.00495, 1.09916, 1.04412, 1.15181, 1.02519, 1.04334, 1.09103],
    [1.09029, 1.01934, 1.09024, 1.08772, 1.01193, 1.14780, 1.13921, 1.09439, 1.16125, 1.10165],
    [1.14290, 1.07548, 1.07778, 1.06362, 1.04931, 1.19843, 1.12502, 1.04600, 1.01308, 1.12478],
    [1.04178, 1.16175, 1.00713, 1.10036, 1.09699, 1.08510, 1.06592, 1.15035, 1.12922, 1.05779],
    [1.09168, 1.18580, 1.05234, 1.09731, 1.05466, 1.12762, 1.10835, 1.16334, 1.11891, 1.05454],
    [1.04871, 1.13862, 1.12456, 1.08097, 1.12558, 1.18056, 1.15812, 1.17136, 1.07385, 1.09973],
    [1.04180, 1.19700, 1.16565, 1.12169, 1.07335, 1.04176, 1.11824, 1.08808, 1.04740, 1.06282],
    [1.13673, 1.05360, 1.08981, 1.11278, 1.07279, 1.13483, 1.13611, 1.02934, 1.18063, 1.16730],
    [1.18528, 1.19879, 1.05148, 1.02695, 1.16031, 1.09956, 1.00790, 1.17245, 1.10649, 1.03220],
    [1.13902, 1.06422, 1.15895, 1.14181, 1.05808, 1.01694, 1.01055, 1.13935, 1.16351, 1.14128],
    [1.11141, 1.02806, 1.08474, 1.13143, 1.13136, 1.04119, 1.09407, 1.15463, 1.11646, 1.09723],
    [1.16573, 1.19879, 1.07100, 1.17913, 1.06353, 1.13468, 1.19611, 1.14341, 1.13827, 1.04872],
    [1.11617, 1.16578, 1.01608, 1.10280, 1.12454, 1.12918, 1.05916, 1.07727, 1.17953, 1.16075],
    [1.17991, 1.05334, 1.08204, 1.02387, 1.08991, 1.19132, 1.16617, 1.17145, 1.16487, 1.06063],
    [1.13385, 1.16689, 1.00687, 1.07818, 1.16500, 1.07882, 1.08513, 1.11106, 1.13414, 1.15593],
    [1.13645, 1.00005, 1.06513, 1.18815, 1.10685, 1.06005, 1.05484, 1.06032, 1.11524, 1.11363],
    [1.19732, 1.10485, 1.02081, 1.11416, 1.13960, 1.15927, 1.07512, 1.11457, 1.00034, 1.13525],
    [1.04011, 1.03807, 1.08268, 1.00515, 1.05352, 1.00707, 1.11241, 1.01235, 1.02275, 1.08660],
    [1.03286, 1.01177, 1.02849, 1.19837, 1.08760, 1.14662, 1.11936, 1.06179, 1.02235, 1.16772],
    [1.17889, 1.11828, 1.13722, 1.00176, 1.04584, 1.09488, 1.02065, 1.07454, 1.16954, 1.16374],
    [1.09623, 1.19554, 1.18098, 1.15339, 1.01356, 1.11011, 1.06138, 1.16834, 1.01468, 1.12549],
    [1.08915, 1.07309, 1.10697, 1.11686, 1.04664, 1.19683, 1.17407, 1.11977, 1.06795, 1.11511],
    [1.05583, 1.01509, 1.00895, 1.06469, 1.12877, 1.11288, 1.12086, 1.04789, 1.01805, 1.14123],
    [1.10855, 1.18262, 1.17245, 1.04650, 1.15491, 1.15429, 1.13340, 1.11112, 1.19243, 1.12608],
    [1.02946, 1.19523, 1.00331, 1.16354, 1.12741, 1.00834, 1.02943, 1.12988, 1.17125, 1.01740],
    [1.07315, 1.10833, 1.14030, 1.09740, 1.17053, 1.10761, 1.15776, 1.13081, 1.01799, 1.10684],
    [1.18084, 1.06210, 1.03382, 1.19625, 1.00383, 1.01357, 1.03558, 1.06973, 1.00531, 1.16879],
    [1.01486, 1.02567, 1.17067, 1.02983, 1.19050, 1.13221, 1.02138, 1.15462, 1.02165, 1.11317],
    [1.18213, 1.18058, 1.16178, 1.01104, 1.01700, 1.04087, 1.03493, 1.18302, 1.06622, 1.17945],
    [1.01559, 1.08661, 1.11435, 1.07120, 1.09325, 1.01094, 1.02151, 1.05344, 1.00293, 1.00991],
    [1.14869, 1.17494, 1.10314, 1.19371, 1.10847, 1.06878, 1.18219, 1.03461, 1.07233, 1.15536],
    [1.07432, 1.04365, 1.16593, 1.18163, 1.06688, 1.07407, 1.18347, 1.00297, 1.17978, 1.00815],
    [1.15246, 1.01390, 1.09831, 1.08335, 1.18016, 1.13381, 1.04097, 1.01423, 1.11281, 1.15406],
    [1.14313, 1.16631, 1.03917, 1.15268, 1.03800, 1.13807, 1.16929, 1.18284, 1.01613, 1.00754],
    [1.11995, 1.14147, 1.04470, 1.19948, 1.13813, 1.02410, 1.02778, 1.02949, 1.09344, 1.07243],
    [1.18889, 1.08150, 1.17102, 1.02056, 1.15698, 1.07446, 1.09608, 1.14646, 1.03740, 1.17494],
    [1.02135, 1.13460, 1.04862, 1.01160, 1.10865, 1.05634, 1.00638, 1.14784, 1.13577, 1.07401],
    [1.03632, 1.06898, 1.16019, 1.17511, 1.19634, 1.04006, 1.17048, 1.14283, 1.19004, 1.09065],
    [1.15694, 1.06922, 1.05235, 1.08280, 1.13267, 1.01706, 1.18874, 1.11857, 1.13619, 1.13694],
    [1.04918, 1.04310, 1.14699, 1.04552, 1.01807, 1.09975, 1.14523, 1.17155, 1.00151, 1.09341],
    [1.04685, 1.07555, 1.09300, 1.11823, 1.14525, 1.04967, 1.19900, 1.00611, 1.19092, 1.00386],
    [1.00543, 1.15210, 1.14021, 1.14455, 1.16650, 1.07304, 1.10447, 1.05226, 1.09696, 1.15558],
    [1.13081, 1.06427, 1.04922, 1.15001, 1.14581, 1.16849, 1.05643, 1.06597, 1.09333, 1.11512],
    [1.02284, 1.02637, 1.19770, 1.15195, 1.14266, 1.13579, 1.18357, 1.08984, 1.12870, 1.11953],
    [1.18372, 1.10451, 1.03204, 1.18970, 1.16579, 1.18089, 1.13394, 1.09444, 1.00970, 1.00630],
    [1.09125, 1.00662, 1.06651, 1.01874, 1.01666, 1.00822, 1.13019, 1.01646, 1.07487, 1.02671],
    [1.05356, 1.03516, 1.07609, 1.17960, 1.13971, 1.09897, 1.04805, 1.18343, 1.13987, 1.15151],
    [1.06773, 1.18349, 1.18932, 1.17335, 1.13417, 1.06051, 1.11241, 1.19197, 1.16350, 1.17051],
    [1.02792, 1.19055, 1.08749, 1.17411, 1.08612, 1.02188, 1.13691, 1.11154, 1.06870, 1.13363],
    [1.09082, 1.17969, 1.08282, 1.01102, 1.17323, 1.16720, 1.08056, 1.14360, 1.17817, 1.00416],
    [1.03506, 1.02183, 1.10461, 1.18242, 1.10447, 1.17020, 1.08236, 1.10288, 1.01508, 1.12276],
    [1.07026, 1.10598, 1.19490, 1.14763, 1.10779, 1.04166, 1.08871, 1.02649, 1.00161, 1.13500],
    [1.18624, 1.09541, 1.02797, 1.00383, 1.19424, 1.05329, 1.13246, 1.18452, 1.08418, 1.14410],
    [1.00824, 1.02225, 1.04637, 1.01922, 1.13411, 1.08199, 1.08214, 1.08610, 1.15345, 1.13636],
    [1.06509, 1.04947, 1.07556, 1.08682, 1.00268, 1.05143, 1.08053, 1.07418, 1.12960, 1.11659],
    [1.00867, 1.13492, 1.16387, 1.10852, 1.11624, 1.05936, 1.15721, 1.10382, 1.17824, 1.00819],
    [1.07071, 1.18998, 1.11979, 1.14324, 1.10723, 1.19335, 1.05726, 1.02913, 1.13158, 1.14339],
    [1.13045, 1.06181, 1.00992, 1.17958, 1.00701, 1.08028, 1.19957, 1.10707, 1.04031, 1.01781],
    [1.02036, 1.10746, 1.16224, 1.14883, 1.13897, 1.01088, 1.09182, 1.18774, 1.09735, 1.03569],
    [1.14129, 1.19607, 1.01658, 1.00198, 1.00053, 1.15387, 1.10735, 1.12510, 1.18133, 1.15201],
    [1.11824, 1.19563, 1.10271, 1.06129, 1.15335, 1.05181, 1.09842, 1.03485, 1.19011, 1.15094],
    [1.12802, 1.09995, 1.12881, 1.14564, 1.07270, 1.19553, 1.10512, 1.07169, 1.19714, 1.11166],
    [1.09655, 1.05327, 1.05858, 1.08726, 1.15447, 1.13211, 1.04448, 1.12217, 1.09266, 1.12665],
    [1.01986, 1.16005, 1.16387, 1.12762, 1.06577, 1.19814, 1.15538, 1.13614, 1.18989, 1.08025],
    [1.03506, 1.05064, 1.19077, 1.02923, 1.17904, 1.10891, 1.15673, 1.07508, 1.11220, 1.19139],
    [1.18088, 1.03508, 1.19297, 1.09215, 1.17332, 1.00212, 1.17327, 1.16362, 1.15187, 1.19741],
    [1.06536, 1.04140, 1.09261, 1.14394, 1.04642, 1.05543, 1.12143, 1.01694, 1.03226, 1.03377],
    [1.12776, 1.12749, 1.05149, 1.10508, 1.18192, 1.19555, 1.05134, 1.00629, 1.03721, 1.16877],
    [1.06630, 1.10166, 1.09798, 1.04321, 1.18096, 1.01916, 1.13497, 1.04228, 1.01815, 1.11100],
    [1.12920, 1.01009, 1.18392, 1.04400, 1.12562, 1.17558, 1.00015, 1.12640, 1.07775, 1.14352],
    [1.15651, 1.07718, 1.16460, 1.06878, 1.01268, 1.04435, 1.16111, 1.07005, 1.18232, 1.17810],
    [1.14331, 1.03916, 1.12978, 1.16544, 1.10961, 1.10251, 1.01116, 1.03240, 1.19923, 1.09059],
    [1.09054, 1.02002, 1.08920, 1.07200, 1.16302, 1.04037, 1.05115, 1.10816, 1.11553, 1.11905],
    [1.04904, 1.08495, 1.05689, 1.13010, 1.15928, 1.17764, 1.14819, 1.02986, 1.09419, 1.00512],
    [1.16478, 1.09583, 1.11040, 1.03004, 1.12124, 1.17693, 1.08321, 1.06066, 1.19048, 1.06124],
    [1.02808, 1.01116, 1.04810, 1.16767, 1.05089, 1.17615, 1.07360, 1.06767, 1.00773, 1.17610],
    [1.13928, 1.04323, 1.05586, 1.02957, 1.01841, 1.18749, 1.17686, 1.10876, 1.14378, 1.05422],
    [1.05328, 1.03441, 1.14778, 1.16230, 1.18017, 1.06646, 1.11553, 1.16156, 1.19245, 1.04664],
    [1.18202, 1.16625, 1.08972, 1.04935, 1.00474, 1.06221, 1.13949, 1.19681, 1.14287, 1.09431],
    [1.14014, 1.19507, 1.07438, 1.13999, 1.02501, 1.04696, 1.08234, 1.17557, 1.08869, 1.09817],
    [1.14151, 1.14131, 1.01676, 1.07280, 1.03667, 1.11151, 1.00048, 1.05471, 1.04375, 1.17602],
    [1.11727, 1.07066, 1.00519, 1.13927, 1.05863, 1.03178, 1.13064, 1.04313, 1.18651, 1.08948],
    [1.15427, 1.01993, 1.19941, 1.16200, 1.18007, 1.08164, 1.18956, 1.08795, 1.04617, 1.15182],
    [1.17236, 1.16308, 1.13968, 1.14626, 1.06925, 1.11646, 1.09301, 1.00877, 1.02551, 1.08236],
    [1.09326, 1.10826, 1.04386, 1.02414, 1.03562, 1.10342, 1.01552, 1.16630, 1.05220, 1.08120],
    [1.12969, 1.09095, 1.04750, 1.07545, 1.14280, 1.05506, 1.17181, 1.17176, 1.08879, 1.18462],
    [1.06367, 1.10495, 1.11169, 1.10199, 1.19281, 1.15545, 1.00161, 1.04274, 1.13462, 1.05060],
    [1.11565, 1.01819, 1.10768, 1.07746, 1.06463, 1.07982, 1.00519, 1.11303, 1.04733, 1.04202],
    [1.05210, 1.17842, 1.01301, 1.11922, 1.11851, 1.02304, 1.13384, 1.03367, 1.02134, 1.14515],
    [1.16829, 1.05029, 1.04485, 1.15494, 1.19680, 1.09463, 1.01169, 1.08649, 1.11097, 1.01032],
    [1.13558, 1.16479, 1.13754, 1.11226, 1.18683, 1.03406, 1.17829, 1.09164, 1.00204, 1.15370],
    [1.04730, 1.02932, 1.06923, 1.16802, 1.18674, 1.17358, 1.01950, 1.15609, 1.14231, 1.03851],
    [1.15665, 1.16788, 1.17983, 1.07956, 1.05596, 1.15300, 1.12399, 1.10199, 1.16338, 1.08828],
    [1.00069, 1.05908, 1.02620, 1.01036, 1.16410, 1.19586, 1.08683, 1.15975, 1.08974, 1.19481],
    [1.07056, 1.14227, 1.11488, 1.07980, 1.09879, 1.11451, 1.10735, 1.13453, 1.15890, 1.09926],
    [1.14424, 1.19152, 1.06193, 1.03726, 1.18149, 1.14823, 1.11953, 1.08161, 1.19588, 1.06629],
    [1.07116, 1.14093, 1.18039, 1.11016, 1.09306, 1.17762, 1.07447, 1.08155, 1.02003, 1.06746],
    [1.01019, 1.00577, 1.01136, 1.12685, 1.15578, 1.12632, 1.19219, 1.11366, 1.13761, 1.16383],
    [1.10143, 1.00847, 1.12190, 1.19584, 1.07771, 1.18187, 1.13758, 1.01341, 1.01430, 1.05449],
    [1.12129, 1.11104, 1.01457, 1.05582, 1.06594, 1.16595, 1.17899, 1.18807, 1.15405, 1.16312],
    [1.05505, 1.00140, 1.05705, 1.02224, 1.18135, 1.08677, 1.08198, 1.08299, 1.05707, 1.09245],
    [1.14648, 1.10451, 1.16802, 1.17087, 1.06381, 1.13591, 1.00067, 1.06150, 1.11864, 1.11343],
    [1.07529, 1.11661, 1.01531, 1.14097, 1.12941, 1.07558, 1.17946, 1.11010, 1.08305, 1.09451],
    [1.09449, 1.01561, 1.11672, 1.03701, 1.05402, 1.02318, 1.09366, 1.13263, 1.01166, 1.04517],
    [1.05737, 1.00915, 1.10924, 1.08085, 1.03587, 1.00486, 1.16475, 1.07741, 1.08383, 1.16724],
    [1.10150, 1.16784, 1.19376, 1.04418, 1.19929, 1.04206, 1.00771, 1.07409, 1.14932, 1.10750],
    [1.16056, 1.08097, 1.19369, 1.19534, 1.18616, 1.08095, 1.13102, 1.06878, 1.01766, 1.10628],
    [1.06933, 1.08947, 1.01325, 1.05325, 1.10736, 1.09834, 1.13844, 1.06012, 1.02575, 1.06725],
    [1.03639, 1.02138, 1.16919, 1.17750, 1.01721, 1.14469, 1.00081, 1.08155, 1.09777, 1.15647],
    [1.11014, 1.00428, 1.12311, 1.06275, 1.15580, 1.03984, 1.10072, 1.07119, 1.12423, 1.10052],
    [1.17901, 1.18083, 1.18566, 1.07376, 1.00112, 1.04551, 1.12859, 1.04377, 1.06542, 1.01753],
    [1.05408, 1.13362, 1.02384, 1.17751, 1.11103, 1.02447, 1.14941, 1.05684, 1.15370, 1.10793],
    [1.10412, 1.05910, 1.10278, 1.12785, 1.03850, 1.08636, 1.09123, 1.06793, 1.15400, 1.17690],
    [1.17610, 1.14107, 1.15957, 1.06059, 1.09763, 1.03715, 1.15365, 1.03792, 1.06692, 1.08515],
    [1.16275, 1.08928, 1.06326, 1.08593, 1.06791, 1.02041, 1.02258, 1.07209, 1.15037, 1.15062],
    [1.19806, 1.15092, 1.18757, 1.14961, 1.07437, 1.08686, 1.13082, 1.12958, 1.11662, 1.17964],
    [1.09585, 1.19854, 1.13528, 1.09441, 1.09748, 1.18118, 1.14846, 1.00000, 1.05976, 1.11375],
    [1.12261, 1.07174, 1.13263, 1.01875, 1.07309, 1.11487, 1.04657, 1.16619, 1.10564, 1.16495],
    [1.13634, 1.12724, 1.08021, 1.02152, 1.16514, 1.02687, 1.07827, 1.17118, 1.18038, 1.10147],
    [1.15488, 1.05627, 1.13238, 1.16777, 1.15673, 1.14573, 1.08714, 1.10945, 1.08759, 1.16393],
    [1.16462, 1.18749, 1.00214, 1.13407, 1.03352, 1.08062, 1.10957, 1.19235, 1.09406, 1.06212],
    [1.06826, 1.02885, 1.17984, 1.01917, 1.15276, 1.11197, 1.11013, 1.12102, 1.07412, 1.15196],
    [1.12376, 1.04229, 1.13514, 1.16038, 1.12594, 1.14755, 1.10161, 1.16150, 1.17917, 1.14347],
    [1.07077, 1.11177, 1.16963, 1.00488, 1.11826, 1.08390, 1.08010, 1.08078, 1.00497, 1.07153],
    [1.00084, 1.18680, 1.12477, 1.07091, 1.10962, 1.19014, 1.17454, 1.19575, 1.15208, 1.09342],
    [1.12776, 1.08159, 1.05378, 1.12359, 1.19283, 1.13576, 1.19514, 1.03206, 1.13738, 1.08941],
    [1.18046, 1.11262, 1.05992, 1.00766, 1.03247, 1.14295, 1.18996, 1.01425, 1.04332, 1.15641],
    [1.19785, 1.08686, 1.01366, 1.05001, 1.19571, 1.17943, 1.11070, 1.13511, 1.11064, 1.02759],
    [1.07678, 1.03671, 1.01132, 1.09372, 1.01951, 1.04813, 1.06957, 1.00746, 1.11482, 1.14676],
    [1.13769, 1.15843, 1.05414, 1.17747, 1.02329, 1.19697, 1.16705, 1.00992, 1.04248, 1.09939],
    [1.05039, 1.17589, 1.13294, 1.15401, 1.03549, 1.19285, 1.10788, 1.12400, 1.12434, 1.08029],
    [1.13238, 1.14350, 1.12628, 1.07476, 1.00319, 1.00324, 1.02628, 1.04997, 1.11328, 1.18179],
    [1.11609, 1.04831, 1.08249, 1.07876, 1.11961, 1.02987, 1.13532, 1.00627, 1.04353, 1.04533],
    [1.00733, 1.19484, 1.18475, 1.13890, 1.06130, 1.16990, 1.02555, 1.18762, 1.19435, 1.15544],
    [1.04804, 1.18318, 1.01737, 1.06068, 1.19886, 1.16270, 1.08795, 1.10630, 1.03565, 1.09438],
    [1.07811, 1.04628, 1.08631, 1.12467, 1.05795, 1.04185, 1.05249, 1.09292, 1.17673, 1.14346],
    [1.18834, 1.11990, 1.12224, 1.03734, 1.08609, 1.17634, 1.04020, 1.01270, 1.19934, 1.03786],
    [1.09442, 1.00585, 1.13556, 1.13249, 1.14944, 1.07765, 1.04906, 1.08690, 1.15651, 1.18028],
    [1.16545, 1.07789, 1.12445, 1.16974, 1.16909, 1.19503, 1.05652, 1.12041, 1.08466, 1.12098],
    [1.13448, 1.09764, 1.18414, 1.13565, 1.13121, 1.04495, 1.15037, 1.15036, 1.13315, 1.14183],
    [1.02856, 1.17842, 1.15366, 1.08855, 1.19693, 1.14818, 1.11868, 1.07413, 1.08769, 1.06500],
    [1.00596, 1.08382, 1.08975, 1.02828, 1.01896, 1.10222, 1.16426, 1.10981, 1.17687, 1.06839],
    [1.00427, 1.19962, 1.00178, 1.13916, 1.06984, 1.02581, 1.08448, 1.11691, 1.12978, 1.05439],
    [1.00994, 1.19798, 1.04121, 1.07536, 1.02385, 1.09812, 1.19838, 1.18148, 1.12142, 1.11111],
    [1.18177, 1.14587, 1.13968, 1.15683, 1.03888, 1.10461, 1.13454, 1.17501, 1.12795, 1.15071],
    [1.02393, 1.12100, 1.15570, 1.14569, 1.17811, 1.11965, 1.14062, 1.15491, 1.13855, 1.03374],
    [1.13277, 1.01307, 1.14659, 1.00305, 1.02151, 1.02597, 1.06307, 1.01038, 1.06243, 1.11485],
    [1.16026, 1.03082, 1.05459, 1.00963, 1.16728, 1.02043, 1.19940, 1.19713, 1.05033, 1.10067],
    [1.17248, 1.03068, 1.10888, 1.19470, 1.03958, 1.10730, 1.06917, 1.07196, 1.14788, 1.11869],
    [1.15616, 1.05722, 1.02402, 1.08232, 1.02538, 1.16024, 1.00994, 1.15884, 1.13562, 1.08242],
    [1.06786, 1.16203, 1.04403, 1.05675, 1.08570, 1.16767, 1.00464, 1.17704, 1.11414, 1.12739],
    [1.15174, 1.17299, 1.06649, 1.09390, 1.04917, 1.08717, 1.11280, 1.16379, 1.08692, 1.01020],
    [1.09930, 1.14415, 1.10631, 1.13036, 1.02451, 1.04929, 1.13483, 1.05396, 1.10323, 1.03377],
    [1.01205, 1.05258, 1.04965, 1.06798, 1.18782, 1.19365, 1.11090, 1.16261, 1.07389, 1.01027],
    [1.08217, 1.04817, 1.03042, 1.06702, 1.03480, 1.11581, 1.16846, 1.07739, 1.18849, 1.12574],
    [1.04957, 1.12974, 1.05878, 1.08954, 1.06424, 1.07743, 1.11142, 1.03239, 1.16971, 1.04988],
    [1.05436, 1.04182, 1.16918, 1.14043, 1.19909, 1.10891, 1.01296, 1.02747, 1.02221, 1.16833],
    [1.10337, 1.18505, 1.15881, 1.04350, 1.08427, 1.03906, 1.15855, 1.10309, 1.09668, 1.12557],
    [1.03603, 1.13503, 1.18160, 1.00718, 1.14650, 1.04436, 1.01143, 1.00394, 1.01818, 1.08128],
    [1.03106, 1.09493, 1.07255, 1.00533, 1.19005, 1.04679, 1.06366, 1.09231, 1.14705, 1.12549],
    [1.16794, 1.18995, 1.12771, 1.04749, 1.15564, 1.12867, 1.11744, 1.12666, 1.17507, 1.09370],
    [1.17002, 1.07315, 1.18107, 1.06472, 1.11371, 1.00038, 1.13887, 1.12937, 1.03565, 1.09666],
    [1.03452, 1.17687, 1.02614, 1.11728, 1.02329, 1.17784, 1.16398, 1.15376, 1.14714, 1.15689],
    [1.02392, 1.03617, 1.15262, 1.06385, 1.08780, 1.02500, 1.04047, 1.05021, 1.14032, 1.14863],
    [1.07796, 1.15682, 1.03092, 1.04284, 1.10548, 1.11917, 1.08287, 1.04848, 1.06856, 1.09657],
    [1.13088, 1.02362, 1.00637, 1.03130, 1.06849, 1.02636, 1.02830, 1.04417, 1.08652, 1.12466],
    [1.10952, 1.17262, 1.08366, 1.08926, 1.03705, 1.05766, 1.03073, 1.02622, 1.13739, 1.08590],
    [1.16958, 1.10500, 1.11708, 1.19288, 1.02805, 1.03858, 1.04741, 1.03399, 1.13229, 1.07180],
    [1.02448, 1.12922, 1.19736, 1.13407, 1.13594, 1.08800, 1.07788, 1.11285, 1.06556, 1.12039],
    [1.05947, 1.10406, 1.16708, 1.14073, 1.17262, 1.19574, 1.13826, 1.07026, 1.10989, 1.04104],
    [1.12670, 1.04478, 1.02810, 1.17707, 1.19854, 1.13359, 1.01635, 1.14560, 1.00123, 1.07600],
    [1.11142, 1.17199, 1.15181, 1.04180, 1.04159, 1.05854, 1.18165, 1.12163, 1.18033, 1.04865],
    [1.16930, 1.15381, 1.09091, 1.11781, 1.09232, 1.19368, 1.14336, 1.04783, 1.02954, 1.03177],
    [1.18489, 1.14060, 1.04498, 1.06713, 1.14504, 1.12740, 1.08468, 1.14186, 1.15701, 1.13035],
    [1.11759, 1.04331, 1.07599, 1.03188, 1.05194, 1.08007, 1.17632, 1.10879, 1.05821, 1.03808],
    [1.10811, 1.08696, 1.03000, 1.12300, 1.09513, 1.07298, 1.01401, 1.19519, 1.05474, 1.11905],
    [1.14045, 1.10357, 1.02159, 1.07729, 1.08507, 1.02448, 1.15581, 1.09979, 1.19412, 1.01190],
    [1.11743, 1.04052, 1.10335, 1.06527, 1.08796, 1.11560, 1.18256, 1.12105, 1.02053, 1.07785],
    [1.03658, 1.07453, 1.19977, 1.06218, 1.19439, 1.03776, 1.09268, 1.15790, 1.01715, 1.14023],
    [1.17186, 1.06411, 1.15676, 1.07828, 1.09213, 1.08477, 1.19603, 1.11962, 1.10204, 1.01927],
    [1.00170, 1.16916, 1.07131, 1.00508, 1.02167, 1.00246, 1.01553, 1.06850, 1.05757, 1.07298],
    [1.09948, 1.03996, 1.14395, 1.19937, 1.00006, 1.19001, 1.06544, 1.13917, 1.01038, 1.04214],
    [1.14300, 1.15504, 1.16602, 1.11900, 1.02051, 1.17980, 1.17486, 1.07791, 1.08317, 1.08657],
    [1.03165, 1.19217, 1.03853, 1.07030, 1.09859, 1.03422, 1.09193, 1.04674, 1.13319, 1.11720],
    [1.04714, 1.07535, 1.04465, 1.15068, 1.16376, 1.11226, 1.06002, 1.06735, 1.10239, 1.09954],
    [1.08128, 1.07655, 1.18907, 1.09707, 1.11484, 1.10097, 1.13002, 1.06322, 1.15442, 1.05287],
    [1.00807, 1.19063, 1.19878, 1.10600, 1.09196, 1.00328, 1.18544, 1.01941, 1.08975, 1.12120],
    [1.12163, 1.06955, 1.17771, 1.09893, 1.19380, 1.04673, 1.03571, 1.04411, 1.13692, 1.07238],
    [1.02070, 1.02243, 1.04469, 1.09320, 1.10912, 1.15505, 1.10213, 1.00849, 1.13980, 1.01494],
    [1.02165, 1.08704, 1.18857, 1.02832, 1.06383, 1.02959, 1.00560, 1.08729, 1.02429, 1.13335],
    [1.14704, 1.08019, 1.06781, 1.11468, 1.13191, 1.14571, 1.19092, 1.04616, 1.05576, 1.15709],
    [1.19429, 1.16454, 1.19213, 1.04265, 1.14617, 1.00541, 1.01315, 1.04894, 1.01801, 1.02131],
    [1.16066, 1.15260, 1.07370, 1.13905, 1.19872, 1.12743, 1.09345, 1.01298, 1.07929, 1.07276],
    [1.01384, 1.03000, 1.15190, 1.10930, 1.06496, 1.02293, 1.04867, 1.04895, 1.18624, 1.14823],
    [1.07609, 1.14459, 1.00189, 1.08448, 1.04462, 1.12629, 1.13751, 1.00779, 1.16746, 1.02998],
    [1.15879, 1.10041, 1.15962, 1.02504, 1.11391, 1.04881, 1.16885, 1.14700, 1.16055, 1.08746],
    [1.06915, 1.14139, 1.05900, 1.04455, 1.14875, 1.12538, 1.01253, 1.14593, 1.12317, 1.07314],
    [1.03626, 1.03345, 1.10516, 1.03128, 1.13576, 1.15414, 1.06243, 1.07064, 1.07678, 1.17614],
    [1.19451, 1.08062, 1.02708, 1.18802, 1.15999, 1.01242, 1.05192, 1.13745, 1.18552, 1.07729],
    [1.14427, 1.06559, 1.18753, 1.10609, 1.17096, 1.19348, 1.13820, 1.17652, 1.01624, 1.01653],
    [1.00680, 1.11405, 1.10373, 1.06361, 1.10766, 1.17307, 1.17819, 1.07669, 1.18603, 1.10426],
    [1.12829, 1.06755, 1.07307, 1.11459, 1.13171, 1.00763, 1.04130, 1.12611, 1.10360, 1.00735],
    [1.09157, 1.03986, 1.13001, 1.14117, 1.10302, 1.01109, 1.06715, 1.17446, 1.07714, 1.04207],
    [1.18806, 1.14884, 1.00725, 1.09867, 1.05764, 1.08170, 1.00454, 1.05711, 1.11767, 1.13655],
    [1.01213, 1.08699, 1.16259, 1.12036, 1.13818, 1.17687, 1.18776, 1.06399, 1.13936, 1.00872],
    [1.19106, 1.14220, 1.08607, 1.08748, 1.00942, 1.08923, 1.14050, 1.13182, 1.17126, 1.16648],
    [1.07872, 1.03262, 1.04617, 1.03823, 1.08841, 1.18525, 1.07323, 1.01199, 1.07299, 1.10182],
    [1.14899, 1.19940, 1.19374, 1.10987, 1.15649, 1.05413, 1.08107, 1.04366, 1.11657, 1.04307],
    [1.04619, 1.13415, 1.14267, 1.10684, 1.12434, 1.00417, 1.08042, 1.06609, 1.08103, 1.17494],
    [1.01321, 1.02972, 1.01231, 1.19003, 1.11507, 1.16131, 1.07047, 1.16330, 1.03201, 1.06002],
    [1.14647, 1.05683, 1.07318, 1.11216, 1.04006, 1.09524, 1.19304, 1.06970, 1.14927, 1.02245],
    [1.04573, 1.01211, 1.01008, 1.00751, 1.09305, 1.14744, 1.11795, 1.10525, 1.04714, 1.00928],
    [1.16201, 1.07842, 1.02919, 1.10565, 1.10354, 1.08738, 1.12546, 1.17595, 1.02984, 1.05357],
    [1.12171, 1.11255, 1.01467, 1.00308, 1.09752, 1.10300, 1.11659, 1.19664, 1.06156, 1.04917],
    [1.14652, 1.15196, 1.10909, 1.01960, 1.13559, 1.16518, 1.08307, 1.19139, 1.13473, 1.03721],
    [1.01998, 1.03763, 1.07702, 1.01144, 1.16164, 1.01696, 1.13431, 1.02902, 1.01430, 1.12123],
    [1.09919, 1.10805, 1.03633, 1.13758, 1.02353, 1.15272, 1.03553, 1.18135, 1.04504, 1.19888],
    [1.05759, 1.15583, 1.03283, 1.00214, 1.04671, 1.09528, 1.18350, 1.17480, 1.05985, 1.04732],
    [1.19874, 1.17787, 1.11560, 1.05116, 1.17591, 1.17444, 1.05921, 1.06763, 1.04275, 1.05056],
    [1.12481, 1.01754, 1.06742, 1.01001, 1.17611, 1.18439, 1.07526, 1.04915, 1.10699, 1.13788],
    [1.10340, 1.11805, 1.18295, 1.03429, 1.12449, 1.07423, 1.00496, 1.05012, 1.17085, 1.03522],
    [1.07675, 1.00513, 1.09030, 1.03624, 1.05689, 1.13117, 1.06480, 1.19911, 1.07686, 1.04284],
    [1.12324, 1.11882, 1.00643, 1.06648, 1.17971, 1.07394, 1.04755, 1.18350, 1.02831, 1.16704],
    [1.13791, 1.14452, 1.02590, 1.00145, 1.14568, 1.01037, 1.09397, 1.00069, 1.13641, 1.07637],
    [1.17093, 1.17660, 1.09340, 1.03598, 1.14600, 1.05261, 1.17302, 1.14023, 1.00602, 1.14839],
    [1.07577, 1.00906, 1.02641, 1.13192, 1.01491, 1.05091, 1.13747, 1.04560, 1.06338, 1.14667],
    [1.09737, 1.11228, 1.16058, 1.15444, 1.00301, 1.12765, 1.16011, 1.09116, 1.17006, 1.14526],
    [1.19990, 1.14752, 1.11328, 1.06029, 1.17568, 1.19224, 1.05865, 1.19853, 1.19936, 1.12212],
    [1.11820, 1.11646, 1.02335, 1.11399, 1.15917, 1.11919, 1.11219, 1.13495, 1.09837, 1.10199],
    [1.14262, 1.16692, 1.05338, 1.02204, 1.01351, 1.10205, 1.08147, 1.00646, 1.14678, 1.16498],
    [1.13775, 1.00288, 1.16052, 1.01829, 1.18371, 1.17894, 1.09568, 1.00755, 1.07732, 1.17675],
    [1.07758, 1.10188, 1.17618, 1.02877, 1.19332, 1.18659, 1.08462, 1.04122, 1.06648, 1.06395],
    [1.07631, 1.05136, 1.11049, 1.01852, 1.02354, 1.16474, 1.14150, 1.10305, 1.16424, 1.17895],
    [1.13251, 1.00140, 1.13832, 1.19980, 1.18960, 1.02468, 1.02423, 1.05640, 1.13179, 1.09682],
    [1.00734, 1.02132, 1.15558, 1.08584, 1.01106, 1.04201, 1.16557, 1.13705, 1.12217, 1.18989],
    [1.05225, 1.16454, 1.14149, 1.13321, 1.09849, 1.15700, 1.09131, 1.14001, 1.19556, 1.05435],
    [1.01057, 1.01742, 1.05033, 1.05126, 1.06925, 1.09347, 1.06474, 1.08393, 1.13315, 1.04782],
    [1.06862, 1.15619, 1.01028, 1.09752, 1.18752, 1.06153, 1.11021, 1.14411, 1.02629, 1.15685],
    [1.14743, 1.18825, 1.05022, 1.14457, 1.02029, 1.01828, 1.14437, 1.11911, 1.09638, 1.07878],
    [1.03295, 1.03413, 1.03593, 1.12545, 1.13958, 1.04666, 1.18433, 1.17262, 1.16977, 1.09450],
    [1.06500, 1.13957, 1.19705, 1.16304, 1.00396, 1.10190, 1.13377, 1.19775, 1.01721, 1.15427],
    [1.16794, 1.11867, 1.19232, 1.19068, 1.04733, 1.09314, 1.09540, 1.00860, 1.19213, 1.12287],
    [1.03469, 1.04320, 1.11723, 1.10180, 1.11204, 1.13785, 1.14580, 1.00090, 1.09355, 1.05722],
    [1.09478, 1.13616, 1.03059, 1.14927, 1.11419, 1.17602, 1.06246, 1.06222, 1.16101, 1.04454],
    [1.13193, 1.12292, 1.08918, 1.17648, 1.04495, 1.08275, 1.03682, 1.08062, 1.00572, 1.03740],
    [1.09199, 1.06754, 1.05844, 1.02669, 1.11816, 1.09804, 1.16689, 1.12068, 1.12079, 1.00858],
    [1.16318, 1.09849, 1.03611, 1.06988, 1.09695, 1.12580, 1.12340, 1.13503, 1.01609, 1.13753],
    [1.04212, 1.13321, 1.11046, 1.13176, 1.19495, 1.16548, 1.04970, 1.08133, 1.01814, 1.15864],
    [1.04643, 1.06920, 1.00046, 1.13366, 1.07609, 1.15389, 1.11175, 1.04478, 1.18470, 1.17126],
    [1.02261, 1.04551, 1.11573, 1.17891, 1.19634, 1.13789, 1.18737, 1.14930, 1.03432, 1.06120],
    [1.05142, 1.01810, 1.15627, 1.17632, 1.06517, 1.09372, 1.19642, 1.00212, 1.10723, 1.13451],
    [1.19701, 1.16003, 1.16894, 1.09974, 1.18030, 1.18298, 1.15233, 1.08072, 1.18030, 1.14519],
    [1.00596, 1.01815, 1.11559, 1.16879, 1.02995, 1.11217, 1.18433, 1.16370, 1.08138, 1.13113],
    [1.16282, 1.05692, 1.11129, 1.12547, 1.08885, 1.06764, 1.16466, 1.15300, 1.11103, 1.08412],
    [1.07440, 1.12162, 1.18538, 1.09891, 1.18092, 1.15602, 1.00047, 1.15853, 1.10810, 1.19433],
    [1.01232, 1.18370, 1.12738, 1.02117, 1.17026, 1.11675, 1.14087, 1.04328, 1.01513, 1.15201],
    [1.01479, 1.01392, 1.13099, 1.10585, 1.09477, 1.01243, 1.03150, 1.08224, 1.03377, 1.08502],
    [1.06245, 1.09041, 1.16437, 1.05327, 1.00146, 1.17066, 1.14628, 1.09629, 1.13624, 1.08455],
    [1.12060, 1.01313, 1.10258, 1.12597, 1.10196, 1.17138, 1.06342, 1.10895, 1.03972, 1.04843],
    [1.11012, 1.08884, 1.07963, 1.17156, 1.06723, 1.07287, 1.05716, 1.16300, 1.18214, 1.07641],
    [1.15362, 1.09649, 1.08063, 1.18123, 1.14649, 1.07130, 1.06973, 1.15187, 1.18518, 1.01007],
    [1.16910, 1.06660, 1.12329, 1.18679, 1.15213, 1.11894, 1.13892, 1.09110, 1.17816, 1.04623],
    [1.07403, 1.13512, 1.09685, 1.14141, 1.02420, 1.00915, 1.00613, 1.10412, 1.01005, 1.19247],
    [1.14491, 1.08771, 1.06155, 1.02535, 1.10174, 1.19801, 1.14643, 1.04881, 1.02090, 1.00042],
    [1.07404, 1.01809, 1.18678, 1.09142, 1.00584, 1.09620, 1.06822, 1.09076, 1.10373, 1.03388],
    [1.00376, 1.11068, 1.14756, 1.04204, 1.00919, 1.05820, 1.05304, 1.16310, 1.08860, 1.02700],
    [1.12127, 1.04736, 1.13020, 1.13493, 1.15118, 1.14078, 1.16822, 1.06346, 1.04605, 1.19015],
    [1.09192, 1.05540, 1.04554, 1.07236, 1.18329, 1.02702, 1.01423, 1.05354, 1.16439, 1.15088],
    [1.11813, 1.08455, 1.13579, 1.16562, 1.12031, 1.03918, 1.08720, 1.16897, 1.02692, 1.10102],
    [1.16172, 1.15016, 1.11488, 1.00548, 1.15469, 1.01812, 1.07234, 1.14321, 1.02874, 1.18154],
    [1.08350, 1.03090, 1.12602, 1.03719, 1.18859, 1.15614, 1.05886, 1.02269, 1.15064, 1.10219],
    [1.16041, 1.18997, 1.16009, 1.15917, 1.07604, 1.15564, 1.00855, 1.12776, 1.17725, 1.18469],
    [1.06292, 1.12178, 1.17888, 1.06348, 1.07119, 1.07585, 1.04125, 1.11858, 1.13116, 1.16434],
    [1.13825, 1.03745, 1.05315, 1.03791, 1.17265, 1.04739, 1.04834, 1.08392, 1.02000, 1.10894],
    [1.17351, 1.01683, 1.18231, 1.07993, 1.06384, 1.00505, 1.03258, 1.10655, 1.18478, 1.04024],
    [1.13189, 1.19759, 1.13429, 1.15552, 1.19968, 1.03810, 1.02680, 1.19875, 1.01904, 1.19885],
    [1.08997, 1.16711, 1.05791, 1.19764, 1.10565, 1.00929, 1.08752, 1.16887, 1.02622, 1.10146],
    [1.17945, 1.19754, 1.19755, 1.10337, 1.16235, 1.07396, 1.11987, 1.00076, 1.11972, 1.12546],
    [1.17777, 1.04035, 1.00999, 1.08117, 1.07060, 1.16361, 1.19002, 1.02642, 1.17452, 1.04570],
    [1.12348, 1.00274, 1.16739, 1.14571, 1.05516, 1.10983, 1.14788, 1.07437, 1.13261, 1.06573],
    [1.17990, 1.08576, 1.15620, 1.08149, 1.09370, 1.19896, 1.03907, 1.00648, 1.07489, 1.15612],
    [1.15801, 1.00067, 1.07251, 1.12305, 1.07661, 1.09015, 1.15763, 1.13868, 1.02199, 1.06208],
    [1.06341, 1.01952, 1.19619, 1.05529, 1.03826, 1.12558, 1.10369, 1.10296, 1.04296, 1.09376],
    [1.17612, 1.18334, 1.02329, 1.14507, 1.07549, 1.03508, 1.08917, 1.07200, 1.15725, 1.09315],
    [1.13189, 1.11218, 1.07426, 1.00177, 1.11029, 1.01458, 1.00311, 1.06054, 1.13741, 1.10460],
    [1.07397, 1.05997, 1.19881, 1.05421, 1.08509, 1.06281, 1.03370, 1.16341, 1.08342, 1.18725],
    [1.01030, 1.05929, 1.09251, 1.14831, 1.12655, 1.01888, 1.16883, 1.01381, 1.16739, 1.02216],
    [1.06790, 1.13091, 1.15010, 1.14126, 1.10152, 1.07960, 1.08860, 1.17239, 1.06708, 1.00956],
    [1.00825, 1.11651, 1.03059, 1.01624, 1.04227, 1.01506, 1.04431, 1.11285, 1.14105, 1.14714],
    [1.18054, 1.05414, 1.02553, 1.09407, 1.16250, 1.16850, 1.11610, 1.07797, 1.17394, 1.05447],
    [1.06807, 1.08035, 1.12831, 1.09792, 1.04500, 1.14693, 1.17910, 1.06623, 1.16120, 1.18522],
    [1.15234, 1.13570, 1.02468, 1.06077, 1.08270, 1.00828, 1.01165, 1.09862, 1.13428, 1.07420],
    [1.00391, 1.19595, 1.08747, 1.07635, 1.02051, 1.05243, 1.07306, 1.03302, 1.07461, 1.12433],
    [1.13483, 1.07505, 1.08715, 1.00872, 1.10200, 1.15361, 1.18831, 1.06399, 1.15256, 1.07500],
    [1.03811, 1.17302, 1.14899, 1.01869, 1.09751, 1.05502, 1.12743, 1.19473, 1.08099, 1.03265],
    [1.02163, 1.19691, 1.12216, 1.06029, 1.00291, 1.10782, 1.08340, 1.11998, 1.11739, 1.11224],
    [1.14100, 1.19120, 1.00175, 1.07484, 1.07683, 1.10067, 1.15874, 1.03865, 1.00800, 1.05853],
    [1.17371, 1.10048, 1.18558, 1.18703, 1.15337, 1.01953, 1.19376, 1.04815, 1.16816, 1.01549],
    [1.18063, 1.07620, 1.17927, 1.11227, 1.05187, 1.12185, 1.03177, 1.08375, 1.05858, 1.01356],
    [1.19495, 1.15776, 1.11043, 1.14310, 1.03117, 1.13435, 1.04556, 1.18089, 1.07456, 1.07497],
    [1.18832, 1.12784, 1.10058, 1.01850, 1.02612, 1.00970, 1.06805, 1.08045, 1.13671, 1.02025],
    [1.11448, 1.19169, 1.19712, 1.01955, 1.08634, 1.03284, 1.00541, 1.19355, 1.18525, 1.02062],
    [1.14668, 1.18127, 1.01146, 1.10244, 1.03430, 1.07577, 1.18587, 1.01534, 1.15804, 1.00525],
    [1.03173, 1.16575, 1.06973, 1.10049, 1.09751, 1.18615, 1.13849, 1.15478, 1.00188, 1.12493],
    [1.00593, 1.18273, 1.18228, 1.12572, 1.17330, 1.18423, 1.02824, 1.15242, 1.05139, 1.11961],
    [1.18077, 1.01613, 1.10458, 1.00244, 1.07889, 1.06041, 1.02031, 1.11620, 1.13481, 1.16084],
    [1.13520, 1.06093, 1.01878, 1.19540, 1.04898, 1.03630, 1.03505, 1.04174, 1.05770, 1.06721],
    [1.06995, 1.05771, 1.13720, 1.17820, 1.09367, 1.10124, 1.10824, 1.02302, 1.09664, 1.04605],
    [1.11465, 1.17545, 1.04202, 1.04922, 1.04542, 1.18769, 1.11545, 1.12701, 1.03235, 1.02267],
    [1.05325, 1.09510, 1.05424, 1.16634, 1.03049, 1.02959, 1.17904, 1.02634, 1.08999, 1.10488],
    [1.07503, 1.12323, 1.19361, 1.16479, 1.12256, 1.08054, 1.07703, 1.08314, 1.15727, 1.11996],
    [1.18942, 1.07004, 1.17631, 1.06776, 1.09893, 1.18011, 1.03859, 1.17885, 1.04558, 1.17886],
    [1.09060, 1.18467, 1.02268, 1.02366, 1.14864, 1.07113, 1.06789, 1.11526, 1.16913, 1.19292],
    [1.14541, 1.17638, 1.03795, 1.03029, 1.10042, 1.11338, 1.01029, 1.19489, 1.06698, 1.11755],
    [1.03194, 1.19033, 1.01074, 1.16194, 1.07369, 1.13448, 1.18768, 1.15024, 1.10973, 1.14902],
    [1.00002, 1.07382, 1.07146, 1.02294, 1.03085, 1.03327, 1.00806, 1.05622, 1.13824, 1.08058],
    [1.18472, 1.08959, 1.19060, 1.13832, 1.15026, 1.02714, 1.12423, 1.15199, 1.10495, 1.05759],
    [1.10437, 1.13187, 1.00010, 1.08066, 1.07100, 1.04053, 1.10043, 1.14481, 1.05069, 1.18232],
    [1.04070, 1.00253, 1.11574, 1.05100, 1.10761, 1.18951, 1.17175, 1.09196, 1.17846, 1.13374],
    [1.05506, 1.13497, 1.04756, 1.10117, 1.12112, 1.15403, 1.17195, 1.08374, 1.00513, 1.11034],
    [1.16733, 1.03631, 1.13634, 1.13474, 1.08580, 1.16874, 1.08684, 1.00588, 1.00637, 1.09918],
    [1.13666, 1.18031, 1.16966, 1.17501, 1.13592, 1.13077, 1.18798, 1.16760, 1.04563, 1.04898],
    [1.16204, 1.04713, 1.03815, 1.06910, 1.03562, 1.04375, 1.13877, 1.06809, 1.01927, 1.10130],
    [1.08947, 1.19943, 1.01445, 1.12991, 1.01624, 1.01605, 1.06937, 1.16360, 1.18118, 1.13928],
    [1.19761, 1.02927, 1.00051, 1.12941, 1.19098, 1.03328, 1.01005, 1.11473, 1.15770, 1.07173],
    [1.15897, 1.03487, 1.01724, 1.07103, 1.11352, 1.05490, 1.08313, 1.16462, 1.15162, 1.00635],
    [1.16475, 1.11230, 1.12982, 1.01147, 1.11963, 1.16851, 1.10371, 1.14696, 1.08738, 1.10552],
    [1.08314, 1.10327, 1.13651, 1.19805, 1.10343, 1.09608, 1.15530, 1.07544, 1.09383, 1.18575],
    [1.11820, 1.04765, 1.12453, 1.06139, 1.15878, 1.01135, 1.11344, 1.04554, 1.18057, 1.14234],
    [1.17397, 1.17587, 1.03713, 1.08045, 1.08502, 1.11999, 1.01238, 1.01350, 1.06461, 1.17984],
    [1.03266, 1.16604, 1.12816, 1.14167, 1.14167, 1.09968, 1.01285, 1.02802, 1.06950, 1.13083],
    [1.14922, 1.10794, 1.02716, 1.07236, 1.06129, 1.02155, 1.15757, 1.00526, 1.07645, 1.17545],
    [1.17466, 1.08673, 1.12637, 1.06497, 1.02144, 1.10074, 1.12016, 1.07969, 1.07851, 1.15749],
    [1.07105, 1.04834, 1.15428, 1.04793, 1.05786, 1.07951, 1.18794, 1.05961, 1.00244, 1.15420],
    [1.09673, 1.16006, 1.14444, 1.02665, 1.09848, 1.15411, 1.19451, 1.08962, 1.14084, 1.12116],
    [1.04732, 1.16030, 1.16840, 1.13887, 1.03564, 1.04326, 1.05893, 1.19938, 1.00657, 1.02657],
    [1.16007, 1.12438, 1.00141, 1.16736, 1.05755, 1.18525, 1.02015, 1.12309, 1.10643, 1.03453],
    [1.05216, 1.18481, 1.15636, 1.05497, 1.05396, 1.06851, 1.00233, 1.13241, 1.05567, 1.12112],
    [1.19202, 1.15871, 1.07707, 1.09701, 1.12098, 1.07106, 1.03483, 1.16155, 1.04710, 1.13384],
    [1.12187, 1.07786, 1.15533, 1.06927, 1.04030, 1.03303, 1.10406, 1.14325, 1.16919, 1.05997],
    [1.18449, 1.01237, 1.04815, 1.11129, 1.12403, 1.03865, 1.05848, 1.14137, 1.06513, 1.07800],
    [1.08252, 1.05282, 1.15080, 1.04881, 1.02298, 1.06375, 1.04791, 1.08686, 1.16325, 1.15192],
    [1.03974, 1.19283, 1.04986, 1.13207, 1.01884, 1.17856, 1.07861, 1.02276, 1.01162, 1.01849],
    [1.06535, 1.05894, 1.16572, 1.01234, 1.18288, 1.00638, 1.03161, 1.06546, 1.14497, 1.13434],
    [1.06955, 1.09289, 1.01904, 1.10273, 1.01315, 1.05362, 1.14858, 1.11997, 1.02091, 1.02109],
    [1.16645, 1.02770, 1.04682, 1.19634, 1.18065, 1.06890, 1.16139, 1.06987, 1.11343, 1.19518],
    [1.05430, 1.03873, 1.07532, 1.07006, 1.04998, 1.08487, 1.15501, 1.02401, 1.06726, 1.02097],
    [1.10663, 1.11778, 1.05449, 1.11033, 1.11551, 1.17013, 1.13125, 1.16656, 1.12364, 1.10631],
    [1.16796, 1.13984, 1.09624, 1.08349, 1.03463, 1.09558, 1.11056, 1.14936, 1.05002, 1.19207],
    [1.04815, 1.09018, 1.06244, 1.16303, 1.17198, 1.02462, 1.09337, 1.11164, 1.16948, 1.19941],
    [1.17536, 1.12206, 1.14294, 1.14331, 1.11514, 1.09482, 1.12839, 1.03552, 1.01356, 1.11228],
    [1.02418, 1.04472, 1.07329, 1.14038, 1.11068, 1.09510, 1.12566, 1.17303, 1.04219, 1.01567],
    [1.00803, 1.02529, 1.09239, 1.12892, 1.02260, 1.08165, 1.13448, 1.03516, 1.00825, 1.00559],
    [1.13746, 1.04900, 1.05653, 1.11680, 1.05961, 1.04379, 1.00289, 1.04212, 1.12044, 1.16069],
    [1.12477, 1.14669, 1.13248, 1.13835, 1.17737, 1.15129, 1.07407, 1.11961, 1.19869, 1.04239],
    [1.18439, 1.09134, 1.01495, 1.08091, 1.16200, 1.01376, 1.07759, 1.01613, 1.14822, 1.19550],
    [1.16322, 1.11093, 1.07640, 1.17051, 1.16766, 1.08454, 1.06860, 1.03333, 1.12543, 1.17922],
    [1.06065, 1.08863, 1.08583, 1.05694, 1.13707, 1.17164, 1.17693, 1.13240, 1.15698, 1.09536],
    [1.08871, 1.04865, 1.15222, 1.18109, 1.10658, 1.10156, 1.07911, 1.12838, 1.12651, 1.11926],
    [1.00485, 1.18067, 1.18313, 1.00307, 1.10997, 1.04289, 1.12189, 1.03588, 1.18812, 1.10728],
    [1.14666, 1.16438, 1.02426, 1.04364, 1.07393, 1.16146, 1.13272, 1.11026, 1.02495, 1.07476],
    [1.03619, 1.04192, 1.18700, 1.06803, 1.16704, 1.07090, 1.17495, 1.06110, 1.17210, 1.13764],
    [1.02465, 1.07507, 1.10227, 1.04697, 1.14908, 1.08872, 1.06810, 1.02634, 1.08860, 1.11266],
    [1.04263, 1.04227, 1.18675, 1.08710, 1.19277, 1.13121, 1.02252, 1.10988, 1.02046, 1.10114],
    [1.13067, 1.00069, 1.09478, 1.06013, 1.04104, 1.10800, 1.05642, 1.12803, 1.16836, 1.16469],
    [1.07557, 1.18771, 1.18362, 1.09884, 1.04464, 1.03196, 1.19844, 1.00582, 1.08698, 1.16232],
    [1.19343, 1.18799, 1.06285, 1.19615, 1.02211, 1.06814, 1.05393, 1.13811, 1.02130, 1.08312],
    [1.10756, 1.07244, 1.15956, 1.16376, 1.02206, 1.13206, 1.15463, 1.10727, 1.05422, 1.10094],
    [1.09134, 1.04867, 1.13041, 1.10597, 1.17121, 1.13710, 1.04235, 1.15444, 1.12478, 1.02355],
    [1.00903, 1.17354, 1.11826, 1.06619, 1.08574, 1.10803, 1.08542, 1.05948, 1.00172, 1.13238],
    [1.11623, 1.19335, 1.10755, 1.13360, 1.03334, 1.04876, 1.01357, 1.12105, 1.18774, 1.13582],
    [1.00051, 1.11938, 1.00469, 1.18069, 1.18372, 1.00105, 1.11151, 1.06764, 1.11206, 1.01444],
    [1.17800, 1.04235, 1.18295, 1.06394, 1.10122, 1.08289, 1.15452, 1.09828, 1.06558, 1.04439],
    [1.13639, 1.06326, 1.10948, 1.08396, 1.14020, 1.17529, 1.13001, 1.17178, 1.17112, 1.17167],
    [1.15665, 1.19487, 1.14164, 1.09433, 1.02546, 1.05962, 1.18887, 1.06287, 1.08483, 1.09949],
    [1.07667, 1.19329, 1.06416, 1.19393, 1.06366, 1.11874, 1.13672, 1.10491, 1.11864, 1.06850],
    [1.10777, 1.03737, 1.06444, 1.16130, 1.15951, 1.12962, 1.13155, 1.06942, 1.08377, 1.08013],
    [1.10277, 1.10976, 1.03387, 1.01688, 1.13019, 1.11805, 1.12693, 1.01559, 1.00549, 1.16255],
    [1.12776, 1.17294, 1.16532, 1.05350, 1.14565, 1.04119, 1.01234, 1.10439, 1.17536, 1.13035],
    [1.03382, 1.10156, 1.01340, 1.08417, 1.09861, 1.13823, 1.18103, 1.03624, 1.01385, 1.06917],
    [1.18513, 1.15237, 1.12284, 1.04238, 1.14816, 1.06558, 1.02499, 1.06399, 1.13864, 1.00997],
    [1.19946, 1.05250, 1.03309, 1.15951, 1.01340, 1.13890, 1.04104, 1.17835, 1.09641, 1.06859],
    [1.12404, 1.08856, 1.16202, 1.06157, 1.04013, 1.06179, 1.05788, 1.18710, 1.04497, 1.04096],
    [1.12564, 1.00897, 1.18079, 1.19831, 1.05186, 1.15790, 1.18453, 1.13595, 1.09114, 1.18691],
    [1.14638, 1.03540, 1.04287, 1.16634, 1.14993, 1.06200, 1.06260, 1.17452, 1.02521, 1.03084],
    [1.08958, 1.14030, 1.04590, 1.04013, 1.17147, 1.19390, 1.10189, 1.07849, 1.06752, 1.18215],
    [1.17853, 1.11222, 1.01170, 1.10450, 1.07373, 1.05902, 1.01665, 1.12586, 1.18423, 1.15420],
    [1.19999, 1.12278, 1.09220, 1.11574, 1.11410, 1.01898, 1.18359, 1.01442, 1.16079, 1.06667],
    [1.02926, 1.05535, 1.07177, 1.12972, 1.16032, 1.17692, 1.13660, 1.12513, 1.16884, 1.07376],
    [1.15901, 1.07891, 1.16517, 1.14964, 1.02305, 1.15267, 1.12321, 1.00681, 1.05027, 1.09711],
    [1.14477, 1.17779, 1.02909, 1.08885, 1.17438, 1.10613, 1.09778, 1.00657, 1.19563, 1.08208],
    [1.16212, 1.10290, 1.04052, 1.13982, 1.02915, 1.12832, 1.04293, 1.02201, 1.13815, 1.06316],
    [1.06738, 1.01835, 1.07009, 1.11416, 1.14457, 1.18416, 1.11697, 1.13165, 1.04467, 1.14526],
    [1.09203, 1.10372, 1.01992, 1.19546, 1.06232, 1.08361, 1.04746, 1.09293, 1.18477, 1.00648],
    [1.00387, 1.06149, 1.12700, 1.15200, 1.10263, 1.00344, 1.05416, 1.10879, 1.02563, 1.02975],
    [1.06306, 1.19708, 1.08021, 1.11428, 1.04476, 1.00590, 1.01268, 1.17792, 1.05698, 1.00087],
    [1.00986, 1.00916, 1.18748, 1.05904, 1.11970, 1.12718, 1.18974, 1.08678, 1.02225, 1.19379],
    [1.07219, 1.17737, 1.18241, 1.08046, 1.12207, 1.06402, 1.11541, 1.19666, 1.14549, 1.12508],
    [1.19655, 1.18575, 1.00457, 1.09725, 1.14622, 1.19479, 1.03327, 1.15340, 1.02171, 1.02434],
    [1.01285, 1.10102, 1.04677, 1.16460, 1.08841, 1.15762, 1.11034, 1.02415, 1.10770, 1.05936],
    [1.06577, 1.15757, 1.16341, 1.15912, 1.06154, 1.19800, 1.02025, 1.07027, 1.03497, 1.10114],
    [1.00806, 1.11242, 1.00004, 1.00682, 1.06213, 1.11529, 1.06057, 1.12438, 1.09211, 1.03719],
    [1.18010, 1.14807, 1.16062, 1.15401, 1.03959, 1.00887, 1.05290, 1.07531, 1.01437, 1.06887],
    [1.11878, 1.14358, 1.00132, 1.16441, 1.16805, 1.07288, 1.12786, 1.00439, 1.10067, 1.18329],
    [1.07369, 1.12984, 1.05305, 1.08723, 1.03679, 1.14110, 1.14145, 1.18406, 1.07470, 1.19881],
    [1.18402, 1.01902, 1.05255, 1.10501, 1.08255, 1.06300, 1.12884, 1.17055, 1.04525, 1.16919],
    [1.01055, 1.17504, 1.13183, 1.06292, 1.10844, 1.02567, 1.10197, 1.12104, 1.02416, 1.02118],
    [1.04874, 1.19687, 1.10015, 1.12695, 1.19791, 1.14726, 1.06365, 1.16790, 1.15450, 1.01767],
    [1.09627, 1.14507, 1.17800, 1.14192, 1.16000, 1.18234, 1.16717, 1.11244, 1.11122, 1.10945],
    [1.13603, 1.07758, 1.03388, 1.18763, 1.06192, 1.12214, 1.12293, 1.18400, 1.08731, 1.18725],
    [1.14955, 1.10114, 1.15612, 1.08608, 1.03920, 1.16791, 1.06629, 1.07142, 1.19377, 1.19784],
    [1.01948, 1.11148, 1.08918, 1.12143, 1.04928, 1.13016, 1.17965, 1.19846, 1.00927, 1.16799],
    [1.03972, 1.11664, 1.10202, 1.12008, 1.17562, 1.08286, 1.03041, 1.00720, 1.03681, 1.11326],
    [1.15242, 1.03638, 1.05933, 1.02832, 1.12069, 1.00720, 1.07196, 1.15940, 1.18816, 1.11994],
    [1.09652, 1.07274, 1.06086, 1.14211, 1.07361, 1.11737, 1.07937, 1.18925, 1.14494, 1.10301],
    [1.00985, 1.07657, 1.02357, 1.11443, 1.02629, 1.09749, 1.08329, 1.16822, 1.16487, 1.18535],
    [1.09839, 1.11858, 1.03192, 1.11461, 1.06508, 1.11799, 1.04661, 1.09779, 1.03577, 1.03937],
    [1.19967, 1.03427, 1.19755, 1.16573, 1.00936, 1.16740, 1.12597, 1.15366, 1.05601, 1.00595],
    [1.04559, 1.17693, 1.17621, 1.06637, 1.02825, 1.05637, 1.09815, 1.09192, 1.16065, 1.08241],
    [1.19915, 1.10507, 1.01220, 1.13633, 1.16669, 1.14930, 1.03461, 1.01668, 1.04428, 1.07664],
    [1.02424, 1.17701, 1.04326, 1.03712, 1.07873, 1.18113, 1.00193, 1.02648, 1.17894, 1.08229],
    [1.07319, 1.14830, 1.02752, 1.03234, 1.12186, 1.14679, 1.07548, 1.12730, 1.01315, 1.06668],
    [1.16769, 1.19542, 1.07332, 1.19610, 1.13904, 1.13415, 1.10385, 1.14911, 1.19200, 1.10219],
    [1.03035, 1.04381, 1.18722, 1.17275, 1.16763, 1.03244, 1.07821, 1.15454, 1.18180, 1.13971],
    [1.02141, 1.18652, 1.13116, 1.06554, 1.19296, 1.01268, 1.06657, 1.10852, 1.04323, 1.14327],
    [1.17311, 1.06635, 1.02069, 1.00845, 1.13374, 1.06942, 1.09594, 1.11092, 1.09676, 1.00392],
    [1.11758, 1.08353, 1.12773, 1.08059, 1.13081, 1.05827, 1.12768, 1.00543, 1.09036, 1.05281],
    [1.09842, 1.10869, 1.09857, 1.18085, 1.13641, 1.08820, 1.00032, 1.19261, 1.03639, 1.12348],
    [1.06576, 1.15160, 1.08606, 1.01677, 1.19216, 1.15398, 1.13299, 1.11728, 1.15621, 1.09675],
    [1.10503, 1.08489, 1.14791, 1.00100, 1.06555, 1.04953, 1.11739, 1.09654, 1.18462, 1.02255],
    [1.16583, 1.17403, 1.10750, 1.11629, 1.11182, 1.01102, 1.10168, 1.02806, 1.06432, 1.17801],
    [1.06358, 1.14485, 1.13352, 1.03085, 1.16634, 1.12502, 1.11085, 1.19574, 1.02990, 1.11316],
    [1.04937, 1.15303, 1.19456, 1.04439, 1.17582, 1.02613, 1.17923, 1.19443, 1.06552, 1.18173],
    [1.10586, 1.03151, 1.11149, 1.14756, 1.17102, 1.12663, 1.01883, 1.05405, 1.14598, 1.17813],
    [1.15591, 1.10606, 1.18666, 1.10705, 1.09325, 1.09084, 1.13448, 1.07943, 1.16177, 1.02868],
    [1.18957, 1.01179, 1.16122, 1.17238, 1.13744, 1.01608, 1.05037, 1.06170, 1.01040, 1.14034],
    [1.15009, 1.03928, 1.16510, 1.06126, 1.09048, 1.13398, 1.05717, 1.08506, 1.03353, 1.11820],
    [1.09454, 1.11267, 1.00226, 1.04516, 1.05040, 1.12575, 1.04793, 1.07262, 1.01729, 1.04957],
    [1.08618, 1.07904, 1.18333, 1.14916, 1.13380, 1.07868, 1.01204, 1.01485, 1.17690, 1.14175],
    [1.10699, 1.09355, 1.00218, 1.02588, 1.14226, 1.02200, 1.02219, 1.02514, 1.14043, 1.11819],
    [1.02606, 1.04294, 1.07885, 1.08720, 1.08686, 1.19498, 1.10586, 1.09787, 1.15678, 1.14853],
    [1.14784, 1.08628, 1.18160, 1.10428, 1.18876, 1.04251, 1.06540, 1.02705, 1.00300, 1.13684],
    [1.11698, 1.03156, 1.02311, 1.04163, 1.10916, 1.12947, 1.12353, 1.10520, 1.18226, 1.04414],
    [1.00150, 1.13388, 1.12287, 1.09904, 1.13667, 1.03848, 1.04937, 1.08641, 1.01027, 1.10159],
    [1.03528, 1.12210, 1.16543, 1.12164, 1.10178, 1.19312, 1.18972, 1.19033, 1.11056, 1.00388],
    [1.00118, 1.15944, 1.18842, 1.02765, 1.11921, 1.15336, 1.01462, 1.16925, 1.10133, 1.18355],
    [1.00255, 1.14532, 1.02736, 1.02124, 1.10659, 1.18851, 1.01199, 1.18456, 1.08575, 1.18162],
    [1.02719, 1.19634, 1.15517, 1.02817, 1.01562, 1.16897, 1.05673, 1.16554, 1.17627, 1.07233],
    [1.08008, 1.02679, 1.00369, 1.14129, 1.06529, 1.15783, 1.16190, 1.17879, 1.11843, 1.19564],
    [1.17435, 1.01101, 1.07122, 1.01428, 1.01121, 1.05064, 1.01616, 1.04458, 1.15505, 1.02467],
    [1.14820, 1.07401, 1.02638, 1.02278, 1.04442, 1.13282, 1.15021, 1.12286, 1.01271, 1.17275],
    [1.14478, 1.14953, 1.04099, 1.14466, 1.11391, 1.02229, 1.17794, 1.18111, 1.12409, 1.04923],
    [1.07668, 1.09034, 1.14752, 1.02279, 1.13265, 1.06786, 1.15251, 1.07370, 1.14674, 1.03177],
    [1.12233, 1.13934, 1.14518, 1.08825, 1.08387, 1.00284, 1.08726, 1.13332, 1.12726, 1.15914],
    [1.09224, 1.09723, 1.09781, 1.06416, 1.11659, 1.03761, 1.14146, 1.02358, 1.11291, 1.18778],
    [1.18494, 1.07721, 1.00172, 1.16630, 1.13202, 1.13534, 1.08746, 1.05416, 1.05698, 1.12326],
    [1.04974, 1.14583, 1.17660, 1.19035, 1.14136, 1.08023, 1.08193, 1.13971, 1.12416, 1.15826],
    [1.01107, 1.13489, 1.17407, 1.15270, 1.04421, 1.03969, 1.08641, 1.01702, 1.00220, 1.04755],
    [1.01303, 1.19938, 1.12984, 1.15655, 1.06217, 1.16769, 1.14529, 1.14636, 1.19255, 1.05253],
    [1.13659, 1.01344, 1.13283, 1.01375, 1.08684, 1.12070, 1.15770, 1.03713, 1.10909, 1.01779],
    [1.05186, 1.16746, 1.17221, 1.18843, 1.09320, 1.08412, 1.19908, 1.08086, 1.18625, 1.02552],
    [1.11825, 1.07785, 1.17739, 1.16868, 1.15046, 1.16230, 1.08287, 1.06995, 1.11100, 1.13482],
    [1.06105, 1.07356, 1.00953, 1.13961, 1.05993, 1.09380, 1.12830, 1.15467, 1.17140, 1.07735],
    [1.06012, 1.00276, 1.02334, 1.15197, 1.08747, 1.13935, 1.04091, 1.16772, 1.18373, 1.17367],
    [1.10815, 1.03699, 1.01799, 1.17938, 1.06129, 1.17972, 1.04467, 1.15073, 1.14493, 1.07978],
    [1.05908, 1.06090, 1.06234, 1.05910, 1.10029, 1.07837, 1.15120, 1.07547, 1.08247, 1.19777],
    [1.11590, 1.05054, 1.03606, 1.04155, 1.04782, 1.13412, 1.13993, 1.08847, 1.16470, 1.01096],
    [1.02576, 1.08534, 1.00040, 1.05654, 1.13603, 1.09825, 1.07632, 1.04779, 1.01664, 1.15942],
    [1.18571, 1.03513, 1.12573, 1.16609, 1.12207, 1.08224, 1.03956, 1.18759, 1.18307, 1.07951],
    [1.03709, 1.03677, 1.08090, 1.13762, 1.14417, 1.06233, 1.19078, 1.16746, 1.01887, 1.01788],
    [1.16833, 1.15258, 1.15902, 1.16438, 1.06754, 1.12058, 1.01323, 1.06188, 1.19030, 1.11941],
    [1.07677, 1.00714, 1.19879, 1.00516, 1.15337, 1.17307, 1.12211, 1.14733, 1.06433, 1.00635],
    [1.18818, 1.05792, 1.18616, 1.13969, 1.11236, 1.05073, 1.09798, 1.17453, 1.17396, 1.13680],
    [1.11987, 1.19092, 1.11181, 1.06253, 1.02358, 1.14050, 1.17036, 1.09670, 1.09673, 1.17891],
    [1.12728, 1.07238, 1.04171, 1.09397, 1.03404, 1.09033, 1.09067, 1.08580, 1.10060, 1.18996],
    [1.01778, 1.05507, 1.05546, 1.19398, 1.02993, 1.05579, 1.01246, 1.03331, 1.01726, 1.06881],
    [1.17532, 1.15822, 1.14472, 1.15215, 1.01140, 1.14206, 1.06579, 1.12469, 1.02590, 1.08380],
    [1.13989, 1.03922, 1.16761, 1.11571, 1.13435, 1.00119, 1.19757, 1.02233, 1.19258, 1.18949],
    [1.05191, 1.07698, 1.14940, 1.03531, 1.13009, 1.10215, 1.17488, 1.01560, 1.13966, 1.05999],
    [1.02805, 1.01710, 1.02909, 1.17903, 1.10148, 1.12741, 1.03961, 1.12361, 1.13824, 1.00920],
    [1.00745, 1.01199, 1.00232, 1.11396, 1.14785, 1.18972, 1.18385, 1.09135, 1.05172, 1.16410],
    [1.02027, 1.05058, 1.12671, 1.00648, 1.11488, 1.02996, 1.01346, 1.02821, 1.13377, 1.13088],
    [1.00864, 1.03668, 1.06261, 1.07258, 1.02576, 1.17779, 1.10446, 1.02377, 1.12520, 1.07090],
    [1.09976, 1.06751, 1.14457, 1.04266, 1.04990, 1.15553, 1.06082, 1.16590, 1.02561, 1.10826],
    [1.01509, 1.10981, 1.04118, 1.11680, 1.03184, 1.10783, 1.17621, 1.10312, 1.16326, 1.04915],
    [1.12558, 1.19465, 1.09037, 1.00055, 1.05948, 1.06967, 1.11206, 1.16432, 1.17422, 1.02957],
    [1.15318, 1.17893, 1.01544, 1.15436, 1.12303, 1.16844, 1.15476, 1.19756, 1.05559, 1.04705],
    [1.10127, 1.17695, 1.16256, 1.08492, 1.02899, 1.11709, 1.03048, 1.04159, 1.00157, 1.10014],
    [1.09339, 1.07323, 1.07556, 1.08117, 1.01203, 1.12001, 1.16343, 1.02404, 1.09097, 1.17969],
    [1.03756, 1.01439, 1.16481, 1.17389, 1.15661, 1.10572, 1.08487, 1.01320, 1.09524, 1.15495],
    [1.03750, 1.16722, 1.05875, 1.00373, 1.02520, 1.14612, 1.06363, 1.06165, 1.14198, 1.19963],
    [1.06545, 1.04766, 1.17402, 1.03995, 1.01520, 1.14597, 1.15708, 1.09471, 1.12547, 1.13263],
    [1.02170, 1.09619, 1.12754, 1.12907, 1.15759, 1.11328, 1.00087, 1.13885, 1.02839, 1.03206],
    [1.15599, 1.02384, 1.06811, 1.19168, 1.15219, 1.07616, 1.19039, 1.18133, 1.13128, 1.04194],
    [1.14199, 1.10503, 1.04855, 1.15352, 1.03156, 1.12006, 1.08226, 1.02580, 1.06521, 1.15555],
    [1.10290, 1.17359, 1.01974, 1.01741, 1.18347, 1.00566, 1.08529, 1.18580, 1.03206, 1.05222],
    [1.00813, 1.11142, 1.12785, 1.08163, 1.16524, 1.11695, 1.04198, 1.06301, 1.10172, 1.10976],
    [1.12438, 1.03068, 1.16239, 1.01215, 1.03784, 1.00683, 1.14870, 1.11556, 1.12071, 1.03870],
    [1.03236, 1.06471, 1.05922, 1.10635, 1.05683, 1.07815, 1.05090, 1.15752, 1.05792, 1.11142],
    [1.14026, 1.02557, 1.13488, 1.16888, 1.10796, 1.08695, 1.10296, 1.07084, 1.19479, 1.01435],
    [1.05905, 1.08184, 1.04159, 1.08180, 1.09132, 1.10658, 1.12653, 1.17797, 1.06433, 1.05970],
    [1.08081, 1.18392, 1.11073, 1.11558, 1.16423, 1.07160, 1.16092, 1.04449, 1.08164, 1.17922],
    [1.14175, 1.14136, 1.02180, 1.01989, 1.17568, 1.15333, 1.09968, 1.07970, 1.01160, 1.11236],
    [1.08350, 1.16149, 1.01848, 1.07926, 1.18787, 1.13053, 1.17316, 1.10517, 1.01408, 1.01853],
    [1.17362, 1.01699, 1.01906, 1.14198, 1.10878, 1.13282, 1.19394, 1.19125, 1.01627, 1.11373],
    [1.13374, 1.14658, 1.15927, 1.05811, 1.17928, 1.17742, 1.15383, 1.04489, 1.01262, 1.18103],
    [1.17774, 1.03181, 1.18728, 1.11694, 1.19236, 1.11496, 1.17438, 1.19330, 1.00855, 1.05600],
    [1.00620, 1.06138, 1.12799, 1.08318, 1.09818, 1.07466, 1.19120, 1.07235, 1.13063, 1.16847],
    [1.16334, 1.11443, 1.17151, 1.01669, 1.08924, 1.17537, 1.12154, 1.02163, 1.14885, 1.05495],
    [1.06268, 1.19331, 1.04418, 1.15071, 1.19152, 1.07453, 1.04929, 1.03312, 1.11855, 1.16783],
    [1.15437, 1.13844, 1.01486, 1.02064, 1.03511, 1.18527, 1.18719, 1.02496, 1.07893, 1.02132],
    [1.16283, 1.08769, 1.19886, 1.10642, 1.06552, 1.02788, 1.06669, 1.13812, 1.16366, 1.05726],
    [1.09655, 1.02613, 1.17195, 1.00020, 1.01000, 1.12185, 1.18787, 1.00931, 1.11415, 1.10920],
    [1.04408, 1.03307, 1.12375, 1.06306, 1.15828, 1.19166, 1.05890, 1.08150, 1.06132, 1.11717],
    [1.04918, 1.19814, 1.08530, 1.01459, 1.17580, 1.18076, 1.19256, 1.09973, 1.18286, 1.12258],
    [1.02698, 1.17032, 1.18896, 1.03230, 1.16882, 1.16659, 1.03054, 1.12926, 1.07422, 1.07756],
    [1.16800, 1.04987, 1.08090, 1.04923, 1.18609, 1.07172, 1.16091, 1.05105, 1.01951, 1.16140],
    [1.00207, 1.15679, 1.13539, 1.15247, 1.09908, 1.19609, 1.00341, 1.05976, 1.03569, 1.03306],
    [1.08527, 1.03622, 1.03909, 1.02802, 1.07438, 1.17861, 1.18788, 1.13863, 1.01735, 1.08823],
    [1.15475, 1.01684, 1.04823, 1.19309, 1.06518, 1.15777, 1.16701, 1.13752, 1.15347, 1.05669],
    [1.19338, 1.04569, 1.19718, 1.03058, 1.12726, 1.16521, 1.01144, 1.06035, 1.04716, 1.09699],
    [1.18423, 1.10997, 1.17767, 1.11776, 1.13383, 1.07885, 1.05734, 1.00140, 1.07003, 1.04369],
    [1.03826, 1.04528, 1.13983, 1.14595, 1.04843, 1.10803, 1.13935, 1.18138, 1.04840, 1.16480],
    [1.07290, 1.04766, 1.11314, 1.18640, 1.14064, 1.10658, 1.17074, 1.04852, 1.03591, 1.01681],
    [1.12878, 1.07725, 1.13371, 1.09378, 1.02008, 1.13717, 1.05128, 1.15257, 1.09865, 1.06832],
    [1.16237, 1.09043, 1.11734, 1.17821, 1.14613, 1.16494, 1.11846, 1.19514, 1.15210, 1.02402],
    [1.16840, 1.18915, 1.06245, 1.04435, 1.16774, 1.06676, 1.03270, 1.03404, 1.16801, 1.14582],
    [1.19227, 1.05615, 1.12624, 1.01662, 1.08596, 1.02906, 1.12876, 1.19568, 1.13779, 1.06013],
    [1.01533, 1.17826, 1.11828, 1.16875, 1.03492, 1.19604, 1.09654, 1.15510, 1.06441, 1.08610],
    [1.05836, 1.07090, 1.02138, 1.17742, 1.07156, 1.04835, 1.00233, 1.00129, 1.17986, 1.14349],
    [1.17754, 1.13176, 1.10653, 1.15027, 1.17378, 1.16242, 1.14903, 1.04165, 1.17622, 1.12574],
    [1.14593, 1.19380, 1.08068, 1.16131, 1.09737, 1.04977, 1.12757, 1.13907, 1.12022, 1.17898],
    [1.14865, 1.04386, 1.11932, 1.18848, 1.05799, 1.02770, 1.05595, 1.04254, 1.11833, 1.13573],
    [1.19486, 1.04669, 1.01401, 1.01224, 1.01097, 1.05236, 1.06186, 1.19319, 1.13722, 1.13863],
    [1.19120, 1.09109, 1.03455, 1.12704, 1.02424, 1.07888, 1.16552, 1.18591, 1.08811, 1.17881],
    [1.15256, 1.08039, 1.08977, 1.16261, 1.10239, 1.12445, 1.08511, 1.16937, 1.17758, 1.19103],
    [1.07340, 1.04708, 1.19669, 1.03665, 1.04838, 1.12444, 1.14413, 1.09685, 1.03723, 1.01876],
    [1.17110, 1.00833, 1.15874, 1.18670, 1.16875, 1.01459, 1.03181, 1.02358, 1.09483, 1.11078],
    [1.16561, 1.01805, 1.13522, 1.08437, 1.06262, 1.16778, 1.08126, 1.10778, 1.06588, 1.16297],
    [1.00466, 1.03916, 1.08147, 1.14361, 1.01058, 1.08766, 1.00784, 1.13675, 1.15076, 1.19940],
    [1.00285, 1.18021, 1.07746, 1.02033, 1.02008, 1.03877, 1.11984, 1.19246, 1.14542, 1.11930],
    [1.16370, 1.03929, 1.16539, 1.09084, 1.01608, 1.19722, 1.09832, 1.01606, 1.03588, 1.04866],
    [1.11967, 1.10039, 1.11167, 1.11356, 1.01269, 1.06480, 1.16806, 1.05522, 1.17584, 1.04882],
    [1.08190, 1.05693, 1.11797, 1.04982, 1.18937, 1.02546, 1.07274, 1.00479, 1.06543, 1.17786],
    [1.06336, 1.12116, 1.15672, 1.06759, 1.04903, 1.16244, 1.14932, 1.00648, 1.08422, 1.09539],
    [1.05241, 1.13855, 1.12213, 1.00469, 1.07929, 1.12209, 1.19349, 1.08141, 1.10685, 1.07611],
    [1.19208, 1.19159, 1.19483, 1.14763, 1.19805, 1.03117, 1.14613, 1.15581, 1.17047, 1.17349],
    [1.18934, 1.06929, 1.14018, 1.01553, 1.16477, 1.17306, 1.13435, 1.12940, 1.09532, 1.08097],
    [1.16392, 1.02498, 1.12329, 1.05017, 1.10514, 1.03026, 1.09452, 1.15385, 1.00652, 1.09545],
    [1.17095, 1.16833, 1.05249, 1.02719, 1.15307, 1.13092, 1.11482, 1.15909, 1.09331, 1.02468],
    [1.12328, 1.16481, 1.08167, 1.14648, 1.18666, 1.02004, 1.18497, 1.01435, 1.09542, 1.01949],
    [1.02073, 1.17072, 1.13727, 1.05524, 1.14721, 1.13746, 1.05682, 1.06265, 1.15055, 1.07921],
    [1.09071, 1.04016, 1.01059, 1.03116, 1.10930, 1.14904, 1.02639, 1.04746, 1.19628, 1.09962],
    [1.08269, 1.12668, 1.09744, 1.13000, 1.13876, 1.07042, 1.06984, 1.18358, 1.12069, 1.13135],
    [1.16257, 1.19177, 1.09847, 1.00704, 1.06037, 1.06787, 1.12908, 1.03562, 1.12158, 1.11874],
    [1.04684, 1.14979, 1.14123, 1.08004, 1.18229, 1.04511, 1.07093, 1.08180, 1.09082, 1.11919],
    [1.02662, 1.15010, 1.07235, 1.03763, 1.01545, 1.15151, 1.16319, 1.08334, 1.11303, 1.18626],
    [1.18155, 1.14521, 1.12235, 1.13648, 1.10768, 1.10247, 1.04558, 1.17582, 1.18010, 1.06112],
    [1.00004, 1.14661, 1.18912, 1.19844, 1.10948, 1.01086, 1.14878, 1.07196, 1.00208, 1.08136],
    [1.02864, 1.14928, 1.04635, 1.03906, 1.12658, 1.01461, 1.15608, 1.04307, 1.16381, 1.00873],
    [1.09576, 1.13946, 1.08341, 1.15831, 1.11761, 1.07519, 1.03374, 1.15082, 1.06151, 1.12327],
    [1.11770, 1.01166, 1.14909, 1.02561, 1.18934, 1.03927, 1.00312, 1.05961, 1.07905, 1.05472],
    [1.12371, 1.13490, 1.12838, 1.12214, 1.15219, 1.12635, 1.01596, 1.19595, 1.15433, 1.14965],
    [1.15569, 1.05134, 1.05382, 1.18582, 1.04840, 1.15429, 1.04741, 1.16067, 1.06833, 1.02712],
    [1.13301, 1.08565, 1.06555, 1.16620, 1.18186, 1.16633, 1.06572, 1.06764, 1.08609, 1.08454],
    [1.04835, 1.01765, 1.01300, 1.16083, 1.08479, 1.00346, 1.09712, 1.00300, 1.01727, 1.00122],
    [1.00146, 1.14747, 1.16018, 1.19714, 1.07924, 1.09920, 1.00489, 1.19805, 1.16707, 1.07694],
    [1.00933, 1.18769, 1.14117, 1.06967, 1.05358, 1.08493, 1.06773, 1.11062, 1.04271, 1.06017],
    [1.07855, 1.17516, 1.03817, 1.06629, 1.00342, 1.00878, 1.19893, 1.14017, 1.09036, 1.09137],
    [1.11358, 1.13127, 1.04499, 1.04400, 1.00486, 1.01337, 1.12033, 1.08474, 1.18749, 1.03574],
    [1.08816, 1.03931, 1.06091, 1.07007, 1.02336, 1.11326, 1.01799, 1.00931, 1.13235, 1.13157],
    [1.15105, 1.17472, 1.15691, 1.05221, 1.13627, 1.18738, 1.18465, 1.05969, 1.17804, 1.06042],
    [1.19740, 1.04498, 1.19421, 1.16817, 1.18868, 1.17797, 1.12358, 1.04851, 1.18163, 1.17881],
    [1.13708, 1.09474, 1.17851, 1.19431, 1.03345, 1.09306, 1.17318, 1.08560, 1.00121, 1.06205],
    [1.05759, 1.03353, 1.02767, 1.15040, 1.15384, 1.06770, 1.13663, 1.04895, 1.00264, 1.02570],
    [1.13567, 1.07365, 1.13996, 1.14866, 1.05468, 1.17525, 1.09252, 1.01933, 1.15643, 1.03231],
    [1.12391, 1.04903, 1.10076, 1.08371, 1.16219, 1.01968, 1.14362, 1.05670, 1.04047, 1.08714],
    [1.15191, 1.04711, 1.08161, 1.15211, 1.11581, 1.10756, 1.15824, 1.00488, 1.13949, 1.00027],
    [1.05959, 1.15023, 1.19160, 1.07053, 1.09601, 1.11849, 1.19683, 1.09709, 1.17279, 1.16932],
    [1.14972, 1.07575, 1.06423, 1.19430, 1.03192, 1.19252, 1.11952, 1.12452, 1.01429, 1.14231],
    [1.13136, 1.04957, 1.12502, 1.04968, 1.19876, 1.15413, 1.06492, 1.14783, 1.11530, 1.07826],
    [1.15135, 1.07186, 1.11395, 1.00792, 1.07182, 1.12300, 1.09981, 1.10176, 1.02870, 1.15951],
    [1.00198, 1.16041, 1.15607, 1.07106, 1.17588, 1.14472, 1.19017, 1.09232, 1.08708, 1.04906],
    [1.07465, 1.11241, 1.00817, 1.13583, 1.08173, 1.03623, 1.15969, 1.03770, 1.13071, 1.15406],
    [1.02642, 1.13358, 1.08495, 1.17549, 1.08041, 1.10470, 1.10865, 1.08419, 1.04180, 1.07705],
    [1.06461, 1.06961, 1.10887, 1.05630, 1.03429, 1.09174, 1.08839, 1.06168, 1.14138, 1.13551],
    [1.05768, 1.06486, 1.16008, 1.11082, 1.08954, 1.14010, 1.08947, 1.05446, 1.07129, 1.13217],
    [1.17515, 1.19036, 1.14928, 1.04785, 1.15929, 1.10415, 1.02991, 1.07772, 1.04058, 1.18857],
    [1.06874, 1.05416, 1.12510, 1.01570, 1.17847, 1.05198, 1.04949, 1.19251, 1.08756, 1.13782],
    [1.15766, 1.15574, 1.18041, 1.17469, 1.11222, 1.06258, 1.05029, 1.08783, 1.12192, 1.03333],
    [1.19669, 1.09812, 1.06644, 1.10210, 1.19778, 1.12931, 1.09962, 1.13215, 1.18968, 1.09538],
    [1.01241, 1.05180, 1.18359, 1.07418, 1.13699, 1.06738, 1.05202, 1.07367, 1.07301, 1.00936],
    [1.11544, 1.19700, 1.01740, 1.06787, 1.16056, 1.11259, 1.17898, 1.07400, 1.02155, 1.03571],
    [1.05901, 1.18303, 1.15528, 1.12741, 1.07907, 1.11588, 1.14209, 1.11748, 1.13742, 1.01497],
    [1.14314, 1.05734, 1.17515, 1.07079, 1.04558, 1.00940, 1.13333, 1.17548, 1.12704, 1.17884],
    [1.18242, 1.15955, 1.17030, 1.09434, 1.00520, 1.06807, 1.05974, 1.14385, 1.01451, 1.03261],
    [1.19066, 1.07167, 1.08693, 1.19503, 1.12268, 1.14313, 1.09373, 1.03958, 1.00863, 1.18310],
    [1.01044, 1.18940, 1.02998, 1.19452, 1.08608, 1.02373, 1.17020, 1.16340, 1.05343, 1.17206],
    [1.15730, 1.15620, 1.06156, 1.04153, 1.10669, 1.11623, 1.11195, 1.03373, 1.09574, 1.06499],
    [1.07923, 1.00722, 1.00121, 1.11490, 1.09810, 1.04202, 1.03079, 1.19963, 1.19739, 1.06229],
    [1.08007, 1.12817, 1.16268, 1.17345, 1.14617, 1.06907, 1.10873, 1.07003, 1.12917, 1.07097],
    [1.14284, 1.17046, 1.05280, 1.12573, 1.00053, 1.03506, 1.03540, 1.18030, 1.03474, 1.12349],
    [1.04266, 1.00379, 1.03976, 1.04788, 1.15309, 1.11585, 1.09120, 1.17798, 1.16774, 1.08250],
    [1.08325, 1.15439, 1.09532, 1.18595, 1.14438, 1.16639, 1.14389, 1.17440, 1.01287, 1.15038],
    [1.15047, 1.09821, 1.15338, 1.16526, 1.07979, 1.13865, 1.09566, 1.10113, 1.12348, 1.03541],
    [1.17696, 1.17725, 1.03081, 1.01930, 1.16902, 1.18590, 1.00236, 1.05620, 1.17118, 1.13809],
    [1.17791, 1.10858, 1.05080, 1.06747, 1.04955, 1.02093, 1.01202, 1.04873, 1.03160, 1.13516],
    [1.17453, 1.18669, 1.11833, 1.04241, 1.14309, 1.03229, 1.06080, 1.17743, 1.04954, 1.18195],
    [1.19422, 1.06170, 1.04823, 1.11612, 1.14676, 1.10180, 1.14614, 1.03380, 1.16142, 1.14890],
    [1.14921, 1.13882, 1.06194, 1.12599, 1.00572, 1.13441, 1.19418, 1.12888, 1.12837, 1.18226],
    [1.17400, 1.10727, 1.17598, 1.08213, 1.17322, 1.13215, 1.07628, 1.12864, 1.17458, 1.15578],
    [1.17102, 1.00103, 1.12715, 1.07055, 1.06440, 1.14253, 1.03333, 1.17281, 1.05654, 1.18540],
    [1.09883, 1.03812, 1.14272, 1.07786, 1.17672, 1.11405, 1.06001, 1.06931, 1.03685, 1.03679],
    [1.16241, 1.00996, 1.09201, 1.17789, 1.00574, 1.12115, 1.11187, 1.02722, 1.02352, 1.09262],
    [1.15614, 1.11870, 1.17516, 1.06309, 1.05806, 1.10459, 1.14762, 1.14011, 1.08960, 1.08513],
    [1.19187, 1.01574, 1.13948, 1.19932, 1.17539, 1.13418, 1.03537, 1.18336, 1.13185, 1.16755],
    [1.14151, 1.10291, 1.08938, 1.05613, 1.06286, 1.16541, 1.05860, 1.16940, 1.18728, 1.01871],
    [1.16161, 1.04383, 1.09674, 1.04238, 1.18332, 1.05414, 1.17900, 1.03768, 1.12622, 1.07375],
    [1.07088, 1.02277, 1.05002, 1.08112, 1.06444, 1.13918, 1.17716, 1.16798, 1.10729, 1.17578],
    [1.14572, 1.10571, 1.12831, 1.11675, 1.19079, 1.12628, 1.11998, 1.01950, 1.13558, 1.07380],
    [1.10865, 1.02893, 1.17361, 1.18309, 1.04388, 1.03430, 1.12308, 1.04140, 1.13826, 1.17496],
    [1.13486, 1.18960, 1.08876, 1.10104, 1.13514, 1.11910, 1.11109, 1.19564, 1.18420, 1.12071],
    [1.01810, 1.06439, 1.03233, 1.14167, 1.07367, 1.09906, 1.05437, 1.10717, 1.05307, 1.02107],
    [1.04395, 1.06254, 1.04147, 1.01143, 1.04881, 1.19248, 1.00134, 1.13319, 1.12828, 1.07335],
    [1.04038, 1.05279, 1.01437, 1.01503, 1.01105, 1.16646, 1.15765, 1.04846, 1.17302, 1.13788],
    [1.13895, 1.01509, 1.14971, 1.15354, 1.12864, 1.11455, 1.11025, 1.10184, 1.17411, 1.16682],
    [1.00808, 1.18228, 1.19725, 1.14504, 1.00747, 1.15103, 1.08278, 1.03533, 1.12912, 1.10901],
    [1.13901, 1.17974, 1.04614, 1.03882, 1.11191, 1.15871, 1.06182, 1.19681, 1.03417, 1.16927],
    [1.00009, 1.16636, 1.09010, 1.15506, 1.04022, 1.07884, 1.17787, 1.04469, 1.02696, 1.00834],
    [1.15027, 1.15450, 1.08720, 1.04653, 1.01523, 1.11197, 1.08463, 1.06380, 1.07733, 1.15622],
    [1.14347, 1.06298, 1.10160, 1.17154, 1.17261, 1.13192, 1.08082, 1.11053, 1.02141, 1.10113],
    [1.08762, 1.16282, 1.19840, 1.11275, 1.19257, 1.12583, 1.18404, 1.00710, 1.12947, 1.13373],
    [1.06898, 1.13306, 1.08933, 1.00072, 1.14889, 1.08849, 1.12394, 1.13526, 1.00718, 1.19706],
    [1.14051, 1.08098, 1.11691, 1.02758, 1.16864, 1.04100, 1.09304, 1.16221, 1.08072, 1.04161],
    [1.02637, 1.11970, 1.04715, 1.09164, 1.03030, 1.04001, 1.10753, 1.19386, 1.03179, 1.03646],
    [1.13916, 1.16449, 1.13774, 1.02176, 1.00404, 1.11726, 1.00784, 1.11406, 1.15564, 1.16808],
    [1.16559, 1.02936, 1.08662, 1.01670, 1.07820, 1.16653, 1.09897, 1.16161, 1.13702, 1.19107],
    [1.17750, 1.00436, 1.16954, 1.02405, 1.04815, 1.19955, 1.01440, 1.04231, 1.00243, 1.10685],
    [1.19038, 1.19625, 1.16891, 1.10112, 1.19087, 1.05144, 1.01340, 1.19714, 1.03499, 1.06039],
    [1.14886, 1.14485, 1.00659, 1.07052, 1.03623, 1.05169, 1.01235, 1.17479, 1.05769, 1.08810],
    [1.09029, 1.11113, 1.14325, 1.13243, 1.09998, 1.11698, 1.03228, 1.11160, 1.12555, 1.04510],
    [1.15095, 1.09375, 1.02291, 1.04704, 1.18693, 1.08897, 1.04230, 1.03035, 1.14265, 1.01461],
    [1.15755, 1.19591, 1.14837, 1.18125, 1.03317, 1.06161, 1.01614, 1.15556, 1.06062, 1.07859],
    [1.01611, 1.15646, 1.19493, 1.04626, 1.05636, 1.04069, 1.02302, 1.03250, 1.14745, 1.03408],
    [1.19487, 1.00507, 1.13302, 1.06477, 1.04879, 1.08071, 1.16767, 1.05463, 1.16221, 1.19799],
    [1.12328, 1.02520, 1.05896, 1.12026, 1.00521, 1.17420, 1.00455, 1.17494, 1.15942, 1.17911],
    [1.12051, 1.03540, 1.15185, 1.08391, 1.14921, 1.15160, 1.10145, 1.02529, 1.10023, 1.13590],
    [1.14779, 1.15454, 1.10968, 1.11015, 1.03482, 1.01137, 1.14364, 1.12034, 1.09185, 1.10600],
    [1.07700, 1.02510, 1.19304, 1.16568, 1.17892, 1.16435, 1.17665, 1.00187, 1.13620, 1.01407],
    [1.10535, 1.05443, 1.04579, 1.13393, 1.04873, 1.16896, 1.10768, 1.01351, 1.16938, 1.06364],
    [1.04942, 1.12372, 1.19371, 1.04178, 1.01360, 1.17954, 1.04877, 1.00624, 1.13935, 1.12027],
    [1.14644, 1.13216, 1.16935, 1.01372, 1.09592, 1.05405, 1.11338, 1.19034, 1.12621, 1.12370],
    [1.09987, 1.01382, 1.19951, 1.19485, 1.04647, 1.19417, 1.09684, 1.09132, 1.08112, 1.04962],
    [1.05726, 1.01437, 1.14469, 1.02374, 1.05184, 1.04585, 1.10650, 1.06367, 1.07358, 1.00336],
    [1.02406, 1.16611, 1.12465, 1.00348, 1.07816, 1.09707, 1.08216, 1.18961, 1.01453, 1.19165],
    [1.12367, 1.18034, 1.02351, 1.04026, 1.09369, 1.09496, 1.08881, 1.16732, 1.09251, 1.11200],
    [1.13659, 1.10882, 1.06848, 1.01737, 1.01633, 1.19499, 1.09512, 1.09806, 1.04445, 1.04423],
    [1.11416, 1.03791, 1.14216, 1.07470, 1.02593, 1.17158, 1.09861, 1.03965, 1.10826, 1.15284],
    [1.19082, 1.09292, 1.04505, 1.19373, 1.09137, 1.19070, 1.14596, 1.13058, 1.09531, 1.13587],
    [1.03834, 1.07323, 1.19738, 1.07124, 1.01265, 1.09378, 1.05094, 1.12776, 1.10268, 1.11093],
    [1.13984, 1.03417, 1.08169, 1.02636, 1.19426, 1.19413, 1.05602, 1.06931, 1.18210, 1.03723],
    [1.03697, 1.00552, 1.10694, 1.15007, 1.17262, 1.16704, 1.14393, 1.19369, 1.02061, 1.15879],
    [1.14474, 1.11352, 1.14317, 1.19850, 1.04300, 1.04823, 1.00565, 1.14600, 1.19133, 1.04358],
    [1.05991, 1.17828, 1.16125, 1.17768, 1.19362, 1.16642, 1.03726, 1.00375, 1.02686, 1.11079],
    [1.13631, 1.11680, 1.03727, 1.09069, 1.18386, 1.15025, 1.19493, 1.08469, 1.07791, 1.00906],
    [1.08822, 1.11792, 1.07210, 1.04526, 1.02207, 1.09253, 1.10927, 1.18244, 1.06958, 1.15768],
    [1.13657, 1.09524, 1.15848, 1.17516, 1.13354, 1.05018, 1.17361, 1.13703, 1.08430, 1.11417],
    [1.15667, 1.09137, 1.02515, 1.13662, 1.18442, 1.03259, 1.19875, 1.01188, 1.00673, 1.11237],
    [1.04628, 1.02787, 1.02558, 1.02755, 1.06866, 1.00730, 1.09640, 1.14131, 1.08822, 1.04774],
    [1.13281, 1.19369, 1.14198, 1.16675, 1.19627, 1.15786, 1.13781, 1.05839, 1.05160, 1.09840],
    [1.10476, 1.06721, 1.06991, 1.18768, 1.16879, 1.18618, 1.05990, 1.13675, 1.08508, 1.18461],
    [1.10905, 1.19698, 1.05828, 1.07244, 1.01575, 1.18853, 1.08193, 1.00712, 1.19374, 1.11209],
    [1.12815, 1.04925, 1.02998, 1.00018, 1.01914, 1.07342, 1.17745, 1.16393, 1.11142, 1.04022],
    [1.16378, 1.09198, 1.02427, 1.13598, 1.19730, 1.15755, 1.14364, 1.18624, 1.15146, 1.18994],
    [1.13253, 1.04934, 1.00918, 1.06671, 1.17940, 1.19634, 1.14805, 1.18290, 1.01566, 1.18343],
    [1.14792, 1.15336, 1.03360, 1.02336, 1.10194, 1.00456, 1.13587, 1.16177, 1.11240, 1.01217],
    [1.04796, 1.06487, 1.15257, 1.04049, 1.12473, 1.12482, 1.17579, 1.14013, 1.18238, 1.08880],
    [1.05310, 1.06017, 1.18706, 1.11825, 1.02063, 1.03098, 1.13135, 1.08435, 1.01801, 1.07403],
    [1.12987, 1.00620, 1.19903, 1.19484, 1.06535, 1.03770, 1.19581, 1.11546, 1.01624, 1.10958],
    [1.01779, 1.10264, 1.19730, 1.03278, 1.16666, 1.14787, 1.04425, 1.16934, 1.04860, 1.05575],
    [1.17391, 1.07712, 1.06505, 1.09671, 1.05086, 1.03473, 1.06319, 1.18047, 1.09210, 1.05258],
    [1.12746, 1.00647, 1.04081, 1.07666, 1.19341, 1.14751, 1.14045, 1.19113, 1.06497, 1.12277],
    [1.14058, 1.12589, 1.11651, 1.01661, 1.06554, 1.07564, 1.06098, 1.09934, 1.17724, 1.13636],
    [1.06521, 1.00604, 1.06340, 1.16570, 1.19382, 1.13008, 1.08238, 1.17345, 1.06286, 1.18708],
    [1.09591, 1.04832, 1.08444, 1.00607, 1.12100, 1.12728, 1.18365, 1.10363, 1.03218, 1.01378],
    [1.16903, 1.09763, 1.14546, 1.15099, 1.03771, 1.11667, 1.01502, 1.15640, 1.19670, 1.06134],
    [1.07432, 1.02399, 1.08130, 1.07385, 1.05227, 1.00027, 1.15215, 1.07204, 1.19631, 1.04030],
    [1.15195, 1.10401, 1.03323, 1.05013, 1.00327, 1.17991, 1.09919, 1.02177, 1.02859, 1.13667],
    [1.17010, 1.06704, 1.07386, 1.19246, 1.02368, 1.05640, 1.01680, 1.14659, 1.06436, 1.06922],
    [1.04127, 1.08158, 1.04237, 1.16159, 1.15886, 1.12331, 1.19818, 1.05786, 1.15902, 1.11562],
    [1.06361, 1.07246, 1.06895, 1.16568, 1.05080, 1.06784, 1.10450, 1.11629, 1.06040, 1.15512],
    [1.19332, 1.10137, 1.03999, 1.14352, 1.05159, 1.04085, 1.12435, 1.04490, 1.09543, 1.03142],
    [1.08842, 1.03957, 1.16836, 1.08902, 1.14455, 1.00973, 1.16609, 1.19976, 1.01505, 1.04671],
    [1.13969, 1.13507, 1.11147, 1.03833, 1.15866, 1.18776, 1.15160, 1.14250, 1.11493, 1.08484],
    [1.04588, 1.05352, 1.14917, 1.03372, 1.18389, 1.06711, 1.08057, 1.15774, 1.15276, 1.05054],
    [1.12148, 1.07746, 1.01827, 1.12413, 1.05791, 1.09387, 1.00021, 1.16028, 1.17745, 1.12982],
    [1.07305, 1.10633, 1.12565, 1.08593, 1.12333, 1.03756, 1.17210, 1.16716, 1.19486, 1.14644],
    [1.06763, 1.03634, 1.05314, 1.17447, 1.17373, 1.15095, 1.00009, 1.09293, 1.04544, 1.13926],
    [1.17051, 1.13860, 1.14912, 1.17227, 1.04130, 1.01083, 1.09608, 1.18757, 1.18502, 1.13631],
    [1.07367, 1.12135, 1.19860, 1.00745, 1.05464, 1.00494, 1.03890, 1.10107, 1.06654, 1.08207],
    [1.09605, 1.18321, 1.10190, 1.00291, 1.03594, 1.10668, 1.15083, 1.05155, 1.14314, 1.10737],
    [1.13706, 1.06279, 1.19539, 1.10560, 1.03874, 1.18464, 1.00109, 1.01887, 1.17534, 1.14283],
    [1.03083, 1.19219, 1.14169, 1.16346, 1.07434, 1.15210, 1.17066, 1.01015, 1.15412, 1.19102],
    [1.00551, 1.09191, 1.02691, 1.18763, 1.06330, 1.09785, 1.10431, 1.17012, 1.17058, 1.11526],
    [1.12382, 1.02803, 1.05254, 1.08698, 1.00150, 1.07933, 1.05700, 1.16462, 1.19751, 1.09870],
    [1.09433, 1.01360, 1.02579, 1.11349, 1.07474, 1.02650, 1.03921, 1.17352, 1.02394, 1.10081],
    [1.12120, 1.00079, 1.15878, 1.13736, 1.01541, 1.12577, 1.10363, 1.11576, 1.12449, 1.01601],
    [1.12929, 1.10306, 1.10918, 1.00382, 1.19526, 1.05173, 1.11915, 1.11883, 1.07679, 1.14351],
    [1.18665, 1.03198, 1.15802, 1.13511, 1.01430, 1.01708, 1.17228, 1.06211, 1.08838, 1.13620],
    [1.07100, 1.15744, 1.14856, 1.15508, 1.10238, 1.14033, 1.14577, 1.19493, 1.08095, 1.13247],
    [1.11898, 1.02682, 1.12958, 1.15719, 1.12250, 1.01484, 1.07484, 1.07818, 1.03491, 1.01437],
    [1.17728, 1.13386, 1.18086, 1.03167, 1.17756, 1.12378, 1.19698, 1.15105, 1.14001, 1.00314],
    [1.07324, 1.13591, 1.07457, 1.14180, 1.00093, 1.00976, 1.01859, 1.00400, 1.15849, 1.02368],
    [1.15958, 1.10504, 1.06655, 1.11628, 1.08026, 1.00113, 1.04332, 1.07249, 1.10714, 1.16871],
    [1.19162, 1.08750, 1.04384, 1.12947, 1.04876, 1.14195, 1.07039, 1.07734, 1.13072, 1.09474],
    [1.08991, 1.16369, 1.10149, 1.09964, 1.10364, 1.09691, 1.19924, 1.05202, 1.09593, 1.01280],
    [1.05028, 1.07185, 1.01005, 1.07182, 1.10223, 1.12935, 1.09643, 1.13963, 1.00745, 1.01937],
    [1.01429, 1.00697, 1.18833, 1.19099, 1.16814, 1.10537, 1.11520, 1.03826, 1.06021, 1.17474],
    [1.12864, 1.15875, 1.14018, 1.03912, 1.13702, 1.18565, 1.13346, 1.14705, 1.02068, 1.10025],
    [1.12917, 1.03239, 1.07414, 1.03049, 1.00918, 1.15239, 1.11725, 1.04225, 1.09942, 1.05866],
    [1.00692, 1.12938, 1.02465, 1.15786, 1.18037, 1.10887, 1.04808, 1.01789, 1.16127, 1.02730],
    [1.07693, 1.07617, 1.06014, 1.18491, 1.01529, 1.10606, 1.20000, 1.18344, 1.04552, 1.09772],
    [1.09871, 1.10411, 1.11935, 1.10972, 1.13927, 1.02192, 1.04003, 1.14757, 1.15914, 1.16246],
    [1.01683, 1.02547, 1.09002, 1.10764, 1.07285, 1.06751, 1.07931, 1.15644, 1.18781, 1.00456],
    [1.02434, 1.04700, 1.15674, 1.12311, 1.15085, 1.14634, 1.04595, 1.02236, 1.16685, 1.11375],
    [1.02756, 1.03570, 1.02302, 1.14452, 1.07372, 1.07293, 1.01117, 1.19970, 1.09191, 1.13944],
    [1.03164, 1.12869, 1.18249, 1.08854, 1.16130, 1.09052, 1.19975, 1.06333, 1.15298, 1.18022],
    [1.09773, 1.18419, 1.19800, 1.06656, 1.04207, 1.13825, 1.18266, 1.14737, 1.16914, 1.02713],
    [1.17024, 1.02860, 1.17360, 1.12901, 1.13957, 1.03361, 1.00584, 1.13147, 1.11156, 1.14864],
    [1.06037, 1.09134, 1.09478, 1.11092, 1.13649, 1.07761, 1.18154, 1.04565, 1.15246, 1.15395],
    [1.02545, 1.15799, 1.09448, 1.05681, 1.03211, 1.08641, 1.18161, 1.02555, 1.09369, 1.02360],
    [1.12804, 1.14075, 1.19908, 1.01124, 1.08385, 1.02691, 1.15054, 1.11482, 1.13545, 1.07600],
    [1.11842, 1.08481, 1.14722, 1.04783, 1.06482, 1.01036, 1.02517, 1.00365, 1.16777, 1.17192],
    [1.18437, 1.02925, 1.07703, 1.19880, 1.10097, 1.10373, 1.13277, 1.13824, 1.13027, 1.17021],
    [1.17835, 1.14188, 1.07214, 1.16479, 1.09853, 1.17617, 1.06482, 1.05991, 1.11439, 1.06280],
    [1.08861, 1.07846, 1.16598, 1.05553, 1.06050, 1.13477, 1.01425, 1.05950, 1.00110, 1.05892],
    [1.19330, 1.09944, 1.05509, 1.06040, 1.04432, 1.14292, 1.04635, 1.18751, 1.16235, 1.08499],
    [1.14926, 1.03869, 1.08725, 1.00029, 1.15714, 1.08215, 1.17002, 1.06912, 1.12925, 1.03980],
    [1.04581, 1.08344, 1.09757, 1.09200, 1.04472, 1.13936, 1.01454, 1.15922, 1.17184, 1.02204],
    [1.02315, 1.01690, 1.18767, 1.08958, 1.03049, 1.09978, 1.02011, 1.16188, 1.06602, 1.15192],
    [1.03943, 1.02084, 1.00599, 1.17869, 1.02728, 1.02820, 1.14501, 1.05692, 1.17122, 1.06712],
    [1.19614, 1.05958, 1.11575, 1.11393, 1.00085, 1.05106, 1.00136, 1.04611, 1.12989, 1.00951],
    [1.12261, 1.19296, 1.05639, 1.03231, 1.13667, 1.03499, 1.08268, 1.08103, 1.05350, 1.15848],
    [1.10163, 1.02203, 1.13888, 1.07125, 1.17415, 1.01917, 1.16159, 1.18619, 1.00394, 1.03447],
    [1.11603, 1.17842, 1.09073, 1.09351, 1.05141, 1.02264, 1.04326, 1.07130, 1.13888, 1.11685],
    [1.03334, 1.05523, 1.00779, 1.19849, 1.07216, 1.04115, 1.08233, 1.05954, 1.09004, 1.01904],
    [1.14979, 1.16673, 1.10108, 1.00414, 1.09179, 1.19291, 1.03367, 1.07033, 1.00955, 1.16611],
    [1.10843, 1.14142, 1.07462, 1.04250, 1.14452, 1.19714, 1.13623, 1.00926, 1.07580, 1.04967],
    [1.01652, 1.12389, 1.05797, 1.14720, 1.12493, 1.19608, 1.04804, 1.16067, 1.12295, 1.11836],
    [1.03719, 1.00996, 1.07056, 1.15194, 1.01851, 1.08580, 1.18552, 1.17373, 1.07074, 1.12363],
    [1.04679, 1.19106, 1.03917, 1.08562, 1.17341, 1.13014, 1.19525, 1.10721, 1.00991, 1.00468],
    [1.15574, 1.06431, 1.04975, 1.07080, 1.04308, 1.01750, 1.12776, 1.07445, 1.16788, 1.08932],
    [1.01307, 1.19781, 1.01499, 1.03117, 1.13364, 1.01062, 1.01434, 1.03580, 1.16368, 1.03292],
    [1.07777, 1.05177, 1.10522, 1.01536, 1.18313, 1.15618, 1.19506, 1.14332, 1.18691, 1.04174],
    [1.06840, 1.07107, 1.14662, 1.17468, 1.11030, 1.19239, 1.13422, 1.07947, 1.02630, 1.05360],
    [1.02176, 1.10687, 1.16349, 1.11554, 1.02057, 1.14134, 1.01309, 1.17057, 1.05522, 1.00419],
    [1.02611, 1.02092, 1.15347, 1.00871, 1.17295, 1.12465, 1.13352, 1.02346, 1.17850, 1.01530],
    [1.16974, 1.10000, 1.06390, 1.00183, 1.11821, 1.02142, 1.12615, 1.15473, 1.18320, 1.02768],
    [1.18682, 1.08473, 1.00602, 1.07429, 1.04123, 1.12040, 1.15730, 1.08034, 1.13925, 1.19081],
    [1.11404, 1.12227, 1.02893, 1.01942, 1.10275, 1.02966, 1.19437, 1.13574, 1.08980, 1.13908],
    [1.01887, 1.11058, 1.10025, 1.06251, 1.10485, 1.12162, 1.14654, 1.02647, 1.08152, 1.05512],
    [1.14808, 1.03797, 1.13181, 1.05030, 1.12325, 1.03382, 1.16960, 1.09254, 1.03478, 1.06931],
    [1.09867, 1.16163, 1.16994, 1.10259, 1.08448, 1.14136, 1.03680, 1.03106, 1.07011, 1.19674],
    [1.05769, 1.13589, 1.06761, 1.02492, 1.04118, 1.19105, 1.05595, 1.08636, 1.11387, 1.19301],
    [1.01690, 1.02214, 1.09316, 1.16742, 1.14004, 1.16406, 1.18229, 1.00895, 1.12813, 1.14333],
    [1.16890, 1.01065, 1.03419, 1.10456, 1.00834, 1.03895, 1.16138, 1.13092, 1.17306, 1.01063],
    [1.05708, 1.18699, 1.04914, 1.02801, 1.13238, 1.18531, 1.16152, 1.02861, 1.13815, 1.08318],
    [1.10874, 1.10545, 1.02901, 1.01560, 1.18901, 1.15435, 1.04651, 1.17095, 1.19822, 1.00441],
    [1.15262, 1.01539, 1.18176, 1.08801, 1.04487, 1.17238, 1.02087, 1.00639, 1.08445, 1.16355],
    [1.03519, 1.04731, 1.16839, 1.11709, 1.08238, 1.01080, 1.07710, 1.05001, 1.13650, 1.19949],
    [1.12864, 1.03051, 1.02593, 1.12948, 1.07084, 1.02656, 1.11241, 1.01834, 1.04250, 1.14722],
    [1.19239, 1.00619, 1.13510, 1.08261, 1.00175, 1.16628, 1.18604, 1.04913, 1.00546, 1.06123],
    [1.13483, 1.04593, 1.05313, 1.10132, 1.17343, 1.12888, 1.18187, 1.06088, 1.02192, 1.10853],
    [1.14764, 1.00917, 1.16088, 1.17801, 1.16645, 1.01200, 1.15160, 1.07735, 1.04644, 1.06023],
    [1.07551, 1.10031, 1.19237, 1.18153, 1.02387, 1.15010, 1.06347, 1.19158, 1.06926, 1.15010],
    [1.16625, 1.04099, 1.04986, 1.01600, 1.16308, 1.01411, 1.19784, 1.09546, 1.17831, 1.13610],
    [1.14327, 1.08160, 1.08267, 1.04445, 1.12456, 1.10658, 1.03758, 1.08121, 1.13679, 1.02152],
    [1.08040, 1.06209, 1.04929, 1.16897, 1.03201, 1.07890, 1.02346, 1.05425, 1.10781, 1.19134],
    [1.06237, 1.02181, 1.11361, 1.16449, 1.02313, 1.14297, 1.00745, 1.10838, 1.12350, 1.02118],
    [1.10867, 1.17557, 1.07381, 1.12124, 1.13559, 1.17334, 1.06561, 1.12838, 1.15286, 1.04652],
    [1.14812, 1.14388, 1.00985, 1.08726, 1.02386, 1.02315, 1.15140, 1.02805, 1.19468, 1.06269],
    [1.18187, 1.07417, 1.08944, 1.14205, 1.06423, 1.03178, 1.10452, 1.12724, 1.13493, 1.18809],
    [1.18855, 1.04163, 1.01616, 1.09966, 1.10246, 1.01069, 1.00663, 1.14510, 1.18627, 1.08681],
    [1.03204, 1.19860, 1.16359, 1.16050, 1.13660, 1.08031, 1.01548, 1.06408, 1.19687, 1.13998],
    [1.05456, 1.07428, 1.03903, 1.02998, 1.03077, 1.11985, 1.04099, 1.02413, 1.00011, 1.10054],
    [1.00045, 1.13844, 1.18737, 1.02366, 1.15026, 1.00996, 1.17439, 1.16446, 1.10232, 1.19025],
    [1.04494, 1.15655, 1.00117, 1.00938, 1.01740, 1.01870, 1.06869, 1.06708, 1.19666, 1.02423],
    [1.02101, 1.10689, 1.17639, 1.01917, 1.13891, 1.12991, 1.12297, 1.09549, 1.07305, 1.10414],
    [1.07227, 1.02578, 1.16519, 1.12590, 1.07058, 1.16537, 1.16666, 1.18937, 1.09101, 1.02830],
    [1.13536, 1.02055, 1.15635, 1.04348, 1.19250, 1.13204, 1.00004, 1.09704, 1.12044, 1.15465],
    [1.09615, 1.16733, 1.08266, 1.00229, 1.18971, 1.05871, 1.04736, 1.12634, 1.15883, 1.14051],
    [1.19580, 1.01555, 1.13959, 1.09717, 1.09658, 1.19816, 1.14510, 1.19609, 1.12734, 1.10196],
    [1.10998, 1.07921, 1.12477, 1.02902, 1.19144, 1.18478, 1.14458, 1.00098, 1.05825, 1.00533],
    [1.11241, 1.13134, 1.19897, 1.08833, 1.04691, 1.08093, 1.18032, 1.18556, 1.03652, 1.05293],
    [1.08744, 1.05769, 1.05090, 1.08346, 1.07693, 1.14014, 1.16832, 1.08417, 1.07404, 1.17642],
    [1.10050, 1.19312, 1.14523, 1.02545, 1.19578, 1.08995, 1.17739, 1.14886, 1.00217, 1.03191],
    [1.19501, 1.18466, 1.17139, 1.06673, 1.14637, 1.11346, 1.18509, 1.17877, 1.09024, 1.02356],
    [1.08477, 1.02457, 1.01410, 1.18107, 1.08624, 1.01413, 1.01539, 1.01138, 1.06032, 1.19416],
    [1.07679, 1.09821, 1.16061, 1.08945, 1.16691, 1.00651, 1.17989, 1.15884, 1.09767, 1.03535],
    [1.11631, 1.02172, 1.06953, 1.10730, 1.13045, 1.11166, 1.13587, 1.10019, 1.17480, 1.11305],
    [1.11778, 1.02786, 1.07669, 1.03739, 1.00041, 1.17593, 1.15599, 1.09513, 1.14234, 1.19883],
    [1.15876, 1.01955, 1.12898, 1.08457, 1.18837, 1.19882, 1.00144, 1.19315, 1.01485, 1.07245],
    [1.09196, 1.07519, 1.04426, 1.14861, 1.19730, 1.07685, 1.12889, 1.09821, 1.12124, 1.03724],
    [1.09987, 1.08227, 1.11748, 1.08484, 1.00319, 1.16880, 1.06418, 1.03879, 1.12052, 1.19526],
    [1.10136, 1.02167, 1.15610, 1.13308, 1.16251, 1.18982, 1.07076, 1.11032, 1.13150, 1.18737],
    [1.14466, 1.14881, 1.05622, 1.03052, 1.14955, 1.17200, 1.15004, 1.02811, 1.01227, 1.13970],
    [1.01246, 1.04459, 1.05039, 1.06616, 1.00012, 1.11211, 1.16136, 1.17743, 1.17948, 1.09745],
    [1.04650, 1.16456, 1.19232, 1.03037, 1.05098, 1.18869, 1.06550, 1.19957, 1.10099, 1.19434],
    [1.09599, 1.02241, 1.11954, 1.18719, 1.04263, 1.19477, 1.00195, 1.03254, 1.15574, 1.12715],
    [1.13240, 1.03072, 1.07581, 1.17346, 1.12270, 1.02570, 1.13276, 1.05856, 1.15458, 1.10318],
    [1.07663, 1.01093, 1.00684, 1.03433, 1.17132, 1.00658, 1.14837, 1.12157, 1.08234, 1.03066],
    [1.17852, 1.00246, 1.09009, 1.16280, 1.19601, 1.06809, 1.05967, 1.19257, 1.17751, 1.05217],
    [1.09861, 1.17128, 1.14734, 1.04709, 1.13379, 1.00630, 1.01937, 1.10313, 1.13867, 1.10431],
    [1.09247, 1.06718, 1.04221, 1.16952, 1.08067, 1.01712, 1.05070, 1.16327, 1.05943, 1.14820],
    [1.01365, 1.13119, 1.00906, 1.06757, 1.16521, 1.10426, 1.13679, 1.15329, 1.07201, 1.17984],
    [1.05847, 1.13407, 1.11916, 1.18906, 1.02138, 1.14590, 1.16518, 1.05685, 1.04926, 1.02194],
    [1.09740, 1.06074, 1.19090, 1.07183, 1.11905, 1.09476, 1.15340, 1.10674, 1.09908, 1.14460],
    [1.10159, 1.16628, 1.01635, 1.08050, 1.10457, 1.10376, 1.02900, 1.17382, 1.01089, 1.08581],
    [1.00059, 1.04373, 1.03338, 1.16266, 1.01409, 1.04031, 1.02509, 1.16548, 1.10496, 1.17008],
    [1.12746, 1.08687, 1.14475, 1.17049, 1.17199, 1.00079, 1.10620, 1.03942, 1.11668, 1.07821],
    [1.04131, 1.02604, 1.09854, 1.15475, 1.00354, 1.18920, 1.18328, 1.00641, 1.04540, 1.12972],
    [1.19355, 1.18992, 1.12264, 1.00267, 1.09700, 1.00360, 1.03638, 1.01610, 1.13527, 1.02540],
    [1.04441, 1.12220, 1.17529, 1.18390, 1.07274, 1.10741, 1.06409, 1.01892, 1.15900, 1.18755],
    [1.06841, 1.08786, 1.05849, 1.11426, 1.18022, 1.17383, 1.04462, 1.09912, 1.16963, 1.05213],
    [1.03457, 1.16145, 1.16627, 1.07112, 1.07158, 1.00630, 1.05037, 1.10384, 1.09528, 1.03874],
    [1.03498, 1.12650, 1.03103, 1.02069, 1.12035, 1.18025, 1.12969, 1.17665, 1.00185, 1.17239],
    [1.18901, 1.05441, 1.11274, 1.07323, 1.18798, 1.14721, 1.18280, 1.16497, 1.16524, 1.18336],
    [1.19435, 1.09876, 1.07291, 1.08978, 1.11678, 1.01619, 1.03712, 1.13554, 1.10076, 1.09153],
    [1.15626, 1.06179, 1.11353, 1.15086, 1.06859, 1.10427, 1.09647, 1.12444, 1.02011, 1.11457],
    [1.02612, 1.18858, 1.06405, 1.08655, 1.16007, 1.15311, 1.12337, 1.09407, 1.04870, 1.15087],
    [1.14725, 1.14627, 1.19440, 1.18543, 1.09312, 1.16670, 1.13910, 1.19316, 1.16520, 1.00253],
    [1.06169, 1.17611, 1.04104, 1.07008, 1.06647, 1.06179, 1.11710, 1.14291, 1.04374, 1.04618],
    [1.10481, 1.08881, 1.08404, 1.07613, 1.00821, 1.06175, 1.12705, 1.02754, 1.01452, 1.15529],
    [1.02663, 1.03549, 1.12881, 1.02344, 1.11299, 1.13249, 1.08408, 1.07547, 1.03344, 1.05127],
    [1.15802, 1.15069, 1.15295, 1.14824, 1.02759, 1.07965, 1.09561, 1.10390, 1.09280, 1.03782],
    [1.10851, 1.15647, 1.00082, 1.09823, 1.02894, 1.12494, 1.00181, 1.08904, 1.13658, 1.17785],
    [1.06754, 1.16255, 1.07150, 1.00404, 1.00428, 1.18173, 1.09958, 1.14156, 1.09097, 1.13059],
    [1.10631, 1.12106, 1.07403, 1.05468, 1.00054, 1.17986, 1.05017, 1.13783, 1.10901, 1.00300],
    [1.06822, 1.02149, 1.04335, 1.04754, 1.18145, 1.17299, 1.02047, 1.10614, 1.18141, 1.00871],
    [1.11781, 1.06656, 1.14479, 1.17880, 1.04450, 1.12297, 1.02434, 1.11921, 1.10988, 1.19551],
    [1.01520, 1.07781, 1.17047, 1.01428, 1.12792, 1.12041, 1.03676, 1.02412, 1.09923, 1.12318],
    [1.12098, 1.16619, 1.07212, 1.05763, 1.00710, 1.09288, 1.17622, 1.17443, 1.12450, 1.07214],
    [1.03983, 1.19229, 1.00615, 1.13749, 1.16485, 1.09821, 1.11306, 1.13999, 1.19583, 1.06524],
    [1.10586, 1.05842, 1.01446, 1.09413, 1.14489, 1.02396, 1.09065, 1.08504, 1.10013, 1.01547],
    [1.02150, 1.14552, 1.05205, 1.08178, 1.08949, 1.04121, 1.16487, 1.04722, 1.17093, 1.19520],
    [1.11313, 1.15658, 1.02615, 1.14256, 1.14324, 1.01567, 1.10258, 1.04624, 1.15087, 1.08404],
    [1.08191, 1.18043, 1.05573, 1.07569, 1.10264, 1.18782, 1.05482, 1.12438, 1.08940, 1.01696],
    [1.03541, 1.06956, 1.11998, 1.14592, 1.12906, 1.11935, 1.06161, 1.19846, 1.08797, 1.04656],
    [1.00762, 1.15916, 1.06474, 1.17434, 1.14570, 1.09355, 1.07697, 1.10742, 1.18910, 1.17957],
    [1.13784, 1.06534, 1.00194, 1.15659, 1.13396, 1.17391, 1.14992, 1.19835, 1.03177, 1.17103],
    [1.00763, 1.11585, 1.09364, 1.08334, 1.15388, 1.09667, 1.08505, 1.12974, 1.08598, 1.08683],
    [1.15400, 1.00812, 1.18459, 1.02145, 1.16396, 1.02156, 1.16005, 1.01055, 1.16152, 1.00026],
    [1.11176, 1.08614, 1.16017, 1.07534, 1.03159, 1.01685, 1.12126, 1.06093, 1.08270, 1.19649],
    [1.11347, 1.10069, 1.08504, 1.11260, 1.13210, 1.13497, 1.13869, 1.00135, 1.15933, 1.04503],
    [1.01636, 1.19506, 1.14680, 1.03040, 1.05636, 1.16845, 1.10163, 1.07566, 1.18701, 1.19010],
    [1.15726, 1.06302, 1.01414, 1.18514, 1.01028, 1.18675, 1.00271, 1.11554, 1.00458, 1.02589],
    [1.08366, 1.08424, 1.04390, 1.13137, 1.11757, 1.06938, 1.01429, 1.08386, 1.14612, 1.09478],
    [1.09745, 1.07854, 1.06278, 1.14311, 1.05645, 1.19313, 1.03374, 1.01777, 1.07490, 1.19526],
    [1.10064, 1.05997, 1.03085, 1.04573, 1.09612, 1.12701, 1.18688, 1.15352, 1.10346, 1.13826],
    [1.17715, 1.13913, 1.19172, 1.19487, 1.07334, 1.16236, 1.05741, 1.17960, 1.01002, 1.17071],
    [1.10417, 1.04302, 1.15123, 1.12487, 1.19147, 1.08220, 1.07931, 1.15729, 1.18376, 1.01830],
    [1.18712, 1.12026, 1.13130, 1.17920, 1.15522, 1.07969, 1.01379, 1.19344, 1.09486, 1.01085],
    [1.07822, 1.10185, 1.03843, 1.05227, 1.10203, 1.09284, 1.15826, 1.17415, 1.01302, 1.16791],
    [1.19529, 1.01742, 1.19706, 1.14338, 1.07872, 1.15983, 1.12494, 1.09481, 1.01793, 1.16512],
    [1.02971, 1.05017, 1.04791, 1.07179, 1.06554, 1.03806, 1.10947, 1.07746, 1.07951, 1.09737],
    [1.04542, 1.07521, 1.02761, 1.15442, 1.19412, 1.19817, 1.16602, 1.17394, 1.16141, 1.02852],
    [1.04909, 1.09021, 1.05238, 1.02718, 1.06526, 1.12442, 1.14422, 1.04050, 1.14198, 1.19467],
    [1.08118, 1.04011, 1.15115, 1.02475, 1.17316, 1.15226, 1.04619, 1.05811, 1.07903, 1.13282],
    [1.06189, 1.18300, 1.05600, 1.14429, 1.00853, 1.17530, 1.05620, 1.19095, 1.19135, 1.06516],
    [1.05177, 1.06850, 1.18658, 1.13369, 1.06983, 1.18442, 1.00551, 1.14598, 1.11830, 1.10523],
    [1.07757, 1.12673, 1.08413, 1.18701, 1.18386, 1.08466, 1.18497, 1.14530, 1.17231, 1.19211],
    [1.05555, 1.12083, 1.18577, 1.02573, 1.05028, 1.09705, 1.03411, 1.17508, 1.04286, 1.02595],
    [1.04193, 1.02474, 1.10461, 1.11833, 1.00267, 1.01672, 1.14239, 1.05479, 1.17079, 1.19909],
    [1.07776, 1.17358, 1.12298, 1.16721, 1.04813, 1.19177, 1.01986, 1.00380, 1.01169, 1.11581],
    [1.09923, 1.12410, 1.03692, 1.09780, 1.13224, 1.03230, 1.05818, 1.09370, 1.07374, 1.09563],
    [1.17859, 1.07979, 1.03794, 1.14220, 1.10140, 1.08355, 1.03082, 1.18899, 1.17111, 1.18523],
    [1.17032, 1.10609, 1.00565, 1.14639, 1.02572, 1.12359, 1.00076, 1.02166, 1.00747, 1.18727],
    [1.08799, 1.00993, 1.03853, 1.06936, 1.02730, 1.10126, 1.03869, 1.04062, 1.01589, 1.17569],
    [1.05304, 1.01003, 1.09409, 1.11034, 1.15579, 1.13829, 1.12990, 1.15093, 1.16072, 1.03139],
    [1.06325, 1.10391, 1.06958, 1.12053, 1.19128, 1.00573, 1.08956, 1.13459, 1.17587, 1.02515],
    [1.15123, 1.07147, 1.15470, 1.05506, 1.15802, 1.17444, 1.03709, 1.15002, 1.09870, 1.11989],
    [1.16584, 1.06572, 1.05391, 1.12263, 1.02631, 1.05671, 1.02814, 1.16500, 1.18410, 1.18846],
    [1.03831, 1.05607, 1.13235, 1.12026, 1.19030, 1.12723, 1.03021, 1.01494, 1.17450, 1.07018],
    [1.01353, 1.13199, 1.11191, 1.12401, 1.05895, 1.15983, 1.18177, 1.11710, 1.08294, 1.04411],
    [1.16213, 1.17054, 1.05671, 1.16776, 1.11447, 1.16902, 1.01849, 1.03925, 1.14391, 1.00558],
    [1.16424, 1.14543, 1.06581, 1.10647, 1.09817, 1.12494, 1.11045, 1.04225, 1.02426, 1.11861],
    [1.09679, 1.13159, 1.16009, 1.05314, 1.00656, 1.04377, 1.15411, 1.11413, 1.19012, 1.10638],
    [1.18774, 1.16486, 1.13507, 1.12427, 1.14344, 1.16700, 1.02913, 1.01605, 1.12008, 1.15959],
    [1.04827, 1.07455, 1.07682, 1.05236, 1.00165, 1.15723, 1.08673, 1.18988, 1.06428, 1.01292],
    [1.18146, 1.14255, 1.02895, 1.05127, 1.06813, 1.08086, 1.00848, 1.16088, 1.09980, 1.18912],
    [1.01962, 1.08258, 1.18065, 1.07479, 1.17990, 1.14400, 1.18719, 1.02991, 1.14850, 1.06181],
    [1.18679, 1.10057, 1.14264, 1.01765, 1.03458, 1.02101, 1.16053, 1.11424, 1.03033, 1.16826],
    [1.14226, 1.01778, 1.01613, 1.19385, 1.09975, 1.09295, 1.19650, 1.08864, 1.14720, 1.03672],
    [1.06188, 1.13719, 1.06311, 1.11721, 1.09706, 1.11773, 1.11520, 1.02395, 1.05542, 1.00418],
    [1.17947, 1.03566, 1.08057, 1.12632, 1.08466, 1.11189, 1.05652, 1.04439, 1.01340, 1.01468],
    [1.06748, 1.09450, 1.09110, 1.06666, 1.14883, 1.06083, 1.19418, 1.05161, 1.01026, 1.13120],
    [1.10852, 1.06391, 1.11249, 1.19196, 1.06966, 1.01306, 1.17864, 1.01870, 1.01583, 1.18954],
    [1.12179, 1.01877, 1.18518, 1.19819, 1.06967, 1.08219, 1.18829, 1.06550, 1.06788, 1.19679],
    [1.18746, 1.02696, 1.14296, 1.18428, 1.11380, 1.00063, 1.10636, 1.01308, 1.15351, 1.05346],
    [1.18079, 1.04453, 1.03447, 1.06634, 1.02997, 1.06834, 1.14458, 1.10418, 1.07327, 1.08401],
    [1.01291, 1.09746, 1.06624, 1.08390, 1.18501, 1.14124, 1.02852, 1.19479, 1.02365, 1.01801],
    [1.10016, 1.03370, 1.06614, 1.05073, 1.00778, 1.03450, 1.06958, 1.09199, 1.12178, 1.00143],
    [1.17526, 1.15599, 1.18564, 1.04586, 1.12336, 1.09912, 1.09897, 1.16249, 1.14946, 1.05583],
    [1.03511, 1.00120, 1.09377, 1.03565, 1.07495, 1.09099, 1.15460, 1.18790, 1.03784, 1.07198],
    [1.01718, 1.14017, 1.09109, 1.19191, 1.18916, 1.11690, 1.01924, 1.02336, 1.07392, 1.04431],
    [1.13440, 1.05796, 1.01316, 1.14789, 1.10868, 1.13370, 1.02971, 1.04863, 1.11033, 1.15176],
    [1.10211, 1.06455, 1.12456, 1.03908, 1.10202, 1.12331, 1.04036, 1.01278, 1.02583, 1.19254],
    [1.18460, 1.10289, 1.05155, 1.03395, 1.08466, 1.18942, 1.05245, 1.18763, 1.14086, 1.11028],
    [1.09856, 1.19242, 1.18976, 1.09600, 1.17725, 1.14914, 1.03996, 1.08776, 1.06432, 1.03251],
    [1.16119, 1.19483, 1.17660, 1.05814, 1.00828, 1.04770, 1.13753, 1.11087, 1.16114, 1.10322],
    [1.08684, 1.14072, 1.16201, 1.05786, 1.06566, 1.13264, 1.03114, 1.02551, 1.10822, 1.15632],
    [1.14239, 1.03592, 1.17145, 1.10235, 1.03969, 1.11013, 1.13378, 1.01097, 1.07586, 1.06905],
    [1.19423, 1.19963, 1.05491, 1.13158, 1.10326, 1.09561, 1.15915, 1.05835, 1.15638, 1.18002],
    [1.14223, 1.09749, 1.18201, 1.14931, 1.06953, 1.08851, 1.05470, 1.10072, 1.18702, 1.18070],
    [1.16492, 1.04763, 1.19989, 1.12222, 1.17685, 1.17145, 1.14223, 1.17617, 1.10525, 1.11585],
    [1.11894, 1.01978, 1.04273, 1.13011, 1.10111, 1.08314, 1.16866, 1.16725, 1.05633, 1.08359],
    [1.17093, 1.14369, 1.19481, 1.01207, 1.11198, 1.06641, 1.01287, 1.12770, 1.07005, 1.03395],
    [1.11502, 1.01674, 1.18722, 1.01749, 1.09561, 1.07235, 1.05521, 1.02825, 1.06170, 1.05121],
    [1.07043, 1.17750, 1.07804, 1.06345, 1.08937, 1.03533, 1.11567, 1.05192, 1.01561, 1.19460],
    [1.18524, 1.11721, 1.04979, 1.04608, 1.03630, 1.14466, 1.03363, 1.07135, 1.10401, 1.08955],
    [1.01941, 1.05933, 1.08415, 1.17667, 1.09610, 1.15303, 1.01809, 1.17072, 1.00328, 1.13260],
    [1.06864, 1.17359, 1.16434, 1.04088, 1.06825, 1.10481, 1.06993, 1.15793, 1.02069, 1.12156],
    [1.04321, 1.03043, 1.03748, 1.13426, 1.11781, 1.16265, 1.09040, 1.07421, 1.06009, 1.07473],
    [1.06114, 1.06941, 1.06668, 1.13511, 1.06966, 1.18474, 1.16874, 1.07267, 1.16210, 1.08302],
    [1.07403, 1.17554, 1.13987, 1.06286, 1.07821, 1.08223, 1.01092, 1.02982, 1.17646, 1.17177],
    [1.04456, 1.05694, 1.00676, 1.05879, 1.11101, 1.09104, 1.15610, 1.00004, 1.08703, 1.06093],
    [1.06076, 1.11841, 1.00874, 1.14389, 1.03203, 1.05079, 1.15303, 1.04647, 1.03859, 1.12607],
    [1.12867, 1.05617, 1.17669, 1.07939, 1.15845, 1.11988, 1.05957, 1.00900, 1.03363, 1.10574],
    [1.05723, 1.18199, 1.12188, 1.10421, 1.01784, 1.19496, 1.10994, 1.12510, 1.00200, 1.09624],
    [1.06237, 1.04627, 1.06126, 1.17547, 1.07752, 1.17085, 1.19188, 1.02712, 1.12202, 1.04863],
    [1.09535, 1.19413, 1.12506, 1.11833, 1.07674, 1.19772, 1.11366, 1.02672, 1.11219, 1.05993],
    [1.07021, 1.18104, 1.01681, 1.12495, 1.09353, 1.19078, 1.14427, 1.08546, 1.14468, 1.15523],
    [1.14913, 1.02040, 1.15885, 1.05294, 1.04348, 1.15025, 1.00443, 1.18942, 1.07888, 1.11612],
    [1.07061, 1.15926, 1.08497, 1.08902, 1.16482, 1.07895, 1.19590, 1.11534, 1.10109, 1.14671],
    [1.19605, 1.00497, 1.06076, 1.08546, 1.01597, 1.16829, 1.10662, 1.12527, 1.01011, 1.10809],
    [1.13189, 1.08148, 1.14733, 1.17300, 1.02517, 1.18489, 1.14556, 1.07837, 1.13269, 1.01994],
    [1.08197, 1.00103, 1.19905, 1.02758, 1.10964, 1.15414, 1.06770, 1.12868, 1.01216, 1.04831],
    [1.12253, 1.12442, 1.02743, 1.14537, 1.15161, 1.02999, 1.07177, 1.11089, 1.01453, 1.19758],
    [1.19572, 1.17187, 1.19446, 1.18517, 1.00270, 1.18569, 1.01624, 1.02733, 1.06187, 1.12665],
    [1.01177, 1.06404, 1.04630, 1.19635, 1.01383, 1.18415, 1.02780, 1.06415, 1.05974, 1.03945],
    [1.05974, 1.04396, 1.08604, 1.08570, 1.07884, 1.11357, 1.09535, 1.00686, 1.05748, 1.18287],
    [1.17687, 1.17884, 1.03763, 1.11709, 1.06154, 1.12883, 1.17761, 1.12143, 1.19327, 1.04671],
    [1.04306, 1.19320, 1.19739, 1.10456, 1.07328, 1.04783, 1.12771, 1.04072, 1.05417, 1.02496],
    [1.17322, 1.16445, 1.12913, 1.18084, 1.00592, 1.03761, 1.17904, 1.07330, 1.05082, 1.18957],
    [1.10266, 1.04559, 1.05952, 1.12146, 1.02868, 1.11527, 1.06854, 1.15627, 1.19066, 1.07440],
    [1.12365, 1.19074, 1.09602, 1.10736, 1.05148, 1.10563, 1.12060, 1.13247, 1.05966, 1.09031],
    [1.15969, 1.17373, 1.04666, 1.03808, 1.06704, 1.16877, 1.00273, 1.06850, 1.11303, 1.11954],
    [1.18310, 1.13284, 1.19308, 1.19172, 1.03459, 1.15909, 1.01795, 1.06922, 1.15711, 1.09252],
    [1.01668, 1.17005, 1.08109, 1.08837, 1.18386, 1.02973, 1.14229, 1.01260, 1.00214, 1.05853],
    [1.03494, 1.10719, 1.07154, 1.17886, 1.12483, 1.17603, 1.17648, 1.14881, 1.10329, 1.14793],
    [1.02207, 1.07850, 1.06355, 1.17267, 1.17081, 1.14510, 1.18046, 1.10660, 1.01075, 1.01295],
    [1.07513, 1.14389, 1.08681, 1.16506, 1.04552, 1.04981, 1.02598, 1.05215, 1.04426, 1.15210],
    [1.18810, 1.06552, 1.18504, 1.14687, 1.07318, 1.04000, 1.05875, 1.07522, 1.01663, 1.09328],
    [1.04064, 1.12674, 1.00368, 1.10766, 1.06972, 1.02628, 1.13410, 1.06087, 1.08173, 1.06013],
    [1.16866, 1.11175, 1.17678, 1.09793, 1.08838, 1.04737, 1.10312, 1.06651, 1.09802, 1.19772],
    [1.13811, 1.03195, 1.00488, 1.02417, 1.14770, 1.14612, 1.00430, 1.08809, 1.10571, 1.01381],
    [1.00301, 1.00573, 1.05409, 1.13701, 1.11162, 1.09573, 1.18549, 1.19218, 1.03753, 1.12541],
    [1.02928, 1.19711, 1.00950, 1.06215, 1.02244, 1.12345, 1.16500, 1.03618, 1.04631, 1.01118],
    [1.03186, 1.02079, 1.01080, 1.14131, 1.03516, 1.03650, 1.06693, 1.12296, 1.06087, 1.18527],
    [1.12923, 1.05125, 1.00734, 1.12101, 1.08920, 1.19207, 1.15589, 1.06269, 1.00092, 1.15008],
    [1.09188, 1.15634, 1.02023, 1.17614, 1.00733, 1.09195, 1.17877, 1.17048, 1.11653, 1.18193],
    [1.17380, 1.03778, 1.01563, 1.00695, 1.05556, 1.15051, 1.11783, 1.03575, 1.19296, 1.17666],
    [1.19507, 1.12494, 1.19909, 1.02819, 1.15759, 1.10514, 1.19778, 1.18650, 1.10275, 1.15976],
    [1.11235, 1.16098, 1.16418, 1.00253, 1.15796, 1.13713, 1.19250, 1.16017, 1.01865, 1.17032],
    [1.19905, 1.16629, 1.09048, 1.18151, 1.19371, 1.17305, 1.07182, 1.11117, 1.14808, 1.18643],
    [1.08228, 1.08773, 1.11534, 1.03176, 1.19131, 1.16658, 1.03798, 1.05546, 1.13788, 1.09613],
    [1.07472, 1.06941, 1.12238, 1.06712, 1.17773, 1.14413, 1.05207, 1.10122, 1.15155, 1.15708],
    [1.12127, 1.03552, 1.12494, 1.10221, 1.10757, 1.15881, 1.06675, 1.06717, 1.06532, 1.05616],
    [1.07732, 1.08429, 1.19764, 1.11795, 1.08639, 1.16166, 1.18816, 1.06956, 1.08901, 1.10053],
    [1.17380, 1.17804, 1.15055, 1.00535, 1.03983, 1.09198, 1.11206, 1.09250, 1.01843, 1.17082]
],
    dtype=np.double)
minShekel = np.array([
    [-1.85298, 7.288],
    [-2.09360, 2.497],
    [-2.37493, 0.803],
    [-1.76149, 7.833],
    [-2.86001, 8.762],
    [-2.19686, 7.691],
    [-1.91211, 0.901],
    [-2.19514, 3.370],
    [-3.89667, 3.642],
    [-2.04275, 5.538],
    [-3.14299, 8.351],
    [-1.83163, 3.162],
    [-2.03521, 5.209],
    [-2.10209, 3.351],
    [-1.90642, 6.823],
    [-1.96309, 9.469],
    [-3.44893, 7.157],
    [-1.89005, 5.212],
    [-2.50860, 1.551],
    [-2.46707, 4.991],
    [-2.23207, 5.140],
    [-1.90514, 2.670],
    [-2.01529, 0.140],
    [-2.95998, 9.004],
    [-2.89922, 5.110],
    [-1.72527, 3.555],
    [-2.16560, 8.659],
    [-2.68007, 5.550],
    [-2.08080, 4.118],
    [-2.57115, 1.219],
    [-3.38741, 7.191],
    [-2.08314, 4.579],
    [-2.71673, 2.943],
    [-2.75781, 2.846],
    [-2.94354, 0.884],
    [-1.97648, 4.819],
    [-2.11114, 1.306],
    [-2.43103, 3.292],
    [-2.13599, 6.757],
    [-2.39159, 4.292],
    [-2.14258, 8.713],
    [-2.40213, 2.656],
    [-2.39552, 4.399],
    [-2.19491, 1.340],
    [-2.21471, 2.679],
    [-2.01473, 1.346],
    [-3.32986, 1.828],
    [-2.29795, 1.179],
    [-2.12219, 2.636],
    [-1.86816, 2.333],
    [-2.48836, 9.730],
    [-2.14927, 7.981],
    [-2.26542, 7.985],
    [-1.93403, 2.300],
    [-1.98591, 8.575],
    [-2.58936, 1.278],
    [-2.08216, 5.733],
    [-2.28467, 9.522],
    [-2.25246, 3.674],
    [-2.97102, 6.408],
    [-2.26896, 4.545],
    [-2.30743, 0.908],
    [-3.05056, 3.648],
    [-3.45105, 0.275],
    [-1.82753, 7.499],
    [-1.94513, 9.149],
    [-2.32479, 5.364],
    [-2.38414, 5.970],
    [-2.53954, 5.609],
    [-2.71774, 1.363],
    [-2.20182, 7.536],
    [-2.02306, 3.512],
    [-2.91755, 9.512],
    [-2.41165, 3.359],
    [-2.37522, 1.984],
    [-2.92006, 1.740],
    [-3.11371, 3.368],
    [-2.75221, 1.986],
    [-1.92595, 9.042],
    [-1.83226, 0.392],
    [-3.03090, 5.057],
    [-2.37948, 4.268],
    [-1.84944, 2.124],
    [-3.02710, 5.722],
    [-2.59392, 6.140],
    [-2.51458, 5.425],
    [-1.98422, 7.697],
    [-2.23391, 2.166],
    [-2.20281, 2.685],
    [-2.67355, 3.558],
    [-1.87309, 8.797],
    [-2.18050, 6.404],
    [-2.20420, 4.871],
    [-2.09230, 1.414],
    [-3.61233, 6.381],
    [-1.75324, 1.108],
    [-1.96371, 8.967],
    [-2.56501, 9.123],
    [-1.49308, 7.854],
    [-2.26230, 1.245],
    [-2.79032, 2.548],
    [-1.89186, 3.255],
    [-4.58470, 5.986],
    [-2.15234, 7.967],
    [-2.27088, 2.029],
    [-1.80350, 7.983],
    [-2.42863, 0.721],
    [-2.28173, 6.947],
    [-2.75481, 8.227],
    [-1.95482, 8.923],
    [-1.82247, 6.460],
    [-2.10315, 3.514],
    [-1.89306, 3.883],
    [-1.98395, 3.750],
    [-1.46281, 9.888],
    [-3.32830, 0.944],
    [-2.55725, 1.137],
    [-2.29451, 7.147],
    [-1.91119, 2.281],
    [-2.39943, 5.157],
    [-3.22599, 6.605],
    [-1.53881, 4.810],
    [-1.93970, 1.685],
    [-2.03667, 1.744],
    [-1.50128, 4.491],
    [-2.50822, 9.654],
    [-3.34054, 8.923],
    [-2.90839, 2.731],
    [-2.01562, 2.765],
    [-2.33777, 4.181],
    [-2.68749, 0.675],
    [-1.92603, 5.296],
    [-1.94562, 1.649],
    [-1.90193, 2.512],
    [-1.87021, 8.651],
    [-2.11983, 8.442],
    [-2.60931, 4.601],
    [-1.58258, 3.597],
    [-2.81033, 1.744],
    [-1.53909, 1.268],
    [-2.40499, 4.482],
    [-1.84686, 3.092],
    [-2.54132, 3.932],
    [-2.57170, 0.396],
    [-2.14472, 1.877],
    [-2.38396, 4.398],
    [-3.27538, 9.646],
    [-2.03665, 6.508],
    [-2.51363, 8.305],
    [-2.25009, 8.099],
    [-2.39408, 5.900],
    [-2.50041, 7.153],
    [-2.55885, 4.287],
    [-1.86733, 8.193],
    [-1.70799, 9.008],
    [-2.56582, 8.145],
    [-2.01905, 6.339],
    [-2.11371, 3.216],
    [-2.75254, 8.009],
    [-2.02191, 2.518],
    [-2.49033, 0.511],
    [-2.76661, 2.069],
    [-1.92271, 5.941],
    [-2.22059, 2.007],
    [-1.79417, 3.554],
    [-2.09584, 8.814],
    [-1.97072, 8.193],
    [-1.92336, 9.764],
    [-1.54017, 5.362],
    [-2.64772, 6.731],
    [-4.59169, 7.812],
    [-1.93809, 5.412],
    [-1.86498, 6.365],
    [-3.62881, 3.939],
    [-1.89289, 4.651],
    [-1.82643, 8.786],
    [-2.34630, 4.388],
    [-3.31142, 7.153],
    [-1.94107, 7.064],
    [-2.52511, 8.933],
    [-2.37037, 6.312],
    [-1.98174, 3.388],
    [-2.15705, 4.724],
    [-2.23845, 3.377],
    [-2.03436, 0.372],
    [-2.03196, 8.091],
    [-2.71434, 6.072],
    [-2.92260, 4.511],
    [-3.34224, 6.813],
    [-2.01772, 6.143],
    [-1.52048, 1.362],
    [-2.64351, 4.981],
    [-2.13114, 5.918],
    [-1.73623, 3.579],
    [-2.12581, 3.757],
    [-2.12567, 4.250],
    [-2.17889, 8.223],
    [-1.98500, 3.793],
    [-3.05505, 6.230],
    [-1.67306, 1.493],
    [-1.92458, 4.697],
    [-1.77391, 7.149],
    [-2.23436, 3.597],
    [-2.33244, 5.105],
    [-2.19489, 1.370],
    [-1.80920, 5.897],
    [-2.18650, 1.872],
    [-2.59777, 8.736],
    [-1.63069, 3.809],
    [-2.91898, 7.365],
    [-3.61433, 0.197],
    [-1.92180, 0.560],
    [-1.65383, 9.364],
    [-2.01557, 4.301],
    [-2.55812, 7.669],
    [-2.38717, 3.691],
    [-1.76253, 1.392],
    [-2.13931, 9.375],
    [-1.99365, 1.543],
    [-2.16215, 9.431],
    [-1.64849, 4.573],
    [-2.81535, 8.180],
    [-2.52254, 0.670],
    [-2.70242, 7.837],
    [-1.94763, 3.976],
    [-2.18440, 7.378],
    [-2.46649, 7.166],
    [-3.48186, 1.766],
    [-1.95207, 7.950],
    [-2.25776, 7.044],
    [-1.45176, 3.602],
    [-3.20871, 1.668],
    [-2.84797, 2.003],
    [-2.12510, 7.438],
    [-2.16364, 4.742],
    [-1.67255, 2.901],
    [-1.49449, 9.112],
    [-2.72673, 5.107],
    [-2.64292, 3.271],
    [-1.90300, 0.386],
    [-2.18957, 3.968],
    [-1.78782, 4.661],
    [-2.20039, 7.219],
    [-3.28259, 7.365],
    [-2.02264, 4.716],
    [-1.98320, 2.852],
    [-2.45665, 1.485],
    [-1.83685, 1.741],
    [-2.67702, 6.005],
    [-2.14375, 6.992],
    [-1.95379, 8.572],
    [-2.25407, 5.141],
    [-2.74052, 5.727],
    [-2.61397, 2.289],
    [-2.10033, 6.833],
    [-1.85481, 7.268],
    [-2.26275, 5.181],
    [-2.23453, 3.203],
    [-2.12769, 7.366],
    [-2.08956, 0.925],
    [-1.87203, 3.367],
    [-1.71363, 1.370],
    [-2.03379, 1.534],
    [-2.30233, 2.576],
    [-2.36308, 1.641],
    [-1.54513, 0.472],
    [-1.80361, 3.122],
    [-2.38815, 6.132],
    [-2.98802, 0.898],
    [-2.83593, 6.134],
    [-2.39345, 9.604],
    [-3.18620, 2.159],
    [-2.27122, 6.699],
    [-2.88238, 6.225],
    [-2.19048, 8.071],
    [-3.42814, 1.306],
    [-2.69944, 4.549],
    [-1.83866, 9.658],
    [-2.08372, 1.684],
    [-1.56729, 3.820],
    [-2.23668, 9.559],
    [-1.79908, 2.407],
    [-2.56228, 5.018],
    [-2.46886, 4.996],
    [-2.42642, 7.468],
    [-1.92053, 7.531],
    [-1.98681, 7.330],
    [-2.05756, 0.163],
    [-3.00597, 1.951],
    [-2.63146, 6.587],
    [-2.28643, 1.111],
    [-2.58002, 7.583],
    [-3.01495, 3.159],
    [-2.00282, 0.731],
    [-2.07338, 5.903],
    [-2.47027, 7.220],
    [-1.74187, 4.620],
    [-2.49168, 9.600],
    [-1.96319, 7.890],
    [-3.38846, 8.564],
    [-2.01299, 4.285],
    [-2.20036, 4.585],
    [-3.99316, 8.334],
    [-2.15807, 8.600],
    [-3.57570, 3.079],
    [-2.42949, 9.250],
    [-2.45410, 2.258],
    [-2.90799, 5.830],
    [-2.91067, 6.187],
    [-1.93164, 2.898],
    [-1.74865, 8.298],
    [-2.28426, 1.326],
    [-2.75192, 5.796],
    [-2.36154, 1.113],
    [-1.82193, 7.264],
    [-2.31381, 9.807],
    [-2.18482, 6.710],
    [-2.02123, 0.045],
    [-2.01678, 4.392],
    [-1.88425, 8.124],
    [-2.02912, 3.982],
    [-2.47899, 8.193],
    [-1.72551, 0.636],
    [-1.84825, 7.776],
    [-2.46180, 0.652],
    [-2.14111, 8.349],
    [-2.77204, 3.768],
    [-2.69602, 3.561],
    [-2.25080, 5.268],
    [-1.96821, 6.962],
    [-2.86672, 9.434],
    [-2.18603, 0.761],
    [-2.07538, 1.760],
    [-2.34657, 1.720],
    [-2.41438, 4.581],
    [-2.75743, 1.376],
    [-2.24619, 5.677],
    [-2.75772, 3.150],
    [-2.33978, 0.680],
    [-3.40931, 2.347],
    [-1.77731, 2.652],
    [-2.08611, 1.287],
    [-1.69484, 2.603],
    [-1.93787, 2.606],
    [-2.03131, 5.908],
    [-2.23569, 5.991],
    [-2.05355, 1.912],
    [-3.11315, 9.699],
    [-3.15033, 4.403],
    [-1.80924, 4.051],
    [-4.31470, 7.978],
    [-2.27990, 5.504],
    [-1.83977, 1.161],
    [-2.22546, 2.350],
    [-1.77689, 7.744],
    [-2.28520, 5.151],
    [-2.13041, 2.426],
    [-2.00100, 6.064],
    [-1.64848, 7.923],
    [-1.71792, 2.136],
    [-1.79894, 6.307],
    [-2.14114, 3.714],
    [-2.02233, 7.430],
    [-1.97628, 8.711],
    [-2.74133, 3.455],
    [-2.03574, 6.015],
    [-2.48760, 1.142],
    [-2.04116, 2.582],
    [-2.08944, 5.057],
    [-2.92739, 6.342],
    [-1.89210, 7.195],
    [-2.55683, 4.868],
    [-2.29909, 2.655],
    [-2.37655, 9.389],
    [-1.84925, 8.937],
    [-2.33309, 4.886],
    [-3.07964, 6.014],
    [-2.76333, 0.317],
    [-1.94691, 7.439],
    [-2.58858, 0.412],
    [-2.50132, 1.560],
    [-1.94180, 6.239],
    [-2.03197, 6.305],
    [-2.71923, 9.568],
    [-3.01591, 7.536],
    [-2.14918, 6.397],
    [-2.56212, 8.290],
    [-1.90057, 2.898],
    [-2.41151, 5.619],
    [-1.88987, 0.087],
    [-2.65125, 6.276],
    [-2.50712, 9.717],
    [-3.11784, 2.283],
    [-2.08140, 1.075],
    [-2.57113, 4.174],
    [-2.09497, 1.283],
    [-2.13404, 1.149],
    [-2.10629, 2.308],
    [-2.00418, 6.724],
    [-1.95721, 9.809],
    [-2.12250, 4.960],
    [-1.78986, 0.721],
    [-2.28921, 6.118],
    [-3.00380, 1.405],
    [-1.87250, 0.300],
    [-2.73342, 2.595],
    [-2.04591, 2.719],
    [-3.32880, 0.213],
    [-2.13354, 8.506],
    [-2.02555, 3.648],
    [-1.61276, 8.784],
    [-1.50115, 1.938],
    [-1.87034, 0.815],
    [-2.05106, 5.072],
    [-2.60908, 8.287],
    [-1.81365, 2.317],
    [-2.30089, 6.619],
    [-2.85480, 0.834],
    [-1.79115, 8.425],
    [-1.92593, 0.513],
    [-1.86965, 5.975],
    [-1.43347, 6.883],
    [-2.18314, 8.928],
    [-2.08894, 8.982],
    [-3.00385, 2.810],
    [-2.03516, 6.968],
    [-2.56611, 5.099],
    [-2.94939, 8.696],
    [-2.52246, 6.031],
    [-2.75787, 7.349],
    [-3.75906, 7.972],
    [-2.38087, 4.179],
    [-1.88920, 0.739],
    [-2.29667, 1.698],
    [-3.13871, 7.141],
    [-2.19563, 5.222],
    [-2.77089, 7.634],
    [-3.23785, 3.583],
    [-2.66558, 7.146],
    [-1.80928, 0.784],
    [-2.92872, 0.542],
    [-2.15531, 1.800],
    [-2.01060, 4.768],
    [-2.27336, 7.040],
    [-2.42042, 5.035],
    [-2.67561, 9.103],
    [-2.76041, 2.183],
    [-1.99001, 4.353],
    [-1.97034, 3.452],
    [-2.79769, 0.756],
    [-1.91135, 8.905],
    [-2.34132, 1.870],
    [-2.20074, 7.687],
    [-1.98031, 5.334],
    [-2.26026, 9.252],
    [-2.36746, 4.012],
    [-2.15075, 6.447],
    [-1.82683, 0.222],
    [-2.27560, 6.285],
    [-2.07302, 8.415],
    [-2.26183, 2.372],
    [-2.88984, 6.707],
    [-2.23905, 8.096],
    [-2.04728, 4.191],
    [-1.87992, 0.733],
    [-2.19369, 8.853],
    [-2.02265, 2.239],
    [-3.72742, 4.555],
    [-1.98418, 7.993],
    [-2.25813, 8.253],
    [-1.96112, 5.317],
    [-1.84748, 1.956],
    [-2.09761, 1.748],
    [-2.05602, 6.426],
    [-2.53775, 6.985],
    [-2.48817, 2.782],
    [-2.18916, 0.132],
    [-2.33376, 8.654],
    [-2.89024, 9.251],
    [-1.99531, 5.625],
    [-3.03453, 2.071],
    [-1.54841, 0.789],
    [-2.42809, 6.316],
    [-1.82706, 4.210],
    [-2.04601, 6.191],
    [-2.44293, 4.843],
    [-1.97596, 7.852],
    [-2.29279, 7.533],
    [-3.09043, 6.007],
    [-2.47992, 9.539],
    [-2.45371, 7.225],
    [-2.26934, 3.754],
    [-2.61281, 0.673],
    [-2.10951, 7.886],
    [-1.73052, 5.731],
    [-2.75153, 7.971],
    [-2.74816, 5.126],
    [-2.19989, 9.429],
    [-2.72586, 3.897],
    [-2.04330, 5.200],
    [-2.65529, 2.399],
    [-2.24098, 6.103],
    [-1.85101, 9.694],
    [-1.93563, 0.671],
    [-1.99495, 3.578],
    [-2.16791, 2.697],
    [-3.01108, 9.465],
    [-1.59936, 5.831],
    [-2.51536, 1.776],
    [-2.76214, 2.309],
    [-2.08710, 6.889],
    [-1.97376, 5.482],
    [-2.50281, 3.683],
    [-1.86182, 8.827],
    [-2.23997, 7.321],
    [-1.78585, 1.018],
    [-2.72227, 6.251],
    [-3.16570, 4.332],
    [-2.19974, 1.067],
    [-2.49144, 4.554],
    [-2.34620, 5.155],
    [-2.63189, 8.544],
    [-2.44518, 5.645],
    [-2.38233, 6.300],
    [-2.86232, 5.653],
    [-1.59896, 8.814],
    [-2.19543, 4.854],
    [-2.46478, 3.678],
    [-1.96452, 6.242],
    [-1.98283, 6.815],
    [-2.23071, 7.947],
    [-1.73401, 3.566],
    [-2.10982, 5.210],
    [-2.75420, 4.414],
    [-1.55815, 7.286],
    [-1.79953, 0.398],
    [-2.43859, 6.578],
    [-1.71617, 2.693],
    [-1.88529, 5.201],
    [-2.56087, 5.174],
    [-2.23265, 3.988],
    [-1.90774, 0.155],
    [-2.71149, 7.969],
    [-1.71188, 8.025],
    [-1.77825, 3.657],
    [-1.79333, 8.585],
    [-1.83175, 2.269],
    [-2.69575, 7.748],
    [-2.26982, 3.814],
    [-2.47299, 7.433],
    [-2.10042, 0.089],
    [-2.54270, 8.864],
    [-2.68779, 3.120],
    [-3.26805, 4.166],
    [-2.40843, 0.406],
    [-3.49062, 1.042],
    [-1.74153, 6.210],
    [-2.05469, 6.086],
    [-2.03309, 3.498],
    [-3.51886, 4.446],
    [-2.59942, 1.955],
    [-2.16136, 7.326],
    [-1.88164, 1.674],
    [-1.93968, 8.859],
    [-1.46446, 2.475],
    [-2.72681, 1.953],
    [-2.89470, 4.966],
    [-2.22574, 5.434],
    [-2.85259, 4.830],
    [-2.50095, 6.401],
    [-1.72492, 1.351],
    [-2.04988, 3.309],
    [-2.32435, 8.664],
    [-1.77192, 9.875],
    [-2.25745, 3.572],
    [-2.39401, 3.721],
    [-1.96177, 6.500],
    [-1.84889, 5.519],
    [-1.98981, 8.353],
    [-2.00516, 6.416],
    [-2.08396, 8.338],
    [-2.24580, 4.283],
    [-2.85363, 7.992],
    [-2.12505, 2.353],
    [-2.07460, 6.117],
    [-2.08213, 5.049],
    [-2.75296, 6.255],
    [-1.54060, 7.313],
    [-2.20719, 2.352],
    [-2.30159, 5.216],
    [-2.24194, 6.916],
    [-2.06712, 8.984],
    [-2.05375, 3.200],
    [-1.81568, 9.849],
    [-2.44253, 3.784],
    [-2.85225, 7.695],
    [-2.02101, 9.024],
    [-2.18313, 4.942],
    [-1.78810, 2.108],
    [-2.11115, 9.536],
    [-2.03560, 1.066],
    [-2.83903, 5.392],
    [-1.76312, 9.380],
    [-1.90318, 4.570],
    [-1.88771, 2.719],
    [-2.06757, 7.698],
    [-2.73640, 5.763],
    [-1.99476, 6.823],
    [-2.20342, 4.565],
    [-2.77824, 4.908],
    [-2.46551, 4.988],
    [-2.18421, 7.507],
    [-1.75776, 6.824],
    [-2.53361, 1.406],
    [-2.30507, 0.466],
    [-2.77190, 0.411],
    [-1.83566, 9.959],
    [-2.12516, 5.651],
    [-2.36734, 1.742],
    [-2.48144, 9.774],
    [-2.04699, 3.385],
    [-2.29537, 4.731],
    [-2.08480, 3.109],
    [-2.24917, 0.240],
    [-2.06956, 5.902],
    [-2.36788, 5.804],
    [-2.16181, 5.314],
    [-1.88721, 6.956],
    [-2.84278, 5.167],
    [-2.94763, 3.294],
    [-2.62337, 6.005],
    [-2.66397, 5.142],
    [-1.97282, 3.633],
    [-1.89293, 1.323],
    [-3.52951, 7.573],
    [-2.67726, 4.741],
    [-2.08915, 2.745],
    [-1.98808, 9.031],
    [-2.93817, 5.785],
    [-1.86256, 6.853],
    [-2.51913, 1.545],
    [-2.15737, 6.771],
    [-2.28427, 7.225],
    [-2.60813, 5.145],
    [-1.84361, 5.860],
    [-1.84961, 1.359],
    [-1.91905, 7.939],
    [-2.04915, 5.646],
    [-2.79020, 7.344],
    [-2.11747, 3.036],
    [-1.71120, 0.069],
    [-2.65594, 9.862],
    [-1.89640, 9.122],
    [-1.93532, 0.897],
    [-2.11169, 2.365],
    [-2.05435, 8.435],
    [-2.09431, 5.538],
    [-2.90448, 7.046],
    [-2.87441, 9.556],
    [-1.88263, 5.856],
    [-2.68610, 4.344],
    [-2.55144, 6.350],
    [-2.12083, 1.395],
    [-2.67696, 2.580],
    [-2.30638, 7.278],
    [-2.78280, 6.340],
    [-2.19038, 2.474],
    [-2.28547, 0.458],
    [-2.12491, 1.588],
    [-3.06988, 4.026],
    [-2.01304, 2.774],
    [-4.05540, 2.366],
    [-3.27590, 5.175],
    [-1.75886, 8.132],
    [-1.49946, 6.228],
    [-2.05656, 6.463],
    [-2.82259, 0.657],
    [-1.85879, 7.300],
    [-2.57968, 3.451],
    [-2.02244, 5.219],
    [-3.11702, 2.097],
    [-1.96954, 8.482],
    [-2.04634, 4.944],
    [-2.07998, 4.939],
    [-2.99908, 5.357],
    [-2.50161, 3.778],
    [-3.53567, 6.497],
    [-1.86014, 4.059],
    [-1.94413, 2.098],
    [-2.05393, 5.527],
    [-2.66320, 2.880],
    [-2.86295, 2.841],
    [-1.52766, 2.073],
    [-1.84900, 8.820],
    [-1.82753, 4.194],
    [-2.85041, 1.759],
    [-1.69700, 0.754],
    [-1.61261, 4.718],
    [-2.12553, 0.590],
    [-2.16293, 3.416],
    [-1.86218, 1.093],
    [-1.38351, 8.739],
    [-2.89414, 1.373],
    [-3.57061, 2.009],
    [-3.08786, 0.910],
    [-2.57241, 6.905],
    [-1.89271, 5.311],
    [-1.70805, 3.125],
    [-2.15325, 8.060],
    [-1.99372, 4.645],
    [-2.68372, 8.400],
    [-1.90086, 4.063],
    [-3.20918, 3.783],
    [-2.68274, 7.963],
    [-2.10315, 3.655],
    [-2.22189, 5.739],
    [-2.33349, 9.333],
    [-2.48847, 5.996],
    [-2.23012, 1.521],
    [-2.22404, 1.996],
    [-2.34628, 5.401],
    [-1.92797, 8.132],
    [-2.23418, 1.431],
    [-2.42862, 7.443],
    [-1.89671, 4.166],
    [-2.74310, 3.385],
    [-1.86833, 4.774],
    [-2.10638, 3.491],
    [-2.39580, 2.444],
    [-3.61545, 5.881],
    [-1.93754, 1.195],
    [-1.69136, 4.640],
    [-1.32449, 3.475],
    [-2.02775, 3.339],
    [-2.07823, 2.439],
    [-2.98055, 4.068],
    [-1.91182, 2.666],
    [-2.20259, 7.072],
    [-2.22996, 8.971],
    [-2.36951, 4.468],
    [-2.02113, 7.763],
    [-1.72947, 8.187],
    [-2.79694, 5.372],
    [-2.06828, 7.026],
    [-2.36488, 8.400],
    [-1.97373, 4.420],
    [-1.94968, 4.207],
    [-1.90613, 0.406],
    [-2.73043, 8.534],
    [-1.53370, 3.668],
    [-2.21881, 2.936],
    [-2.01927, 5.017],
    [-1.83526, 7.007],
    [-2.36481, 5.499],
    [-2.49867, 6.966],
    [-1.97913, 8.812],
    [-2.24789, 4.436],
    [-2.73330, 0.411],
    [-2.43300, 5.437],
    [-2.82366, 8.533],
    [-2.32915, 8.930],
    [-1.87868, 9.511],
    [-2.06964, 2.886],
    [-2.30518, 1.656],
    [-2.71147, 0.715],
    [-1.88503, 0.870],
    [-2.41429, 1.084],
    [-3.41560, 0.718],
    [-2.44974, 7.455],
    [-1.91914, 3.800],
    [-2.67845, 8.966],
    [-2.40665, 1.333],
    [-2.06270, 9.210],
    [-3.16594, 3.256],
    [-1.92147, 7.212],
    [-1.97007, 6.342],
    [-1.75041, 5.599],
    [-2.79930, 1.028],
    [-1.96586, 9.817],
    [-1.50542, 2.003],
    [-1.84174, 1.098],
    [-2.63092, 6.678],
    [-2.69337, 9.526],
    [-1.85884, 9.366],
    [-2.25536, 0.319],
    [-2.59592, 5.506],
    [-2.02450, 6.096],
    [-1.88372, 0.926],
    [-3.25820, 5.285],
    [-1.65960, 2.141],
    [-2.57629, 2.245],
    [-2.41772, 3.781],
    [-2.87213, 5.360],
    [-2.14968, 4.370],
    [-1.91269, 6.477],
    [-1.77061, 1.084],
    [-2.17741, 1.266],
    [-1.88541, 5.343],
    [-1.89155, 7.537],
    [-1.71642, 2.442],
    [-1.75462, 7.913],
    [-1.79322, 9.193],
    [-3.02446, 7.061],
    [-2.50300, 5.791],
    [-2.64602, 2.397],
    [-2.27108, 8.524],
    [-2.42209, 5.837],
    [-1.74396, 1.602],
    [-1.87498, 2.580],
    [-3.14391, 9.320],
    [-1.98207, 2.075],
    [-2.60801, 3.603],
    [-1.51046, 9.547],
    [-2.73900, 0.591],
    [-3.05214, 7.300],
    [-2.12861, 8.898],
    [-2.26359, 0.614],
    [-2.66765, 2.605],
    [-1.89390, 3.298],
    [-1.83701, 2.393],
    [-2.28368, 6.022],
    [-2.05318, 1.869],
    [-3.37204, 8.118],
    [-1.86236, 9.219],
    [-2.06032, 1.169],
    [-2.61974, 4.674],
    [-2.99417, 2.083],
    [-2.43121, 9.859],
    [-2.29507, 0.587],
    [-2.07583, 5.250],
    [-1.93486, 8.814],
    [-1.99990, 4.473],
    [-1.91359, 9.562],
    [-1.87119, 9.523],
    [-1.80428, 9.897],
    [-2.06220, 2.008],
    [-1.96158, 4.742],
    [-2.03717, 1.460],
    [-2.32264, 8.178],
    [-1.52684, 5.730],
    [-2.65383, 7.683],
    [-2.75321, 3.220],
    [-1.70295, 9.697],
    [-1.52666, 0.414],
    [-2.96123, 2.997],
    [-2.23213, 2.741],
    [-1.83966, 0.364],
    [-1.76303, 4.693],
    [-2.11724, 2.701],
    [-1.82438, 0.599],
    [-2.69651, 5.608],
    [-2.60319, 5.678],
    [-2.89660, 2.671],
    [-2.11766, 5.144],
    [-2.93871, 3.039],
    [-2.13206, 6.356],
    [-2.53205, 1.586],
    [-2.50935, 6.145],
    [-2.20017, 8.244],
    [-1.69441, 3.679],
    [-2.07271, 4.634],
    [-2.11862, 7.172],
    [-1.88629, 3.161],
    [-2.18422, 1.428],
    [-3.42514, 8.181],
    [-2.73171, 7.130],
    [-1.91335, 7.705],
    [-2.22286, 6.200],
    [-2.03745, 3.872],
    [-2.72754, 6.700],
    [-1.92001, 9.217],
    [-2.22573, 9.018],
    [-1.97307, 1.111],
    [-2.07192, 4.420],
    [-2.12073, 0.914],
    [-2.31786, 0.734],
    [-1.98781, 6.275],
    [-1.86410, 3.699],
    [-2.15700, 7.697],
    [-2.55068, 3.884],
    [-2.14440, 6.260],
    [-2.32853, 1.303],
    [-2.02407, 7.479],
    [-1.91454, 9.606],
    [-2.33067, 8.753],
    [-1.65918, 1.643],
    [-2.55045, 4.014],
    [-2.03015, 5.789],
    [-2.51280, 3.338],
    [-1.93814, 9.155],
    [-2.46857, 7.595],
    [-1.77029, 2.408],
    [-2.07914, 5.391],
    [-2.99147, 1.781],
    [-1.97433, 5.174],
    [-3.95021, 1.851],
    [-2.41329, 8.257],
    [-2.02764, 2.464],
    [-2.06770, 7.362],
    [-1.74160, 9.413],
    [-1.73831, 0.368],
    [-2.11613, 5.803],
    [-2.42327, 5.707],
    [-1.77383, 4.873],
    [-1.75400, 3.112],
    [-1.99260, 6.180],
    [-2.21458, 8.243],
    [-3.31469, 5.888],
    [-2.04581, 6.098],
    [-1.88466, 7.560],
    [-2.41434, 7.278],
    [-2.83983, 5.594],
    [-1.33276, 9.325],
    [-2.80585, 7.768],
    [-3.27565, 3.961],
    [-2.19136, 3.329],
    [-2.05765, 2.395],
    [-1.98881, 5.771],
    [-1.81074, 0.553],
    [-2.05204, 7.023],
    [-2.62812, 1.992],
    [-2.16974, 6.795],
    [-1.87204, 6.758],
    [-1.78011, 4.605],
    [-2.65708, 5.738],
    [-2.22929, 9.317],
    [-1.96245, 5.506],
    [-2.84457, 5.876],
    [-2.23438, 4.795],
    [-1.64793, 2.082],
    [-2.55884, 4.427],
    [-2.25316, 2.007],
    [-2.44413, 9.144],
    [-2.03179, 7.034],
    [-1.47668, 9.524],
    [-1.95794, 5.638],
    [-3.12804, 8.194],
    [-2.33296, 1.430],
    [-3.40574, 0.289],
    [-2.04054, 1.817],
    [-2.00376, 7.884],
    [-1.86414, 7.488],
    [-2.07828, 5.118],
    [-2.65722, 3.514],
    [-2.21158, 5.405],
    [-1.92854, 8.062],
    [-2.49622, 0.913],
    [-1.99420, 7.484],
    [-2.11375, 8.879],
    [-2.26968, 6.273],
    [-2.56652, 7.653],
    [-2.63316, 5.496],
    [-2.75926, 5.356],
    [-2.26185, 3.000],
    [-2.12783, 2.129],
    [-1.90137, 7.051],
    [-2.01122, 4.162],
    [-3.29922, 6.380],
    [-2.06190, 1.622],
    [-1.87728, 7.613],
    [-1.84960, 8.324],
    [-2.23304, 1.524],
    [-1.88868, 4.324],
    [-2.46266, 9.774],
    [-2.86344, 3.189],
    [-1.30134, 1.043],
    [-2.35839, 3.999],
    [-2.55609, 3.470],
    [-2.02824, 9.407],
    [-1.68585, 3.151],
    [-1.78267, 9.424],
    [-2.11491, 9.217],
    [-2.05690, 2.633],
    [-2.85281, 4.884],
    [-1.90482, 7.213],
    [-3.01491, 5.386],
    [-1.84300, 1.805],
    [-2.19441, 8.487],
    [-2.49659, 3.331],
    [-1.81854, 4.336],
    [-1.83976, 8.633],
    [-2.37846, 4.884],
    [-2.57864, 8.440],
    [-1.92797, 7.848],
    [-2.58106, 5.778],
    [-2.12080, 0.268],
    [-2.13870, 5.238],
    [-2.03970, 1.188],
    [-2.04397, 8.286],
    [-2.38938, 3.428],
    [-3.22484, 6.219],
    [-1.49918, 3.751],
    [-1.97107, 5.965],
    [-1.50562, 2.945],
    [-2.41085, 0.204],
    [-2.20529, 6.527],
    [-2.01933, 9.147],
    [-2.05173, 9.684],
    [-2.39518, 6.586],
    [-3.00334, 5.812]
],
    dtype=np.double)
maxHill = np.array([
    [-0.06015, 10.000],
    [-0.04973, 0.000],
    [-0.16222, 10.000],
    [-0.11096, 0.000],
    [-0.07334, 2.138],
    [-0.03810, 0.000],
    [-0.17442, 7.749],
    [-0.08171, 0.000],
    [-0.04897, 0.000],
    [-0.12327, 8.161],
    [-0.08613, 1.543],
    [-0.11504, 7.666],
    [-0.15253, 8.683],
    [-0.13130, 8.923],
    [-0.17327, 4.551],
    [-0.06031, 7.440],
    [-0.07854, 3.168],
    [-0.03918, 10.000],
    [-0.09898, 0.000],
    [-0.09126, 8.458],
    [-0.09126, 0.000],
    [-0.22282, 7.191],
    [-0.03952, 10.000],
    [-0.03830, 0.000],
    [-0.10165, 1.533],
    [-0.08738, 10.000],
    [-0.16790, 10.000],
    [-0.09574, 2.631],
    [-0.07779, 10.000],
    [-0.10957, 0.000],
    [-0.03621, 0.000],
    [-0.18280, 6.497],
    [-0.06856, 10.000],
    [-0.10453, 5.641],
    [-0.10170, 4.379],
    [-0.12695, 8.306],
    [-0.10299, 10.000],
    [-0.05446, 10.000],
    [-0.07656, 0.000],
    [-0.05539, 0.000],
    [-0.12708, 2.955],
    [-0.06829, 10.000],
    [-0.04336, 0.000],
    [-0.09508, 7.865],
    [-0.04227, 10.000],
    [-0.12380, 0.000],
    [-0.01908, 10.000],
    [-0.14872, 10.000],
    [-0.19032, 5.296],
    [-0.13203, 10.000],
    [-0.12956, 7.498],
    [-0.04464, 0.000],
    [-0.08267, 0.000],
    [-0.10001, 0.000],
    [-0.13820, 10.000],
    [-0.07876, 4.730],
    [-0.11939, 10.000],
    [-0.13031, 4.385],
    [-0.04972, 0.000],
    [-0.05348, 10.000],
    [-0.07068, 8.003],
    [-0.10645, 10.000],
    [-0.04313, 10.000],
    [-0.07081, 10.000],
    [-0.10945, 0.000],
    [-0.22464, 10.000],
    [-0.06728, 0.000],
    [-0.03611, 0.000],
    [-0.03857, 0.000],
    [-0.10087, 10.000],
    [-0.03140, 0.000],
    [-0.03548, 0.000],
    [-0.10397, 1.654],
    [-0.01955, 10.000],
    [-0.08340, 10.000],
    [-0.10360, 5.901],
    [-0.02151, 10.000],
    [-0.11070, 0.000],
    [-0.11594, 3.388],
    [-0.12386, 10.000],
    [-0.08904, 0.000],
    [-0.10542, 0.000],
    [-0.10216, 10.000],
    [-0.04049, 10.000],
    [-0.08150, 10.000],
    [-0.02324, 0.000],
    [-0.07481, 3.261],
    [-0.09660, 0.000],
    [-0.18888, 8.657],
    [-0.07014, 0.000],
    [-0.04215, 0.000],
    [-0.04035, 0.000],
    [-0.14443, 10.000],
    [-0.06836, 10.000],
    [-0.03522, 0.000],
    [-0.17060, 0.000],
    [-0.12634, 0.000],
    [-0.02329, 0.000],
    [-0.15745, 10.000],
    [-0.08052, 7.733],
    [-0.06473, 10.000],
    [-0.21379, 0.000],
    [-0.06806, 2.699],
    [-0.08727, 0.000],
    [-0.06066, 6.206],
    [-0.09308, 2.118],
    [-0.19103, 5.700],
    [-0.10875, 0.000],
    [-0.11376, 1.519],
    [-0.14732, 10.000],
    [-0.24390, 8.780],
    [-0.15067, 10.000],
    [-0.02444, 10.000],
    [-0.03549, 0.000],
    [-0.14327, 1.458],
    [-0.19033, 5.130],
    [-0.03510, 6.659],
    [-0.04827, 10.000],
    [-0.05371, 0.000],
    [-0.06896, 10.000],
    [-0.04388, 10.000],
    [-0.16743, 9.020],
    [-0.08858, 0.000],
    [-0.01805, 10.000],
    [-0.19763, 0.000],
    [-0.05541, 0.000],
    [-0.02892, 0.000],
    [-0.12255, 5.065],
    [-0.08275, 0.000],
    [-0.02323, 10.000],
    [-0.10930, 8.471],
    [-0.09578, 10.000],
    [-0.09495, 0.000],
    [-0.03693, 10.000],
    [-0.09023, 10.000],
    [-0.10967, 0.000],
    [-0.09354, 7.347],
    [-0.23845, 4.697],
    [-0.06029, 7.802],
    [-0.09456, 8.123],
    [-0.05102, 7.504],
    [-0.22775, 0.000],
    [-0.07714, 10.000],
    [-0.08824, 5.468],
    [-0.04987, 10.000],
    [-0.05610, 10.000],
    [-0.13738, 4.512],
    [-0.06900, 10.000],
    [-0.02283, 0.000],
    [-0.13796, 5.300],
    [-0.04089, 0.000],
    [-0.09206, 0.000],
    [-0.06204, 0.000],
    [-0.09405, 10.000],
    [-0.10238, 6.078],
    [-0.11493, 10.000],
    [-0.09776, 10.000],
    [-0.03142, 10.000],
    [-0.07344, 0.000],
    [-0.19532, 6.728],
    [-0.01933, 10.000],
    [-0.06224, 5.061],
    [-0.04083, 10.000],
    [-0.13306, 0.000],
    [-0.04752, 0.000],
    [-0.11941, 0.000],
    [-0.12422, 6.319],
    [-0.22100, 1.857],
    [-0.12357, 10.000],
    [-0.08317, 0.000],
    [-0.02450, 0.000],
    [-0.19411, 1.501],
    [-0.12050, 0.000],
    [-0.11612, 0.000],
    [-0.13660, 7.089],
    [-0.13849, 10.000],
    [-0.08421, 0.000],
    [-0.08218, 0.000],
    [-0.14065, 0.000],
    [-0.20780, 10.000],
    [-0.08127, 10.000],
    [-0.13927, 5.860],
    [-0.11184, 2.651],
    [-0.09473, 8.456],
    [-0.07402, 6.324],
    [-0.07270, 0.000],
    [-0.08049, 2.377],
    [-0.13882, 10.000],
    [-0.08041, 2.297],
    [-0.01778, 10.000],
    [-0.14154, 3.055],
    [-0.12066, 10.000],
    [-0.08112, 10.000],
    [-0.14211, 0.000],
    [-0.05672, 10.000],
    [-0.02674, 10.000],
    [-0.06420, 0.000],
    [-0.02636, 10.000],
    [-0.04765, 0.000],
    [-0.08518, 0.000],
    [-0.13138, 1.142],
    [-0.25329, 4.018],
    [-0.09349, 7.738],
    [-0.13103, 10.000],
    [-0.14177, 8.915],
    [-0.03158, 0.000],
    [-0.07703, 6.526],
    [-0.10238, 4.459],
    [-0.07596, 10.000],
    [-0.05745, 10.000],
    [-0.01686, 10.000],
    [-0.13363, 10.000],
    [-0.23643, 1.784],
    [-0.16473, 8.574],
    [-0.09378, 5.393],
    [-0.08344, 0.000],
    [-0.11023, 7.934],
    [-0.10177, 0.000],
    [-0.09605, 4.027],
    [-0.08580, 1.883],
    [-0.09300, 7.762],
    [-0.06415, 0.000],
    [-0.05305, 7.742],
    [-0.06516, 0.000],
    [-0.15888, 10.000],
    [-0.09091, 1.620],
    [-0.08833, 4.226],
    [-0.13983, 0.000],
    [-0.11655, 3.274],
    [-0.05572, 10.000],
    [-0.16431, 1.372],
    [-0.03027, 10.000],
    [-0.07421, 8.000],
    [-0.09053, 3.867],
    [-0.02423, 10.000],
    [-0.14558, 0.000],
    [-0.12565, 2.308],
    [-0.03137, 0.000],
    [-0.13590, 5.708],
    [-0.10780, 3.764],
    [-0.05659, 0.000],
    [-0.06244, 0.000],
    [-0.26352, 8.441],
    [-0.05936, 0.000],
    [-0.12133, 10.000],
    [-0.03154, 0.000],
    [-0.13233, 8.361],
    [-0.18051, 4.241],
    [-0.02420, 10.000],
    [-0.04354, 0.000],
    [-0.14297, 10.000],
    [-0.14825, 0.000],
    [-0.04392, 10.000],
    [-0.06584, 10.000],
    [-0.10191, 0.000],
    [-0.14564, 5.691],
    [-0.04350, 10.000],
    [-0.05248, 0.000],
    [-0.05542, 10.000],
    [-0.03866, 10.000],
    [-0.07380, 0.000],
    [-0.09306, 0.000],
    [-0.13784, 5.701],
    [-0.12038, 0.000],
    [-0.03924, 10.000],
    [-0.11136, 3.378],
    [-0.24090, 4.510],
    [-0.11454, 2.140],
    [-0.04353, 10.000],
    [-0.18219, 1.894],
    [-0.02602, 0.000],
    [-0.05060, 10.000],
    [-0.04924, 0.000],
    [-0.06004, 0.000],
    [-0.04244, 0.000],
    [-0.02839, 10.000],
    [-0.08020, 0.000],
    [-0.09221, 8.126],
    [-0.02733, 10.000],
    [-0.12145, 10.000],
    [-0.09853, 0.000],
    [-0.05433, 0.000],
    [-0.02654, 10.000],
    [-0.04160, 0.000],
    [-0.03071, 0.000],
    [-0.04744, 10.000],
    [-0.13521, 5.420],
    [-0.07564, 4.837],
    [-0.04326, 8.057],
    [-0.05342, 0.000],
    [-0.03721, 10.000],
    [-0.09051, 3.701],
    [-0.04727, 0.000],
    [-0.13536, 8.161],
    [-0.03685, 0.000],
    [-0.12772, 0.000],
    [-0.12433, 10.000],
    [-0.02250, 0.000],
    [-0.05883, 10.000],
    [-0.11792, 2.756],
    [-0.05383, 0.000],
    [-0.04237, 10.000],
    [-0.02643, 0.000],
    [-0.17983, 1.897],
    [-0.07869, 6.208],
    [-0.15506, 6.879],
    [-0.14286, 10.000],
    [-0.02938, 10.000],
    [-0.06664, 0.000],
    [-0.06803, 0.000],
    [-0.05978, 10.000],
    [-0.05177, 10.000],
    [-0.19738, 7.939],
    [-0.15580, 2.842],
    [-0.13919, 10.000],
    [-0.02061, 0.000],
    [-0.06889, 10.000],
    [-0.21055, 9.129],
    [-0.07483, 10.000],
    [-0.10129, 4.427],
    [-0.04768, 10.000],
    [-0.24206, 10.000],
    [-0.19599, 5.009],
    [-0.23960, 4.202],
    [-0.03328, 10.000],
    [-0.11851, 4.219],
    [-0.14733, 10.000],
    [-0.16298, 8.540],
    [-0.11486, 10.000],
    [-0.04965, 0.000],
    [-0.07606, 0.000],
    [-0.11800, 6.297],
    [-0.06148, 0.000],
    [-0.04047, 10.000],
    [-0.04558, 10.000],
    [-0.05105, 10.000],
    [-0.11172, 10.000],
    [-0.05317, 0.000],
    [-0.10811, 5.353],
    [-0.05447, 10.000],
    [-0.04642, 10.000],
    [-0.06092, 10.000],
    [-0.15871, 10.000],
    [-0.08866, 0.000],
    [-0.13743, 1.779],
    [-0.13589, 7.959],
    [-0.06851, 0.000],
    [-0.08409, 4.550],
    [-0.06911, 0.000],
    [-0.04361, 0.000],
    [-0.09565, 0.000],
    [-0.03605, 10.000],
    [-0.18459, 6.845],
    [-0.12015, 10.000],
    [-0.11814, 2.391],
    [-0.03397, 0.000],
    [-0.07852, 10.000],
    [-0.06959, 10.000],
    [-0.07113, 10.000],
    [-0.03309, 10.000],
    [-0.12826, 3.212],
    [-0.05800, 10.000],
    [-0.03087, 0.000],
    [-0.16435, 4.154],
    [-0.05910, 10.000],
    [-0.06855, 0.000],
    [-0.11178, 8.004],
    [-0.05369, 0.000],
    [-0.04108, 10.000],
    [-0.02387, 0.000],
    [-0.07720, 0.000],
    [-0.16753, 6.444],
    [-0.09780, 7.557],
    [-0.15651, 6.618],
    [-0.13172, 10.000],
    [-0.04328, 10.000],
    [-0.13029, 10.000],
    [-0.03881, 7.287],
    [-0.07465, 0.000],
    [-0.17995, 8.706],
    [-0.03563, 10.000],
    [-0.07371, 10.000],
    [-0.14775, 8.056],
    [-0.01610, 0.000],
    [-0.09946, 10.000],
    [-0.03128, 0.000],
    [-0.06436, 0.000],
    [-0.15816, 10.000],
    [-0.10524, 1.692],
    [-0.12415, 5.418],
    [-0.04430, 10.000],
    [-0.03555, 0.000],
    [-0.05902, 10.000],
    [-0.11403, 8.359],
    [-0.03793, 10.000],
    [-0.05619, 10.000],
    [-0.11556, 10.000],
    [-0.07871, 10.000],
    [-0.03391, 0.000],
    [-0.19081, 8.672],
    [-0.11553, 7.305],
    [-0.26008, 5.453],
    [-0.05880, 0.000],
    [-0.02649, 10.000],
    [-0.12815, 10.000],
    [-0.06160, 0.000],
    [-0.06103, 10.000],
    [-0.03307, 10.000],
    [-0.03021, 0.000],
    [-0.18301, 7.718],
    [-0.20704, 4.232],
    [-0.17835, 8.307],
    [-0.18473, 2.595],
    [-0.03244, 0.000],
    [-0.09684, 10.000],
    [-0.03058, 10.000],
    [-0.03673, 0.000],
    [-0.12654, 5.757],
    [-0.17546, 6.902],
    [-0.09597, 5.085],
    [-0.20484, 10.000],
    [-0.12891, 10.000],
    [-0.07081, 2.145],
    [-0.12650, 3.168],
    [-0.12816, 10.000],
    [-0.11296, 3.219],
    [-0.09557, 10.000],
    [-0.06799, 0.000],
    [-0.03686, 0.000],
    [-0.12510, 3.118],
    [-0.01451, 0.000],
    [-0.26273, 5.797],
    [-0.19264, 4.592],
    [-0.10732, 10.000],
    [-0.01627, 0.000],
    [-0.05169, 0.000],
    [-0.13309, 0.000],
    [-0.03511, 10.000],
    [-0.12030, 1.765],
    [-0.13895, 5.120],
    [-0.12571, 8.350],
    [-0.09103, 0.000],
    [-0.03899, 10.000],
    [-0.21076, 4.559],
    [-0.03812, 10.000],
    [-0.04776, 0.000],
    [-0.02699, 10.000],
    [-0.11819, 1.236],
    [-0.02559, 0.000],
    [-0.04436, 10.000],
    [-0.03828, 0.000],
    [-0.13024, 10.000],
    [-0.06235, 3.133],
    [-0.08558, 10.000],
    [-0.13647, 6.059],
    [-0.05228, 10.000],
    [-0.06418, 10.000],
    [-0.14104, 7.779],
    [-0.04827, 0.000],
    [-0.02288, 0.000],
    [-0.05092, 0.000],
    [-0.04044, 0.000],
    [-0.11947, 5.951],
    [-0.05583, 0.000],
    [-0.08656, 8.249],
    [-0.03549, 0.000],
    [-0.08877, 7.493],
    [-0.02294, 10.000],
    [-0.13728, 10.000],
    [-0.11970, 3.016],
    [-0.14527, 2.815],
    [-0.05643, 10.000],
    [-0.06874, 10.000],
    [-0.30217, 0.889],
    [-0.10913, 0.000],
    [-0.12065, 0.000],
    [-0.13886, 4.477],
    [-0.10845, 6.094],
    [-0.07672, 4.067],
    [-0.10397, 10.000],
    [-0.09419, 0.000],
    [-0.08638, 5.795],
    [-0.05149, 10.000],
    [-0.08472, 10.000],
    [-0.05754, 10.000],
    [-0.11445, 10.000],
    [-0.12800, 10.000],
    [-0.18145, 5.705],
    [-0.03156, 10.000],
    [-0.20344, 6.974],
    [-0.04438, 0.000],
    [-0.02581, 10.000],
    [-0.06424, 8.403],
    [-0.05597, 10.000],
    [-0.07297, 0.000],
    [-0.05660, 0.000],
    [-0.12715, 10.000],
    [-0.09663, 4.497],
    [-0.03618, 10.000],
    [-0.11333, 1.821],
    [-0.09768, 6.110],
    [-0.11303, 2.708],
    [-0.14938, 3.427],
    [-0.03070, 10.000],
    [-0.07425, 10.000],
    [-0.09826, 6.599],
    [-0.02389, 0.000],
    [-0.04931, 10.000],
    [-0.07110, 6.804],
    [-0.03185, 10.000],
    [-0.02408, 0.000],
    [-0.11188, 2.683],
    [-0.10311, 0.000],
    [-0.07863, 0.000],
    [-0.12682, 1.074],
    [-0.13006, 0.000],
    [-0.02488, 0.000],
    [-0.04600, 0.000],
    [-0.12058, 4.674],
    [-0.05429, 0.000],
    [-0.04808, 10.000],
    [-0.09988, 4.364],
    [-0.06512, 10.000],
    [-0.07128, 0.000],
    [-0.02338, 10.000],
    [-0.06978, 0.000],
    [-0.11525, 2.308],
    [-0.05465, 10.000],
    [-0.05030, 10.000],
    [-0.11797, 10.000],
    [-0.10427, 10.000],
    [-0.12986, 0.000],
    [-0.12731, 3.478],
    [-0.09529, 7.867],
    [-0.16239, 3.319],
    [-0.05697, 10.000],
    [-0.11967, 10.000],
    [-0.19359, 0.000],
    [-0.19498, 10.000],
    [-0.11062, 0.000],
    [-0.04651, 10.000],
    [-0.13936, 4.587],
    [-0.06197, 10.000],
    [-0.08290, 0.000],
    [-0.05801, 0.000],
    [-0.12400, 10.000],
    [-0.19979, 1.230],
    [-0.04149, 0.000],
    [-0.05617, 10.000],
    [-0.15077, 10.000],
    [-0.07927, 10.000],
    [-0.13910, 0.000],
    [-0.08969, 0.000],
    [-0.04475, 10.000],
    [-0.16916, 3.093],
    [-0.05071, 8.181],
    [-0.18241, 4.613],
    [-0.02189, 0.000],
    [-0.11395, 5.754],
    [-0.11014, 1.214],
    [-0.04880, 10.000],
    [-0.06102, 10.000],
    [-0.05014, 10.000],
    [-0.01882, 0.000],
    [-0.22009, 3.712],
    [-0.03311, 10.000],
    [-0.13070, 7.830],
    [-0.06652, 0.000],
    [-0.02171, 10.000],
    [-0.02535, 10.000],
    [-0.07966, 0.000],
    [-0.23015, 6.617],
    [-0.12768, 0.000],
    [-0.19548, 4.447],
    [-0.08948, 0.000],
    [-0.08303, 10.000],
    [-0.03199, 10.000],
    [-0.09284, 0.000],
    [-0.11192, 0.000],
    [-0.06526, 3.213],
    [-0.05175, 0.000],
    [-0.13142, 7.098],
    [-0.12779, 0.000],
    [-0.11925, 7.152],
    [-0.04065, 10.000],
    [-0.12967, 0.000],
    [-0.06260, 2.434],
    [-0.03391, 0.000],
    [-0.09199, 10.000],
    [-0.03909, 10.000],
    [-0.09453, 1.559],
    [-0.03566, 0.000],
    [-0.06208, 10.000],
    [-0.09885, 0.000],
    [-0.04287, 0.000],
    [-0.13102, 0.000],
    [-0.22754, 7.582],
    [-0.09915, 10.000],
    [-0.04054, 0.000],
    [-0.14403, 0.000],
    [-0.09457, 10.000],
    [-0.02888, 10.000],
    [-0.16332, 4.167],
    [-0.17916, 10.000],
    [-0.10228, 10.000],
    [-0.06031, 10.000],
    [-0.13339, 8.847],
    [-0.03835, 0.000],
    [-0.12678, 1.107],
    [-0.08558, 10.000],
    [-0.03113, 0.000],
    [-0.09505, 3.163],
    [-0.24203, 8.672],
    [-0.11514, 5.834],
    [-0.12632, 10.000],
    [-0.01965, 10.000],
    [-0.10280, 0.000],
    [-0.01727, 0.000],
    [-0.20469, 10.000],
    [-0.05790, 1.954],
    [-0.14461, 6.341],
    [-0.03862, 0.000],
    [-0.12891, 8.161],
    [-0.08918, 6.340],
    [-0.03605, 0.000],
    [-0.17033, 2.628],
    [-0.19181, 1.782],
    [-0.09244, 1.284],
    [-0.08362, 0.000],
    [-0.07749, 7.166],
    [-0.06537, 10.000],
    [-0.05679, 10.000],
    [-0.03264, 0.000],
    [-0.19127, 6.945],
    [-0.09621, 0.000],
    [-0.09813, 2.509],
    [-0.06962, 7.871],
    [-0.11916, 6.655],
    [-0.11586, 3.221],
    [-0.08511, 10.000],
    [-0.21825, 7.381],
    [-0.08600, 0.000],
    [-0.18251, 3.794],
    [-0.03670, 0.000],
    [-0.18030, 4.519],
    [-0.05502, 10.000],
    [-0.10561, 5.139],
    [-0.06441, 0.000],
    [-0.05423, 10.000],
    [-0.18523, 5.699],
    [-0.06273, 7.506],
    [-0.12954, 3.163],
    [-0.04071, 0.000],
    [-0.03414, 10.000],
    [-0.02867, 10.000],
    [-0.12774, 3.756],
    [-0.03042, 10.000],
    [-0.13347, 4.279],
    [-0.07857, 6.182],
    [-0.16367, 0.000],
    [-0.04970, 10.000],
    [-0.12750, 3.886],
    [-0.07252, 3.510],
    [-0.05239, 10.000],
    [-0.03422, 0.000],
    [-0.05468, 10.000],
    [-0.06372, 10.000],
    [-0.14912, 10.000],
    [-0.07576, 10.000],
    [-0.06521, 0.000],
    [-0.07358, 10.000],
    [-0.02438, 10.000],
    [-0.04693, 10.000],
    [-0.08884, 10.000],
    [-0.26308, 1.598],
    [-0.18085, 8.374],
    [-0.20252, 6.811],
    [-0.08030, 10.000],
    [-0.08992, 10.000],
    [-0.08725, 0.000],
    [-0.11054, 5.044],
    [-0.09558, 0.000],
    [-0.21929, 7.856],
    [-0.04144, 0.000],
    [-0.05801, 0.000],
    [-0.13603, 7.714],
    [-0.07358, 0.000],
    [-0.10129, 1.509],
    [-0.12480, 10.000],
    [-0.04343, 0.000],
    [-0.09366, 0.000],
    [-0.15398, 4.539],
    [-0.22611, 3.151],
    [-0.10764, 6.858],
    [-0.11462, 0.000],
    [-0.14300, 0.000],
    [-0.15123, 6.955],
    [-0.11412, 2.547],
    [-0.08464, 10.000],
    [-0.02878, 0.000],
    [-0.12990, 4.195],
    [-0.27403, 2.598],
    [-0.02301, 10.000],
    [-0.01946, 10.000],
    [-0.05858, 7.391],
    [-0.11282, 0.000],
    [-0.02620, 0.000],
    [-0.06222, 10.000],
    [-0.06128, 10.000],
    [-0.09487, 2.004],
    [-0.05946, 0.000],
    [-0.20517, 0.000],
    [-0.03411, 10.000],
    [-0.16280, 2.114],
    [-0.09311, 6.528],
    [-0.04133, 0.000],
    [-0.15400, 7.006],
    [-0.08957, 10.000],
    [-0.12154, 0.000],
    [-0.07841, 10.000],
    [-0.07995, 10.000],
    [-0.10892, 10.000],
    [-0.10919, 3.841],
    [-0.04214, 0.000],
    [-0.06221, 10.000],
    [-0.13738, 8.531],
    [-0.08067, 7.760],
    [-0.03662, 10.000],
    [-0.06915, 0.000],
    [-0.02403, 0.000],
    [-0.08669, 10.000],
    [-0.05846, 10.000],
    [-0.17886, 8.838],
    [-0.07992, 0.000],
    [-0.02046, 10.000],
    [-0.11913, 10.000],
    [-0.04446, 0.000],
    [-0.10308, 1.578],
    [-0.03673, 0.000],
    [-0.04369, 10.000],
    [-0.13454, 1.499],
    [-0.15407, 0.000],
    [-0.03268, 10.000],
    [-0.07871, 10.000],
    [-0.08762, 4.470],
    [-0.11545, 1.581],
    [-0.13758, 0.000],
    [-0.10721, 5.842],
    [-0.06655, 3.167],
    [-0.04799, 0.000],
    [-0.04957, 0.000],
    [-0.08490, 8.182],
    [-0.10150, 0.000],
    [-0.18143, 2.829],
    [-0.05132, 0.000],
    [-0.07424, 0.000],
    [-0.10106, 0.000],
    [-0.03448, 10.000],
    [-0.11034, 2.805],
    [-0.06831, 0.000],
    [-0.12975, 1.931],
    [-0.02215, 0.000],
    [-0.08762, 5.024],
    [-0.02756, 10.000],
    [-0.02343, 10.000],
    [-0.06487, 10.000],
    [-0.03324, 10.000],
    [-0.04631, 10.000],
    [-0.08529, 0.000],
    [-0.24433, 2.244],
    [-0.13736, 6.153],
    [-0.09122, 7.650],
    [-0.13460, 3.996],
    [-0.05705, 0.000],
    [-0.12007, 3.303],
    [-0.08199, 0.000],
    [-0.18026, 10.000],
    [-0.12235, 7.450],
    [-0.08145, 0.000],
    [-0.16820, 0.000],
    [-0.17404, 10.000],
    [-0.09712, 0.000],
    [-0.05428, 0.000],
    [-0.08757, 2.317],
    [-0.14957, 7.839],
    [-0.06574, 0.000],
    [-0.13608, 10.000],
    [-0.14293, 5.974],
    [-0.04107, 0.000],
    [-0.05708, 0.000],
    [-0.16870, 8.386],
    [-0.02698, 0.000],
    [-0.17597, 10.000],
    [-0.09276, 10.000],
    [-0.15310, 10.000],
    [-0.10023, 10.000],
    [-0.10839, 8.970],
    [-0.07021, 10.000],
    [-0.08277, 10.000],
    [-0.09130, 0.000],
    [-0.24640, 10.000],
    [-0.09097, 1.339],
    [-0.11724, 0.000],
    [-0.06977, 0.000],
    [-0.05375, 10.000],
    [-0.08269, 2.559],
    [-0.12114, 1.721],
    [-0.05875, 0.000],
    [-0.07929, 10.000],
    [-0.09668, 1.908],
    [-0.18165, 6.019],
    [-0.15237, 5.286],
    [-0.02666, 0.000],
    [-0.05043, 8.000],
    [-0.06123, 2.023],
    [-0.12947, 2.890],
    [-0.09707, 3.505],
    [-0.04417, 10.000],
    [-0.05473, 10.000],
    [-0.12216, 8.201],
    [-0.08551, 0.000],
    [-0.06276, 10.000],
    [-0.04478, 0.000],
    [-0.23452, 6.104],
    [-0.12956, 2.953],
    [-0.04977, 0.000],
    [-0.04015, 10.000],
    [-0.07786, 2.810],
    [-0.09407, 10.000],
    [-0.10961, 0.000],
    [-0.12244, 2.639],
    [-0.11745, 0.000],
    [-0.16066, 8.330],
    [-0.04039, 0.000],
    [-0.04887, 0.000],
    [-0.07515, 5.756],
    [-0.12043, 10.000],
    [-0.09219, 0.000],
    [-0.08552, 0.000],
    [-0.16780, 8.623],
    [-0.09527, 2.647],
    [-0.07023, 0.000],
    [-0.10481, 0.000],
    [-0.21075, 7.667],
    [-0.04895, 0.000],
    [-0.07671, 0.000],
    [-0.20801, 8.030],
    [-0.11748, 7.285],
    [-0.11062, 0.000],
    [-0.16646, 4.105],
    [-0.05775, 10.000],
    [-0.10766, 0.000],
    [-0.18438, 0.000],
    [-0.04968, 10.000],
    [-0.05921, 0.000],
    [-0.07350, 10.000],
    [-0.15575, 4.783],
    [-0.09240, 2.828],
    [-0.02702, 0.000],
    [-0.15820, 8.878],
    [-0.05410, 10.000],
    [-0.10490, 0.000],
    [-0.12145, 4.773],
    [-0.12152, 4.317],
    [-0.05085, 0.000],
    [-0.09859, 1.614],
    [-0.05849, 1.591],
    [-0.13024, 10.000],
    [-0.08834, 1.260],
    [-0.10368, 0.000],
    [-0.09833, 4.174],
    [-0.04137, 2.284],
    [-0.09115, 8.500],
    [-0.03192, 0.000],
    [-0.14959, 10.000],
    [-0.11048, 4.089],
    [-0.07051, 10.000],
    [-0.09184, 10.000],
    [-0.03600, 0.000],
    [-0.13414, 0.000],
    [-0.03587, 0.000],
    [-0.04656, 10.000],
    [-0.04645, 0.000],
    [-0.13796, 0.000],
    [-0.06713, 5.786],
    [-0.07371, 7.474],
    [-0.14827, 8.167],
    [-0.06335, 10.000],
    [-0.04321, 10.000],
    [-0.11681, 0.000],
    [-0.07839, 4.756],
    [-0.08122, 10.000],
    [-0.04769, 0.000],
    [-0.03066, 10.000],
    [-0.04477, 0.000],
    [-0.04727, 10.000],
    [-0.15741, 5.131],
    [-0.21777, 1.268],
    [-0.15016, 0.000],
    [-0.19632, 2.621],
    [-0.08432, 10.000],
    [-0.21166, 2.145],
    [-0.12467, 7.624],
    [-0.07067, 10.000],
    [-0.04374, 0.000],
    [-0.07230, 2.855],
    [-0.04566, 0.000],
    [-0.06043, 0.000],
    [-0.16895, 0.000],
    [-0.18526, 1.503],
    [-0.05659, 10.000],
    [-0.02146, 0.000],
    [-0.12433, 0.000],
    [-0.03366, 0.000],
    [-0.03811, 10.000],
    [-0.09670, 10.000],
    [-0.16612, 8.437],
    [-0.07059, 10.000],
    [-0.18066, 8.540],
    [-0.14981, 1.295],
    [-0.04781, 10.000],
    [-0.08130, 10.000],
    [-0.13953, 8.720],
    [-0.18049, 10.000],
    [-0.02917, 0.000],
    [-0.06270, 0.000],
    [-0.06590, 0.000],
    [-0.08756, 0.000],
    [-0.04477, 0.000],
    [-0.08373, 0.000],
    [-0.02373, 10.000],
    [-0.14092, 7.476],
    [-0.05907, 0.000],
    [-0.11622, 4.009],
    [-0.14247, 1.263],
    [-0.20994, 7.212],
    [-0.14101, 3.505],
    [-0.05032, 10.000],
    [-0.02304, 10.000],
    [-0.10805, 0.000],
    [-0.09226, 10.000],
    [-0.21640, 6.066],
    [-0.03843, 0.000],
    [-0.05445, 0.000],
    [-0.07009, 10.000],
    [-0.11795, 0.000],
    [-0.01810, 10.000],
    [-0.13621, 10.000],
    [-0.21265, 4.531],
    [-0.14490, 2.582],
    [-0.05016, 0.000],
    [-0.10846, 10.000],
    [-0.11270, 10.000],
    [-0.06206, 10.000],
    [-0.05275, 10.000],
    [-0.09229, 10.000],
    [-0.09345, 10.000],
    [-0.05899, 10.000],
    [-0.11215, 5.383],
    [-0.14364, 1.910],
    [-0.13346, 0.000],
    [-0.09198, 4.598],
    [-0.05696, 0.000],
    [-0.19815, 0.000],
    [-0.15276, 0.000],
    [-0.18707, 3.874],
    [-0.18698, 10.000],
    [-0.20240, 0.000],
    [-0.10664, 2.086],
    [-0.10291, 0.000],
    [-0.11432, 5.948],
    [-0.17516, 5.109],
    [-0.07731, 10.000],
    [-0.06652, 10.000],
    [-0.05929, 10.000],
    [-0.18281, 1.447],
    [-0.09788, 6.106],
    [-0.09011, 0.000],
    [-0.11981, 10.000],
    [-0.10756, 0.000],
    [-0.15819, 4.330],
    [-0.12307, 7.475],
    [-0.06626, 3.171],
    [-0.04574, 0.000],
    [-0.03724, 0.000],
    [-0.07089, 10.000],
    [-0.05474, 0.000],
    [-0.21774, 0.000],
    [-0.12054, 4.732],
    [-0.20689, 7.578],
    [-0.07562, 0.000],
    [-0.13397, 10.000],
    [-0.06648, 10.000],
    [-0.03064, 10.000],
    [-0.12702, 6.537],
    [-0.03454, 0.000],
    [-0.05367, 0.000],
    [-0.10952, 0.000],
    [-0.14914, 8.602],
    [-0.02774, 0.000]
],
    dtype=np.double)
lConstantHill = np.array([
    4.02007,
    4.27525,
    3.12554,
    2.83000,
    4.82899,
    4.34591,
    4.54607,
    3.69802,
    7.75208,
    3.75543,
    5.29004,
    3.30792,
    5.05533,
    4.19276,
    4.09791,
    5.50411,
    7.56128,
    3.92099,
    6.12023,
    4.54032,
    5.27195,
    5.15516,
    3.79335,
    5.91342,
    4.65170,
    3.97372,
    3.41825,
    4.58927,
    3.78723,
    7.34706,
    7.60923,
    3.55856,
    4.79602,
    5.16327,
    6.24999,
    3.50503,
    3.86084,
    4.40614,
    4.01171,
    4.79460,
    4.65674,
    3.19565,
    5.48670,
    3.73924,
    4.38690,
    4.76521,
    5.02718,
    4.31793,
    5.07915,
    3.97105,
    6.39654,
    5.15710,
    3.53571,
    4.69455,
    4.26587,
    5.87077,
    3.64368,
    4.48713,
    4.56908,
    6.11830,
    5.34272,
    3.30433,
    6.11611,
    6.24811,
    3.84973,
    4.39365,
    4.32691,
    4.93301,
    4.63635,
    5.73586,
    3.51998,
    4.88607,
    5.71138,
    4.82609,
    5.68154,
    6.71872,
    7.52967,
    4.89772,
    3.51817,
    2.94508,
    6.11026,
    5.46378,
    4.80600,
    7.15727,
    5.96744,
    5.94503,
    3.89862,
    3.96383,
    5.21950,
    5.36709,
    4.86779,
    4.89395,
    4.39107,
    4.47104,
    7.49393,
    3.72213,
    4.28424,
    6.30919,
    2.97372,
    3.93575,
    5.96866,
    4.66702,
    10.57580,
    3.76351,
    4.56050,
    3.19122,
    4.89363,
    4.47071,
    4.89126,
    4.66850,
    3.89733,
    4.87211,
    4.30277,
    4.20865,
    3.90173,
    6.88967,
    5.07829,
    5.53722,
    4.47379,
    4.50493,
    6.33807,
    3.43553,
    4.70594,
    3.94122,
    3.02244,
    4.68355,
    5.56797,
    7.20441,
    4.40593,
    3.88502,
    4.19743,
    3.92513,
    4.15791,
    4.28649,
    4.54563,
    4.76117,
    5.51793,
    3.85325,
    5.74086,
    3.95697,
    6.60453,
    3.66580,
    4.46120,
    5.66823,
    4.09129,
    3.97466,
    6.63031,
    4.75493,
    4.75618,
    4.21191,
    3.31429,
    3.65360,
    5.04423,
    3.49260,
    4.23601,
    3.85465,
    5.06767,
    4.63965,
    4.21246,
    4.73933,
    4.73834,
    6.14742,
    3.43643,
    3.48289,
    3.68309,
    4.92259,
    4.32685,
    3.85175,
    2.83167,
    5.51835,
    8.15568,
    3.84624,
    3.33940,
    5.63053,
    3.61213,
    3.70161,
    4.58106,
    5.15621,
    3.74057,
    6.15338,
    3.87304,
    5.10668,
    4.95312,
    4.83065,
    4.01873,
    5.16112,
    4.66647,
    7.88095,
    6.38201,
    5.38732,
    3.39814,
    6.30192,
    4.76186,
    3.61981,
    4.94144,
    4.72737,
    5.28267,
    3.28601,
    5.93515,
    3.68763,
    4.05907,
    3.23087,
    4.61355,
    4.92155,
    3.77243,
    3.49301,
    4.86907,
    4.94450,
    2.91334,
    6.18018,
    6.60156,
    3.66891,
    3.92816,
    3.92240,
    5.49820,
    3.42470,
    4.18054,
    4.08955,
    4.03865,
    4.30083,
    3.82024,
    5.89610,
    4.95649,
    5.97672,
    4.20612,
    3.26331,
    5.17713,
    6.97679,
    4.14356,
    4.88995,
    2.69604,
    4.98733,
    5.52183,
    4.15399,
    4.50090,
    4.03320,
    3.03566,
    4.00656,
    4.85891,
    5.00739,
    4.86185,
    3.80132,
    5.16544,
    5.20975,
    5.01762,
    4.57304,
    4.97841,
    3.28099,
    6.27119,
    4.61199,
    3.72903,
    3.98528,
    6.00203,
    3.37318,
    4.15546,
    4.72674,
    3.95455,
    4.18855,
    3.58908,
    5.68909,
    4.66207,
    3.73852,
    4.62779,
    3.31922,
    4.86141,
    3.41460,
    3.91125,
    3.91080,
    5.75729,
    6.70178,
    5.93640,
    5.12973,
    4.89869,
    5.27497,
    4.96975,
    6.49511,
    5.65510,
    5.32163,
    4.48108,
    3.54031,
    3.72714,
    3.74645,
    6.08691,
    3.74309,
    5.81384,
    4.03812,
    4.52230,
    5.34815,
    6.21825,
    4.55128,
    4.84368,
    5.84130,
    6.47148,
    3.77471,
    4.79999,
    5.06510,
    3.17611,
    4.92168,
    4.61298,
    5.38723,
    3.76622,
    3.24389,
    10.32568,
    3.50973,
    7.93163,
    4.20372,
    6.34507,
    5.29725,
    5.16006,
    3.74753,
    4.06198,
    5.02806,
    4.41590,
    5.29017,
    3.58892,
    5.23149,
    4.25049,
    3.85636,
    4.04559,
    4.92058,
    4.52119,
    4.80467,
    3.70247,
    3.45927,
    4.88889,
    4.56736,
    6.70431,
    5.05623,
    5.30263,
    4.57790,
    6.72026,
    3.53523,
    5.50170,
    5.00872,
    4.44407,
    5.74461,
    5.25139,
    6.47899,
    4.80592,
    6.01347,
    3.29586,
    3.76076,
    3.46942,
    3.59992,
    3.43482,
    4.83670,
    4.71730,
    5.32663,
    6.47001,
    4.24619,
    9.32078,
    3.86143,
    4.04915,
    5.10585,
    3.95116,
    4.26042,
    3.45402,
    4.52053,
    3.55630,
    4.10134,
    3.07568,
    3.69646,
    4.59839,
    4.83499,
    4.69050,
    4.52269,
    4.08450,
    3.90937,
    3.87965,
    5.96862,
    4.30697,
    5.59308,
    4.35660,
    4.89419,
    4.71061,
    4.19926,
    5.95960,
    7.23402,
    3.70900,
    5.34565,
    5.67647,
    3.52844,
    4.37520,
    4.71243,
    5.51606,
    4.45838,
    3.39833,
    3.31777,
    4.78425,
    3.10064,
    4.05794,
    5.19290,
    6.83510,
    4.84063,
    3.91223,
    4.31668,
    4.68617,
    5.15375,
    3.94694,
    4.93030,
    3.93447,
    4.40727,
    4.93105,
    7.21537,
    4.72067,
    5.13153,
    4.20897,
    5.57527,
    3.68785,
    5.00288,
    3.27171,
    3.12998,
    3.95352,
    3.87958,
    6.13582,
    3.10515,
    4.19872,
    6.42965,
    3.44002,
    3.44062,
    3.50726,
    3.17477,
    3.97756,
    3.85812,
    7.75523,
    4.12068,
    4.02585,
    5.55167,
    5.56944,
    3.94737,
    8.43232,
    4.72335,
    4.77111,
    3.23563,
    5.67385,
    3.77003,
    5.22838,
    5.53251,
    5.59840,
    2.98572,
    5.20950,
    4.43741,
    5.28216,
    2.95720,
    4.02529,
    4.75593,
    4.85562,
    4.23976,
    4.24905,
    6.20004,
    4.24831,
    3.48839,
    4.40411,
    4.69816,
    4.08232,
    5.33745,
    4.77892,
    3.96693,
    4.27242,
    4.18288,
    4.79793,
    5.53439,
    4.60880,
    4.20573,
    4.04998,
    4.16180,
    3.53787,
    8.94958,
    4.89899,
    4.84492,
    4.73709,
    3.58692,
    5.02867,
    4.31781,
    3.15069,
    3.61987,
    5.01967,
    5.06288,
    6.71449,
    4.48401,
    6.33515,
    3.19052,
    5.26903,
    3.03344,
    5.35733,
    3.86239,
    4.12443,
    3.80036,
    6.68795,
    3.79819,
    6.67416,
    3.69968,
    5.70514,
    5.28521,
    3.51173,
    4.58793,
    5.74504,
    5.52527,
    4.59006,
    3.50066,
    4.06531,
    4.26093,
    4.01307,
    4.19198,
    4.07058,
    5.15167,
    6.44409,
    3.38613,
    4.42470,
    5.39613,
    4.58126,
    3.94709,
    4.11679,
    4.26854,
    5.04181,
    4.62398,
    6.89449,
    6.83813,
    5.26192,
    4.84578,
    5.61948,
    5.79403,
    4.42127,
    5.19524,
    7.11386,
    3.41801,
    4.08240,
    4.13900,
    4.39699,
    4.23465,
    4.42359,
    3.74239,
    5.24138,
    6.81735,
    3.23153,
    3.90252,
    3.81492,
    2.93627,
    3.79880,
    3.58347,
    5.22911,
    3.96792,
    6.25645,
    3.17609,
    3.56105,
    3.71165,
    4.78643,
    6.36316,
    4.95566,
    4.13108,
    4.15415,
    3.38355,
    4.10358,
    4.73407,
    4.29849,
    7.48669,
    3.13922,
    3.94823,
    3.65556,
    6.10331,
    4.82781,
    4.72475,
    4.01741,
    3.87172,
    3.10418,
    3.34390,
    4.80356,
    4.30892,
    5.31089,
    5.96671,
    4.45729,
    4.31018,
    4.82999,
    3.93548,
    5.25564,
    3.95711,
    4.06305,
    2.98273,
    4.12309,
    4.48669,
    5.07686,
    4.56150,
    4.54438,
    4.76471,
    4.22253,
    4.74960,
    6.02256,
    3.09241,
    3.19902,
    5.72753,
    5.24816,
    4.81635,
    5.18352,
    4.71147,
    5.72337,
    6.74409,
    4.15460,
    4.03713,
    4.88306,
    5.42480,
    3.98117,
    5.88436,
    3.82482,
    4.21075,
    4.06622,
    4.30753,
    6.10215,
    4.70912,
    4.32229,
    3.46450,
    4.64171,
    3.42018,
    3.92956,
    4.81200,
    3.85353,
    6.07273,
    4.31713,
    3.68141,
    4.64009,
    4.68470,
    4.62081,
    4.54826,
    3.87959,
    4.77997,
    4.78544,
    3.50140,
    3.56671,
    4.01956,
    5.78876,
    5.34491,
    4.35024,
    3.50615,
    3.83929,
    3.68039,
    7.21836,
    5.81875,
    4.70077,
    3.31944,
    5.58002,
    4.71249,
    4.65143,
    4.26690,
    4.46735,
    4.29206,
    4.37348,
    3.74196,
    3.30862,
    2.94029,
    6.35286,
    4.07429,
    3.09963,
    5.35723,
    4.54299,
    3.89689,
    4.28343,
    4.60030,
    4.96201,
    6.25396,
    5.92292,
    4.10145,
    6.26784,
    4.42057,
    5.88664,
    4.54426,
    4.46487,
    4.39231,
    3.79251,
    5.23943,
    3.79655,
    6.64934,
    4.77006,
    6.30269,
    4.06347,
    3.48356,
    3.21342,
    2.84056,
    3.67277,
    3.28543,
    4.18476,
    3.91969,
    5.32367,
    4.07543,
    4.04317,
    4.63533,
    5.57720,
    6.29263,
    6.06544,
    4.25979,
    4.38288,
    5.38686,
    5.57571,
    6.63579,
    3.47577,
    3.76383,
    4.25973,
    4.76955,
    4.58592,
    3.09738,
    3.85552,
    4.36661,
    5.21219,
    3.23377,
    6.04436,
    6.31879,
    4.48840,
    5.98872,
    4.62341,
    3.96167,
    5.03143,
    4.29972,
    5.18081,
    5.11898,
    6.48086,
    5.04679,
    3.91379,
    4.94224,
    4.73099,
    4.99018,
    4.94693,
    5.03568,
    5.67366,
    5.06966,
    4.39367,
    4.85094,
    3.44808,
    4.20990,
    3.06114,
    3.63718,
    5.10201,
    7.32441,
    3.59197,
    3.17114,
    2.86664,
    3.91523,
    3.42519,
    7.23259,
    4.69226,
    5.02424,
    4.62762,
    4.68591,
    4.08923,
    4.01234,
    5.87332,
    4.34709,
    3.87779,
    3.78824,
    3.82390,
    4.26136,
    4.47741,
    2.85119,
    4.54058,
    4.98526,
    3.73872,
    3.57062,
    4.97257,
    5.31945,
    4.41842,
    4.92026,
    4.92439,
    5.39380,
    5.21297,
    4.01748,
    4.47258,
    3.49822,
    4.90722,
    3.48055,
    3.80224,
    9.11143,
    3.96327,
    4.28169,
    5.89620,
    3.65259,
    4.46886,
    5.14908,
    3.51418,
    4.36879,
    4.09943,
    5.22830,
    4.35478,
    3.82919,
    3.57306,
    3.73816,
    5.78073,
    4.76746,
    4.74140,
    5.08245,
    5.32377,
    4.61813,
    6.52422,
    3.23227,
    5.22629,
    5.72274,
    6.62321,
    3.72578,
    5.10611,
    4.21387,
    4.46432,
    4.12998,
    4.05103,
    3.17406,
    3.90356,
    4.08736,
    3.77417,
    3.90876,
    4.82289,
    3.74652,
    4.20729,
    4.12056,
    3.93279,
    7.46100,
    3.98568,
    4.83626,
    4.16636,
    4.58543,
    4.41547,
    3.73386,
    5.02207,
    4.26122,
    4.41983,
    4.32241,
    4.73583,
    4.53268,
    7.58587,
    3.96150,
    4.31602,
    6.83911,
    5.00746,
    4.56800,
    6.06184,
    3.75250,
    4.90895,
    4.89311,
    5.40998,
    3.36930,
    4.04023,
    4.40171,
    5.59633,
    4.87095,
    4.50281,
    3.06974,
    5.31530,
    6.39078,
    3.06453,
    3.41109,
    5.98968,
    3.67276,
    4.25092,
    3.35745,
    4.92686,
    3.80046,
    4.83665,
    4.45365,
    5.22867,
    4.33488,
    7.32551,
    3.37280,
    3.95127,
    5.17721,
    3.90259,
    3.98545,
    4.56002,
    4.25235,
    5.07268,
    4.90594,
    7.05380,
    4.81287,
    2.86951,
    4.30034,
    5.16050,
    4.97008,
    3.58318,
    3.45446,
    3.50922,
    3.92265,
    4.74454,
    5.86219,
    3.69575,
    4.07245,
    4.51041,
    5.69440,
    4.07081,
    3.57433,
    3.44129,
    4.69043,
    4.96539,
    4.23409,
    5.34122,
    4.35001,
    4.89757,
    4.17032,
    4.14137,
    3.84918,
    5.50322,
    6.23405,
    4.98669,
    7.94376,
    5.25197,
    4.50742,
    2.63435,
    3.64530,
    3.81350,
    4.37555,
    5.67126,
    3.86859,
    3.36090,
    4.64827,
    4.67430,
    7.01178,
    4.35737,
    4.40864,
    4.30923,
    5.10353,
    3.36051,
    4.53810,
    5.67843,
    5.35517,
    4.61307,
    3.95995,
    4.64599,
    4.07448,
    5.83422,
    4.50874,
    3.54458,
    3.75434,
    6.01518,
    4.91838,
    4.71120,
    6.26112,
    4.44370,
    3.07529,
    5.77540,
    4.38656,
    4.23572,
    3.24637,
    3.63440,
    4.36333,
    3.82907,
    4.18984,
    7.32663,
    3.44666,
    4.29721,
    3.59402,
    4.01535,
    4.65964,
    3.56722,
    4.49559,
    4.63209,
    4.36893,
    4.06704,
    4.99117,
    5.07791,
    4.50177,
    5.67947,
    3.76796,
    4.86294,
    4.00964,
    4.75049,
    8.23387,
    4.93270,
    4.34773,
    4.54807,
    4.19988,
    4.04576,
    4.09073,
    5.73536,
    2.84430,
    5.86318,
    6.24989,
    5.56074,
    3.09222,
    4.60839,
    3.85502,
    3.84159,
    5.15487,
    3.80286,
    5.54750,
    2.99416,
    3.97088,
    6.29921,
    3.70317,
    4.09217,
    4.06335,
    4.87035,
    4.09277,
    5.43696,
    4.57431,
    3.54524,
    3.54496,
    4.28183,
    4.82260,
    5.59372,
    3.12658,
    4.20131,
    3.65362,
    5.72024,
    4.85920,
    3.38586,
    5.75793,
    4.74268,
    5.76076
],
    dtype=np.double)
