# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gemini_api', 'gemini_api.endpoints']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.28.0,<3.0.0']

setup_kwargs = {
    'name': 'gemini-api',
    'version': '0.1.5',
    'description': 'A Python wrapper for the Gemini cryptocurrency exchange API',
    'long_description': '<div id="top"></div>\n\n\n[![Contributors][contributors-shield]][contributors-url]\n[![Forks][forks-shield]][forks-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n[![MIT License][license-shield]][license-url]\n[![LinkedIn][linkedin-shield]][linkedin-url]\n\n<br/>\n<div align="center">\n  <a href="https://github.com/eliasbenaddou/gemini_api">\n    <img src="images/gemini_logo.png" alt="Logo" width="500" height="100">\n  </a>\n\n<h3 align="center">Gemini API Wrapper</h3>\n\n  <p align="center">\n    A Python wrapper for the cyrptocurrency exchange Gemini.\n    <br />\n    <a href="https://eliasbenaddou.github.io/gemini_api"><strong>Explore the docs »</strong></a>\n    <br />\n    <a href="https://eliasbenaddouidrissi.com">View Blog Post</a>\n    ·\n    <a href="https://github.com/eliasbenaddou/gemini_api/issues">Report Bug/Request Feature</a>\n  </p>\n</div>\n\n\n\n<!-- TABLE OF CONTENTS -->\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisites">Prerequisites</a></li>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n  </ol>\n\n<br>\n\n\n<!-- ABOUT THE PROJECT -->\n## About The Project\n\nA Python wrapper for the cryptocurrency exchange Gemini that offer both public and private REST APIs. Within your Gemini account settings, visit the API section to generate API keys for Account level use (Master level keys not yet supported by this wrapper).\n\nWhen provisioning a session key, you have the option of marking the session as "Requires Heartbeat". When selected, if the exchange does not receive a message for 30 seconds,\nthen it will assume there has been an interruption in service and all outstanding orders on this session will be canceled. To maintain the session,\nthe you must send a heartbeat message (using the revive_heartbeat method in the \'order\' endpoint) at a more frequent interval.\n\nPublic REST APIs provide market data such as:\n\n- current order book\n- recent trading activity\n- trade history\n\nPrivate REST APIs allow you to manage both orders and funds:\n\n- place and cancel orders\n- see your active orders\n- see your trading history and trade volume\n- get your available balances\n\nIn addition to the API key methods described in the private APIs, Gemini supports OAuth 2.0 flows and this is currently being developed for future implementation in this package.\n\nGemini\'s Sandbox site is an instance of the Gemini Exchange that offers exchange functionality using test funds - the Sandbox site URL is chosen for the connection\nat the instantiation of the authentication class for the private API invocation.\n\nTo prevent abuse, Gemini imposes rate limits on incoming requests as described in the Gemini API Agreement.\n\nFor public API entry points, Gemini limit requests to 120 requests per minute, and recommend that you do not exceed 1 request per second.\n\nFor private API entry points, Gemini limit requests to 600 requests per minute, and recommend that you not exceed 5 requests per second.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n### Built With\n\n* Python 3.8.11\n* Pyenv\n* Poetry\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n<!-- GETTING STARTED -->\n## Getting Started\n\nThe package is available on PyPI and can be installed using pip or poetry.\n\n### Installation\n\nYou\'ll need to have Python 3.6 or above. Package dependencies are listed in the poetry.lock file.\n\n1. Sign in to Gemini and get API Keys [https://exchange.gemini.com/](https://exchange.gemini.com/)\nNote that this is for the real account - if you want to use the Sandbox Gemini account for testing, signup for a separate Sandbox account and create your keys there [https://exchange.sandbox.gemini.com/](https://exchange.sandbox.gemini.com/)\n\n2. Install package\n```python\npip install gemini_api\n```\n\n3. Stack some sats programmatically 😎\n\nIf you would like to edit the source code yourself\n\n\n1. Clone this repo\n   ```sh\n   git clone https://github.com/eliasbenaddou/gemini_api\n   ```\n2. Install required dependencies\n   ```python\n   poetry install\n   ```\n\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- USAGE EXAMPLES -->\n## Usage Examples\n\nHere is an example of creating a new order in the Sandbox test environment through the Order Placement API by instantiatng a new Authentication object with your public and private key and providing it to the Order class.\n\nThe class method \'new_order\' will return an Order object and the \'order_id\' attribute for the new order created is printed.\n\n```python\nfrom gemini_api.endpoints.order import Order\nfrom gemini_api.authentication import Authentication\n\nauth = Authentication(\n    public_key="XXXXXXXXXX", private_key="XXXXXXXXXX", sandbox=True,\n)\n\n\nif __name__ == "__main__":\n    x = Order.new_order(\n        auth=auth,\n        symbol="btcusd",\n        amount="1",\n        price="20000",\n        side="buy",\n        options=["maker-or-cancel"],\n    )\n\n    print(x.order_id)\n```\n\n_For more examples, please refer to the [Documentation](https://eliasbenaddou.github.io/gemini_api/)_\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- ROADMAP -->\n## Roadmap\n\n- [x] Public APIs\n    - [x] Symbol Details\n    - [x] Ticker\n    - [x] Ticker V2\n    - [x] Candles\n    - [x] Current Order Book\n    - [x] Auction History\n    - [x] Price Feed\n- [x] Order Placement APIs\n    - [x] New Order\n    - [x] Cancel Order\n    - [x] Wrap Order\n    - [x] Cancel All Session Orders\n    - [x] Cancel All Active Orders\n- [x] Order Status APIs\n    - [x] Order Status\n    - [x] Get Active Orders\n    - [x] Get Past Orders\n- [x] Fee and Volume APIs\n    - [x] Get Notional Volume\n    - [x] Get Trade Volume\n- [x] FX Rate API\n- [x] Fund Management APIs\n    - [x] Get Available Balances\n    - [x] Get Notional Balances\n    - [x] Custody Account Fees\n    - [x] Get Deposit Addresses\n    - [x] New Deposit Address\n    - [x] Withdraw Crypto Funds\n    - [x] Gas Fee Estimation\n    - [ ] Internal Transfers (Requires Master level key)\n    - [x] Add Bank\n    - [x] Add A Bank CAD\n    - [x] Payment Methods\n    - [x] SEN Withdrawals\n- [ ] Approved Addresses APIs\n- [ ] Account Administration APIs\n- [ ] OAuth 2.0 Authentication\n- [ ] Websocket APIs\n- [ ] Gemini Clearing\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n\n<!-- CONTRIBUTING -->\n## Contributing\n\nContributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n\nDon\'t forget to give the project a star if you found it useful! Thanks!\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n\n## License\n\nDistributed under the MIT License. See `LICENSE.txt` for more information.\n\n<p align="right">(<a href="#top">back to top</a>)</p>\n\n## Disclaimer\n\nThis package connects to a live crytpcurrency exchange and the user takes full responsibility when using it. I am not liable for any costs or errors due to incorrect code or unanticipated actions. Use the Sandbox environment first to get familiar with the code and check it performs the expected actions.\n\nIf the user is not comfortable accepting the risks that come with using this program then they should not use it. It is licensed under an MIT license so you are free to dissect and use any part of this codebase as you wish.\n\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[contributors-shield]: https://img.shields.io/github/contributors/eliasbenaddou/gemini_api.svg?style=for-the-badge\n[contributors-url]: https://github.com/eliasbenaddou/gemini_api/graphs/contributors\n[forks-shield]: https://img.shields.io/github/forks/eliasbenaddou/gemini_api.svg?style=for-the-badge\n[forks-url]: https://github.com/eliasbenaddou/gemini_api/network/members\n[stars-shield]: https://img.shields.io/github/stars/eliasbenaddou/gemini_api.svg?style=for-the-badge\n[stars-url]: https://github.com/eliasbenaddou/gemini_api/stargazers\n[issues-shield]: https://img.shields.io/github/issues/eliasbenaddou/gemini_api.svg?style=for-the-badge\n[issues-url]: https://github.com/eliasbenaddou/gemini_api/issues\n[license-shield]: https://img.shields.io/github/license/eliasbenaddou/gemini_api.svg?style=for-the-badge\n[license-url]: https://github.com/eliasbenaddou/gemini_api/blob/master/LICENSE\n[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[linkedin-url]: https://linkedin.com/in/eliasbenaddouidrissi\n',
    'author': 'Elias Benaddou Idrissi',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/eliasbenaddou/gemini_api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
