"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExposedSecret = void 0;
/**
 * (experimental) Exposed secret for log configuration.
 *
 * @experimental
 */
class ExposedSecret {
    /**
     * @experimental
     */
    constructor(optionName, secretArn) {
        this.optionName = optionName;
        this.secretArn = secretArn;
    }
    /**
     * (experimental) Use Secrets Manager Secret.
     *
     * @param optionaName - The name of the option.
     * @param secret - A secret from secrets manager.
     * @experimental
     */
    static fromSecretsManager(optionaName, secret) {
        return new ExposedSecret(optionaName, secret.secretArn);
    }
    /**
     * (experimental) User Parameters Store Parameter.
     *
     * @param optionaName - The name of the option.
     * @param parameter - A parameter from parameters store.
     * @experimental
     */
    static fromParametersStore(optionaName, parameter) {
        return new ExposedSecret(optionaName, parameter.parameterArn);
    }
}
exports.ExposedSecret = ExposedSecret;
//# sourceMappingURL=data:application/json;base64,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