# -*- coding: utf-8 -*-
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.dataplex_v1 import gapic_version as package_version

__version__ = package_version.__version__


from .services.catalog_service import CatalogServiceAsyncClient, CatalogServiceClient
from .services.content_service import ContentServiceAsyncClient, ContentServiceClient
from .services.data_scan_service import (
    DataScanServiceAsyncClient,
    DataScanServiceClient,
)
from .services.data_taxonomy_service import (
    DataTaxonomyServiceAsyncClient,
    DataTaxonomyServiceClient,
)
from .services.dataplex_service import DataplexServiceAsyncClient, DataplexServiceClient
from .services.metadata_service import MetadataServiceAsyncClient, MetadataServiceClient
from .types.analyze import Content, Environment, Session
from .types.catalog import (
    Aspect,
    AspectSource,
    AspectType,
    CreateAspectTypeRequest,
    CreateEntryGroupRequest,
    CreateEntryRequest,
    CreateEntryTypeRequest,
    DeleteAspectTypeRequest,
    DeleteEntryGroupRequest,
    DeleteEntryRequest,
    DeleteEntryTypeRequest,
    Entry,
    EntryGroup,
    EntrySource,
    EntryType,
    EntryView,
    GetAspectTypeRequest,
    GetEntryGroupRequest,
    GetEntryRequest,
    GetEntryTypeRequest,
    ListAspectTypesRequest,
    ListAspectTypesResponse,
    ListEntriesRequest,
    ListEntriesResponse,
    ListEntryGroupsRequest,
    ListEntryGroupsResponse,
    ListEntryTypesRequest,
    ListEntryTypesResponse,
    LookupEntryRequest,
    SearchEntriesRequest,
    SearchEntriesResponse,
    SearchEntriesResult,
    TransferStatus,
    UpdateAspectTypeRequest,
    UpdateEntryGroupRequest,
    UpdateEntryRequest,
    UpdateEntryTypeRequest,
)
from .types.content import (
    CreateContentRequest,
    DeleteContentRequest,
    GetContentRequest,
    ListContentRequest,
    ListContentResponse,
    UpdateContentRequest,
)
from .types.data_profile import DataProfileResult, DataProfileSpec
from .types.data_quality import (
    DataQualityColumnResult,
    DataQualityDimension,
    DataQualityDimensionResult,
    DataQualityResult,
    DataQualityRule,
    DataQualityRuleResult,
    DataQualitySpec,
)
from .types.data_taxonomy import (
    CreateDataAttributeBindingRequest,
    CreateDataAttributeRequest,
    CreateDataTaxonomyRequest,
    DataAttribute,
    DataAttributeBinding,
    DataTaxonomy,
    DeleteDataAttributeBindingRequest,
    DeleteDataAttributeRequest,
    DeleteDataTaxonomyRequest,
    GetDataAttributeBindingRequest,
    GetDataAttributeRequest,
    GetDataTaxonomyRequest,
    ListDataAttributeBindingsRequest,
    ListDataAttributeBindingsResponse,
    ListDataAttributesRequest,
    ListDataAttributesResponse,
    ListDataTaxonomiesRequest,
    ListDataTaxonomiesResponse,
    UpdateDataAttributeBindingRequest,
    UpdateDataAttributeRequest,
    UpdateDataTaxonomyRequest,
)
from .types.datascans import (
    CreateDataScanRequest,
    DataScan,
    DataScanJob,
    DataScanType,
    DeleteDataScanRequest,
    GenerateDataQualityRulesRequest,
    GenerateDataQualityRulesResponse,
    GetDataScanJobRequest,
    GetDataScanRequest,
    ListDataScanJobsRequest,
    ListDataScanJobsResponse,
    ListDataScansRequest,
    ListDataScansResponse,
    RunDataScanRequest,
    RunDataScanResponse,
    UpdateDataScanRequest,
)
from .types.logs import (
    DataQualityScanRuleResult,
    DataScanEvent,
    DiscoveryEvent,
    GovernanceEvent,
    JobEvent,
    SessionEvent,
)
from .types.metadata_ import (
    CreateEntityRequest,
    CreatePartitionRequest,
    DeleteEntityRequest,
    DeletePartitionRequest,
    Entity,
    GetEntityRequest,
    GetPartitionRequest,
    ListEntitiesRequest,
    ListEntitiesResponse,
    ListPartitionsRequest,
    ListPartitionsResponse,
    Partition,
    Schema,
    StorageAccess,
    StorageFormat,
    StorageSystem,
    UpdateEntityRequest,
)
from .types.processing import DataSource, ScannedData, Trigger
from .types.resources import Action, Asset, AssetStatus, Lake, State, Zone
from .types.security import DataAccessSpec, ResourceAccessSpec
from .types.service import (
    CancelJobRequest,
    CreateAssetRequest,
    CreateEnvironmentRequest,
    CreateLakeRequest,
    CreateTaskRequest,
    CreateZoneRequest,
    DeleteAssetRequest,
    DeleteEnvironmentRequest,
    DeleteLakeRequest,
    DeleteTaskRequest,
    DeleteZoneRequest,
    GetAssetRequest,
    GetEnvironmentRequest,
    GetJobRequest,
    GetLakeRequest,
    GetTaskRequest,
    GetZoneRequest,
    ListActionsResponse,
    ListAssetActionsRequest,
    ListAssetsRequest,
    ListAssetsResponse,
    ListEnvironmentsRequest,
    ListEnvironmentsResponse,
    ListJobsRequest,
    ListJobsResponse,
    ListLakeActionsRequest,
    ListLakesRequest,
    ListLakesResponse,
    ListSessionsRequest,
    ListSessionsResponse,
    ListTasksRequest,
    ListTasksResponse,
    ListZoneActionsRequest,
    ListZonesRequest,
    ListZonesResponse,
    OperationMetadata,
    RunTaskRequest,
    RunTaskResponse,
    UpdateAssetRequest,
    UpdateEnvironmentRequest,
    UpdateLakeRequest,
    UpdateTaskRequest,
    UpdateZoneRequest,
)
from .types.tasks import Job, Task

__all__ = (
    "CatalogServiceAsyncClient",
    "ContentServiceAsyncClient",
    "DataScanServiceAsyncClient",
    "DataTaxonomyServiceAsyncClient",
    "DataplexServiceAsyncClient",
    "MetadataServiceAsyncClient",
    "Action",
    "Aspect",
    "AspectSource",
    "AspectType",
    "Asset",
    "AssetStatus",
    "CancelJobRequest",
    "CatalogServiceClient",
    "Content",
    "ContentServiceClient",
    "CreateAspectTypeRequest",
    "CreateAssetRequest",
    "CreateContentRequest",
    "CreateDataAttributeBindingRequest",
    "CreateDataAttributeRequest",
    "CreateDataScanRequest",
    "CreateDataTaxonomyRequest",
    "CreateEntityRequest",
    "CreateEntryGroupRequest",
    "CreateEntryRequest",
    "CreateEntryTypeRequest",
    "CreateEnvironmentRequest",
    "CreateLakeRequest",
    "CreatePartitionRequest",
    "CreateTaskRequest",
    "CreateZoneRequest",
    "DataAccessSpec",
    "DataAttribute",
    "DataAttributeBinding",
    "DataProfileResult",
    "DataProfileSpec",
    "DataQualityColumnResult",
    "DataQualityDimension",
    "DataQualityDimensionResult",
    "DataQualityResult",
    "DataQualityRule",
    "DataQualityRuleResult",
    "DataQualityScanRuleResult",
    "DataQualitySpec",
    "DataScan",
    "DataScanEvent",
    "DataScanJob",
    "DataScanServiceClient",
    "DataScanType",
    "DataSource",
    "DataTaxonomy",
    "DataTaxonomyServiceClient",
    "DataplexServiceClient",
    "DeleteAspectTypeRequest",
    "DeleteAssetRequest",
    "DeleteContentRequest",
    "DeleteDataAttributeBindingRequest",
    "DeleteDataAttributeRequest",
    "DeleteDataScanRequest",
    "DeleteDataTaxonomyRequest",
    "DeleteEntityRequest",
    "DeleteEntryGroupRequest",
    "DeleteEntryRequest",
    "DeleteEntryTypeRequest",
    "DeleteEnvironmentRequest",
    "DeleteLakeRequest",
    "DeletePartitionRequest",
    "DeleteTaskRequest",
    "DeleteZoneRequest",
    "DiscoveryEvent",
    "Entity",
    "Entry",
    "EntryGroup",
    "EntrySource",
    "EntryType",
    "EntryView",
    "Environment",
    "GenerateDataQualityRulesRequest",
    "GenerateDataQualityRulesResponse",
    "GetAspectTypeRequest",
    "GetAssetRequest",
    "GetContentRequest",
    "GetDataAttributeBindingRequest",
    "GetDataAttributeRequest",
    "GetDataScanJobRequest",
    "GetDataScanRequest",
    "GetDataTaxonomyRequest",
    "GetEntityRequest",
    "GetEntryGroupRequest",
    "GetEntryRequest",
    "GetEntryTypeRequest",
    "GetEnvironmentRequest",
    "GetJobRequest",
    "GetLakeRequest",
    "GetPartitionRequest",
    "GetTaskRequest",
    "GetZoneRequest",
    "GovernanceEvent",
    "Job",
    "JobEvent",
    "Lake",
    "ListActionsResponse",
    "ListAspectTypesRequest",
    "ListAspectTypesResponse",
    "ListAssetActionsRequest",
    "ListAssetsRequest",
    "ListAssetsResponse",
    "ListContentRequest",
    "ListContentResponse",
    "ListDataAttributeBindingsRequest",
    "ListDataAttributeBindingsResponse",
    "ListDataAttributesRequest",
    "ListDataAttributesResponse",
    "ListDataScanJobsRequest",
    "ListDataScanJobsResponse",
    "ListDataScansRequest",
    "ListDataScansResponse",
    "ListDataTaxonomiesRequest",
    "ListDataTaxonomiesResponse",
    "ListEntitiesRequest",
    "ListEntitiesResponse",
    "ListEntriesRequest",
    "ListEntriesResponse",
    "ListEntryGroupsRequest",
    "ListEntryGroupsResponse",
    "ListEntryTypesRequest",
    "ListEntryTypesResponse",
    "ListEnvironmentsRequest",
    "ListEnvironmentsResponse",
    "ListJobsRequest",
    "ListJobsResponse",
    "ListLakeActionsRequest",
    "ListLakesRequest",
    "ListLakesResponse",
    "ListPartitionsRequest",
    "ListPartitionsResponse",
    "ListSessionsRequest",
    "ListSessionsResponse",
    "ListTasksRequest",
    "ListTasksResponse",
    "ListZoneActionsRequest",
    "ListZonesRequest",
    "ListZonesResponse",
    "LookupEntryRequest",
    "MetadataServiceClient",
    "OperationMetadata",
    "Partition",
    "ResourceAccessSpec",
    "RunDataScanRequest",
    "RunDataScanResponse",
    "RunTaskRequest",
    "RunTaskResponse",
    "ScannedData",
    "Schema",
    "SearchEntriesRequest",
    "SearchEntriesResponse",
    "SearchEntriesResult",
    "Session",
    "SessionEvent",
    "State",
    "StorageAccess",
    "StorageFormat",
    "StorageSystem",
    "Task",
    "TransferStatus",
    "Trigger",
    "UpdateAspectTypeRequest",
    "UpdateAssetRequest",
    "UpdateContentRequest",
    "UpdateDataAttributeBindingRequest",
    "UpdateDataAttributeRequest",
    "UpdateDataScanRequest",
    "UpdateDataTaxonomyRequest",
    "UpdateEntityRequest",
    "UpdateEntryGroupRequest",
    "UpdateEntryRequest",
    "UpdateEntryTypeRequest",
    "UpdateEnvironmentRequest",
    "UpdateLakeRequest",
    "UpdateTaskRequest",
    "UpdateZoneRequest",
    "Zone",
)
