(self["webpackChunkjupyterlab_zethus"] = self["webpackChunkjupyterlab_zethus"] || []).push([["lib_index_js"],{

/***/ "./lib/default_config.js":
/*!*******************************!*\
  !*** ./lib/default_config.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default_config": () => (/* binding */ default_config)
/* harmony export */ });
const default_config = (defaultROSEndpoint) => {
    return `{
        "panels": {
          "sidebar": {
            "display": true,
            "collapsed": false
          },
          "header": {
            "display": true
          },
          "info": {
            "display": true,
            "collapsed": true
          }
        },
        "ros": {
          "endpoint": "ws://localhost:8889/jupyterlab-ros/bridge"
        },
        "infoTabs": [],
        "visualizations": [],
        "globalOptions": {
          "display": true,
          "backgroundColor": {
            "display": true,
            "value": 15790320
          },
          "fixedFrame": {
            "display": true,
            "value": "world"
          },
          "grid": {
            "display": true,
            "size": 30,
            "divisions": 30,
            "color": 11184810,
            "centerlineColor": 7368816
          }
        },
        "tools": {
          "mode": "controls",
          "controls": {
            "display": false,
            "enabled": true
          },
          "measure": {
            "display": false
          },
          "custom": []
        }
      }`;
};


/***/ }),

/***/ "./lib/editor.js":
/*!***********************!*\
  !*** ./lib/editor.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ZethusWidget": () => (/* binding */ ZethusWidget),
/* harmony export */   "ZethusFactory": () => (/* binding */ ZethusFactory)
/* harmony export */ });
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _zethus_panels_umd_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../zethus/panels.umd.js */ "./zethus/panels.umd.js");
/* harmony import */ var _zethus_panels_umd_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_zethus_panels_umd_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docregistry */ "webpack/sharing/consume/default/@jupyterlab/docregistry");
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _default_config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./default_config */ "./lib/default_config.js");
// Copyright 2018 Wolf Vollprecht
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


// @ts-ignore






// const DIRTY_CLASS = 'jp-mod-dirty';
class ZethusWidget extends _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_2__.DocumentWidget {
    constructor(options, defaultROSEndpoint) {
        super(Object.assign({}, options));
        // private _editor : any;
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.PromiseDelegate();
        this.context = options['context'];
        this._onTitleChanged();
        this.context.pathChanged.connect(this._onTitleChanged, this);
        this.context.ready.then(() => {
            this._onContextReady();
        });
        this.defaultROSEndpoint = defaultROSEndpoint;
        // this.context.ready.then(() => { this._handleDirtyStateNew(); });
    }
    loadEditor(state) {
        console.log(state);
        react_dom__WEBPACK_IMPORTED_MODULE_0___default().render(react__WEBPACK_IMPORTED_MODULE_1___default().createElement((_zethus_panels_umd_js__WEBPACK_IMPORTED_MODULE_6___default()), { configuration: state }), this.node);
        // React.createElement(Zethus, {configuration: state}), this.node);
        const cvx = this.node.querySelector('canvas');
        if (cvx) {
            cvx.width = this.node.clientWidth; //  = msg.width;
            cvx.height = this.node.clientHeight; // = msg.height;
            cvx.style.width = this.node.clientWidth + 'px';
            cvx.style.height = this.node.clientHeight + 'px';
        }
    }
    onResize(msg) {
        const cvx = this.node.querySelector('canvas');
        if (cvx) {
            cvx.width = msg.width;
            cvx.height = msg.height;
            cvx.style.width = msg.width + 'px';
            cvx.style.height = msg.height + 'px';
        }
    }
    _onContextReady() {
        const contextModel = this.context.model;
        if (this.context.model.toString() === '') {
            this.context.model.fromString((0,_default_config__WEBPACK_IMPORTED_MODULE_7__.default_config)(this.defaultROSEndpoint));
        }
        // // Set the editor model value.
        this._onContentChanged();
        contextModel.contentChanged.connect(this._onContentChanged, this);
        // contextModel.stateChanged.connect(this._onModelStateChangedNew, this);
        // this._editor.sidebarContainer.style.width = '208px';
        // var footer = document.getElementsByClassName('geFooterContainer');
        // this._editor.refresh();
        this._ready.resolve(void 0);
    }
    /**
     * Handle a change to the title.
     */
    _onTitleChanged() {
        this.title.label = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.PathExt.basename(this.context.localPath);
    }
    _onContentChanged() {
        try {
            const editor_value = this.context.model.toString();
            const state = JSON.parse(editor_value);
            console.log('Loading editro from content chagned!');
            this.loadEditor(state);
        }
        catch (e) {
            // maybe empty string/
        }
    }
    // private _saveToContext() : void {
    //     // if (this._editor.editor.graph.isEditing())
    //     // {
    //     //     this._editor.editor.graph.stopEditing();
    //     // }
    //     // let xml = mx.mxUtils.getXml(this._editor.editor.getGraphXml());
    //     // this.context.model.fromString(xml);
    // }
    // private _onModelStateChangedNew(sender: DocumentRegistry.IModel, args: IChangedArgs<any>): void {
    //     // if (args.name === 'dirty') {
    //     //     this._handleDirtyStateNew();
    //     // }
    // }
    // private _handleDirtyStateNew() : void {
    //     // if (this.context.model.dirty) {
    //     //     this.title.className += ` ${DIRTY_CLASS}`;
    //     // } else {
    //     //     this.title.className = this.title.className.replace(DIRTY_CLASS, '');
    //     // }
    // }
    onBeforeDetach(msg) {
        react_dom__WEBPACK_IMPORTED_MODULE_0___default().unmountComponentAtNode(this.node);
    }
    /**
     * A promise that resolves when the zethus viewer is ready.
     */
    get ready() {
        return this._ready.promise;
    }
}
/**
 * A widget factory for drawio.
 */
class ZethusFactory extends _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_2__.ABCWidgetFactory {
    /**
     * Create a new widget given a context.
     */
    constructor(options, defaultROSEndpoint) {
        super(options);
        this.defaultROSEndpoint = defaultROSEndpoint;
    }
    createNewWidget(context) {
        return new ZethusWidget({ context, content: new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget() }, this.defaultROSEndpoint);
    }
}


/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "zethusIcon": () => (/* binding */ zethusIcon),
/* harmony export */   "IZethusTracker": () => (/* binding */ IZethusTracker),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/application */ "webpack/sharing/consume/default/@jupyterlab/application");
/* harmony import */ var _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/apputils */ "webpack/sharing/consume/default/@jupyterlab/apputils");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/filebrowser */ "webpack/sharing/consume/default/@jupyterlab/filebrowser");
/* harmony import */ var _jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/launcher */ "webpack/sharing/consume/default/@jupyterlab/launcher");
/* harmony import */ var _jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/settingregistry */ "webpack/sharing/consume/default/@jupyterlab/settingregistry");
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _editor__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./editor */ "./lib/editor.js");
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/codemirror */ "webpack/sharing/consume/default/@jupyterlab/codemirror");
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _style_index_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../style/index.css */ "./style/index.css");
/* harmony import */ var _style_icon_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../style/icon.svg */ "./style/icon.svg");
// Copyright 2018 Wolf Vollprecht
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.











/**
 * The name of the factory that creates editor widgets.
 */
const FACTORY = 'Zethus';
const zethusIcon = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__.LabIcon({
    name: 'jupyterlab-zethus:icon',
    svgstr: _style_icon_svg__WEBPACK_IMPORTED_MODULE_9__.default
});
const IZethusTracker = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_5__.Token('zethus/tracki');
/**
 * The editor tracker extension.
 */
const plugin = {
    activate,
    id: 'jupyterlab-zethus:plugin',
    requires: [_jupyterlab_filebrowser__WEBPACK_IMPORTED_MODULE_2__.IFileBrowserFactory, _jupyterlab_application__WEBPACK_IMPORTED_MODULE_0__.ILayoutRestorer, _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_4__.ISettingRegistry],
    optional: [_jupyterlab_launcher__WEBPACK_IMPORTED_MODULE_3__.ILauncher],
    provides: IZethusTracker,
    autoStart: true
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);
// function activate(
//   app: JupyterFrontEnd,
//   browserFactory: IFileBrowserFactory,
//   restorer: ILayoutRestorer,
//   menu: IMainMenu,
//   palette: ICommandPalette,
//   launcher: ILauncher | null
// ): IDrawioTracker {
function activate(app, browserFactory, restorer, settingRegistry, launcher) {
    const namespace = 'zethus';
    const { commands } = app;
    const tracker = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_1__.WidgetTracker({ namespace });
    let defaultROSEndpoint = '';
    let factory = new _editor__WEBPACK_IMPORTED_MODULE_10__.ZethusFactory({ name: FACTORY, fileTypes: ['zethus'], defaultFor: ['zethus'] }, defaultROSEndpoint);
    const updateSettings = (settings) => {
        defaultROSEndpoint = settings.get('defaultROSEndpoint').composite;
        factory = new _editor__WEBPACK_IMPORTED_MODULE_10__.ZethusFactory({ name: FACTORY, fileTypes: ['zethus'], defaultFor: ['zethus'] }, defaultROSEndpoint);
    };
    Promise.all([
        settingRegistry.load('jupyterlab-zethus:settings'),
        app.restored
    ])
        .then(([settings]) => {
        updateSettings(settings);
        settings.changed.connect(updateSettings);
    })
        .catch((reason) => {
        console.error(reason.message);
    });
    /**
     * Whether there is an active Zethus viewer.
     */
    function isEnabled() {
        return (tracker.currentWidget !== null &&
            tracker.currentWidget === app.shell.currentWidget);
    }
    const zethusCSSSelector = '.jp-DirListing-item[title$=".zethus"]';
    app.contextMenu.addItem({
        command: 'zethus:launch-simulation',
        selector: zethusCSSSelector,
        rank: 1
    });
    // Handle state restoration.
    restorer.restore(tracker, {
        command: 'docmanager:open',
        args: widget => ({ path: widget.context.path, factory: FACTORY }),
        name: widget => widget.context.path
    });
    factory.widgetCreated.connect((sender, widget) => {
        widget.title.icon = 'jp-MaterialIcon ZethusIcon'; // TODO change
        // Notify the instance tracker if restore data needs to update.
        widget.context.pathChanged.connect(() => {
            tracker.save(widget);
        });
        tracker.add(widget);
    });
    app.docRegistry.addWidgetFactory(factory);
    // Function to create a new untitled diagram file, given
    // the current working directory.
    const createNewZethus = (cwd) => {
        return commands
            .execute('docmanager:new-untitled', {
            path: cwd,
            type: 'file',
            ext: '.zethus'
        })
            .then(model => {
            return commands.execute('docmanager:open', {
                path: model.path,
                factory: FACTORY
            });
        });
    };
    app.docRegistry.addFileType({
        name: 'zethus',
        displayName: 'Zethus File',
        mimeTypes: ['application/json'],
        extensions: ['.zethus'],
        icon: zethusIcon,
        fileFormat: 'text'
    });
    app.docRegistry.addFileType({
        name: 'roslaunch',
        displayName: 'ROS Launch File',
        mimeTypes: ['application/xml'],
        extensions: ['.launch'],
        icon: zethusIcon,
        fileFormat: 'text'
    });
    commands.addCommand('zethus:launch', {
        label: 'Zethus',
        icon: zethusIcon,
        caption: 'Launch the Zethus viewer',
        execute: () => {
            const cwd = browserFactory.defaultBrowser.model.path;
            return createNewZethus(cwd);
        },
        isEnabled
    });
    // Add a launcher item if the launcher is available.
    if (launcher) {
        launcher.add({
            command: 'zethus:launch',
            rank: 1,
            category: 'Robotics'
        });
    }
    _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_6__.Mode.getModeInfo().push({
        name: 'ROS Launch',
        mime: 'application/xml',
        mode: 'xml',
        ext: ['launch']
    });
    _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_6__.Mode.getModeInfo().push({
        name: 'Zethus',
        mime: 'application/json',
        mode: 'json',
        ext: ['zethus']
    });
    return tracker;
}


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/base.css":
/*!**************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/base.css ***!
  \**************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/cssWithMappingToString.js */ "./node_modules/css-loader/dist/runtime/cssWithMappingToString.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, ":root {\n    --jp-image-jupyter: url('data:image/png;base64,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') !important;\n}\n", "",{"version":3,"sources":["webpack://./style/base.css"],"names":[],"mappings":"AAAA;IACI,wzIAAwzI;AAC5zI","sourcesContent":[":root {\n    --jp-image-jupyter: url('data:image/png;base64,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') !important;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./style/index.css":
/*!***************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./style/index.css ***!
  \***************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/cssWithMappingToString.js */ "./node_modules/css-loader/dist/runtime/cssWithMappingToString.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_base_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! -!../node_modules/css-loader/dist/cjs.js!./base.css */ "./node_modules/css-loader/dist/cjs.js!./style/base.css");
// Imports



var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_node_modules_css_loader_dist_cjs_js_base_css__WEBPACK_IMPORTED_MODULE_2__.default);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n", "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./style/icon.svg":
/*!************************!*\
  !*** ./style/icon.svg ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!-- Created with Inkscape (http://www.inkscape.org/) -->\n\n<svg\n   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n   xmlns:cc=\"http://creativecommons.org/ns#\"\n   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\"\n   xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"\n   width=\"120mm\"\n   height=\"120mm\"\n   viewBox=\"0 0 120 120\"\n   version=\"1.1\"\n   id=\"svg3827\"\n   inkscape:export-filename=\"/home/wolfv/zethus_logo.png\"\n   inkscape:export-xdpi=\"211.67\"\n   inkscape:export-ydpi=\"211.67\"\n   inkscape:version=\"0.92.3 (2405546, 2018-03-11)\"\n   sodipodi:docname=\"log.svg\">\n  <defs\n     id=\"defs3821\" />\n  <sodipodi:namedview\n     id=\"base\"\n     pagecolor=\"#ffffff\"\n     bordercolor=\"#666666\"\n     borderopacity=\"1.0\"\n     inkscape:pageopacity=\"0.0\"\n     inkscape:pageshadow=\"2\"\n     inkscape:zoom=\"1.4\"\n     inkscape:cx=\"148.75288\"\n     inkscape:cy=\"265.41759\"\n     inkscape:document-units=\"mm\"\n     inkscape:current-layer=\"layer1\"\n     showgrid=\"false\"\n     inkscape:window-width=\"2493\"\n     inkscape:window-height=\"1385\"\n     inkscape:window-x=\"67\"\n     inkscape:window-y=\"27\"\n     inkscape:window-maximized=\"1\" />\n  <metadata\n     id=\"metadata3824\">\n    <rdf:RDF>\n      <cc:Work\n         rdf:about=\"\">\n        <dc:format>image/svg+xml</dc:format>\n        <dc:type\n           rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\" />\n        <dc:title></dc:title>\n      </cc:Work>\n    </rdf:RDF>\n  </metadata>\n  <g\n     inkscape:label=\"Layer 1\"\n     inkscape:groupmode=\"layer\"\n     id=\"layer1\"\n     transform=\"translate(0,-177)\">\n    <g\n       id=\"g3845\"\n       transform=\"matrix(0.75791659,0,0,0.75791659,-15.056298,153.99009)\">\n      <polygon\n         id=\"polygon3782\"\n         points=\"159.8,241.17 231.44,365.27 303.09,241.17 \"\n         transform=\"matrix(0.26458333,0,0,0.26458333,14.363094,53.453311)\" />\n      <polygon\n         id=\"polygon3784\"\n         points=\"364.28,135.18 320,58.49 54.32,58.49 98.6,135.18 \"\n         transform=\"matrix(0.26458333,0,0,0.26458333,14.363094,53.453311)\" />\n      <polygon\n         id=\"polygon3786\"\n         points=\"480.2,182.67 408.56,58.58 336.91,182.67 \"\n         transform=\"matrix(0.26458333,0,0,0.26458333,14.363094,53.453311)\" />\n      <polygon\n         id=\"polygon3788\"\n         points=\"275.72,288.66 320,365.35 585.68,365.35 541.4,288.66 \"\n         transform=\"matrix(0.26458333,0,0,0.26458333,14.363094,53.453311)\" />\n    </g>\n  </g>\n</svg>\n");

/***/ }),

/***/ "./style/index.css":
/*!*************************!*\
  !*** ./style/index.css ***!
  \*************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./index.css */ "./node_modules/css-loader/dist/cjs.js!./style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__.default, options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__.default.locals || {});

/***/ }),

/***/ "./zethus/panels.umd.js":
/*!******************************!*\
  !*** ./zethus/panels.umd.js ***!
  \******************************/
/***/ ((module) => {

!function(e,t){if(true)module.exports=t();else { var r, n; }}(window,(function(){return function(e){function t(t){for(var n,i,o=t[0],a=t[1],s=0,c=[];s<o.length;s++)i=o[s],Object.prototype.hasOwnProperty.call(r,i)&&r[i]&&c.push(r[i][0]),r[i]=0;for(n in a)Object.prototype.hasOwnProperty.call(a,n)&&(e[n]=a[n]);for(u&&u(t);c.length;)c.shift()()}var n={},r={0:0};var i={};var o={"vd+8":function(){return{"./index.js":{__wbindgen_memory:function(){return n["So+1"].exports.__wbindgen_memory()},__wbg_new_59cb74e423758ede:function(){return n["So+1"].exports.__wbg_new_59cb74e423758ede()},__wbg_stack_558ba5917b466edd:function(e,t){return n["So+1"].exports.__wbg_stack_558ba5917b466edd(e,t)},__wbg_error_4bb6c2a97407129a:function(e,t){return n["So+1"].exports.__wbg_error_4bb6c2a97407129a(e,t)},__wbindgen_object_drop_ref:function(e){return n["So+1"].exports.__wbindgen_object_drop_ref(e)},__wbindgen_throw:function(e,t){return n["So+1"].exports.__wbindgen_throw(e,t)}}}}};function a(t){if(n[t])return n[t].exports;var r=n[t]={i:t,l:!1,exports:{}};return e[t].call(r.exports,r,r.exports,a),r.l=!0,r.exports}a.e=function(e){var t=[],n=r[e];if(0!==n)if(n)t.push(n[2]);else{var s=new Promise((function(t,i){n=r[e]=[t,i]}));t.push(n[2]=s);var c,l=document.createElement("script");l.charset="utf-8",l.timeout=120,a.nc&&l.setAttribute("nonce",a.nc),l.src=function(e){return a.p+""+({}[e]||e)+".umd.js"}(e);var u=new Error;c=function(t){l.onerror=l.onload=null,clearTimeout(h);var n=r[e];if(0!==n){if(n){var i=t&&("load"===t.type?"missing":t.type),o=t&&t.target&&t.target.src;u.message="Loading chunk "+e+" failed.\n("+i+": "+o+")",u.name="ChunkLoadError",u.type=i,u.request=o,n[1](u)}r[e]=void 0}};var h=setTimeout((function(){c({type:"timeout",target:l})}),12e4);l.onerror=l.onload=c,document.head.appendChild(l)}return({2:["vd+8"]}[e]||[]).forEach((function(e){var n=i[e];if(n)t.push(n);else{var r,s=o[e](),c=fetch(a.p+""+{"vd+8":"5bbcdfca599323ba0603"}[e]+".module.wasm");if(s instanceof Promise&&"function"==typeof WebAssembly.compileStreaming)r=Promise.all([WebAssembly.compileStreaming(c),s]).then((function(e){return WebAssembly.instantiate(e[0],e[1])}));else if("function"==typeof WebAssembly.instantiateStreaming)r=WebAssembly.instantiateStreaming(c,s);else{r=c.then((function(e){return e.arrayBuffer()})).then((function(e){return WebAssembly.instantiate(e,s)}))}t.push(i[e]=r.then((function(t){return a.w[e]=(t.instance||t).exports})))}})),Promise.all(t)},a.m=e,a.c=n,a.d=function(e,t,n){a.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},a.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},a.t=function(e,t){if(1&t&&(e=a(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(a.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var r in e)a.d(n,r,function(t){return e[t]}.bind(null,r));return n},a.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return a.d(t,"a",t),t},a.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},a.p="",a.oe=function(e){throw console.error(e),e},a.w={};var s=window.webpackJsonp=window.webpackJsonp||[],c=s.push.bind(s);s.push=t,s=s.slice();for(var l=0;l<s.length;l++)t(s[l]);var u=c;return a(a.s="qCj9")}({"+3EO":function(e,t,n){"use strict";n.r(t),n.d(t,"MeshBVH",(function(){return L})),n.d(t,"Visualizer",(function(){return B})),n.d(t,"acceleratedRaycast",(function(){return V})),n.d(t,"computeBoundsTree",(function(){return $})),n.d(t,"disposeBoundsTree",(function(){return W})),n.d(t,"CENTER",(function(){return T})),n.d(t,"AVERAGE",(function(){return M})),n.d(t,"SAH",(function(){return O}));var r=n("Womt"),i=new r.Vector3,o=new r.Vector3,a=new r.Vector3,s=new r.Vector2,c=new r.Vector2,l=new r.Vector2,u=new r.Vector3,h=new r.Vector3;function d(e,t,n,d,f,p,m,g){i.fromBufferAttribute(d,p),o.fromBufferAttribute(d,m),a.fromBufferAttribute(d,g);var v=function(e,t,n,i,o,a,s,c){if(null===(t.side===r.BackSide?i.intersectTriangle(s,a,o,!0,c):i.intersectTriangle(o,a,s,t.side!==r.DoubleSide,c)))return null;h.copy(c),h.applyMatrix4(e.matrixWorld);var l=n.ray.origin.distanceTo(h);return l<n.near||l>n.far?null:{distance:l,point:h.clone(),object:e}}(e,e.material,t,n,i,o,a,u);if(v){f&&(s.fromBufferAttribute(f,p),c.fromBufferAttribute(f,m),l.fromBufferAttribute(f,g),v.uv=r.Triangle.getUV(u,i,o,a,s,c,l,new r.Vector2));var y=new r.Vector3;v.face=new r.Face3(p,m,g,r.Triangle.getNormal(i,o,a,y)),v.faceIndex=p}return v}function f(e,t,n,r,i,o){const a=3*i,s=t.index.getX(a),c=t.index.getX(a+1),l=t.index.getX(a+2),u=d(e,n,r,t.attributes.position,t.attributes.uv,s,c,l);return u?(u.faceIndex=i,o&&o.push(u),u):null}function p(e,t){return t.min.x=e[0],t.min.y=e[1],t.min.z=e[2],t.max.x=e[3],t.max.y=e[4],t.max.z=e[5],t}function m(e){let t=-1,n=-1/0;for(let r=0;r<3;r++){const i=e[r+3]-e[r];i>n&&(n=i,t=r)}return t}class g{constructor(){this.min=1/0,this.max=-1/0}setFromPointsField(e,t){let n=1/0,r=-1/0;for(let i=0,o=e.length;i<o;i++){const o=e[i][t];n=Math.min(o,n),r=Math.max(o,r)}this.min=n,this.max=r}setFromPoints(e,t){let n=1/0,r=-1/0;for(let i=0,o=t.length;i<o;i++){const o=t[i],a=e.dot(o);n=Math.min(a,n),r=Math.max(a,r)}this.min=n,this.max=r}isSeparated(e){return this.min>e.max||e.min>this.max}}g.prototype.setFromBox=function(){const e=new r.Vector3;return function(t,n){const r=n.min,i=n.max;let o=1/0,a=-1/0;for(let n=0;n<=1;n++)for(let s=0;s<=1;s++)for(let c=0;c<=1;c++){e.x=r.x*n+i.x*(1-n),e.y=r.y*s+i.y*(1-s),e.z=r.z*c+i.z*(1-c);const l=t.dot(e);o=Math.min(l,o),a=Math.max(l,a)}this.min=o,this.max=a}}();!function(){const e=new g}();const v=function(){const e=new r.Vector3,t=new r.Vector3,n=new r.Vector3;return function(r,i,o){const a=r.start,s=e,c=i.start,l=t;n.subVectors(a,c),e.subVectors(r.end,i.start),t.subVectors(i.end,i.start);const u=n.dot(l),h=l.dot(s),d=l.dot(l),f=n.dot(s),p=s.dot(s)*d-h*h;let m,g;m=0!==p?(u*h-f*d)/p:0,g=(u+m*h)/d,o.x=m,o.y=g}}(),y=function(){const e=new r.Vector2,t=new r.Vector3,n=new r.Vector3;return function(r,i,o,a){v(r,i,e);let s=e.x,c=e.y;if(s>=0&&s<=1&&c>=0&&c<=1)return r.at(s,o),void i.at(c,a);if(s>=0&&s<=1)return c<0?i.at(0,a):i.at(1,a),void r.closestPointToPoint(a,!0,o);if(c>=0&&c<=1)return s<0?r.at(0,o):r.at(1,o),void i.closestPointToPoint(o,!0,a);{let e,l;e=s<0?r.start:r.end,l=c<0?i.start:i.end;const u=t,h=n;return r.closestPointToPoint(l,!0,t),i.closestPointToPoint(e,!0,n),u.distanceToSquared(l)<=h.distanceToSquared(e)?(o.copy(u),void a.copy(l)):(o.copy(e),void a.copy(h))}}}(),b=function(){const e=new r.Vector3,t=new r.Vector3,n=new r.Plane,i=new r.Line3;return function(r,o){const{radius:a,center:s}=r,{a:c,b:l,c:u}=o;i.start=c,i.end=l;if(i.closestPointToPoint(s,!0,e).distanceTo(s)<=a)return!0;i.start=c,i.end=u;if(i.closestPointToPoint(s,!0,e).distanceTo(s)<=a)return!0;i.start=l,i.end=u;if(i.closestPointToPoint(s,!0,e).distanceTo(s)<=a)return!0;const h=o.getPlane(n);if(Math.abs(h.distanceToPoint(s))<=a){const e=h.projectPoint(s,t);if(o.containsPoint(e))return!0}return!1}}();class w extends r.Triangle{constructor(...e){super(...e),this.isSeparatingAxisTriangle=!0,this.satAxes=new Array(4).fill().map(()=>new r.Vector3),this.satBounds=new Array(4).fill().map(()=>new g),this.points=[this.a,this.b,this.c],this.sphere=new r.Sphere}}w.prototype.update=function(){const e=new Array(3);return function(){const t=this.a,n=this.b,r=this.c;e[0]=this.a,e[1]=this.b,e[2]=this.c;const i=this.satAxes,o=this.satBounds,a=i[0],s=o[0];this.getNormal(a),s.setFromPoints(a,e);const c=i[1],l=o[1];c.subVectors(t,n),l.setFromPoints(c,e);const u=i[2],h=o[2];u.subVectors(n,r),h.setFromPoints(u,e);const d=i[3],f=o[3];d.subVectors(r,t),f.setFromPoints(d,e),this.sphere.setFromPoints(this.points)}}(),w.prototype.intersectsTriangle=function(){const e=new w,t=new Array(3),n=new Array(3),i=new g,o=new g,a=new r.Vector3;return function(r){r.isSeparatingAxisTriangle||(e.copy(r),e.update(),r=e);const s=this.satBounds,c=this.satAxes;n[0]=r.a,n[1]=r.b,n[2]=r.c;for(let e=0;e<4;e++){const t=s[e],r=c[e];if(i.setFromPoints(r,n),t.isSeparated(i))return!1}const l=r.satBounds,u=r.satAxes;t[0]=this.a,t[1]=this.b,t[2]=this.c;for(let e=0;e<4;e++){const n=l[e],r=u[e];if(i.setFromPoints(r,t),n.isSeparated(i))return!1}for(let e=0;e<4;e++){const r=c[e];for(let e=0;e<4;e++){const s=u[e];if(a.crossVectors(r,s),i.setFromPoints(a,t),o.setFromPoints(a,n),i.isSeparated(o))return!1}}return!0}}(),w.prototype.distanceToPoint=function(){const e=new r.Vector3;return function(t){return this.closestPointToPoint(t,e),t.distanceTo(e)}}(),w.prototype.distanceToTriangle=function(){const e=new r.Vector3,t=new r.Vector3,n=["a","b","c"],i=new r.Line3,o=new r.Line3;return function(r,a=null,s=null){if(this.intersectsTriangle(r))return(a||s)&&(this.getMidpoint(e),r.closestPointToPoint(e,t),this.closestPointToPoint(t,e),a&&a.copy(e),s&&s.copy(t)),0;let c=1/0;for(let t=0;t<3;t++){let i;const o=n[t],l=r[o];this.closestPointToPoint(l,e),i=l.distanceToSquared(e),i<c&&(c=i,a&&a.copy(e),s&&s.copy(l));const u=this[o];r.closestPointToPoint(u,e),i=u.distanceToSquared(e),i<c&&(c=i,a&&a.copy(u),s&&s.copy(e))}for(let l=0;l<3;l++){const u=n[l],h=n[(l+1)%3];i.set(this[u],this[h]);for(let l=0;l<3;l++){const u=n[l],h=n[(l+1)%3];o.set(r[u],r[h]),y(i,o,e,t);const d=e.distanceToSquared(t);d<c&&(c=d,a&&a.copy(e),s&&s.copy(t))}}return Math.sqrt(c)}}();class x extends r.Box3{constructor(...e){super(...e),this.isOrientedBox=!0,this.matrix=new r.Matrix4,this.invMatrix=new r.Matrix4,this.points=new Array(8).fill().map(()=>new r.Vector3),this.satAxes=new Array(3).fill().map(()=>new r.Vector3),this.satBounds=new Array(3).fill().map(()=>new g),this.alignedSatBounds=new Array(3).fill().map(()=>new g),this.sphere=new r.Sphere}set(e,t,n){super.set(e,t),this.matrix=n}copy(e){super.copy(e),this.matrix.copy(e.matrix)}}x.prototype.update=function(){const e=this.matrix,t=this.min,n=this.max,r=this.points;for(let i=0;i<=1;i++)for(let o=0;o<=1;o++)for(let a=0;a<=1;a++){const s=r[1*i|2*o|4*a];s.x=i?n.x:t.x,s.y=o?n.y:t.y,s.z=a?n.z:t.z,s.applyMatrix4(e)}this.sphere.setFromPoints(this.points);const i=this.satBounds,o=this.satAxes,a=r[0];for(let e=0;e<3;e++){const t=o[e],n=i[e],s=r[1<<e];t.subVectors(a,s),n.setFromPoints(t,r)}const s=this.alignedSatBounds;s[0].setFromPointsField(r,"x"),s[1].setFromPointsField(r,"y"),s[2].setFromPointsField(r,"z"),this.invMatrix.getInverse(this.matrix)},x.prototype.intersectsBox=function(){const e=new g;return function(t){if(!t.intersectsSphere(this.sphere))return!1;const n=t.min,r=t.max,i=this.satBounds,o=this.satAxes,a=this.alignedSatBounds;if(e.min=n.x,e.max=r.x,a[0].isSeparated(e))return!1;if(e.min=n.y,e.max=r.y,a[1].isSeparated(e))return!1;if(e.min=n.z,e.max=r.z,a[2].isSeparated(e))return!1;for(let n=0;n<3;n++){const r=o[n],a=i[n];if(e.setFromBox(r,t),a.isSeparated(e))return!1}return!0}}(),x.prototype.intersectsTriangle=function(){const e=new w,t=new Array(3),n=new g,i=new g,o=new r.Vector3;return function(r){r.isSeparatingAxisTriangle||(e.copy(r),e.update(),r=e);const a=this.satBounds,s=this.satAxes;t[0]=r.a,t[1]=r.b,t[2]=r.c;for(let e=0;e<3;e++){const r=a[e],i=s[e];if(n.setFromPoints(i,t),r.isSeparated(n))return!1}const c=r.satBounds,l=r.satAxes,u=this.points;for(let e=0;e<3;e++){const t=c[e],r=l[e];if(n.setFromPoints(r,u),t.isSeparated(n))return!1}for(let e=0;e<3;e++){const r=s[e];for(let e=0;e<4;e++){const a=l[e];if(o.crossVectors(r,a),n.setFromPoints(o,t),i.setFromPoints(o,u),n.isSeparated(i))return!1}}return!0}}(),x.prototype.closestPointToPoint=function(e,t){return t.copy(e).applyMatrix4(this.invMatrix).clamp(this.min,this.max).applyMatrix4(this.matrix),t},x.prototype.distanceToPoint=function(){const e=new r.Vector3;return function(t){return this.closestPointToPoint(t,e),t.distanceTo(e)}}(),x.prototype.distanceToBox=function(){const e=["x","y","z"],t=new Array(12).fill().map(()=>new r.Line3),n=new Array(12).fill().map(()=>new r.Line3),i=new r.Vector3,o=new r.Vector3;return function(r,a=0,s=null,c=null){if(this.intersectsBox(r))return(s||c)&&(r.getCenter(o),this.closestPointToPoint(o,i),r.closestPointToPoint(i,o),s&&s.copy(i),c&&c.copy(o)),0;const l=a*a,u=r.min,h=r.max,d=this.points;let f=1/0;for(let e=0;e<8;e++){const t=d[e];o.copy(t).clamp(u,h);const n=t.distanceToSquared(o);if(n<f&&(f=n,s&&s.copy(t),c&&c.copy(o),n<l))return Math.sqrt(n)}let p=0;for(let r=0;r<3;r++)for(let i=0;i<=1;i++)for(let o=0;o<=1;o++){const a=(r+1)%3,s=(r+2)%3,c=1<<r|i<<a|o<<s,l=d[i<<a|o<<s],f=d[c];t[p].set(l,f);const m=e[r],g=e[a],v=e[s],y=n[p],b=y.start,w=y.end;b[m]=u[m],b[g]=i?u[g]:h[g],b[v]=o?u[v]:h[g],w[m]=h[m],w[g]=i?u[g]:h[g],w[v]=o?u[v]:h[g],p++}for(let e=0;e<=1;e++)for(let t=0;t<=1;t++)for(let n=0;n<=1;n++){o.x=e?h.x:u.x,o.y=t?h.y:u.y,o.z=n?h.z:u.z,this.closestPointToPoint(o,i);const r=o.distanceToSquared(i);if(r<f&&(f=r,s&&s.copy(i),c&&c.copy(o),r<l))return Math.sqrt(r)}for(let e=0;e<12;e++){const r=t[e];for(let e=0;e<12;e++){const t=n[e];y(r,t,i,o);const a=i.distanceToSquared(o);if(a<f&&(f=a,s&&s.copy(i),c&&c.copy(o),a<l))return Math.sqrt(a)}}return Math.sqrt(f)}}();const _=new r.Box3,E=new r.Vector3,S=["x","y","z"];function C(e,t,n,r){const i=e.a,o=e.b,a=e.c;let s=n.getX(t);i.x=r.getX(s),i.y=r.getY(s),i.z=r.getZ(s),s=n.getX(t+1),o.x=r.getX(s),o.y=r.getY(s),o.z=r.getZ(s),s=n.getX(t+2),a.x=r.getX(s),a.y=r.getY(s),a.z=r.getZ(s)}class A{constructor(){}intersectRay(e,t){return p(this.boundingData,_),e.intersectBox(_,t)}raycast(e,t,n,r){this.count?function(e,t,n,r,i,o,a){for(let s=i,c=i+o;s<c;s++)f(e,t,n,r,s,a)}(e,e.geometry,t,n,this.offset,this.count,r):(this.left.intersectRay(n,E)&&this.left.raycast(e,t,n,r),this.right.intersectRay(n,E)&&this.right.raycast(e,t,n,r))}raycastFirst(e,t,n){if(this.count)return function(e,t,n,r,i,o){let a=1/0,s=null;for(let c=i,l=i+o;c<l;c++){const i=f(e,t,n,r,c);i&&i.distance<a&&(s=i,a=i.distance)}return s}(e,e.geometry,t,n,this.offset,this.count);{const r=this.splitAxis,i=S[r];let o,a;n.direction[i]>=0?(o=this.left,a=this.right):(o=this.right,a=this.left);const s=o.intersectRay(n,E)?o.raycastFirst(e,t,n):null;if(s){const e=n.origin[i],t=e-s.point[i],o=e-a.boundingData[r],c=e-a.boundingData[r+3],l=t*t;if(l<=o*o&&l<=c*c)return s}const c=a.intersectRay(n,E)?a.raycastFirst(e,t,n):null;return s&&c?s.distance<=c.distance?s:c:s||c||null}}}A.prototype.shapecast=function(){const e=new w,t=new r.Box3,n=new r.Box3;return function(r,i,o=null,a=null){if(this.count&&o){const t=r.geometry,n=t.index,i=t.attributes.position,a=this.offset;for(let t=3*a,r=3*(this.count+a);t<r;t+=3)if(C(e,t,n,i),e.update(),o(e,t,t+1,t+2))return!0;return!1}{const e=this.left,s=this.right;let c,l,u,h,d=e,f=s;if(a&&(u=t,h=n,p(d.boundingData,u),p(f.boundingData,h),c=a(u),l=a(h),l<c)){d=s,f=e;const t=c;c=l,l=t;const n=u;u=h,h=n}u||(u=t,p(d.boundingData,u));if(i(u,!!d.count,c,d)&&d.shapecast(r,i,o,a))return!0;h||(h=n,p(f.boundingData,h));return!!(i(h,!!f.count,l,f)&&f.shapecast(r,i,o,a))}}}(),A.prototype.intersectsGeometry=function(){const e=new w,t=new w,n=new r.Mesh,i=new r.Matrix4,o=new x,a=new x;return function(r,s,c,l=null){if(null===l&&(s.boundingBox||s.computeBoundingBox(),o.set(s.boundingBox.min,s.boundingBox.max,c),o.update(),l=o),!this.count){const e=this.left,t=this.right;p(e.boundingData,_);if(l.intersectsBox(_)&&e.intersectsGeometry(r,s,c,l))return!0;p(t.boundingData,_);return!!(l.intersectsBox(_)&&t.intersectsGeometry(r,s,c,l))}{const o=r.geometry,l=o.index,u=o.attributes.position,h=s.index,d=s.attributes.position,f=this.offset,m=this.count;if(i.getInverse(c),s.boundsTree){p(this.boundingData,a),a.matrix.copy(i),a.update(),n.geometry=s;const e=s.boundsTree.shapecast(n,e=>a.intersectsBox(e),(function(e){e.a.applyMatrix4(c),e.b.applyMatrix4(c),e.c.applyMatrix4(c),e.update();for(let n=3*f,r=3*(m+f);n<r;n+=3)if(C(t,n,l,u),t.update(),e.intersectsTriangle(t))return!0;return!1}));return n.geometry=null,e}for(let n=3*f,r=m+3*f;n<r;n+=3){C(e,n,l,u),e.a.applyMatrix4(i),e.b.applyMatrix4(i),e.c.applyMatrix4(i),e.update();for(let n=0,r=h.count;n<r;n+=3)if(C(t,n,h,d),t.update(),e.intersectsTriangle(t))return!0}}}}(),A.prototype.intersectsBox=function(){const e=new x;return function(t,n,r){return e.set(n.min,n.max,r),e.update(),this.shapecast(t,t=>e.intersectsBox(t),t=>e.intersectsTriangle(t))}}(),A.prototype.intersectsSphere=function(e,t){return this.shapecast(e,e=>t.intersectsBox(e),e=>b(t,e))},A.prototype.closestPointToPoint=function(){const e=new r.Vector3;return function(t,n,r=null,i=0,o=1/0){let a=1/0;return this.shapecast(t,(e,t,n)=>n<a&&n<o,t=>{t.closestPointToPoint(n,e);const o=n.distanceTo(e);return o<a&&(r&&r.copy(e),a=o),o<i},e=>e.distanceToPoint(n)),a}}(),A.prototype.closestPointToGeometry=function(){const e=new w,t=new x,n=new r.Vector3,i=new r.Vector3;return function(r,o,a,s=null,c=null,l=0,u=1/0){o.boundingBox||o.computeBoundingBox(),t.set(o.boundingBox.min,o.boundingBox.max,a),t.update();const h=o.attributes.position,d=o.index;let f,p;s&&(f=n),c&&(p=i);let m=1/0;return this.shapecast(r,(e,t,n)=>n<m&&n<u,t=>{const n=t.sphere;for(let r=0,i=d.count;r<i;r+=3){C(e,r,d,h),e.a.applyMatrix4(a),e.b.applyMatrix4(a),e.c.applyMatrix4(a),e.sphere.setFromPoints(e.points);const i=e.sphere;if(i.center.distanceTo(n.center)-i.radius-n.radius>m)continue;e.update();const o=t.distanceToTriangle(e,f,p);if(o<m&&(s&&s.copy(f),c&&c.copy(p),m=o),o<l)return!0}return!1},e=>t.distanceToBox(e,Math.min(m,u))),m}}();const T=0,M=1,O=2,k=["x","y","z"];const R=new r.Box3;class P{constructor(e,t){if(this.geo=e,this.options=t,this.bounds=function(e){const t=e.attributes.position.array,n=e.index.array,r=n.length/3,i=new Float32Array(6*r);for(let e=0;e<r;e++){const r=3*n[3*e+0],o=3*n[3*e+1],a=3*n[3*e+2];for(let n=0;n<3;n++){const s=t[r+n],c=t[o+n],l=t[a+n],u=Math.min(s,c,l),h=(Math.max(s,c,l)-u)/2;i[6*e+2*n+0]=u+h,i[6*e+2*n+1]=h}}return i}(e),this.sahplanes=null,t.strategy===O){const t=e.index.count/3;this.sahplanes=[new Array(t),new Array(t),new Array(t)];for(let e=0;e<t;e++)for(let t=0;t<3;t++)this.sahplanes[t][e]={p:this.bounds[6*e+2*t],tri:e}}}getAverage(e,t,n){let r=0;const i=this.bounds;for(let o=e,a=e+t;o<a;o++)r+=i[6*o+2*n];return r/t}getBounds(e,t,n){let r=1/0,i=1/0,o=1/0,a=-1/0,s=-1/0,c=-1/0;const l=this.bounds;for(let n=e,u=e+t;n<u;n++){const e=l[6*n+0],t=l[6*n+1];r=Math.min(r,e-t),a=Math.max(a,e+t);const u=l[6*n+2],h=l[6*n+3];i=Math.min(i,u-h),s=Math.max(s,u+h);const d=l[6*n+4],f=l[6*n+5];o=Math.min(o,d-f),c=Math.max(c,d+f)}return n[0]=r,n[1]=i,n[2]=o,n[3]=a,n[4]=s,n[5]=c,n}partition(e,t,n){let r=e,i=e+t-1;const o=n.pos,a=2*n.axis,s=this.geo.index.array,c=this.bounds,l=this.sahplanes;for(;;){for(;r<=i&&c[6*r+a]<o;)r++;for(;r<=i&&c[6*i+a]>=o;)i--;if(!(r<i))return r;for(let e=0;e<3;e++){let t=s[3*r+e];s[3*r+e]=s[3*i+e],s[3*i+e]=t;let n=c[6*r+2*e+0];c[6*r+2*e+0]=c[6*i+2*e+0],c[6*i+2*e+0]=n;let o=c[6*r+2*e+1];c[6*r+2*e+1]=c[6*i+2*e+1],c[6*i+2*e+1]=o}if(l)for(let e=0;e<3;e++){let t=l[e][r];l[e][r]=l[e][i],l[e][i]=t}r++,i--}}getOptimalSplit(e,t,n,r){let i=-1,o=0;if(r===T)i=m(e),-1!==i&&(o=(e[i+3]+e[i])/2);else if(r===M)i=m(e),-1!==i&&(o=this.getAverage(t,n,i));else if(r===O){const r=3,a=1,s=p(e,R),c=[s.max.x-s.min.x,s.max.y-s.min.y,s.max.z-s.min.z],l=2*(c[0]*c[1]+c[0]*c[2]+c[1]*c[2]),u=[[],[],[]];for(let e=t,r=t+n;e<r;e++)for(let t=0;t<3;t++)u[t].push(this.sahplanes[t][e]);u.forEach(e=>e.sort((e,t)=>e.p-t.p));const h=(e,t,n,i,o)=>r+a*(t/e*n+i/e*o);i=-1;let d=a*n;for(let e=0;e<3;e++){const t=(e+1)%3,r=(e+2)%3,a=s.min[k[e]],f=s.max[k[e]],p=u[e];let m=0,g=n;for(let n=0;n<p.length;n++){const s=p[n];m++,g--;const u=s.p-a,v=f-s.p;let y=c[t],b=c[t],w=c[r],x=c[r];const _=h(l,2*(y*w+y*u+w*u),m,2*(b*x+b*v+x*v),g);_<d&&(i=e,o=s.p,d=_)}}}return{axis:i,pos:o}}}class L{constructor(e,t={}){if(!e.isBufferGeometry)throw new Error("MeshBVH: Only BufferGeometries are supported.");if(e.attributes.position.isInterleavedBufferAttribute)throw new Error("MeshBVH: InterleavedBufferAttribute is not supported for the position attribute.");if(e.index&&e.index.isInterleavedBufferAttribute)throw new Error("MeshBVH: InterleavedBufferAttribute is not supported for the index attribute.");(t=Object.assign({strategy:T,maxDepth:40,maxLeafTris:10,verbose:!0},t)).strategy=Math.max(0,Math.min(2,t.strategy)),this._roots=this._buildTree(e,t)}_ensureIndex(e){if(!e.index){const t=e.attributes.position.count,n=new(t>65535?Uint32Array:Uint16Array)(t);e.setIndex(new r.BufferAttribute(n,1));for(let e=0;e<t;e++)n[e]=e}}_getRootIndexRanges(e){if(!e.groups||!e.groups.length)return[{offset:0,count:e.index.count/3}];const t=[],n=new Set;for(const t of e.groups)n.add(t.start),n.add(t.start+t.count);const r=Array.from(n.values()).sort((e,t)=>e-t);for(let e=0;e<r.length-1;e++){const n=r[e],i=r[e+1];t.push({offset:n/3,count:(i-n)/3})}return t}_buildTree(e,t){this._ensureIndex(e);const n=new P(e,t);let i=!1;const o=(e,r,a,s=0)=>{if(s>=t.maxDepth&&(i=!0),a<=t.maxLeafTris||s>=t.maxDepth)return e.offset=r,e.count=a,e;const c=n.getOptimalSplit(e.boundingData,r,a,t.strategy);if(-1===c.axis)return e.offset=r,e.count=a,e;const l=n.partition(r,a,c);if(l===r||l===r+a)e.offset=r,e.count=a;else{e.splitAxis=c.axis;const t=e.left=new A,i=r,u=l-r;t.boundingData=n.getBounds(i,u,new Float32Array(6)),o(t,i,u,s+1);const h=e.right=new A,d=l,f=a-u;h.boundingData=n.getBounds(d,f,new Float32Array(6)),o(h,d,f,s+1)}return e},a=[],s=this._getRootIndexRanges(e);if(1===s.length){const t=new A,r=s[0];null!=e.boundingBox?t.boundingData=function(e){const t=new Float32Array(6);return t[0]=e.min.x,t[1]=e.min.y,t[2]=e.min.z,t[3]=e.max.x,t[4]=e.max.y,t[5]=e.max.z,t}(e.boundingBox):t.boundingData=n.getBounds(r.offset,r.count,new Float32Array(6)),o(t,r.offset,r.count),a.push(t)}else for(let e of s){const t=new A;t.boundingData=n.getBounds(e.offset,e.count,new Float32Array(6)),o(t,e.offset,e.count),a.push(t)}if(i&&t.verbose&&(console.warn(`MeshBVH: Max depth of ${t.maxDepth} reached when generating BVH. Consider increasing maxDepth.`),console.warn(this,e)),null==e.boundingBox){const t=new r.Box3;e.boundingBox=new r.Box3;for(let n of a)e.boundingBox.union(p(n.boundingData,t))}return a}raycast(e,t,n,r){for(const i of this._roots)i.raycast(e,t,n,r)}raycastFirst(e,t,n){let r=null;for(const i of this._roots){const o=i.raycastFirst(e,t,n);null!=o&&(null==r||o.distance<r.distance)&&(r=o)}return r}intersectsGeometry(e,t,n){for(const r of this._roots)if(r.intersectsGeometry(e,t,n))return!0;return!1}shapecast(e,t,n=null,r=null){for(const i of this._roots)if(i.shapecast(e,t,n,r))return!0;return!1}intersectsBox(e,t,n){for(const r of this._roots)if(r.intersectsBox(e,t,n))return!0;return!1}intersectsSphere(e,t){for(const n of this._roots)if(n.intersectsSphere(e,t))return!0;return!1}closestPointToGeometry(e,t,n,r,i,o,a){let s=1/0;for(const c of this._roots){const l=c.closestPointToGeometry(e,t,n,r,i,o,a);if(l<s&&(s=l),l<o)return l}return s}distanceToGeometry(e,t,n,r,i){return this.closestPointToGeometry(e,t,n,null,null,r,i)}closestPointToPoint(e,t,n,r,i){let o=1/0;for(const a of this._roots){const s=a.closestPointToPoint(e,t,n,r,i);if(s<o&&(o=s),s<r)return s}return o}distanceToPoint(e,t,n,r){return this.closestPointToPoint(e,t,null,n,r)}}const F=new r.LineBasicMaterial({color:65416,transparent:!0,opacity:.3}),j=(new r.Box3Helper).geometry;let D=new r.Box3;class N extends r.Object3D{constructor(e,t=10,n=0){super("MeshBVHRootVisualizer"),this.depth=t,this._oldDepth=-1,this._mesh=e,this._boundsTree=null,this._group=n,this.update()}update(){if(this._mesh.geometry.boundsTree!==this._boundsTree||this._oldDepth!==this.depth){this._oldDepth=this.depth,this._boundsTree=this._mesh.geometry.boundsTree;let e=0;if(this._boundsTree){const t=(n,i)=>{let o="count"in n;if(i!==this.depth){if(i===this.depth-1||o){let t=e<this.children.length?this.children[e]:null;t||(t=new r.LineSegments(j,F),t.raycast=()=>[],this.add(t)),e++,p(n.boundingData,D),D.getCenter(t.position),t.scale.subVectors(D.max,D.min).multiplyScalar(.5),0===t.scale.x&&(t.scale.x=Number.EPSILON),0===t.scale.y&&(t.scale.y=Number.EPSILON),0===t.scale.z&&(t.scale.z=Number.EPSILON)}o||(t(n.left,i+1),t(n.right,i+1))}};t(this._boundsTree._roots[this._group],0)}for(;this.children.length>e;)this.remove(this.children.pop())}}}class I extends r.Object3D{constructor(e,t=10){super("MeshBVHVisualizer"),this.depth=t,this._mesh=e,this._roots=[],this.update()}update(){const e=this._mesh.geometry.boundsTree,t=e?e._roots.length:0;for(;this._roots.length>t;)this._roots.pop();for(let e=0;e<t;e++)if(e>=this._roots.length){const t=new N(this._mesh,this.depth,e);this.add(t),this._roots.push(t)}else{let t=this._roots[e];t.depth=this.depth,t.update()}this.position.copy(this._mesh.position),this.rotation.copy(this._mesh.rotation),this.scale.copy(this._mesh.scale)}}var B=I;const z=new r.Ray,U=new r.Matrix4,H=r.Mesh.prototype.raycast;function V(e,t){if(this.geometry.boundsTree){if(void 0===this.material)return;if(U.getInverse(this.matrixWorld),z.copy(e.ray).applyMatrix4(U),!0===e.firstHitOnly){const n=this.geometry.boundsTree.raycastFirst(this,e,z);n&&t.push(n)}else this.geometry.boundsTree.raycast(this,e,z,t)}else H.call(this,e,t)}function $(e){return this.boundsTree=new L(this,e),this.boundsTree}function W(){this.boundsTree=null}},"+6XX":function(e,t,n){var r=n("y1pI");e.exports=function(e){return r(this.__data__,e)>-1}},"+K+b":function(e,t,n){var r=n("JHRd");e.exports=function(e){var t=new e.constructor(e.byteLength);return new r(t).set(new r(e)),t}},"+Qka":function(e,t,n){var r=n("fmRc"),i=n("t2Dn"),o=n("cq/+"),a=n("T1AV"),s=n("GoyQ"),c=n("mTTR"),l=n("itsj");e.exports=function e(t,n,u,h,d){t!==n&&o(n,(function(o,c){if(d||(d=new r),s(o))a(t,n,c,u,e,h,d);else{var f=h?h(l(t,c),o,c+"",t,n,d):void 0;void 0===f&&(f=o),i(t,c,f)}}),c)}},"+XMi":function(e,t,n){"use strict";(function(t){var r=n("33yf"),i=n("48q5"),o=n("BEtg");e.exports=l;var a={}.hasOwnProperty,s=l.prototype;s.toString=function(e){var t=this.contents||"";return o(t)?t.toString(e):String(t)};var c=["history","path","basename","stem","extname","dirname"];function l(e){var n,r,i;if(e){if("string"==typeof e||o(e))e={contents:e};else if("message"in e&&"messages"in e)return e}else e={};if(!(this instanceof l))return new l(e);for(this.data={},this.messages=[],this.history=[],this.cwd=t.cwd(),r=-1,i=c.length;++r<i;)n=c[r],a.call(e,n)&&(this[n]=e[n]);for(n in e)-1===c.indexOf(n)&&(this[n]=e[n])}function u(e,t){if(-1!==e.indexOf(r.sep))throw new Error("`"+t+"` cannot be a path: did not expect `"+r.sep+"`")}function h(e,t){if(!e)throw new Error("`"+t+"` cannot be empty")}function d(e,t){if(!e)throw new Error("Setting `"+t+"` requires `path` to be set too")}Object.defineProperty(s,"path",{get:function(){return this.history[this.history.length-1]},set:function(e){h(e,"path"),e!==this.path&&this.history.push(e)}}),Object.defineProperty(s,"dirname",{get:function(){return"string"==typeof this.path?r.dirname(this.path):void 0},set:function(e){d(this.path,"dirname"),this.path=r.join(e||"",this.basename)}}),Object.defineProperty(s,"basename",{get:function(){return"string"==typeof this.path?r.basename(this.path):void 0},set:function(e){h(e,"basename"),u(e,"basename"),this.path=r.join(this.dirname||"",e)}}),Object.defineProperty(s,"extname",{get:function(){return"string"==typeof this.path?r.extname(this.path):void 0},set:function(e){var t=e||"";if(u(t,"extname"),d(this.path,"extname"),t){if("."!==t.charAt(0))throw new Error("`extname` must start with `.`");if(-1!==t.indexOf(".",1))throw new Error("`extname` cannot contain multiple dots")}this.path=i(this.path,t)}}),Object.defineProperty(s,"stem",{get:function(){return"string"==typeof this.path?r.basename(this.path,this.extname):void 0},set:function(e){h(e,"stem"),u(e,"stem"),this.path=r.join(this.dirname||"",e+(this.extname||""))}})}).call(this,n("8oxB"))},"+c4W":function(e,t,n){var r=n("711d"),i=n("4/ic"),o=n("9ggG"),a=n("9Nap");e.exports=function(e){return o(e)?r(a(e)):i(e)}},"+iFO":function(e,t,n){var r=n("dTAl"),i=n("LcsW"),o=n("6sVZ");e.exports=function(e){return"function"!=typeof e.constructor||o(e)?{}:r(i(e))}},"+wdc":function(e,t,n){"use strict";
/** @license React v0.19.1
 * scheduler.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */var r,i,o,a,s;if("undefined"==typeof window||"function"!=typeof MessageChannel){var c=null,l=null,u=function(){if(null!==c)try{var e=t.unstable_now();c(!0,e),c=null}catch(e){throw setTimeout(u,0),e}},h=Date.now();t.unstable_now=function(){return Date.now()-h},r=function(e){null!==c?setTimeout(r,0,e):(c=e,setTimeout(u,0))},i=function(e,t){l=setTimeout(e,t)},o=function(){clearTimeout(l)},a=function(){return!1},s=t.unstable_forceFrameRate=function(){}}else{var d=window.performance,f=window.Date,p=window.setTimeout,m=window.clearTimeout;if("undefined"!=typeof console){var g=window.cancelAnimationFrame;"function"!=typeof window.requestAnimationFrame&&console.error("This browser doesn't support requestAnimationFrame. Make sure that you load a polyfill in older browsers. https://fb.me/react-polyfills"),"function"!=typeof g&&console.error("This browser doesn't support cancelAnimationFrame. Make sure that you load a polyfill in older browsers. https://fb.me/react-polyfills")}if("object"==typeof d&&"function"==typeof d.now)t.unstable_now=function(){return d.now()};else{var v=f.now();t.unstable_now=function(){return f.now()-v}}var y=!1,b=null,w=-1,x=5,_=0;a=function(){return t.unstable_now()>=_},s=function(){},t.unstable_forceFrameRate=function(e){0>e||125<e?console.error("forceFrameRate takes a positive int between 0 and 125, forcing framerates higher than 125 fps is not unsupported"):x=0<e?Math.floor(1e3/e):5};var E=new MessageChannel,S=E.port2;E.port1.onmessage=function(){if(null!==b){var e=t.unstable_now();_=e+x;try{b(!0,e)?S.postMessage(null):(y=!1,b=null)}catch(e){throw S.postMessage(null),e}}else y=!1},r=function(e){b=e,y||(y=!0,S.postMessage(null))},i=function(e,n){w=p((function(){e(t.unstable_now())}),n)},o=function(){m(w),w=-1}}function C(e,t){var n=e.length;e.push(t);e:for(;;){var r=n-1>>>1,i=e[r];if(!(void 0!==i&&0<M(i,t)))break e;e[r]=t,e[n]=i,n=r}}function A(e){return void 0===(e=e[0])?null:e}function T(e){var t=e[0];if(void 0!==t){var n=e.pop();if(n!==t){e[0]=n;e:for(var r=0,i=e.length;r<i;){var o=2*(r+1)-1,a=e[o],s=o+1,c=e[s];if(void 0!==a&&0>M(a,n))void 0!==c&&0>M(c,a)?(e[r]=c,e[s]=n,r=s):(e[r]=a,e[o]=n,r=o);else{if(!(void 0!==c&&0>M(c,n)))break e;e[r]=c,e[s]=n,r=s}}}return t}return null}function M(e,t){var n=e.sortIndex-t.sortIndex;return 0!==n?n:e.id-t.id}var O=[],k=[],R=1,P=null,L=3,F=!1,j=!1,D=!1;function N(e){for(var t=A(k);null!==t;){if(null===t.callback)T(k);else{if(!(t.startTime<=e))break;T(k),t.sortIndex=t.expirationTime,C(O,t)}t=A(k)}}function I(e){if(D=!1,N(e),!j)if(null!==A(O))j=!0,r(B);else{var t=A(k);null!==t&&i(I,t.startTime-e)}}function B(e,n){j=!1,D&&(D=!1,o()),F=!0;var r=L;try{for(N(n),P=A(O);null!==P&&(!(P.expirationTime>n)||e&&!a());){var s=P.callback;if(null!==s){P.callback=null,L=P.priorityLevel;var c=s(P.expirationTime<=n);n=t.unstable_now(),"function"==typeof c?P.callback=c:P===A(O)&&T(O),N(n)}else T(O);P=A(O)}if(null!==P)var l=!0;else{var u=A(k);null!==u&&i(I,u.startTime-n),l=!1}return l}finally{P=null,L=r,F=!1}}function z(e){switch(e){case 1:return-1;case 2:return 250;case 5:return 1073741823;case 4:return 1e4;default:return 5e3}}var U=s;t.unstable_IdlePriority=5,t.unstable_ImmediatePriority=1,t.unstable_LowPriority=4,t.unstable_NormalPriority=3,t.unstable_Profiling=null,t.unstable_UserBlockingPriority=2,t.unstable_cancelCallback=function(e){e.callback=null},t.unstable_continueExecution=function(){j||F||(j=!0,r(B))},t.unstable_getCurrentPriorityLevel=function(){return L},t.unstable_getFirstCallbackNode=function(){return A(O)},t.unstable_next=function(e){switch(L){case 1:case 2:case 3:var t=3;break;default:t=L}var n=L;L=t;try{return e()}finally{L=n}},t.unstable_pauseExecution=function(){},t.unstable_requestPaint=U,t.unstable_runWithPriority=function(e,t){switch(e){case 1:case 2:case 3:case 4:case 5:break;default:e=3}var n=L;L=e;try{return t()}finally{L=n}},t.unstable_scheduleCallback=function(e,n,a){var s=t.unstable_now();if("object"==typeof a&&null!==a){var c=a.delay;c="number"==typeof c&&0<c?s+c:s,a="number"==typeof a.timeout?a.timeout:z(e)}else a=z(e),c=s;return e={id:R++,callback:n,priorityLevel:e,startTime:c,expirationTime:a=c+a,sortIndex:-1},c>s?(e.sortIndex=c,C(k,e),null===A(O)&&e===A(k)&&(D?o():D=!0,i(I,c-s))):(e.sortIndex=a,C(O,e),j||F||(j=!0,r(B))),e},t.unstable_shouldYield=function(){var e=t.unstable_now();N(e);var n=A(O);return n!==P&&null!==P&&null!==n&&null!==n.callback&&n.startTime<=e&&n.expirationTime<P.expirationTime||a()},t.unstable_wrapCallback=function(e){var t=L;return function(){var n=L;L=t;try{return e.apply(this,arguments)}finally{L=n}}}},"/9aa":function(e,t,n){var r=n("NykK"),i=n("ExA7");e.exports=function(e){return"symbol"==typeof e||i(e)&&"[object Symbol]"==r(e)}},"/Zut":function(e,t,n){(function(e){var n;n=function(){var e=null,t={};a("monochrome",null,[[0,0],[100,0]]),a("red",[-26,18],[[20,100],[30,92],[40,89],[50,85],[60,78],[70,70],[80,60],[90,55],[100,50]]),a("orange",[19,46],[[20,100],[30,93],[40,88],[50,86],[60,85],[70,70],[100,70]]),a("yellow",[47,62],[[25,100],[40,94],[50,89],[60,86],[70,84],[80,82],[90,80],[100,75]]),a("green",[63,178],[[30,100],[40,90],[50,85],[60,81],[70,74],[80,64],[90,50],[100,40]]),a("blue",[179,257],[[20,100],[30,86],[40,80],[50,74],[60,60],[70,52],[80,44],[90,39],[100,35]]),a("purple",[258,282],[[20,100],[30,87],[40,79],[50,70],[60,65],[70,59],[80,52],[90,45],[100,42]]),a("pink",[283,334],[[20,100],[30,90],[40,86],[60,84],[80,80],[90,75],[100,73]]);var n=[],r=function(a){if(void 0!==(a=a||{}).seed&&null!==a.seed&&a.seed===parseInt(a.seed,10))e=a.seed;else if("string"==typeof a.seed)e=function(e){for(var t=0,n=0;n!==e.length&&!(t>=Number.MAX_SAFE_INTEGER);n++)t+=e.charCodeAt(n);return t}(a.seed);else{if(void 0!==a.seed&&null!==a.seed)throw new TypeError("The seed value must be an integer or string");e=null}var u,h;if(null!==a.count&&void 0!==a.count){for(var d=a.count,f=[],p=0;p<a.count;p++)n.push(!1);for(a.count=null;d>f.length;)e&&a.seed&&(a.seed+=1),f.push(r(a));return a.count=d,f}return function(e,t){switch(t.format){case"hsvArray":return e;case"hslArray":return l(e);case"hsl":var n=l(e);return"hsl("+n[0]+", "+n[1]+"%, "+n[2]+"%)";case"hsla":var r=l(e),i=t.alpha||Math.random();return"hsla("+r[0]+", "+r[1]+"%, "+r[2]+"%, "+i+")";case"rgbArray":return s(e);case"rgb":return"rgb("+s(e).join(", ")+")";case"rgba":var o=s(e);return i=t.alpha||Math.random(),"rgba("+o.join(", ")+", "+i+")";default:return function(e){var t=s(e);function n(e){var t=e.toString(16);return 1==t.length?"0"+t:t}return"#"+n(t[0])+n(t[1])+n(t[2])}(e)}}([u=function(e){if(n.length>0){var r=o(h=function(e){if(isNaN(e)){if("string"==typeof e)if(t[e]){var n=t[e];if(n.hueRange)return n.hueRange}else if(e.match(/^#?([0-9A-F]{3}|[0-9A-F]{6})$/i))return i(c(e)[0]).hueRange}else{var r=parseInt(e);if(r<360&&r>0)return i(e).hueRange}return[0,360]}(e.hue)),a=(h[1]-h[0])/n.length,s=parseInt((r-h[0])/a);!0===n[s]?s=(s+2)%n.length:n[s]=!0;var l=(h[0]+s*a)%359,u=(h[0]+(s+1)*a)%359;return(r=o(h=[l,u]))<0&&(r=360+r),r}var h=function(e){if("number"==typeof parseInt(e)){var n=parseInt(e);if(n<360&&n>0)return[n,n]}if("string"==typeof e)if(t[e]){var r=t[e];if(r.hueRange)return r.hueRange}else if(e.match(/^#?([0-9A-F]{3}|[0-9A-F]{6})$/i)){var i=c(e)[0];return[i,i]}return[0,360]}(e.hue);return(r=o(h))<0&&(r=360+r),r}(a),h=function(e,t){if("monochrome"===t.hue)return 0;if("random"===t.luminosity)return o([0,100]);var n=function(e){return i(e).saturationRange}(e),r=n[0],a=n[1];switch(t.luminosity){case"bright":r=55;break;case"dark":r=a-10;break;case"light":a=55}return o([r,a])}(u,a),function(e,t,n){var r=function(e,t){for(var n=i(e).lowerBounds,r=0;r<n.length-1;r++){var o=n[r][0],a=n[r][1],s=n[r+1][0],c=n[r+1][1];if(t>=o&&t<=s){var l=(c-a)/(s-o);return l*t+(a-l*o)}}return 0}(e,t),a=100;switch(n.luminosity){case"dark":a=r+20;break;case"light":r=(a+r)/2;break;case"random":r=0,a=100}return o([r,a])}(u,h,a)],a)};function i(e){for(var n in e>=334&&e<=360&&(e-=360),t){var r=t[n];if(r.hueRange&&e>=r.hueRange[0]&&e<=r.hueRange[1])return t[n]}return"Color not found"}function o(t){if(null===e){var n=Math.random();return n+=.618033988749895,n%=1,Math.floor(t[0]+n*(t[1]+1-t[0]))}var r=t[1]||1,i=t[0]||0,o=(e=(9301*e+49297)%233280)/233280;return Math.floor(i+o*(r-i))}function a(e,n,r){var i=r[0][0],o=r[r.length-1][0],a=r[r.length-1][1],s=r[0][1];t[e]={hueRange:n,lowerBounds:r,saturationRange:[i,o],brightnessRange:[a,s]}}function s(e){var t=e[0];0===t&&(t=1),360===t&&(t=359),t/=360;var n=e[1]/100,r=e[2]/100,i=Math.floor(6*t),o=6*t-i,a=r*(1-n),s=r*(1-o*n),c=r*(1-(1-o)*n),l=256,u=256,h=256;switch(i){case 0:l=r,u=c,h=a;break;case 1:l=s,u=r,h=a;break;case 2:l=a,u=r,h=c;break;case 3:l=a,u=s,h=r;break;case 4:l=c,u=a,h=r;break;case 5:l=r,u=a,h=s}return[Math.floor(255*l),Math.floor(255*u),Math.floor(255*h)]}function c(e){e=3===(e=e.replace(/^#/,"")).length?e.replace(/(.)/g,"$1$1"):e;var t=parseInt(e.substr(0,2),16)/255,n=parseInt(e.substr(2,2),16)/255,r=parseInt(e.substr(4,2),16)/255,i=Math.max(t,n,r),o=i-Math.min(t,n,r),a=i?o/i:0;switch(i){case t:return[(n-r)/o%6*60||0,a,i];case n:return[60*((r-t)/o+2)||0,a,i];case r:return[60*((t-n)/o+4)||0,a,i]}}function l(e){var t=e[0],n=e[1]/100,r=e[2]/100,i=(2-n)*r;return[t,Math.round(n*r/(i<1?i:2-i)*1e4)/100,i/2*100]}return r}(),e&&e.exports&&(t=e.exports=n),t.randomColor=n}).call(this,n("YuTi")(e))},"/qNp":function(e,t,n){"use strict";var r={}.hasOwnProperty;function i(e){return e&&"object"==typeof e||(e={}),a(e.line)+":"+a(e.column)}function o(e){return e&&"object"==typeof e||(e={}),i(e.start)+"-"+i(e.end)}function a(e){return e&&"number"==typeof e?e:1}e.exports=function(e){if(!e||"object"!=typeof e)return null;if(r.call(e,"position")||r.call(e,"type"))return o(e.position);if(r.call(e,"start")||r.call(e,"end"))return o(e);if(r.call(e,"line")||r.call(e,"column"))return i(e);return null}},"03A+":function(e,t,n){var r=n("JTzB"),i=n("ExA7"),o=Object.prototype,a=o.hasOwnProperty,s=o.propertyIsEnumerable,c=r(function(){return arguments}())?r:function(e){return i(e)&&a.call(e,"callee")&&!s.call(e,"callee")};e.exports=c},"0C9X":function(e,t,n){e.exports={Pose:n("N6n/"),Quaternion:n("ACFR"),Transform:n("4wl8"),Vector3:n("OEc2")}},"0CBx":function(e,t,n){"use strict";n.r(t),n.d(t,"ResizeObserver",(function(){return B}));var r,i,o="undefined"==typeof window?{}:window,a=[],s=function(e){if(!r){var t=document.createTextNode("");new MutationObserver((function(){return a.splice(0).forEach((function(e){return e()}))})).observe(t,{characterData:!0}),r=function(){t.textContent=""}}a.push(e),r()},c={attributes:!0,characterData:!0,childList:!0,subtree:!0},l=["resize","load","transitionend","animationend","animationstart","animationiteration","keyup","keydown","mouseup","mousedown","mouseover","mouseout","blur","focus"],u=!1,h=new(function(){function e(){var e=this;this.stopped=!0,this.listener=function(){return e.schedule()}}return e.prototype.run=function(e){var t,n=this;u||(u=!0,t=function(){var t=!1;try{t=D()}finally{if(u=!1,!I())return;t?n.run(60):e?n.run(e-1):n.start()}},s((function(){requestAnimationFrame(t)})))},e.prototype.schedule=function(){this.stop(),this.run(12)},e.prototype.observe=function(){var e=this,t=function(){return e.observer&&e.observer.observe(document.body,c)};document.body?t():o.addEventListener("DOMContentLoaded",t)},e.prototype.start=function(){var e=this;this.stopped&&(this.stopped=!1,this.observer=new MutationObserver(this.listener),this.observe(),l.forEach((function(t){return o.addEventListener(t,e.listener,!0)})))},e.prototype.stop=function(){var e=this;this.stopped||(this.observer&&this.observer.disconnect(),l.forEach((function(t){return o.removeEventListener(t,e.listener,!0)})),this.stopped=!0)},e}());!function(e){e.BORDER_BOX="border-box",e.CONTENT_BOX="content-box"}(i||(i={}));var d=function(){function e(e,t,n,r){return this.x=e,this.y=t,this.width=n,this.height=r,this.top=this.y,this.left=this.x,this.bottom=this.top+this.height,this.right=this.left+this.width,Object.freeze(this)}return e.fromRect=function(t){return new e(t.x,t.y,t.width,t.height)},e}(),f=function(e){return e instanceof SVGElement&&"getBBox"in e},p=function(e){if(f(e)){var t=e.getBBox(),n=t.width,r=t.height;return!n&&!r}var i=e,o=i.offsetWidth,a=i.offsetHeight;return!(o||a||e.getClientRects().length)},m=new Map,g=/auto|scroll/,v=/^tb|vertical/,y=/msie|trident/i.test(o.navigator&&o.navigator.userAgent),b=function(e){return parseFloat(e||"0")},w=function(e,t,n){return void 0===e&&(e=0),void 0===t&&(t=0),void 0===n&&(n=!1),Object.freeze({inlineSize:(n?t:e)||0,blockSize:(n?e:t)||0})},x=Object.freeze({borderBoxSize:w(),contentBoxSize:w(),contentRect:new d(0,0,0,0)}),_=function(e){if(m.has(e))return m.get(e);if(p(e))return m.set(e,x),x;var t=getComputedStyle(e),n=f(e)&&e.getBBox(),r=!y&&"border-box"===t.boxSizing,i=v.test(t.writingMode||""),o=!n&&g.test(t.overflowY||""),a=!n&&g.test(t.overflowX||""),s=n?0:b(t.paddingTop),c=n?0:b(t.paddingRight),l=n?0:b(t.paddingBottom),u=n?0:b(t.paddingLeft),h=n?0:b(t.borderTopWidth),_=n?0:b(t.borderRightWidth),E=n?0:b(t.borderBottomWidth),S=u+c,C=s+l,A=(n?0:b(t.borderLeftWidth))+_,T=h+E,M=a?e.offsetHeight-T-e.clientHeight:0,O=o?e.offsetWidth-A-e.clientWidth:0,k=r?S+A:0,R=r?C+T:0,P=n?n.width:b(t.width)-k-O,L=n?n.height:b(t.height)-R-M,F=P+S+O+A,j=L+C+M+T,D=Object.freeze({borderBoxSize:w(F,j,i),contentBoxSize:w(P,L,i),contentRect:new d(u,s,P,L)});return m.set(e,D),D},E=function(e,t){var n=_(e),r=n.borderBoxSize,o=n.contentBoxSize;return t===i.BORDER_BOX?r:o},S=function(){function e(e,t){this.target=e,this.observedBox=t||i.CONTENT_BOX,this.lastReportedSize={inlineSize:0,blockSize:0}}return e.prototype.isActive=function(){var e,t=E(this.target,this.observedBox);return e=this.target,f(e)||function(e){switch(e.tagName){case"INPUT":if("image"!==e.type)break;case"VIDEO":case"AUDIO":case"EMBED":case"OBJECT":case"CANVAS":case"IFRAME":case"IMG":return!0}return!1}(e)||"inline"!==getComputedStyle(e).display||(this.lastReportedSize=t),this.lastReportedSize.inlineSize!==t.inlineSize||this.lastReportedSize.blockSize!==t.blockSize},e}(),C=function(e,t){this.activeTargets=[],this.skippedTargets=[],this.observationTargets=[],this.observer=e,this.callback=t},A="ResizeObserver loop completed with undelivered notifications.",T=function(e){var t=_(e);this.target=e,this.contentRect=t.contentRect,this.borderBoxSize=t.borderBoxSize,this.contentBoxSize=t.contentBoxSize},M=function(e){if(p(e))return 1/0;for(var t=0,n=e.parentNode;n;)t+=1,n=n.parentNode;return t},O=function(){var e=1/0,t=[];R.forEach((function(n){if(0!==n.activeTargets.length){var r=[];n.activeTargets.forEach((function(t){var n=new T(t.target),i=M(t.target);r.push(n),t.lastReportedSize=E(t.target,t.observedBox),i<e&&(e=i)})),t.push((function(){n.callback.call(n.observer,r,n.observer)})),n.activeTargets.splice(0,n.activeTargets.length)}}));for(var n=0,r=t;n<r.length;n++){(0,r[n])()}return e},k=function(e){m.clear(),R.forEach((function(t){t.activeTargets.splice(0,t.activeTargets.length),t.skippedTargets.splice(0,t.skippedTargets.length),t.observationTargets.forEach((function(n){n.isActive()&&(M(n.target)>e?t.activeTargets.push(n):t.skippedTargets.push(n))}))}))},R=[],P=new Map,L=0,F=function(e){!L&&e>0&&h.start(),!(L+=e)&&h.stop()},j=function(e,t){for(var n=0;n<e.length;n+=1)if(e[n].target===t)return n;return-1},D=function(){var e,t=0;for(k(t);R.some((function(e){return e.activeTargets.length>0}));)t=O(),k(t);return R.some((function(e){return e.skippedTargets.length>0}))&&("function"==typeof ErrorEvent?e=new ErrorEvent("error",{message:A}):((e=document.createEvent("Event")).initEvent("error",!1,!1),e.message=A),window.dispatchEvent(e)),t>0},N=function(){function e(){}return e.connect=function(e,t){var n=new C(e,t);R.push(n),P.set(e,n)},e.observe=function(e,t,n){if(P.has(e)){var r=P.get(e);j(r.observationTargets,t)<0&&(r.observationTargets.push(new S(t,n&&n.box)),F(1),h.schedule())}},e.unobserve=function(e,t){if(P.has(e)){var n=P.get(e),r=j(n.observationTargets,t);r>=0&&(n.observationTargets.splice(r,1),F(-1))}},e.disconnect=function(e){if(P.has(e)){var t=P.get(e);R.splice(R.indexOf(t),1),P.delete(e),F(-t.observationTargets.length)}},e}(),I=function(){return!!L},B=function(){function e(e){if(0===arguments.length)throw new TypeError("Failed to construct 'ResizeObserver': 1 argument required, but only 0 present.");if("function"!=typeof e)throw new TypeError("Failed to construct 'ResizeObserver': The callback provided as parameter 1 is not a function.");N.connect(this,e)}return e.prototype.observe=function(e,t){if(0===arguments.length)throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': 1 argument required, but only 0 present.");if(e instanceof Element==!1)throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': parameter 1 is not of type 'Element");N.observe(this,e,t)},e.prototype.unobserve=function(e){if(0===arguments.length)throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': 1 argument required, but only 0 present.");if(e instanceof Element==!1)throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': parameter 1 is not of type 'Element");N.unobserve(this,e)},e.prototype.disconnect=function(){N.disconnect(this)},e.toString=function(){return"function ResizeObserver () { [polyfill code] }"},e}();t.default=B},"0Cz8":function(e,t,n){var r=n("Xi7e"),i=n("ebwN"),o=n("e4Nc");e.exports=function(e,t){var n=this.__data__;if(n instanceof r){var a=n.__data__;if(!i||a.length<199)return a.push([e,t]),this.size=++n.size,this;n=this.__data__=new o(a)}return n.set(e,t),this.size=n.size,this}},"0K0V":function(e,t){e.exports=function(){return document.createElement("canvas")}},"0lR2":function(e,t,n){"use strict";e.exports={position:!0,gfm:!0,commonmark:!1,footnotes:!1,pedantic:!1,blocks:n("WwTg")}},"0xIU":function(e,t,n){var r=n("pHPU"),i=n("M96O");e.exports=function(e,t,n){return i.transform(e.nodes(),(function(i,o){i[o]=r(e,o,t,n)}),{})}},"0ycA":function(e,t){e.exports=function(){return[]}},"1+5i":function(e,t,n){var r=n("w/wX"),i=n("sEf8"),o=n("mdPL"),a=o&&o.isSet,s=a?i(a):r;e.exports=s},"14Cm":function(e,t,n){"use strict";var r=n("b5wT");function i(e,t,n){for(var i=r.zipObject(n,r.map(n,(function(e,t){return t}))),o=r.flatten(r.map(t,(function(t){return r.sortBy(r.map(e.outEdges(t),(function(t){return{pos:i[t.w],weight:e.edge(t).weight}})),"pos")})),!0),a=1;a<n.length;)a<<=1;var s=2*a-1;a-=1;var c=r.map(new Array(s),(function(){return 0})),l=0;return r.forEach(o.forEach((function(e){var t=e.pos+a;c[t]+=e.weight;for(var n=0;t>0;)t%2&&(n+=c[t+1]),c[t=t-1>>1]+=e.weight;l+=e.weight*n}))),l}e.exports=function(e,t){for(var n=0,r=1;r<t.length;++r)n+=i(e,t[r-1],t[r]);return n}},"16Al":function(e,t,n){"use strict";var r=n("WbBG");function i(){}function o(){}o.resetWarningCache=i,e.exports=function(){function e(e,t,n,i,o,a){if(a!==r){var s=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types");throw s.name="Invariant Violation",s}}function t(){return e}e.isRequired=e;var n={array:e,bool:e,func:e,number:e,object:e,string:e,symbol:e,any:e,arrayOf:t,element:e,elementType:e,instanceOf:t,node:e,objectOf:t,oneOf:t,oneOfType:t,shape:t,exact:t,checkPropTypes:o,resetWarningCache:i};return n.PropTypes=n,n}},"17x9":function(e,t,n){e.exports=n("16Al")()},"197s":function(e,t,n){var r,i,o;i=[e,t,n("q1tI"),n("17x9")],void 0===(o="function"==typeof(r=function(e,t,n,r){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var i=o(n);function o(e){return e&&e.__esModule?e:{default:e}}o(r);var a=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),s=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e};function c(e,t){var n={};for(var r in e)t.indexOf(r)>=0||Object.prototype.hasOwnProperty.call(e,r)&&(n[r]=e[r]);return n}var l={className:"react-tagsinput-input",placeholder:"Add a tag"},u=function(e){function t(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);var e=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).call(this));return e.state={tag:"",isFocused:!1},e.focus=e.focus.bind(e),e.blur=e.blur.bind(e),e}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,e),a(t,[{key:"_getTagDisplayValue",value:function(e){var t=this.props.tagDisplayProp;return t?e[t]:e}},{key:"_makeTag",value:function(e){var t,n,r,i=this.props.tagDisplayProp;return i?(r=e,(n=i)in(t={})?Object.defineProperty(t,n,{value:r,enumerable:!0,configurable:!0,writable:!0}):t[n]=r,t):e}},{key:"_removeTag",value:function(e){var t=this.props.value.concat([]);if(e>-1&&e<t.length){var n=t.splice(e,1);this.props.onChange(t,n,[e])}}},{key:"_clearInput",value:function(){this.hasControlledInput()?this.props.onChangeInput(""):this.setState({tag:""})}},{key:"_tag",value:function(){return this.hasControlledInput()?this.props.inputValue:this.state.tag}},{key:"_addTags",value:function(e){var t=this,n=this.props,r=n.validationRegex,i=n.onChange,o=n.onValidationReject,a=n.onlyUnique,s=n.maxTags,c=n.value;a&&(e=(e=function(e){for(var t=[],n=0;n<e.length;n++)-1===t.indexOf(e[n])&&t.push(e[n]);return t}(e)).filter((function(e){return c.every((function(n){return t._getTagDisplayValue(n)!==t._getTagDisplayValue(e)}))})));var l=e.filter((function(e){return!r.test(t._getTagDisplayValue(e))}));if(e=(e=e.filter((function(e){return r.test(t._getTagDisplayValue(e))}))).filter((function(e){var n=t._getTagDisplayValue(e);return"function"==typeof n.trim?n.trim().length>0:n})),s>=0){var u=Math.max(s-c.length,0);e=e.slice(0,u)}if(o&&l.length>0&&o(l),e.length>0){for(var h=c.concat(e),d=[],f=0;f<e.length;f++)d.push(c.length+f);return i(h,e,d),this._clearInput(),!0}return l.length>0||this._clearInput(),!1}},{key:"_shouldPreventDefaultEventOnAdd",value:function(e,t,n){return!!e||13===n&&(this.props.preventSubmit||!this.props.preventSubmit&&!t)}},{key:"focus",value:function(){this.input&&"function"==typeof this.input.focus&&this.input.focus(),this.handleOnFocus()}},{key:"blur",value:function(){this.input&&"function"==typeof this.input.blur&&this.input.blur(),this.handleOnBlur()}},{key:"accept",value:function(){var e=this._tag();return""!==e&&(e=this._makeTag(e),this._addTags([e]))}},{key:"addTag",value:function(e){return this._addTags([e])}},{key:"clearInput",value:function(){this._clearInput()}},{key:"handlePaste",value:function(e){var t=this,n=this.props,r=n.addOnPaste,i=n.pasteSplit;if(r){e.preventDefault();var o=i(function(e){return window.clipboardData?window.clipboardData.getData("Text"):e.clipboardData?e.clipboardData.getData("text/plain"):""}(e)).map((function(e){return t._makeTag(e)}));this._addTags(o)}}},{key:"handleKeyDown",value:function(e){if(!e.defaultPrevented){var t=this.props,n=t.value,r=t.removeKeys,i=t.addKeys,o=""===this._tag(),a=e.keyCode,s=e.key,c=-1!==i.indexOf(a)||-1!==i.indexOf(s),l=-1!==r.indexOf(a)||-1!==r.indexOf(s);if(c){var u=this.accept();this._shouldPreventDefaultEventOnAdd(u,o,a)&&e.preventDefault()}l&&n.length>0&&o&&(e.preventDefault(),this._removeTag(n.length-1))}}},{key:"handleClick",value:function(e){e.target===this.div&&this.focus()}},{key:"handleChange",value:function(e){var t=this.props.onChangeInput,n=this.props.inputProps.onChange,r=e.target.value;n&&n(e),this.hasControlledInput()?t(r):this.setState({tag:r})}},{key:"handleOnFocus",value:function(e){var t=this.props.inputProps.onFocus;t&&t(e),this.setState({isFocused:!0})}},{key:"handleOnBlur",value:function(e){var t=this.props.inputProps.onBlur;if(this.setState({isFocused:!1}),null!=e&&(t&&t(e),this.props.addOnBlur)){var n=this._makeTag(e.target.value);this._addTags([n])}}},{key:"handleRemove",value:function(e){this._removeTag(e)}},{key:"inputProps",value:function(){var e=this.props.inputProps,t=(e.onChange,e.onFocus,e.onBlur,c(e,["onChange","onFocus","onBlur"])),n=s({},l,t);return this.props.disabled&&(n.disabled=!0),n}},{key:"inputValue",value:function(e){return e.currentValue||e.inputValue||""}},{key:"hasControlledInput",value:function(){var e=this.props,t=e.inputValue;return"function"==typeof e.onChangeInput&&"string"==typeof t}},{key:"componentDidMount",value:function(){this.hasControlledInput()||this.setState({tag:this.inputValue(this.props)})}},{key:"componentWillReceiveProps",value:function(e){this.hasControlledInput()||this.inputValue(e)&&this.setState({tag:this.inputValue(e)})}},{key:"render",value:function(){var e=this,t=this.props,n=t.value,r=(t.onChange,t.tagProps),o=t.renderLayout,a=t.renderTag,l=t.renderInput,u=(t.addKeys,t.removeKeys,t.className),h=t.focusedClassName,d=(t.addOnBlur,t.addOnPaste,t.inputProps,t.pasteSplit,t.onlyUnique,t.maxTags,t.validationRegex,t.disabled);t.tagDisplayProp,t.inputValue,t.onChangeInput,c(t,["value","onChange","tagProps","renderLayout","renderTag","renderInput","addKeys","removeKeys","className","focusedClassName","addOnBlur","addOnPaste","inputProps","pasteSplit","onlyUnique","maxTags","validationRegex","disabled","tagDisplayProp","inputValue","onChangeInput"]),this.state.isFocused&&(u+=" "+h);var f=n.map((function(t,n){return a(s({key:n,tag:t,onRemove:e.handleRemove.bind(e),disabled:d,getTagDisplayValue:e._getTagDisplayValue.bind(e)},r))})),p=l(s({ref:function(t){e.input=t},value:this._tag(),onPaste:this.handlePaste.bind(this),onKeyDown:this.handleKeyDown.bind(this),onChange:this.handleChange.bind(this),onFocus:this.handleOnFocus.bind(this),onBlur:this.handleOnBlur.bind(this),addTag:this.addTag.bind(this)},this.inputProps()));return i.default.createElement("div",{ref:function(t){e.div=t},onClick:this.handleClick.bind(this),className:u},o(f,p))}}]),t}(i.default.Component);u.defaultProps={className:"react-tagsinput",focusedClassName:"react-tagsinput--focused",addKeys:[9,13],addOnBlur:!1,addOnPaste:!1,inputProps:{},removeKeys:[8],renderInput:function(e){e.addTag;var t=c(e,["addTag"]),n=t.onChange,r=t.value,o=c(t,["onChange","value"]);return i.default.createElement("input",s({type:"text",onChange:n,value:r},o))},renderTag:function(e){var t=e.tag,n=e.key,r=e.disabled,o=e.onRemove,a=e.classNameRemove,l=e.getTagDisplayValue,u=c(e,["tag","key","disabled","onRemove","classNameRemove","getTagDisplayValue"]);return i.default.createElement("span",s({key:n},u),l(t),!r&&i.default.createElement("a",{className:a,onClick:function(e){return o(n)}}))},renderLayout:function(e,t){return i.default.createElement("span",null,e,t)},pasteSplit:function(e){return e.split(" ").map((function(e){return e.trim()}))},tagProps:{className:"react-tagsinput-tag",classNameRemove:"react-tagsinput-remove"},onlyUnique:!1,maxTags:-1,validationRegex:/.*/,disabled:!1,tagDisplayProp:null,preventSubmit:!0},t.default=u,e.exports=t.default})?r.apply(t,i):r)||(e.exports=o)},"1KsK":function(e,t,n){"use strict";var r=Object.prototype.toString;e.exports=function(e){var t=r.call(e),n="[object Arguments]"===t;return n||(n="[object Array]"!==t&&null!==e&&"object"==typeof e&&"number"==typeof e.length&&e.length>=0&&"[object Function]"===r.call(e.callee)),n}},"1LK5":function(e,t){e.exports=function(e,t){var n=e.length;for(e.sort(t);n--;)e[n]=e[n].value;return e}},"1PPP":function(e,t,n){var r=n("b5wT");e.exports=function(e,t,n){var i,o={};r.forEach(n,(function(n){for(var r,a,s=e.parent(n);s;){if((r=e.parent(s))?(a=o[r],o[r]=s):(a=i,i=s),a&&a!==s)return void t.setEdge(a,s);s=r}}))}},"1VtT":function(e,t,n){"use strict";var r=n("6dBs"),i=n("Gdbo"),o=n("Esvb"),a=n("xkQk"),s=n("IRYA"),c=n("NkL+");e.exports=function e(){var t=[],n=a(),y={},b=!1,w=-1;return x.data=function(e,t){if(s(e))return 2===arguments.length?(m("data",b),y[e]=t,x):u.call(y,e)&&y[e]||null;if(e)return m("data",b),y=e,x;return y},x.freeze=_,x.attachers=t,x.use=function(e){var n;if(m("use",b),null==e);else if("function"==typeof e)s.apply(null,arguments);else{if("object"!=typeof e)throw new Error("Expected usable value, not `"+e+"`");"length"in e?a(e):i(e)}n&&(y.settings=r(y.settings||{},n));return x;function i(e){a(e.plugins),e.settings&&(n=r(n||{},e.settings))}function o(e){if("function"==typeof e)s(e);else{if("object"!=typeof e)throw new Error("Expected usable value, not `"+e+"`");"length"in e?s.apply(null,e):i(e)}}function a(e){var t,n;if(null==e);else{if("object"!=typeof e||!("length"in e))throw new Error("Expected a list of plugins, not `"+e+"`");for(t=e.length,n=-1;++n<t;)o(e[n])}}function s(e,n){var i=E(e);i?(c(i[1])&&c(n)&&(n=r(i[1],n)),i[1]=n):t.push(l.call(arguments))}},x.parse=function(e){var t,n=o(e);if(_(),f("parse",t=x.Parser),d(t))return new t(String(n),n).parse();return t(String(n),n)},x.stringify=function(e,t){var n,r=o(t);if(_(),p("stringify",n=x.Compiler),g(e),d(n))return new n(e,r).compile();return n(e,r)},x.run=S,x.runSync=function(e,t){var n,r=!1;return S(e,t,(function(e,t){r=!0,i(e),n=t})),v("runSync","run",r),n},x.process=C,x.processSync=function(e){var t,n=!1;return _(),f("processSync",x.Parser),p("processSync",x.Compiler),C(t=o(e),(function(e){n=!0,i(e)})),v("processSync","process",n),t},x;function x(){for(var n=e(),i=t.length,o=-1;++o<i;)n.use.apply(null,t[o]);return n.data(r(!0,{},y)),n}function _(){var e,r,i,o;if(b)return x;for(;++w<t.length;)r=(e=t[w])[0],null,!1!==(i=e[1])&&(!0===i&&(e[1]=void 0),"function"==typeof(o=r.apply(x,e.slice(1)))&&n.use(o));return b=!0,w=1/0,x}function E(e){for(var n,r=t.length,i=-1;++i<r;)if((n=t[i])[0]===e)return n}function S(e,t,r){if(g(e),_(),r||"function"!=typeof t||(r=t,t=null),!r)return new Promise(i);function i(i,a){n.run(e,o(t),(function(t,n,o){n=n||e,t?a(t):i?i(n):r(null,n,o)}))}i(null,r)}function C(e,t){if(_(),f("process",x.Parser),p("process",x.Compiler),!t)return new Promise(n);function n(n,r){var i=o(e);h.run(x,{file:i},(function(e){e?r(e):n?n(i):t(null,i)}))}n(null,t)}}().freeze();var l=[].slice,u={}.hasOwnProperty,h=a().use((function(e,t){t.tree=e.parse(t.file)})).use((function(e,t,n){e.run(t.tree,t.file,(function(e,r,i){e?n(e):(t.tree=r,t.file=i,n())}))})).use((function(e,t){t.file.contents=e.stringify(t.tree,t.file)}));function d(e){return"function"==typeof e&&function(e){var t;for(t in e)return!0;return!1}(e.prototype)}function f(e,t){if("function"!=typeof t)throw new Error("Cannot `"+e+"` without `Parser`")}function p(e,t){if("function"!=typeof t)throw new Error("Cannot `"+e+"` without `Compiler`")}function m(e,t){if(t)throw new Error(["Cannot invoke `"+e+"` on a frozen processor.\nCreate a new ","processor first, by invoking it: use `processor()` instead of ","`processor`."].join(""))}function g(e){if(!e||!s(e.type))throw new Error("Expected node, got `"+e+"`")}function v(e,t,n){if(!n)throw new Error("`"+e+"` finished async. Use `"+t+"` instead")}},"1hJj":function(e,t,n){var r=n("e4Nc"),i=n("ftKO"),o=n("3A9y");function a(e){var t=-1,n=null==e?0:e.length;for(this.__data__=new r;++t<n;)this.add(e[t])}a.prototype.add=a.prototype.push=i,a.prototype.has=o,e.exports=a},"1iAE":function(e,t,n){"use strict";e.exports=function(e){var t="string"==typeof e?e.charCodeAt(0):e;return t>=97&&t<=122||t>=65&&t<=90}},"1iNE":function(e,t,n){var r=n("A90E"),i=n("QqLw"),o=n("MMmD"),a=n("4qC0"),s=n("Z1HP");e.exports=function(e){if(null==e)return 0;if(o(e))return a(e)?s(e):e.length;var t=i(e);return"[object Map]"==t||"[object Set]"==t?e.size:r(e).length}},"1seS":function(e,t,n){"use strict";var r=Array.prototype.slice,i=n("1KsK"),o=Object.keys,a=o?function(e){return o(e)}:n("sYn3"),s=Object.keys;a.shim=function(){Object.keys?function(){var e=Object.keys(arguments);return e&&e.length===arguments.length}(1,2)||(Object.keys=function(e){return i(e)?s(r.call(e)):s(e)}):Object.keys=a;return Object.keys||a},e.exports=a},"1w02":function(e,t){e.exports=function(e,t,n){for(var r=-1,i=e.length,o=t.length,a={};++r<i;){var s=r<o?t[r]:void 0;n(a,e[r],s)}return a}},"2J+T":function(e,t,n){e.exports={components:n("5EqP"),dijkstra:n("pHPU"),dijkstraAll:n("0xIU"),findCycles:n("3azA"),floydWarshall:n("ZzYp"),isAcyclic:n("Q+g8"),postorder:n("Txda"),preorder:n("qvmO"),prim:n("Yen4"),tarjan:n("z6cq"),topsort:n("gYXE")}},"2ajD":function(e,t){e.exports=function(e){return e!=e}},"2fNS":function(e,t,n){"use strict";var r=n("b5wT");e.exports=function(e,t){var n={};return r.forEach(e,(function(e,t){var i=n[e.v]={indegree:0,in:[],out:[],vs:[e.v],i:t};r.isUndefined(e.barycenter)||(i.barycenter=e.barycenter,i.weight=e.weight)})),r.forEach(t.edges(),(function(e){var t=n[e.v],i=n[e.w];r.isUndefined(t)||r.isUndefined(i)||(i.indegree++,t.out.push(n[e.w]))})),function(e){var t=[];function n(e){return function(t){t.merged||(r.isUndefined(t.barycenter)||r.isUndefined(e.barycenter)||t.barycenter>=e.barycenter)&&function(e,t){var n=0,r=0;e.weight&&(n+=e.barycenter*e.weight,r+=e.weight);t.weight&&(n+=t.barycenter*t.weight,r+=t.weight);e.vs=t.vs.concat(e.vs),e.barycenter=n/r,e.weight=r,e.i=Math.min(t.i,e.i),t.merged=!0}(e,t)}}function i(t){return function(n){n.in.push(t),0==--n.indegree&&e.push(n)}}for(;e.length;){var o=e.pop();t.push(o),r.forEach(o.in.reverse(),n(o)),r.forEach(o.out,i(o))}return r.map(r.filter(t,(function(e){return!e.merged})),(function(e){return r.pick(e,["vs","i","barycenter","weight"])}))}(r.filter(n,(function(e){return!e.indegree})))}},"2gN3":function(e,t,n){var r=n("Kz5y")["__core-js_shared__"];e.exports=r},"2yk8":function(e,t,n){"use strict";var r=n("IPAr"),i=n("ZWk2"),o=n("afWh");e.exports=s,s.locator=o,s.notInLink=!0;var a="mailto:".length;function s(e,t,n){var o,s,c,l,u,h,d,f,p,m,g;if("<"===t.charAt(0)){for(this,o="",s=t.length,c=0,l="",h=!1,d="",c++,o="<";c<s&&(u=t.charAt(c),!(r(u)||">"===u||"@"===u||":"===u&&"/"===t.charAt(c+1)));)l+=u,c++;if(l){if(d+=l,l="",d+=u=t.charAt(c),c++,"@"===u)h=!0;else{if(":"!==u||"/"!==t.charAt(c+1))return;d+="/",c++}for(;c<s&&(u=t.charAt(c),!r(u)&&">"!==u);)l+=u,c++;if(u=t.charAt(c),l&&">"===u)return!!n||(p=d+=l,o+=d+u,(f=e.now()).column++,f.offset++,h&&("mailto:"===d.slice(0,a).toLowerCase()?(p=p.substr(a),f.column+=a,f.offset+=a):d="mailto:"+d),m=this.inlineTokenizers,this.inlineTokenizers={text:m.text},g=this.enterLink(),p=this.tokenizeInline(p,f),this.inlineTokenizers=m,g(),e(o)({type:"link",title:null,url:i(d,{nonTerminated:!1}),children:p}))}}}},"33yf":function(e,t,n){(function(e){function n(e,t){for(var n=0,r=e.length-1;r>=0;r--){var i=e[r];"."===i?e.splice(r,1):".."===i?(e.splice(r,1),n++):n&&(e.splice(r,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}function r(e,t){if(e.filter)return e.filter(t);for(var n=[],r=0;r<e.length;r++)t(e[r],r,e)&&n.push(e[r]);return n}t.resolve=function(){for(var t="",i=!1,o=arguments.length-1;o>=-1&&!i;o--){var a=o>=0?arguments[o]:e.cwd();if("string"!=typeof a)throw new TypeError("Arguments to path.resolve must be strings");a&&(t=a+"/"+t,i="/"===a.charAt(0))}return(i?"/":"")+(t=n(r(t.split("/"),(function(e){return!!e})),!i).join("/"))||"."},t.normalize=function(e){var o=t.isAbsolute(e),a="/"===i(e,-1);return(e=n(r(e.split("/"),(function(e){return!!e})),!o).join("/"))||o||(e="."),e&&a&&(e+="/"),(o?"/":"")+e},t.isAbsolute=function(e){return"/"===e.charAt(0)},t.join=function(){var e=Array.prototype.slice.call(arguments,0);return t.normalize(r(e,(function(e,t){if("string"!=typeof e)throw new TypeError("Arguments to path.join must be strings");return e})).join("/"))},t.relative=function(e,n){function r(e){for(var t=0;t<e.length&&""===e[t];t++);for(var n=e.length-1;n>=0&&""===e[n];n--);return t>n?[]:e.slice(t,n-t+1)}e=t.resolve(e).substr(1),n=t.resolve(n).substr(1);for(var i=r(e.split("/")),o=r(n.split("/")),a=Math.min(i.length,o.length),s=a,c=0;c<a;c++)if(i[c]!==o[c]){s=c;break}var l=[];for(c=s;c<i.length;c++)l.push("..");return(l=l.concat(o.slice(s))).join("/")},t.sep="/",t.delimiter=":",t.dirname=function(e){if("string"!=typeof e&&(e+=""),0===e.length)return".";for(var t=e.charCodeAt(0),n=47===t,r=-1,i=!0,o=e.length-1;o>=1;--o)if(47===(t=e.charCodeAt(o))){if(!i){r=o;break}}else i=!1;return-1===r?n?"/":".":n&&1===r?"/":e.slice(0,r)},t.basename=function(e,t){var n=function(e){"string"!=typeof e&&(e+="");var t,n=0,r=-1,i=!0;for(t=e.length-1;t>=0;--t)if(47===e.charCodeAt(t)){if(!i){n=t+1;break}}else-1===r&&(i=!1,r=t+1);return-1===r?"":e.slice(n,r)}(e);return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n},t.extname=function(e){"string"!=typeof e&&(e+="");for(var t=-1,n=0,r=-1,i=!0,o=0,a=e.length-1;a>=0;--a){var s=e.charCodeAt(a);if(47!==s)-1===r&&(i=!1,r=a+1),46===s?-1===t?t=a:1!==o&&(o=1):-1!==t&&(o=-1);else if(!i){n=a+1;break}}return-1===t||-1===r||0===o||1===o&&t===r-1&&t===n+1?"":e.slice(t,r)};var i= true?function(e,t,n){return e.substr(t,n)}:0}).call(this,n("8oxB"))},"3A9y":function(e,t){e.exports=function(e){return this.__data__.has(e)}},"3Fdi":function(e,t){var n=Function.prototype.toString;e.exports=function(e){if(null!=e){try{return n.call(e)}catch(e){}try{return e+""}catch(e){}}return""}},"3GlI":function(e,t,n){"use strict";e.exports=function(e){return String(e).replace(/\n+$/,"")}},"3L66":function(e,t,n){var r=n("MMmD"),i=n("ExA7");e.exports=function(e){return i(e)&&r(e)}},"3WF5":function(e,t,n){var r=n("eUgh"),i=n("ut/Y"),o=n("l9OW"),a=n("Z0cm");e.exports=function(e,t){return(a(e)?r:o)(e,i(t,3))}},"3azA":function(e,t,n){var r=n("M96O"),i=n("z6cq");e.exports=function(e){return r.filter(i(e),(function(t){return t.length>1||1===t.length&&e.hasEdge(t[0],t[0])}))}},"3cg9":function(e,t,n){"use strict";n.r(t),function(e){n.d(t,"ANCHOR_MODE",(function(){return ce})),n.d(t,"ControlsManager",(function(){return ge})),n.d(t,"DEFAULT_HANDLE_GROUP_NAME",(function(){return se})),n.d(t,"Pick",(function(){return v})),n.d(t,"PickPlane",(function(){return b})),n.d(t,"PickPlaneGroup",(function(){return f})),n.d(t,"RAYCASTER_EVENTS",(function(){return de})),n.d(t,"Rotation",(function(){return g})),n.d(t,"RotationGroup",(function(){return h})),n.d(t,"Translation",(function(){return p})),n.d(t,"TranslationGroup",(function(){return u}));var r=n("Womt"),i=function(e,t){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)};
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */function o(e,t){function n(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var a;!function(e){e[e.ACTIVE=.75]="ACTIVE",e[e.INACTIVE=.3]="INACTIVE"}(a||(a={}));var s=function(e){function t(t){var n=e.call(this)||this;return n.geometry=new r.ConeGeometry(.3,.75,32),n.material=new r.MeshBasicMaterial({color:t,depthTest:!1}),n.material.transparent=!0,n.material.opacity=1,n}return o(t,e),t}(r.Mesh),c=function(e){function t(t,n){var i=e.call(this)||this;return i.geometry=n,i.material=new r.MeshBasicMaterial({color:t,depthTest:!0}),i.material.transparent=!0,i.material.opacity=1,i}return o(t,e),t}(r.LineLoop),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t}(r.Group),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t}(l),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t}(l),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t}(l),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t}(l),p=function(e){function t(t){void 0===t&&(t="#f0ff00");var n=e.call(this)||this;n.parallel=new r.Vector3(0,1,0),n.getInteractiveObjects=function(){return[n.cone]},n.setColor=function(e){var t=n.cone.material,r=n.line.material;t.color.set(e),r.color.set(e)},n.cone=new s(t);var i=new r.Geometry;return i.vertices.push(new r.Vector3(0,0,0)),i.vertices.push(new r.Vector3(0,1,0)),n.line=new c(t,i),n.cone.geometry.scale(.3,.75,.3),n.cone.translateY(1),n.add(n.cone),n.add(n.line),n}return o(t,e),t}(u),m=function(e){function t(t){var n=e.call(this)||this;return n.geometry=new r.OctahedronBufferGeometry(.1,0),n.material=new r.MeshBasicMaterial({color:t,depthTest:!1,transparent:!0,side:r.DoubleSide}),n}return o(t,e),t}(r.Mesh),g=function(e){function t(t,n){void 0===t&&(t="#f0ff00"),void 0===n&&(n=1);var i=e.call(this)||this;i.getInteractiveObjects=function(){return[i.handlebar]},i.setColor=function(e){var t=i.ring.material,n=i.handlebar.material;t.color.set(e),n.color.set(e)};for(var o=new r.Geometry,a=2*Math.PI/64,s=1;s<65;s++)o.vertices.push(new r.Vector3(n*Math.cos(s*a),n*Math.sin(s*a),0));return i.ring=new c(t,o),i.handlebar=new m(t),i.handlebar.position.y=n,i.add(i.ring),i.add(i.handlebar),i}return o(t,e),t}(h),v=function(e){function t(){var t=e.call(this)||this;return t.getInteractiveObjects=function(){return[t.octahedron]},t.setColor=function(e){t.octahedron.material.color.set(e)},t.octahedron=new m("white"),t.add(t.octahedron),t}return o(t,e),t}(d),y=function(e){function t(t){void 0===t&&(t="#f0ff00");var n=e.call(this)||this;return n.geometry=new r.PlaneGeometry(.75,.75,32),n.material=new r.MeshBasicMaterial({color:t,depthTest:!1,side:r.DoubleSide,transparent:!0}),n.material.opacity=a.INACTIVE,n}return o(t,e),t}(r.Mesh),b=function(e){function t(t){void 0===t&&(t="#f0ff00");var n=e.call(this)||this;n.getInteractiveObjects=function(){return[n.plane]},n.setColor=function(e){var t=n.plane.material,r=n.boundary.material;t.color.set(e),r.color.set(e)};var i=new r.Geometry,o=new r.Geometry,a=new r.Geometry;return i.vertices.push(new r.Vector3(.375,.375,0)),i.vertices.push(new r.Vector3(.375,-.375,0)),i.vertices.push(new r.Vector3(-.375,-.375,0)),i.vertices.push(new r.Vector3(-.375,.375,0)),o.vertices.push(new r.Vector3(0,.375,0)),o.vertices.push(new r.Vector3(0,-.375,0)),a.vertices.push(new r.Vector3(-.375,0,0)),a.vertices.push(new r.Vector3(.375,0,0)),n.boundary=new c(t,i),n.crossX=new c("black",o),n.crossY=new c("black",a),n.plane=new y(t),n.add(n.plane),n.add(n.boundary),n.add(n.crossX),n.add(n.crossY),n}return o(t,e),t}(f),w=function(e){function t(t){void 0===t&&(t="#f0ff00");var n=e.call(this,t,1.25)||this;return n.camera=null,n.controlsWorldOrientation=new r.Quaternion,n._temp1=new r.Vector3,n._temp2=new r.Vector3,n._temp3=new r.Quaternion,n.worldPosition=new r.Vector3,n}return o(t,e),t.prototype.updateMatrixWorld=function(t){null!==this.camera&&null!==this.parent&&(this.parent.matrixWorld.decompose(this._temp1,this.controlsWorldOrientation,this._temp2),this.matrixWorld.decompose(this.worldPosition,this._temp3,this._temp2),this.camera.getWorldQuaternion(this.quaternion).premultiply(this.controlsWorldOrientation.inverse()),this.camera.getWorldPosition(this.up).sub(this.worldPosition)),e.prototype.updateMatrixWorld.call(this,t)},t}(g),x="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:void 0!==e?e:"undefined"!=typeof self?self:{};var _=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,E=/^\w*$/,S=/^\./,C=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,A=/\\(\\)?/g,T=/^\[object .+?Constructor\]$/,M="object"==typeof x&&x&&x.Object===Object&&x,O="object"==typeof self&&self&&self.Object===Object&&self,k=M||O||Function("return this")();var R,P=Array.prototype,L=Function.prototype,F=Object.prototype,j=k["__core-js_shared__"],D=(R=/[^.]+$/.exec(j&&j.keys&&j.keys.IE_PROTO||""))?"Symbol(src)_1."+R:"",N=L.toString,I=F.hasOwnProperty,B=F.toString,z=RegExp("^"+N.call(I).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),U=k.Symbol,H=P.splice,V=ee(k,"Map"),$=ee(Object,"create"),W=U?U.prototype:void 0,G=W?W.toString:void 0;function q(e){var t=-1,n=e?e.length:0;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function Y(e){var t=-1,n=e?e.length:0;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function X(e){var t=-1,n=e?e.length:0;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function K(e,t){for(var n,r,i=e.length;i--;)if((n=e[i][0])===(r=t)||n!=n&&r!=r)return i;return-1}function Z(e,t){for(var n,r=0,i=(t=function(e,t){if(ie(e))return!1;var n=typeof e;if("number"==n||"symbol"==n||"boolean"==n||null==e||ae(e))return!0;return E.test(e)||!_.test(e)||null!=t&&e in Object(t)}(t,e)?[t]:ie(n=t)?n:te(n)).length;null!=e&&r<i;)e=e[ne(t[r++])];return r&&r==i?e:void 0}function J(e){return!(!oe(e)||(t=e,D&&D in t))&&(function(e){var t=oe(e)?B.call(e):"";return"[object Function]"==t||"[object GeneratorFunction]"==t}(e)||function(e){var t=!1;if(null!=e&&"function"!=typeof e.toString)try{t=!!(e+"")}catch(e){}return t}(e)?z:T).test(function(e){if(null!=e){try{return N.call(e)}catch(e){}try{return e+""}catch(e){}}return""}(e));var t}function Q(e,t){var n,r,i=e.__data__;return("string"==(r=typeof(n=t))||"number"==r||"symbol"==r||"boolean"==r?"__proto__"!==n:null===n)?i["string"==typeof t?"string":"hash"]:i.map}function ee(e,t){var n=function(e,t){return null==e?void 0:e[t]}(e,t);return J(n)?n:void 0}q.prototype.clear=function(){this.__data__=$?$(null):{}},q.prototype.delete=function(e){return this.has(e)&&delete this.__data__[e]},q.prototype.get=function(e){var t=this.__data__;if($){var n=t[e];return"__lodash_hash_undefined__"===n?void 0:n}return I.call(t,e)?t[e]:void 0},q.prototype.has=function(e){var t=this.__data__;return $?void 0!==t[e]:I.call(t,e)},q.prototype.set=function(e,t){return this.__data__[e]=$&&void 0===t?"__lodash_hash_undefined__":t,this},Y.prototype.clear=function(){this.__data__=[]},Y.prototype.delete=function(e){var t=this.__data__,n=K(t,e);return!(n<0)&&(n==t.length-1?t.pop():H.call(t,n,1),!0)},Y.prototype.get=function(e){var t=this.__data__,n=K(t,e);return n<0?void 0:t[n][1]},Y.prototype.has=function(e){return K(this.__data__,e)>-1},Y.prototype.set=function(e,t){var n=this.__data__,r=K(n,e);return r<0?n.push([e,t]):n[r][1]=t,this},X.prototype.clear=function(){this.__data__={hash:new q,map:new(V||Y),string:new q}},X.prototype.delete=function(e){return Q(this,e).delete(e)},X.prototype.get=function(e){return Q(this,e).get(e)},X.prototype.has=function(e){return Q(this,e).has(e)},X.prototype.set=function(e,t){return Q(this,e).set(e,t),this};var te=re((function(e){var t;e=null==(t=e)?"":function(e){if("string"==typeof e)return e;if(ae(e))return G?G.call(e):"";var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}(t);var n=[];return S.test(e)&&n.push(""),e.replace(C,(function(e,t,r,i){n.push(r?i.replace(A,"$1"):t||e)})),n}));function ne(e){if("string"==typeof e||ae(e))return e;var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}function re(e,t){if("function"!=typeof e||t&&"function"!=typeof t)throw new TypeError("Expected a function");var n=function(){var r=arguments,i=t?t.apply(this,r):r[0],o=n.cache;if(o.has(i))return o.get(i);var a=e.apply(this,r);return n.cache=o.set(i,a),a};return n.cache=new(re.Cache||X),n}re.Cache=X;var ie=Array.isArray;function oe(e){var t=typeof e;return!!e&&("object"==t||"function"==t)}function ae(e){return"symbol"==typeof e||function(e){return!!e&&"object"==typeof e}(e)&&"[object Symbol]"==B.call(e)}var se,ce,le=function(e,t,n){var r=null==e?void 0:Z(e,t);return void 0===r?n:r};!function(e){e.XPT="xpt_handle",e.YPT="ypt_handle",e.ZPT="zpt_handle",e.XNT="xnt_handle",e.YNT="ynt_handle",e.ZNT="znt_handle",e.XR="xr_handle",e.YR="yr_handle",e.ZR="zr_handle",e.ER="er_handle",e.PICK="pick_handle",e.PICK_PLANE_XY="pick_plane_xy_handle",e.PICK_PLANE_YZ="pick_plane_yz_handle",e.PICK_PLANE_ZX="pick_plane_zx_handle"}(se||(se={})),function(e){e.FIXED="fixed",e.INHERIT="inherit"}(ce||(ce={}));var ue=function(e){function t(t,n,i){var o=e.call(this)||this;if(o.object=t,o.camera=n,o.handleTargetQuaternion=new r.Quaternion,o.objectWorldPosition=new r.Vector3,o.objectTargetPosition=new r.Vector3,o.objectTargetQuaternion=new r.Quaternion,o.objectParentWorldPosition=new r.Vector3,o.objectParentWorldQuaternion=new r.Quaternion,o.objectParentWorldScale=new r.Vector3,o.deltaPosition=new r.Vector3,o.normalizedHandleParallelVectorCache=new r.Vector3,o.touch1=new r.Vector3,o.touch2=new r.Vector3,o.minBox=new r.Vector3,o.maxBox=new r.Vector3,o.dragStartPoint=new r.Vector3,o.dragIncrementalStartPoint=new r.Vector3,o.handleNamesMap={},o.isBeingDraggedTranslation=!1,o.isBeingDraggedRotation=!1,o.isDampingEnabled=!0,o.dampingFactor=.8,o.initialSelfQuaternion=new r.Quaternion,o.setupDefaultPickPlane=function(){o.pickPlaneXY.name=se.PICK_PLANE_XY,o.pickPlaneYZ.name=se.PICK_PLANE_YZ,o.pickPlaneZX.name=se.PICK_PLANE_ZX,o.pickPlaneYZ.up=new r.Vector3(1,0,0),o.pickPlaneZX.up=new r.Vector3(0,1,0),o.pickPlaneXY.up=new r.Vector3(0,0,1),o.pickPlaneYZ.rotateY(Math.PI/2),o.pickPlaneZX.rotateX(Math.PI/2),o.handleNamesMap[o.pickPlaneXY.name]=o.pickPlaneXY,o.handleNamesMap[o.pickPlaneYZ.name]=o.pickPlaneYZ,o.handleNamesMap[o.pickPlaneZX.name]=o.pickPlaneZX,o.add(o.pickPlaneXY),o.add(o.pickPlaneYZ),o.add(o.pickPlaneZX)},o.setupHandle=function(e){if(void 0!==o.handleNamesMap[e.name])throw new Error("handle with this name already exists!");o.handleNamesMap[e.name]=e,o.add(e)},o.setupDefaultPick=function(){o.pick.name=se.PICK,o.handleNamesMap[o.pick.name]=o.pick,o.add(o.pick)},o.setupDefaultEyeRotation=function(){o.rotationEye.name=se.ER,o.handleNamesMap[o.rotationEye.name]=o.rotationEye,o.rotationEye.camera=o.camera,o.add(o.rotationEye)},o.setupDefaultTranslation=function(){o.translationXP.name=se.XPT,o.translationYP.name=se.YPT,o.translationZP.name=se.ZPT,o.translationXN.name=se.XNT,o.translationYN.name=se.YNT,o.translationZN.name=se.ZNT,o.translationXP.translateX(o.maxBox.x),o.translationYP.translateY(o.maxBox.y),o.translationZP.translateZ(o.maxBox.z),o.translationXN.translateX(o.minBox.x),o.translationYN.translateY(o.minBox.y),o.translationZN.translateZ(o.minBox.z),o.translationXP.rotateZ(-Math.PI/2),o.translationZP.rotateX(Math.PI/2),o.translationXN.rotateZ(Math.PI/2),o.translationYN.rotateX(Math.PI),o.translationZN.rotateX(-Math.PI/2),o.translationXP.up=new r.Vector3(0,1,0),o.translationYP.up=new r.Vector3(0,0,1),o.translationZP.up=new r.Vector3(0,1,0),o.translationXN.up=new r.Vector3(0,-1,0),o.translationYN.up=new r.Vector3(0,0,-1),o.translationZN.up=new r.Vector3(0,-1,0),o.translationXP.parallel=new r.Vector3(1,0,0),o.translationYP.parallel=new r.Vector3(0,1,0),o.translationZP.parallel=new r.Vector3(0,0,1),o.translationXN.parallel=new r.Vector3(-1,0,0),o.translationYN.parallel=new r.Vector3(0,-1,0),o.translationZN.parallel=new r.Vector3(0,0,-1),o.handleNamesMap[o.translationXP.name]=o.translationXP,o.handleNamesMap[o.translationYP.name]=o.translationYP,o.handleNamesMap[o.translationZP.name]=o.translationZP,o.handleNamesMap[o.translationXN.name]=o.translationXN,o.handleNamesMap[o.translationYN.name]=o.translationYN,o.handleNamesMap[o.translationZN.name]=o.translationZN,o.add(o.translationXP),o.add(o.translationYP),o.add(o.translationZP),o.add(o.translationXN),o.add(o.translationYN),o.add(o.translationZN)},o.setupDefaultRotation=function(){o.rotationX.name=se.XR,o.rotationY.name=se.YR,o.rotationZ.name=se.ZR,o.rotationX.up=new r.Vector3(1,0,0),o.rotationY.up=new r.Vector3(0,1,0),o.rotationZ.up=new r.Vector3(0,0,1),o.rotationX.rotateY(Math.PI/2),o.rotationX.rotateZ(Math.PI),o.rotationY.rotateX(Math.PI/2),o.handleNamesMap[o.rotationX.name]=o.rotationX,o.handleNamesMap[o.rotationY.name]=o.rotationY,o.handleNamesMap[o.rotationZ.name]=o.rotationZ,o.add(o.rotationX),o.add(o.rotationY),o.add(o.rotationZ)},o.computeObjectBounds=function(){if(void 0!==o.options.separationT){var e=o.options.separationT,t=e.x,n=e.y,i=e.z;o.minBox.copy(new r.Vector3(-t,-n,-i)),o.maxBox.copy(new r.Vector3(t,n,i))}else if("Mesh"===o.object.type){var a=o.object.geometry;a.computeBoundingBox();var s=a.boundingBox,c=s.min,l=s.max;o.minBox.copy(c),o.maxBox.copy(l),o.minBox.addScalar(-.5),o.maxBox.addScalar(.5)}else o.minBox.copy(new r.Vector3(-1,-1,-1)),o.maxBox.copy(new r.Vector3(1,1,1))},o.processDragStart=function(e){var t=e.point,n=e.handle;o.dragStartPoint.copy(t),o.dragIncrementalStartPoint.copy(t),o.isBeingDraggedTranslation=n instanceof u||n instanceof d||n instanceof f,o.isBeingDraggedRotation=n instanceof h},o.setDampingFactor=function(e){return void 0===e&&(e=0),o.dampingFactor=r.Math.clamp(e,0,1)},o.processHandle=function(e){var t=e.point,n=e.handle,r=e.dragRatio,i=void 0===r?1:r,a=Math.exp(-o.dampingFactor*Math.abs(Math.pow(i,3)));if(n instanceof u){o.deltaPosition.copy(t).sub(o.dragIncrementalStartPoint),o.normalizedHandleParallelVectorCache.copy(n.parallel.normalize()).applyQuaternion(o.quaternion);var s=o.deltaPosition.dot(o.normalizedHandleParallelVectorCache);o.deltaPosition.copy(o.normalizedHandleParallelVectorCache).multiplyScalar(o.isDampingEnabled?a*s:s),o.position.add(o.deltaPosition)}else n instanceof d||n instanceof f?(o.deltaPosition.copy(t).sub(o.dragIncrementalStartPoint).multiplyScalar(o.isDampingEnabled?a:1),o.position.add(o.deltaPosition)):(o.touch1.copy(o.dragIncrementalStartPoint).sub(o.objectWorldPosition).normalize(),o.touch2.copy(t).sub(o.objectWorldPosition).normalize(),o.handleTargetQuaternion.setFromUnitVectors(o.touch1,o.touch2),o.attachMode===ce.FIXED&&o.detachHandleUpdateQuaternionAttach(n,o.handleTargetQuaternion));o.objectTargetQuaternion.premultiply(o.handleTargetQuaternion),o.dragIncrementalStartPoint.copy(t)},o.detachObjectUpdatePositionAttach=function(e,t){if(null!==e&&null!==o.parent&&null!==o.parent.parent){var n=o.parent.parent;if("Scene"!==n.type)throw new Error("freeform controls must be attached to the scene");n.attach(t),t.position.copy(o.objectTargetPosition),e.attach(t)}},o.detachHandleUpdateQuaternionAttach=function(e,t){if(null!==o.parent&&o.parent.parent){var n=o.parent.parent;if("Scene"!==n.type)throw new Error("freeform controls must be attached to the scene");n.attach(e),e.applyQuaternion(t),o.attach(e)}},o.showByNames=function(e,t){void 0===t&&(t=!0),e.map((function(e){var n=o.handleNamesMap[e];if(void 0===n)throw new Error("handle: "+e+" not found");n.visible=t}))},o.showAll=function(e){void 0===e&&(e=!0),Object.values(o.handleNamesMap).map((function(t){t.visible=e}))},o.updateMatrixWorld=function(t){o.object.updateMatrixWorld(t),o.object.getWorldPosition(o.objectWorldPosition);var n=o.object.parent;null!==n&&n.matrixWorld.decompose(o.objectParentWorldPosition,o.objectParentWorldQuaternion,o.objectParentWorldScale),o.objectParentWorldQuaternion.inverse(),o.objectTargetPosition.copy(o.position),o.objectTargetQuaternion.premultiply(o.objectParentWorldQuaternion),o.isBeingDraggedTranslation?o.detachObjectUpdatePositionAttach(n,o.object):o.isBeingDraggedRotation?(o.object.quaternion.copy(o.objectTargetQuaternion),o.detachObjectUpdatePositionAttach(n,o.object)):o.position.copy(o.objectWorldPosition),o.object.getWorldQuaternion(o.objectTargetQuaternion),o.attachMode!==ce.INHERIT||o.isBeingDraggedTranslation||o.quaternion.copy(o.initialSelfQuaternion).premultiply(o.objectTargetQuaternion),e.prototype.updateMatrixWorld.call(o,t)},o.options=i||{},o.attachMode=le(o.options,"mode",ce.FIXED),o.hideOtherHandlesOnSelect=le(o.options,"hideOtherHandlesOnSelect",!0),o.hideOtherControlsInstancesOnSelect=le(o.options,"hideOtherControlsInstancesOnSelect",!0),o.showHelperPlane=le(o.options,"showHelperPlane",!1),void 0!==o.options.orientation){var a=o.options.orientation,s=a.x,c=a.y,l=a.z,m=a.w;o.initialSelfQuaternion.set(s,c,l,m).normalize(),o.quaternion.copy(o.initialSelfQuaternion)}return o.computeObjectBounds(),o.pick=new v,o.pickPlaneXY=new b("yellow"),o.pickPlaneYZ=new b("cyan"),o.pickPlaneZX=new b("pink"),o.translationXP=new p("red"),o.translationYP=new p("green"),o.translationZP=new p("blue"),o.translationXN=new p("red"),o.translationYN=new p("green"),o.translationZN=new p("blue"),o.rotationX=new g("red"),o.rotationY=new g("green"),o.rotationZ=new g("blue"),o.rotationEye=new w("yellow"),o.setupDefaultTranslation(),o.setupDefaultRotation(),o.setupDefaultEyeRotation(),o.setupDefaultPickPlane(),o.setupDefaultPick(),o}return o(t,e),t.prototype.getInteractiveObjects=function(){var e=Object.values(this.handleNamesMap),t=[];return e.map((function(e){e.visible&&t.push.apply(t,e.getInteractiveObjects())})),t},t}(r.Group),he=function(e,t){return e(t={exports:{}},t.exports),t.exports}((function(e){(e.exports=function(){this.events={}}).prototype={emit:function(e){var t=[].slice.call(arguments,1);[].slice.call(this.events[e]||[]).filter((function(e){e.apply(null,t)}))},on:function(e,t){return(this.events[e]=this.events[e]||[]).push(t),function(){this.events[e]=this.events[e].filter((function(e){return e!==t}))}.bind(this)}}}));var de,fe=function(e){e.events={}},pe=new he;!function(e){e.DRAG_START="DRAG_START",e.DRAG="DRAG",e.DRAG_STOP="DRAG_STOP"}(de||(de={}));var me=function(e){function t(t,n,i){var o=e.call(this)||this;return o.camera=t,o.domElement=n,o.controls=i,o.mouse=new r.Vector2,o.cameraPosition=new r.Vector3,o.activeHandle=null,o.activePlane=null,o.point=new r.Vector3,o.normal=new r.Vector3,o.visibleHandles=[],o.visibleControls=[],o.helperPlane=new y("yellow"),o.controlsWorldQuaternion=new r.Quaternion,o.activeHandleWorldQuaternion=new r.Quaternion,o.clientDiagonalLength=1,o.previousScreenPoint=new r.Vector2,o.currentScreenPoint=new r.Vector2,o.mouseDownListener=function(e){o.setRayDirection(e),o.clientDiagonalLength=Math.sqrt(Math.pow(e.target.clientWidth,2)+Math.pow(e.target.clientHeight,2)),o.previousScreenPoint.set(e.clientX,e.clientY);var t=[];if(Object.values(o.controls).map((function(e){t.push.apply(t,e.getInteractiveObjects())})),o.activeHandle=o.resolveHandleGroup(o.intersectObjects(t,!0)[0]),null!==o.activeHandle&&null!==o.activeHandle.parent){o.activePlane=new r.Plane;var n=o.activeHandle.parent;if(n.getWorldQuaternion(o.controlsWorldQuaternion),o.normal.copy(o.activeHandle instanceof d?o.getEyePlaneNormal(o.activeHandle):o.activeHandle.up),o.activeHandle instanceof w||o.activeHandle instanceof d||o.normal.applyQuaternion(o.controlsWorldQuaternion),n.hideOtherControlsInstancesOnSelect&&(Object.values(o.controls).forEach((function(e){e.visible&&o.visibleControls.push(e),e.visible=!1})),n.visible=!0),n.hideOtherHandlesOnSelect&&(n.children.map((function(e){e.visible&&o.visibleHandles.push(e),e.visible=!1})),o.activeHandle.visible=!0),n.showHelperPlane&&!(o.activeHandle instanceof v||o.activeHandle instanceof b)){var i=n.parent;o.helperPlane.position.copy(n.position),o.activeHandle.getWorldQuaternion(o.helperPlane.quaternion),i.add(o.helperPlane)}o.activeHandle instanceof b&&o.setPickPlaneOpacity(a.ACTIVE),o.activePlane.setFromNormalAndCoplanarPoint(o.normal,n.position);var s=new r.Vector3;o.activeHandle instanceof d?o.activeHandle.getWorldPosition(s):o.ray.intersectPlane(o.activePlane,s),o.domElement.removeEventListener("mousedown",o.mouseDownListener),pe.emit(de.DRAG_START,{point:s,handle:o.activeHandle}),o.domElement.addEventListener("mousemove",o.mouseMoveListener,!1)}else o.activePlane=null},o.getEyePlaneNormal=function(e){return o.cameraPosition.copy(o.camera.position),o.cameraPosition.sub(e.position)},o.setRayDirection=function(e){var t=o.domElement.getBoundingClientRect(),n=o.domElement,r=n.clientHeight,i=n.clientWidth;o.mouse.x=(e.clientX-t.left)/i*2-1,o.mouse.y=-(e.clientY-t.top)/r*2+1,o.setFromCamera(o.mouse,o.camera)},o.mouseMoveListener=function(e){if(null!==o.activeHandle&&null!==o.activePlane){o.activeHandle.getWorldQuaternion(o.activeHandleWorldQuaternion),o.helperPlane.quaternion.copy(o.activeHandleWorldQuaternion),o.setRayDirection(e),o.ray.intersectPlane(o.activePlane,o.point),o.currentScreenPoint.set(e.clientX,e.clientY);var t=o.currentScreenPoint.distanceTo(o.previousScreenPoint)/(o.clientDiagonalLength||1);pe.emit(de.DRAG,{point:o.point,handle:o.activeHandle,dragRatio:t}),o.previousScreenPoint.set(e.clientX,e.clientY)}},o.mouseUpListener=function(){(o.domElement.removeEventListener("mousemove",o.mouseMoveListener),o.domElement.addEventListener("mousedown",o.mouseDownListener,!1),pe.emit(de.DRAG_STOP,{point:o.point,handle:o.activeHandle}),null!==o.activeHandle&&null!==o.activeHandle.parent&&o.activeHandle.parent.hideOtherControlsInstancesOnSelect&&(o.visibleControls.forEach((function(e){e.visible=!0})),o.visibleControls=[]),null!==o.activeHandle&&null!==o.activeHandle.parent&&o.activeHandle.parent.hideOtherHandlesOnSelect&&(o.visibleHandles.forEach((function(e){e.visible=!0})),o.visibleHandles=[]),o.activeHandle instanceof b&&o.setPickPlaneOpacity(a.INACTIVE),null!==o.activeHandle&&null!==o.activeHandle.parent&&o.activeHandle.parent.showHelperPlane)&&o.activeHandle.parent.parent.remove(o.helperPlane);o.activeHandle=null,o.activePlane=null},o.resolveHandleGroup=function(e){return void 0===e?null:e.object.parent},o.destroy=function(){o.activePlane=null,o.activeHandle=null,o.domElement.removeEventListener("mousedown",o.mouseDownListener),o.domElement.removeEventListener("mousemove",o.mouseMoveListener),o.domElement.removeEventListener("mouseup",o.mouseUpListener)},o.domElement.addEventListener("mousedown",o.mouseDownListener,!1),o.domElement.addEventListener("mouseup",o.mouseUpListener,!1),o}return o(t,e),t.prototype.setPickPlaneOpacity=function(e){if(this.activeHandle instanceof b){var t=this.activeHandle.plane.material;Array.isArray(t)?t.map((function(t){t.opacity=e,t.needsUpdate=!0})):(t.opacity=e,t.needsUpdate=!0)}},t}(r.Raycaster),ge=function(e){function t(t,n){var i,o=e.call(this)||this;return o.camera=t,o.domElement=n,o.objects={},o.controls={},o.eventListeners=((i={})[de.DRAG_START]=[],i[de.DRAG]=[],i[de.DRAG_STOP]=[],i),o.listenToEvents=function(){pe.on(de.DRAG_START,(function(e){var t=e.point,n=e.handle;if(null!==n){var r=n.parent;null!==r&&(r.processDragStart({point:t,handle:n}),o.eventListeners[de.DRAG_START].map((function(e){e(r.object,n.name)})))}})),pe.on(de.DRAG,(function(e){var t=e.point,n=e.handle,r=e.dragRatio;if(null!==n){var i=n.parent;null!==i&&(i.processHandle({point:t,handle:n,dragRatio:r}),o.eventListeners[de.DRAG].map((function(e){e(i.object,n.name)})))}})),pe.on(de.DRAG_STOP,(function(e){var t=e.handle;if(null!==t){var n=t.parent;null!==n&&(n.isBeingDraggedTranslation=!1,n.isBeingDraggedRotation=!1,o.eventListeners[de.DRAG_STOP].map((function(e){e(n.object,t.name)})))}}))},o.anchor=function(e,t){var n=o.addControls(e,t);return o.objects[e.id]=e,n},o.detach=function(e,t){if(!o.objects.hasOwnProperty(e.id))throw new Error("object should be attached first");o.remove(t),o.eventListeners[de.DRAG_STOP].map((function(e){e(t.object,null)})),o.dispose(t),delete o.objects[e.id],delete o.controls[t.id]},o.addControls=function(e,t){var n=new ue(e,o.camera,t);return o.controls[n.id]=n,o.add(n),n},o.listen=function(e,t){o.eventListeners[e].push(t)},o.removeListen=function(e,t){var n=o.eventListeners[e].findIndex(t);-1!==n&&o.eventListeners[e].splice(n,1)},o.dispose=function(e){for(e instanceof r.Mesh&&(e.geometry.dispose(),Array.isArray(e.material)?e.material.map((function(e){return e.dispose()})):e.material.dispose());e.children.length>0;)e.children.map((function(t){o.dispose(t),e.remove(t)}))},o.destroy=function(){var e;fe(pe);var t=o.parent;null!==t&&t.remove(o),o.dispose(o),Object.values(o.controls).map((function(e){o.dispose(e)})),o.eventListeners[de.DRAG_STOP].map((function(e){e(null,null)})),o.rayCaster.destroy(),o.objects={},o.controls={},o.eventListeners=((e={})[de.DRAG_START]=[],e[de.DRAG]=[],e[de.DRAG_STOP]=[],e)},o.rayCaster=new me(o.camera,o.domElement,o.controls),o.listenToEvents(),o}return o(t,e),t}(r.Object3D)}.call(this,n("yLpj"))},"3m36":function(e,t,n){"use strict";var r=n("U6jy"),i=n("q1tI"),o=parseInt((i.version||"16").slice(0,2),10)>=16,a=i.createElement;function s(e,t){return a(e,c(t),t.children)}function c(e){return e["data-sourcepos"]?{"data-sourcepos":e["data-sourcepos"]}:{}}e.exports={break:"br",paragraph:"p",emphasis:"em",strong:"strong",thematicBreak:"hr",blockquote:"blockquote",delete:"del",link:"a",image:"img",linkReference:"a",imageReference:"img",table:s.bind(null,"table"),tableHead:s.bind(null,"thead"),tableBody:s.bind(null,"tbody"),tableRow:s.bind(null,"tr"),tableCell:function(e){var t=e.align?{textAlign:e.align}:void 0,n=c(e);return a(e.isHeader?"th":"td",t?r({style:t},n):n,e.children)},root:function(e){var t=!e.className,n=t&&i.Fragment||"div";return a(n,t?null:e,e.children)},text:function(e){return o?e.children:a("span",null,e.children)},list:function(e){var t=c(e);null!==e.start&&1!==e.start&&void 0!==e.start&&(t.start=e.start.toString());return a(e.ordered?"ol":"ul",t,e.children)},listItem:function(e){var t=null;if(null!==e.checked&&void 0!==e.checked){var n=e.checked;t=a("input",{type:"checkbox",checked:n,readOnly:!0})}return a("li",c(e),t,e.children)},definition:function(){return null},heading:function(e){return a("h".concat(e.level),c(e),e.children)},inlineCode:function(e){return a("code",c(e),e.children)},code:function(e){var t=e.language&&"language-".concat(e.language),n=a("code",t?{className:t}:null,e.value);return a("pre",c(e),n)},html:function(e){if(e.skipHtml)return null;var t=e.isBlock?"div":"span";if(e.escapeHtml){var n=i.Fragment||t;return a(n,null,e.value)}var r={dangerouslySetInnerHTML:{__html:e.value}};return a(t,r)},virtualHtml:function(e){return a(e.tag,c(e),e.children)},parsedHtml:function(e){return e["data-sourcepos"]?i.cloneElement(e.element,{"data-sourcepos":e["data-sourcepos"]}):e.element}}},"3th9":function(e,t,n){var r=n("Sdz8");e.exports=function(e,t,n){return r(e,t,t,n)}},"3y7U":function(e,t,n){var r=n("M96O");e.exports=function(e,t,n){r.isArray(t)||(t=[t]);var i=(e.isDirected()?e.successors:e.neighbors).bind(e),o=[],a={};return r.each(t,(function(t){if(!e.hasNode(t))throw new Error("Graph does not have node: "+t);!function e(t,n,i,o,a,s){r.has(o,n)||(o[n]=!0,i||s.push(n),r.each(a(n),(function(n){e(t,n,i,o,a,s)})),i&&s.push(n))}(e,t,"post"===n,a,i,o)})),o}},"4/ic":function(e,t,n){var r=n("ZWtO");e.exports=function(e){return function(t){return r(t,e)}}},"409L":function(e,t,n){e.exports={graphlib:n("F9We"),layout:n("epwv"),debug:n("4JAw"),util:{time:n("tQ6r").time,notime:n("tQ6r").notime},version:n("khRU")}},"44Ds":function(e,t,n){var r=n("e4Nc");function i(e,t){if("function"!=typeof e||null!=t&&"function"!=typeof t)throw new TypeError("Expected a function");var n=function(){var r=arguments,i=t?t.apply(this,r):r[0],o=n.cache;if(o.has(i))return o.get(i);var a=e.apply(this,r);return n.cache=o.set(i,a)||o,a};return n.cache=new(i.Cache||r),n}i.Cache=r,e.exports=i},"48q5":function(e,t,n){"use strict";var r=n("33yf");e.exports=function(e,t){if("string"!=typeof e)return e;if(0===e.length)return e;var n=r.basename(e,r.extname(e))+t;return r.join(r.dirname(e),n)}},"497W":function(e,t,n){"use strict";var r=n("aTp6");e.exports=i,i.locator=r;function i(e,t,n){for(var r,i=t.length,o=-1,a="";++o<i;){if("\n"===(r=t.charAt(o))){if(o<2)return;return!!n||e(a+=r)({type:"break"})}if(" "!==r)return;a+=r}}},"4ALT":function(e,t,n){"use strict";n.d(t,"h",(function(){return r})),n.d(t,"a",(function(){return i})),n.d(t,"i",(function(){return o})),n.d(t,"b",(function(){return a})),n.d(t,"c",(function(){return s})),n.d(t,"d",(function(){return c})),n.d(t,"e",(function(){return l})),n.d(t,"f",(function(){return u})),n.d(t,"g",(function(){return h})),n.d(t,"j",(function(){return d})),n.d(t,"k",(function(){return f})),n.d(t,"l",(function(){return p}));var r="#dc1d30",i="#013c89",o="#dc1d30",a="#f6f6f6",s="#dddddd",c="#222222",l="#444444",u="#666666",h="#888888",d="0.8rem",f="0.7rem",p=60},"4Ai+":function(e,t,n){var r=n("Ac7g");e.exports={Graph:r.Graph,json:n("GbLa"),alg:n("2J+T"),version:r.version}},"4JAw":function(e,t,n){var r=n("b5wT"),i=n("tQ6r"),o=n("F9We").Graph;e.exports={debugOrdering:function(e){var t=i.buildLayerMatrix(e),n=new o({compound:!0,multigraph:!0}).setGraph({});return r.forEach(e.nodes(),(function(t){n.setNode(t,{label:t}),n.setParent(t,"layer"+e.node(t).rank)})),r.forEach(e.edges(),(function(e){n.setEdge(e.v,e.w,{},e.name)})),r.forEach(t,(function(e,t){var i="layer"+t;n.setNode(i,{rank:"same"}),r.reduce(e,(function(e,t){return n.setEdge(e,t,{style:"invis"}),t}))})),n}}},"4K9o":function(e,t,n){"use strict";var r=n("82c2"),i=n("hBby"),o=n("vzKJ"),a=n("aqn5"),s=o(),c=function(){return s};r(c,{getPolyfill:o,implementation:i,shim:a}),e.exports=c},"4MqD":function(e,t,n){"use strict";e.exports=function(e,t,n){return function(){var r=n||this,i=r[e];return r[e]=!t,function(){r[e]=i}}}},"4P+C":function(e,t,n){"use strict";var r=n("PEyx"),i=n("Ve/E");e.exports=function(e,t){function n(e){var n=t.node(e);return"translate("+n.x+","+n.y+")"}e.filter((function(){return!i.select(this).classed("update")})).attr("transform",n),r.applyTransition(e,t).style("opacity",1).attr("transform",n)}},"4XN4":function(e,t,n){var r=n("PjQo"),i=n("cjKa").EventEmitter2;function o(e){var t=this;this.actionClient=e.actionClient,this.goalMessage=e.goalMessage,this.isFinished=!1;var n=new Date;this.goalID="goal_"+Math.random()+"_"+n.getTime(),this.goalMessage=new r({goal_id:{stamp:{secs:0,nsecs:0},id:this.goalID},goal:this.goalMessage}),this.on("status",(function(e){t.status=e})),this.on("result",(function(e){t.isFinished=!0,t.result=e})),this.on("feedback",(function(e){t.feedback=e})),this.actionClient.goals[this.goalID]=this}o.prototype.__proto__=i.prototype,o.prototype.send=function(e){var t=this;t.actionClient.goalTopic.publish(t.goalMessage),e&&setTimeout((function(){t.isFinished||t.emit("timeout")}),e)},o.prototype.cancel=function(){var e=new r({id:this.goalID});this.actionClient.cancelTopic.publish(e)},e.exports=o},"4kuk":function(e,t,n){var r=n("SfRM"),i=n("Hvzi"),o=n("u8Dt"),a=n("ekgI"),s=n("JSQU");function c(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}c.prototype.clear=r,c.prototype.delete=i,c.prototype.get=o,c.prototype.has=a,c.prototype.set=s,e.exports=c},"4qC0":function(e,t,n){var r=n("NykK"),i=n("Z0cm"),o=n("ExA7");e.exports=function(e){return"string"==typeof e||!i(e)&&o(e)&&"[object String]"==r(e)}},"4qRI":function(e,t,n){"use strict";t.a=function(e){var t={};return function(n){return void 0===t[n]&&(t[n]=e(n)),t[n]}}},"4sDh":function(e,t,n){var r=n("4uTw"),i=n("03A+"),o=n("Z0cm"),a=n("wJg7"),s=n("shjB"),c=n("9Nap");e.exports=function(e,t,n){for(var l=-1,u=(t=r(t,e)).length,h=!1;++l<u;){var d=c(t[l]);if(!(h=null!=e&&n(e,d)))break;e=e[d]}return h||++l!=u?h:!!(u=null==e?0:e.length)&&s(u)&&a(d,u)&&(o(e)||i(e))}},"4uTw":function(e,t,n){var r=n("Z0cm"),i=n("9ggG"),o=n("GNiM"),a=n("dt0z");e.exports=function(e,t){return r(e)?e:i(e,t)?[e]:o(a(e))}},"4wl8":function(e,t,n){var r=n("OEc2"),i=n("ACFR");function o(e){e=e||{},this.translation=new r(e.translation),this.rotation=new i(e.rotation)}o.prototype.clone=function(){return new o(this)},e.exports=o},"55cE":function(e,t,n){var r=n("E9ZH");e.exports=function(e){this.type=r.URDF_SPHERE,this.radius=parseFloat(e.xml.getAttribute("radius"))}},"5EqP":function(e,t,n){var r=n("M96O");e.exports=function(e){var t,n={},i=[];function o(i){r.has(n,i)||(n[i]=!0,t.push(i),r.each(e.successors(i),o),r.each(e.predecessors(i),o))}return r.each(e.nodes(),(function(e){t=[],o(e),t.length&&i.push(t)})),i}},"5Tg0":function(e,t,n){(function(e){var r=n("Kz5y"),i=t&&!t.nodeType&&t,o=i&&"object"==typeof e&&e&&!e.nodeType&&e,a=o&&o.exports===i?r.Buffer:void 0,s=a?a.allocUnsafe:void 0;e.exports=function(e,t){if(t)return e.slice();var n=e.length,r=s?s(n):new e.constructor(n);return e.copy(r),r}}).call(this,n("YuTi")(e))},"5jIi":function(e,t,n){"use strict";var r=n("b5wT");e.exports=function(e){var t={},n=r.filter(e.nodes(),(function(t){return!e.children(t).length})),i=r.max(r.map(n,(function(t){return e.node(t).rank}))),o=r.map(r.range(i+1),(function(){return[]}));var a=r.sortBy(n,(function(t){return e.node(t).rank}));return r.forEach(a,(function n(i){if(r.has(t,i))return;t[i]=!0;var a=e.node(i);o[a.rank].push(i),r.forEach(e.successors(i),n)})),o}},"5t69":function(e,t,n){"use strict";var r=n("U6jy"),i=n("P7XM");e.exports=function(e){var t,n,o;for(n in i(s,e),i(a,s),t=s.prototype)(o=t[n])&&"object"==typeof o&&(t[n]="concat"in o?o.concat():r(o));return s;function a(t){return e.apply(this,t)}function s(){return this instanceof s?e.apply(this,arguments):new a(arguments)}}},"6Ekc":function(e,t,n){"use strict";var r=n("b5wT");e.exports={longestPath:function(e){var t={};r.forEach(e.sources(),(function n(i){var o=e.node(i);if(r.has(t,i))return o.rank;t[i]=!0;var a=r.min(r.map(e.outEdges(i),(function(t){return n(t.w)-e.edge(t).minlen})));return a!==Number.POSITIVE_INFINITY&&null!=a||(a=0),o.rank=a}))},slack:function(e,t){return e.node(t.w).rank-e.node(t.v).rank-e.edge(t).minlen}}},"6GvM":function(e,t,n){var r=this.ROSLIB||{REVISION:"1.1.0"},i=n("MgzW");i(r,n("Ivbl")),i(r,n("79nV")),i(r,n("0C9X")),i(r,n("dxEu")),i(r,n("OHWT")),e.exports=r},"6IMF":function(e,t,n){var r=n("PEyx");e.exports=function(e,t){for(var n=e.append("text"),i=function(e){for(var t,n="",r=!1,i=0;i<e.length;++i)if(t=e[i],r){switch(t){case"n":n+="\n";break;default:n+=t}r=!1}else"\\"===t?r=!0:n+=t;return n}(t.label).split("\n"),o=0;o<i.length;o++)n.append("tspan").attr("xml:space","preserve").attr("dy","1em").attr("x","1").text(i[o]);return r.applyStyle(n,t.labelStyle),n}},"6P8j":function(e,t){e.exports.id="ace/mode/json_worker",e.exports.src='"no use strict";!function(window){function resolveModuleId(id,paths){for(var testPath=id,tail="";testPath;){var alias=paths[testPath];if("string"==typeof alias)return alias+tail;if(alias)return alias.location.replace(/\\/*$/,"/")+(tail||alias.main||alias.name);if(alias===!1)return"";var i=testPath.lastIndexOf("/");if(-1===i)break;tail=testPath.substr(i)+tail,testPath=testPath.slice(0,i)}return id}if(!(void 0!==window.window&&window.document||window.acequire&&window.define)){window.console||(window.console=function(){var msgs=Array.prototype.slice.call(arguments,0);postMessage({type:"log",data:msgs})},window.console.error=window.console.warn=window.console.log=window.console.trace=window.console),window.window=window,window.ace=window,window.onerror=function(message,file,line,col,err){postMessage({type:"error",data:{message:message,data:err.data,file:file,line:line,col:col,stack:err.stack}})},window.normalizeModule=function(parentId,moduleName){if(-1!==moduleName.indexOf("!")){var chunks=moduleName.split("!");return window.normalizeModule(parentId,chunks[0])+"!"+window.normalizeModule(parentId,chunks[1])}if("."==moduleName.charAt(0)){var base=parentId.split("/").slice(0,-1).join("/");for(moduleName=(base?base+"/":"")+moduleName;-1!==moduleName.indexOf(".")&&previous!=moduleName;){var previous=moduleName;moduleName=moduleName.replace(/^\\.\\//,"").replace(/\\/\\.\\//,"/").replace(/[^\\/]+\\/\\.\\.\\//,"")}}return moduleName},window.acequire=function acequire(parentId,id){if(id||(id=parentId,parentId=null),!id.charAt)throw Error("worker.js acequire() accepts only (parentId, id) as arguments");id=window.normalizeModule(parentId,id);var module=window.acequire.modules[id];if(module)return module.initialized||(module.initialized=!0,module.exports=module.factory().exports),module.exports;if(!window.acequire.tlns)return console.log("unable to load "+id);var path=resolveModuleId(id,window.acequire.tlns);return".js"!=path.slice(-3)&&(path+=".js"),window.acequire.id=id,window.acequire.modules[id]={},importScripts(path),window.acequire(parentId,id)},window.acequire.modules={},window.acequire.tlns={},window.define=function(id,deps,factory){if(2==arguments.length?(factory=deps,"string"!=typeof id&&(deps=id,id=window.acequire.id)):1==arguments.length&&(factory=id,deps=[],id=window.acequire.id),"function"!=typeof factory)return window.acequire.modules[id]={exports:factory,initialized:!0},void 0;deps.length||(deps=["require","exports","module"]);var req=function(childId){return window.acequire(id,childId)};window.acequire.modules[id]={exports:{},factory:function(){var module=this,returnExports=factory.apply(this,deps.map(function(dep){switch(dep){case"require":return req;case"exports":return module.exports;case"module":return module;default:return req(dep)}}));return returnExports&&(module.exports=returnExports),module}}},window.define.amd={},acequire.tlns={},window.initBaseUrls=function(topLevelNamespaces){for(var i in topLevelNamespaces)acequire.tlns[i]=topLevelNamespaces[i]},window.initSender=function(){var EventEmitter=window.acequire("ace/lib/event_emitter").EventEmitter,oop=window.acequire("ace/lib/oop"),Sender=function(){};return function(){oop.implement(this,EventEmitter),this.callback=function(data,callbackId){postMessage({type:"call",id:callbackId,data:data})},this.emit=function(name,data){postMessage({type:"event",name:name,data:data})}}.call(Sender.prototype),new Sender};var main=window.main=null,sender=window.sender=null;window.onmessage=function(e){var msg=e.data;if(msg.event&&sender)sender._signal(msg.event,msg.data);else if(msg.command)if(main[msg.command])main[msg.command].apply(main,msg.args);else{if(!window[msg.command])throw Error("Unknown command:"+msg.command);window[msg.command].apply(window,msg.args)}else if(msg.init){window.initBaseUrls(msg.tlns),acequire("ace/lib/es5-shim"),sender=window.sender=window.initSender();var clazz=acequire(msg.module)[msg.classname];main=window.main=new clazz(sender)}}}}(this),ace.define("ace/lib/oop",["require","exports","module"],function(acequire,exports){"use strict";exports.inherits=function(ctor,superCtor){ctor.super_=superCtor,ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:!1,writable:!0,configurable:!0}})},exports.mixin=function(obj,mixin){for(var key in mixin)obj[key]=mixin[key];return obj},exports.implement=function(proto,mixin){exports.mixin(proto,mixin)}}),ace.define("ace/range",["require","exports","module"],function(acequire,exports){"use strict";var comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},Range=function(startRow,startColumn,endRow,endColumn){this.start={row:startRow,column:startColumn},this.end={row:endRow,column:endColumn}};(function(){this.isEqual=function(range){return this.start.row===range.start.row&&this.end.row===range.end.row&&this.start.column===range.start.column&&this.end.column===range.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(row,column){return 0==this.compare(row,column)},this.compareRange=function(range){var cmp,end=range.end,start=range.start;return cmp=this.compare(end.row,end.column),1==cmp?(cmp=this.compare(start.row,start.column),1==cmp?2:0==cmp?1:0):-1==cmp?-2:(cmp=this.compare(start.row,start.column),-1==cmp?-1:1==cmp?42:0)},this.comparePoint=function(p){return this.compare(p.row,p.column)},this.containsRange=function(range){return 0==this.comparePoint(range.start)&&0==this.comparePoint(range.end)},this.intersects=function(range){var cmp=this.compareRange(range);return-1==cmp||0==cmp||1==cmp},this.isEnd=function(row,column){return this.end.row==row&&this.end.column==column},this.isStart=function(row,column){return this.start.row==row&&this.start.column==column},this.setStart=function(row,column){"object"==typeof row?(this.start.column=row.column,this.start.row=row.row):(this.start.row=row,this.start.column=column)},this.setEnd=function(row,column){"object"==typeof row?(this.end.column=row.column,this.end.row=row.row):(this.end.row=row,this.end.column=column)},this.inside=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)||this.isStart(row,column)?!1:!0:!1},this.insideStart=function(row,column){return 0==this.compare(row,column)?this.isEnd(row,column)?!1:!0:!1},this.insideEnd=function(row,column){return 0==this.compare(row,column)?this.isStart(row,column)?!1:!0:!1},this.compare=function(row,column){return this.isMultiLine()||row!==this.start.row?this.start.row>row?-1:row>this.end.row?1:this.start.row===row?column>=this.start.column?0:-1:this.end.row===row?this.end.column>=column?0:1:0:this.start.column>column?-1:column>this.end.column?1:0},this.compareStart=function(row,column){return this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.compareEnd=function(row,column){return this.end.row==row&&this.end.column==column?1:this.compare(row,column)},this.compareInside=function(row,column){return this.end.row==row&&this.end.column==column?1:this.start.row==row&&this.start.column==column?-1:this.compare(row,column)},this.clipRows=function(firstRow,lastRow){if(this.end.row>lastRow)var end={row:lastRow+1,column:0};else if(firstRow>this.end.row)var end={row:firstRow,column:0};if(this.start.row>lastRow)var start={row:lastRow+1,column:0};else if(firstRow>this.start.row)var start={row:firstRow,column:0};return Range.fromPoints(start||this.start,end||this.end)},this.extend=function(row,column){var cmp=this.compare(row,column);if(0==cmp)return this;if(-1==cmp)var start={row:row,column:column};else var end={row:row,column:column};return Range.fromPoints(start||this.start,end||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return Range.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new Range(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new Range(this.start.row,0,this.end.row,0)},this.toScreenRange=function(session){var screenPosStart=session.documentToScreenPosition(this.start),screenPosEnd=session.documentToScreenPosition(this.end);return new Range(screenPosStart.row,screenPosStart.column,screenPosEnd.row,screenPosEnd.column)},this.moveBy=function(row,column){this.start.row+=row,this.start.column+=column,this.end.row+=row,this.end.column+=column}}).call(Range.prototype),Range.fromPoints=function(start,end){return new Range(start.row,start.column,end.row,end.column)},Range.comparePoints=comparePoints,Range.comparePoints=function(p1,p2){return p1.row-p2.row||p1.column-p2.column},exports.Range=Range}),ace.define("ace/apply_delta",["require","exports","module"],function(acequire,exports){"use strict";exports.applyDelta=function(docLines,delta){var row=delta.start.row,startColumn=delta.start.column,line=docLines[row]||"";switch(delta.action){case"insert":var lines=delta.lines;if(1===lines.length)docLines[row]=line.substring(0,startColumn)+delta.lines[0]+line.substring(startColumn);else{var args=[row,1].concat(delta.lines);docLines.splice.apply(docLines,args),docLines[row]=line.substring(0,startColumn)+docLines[row],docLines[row+delta.lines.length-1]+=line.substring(startColumn)}break;case"remove":var endColumn=delta.end.column,endRow=delta.end.row;row===endRow?docLines[row]=line.substring(0,startColumn)+line.substring(endColumn):docLines.splice(row,endRow-row+1,line.substring(0,startColumn)+docLines[endRow].substring(endColumn))}}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(acequire,exports){"use strict";var EventEmitter={},stopPropagation=function(){this.propagationStopped=!0},preventDefault=function(){this.defaultPrevented=!0};EventEmitter._emit=EventEmitter._dispatchEvent=function(eventName,e){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var listeners=this._eventRegistry[eventName]||[],defaultHandler=this._defaultHandlers[eventName];if(listeners.length||defaultHandler){"object"==typeof e&&e||(e={}),e.type||(e.type=eventName),e.stopPropagation||(e.stopPropagation=stopPropagation),e.preventDefault||(e.preventDefault=preventDefault),listeners=listeners.slice();for(var i=0;listeners.length>i&&(listeners[i](e,this),!e.propagationStopped);i++);return defaultHandler&&!e.defaultPrevented?defaultHandler(e,this):void 0}},EventEmitter._signal=function(eventName,e){var listeners=(this._eventRegistry||{})[eventName];if(listeners){listeners=listeners.slice();for(var i=0;listeners.length>i;i++)listeners[i](e,this)}},EventEmitter.once=function(eventName,callback){var _self=this;callback&&this.addEventListener(eventName,function newCallback(){_self.removeEventListener(eventName,newCallback),callback.apply(null,arguments)})},EventEmitter.setDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers||(handlers=this._defaultHandlers={_disabled_:{}}),handlers[eventName]){var old=handlers[eventName],disabled=handlers._disabled_[eventName];disabled||(handlers._disabled_[eventName]=disabled=[]),disabled.push(old);var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}handlers[eventName]=callback},EventEmitter.removeDefaultHandler=function(eventName,callback){var handlers=this._defaultHandlers;if(handlers){var disabled=handlers._disabled_[eventName];if(handlers[eventName]==callback)handlers[eventName],disabled&&this.setDefaultHandler(eventName,disabled.pop());else if(disabled){var i=disabled.indexOf(callback);-1!=i&&disabled.splice(i,1)}}},EventEmitter.on=EventEmitter.addEventListener=function(eventName,callback,capturing){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];return listeners||(listeners=this._eventRegistry[eventName]=[]),-1==listeners.indexOf(callback)&&listeners[capturing?"unshift":"push"](callback),callback},EventEmitter.off=EventEmitter.removeListener=EventEmitter.removeEventListener=function(eventName,callback){this._eventRegistry=this._eventRegistry||{};var listeners=this._eventRegistry[eventName];if(listeners){var index=listeners.indexOf(callback);-1!==index&&listeners.splice(index,1)}},EventEmitter.removeAllListeners=function(eventName){this._eventRegistry&&(this._eventRegistry[eventName]=[])},exports.EventEmitter=EventEmitter}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),EventEmitter=acequire("./lib/event_emitter").EventEmitter,Anchor=exports.Anchor=function(doc,row,column){this.$onChange=this.onChange.bind(this),this.attach(doc),column===void 0?this.setPosition(row.row,row.column):this.setPosition(row,column)};(function(){function $pointsInOrder(point1,point2,equalPointsInOrder){var bColIsAfter=equalPointsInOrder?point1.column<=point2.column:point1.column<point2.column;return point1.row<point2.row||point1.row==point2.row&&bColIsAfter}function $getTransformedPoint(delta,point,moveIfEqual){var deltaIsInsert="insert"==delta.action,deltaRowShift=(deltaIsInsert?1:-1)*(delta.end.row-delta.start.row),deltaColShift=(deltaIsInsert?1:-1)*(delta.end.column-delta.start.column),deltaStart=delta.start,deltaEnd=deltaIsInsert?deltaStart:delta.end;return $pointsInOrder(point,deltaStart,moveIfEqual)?{row:point.row,column:point.column}:$pointsInOrder(deltaEnd,point,!moveIfEqual)?{row:point.row+deltaRowShift,column:point.column+(point.row==deltaEnd.row?deltaColShift:0)}:{row:deltaStart.row,column:deltaStart.column}}oop.implement(this,EventEmitter),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(delta){if(!(delta.start.row==delta.end.row&&delta.start.row!=this.row||delta.start.row>this.row)){var point=$getTransformedPoint(delta,{row:this.row,column:this.column},this.$insertRight);this.setPosition(point.row,point.column,!0)}},this.setPosition=function(row,column,noClip){var pos;if(pos=noClip?{row:row,column:column}:this.$clipPositionToDocument(row,column),this.row!=pos.row||this.column!=pos.column){var old={row:this.row,column:this.column};this.row=pos.row,this.column=pos.column,this._signal("change",{old:old,value:pos})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(doc){this.document=doc||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(row,column){var pos={};return row>=this.document.getLength()?(pos.row=Math.max(0,this.document.getLength()-1),pos.column=this.document.getLine(pos.row).length):0>row?(pos.row=0,pos.column=0):(pos.row=row,pos.column=Math.min(this.document.getLine(pos.row).length,Math.max(0,column))),0>column&&(pos.column=0),pos}}).call(Anchor.prototype)}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(acequire,exports){"use strict";var oop=acequire("./lib/oop"),applyDelta=acequire("./apply_delta").applyDelta,EventEmitter=acequire("./lib/event_emitter").EventEmitter,Range=acequire("./range").Range,Anchor=acequire("./anchor").Anchor,Document=function(textOrLines){this.$lines=[""],0===textOrLines.length?this.$lines=[""]:Array.isArray(textOrLines)?this.insertMergedLines({row:0,column:0},textOrLines):this.insert({row:0,column:0},textOrLines)};(function(){oop.implement(this,EventEmitter),this.setValue=function(text){var len=this.getLength()-1;this.remove(new Range(0,0,len,this.getLine(len).length)),this.insert({row:0,column:0},text)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(row,column){return new Anchor(this,row,column)},this.$split=0==="aaa".split(/a/).length?function(text){return text.replace(/\\r\\n|\\r/g,"\\n").split("\\n")}:function(text){return text.split(/\\r\\n|\\r|\\n/)},this.$detectNewLine=function(text){var match=text.match(/^.*?(\\r\\n|\\r|\\n)/m);this.$autoNewLine=match?match[1]:"\\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\\r\\n";case"unix":return"\\n";default:return this.$autoNewLine||"\\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(newLineMode){this.$newLineMode!==newLineMode&&(this.$newLineMode=newLineMode,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(text){return"\\r\\n"==text||"\\r"==text||"\\n"==text},this.getLine=function(row){return this.$lines[row]||""},this.getLines=function(firstRow,lastRow){return this.$lines.slice(firstRow,lastRow+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(range){return this.getLinesForRange(range).join(this.getNewLineCharacter())},this.getLinesForRange=function(range){var lines;if(range.start.row===range.end.row)lines=[this.getLine(range.start.row).substring(range.start.column,range.end.column)];else{lines=this.getLines(range.start.row,range.end.row),lines[0]=(lines[0]||"").substring(range.start.column);var l=lines.length-1;range.end.row-range.start.row==l&&(lines[l]=lines[l].substring(0,range.end.column))}return lines},this.insertLines=function(row,lines){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(row,lines)},this.removeLines=function(firstRow,lastRow){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(firstRow,lastRow)},this.insertNewLine=function(position){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, [\'\', \'\']) instead."),this.insertMergedLines(position,["",""])},this.insert=function(position,text){return 1>=this.getLength()&&this.$detectNewLine(text),this.insertMergedLines(position,this.$split(text))},this.insertInLine=function(position,text){var start=this.clippedPos(position.row,position.column),end=this.pos(position.row,position.column+text.length);return this.applyDelta({start:start,end:end,action:"insert",lines:[text]},!0),this.clonePos(end)},this.clippedPos=function(row,column){var length=this.getLength();void 0===row?row=length:0>row?row=0:row>=length&&(row=length-1,column=void 0);var line=this.getLine(row);return void 0==column&&(column=line.length),column=Math.min(Math.max(column,0),line.length),{row:row,column:column}},this.clonePos=function(pos){return{row:pos.row,column:pos.column}},this.pos=function(row,column){return{row:row,column:column}},this.$clipPosition=function(position){var length=this.getLength();return position.row>=length?(position.row=Math.max(0,length-1),position.column=this.getLine(length-1).length):(position.row=Math.max(0,position.row),position.column=Math.min(Math.max(position.column,0),this.getLine(position.row).length)),position},this.insertFullLines=function(row,lines){row=Math.min(Math.max(row,0),this.getLength());var column=0;this.getLength()>row?(lines=lines.concat([""]),column=0):(lines=[""].concat(lines),row--,column=this.$lines[row].length),this.insertMergedLines({row:row,column:column},lines)},this.insertMergedLines=function(position,lines){var start=this.clippedPos(position.row,position.column),end={row:start.row+lines.length-1,column:(1==lines.length?start.column:0)+lines[lines.length-1].length};return this.applyDelta({start:start,end:end,action:"insert",lines:lines}),this.clonePos(end)},this.remove=function(range){var start=this.clippedPos(range.start.row,range.start.column),end=this.clippedPos(range.end.row,range.end.column);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})}),this.clonePos(start)},this.removeInLine=function(row,startColumn,endColumn){var start=this.clippedPos(row,startColumn),end=this.clippedPos(row,endColumn);return this.applyDelta({start:start,end:end,action:"remove",lines:this.getLinesForRange({start:start,end:end})},!0),this.clonePos(start)},this.removeFullLines=function(firstRow,lastRow){firstRow=Math.min(Math.max(0,firstRow),this.getLength()-1),lastRow=Math.min(Math.max(0,lastRow),this.getLength()-1);var deleteFirstNewLine=lastRow==this.getLength()-1&&firstRow>0,deleteLastNewLine=this.getLength()-1>lastRow,startRow=deleteFirstNewLine?firstRow-1:firstRow,startCol=deleteFirstNewLine?this.getLine(startRow).length:0,endRow=deleteLastNewLine?lastRow+1:lastRow,endCol=deleteLastNewLine?0:this.getLine(endRow).length,range=new Range(startRow,startCol,endRow,endCol),deletedLines=this.$lines.slice(firstRow,lastRow+1);return this.applyDelta({start:range.start,end:range.end,action:"remove",lines:this.getLinesForRange(range)}),deletedLines},this.removeNewLine=function(row){this.getLength()-1>row&&row>=0&&this.applyDelta({start:this.pos(row,this.getLine(row).length),end:this.pos(row+1,0),action:"remove",lines:["",""]})},this.replace=function(range,text){if(range instanceof Range||(range=Range.fromPoints(range.start,range.end)),0===text.length&&range.isEmpty())return range.start;if(text==this.getTextRange(range))return range.end;this.remove(range);var end;return end=text?this.insert(range.start,text):range.start},this.applyDeltas=function(deltas){for(var i=0;deltas.length>i;i++)this.applyDelta(deltas[i])},this.revertDeltas=function(deltas){for(var i=deltas.length-1;i>=0;i--)this.revertDelta(deltas[i])},this.applyDelta=function(delta,doNotValidate){var isInsert="insert"==delta.action;(isInsert?1>=delta.lines.length&&!delta.lines[0]:!Range.comparePoints(delta.start,delta.end))||(isInsert&&delta.lines.length>2e4&&this.$splitAndapplyLargeDelta(delta,2e4),applyDelta(this.$lines,delta,doNotValidate),this._signal("change",delta))},this.$splitAndapplyLargeDelta=function(delta,MAX){for(var lines=delta.lines,l=lines.length,row=delta.start.row,column=delta.start.column,from=0,to=0;;){from=to,to+=MAX-1;var chunk=lines.slice(from,to);if(to>l){delta.lines=chunk,delta.start.row=row+from,delta.start.column=column;break}chunk.push(""),this.applyDelta({start:this.pos(row+from,column),end:this.pos(row+to,column=0),action:delta.action,lines:chunk},!0)}},this.revertDelta=function(delta){this.applyDelta({start:this.clonePos(delta.start),end:this.clonePos(delta.end),action:"insert"==delta.action?"remove":"insert",lines:delta.lines.slice()})},this.indexToPosition=function(index,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,i=startRow||0,l=lines.length;l>i;i++)if(index-=lines[i].length+newlineLength,0>index)return{row:i,column:index+lines[i].length+newlineLength};return{row:l-1,column:lines[l-1].length}},this.positionToIndex=function(pos,startRow){for(var lines=this.$lines||this.getAllLines(),newlineLength=this.getNewLineCharacter().length,index=0,row=Math.min(pos.row,lines.length),i=startRow||0;row>i;++i)index+=lines[i].length+newlineLength;return index+pos.column}}).call(Document.prototype),exports.Document=Document}),ace.define("ace/lib/lang",["require","exports","module"],function(acequire,exports){"use strict";exports.last=function(a){return a[a.length-1]},exports.stringReverse=function(string){return string.split("").reverse().join("")},exports.stringRepeat=function(string,count){for(var result="";count>0;)1&count&&(result+=string),(count>>=1)&&(string+=string);return result};var trimBeginRegexp=/^\\s\\s*/,trimEndRegexp=/\\s\\s*$/;exports.stringTrimLeft=function(string){return string.replace(trimBeginRegexp,"")},exports.stringTrimRight=function(string){return string.replace(trimEndRegexp,"")},exports.copyObject=function(obj){var copy={};for(var key in obj)copy[key]=obj[key];return copy},exports.copyArray=function(array){for(var copy=[],i=0,l=array.length;l>i;i++)copy[i]=array[i]&&"object"==typeof array[i]?this.copyObject(array[i]):array[i];return copy},exports.deepCopy=function deepCopy(obj){if("object"!=typeof obj||!obj)return obj;var copy;if(Array.isArray(obj)){copy=[];for(var key=0;obj.length>key;key++)copy[key]=deepCopy(obj[key]);return copy}if("[object Object]"!==Object.prototype.toString.call(obj))return obj;copy={};for(var key in obj)copy[key]=deepCopy(obj[key]);return copy},exports.arrayToMap=function(arr){for(var map={},i=0;arr.length>i;i++)map[arr[i]]=1;return map},exports.createMap=function(props){var map=Object.create(null);for(var i in props)map[i]=props[i];return map},exports.arrayRemove=function(array,value){for(var i=0;array.length>=i;i++)value===array[i]&&array.splice(i,1)},exports.escapeRegExp=function(str){return str.replace(/([.*+?^${}()|[\\]\\/\\\\])/g,"\\\\$1")},exports.escapeHTML=function(str){return str.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/\'/g,"&#39;").replace(/</g,"&#60;")},exports.getMatchOffsets=function(string,regExp){var matches=[];return string.replace(regExp,function(str){matches.push({offset:arguments[arguments.length-2],length:str.length})}),matches},exports.deferredCall=function(fcn){var timer=null,callback=function(){timer=null,fcn()},deferred=function(timeout){return deferred.cancel(),timer=setTimeout(callback,timeout||0),deferred};return deferred.schedule=deferred,deferred.call=function(){return this.cancel(),fcn(),deferred},deferred.cancel=function(){return clearTimeout(timer),timer=null,deferred},deferred.isPending=function(){return timer},deferred},exports.delayedCall=function(fcn,defaultTimeout){var timer=null,callback=function(){timer=null,fcn()},_self=function(timeout){null==timer&&(timer=setTimeout(callback,timeout||defaultTimeout))};return _self.delay=function(timeout){timer&&clearTimeout(timer),timer=setTimeout(callback,timeout||defaultTimeout)},_self.schedule=_self,_self.call=function(){this.cancel(),fcn()},_self.cancel=function(){timer&&clearTimeout(timer),timer=null},_self.isPending=function(){return timer},_self}}),ace.define("ace/worker/mirror",["require","exports","module","ace/range","ace/document","ace/lib/lang"],function(acequire,exports){"use strict";acequire("../range").Range;var Document=acequire("../document").Document,lang=acequire("../lib/lang"),Mirror=exports.Mirror=function(sender){this.sender=sender;var doc=this.doc=new Document(""),deferredUpdate=this.deferredUpdate=lang.delayedCall(this.onUpdate.bind(this)),_self=this;sender.on("change",function(e){var data=e.data;if(data[0].start)doc.applyDeltas(data);else for(var i=0;data.length>i;i+=2){if(Array.isArray(data[i+1]))var d={action:"insert",start:data[i],lines:data[i+1]};else var d={action:"remove",start:data[i],end:data[i+1]};doc.applyDelta(d,!0)}return _self.$timeout?deferredUpdate.schedule(_self.$timeout):(_self.onUpdate(),void 0)})};(function(){this.$timeout=500,this.setTimeout=function(timeout){this.$timeout=timeout},this.setValue=function(value){this.doc.setValue(value),this.deferredUpdate.schedule(this.$timeout)},this.getValue=function(callbackId){this.sender.callback(this.doc.getValue(),callbackId)},this.onUpdate=function(){},this.isPending=function(){return this.deferredUpdate.isPending()}}).call(Mirror.prototype)}),ace.define("ace/mode/json/json_parse",["require","exports","module"],function(){"use strict";var at,ch,text,value,escapee={\'"\':\'"\',"\\\\":"\\\\","/":"/",b:"\\b",f:"\\f",n:"\\n",r:"\\r",t:"\t"},error=function(m){throw{name:"SyntaxError",message:m,at:at,text:text}},next=function(c){return c&&c!==ch&&error("Expected \'"+c+"\' instead of \'"+ch+"\'"),ch=text.charAt(at),at+=1,ch},number=function(){var number,string="";for("-"===ch&&(string="-",next("-"));ch>="0"&&"9">=ch;)string+=ch,next();if("."===ch)for(string+=".";next()&&ch>="0"&&"9">=ch;)string+=ch;if("e"===ch||"E"===ch)for(string+=ch,next(),("-"===ch||"+"===ch)&&(string+=ch,next());ch>="0"&&"9">=ch;)string+=ch,next();return number=+string,isNaN(number)?(error("Bad number"),void 0):number},string=function(){var hex,i,uffff,string="";if(\'"\'===ch)for(;next();){if(\'"\'===ch)return next(),string;if("\\\\"===ch)if(next(),"u"===ch){for(uffff=0,i=0;4>i&&(hex=parseInt(next(),16),isFinite(hex));i+=1)uffff=16*uffff+hex;string+=String.fromCharCode(uffff)}else{if("string"!=typeof escapee[ch])break;string+=escapee[ch]}else string+=ch}error("Bad string")},white=function(){for(;ch&&" ">=ch;)next()},word=function(){switch(ch){case"t":return next("t"),next("r"),next("u"),next("e"),!0;case"f":return next("f"),next("a"),next("l"),next("s"),next("e"),!1;case"n":return next("n"),next("u"),next("l"),next("l"),null}error("Unexpected \'"+ch+"\'")},array=function(){var array=[];if("["===ch){if(next("["),white(),"]"===ch)return next("]"),array;for(;ch;){if(array.push(value()),white(),"]"===ch)return next("]"),array;next(","),white()}}error("Bad array")},object=function(){var key,object={};if("{"===ch){if(next("{"),white(),"}"===ch)return next("}"),object;for(;ch;){if(key=string(),white(),next(":"),Object.hasOwnProperty.call(object,key)&&error(\'Duplicate key "\'+key+\'"\'),object[key]=value(),white(),"}"===ch)return next("}"),object;next(","),white()}}error("Bad object")};return value=function(){switch(white(),ch){case"{":return object();case"[":return array();case\'"\':return string();case"-":return number();default:return ch>="0"&&"9">=ch?number():word()}},function(source,reviver){var result;return text=source,at=0,ch=" ",result=value(),white(),ch&&error("Syntax error"),"function"==typeof reviver?function walk(holder,key){var k,v,value=holder[key];if(value&&"object"==typeof value)for(k in value)Object.hasOwnProperty.call(value,k)&&(v=walk(value,k),void 0!==v?value[k]=v:delete value[k]);return reviver.call(holder,key,value)}({"":result},""):result}}),ace.define("ace/mode/json_worker",["require","exports","module","ace/lib/oop","ace/worker/mirror","ace/mode/json/json_parse"],function(acequire,exports){"use strict";var oop=acequire("../lib/oop"),Mirror=acequire("../worker/mirror").Mirror,parse=acequire("./json/json_parse"),JsonWorker=exports.JsonWorker=function(sender){Mirror.call(this,sender),this.setTimeout(200)};oop.inherits(JsonWorker,Mirror),function(){this.onUpdate=function(){var value=this.doc.getValue(),errors=[];try{value&&parse(value)}catch(e){var pos=this.doc.indexToPosition(e.at-1);errors.push({row:pos.row,column:pos.column,text:e.message,type:"error"})}this.sender.emit("annotate",errors)}}.call(JsonWorker.prototype)}),ace.define("ace/lib/es5-shim",["require","exports","module"],function(){function Empty(){}function doesDefinePropertyWork(object){try{return Object.defineProperty(object,"sentinel",{}),"sentinel"in object}catch(exception){}}function toInteger(n){return n=+n,n!==n?n=0:0!==n&&n!==1/0&&n!==-(1/0)&&(n=(n>0||-1)*Math.floor(Math.abs(n))),n}Function.prototype.bind||(Function.prototype.bind=function(that){var target=this;if("function"!=typeof target)throw new TypeError("Function.prototype.bind called on incompatible "+target);var args=slice.call(arguments,1),bound=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));return Object(result)===result?result:this}return target.apply(that,args.concat(slice.call(arguments)))};return target.prototype&&(Empty.prototype=target.prototype,bound.prototype=new Empty,Empty.prototype=null),bound});var defineGetter,defineSetter,lookupGetter,lookupSetter,supportsAccessors,call=Function.prototype.call,prototypeOfArray=Array.prototype,prototypeOfObject=Object.prototype,slice=prototypeOfArray.slice,_toString=call.bind(prototypeOfObject.toString),owns=call.bind(prototypeOfObject.hasOwnProperty);if((supportsAccessors=owns(prototypeOfObject,"__defineGetter__"))&&(defineGetter=call.bind(prototypeOfObject.__defineGetter__),defineSetter=call.bind(prototypeOfObject.__defineSetter__),lookupGetter=call.bind(prototypeOfObject.__lookupGetter__),lookupSetter=call.bind(prototypeOfObject.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function makeArray(l){var a=Array(l+2);return a[0]=a[1]=0,a}var lengthBefore,array=[];return array.splice.apply(array,makeArray(20)),array.splice.apply(array,makeArray(26)),lengthBefore=array.length,array.splice(5,0,"XXX"),lengthBefore+1==array.length,lengthBefore+1==array.length?!0:void 0\n}()){var array_splice=Array.prototype.splice;Array.prototype.splice=function(start,deleteCount){return arguments.length?array_splice.apply(this,[void 0===start?0:start,void 0===deleteCount?this.length-start:deleteCount].concat(slice.call(arguments,2))):[]}}else Array.prototype.splice=function(pos,removeCount){var length=this.length;pos>0?pos>length&&(pos=length):void 0==pos?pos=0:0>pos&&(pos=Math.max(length+pos,0)),length>pos+removeCount||(removeCount=length-pos);var removed=this.slice(pos,pos+removeCount),insert=slice.call(arguments,2),add=insert.length;if(pos===length)add&&this.push.apply(this,insert);else{var remove=Math.min(removeCount,length-pos),tailOldPos=pos+remove,tailNewPos=tailOldPos+add-remove,tailCount=length-tailOldPos,lengthAfterRemove=length-remove;if(tailOldPos>tailNewPos)for(var i=0;tailCount>i;++i)this[tailNewPos+i]=this[tailOldPos+i];else if(tailNewPos>tailOldPos)for(i=tailCount;i--;)this[tailNewPos+i]=this[tailOldPos+i];if(add&&pos===lengthAfterRemove)this.length=lengthAfterRemove,this.push.apply(this,insert);else for(this.length=lengthAfterRemove+add,i=0;add>i;++i)this[pos+i]=insert[i]}return removed};Array.isArray||(Array.isArray=function(obj){return"[object Array]"==_toString(obj)});var boxedString=Object("a"),splitString="a"!=boxedString[0]||!(0 in boxedString);if(Array.prototype.forEach||(Array.prototype.forEach=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,thisp=arguments[1],i=-1,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError;for(;length>++i;)i in self&&fun.call(thisp,self[i],i,object)}),Array.prototype.map||(Array.prototype.map=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=Array(length),thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(result[i]=fun.call(thisp,self[i],i,object));return result}),Array.prototype.filter||(Array.prototype.filter=function(fun){var value,object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,result=[],thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)i in self&&(value=self[i],fun.call(thisp,value,i,object)&&result.push(value));return result}),Array.prototype.every||(Array.prototype.every=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&!fun.call(thisp,self[i],i,object))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0,thisp=arguments[1];if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");for(var i=0;length>i;i++)if(i in self&&fun.call(thisp,self[i],i,object))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var result,i=0;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i++];break}if(++i>=length)throw new TypeError("reduce of empty array with no initial value")}for(;length>i;i++)i in self&&(result=fun.call(void 0,result,self[i],i,object));return result}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(fun){var object=toObject(this),self=splitString&&"[object String]"==_toString(this)?this.split(""):object,length=self.length>>>0;if("[object Function]"!=_toString(fun))throw new TypeError(fun+" is not a function");if(!length&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var result,i=length-1;if(arguments.length>=2)result=arguments[1];else for(;;){if(i in self){result=self[i--];break}if(0>--i)throw new TypeError("reduceRight of empty array with no initial value")}do i in this&&(result=fun.call(void 0,result,self[i],i,object));while(i--);return result}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=0;for(arguments.length>1&&(i=toInteger(arguments[1])),i=i>=0?i:Math.max(0,length+i);length>i;i++)if(i in self&&self[i]===sought)return i;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(sought){var self=splitString&&"[object String]"==_toString(this)?this.split(""):toObject(this),length=self.length>>>0;if(!length)return-1;var i=length-1;for(arguments.length>1&&(i=Math.min(i,toInteger(arguments[1]))),i=i>=0?i:length-Math.abs(i);i>=0;i--)if(i in self&&sought===self[i])return i;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(object){return object.__proto__||(object.constructor?object.constructor.prototype:prototypeOfObject)}),!Object.getOwnPropertyDescriptor){var ERR_NON_OBJECT="Object.getOwnPropertyDescriptor called on a non-object: ";Object.getOwnPropertyDescriptor=function(object,property){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT+object);if(owns(object,property)){var descriptor,getter,setter;if(descriptor={enumerable:!0,configurable:!0},supportsAccessors){var prototype=object.__proto__;object.__proto__=prototypeOfObject;var getter=lookupGetter(object,property),setter=lookupSetter(object,property);if(object.__proto__=prototype,getter||setter)return getter&&(descriptor.get=getter),setter&&(descriptor.set=setter),descriptor}return descriptor.value=object[property],descriptor}}}if(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(object){return Object.keys(object)}),!Object.create){var createEmpty;createEmpty=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var empty={};for(var i in empty)empty[i]=null;return empty.constructor=empty.hasOwnProperty=empty.propertyIsEnumerable=empty.isPrototypeOf=empty.toLocaleString=empty.toString=empty.valueOf=empty.__proto__=null,empty},Object.create=function(prototype,properties){var object;if(null===prototype)object=createEmpty();else{if("object"!=typeof prototype)throw new TypeError("typeof prototype["+typeof prototype+"] != \'object\'");var Type=function(){};Type.prototype=prototype,object=new Type,object.__proto__=prototype}return void 0!==properties&&Object.defineProperties(object,properties),object}}if(Object.defineProperty){var definePropertyWorksOnObject=doesDefinePropertyWork({}),definePropertyWorksOnDom="undefined"==typeof document||doesDefinePropertyWork(document.createElement("div"));if(!definePropertyWorksOnObject||!definePropertyWorksOnDom)var definePropertyFallback=Object.defineProperty}if(!Object.defineProperty||definePropertyFallback){var ERR_NON_OBJECT_DESCRIPTOR="Property description must be an object: ",ERR_NON_OBJECT_TARGET="Object.defineProperty called on non-object: ",ERR_ACCESSORS_NOT_SUPPORTED="getters & setters can not be defined on this javascript engine";Object.defineProperty=function(object,property,descriptor){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError(ERR_NON_OBJECT_TARGET+object);if("object"!=typeof descriptor&&"function"!=typeof descriptor||null===descriptor)throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR+descriptor);if(definePropertyFallback)try{return definePropertyFallback.call(Object,object,property,descriptor)}catch(exception){}if(owns(descriptor,"value"))if(supportsAccessors&&(lookupGetter(object,property)||lookupSetter(object,property))){var prototype=object.__proto__;object.__proto__=prototypeOfObject,delete object[property],object[property]=descriptor.value,object.__proto__=prototype}else object[property]=descriptor.value;else{if(!supportsAccessors)throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);owns(descriptor,"get")&&defineGetter(object,property,descriptor.get),owns(descriptor,"set")&&defineSetter(object,property,descriptor.set)}return object}}Object.defineProperties||(Object.defineProperties=function(object,properties){for(var property in properties)owns(properties,property)&&Object.defineProperty(object,property,properties[property]);return object}),Object.seal||(Object.seal=function(object){return object}),Object.freeze||(Object.freeze=function(object){return object});try{Object.freeze(function(){})}catch(exception){Object.freeze=function(freezeObject){return function(object){return"function"==typeof object?object:freezeObject(object)}}(Object.freeze)}if(Object.preventExtensions||(Object.preventExtensions=function(object){return object}),Object.isSealed||(Object.isSealed=function(){return!1}),Object.isFrozen||(Object.isFrozen=function(){return!1}),Object.isExtensible||(Object.isExtensible=function(object){if(Object(object)===object)throw new TypeError;for(var name="";owns(object,name);)name+="?";object[name]=!0;var returnValue=owns(object,name);return delete object[name],returnValue}),!Object.keys){var hasDontEnumBug=!0,dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],dontEnumsLength=dontEnums.length;for(var key in{toString:null})hasDontEnumBug=!1;Object.keys=function(object){if("object"!=typeof object&&"function"!=typeof object||null===object)throw new TypeError("Object.keys called on a non-object");var keys=[];for(var name in object)owns(object,name)&&keys.push(name);if(hasDontEnumBug)for(var i=0,ii=dontEnumsLength;ii>i;i++){var dontEnum=dontEnums[i];owns(object,dontEnum)&&keys.push(dontEnum)}return keys}}Date.now||(Date.now=function(){return(new Date).getTime()});var ws="\t\\n\v\\f\\r   ᠎             　\\u2028\\u2029\ufeff";if(!String.prototype.trim||ws.trim()){ws="["+ws+"]";var trimBeginRegexp=RegExp("^"+ws+ws+"*"),trimEndRegexp=RegExp(ws+ws+"*$");String.prototype.trim=function(){return(this+"").replace(trimBeginRegexp,"").replace(trimEndRegexp,"")}}var toObject=function(o){if(null==o)throw new TypeError("can\'t convert "+o+" to object");return Object(o)}});'},"6dBs":function(e,t,n){"use strict";var r=Object.prototype.hasOwnProperty,i=Object.prototype.toString,o=Object.defineProperty,a=Object.getOwnPropertyDescriptor,s=function(e){return"function"==typeof Array.isArray?Array.isArray(e):"[object Array]"===i.call(e)},c=function(e){if(!e||"[object Object]"!==i.call(e))return!1;var t,n=r.call(e,"constructor"),o=e.constructor&&e.constructor.prototype&&r.call(e.constructor.prototype,"isPrototypeOf");if(e.constructor&&!n&&!o)return!1;for(t in e);return void 0===t||r.call(e,t)},l=function(e,t){o&&"__proto__"===t.name?o(e,t.name,{enumerable:!0,configurable:!0,value:t.newValue,writable:!0}):e[t.name]=t.newValue},u=function(e,t){if("__proto__"===t){if(!r.call(e,t))return;if(a)return a(e,t).value}return e[t]};e.exports=function e(){var t,n,r,i,o,a,h=arguments[0],d=1,f=arguments.length,p=!1;for("boolean"==typeof h&&(p=h,h=arguments[1]||{},d=2),(null==h||"object"!=typeof h&&"function"!=typeof h)&&(h={});d<f;++d)if(null!=(t=arguments[d]))for(n in t)r=u(h,n),h!==(i=u(t,n))&&(p&&i&&(c(i)||(o=s(i)))?(o?(o=!1,a=r&&s(r)?r:[]):a=r&&c(r)?r:{},l(h,{name:n,newValue:e(p,a,i)})):void 0!==i&&l(h,{name:n,newValue:i}));return h}},"6sVZ":function(e,t){var n=Object.prototype;e.exports=function(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||n)}},"711d":function(e,t){e.exports=function(e){return function(t){return null==t?void 0:t[e]}}},"75pU":function(e,t){function n(e,t,n,r){var i,o=null==(i=r)||"number"==typeof i||"boolean"==typeof i?r:n(r),a=t.get(o);return void 0===a&&(a=e.call(this,r),t.set(o,a)),a}function r(e,t,n){var r=Array.prototype.slice.call(arguments,3),i=n(r),o=t.get(i);return void 0===o&&(o=e.apply(this,r),t.set(i,o)),o}function i(e,t,n,r,i){return n.bind(t,e,r,i)}function o(e,t){return i(e,this,1===e.length?n:r,t.cache.create(),t.serializer)}function a(){return JSON.stringify(arguments)}function s(){this.cache=Object.create(null)}s.prototype.has=function(e){return e in this.cache},s.prototype.get=function(e){return this.cache[e]},s.prototype.set=function(e,t){this.cache[e]=t};var c={create:function(){return new s}};e.exports=function(e,t){var n=t&&t.cache?t.cache:c,r=t&&t.serializer?t.serializer:a;return(t&&t.strategy?t.strategy:o)(e,{cache:n,serializer:r})},e.exports.strategies={variadic:function(e,t){return i(e,this,r,t.cache.create(),t.serializer)},monadic:function(e,t){return i(e,this,n,t.cache.create(),t.serializer)}}},"77Zs":function(e,t,n){var r=n("Xi7e");e.exports=function(){this.__data__=new r,this.size=0}},"79nV":function(e,t,n){var r=n("U1bi");n("epdU")(r,["ActionClient","SimpleActionServer"],e.exports={ActionClient:n("qesz"),ActionListener:n("BCdy"),Goal:n("4XN4"),SimpleActionServer:n("jcpv")})},"7GkX":function(e,t,n){var r=n("b80T"),i=n("A90E"),o=n("MMmD");e.exports=function(e){return o(e)?r(e):i(e)}},"7Ix3":function(e,t){e.exports=function(e){var t=[];if(null!=e)for(var n in Object(e))t.push(n);return t}},"7Qib":function(e,t,n){"use strict";n.d(t,"b",(function(){return u})),n.d(t,"f",(function(){return h})),n.d(t,"h",(function(){return d})),n.d(t,"d",(function(){return f})),n.d(t,"a",(function(){return p})),n.d(t,"i",(function(){return m})),n.d(t,"c",(function(){return g})),n.d(t,"g",(function(){return v})),n.d(t,"e",(function(){return y}));var r=n("EZfD"),i=n("LvDl"),o=n.n(i),a=n("s55K");function s(e){return function(e){if(Array.isArray(e))return c(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(!e)return;if("string"==typeof e)return c(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return c(e,t)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function c(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var l=r.CONSTANTS.DEFAULT_OPTIONS_SCENE,u={INITIAL:"Not Connected",CONNECTING:"Connecting",CONNECTED:"Connected",CONNECTION_ERROR:"Error in connection"},h=function(e){return o.a.filter(e,(function(e){return o.a.includes(a.a,e.messageType)}))},d=function(e){return e.stopPropagation()},f=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r=document.createElement("a");r.setAttribute("href","data:".concat(n.mimetype||"text/json",";charset=utf-8,").concat(encodeURIComponent(e))),r.setAttribute("download",t),r.style.display="none",document.body.appendChild(r),r.click(),document.body.removeChild(r)},p={panels:{sidebar:{display:!0,collapsed:!1},header:{display:!0},info:{display:!0,collapsed:!0}},ros:{endpoint:"ws://".concat(window.location.host,"/jupyterlab-ros/bridge")},infoTabs:[],visualizations:[],globalOptions:{display:!0,backgroundColor:{display:!0,value:l.backgroundColor},fixedFrame:{display:!0,value:"world"},grid:{display:!0,size:l.gridSize,divisions:l.gridDivisions,color:l.gridColor,centerlineColor:l.gridCenterlineColor}},tools:{mode:"controls",controls:{display:!1,enabled:!0},measure:{display:!1},custom:[]}};function m(e){var t=this.props,n=t.options.key,r=t.updateVizOptions,i=e.target,a=i.checked,s=i.dataset.id,c=i.value;r(n,function(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}({},s,o.a.has(e.target,"checked")?a:c))}function g(e){var t=[],n=e.auxGraphData;return o.a.each(o.a.keys(n),(function(e){var r=n[e].publishers,i=n[e].subscribers;o.a.each(r,(function(n){o.a.each(i,(function(r){t.push({source:{id:n,label:n},target:{id:r,label:r},value:e})}))}))})),{nodes:e.nodes,edges:t}}function v(e){var t=s(e.nodes),n=[],r=e.auxGraphData;return o.a.keys(e.auxGraphData).forEach((function(e){t.push({id:e+e,label:e,type:"rect"})})),o.a.each(o.a.keys(r),(function(e){var t=r[e].publishers,i=r[e].subscribers;o.a.each(t,(function(t){n.push({source:{id:t,label:t},target:{id:e+e,label:e},value:""})})),o.a.each(i,(function(t){n.push({source:{id:e+e,label:e},target:{id:t,label:t},value:""})}))})),{nodes:t,edges:n}}function y(e){var t={};return new Promise((function(n,r){e.getNodes((function(i){t.nodes=o.a.map(i,(function(e){return{id:e,label:e,type:"ellipse"}})),e.getTopics((function(o){var a=o.topics;Promise.all(i.map((function(t){return function(e,t){return new Promise((function(n,r){try{e.getNodeDetails(t,(function(e){var r=e.publishing,i=e.subscribing;n({publishing:r,subscribing:i,node:t})}))}catch(e){r(e)}}))}(e,t)}))).then((function(e){t.auxGraphData=function(e,t){var n={};return e.forEach((function(e){n[e]={publishers:[],subscribers:[]}})),t.forEach((function(e){var t=e.publishing,r=e.subscribing,i=e.node;t.forEach((function(e){n[e].publishers.push(i)})),r.forEach((function(e){n[e].subscribers.push(i)}))})),n}(a,e),n(t)})).catch((function(e){r(e)}))}))}))}))}},"7W2i":function(e,t,n){var r=n("SksO");e.exports=function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&r(e,t)},e.exports.default=e.exports,e.exports.__esModule=!0},"7fqy":function(e,t){e.exports=function(e){var t=-1,n=Array(e.size);return e.forEach((function(e,r){n[++t]=[r,e]})),n}},"7nPM":function(e,t,n){"use strict";function r(e){return function(t){var n=-1,r=e.length;if(t<0)return{};for(;++n<r;)if(e[n]>t)return{line:n+1,column:t-(e[n-1]||0)+1,offset:t};return{}}}function i(e){return function(t){var n=t&&t.line,r=t&&t.column;if(!isNaN(n)&&!isNaN(r)&&n-1 in e)return(e[n-2]||0)+r-1||0;return-1}}e.exports=function(e){var t=function(e){var t=[],n=e.indexOf("\n");for(;-1!==n;)t.push(n+1),n=e.indexOf("\n",n+1);return t.push(e.length+1),t}(String(e));return{toPosition:r(t),toOffset:i(t)}}},"81LO":function(e,t,n){var r=n("b5wT"),i=n("tQ6r");function o(e,t,n){for(var i;t.length&&(i=r.last(t)).i<=n;)t.pop(),e.push(i.vs),n++;return n}e.exports=function(e,t){var n=i.partition(e,(function(e){return r.has(e,"barycenter")})),a=n.lhs,s=r.sortBy(n.rhs,(function(e){return-e.i})),c=[],l=0,u=0,h=0;a.sort((d=!!t,function(e,t){return e.barycenter<t.barycenter?-1:e.barycenter>t.barycenter?1:d?t.i-e.i:e.i-t.i})),h=o(c,s,h),r.forEach(a,(function(e){h+=e.vs.length,c.push(e.vs),l+=e.barycenter*e.weight,u+=e.weight,h=o(c,s,h)}));var d;var f={vs:r.flatten(c,!0)};u&&(f.barycenter=l/u,f.weight=u);return f}},"82c2":function(e,t,n){"use strict";var r=n("1seS"),i="function"==typeof Symbol&&"symbol"==typeof Symbol("foo"),o=Object.prototype.toString,a=Array.prototype.concat,s=Object.defineProperty,c=s&&function(){var e={};try{for(var t in s(e,"x",{enumerable:!1,value:e}),e)return!1;return e.x===e}catch(e){return!1}}(),l=function(e,t,n,r){var i;(!(t in e)||"function"==typeof(i=r)&&"[object Function]"===o.call(i)&&r())&&(c?s(e,t,{configurable:!0,enumerable:!1,value:n,writable:!0}):e[t]=n)},u=function(e,t){var n=arguments.length>2?arguments[2]:{},o=r(t);i&&(o=a.call(o,Object.getOwnPropertySymbols(t)));for(var s=0;s<o.length;s+=1)l(e,o[s],t[o[s]],n[o[s]])};u.supportsDescriptors=!!c,e.exports=u},"88Gu":function(e,t){var n=Date.now;e.exports=function(e){var t=0,r=0;return function(){var i=n(),o=16-(i-r);if(r=i,o>0){if(++t>=800)return arguments[0]}else t=0;return e.apply(void 0,arguments)}}},"8N4D":function(e,t,n){"use strict";function r(e){return(r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}Object.defineProperty(t,"__esModule",{value:!0}),t.matchesSelector=h,t.matchesSelectorAndParentsTo=function(e,t,n){var r=e;do{if(h(r,t))return!0;if(r===n)return!1;r=r.parentNode}while(r);return!1},t.addEvent=function(e,t,n,r){if(!e)return;var i=c({capture:!0},r);e.addEventListener?e.addEventListener(t,n,i):e.attachEvent?e.attachEvent("on"+t,n):e["on"+t]=n},t.removeEvent=function(e,t,n,r){if(!e)return;var i=c({capture:!0},r);e.removeEventListener?e.removeEventListener(t,n,i):e.detachEvent?e.detachEvent("on"+t,n):e["on"+t]=null},t.outerHeight=function(e){var t=e.clientHeight,n=e.ownerDocument.defaultView.getComputedStyle(e);return t+=(0,i.int)(n.borderTopWidth),t+=(0,i.int)(n.borderBottomWidth)},t.outerWidth=function(e){var t=e.clientWidth,n=e.ownerDocument.defaultView.getComputedStyle(e);return t+=(0,i.int)(n.borderLeftWidth),t+=(0,i.int)(n.borderRightWidth)},t.innerHeight=function(e){var t=e.clientHeight,n=e.ownerDocument.defaultView.getComputedStyle(e);return t-=(0,i.int)(n.paddingTop),t-=(0,i.int)(n.paddingBottom)},t.innerWidth=function(e){var t=e.clientWidth,n=e.ownerDocument.defaultView.getComputedStyle(e);return t-=(0,i.int)(n.paddingLeft),t-=(0,i.int)(n.paddingRight)},t.offsetXYFromParent=function(e,t,n){var r=t===t.ownerDocument.body?{left:0,top:0}:t.getBoundingClientRect(),i=(e.clientX+t.scrollLeft-r.left)/n,o=(e.clientY+t.scrollTop-r.top)/n;return{x:i,y:o}},t.createCSSTransform=function(e,t){var n=d(e,t,"px");return l({},(0,o.browserPrefixToKey)("transform",o.default),n)},t.createSVGTransform=function(e,t){return d(e,t,"")},t.getTranslation=d,t.getTouch=function(e,t){return e.targetTouches&&(0,i.findInArray)(e.targetTouches,(function(e){return t===e.identifier}))||e.changedTouches&&(0,i.findInArray)(e.changedTouches,(function(e){return t===e.identifier}))},t.getTouchIdentifier=function(e){if(e.targetTouches&&e.targetTouches[0])return e.targetTouches[0].identifier;if(e.changedTouches&&e.changedTouches[0])return e.changedTouches[0].identifier},t.addUserSelectStyles=function(e){if(!e)return;var t=e.getElementById("react-draggable-style-el");t||((t=e.createElement("style")).type="text/css",t.id="react-draggable-style-el",t.innerHTML=".react-draggable-transparent-selection *::-moz-selection {all: inherit;}\n",t.innerHTML+=".react-draggable-transparent-selection *::selection {all: inherit;}\n",e.getElementsByTagName("head")[0].appendChild(t));e.body&&f(e.body,"react-draggable-transparent-selection")},t.removeUserSelectStyles=function(e){if(!e)return;try{if(e.body&&p(e.body,"react-draggable-transparent-selection"),e.selection)e.selection.empty();else{var t=(e.defaultView||window).getSelection();t&&"Caret"!==t.type&&t.removeAllRanges()}}catch(e){}},t.addClassName=f,t.removeClassName=p;var i=n("gbW8"),o=function(e){if(e&&e.__esModule)return e;if(null===e||"object"!==r(e)&&"function"!=typeof e)return{default:e};var t=a();if(t&&t.has(e))return t.get(e);var n={},i=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var s=i?Object.getOwnPropertyDescriptor(e,o):null;s&&(s.get||s.set)?Object.defineProperty(n,o,s):n[o]=e[o]}n.default=e,t&&t.set(e,n);return n}(n("Ga4A"));function a(){if("function"!=typeof WeakMap)return null;var e=new WeakMap;return a=function(){return e},e}function s(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var r=Object.getOwnPropertySymbols(e);t&&(r=r.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,r)}return n}function c(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?s(Object(n),!0).forEach((function(t){l(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):s(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function l(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var u="";function h(e,t){return u||(u=(0,i.findInArray)(["matches","webkitMatchesSelector","mozMatchesSelector","msMatchesSelector","oMatchesSelector"],(function(t){return(0,i.isFunction)(e[t])}))),!!(0,i.isFunction)(e[u])&&e[u](t)}function d(e,t,n){var r=e.x,i=e.y,o="translate(".concat(r).concat(n,",").concat(i).concat(n,")");if(t){var a="".concat("string"==typeof t.x?t.x:t.x+n),s="".concat("string"==typeof t.y?t.y:t.y+n);o="translate(".concat(a,", ").concat(s,")")+o}return o}function f(e,t){e.classList?e.classList.add(t):e.className.match(new RegExp("(?:^|\\s)".concat(t,"(?!\\S)")))||(e.className+=" ".concat(t))}function p(e,t){e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(?:^|\\s)".concat(t,"(?!\\S)"),"g"),"")}},"8OQS":function(e,t){e.exports=function(e,t){if(null==e)return{};var n,r,i={},o=Object.keys(e);for(r=0;r<o.length;r++)n=o[r],t.indexOf(n)>=0||(i[n]=e[n]);return i},e.exports.default=e.exports,e.exports.__esModule=!0},"8c2E":function(e,t,n){var r=n("b5wT");e.exports=function(e){var t=function(e){var t={},n=0;function i(o){var a=n;r.forEach(e.children(o),i),t[o]={low:a,lim:n++}}return r.forEach(e.children(),i),t}(e);r.forEach(e.graph().dummyChains,(function(n){for(var r=e.node(n),i=r.edgeObj,o=function(e,t,n,r){var i,o,a=[],s=[],c=Math.min(t[n].low,t[r].low),l=Math.max(t[n].lim,t[r].lim);i=n;do{i=e.parent(i),a.push(i)}while(i&&(t[i].low>c||l>t[i].lim));o=i,i=r;for(;(i=e.parent(i))!==o;)s.push(i);return{path:a.concat(s.reverse()),lca:o}}(e,t,i.v,i.w),a=o.path,s=o.lca,c=0,l=a[c],u=!0;n!==i.w;){if(r=e.node(n),u){for(;(l=a[c])!==s&&e.node(l).maxRank<r.rank;)c++;l===s&&(u=!1)}if(!u){for(;c<a.length-1&&e.node(l=a[c+1]).minRank<=r.rank;)c++;l=a[c]}e.setParent(n,l),n=e.successors(n)[0]}}))}},"8oxB":function(e,t){var n,r,i=e.exports={};function o(){throw new Error("setTimeout has not been defined")}function a(){throw new Error("clearTimeout has not been defined")}function s(e){if(n===setTimeout)return setTimeout(e,0);if((n===o||!n)&&setTimeout)return n=setTimeout,setTimeout(e,0);try{return n(e,0)}catch(t){try{return n.call(null,e,0)}catch(t){return n.call(this,e,0)}}}!function(){try{n="function"==typeof setTimeout?setTimeout:o}catch(e){n=o}try{r="function"==typeof clearTimeout?clearTimeout:a}catch(e){r=a}}();var c,l=[],u=!1,h=-1;function d(){u&&c&&(u=!1,c.length?l=c.concat(l):h=-1,l.length&&f())}function f(){if(!u){var e=s(d);u=!0;for(var t=l.length;t;){for(c=l,l=[];++h<t;)c&&c[h].run();h=-1,t=l.length}c=null,u=!1,function(e){if(r===clearTimeout)return clearTimeout(e);if((r===a||!r)&&clearTimeout)return r=clearTimeout,clearTimeout(e);try{r(e)}catch(t){try{return r.call(null,e)}catch(t){return r.call(this,e)}}}(e)}}function p(e,t){this.fun=e,this.array=t}function m(){}i.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];l.push(new p(e,t)),1!==l.length||u||s(f)},p.prototype.run=function(){this.fun.apply(null,this.array)},i.title="browser",i.browser=!0,i.env={},i.argv=[],i.version="",i.versions={},i.on=m,i.addListener=m,i.once=m,i.off=m,i.removeListener=m,i.removeAllListeners=m,i.emit=m,i.prependListener=m,i.prependOnceListener=m,i.listeners=function(e){return[]},i.binding=function(e){throw new Error("process.binding is not supported")},i.cwd=function(){return"/"},i.chdir=function(e){throw new Error("process.chdir is not supported")},i.umask=function(){return 0}},"9/5/":function(e,t,n){(function(t){var n=/^\s+|\s+$/g,r=/^[-+]0x[0-9a-f]+$/i,i=/^0b[01]+$/i,o=/^0o[0-7]+$/i,a=parseInt,s="object"==typeof t&&t&&t.Object===Object&&t,c="object"==typeof self&&self&&self.Object===Object&&self,l=s||c||Function("return this")(),u=Object.prototype.toString,h=Math.max,d=Math.min,f=function(){return l.Date.now()};function p(e){var t=typeof e;return!!e&&("object"==t||"function"==t)}function m(e){if("number"==typeof e)return e;if(function(e){return"symbol"==typeof e||function(e){return!!e&&"object"==typeof e}(e)&&"[object Symbol]"==u.call(e)}(e))return NaN;if(p(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=p(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=e.replace(n,"");var s=i.test(e);return s||o.test(e)?a(e.slice(2),s?2:8):r.test(e)?NaN:+e}e.exports=function(e,t,n){var r,i,o,a,s,c,l=0,u=!1,g=!1,v=!0;if("function"!=typeof e)throw new TypeError("Expected a function");function y(t){var n=r,o=i;return r=i=void 0,l=t,a=e.apply(o,n)}function b(e){return l=e,s=setTimeout(x,t),u?y(e):a}function w(e){var n=e-c;return void 0===c||n>=t||n<0||g&&e-l>=o}function x(){var e=f();if(w(e))return _(e);s=setTimeout(x,function(e){var n=t-(e-c);return g?d(n,o-(e-l)):n}(e))}function _(e){return s=void 0,v&&r?y(e):(r=i=void 0,a)}function E(){var e=f(),n=w(e);if(r=arguments,i=this,c=e,n){if(void 0===s)return b(c);if(g)return s=setTimeout(x,t),y(c)}return void 0===s&&(s=setTimeout(x,t)),a}return t=m(t)||0,p(n)&&(u=!!n.leading,o=(g="maxWait"in n)?h(m(n.maxWait)||0,t):o,v="trailing"in n?!!n.trailing:v),E.cancel=function(){void 0!==s&&clearTimeout(s),l=0,r=c=i=s=void 0},E.flush=function(){return void 0===s?a:_(f())},E}}).call(this,n("yLpj"))},"9Nap":function(e,t,n){var r=n("/9aa");e.exports=function(e){if("string"==typeof e||r(e))return e;var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}},"9Z5P":function(e,t,n){"use strict";var r=n("ZkSf");function i(e){var t=e.children;e.children=[{type:"tableHead",align:e.align,children:[t[0]],position:t[0].position}],t.length>1&&e.children.push({type:"tableBody",align:e.align,children:t.slice(1),position:{start:t[1].position.start,end:t[t.length-1].position.end}})}e.exports=function(e){return r(e,"table",i),e}},"9ggG":function(e,t,n){var r=n("Z0cm"),i=n("/9aa"),o=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,a=/^\w*$/;e.exports=function(e,t){if(r(e))return!1;var n=typeof e;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=e&&!i(e))||(a.test(e)||!o.test(e)||null!=t&&e in Object(t))}},"9uj6":function(e,t,n){"use strict";var r=n("4qRI"),i=/^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|inert|itemProp|itemScope|itemType|itemID|itemRef|on|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/,o=Object(r.a)((function(e){return i.test(e)||111===e.charCodeAt(0)&&110===e.charCodeAt(1)&&e.charCodeAt(2)<91}));t.a=o},A6mZ:function(e,t,n){"use strict";e.exports=function(e){return function(t,n){var o,a,s,c,l,u,h=this,d=h.offset,f=[],p=h[e+"Methods"],m=h[e+"Tokenizers"],g=n.line,v=n.column;if(!t)return f;x.now=b,x.file=h.file,y("");for(;t;){for(o=-1,a=p.length,l=!1;++o<a&&(c=p[o],!(s=m[c])||s.onlyAtStart&&!h.atStart||s.notInList&&h.inList||s.notInBlock&&h.inBlock||s.notInLink&&h.inLink||(u=t.length,s.apply(h,[x,t]),!(l=u!==t.length))););l||h.file.fail(new Error("Infinite loop"),x.now())}return h.eof=b(),f;function y(e){for(var t=-1,n=e.indexOf("\n");-1!==n;)g++,t=n,n=e.indexOf("\n",n+1);-1===t?v+=e.length:v=e.length-t,g in d&&(-1!==t?v+=d[g]:v<=d[g]&&(v=d[g]+1))}function b(){var e={line:g,column:v};return e.offset=h.toOffset(e),e}function w(e){this.start=e,this.end=b()}function x(e){var n,o=function(){var e=[],t=g+1;return function(){for(var n=g+1;t<n;)e.push((d[t]||0)+1),t++;return e}}(),a=(n=b(),function(e,t){var r=e.position,i=r?r.start:n,o=[],a=r&&r.end.line,s=n.line;if(e.position=new w(i),r&&t&&r.indent){if(o=r.indent,a<s){for(;++a<s;)o.push((d[a]||0)+1);o.push(n.column)}t=o.concat(t)}return e.position.indent=t||[],e}),s=b();return function(e){t.substring(0,e.length)!==e&&h.file.fail(new Error("Incorrectly eaten value: please report this warning on http://git.io/vg5Ft"),b())}(e),c.reset=l,l.test=u,c.test=u,t=t.substring(e.length),y(e),o=o(),c;function c(e,t){return a(function(e,t){var n=t?t.children:f,o=n[n.length-1];return o&&e.type===o.type&&e.type in r&&i(o)&&i(e)&&(e=r[e.type].call(h,o,e)),e!==o&&n.push(e),h.atStart&&0!==f.length&&h.exitStart(),e}(a(e),t),o)}function l(){var n=c.apply(null,arguments);return g=s.line,v=s.column,t=e+t,n}function u(){var n=a({});return g=s.line,v=s.column,t=e+t,n.position}}}};var r={text:function(e,t){return e.value+=t.value,e},blockquote:function(e,t){if(this.options.commonmark)return t;return e.children=e.children.concat(t.children),e}};function i(e){var t,n;return"text"!==e.type||!e.position||(t=e.position.start,n=e.position.end,t.line!==n.line||n.column-t.column===e.value.length)}},A90E:function(e,t,n){var r=n("6sVZ"),i=n("V6Ve"),o=Object.prototype.hasOwnProperty;e.exports=function(e){if(!r(e))return i(e);var t=[];for(var n in Object(e))o.call(e,n)&&"constructor"!=n&&t.push(n);return t}},ABHV:function(e,t,n){"use strict";var r=n("0K0V"),i=r.Image||window.Image;e.exports=function(e,t){var n=new i;n.onload=function(){var e=new r,i=e.getContext("2d");e.width=n.width,e.height=n.height,i.imageSmoothingEnabled=!1,i.webkitImageSmoothingEnabled=!1,i.mozImageSmoothingEnabled=!1,i.drawImage(n,0,0);for(var o=i.getImageData(0,0,n.width,n.height).data,a="",s=0;s<o.length;s+=4)a+=String.fromCharCode(o[s],o[s+1],o[s+2]);t(JSON.parse(a))},n.src="data:image/png;base64,"+e}},ACFR:function(e,t){function n(e){e=e||{},this.x=e.x||0,this.y=e.y||0,this.z=e.z||0,this.w="number"==typeof e.w?e.w:1}n.prototype.conjugate=function(){this.x*=-1,this.y*=-1,this.z*=-1},n.prototype.norm=function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},n.prototype.normalize=function(){var e=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===e?(this.x=0,this.y=0,this.z=0,this.w=1):(e=1/e,this.x=this.x*e,this.y=this.y*e,this.z=this.z*e,this.w=this.w*e)},n.prototype.invert=function(){this.conjugate(),this.normalize()},n.prototype.multiply=function(e){var t=this.x*e.w+this.y*e.z-this.z*e.y+this.w*e.x,n=-this.x*e.z+this.y*e.w+this.z*e.x+this.w*e.y,r=this.x*e.y-this.y*e.x+this.z*e.w+this.w*e.z,i=-this.x*e.x-this.y*e.y-this.z*e.z+this.w*e.w;this.x=t,this.y=n,this.z=r,this.w=i},n.prototype.clone=function(){return new n(this)},e.exports=n},AE40:function(e,t,n){var r=n("dunj"),i=n("jSBL"),o=n("zZ0H");e.exports=function(e){return e&&e.length?r(e,o,i):void 0}},AP2z:function(e,t,n){var r=n("nmnc"),i=Object.prototype,o=i.hasOwnProperty,a=i.toString,s=r?r.toStringTag:void 0;e.exports=function(e){var t=o.call(e,s),n=e[s];try{e[s]=void 0;var r=!0}catch(e){}var i=a.call(e);return r&&(t?e[s]=n:delete e[s]),i}},Ac7g:function(e,t,n){e.exports={Graph:n("lnHP"),version:n("w802")}},AevD:function(e,t,n){var r=n("M96O");function i(){this._arr=[],this._keyIndices={}}e.exports=i,i.prototype.size=function(){return this._arr.length},i.prototype.keys=function(){return this._arr.map((function(e){return e.key}))},i.prototype.has=function(e){return r.has(this._keyIndices,e)},i.prototype.priority=function(e){var t=this._keyIndices[e];if(void 0!==t)return this._arr[t].priority},i.prototype.min=function(){if(0===this.size())throw new Error("Queue underflow");return this._arr[0].key},i.prototype.add=function(e,t){var n=this._keyIndices;if(e=String(e),!r.has(n,e)){var i=this._arr,o=i.length;return n[e]=o,i.push({key:e,priority:t}),this._decrease(o),!0}return!1},i.prototype.removeMin=function(){this._swap(0,this._arr.length-1);var e=this._arr.pop();return delete this._keyIndices[e.key],this._heapify(0),e.key},i.prototype.decrease=function(e,t){var n=this._keyIndices[e];if(t>this._arr[n].priority)throw new Error("New priority is greater than current priority. Key: "+e+" Old: "+this._arr[n].priority+" New: "+t);this._arr[n].priority=t,this._decrease(n)},i.prototype._heapify=function(e){var t=this._arr,n=2*e,r=n+1,i=e;n<t.length&&(i=t[n].priority<t[i].priority?n:i,r<t.length&&(i=t[r].priority<t[i].priority?r:i),i!==e&&(this._swap(e,i),this._heapify(i)))},i.prototype._decrease=function(e){for(var t,n=this._arr,r=n[e].priority;0!==e&&!(n[t=e>>1].priority<r);)this._swap(e,t),e=t},i.prototype._swap=function(e,t){var n=this._arr,r=this._keyIndices,i=n[e],o=n[t];n[e]=o,n[t]=i,r[o.key]=e,r[i.key]=t}},B8du:function(e,t){e.exports=function(){return!1}},B9Yq:function(e,t){e.exports=function(){throw new Error("define cannot be used indirect")}},BCdy:function(e,t,n){var r=n("cqyl"),i=(n("PjQo"),n("cjKa").EventEmitter2);function o(e){var t=this;e=e||{},this.ros=e.ros,this.serverName=e.serverName,this.actionName=e.actionName,this.timeout=e.timeout,this.omitFeedback=e.omitFeedback,this.omitStatus=e.omitStatus,this.omitResult=e.omitResult;var n=new r({ros:this.ros,name:this.serverName+"/goal",messageType:this.actionName+"Goal"}),i=new r({ros:this.ros,name:this.serverName+"/feedback",messageType:this.actionName+"Feedback"}),o=new r({ros:this.ros,name:this.serverName+"/status",messageType:"actionlib_msgs/GoalStatusArray"}),a=new r({ros:this.ros,name:this.serverName+"/result",messageType:this.actionName+"Result"});n.subscribe((function(e){t.emit("goal",e)})),o.subscribe((function(e){e.status_list.forEach((function(e){t.emit("status",e)}))})),i.subscribe((function(e){t.emit("status",e.status),t.emit("feedback",e.feedback)})),a.subscribe((function(e){t.emit("status",e.status),t.emit("result",e.result)}))}o.prototype.__proto__=i.prototype,e.exports=o},BEtg:function(e,t){function n(e){return!!e.constructor&&"function"==typeof e.constructor.isBuffer&&e.constructor.isBuffer(e)}
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
e.exports=function(e){return null!=e&&(n(e)||function(e){return"function"==typeof e.readFloatLE&&"function"==typeof e.slice&&n(e.slice(0,0))}(e)||!!e._isBuffer)}},BHpa:function(e,t){e.exports=function(e){var t=e.xml.getAttribute("rgba").split(" ");this.r=parseFloat(t[0]),this.g=parseFloat(t[1]),this.b=parseFloat(t[2]),this.a=parseFloat(t[3])}},BPfq:function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var t,n=e.Symbol;if("function"==typeof n)if(n.observable)t=n.observable;else{t=n.for("https://github.com/benlesh/symbol-observable");try{n.observable=t}catch(e){}}else t="@@observable";return t}},BS4l:function(e,t,n){"use strict";var r=n("lU+G"),i=n("XedF"),o=n("PEyx"),a=n("Ve/E");e.exports=function(e,t){var n,s=e.selectAll("g.edgeLabel").data(t.edges(),(function(e){return o.edgeToId(e)})).classed("update",!0);s.exit().remove(),s.enter().append("g").classed("edgeLabel",!0).style("opacity",0),(s=e.selectAll("g.edgeLabel")).each((function(e){var n=a.select(this);n.select(".label").remove();var o=t.edge(e),s=i(n,t.edge(e),0,0).classed("label",!0),c=s.node().getBBox();o.labelId&&s.attr("id",o.labelId),r.has(o,"width")||(o.width=c.width),r.has(o,"height")||(o.height=c.height)})),n=s.exit?s.exit():s.selectAll(null);return o.applyTransition(n,t).style("opacity",0).remove(),s}},Bhyg:function(e,t,n){!function(){var e=function(){return this}();e||"undefined"==typeof window||(e=window);var t=function(e,n,r){"string"==typeof e?(2==arguments.length&&(r=n),t.modules[e]||(t.payloads[e]=r,t.modules[e]=null)):t.original?t.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace())};t.modules={},t.payloads={};var n,r,i=function(e,t,n){if("string"==typeof t){var r=s(e,t);if(null!=r)return n&&n(),r}else if("[object Array]"===Object.prototype.toString.call(t)){for(var i=[],a=0,c=t.length;a<c;++a){var l=s(e,t[a]);if(null==l&&o.original)return;i.push(l)}return n&&n.apply(null,i)||!0}},o=function(e,t){var n=i("",e,t);return null==n&&o.original?o.original.apply(this,arguments):n},a=function(e,t){if(-1!==t.indexOf("!")){var n=t.split("!");return a(e,n[0])+"!"+a(e,n[1])}if("."==t.charAt(0))for(t=e.split("/").slice(0,-1).join("/")+"/"+t;-1!==t.indexOf(".")&&r!=t;){var r=t;t=t.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return t},s=function(e,n){n=a(e,n);var r=t.modules[n];if(!r){if("function"==typeof(r=t.payloads[n])){var o={},s={id:n,uri:"",exports:o,packaged:!0};o=r((function(e,t){return i(n,e,t)}),o,s)||s.exports,t.modules[n]=o,delete t.payloads[n]}r=t.modules[n]=o||r}return r};r=e,(n="ace")&&(e[n]||(e[n]={}),r=e[n]),r.define&&r.define.packaged||(t.original=r.define,r.define=t,r.define.packaged=!0),r.acequire&&r.acequire.packaged||(o.original=r.acequire,r.acequire=o,r.acequire.packaged=!0)}(),ace.define("ace/lib/regexp",["require","exports","module"],(function(e,t,n){"use strict";var r,i={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},o=void 0===i.exec.call(/()??/,"")[1],a=(r=/^/g,i.test.call(r,""),!r.lastIndex);function s(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.extended?"x":"")+(e.sticky?"y":"")}function c(e,t,n){if(Array.prototype.indexOf)return e.indexOf(t,n);for(var r=n||0;r<e.length;r++)if(e[r]===t)return r;return-1}a&&o||(RegExp.prototype.exec=function(e){var t,n,r=i.exec.apply(this,arguments);if("string"==typeof e&&r){if(!o&&r.length>1&&c(r,"")>-1&&(n=RegExp(this.source,i.replace.call(s(this),"g","")),i.replace.call(e.slice(r.index),n,(function(){for(var e=1;e<arguments.length-2;e++)void 0===arguments[e]&&(r[e]=void 0)}))),this._xregexp&&this._xregexp.captureNames)for(var l=1;l<r.length;l++)(t=this._xregexp.captureNames[l-1])&&(r[t]=r[l]);!a&&this.global&&!r[0].length&&this.lastIndex>r.index&&this.lastIndex--}return r},a||(RegExp.prototype.test=function(e){var t=i.exec.call(this,e);return t&&this.global&&!t[0].length&&this.lastIndex>t.index&&this.lastIndex--,!!t}))})),ace.define("ace/lib/es5-shim",["require","exports","module"],(function(e,t,n){function r(){}Function.prototype.bind||(Function.prototype.bind=function(e){var t=this;if("function"!=typeof t)throw new TypeError("Function.prototype.bind called on incompatible "+t);var n=d.call(arguments,1),i=function(){if(this instanceof i){var r=t.apply(this,n.concat(d.call(arguments)));return Object(r)===r?r:this}return t.apply(e,n.concat(d.call(arguments)))};return t.prototype&&(r.prototype=t.prototype,i.prototype=new r,r.prototype=null),i});var i,o,a,s,c,l=Function.prototype.call,u=Array.prototype,h=Object.prototype,d=u.slice,f=l.bind(h.toString),p=l.bind(h.hasOwnProperty);if((c=p(h,"__defineGetter__"))&&(i=l.bind(h.__defineGetter__),o=l.bind(h.__defineSetter__),a=l.bind(h.__lookupGetter__),s=l.bind(h.__lookupSetter__)),2!=[1,2].splice(0).length)if(function(){function e(e){var t=new Array(e+2);return t[0]=t[1]=0,t}var t,n=[];if(n.splice.apply(n,e(20)),n.splice.apply(n,e(26)),t=n.length,n.splice(5,0,"XXX"),n.length,t+1==n.length)return!0}()){var m=Array.prototype.splice;Array.prototype.splice=function(e,t){return arguments.length?m.apply(this,[void 0===e?0:e,void 0===t?this.length-e:t].concat(d.call(arguments,2))):[]}}else Array.prototype.splice=function(e,t){var n=this.length;e>0?e>n&&(e=n):null==e?e=0:e<0&&(e=Math.max(n+e,0)),e+t<n||(t=n-e);var r=this.slice(e,e+t),i=d.call(arguments,2),o=i.length;if(e===n)o&&this.push.apply(this,i);else{var a=Math.min(t,n-e),s=e+a,c=s+o-a,l=n-s,u=n-a;if(c<s)for(var h=0;h<l;++h)this[c+h]=this[s+h];else if(c>s)for(h=l;h--;)this[c+h]=this[s+h];if(o&&e===u)this.length=u,this.push.apply(this,i);else for(this.length=u+o,h=0;h<o;++h)this[e+h]=i[h]}return r};Array.isArray||(Array.isArray=function(e){return"[object Array]"==f(e)});var g,v,y=Object("a"),b="a"!=y[0]||!(0 in y);if(Array.prototype.forEach||(Array.prototype.forEach=function(e){var t=P(this),n=b&&"[object String]"==f(this)?this.split(""):t,r=arguments[1],i=-1,o=n.length>>>0;if("[object Function]"!=f(e))throw new TypeError;for(;++i<o;)i in n&&e.call(r,n[i],i,t)}),Array.prototype.map||(Array.prototype.map=function(e){var t=P(this),n=b&&"[object String]"==f(this)?this.split(""):t,r=n.length>>>0,i=Array(r),o=arguments[1];if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var a=0;a<r;a++)a in n&&(i[a]=e.call(o,n[a],a,t));return i}),Array.prototype.filter||(Array.prototype.filter=function(e){var t,n=P(this),r=b&&"[object String]"==f(this)?this.split(""):n,i=r.length>>>0,o=[],a=arguments[1];if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var s=0;s<i;s++)s in r&&(t=r[s],e.call(a,t,s,n)&&o.push(t));return o}),Array.prototype.every||(Array.prototype.every=function(e){var t=P(this),n=b&&"[object String]"==f(this)?this.split(""):t,r=n.length>>>0,i=arguments[1];if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var o=0;o<r;o++)if(o in n&&!e.call(i,n[o],o,t))return!1;return!0}),Array.prototype.some||(Array.prototype.some=function(e){var t=P(this),n=b&&"[object String]"==f(this)?this.split(""):t,r=n.length>>>0,i=arguments[1];if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");for(var o=0;o<r;o++)if(o in n&&e.call(i,n[o],o,t))return!0;return!1}),Array.prototype.reduce||(Array.prototype.reduce=function(e){var t=P(this),n=b&&"[object String]"==f(this)?this.split(""):t,r=n.length>>>0;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");if(!r&&1==arguments.length)throw new TypeError("reduce of empty array with no initial value");var i,o=0;if(arguments.length>=2)i=arguments[1];else for(;;){if(o in n){i=n[o++];break}if(++o>=r)throw new TypeError("reduce of empty array with no initial value")}for(;o<r;o++)o in n&&(i=e.call(void 0,i,n[o],o,t));return i}),Array.prototype.reduceRight||(Array.prototype.reduceRight=function(e){var t=P(this),n=b&&"[object String]"==f(this)?this.split(""):t,r=n.length>>>0;if("[object Function]"!=f(e))throw new TypeError(e+" is not a function");if(!r&&1==arguments.length)throw new TypeError("reduceRight of empty array with no initial value");var i,o=r-1;if(arguments.length>=2)i=arguments[1];else for(;;){if(o in n){i=n[o--];break}if(--o<0)throw new TypeError("reduceRight of empty array with no initial value")}do{o in this&&(i=e.call(void 0,i,n[o],o,t))}while(o--);return i}),Array.prototype.indexOf&&-1==[0,1].indexOf(1,2)||(Array.prototype.indexOf=function(e){var t=b&&"[object String]"==f(this)?this.split(""):P(this),n=t.length>>>0;if(!n)return-1;var r=0;for(arguments.length>1&&(r=R(arguments[1])),r=r>=0?r:Math.max(0,n+r);r<n;r++)if(r in t&&t[r]===e)return r;return-1}),Array.prototype.lastIndexOf&&-1==[0,1].lastIndexOf(0,-3)||(Array.prototype.lastIndexOf=function(e){var t=b&&"[object String]"==f(this)?this.split(""):P(this),n=t.length>>>0;if(!n)return-1;var r=n-1;for(arguments.length>1&&(r=Math.min(r,R(arguments[1]))),r=r>=0?r:n-Math.abs(r);r>=0;r--)if(r in t&&e===t[r])return r;return-1}),Object.getPrototypeOf||(Object.getPrototypeOf=function(e){return e.__proto__||(e.constructor?e.constructor.prototype:h)}),!Object.getOwnPropertyDescriptor){Object.getOwnPropertyDescriptor=function(e,t){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.getOwnPropertyDescriptor called on a non-object: "+e);if(p(e,t)){var n;if(n={enumerable:!0,configurable:!0},c){var r=e.__proto__;e.__proto__=h;var i=a(e,t),o=s(e,t);if(e.__proto__=r,i||o)return i&&(n.get=i),o&&(n.set=o),n}return n.value=e[t],n}}}(Object.getOwnPropertyNames||(Object.getOwnPropertyNames=function(e){return Object.keys(e)}),Object.create)||(g=null===Object.prototype.__proto__?function(){return{__proto__:null}}:function(){var e={};for(var t in e)e[t]=null;return e.constructor=e.hasOwnProperty=e.propertyIsEnumerable=e.isPrototypeOf=e.toLocaleString=e.toString=e.valueOf=e.__proto__=null,e},Object.create=function(e,t){var n;if(null===e)n=g();else{if("object"!=typeof e)throw new TypeError("typeof prototype["+typeof e+"] != 'object'");var r=function(){};r.prototype=e,(n=new r).__proto__=e}return void 0!==t&&Object.defineProperties(n,t),n});function w(e){try{return Object.defineProperty(e,"sentinel",{}),"sentinel"in e}catch(e){}}if(Object.defineProperty){var x=w({}),_="undefined"==typeof document||w(document.createElement("div"));if(!x||!_)var E=Object.defineProperty}if(!Object.defineProperty||E){Object.defineProperty=function(e,t,n){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.defineProperty called on non-object: "+e);if("object"!=typeof n&&"function"!=typeof n||null===n)throw new TypeError("Property description must be an object: "+n);if(E)try{return E.call(Object,e,t,n)}catch(e){}if(p(n,"value"))if(c&&(a(e,t)||s(e,t))){var r=e.__proto__;e.__proto__=h,delete e[t],e[t]=n.value,e.__proto__=r}else e[t]=n.value;else{if(!c)throw new TypeError("getters & setters can not be defined on this javascript engine");p(n,"get")&&i(e,t,n.get),p(n,"set")&&o(e,t,n.set)}return e}}Object.defineProperties||(Object.defineProperties=function(e,t){for(var n in t)p(t,n)&&Object.defineProperty(e,n,t[n]);return e}),Object.seal||(Object.seal=function(e){return e}),Object.freeze||(Object.freeze=function(e){return e});try{Object.freeze((function(){}))}catch(e){Object.freeze=(v=Object.freeze,function(e){return"function"==typeof e?e:v(e)})}if(Object.preventExtensions||(Object.preventExtensions=function(e){return e}),Object.isSealed||(Object.isSealed=function(e){return!1}),Object.isFrozen||(Object.isFrozen=function(e){return!1}),Object.isExtensible||(Object.isExtensible=function(e){if(Object(e)===e)throw new TypeError;for(var t="";p(e,t);)t+="?";e[t]=!0;var n=p(e,t);return delete e[t],n}),!Object.keys){var S=!0,C=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],A=C.length;for(var T in{toString:null})S=!1;Object.keys=function(e){if("object"!=typeof e&&"function"!=typeof e||null===e)throw new TypeError("Object.keys called on a non-object");var t=[];for(var n in e)p(e,n)&&t.push(n);if(S)for(var r=0,i=A;r<i;r++){var o=C[r];p(e,o)&&t.push(o)}return t}}Date.now||(Date.now=function(){return(new Date).getTime()});var M="\t\n\v\f\r   ᠎             　\u2028\u2029\ufeff";if(!String.prototype.trim||M.trim()){M="["+M+"]";var O=new RegExp("^"+M+M+"*"),k=new RegExp(M+M+"*$");String.prototype.trim=function(){return String(this).replace(O,"").replace(k,"")}}function R(e){return(e=+e)!=e?e=0:0!==e&&e!==1/0&&e!==-1/0&&(e=(e>0||-1)*Math.floor(Math.abs(e))),e}var P=function(e){if(null==e)throw new TypeError("can't convert "+e+" to object");return Object(e)}})),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/regexp","ace/lib/es5-shim"],(function(e,t,n){"use strict";e("./regexp"),e("./es5-shim")})),ace.define("ace/lib/dom",["require","exports","module"],(function(e,t,n){"use strict";t.getDocumentHead=function(e){return e||(e=document),e.head||e.getElementsByTagName("head")[0]||e.documentElement},t.createElement=function(e,t){return document.createElementNS?document.createElementNS(t||"http://www.w3.org/1999/xhtml",e):document.createElement(e)},t.hasCssClass=function(e,t){return-1!==(e.className+"").split(/\s+/g).indexOf(t)},t.addCssClass=function(e,n){t.hasCssClass(e,n)||(e.className+=" "+n)},t.removeCssClass=function(e,t){for(var n=e.className.split(/\s+/g);;){var r=n.indexOf(t);if(-1==r)break;n.splice(r,1)}e.className=n.join(" ")},t.toggleCssClass=function(e,t){for(var n=e.className.split(/\s+/g),r=!0;;){var i=n.indexOf(t);if(-1==i)break;r=!1,n.splice(i,1)}return r&&n.push(t),e.className=n.join(" "),r},t.setCssClass=function(e,n,r){r?t.addCssClass(e,n):t.removeCssClass(e,n)},t.hasCssString=function(e,t){var n,r=0;if((t=t||document).createStyleSheet&&(n=t.styleSheets)){for(;r<n.length;)if(n[r++].owningElement.id===e)return!0}else if(n=t.getElementsByTagName("style"))for(;r<n.length;)if(n[r++].id===e)return!0;return!1},t.importCssString=function(e,n,r){if(r=r||document,n&&t.hasCssString(n,r))return null;var i;n&&(e+="\n/*# sourceURL=ace/css/"+n+" */"),r.createStyleSheet?((i=r.createStyleSheet()).cssText=e,n&&(i.owningElement.id=n)):((i=t.createElement("style")).appendChild(r.createTextNode(e)),n&&(i.id=n),t.getDocumentHead(r).appendChild(i))},t.importCssStylsheet=function(e,n){if(n.createStyleSheet)n.createStyleSheet(e);else{var r=t.createElement("link");r.rel="stylesheet",r.href=e,t.getDocumentHead(n).appendChild(r)}},t.getInnerWidth=function(e){return parseInt(t.computedStyle(e,"paddingLeft"),10)+parseInt(t.computedStyle(e,"paddingRight"),10)+e.clientWidth},t.getInnerHeight=function(e){return parseInt(t.computedStyle(e,"paddingTop"),10)+parseInt(t.computedStyle(e,"paddingBottom"),10)+e.clientHeight},t.scrollbarWidth=function(e){var n=t.createElement("ace_inner");n.style.width="100%",n.style.minWidth="0px",n.style.height="200px",n.style.display="block";var r=t.createElement("ace_outer"),i=r.style;i.position="absolute",i.left="-10000px",i.overflow="hidden",i.width="200px",i.minWidth="0px",i.height="150px",i.display="block",r.appendChild(n);var o=e.documentElement;o.appendChild(r);var a=n.offsetWidth;i.overflow="scroll";var s=n.offsetWidth;return a==s&&(s=r.clientWidth),o.removeChild(r),a-s},"undefined"!=typeof document?(void 0!==window.pageYOffset?(t.getPageScrollTop=function(){return window.pageYOffset},t.getPageScrollLeft=function(){return window.pageXOffset}):(t.getPageScrollTop=function(){return document.body.scrollTop},t.getPageScrollLeft=function(){return document.body.scrollLeft}),window.getComputedStyle?t.computedStyle=function(e,t){return t?(window.getComputedStyle(e,"")||{})[t]||"":window.getComputedStyle(e,"")||{}}:t.computedStyle=function(e,t){return t?e.currentStyle[t]:e.currentStyle},t.setInnerHtml=function(e,t){var n=e.cloneNode(!1);return n.innerHTML=t,e.parentNode.replaceChild(n,e),n},"textContent"in document.documentElement?(t.setInnerText=function(e,t){e.textContent=t},t.getInnerText=function(e){return e.textContent}):(t.setInnerText=function(e,t){e.innerText=t},t.getInnerText=function(e){return e.innerText}),t.getParentWindow=function(e){return e.defaultView||e.parentWindow}):t.importCssString=function(){}})),ace.define("ace/lib/oop",["require","exports","module"],(function(e,t,n){"use strict";t.inherits=function(e,t){e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}})},t.mixin=function(e,t){for(var n in t)e[n]=t[n];return e},t.implement=function(e,n){t.mixin(e,n)}})),ace.define("ace/lib/keys",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop"],(function(e,t,n){"use strict";e("./fixoldbrowsers");var r=e("./oop"),i=function(){var e,t,n={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(t in n.FUNCTION_KEYS)e=n.FUNCTION_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);for(t in n.PRINTABLE_KEYS)e=n.PRINTABLE_KEYS[t].toLowerCase(),n[e]=parseInt(t,10);return r.mixin(n,n.MODIFIER_KEYS),r.mixin(n,n.PRINTABLE_KEYS),r.mixin(n,n.FUNCTION_KEYS),n.enter=n.return,n.escape=n.esc,n.del=n.delete,n[173]="-",function(){for(var e=["cmd","ctrl","alt","shift"],t=Math.pow(2,e.length);t--;)n.KEY_MODS[t]=e.filter((function(e){return t&n.KEY_MODS[e]})).join("-")+"-"}(),n.KEY_MODS[0]="",n.KEY_MODS[-1]="input-",n}();r.mixin(t,i),t.keyCodeToString=function(e){var t=i[e];return"string"!=typeof t&&(t=String.fromCharCode(e)),t.toLowerCase()}})),ace.define("ace/lib/useragent",["require","exports","module"],(function(e,t,n){"use strict";if(t.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},t.getOS=function(){return t.isMac?t.OS.MAC:t.isLinux?t.OS.LINUX:t.OS.WINDOWS},"object"==typeof navigator){var r=(navigator.platform.match(/mac|win|linux/i)||["other"])[0].toLowerCase(),i=navigator.userAgent;t.isWin="win"==r,t.isMac="mac"==r,t.isLinux="linux"==r,t.isIE="Microsoft Internet Explorer"==navigator.appName||navigator.appName.indexOf("MSAppHost")>=0?parseFloat((i.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((i.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),t.isOldIE=t.isIE&&t.isIE<9,t.isGecko=t.isMozilla=(window.Controllers||window.controllers)&&"Gecko"===window.navigator.product,t.isOldGecko=t.isGecko&&parseInt((i.match(/rv:(\d+)/)||[])[1],10)<4,t.isOpera=window.opera&&"[object Opera]"==Object.prototype.toString.call(window.opera),t.isWebKit=parseFloat(i.split("WebKit/")[1])||void 0,t.isChrome=parseFloat(i.split(" Chrome/")[1])||void 0,t.isAIR=i.indexOf("AdobeAIR")>=0,t.isIPad=i.indexOf("iPad")>=0,t.isChromeOS=i.indexOf(" CrOS ")>=0,t.isIOS=/iPad|iPhone|iPod/.test(i)&&!window.MSStream,t.isIOS&&(t.isMac=!0)}})),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],(function(e,t,n){"use strict";var r=e("./keys"),i=e("./useragent"),o=null,a=0;t.addListener=function(e,t,n){if(e.addEventListener)return e.addEventListener(t,n,!1);if(e.attachEvent){var r=function(){n.call(e,window.event)};n._wrapper=r,e.attachEvent("on"+t,r)}},t.removeListener=function(e,t,n){if(e.removeEventListener)return e.removeEventListener(t,n,!1);e.detachEvent&&e.detachEvent("on"+t,n._wrapper||n)},t.stopEvent=function(e){return t.stopPropagation(e),t.preventDefault(e),!1},t.stopPropagation=function(e){e.stopPropagation?e.stopPropagation():e.cancelBubble=!0},t.preventDefault=function(e){e.preventDefault?e.preventDefault():e.returnValue=!1},t.getButton=function(e){return"dblclick"==e.type?0:"contextmenu"==e.type||i.isMac&&e.ctrlKey&&!e.altKey&&!e.shiftKey?2:e.preventDefault?e.button:{1:0,2:2,4:1}[e.button]},t.capture=function(e,n,r){function i(e){n&&n(e),r&&r(e),t.removeListener(document,"mousemove",n,!0),t.removeListener(document,"mouseup",i,!0),t.removeListener(document,"dragstart",i,!0)}return t.addListener(document,"mousemove",n,!0),t.addListener(document,"mouseup",i,!0),t.addListener(document,"dragstart",i,!0),i},t.addTouchMoveListener=function(e,n){var r,i;t.addListener(e,"touchstart",(function(e){var t=e.touches[0];r=t.clientX,i=t.clientY})),t.addListener(e,"touchmove",(function(e){var t=e.touches;if(!(t.length>1)){var o=t[0];e.wheelX=r-o.clientX,e.wheelY=i-o.clientY,r=o.clientX,i=o.clientY,n(e)}}))},t.addMouseWheelListener=function(e,n){"onmousewheel"in e?t.addListener(e,"mousewheel",(function(e){void 0!==e.wheelDeltaX?(e.wheelX=-e.wheelDeltaX/8,e.wheelY=-e.wheelDeltaY/8):(e.wheelX=0,e.wheelY=-e.wheelDelta/8),n(e)})):"onwheel"in e?t.addListener(e,"wheel",(function(e){switch(e.deltaMode){case e.DOM_DELTA_PIXEL:e.wheelX=.35*e.deltaX||0,e.wheelY=.35*e.deltaY||0;break;case e.DOM_DELTA_LINE:case e.DOM_DELTA_PAGE:e.wheelX=5*(e.deltaX||0),e.wheelY=5*(e.deltaY||0)}n(e)})):t.addListener(e,"DOMMouseScroll",(function(e){e.axis&&e.axis==e.HORIZONTAL_AXIS?(e.wheelX=5*(e.detail||0),e.wheelY=0):(e.wheelX=0,e.wheelY=5*(e.detail||0)),n(e)}))},t.addMultiMouseDownListener=function(e,n,r,o){var a,s,c,l=0,u={2:"dblclick",3:"tripleclick",4:"quadclick"};function h(e){if(0!==t.getButton(e)?l=0:e.detail>1?++l>4&&(l=1):l=1,i.isIE){var h=Math.abs(e.clientX-a)>5||Math.abs(e.clientY-s)>5;c&&!h||(l=1),c&&clearTimeout(c),c=setTimeout((function(){c=null}),n[l-1]||600),1==l&&(a=e.clientX,s=e.clientY)}if(e._clicks=l,r[o]("mousedown",e),l>4)l=0;else if(l>1)return r[o](u[l],e)}function d(e){l=2,c&&clearTimeout(c),c=setTimeout((function(){c=null}),n[l-1]||600),r[o]("mousedown",e),r[o](u[l],e)}Array.isArray(e)||(e=[e]),e.forEach((function(e){t.addListener(e,"mousedown",h),i.isOldIE&&t.addListener(e,"dblclick",d)}))};var s=i.isMac&&i.isOpera&&!("KeyboardEvent"in window)?function(e){return 0|(e.metaKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.ctrlKey?8:0)}:function(e){return 0|(e.ctrlKey?1:0)|(e.altKey?2:0)|(e.shiftKey?4:0)|(e.metaKey?8:0)};function c(e,t,n){var c=s(t);if(!i.isMac&&o){if(t.getModifierState&&(t.getModifierState("OS")||t.getModifierState("Win"))&&(c|=8),o.altGr){if(3==(3&c))return;o.altGr=0}if(18===n||17===n){var l="location"in t?t.location:t.keyLocation;if(17===n&&1===l)1==o[n]&&(a=t.timeStamp);else if(18===n&&3===c&&2===l){t.timeStamp-a<50&&(o.altGr=!0)}}}if((n in r.MODIFIER_KEYS&&(n=-1),8&c&&n>=91&&n<=93&&(n=-1),!c&&13===n)&&(3===(l="location"in t?t.location:t.keyLocation)&&(e(t,c,-n),t.defaultPrevented)))return;if(i.isChromeOS&&8&c){if(e(t,c,n),t.defaultPrevented)return;c&=-9}return!!(c||n in r.FUNCTION_KEYS||n in r.PRINTABLE_KEYS)&&e(t,c,n)}function l(){o=Object.create(null)}if(t.getModifierString=function(e){return r.KEY_MODS[s(e)]},t.addCommandKeyListener=function(e,n){var r=t.addListener;if(i.isOldGecko||i.isOpera&&!("KeyboardEvent"in window)){var a=null;r(e,"keydown",(function(e){a=e.keyCode})),r(e,"keypress",(function(e){return c(n,e,a)}))}else{var s=null;r(e,"keydown",(function(e){o[e.keyCode]=(o[e.keyCode]||0)+1;var t=c(n,e,e.keyCode);return s=e.defaultPrevented,t})),r(e,"keypress",(function(e){s&&(e.ctrlKey||e.altKey||e.shiftKey||e.metaKey)&&(t.stopEvent(e),s=null)})),r(e,"keyup",(function(e){o[e.keyCode]=null})),o||(l(),r(window,"focus",l))}},"object"==typeof window&&window.postMessage&&!i.isOldIE){t.nextTick=function(e,n){n=n||window;t.addListener(n,"message",(function r(i){"zero-timeout-message-1"==i.data&&(t.stopPropagation(i),t.removeListener(n,"message",r),e())})),n.postMessage("zero-timeout-message-1","*")}}t.nextFrame="object"==typeof window&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),t.nextFrame?t.nextFrame=t.nextFrame.bind(window):t.nextFrame=function(e){setTimeout(e,17)}})),ace.define("ace/lib/lang",["require","exports","module"],(function(e,t,n){"use strict";t.last=function(e){return e[e.length-1]},t.stringReverse=function(e){return e.split("").reverse().join("")},t.stringRepeat=function(e,t){for(var n="";t>0;)1&t&&(n+=e),(t>>=1)&&(e+=e);return n};var r=/^\s\s*/,i=/\s\s*$/;t.stringTrimLeft=function(e){return e.replace(r,"")},t.stringTrimRight=function(e){return e.replace(i,"")},t.copyObject=function(e){var t={};for(var n in e)t[n]=e[n];return t},t.copyArray=function(e){for(var t=[],n=0,r=e.length;n<r;n++)e[n]&&"object"==typeof e[n]?t[n]=this.copyObject(e[n]):t[n]=e[n];return t},t.deepCopy=function e(t){if("object"!=typeof t||!t)return t;var n;if(Array.isArray(t)){n=[];for(var r=0;r<t.length;r++)n[r]=e(t[r]);return n}if("[object Object]"!==Object.prototype.toString.call(t))return t;for(var r in n={},t)n[r]=e(t[r]);return n},t.arrayToMap=function(e){for(var t={},n=0;n<e.length;n++)t[e[n]]=1;return t},t.createMap=function(e){var t=Object.create(null);for(var n in e)t[n]=e[n];return t},t.arrayRemove=function(e,t){for(var n=0;n<=e.length;n++)t===e[n]&&e.splice(n,1)},t.escapeRegExp=function(e){return e.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},t.escapeHTML=function(e){return e.replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},t.getMatchOffsets=function(e,t){var n=[];return e.replace(t,(function(e){n.push({offset:arguments[arguments.length-2],length:e.length})})),n},t.deferredCall=function(e){var t=null,n=function(){t=null,e()},r=function(e){return r.cancel(),t=setTimeout(n,e||0),r};return r.schedule=r,r.call=function(){return this.cancel(),e(),r},r.cancel=function(){return clearTimeout(t),t=null,r},r.isPending=function(){return t},r},t.delayedCall=function(e,t){var n=null,r=function(){n=null,e()},i=function(e){null==n&&(n=setTimeout(r,e||t))};return i.delay=function(e){n&&clearTimeout(n),n=setTimeout(r,e||t)},i.schedule=i,i.call=function(){this.cancel(),e()},i.cancel=function(){n&&clearTimeout(n),n=null},i.isPending=function(){return n},i}})),ace.define("ace/keyboard/textinput_ios",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/lib/keys"],(function(e,t,n){"use strict";var r=e("../lib/event"),i=e("../lib/useragent"),o=e("../lib/dom"),a=e("../lib/lang"),s=e("../lib/keys"),c=s.KEY_MODS,l=i.isChrome<18,u=i.isIE;t.TextInput=function(e,t){var n=o.createElement("textarea");n.className=i.isIOS?"ace_text-input ace_text-input-ios":"ace_text-input",i.isTouchPad&&n.setAttribute("x-palm-disable-auto-cap",!0),n.setAttribute("wrap","off"),n.setAttribute("autocorrect","off"),n.setAttribute("autocapitalize","off"),n.setAttribute("spellcheck",!1),n.style.opacity="0",e.insertBefore(n,e.firstChild);var h=!1,d=!1,f=!1,p=!1,m="",g=!0;try{var v=document.activeElement===n}catch(e){}r.addListener(n,"blur",(function(e){t.onBlur(e),v=!1})),r.addListener(n,"focus",(function(e){v=!0,t.onFocus(e),w()})),this.focus=function(){if(m)return n.focus();n.style.position="fixed",n.focus()},this.blur=function(){n.blur()},this.isFocused=function(){return v};var y=a.delayedCall((function(){v&&w(g)})),b=a.delayedCall((function(){p||(n.value="\n aaaa a\n",v&&w())}));function w(e){if(!p){if(p=!0,_)t=0,r=e?0:n.value.length-1;else var t=4,r=5;try{n.setSelectionRange(t,r)}catch(e){}p=!1}}function x(){p||(n.value="\n aaaa a\n",i.isWebKit&&b.schedule())}i.isWebKit||t.addEventListener("changeSelection",(function(){t.selection.isEmpty()!=g&&(g=!g,y.schedule())})),x(),v&&t.onFocus();var _=null;this.setInputHandler=function(e){_=e},this.getInputHandler=function(){return _};var E=!1,S=function(e){4===n.selectionStart&&5===n.selectionEnd||(_&&(e=_(e),_=null),f?(w(),e&&t.onPaste(e),f=!1):e=="\n aaaa a\n".substr(0)&&4===n.selectionStart?E?t.execCommand("del",{source:"ace"}):t.execCommand("backspace",{source:"ace"}):h||("\n aaaa a\n"==e.substring(0,9)&&e.length>"\n aaaa a\n".length?e=e.substr(9):e.substr(0,4)=="\n aaaa a\n".substr(0,4)?e=e.substr(4,e.length-"\n aaaa a\n".length+1):e.charAt(e.length-1)=="\n aaaa a\n".charAt(0)&&(e=e.slice(0,-1)),e=="\n aaaa a\n".charAt(0)||e.charAt(e.length-1)=="\n aaaa a\n".charAt(0)&&(e=e.slice(0,-1)),e&&t.onTextInput(e)),h&&(h=!1),E&&(E=!1))},C=function(e){if(!p){var t=n.value;S(t),x()}},A=function(e,t,n){var r=e.clipboardData||window.clipboardData;if(r&&!l){var i=u||n?"Text":"text/plain";try{return t?!1!==r.setData(i,t):r.getData(i)}catch(e){if(!n)return A(e,t,!0)}}},T=function(e,o){var a=t.getCopyText();if(!a)return r.preventDefault(e);A(e,a)?(i.isIOS&&(d=o,n.value="\n aa"+a+"a a\n",n.setSelectionRange(4,4+a.length),h={value:a}),o?t.onCut():t.onCopy(),i.isIOS||r.preventDefault(e)):(h=!0,n.value=a,n.select(),setTimeout((function(){h=!1,x(),w(),o?t.onCut():t.onCopy()})))};r.addCommandKeyListener(n,t.onCommandKey.bind(t)),r.addListener(n,"select",(function(e){!function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length}(n)?_&&w(t.selection.isEmpty()):(t.selectAll(),w())})),r.addListener(n,"input",C),r.addListener(n,"cut",(function(e){T(e,!0)})),r.addListener(n,"copy",(function(e){T(e,!1)})),r.addListener(n,"paste",(function(e){var o=A(e);"string"==typeof o?(o&&t.onPaste(o,e),i.isIE&&setTimeout(w),r.preventDefault(e)):(n.value="",f=!0)}));var M,O=function(){if(p&&t.onCompositionUpdate&&!t.$readOnly){var e=n.value.replace(/\x01/g,"");if(p.lastValue!==e&&(t.onCompositionUpdate(e),p.lastValue&&t.undo(),p.canUndo&&(p.lastValue=e),p.lastValue)){var r=t.selection.getRange();t.insert(p.lastValue),t.session.markUndoGroup(),p.range=t.selection.getRange(),t.selection.setRange(r),t.selection.clearSelection()}}},k=function(e){if(t.onCompositionEnd&&!t.$readOnly){var r=p;p=!1;var o=setTimeout((function(){o=null;var e=n.value.replace(/\x01/g,"");p||(e==r.lastValue?x():!r.lastValue&&e&&(x(),S(e)))}));_=function(e){return o&&clearTimeout(o),(e=e.replace(/\x01/g,""))==r.lastValue?"":(r.lastValue&&o&&t.undo(),e)},t.onCompositionEnd(),t.removeListener("mousedown",k),"compositionend"==e.type&&r.range&&t.selection.setRange(r.range),(!!i.isChrome&&i.isChrome>=53||!!i.isWebKit&&i.isWebKit>=603)&&C()}},R=a.delayedCall(O,50);function P(){clearTimeout(M),M=setTimeout((function(){m&&(n.style.cssText=m,m=""),null==t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=!0,t.renderer.$moveTextAreaToCursor())}),0)}r.addListener(n,"compositionstart",(function(e){p||!t.onCompositionStart||t.$readOnly||((p={}).canUndo=t.session.$undoManager,t.onCompositionStart(),setTimeout(O,0),t.on("mousedown",k),p.canUndo&&!t.selection.isEmpty()&&(t.insert(""),t.session.markUndoGroup(),t.selection.clearSelection()),t.session.markUndoGroup())})),i.isGecko?r.addListener(n,"text",(function(){R.schedule()})):(r.addListener(n,"keyup",(function(){R.schedule()})),r.addListener(n,"keydown",(function(){R.schedule()}))),r.addListener(n,"compositionend",k),this.getElement=function(){return n},this.setReadOnly=function(e){n.readOnly=e},this.onContextMenu=function(e){E=!0,w(t.selection.isEmpty()),t._emit("nativecontextmenu",{target:t,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,a){m||(m=n.style.cssText),n.style.cssText=(a?"z-index:100000;":"")+"height:"+n.style.height+";"+(i.isIE?"opacity:0.1;":"");var s=t.container.getBoundingClientRect(),c=o.computedStyle(t.container),l=s.top+(parseInt(c.borderTopWidth)||0),u=s.left+(parseInt(s.borderLeftWidth)||0),h=s.bottom-l-n.clientHeight-2,d=function(e){n.style.left=e.clientX-u-2+"px",n.style.top=Math.min(e.clientY-l-2,h)+"px"};d(e),"mousedown"==e.type&&(t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=null),clearTimeout(M),i.isWin&&r.capture(t.container,d,P))},this.onContextMenuClose=P;var L=function(e){t.textInput.onContextMenu(e),P()};if(r.addListener(n,"mouseup",L),r.addListener(n,"mousedown",(function(e){e.preventDefault(),P()})),r.addListener(t.renderer.scroller,"contextmenu",L),r.addListener(n,"contextmenu",L),i.isIOS){var F=null,j=!1;e.addEventListener("keydown",(function(e){F&&clearTimeout(F),j=!0})),e.addEventListener("keyup",(function(e){F=setTimeout((function(){j=!1}),100)}));var D=function(e){if(document.activeElement===n&&!j){if(d)return setTimeout((function(){d=!1}),100);var r=n.selectionStart,i=n.selectionEnd;if(n.setSelectionRange(4,5),r==i)switch(r){case 0:t.onCommandKey(null,0,s.up);break;case 1:t.onCommandKey(null,0,s.home);break;case 2:t.onCommandKey(null,c.option,s.left);break;case 4:t.onCommandKey(null,0,s.left);break;case 5:t.onCommandKey(null,0,s.right);break;case 7:t.onCommandKey(null,c.option,s.right);break;case 8:t.onCommandKey(null,0,s.end);break;case 9:t.onCommandKey(null,0,s.down)}else{switch(i){case 6:t.onCommandKey(null,c.shift,s.right);break;case 7:t.onCommandKey(null,c.shift|c.option,s.right);break;case 8:t.onCommandKey(null,c.shift,s.end);break;case 9:t.onCommandKey(null,c.shift,s.down)}switch(r){case 0:t.onCommandKey(null,c.shift,s.up);break;case 1:t.onCommandKey(null,c.shift,s.home);break;case 2:t.onCommandKey(null,c.shift|c.option,s.left);break;case 3:t.onCommandKey(null,c.shift,s.left)}}}};document.addEventListener("selectionchange",D),t.on("destroy",(function(){document.removeEventListener("selectionchange",D)}))}}})),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/keyboard/textinput_ios"],(function(e,t,n){"use strict";var r=e("../lib/event"),i=e("../lib/useragent"),o=e("../lib/dom"),a=e("../lib/lang"),s=i.isChrome<18,c=i.isIE,l=e("./textinput_ios").TextInput;t.TextInput=function(e,t){if(i.isIOS)return l.call(this,e,t);var n=o.createElement("textarea");n.className="ace_text-input",n.setAttribute("wrap","off"),n.setAttribute("autocorrect","off"),n.setAttribute("autocapitalize","off"),n.setAttribute("spellcheck",!1),n.style.opacity="0",e.insertBefore(n,e.firstChild);var u=!1,h=!1,d=!1,f="",p=!0;try{var m=document.activeElement===n}catch(e){}r.addListener(n,"blur",(function(e){t.onBlur(e),m=!1})),r.addListener(n,"focus",(function(e){m=!0,t.onFocus(e),y()})),this.focus=function(){if(f)return n.focus();var e=n.style.top;n.style.position="fixed",n.style.top="0px",n.focus(),setTimeout((function(){n.style.position="","0px"==n.style.top&&(n.style.top=e)}),0)},this.blur=function(){n.blur()},this.isFocused=function(){return m};var g=a.delayedCall((function(){m&&y(p)})),v=a.delayedCall((function(){d||(n.value="\u2028\u2028",m&&y())}));function y(e){if(!d){if(d=!0,w)var t=0,r=e?0:n.value.length-1;else t=e?2:1,r=2;try{n.setSelectionRange(t,r)}catch(e){}d=!1}}function b(){d||(n.value="\u2028\u2028",i.isWebKit&&v.schedule())}i.isWebKit||t.addEventListener("changeSelection",(function(){t.selection.isEmpty()!=p&&(p=!p,g.schedule())})),b(),m&&t.onFocus();var w=null;this.setInputHandler=function(e){w=e},this.getInputHandler=function(){return w};var x=!1,_=function(e){w&&(e=w(e),w=null),h?(y(),e&&t.onPaste(e),h=!1):e=="\u2028\u2028".charAt(0)?x?t.execCommand("del",{source:"ace"}):t.execCommand("backspace",{source:"ace"}):("\u2028\u2028"==e.substring(0,2)?e=e.substr(2):e.charAt(0)=="\u2028\u2028".charAt(0)?e=e.substr(1):e.charAt(e.length-1)=="\u2028\u2028".charAt(0)&&(e=e.slice(0,-1)),e.charAt(e.length-1)=="\u2028\u2028".charAt(0)&&(e=e.slice(0,-1)),e&&t.onTextInput(e)),x&&(x=!1)},E=function(e){if(!d){var t=n.value;_(t),b()}},S=function(e,t,n){var r=e.clipboardData||window.clipboardData;if(r&&!s){var i=c||n?"Text":"text/plain";try{return t?!1!==r.setData(i,t):r.getData(i)}catch(e){if(!n)return S(e,t,!0)}}},C=function(e,i){var o=t.getCopyText();if(!o)return r.preventDefault(e);S(e,o)?(i?t.onCut():t.onCopy(),r.preventDefault(e)):(u=!0,n.value=o,n.select(),setTimeout((function(){u=!1,b(),y(),i?t.onCut():t.onCopy()})))},A=function(e){C(e,!0)},T=function(e){C(e,!1)},M=function(e){var o=S(e);"string"==typeof o?(o&&t.onPaste(o,e),i.isIE&&setTimeout(y),r.preventDefault(e)):(n.value="",h=!0)};r.addCommandKeyListener(n,t.onCommandKey.bind(t)),r.addListener(n,"select",(function(e){u?u=!1:!function(e){return 0===e.selectionStart&&e.selectionEnd===e.value.length}(n)?w&&y(t.selection.isEmpty()):(t.selectAll(),y())})),r.addListener(n,"input",E),r.addListener(n,"cut",A),r.addListener(n,"copy",T),r.addListener(n,"paste",M),"oncut"in n&&"oncopy"in n&&"onpaste"in n||r.addListener(e,"keydown",(function(e){if((!i.isMac||e.metaKey)&&e.ctrlKey)switch(e.keyCode){case 67:T(e);break;case 86:M(e);break;case 88:A(e)}}));var O,k=function(){if(d&&t.onCompositionUpdate&&!t.$readOnly){var e=n.value.replace(/\u2028/g,"");if(d.lastValue!==e&&(t.onCompositionUpdate(e),d.lastValue&&t.undo(),d.canUndo&&(d.lastValue=e),d.lastValue)){var r=t.selection.getRange();t.insert(d.lastValue),t.session.markUndoGroup(),d.range=t.selection.getRange(),t.selection.setRange(r),t.selection.clearSelection()}}},R=function(e){if(t.onCompositionEnd&&!t.$readOnly){var r=d;d=!1;var o=setTimeout((function(){o=null;var e=n.value.replace(/\u2028/g,"");d||(e==r.lastValue?b():!r.lastValue&&e&&(b(),_(e)))}));w=function(e){return o&&clearTimeout(o),(e=e.replace(/\u2028/g,""))==r.lastValue?"":(r.lastValue&&o&&t.undo(),e)},t.onCompositionEnd(),t.removeListener("mousedown",R),"compositionend"==e.type&&r.range&&t.selection.setRange(r.range),(!!i.isChrome&&i.isChrome>=53||!!i.isWebKit&&i.isWebKit>=603)&&E()}},P=a.delayedCall(k,50);function L(){clearTimeout(O),O=setTimeout((function(){f&&(n.style.cssText=f,f=""),null==t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=!0,t.renderer.$moveTextAreaToCursor())}),0)}r.addListener(n,"compositionstart",(function(e){d||!t.onCompositionStart||t.$readOnly||((d={}).canUndo=t.session.$undoManager,t.onCompositionStart(),setTimeout(k,0),t.on("mousedown",R),d.canUndo&&!t.selection.isEmpty()&&(t.insert(""),t.session.markUndoGroup(),t.selection.clearSelection()),t.session.markUndoGroup())})),i.isGecko?r.addListener(n,"text",(function(){P.schedule()})):(r.addListener(n,"keyup",(function(){P.schedule()})),r.addListener(n,"keydown",(function(){P.schedule()}))),r.addListener(n,"compositionend",R),this.getElement=function(){return n},this.setReadOnly=function(e){n.readOnly=e},this.onContextMenu=function(e){x=!0,y(t.selection.isEmpty()),t._emit("nativecontextmenu",{target:t,domEvent:e}),this.moveToMouse(e,!0)},this.moveToMouse=function(e,a){f||(f=n.style.cssText),n.style.cssText=(a?"z-index:100000;":"")+"height:"+n.style.height+";"+(i.isIE?"opacity:0.1;":"");var s=t.container.getBoundingClientRect(),c=o.computedStyle(t.container),l=s.top+(parseInt(c.borderTopWidth)||0),u=s.left+(parseInt(s.borderLeftWidth)||0),h=s.bottom-l-n.clientHeight-2,d=function(e){n.style.left=e.clientX-u-2+"px",n.style.top=Math.min(e.clientY-l-2,h)+"px"};d(e),"mousedown"==e.type&&(t.renderer.$keepTextAreaAtCursor&&(t.renderer.$keepTextAreaAtCursor=null),clearTimeout(O),i.isWin&&r.capture(t.container,d,L))},this.onContextMenuClose=L;var F=function(e){t.textInput.onContextMenu(e),L()};r.addListener(n,"mouseup",F),r.addListener(n,"mousedown",(function(e){e.preventDefault(),L()})),r.addListener(t.renderer.scroller,"contextmenu",F),r.addListener(n,"contextmenu",F)}})),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],(function(e,t,n){"use strict";e("../lib/dom"),e("../lib/event");var r=e("../lib/useragent");function i(e){e.$clickSelection=null;var t=e.editor;t.setDefaultHandler("mousedown",this.onMouseDown.bind(e)),t.setDefaultHandler("dblclick",this.onDoubleClick.bind(e)),t.setDefaultHandler("tripleclick",this.onTripleClick.bind(e)),t.setDefaultHandler("quadclick",this.onQuadClick.bind(e)),t.setDefaultHandler("mousewheel",this.onMouseWheel.bind(e)),t.setDefaultHandler("touchmove",this.onTouchMove.bind(e));["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach((function(t){e[t]=this[t]}),this),e.selectByLines=this.extendSelectionBy.bind(e,"getLineRange"),e.selectByWords=this.extendSelectionBy.bind(e,"getWordRange")}function o(e,t){if(e.start.row==e.end.row)var n=2*t.column-e.start.column-e.end.column;else if(e.start.row!=e.end.row-1||e.start.column||e.end.column)n=2*t.row-e.start.row-e.end.row;else var n=t.column-4;return n<0?{cursor:e.start,anchor:e.end}:{cursor:e.end,anchor:e.start}}(function(){this.onMouseDown=function(e){var t=e.inSelection(),n=e.getDocumentPosition();this.mousedownEvent=e;var i=this.editor,o=e.getButton();if(0!==o){var a=i.getSelectionRange().isEmpty();return i.$blockScrolling++,(a||1==o)&&i.selection.moveToPosition(n),i.$blockScrolling--,void(2==o&&(i.textInput.onContextMenu(e.domEvent),r.isMozilla||e.preventDefault()))}return this.mousedownEvent.time=Date.now(),!t||i.isFocused()||(i.focus(),!this.$focusTimout||this.$clickSelection||i.inMultiSelectMode)?(this.captureMouse(e),this.startSelect(n,e.domEvent._clicks>1),e.preventDefault()):(this.setState("focusWait"),void this.captureMouse(e))},this.startSelect=function(e,t){e=e||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var n=this.editor;n.$blockScrolling++,this.mousedownEvent.getShiftKey()?n.selection.selectToPosition(e):t||n.selection.moveToPosition(e),t||this.select(),n.renderer.scroller.setCapture&&n.renderer.scroller.setCapture(),n.setStyle("ace_selecting"),this.setState("select"),n.$blockScrolling--},this.select=function(){var e,t=this.editor,n=t.renderer.screenToTextCoordinates(this.x,this.y);if(t.$blockScrolling++,this.$clickSelection){var r=this.$clickSelection.comparePoint(n);if(-1==r)e=this.$clickSelection.end;else if(1==r)e=this.$clickSelection.start;else{var i=o(this.$clickSelection,n);n=i.cursor,e=i.anchor}t.selection.setSelectionAnchor(e.row,e.column)}t.selection.selectToPosition(n),t.$blockScrolling--,t.renderer.scrollCursorIntoView()},this.extendSelectionBy=function(e){var t,n=this.editor,r=n.renderer.screenToTextCoordinates(this.x,this.y),i=n.selection[e](r.row,r.column);if(n.$blockScrolling++,this.$clickSelection){var a=this.$clickSelection.comparePoint(i.start),s=this.$clickSelection.comparePoint(i.end);if(-1==a&&s<=0)t=this.$clickSelection.end,i.end.row==r.row&&i.end.column==r.column||(r=i.start);else if(1==s&&a>=0)t=this.$clickSelection.start,i.start.row==r.row&&i.start.column==r.column||(r=i.end);else if(-1==a&&1==s)r=i.end,t=i.start;else{var c=o(this.$clickSelection,r);r=c.cursor,t=c.anchor}n.selection.setSelectionAnchor(t.row,t.column)}n.selection.selectToPosition(r),n.$blockScrolling--,n.renderer.scrollCursorIntoView()},this.selectEnd=this.selectAllEnd=this.selectByWordsEnd=this.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting"),this.editor.renderer.scroller.releaseCapture&&this.editor.renderer.scroller.releaseCapture()},this.focusWait=function(){var e,t,n,r,i=(e=this.mousedownEvent.x,t=this.mousedownEvent.y,n=this.x,r=this.y,Math.sqrt(Math.pow(n-e,2)+Math.pow(r-t,2))),o=Date.now();(i>0||o-this.mousedownEvent.time>this.$focusTimout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},this.onDoubleClick=function(e){var t=e.getDocumentPosition(),n=this.editor,r=n.session.getBracketRange(t);r?(r.isEmpty()&&(r.start.column--,r.end.column++),this.setState("select")):(r=n.selection.getWordRange(t.row,t.column),this.setState("selectByWords")),this.$clickSelection=r,this.select()},this.onTripleClick=function(e){var t=e.getDocumentPosition(),n=this.editor;this.setState("selectByLines");var r=n.getSelectionRange();r.isMultiLine()&&r.contains(t.row,t.column)?(this.$clickSelection=n.selection.getLineRange(r.start.row),this.$clickSelection.end=n.selection.getLineRange(r.end.row).end):this.$clickSelection=n.selection.getLineRange(t.row),this.select()},this.onQuadClick=function(e){var t=this.editor;t.selectAll(),this.$clickSelection=t.getSelectionRange(),this.setState("selectAll")},this.onMouseWheel=function(e){if(!e.getAccelKey()){e.getShiftKey()&&e.wheelY&&!e.wheelX&&(e.wheelX=e.wheelY,e.wheelY=0);var t=this.editor;this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0});var n=this.$lastScroll,r=e.domEvent.timeStamp,i=r-n.t,o=e.wheelX/i,a=e.wheelY/i;i<250&&(o=(o+n.vx)/2,a=(a+n.vy)/2);var s=Math.abs(o/a),c=!1;if(s>=1&&t.renderer.isScrollableBy(e.wheelX*e.speed,0)&&(c=!0),s<=1&&t.renderer.isScrollableBy(0,e.wheelY*e.speed)&&(c=!0),c)n.allowed=r;else if(r-n.allowed<250){Math.abs(o)<=1.1*Math.abs(n.vx)&&Math.abs(a)<=1.1*Math.abs(n.vy)?(c=!0,n.allowed=r):n.allowed=0}return n.t=r,n.vx=o,n.vy=a,c?(t.renderer.scrollBy(e.wheelX*e.speed,e.wheelY*e.speed),e.stop()):void 0}},this.onTouchMove=function(e){this.editor._emit("mousewheel",e)}}).call(i.prototype),t.DefaultHandlers=i})),ace.define("ace/tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom"],(function(e,t,n){"use strict";e("./lib/oop");var r=e("./lib/dom");function i(e){this.isOpen=!1,this.$element=null,this.$parentNode=e}(function(){this.$init=function(){return this.$element=r.createElement("div"),this.$element.className="ace_tooltip",this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},this.getElement=function(){return this.$element||this.$init()},this.setText=function(e){r.setInnerText(this.getElement(),e)},this.setHtml=function(e){this.getElement().innerHTML=e},this.setPosition=function(e,t){this.getElement().style.left=e+"px",this.getElement().style.top=t+"px"},this.setClassName=function(e){r.addCssClass(this.getElement(),e)},this.show=function(e,t,n){null!=e&&this.setText(e),null!=t&&null!=n&&this.setPosition(t,n),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},this.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.isOpen=!1)},this.getHeight=function(){return this.getElement().offsetHeight},this.getWidth=function(){return this.getElement().offsetWidth},this.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)}}).call(i.prototype),t.Tooltip=i})),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event","ace/tooltip"],(function(e,t,n){"use strict";var r=e("../lib/dom"),i=e("../lib/oop"),o=e("../lib/event"),a=e("../tooltip").Tooltip;function s(e){a.call(this,e)}i.inherits(s,a),function(){this.setPosition=function(e,t){var n=window.innerWidth||document.documentElement.clientWidth,r=window.innerHeight||document.documentElement.clientHeight,i=this.getWidth(),o=this.getHeight();(e+=15)+i>n&&(e-=e+i-n),(t+=15)+o>r&&(t-=20+o),a.prototype.setPosition.call(this,e,t)}}.call(s.prototype),t.GutterHandler=function(e){var t,n,i,a=e.editor,c=a.renderer.$gutterLayer,l=new s(a.container);function u(){t&&(t=clearTimeout(t)),i&&(l.hide(),i=null,a._signal("hideGutterTooltip",l),a.removeEventListener("mousewheel",u))}function h(e){l.setPosition(e.x,e.y)}e.editor.setDefaultHandler("guttermousedown",(function(t){if(a.isFocused()&&0==t.getButton()&&"foldWidgets"!=c.getRegion(t)){var n=t.getDocumentPosition().row,r=a.session.selection;if(t.getShiftKey())r.selectTo(n,0);else{if(2==t.domEvent.detail)return a.selectAll(),t.preventDefault();e.$clickSelection=a.selection.getLineRange(n)}return e.setState("selectByLines"),e.captureMouse(t),t.preventDefault()}})),e.editor.setDefaultHandler("guttermousemove",(function(o){var s=o.domEvent.target||o.domEvent.srcElement;if(r.hasCssClass(s,"ace_fold-widget"))return u();i&&e.$tooltipFollowsMouse&&h(o),n=o,t||(t=setTimeout((function(){t=null,n&&!e.isMousePressed?function(){var t=n.getDocumentPosition().row,r=c.$annotations[t];if(!r)return u();if(t==a.session.getLength()){var o=a.renderer.pixelToScreenCoordinates(0,n.y).row,s=n.$pos;if(o>a.session.documentToScreenRow(s.row,s.column))return u()}if(i!=r)if(i=r.text.join("<br/>"),l.setHtml(i),l.show(),a._signal("showGutterTooltip",l),a.on("mousewheel",u),e.$tooltipFollowsMouse)h(n);else{var d=n.domEvent.target.getBoundingClientRect(),f=l.getElement().style;f.left=d.right+"px",f.top=d.bottom+"px"}}():u()}),50))})),o.addListener(a.renderer.$gutter,"mouseout",(function(e){n=null,i&&!t&&(t=setTimeout((function(){t=null,u()}),50))})),a.on("changeSession",u)}})),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],(function(e,t,n){"use strict";var r=e("../lib/event"),i=e("../lib/useragent"),o=t.MouseEvent=function(e,t){this.domEvent=e,this.editor=t,this.x=this.clientX=e.clientX,this.y=this.clientY=e.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1};(function(){this.stopPropagation=function(){r.stopPropagation(this.domEvent),this.propagationStopped=!0},this.preventDefault=function(){r.preventDefault(this.domEvent),this.defaultPrevented=!0},this.stop=function(){this.stopPropagation(),this.preventDefault()},this.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},this.inSelection=function(){if(null!==this.$inSelection)return this.$inSelection;var e=this.editor.getSelectionRange();if(e.isEmpty())this.$inSelection=!1;else{var t=this.getDocumentPosition();this.$inSelection=e.contains(t.row,t.column)}return this.$inSelection},this.getButton=function(){return r.getButton(this.domEvent)},this.getShiftKey=function(){return this.domEvent.shiftKey},this.getAccelKey=i.isMac?function(){return this.domEvent.metaKey}:function(){return this.domEvent.ctrlKey}}).call(o.prototype)})),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],(function(e,t,n){"use strict";var r=e("../lib/dom"),i=e("../lib/event"),o=e("../lib/useragent");function a(e){var t=e.editor,n=r.createElement("img");n.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==",o.isOpera&&(n.style.cssText="width:1px;height:1px;position:fixed;top:0;left:0;z-index:2147483647;opacity:0;");["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach((function(t){e[t]=this[t]}),this),t.addEventListener("mousedown",this.onMouseDown.bind(e));var a,c,l,u,h,d,f,p,m,g,v,y=t.container,b=0;function w(){var e=d;(function(e,n){var r=Date.now(),i=!n||e.row!=n.row,o=!n||e.column!=n.column;!g||i||o?(t.$blockScrolling+=1,t.moveCursorToPosition(e),t.$blockScrolling-=1,g=r,v={x:c,y:l}):s(v.x,v.y,c,l)>5?g=null:r-g>=200&&(t.renderer.scrollCursorIntoView(),g=null)})(d=t.renderer.screenToTextCoordinates(c,l),e),function(e,n){var r=Date.now(),i=t.renderer.layerConfig.lineHeight,o=t.renderer.layerConfig.characterWidth,a=t.renderer.scroller.getBoundingClientRect(),s={x:{left:c-a.left,right:a.right-c},y:{top:l-a.top,bottom:a.bottom-l}},u=Math.min(s.x.left,s.x.right),h=Math.min(s.y.top,s.y.bottom),d={row:e.row,column:e.column};u/o<=2&&(d.column+=s.x.left<s.x.right?-3:2),h/i<=1&&(d.row+=s.y.top<s.y.bottom?-1:1);var f=e.row!=d.row,p=e.column!=d.column,g=!n||e.row!=n.row;f||p&&!g?m?r-m>=200&&t.renderer.scrollCursorIntoView(d):m=r:m=null}(d,e)}function x(){h=t.selection.toOrientedRange(),a=t.session.addMarker(h,"ace_selection",t.getSelectionStyle()),t.clearSelection(),t.isFocused()&&t.renderer.$cursorLayer.setBlinking(!1),clearInterval(u),w(),u=setInterval(w,20),b=0,i.addListener(document,"mousemove",S)}function _(){clearInterval(u),t.session.removeMarker(a),a=null,t.$blockScrolling+=1,t.selection.fromOrientedRange(h),t.$blockScrolling-=1,t.isFocused()&&!p&&t.renderer.$cursorLayer.setBlinking(!t.getReadOnly()),h=null,d=null,b=0,m=null,g=null,i.removeListener(document,"mousemove",S)}this.onDragStart=function(e){if(this.cancelDrag||!y.draggable){var r=this;return setTimeout((function(){r.startSelect(),r.captureMouse(e)}),0),e.preventDefault()}h=t.getSelectionRange();var i=e.dataTransfer;i.effectAllowed=t.getReadOnly()?"copy":"copyMove",o.isOpera&&(t.container.appendChild(n),n.scrollTop=0),i.setDragImage&&i.setDragImage(n,0,0),o.isOpera&&t.container.removeChild(n),i.clearData(),i.setData("Text",t.session.getTextRange()),p=!0,this.setState("drag")},this.onDragEnd=function(e){if(y.draggable=!1,p=!1,this.setState(null),!t.getReadOnly()){var n=e.dataTransfer.dropEffect;f||"move"!=n||t.session.remove(t.getSelectionRange()),t.renderer.$cursorLayer.setBlinking(!0)}this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(e){if(!t.getReadOnly()&&C(e.dataTransfer))return c=e.clientX,l=e.clientY,a||x(),b++,e.dataTransfer.dropEffect=f=A(e),i.preventDefault(e)},this.onDragOver=function(e){if(!t.getReadOnly()&&C(e.dataTransfer))return c=e.clientX,l=e.clientY,a||(x(),b++),null!==E&&(E=null),e.dataTransfer.dropEffect=f=A(e),i.preventDefault(e)},this.onDragLeave=function(e){if(--b<=0&&a)return _(),f=null,i.preventDefault(e)},this.onDrop=function(e){if(d){var n=e.dataTransfer;if(p)switch(f){case"move":h=h.contains(d.row,d.column)?{start:d,end:d}:t.moveText(h,d);break;case"copy":h=t.moveText(h,d,!0)}else{var r=n.getData("Text");h={start:d,end:t.session.insert(d,r)},t.focus(),f=null}return _(),i.preventDefault(e)}},i.addListener(y,"dragstart",this.onDragStart.bind(e)),i.addListener(y,"dragend",this.onDragEnd.bind(e)),i.addListener(y,"dragenter",this.onDragEnter.bind(e)),i.addListener(y,"dragover",this.onDragOver.bind(e)),i.addListener(y,"dragleave",this.onDragLeave.bind(e)),i.addListener(y,"drop",this.onDrop.bind(e));var E=null;function S(){null==E&&(E=setTimeout((function(){null!=E&&a&&_()}),20))}function C(e){var t=e.types;return!t||Array.prototype.some.call(t,(function(e){return"text/plain"==e||"Text"==e}))}function A(e){var t=["copy","copymove","all","uninitialized"],n=o.isMac?e.altKey:e.ctrlKey,r="uninitialized";try{r=e.dataTransfer.effectAllowed.toLowerCase()}catch(e){}var i="none";return n&&t.indexOf(r)>=0?i="copy":["move","copymove","linkmove","all","uninitialized"].indexOf(r)>=0?i="move":t.indexOf(r)>=0&&(i="copy"),i}}function s(e,t,n,r){return Math.sqrt(Math.pow(n-e,2)+Math.pow(r-t,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(e){this.editor.renderer.$cursorLayer.setBlinking(!this.editor.getReadOnly()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var e=this.editor;e.container.draggable=!0,e.renderer.$cursorLayer.setBlinking(!1),e.setStyle("ace_dragging");var t=o.isWin?"default":"move";e.renderer.setCursorStyle(t),this.setState("dragReady")},this.onMouseDrag=function(e){var t=this.editor.container;o.isIE&&"dragReady"==this.state&&(s(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)>3&&t.dragDrop());"dragWait"===this.state&&(s(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)>0&&(t.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition())))},this.onMouseDown=function(e){if(this.$dragEnabled){this.mousedownEvent=e;var t=this.editor,n=e.inSelection(),r=e.getButton();if(1===(e.domEvent.detail||1)&&0===r&&n){if(e.editor.inMultiSelectMode&&(e.getAccelKey()||e.getShiftKey()))return;this.mousedownEvent.time=Date.now();var i=e.domEvent.target||e.domEvent.srcElement;if("unselectable"in i&&(i.unselectable="on"),t.getDragDelay()){if(o.isWebKit)this.cancelDrag=!0,t.container.draggable=!0;this.setState("dragWait")}else this.startDrag();this.captureMouse(e,this.onMouseDrag.bind(this)),e.defaultPrevented=!0}}}}).call(a.prototype),t.DragdropHandler=a})),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";var r=e("./dom");t.get=function(e,t){var n=new XMLHttpRequest;n.open("GET",e,!0),n.onreadystatechange=function(){4===n.readyState&&t(n.responseText)},n.send(null)},t.loadScript=function(e,t){var n=r.getDocumentHead(),i=document.createElement("script");i.src=e,n.appendChild(i),i.onload=i.onreadystatechange=function(e,n){!n&&i.readyState&&"loaded"!=i.readyState&&"complete"!=i.readyState||(i=i.onload=i.onreadystatechange=null,n||t())}},t.qualifyURL=function(e){var t=document.createElement("a");return t.href=e,t.href}})),ace.define("ace/lib/event_emitter",["require","exports","module"],(function(e,t,n){"use strict";var r={},i=function(){this.propagationStopped=!0},o=function(){this.defaultPrevented=!0};r._emit=r._dispatchEvent=function(e,t){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var n=this._eventRegistry[e]||[],r=this._defaultHandlers[e];if(n.length||r){"object"==typeof t&&t||(t={}),t.type||(t.type=e),t.stopPropagation||(t.stopPropagation=i),t.preventDefault||(t.preventDefault=o),n=n.slice();for(var a=0;a<n.length&&(n[a](t,this),!t.propagationStopped);a++);return r&&!t.defaultPrevented?r(t,this):void 0}},r._signal=function(e,t){var n=(this._eventRegistry||{})[e];if(n){n=n.slice();for(var r=0;r<n.length;r++)n[r](t,this)}},r.once=function(e,t){var n=this;t&&this.addEventListener(e,(function r(){n.removeEventListener(e,r),t.apply(null,arguments)}))},r.setDefaultHandler=function(e,t){var n=this._defaultHandlers;if(n||(n=this._defaultHandlers={_disabled_:{}}),n[e]){var r=n[e],i=n._disabled_[e];i||(n._disabled_[e]=i=[]),i.push(r);var o=i.indexOf(t);-1!=o&&i.splice(o,1)}n[e]=t},r.removeDefaultHandler=function(e,t){var n=this._defaultHandlers;if(n){var r=n._disabled_[e];if(n[e]==t){n[e];r&&this.setDefaultHandler(e,r.pop())}else if(r){var i=r.indexOf(t);-1!=i&&r.splice(i,1)}}},r.on=r.addEventListener=function(e,t,n){this._eventRegistry=this._eventRegistry||{};var r=this._eventRegistry[e];return r||(r=this._eventRegistry[e]=[]),-1==r.indexOf(t)&&r[n?"unshift":"push"](t),t},r.off=r.removeListener=r.removeEventListener=function(e,t){this._eventRegistry=this._eventRegistry||{};var n=this._eventRegistry[e];if(n){var r=n.indexOf(t);-1!==r&&n.splice(r,1)}},r.removeAllListeners=function(e){this._eventRegistry&&(this._eventRegistry[e]=[])},t.EventEmitter=r})),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],(function(e,t,n){var r=e("./oop"),i=e("./event_emitter").EventEmitter,o={setOptions:function(e){Object.keys(e).forEach((function(t){this.setOption(t,e[t])}),this)},getOptions:function(e){var t={};return e?Array.isArray(e)||(t=e,e=Object.keys(t)):e=Object.keys(this.$options),e.forEach((function(e){t[e]=this.getOption(e)}),this),t},setOption:function(e,t){if(this["$"+e]!==t){var n=this.$options[e];if(!n)return a('misspelled option "'+e+'"');if(n.forwardTo)return this[n.forwardTo]&&this[n.forwardTo].setOption(e,t);n.handlesSet||(this["$"+e]=t),n&&n.set&&n.set.call(this,t)}},getOption:function(e){var t=this.$options[e];return t?t.forwardTo?this[t.forwardTo]&&this[t.forwardTo].getOption(e):t&&t.get?t.get.call(this):this["$"+e]:a('misspelled option "'+e+'"')}};function a(e){"undefined"!=typeof console&&console.warn&&console.warn.apply(console,arguments)}function s(e,t){var n=new Error(e);n.data=t,"object"==typeof console&&console.error&&console.error(n),setTimeout((function(){throw n}))}var c=function(){this.$defaultOptions={}};(function(){r.implement(this,i),this.defineOptions=function(e,t,n){return e.$options||(this.$defaultOptions[t]=e.$options={}),Object.keys(n).forEach((function(t){var r=n[t];"string"==typeof r&&(r={forwardTo:r}),r.name||(r.name=t),e.$options[r.name]=r,"initialValue"in r&&(e["$"+r.name]=r.initialValue)})),r.implement(e,o),this},this.resetOptions=function(e){Object.keys(e.$options).forEach((function(t){var n=e.$options[t];"value"in n&&e.setOption(t,n.value)}))},this.setDefaultValue=function(e,t,n){var r=this.$defaultOptions[e]||(this.$defaultOptions[e]={});r[t]&&(r.forwardTo?this.setDefaultValue(r.forwardTo,t,n):r[t].value=n)},this.setDefaultValues=function(e,t){Object.keys(t).forEach((function(n){this.setDefaultValue(e,n,t[n])}),this)},this.warn=a,this.reportError=s}).call(c.prototype),t.AppConfig=c})),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/lib/net","ace/lib/app_config"],(function(e,t,r){var i=e("./lib/lang"),o=(e("./lib/oop"),e("./lib/net")),a=e("./lib/app_config").AppConfig;r.exports=t=new a;var s=function(){return this||"undefined"!=typeof window&&window}(),c={packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{}};function l(i){if(s&&s.document){c.packaged=i||e.packaged||r.packaged||s.define&&n("B9Yq").packaged;for(var o,a={},l="",u=document.currentScript||document._currentScript,h=(u&&u.ownerDocument||document).getElementsByTagName("script"),d=0;d<h.length;d++){var f=h[d],p=f.src||f.getAttribute("src");if(p){for(var m=f.attributes,g=0,v=m.length;g<v;g++){var y=m[g];0===y.name.indexOf("data-ace-")&&(a[(o=y.name.replace(/^data-ace-/,""),o.replace(/-(.)/g,(function(e,t){return t.toUpperCase()})))]=y.value)}var b=p.match(/^(.*)\/ace(\-\w+)?\.js(\?|$)/);b&&(l=b[1])}}for(var w in l&&(a.base=a.base||l,a.packaged=!0),a.basePath=a.base,a.workerPath=a.workerPath||a.base,a.modePath=a.modePath||a.base,a.themePath=a.themePath||a.base,delete a.base,a)void 0!==a[w]&&t.set(w,a[w])}}t.get=function(e){if(!c.hasOwnProperty(e))throw new Error("Unknown config key: "+e);return c[e]},t.set=function(e,t){if(!c.hasOwnProperty(e))throw new Error("Unknown config key: "+e);c[e]=t},t.all=function(){return i.copyObject(c)},t.moduleUrl=function(e,t){if(c.$moduleUrls[e])return c.$moduleUrls[e];var n=e.split("/"),r="snippets"==(t=t||n[n.length-2]||"")?"/":"-",i=n[n.length-1];if("worker"==t&&"-"==r){var o=new RegExp("^"+t+"[\\-_]|[\\-_]"+t+"$","g");i=i.replace(o,"")}(!i||i==t)&&n.length>1&&(i=n[n.length-2]);var a=c[t+"Path"];return null==a?a=c.basePath:"/"==r&&(t=r=""),a&&"/"!=a.slice(-1)&&(a+="/"),a+t+r+i+this.get("suffix")},t.setModuleUrl=function(e,t){return c.$moduleUrls[e]=t},t.$loading={},t.loadModule=function(n,r){var i,a;Array.isArray(n)&&(a=n[0],n=n[1]);try{i=e(n)}catch(e){}if(i&&!t.$loading[n])return r&&r(i);if(t.$loading[n]||(t.$loading[n]=[]),t.$loading[n].push(r),!(t.$loading[n].length>1)){var s=function(){e([n],(function(e){t._emit("load.module",{name:n,module:e});var r=t.$loading[n];t.$loading[n]=null,r.forEach((function(t){t&&t(e)}))}))};if(!t.get("packaged"))return s();o.loadScript(t.moduleUrl(n,a),s)}},l(!0),t.init=l})),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/config"],(function(e,t,n){"use strict";var r=e("../lib/event"),i=e("../lib/useragent"),o=e("./default_handlers").DefaultHandlers,a=e("./default_gutter_handler").GutterHandler,s=e("./mouse_event").MouseEvent,c=e("./dragdrop_handler").DragdropHandler,l=e("../config"),u=function(e){var t=this;this.editor=e,new o(this),new a(this),new c(this);var n=function(t){(!document.hasFocus||!document.hasFocus()||!e.isFocused()&&document.activeElement==(e.textInput&&e.textInput.getElement()))&&window.focus(),e.focus()},s=e.renderer.getMouseEventTarget();r.addListener(s,"click",this.onMouseEvent.bind(this,"click")),r.addListener(s,"mousemove",this.onMouseMove.bind(this,"mousemove")),r.addMultiMouseDownListener([s,e.renderer.scrollBarV&&e.renderer.scrollBarV.inner,e.renderer.scrollBarH&&e.renderer.scrollBarH.inner,e.textInput&&e.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent"),r.addMouseWheelListener(e.container,this.onMouseWheel.bind(this,"mousewheel")),r.addTouchMoveListener(e.container,this.onTouchMove.bind(this,"touchmove"));var l=e.renderer.$gutter;r.addListener(l,"mousedown",this.onMouseEvent.bind(this,"guttermousedown")),r.addListener(l,"click",this.onMouseEvent.bind(this,"gutterclick")),r.addListener(l,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick")),r.addListener(l,"mousemove",this.onMouseEvent.bind(this,"guttermousemove")),r.addListener(s,"mousedown",n),r.addListener(l,"mousedown",n),i.isIE&&e.renderer.scrollBarV&&(r.addListener(e.renderer.scrollBarV.element,"mousedown",n),r.addListener(e.renderer.scrollBarH.element,"mousedown",n)),e.on("mousemove",(function(n){if(!t.state&&!t.$dragDelay&&t.$dragEnabled){var r=e.renderer.screenToTextCoordinates(n.x,n.y),i=e.session.selection.getRange(),o=e.renderer;!i.isEmpty()&&i.insideStart(r.row,r.column)?o.setCursorStyle("default"):o.setCursorStyle("")}}))};(function(){this.onMouseEvent=function(e,t){this.editor._emit(e,new s(t,this.editor))},this.onMouseMove=function(e,t){var n=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;n&&n.length&&this.editor._emit(e,new s(t,this.editor))},this.onMouseWheel=function(e,t){var n=new s(t,this.editor);n.speed=2*this.$scrollSpeed,n.wheelX=t.wheelX,n.wheelY=t.wheelY,this.editor._emit(e,n)},this.onTouchMove=function(e,t){var n=new s(t,this.editor);n.speed=1,n.wheelX=t.wheelX,n.wheelY=t.wheelY,this.editor._emit(e,n)},this.setState=function(e){this.state=e},this.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;var n=this.editor.renderer;n.$keepTextAreaAtCursor&&(n.$keepTextAreaAtCursor=null);var o=this,a=function(e){if(e){if(i.isWebKit&&!e.which&&o.releaseMouse)return o.releaseMouse();o.x=e.clientX,o.y=e.clientY,t&&t(e),o.mouseEvent=new s(e,o.editor),o.$mouseMoved=!0}},c=function(e){clearInterval(u),l(),o[o.state+"End"]&&o[o.state+"End"](e),o.state="",null==n.$keepTextAreaAtCursor&&(n.$keepTextAreaAtCursor=!0,n.$moveTextAreaToCursor()),o.isMousePressed=!1,o.$onCaptureMouseMove=o.releaseMouse=null,e&&o.onMouseEvent("mouseup",e)},l=function(){o[o.state]&&o[o.state](),o.$mouseMoved=!1};if(i.isOldIE&&"dblclick"==e.domEvent.type)return setTimeout((function(){c(e)}));o.$onCaptureMouseMove=a,o.releaseMouse=r.capture(this.editor.container,a,c);var u=setInterval(l,20)},this.releaseMouse=null,this.cancelContextMenu=function(){var e=function(t){t&&t.domEvent&&"contextmenu"!=t.domEvent.type||(this.editor.off("nativecontextmenu",e),t&&t.domEvent&&r.stopEvent(t.domEvent))}.bind(this);setTimeout(e,10),this.editor.on("nativecontextmenu",e)}}).call(u.prototype),l.defineOptions(u.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:i.isMac?150:0},dragEnabled:{initialValue:!0},focusTimout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),t.MouseHandler=u})),ace.define("ace/mouse/fold_handler",["require","exports","module"],(function(e,t,n){"use strict";t.FoldHandler=function(e){e.on("click",(function(t){var n=t.getDocumentPosition(),r=e.session,i=r.getFoldAt(n.row,n.column,1);i&&(t.getAccelKey()?r.removeFold(i):r.expandFold(i),t.stop())})),e.on("gutterclick",(function(t){if("foldWidgets"==e.renderer.$gutterLayer.getRegion(t)){var n=t.getDocumentPosition().row,r=e.session;r.foldWidgets&&r.foldWidgets[n]&&e.session.onFoldWidgetClick(n,t),e.isFocused()||e.focus(),t.stop()}})),e.on("gutterdblclick",(function(t){if("foldWidgets"==e.renderer.$gutterLayer.getRegion(t)){var n=t.getDocumentPosition().row,r=e.session,i=r.getParentFoldRangeData(n,!0),o=i.range||i.firstRange;if(o){n=o.start.row;var a=r.getFoldAt(n,r.getLine(n).length,1);a?r.removeFold(a):(r.addFold("...",o),e.renderer.scrollCursorIntoView({row:o.start.row,column:0}))}t.stop()}}))}})),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],(function(e,t,n){"use strict";var r=e("../lib/keys"),i=e("../lib/event"),o=function(e){this.$editor=e,this.$data={editor:e},this.$handlers=[],this.setDefaultHandler(e.commands)};(function(){this.setDefaultHandler=function(e){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=e,this.addKeyboardHandler(e,0)},this.setKeyboardHandler=function(e){var t=this.$handlers;if(t[t.length-1]!=e){for(;t[t.length-1]&&t[t.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(t[t.length-1]);this.addKeyboardHandler(e,1)}},this.addKeyboardHandler=function(e,t){if(e){"function"!=typeof e||e.handleKeyboard||(e.handleKeyboard=e);var n=this.$handlers.indexOf(e);-1!=n&&this.$handlers.splice(n,1),null==t?this.$handlers.push(e):this.$handlers.splice(t,0,e),-1==n&&e.attach&&e.attach(this.$editor)}},this.removeKeyboardHandler=function(e){var t=this.$handlers.indexOf(e);return-1!=t&&(this.$handlers.splice(t,1),e.detach&&e.detach(this.$editor),!0)},this.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},this.getStatusText=function(){var e=this.$data,t=e.editor;return this.$handlers.map((function(n){return n.getStatusText&&n.getStatusText(t,e)||""})).filter(Boolean).join(" ")},this.$callKeyboardHandlers=function(e,t,n,r){for(var o,a=!1,s=this.$editor.commands,c=this.$handlers.length;c--&&!((o=this.$handlers[c].handleKeyboard(this.$data,e,t,n,r))&&o.command&&((a="null"==o.command||s.exec(o.command,this.$editor,o.args,r))&&r&&-1!=e&&1!=o.passEvent&&1!=o.command.passEvent&&i.stopEvent(r),a)););return a||-1!=e||(o={command:"insertstring"},a=s.exec("insertstring",this.$editor,t)),a&&this.$editor._signal&&this.$editor._signal("keyboardActivity",o),a},this.onCommandKey=function(e,t,n){var i=r.keyCodeToString(n);this.$callKeyboardHandlers(t,i,n,e)},this.onTextInput=function(e){this.$callKeyboardHandlers(-1,e)}}).call(o.prototype),t.KeyBinding=o})),ace.define("ace/lib/bidiutil",["require","exports","module"],(function(e,t,n){"use strict";var r=0,i=0,o=!1,a=!1,s=!1,c=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],l=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],u=[18,18,18,18,18,18,18,18,18,6,5,6,8,5,18,18,18,18,18,18,18,18,18,18,18,18,18,18,5,5,5,6,8,4,4,11,11,11,4,4,4,4,4,10,9,10,9,9,2,2,2,2,2,2,2,2,2,2,9,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,18,18,18,18,18,18,5,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,9,4,11,11,11,11,4,4,4,4,0,4,4,18,4,4,11,11,2,2,4,0,4,4,4,2,0,4,4,4,4,4],h=[8,8,8,8,8,8,8,8,8,8,8,18,18,18,0,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8,5,13,14,15,16,17,9,11,11,11,11,11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,9,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,8];function d(e,t,n){if(!(i<e))if(1!=e||1!=r||a)for(var o,s,c,l,u=n.length,h=0;h<u;){if(t[h]>=e){for(o=h+1;o<u&&t[o]>=e;)o++;for(s=h,c=o-1;s<c;s++,c--)l=n[s],n[s]=n[c],n[c]=l;h=o}h++}else n.reverse()}function f(e,t,n,i){var c,l,u,h,d=t[i];switch(d){case 0:case 1:o=!1;case 4:case 3:return d;case 2:return o?3:2;case 7:return o=!0,!0,1;case 8:return 4;case 9:return i<1||i+1>=t.length||2!=(c=n[i-1])&&3!=c||2!=(l=t[i+1])&&3!=l?4:(o&&(l=3),l==c?l:4);case 10:return 2==(c=i>0?n[i-1]:5)&&i+1<t.length&&2==t[i+1]?2:4;case 11:if(i>0&&2==n[i-1])return 2;if(o)return 4;for(h=i+1,u=t.length;h<u&&11==t[h];)h++;return h<u&&2==t[h]?2:4;case 12:for(u=t.length,h=i+1;h<u&&12==t[h];)h++;if(h<u){var f=e[i],p=f>=1425&&f<=2303||64286==f;if(c=t[h],p&&(1==c||7==c))return 1}return i<1||5==(c=t[i-1])?4:n[i-1];case 5:return o=!1,a=!0,r;case 6:return s=!0,4;case 13:case 14:case 16:case 17:case 15:o=!1;case 18:return 4}}function p(e){var t=e.charCodeAt(0),n=t>>8;return 0==n?t>191?0:u[t]:5==n?/[\u0591-\u05f4]/.test(e)?1:0:6==n?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(e)?12:/[\u0660-\u0669\u066b-\u066c]/.test(e)?3:1642==t?11:/[\u06f0-\u06f9]/.test(e)?2:7:32==n&&t<=8287?h[255&t]:254==n&&t>=65136?7:4}t.L=0,t.R=1,t.EN=2,t.ON_R=3,t.AN=4,t.R_H=5,t.B=6,t.DOT="·",t.doBidiReorder=function(e,n,u){if(e.length<2)return{};var h=e.split(""),m=new Array(h.length),g=new Array(h.length),v=[];r=u?1:0,function(e,t,n,u){var h=r?l:c,d=null,m=null,g=null,v=0,y=null,b=-1,w=null,x=null,_=[];if(!u)for(w=0,u=[];w<n;w++)u[w]=p(e[w]);for(i=r,o=!1,!1,a=!1,s=!1,x=0;x<n;x++){if(d=v,_[x]=m=f(e,u,_,x),y=240&(v=h[d][m]),v&=15,t[x]=g=h[v][5],y>0)if(16==y){for(w=b;w<x;w++)t[w]=1;b=-1}else b=-1;if(h[v][6])-1==b&&(b=x);else if(b>-1){for(w=b;w<x;w++)t[w]=g;b=-1}5==u[x]&&(t[x]=0),i|=g}if(s)for(w=0;w<n;w++)if(6==u[w]){t[w]=r;for(var E=w-1;E>=0&&8==u[E];E--)t[E]=r}}(h,v,h.length,n);for(var y=0;y<m.length;m[y]=y,y++);d(2,v,m),d(1,v,m);for(y=0;y<m.length-1;y++)3===n[y]?v[y]=t.AN:1===v[y]&&(n[y]>7&&n[y]<13||4===n[y]||18===n[y])?v[y]=t.ON_R:y>0&&"ل"===h[y-1]&&/\u0622|\u0623|\u0625|\u0627/.test(h[y])&&(v[y-1]=v[y]=t.R_H,y++);h[h.length-1]===t.DOT&&(v[h.length-1]=t.B);for(y=0;y<m.length;y++)g[y]=v[m[y]];return{logicalFromVisual:m,bidiLevels:g}},t.hasBidiCharacters=function(e,t){for(var n=!1,r=0;r<e.length;r++)t[r]=p(e.charAt(r)),n||1!=t[r]&&7!=t[r]||(n=!0);return n},t.getVisualFromLogicalIdx=function(e,t){for(var n=0;n<t.logicalFromVisual.length;n++)if(t.logicalFromVisual[n]==e)return n;return 0}})),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang","ace/lib/useragent"],(function(e,t,n){"use strict";var r=e("./lib/bidiutil"),i=e("./lib/lang"),o=e("./lib/useragent"),a=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/,s=function(e){this.session=e,this.bidiMap={},this.currentRow=null,this.bidiUtil=r,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.line="",this.wrapIndent=0,this.isLastRow=!1,this.EOF="¶",this.seenBidi=!1};(function(){this.isBidiRow=function(e,t,n){return!!this.seenBidi&&(e!==this.currentRow&&(this.currentRow=e,this.updateRowLine(t,n),this.updateBidiMap()),this.bidiMap.bidiLevels)},this.onChange=function(e){this.seenBidi?this.currentRow=null:"insert"==e.action&&a.test(e.lines.join("\n"))&&(this.seenBidi=!0,this.currentRow=null)},this.getDocumentRow=function(){var e=0,t=this.session.$screenRowCache;if(t.length){var n=this.session.$getRowCacheIndex(t,this.currentRow);n>=0&&(e=this.session.$docRowCache[n])}return e},this.getSplitIndex=function(){var e=0,t=this.session.$screenRowCache;if(t.length)for(var n,r=this.session.$getRowCacheIndex(t,this.currentRow);this.currentRow-e>0&&(n=this.session.$getRowCacheIndex(t,this.currentRow-e-1))===r;)r=n,e++;return e},this.updateRowLine=function(e,t){if(void 0===e&&(e=this.getDocumentRow()),this.wrapIndent=0,this.isLastRow=e===this.session.getLength()-1,this.line=this.session.getLine(e),this.session.$useWrapMode){var n=this.session.$wrapData[e];n&&(void 0===t&&(t=this.getSplitIndex()),t>0&&n.length?(this.wrapIndent=n.indent,this.line=t<n.length?this.line.substring(n[t-1],n[n.length-1]):this.line.substring(n[n.length-1])):this.line=this.line.substring(0,n[t]))}var o,a=this.session,s=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,(function(e,t){return"\t"===e||a.isFullWidth(e.charCodeAt(0))?(o="\t"===e?a.getScreenTabSize(t+s):2,s+=o-1,i.stringRepeat(r.DOT,o)):e}))},this.updateBidiMap=function(){var e=[],t=this.isLastRow?this.EOF:this.EOL,n=this.line+(this.showInvisibles?t:r.DOT);r.hasBidiCharacters(n,e)?this.bidiMap=r.doBidiReorder(n,e,this.isRtlDir):this.bidiMap={}},this.markAsDirty=function(){this.currentRow=null},this.updateCharacterWidths=function(e){if(this.seenBidi&&this.characterWidth!==e.$characterSize.width){var t=this.characterWidth=e.$characterSize.width,n=e.$measureCharWidth("ה");this.charWidths[r.L]=this.charWidths[r.EN]=this.charWidths[r.ON_R]=t,this.charWidths[r.R]=this.charWidths[r.AN]=n,this.charWidths[r.R_H]=o.isChrome?n:.45*n,this.charWidths[r.B]=0,this.currentRow=null}},this.getShowInvisibles=function(){return this.showInvisibles},this.setShowInvisibles=function(e){this.showInvisibles=e,this.currentRow=null},this.setEolChar=function(e){this.EOL=e},this.setTextDir=function(e){this.isRtlDir=e},this.getPosLeft=function(e){e-=this.wrapIndent;var t=r.getVisualFromLogicalIdx(e>0?e-1:0,this.bidiMap),n=this.bidiMap.bidiLevels,i=0;0===e&&n[t]%2!=0&&t++;for(var o=0;o<t;o++)i+=this.charWidths[n[o]];return 0!==e&&n[t]%2==0&&(i+=this.charWidths[n[t]]),this.wrapIndent&&(i+=this.wrapIndent*this.charWidths[r.L]),i},this.getSelections=function(e,t){for(var n,i,o=this.bidiMap,a=o.bidiLevels,s=this.wrapIndent*this.charWidths[r.L],c=[],l=Math.min(e,t)-this.wrapIndent,u=Math.max(e,t)-this.wrapIndent,h=!1,d=!1,f=0,p=0;p<a.length;p++)i=o.logicalFromVisual[p],n=a[p],(h=i>=l&&i<u)&&!d?f=s:!h&&d&&c.push({left:f,width:s-f}),s+=this.charWidths[n],d=h;return h&&p===a.length&&c.push({left:f,width:s-f}),c},this.offsetToCol=function(e){var t=0,n=(e=Math.max(e,0),0),i=0,o=this.bidiMap.bidiLevels,a=this.charWidths[o[i]];for(this.wrapIndent&&(e-=this.wrapIndent*this.charWidths[r.L]);e>n+a/2;){if(n+=a,i===o.length-1){a=0;break}a=this.charWidths[o[++i]]}return i>0&&o[i-1]%2!=0&&o[i]%2==0?(e<n&&i--,t=this.bidiMap.logicalFromVisual[i]):i>0&&o[i-1]%2==0&&o[i]%2!=0?t=1+(e>n?this.bidiMap.logicalFromVisual[i]:this.bidiMap.logicalFromVisual[i-1]):this.isRtlDir&&i===o.length-1&&0===a&&o[i-1]%2==0||!this.isRtlDir&&0===i&&o[i]%2!=0?t=1+this.bidiMap.logicalFromVisual[i]:(i>0&&o[i-1]%2!=0&&0!==a&&i--,t=this.bidiMap.logicalFromVisual[i]),t+this.wrapIndent}}).call(s.prototype),t.BidiHandler=s})),ace.define("ace/range",["require","exports","module"],(function(e,t,n){"use strict";var r=function(e,t,n,r){this.start={row:e,column:t},this.end={row:n,column:r}};(function(){this.isEqual=function(e){return this.start.row===e.start.row&&this.end.row===e.end.row&&this.start.column===e.start.column&&this.end.column===e.end.column},this.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},this.contains=function(e,t){return 0==this.compare(e,t)},this.compareRange=function(e){var t,n=e.end,r=e.start;return 1==(t=this.compare(n.row,n.column))?1==(t=this.compare(r.row,r.column))?2:0==t?1:0:-1==t?-2:-1==(t=this.compare(r.row,r.column))?-1:1==t?42:0},this.comparePoint=function(e){return this.compare(e.row,e.column)},this.containsRange=function(e){return 0==this.comparePoint(e.start)&&0==this.comparePoint(e.end)},this.intersects=function(e){var t=this.compareRange(e);return-1==t||0==t||1==t},this.isEnd=function(e,t){return this.end.row==e&&this.end.column==t},this.isStart=function(e,t){return this.start.row==e&&this.start.column==t},this.setStart=function(e,t){"object"==typeof e?(this.start.column=e.column,this.start.row=e.row):(this.start.row=e,this.start.column=t)},this.setEnd=function(e,t){"object"==typeof e?(this.end.column=e.column,this.end.row=e.row):(this.end.row=e,this.end.column=t)},this.inside=function(e,t){return 0==this.compare(e,t)&&(!this.isEnd(e,t)&&!this.isStart(e,t))},this.insideStart=function(e,t){return 0==this.compare(e,t)&&!this.isEnd(e,t)},this.insideEnd=function(e,t){return 0==this.compare(e,t)&&!this.isStart(e,t)},this.compare=function(e,t){return this.isMultiLine()||e!==this.start.row?e<this.start.row?-1:e>this.end.row?1:this.start.row===e?t>=this.start.column?0:-1:this.end.row===e?t<=this.end.column?0:1:0:t<this.start.column?-1:t>this.end.column?1:0},this.compareStart=function(e,t){return this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.compareEnd=function(e,t){return this.end.row==e&&this.end.column==t?1:this.compare(e,t)},this.compareInside=function(e,t){return this.end.row==e&&this.end.column==t?1:this.start.row==e&&this.start.column==t?-1:this.compare(e,t)},this.clipRows=function(e,t){if(this.end.row>t)var n={row:t+1,column:0};else if(this.end.row<e)n={row:e,column:0};if(this.start.row>t)var i={row:t+1,column:0};else if(this.start.row<e)i={row:e,column:0};return r.fromPoints(i||this.start,n||this.end)},this.extend=function(e,t){var n=this.compare(e,t);if(0==n)return this;if(-1==n)var i={row:e,column:t};else var o={row:e,column:t};return r.fromPoints(i||this.start,o||this.end)},this.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},this.isMultiLine=function(){return this.start.row!==this.end.row},this.clone=function(){return r.fromPoints(this.start,this.end)},this.collapseRows=function(){return 0==this.end.column?new r(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new r(this.start.row,0,this.end.row,0)},this.toScreenRange=function(e){var t=e.documentToScreenPosition(this.start),n=e.documentToScreenPosition(this.end);return new r(t.row,t.column,n.row,n.column)},this.moveBy=function(e,t){this.start.row+=e,this.start.column+=t,this.end.row+=e,this.end.column+=t}}).call(r.prototype),r.fromPoints=function(e,t){return new r(e.row,e.column,t.row,t.column)},r.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},r.comparePoints=function(e,t){return e.row-t.row||e.column-t.column},t.Range=r})),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./lib/lang"),o=e("./lib/event_emitter").EventEmitter,a=e("./range").Range,s=function(e){this.session=e,this.doc=e.getDocument(),this.clearSelection(),this.lead=this.selectionLead=this.doc.createAnchor(0,0),this.anchor=this.selectionAnchor=this.doc.createAnchor(0,0);var t=this;this.lead.on("change",(function(e){t._emit("changeCursor"),t.$isEmpty||t._emit("changeSelection"),t.$keepDesiredColumnOnChange||e.old.column==e.value.column||(t.$desiredColumn=null)})),this.selectionAnchor.on("change",(function(){t.$isEmpty||t._emit("changeSelection")}))};(function(){r.implement(this,o),this.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},this.isMultiLine=function(){return!this.isEmpty()&&this.getRange().isMultiLine()},this.getCursor=function(){return this.lead.getPosition()},this.setSelectionAnchor=function(e,t){this.anchor.setPosition(e,t),this.$isEmpty&&(this.$isEmpty=!1,this._emit("changeSelection"))},this.getSelectionAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},this.getSelectionLead=function(){return this.lead.getPosition()},this.shiftSelection=function(e){if(this.$isEmpty)this.moveCursorTo(this.lead.row,this.lead.column+e);else{var t=this.getSelectionAnchor(),n=this.getSelectionLead(),r=this.isBackwards();r&&0===t.column||this.setSelectionAnchor(t.row,t.column+e),(r||0!==n.column)&&this.$moveSelection((function(){this.moveCursorTo(n.row,n.column+e)}))}},this.isBackwards=function(){var e=this.anchor,t=this.lead;return e.row>t.row||e.row==t.row&&e.column>t.column},this.getRange=function(){var e=this.anchor,t=this.lead;return this.isEmpty()?a.fromPoints(t,t):this.isBackwards()?a.fromPoints(t,e):a.fromPoints(e,t)},this.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},this.selectAll=function(){var e=this.doc.getLength()-1;this.setSelectionAnchor(0,0),this.moveCursorTo(e,this.doc.getLine(e).length)},this.setRange=this.setSelectionRange=function(e,t){t?(this.setSelectionAnchor(e.end.row,e.end.column),this.selectTo(e.start.row,e.start.column)):(this.setSelectionAnchor(e.start.row,e.start.column),this.selectTo(e.end.row,e.end.column)),this.getRange().isEmpty()&&(this.$isEmpty=!0),this.$desiredColumn=null},this.$moveSelection=function(e){var t=this.lead;this.$isEmpty&&this.setSelectionAnchor(t.row,t.column),e.call(this)},this.selectTo=function(e,t){this.$moveSelection((function(){this.moveCursorTo(e,t)}))},this.selectToPosition=function(e){this.$moveSelection((function(){this.moveCursorToPosition(e)}))},this.moveTo=function(e,t){this.clearSelection(),this.moveCursorTo(e,t)},this.moveToPosition=function(e){this.clearSelection(),this.moveCursorToPosition(e)},this.selectUp=function(){this.$moveSelection(this.moveCursorUp)},this.selectDown=function(){this.$moveSelection(this.moveCursorDown)},this.selectRight=function(){this.$moveSelection(this.moveCursorRight)},this.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},this.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},this.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},this.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},this.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},this.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},this.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},this.getWordRange=function(e,t){if(void 0===t){var n=e||this.lead;e=n.row,t=n.column}return this.session.getWordRange(e,t)},this.selectWord=function(){this.setSelectionRange(this.getWordRange())},this.selectAWord=function(){var e=this.getCursor(),t=this.session.getAWordRange(e.row,e.column);this.setSelectionRange(t)},this.getLineRange=function(e,t){var n,r="number"==typeof e?e:this.lead.row,i=this.session.getFoldLine(r);return i?(r=i.start.row,n=i.end.row):n=r,!0===t?new a(r,0,n,this.session.getLine(n).length):new a(r,0,n+1,0)},this.selectLine=function(){this.setSelectionRange(this.getLineRange())},this.moveCursorUp=function(){this.moveCursorBy(-1,0)},this.moveCursorDown=function(){this.moveCursorBy(1,0)},this.wouldMoveIntoSoftTab=function(e,t,n){var r=e.column,i=e.column+t;return n<0&&(r=e.column-t,i=e.column),this.session.isTabStop(e)&&this.doc.getLine(e.row).slice(r,i).split(" ").length-1==t},this.moveCursorLeft=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,-1))this.moveCursorTo(e.start.row,e.start.column);else if(0===t.column)t.row>0&&this.moveCursorTo(t.row-1,this.doc.getLine(t.row-1).length);else{var n=this.session.getTabSize();this.wouldMoveIntoSoftTab(t,n,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-n):this.moveCursorBy(0,-1)}},this.moveCursorRight=function(){var e,t=this.lead.getPosition();if(e=this.session.getFoldAt(t.row,t.column,1))this.moveCursorTo(e.end.row,e.end.column);else if(this.lead.column==this.doc.getLine(this.lead.row).length)this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0);else{var n=this.session.getTabSize();t=this.lead;this.wouldMoveIntoSoftTab(t,n,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,n):this.moveCursorBy(0,1)}},this.moveCursorLineStart=function(){var e=this.lead.row,t=this.lead.column,n=this.session.documentToScreenRow(e,t),r=this.session.screenToDocumentPosition(n,0),i=this.session.getDisplayLine(e,null,r.row,r.column).match(/^\s*/);i[0].length==t||this.session.$useEmacsStyleLineStart||(r.column+=i[0].length),this.moveCursorToPosition(r)},this.moveCursorLineEnd=function(){var e=this.lead,t=this.session.getDocumentLastRowColumnPosition(e.row,e.column);if(this.lead.column==t.column){var n=this.session.getLine(t.row);if(t.column==n.length){var r=n.search(/\s+$/);r>0&&(t.column=r)}}this.moveCursorTo(t.row,t.column)},this.moveCursorFileEnd=function(){var e=this.doc.getLength()-1,t=this.doc.getLine(e).length;this.moveCursorTo(e,t)},this.moveCursorFileStart=function(){this.moveCursorTo(0,0)},this.moveCursorLongWordRight=function(){var e=this.lead.row,t=this.lead.column,n=this.doc.getLine(e),r=n.substring(t);this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0;var i=this.session.getFoldAt(e,t,1);if(i)this.moveCursorTo(i.end.row,i.end.column);else{if(this.session.nonTokenRe.exec(r)&&(t+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,r=n.substring(t)),t>=n.length)return this.moveCursorTo(e,n.length),this.moveCursorRight(),void(e<this.doc.getLength()-1&&this.moveCursorWordRight());this.session.tokenRe.exec(r)&&(t+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(e,t)}},this.moveCursorLongWordLeft=function(){var e,t=this.lead.row,n=this.lead.column;if(e=this.session.getFoldAt(t,n,-1))this.moveCursorTo(e.start.row,e.start.column);else{var r=this.session.getFoldStringAt(t,n,-1);null==r&&(r=this.doc.getLine(t).substring(0,n));var o=i.stringReverse(r);if(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(o)&&(n-=this.session.nonTokenRe.lastIndex,o=o.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),n<=0)return this.moveCursorTo(t,0),this.moveCursorLeft(),void(t>0&&this.moveCursorWordLeft());this.session.tokenRe.exec(o)&&(n-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(t,n)}},this.$shortWordEndIndex=function(e){var t,n=0,r=/\s/,i=this.session.tokenRe;if(i.lastIndex=0,this.session.tokenRe.exec(e))n=this.session.tokenRe.lastIndex;else{for(;(t=e[n])&&r.test(t);)n++;if(n<1)for(i.lastIndex=0;(t=e[n])&&!i.test(t);)if(i.lastIndex=0,n++,r.test(t)){if(n>2){n--;break}for(;(t=e[n])&&r.test(t);)n++;if(n>2)break}}return i.lastIndex=0,n},this.moveCursorShortWordRight=function(){var e=this.lead.row,t=this.lead.column,n=this.doc.getLine(e),r=n.substring(t),i=this.session.getFoldAt(e,t,1);if(i)return this.moveCursorTo(i.end.row,i.end.column);if(t==n.length){var o=this.doc.getLength();do{e++,r=this.doc.getLine(e)}while(e<o&&/^\s*$/.test(r));/^\s+/.test(r)||(r=""),t=0}var a=this.$shortWordEndIndex(r);this.moveCursorTo(e,t+a)},this.moveCursorShortWordLeft=function(){var e,t=this.lead.row,n=this.lead.column;if(e=this.session.getFoldAt(t,n,-1))return this.moveCursorTo(e.start.row,e.start.column);var r=this.session.getLine(t).substring(0,n);if(0===n){do{t--,r=this.doc.getLine(t)}while(t>0&&/^\s*$/.test(r));n=r.length,/\s+$/.test(r)||(r="")}var o=i.stringReverse(r),a=this.$shortWordEndIndex(o);return this.moveCursorTo(t,n-a)},this.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},this.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},this.moveCursorBy=function(e,t){var n,r=this.session.documentToScreenPosition(this.lead.row,this.lead.column);0===t&&(0!==e&&(this.session.$bidiHandler.isBidiRow(r.row,this.lead.row)?(n=this.session.$bidiHandler.getPosLeft(r.column),r.column=Math.round(n/this.session.$bidiHandler.charWidths[0])):n=r.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?r.column=this.$desiredColumn:this.$desiredColumn=r.column);var i=this.session.screenToDocumentPosition(r.row+e,r.column,n);0!==e&&0===t&&i.row===this.lead.row&&i.column===this.lead.column&&this.session.lineWidgets&&this.session.lineWidgets[i.row]&&(i.row>0||e>0)&&i.row++,this.moveCursorTo(i.row,i.column+t,0===t)},this.moveCursorToPosition=function(e){this.moveCursorTo(e.row,e.column)},this.moveCursorTo=function(e,t,n){var r=this.session.getFoldAt(e,t,1);r&&(e=r.start.row,t=r.start.column),this.$keepDesiredColumnOnChange=!0;var i=this.session.getLine(e);/[\uDC00-\uDFFF]/.test(i.charAt(t))&&i.charAt(t-1)&&(this.lead.row==e&&this.lead.column==t+1?t-=1:t+=1),this.lead.setPosition(e,t),this.$keepDesiredColumnOnChange=!1,n||(this.$desiredColumn=null)},this.moveCursorToScreen=function(e,t,n){var r=this.session.screenToDocumentPosition(e,t);this.moveCursorTo(r.row,r.column,n)},this.detach=function(){this.lead.detach(),this.anchor.detach(),this.session=this.doc=null},this.fromOrientedRange=function(e){this.setSelectionRange(e,e.cursor==e.start),this.$desiredColumn=e.desiredColumn||this.$desiredColumn},this.toOrientedRange=function(e){var t=this.getRange();return e?(e.start.column=t.start.column,e.start.row=t.start.row,e.end.column=t.end.column,e.end.row=t.end.row):e=t,e.cursor=this.isBackwards()?e.start:e.end,e.desiredColumn=this.$desiredColumn,e},this.getRangeOfMovements=function(e){var t=this.getCursor();try{e(this);var n=this.getCursor();return a.fromPoints(t,n)}catch(e){return a.fromPoints(t,t)}finally{this.moveCursorToPosition(t)}},this.toJSON=function(){if(this.rangeCount)var e=this.ranges.map((function(e){var t=e.clone();return t.isBackwards=e.cursor==e.start,t}));else(e=this.getRange()).isBackwards=this.isBackwards();return e},this.fromJSON=function(e){if(null==e.start){if(this.rangeList){this.toSingleRange(e[0]);for(var t=e.length;t--;){var n=a.fromPoints(e[t].start,e[t].end);e[t].isBackwards&&(n.cursor=n.start),this.addRange(n,!0)}return}e=e[0]}this.rangeList&&this.toSingleRange(e),this.setSelectionRange(e,e.isBackwards)},this.isEqual=function(e){if((e.length||this.rangeCount)&&e.length!=this.rangeCount)return!1;if(!e.length||!this.ranges)return this.getRange().isEqual(e);for(var t=this.ranges.length;t--;)if(!this.ranges[t].isEqual(e[t]))return!1;return!0}}).call(s.prototype),t.Selection=s})),ace.define("ace/tokenizer",["require","exports","module","ace/config"],(function(e,t,n){"use strict";var r=e("./config"),i=2e3,o=function(e){for(var t in this.states=e,this.regExps={},this.matchMappings={},this.states){for(var n=this.states[t],r=[],i=0,o=this.matchMappings[t]={defaultToken:"text"},a="g",s=[],c=0;c<n.length;c++){var l=n[c];if(l.defaultToken&&(o.defaultToken=l.defaultToken),l.caseInsensitive&&(a="gi"),null!=l.regex){l.regex instanceof RegExp&&(l.regex=l.regex.toString().slice(1,-1));var u=l.regex,h=new RegExp("(?:("+u+")|(.))").exec("a").length-2;Array.isArray(l.token)?1==l.token.length||1==h?l.token=l.token[0]:h-1!=l.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:l,groupCount:h-1}),l.token=l.token[0]):(l.tokenArray=l.token,l.token=null,l.onMatch=this.$arrayTokens):"function"!=typeof l.token||l.onMatch||(l.onMatch=h>1?this.$applyToken:l.token),h>1&&(/\\\d/.test(l.regex)?u=l.regex.replace(/\\([0-9]+)/g,(function(e,t){return"\\"+(parseInt(t,10)+i+1)})):(h=1,u=this.removeCapturingGroups(l.regex)),l.splitRegex||"string"==typeof l.token||s.push(l)),o[i]=c,i+=h,r.push(u),l.onMatch||(l.onMatch=null)}}r.length||(o[0]=0,r.push("$")),s.forEach((function(e){e.splitRegex=this.createSplitterRegexp(e.regex,a)}),this),this.regExps[t]=new RegExp("("+r.join(")|(")+")|($)",a)}};(function(){this.$setMaxTokenCount=function(e){i=0|e},this.$applyToken=function(e){var t=this.splitRegex.exec(e).slice(1),n=this.token.apply(this,t);if("string"==typeof n)return[{type:n,value:e}];for(var r=[],i=0,o=n.length;i<o;i++)t[i]&&(r[r.length]={type:n[i],value:t[i]});return r},this.$arrayTokens=function(e){if(!e)return[];var t=this.splitRegex.exec(e);if(!t)return"text";for(var n=[],r=this.tokenArray,i=0,o=r.length;i<o;i++)t[i+1]&&(n[n.length]={type:r[i],value:t[i+1]});return n},this.removeCapturingGroups=function(e){return e.replace(/\[(?:\\.|[^\]])*?\]|\\.|\(\?[:=!]|(\()/g,(function(e,t){return t?"(?:":e}))},this.createSplitterRegexp=function(e,t){if(-1!=e.indexOf("(?=")){var n=0,r=!1,i={};e.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,(function(e,t,o,a,s,c){return r?r="]"!=s:s?r=!0:a?(n==i.stack&&(i.end=c+1,i.stack=-1),n--):o&&(n++,1!=o.length&&(i.stack=n,i.start=c)),e})),null!=i.end&&/^\)*$/.test(e.substr(i.end))&&(e=e.substring(0,i.start)+e.substr(i.end))}return"^"!=e.charAt(0)&&(e="^"+e),"$"!=e.charAt(e.length-1)&&(e+="$"),new RegExp(e,(t||"").replace("g",""))},this.getLineTokens=function(e,t){if(t&&"string"!=typeof t){var n=t.slice(0);"#tmp"===(t=n[0])&&(n.shift(),t=n.shift())}else n=[];var r=t||"start",o=this.states[r];o||(r="start",o=this.states[r]);var a=this.matchMappings[r],s=this.regExps[r];s.lastIndex=0;for(var c,l=[],u=0,h=0,d={type:null,value:""};c=s.exec(e);){var f=a.defaultToken,p=null,m=c[0],g=s.lastIndex;if(g-m.length>u){var v=e.substring(u,g-m.length);d.type==f?d.value+=v:(d.type&&l.push(d),d={type:f,value:v})}for(var y=0;y<c.length-2;y++)if(void 0!==c[y+1]){f=(p=o[a[y]]).onMatch?p.onMatch(m,r,n,e):p.token,p.next&&(r="string"==typeof p.next?p.next:p.next(r,n),(o=this.states[r])||(this.reportError("state doesn't exist",r),r="start",o=this.states[r]),a=this.matchMappings[r],u=g,(s=this.regExps[r]).lastIndex=g),p.consumeLineEnd&&(u=g);break}if(m)if("string"==typeof f)p&&!1===p.merge||d.type!==f?(d.type&&l.push(d),d={type:f,value:m}):d.value+=m;else if(f){d.type&&l.push(d),d={type:null,value:""};for(y=0;y<f.length;y++)l.push(f[y])}if(u==e.length)break;if(u=g,h++>i){for(h>2*e.length&&this.reportError("infinite loop with in ace tokenizer",{startState:t,line:e});u<e.length;)d.type&&l.push(d),d={value:e.substring(u,u+=2e3),type:"overflow"};r="start",n=[];break}}return d.type&&l.push(d),n.length>1&&n[0]!==r&&n.unshift("#tmp",r),{tokens:l,state:n.length?n:r}},this.reportError=r.reportError}).call(o.prototype),t.Tokenizer=o})),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/lang"],(function(e,t,n){"use strict";var r=e("../lib/lang"),i=function(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}};(function(){this.addRules=function(e,t){if(t)for(var n in e){for(var r=e[n],i=0;i<r.length;i++){var o=r[i];(o.next||o.onMatch)&&("string"==typeof o.next&&0!==o.next.indexOf(t)&&(o.next=t+o.next),o.nextState&&0!==o.nextState.indexOf(t)&&(o.nextState=t+o.nextState))}this.$rules[t+n]=r}else for(var n in e)this.$rules[n]=e[n]},this.getRules=function(){return this.$rules},this.embedRules=function(e,t,n,i,o){var a="function"==typeof e?(new e).getRules():e;if(i)for(var s=0;s<i.length;s++)i[s]=t+i[s];else for(var c in i=[],a)i.push(t+c);if(this.addRules(a,t),n){var l=Array.prototype[o?"push":"unshift"];for(s=0;s<i.length;s++)l.apply(this.$rules[i[s]],r.deepCopy(n))}this.$embeds||(this.$embeds=[]),this.$embeds.push(t)},this.getEmbeds=function(){return this.$embeds};var e=function(e,t){return("start"!=e||t.length)&&t.unshift(this.nextState,e),this.nextState},t=function(e,t){return t.shift(),t.shift()||"start"};this.normalizeRules=function(){var n=0,r=this.$rules;Object.keys(r).forEach((function i(o){var a=r[o];a.processed=!0;for(var s=0;s<a.length;s++){var c=a[s],l=null;Array.isArray(c)&&(l=c,c={}),!c.regex&&c.start&&(c.regex=c.start,c.next||(c.next=[]),c.next.push({defaultToken:c.token},{token:c.token+".end",regex:c.end||c.start,next:"pop"}),c.token=c.token+".start",c.push=!0);var u=c.next||c.push;if(u&&Array.isArray(u)){var h=c.stateName;h||("string"!=typeof(h=c.token)&&(h=h[0]||""),r[h]&&(h+=n++)),r[h]=u,c.next=h,i(h)}else"pop"==u&&(c.next=t);if(c.push&&(c.nextState=c.next||c.push,c.next=e,delete c.push),c.rules)for(var d in c.rules)r[d]?r[d].push&&r[d].push.apply(r[d],c.rules[d]):r[d]=c.rules[d];var f="string"==typeof c?c:c.include;if(f&&(l=Array.isArray(f)?f.map((function(e){return r[e]})):r[f]),l){var p=[s,1].concat(l);c.noEscape&&(p=p.filter((function(e){return!e.next}))),a.splice.apply(a,p),s--}c.keywordMap&&(c.token=this.createKeywordMapper(c.keywordMap,c.defaultToken||"text",c.caseInsensitive),delete c.defaultToken)}}),this)},this.createKeywordMapper=function(e,t,n,r){var i=Object.create(null);return Object.keys(e).forEach((function(t){var o=e[t];n&&(o=o.toLowerCase());for(var a=o.split(r||"|"),s=a.length;s--;)i[a[s]]=t})),Object.getPrototypeOf(i)&&(i.__proto__=null),this.$keywordList=Object.keys(i),e=null,n?function(e){return i[e.toLowerCase()]||t}:function(e){return i[e]||t}},this.getKeywords=function(){return this.$keywords}}).call(i.prototype),t.TextHighlightRules=i})),ace.define("ace/mode/behaviour",["require","exports","module"],(function(e,t,n){"use strict";var r=function(){this.$behaviours={}};(function(){this.add=function(e,t,n){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[e]:this.$behaviours[e]={}}this.$behaviours[e][t]=n},this.addBehaviours=function(e){for(var t in e)for(var n in e[t])this.add(t,n,e[t][n])},this.remove=function(e){this.$behaviours&&this.$behaviours[e]&&delete this.$behaviours[e]},this.inherit=function(e,t){if("function"==typeof e)var n=(new e).getBehaviours(t);else n=e.getBehaviours(t);this.addBehaviours(n)},this.getBehaviours=function(e){if(e){for(var t={},n=0;n<e.length;n++)this.$behaviours[e[n]]&&(t[e[n]]=this.$behaviours[e[n]]);return t}return this.$behaviours}}).call(r.prototype),t.Behaviour=r})),ace.define("ace/token_iterator",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("./range").Range,i=function(e,t,n){this.$session=e,this.$row=t,this.$rowTokens=e.getTokens(t);var r=e.getTokenAt(t,n);this.$tokenIndex=r?r.index:-1};(function(){this.stepBackward=function(){for(this.$tokenIndex-=1;this.$tokenIndex<0;){if(this.$row-=1,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},this.stepForward=function(){var e;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,e||(e=this.$session.getLength()),this.$row>=e)return this.$row=e-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},this.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},this.getCurrentTokenRow=function(){return this.$row},this.getCurrentTokenColumn=function(){var e=this.$rowTokens,t=this.$tokenIndex,n=e[t].start;if(void 0!==n)return n;for(n=0;t>0;)n+=e[t-=1].value.length;return n},this.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},this.getCurrentTokenRange=function(){var e=this.$rowTokens[this.$tokenIndex],t=this.getCurrentTokenColumn();return new r(this.$row,t,this.$row,t+e.value.length)}}).call(i.prototype),t.TokenIterator=i})),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],(function(e,t,n){"use strict";var r,i=e("../../lib/oop"),o=e("../behaviour").Behaviour,a=e("../../token_iterator").TokenIterator,s=e("../../lib/lang"),c=["text","paren.rparen","punctuation.operator"],l=["text","paren.rparen","punctuation.operator","comment"],u={},h={'"':'"',"'":"'"},d=function(e){var t=-1;if(e.multiSelect&&(t=e.selection.index,u.rangeCount!=e.multiSelect.rangeCount&&(u={rangeCount:e.multiSelect.rangeCount})),u[t])return r=u[t];r=u[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}},f=function(e,t,n,r){var i=e.end.row-e.start.row;return{text:n+t+r,selection:[0,e.start.column+1,i,e.end.column+(i?0:1)]}},p=function(e){this.add("braces","insertion",(function(t,n,i,o,a){var c=i.getCursorPosition(),l=o.doc.getLine(c.row);if("{"==a){d(i);var u=i.getSelectionRange(),h=o.doc.getTextRange(u);if(""!==h&&"{"!==h&&i.getWrapBehavioursEnabled())return f(u,h,"{","}");if(p.isSaneInsertion(i,o))return/[\]\}\)]/.test(l[c.column])||i.inMultiSelectMode||e&&e.braces?(p.recordAutoInsert(i,o,"}"),{text:"{}",selection:[1,1]}):(p.recordMaybeInsert(i,o,"{"),{text:"{",selection:[1,1]})}else if("}"==a){if(d(i),"}"==l.substring(c.column,c.column+1))if(null!==o.$findOpeningBracket("}",{column:c.column+1,row:c.row})&&p.isAutoInsertedClosing(c,l,a))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if("\n"==a||"\r\n"==a){d(i);var m="";if(p.isMaybeInsertedClosing(c,l)&&(m=s.stringRepeat("}",r.maybeInsertedBrackets),p.clearMaybeInsertedClosing()),"}"===l.substring(c.column,c.column+1)){var g=o.findMatchingBracket({row:c.row,column:c.column+1},"}");if(!g)return null;var v=this.$getIndent(o.getLine(g.row))}else{if(!m)return void p.clearMaybeInsertedClosing();v=this.$getIndent(l)}var y=v+o.getTabString();return{text:"\n"+y+"\n"+v+m,selection:[1,y.length,1,y.length]}}p.clearMaybeInsertedClosing()}})),this.add("braces","deletion",(function(e,t,n,i,o){var a=i.doc.getTextRange(o);if(!o.isMultiLine()&&"{"==a){if(d(n),"}"==i.doc.getLine(o.start.row).substring(o.end.column,o.end.column+1))return o.end.column++,o;r.maybeInsertedBrackets--}})),this.add("parens","insertion",(function(e,t,n,r,i){if("("==i){d(n);var o=n.getSelectionRange(),a=r.doc.getTextRange(o);if(""!==a&&n.getWrapBehavioursEnabled())return f(o,a,"(",")");if(p.isSaneInsertion(n,r))return p.recordAutoInsert(n,r,")"),{text:"()",selection:[1,1]}}else if(")"==i){d(n);var s=n.getCursorPosition(),c=r.doc.getLine(s.row);if(")"==c.substring(s.column,s.column+1))if(null!==r.$findOpeningBracket(")",{column:s.column+1,row:s.row})&&p.isAutoInsertedClosing(s,c,i))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}})),this.add("parens","deletion",(function(e,t,n,r,i){var o=r.doc.getTextRange(i);if(!i.isMultiLine()&&"("==o&&(d(n),")"==r.doc.getLine(i.start.row).substring(i.start.column+1,i.start.column+2)))return i.end.column++,i})),this.add("brackets","insertion",(function(e,t,n,r,i){if("["==i){d(n);var o=n.getSelectionRange(),a=r.doc.getTextRange(o);if(""!==a&&n.getWrapBehavioursEnabled())return f(o,a,"[","]");if(p.isSaneInsertion(n,r))return p.recordAutoInsert(n,r,"]"),{text:"[]",selection:[1,1]}}else if("]"==i){d(n);var s=n.getCursorPosition(),c=r.doc.getLine(s.row);if("]"==c.substring(s.column,s.column+1))if(null!==r.$findOpeningBracket("]",{column:s.column+1,row:s.row})&&p.isAutoInsertedClosing(s,c,i))return p.popAutoInsertedClosing(),{text:"",selection:[1,1]}}})),this.add("brackets","deletion",(function(e,t,n,r,i){var o=r.doc.getTextRange(i);if(!i.isMultiLine()&&"["==o&&(d(n),"]"==r.doc.getLine(i.start.row).substring(i.start.column+1,i.start.column+2)))return i.end.column++,i})),this.add("string_dquotes","insertion",(function(e,t,n,r,i){var o=r.$mode.$quotes||h;if(1==i.length&&o[i]){if(this.lineCommentStart&&-1!=this.lineCommentStart.indexOf(i))return;d(n);var a=i,s=n.getSelectionRange(),c=r.doc.getTextRange(s);if(!(""===c||1==c.length&&o[c])&&n.getWrapBehavioursEnabled())return f(s,c,a,a);if(!c){var l=n.getCursorPosition(),u=r.doc.getLine(l.row),p=u.substring(l.column-1,l.column),m=u.substring(l.column,l.column+1),g=r.getTokenAt(l.row,l.column),v=r.getTokenAt(l.row,l.column+1);if("\\"==p&&g&&/escape/.test(g.type))return null;var y,b=g&&/string|escape/.test(g.type),w=!v||/string|escape/.test(v.type);if(m==a)(y=b!==w)&&/string\.end/.test(v.type)&&(y=!1);else{if(b&&!w)return null;if(b&&w)return null;var x=r.$mode.tokenRe;x.lastIndex=0;var _=x.test(p);x.lastIndex=0;var E=x.test(p);if(_||E)return null;if(m&&!/[\s;,.})\]\\]/.test(m))return null;y=!0}return{text:y?a+a:"",selection:[1,1]}}}})),this.add("string_dquotes","deletion",(function(e,t,n,r,i){var o=r.doc.getTextRange(i);if(!i.isMultiLine()&&('"'==o||"'"==o)&&(d(n),r.doc.getLine(i.start.row).substring(i.start.column+1,i.start.column+2)==o))return i.end.column++,i}))};p.isSaneInsertion=function(e,t){var n=e.getCursorPosition(),r=new a(t,n.row,n.column);if(!this.$matchTokenType(r.getCurrentToken()||"text",c)){var i=new a(t,n.row,n.column+1);if(!this.$matchTokenType(i.getCurrentToken()||"text",c))return!1}return r.stepForward(),r.getCurrentTokenRow()!==n.row||this.$matchTokenType(r.getCurrentToken()||"text",l)},p.$matchTokenType=function(e,t){return t.indexOf(e.type||e)>-1},p.recordAutoInsert=function(e,t,n){var i=e.getCursorPosition(),o=t.doc.getLine(i.row);this.isAutoInsertedClosing(i,o,r.autoInsertedLineEnd[0])||(r.autoInsertedBrackets=0),r.autoInsertedRow=i.row,r.autoInsertedLineEnd=n+o.substr(i.column),r.autoInsertedBrackets++},p.recordMaybeInsert=function(e,t,n){var i=e.getCursorPosition(),o=t.doc.getLine(i.row);this.isMaybeInsertedClosing(i,o)||(r.maybeInsertedBrackets=0),r.maybeInsertedRow=i.row,r.maybeInsertedLineStart=o.substr(0,i.column)+n,r.maybeInsertedLineEnd=o.substr(i.column),r.maybeInsertedBrackets++},p.isAutoInsertedClosing=function(e,t,n){return r.autoInsertedBrackets>0&&e.row===r.autoInsertedRow&&n===r.autoInsertedLineEnd[0]&&t.substr(e.column)===r.autoInsertedLineEnd},p.isMaybeInsertedClosing=function(e,t){return r.maybeInsertedBrackets>0&&e.row===r.maybeInsertedRow&&t.substr(e.column)===r.maybeInsertedLineEnd&&t.substr(0,e.column)==r.maybeInsertedLineStart},p.popAutoInsertedClosing=function(){r.autoInsertedLineEnd=r.autoInsertedLineEnd.substr(1),r.autoInsertedBrackets--},p.clearMaybeInsertedClosing=function(){r&&(r.maybeInsertedBrackets=0,r.maybeInsertedRow=-1)},i.inherits(p,o),t.CstyleBehaviour=p})),ace.define("ace/unicode",["require","exports","module"],(function(e,t,n){"use strict";t.packages={},function(e){var n=/\w{4}/g;for(var r in e)t.packages[r]=e[r].replace(n,"\\u$&")}({L:"0041-005A0061-007A00AA00B500BA00C0-00D600D8-00F600F8-02C102C6-02D102E0-02E402EC02EE0370-037403760377037A-037D03860388-038A038C038E-03A103A3-03F503F7-0481048A-05250531-055605590561-058705D0-05EA05F0-05F20621-064A066E066F0671-06D306D506E506E606EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA07F407F507FA0800-0815081A082408280904-0939093D09500958-0961097109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E460E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EC60EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10A0-10C510D0-10FA10FC1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317D717DC1820-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541AA71B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C7D1CE9-1CEC1CEE-1CF11D00-1DBF1E00-1F151F18-1F1D1F20-1F451F48-1F4D1F50-1F571F591F5B1F5D1F5F-1F7D1F80-1FB41FB6-1FBC1FBE1FC2-1FC41FC6-1FCC1FD0-1FD31FD6-1FDB1FE0-1FEC1FF2-1FF41FF6-1FFC2071207F2090-209421022107210A-211321152119-211D212421262128212A-212D212F-2139213C-213F2145-2149214E218321842C00-2C2E2C30-2C5E2C60-2CE42CEB-2CEE2D00-2D252D30-2D652D6F2D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE2E2F300530063031-3035303B303C3041-3096309D-309F30A1-30FA30FC-30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A48CA4D0-A4FDA500-A60CA610-A61FA62AA62BA640-A65FA662-A66EA67F-A697A6A0-A6E5A717-A71FA722-A788A78BA78CA7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2A9CFAA00-AA28AA40-AA42AA44-AA4BAA60-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADB-AADDABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB00-FB06FB13-FB17FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF21-FF3AFF41-FF5AFF66-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",Ll:"0061-007A00AA00B500BA00DF-00F600F8-00FF01010103010501070109010B010D010F01110113011501170119011B011D011F01210123012501270129012B012D012F01310133013501370138013A013C013E014001420144014601480149014B014D014F01510153015501570159015B015D015F01610163016501670169016B016D016F0171017301750177017A017C017E-0180018301850188018C018D019201950199-019B019E01A101A301A501A801AA01AB01AD01B001B401B601B901BA01BD-01BF01C601C901CC01CE01D001D201D401D601D801DA01DC01DD01DF01E101E301E501E701E901EB01ED01EF01F001F301F501F901FB01FD01FF02010203020502070209020B020D020F02110213021502170219021B021D021F02210223022502270229022B022D022F02310233-0239023C023F0240024202470249024B024D024F-02930295-02AF037103730377037B-037D039003AC-03CE03D003D103D5-03D703D903DB03DD03DF03E103E303E503E703E903EB03ED03EF-03F303F503F803FB03FC0430-045F04610463046504670469046B046D046F04710473047504770479047B047D047F0481048B048D048F04910493049504970499049B049D049F04A104A304A504A704A904AB04AD04AF04B104B304B504B704B904BB04BD04BF04C204C404C604C804CA04CC04CE04CF04D104D304D504D704D904DB04DD04DF04E104E304E504E704E904EB04ED04EF04F104F304F504F704F904FB04FD04FF05010503050505070509050B050D050F05110513051505170519051B051D051F0521052305250561-05871D00-1D2B1D62-1D771D79-1D9A1E011E031E051E071E091E0B1E0D1E0F1E111E131E151E171E191E1B1E1D1E1F1E211E231E251E271E291E2B1E2D1E2F1E311E331E351E371E391E3B1E3D1E3F1E411E431E451E471E491E4B1E4D1E4F1E511E531E551E571E591E5B1E5D1E5F1E611E631E651E671E691E6B1E6D1E6F1E711E731E751E771E791E7B1E7D1E7F1E811E831E851E871E891E8B1E8D1E8F1E911E931E95-1E9D1E9F1EA11EA31EA51EA71EA91EAB1EAD1EAF1EB11EB31EB51EB71EB91EBB1EBD1EBF1EC11EC31EC51EC71EC91ECB1ECD1ECF1ED11ED31ED51ED71ED91EDB1EDD1EDF1EE11EE31EE51EE71EE91EEB1EED1EEF1EF11EF31EF51EF71EF91EFB1EFD1EFF-1F071F10-1F151F20-1F271F30-1F371F40-1F451F50-1F571F60-1F671F70-1F7D1F80-1F871F90-1F971FA0-1FA71FB0-1FB41FB61FB71FBE1FC2-1FC41FC61FC71FD0-1FD31FD61FD71FE0-1FE71FF2-1FF41FF61FF7210A210E210F2113212F21342139213C213D2146-2149214E21842C30-2C5E2C612C652C662C682C6A2C6C2C712C732C742C76-2C7C2C812C832C852C872C892C8B2C8D2C8F2C912C932C952C972C992C9B2C9D2C9F2CA12CA32CA52CA72CA92CAB2CAD2CAF2CB12CB32CB52CB72CB92CBB2CBD2CBF2CC12CC32CC52CC72CC92CCB2CCD2CCF2CD12CD32CD52CD72CD92CDB2CDD2CDF2CE12CE32CE42CEC2CEE2D00-2D25A641A643A645A647A649A64BA64DA64FA651A653A655A657A659A65BA65DA65FA663A665A667A669A66BA66DA681A683A685A687A689A68BA68DA68FA691A693A695A697A723A725A727A729A72BA72DA72F-A731A733A735A737A739A73BA73DA73FA741A743A745A747A749A74BA74DA74FA751A753A755A757A759A75BA75DA75FA761A763A765A767A769A76BA76DA76FA771-A778A77AA77CA77FA781A783A785A787A78CFB00-FB06FB13-FB17FF41-FF5A",Lu:"0041-005A00C0-00D600D8-00DE01000102010401060108010A010C010E01100112011401160118011A011C011E01200122012401260128012A012C012E01300132013401360139013B013D013F0141014301450147014A014C014E01500152015401560158015A015C015E01600162016401660168016A016C016E017001720174017601780179017B017D018101820184018601870189-018B018E-0191019301940196-0198019C019D019F01A001A201A401A601A701A901AC01AE01AF01B1-01B301B501B701B801BC01C401C701CA01CD01CF01D101D301D501D701D901DB01DE01E001E201E401E601E801EA01EC01EE01F101F401F6-01F801FA01FC01FE02000202020402060208020A020C020E02100212021402160218021A021C021E02200222022402260228022A022C022E02300232023A023B023D023E02410243-02460248024A024C024E03700372037603860388-038A038C038E038F0391-03A103A3-03AB03CF03D2-03D403D803DA03DC03DE03E003E203E403E603E803EA03EC03EE03F403F703F903FA03FD-042F04600462046404660468046A046C046E04700472047404760478047A047C047E0480048A048C048E04900492049404960498049A049C049E04A004A204A404A604A804AA04AC04AE04B004B204B404B604B804BA04BC04BE04C004C104C304C504C704C904CB04CD04D004D204D404D604D804DA04DC04DE04E004E204E404E604E804EA04EC04EE04F004F204F404F604F804FA04FC04FE05000502050405060508050A050C050E05100512051405160518051A051C051E0520052205240531-055610A0-10C51E001E021E041E061E081E0A1E0C1E0E1E101E121E141E161E181E1A1E1C1E1E1E201E221E241E261E281E2A1E2C1E2E1E301E321E341E361E381E3A1E3C1E3E1E401E421E441E461E481E4A1E4C1E4E1E501E521E541E561E581E5A1E5C1E5E1E601E621E641E661E681E6A1E6C1E6E1E701E721E741E761E781E7A1E7C1E7E1E801E821E841E861E881E8A1E8C1E8E1E901E921E941E9E1EA01EA21EA41EA61EA81EAA1EAC1EAE1EB01EB21EB41EB61EB81EBA1EBC1EBE1EC01EC21EC41EC61EC81ECA1ECC1ECE1ED01ED21ED41ED61ED81EDA1EDC1EDE1EE01EE21EE41EE61EE81EEA1EEC1EEE1EF01EF21EF41EF61EF81EFA1EFC1EFE1F08-1F0F1F18-1F1D1F28-1F2F1F38-1F3F1F48-1F4D1F591F5B1F5D1F5F1F68-1F6F1FB8-1FBB1FC8-1FCB1FD8-1FDB1FE8-1FEC1FF8-1FFB21022107210B-210D2110-211221152119-211D212421262128212A-212D2130-2133213E213F214521832C00-2C2E2C602C62-2C642C672C692C6B2C6D-2C702C722C752C7E-2C802C822C842C862C882C8A2C8C2C8E2C902C922C942C962C982C9A2C9C2C9E2CA02CA22CA42CA62CA82CAA2CAC2CAE2CB02CB22CB42CB62CB82CBA2CBC2CBE2CC02CC22CC42CC62CC82CCA2CCC2CCE2CD02CD22CD42CD62CD82CDA2CDC2CDE2CE02CE22CEB2CEDA640A642A644A646A648A64AA64CA64EA650A652A654A656A658A65AA65CA65EA662A664A666A668A66AA66CA680A682A684A686A688A68AA68CA68EA690A692A694A696A722A724A726A728A72AA72CA72EA732A734A736A738A73AA73CA73EA740A742A744A746A748A74AA74CA74EA750A752A754A756A758A75AA75CA75EA760A762A764A766A768A76AA76CA76EA779A77BA77DA77EA780A782A784A786A78BFF21-FF3A",Lt:"01C501C801CB01F21F88-1F8F1F98-1F9F1FA8-1FAF1FBC1FCC1FFC",Lm:"02B0-02C102C6-02D102E0-02E402EC02EE0374037A0559064006E506E607F407F507FA081A0824082809710E460EC610FC17D718431AA71C78-1C7D1D2C-1D611D781D9B-1DBF2071207F2090-20942C7D2D6F2E2F30053031-3035303B309D309E30FC-30FEA015A4F8-A4FDA60CA67FA717-A71FA770A788A9CFAA70AADDFF70FF9EFF9F",Lo:"01BB01C0-01C3029405D0-05EA05F0-05F20621-063F0641-064A066E066F0671-06D306D506EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA0800-08150904-0939093D09500958-096109720979-097F0985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C330C35-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10D05-0D0C0D0E-0D100D12-0D280D2A-0D390D3D0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E450E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EDC0EDD0F000F40-0F470F49-0F6C0F88-0F8B1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10D0-10FA1100-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA1700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317DC1820-18421844-18771880-18A818AA18B0-18F51900-191C1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541B05-1B331B45-1B4B1B83-1BA01BAE1BAF1C00-1C231C4D-1C4F1C5A-1C771CE9-1CEC1CEE-1CF12135-21382D30-2D652D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE3006303C3041-3096309F30A1-30FA30FF3105-312D3131-318E31A0-31B731F0-31FF3400-4DB54E00-9FCBA000-A014A016-A48CA4D0-A4F7A500-A60BA610-A61FA62AA62BA66EA6A0-A6E5A7FB-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2AA00-AA28AA40-AA42AA44-AA4BAA60-AA6FAA71-AA76AA7AAA80-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADBAADCABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA2DFA30-FA6DFA70-FAD9FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF66-FF6FFF71-FF9DFFA0-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC",M:"0300-036F0483-04890591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DE-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0903093C093E-094E0951-0955096209630981-098309BC09BE-09C409C709C809CB-09CD09D709E209E30A01-0A030A3C0A3E-0A420A470A480A4B-0A4D0A510A700A710A750A81-0A830ABC0ABE-0AC50AC7-0AC90ACB-0ACD0AE20AE30B01-0B030B3C0B3E-0B440B470B480B4B-0B4D0B560B570B620B630B820BBE-0BC20BC6-0BC80BCA-0BCD0BD70C01-0C030C3E-0C440C46-0C480C4A-0C4D0C550C560C620C630C820C830CBC0CBE-0CC40CC6-0CC80CCA-0CCD0CD50CD60CE20CE30D020D030D3E-0D440D46-0D480D4A-0D4D0D570D620D630D820D830DCA0DCF-0DD40DD60DD8-0DDF0DF20DF30E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F3E0F3F0F71-0F840F860F870F90-0F970F99-0FBC0FC6102B-103E1056-1059105E-10601062-10641067-106D1071-10741082-108D108F109A-109D135F1712-17141732-1734175217531772177317B6-17D317DD180B-180D18A91920-192B1930-193B19B0-19C019C819C91A17-1A1B1A55-1A5E1A60-1A7C1A7F1B00-1B041B34-1B441B6B-1B731B80-1B821BA1-1BAA1C24-1C371CD0-1CD21CD4-1CE81CED1CF21DC0-1DE61DFD-1DFF20D0-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66F-A672A67CA67DA6F0A6F1A802A806A80BA823-A827A880A881A8B4-A8C4A8E0-A8F1A926-A92DA947-A953A980-A983A9B3-A9C0AA29-AA36AA43AA4CAA4DAA7BAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE3-ABEAABECABEDFB1EFE00-FE0FFE20-FE26",Mn:"0300-036F0483-04870591-05BD05BF05C105C205C405C505C70610-061A064B-065E067006D6-06DC06DF-06E406E706E806EA-06ED07110730-074A07A6-07B007EB-07F30816-0819081B-08230825-08270829-082D0900-0902093C0941-0948094D0951-095509620963098109BC09C1-09C409CD09E209E30A010A020A3C0A410A420A470A480A4B-0A4D0A510A700A710A750A810A820ABC0AC1-0AC50AC70AC80ACD0AE20AE30B010B3C0B3F0B41-0B440B4D0B560B620B630B820BC00BCD0C3E-0C400C46-0C480C4A-0C4D0C550C560C620C630CBC0CBF0CC60CCC0CCD0CE20CE30D41-0D440D4D0D620D630DCA0DD2-0DD40DD60E310E34-0E3A0E47-0E4E0EB10EB4-0EB90EBB0EBC0EC8-0ECD0F180F190F350F370F390F71-0F7E0F80-0F840F860F870F90-0F970F99-0FBC0FC6102D-10301032-10371039103A103D103E10581059105E-10601071-1074108210851086108D109D135F1712-17141732-1734175217531772177317B7-17BD17C617C9-17D317DD180B-180D18A91920-19221927192819321939-193B1A171A181A561A58-1A5E1A601A621A65-1A6C1A73-1A7C1A7F1B00-1B031B341B36-1B3A1B3C1B421B6B-1B731B801B811BA2-1BA51BA81BA91C2C-1C331C361C371CD0-1CD21CD4-1CE01CE2-1CE81CED1DC0-1DE61DFD-1DFF20D0-20DC20E120E5-20F02CEF-2CF12DE0-2DFF302A-302F3099309AA66FA67CA67DA6F0A6F1A802A806A80BA825A826A8C4A8E0-A8F1A926-A92DA947-A951A980-A982A9B3A9B6-A9B9A9BCAA29-AA2EAA31AA32AA35AA36AA43AA4CAAB0AAB2-AAB4AAB7AAB8AABEAABFAAC1ABE5ABE8ABEDFB1EFE00-FE0FFE20-FE26",Mc:"0903093E-09400949-094C094E0982098309BE-09C009C709C809CB09CC09D70A030A3E-0A400A830ABE-0AC00AC90ACB0ACC0B020B030B3E0B400B470B480B4B0B4C0B570BBE0BBF0BC10BC20BC6-0BC80BCA-0BCC0BD70C01-0C030C41-0C440C820C830CBE0CC0-0CC40CC70CC80CCA0CCB0CD50CD60D020D030D3E-0D400D46-0D480D4A-0D4C0D570D820D830DCF-0DD10DD8-0DDF0DF20DF30F3E0F3F0F7F102B102C10311038103B103C105610571062-10641067-106D108310841087-108C108F109A-109C17B617BE-17C517C717C81923-19261929-192B193019311933-193819B0-19C019C819C91A19-1A1B1A551A571A611A631A641A6D-1A721B041B351B3B1B3D-1B411B431B441B821BA11BA61BA71BAA1C24-1C2B1C341C351CE11CF2A823A824A827A880A881A8B4-A8C3A952A953A983A9B4A9B5A9BAA9BBA9BD-A9C0AA2FAA30AA33AA34AA4DAA7BABE3ABE4ABE6ABE7ABE9ABEAABEC",Me:"0488048906DE20DD-20E020E2-20E4A670-A672",N:"0030-003900B200B300B900BC-00BE0660-066906F0-06F907C0-07C90966-096F09E6-09EF09F4-09F90A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BF20C66-0C6F0C78-0C7E0CE6-0CEF0D66-0D750E50-0E590ED0-0ED90F20-0F331040-10491090-10991369-137C16EE-16F017E0-17E917F0-17F91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C5920702074-20792080-20892150-21822185-21892460-249B24EA-24FF2776-27932CFD30073021-30293038-303A3192-31953220-32293251-325F3280-328932B1-32BFA620-A629A6E6-A6EFA830-A835A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nd:"0030-00390660-066906F0-06F907C0-07C90966-096F09E6-09EF0A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BEF0C66-0C6F0CE6-0CEF0D66-0D6F0E50-0E590ED0-0ED90F20-0F291040-10491090-109917E0-17E91810-18191946-194F19D0-19DA1A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C59A620-A629A8D0-A8D9A900-A909A9D0-A9D9AA50-AA59ABF0-ABF9FF10-FF19",Nl:"16EE-16F02160-21822185-218830073021-30293038-303AA6E6-A6EF",No:"00B200B300B900BC-00BE09F4-09F90BF0-0BF20C78-0C7E0D70-0D750F2A-0F331369-137C17F0-17F920702074-20792080-20892150-215F21892460-249B24EA-24FF2776-27932CFD3192-31953220-32293251-325F3280-328932B1-32BFA830-A835",P:"0021-00230025-002A002C-002F003A003B003F0040005B-005D005F007B007D00A100AB00B700BB00BF037E0387055A-055F0589058A05BE05C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F3A-0F3D0F850FD0-0FD4104A-104F10FB1361-13681400166D166E169B169C16EB-16ED1735173617D4-17D617D8-17DA1800-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD32010-20272030-20432045-20512053-205E207D207E208D208E2329232A2768-277527C527C627E6-27EF2983-299829D8-29DB29FC29FD2CF9-2CFC2CFE2CFF2E00-2E2E2E302E313001-30033008-30113014-301F3030303D30A030FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFD3EFD3FFE10-FE19FE30-FE52FE54-FE61FE63FE68FE6AFE6BFF01-FF03FF05-FF0AFF0C-FF0FFF1AFF1BFF1FFF20FF3B-FF3DFF3FFF5BFF5DFF5F-FF65",Pd:"002D058A05BE140018062010-20152E172E1A301C303030A0FE31FE32FE58FE63FF0D",Ps:"0028005B007B0F3A0F3C169B201A201E2045207D208D23292768276A276C276E27702772277427C527E627E827EA27EC27EE2983298529872989298B298D298F299129932995299729D829DA29FC2E222E242E262E283008300A300C300E3010301430163018301A301DFD3EFE17FE35FE37FE39FE3BFE3DFE3FFE41FE43FE47FE59FE5BFE5DFF08FF3BFF5BFF5FFF62",Pe:"0029005D007D0F3B0F3D169C2046207E208E232A2769276B276D276F27712773277527C627E727E927EB27ED27EF298429862988298A298C298E2990299229942996299829D929DB29FD2E232E252E272E293009300B300D300F3011301530173019301B301E301FFD3FFE18FE36FE38FE3AFE3CFE3EFE40FE42FE44FE48FE5AFE5CFE5EFF09FF3DFF5DFF60FF63",Pi:"00AB2018201B201C201F20392E022E042E092E0C2E1C2E20",Pf:"00BB2019201D203A2E032E052E0A2E0D2E1D2E21",Pc:"005F203F20402054FE33FE34FE4D-FE4FFF3F",Po:"0021-00230025-0027002A002C002E002F003A003B003F0040005C00A100B700BF037E0387055A-055F058905C005C305C605F305F40609060A060C060D061B061E061F066A-066D06D40700-070D07F7-07F90830-083E0964096509700DF40E4F0E5A0E5B0F04-0F120F850FD0-0FD4104A-104F10FB1361-1368166D166E16EB-16ED1735173617D4-17D617D8-17DA1800-18051807-180A1944194519DE19DF1A1E1A1F1AA0-1AA61AA8-1AAD1B5A-1B601C3B-1C3F1C7E1C7F1CD3201620172020-20272030-2038203B-203E2041-20432047-205120532055-205E2CF9-2CFC2CFE2CFF2E002E012E06-2E082E0B2E0E-2E162E182E192E1B2E1E2E1F2E2A-2E2E2E302E313001-3003303D30FBA4FEA4FFA60D-A60FA673A67EA6F2-A6F7A874-A877A8CEA8CFA8F8-A8FAA92EA92FA95FA9C1-A9CDA9DEA9DFAA5C-AA5FAADEAADFABEBFE10-FE16FE19FE30FE45FE46FE49-FE4CFE50-FE52FE54-FE57FE5F-FE61FE68FE6AFE6BFF01-FF03FF05-FF07FF0AFF0CFF0EFF0FFF1AFF1BFF1FFF20FF3CFF61FF64FF65",S:"0024002B003C-003E005E0060007C007E00A2-00A900AC00AE-00B100B400B600B800D700F702C2-02C502D2-02DF02E5-02EB02ED02EF-02FF03750384038503F604820606-0608060B060E060F06E906FD06FE07F609F209F309FA09FB0AF10B700BF3-0BFA0C7F0CF10CF20D790E3F0F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-139917DB194019E0-19FF1B61-1B6A1B74-1B7C1FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE20442052207A-207C208A-208C20A0-20B8210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B2140-2144214A-214D214F2190-2328232B-23E82400-24262440-244A249C-24E92500-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE27C0-27C427C7-27CA27CC27D0-27E527F0-29822999-29D729DC-29FB29FE-2B4C2B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F309B309C319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A700-A716A720A721A789A78AA828-A82BA836-A839AA77-AA79FB29FDFCFDFDFE62FE64-FE66FE69FF04FF0BFF1C-FF1EFF3EFF40FF5CFF5EFFE0-FFE6FFE8-FFEEFFFCFFFD",Sm:"002B003C-003E007C007E00AC00B100D700F703F60606-060820442052207A-207C208A-208C2140-2144214B2190-2194219A219B21A021A321A621AE21CE21CF21D221D421F4-22FF2308-230B23202321237C239B-23B323DC-23E125B725C125F8-25FF266F27C0-27C427C7-27CA27CC27D0-27E527F0-27FF2900-29822999-29D729DC-29FB29FE-2AFF2B30-2B442B47-2B4CFB29FE62FE64-FE66FF0BFF1C-FF1EFF5CFF5EFFE2FFE9-FFEC",Sc:"002400A2-00A5060B09F209F309FB0AF10BF90E3F17DB20A0-20B8A838FDFCFE69FF04FFE0FFE1FFE5FFE6",Sk:"005E006000A800AF00B400B802C2-02C502D2-02DF02E5-02EB02ED02EF-02FF0375038403851FBD1FBF-1FC11FCD-1FCF1FDD-1FDF1FED-1FEF1FFD1FFE309B309CA700-A716A720A721A789A78AFF3EFF40FFE3",So:"00A600A700A900AE00B000B60482060E060F06E906FD06FE07F609FA0B700BF3-0BF80BFA0C7F0CF10CF20D790F01-0F030F13-0F170F1A-0F1F0F340F360F380FBE-0FC50FC7-0FCC0FCE0FCF0FD5-0FD8109E109F13601390-1399194019E0-19FF1B61-1B6A1B74-1B7C210021012103-21062108210921142116-2118211E-2123212521272129212E213A213B214A214C214D214F2195-2199219C-219F21A121A221A421A521A7-21AD21AF-21CD21D021D121D321D5-21F32300-2307230C-231F2322-2328232B-237B237D-239A23B4-23DB23E2-23E82400-24262440-244A249C-24E92500-25B625B8-25C025C2-25F72600-266E2670-26CD26CF-26E126E326E8-26FF2701-27042706-2709270C-27272729-274B274D274F-27522756-275E2761-276727942798-27AF27B1-27BE2800-28FF2B00-2B2F2B452B462B50-2B592CE5-2CEA2E80-2E992E9B-2EF32F00-2FD52FF0-2FFB300430123013302030363037303E303F319031913196-319F31C0-31E33200-321E322A-32503260-327F328A-32B032C0-32FE3300-33FF4DC0-4DFFA490-A4C6A828-A82BA836A837A839AA77-AA79FDFDFFE4FFE8FFEDFFEEFFFCFFFD",Z:"002000A01680180E2000-200A20282029202F205F3000",Zs:"002000A01680180E2000-200A202F205F3000",Zl:"2028",Zp:"2029",C:"0000-001F007F-009F00AD03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-0605061C061D0620065F06DD070E070F074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17B417B517DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF200B-200F202A-202E2060-206F20722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-F8FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFD-FF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFFBFFFEFFFF",Cc:"0000-001F007F-009F",Cf:"00AD0600-060306DD070F17B417B5200B-200F202A-202E2060-2064206A-206FFEFFFFF9-FFFB",Co:"E000-F8FF",Cs:"D800-DFFF",Cn:"03780379037F-0383038B038D03A20526-05300557055805600588058B-059005C8-05CF05EB-05EF05F5-05FF06040605061C061D0620065F070E074B074C07B2-07BF07FB-07FF082E082F083F-08FF093A093B094F095609570973-097809800984098D098E0991099209A909B109B3-09B509BA09BB09C509C609C909CA09CF-09D609D8-09DB09DE09E409E509FC-0A000A040A0B-0A0E0A110A120A290A310A340A370A3A0A3B0A3D0A43-0A460A490A4A0A4E-0A500A52-0A580A5D0A5F-0A650A76-0A800A840A8E0A920AA90AB10AB40ABA0ABB0AC60ACA0ACE0ACF0AD1-0ADF0AE40AE50AF00AF2-0B000B040B0D0B0E0B110B120B290B310B340B3A0B3B0B450B460B490B4A0B4E-0B550B58-0B5B0B5E0B640B650B72-0B810B840B8B-0B8D0B910B96-0B980B9B0B9D0BA0-0BA20BA5-0BA70BAB-0BAD0BBA-0BBD0BC3-0BC50BC90BCE0BCF0BD1-0BD60BD8-0BE50BFB-0C000C040C0D0C110C290C340C3A-0C3C0C450C490C4E-0C540C570C5A-0C5F0C640C650C70-0C770C800C810C840C8D0C910CA90CB40CBA0CBB0CC50CC90CCE-0CD40CD7-0CDD0CDF0CE40CE50CF00CF3-0D010D040D0D0D110D290D3A-0D3C0D450D490D4E-0D560D58-0D5F0D640D650D76-0D780D800D810D840D97-0D990DB20DBC0DBE0DBF0DC7-0DC90DCB-0DCE0DD50DD70DE0-0DF10DF5-0E000E3B-0E3E0E5C-0E800E830E850E860E890E8B0E8C0E8E-0E930E980EA00EA40EA60EA80EA90EAC0EBA0EBE0EBF0EC50EC70ECE0ECF0EDA0EDB0EDE-0EFF0F480F6D-0F700F8C-0F8F0F980FBD0FCD0FD9-0FFF10C6-10CF10FD-10FF1249124E124F12571259125E125F1289128E128F12B112B612B712BF12C112C612C712D7131113161317135B-135E137D-137F139A-139F13F5-13FF169D-169F16F1-16FF170D1715-171F1737-173F1754-175F176D17711774-177F17DE17DF17EA-17EF17FA-17FF180F181A-181F1878-187F18AB-18AF18F6-18FF191D-191F192C-192F193C-193F1941-1943196E196F1975-197F19AC-19AF19CA-19CF19DB-19DD1A1C1A1D1A5F1A7D1A7E1A8A-1A8F1A9A-1A9F1AAE-1AFF1B4C-1B4F1B7D-1B7F1BAB-1BAD1BBA-1BFF1C38-1C3A1C4A-1C4C1C80-1CCF1CF3-1CFF1DE7-1DFC1F161F171F1E1F1F1F461F471F4E1F4F1F581F5A1F5C1F5E1F7E1F7F1FB51FC51FD41FD51FDC1FF01FF11FF51FFF2065-206920722073208F2095-209F20B9-20CF20F1-20FF218A-218F23E9-23FF2427-243F244B-245F26CE26E226E4-26E727002705270A270B2728274C274E2753-2755275F27602795-279727B027BF27CB27CD-27CF2B4D-2B4F2B5A-2BFF2C2F2C5F2CF2-2CF82D26-2D2F2D66-2D6E2D70-2D7F2D97-2D9F2DA72DAF2DB72DBF2DC72DCF2DD72DDF2E32-2E7F2E9A2EF4-2EFF2FD6-2FEF2FFC-2FFF3040309730983100-3104312E-3130318F31B8-31BF31E4-31EF321F32FF4DB6-4DBF9FCC-9FFFA48D-A48FA4C7-A4CFA62C-A63FA660A661A674-A67BA698-A69FA6F8-A6FFA78D-A7FAA82C-A82FA83A-A83FA878-A87FA8C5-A8CDA8DA-A8DFA8FC-A8FFA954-A95EA97D-A97FA9CEA9DA-A9DDA9E0-A9FFAA37-AA3FAA4EAA4FAA5AAA5BAA7C-AA7FAAC3-AADAAAE0-ABBFABEEABEFABFA-ABFFD7A4-D7AFD7C7-D7CAD7FC-D7FFFA2EFA2FFA6EFA6FFADA-FAFFFB07-FB12FB18-FB1CFB37FB3DFB3FFB42FB45FBB2-FBD2FD40-FD4FFD90FD91FDC8-FDEFFDFEFDFFFE1A-FE1FFE27-FE2FFE53FE67FE6C-FE6FFE75FEFDFEFEFF00FFBF-FFC1FFC8FFC9FFD0FFD1FFD8FFD9FFDD-FFDFFFE7FFEF-FFF8FFFEFFFF"})})),ace.define("ace/mode/text",["require","exports","module","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],(function(e,t,n){"use strict";var r=e("../tokenizer").Tokenizer,i=e("./text_highlight_rules").TextHighlightRules,o=e("./behaviour/cstyle").CstyleBehaviour,a=e("../unicode"),s=e("../lib/lang"),c=e("../token_iterator").TokenIterator,l=e("../range").Range,u=function(){this.HighlightRules=i};(function(){this.$defaultBehaviour=new o,this.tokenRe=new RegExp("^["+a.packages.L+a.packages.Mn+a.packages.Mc+a.packages.Nd+a.packages.Pc+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+a.packages.L+a.packages.Mn+a.packages.Mc+a.packages.Nd+a.packages.Pc+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new r(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(e,t,n,r){var i=t.doc,o=!0,a=!0,c=1/0,l=t.getTabSize(),u=!1;if(this.lineCommentStart){if(Array.isArray(this.lineCommentStart))m=this.lineCommentStart.map(s.escapeRegExp).join("|"),f=this.lineCommentStart[0];else m=s.escapeRegExp(this.lineCommentStart),f=this.lineCommentStart;m=new RegExp("^(\\s*)(?:"+m+") ?"),u=t.getUseSoftTabs();y=function(e,t){var n=e.match(m);if(n){var r=n[1].length,o=n[0].length;d(e,r,o)||" "!=n[0][o-1]||o--,i.removeInLine(t,r,o)}};var h=f+" ",d=(v=function(e,t){o&&!/\S/.test(e)||(d(e,c,c)?i.insertInLine({row:t,column:c},h):i.insertInLine({row:t,column:c},f))},b=function(e,t){return m.test(e)},function(e,t,n){for(var r=0;t--&&" "==e.charAt(t);)r++;if(r%l!=0)return!1;for(r=0;" "==e.charAt(n++);)r++;return l>2?r%l!=l-1:r%l==0})}else{if(!this.blockComment)return!1;var f=this.blockComment.start,p=this.blockComment.end,m=new RegExp("^(\\s*)(?:"+s.escapeRegExp(f)+")"),g=new RegExp("(?:"+s.escapeRegExp(p)+")\\s*$"),v=function(e,t){b(e,t)||o&&!/\S/.test(e)||(i.insertInLine({row:t,column:e.length},p),i.insertInLine({row:t,column:c},f))},y=function(e,t){var n;(n=e.match(g))&&i.removeInLine(t,e.length-n[0].length,e.length),(n=e.match(m))&&i.removeInLine(t,n[1].length,n[0].length)},b=function(e,n){if(m.test(e))return!0;for(var r=t.getTokens(n),i=0;i<r.length;i++)if("comment"===r[i].type)return!0}}function w(e){for(var t=n;t<=r;t++)e(i.getLine(t),t)}var x=1/0;w((function(e,t){var n=e.search(/\S/);-1!==n?(n<c&&(c=n),a&&!b(e,t)&&(a=!1)):x>e.length&&(x=e.length)})),c==1/0&&(c=x,o=!1,a=!1),u&&c%l!=0&&(c=Math.floor(c/l)*l),w(a?y:v)},this.toggleBlockComment=function(e,t,n,r){var i=this.blockComment;if(i){!i.start&&i[0]&&(i=i[0]);var o,a,s=(m=new c(t,r.row,r.column)).getCurrentToken(),u=(t.selection,t.selection.toOrientedRange());if(s&&/comment/.test(s.type)){for(var h,d;s&&/comment/.test(s.type);){if(-1!=(g=s.value.indexOf(i.start))){var f=m.getCurrentTokenRow(),p=m.getCurrentTokenColumn()+g;h=new l(f,p,f,p+i.start.length);break}s=m.stepBackward()}var m;for(s=(m=new c(t,r.row,r.column)).getCurrentToken();s&&/comment/.test(s.type);){var g;if(-1!=(g=s.value.indexOf(i.end))){f=m.getCurrentTokenRow(),p=m.getCurrentTokenColumn()+g;d=new l(f,p,f,p+i.end.length);break}s=m.stepForward()}d&&t.remove(d),h&&(t.remove(h),o=h.start.row,a=-i.start.length)}else a=i.start.length,o=n.start.row,t.insert(n.end,i.end),t.insert(n.start,i.start);u.start.row==o&&(u.start.column+=a),u.end.row==o&&(u.end.column+=a),t.selection.fromOrientedRange(u)}},this.getNextLineIndent=function(e,t,n){return this.$getIndent(t)},this.checkOutdent=function(e,t,n){return!1},this.autoOutdent=function(e,t,n){},this.$getIndent=function(e){return e.match(/^\s*/)[0]},this.createWorker=function(e){return null},this.createModeDelegates=function(e){for(var t in this.$embeds=[],this.$modes={},e)e[t]&&(this.$embeds.push(t),this.$modes[t]=new e[t]);var n=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"];for(t=0;t<n.length;t++)!function(e){var r=n[t],i=e[r];e[n[t]]=function(){return this.$delegator(r,arguments,i)}}(this)},this.$delegator=function(e,t,n){var r=t[0];"string"!=typeof r&&(r=r[0]);for(var i=0;i<this.$embeds.length;i++)if(this.$modes[this.$embeds[i]]){var o=r.split(this.$embeds[i]);if(!o[0]&&o[1]){t[0]=o[1];var a=this.$modes[this.$embeds[i]];return a[e].apply(a,t)}}var s=n.apply(this,t);return n?s:void 0},this.transformAction=function(e,t,n,r,i){if(this.$behaviour){var o=this.$behaviour.getBehaviours();for(var a in o)if(o[a][t]){var s=o[a][t].apply(this,arguments);if(s)return s}}},this.getKeywords=function(e){if(!this.completionKeywords){var t=this.$tokenizer.rules,n=[];for(var r in t)for(var i=t[r],o=0,a=i.length;o<a;o++)if("string"==typeof i[o].token)/keyword|support|storage/.test(i[o].token)&&n.push(i[o].regex);else if("object"==typeof i[o].token)for(var s=0,c=i[o].token.length;s<c;s++)if(/keyword|support|storage/.test(i[o].token[s])){r=i[o].regex.match(/\(.+?\)/g)[s];n.push(r.substr(1,r.length-2))}this.completionKeywords=n}return e?n.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(e,t,n,r){return(this.$keywordList||this.$createKeywordList()).map((function(e){return{name:e,value:e,score:0,meta:"keyword"}}))},this.$id="ace/mode/text"}).call(u.prototype),t.Mode=u})),ace.define("ace/apply_delta",["require","exports","module"],(function(e,t,n){"use strict";t.applyDelta=function(e,t,n){var r=t.start.row,i=t.start.column,o=e[r]||"";switch(t.action){case"insert":if(1===t.lines.length)e[r]=o.substring(0,i)+t.lines[0]+o.substring(i);else{var a=[r,1].concat(t.lines);e.splice.apply(e,a),e[r]=o.substring(0,i)+e[r],e[r+t.lines.length-1]+=o.substring(i)}break;case"remove":var s=t.end.column,c=t.end.row;r===c?e[r]=o.substring(0,i)+o.substring(s):e.splice(r,c-r+1,o.substring(0,i)+e[c].substring(s))}}})),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./lib/event_emitter").EventEmitter,o=t.Anchor=function(e,t,n){this.$onChange=this.onChange.bind(this),this.attach(e),void 0===n?this.setPosition(t.row,t.column):this.setPosition(t,n)};(function(){function e(e,t,n){var r=n?e.column<=t.column:e.column<t.column;return e.row<t.row||e.row==t.row&&r}r.implement(this,i),this.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},this.getDocument=function(){return this.document},this.$insertRight=!1,this.onChange=function(t){if(!(t.start.row==t.end.row&&t.start.row!=this.row||t.start.row>this.row)){var n=function(t,n,r){var i="insert"==t.action,o=(i?1:-1)*(t.end.row-t.start.row),a=(i?1:-1)*(t.end.column-t.start.column),s=t.start,c=i?s:t.end;if(e(n,s,r))return{row:n.row,column:n.column};if(e(c,n,!r))return{row:n.row+o,column:n.column+(n.row==c.row?a:0)};return{row:s.row,column:s.column}}(t,{row:this.row,column:this.column},this.$insertRight);this.setPosition(n.row,n.column,!0)}},this.setPosition=function(e,t,n){var r;if(r=n?{row:e,column:t}:this.$clipPositionToDocument(e,t),this.row!=r.row||this.column!=r.column){var i={row:this.row,column:this.column};this.row=r.row,this.column=r.column,this._signal("change",{old:i,value:r})}},this.detach=function(){this.document.removeEventListener("change",this.$onChange)},this.attach=function(e){this.document=e||this.document,this.document.on("change",this.$onChange)},this.$clipPositionToDocument=function(e,t){var n={};return e>=this.document.getLength()?(n.row=Math.max(0,this.document.getLength()-1),n.column=this.document.getLine(n.row).length):e<0?(n.row=0,n.column=0):(n.row=e,n.column=Math.min(this.document.getLine(n.row).length,Math.max(0,t))),t<0&&(n.column=0),n}}).call(o.prototype)})),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./apply_delta").applyDelta,o=e("./lib/event_emitter").EventEmitter,a=e("./range").Range,s=e("./anchor").Anchor,c=function(e){this.$lines=[""],0===e.length?this.$lines=[""]:Array.isArray(e)?this.insertMergedLines({row:0,column:0},e):this.insert({row:0,column:0},e)};(function(){r.implement(this,o),this.setValue=function(e){var t=this.getLength()-1;this.remove(new a(0,0,t,this.getLine(t).length)),this.insert({row:0,column:0},e)},this.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},this.createAnchor=function(e,t){return new s(this,e,t)},0==="aaa".split(/a/).length?this.$split=function(e){return e.replace(/\r\n|\r/g,"\n").split("\n")}:this.$split=function(e){return e.split(/\r\n|\r|\n/)},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r\n|\r|\n)/m);this.$autoNewLine=t?t[1]:"\n",this._signal("changeNewLineMode")},this.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return"\r\n";case"unix":return"\n";default:return this.$autoNewLine||"\n"}},this.$autoNewLine="",this.$newLineMode="auto",this.setNewLineMode=function(e){this.$newLineMode!==e&&(this.$newLineMode=e,this._signal("changeNewLineMode"))},this.getNewLineMode=function(){return this.$newLineMode},this.isNewLine=function(e){return"\r\n"==e||"\r"==e||"\n"==e},this.getLine=function(e){return this.$lines[e]||""},this.getLines=function(e,t){return this.$lines.slice(e,t+1)},this.getAllLines=function(){return this.getLines(0,this.getLength())},this.getLength=function(){return this.$lines.length},this.getTextRange=function(e){return this.getLinesForRange(e).join(this.getNewLineCharacter())},this.getLinesForRange=function(e){var t;if(e.start.row===e.end.row)t=[this.getLine(e.start.row).substring(e.start.column,e.end.column)];else{(t=this.getLines(e.start.row,e.end.row))[0]=(t[0]||"").substring(e.start.column);var n=t.length-1;e.end.row-e.start.row==n&&(t[n]=t[n].substring(0,e.end.column))}return t},this.insertLines=function(e,t){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(e,t)},this.removeLines=function(e,t){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(e,t)},this.insertNewLine=function(e){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(e,["",""])},this.insert=function(e,t){return this.getLength()<=1&&this.$detectNewLine(t),this.insertMergedLines(e,this.$split(t))},this.insertInLine=function(e,t){var n=this.clippedPos(e.row,e.column),r=this.pos(e.row,e.column+t.length);return this.applyDelta({start:n,end:r,action:"insert",lines:[t]},!0),this.clonePos(r)},this.clippedPos=function(e,t){var n=this.getLength();void 0===e?e=n:e<0?e=0:e>=n&&(e=n-1,t=void 0);var r=this.getLine(e);return null==t&&(t=r.length),{row:e,column:t=Math.min(Math.max(t,0),r.length)}},this.clonePos=function(e){return{row:e.row,column:e.column}},this.pos=function(e,t){return{row:e,column:t}},this.$clipPosition=function(e){var t=this.getLength();return e.row>=t?(e.row=Math.max(0,t-1),e.column=this.getLine(t-1).length):(e.row=Math.max(0,e.row),e.column=Math.min(Math.max(e.column,0),this.getLine(e.row).length)),e},this.insertFullLines=function(e,t){var n=0;(e=Math.min(Math.max(e,0),this.getLength()))<this.getLength()?(t=t.concat([""]),n=0):(t=[""].concat(t),e--,n=this.$lines[e].length),this.insertMergedLines({row:e,column:n},t)},this.insertMergedLines=function(e,t){var n=this.clippedPos(e.row,e.column),r={row:n.row+t.length-1,column:(1==t.length?n.column:0)+t[t.length-1].length};return this.applyDelta({start:n,end:r,action:"insert",lines:t}),this.clonePos(r)},this.remove=function(e){var t=this.clippedPos(e.start.row,e.start.column),n=this.clippedPos(e.end.row,e.end.column);return this.applyDelta({start:t,end:n,action:"remove",lines:this.getLinesForRange({start:t,end:n})}),this.clonePos(t)},this.removeInLine=function(e,t,n){var r=this.clippedPos(e,t),i=this.clippedPos(e,n);return this.applyDelta({start:r,end:i,action:"remove",lines:this.getLinesForRange({start:r,end:i})},!0),this.clonePos(r)},this.removeFullLines=function(e,t){e=Math.min(Math.max(0,e),this.getLength()-1);var n=(t=Math.min(Math.max(0,t),this.getLength()-1))==this.getLength()-1&&e>0,r=t<this.getLength()-1,i=n?e-1:e,o=n?this.getLine(i).length:0,s=r?t+1:t,c=r?0:this.getLine(s).length,l=new a(i,o,s,c),u=this.$lines.slice(e,t+1);return this.applyDelta({start:l.start,end:l.end,action:"remove",lines:this.getLinesForRange(l)}),u},this.removeNewLine=function(e){e<this.getLength()-1&&e>=0&&this.applyDelta({start:this.pos(e,this.getLine(e).length),end:this.pos(e+1,0),action:"remove",lines:["",""]})},this.replace=function(e,t){return e instanceof a||(e=a.fromPoints(e.start,e.end)),0===t.length&&e.isEmpty()?e.start:t==this.getTextRange(e)?e.end:(this.remove(e),t?this.insert(e.start,t):e.start)},this.applyDeltas=function(e){for(var t=0;t<e.length;t++)this.applyDelta(e[t])},this.revertDeltas=function(e){for(var t=e.length-1;t>=0;t--)this.revertDelta(e[t])},this.applyDelta=function(e,t){var n="insert"==e.action;(n?e.lines.length<=1&&!e.lines[0]:!a.comparePoints(e.start,e.end))||(n&&e.lines.length>2e4&&this.$splitAndapplyLargeDelta(e,2e4),i(this.$lines,e,t),this._signal("change",e))},this.$splitAndapplyLargeDelta=function(e,t){for(var n=e.lines,r=n.length,i=e.start.row,o=e.start.column,a=0,s=0;;){a=s,s+=t-1;var c=n.slice(a,s);if(s>r){e.lines=c,e.start.row=i+a,e.start.column=o;break}c.push(""),this.applyDelta({start:this.pos(i+a,o),end:this.pos(i+s,o=0),action:e.action,lines:c},!0)}},this.revertDelta=function(e){this.applyDelta({start:this.clonePos(e.start),end:this.clonePos(e.end),action:"insert"==e.action?"remove":"insert",lines:e.lines.slice()})},this.indexToPosition=function(e,t){for(var n=this.$lines||this.getAllLines(),r=this.getNewLineCharacter().length,i=t||0,o=n.length;i<o;i++)if((e-=n[i].length+r)<0)return{row:i,column:e+n[i].length+r};return{row:o-1,column:n[o-1].length}},this.positionToIndex=function(e,t){for(var n=this.$lines||this.getAllLines(),r=this.getNewLineCharacter().length,i=0,o=Math.min(e.row,n.length),a=t||0;a<o;++a)i+=n[a].length+r;return i+e.column}}).call(c.prototype),t.Document=c})),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./lib/event_emitter").EventEmitter,o=function(e,t){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=e;var n=this;this.$worker=function(){if(n.running){for(var e=new Date,t=n.currentLine,r=-1,i=n.doc,o=t;n.lines[t];)t++;var a=i.getLength(),s=0;for(n.running=!1;t<a;){n.$tokenizeRow(t),r=t;do{t++}while(n.lines[t]);if(++s%5==0&&new Date-e>20){n.running=setTimeout(n.$worker,20);break}}n.currentLine=t,-1==r&&(r=t),o<=r&&n.fireUpdateEvent(o,r)}}};(function(){r.implement(this,i),this.setTokenizer=function(e){this.tokenizer=e,this.lines=[],this.states=[],this.start(0)},this.setDocument=function(e){this.doc=e,this.lines=[],this.states=[],this.stop()},this.fireUpdateEvent=function(e,t){var n={first:e,last:t};this._signal("update",{data:n})},this.start=function(e){this.currentLine=Math.min(e||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},this.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},this.$updateOnChange=function(e){var t=e.start.row,n=e.end.row-t;if(0===n)this.lines[t]=null;else if("remove"==e.action)this.lines.splice(t,n+1,null),this.states.splice(t,n+1,null);else{var r=Array(n+1);r.unshift(t,1),this.lines.splice.apply(this.lines,r),this.states.splice.apply(this.states,r)}this.currentLine=Math.min(t,this.currentLine,this.doc.getLength()),this.stop()},this.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},this.getTokens=function(e){return this.lines[e]||this.$tokenizeRow(e)},this.getState=function(e){return this.currentLine==e&&this.$tokenizeRow(e),this.states[e]||"start"},this.$tokenizeRow=function(e){var t=this.doc.getLine(e),n=this.states[e-1],r=this.tokenizer.getLineTokens(t,n,e);return this.states[e]+""!=r.state+""?(this.states[e]=r.state,this.lines[e+1]=null,this.currentLine>e+1&&(this.currentLine=e+1)):this.currentLine==e&&(this.currentLine=e+1),this.lines[e]=r.tokens}}).call(o.prototype),t.BackgroundTokenizer=o})),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],(function(e,t,n){"use strict";var r=e("./lib/lang"),i=(e("./lib/oop"),e("./range").Range),o=function(e,t,n){this.setRegexp(e),this.clazz=t,this.type=n||"text"};(function(){this.MAX_RANGES=500,this.setRegexp=function(e){this.regExp+""!=e+""&&(this.regExp=e,this.cache=[])},this.update=function(e,t,n,o){if(this.regExp)for(var a=o.firstRow,s=o.lastRow,c=a;c<=s;c++){var l=this.cache[c];null==l&&((l=r.getMatchOffsets(n.getLine(c),this.regExp)).length>this.MAX_RANGES&&(l=l.slice(0,this.MAX_RANGES)),l=l.map((function(e){return new i(c,e.offset,c,e.offset+e.length)})),this.cache[c]=l.length?l:"");for(var u=l.length;u--;)t.drawSingleLineMarker(e,l[u].toScreenRange(n),this.clazz,o)}}}).call(o.prototype),t.SearchHighlight=o})),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("../range").Range;function i(e,t){this.foldData=e,Array.isArray(t)?this.folds=t:t=this.folds=[t];var n=t[t.length-1];this.range=new r(t[0].start.row,t[0].start.column,n.end.row,n.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach((function(e){e.setFoldLine(this)}),this)}(function(){this.shiftRow=function(e){this.start.row+=e,this.end.row+=e,this.folds.forEach((function(t){t.start.row+=e,t.end.row+=e}))},this.addFold=function(e){if(e.sameRow){if(e.start.row<this.startRow||e.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(e),this.folds.sort((function(e,t){return-e.range.compareEnd(t.start.row,t.start.column)})),this.range.compareEnd(e.start.row,e.start.column)>0?(this.end.row=e.end.row,this.end.column=e.end.column):this.range.compareStart(e.end.row,e.end.column)<0&&(this.start.row=e.start.row,this.start.column=e.start.column)}else if(e.start.row==this.end.row)this.folds.push(e),this.end.row=e.end.row,this.end.column=e.end.column;else{if(e.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(e),this.start.row=e.start.row,this.start.column=e.start.column}e.foldLine=this},this.containsRow=function(e){return e>=this.start.row&&e<=this.end.row},this.walk=function(e,t,n){var r,i,o=0,a=this.folds,s=!0;null==t&&(t=this.end.row,n=this.end.column);for(var c=0;c<a.length;c++){if(-1==(i=(r=a[c]).range.compareStart(t,n)))return void e(null,t,n,o,s);if(!e(null,r.start.row,r.start.column,o,s)&&e(r.placeholder,r.start.row,r.start.column,o)||0===i)return;s=!r.sameRow,o=r.end.column}e(null,t,n,o,s)},this.getNextFoldTo=function(e,t){for(var n,r,i=0;i<this.folds.length;i++){if(-1==(r=(n=this.folds[i]).range.compareEnd(e,t)))return{fold:n,kind:"after"};if(0===r)return{fold:n,kind:"inside"}}return null},this.addRemoveChars=function(e,t,n){var r,i,o=this.getNextFoldTo(e,t);if(o)if(r=o.fold,"inside"==o.kind&&r.start.column!=t&&r.start.row!=e)window.console&&window.console.log(e,t,r);else if(r.start.row==e){var a=(i=this.folds).indexOf(r);for(0===a&&(this.start.column+=n);a<i.length;a++){if((r=i[a]).start.column+=n,!r.sameRow)return;r.end.column+=n}this.end.column+=n}},this.split=function(e,t){var n=this.getNextFoldTo(e,t);if(!n||"inside"==n.kind)return null;var r=n.fold,o=this.folds,a=this.foldData,s=o.indexOf(r),c=o[s-1];this.end.row=c.end.row,this.end.column=c.end.column;var l=new i(a,o=o.splice(s,o.length-s));return a.splice(a.indexOf(this)+1,0,l),l},this.merge=function(e){for(var t=e.folds,n=0;n<t.length;n++)this.addFold(t[n]);var r=this.foldData;r.splice(r.indexOf(e),1)},this.toString=function(){var e=[this.range.toString()+": ["];return this.folds.forEach((function(t){e.push("  "+t.toString())})),e.push("]"),e.join("\n")},this.idxToPosition=function(e){for(var t=0,n=0;n<this.folds.length;n++){var r=this.folds[n];if((e-=r.start.column-t)<0)return{row:r.start.row,column:r.start.column+e};if((e-=r.placeholder.length)<0)return r.start;t=r.end.column}return{row:this.end.row,column:this.end.column+e}}}).call(i.prototype),t.FoldLine=i})),ace.define("ace/range_list",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("./range").Range.comparePoints,i=function(){this.ranges=[]};(function(){this.comparePoints=r,this.pointIndex=function(e,t,n){for(var i=this.ranges,o=n||0;o<i.length;o++){var a=i[o],s=r(e,a.end);if(!(s>0)){var c=r(e,a.start);return 0===s?t&&0!==c?-o-2:o:c>0||0===c&&!t?o:-o-1}}return-o-1},this.add=function(e){var t=!e.isEmpty(),n=this.pointIndex(e.start,t);n<0&&(n=-n-1);var r=this.pointIndex(e.end,t,n);return r<0?r=-r-1:r++,this.ranges.splice(n,r-n,e)},this.addList=function(e){for(var t=[],n=e.length;n--;)t.push.apply(t,this.add(e[n]));return t},this.substractPoint=function(e){var t=this.pointIndex(e);if(t>=0)return this.ranges.splice(t,1)},this.merge=function(){for(var e,t=[],n=this.ranges,i=(n=n.sort((function(e,t){return r(e.start,t.start)})))[0],o=1;o<n.length;o++){e=i,i=n[o];var a=r(e.end,i.start);a<0||(0!=a||e.isEmpty()||i.isEmpty())&&(r(e.end,i.end)<0&&(e.end.row=i.end.row,e.end.column=i.end.column),n.splice(o,1),t.push(i),i=e,o--)}return this.ranges=n,t},this.contains=function(e,t){return this.pointIndex({row:e,column:t})>=0},this.containsPoint=function(e){return this.pointIndex(e)>=0},this.rangeAtPoint=function(e){var t=this.pointIndex(e);if(t>=0)return this.ranges[t]},this.clipRows=function(e,t){var n=this.ranges;if(n[0].start.row>t||n[n.length-1].start.row<e)return[];var r=this.pointIndex({row:e,column:0});r<0&&(r=-r-1);var i=this.pointIndex({row:t,column:0},r);i<0&&(i=-i-1);for(var o=[],a=r;a<i;a++)o.push(n[a]);return o},this.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},this.attach=function(e){this.session&&this.detach(),this.session=e,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},this.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},this.$onChange=function(e){if("insert"==e.action)var t=e.start,n=e.end;else n=e.start,t=e.end;for(var r=t.row,i=n.row-r,o=-t.column+n.column,a=this.ranges,s=0,c=a.length;s<c;s++){if(!((l=a[s]).end.row<r)){if(l.start.row>r)break;if(l.start.row==r&&l.start.column>=t.column&&(l.start.column==t.column&&this.$insertRight||(l.start.column+=o,l.start.row+=i)),l.end.row==r&&l.end.column>=t.column){if(l.end.column==t.column&&this.$insertRight)continue;l.end.column==t.column&&o>0&&s<c-1&&l.end.column>l.start.column&&l.end.column==a[s+1].start.column&&(l.end.column-=o),l.end.column+=o,l.end.row+=i}}}if(0!=i&&s<c)for(;s<c;s++){var l;(l=a[s]).start.row+=i,l.end.row+=i}}}).call(i.prototype),t.RangeList=i})),ace.define("ace/edit_session/fold",["require","exports","module","ace/range","ace/range_list","ace/lib/oop"],(function(e,t,n){"use strict";e("../range").Range;var r=e("../range_list").RangeList,i=e("../lib/oop"),o=t.Fold=function(e,t){this.foldLine=null,this.placeholder=t,this.range=e,this.start=e.start,this.end=e.end,this.sameRow=e.start.row==e.end.row,this.subFolds=this.ranges=[]};function a(e,t){e.row-=t.row,0==e.row&&(e.column-=t.column)}function s(e,t){0==e.row&&(e.column+=t.column),e.row+=t.row}i.inherits(o,r),function(){this.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},this.setFoldLine=function(e){this.foldLine=e,this.subFolds.forEach((function(t){t.setFoldLine(e)}))},this.clone=function(){var e=this.range.clone(),t=new o(e,this.placeholder);return this.subFolds.forEach((function(e){t.subFolds.push(e.clone())})),t.collapseChildren=this.collapseChildren,t},this.addSubFold=function(e){if(!this.range.isEqual(e)){if(!this.range.containsRange(e))throw new Error("A fold can't intersect already existing fold"+e.range+this.range);var t,n;t=e,n=this.start,a(t.start,n),a(t.end,n);for(var r=e.start.row,i=e.start.column,o=0,s=-1;o<this.subFolds.length&&1==(s=this.subFolds[o].range.compare(r,i));o++);var c=this.subFolds[o];if(0==s)return c.addSubFold(e);r=e.range.end.row,i=e.range.end.column;var l=o;for(s=-1;l<this.subFolds.length&&1==(s=this.subFolds[l].range.compare(r,i));l++);this.subFolds[l];if(0==s)throw new Error("A fold can't intersect already existing fold"+e.range+this.range);this.subFolds.splice(o,l-o,e);return e.setFoldLine(this.foldLine),e}},this.restoreRange=function(e){return function(e,t){s(e.start,t),s(e.end,t)}(e,this.start)}}.call(o.prototype)})),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator"],(function(e,t,n){"use strict";var r=e("../range").Range,i=e("./fold_line").FoldLine,o=e("./fold").Fold,a=e("../token_iterator").TokenIterator;t.Folding=function(){this.getFoldAt=function(e,t,n){var r=this.getFoldLine(e);if(!r)return null;for(var i=r.folds,o=0;o<i.length;o++){var a=i[o];if(a.range.contains(e,t)){if(1==n&&a.range.isEnd(e,t))continue;if(-1==n&&a.range.isStart(e,t))continue;return a}}},this.getFoldsInRange=function(e){var t=e.start,n=e.end,r=this.$foldData,i=[];t.column+=1,n.column-=1;for(var o=0;o<r.length;o++){var a=r[o].range.compareRange(e);if(2!=a){if(-2==a)break;for(var s=r[o].folds,c=0;c<s.length;c++){var l=s[c];if(-2==(a=l.range.compareRange(e)))break;if(2!=a){if(42==a)break;i.push(l)}}}}return t.column-=1,n.column+=1,i},this.getFoldsInRangeList=function(e){if(Array.isArray(e)){var t=[];e.forEach((function(e){t=t.concat(this.getFoldsInRange(e))}),this)}else t=this.getFoldsInRange(e);return t},this.getAllFolds=function(){for(var e=[],t=this.$foldData,n=0;n<t.length;n++)for(var r=0;r<t[n].folds.length;r++)e.push(t[n].folds[r]);return e},this.getFoldStringAt=function(e,t,n,r){if(!(r=r||this.getFoldLine(e)))return null;for(var i,o,a={end:{column:0}},s=0;s<r.folds.length;s++){var c=(o=r.folds[s]).range.compareEnd(e,t);if(-1==c){i=this.getLine(o.start.row).substring(a.end.column,o.start.column);break}if(0===c)return null;a=o}return i||(i=this.getLine(o.start.row).substring(a.end.column)),-1==n?i.substring(0,t-a.end.column):1==n?i.substring(t-a.end.column):i},this.getFoldLine=function(e,t){var n=this.$foldData,r=0;for(t&&(r=n.indexOf(t)),-1==r&&(r=0);r<n.length;r++){var i=n[r];if(i.start.row<=e&&i.end.row>=e)return i;if(i.end.row>e)return null}return null},this.getNextFoldLine=function(e,t){var n=this.$foldData,r=0;for(t&&(r=n.indexOf(t)),-1==r&&(r=0);r<n.length;r++){var i=n[r];if(i.end.row>=e)return i}return null},this.getFoldedRowCount=function(e,t){for(var n=this.$foldData,r=t-e+1,i=0;i<n.length;i++){var o=n[i],a=o.end.row,s=o.start.row;if(a>=t){s<t&&(s>=e?r-=t-s:r=0);break}a>=e&&(r-=s>=e?a-s:a-e+1)}return r},this.$addFoldLine=function(e){return this.$foldData.push(e),this.$foldData.sort((function(e,t){return e.start.row-t.start.row})),e},this.addFold=function(e,t){var n,r=this.$foldData,a=!1;e instanceof o?n=e:(n=new o(t,e)).collapseChildren=t.collapseChildren,this.$clipRangeToDocument(n.range);var s=n.start.row,c=n.start.column,l=n.end.row,u=n.end.column;if(!(s<l||s==l&&c<=u-2))throw new Error("The range has to be at least 2 characters width");var h=this.getFoldAt(s,c,1),d=this.getFoldAt(l,u,-1);if(h&&d==h)return h.addSubFold(n);h&&!h.range.isStart(s,c)&&this.removeFold(h),d&&!d.range.isEnd(l,u)&&this.removeFold(d);var f=this.getFoldsInRange(n.range);f.length>0&&(this.removeFolds(f),f.forEach((function(e){n.addSubFold(e)})));for(var p=0;p<r.length;p++){var m=r[p];if(l==m.start.row){m.addFold(n),a=!0;break}if(s==m.end.row){if(m.addFold(n),a=!0,!n.sameRow){var g=r[p+1];if(g&&g.start.row==l){m.merge(g);break}}break}if(l<=m.start.row)break}return a||(m=this.$addFoldLine(new i(this.$foldData,n))),this.$useWrapMode?this.$updateWrapData(m.start.row,m.start.row):this.$updateRowLengthCache(m.start.row,m.start.row),this.$modified=!0,this._signal("changeFold",{data:n,action:"add"}),n},this.addFolds=function(e){e.forEach((function(e){this.addFold(e)}),this)},this.removeFold=function(e){var t=e.foldLine,n=t.start.row,r=t.end.row,i=this.$foldData,o=t.folds;if(1==o.length)i.splice(i.indexOf(t),1);else if(t.range.isEnd(e.end.row,e.end.column))o.pop(),t.end.row=o[o.length-1].end.row,t.end.column=o[o.length-1].end.column;else if(t.range.isStart(e.start.row,e.start.column))o.shift(),t.start.row=o[0].start.row,t.start.column=o[0].start.column;else if(e.sameRow)o.splice(o.indexOf(e),1);else{var a=t.split(e.start.row,e.start.column);(o=a.folds).shift(),a.start.row=o[0].start.row,a.start.column=o[0].start.column}this.$updating||(this.$useWrapMode?this.$updateWrapData(n,r):this.$updateRowLengthCache(n,r)),this.$modified=!0,this._signal("changeFold",{data:e,action:"remove"})},this.removeFolds=function(e){for(var t=[],n=0;n<e.length;n++)t.push(e[n]);t.forEach((function(e){this.removeFold(e)}),this),this.$modified=!0},this.expandFold=function(e){this.removeFold(e),e.subFolds.forEach((function(t){e.restoreRange(t),this.addFold(t)}),this),e.collapseChildren>0&&this.foldAll(e.start.row+1,e.end.row,e.collapseChildren-1),e.subFolds=[]},this.expandFolds=function(e){e.forEach((function(e){this.expandFold(e)}),this)},this.unfold=function(e,t){var n,i;if(null==e?(n=new r(0,0,this.getLength(),0),t=!0):n="number"==typeof e?new r(e,0,e,this.getLine(e).length):"row"in e?r.fromPoints(e,e):e,i=this.getFoldsInRangeList(n),t)this.removeFolds(i);else for(var o=i;o.length;)this.expandFolds(o),o=this.getFoldsInRangeList(n);if(i.length)return i},this.isRowFolded=function(e,t){return!!this.getFoldLine(e,t)},this.getRowFoldEnd=function(e,t){var n=this.getFoldLine(e,t);return n?n.end.row:e},this.getRowFoldStart=function(e,t){var n=this.getFoldLine(e,t);return n?n.start.row:e},this.getFoldDisplayLine=function(e,t,n,r,i){null==r&&(r=e.start.row),null==i&&(i=0),null==t&&(t=e.end.row),null==n&&(n=this.getLine(t).length);var o=this.doc,a="";return e.walk((function(e,t,n,s){if(!(t<r)){if(t==r){if(n<i)return;s=Math.max(i,s)}a+=null!=e?e:o.getLine(t).substring(s,n)}}),t,n),a},this.getDisplayLine=function(e,t,n,r){var i,o=this.getFoldLine(e);return o?this.getFoldDisplayLine(o,e,t,n,r):(i=this.doc.getLine(e)).substring(r||0,t||i.length)},this.$cloneFoldData=function(){var e=[];return e=this.$foldData.map((function(t){var n=t.folds.map((function(e){return e.clone()}));return new i(e,n)}))},this.toggleFold=function(e){var t,n,r=this.selection.getRange();if(r.isEmpty()){var i=r.start;if(t=this.getFoldAt(i.row,i.column))return void this.expandFold(t);(n=this.findMatchingBracket(i))?1==r.comparePoint(n)?r.end=n:(r.start=n,r.start.column++,r.end.column--):(n=this.findMatchingBracket({row:i.row,column:i.column+1}))?(1==r.comparePoint(n)?r.end=n:r.start=n,r.start.column++):r=this.getCommentFoldRange(i.row,i.column)||r}else{var o=this.getFoldsInRange(r);if(e&&o.length)return void this.expandFolds(o);1==o.length&&(t=o[0])}if(t||(t=this.getFoldAt(r.start.row,r.start.column)),t&&t.range.toString()==r.toString())this.expandFold(t);else{var a="...";if(!r.isMultiLine()){if((a=this.getTextRange(r)).length<4)return;a=a.trim().substring(0,2)+".."}this.addFold(a,r)}},this.getCommentFoldRange=function(e,t,n){var i=new a(this,e,t),o=i.getCurrentToken(),s=o.type;if(o&&/^comment|string/.test(s)){"comment"==(s=s.match(/comment|string/)[0])&&(s+="|doc-start");var c=new RegExp(s),l=new r;if(1!=n){do{o=i.stepBackward()}while(o&&c.test(o.type));i.stepForward()}if(l.start.row=i.getCurrentTokenRow(),l.start.column=i.getCurrentTokenColumn()+2,i=new a(this,e,t),-1!=n){var u=-1;do{if(o=i.stepForward(),-1==u){var h=this.getState(i.$row);c.test(h)||(u=i.$row)}else if(i.$row>u)break}while(o&&c.test(o.type));o=i.stepBackward()}else o=i.getCurrentToken();return l.end.row=i.getCurrentTokenRow(),l.end.column=i.getCurrentTokenColumn()+o.value.length-2,l}},this.foldAll=function(e,t,n){null==n&&(n=1e5);var r=this.foldWidgets;if(r){t=t||this.getLength();for(var i=e=e||0;i<t;i++)if(null==r[i]&&(r[i]=this.getFoldWidget(i)),"start"==r[i]){var o=this.getFoldWidgetRange(i);if(o&&o.isMultiLine()&&o.end.row<=t&&o.start.row>=e){i=o.end.row;try{var a=this.addFold("...",o);a&&(a.collapseChildren=n)}catch(e){}}}}},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(e){if(!this.$foldStyles[e])throw new Error("invalid fold style: "+e+"["+Object.keys(this.$foldStyles).join(", ")+"]");if(this.$foldStyle!=e){this.$foldStyle=e,"manual"==e&&this.unfold();var t=this.$foldMode;this.$setFolding(null),this.$setFolding(t)}},this.$setFolding=function(e){this.$foldMode!=e&&(this.$foldMode=e,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),e&&"manual"!=this.$foldStyle?(this.foldWidgets=[],this.getFoldWidget=e.getFoldWidget.bind(e,this,this.$foldStyle),this.getFoldWidgetRange=e.getFoldWidgetRange.bind(e,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(e,t){var n=this.foldWidgets;if(!n||t&&n[e])return{};for(var r,i=e-1;i>=0;){var o=n[i];if(null==o&&(o=n[i]=this.getFoldWidget(i)),"start"==o){var a=this.getFoldWidgetRange(i);if(r||(r=a),a&&a.end.row>=e)break}i--}return{range:-1!==i&&a,firstRange:r}},this.onFoldWidgetClick=function(e,t){var n={children:(t=t.domEvent).shiftKey,all:t.ctrlKey||t.metaKey,siblings:t.altKey};if(!this.$toggleFoldWidget(e,n)){var r=t.target||t.srcElement;r&&/ace_fold-widget/.test(r.className)&&(r.className+=" ace_invalid")}},this.$toggleFoldWidget=function(e,t){if(this.getFoldWidget){var n=this.getFoldWidget(e),r=this.getLine(e),i="end"===n?-1:1,o=this.getFoldAt(e,-1===i?0:r.length,i);if(o)return t.children||t.all?this.removeFold(o):this.expandFold(o),o;var a=this.getFoldWidgetRange(e,!0);if(a&&!a.isMultiLine()&&(o=this.getFoldAt(a.start.row,a.start.column,1))&&a.isEqual(o.range))return this.removeFold(o),o;if(t.siblings){var s=this.getParentFoldRangeData(e);if(s.range)var c=s.range.start.row+1,l=s.range.end.row;this.foldAll(c,l,t.all?1e4:0)}else t.children?(l=a?a.end.row:this.getLength(),this.foldAll(e+1,l,t.all?1e4:0)):a&&(t.all&&(a.collapseChildren=1e4),this.addFold("...",a));return a}},this.toggleFoldWidget=function(e){var t=this.selection.getCursor().row;t=this.getRowFoldStart(t);var n=this.$toggleFoldWidget(t,{});if(!n){var r=this.getParentFoldRangeData(t,!0);if(n=r.range||r.firstRange){t=n.start.row;var i=this.getFoldAt(t,this.getLine(t).length,1);i?this.removeFold(i):this.addFold("...",n)}}},this.updateFoldWidgets=function(e){var t=e.start.row,n=e.end.row-t;if(0===n)this.foldWidgets[t]=null;else if("remove"==e.action)this.foldWidgets.splice(t,n+1,null);else{var r=Array(n+1);r.unshift(t,1),this.foldWidgets.splice.apply(this.foldWidgets,r)}},this.tokenizerUpdateFoldWidgets=function(e){var t=e.data;t.first!=t.last&&this.foldWidgets.length>t.first&&this.foldWidgets.splice(t.first,this.foldWidgets.length)}}})),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],(function(e,t,n){"use strict";var r=e("../token_iterator").TokenIterator,i=e("../range").Range;t.BracketMatch=function(){this.findMatchingBracket=function(e,t){if(0==e.column)return null;var n=t||this.getLine(e.row).charAt(e.column-1);if(""==n)return null;var r=n.match(/([\(\[\{])|([\)\]\}])/);return r?r[1]?this.$findClosingBracket(r[1],e):this.$findOpeningBracket(r[2],e):null},this.getBracketRange=function(e){var t,n=this.getLine(e.row),r=!0,o=n.charAt(e.column-1),a=o&&o.match(/([\(\[\{])|([\)\]\}])/);if(a||(o=n.charAt(e.column),e={row:e.row,column:e.column+1},a=o&&o.match(/([\(\[\{])|([\)\]\}])/),r=!1),!a)return null;if(a[1]){if(!(s=this.$findClosingBracket(a[1],e)))return null;t=i.fromPoints(e,s),r||(t.end.column++,t.start.column--),t.cursor=t.end}else{var s;if(!(s=this.$findOpeningBracket(a[2],e)))return null;t=i.fromPoints(s,e),r||(t.start.column++,t.end.column--),t.cursor=t.start}return t},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{"},this.$findOpeningBracket=function(e,t,n){var i=this.$brackets[e],o=1,a=new r(this,t.row,t.column),s=a.getCurrentToken();if(s||(s=a.stepForward()),s){n||(n=new RegExp("(\\.?"+s.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)")+")+"));for(var c=t.column-a.getCurrentTokenColumn()-2,l=s.value;;){for(;c>=0;){var u=l.charAt(c);if(u==i){if(0==(o-=1))return{row:a.getCurrentTokenRow(),column:c+a.getCurrentTokenColumn()}}else u==e&&(o+=1);c-=1}do{s=a.stepBackward()}while(s&&!n.test(s.type));if(null==s)break;c=(l=s.value).length-1}return null}},this.$findClosingBracket=function(e,t,n){var i=this.$brackets[e],o=1,a=new r(this,t.row,t.column),s=a.getCurrentToken();if(s||(s=a.stepForward()),s){n||(n=new RegExp("(\\.?"+s.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)")+")+"));for(var c=t.column-a.getCurrentTokenColumn();;){for(var l=s.value,u=l.length;c<u;){var h=l.charAt(c);if(h==i){if(0==(o-=1))return{row:a.getCurrentTokenRow(),column:c+a.getCurrentTokenColumn()}}else h==e&&(o+=1);c+=1}do{s=a.stepForward()}while(s&&!n.test(s.type));if(null==s)break;c=0}return null}}}})),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/edit_session/folding","ace/edit_session/bracket_match"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./lib/lang"),o=e("./bidihandler").BidiHandler,a=e("./config"),s=e("./lib/event_emitter").EventEmitter,c=e("./selection").Selection,l=e("./mode/text").Mode,u=e("./range").Range,h=e("./document").Document,d=e("./background_tokenizer").BackgroundTokenizer,f=e("./search_highlight").SearchHighlight,p=function(e,t){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++p.$uid,this.$foldData.toString=function(){return this.join("\n")},this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),"object"==typeof e&&e.getLine||(e=new h(e)),this.$bidiHandler=new o(this),this.setDocument(e),this.selection=new c(this),a.resetOptions(this),this.setMode(t),a._signal("session",this)};p.$uid=0,function(){r.implement(this,s),this.setDocument=function(e){this.doc&&this.doc.removeListener("change",this.$onChange),this.doc=e,e.on("change",this.$onChange),this.bgTokenizer&&this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},this.getDocument=function(){return this.doc},this.$resetRowCache=function(e){if(!e)return this.$docRowCache=[],void(this.$screenRowCache=[]);var t=this.$docRowCache.length,n=this.$getRowCacheIndex(this.$docRowCache,e)+1;t>n&&(this.$docRowCache.splice(n,t),this.$screenRowCache.splice(n,t))},this.$getRowCacheIndex=function(e,t){for(var n=0,r=e.length-1;n<=r;){var i=n+r>>1,o=e[i];if(t>o)n=i+1;else{if(!(t<o))return i;r=i-1}}return n-1},this.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.bgTokenizer&&this.bgTokenizer.start(0)},this.onChangeFold=function(e){var t=e.data;this.$resetRowCache(t.start.row)},this.onChange=function(e){this.$modified=!0,this.$bidiHandler.onChange(e),this.$resetRowCache(e.start.row);var t=this.$updateInternalDataOnChange(e);this.$fromUndo||!this.$undoManager||e.ignore||(this.$deltasDoc.push(e),t&&0!=t.length&&this.$deltasFold.push({action:"removeFolds",folds:t}),this.$informUndoManager.schedule()),this.bgTokenizer&&this.bgTokenizer.$updateOnChange(e),this._signal("change",e)},this.setValue=function(e){this.doc.setValue(e),this.selection.moveTo(0,0),this.$resetRowCache(0),this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},this.getValue=this.toString=function(){return this.doc.getValue()},this.getSelection=function(){return this.selection},this.getState=function(e){return this.bgTokenizer.getState(e)},this.getTokens=function(e){return this.bgTokenizer.getTokens(e)},this.getTokenAt=function(e,t){var n,r=this.bgTokenizer.getTokens(e),i=0;if(null==t){var o=r.length-1;i=this.getLine(e).length}else for(o=0;o<r.length&&!((i+=r[o].value.length)>=t);o++);return(n=r[o])?(n.index=o,n.start=i-n.value.length,n):null},this.setUndoManager=function(e){if(this.$undoManager=e,this.$deltas=[],this.$deltasDoc=[],this.$deltasFold=[],this.$informUndoManager&&this.$informUndoManager.cancel(),e){var t=this;this.$syncInformUndoManager=function(){t.$informUndoManager.cancel(),t.$deltasFold.length&&(t.$deltas.push({group:"fold",deltas:t.$deltasFold}),t.$deltasFold=[]),t.$deltasDoc.length&&(t.$deltas.push({group:"doc",deltas:t.$deltasDoc}),t.$deltasDoc=[]),t.$deltas.length>0&&e.execute({action:"aceupdate",args:[t.$deltas,t],merge:t.mergeUndoDeltas}),t.mergeUndoDeltas=!1,t.$deltas=[]},this.$informUndoManager=i.delayedCall(this.$syncInformUndoManager)}},this.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},this.$defaultUndoManager={undo:function(){},redo:function(){},reset:function(){}},this.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},this.getTabString=function(){return this.getUseSoftTabs()?i.stringRepeat(" ",this.getTabSize()):"\t"},this.setUseSoftTabs=function(e){this.setOption("useSoftTabs",e)},this.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},this.setTabSize=function(e){this.setOption("tabSize",e)},this.getTabSize=function(){return this.$tabSize},this.isTabStop=function(e){return this.$useSoftTabs&&e.column%this.$tabSize==0},this.setNavigateWithinSoftTabs=function(e){this.setOption("navigateWithinSoftTabs",e)},this.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},this.$overwrite=!1,this.setOverwrite=function(e){this.setOption("overwrite",e)},this.getOverwrite=function(){return this.$overwrite},this.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},this.addGutterDecoration=function(e,t){this.$decorations[e]||(this.$decorations[e]=""),this.$decorations[e]+=" "+t,this._signal("changeBreakpoint",{})},this.removeGutterDecoration=function(e,t){this.$decorations[e]=(this.$decorations[e]||"").replace(" "+t,""),this._signal("changeBreakpoint",{})},this.getBreakpoints=function(){return this.$breakpoints},this.setBreakpoints=function(e){this.$breakpoints=[];for(var t=0;t<e.length;t++)this.$breakpoints[e[t]]="ace_breakpoint";this._signal("changeBreakpoint",{})},this.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},this.setBreakpoint=function(e,t){void 0===t&&(t="ace_breakpoint"),t?this.$breakpoints[e]=t:delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.clearBreakpoint=function(e){delete this.$breakpoints[e],this._signal("changeBreakpoint",{})},this.addMarker=function(e,t,n,r){var i=this.$markerId++,o={range:e,type:n||"line",renderer:"function"==typeof n?n:null,clazz:t,inFront:!!r,id:i};return r?(this.$frontMarkers[i]=o,this._signal("changeFrontMarker")):(this.$backMarkers[i]=o,this._signal("changeBackMarker")),i},this.addDynamicMarker=function(e,t){if(e.update){var n=this.$markerId++;return e.id=n,e.inFront=!!t,t?(this.$frontMarkers[n]=e,this._signal("changeFrontMarker")):(this.$backMarkers[n]=e,this._signal("changeBackMarker")),e}},this.removeMarker=function(e){var t=this.$frontMarkers[e]||this.$backMarkers[e];if(t){var n=t.inFront?this.$frontMarkers:this.$backMarkers;t&&(delete n[e],this._signal(t.inFront?"changeFrontMarker":"changeBackMarker"))}},this.getMarkers=function(e){return e?this.$frontMarkers:this.$backMarkers},this.highlight=function(e){if(!this.$searchHighlight){var t=new f(null,"ace_selected-word","text");this.$searchHighlight=this.addDynamicMarker(t)}this.$searchHighlight.setRegexp(e)},this.highlightLines=function(e,t,n,r){"number"!=typeof t&&(n=t,t=e),n||(n="ace_step");var i=new u(e,0,t,1/0);return i.id=this.addMarker(i,n,"fullLine",r),i},this.setAnnotations=function(e){this.$annotations=e,this._signal("changeAnnotation",{})},this.getAnnotations=function(){return this.$annotations||[]},this.clearAnnotations=function(){this.setAnnotations([])},this.$detectNewLine=function(e){var t=e.match(/^.*?(\r?\n)/m);this.$autoNewLine=t?t[1]:"\n"},this.getWordRange=function(e,t){var n=this.getLine(e),r=!1;if(t>0&&(r=!!n.charAt(t-1).match(this.tokenRe)),r||(r=!!n.charAt(t).match(this.tokenRe)),r)var i=this.tokenRe;else if(/^\s+$/.test(n.slice(t-1,t+1)))i=/\s/;else i=this.nonTokenRe;var o=t;if(o>0){do{o--}while(o>=0&&n.charAt(o).match(i));o++}for(var a=t;a<n.length&&n.charAt(a).match(i);)a++;return new u(e,o,e,a)},this.getAWordRange=function(e,t){for(var n=this.getWordRange(e,t),r=this.getLine(n.end.row);r.charAt(n.end.column).match(/[ \t]/);)n.end.column+=1;return n},this.setNewLineMode=function(e){this.doc.setNewLineMode(e)},this.getNewLineMode=function(){return this.doc.getNewLineMode()},this.setUseWorker=function(e){this.setOption("useWorker",e)},this.getUseWorker=function(){return this.$useWorker},this.onReloadTokenizer=function(e){var t=e.data;this.bgTokenizer.start(t.first),this._signal("tokenizerUpdate",e)},this.$modes={},this.$mode=null,this.$modeId=null,this.setMode=function(e,t){if(e&&"object"==typeof e){if(e.getTokenizer)return this.$onChangeMode(e);var n=e,r=n.path}else r=e||"ace/mode/text";if(this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new l),this.$modes[r]&&!n)return this.$onChangeMode(this.$modes[r]),void(t&&t());this.$modeId=r,a.loadModule(["mode",r],function(e){if(this.$modeId!==r)return t&&t();this.$modes[r]&&!n?this.$onChangeMode(this.$modes[r]):e&&e.Mode&&(e=new e.Mode(n),n||(this.$modes[r]=e,e.$id=r),this.$onChangeMode(e)),t&&t()}.bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0)},this.$onChangeMode=function(e,t){if(t||(this.$modeId=e.$id),this.$mode!==e){this.$mode=e,this.$stopWorker(),this.$useWorker&&this.$startWorker();var n=e.getTokenizer();if(void 0!==n.addEventListener){var r=this.onReloadTokenizer.bind(this);n.addEventListener("update",r)}if(this.bgTokenizer)this.bgTokenizer.setTokenizer(n);else{this.bgTokenizer=new d(n);var i=this;this.bgTokenizer.addEventListener("update",(function(e){i._signal("tokenizerUpdate",e)}))}this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=e.tokenRe,this.nonTokenRe=e.nonTokenRe,t||(e.attachToSession&&e.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(e.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode"))}},this.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},this.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(e){a.warn("Could not load worker",e),this.$worker=null}},this.getMode=function(){return this.$mode},this.$scrollTop=0,this.setScrollTop=function(e){this.$scrollTop===e||isNaN(e)||(this.$scrollTop=e,this._signal("changeScrollTop",e))},this.getScrollTop=function(){return this.$scrollTop},this.$scrollLeft=0,this.setScrollLeft=function(e){this.$scrollLeft===e||isNaN(e)||(this.$scrollLeft=e,this._signal("changeScrollLeft",e))},this.getScrollLeft=function(){return this.$scrollLeft},this.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},this.getLineWidgetMaxWidth=function(){if(null!=this.lineWidgetsWidth)return this.lineWidgetsWidth;var e=0;return this.lineWidgets.forEach((function(t){t&&t.screenWidth>e&&(e=t.screenWidth)})),this.lineWidgetWidth=e},this.$computeWidth=function(e){if(this.$modified||e){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var t=this.doc.getAllLines(),n=this.$rowLengthCache,r=0,i=0,o=this.$foldData[i],a=o?o.start.row:1/0,s=t.length,c=0;c<s;c++){if(c>a){if((c=o.end.row+1)>=s)break;a=(o=this.$foldData[i++])?o.start.row:1/0}null==n[c]&&(n[c]=this.$getStringScreenWidth(t[c])[0]),n[c]>r&&(r=n[c])}this.screenWidth=r}},this.getLine=function(e){return this.doc.getLine(e)},this.getLines=function(e,t){return this.doc.getLines(e,t)},this.getLength=function(){return this.doc.getLength()},this.getTextRange=function(e){return this.doc.getTextRange(e||this.selection.getRange())},this.insert=function(e,t){return this.doc.insert(e,t)},this.remove=function(e){return this.doc.remove(e)},this.removeFullLines=function(e,t){return this.doc.removeFullLines(e,t)},this.undoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var n=null,r=e.length-1;-1!=r;r--){var i=e[r];"doc"==i.group?(this.doc.revertDeltas(i.deltas),n=this.$getUndoSelection(i.deltas,!0,n)):i.deltas.forEach((function(e){this.addFolds(e.folds)}),this)}return this.$fromUndo=!1,n&&this.$undoSelect&&!t&&this.selection.setSelectionRange(n),n}},this.redoChanges=function(e,t){if(e.length){this.$fromUndo=!0;for(var n=null,r=0;r<e.length;r++){var i=e[r];"doc"==i.group&&(this.doc.applyDeltas(i.deltas),n=this.$getUndoSelection(i.deltas,!1,n))}return this.$fromUndo=!1,n&&this.$undoSelect&&!t&&this.selection.setSelectionRange(n),n}},this.setUndoSelect=function(e){this.$undoSelect=e},this.$getUndoSelection=function(e,t,n){function r(e){return t?"insert"!==e.action:"insert"===e.action}var i,o,a=e[0];r(a)?i=u.fromPoints(a.start,a.end):i=u.fromPoints(a.start,a.start);for(var s=1;s<e.length;s++)r(a=e[s])?(o=a.start,-1==i.compare(o.row,o.column)&&i.setStart(o),o=a.end,1==i.compare(o.row,o.column)&&i.setEnd(o),!0):(o=a.start,-1==i.compare(o.row,o.column)&&(i=u.fromPoints(a.start,a.start)),!1);if(null!=n){0===u.comparePoints(n.start,i.start)&&(n.start.column+=i.end.column-i.start.column,n.end.column+=i.end.column-i.start.column);var c=n.compareRange(i);1==c?i.setStart(n.start):-1==c&&i.setEnd(n.end)}return i},this.replace=function(e,t){return this.doc.replace(e,t)},this.moveText=function(e,t,n){var r=this.getTextRange(e),i=this.getFoldsInRange(e),o=u.fromPoints(t,t);if(!n){this.remove(e);var a=e.start.row-e.end.row;(l=a?-e.end.column:e.start.column-e.end.column)&&(o.start.row==e.end.row&&o.start.column>e.end.column&&(o.start.column+=l),o.end.row==e.end.row&&o.end.column>e.end.column&&(o.end.column+=l)),a&&o.start.row>=e.end.row&&(o.start.row+=a,o.end.row+=a)}if(o.end=this.insert(o.start,r),i.length){var s=e.start,c=o.start,l=(a=c.row-s.row,c.column-s.column);this.addFolds(i.map((function(e){return(e=e.clone()).start.row==s.row&&(e.start.column+=l),e.end.row==s.row&&(e.end.column+=l),e.start.row+=a,e.end.row+=a,e})))}return o},this.indentRows=function(e,t,n){n=n.replace(/\t/g,this.getTabString());for(var r=e;r<=t;r++)this.doc.insertInLine({row:r,column:0},n)},this.outdentRows=function(e){for(var t=e.collapseRows(),n=new u(0,0,0,0),r=this.getTabSize(),i=t.start.row;i<=t.end.row;++i){var o=this.getLine(i);n.start.row=i,n.end.row=i;for(var a=0;a<r&&" "==o.charAt(a);++a);a<r&&"\t"==o.charAt(a)?(n.start.column=a,n.end.column=a+1):(n.start.column=0,n.end.column=a),this.remove(n)}},this.$moveLines=function(e,t,n){if(e=this.getRowFoldStart(e),t=this.getRowFoldEnd(t),n<0){if((i=this.getRowFoldStart(e+n))<0)return 0;var r=i-e}else if(n>0){var i;if((i=this.getRowFoldEnd(t+n))>this.doc.getLength()-1)return 0;r=i-t}else{e=this.$clipRowToDocument(e);r=(t=this.$clipRowToDocument(t))-e+1}var o=new u(e,0,t,Number.MAX_VALUE),a=this.getFoldsInRange(o).map((function(e){return(e=e.clone()).start.row+=r,e.end.row+=r,e})),s=0==n?this.doc.getLines(e,t):this.doc.removeFullLines(e,t);return this.doc.insertFullLines(e+r,s),a.length&&this.addFolds(a),r},this.moveLinesUp=function(e,t){return this.$moveLines(e,t,-1)},this.moveLinesDown=function(e,t){return this.$moveLines(e,t,1)},this.duplicateLines=function(e,t){return this.$moveLines(e,t,0)},this.$clipRowToDocument=function(e){return Math.max(0,Math.min(e,this.doc.getLength()-1))},this.$clipColumnToRow=function(e,t){return t<0?0:Math.min(this.doc.getLine(e).length,t)},this.$clipPositionToDocument=function(e,t){if(t=Math.max(0,t),e<0)e=0,t=0;else{var n=this.doc.getLength();e>=n?(e=n-1,t=this.doc.getLine(n-1).length):t=Math.min(this.doc.getLine(e).length,t)}return{row:e,column:t}},this.$clipRangeToDocument=function(e){e.start.row<0?(e.start.row=0,e.start.column=0):e.start.column=this.$clipColumnToRow(e.start.row,e.start.column);var t=this.doc.getLength()-1;return e.end.row>t?(e.end.row=t,e.end.column=this.doc.getLine(t).length):e.end.column=this.$clipColumnToRow(e.end.row,e.end.column),e},this.$wrapLimit=80,this.$useWrapMode=!1,this.$wrapLimitRange={min:null,max:null},this.setUseWrapMode=function(e){if(e!=this.$useWrapMode){if(this.$useWrapMode=e,this.$modified=!0,this.$resetRowCache(0),e){var t=this.getLength();this.$wrapData=Array(t),this.$updateWrapData(0,t-1)}this._signal("changeWrapMode")}},this.getUseWrapMode=function(){return this.$useWrapMode},this.setWrapLimitRange=function(e,t){this.$wrapLimitRange.min===e&&this.$wrapLimitRange.max===t||(this.$wrapLimitRange={min:e,max:t},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},this.adjustWrapLimit=function(e,t){var n=this.$wrapLimitRange;n.max<0&&(n={min:t,max:t});var r=this.$constrainWrapLimit(e,n.min,n.max);return r!=this.$wrapLimit&&r>1&&(this.$wrapLimit=r,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},this.$constrainWrapLimit=function(e,t,n){return t&&(e=Math.max(t,e)),n&&(e=Math.min(n,e)),e},this.getWrapLimit=function(){return this.$wrapLimit},this.setWrapLimit=function(e){this.setWrapLimitRange(e,e)},this.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},this.$updateInternalDataOnChange=function(e){var t=this.$useWrapMode,n=e.action,r=e.start,i=e.end,o=r.row,a=i.row,s=a-o,c=null;if(this.$updating=!0,0!=s)if("remove"===n){this[t?"$wrapData":"$rowLengthCache"].splice(o,s);var l=this.$foldData;c=this.getFoldsInRange(e),this.removeFolds(c);var u=0;if(m=this.getFoldLine(i.row)){m.addRemoveChars(i.row,i.column,r.column-i.column),m.shiftRow(-s);var h=this.getFoldLine(o);h&&h!==m&&(h.merge(m),m=h),u=l.indexOf(m)+1}for(;u<l.length;u++){(m=l[u]).start.row>=i.row&&m.shiftRow(-s)}a=o}else{var d=Array(s);d.unshift(o,0);var f=t?this.$wrapData:this.$rowLengthCache;f.splice.apply(f,d);l=this.$foldData,u=0;if(m=this.getFoldLine(o)){var p=m.range.compareInside(r.row,r.column);0==p?(m=m.split(r.row,r.column))&&(m.shiftRow(s),m.addRemoveChars(a,0,i.column-r.column)):-1==p&&(m.addRemoveChars(o,0,i.column-r.column),m.shiftRow(s)),u=l.indexOf(m)+1}for(;u<l.length;u++){var m;(m=l[u]).start.row>=o&&m.shiftRow(s)}}else s=Math.abs(e.start.column-e.end.column),"remove"===n&&(c=this.getFoldsInRange(e),this.removeFolds(c),s=-s),(m=this.getFoldLine(o))&&m.addRemoveChars(o,r.column,s);return t&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,t?this.$updateWrapData(o,a):this.$updateRowLengthCache(o,a),c},this.$updateRowLengthCache=function(e,t,n){this.$rowLengthCache[e]=null,this.$rowLengthCache[t]=null},this.$updateWrapData=function(n,r){var i,o,a=this.doc.getAllLines(),s=this.getTabSize(),c=this.$wrapData,l=this.$wrapLimit,u=n;for(r=Math.min(r,a.length-1);u<=r;)(o=this.getFoldLine(u,o))?(i=[],o.walk(function(n,r,o,s){var c;if(null!=n){(c=this.$getDisplayTokens(n,i.length))[0]=e;for(var l=1;l<c.length;l++)c[l]=t}else c=this.$getDisplayTokens(a[r].substring(s,o),i.length);i=i.concat(c)}.bind(this),o.end.row,a[o.end.row].length+1),c[o.start.row]=this.$computeWrapSplits(i,l,s),u=o.end.row+1):(i=this.$getDisplayTokens(a[u]),c[u]=this.$computeWrapSplits(i,l,s),u++)};var e=3,t=4;function n(e){return!(e<4352)&&(e>=4352&&e<=4447||e>=4515&&e<=4519||e>=4602&&e<=4607||e>=9001&&e<=9002||e>=11904&&e<=11929||e>=11931&&e<=12019||e>=12032&&e<=12245||e>=12272&&e<=12283||e>=12288&&e<=12350||e>=12353&&e<=12438||e>=12441&&e<=12543||e>=12549&&e<=12589||e>=12593&&e<=12686||e>=12688&&e<=12730||e>=12736&&e<=12771||e>=12784&&e<=12830||e>=12832&&e<=12871||e>=12880&&e<=13054||e>=13056&&e<=19903||e>=19968&&e<=42124||e>=42128&&e<=42182||e>=43360&&e<=43388||e>=44032&&e<=55203||e>=55216&&e<=55238||e>=55243&&e<=55291||e>=63744&&e<=64255||e>=65040&&e<=65049||e>=65072&&e<=65106||e>=65108&&e<=65126||e>=65128&&e<=65131||e>=65281&&e<=65376||e>=65504&&e<=65510)}this.$computeWrapSplits=function(n,r,i){if(0==n.length)return[];var o=[],a=n.length,s=0,c=0,l=this.$wrapAsCode,u=this.$indentedSoftWrap,h=r<=Math.max(2*i,8)||!1===u?0:Math.floor(r/2);function d(e){var t=n.slice(s,e),r=t.length;t.join("").replace(/12/g,(function(){r-=1})).replace(/2/g,(function(){r-=1})),o.length||(f=function(){var e=0;if(0===h)return e;if(u)for(var t=0;t<n.length;t++){var r=n[t];if(10==r)e+=1;else{if(11!=r){if(12==r)continue;break}e+=i}}return l&&!1!==u&&(e+=i),Math.min(e,h)}(),o.indent=f),c+=r,o.push(c),s=e}for(var f=0;a-s>r-f;){var p=s+r-f;if(n[p-1]>=10&&n[p]>=10)d(p);else if(n[p]!=e&&n[p]!=t){for(var m=Math.max(p-(r-(r>>2)),s-1);p>m&&n[p]<e;)p--;if(l){for(;p>m&&n[p]<e;)p--;for(;p>m&&9==n[p];)p--}else for(;p>m&&n[p]<10;)p--;p>m?d(++p):(2==n[p=s+r]&&p--,d(p-f))}else{for(;p!=s-1&&n[p]!=e;p--);if(p>s){d(p);continue}for(p=s+r;p<n.length&&n[p]==t;p++);if(p==n.length)break;d(p)}}return o},this.$getDisplayTokens=function(e,t){var r,i=[];t=t||0;for(var o=0;o<e.length;o++){var a=e.charCodeAt(o);if(9==a){r=this.getScreenTabSize(i.length+t),i.push(11);for(var s=1;s<r;s++)i.push(12)}else 32==a?i.push(10):a>39&&a<48||a>57&&a<64?i.push(9):a>=4352&&n(a)?i.push(1,2):i.push(1)}return i},this.$getStringScreenWidth=function(e,t,r){if(0==t)return[0,0];var i,o;for(null==t&&(t=1/0),r=r||0,o=0;o<e.length&&(9==(i=e.charCodeAt(o))?r+=this.getScreenTabSize(r):i>=4352&&n(i)?r+=2:r+=1,!(r>t));o++);return[r,o]},this.lineWidgets=null,this.getRowLength=function(e){if(this.lineWidgets)var t=this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0;else t=0;return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.getRowLineCount=function(e){return this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1:1},this.getRowWrapIndent=function(e){if(this.$useWrapMode){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE),n=this.$wrapData[t.row];return n.length&&n[0]<t.column?n.indent:0}return 0},this.getScreenLastRowColumn=function(e){var t=this.screenToDocumentPosition(e,Number.MAX_VALUE);return this.documentToScreenColumn(t.row,t.column)},this.getDocumentLastRowColumn=function(e,t){var n=this.documentToScreenRow(e,t);return this.getScreenLastRowColumn(n)},this.getDocumentLastRowColumnPosition=function(e,t){var n=this.documentToScreenRow(e,t);return this.screenToDocumentPosition(n,Number.MAX_VALUE/10)},this.getRowSplitData=function(e){return this.$useWrapMode?this.$wrapData[e]:void 0},this.getScreenTabSize=function(e){return this.$tabSize-e%this.$tabSize},this.screenToDocumentRow=function(e,t){return this.screenToDocumentPosition(e,t).row},this.screenToDocumentColumn=function(e,t){return this.screenToDocumentPosition(e,t).column},this.screenToDocumentPosition=function(e,t,n){if(e<0)return{row:0,column:0};var r,i,o=0,a=0,s=0,c=0,l=this.$screenRowCache,u=this.$getRowCacheIndex(l,e),h=l.length;if(h&&u>=0){s=l[u],o=this.$docRowCache[u];var d=e>l[h-1]}else d=!h;for(var f=this.getLength()-1,p=this.getNextFoldLine(o),m=p?p.start.row:1/0;s<=e&&!(s+(c=this.getRowLength(o))>e||o>=f);)s+=c,++o>m&&(o=p.end.row+1,m=(p=this.getNextFoldLine(o,p))?p.start.row:1/0),d&&(this.$docRowCache.push(o),this.$screenRowCache.push(s));if(p&&p.start.row<=o)r=this.getFoldDisplayLine(p),o=p.start.row;else{if(s+c<=e||o>f)return{row:f,column:this.getLine(f).length};r=this.getLine(o),p=null}var g=0,v=Math.floor(e-s);if(this.$useWrapMode){var y=this.$wrapData[o];y&&(i=y[v],v>0&&y.length&&(g=y.indent,a=y[v-1]||y[y.length-1],r=r.substring(a)))}return void 0!==n&&this.$bidiHandler.isBidiRow(s+v,o,v)&&(t=this.$bidiHandler.offsetToCol(n)),a+=this.$getStringScreenWidth(r,t-g)[1],this.$useWrapMode&&a>=i&&(a=i-1),p?p.idxToPosition(a):{row:o,column:a}},this.documentToScreenPosition=function(e,t){if(void 0===t)var n=this.$clipPositionToDocument(e.row,e.column);else n=this.$clipPositionToDocument(e,t);e=n.row,t=n.column;var r,i=0,o=null;(r=this.getFoldAt(e,t,1))&&(e=r.start.row,t=r.start.column);var a,s=0,c=this.$docRowCache,l=this.$getRowCacheIndex(c,e),u=c.length;if(u&&l>=0){s=c[l],i=this.$screenRowCache[l];var h=e>c[u-1]}else h=!u;for(var d=this.getNextFoldLine(s),f=d?d.start.row:1/0;s<e;){if(s>=f){if((a=d.end.row+1)>e)break;f=(d=this.getNextFoldLine(a,d))?d.start.row:1/0}else a=s+1;i+=this.getRowLength(s),s=a,h&&(this.$docRowCache.push(s),this.$screenRowCache.push(i))}var p="";d&&s>=f?(p=this.getFoldDisplayLine(d,e,t),o=d.start.row):(p=this.getLine(e).substring(0,t),o=e);var m=0;if(this.$useWrapMode){var g=this.$wrapData[o];if(g){for(var v=0;p.length>=g[v];)i++,v++;p=p.substring(g[v-1]||0,p.length),m=v>0?g.indent:0}}return{row:i,column:m+this.$getStringScreenWidth(p)[0]}},this.documentToScreenColumn=function(e,t){return this.documentToScreenPosition(e,t).column},this.documentToScreenRow=function(e,t){return this.documentToScreenPosition(e,t).row},this.getScreenLength=function(){var e=0,t=null;if(this.$useWrapMode)for(var n=this.$wrapData.length,r=0,i=(s=0,(t=this.$foldData[s++])?t.start.row:1/0);r<n;){var o=this.$wrapData[r];e+=o?o.length+1:1,++r>i&&(r=t.end.row+1,i=(t=this.$foldData[s++])?t.start.row:1/0)}else{e=this.getLength();for(var a=this.$foldData,s=0;s<a.length;s++)e-=(t=a[s]).end.row-t.start.row}return this.lineWidgets&&(e+=this.$getWidgetScreenLength()),e},this.$setFontMetrics=function(e){this.$enableVarChar&&(this.$getStringScreenWidth=function(t,n,r){if(0===n)return[0,0];var i,o;for(n||(n=1/0),r=r||0,o=0;o<t.length&&!((r+="\t"===(i=t.charAt(o))?this.getScreenTabSize(r):e.getCharacterWidth(i))>n);o++);return[r,o]})},this.destroy=function(){this.bgTokenizer&&(this.bgTokenizer.setDocument(null),this.bgTokenizer=null),this.$stopWorker()},this.isFullWidth=n}.call(p.prototype),e("./edit_session/folding").Folding.call(p.prototype),e("./edit_session/bracket_match").BracketMatch.call(p.prototype),a.defineOptions(p.prototype,"session",{wrap:{set:function(e){if(e&&"off"!=e?"free"==e?e=!0:"printMargin"==e?e=-1:"string"==typeof e&&(e=parseInt(e,10)||!1):e=!1,this.$wrap!=e)if(this.$wrap=e,e){var t="number"==typeof e?e:null;this.setWrapLimitRange(t,t),this.setUseWrapMode(!0)}else this.setUseWrapMode(!1)},get:function(){return this.getUseWrapMode()?-1==this.$wrap?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(e){(e="auto"==e?"text"!=this.$mode.type:"text"!=e)!=this.$wrapAsCode&&(this.$wrapAsCode=e,this.$useWrapMode&&(this.$modified=!0,this.$resetRowCache(0),this.$updateWrapData(0,this.getLength()-1)))},initialValue:"auto"},indentedSoftWrap:{initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(e){this.$useWorker=e,this.$stopWorker(),e&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(e){isNaN(e)||this.$tabSize===e||(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=e,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},overwrite:{set:function(e){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(e){this.doc.setNewLineMode(e)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(e){this.setMode(e)},get:function(){return this.$modeId}}}),t.EditSession=p})),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],(function(e,t,n){"use strict";var r=e("./lib/lang"),i=e("./lib/oop"),o=e("./range").Range,a=function(){this.$options={}};(function(){this.set=function(e){return i.mixin(this.$options,e),this},this.getOptions=function(){return r.copyObject(this.$options)},this.setOptions=function(e){this.$options=e},this.find=function(e){var t=this.$options,n=this.$matchIterator(e,t);if(!n)return!1;var r=null;return n.forEach((function(e,n,i,a){return r=new o(e,n,i,a),!(n==a&&t.start&&t.start.start&&0!=t.skipCurrent&&r.isEqual(t.start))||(r=null,!1)})),r},this.findAll=function(e){var t=this.$options;if(!t.needle)return[];this.$assembleRegExp(t);var n=t.range,i=n?e.getLines(n.start.row,n.end.row):e.doc.getAllLines(),a=[],s=t.re;if(t.$isMultiLine){var c,l=s.length,u=i.length-l;e:for(var h=s.offset||0;h<=u;h++){for(var d=0;d<l;d++)if(-1==i[h+d].search(s[d]))continue e;var f=i[h],p=i[h+l-1],m=f.length-f.match(s[0])[0].length,g=p.match(s[l-1])[0].length;c&&c.end.row===h&&c.end.column>m||(a.push(c=new o(h,m,h+l-1,g)),l>2&&(h=h+l-2))}}else for(var v=0;v<i.length;v++){var y=r.getMatchOffsets(i[v],s);for(d=0;d<y.length;d++){var b=y[d];a.push(new o(v,b.offset,v,b.offset+b.length))}}if(n){var w=n.start.column,x=n.start.column;for(v=0,d=a.length-1;v<d&&a[v].start.column<w&&a[v].start.row==n.start.row;)v++;for(;v<d&&a[d].end.column>x&&a[d].end.row==n.end.row;)d--;for(a=a.slice(v,d+1),v=0,d=a.length;v<d;v++)a[v].start.row+=n.start.row,a[v].end.row+=n.start.row}return a},this.replace=function(e,t){var n=this.$options,r=this.$assembleRegExp(n);if(n.$isMultiLine)return t;if(r){var i=r.exec(e);if(!i||i[0].length!=e.length)return null;if(t=e.replace(r,t),n.preserveCase){t=t.split("");for(var o=Math.min(e.length,e.length);o--;){var a=e[o];a&&a.toLowerCase()!=a?t[o]=t[o].toUpperCase():t[o]=t[o].toLowerCase()}t=t.join("")}return t}},this.$assembleRegExp=function(e,t){if(e.needle instanceof RegExp)return e.re=e.needle;var n=e.needle;if(!e.needle)return e.re=!1;e.regExp||(n=r.escapeRegExp(n)),e.wholeWord&&(n=function(e,t){function n(e){return/\w/.test(e)||t.regExp?"\\b":""}return n(e[0])+e+n(e[e.length-1])}(n,e));var i=e.caseSensitive?"gm":"gmi";if(e.$isMultiLine=!t&&/[\n\r]/.test(n),e.$isMultiLine)return e.re=this.$assembleMultilineRegExp(n,i);try{var o=new RegExp(n,i)}catch(e){o=!1}return e.re=o},this.$assembleMultilineRegExp=function(e,t){for(var n=e.replace(/\r\n|\r|\n/g,"$\n^").split("\n"),r=[],i=0;i<n.length;i++)try{r.push(new RegExp(n[i],t))}catch(e){return!1}return r},this.$matchIterator=function(e,t){var n=this.$assembleRegExp(t);if(!n)return!1;var r=1==t.backwards,i=0!=t.skipCurrent,o=t.range,a=t.start;a||(a=o?o[r?"end":"start"]:e.selection.getRange()),a.start&&(a=a[i!=r?"end":"start"]);var s=o?o.start.row:0,c=o?o.end.row:e.getLength()-1;if(r)var l=function(e){var n=a.row;if(!h(n,a.column,e)){for(n--;n>=s;n--)if(h(n,Number.MAX_VALUE,e))return;if(0!=t.wrap)for(n=c,s=a.row;n>=s;n--)if(h(n,Number.MAX_VALUE,e))return}};else l=function(e){var n=a.row;if(!h(n,a.column,e)){for(n+=1;n<=c;n++)if(h(n,0,e))return;if(0!=t.wrap)for(n=s,c=a.row;n<=c;n++)if(h(n,0,e))return}};if(t.$isMultiLine)var u=n.length,h=function(t,i,o){var a=r?t-u+1:t;if(!(a<0)){var s=e.getLine(a),c=s.search(n[0]);if(!(!r&&c<i||-1===c)){for(var l=1;l<u;l++)if(-1==(s=e.getLine(a+l)).search(n[l]))return;var h=s.match(n[u-1])[0].length;if(!(r&&h>i))return!!o(a,c,a+u-1,h)||void 0}}};else if(r)h=function(t,r,i){var o,a=e.getLine(t),s=[],c=0;for(n.lastIndex=0;o=n.exec(a);){var l=o[0].length;if(c=o.index,!l){if(c>=a.length)break;n.lastIndex=c+=1}if(o.index+l>r)break;s.push(o.index,l)}for(var u=s.length-1;u>=0;u-=2){var h=s[u-1];if(i(t,h,t,h+(l=s[u])))return!0}};else h=function(t,r,i){var o,a=e.getLine(t),s=r;for(n.lastIndex=r;o=n.exec(a);){var c=o[0].length;if(i(t,s=o.index,t,s+c))return!0;if(!c&&(n.lastIndex=s+=1,s>=a.length))return!1}};return{forEach:l}}}).call(a.prototype),t.Search=a})),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],(function(e,t,n){"use strict";var r=e("../lib/keys"),i=e("../lib/useragent"),o=r.KEY_MODS;function a(e,t){this.platform=t||(i.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(e),this.$singleCommand=!0}function s(e,t){a.call(this,e,t),this.$singleCommand=!1}s.prototype=a.prototype,function(){function e(e){return"object"==typeof e&&e.bindKey&&e.bindKey.position||(e.isDefault?-100:0)}this.addCommand=function(e){this.commands[e.name]&&this.removeCommand(e),this.commands[e.name]=e,e.bindKey&&this._buildKeyHash(e)},this.removeCommand=function(e,t){var n=e&&("string"==typeof e?e:e.name);e=this.commands[n],t||delete this.commands[n];var r=this.commandKeyBinding;for(var i in r){var o=r[i];if(o==e)delete r[i];else if(Array.isArray(o)){var a=o.indexOf(e);-1!=a&&(o.splice(a,1),1==o.length&&(r[i]=o[0]))}}},this.bindKey=function(e,t,n){if("object"==typeof e&&e&&(null==n&&(n=e.position),e=e[this.platform]),e)return"function"==typeof t?this.addCommand({exec:t,bindKey:e,name:t.name||e}):void e.split("|").forEach((function(e){var r="";if(-1!=e.indexOf(" ")){var i=e.split(/\s+/);e=i.pop(),i.forEach((function(e){var t=this.parseKeys(e),n=o[t.hashId]+t.key;r+=(r?" ":"")+n,this._addCommandToBinding(r,"chainKeys")}),this),r+=" "}var a=this.parseKeys(e),s=o[a.hashId]+a.key;this._addCommandToBinding(r+s,t,n)}),this)},this._addCommandToBinding=function(t,n,r){var i,o=this.commandKeyBinding;if(n)if(!o[t]||this.$singleCommand)o[t]=n;else{Array.isArray(o[t])?-1!=(i=o[t].indexOf(n))&&o[t].splice(i,1):o[t]=[o[t]],"number"!=typeof r&&(r=e(n));var a=o[t];for(i=0;i<a.length;i++){if(e(a[i])>r)break}a.splice(i,0,n)}else delete o[t]},this.addCommands=function(e){e&&Object.keys(e).forEach((function(t){var n=e[t];if(n){if("string"==typeof n)return this.bindKey(n,t);"function"==typeof n&&(n={exec:n}),"object"==typeof n&&(n.name||(n.name=t),this.addCommand(n))}}),this)},this.removeCommands=function(e){Object.keys(e).forEach((function(t){this.removeCommand(e[t])}),this)},this.bindKeys=function(e){Object.keys(e).forEach((function(t){this.bindKey(t,e[t])}),this)},this._buildKeyHash=function(e){this.bindKey(e.bindKey,e)},this.parseKeys=function(e){var t=e.toLowerCase().split(/[\-\+]([\-\+])?/).filter((function(e){return e})),n=t.pop(),i=r[n];if(r.FUNCTION_KEYS[i])n=r.FUNCTION_KEYS[i].toLowerCase();else{if(!t.length)return{key:n,hashId:-1};if(1==t.length&&"shift"==t[0])return{key:n.toUpperCase(),hashId:-1}}for(var o=0,a=t.length;a--;){var s=r.KEY_MODS[t[a]];if(null==s)return"undefined"!=typeof console&&console.error("invalid modifier "+t[a]+" in "+e),!1;o|=s}return{key:n,hashId:o}},this.findKeyCommand=function(e,t){var n=o[e]+t;return this.commandKeyBinding[n]},this.handleKeyboard=function(e,t,n,r){if(!(r<0)){var i=o[t]+n,a=this.commandKeyBinding[i];return e.$keyChain&&(e.$keyChain+=" "+i,a=this.commandKeyBinding[e.$keyChain]||a),!a||"chainKeys"!=a&&"chainKeys"!=a[a.length-1]?(e.$keyChain&&(t&&4!=t||1!=n.length?(-1==t||r>0)&&(e.$keyChain=""):e.$keyChain=e.$keyChain.slice(0,-i.length-1)),{command:a}):(e.$keyChain=e.$keyChain||i,{command:"null"})}},this.getStatusText=function(e,t){return t.$keyChain||""}}.call(a.prototype),t.HashHandler=a,t.MultiHashHandler=s})),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("../lib/oop"),i=e("../keyboard/hash_handler").MultiHashHandler,o=e("../lib/event_emitter").EventEmitter,a=function(e,t){i.call(this,t,e),this.byName=this.commands,this.setDefaultHandler("exec",(function(e){return e.command.exec(e.editor,e.args||{})}))};r.inherits(a,i),function(){r.implement(this,o),this.exec=function(e,t,n){if(Array.isArray(e)){for(var r=e.length;r--;)if(this.exec(e[r],t,n))return!0;return!1}if("string"==typeof e&&(e=this.commands[e]),!e)return!1;if(t&&t.$readOnly&&!e.readOnly)return!1;if(e.isAvailable&&!e.isAvailable(t))return!1;var i={editor:t,command:e,args:n};return i.returnValue=this._emit("exec",i),this._signal("afterExec",i),!1!==i.returnValue},this.toggleRecording=function(e){if(!this.$inReplay)return e&&e._emit("changeStatus"),this.recording?(this.macro.pop(),this.removeEventListener("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=function(e){this.macro.push([e.command,e.args])}.bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},this.replay=function(e){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(e);try{this.$inReplay=!0,this.macro.forEach((function(t){"string"==typeof t?this.exec(t,e):this.exec(t[0],e,t[1])}),this)}finally{this.$inReplay=!1}}},this.trimMacro=function(e){return e.map((function(e){return"string"!=typeof e[0]&&(e[0]=e[0].name),e[1]||(e=e[0]),e}))}}.call(a.prototype),t.CommandManager=a})),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],(function(e,t,n){"use strict";var r=e("../lib/lang"),i=e("../config"),o=e("../range").Range;function a(e,t){return{win:e,mac:t}}t.commands=[{name:"showSettingsMenu",bindKey:a("Ctrl-,","Command-,"),exec:function(e){i.loadModule("ace/ext/settings_menu",(function(t){t.init(e),e.showSettingsMenu()}))},readOnly:!0},{name:"goToNextError",bindKey:a("Alt-E","F4"),exec:function(e){i.loadModule("ace/ext/error_marker",(function(t){t.showErrorMarker(e,1)}))},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",bindKey:a("Alt-Shift-E","Shift-F4"),exec:function(e){i.loadModule("ace/ext/error_marker",(function(t){t.showErrorMarker(e,-1)}))},scrollIntoView:"animate",readOnly:!0},{name:"selectall",bindKey:a("Ctrl-A","Command-A"),exec:function(e){e.selectAll()},readOnly:!0},{name:"centerselection",bindKey:a(null,"Ctrl-L"),exec:function(e){e.centerSelection()},readOnly:!0},{name:"gotoline",bindKey:a("Ctrl-L","Command-L"),exec:function(e){var t=parseInt(prompt("Enter line number:"),10);isNaN(t)||e.gotoLine(t)},readOnly:!0},{name:"fold",bindKey:a("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(e){e.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:a("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(e){e.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",bindKey:a("F2","F2"),exec:function(e){e.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",bindKey:a("Alt-F2","Alt-F2"),exec:function(e){e.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",bindKey:a(null,"Ctrl-Command-Option-0"),exec:function(e){e.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",bindKey:a("Alt-0","Command-Option-0"),exec:function(e){e.session.foldAll(),e.session.unfold(e.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",bindKey:a("Alt-Shift-0","Command-Option-Shift-0"),exec:function(e){e.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",bindKey:a("Ctrl-K","Command-G"),exec:function(e){e.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",bindKey:a("Ctrl-Shift-K","Command-Shift-G"),exec:function(e){e.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",bindKey:a("Alt-K","Ctrl-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findNext()},readOnly:!0},{name:"selectOrFindPrevious",bindKey:a("Alt-Shift-K","Ctrl-Shift-G"),exec:function(e){e.selection.isEmpty()?e.selection.selectWord():e.findPrevious()},readOnly:!0},{name:"find",bindKey:a("Ctrl-F","Command-F"),exec:function(e){i.loadModule("ace/ext/searchbox",(function(t){t.Search(e)}))},readOnly:!0},{name:"overwrite",bindKey:"Insert",exec:function(e){e.toggleOverwrite()},readOnly:!0},{name:"selecttostart",bindKey:a("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(e){e.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",bindKey:a("Ctrl-Home","Command-Home|Command-Up"),exec:function(e){e.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",bindKey:a("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(e){e.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",bindKey:a("Up","Up|Ctrl-P"),exec:function(e,t){e.navigateUp(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",bindKey:a("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(e){e.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",bindKey:a("Ctrl-End","Command-End|Command-Down"),exec:function(e){e.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",bindKey:a("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(e){e.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",bindKey:a("Down","Down|Ctrl-N"),exec:function(e,t){e.navigateDown(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",bindKey:a("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(e){e.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",bindKey:a("Ctrl-Left","Option-Left"),exec:function(e){e.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",bindKey:a("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",bindKey:a("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(e){e.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",bindKey:a("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(e){e.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",bindKey:a("Left","Left|Ctrl-B"),exec:function(e,t){e.navigateLeft(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",bindKey:a("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(e){e.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",bindKey:a("Ctrl-Right","Option-Right"),exec:function(e){e.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",bindKey:a("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",bindKey:a("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(e){e.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",bindKey:a("Shift-Right","Shift-Right"),exec:function(e){e.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",bindKey:a("Right","Right|Ctrl-F"),exec:function(e,t){e.navigateRight(t.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",bindKey:"Shift-PageDown",exec:function(e){e.selectPageDown()},readOnly:!0},{name:"pagedown",bindKey:a(null,"Option-PageDown"),exec:function(e){e.scrollPageDown()},readOnly:!0},{name:"gotopagedown",bindKey:a("PageDown","PageDown|Ctrl-V"),exec:function(e){e.gotoPageDown()},readOnly:!0},{name:"selectpageup",bindKey:"Shift-PageUp",exec:function(e){e.selectPageUp()},readOnly:!0},{name:"pageup",bindKey:a(null,"Option-PageUp"),exec:function(e){e.scrollPageUp()},readOnly:!0},{name:"gotopageup",bindKey:"PageUp",exec:function(e){e.gotoPageUp()},readOnly:!0},{name:"scrollup",bindKey:a("Ctrl-Up",null),exec:function(e){e.renderer.scrollBy(0,-2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",bindKey:a("Ctrl-Down",null),exec:function(e){e.renderer.scrollBy(0,2*e.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",bindKey:"Shift-Home",exec:function(e){e.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",bindKey:"Shift-End",exec:function(e){e.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",bindKey:a("Ctrl-Alt-E","Command-Option-E"),exec:function(e){e.commands.toggleRecording(e)},readOnly:!0},{name:"replaymacro",bindKey:a("Ctrl-Shift-E","Command-Shift-E"),exec:function(e){e.commands.replay(e)},readOnly:!0},{name:"jumptomatching",bindKey:a("Ctrl-P","Ctrl-P"),exec:function(e){e.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",bindKey:a("Ctrl-Shift-P","Ctrl-Shift-P"),exec:function(e){e.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",bindKey:a("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(e){e.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",bindKey:a(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",exec:function(e){},readOnly:!0},{name:"cut",exec:function(e){var t=e.getSelectionRange();e._emit("cut",t),e.selection.isEmpty()||(e.session.remove(t),e.clearSelection())},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",exec:function(e,t){e.$handlePaste(t)},scrollIntoView:"cursor"},{name:"removeline",bindKey:a("Ctrl-D","Command-D"),exec:function(e){e.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",bindKey:a("Ctrl-Shift-D","Command-Shift-D"),exec:function(e){e.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",bindKey:a("Ctrl-Alt-S","Command-Alt-S"),exec:function(e){e.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",bindKey:a("Ctrl-/","Command-/"),exec:function(e){e.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",bindKey:a("Ctrl-Shift-/","Command-Shift-/"),exec:function(e){e.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",bindKey:a("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(e){e.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",bindKey:a("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(e){e.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",bindKey:a("Ctrl-H","Command-Option-F"),exec:function(e){i.loadModule("ace/ext/searchbox",(function(t){t.Search(e,!0)}))}},{name:"undo",bindKey:a("Ctrl-Z","Command-Z"),exec:function(e){e.undo()}},{name:"redo",bindKey:a("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(e){e.redo()}},{name:"copylinesup",bindKey:a("Alt-Shift-Up","Command-Option-Up"),exec:function(e){e.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",bindKey:a("Alt-Up","Option-Up"),exec:function(e){e.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",bindKey:a("Alt-Shift-Down","Command-Option-Down"),exec:function(e){e.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",bindKey:a("Alt-Down","Option-Down"),exec:function(e){e.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",bindKey:a("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(e){e.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",bindKey:a("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(e){e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",bindKey:a("Shift-Delete",null),exec:function(e){if(!e.selection.isEmpty())return!1;e.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",bindKey:a("Alt-Backspace","Command-Backspace"),exec:function(e){e.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",bindKey:a("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(e){e.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",bindKey:a("Ctrl-Shift-Backspace",null),exec:function(e){var t=e.selection.getRange();t.start.column=0,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",bindKey:a("Ctrl-Shift-Delete",null),exec:function(e){var t=e.selection.getRange();t.end.column=Number.MAX_VALUE,e.session.remove(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",bindKey:a("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(e){e.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",bindKey:a("Ctrl-Delete","Alt-Delete"),exec:function(e){e.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",bindKey:a("Shift-Tab","Shift-Tab"),exec:function(e){e.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",bindKey:a("Tab","Tab"),exec:function(e){e.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",bindKey:a("Ctrl-[","Ctrl-["),exec:function(e){e.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",bindKey:a("Ctrl-]","Ctrl-]"),exec:function(e){e.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",exec:function(e,t){e.insert(t)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",exec:function(e,t){e.insert(r.stringRepeat(t.text||"",t.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",bindKey:a(null,"Ctrl-O"),exec:function(e){e.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",bindKey:a("Alt-Shift-X","Ctrl-T"),exec:function(e){e.transposeLetters()},multiSelectAction:function(e){e.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",bindKey:a("Ctrl-U","Ctrl-U"),exec:function(e){e.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",bindKey:a("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(e){e.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"expandtoline",bindKey:a("Ctrl-Shift-L","Command-Shift-L"),exec:function(e){var t=e.selection.getRange();t.start.column=t.end.column=0,t.end.row++,e.selection.setRange(t,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"joinlines",bindKey:a(null,null),exec:function(e){for(var t=e.selection.isBackwards(),n=t?e.selection.getSelectionLead():e.selection.getSelectionAnchor(),i=t?e.selection.getSelectionAnchor():e.selection.getSelectionLead(),a=e.session.doc.getLine(n.row).length,s=e.session.doc.getTextRange(e.selection.getRange()).replace(/\n\s*/," ").length,c=e.session.doc.getLine(n.row),l=n.row+1;l<=i.row+1;l++){var u=r.stringTrimLeft(r.stringTrimRight(e.session.doc.getLine(l)));0!==u.length&&(u=" "+u),c+=u}i.row+1<e.session.doc.getLength()-1&&(c+=e.session.doc.getNewLineCharacter()),e.clearSelection(),e.session.doc.replace(new o(n.row,0,i.row+2,0),c),s>0?(e.selection.moveCursorTo(n.row,n.column),e.selection.selectTo(n.row,n.column+s)):(a=e.session.doc.getLine(n.row).length>a?a+1:a,e.selection.moveCursorTo(n.row,a))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",bindKey:a(null,null),exec:function(e){var t=e.session.doc.getLength()-1,n=e.session.doc.getLine(t).length,r=e.selection.rangeList.ranges,i=[];r.length<1&&(r=[e.selection.getRange()]);for(var a=0;a<r.length;a++)a==r.length-1&&(r[a].end.row===t&&r[a].end.column===n||i.push(new o(r[a].end.row,r[a].end.column,t,n))),0===a?0===r[a].start.row&&0===r[a].start.column||i.push(new o(0,0,r[a].start.row,r[a].start.column)):i.push(new o(r[a-1].end.row,r[a-1].end.column,r[a].start.row,r[a].start.column));e.exitMultiSelectMode(),e.clearSelection();for(a=0;a<i.length;a++)e.selection.addRange(i[a],!1)},readOnly:!0,scrollIntoView:"none"}]})),ace.define("ace/editor",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator"],(function(e,t,n){"use strict";e("./lib/fixoldbrowsers");var r=e("./lib/oop"),i=e("./lib/dom"),o=e("./lib/lang"),a=e("./lib/useragent"),s=e("./keyboard/textinput").TextInput,c=e("./mouse/mouse_handler").MouseHandler,l=e("./mouse/fold_handler").FoldHandler,u=e("./keyboard/keybinding").KeyBinding,h=e("./edit_session").EditSession,d=e("./search").Search,f=e("./range").Range,p=e("./lib/event_emitter").EventEmitter,m=e("./commands/command_manager").CommandManager,g=e("./commands/default_commands").commands,v=e("./config"),y=e("./token_iterator").TokenIterator,b=function(e,t){var n=e.getContainerElement();this.container=n,this.renderer=e,this.id="editor"+ ++b.$uid,this.commands=new m(a.isMac?"mac":"win",g),"object"==typeof document&&(this.textInput=new s(e.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new c(this),new l(this)),this.keyBinding=new u(this),this.$blockScrolling=0,this.$search=(new d).set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=o.delayedCall(function(){this._signal("input",{}),this.session&&this.session.bgTokenizer&&this.session.bgTokenizer.scheduleStart()}.bind(this)),this.on("change",(function(e,t){t._$emitInputEvent.schedule(31)})),this.setSession(t||new h("")),v.resetOptions(this),v._signal("editor",this)};b.$uid=0,function(){r.implement(this,p),this.$initOperationListeners=function(){this.selections=[],this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=o.delayedCall(this.endOperation.bind(this)),this.on("change",function(){this.curOp||this.startOperation(),this.curOp.docChanged=!0}.bind(this),!0),this.on("changeSelection",function(){this.curOp||this.startOperation(),this.curOp.selectionChanged=!0}.bind(this),!0)},this.curOp=null,this.prevOp={},this.startOperation=function(e){if(this.curOp){if(!e||this.curOp.command)return;this.prevOp=this.curOp}e||(this.previousCommand=null,e={}),this.$opResetTimer.schedule(),this.curOp={command:e.command||{},args:e.args,scrollTop:this.renderer.scrollTop},this.curOp.command.name&&void 0!==this.curOp.command.scrollIntoView&&this.$blockScrolling++},this.endOperation=function(e){if(this.curOp){if(e&&!1===e.returnValue)return this.curOp=null;this._signal("beforeEndOperation");var t=this.curOp.command;t.name&&this.$blockScrolling>0&&this.$blockScrolling--;var n=t&&t.scrollIntoView;if(n){switch(n){case"center-animate":n="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var r=this.selection.getRange(),i=this.renderer.layerConfig;(r.start.row>=i.lastRow||r.end.row<=i.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}"animate"==n&&this.renderer.animateScrolling(this.curOp.scrollTop)}this.prevOp=this.curOp,this.curOp=null}},this.$mergeableCommands=["backspace","del","insertstring"],this.$historyTracker=function(e){if(this.$mergeUndoDeltas){var t=this.prevOp,n=this.$mergeableCommands,r=t.command&&e.command.name==t.command.name;if("insertstring"==e.command.name){var i=e.args;void 0===this.mergeNextCommand&&(this.mergeNextCommand=!0),r=r&&this.mergeNextCommand&&(!/\s/.test(i)||/\s/.test(t.args)),this.mergeNextCommand=!0}else r=r&&-1!==n.indexOf(e.command.name);"always"!=this.$mergeUndoDeltas&&Date.now()-this.sequenceStartTime>2e3&&(r=!1),r?this.session.mergeUndoDeltas=!0:-1!==n.indexOf(e.command.name)&&(this.sequenceStartTime=Date.now())}},this.setKeyboardHandler=function(e,t){if(e&&"string"==typeof e){this.$keybindingId=e;var n=this;v.loadModule(["keybinding",e],(function(r){n.$keybindingId==e&&n.keyBinding.setKeyboardHandler(r&&r.handler),t&&t()}))}else this.$keybindingId=null,this.keyBinding.setKeyboardHandler(e),t&&t()},this.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},this.setSession=function(e){if(this.session!=e){this.curOp&&this.endOperation(),this.curOp={};var t=this.session;if(t){this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange);var n=this.session.getSelection();n.off("changeCursor",this.$onCursorChange),n.off("changeSelection",this.$onSelectionChange)}this.session=e,e?(this.$onDocumentChange=this.onDocumentChange.bind(this),e.on("change",this.$onDocumentChange),this.renderer.setSession(e),this.$onChangeMode=this.onChangeMode.bind(this),e.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),e.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),e.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),e.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),e.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),e.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=e.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.$blockScrolling+=1,this.onCursorChange(),this.$blockScrolling-=1,this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(e)),this._signal("changeSession",{session:e,oldSession:t}),this.curOp=null,t&&t._signal("changeEditor",{oldEditor:this}),e&&e._signal("changeEditor",{editor:this}),e&&e.bgTokenizer&&e.bgTokenizer.scheduleStart()}},this.getSession=function(){return this.session},this.setValue=function(e,t){return this.session.doc.setValue(e),t?1==t?this.navigateFileEnd():-1==t&&this.navigateFileStart():this.selectAll(),e},this.getValue=function(){return this.session.getValue()},this.getSelection=function(){return this.selection},this.resize=function(e){this.renderer.onResize(e)},this.setTheme=function(e,t){this.renderer.setTheme(e,t)},this.getTheme=function(){return this.renderer.getTheme()},this.setStyle=function(e){this.renderer.setStyle(e)},this.unsetStyle=function(e){this.renderer.unsetStyle(e)},this.getFontSize=function(){return this.getOption("fontSize")||i.computedStyle(this.container,"fontSize")},this.setFontSize=function(e){this.setOption("fontSize",e)},this.$highlightBrackets=function(){if(this.session.$bracketHighlight&&(this.session.removeMarker(this.session.$bracketHighlight),this.session.$bracketHighlight=null),!this.$highlightPending){var e=this;this.$highlightPending=!0,setTimeout((function(){e.$highlightPending=!1;var t=e.session;if(t&&t.bgTokenizer){var n=t.findMatchingBracket(e.getCursorPosition());if(n)var r=new f(n.row,n.column,n.row,n.column+1);else if(t.$mode.getMatching)r=t.$mode.getMatching(e.session);r&&(t.$bracketHighlight=t.addMarker(r,"ace_bracket","text"))}}),50)}},this.$highlightTags=function(){if(!this.$highlightTagPending){var e=this;this.$highlightTagPending=!0,setTimeout((function(){e.$highlightTagPending=!1;var t=e.session;if(t&&t.bgTokenizer){var n=e.getCursorPosition(),r=new y(e.session,n.row,n.column),i=r.getCurrentToken();if(!i||!/\b(?:tag-open|tag-name)/.test(i.type))return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);if(-1==i.type.indexOf("tag-open")||(i=r.stepForward())){var o=i.value,a=0,s=r.stepBackward();if("<"==s.value)do{s=i,(i=r.stepForward())&&i.value===o&&-1!==i.type.indexOf("tag-name")&&("<"===s.value?a++:"</"===s.value&&a--)}while(i&&a>=0);else{do{i=s,s=r.stepBackward(),i&&i.value===o&&-1!==i.type.indexOf("tag-name")&&("<"===s.value?a++:"</"===s.value&&a--)}while(s&&a<=0);r.stepForward()}if(!i)return t.removeMarker(t.$tagHighlight),void(t.$tagHighlight=null);var c=r.getCurrentTokenRow(),l=r.getCurrentTokenColumn(),u=new f(c,l,c,l+i.value.length),h=t.$backMarkers[t.$tagHighlight];t.$tagHighlight&&null!=h&&0!==u.compareRange(h.range)&&(t.removeMarker(t.$tagHighlight),t.$tagHighlight=null),u&&!t.$tagHighlight&&(t.$tagHighlight=t.addMarker(u,"ace_bracket","text"))}}}),50)}},this.focus=function(){var e=this;setTimeout((function(){e.textInput.focus()})),this.textInput.focus()},this.isFocused=function(){return this.textInput.isFocused()},this.blur=function(){this.textInput.blur()},this.onFocus=function(e){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",e))},this.onBlur=function(e){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",e))},this.$cursorChange=function(){this.renderer.updateCursor()},this.onDocumentChange=function(e){var t=this.session.$useWrapMode,n=e.start.row==e.end.row?e.end.row:1/0;this.renderer.updateLines(e.start.row,n,t),this._signal("change",e),this.$cursorChange(),this.$updateHighlightActiveLine()},this.onTokenizerUpdate=function(e){var t=e.data;this.renderer.updateLines(t.first,t.last)},this.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},this.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},this.onCursorChange=function(){this.$cursorChange(),this.$blockScrolling||(v.warn("Automatically scrolling cursor into view after selection change","this will be disabled in the next version","set editor.$blockScrolling = Infinity to disable this message"),this.renderer.scrollCursorIntoView()),this.$highlightBrackets(),this.$highlightTags(),this.$updateHighlightActiveLine(),this._signal("changeSelection")},this.$updateHighlightActiveLine=function(){var e,t=this.getSession();if(this.$highlightActiveLine&&("line"==this.$selectionStyle&&this.selection.isMultiLine()||(e=this.getCursorPosition()),!this.renderer.$maxLines||1!==this.session.getLength()||this.renderer.$minLines>1||(e=!1)),t.$highlightLineMarker&&!e)t.removeMarker(t.$highlightLineMarker.id),t.$highlightLineMarker=null;else if(!t.$highlightLineMarker&&e){var n=new f(e.row,e.column,e.row,1/0);n.id=t.addMarker(n,"ace_active-line","screenLine"),t.$highlightLineMarker=n}else e&&(t.$highlightLineMarker.start.row=e.row,t.$highlightLineMarker.end.row=e.row,t.$highlightLineMarker.start.column=e.column,t._signal("changeBackMarker"))},this.onSelectionChange=function(e){var t=this.session;if(t.$selectionMarker&&t.removeMarker(t.$selectionMarker),t.$selectionMarker=null,this.selection.isEmpty())this.$updateHighlightActiveLine();else{var n=this.selection.getRange(),r=this.getSelectionStyle();t.$selectionMarker=t.addMarker(n,"ace_selection",r)}var i=this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp();this.session.highlight(i),this._signal("changeSelection")},this.$getSelectionHighLightRegexp=function(){var e=this.session,t=this.getSelectionRange();if(!t.isEmpty()&&!t.isMultiLine()){var n=t.start.column-1,r=t.end.column+1,i=e.getLine(t.start.row),o=i.length,a=i.substring(Math.max(n,0),Math.min(r,o));if(!(n>=0&&/^[\w\d]/.test(a)||r<=o&&/[\w\d]$/.test(a)))if(a=i.substring(t.start.column,t.end.column),/^[\w\d]+$/.test(a))return this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:a})}},this.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},this.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},this.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},this.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},this.onChangeMode=function(e){this.renderer.updateText(),this._emit("changeMode",e)},this.onChangeWrapLimit=function(){this.renderer.updateFull()},this.onChangeWrapMode=function(){this.renderer.onResize(!0)},this.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},this.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},this.getCopyText=function(){var e=this.getSelectedText();return this._signal("copy",e),e},this.onCopy=function(){this.commands.exec("copy",this)},this.onCut=function(){this.commands.exec("cut",this)},this.onPaste=function(e,t){var n={text:e,event:t};this.commands.exec("paste",this,n)},this.$handlePaste=function(e){"string"==typeof e&&(e={text:e}),this._signal("paste",e);var t=e.text;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)this.insert(t);else{var n=t.split(/\r\n|\r|\n/),r=this.selection.rangeList.ranges;if(n.length>r.length||n.length<2||!n[1])return this.commands.exec("insertstring",this,t);for(var i=r.length;i--;){var o=r[i];o.isEmpty()||this.session.remove(o),this.session.insert(o.start,n[i])}}},this.execCommand=function(e,t){return this.commands.exec(e,this,t)},this.insert=function(e,t){var n=this.session,r=n.getMode(),i=this.getCursorPosition();if(this.getBehavioursEnabled()&&!t){var o=r.transformAction(n.getState(i.row),"insertion",this,n,e);o&&(e!==o.text&&(this.session.mergeUndoDeltas=!1,this.$mergeNextCommand=!1),e=o.text)}if("\t"==e&&(e=this.session.getTabString()),this.selection.isEmpty()){if(this.session.getOverwrite()&&-1==e.indexOf("\n")){(a=new f.fromPoints(i,i)).end.column+=e.length,this.session.remove(a)}}else{var a=this.getSelectionRange();i=this.session.remove(a),this.clearSelection()}if("\n"==e||"\r\n"==e){var s=n.getLine(i.row);if(i.column>s.search(/\S|$/)){var c=s.substr(i.column).search(/\S|$/);n.doc.removeInLine(i.row,i.column,i.column+c)}}this.clearSelection();var l=i.column,u=n.getState(i.row),h=(s=n.getLine(i.row),r.checkOutdent(u,s,e));n.insert(i,e);if(o&&o.selection&&(2==o.selection.length?this.selection.setSelectionRange(new f(i.row,l+o.selection[0],i.row,l+o.selection[1])):this.selection.setSelectionRange(new f(i.row+o.selection[0],o.selection[1],i.row+o.selection[2],o.selection[3]))),n.getDocument().isNewLine(e)){var d=r.getNextLineIndent(u,s.slice(0,i.column),n.getTabString());n.insert({row:i.row+1,column:0},d)}h&&r.autoOutdent(u,n,i.row)},this.onTextInput=function(e){this.keyBinding.onTextInput(e)},this.onCommandKey=function(e,t,n){this.keyBinding.onCommandKey(e,t,n)},this.setOverwrite=function(e){this.session.setOverwrite(e)},this.getOverwrite=function(){return this.session.getOverwrite()},this.toggleOverwrite=function(){this.session.toggleOverwrite()},this.setScrollSpeed=function(e){this.setOption("scrollSpeed",e)},this.getScrollSpeed=function(){return this.getOption("scrollSpeed")},this.setDragDelay=function(e){this.setOption("dragDelay",e)},this.getDragDelay=function(){return this.getOption("dragDelay")},this.setSelectionStyle=function(e){this.setOption("selectionStyle",e)},this.getSelectionStyle=function(){return this.getOption("selectionStyle")},this.setHighlightActiveLine=function(e){this.setOption("highlightActiveLine",e)},this.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.setHighlightSelectedWord=function(e){this.setOption("highlightSelectedWord",e)},this.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},this.setAnimatedScroll=function(e){this.renderer.setAnimatedScroll(e)},this.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},this.setShowInvisibles=function(e){this.renderer.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},this.setDisplayIndentGuides=function(e){this.renderer.setDisplayIndentGuides(e)},this.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},this.setShowPrintMargin=function(e){this.renderer.setShowPrintMargin(e)},this.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},this.setPrintMarginColumn=function(e){this.renderer.setPrintMarginColumn(e)},this.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},this.setReadOnly=function(e){this.setOption("readOnly",e)},this.getReadOnly=function(){return this.getOption("readOnly")},this.setBehavioursEnabled=function(e){this.setOption("behavioursEnabled",e)},this.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},this.setWrapBehavioursEnabled=function(e){this.setOption("wrapBehavioursEnabled",e)},this.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},this.setShowFoldWidgets=function(e){this.setOption("showFoldWidgets",e)},this.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.remove=function(e){this.selection.isEmpty()&&("left"==e?this.selection.selectLeft():this.selection.selectRight());var t=this.getSelectionRange();if(this.getBehavioursEnabled()){var n=this.session,r=n.getState(t.start.row),i=n.getMode().transformAction(r,"deletion",this,n,t);if(0===t.end.column){var o=n.getTextRange(t);if("\n"==o[o.length-1]){var a=n.getLine(t.end.row);/^\s+$/.test(a)&&(t.end.column=a.length)}}i&&(t=i)}this.session.remove(t),this.clearSelection()},this.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.session.remove(this.getSelectionRange()),this.clearSelection()},this.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var e=this.getSelectionRange();e.start.column==e.end.column&&e.start.row==e.end.row&&(e.end.column=0,e.end.row++),this.session.remove(e),this.clearSelection()},this.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var e=this.getCursorPosition();this.insert("\n"),this.moveCursorToPosition(e)},this.transposeLetters=function(){if(this.selection.isEmpty()){var e=this.getCursorPosition(),t=e.column;if(0!==t){var n,r,i=this.session.getLine(e.row);t<i.length?(n=i.charAt(t)+i.charAt(t-1),r=new f(e.row,t-1,e.row,t+1)):(n=i.charAt(t-1)+i.charAt(t-2),r=new f(e.row,t-2,e.row,t)),this.session.replace(r,n),this.session.selection.moveToPosition(r.end)}}},this.toLowerCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),n=this.session.getTextRange(t);this.session.replace(t,n.toLowerCase()),this.selection.setSelectionRange(e)},this.toUpperCase=function(){var e=this.getSelectionRange();this.selection.isEmpty()&&this.selection.selectWord();var t=this.getSelectionRange(),n=this.session.getTextRange(t);this.session.replace(t,n.toUpperCase()),this.selection.setSelectionRange(e)},this.indent=function(){var e=this.session,t=this.getSelectionRange();if(!(t.start.row<t.end.row)){if(t.start.column<t.end.column){var n=e.getTextRange(t);if(!/^\s+$/.test(n)){u=this.$getSelectedRows();return void e.indentRows(u.first,u.last,"\t")}}var r=e.getLine(t.start.row),i=t.start,a=e.getTabSize(),s=e.documentToScreenColumn(i.row,i.column);if(this.session.getUseSoftTabs())var c=a-s%a,l=o.stringRepeat(" ",c);else{for(c=s%a;" "==r[t.start.column-1]&&c;)t.start.column--,c--;this.selection.setSelectionRange(t),l="\t"}return this.insert(l)}var u=this.$getSelectedRows();e.indentRows(u.first,u.last,"\t")},this.blockIndent=function(){var e=this.$getSelectedRows();this.session.indentRows(e.first,e.last,"\t")},this.blockOutdent=function(){var e=this.session.getSelection();this.session.outdentRows(e.getRange())},this.sortLines=function(){for(var e=this.$getSelectedRows(),t=this.session,n=[],r=e.first;r<=e.last;r++)n.push(t.getLine(r));n.sort((function(e,t){return e.toLowerCase()<t.toLowerCase()?-1:e.toLowerCase()>t.toLowerCase()?1:0}));var i=new f(0,0,0,0);for(r=e.first;r<=e.last;r++){var o=t.getLine(r);i.start.row=r,i.end.row=r,i.end.column=o.length,t.replace(i,n[r-e.first])}},this.toggleCommentLines=function(){var e=this.session.getState(this.getCursorPosition().row),t=this.$getSelectedRows();this.session.getMode().toggleCommentLines(e,this.session,t.first,t.last)},this.toggleBlockComment=function(){var e=this.getCursorPosition(),t=this.session.getState(e.row),n=this.getSelectionRange();this.session.getMode().toggleBlockComment(t,this.session,n,e)},this.getNumberAt=function(e,t){var n=/[\-]?[0-9]+(?:\.[0-9]+)?/g;n.lastIndex=0;for(var r=this.session.getLine(e);n.lastIndex<t;){var i=n.exec(r);if(i.index<=t&&i.index+i[0].length>=t)return{value:i[0],start:i.index,end:i.index+i[0].length}}return null},this.modifyNumber=function(e){var t=this.selection.getCursor().row,n=this.selection.getCursor().column,r=new f(t,n-1,t,n),i=this.session.getTextRange(r);if(!isNaN(parseFloat(i))&&isFinite(i)){var o=this.getNumberAt(t,n);if(o){var a=o.value.indexOf(".")>=0?o.start+o.value.indexOf(".")+1:o.end,s=o.start+o.value.length-a,c=parseFloat(o.value);c*=Math.pow(10,s),a!==o.end&&n<a?e*=Math.pow(10,o.end-n-1):e*=Math.pow(10,o.end-n),c+=e;var l=(c/=Math.pow(10,s)).toFixed(s),u=new f(t,o.start,t,o.end);this.session.replace(u,l),this.moveCursorTo(t,Math.max(o.start+1,n+l.length-o.value.length))}}},this.removeLines=function(){var e=this.$getSelectedRows();this.session.removeFullLines(e.first,e.last),this.clearSelection()},this.duplicateSelection=function(){var e=this.selection,t=this.session,n=e.getRange(),r=e.isBackwards();if(n.isEmpty()){var i=n.start.row;t.duplicateLines(i,i)}else{var o=r?n.start:n.end,a=t.insert(o,t.getTextRange(n),!1);n.start=o,n.end=a,e.setSelectionRange(n,r)}},this.moveLinesDown=function(){this.$moveLines(1,!1)},this.moveLinesUp=function(){this.$moveLines(-1,!1)},this.moveText=function(e,t,n){return this.session.moveText(e,t,n)},this.copyLinesUp=function(){this.$moveLines(-1,!0)},this.copyLinesDown=function(){this.$moveLines(1,!0)},this.$moveLines=function(e,t){var n,r,i=this.selection;if(!i.inMultiSelectMode||this.inVirtualSelectionMode){var o=i.toOrientedRange();n=this.$getSelectedRows(o),r=this.session.$moveLines(n.first,n.last,t?0:e),t&&-1==e&&(r=0),o.moveBy(r,0),i.fromOrientedRange(o)}else{var a=i.rangeList.ranges;i.rangeList.detach(this.session),this.inVirtualSelectionMode=!0;for(var s=0,c=0,l=a.length,u=0;u<l;u++){var h=u;a[u].moveBy(s,0);for(var d=(n=this.$getSelectedRows(a[u])).first,f=n.last;++u<l;){c&&a[u].moveBy(c,0);var p=this.$getSelectedRows(a[u]);if(t&&p.first!=f)break;if(!t&&p.first>f+1)break;f=p.last}for(u--,s=this.session.$moveLines(d,f,t?0:e),t&&-1==e&&(h=u+1);h<=u;)a[h].moveBy(s,0),h++;t||(s=0),c+=s}i.fromOrientedRange(i.ranges[0]),i.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},this.$getSelectedRows=function(e){return e=(e||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(e.start.row),last:this.session.getRowFoldEnd(e.end.row)}},this.onCompositionStart=function(e){this.renderer.showComposition(this.getCursorPosition())},this.onCompositionUpdate=function(e){this.renderer.setCompositionText(e)},this.onCompositionEnd=function(){this.renderer.hideComposition()},this.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},this.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},this.isRowVisible=function(e){return e>=this.getFirstVisibleRow()&&e<=this.getLastVisibleRow()},this.isRowFullyVisible=function(e){return e>=this.renderer.getFirstFullyVisibleRow()&&e<=this.renderer.getLastFullyVisibleRow()},this.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},this.$moveByPage=function(e,t){var n=this.renderer,r=this.renderer.layerConfig,i=e*Math.floor(r.height/r.lineHeight);this.$blockScrolling++,!0===t?this.selection.$moveSelection((function(){this.moveCursorBy(i,0)})):!1===t&&(this.selection.moveCursorBy(i,0),this.selection.clearSelection()),this.$blockScrolling--;var o=n.scrollTop;n.scrollBy(0,i*r.lineHeight),null!=t&&n.scrollCursorIntoView(null,.5),n.animateScrolling(o)},this.selectPageDown=function(){this.$moveByPage(1,!0)},this.selectPageUp=function(){this.$moveByPage(-1,!0)},this.gotoPageDown=function(){this.$moveByPage(1,!1)},this.gotoPageUp=function(){this.$moveByPage(-1,!1)},this.scrollPageDown=function(){this.$moveByPage(1)},this.scrollPageUp=function(){this.$moveByPage(-1)},this.scrollToRow=function(e){this.renderer.scrollToRow(e)},this.scrollToLine=function(e,t,n,r){this.renderer.scrollToLine(e,t,n,r)},this.centerSelection=function(){var e=this.getSelectionRange(),t={row:Math.floor(e.start.row+(e.end.row-e.start.row)/2),column:Math.floor(e.start.column+(e.end.column-e.start.column)/2)};this.renderer.alignCursor(t,.5)},this.getCursorPosition=function(){return this.selection.getCursor()},this.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},this.getSelectionRange=function(){return this.selection.getRange()},this.selectAll=function(){this.$blockScrolling+=1,this.selection.selectAll(),this.$blockScrolling-=1},this.clearSelection=function(){this.selection.clearSelection()},this.moveCursorTo=function(e,t){this.selection.moveCursorTo(e,t)},this.moveCursorToPosition=function(e){this.selection.moveCursorToPosition(e)},this.jumpToMatching=function(e,t){var n=this.getCursorPosition(),r=new y(this.session,n.row,n.column),i=r.getCurrentToken(),o=i||r.stepForward();if(o){var a,s,c=!1,l={},u=n.column-o.start,h={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do{if(o.value.match(/[{}()\[\]]/g)){for(;u<o.value.length&&!c;u++)if(h[o.value[u]])switch(s=h[o.value[u]]+"."+o.type.replace("rparen","lparen"),isNaN(l[s])&&(l[s]=0),o.value[u]){case"(":case"[":case"{":l[s]++;break;case")":case"]":case"}":l[s]--,-1===l[s]&&(a="bracket",c=!0)}}else o&&-1!==o.type.indexOf("tag-name")&&(isNaN(l[o.value])&&(l[o.value]=0),"<"===i.value?l[o.value]++:"</"===i.value&&l[o.value]--,-1===l[o.value]&&(a="tag",c=!0));c||(i=o,o=r.stepForward(),u=0)}while(o&&!c);if(a){var d,p;if("bracket"===a)(d=this.session.getBracketRange(n))||(p=(d=new f(r.getCurrentTokenRow(),r.getCurrentTokenColumn()+u-1,r.getCurrentTokenRow(),r.getCurrentTokenColumn()+u-1)).start,(t||p.row===n.row&&Math.abs(p.column-n.column)<2)&&(d=this.session.getBracketRange(p)));else if("tag"===a){if(!o||-1===o.type.indexOf("tag-name"))return;var m=o.value;if(0===(d=new f(r.getCurrentTokenRow(),r.getCurrentTokenColumn()-2,r.getCurrentTokenRow(),r.getCurrentTokenColumn()-2)).compare(n.row,n.column)){c=!1;do{o=i,(i=r.stepBackward())&&(-1!==i.type.indexOf("tag-close")&&d.setEnd(r.getCurrentTokenRow(),r.getCurrentTokenColumn()+1),o.value===m&&-1!==o.type.indexOf("tag-name")&&("<"===i.value?l[m]++:"</"===i.value&&l[m]--,0===l[m]&&(c=!0)))}while(i&&!c)}o&&o.type.indexOf("tag-name")&&(p=d.start).row==n.row&&Math.abs(p.column-n.column)<2&&(p=d.end)}(p=d&&d.cursor||p)&&(e?d&&t?this.selection.setRange(d):d&&d.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(p.row,p.column):this.selection.moveTo(p.row,p.column))}}},this.gotoLine=function(e,t,n){this.selection.clearSelection(),this.session.unfold({row:e-1,column:t||0}),this.$blockScrolling+=1,this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(e-1,t||0),this.$blockScrolling-=1,this.isRowFullyVisible(e-1)||this.scrollToLine(e-1,!0,n)},this.navigateTo=function(e,t){this.selection.moveTo(e,t)},this.navigateUp=function(e){if(this.selection.isMultiLine()&&!this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(-e||-1,0)},this.navigateDown=function(e){if(this.selection.isMultiLine()&&this.selection.isBackwards()){var t=this.selection.anchor.getPosition();return this.moveCursorToPosition(t)}this.selection.clearSelection(),this.selection.moveCursorBy(e||1,0)},this.navigateLeft=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorLeft();else{var t=this.getSelectionRange().start;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateRight=function(e){if(this.selection.isEmpty())for(e=e||1;e--;)this.selection.moveCursorRight();else{var t=this.getSelectionRange().end;this.moveCursorToPosition(t)}this.clearSelection()},this.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},this.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},this.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},this.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},this.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},this.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},this.replace=function(e,t){t&&this.$search.set(t);var n=this.$search.find(this.session),r=0;return n?(this.$tryReplace(n,e)&&(r=1),null!==n&&(this.selection.setSelectionRange(n),this.renderer.scrollSelectionIntoView(n.start,n.end)),r):r},this.replaceAll=function(e,t){t&&this.$search.set(t);var n=this.$search.findAll(this.session),r=0;if(!n.length)return r;this.$blockScrolling+=1;var i=this.getSelectionRange();this.selection.moveTo(0,0);for(var o=n.length-1;o>=0;--o)this.$tryReplace(n[o],e)&&r++;return this.selection.setSelectionRange(i),this.$blockScrolling-=1,r},this.$tryReplace=function(e,t){var n=this.session.getTextRange(e);return null!==(t=this.$search.replace(n,t))?(e.end=this.session.replace(e,t),e):null},this.getLastSearchOptions=function(){return this.$search.getOptions()},this.find=function(e,t,n){t||(t={}),"string"==typeof e||e instanceof RegExp?t.needle=e:"object"==typeof e&&r.mixin(t,e);var i=this.selection.getRange();null==t.needle&&((e=this.session.getTextRange(i)||this.$search.$options.needle)||(i=this.session.getWordRange(i.start.row,i.start.column),e=this.session.getTextRange(i)),this.$search.set({needle:e})),this.$search.set(t),t.start||this.$search.set({start:i});var o=this.$search.find(this.session);return t.preventScroll?o:o?(this.revealRange(o,n),o):(t.backwards?i.start=i.end:i.end=i.start,void this.selection.setRange(i))},this.findNext=function(e,t){this.find({skipCurrent:!0,backwards:!1},e,t)},this.findPrevious=function(e,t){this.find(e,{skipCurrent:!0,backwards:!0},t)},this.revealRange=function(e,t){this.$blockScrolling+=1,this.session.unfold(e),this.selection.setSelectionRange(e),this.$blockScrolling-=1;var n=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(e.start,e.end,.5),!1!==t&&this.renderer.animateScrolling(n)},this.undo=function(){this.$blockScrolling++,this.session.getUndoManager().undo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.redo=function(){this.$blockScrolling++,this.session.getUndoManager().redo(),this.$blockScrolling--,this.renderer.scrollCursorIntoView(null,.5)},this.destroy=function(){this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy()},this.setAutoScrollEditorIntoView=function(e){if(e){var t,n=this,r=!1;this.$scrollAnchor||(this.$scrollAnchor=document.createElement("div"));var i=this.$scrollAnchor;i.style.cssText="position:absolute",this.container.insertBefore(i,this.container.firstChild);var o=this.on("changeSelection",(function(){r=!0})),a=this.renderer.on("beforeRender",(function(){r&&(t=n.renderer.container.getBoundingClientRect())})),s=this.renderer.on("afterRender",(function(){if(r&&t&&(n.isFocused()||n.searchBox&&n.searchBox.isFocused())){var e=n.renderer,o=e.$cursorLayer.$pixelPos,a=e.layerConfig,s=o.top-a.offset;null!=(r=o.top>=0&&s+t.top<0||!(o.top<a.height&&o.top+t.top+a.lineHeight>window.innerHeight)&&null)&&(i.style.top=s+"px",i.style.left=o.left+"px",i.style.height=a.lineHeight+"px",i.scrollIntoView(r)),r=t=null}}));this.setAutoScrollEditorIntoView=function(e){e||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",o),this.renderer.off("afterRender",s),this.renderer.off("beforeRender",a))}}},this.$resetCursorStyle=function(){var e=this.$cursorStyle||"ace",t=this.renderer.$cursorLayer;t&&(t.setSmoothBlinking(/smooth/.test(e)),t.isBlinking=!this.$readOnly&&"wide"!=e,i.setCssClass(t.element,"ace_slim-cursors",/slim/.test(e)))}}.call(b.prototype),v.defineOptions(b.prototype,"editor",{selectionStyle:{set:function(e){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:e})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(e){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(e){this.$resetCursorStyle()},initialValue:!1},cursorStyle:{set:function(e){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},autoScrollEditorIntoView:{set:function(e){this.setAutoScrollEditorIntoView(e)}},keyboardHandler:{set:function(e){this.setKeyboardHandler(e)},get:function(){return this.keybindingId},handlesSet:!0},hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",showLineNumbers:"renderer",showGutter:"renderer",displayIndentGuides:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"}),t.Editor=b})),ace.define("ace/undomanager",["require","exports","module"],(function(e,t,n){"use strict";var r=function(){this.reset()};(function(){function e(e){return{action:e.action,start:e.start,end:e.end,lines:1==e.lines.length?null:e.lines,text:1==e.lines.length?e.lines[0]:null}}function t(e){return{action:e.action,start:e.start,end:e.end,lines:e.lines||[e.text]}}function n(e,t){for(var n=new Array(e.length),r=0;r<e.length;r++){for(var i=e[r],o={group:i.group,deltas:new Array(i.length)},a=0;a<i.deltas.length;a++){var s=i.deltas[a];o.deltas[a]=t(s)}n[r]=o}return n}this.execute=function(e){var t=e.args[0];this.$doc=e.args[1],e.merge&&this.hasUndo()&&(this.dirtyCounter--,t=this.$undoStack.pop().concat(t)),this.$undoStack.push(t),this.$redoStack=[],this.dirtyCounter<0&&(this.dirtyCounter=NaN),this.dirtyCounter++},this.undo=function(e){var t=this.$undoStack.pop(),n=null;return t&&(n=this.$doc.undoChanges(t,e),this.$redoStack.push(t),this.dirtyCounter--),n},this.redo=function(e){var t=this.$redoStack.pop(),n=null;return t&&(n=this.$doc.redoChanges(this.$deserializeDeltas(t),e),this.$undoStack.push(t),this.dirtyCounter++),n},this.reset=function(){this.$undoStack=[],this.$redoStack=[],this.dirtyCounter=0},this.hasUndo=function(){return this.$undoStack.length>0},this.hasRedo=function(){return this.$redoStack.length>0},this.markClean=function(){this.dirtyCounter=0},this.isClean=function(){return 0===this.dirtyCounter},this.$serializeDeltas=function(t){return n(t,e)},this.$deserializeDeltas=function(e){return n(e,t)}}).call(r.prototype),t.UndoManager=r})),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("../lib/dom"),i=e("../lib/oop"),o=e("../lib/lang"),a=e("../lib/event_emitter").EventEmitter,s=function(e){this.element=r.createElement("div"),this.element.className="ace_layer ace_gutter-layer",e.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$cells=[]};(function(){i.implement(this,a),this.setSession=function(e){this.session&&this.session.removeEventListener("change",this.$updateAnnotations),this.session=e,e&&e.on("change",this.$updateAnnotations)},this.addGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(e,t)},this.setAnnotations=function(e){this.$annotations=[];for(var t=0;t<e.length;t++){var n=e[t],r=n.row,i=this.$annotations[r];i||(i=this.$annotations[r]={text:[]});var a=n.text;a=a?o.escapeHTML(a):n.html||"",-1===i.text.indexOf(a)&&i.text.push(a);var s=n.type;"error"==s?i.className=" ace_error":"warning"==s&&" ace_error"!=i.className?i.className=" ace_warning":"info"!=s||i.className||(i.className=" ace_info")}},this.$updateAnnotations=function(e){if(this.$annotations.length){var t=e.start.row,n=e.end.row-t;if(0===n);else if("remove"==e.action)this.$annotations.splice(t,n+1,null);else{var r=new Array(n+1);r.unshift(t,1),this.$annotations.splice.apply(this.$annotations,r)}}},this.update=function(e){for(var t=this.session,n=e.firstRow,i=Math.min(e.lastRow+e.gutterOffset,t.getLength()-1),o=t.getNextFoldLine(n),a=o?o.start.row:1/0,s=this.$showFoldWidgets&&t.foldWidgets,c=t.$breakpoints,l=t.$decorations,u=t.$firstLineNumber,h=0,d=t.gutterRenderer||this.$renderer,f=null,p=-1,m=n;;){if(m>a&&(m=o.end.row+1,a=(o=t.getNextFoldLine(m,o))?o.start.row:1/0),m>i){for(;this.$cells.length>p+1;)f=this.$cells.pop(),this.element.removeChild(f.element);break}(f=this.$cells[++p])||((f={element:null,textNode:null,foldWidget:null}).element=r.createElement("div"),f.textNode=document.createTextNode(""),f.element.appendChild(f.textNode),this.element.appendChild(f.element),this.$cells[p]=f);var g="ace_gutter-cell ";if(c[m]&&(g+=c[m]),l[m]&&(g+=l[m]),this.$annotations[m]&&(g+=this.$annotations[m].className),f.element.className!=g&&(f.element.className=g),(y=t.getRowLength(m)*e.lineHeight+"px")!=f.element.style.height&&(f.element.style.height=y),s){var v=s[m];null==v&&(v=s[m]=t.getFoldWidget(m))}if(v){f.foldWidget||(f.foldWidget=r.createElement("span"),f.element.appendChild(f.foldWidget));g="ace_fold-widget ace_"+v;"start"==v&&m==a&&m<o.end.row?g+=" ace_closed":g+=" ace_open",f.foldWidget.className!=g&&(f.foldWidget.className=g);var y=e.lineHeight+"px";f.foldWidget.style.height!=y&&(f.foldWidget.style.height=y)}else f.foldWidget&&(f.element.removeChild(f.foldWidget),f.foldWidget=null);var b=h=d?d.getText(t,m):m+u;b!==f.textNode.data&&(f.textNode.data=b),m++}this.element.style.height=e.minHeight+"px",(this.$fixedWidth||t.$useWrapMode)&&(h=t.getLength()+u);var w=d?d.getWidth(t,h,e):h.toString().length*e.characterWidth,x=this.$padding||this.$computePadding();(w+=x.left+x.right)===this.gutterWidth||isNaN(w)||(this.gutterWidth=w,this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._emit("changeGutterWidth",w))},this.$fixedWidth=!1,this.$showLineNumbers=!0,this.$renderer="",this.setShowLineNumbers=function(e){this.$renderer=!e&&{getWidth:function(){return""},getText:function(){return""}}},this.getShowLineNumbers=function(){return this.$showLineNumbers},this.$showFoldWidgets=!0,this.setShowFoldWidgets=function(e){e?r.addCssClass(this.element,"ace_folding-enabled"):r.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=e,this.$padding=null},this.getShowFoldWidgets=function(){return this.$showFoldWidgets},this.$computePadding=function(){if(!this.element.firstChild)return{left:0,right:0};var e=r.computedStyle(this.element.firstChild);return this.$padding={},this.$padding.left=parseInt(e.paddingLeft)+1||0,this.$padding.right=parseInt(e.paddingRight)||0,this.$padding},this.getRegion=function(e){var t=this.$padding||this.$computePadding(),n=this.element.getBoundingClientRect();return e.x<t.left+n.left?"markers":this.$showFoldWidgets&&e.x>n.right-t.right?"foldWidgets":void 0}}).call(s.prototype),t.Gutter=s})),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],(function(e,t,n){"use strict";var r=e("../range").Range,i=e("../lib/dom"),o=function(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_marker-layer",e.appendChild(this.element)};(function(){this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setMarkers=function(e){this.markers=e},this.update=function(e){if(e){this.config=e;var t=[];for(var n in this.markers){var r=this.markers[n];if(r.range){var i=r.range.clipRows(e.firstRow,e.lastRow);if(!i.isEmpty())if(i=i.toScreenRange(this.session),r.renderer){var o=this.$getTop(i.start.row,e),a=this.$padding+(this.session.$bidiHandler.isBidiRow(i.start.row)?this.session.$bidiHandler.getPosLeft(i.start.column):i.start.column*e.characterWidth);r.renderer(t,i,a,o,e)}else"fullLine"==r.type?this.drawFullLineMarker(t,i,r.clazz,e):"screenLine"==r.type?this.drawScreenLineMarker(t,i,r.clazz,e):i.isMultiLine()?"text"==r.type?this.drawTextMarker(t,i,r.clazz,e):this.drawMultiLineMarker(t,i,r.clazz,e):this.session.$bidiHandler.isBidiRow(i.start.row)?this.drawBidiSingleLineMarker(t,i,r.clazz+" ace_start ace_br15",e):this.drawSingleLineMarker(t,i,r.clazz+" ace_start ace_br15",e)}else r.update(t,this,this.session,e)}this.element.innerHTML=t.join("")}},this.$getTop=function(e,t){return(e-t.firstRowScreen)*t.lineHeight},this.drawTextMarker=function(e,t,n,i,o){for(var a=this.session,s=t.start.row,c=t.end.row,l=s,u=0,h=0,d=a.getScreenLastRowColumn(l),f=null,p=new r(l,t.start.column,l,h);l<=c;l++)p.start.row=p.end.row=l,p.start.column=l==s?t.start.column:a.getRowWrapIndent(l),p.end.column=d,u=h,h=d,d=l+1<c?a.getScreenLastRowColumn(l+1):l==c?0:t.end.column,f=n+(l==s?" ace_start":"")+" ace_br"+((l==s||l==s+1&&t.start.column?1:0)|(u<h?2:0)|(h>d?4:0)|(l==c?8:0)),this.session.$bidiHandler.isBidiRow(l)?this.drawBidiSingleLineMarker(e,p,f,i,l==c?0:1,o):this.drawSingleLineMarker(e,p,f,i,l==c?0:1,o)},this.drawMultiLineMarker=function(e,t,n,r,i){var o,a,s,c=this.$padding;(i=i||"",this.session.$bidiHandler.isBidiRow(t.start.row))?((l=t.clone()).end.row=l.start.row,l.end.column=this.session.getLine(l.start.row).length,this.drawBidiSingleLineMarker(e,l,n+" ace_br1 ace_start",r,null,i)):(o=r.lineHeight,a=this.$getTop(t.start.row,r),s=c+t.start.column*r.characterWidth,e.push("<div class='",n," ace_br1 ace_start' style='","height:",o,"px;","right:0;","top:",a,"px;","left:",s,"px;",i,"'></div>"));if(this.session.$bidiHandler.isBidiRow(t.end.row)){var l;(l=t.clone()).start.row=l.end.row,l.start.column=0,this.drawBidiSingleLineMarker(e,l,n+" ace_br12",r,null,i)}else{var u=t.end.column*r.characterWidth;o=r.lineHeight,a=this.$getTop(t.end.row,r),e.push("<div class='",n," ace_br12' style='","height:",o,"px;","width:",u,"px;","top:",a,"px;","left:",c,"px;",i,"'></div>")}if(!((o=(t.end.row-t.start.row-1)*r.lineHeight)<=0)){a=this.$getTop(t.start.row+1,r);var h=(t.start.column?1:0)|(t.end.column?0:8);e.push("<div class='",n,h?" ace_br"+h:"","' style='","height:",o,"px;","right:0;","top:",a,"px;","left:",c,"px;",i,"'></div>")}},this.drawSingleLineMarker=function(e,t,n,r,i,o){var a=r.lineHeight,s=(t.end.column+(i||0)-t.start.column)*r.characterWidth,c=this.$getTop(t.start.row,r),l=this.$padding+t.start.column*r.characterWidth;e.push("<div class='",n,"' style='","height:",a,"px;","width:",s,"px;","top:",c,"px;","left:",l,"px;",o||"","'></div>")},this.drawBidiSingleLineMarker=function(e,t,n,r,i,o){var a=r.lineHeight,s=this.$getTop(t.start.row,r),c=this.$padding;this.session.$bidiHandler.getSelections(t.start.column,t.end.column).forEach((function(t){e.push("<div class='",n,"' style='","height:",a,"px;","width:",t.width+(i||0),"px;","top:",s,"px;","left:",c+t.left,"px;",o||"","'></div>")}))},this.drawFullLineMarker=function(e,t,n,r,i){var o=this.$getTop(t.start.row,r),a=r.lineHeight;t.start.row!=t.end.row&&(a+=this.$getTop(t.end.row,r)-o),e.push("<div class='",n,"' style='","height:",a,"px;","top:",o,"px;","left:0;right:0;",i||"","'></div>")},this.drawScreenLineMarker=function(e,t,n,r,i){var o=this.$getTop(t.start.row,r),a=r.lineHeight;e.push("<div class='",n,"' style='","height:",a,"px;","top:",o,"px;","left:0;right:0;",i||"","'></div>")}}).call(o.prototype),t.Marker=o})),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("../lib/oop"),i=e("../lib/dom"),o=e("../lib/lang"),a=(e("../lib/useragent"),e("../lib/event_emitter").EventEmitter),s=function(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_text-layer",e.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this)};(function(){r.implement(this,a),this.EOF_CHAR="¶",this.EOL_CHAR_LF="¬",this.EOL_CHAR_CRLF="¤",this.EOL_CHAR=this.EOL_CHAR_LF,this.TAB_CHAR="—",this.SPACE_CHAR="·",this.$padding=0,this.$updateEolChar=function(){var e="\n"==this.session.doc.getNewLineCharacter()?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=e)return this.EOL_CHAR=e,!0},this.setPadding=function(e){this.$padding=e,this.element.style.padding="0 "+e+"px"},this.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},this.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},this.$setFontMetrics=function(e){this.$fontMetrics=e,this.$fontMetrics.on("changeCharacterSize",function(e){this._signal("changeCharacterSize",e)}.bind(this)),this.$pollSizeChanges()},this.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},this.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},this.setSession=function(e){this.session=e,e&&this.$computeTabString()},this.showInvisibles=!1,this.setShowInvisibles=function(e){return this.showInvisibles!=e&&(this.showInvisibles=e,this.$computeTabString(),!0)},this.displayIndentGuides=!0,this.setDisplayIndentGuides=function(e){return this.displayIndentGuides!=e&&(this.displayIndentGuides=e,this.$computeTabString(),!0)},this.$tabStrings=[],this.onChangeTabSize=this.$computeTabString=function(){var e=this.session.getTabSize();this.tabSize=e;for(var t=this.$tabStrings=[0],n=1;n<e+1;n++)this.showInvisibles?t.push("<span class='ace_invisible ace_invisible_tab'>"+o.stringRepeat(this.TAB_CHAR,n)+"</span>"):t.push(o.stringRepeat(" ",n));if(this.displayIndentGuides){this.$indentGuideRe=/\s\S| \t|\t |\s$/;var r="ace_indent-guide",i="",a="";if(this.showInvisibles){r+=" ace_invisible",i=" ace_invisible_space",a=" ace_invisible_tab";var s=o.stringRepeat(this.SPACE_CHAR,this.tabSize),c=o.stringRepeat(this.TAB_CHAR,this.tabSize)}else c=s=o.stringRepeat(" ",this.tabSize);this.$tabStrings[" "]="<span class='"+r+i+"'>"+s+"</span>",this.$tabStrings["\t"]="<span class='"+r+a+"'>"+c+"</span>"}},this.updateLines=function(e,t,n){this.config.lastRow==e.lastRow&&this.config.firstRow==e.firstRow||this.scrollLines(e),this.config=e;for(var r=Math.max(t,e.firstRow),i=Math.min(n,e.lastRow),o=this.element.childNodes,a=0,s=e.firstRow;s<r;s++){if(c=this.session.getFoldLine(s)){if(c.containsRow(r)){r=c.start.row;break}s=c.end.row}a++}s=r;for(var c,l=(c=this.session.getNextFoldLine(s))?c.start.row:1/0;s>l&&(s=c.end.row+1,l=(c=this.session.getNextFoldLine(s,c))?c.start.row:1/0),!(s>i);){var u=o[a++];if(u){var h=[];this.$renderLine(h,s,!this.$useLineGroups(),s==l&&c),u.style.height=e.lineHeight*this.session.getRowLength(s)+"px",u.innerHTML=h.join("")}s++}},this.scrollLines=function(e){var t=this.config;if(this.config=e,!t||t.lastRow<e.firstRow)return this.update(e);if(e.lastRow<t.firstRow)return this.update(e);var n=this.element;if(t.firstRow<e.firstRow)for(var r=this.session.getFoldedRowCount(t.firstRow,e.firstRow-1);r>0;r--)n.removeChild(n.firstChild);if(t.lastRow>e.lastRow)for(r=this.session.getFoldedRowCount(e.lastRow+1,t.lastRow);r>0;r--)n.removeChild(n.lastChild);if(e.firstRow<t.firstRow){var i=this.$renderLinesFragment(e,e.firstRow,t.firstRow-1);n.firstChild?n.insertBefore(i,n.firstChild):n.appendChild(i)}if(e.lastRow>t.lastRow){i=this.$renderLinesFragment(e,t.lastRow+1,e.lastRow);n.appendChild(i)}},this.$renderLinesFragment=function(e,t,n){for(var r=this.element.ownerDocument.createDocumentFragment(),o=t,a=this.session.getNextFoldLine(o),s=a?a.start.row:1/0;o>s&&(o=a.end.row+1,s=(a=this.session.getNextFoldLine(o,a))?a.start.row:1/0),!(o>n);){var c=i.createElement("div"),l=[];if(this.$renderLine(l,o,!1,o==s&&a),c.innerHTML=l.join(""),this.$useLineGroups())c.className="ace_line_group",r.appendChild(c),c.style.height=e.lineHeight*this.session.getRowLength(o)+"px";else for(;c.firstChild;)r.appendChild(c.firstChild);o++}return r},this.update=function(e){this.config=e;for(var t=[],n=e.firstRow,r=e.lastRow,i=n,o=this.session.getNextFoldLine(i),a=o?o.start.row:1/0;i>a&&(i=o.end.row+1,a=(o=this.session.getNextFoldLine(i,o))?o.start.row:1/0),!(i>r);)this.$useLineGroups()&&t.push("<div class='ace_line_group' style='height:",e.lineHeight*this.session.getRowLength(i),"px'>"),this.$renderLine(t,i,!1,i==a&&o),this.$useLineGroups()&&t.push("</div>"),i++;this.element.innerHTML=t.join("")},this.$textToken={text:!0,rparen:!0,lparen:!0},this.$renderToken=function(e,t,n,r){var i=this,a=r.replace(/\t|&|<|>|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\u3000\uFEFF\uFFF9-\uFFFC])|[\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3000-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF]/g,(function(e,n,r,a,s){if(n)return i.showInvisibles?"<span class='ace_invisible ace_invisible_space'>"+o.stringRepeat(i.SPACE_CHAR,e.length)+"</span>":e;if("&"==e)return"&#38;";if("<"==e)return"&#60;";if(">"==e)return"&#62;";if("\t"==e){var c=i.session.getScreenTabSize(t+a);return t+=c-1,i.$tabStrings[c]}if("　"==e){var l=i.showInvisibles?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",u=i.showInvisibles?i.SPACE_CHAR:"";return t+=1,"<span class='"+l+"' style='width:"+2*i.config.characterWidth+"px'>"+u+"</span>"}return r?"<span class='ace_invisible ace_invisible_space ace_invalid'>"+i.SPACE_CHAR+"</span>":(t+=1,"<span class='ace_cjk' style='width:"+2*i.config.characterWidth+"px'>"+e+"</span>")}));if(this.$textToken[n.type])e.push(a);else{var s="ace_"+n.type.replace(/\./g," ace_"),c="";"fold"==n.type&&(c=" style='width:"+n.value.length*this.config.characterWidth+"px;' "),e.push("<span class='",s,"'",c,">",a,"</span>")}return t+r.length},this.renderIndentGuide=function(e,t,n){var r=t.search(this.$indentGuideRe);return r<=0||r>=n?t:" "==t[0]?(r-=r%this.tabSize,e.push(o.stringRepeat(this.$tabStrings[" "],r/this.tabSize)),t.substr(r)):"\t"==t[0]?(e.push(o.stringRepeat(this.$tabStrings["\t"],r)),t.substr(r)):t},this.$renderWrappedLine=function(e,t,n,r){for(var i=0,a=0,s=n[0],c=0,l=0;l<t.length;l++){var u=t[l],h=u.value;if(0==l&&this.displayIndentGuides){if(i=h.length,!(h=this.renderIndentGuide(e,h,s)))continue;i-=h.length}if(i+h.length<s)c=this.$renderToken(e,c,u,h),i+=h.length;else{for(;i+h.length>=s;)c=this.$renderToken(e,c,u,h.substring(0,s-i)),h=h.substring(s-i),i=s,r||e.push("</div>","<div class='ace_line' style='height:",this.config.lineHeight,"px'>"),e.push(o.stringRepeat(" ",n.indent)),c=0,s=n[++a]||Number.MAX_VALUE;0!=h.length&&(i+=h.length,c=this.$renderToken(e,c,u,h))}}},this.$renderSimpleLine=function(e,t){var n=0,r=t[0],i=r.value;this.displayIndentGuides&&(i=this.renderIndentGuide(e,i)),i&&(n=this.$renderToken(e,n,r,i));for(var o=1;o<t.length;o++)i=(r=t[o]).value,n=this.$renderToken(e,n,r,i)},this.$renderLine=function(e,t,n,r){if(r||0==r||(r=this.session.getFoldLine(t)),r)var i=this.$getFoldLineTokens(t,r);else i=this.session.getTokens(t);if(n||e.push("<div class='ace_line' style='height:",this.config.lineHeight*(this.$useLineGroups()?1:this.session.getRowLength(t)),"px'>"),i.length){var o=this.session.getRowSplitData(t);o&&o.length?this.$renderWrappedLine(e,i,o,n):this.$renderSimpleLine(e,i)}this.showInvisibles&&(r&&(t=r.end.row),e.push("<span class='ace_invisible ace_invisible_eol'>",t==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,"</span>")),n||e.push("</div>")},this.$getFoldLineTokens=function(e,t){var n=this.session,r=[];var i=n.getTokens(e);return t.walk((function(e,t,o,a,s){null!=e?r.push({type:"fold",value:e}):(s&&(i=n.getTokens(t)),i.length&&function(e,t,n){for(var i=0,o=0;o+e[i].value.length<t;)if(o+=e[i].value.length,++i==e.length)return;for(o!=t&&((a=e[i].value.substring(t-o)).length>n-t&&(a=a.substring(0,n-t)),r.push({type:e[i].type,value:a}),o=t+a.length,i+=1);o<n&&i<e.length;){var a;(a=e[i].value).length+o>n?r.push({type:e[i].type,value:a.substring(0,n-o)}):r.push(e[i]),o+=a.length,i+=1}}(i,a,o))}),t.end.row,this.session.getLine(t.end.row).length),r},this.$useLineGroups=function(){return this.session.getUseWrapMode()},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$measureNode&&this.$measureNode.parentNode.removeChild(this.$measureNode),delete this.$measureNode}}).call(s.prototype),t.Text=s})),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";var r,i=e("../lib/dom"),o=function(e){this.element=i.createElement("div"),this.element.className="ace_layer ace_cursor-layer",e.appendChild(this.element),void 0===r&&(r=!("opacity"in this.element.style)),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),i.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=(r?this.$updateVisibility:this.$updateOpacity).bind(this)};(function(){this.$updateVisibility=function(e){for(var t=this.cursors,n=t.length;n--;)t[n].style.visibility=e?"":"hidden"},this.$updateOpacity=function(e){for(var t=this.cursors,n=t.length;n--;)t[n].style.opacity=e?"":"0"},this.$padding=0,this.setPadding=function(e){this.$padding=e},this.setSession=function(e){this.session=e},this.setBlinking=function(e){e!=this.isBlinking&&(this.isBlinking=e,this.restartTimer())},this.setBlinkInterval=function(e){e!=this.blinkInterval&&(this.blinkInterval=e,this.restartTimer())},this.setSmoothBlinking=function(e){e==this.smoothBlinking||r||(this.smoothBlinking=e,i.setCssClass(this.element,"ace_smooth-blinking",e),this.$updateCursors(!0),this.$updateCursors=this.$updateOpacity.bind(this),this.restartTimer())},this.addCursor=function(){var e=i.createElement("div");return e.className="ace_cursor",this.element.appendChild(e),this.cursors.push(e),e},this.removeCursor=function(){if(this.cursors.length>1){var e=this.cursors.pop();return e.parentNode.removeChild(e),e}},this.hideCursor=function(){this.isVisible=!1,i.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.showCursor=function(){this.isVisible=!0,i.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},this.restartTimer=function(){var e=this.$updateCursors;if(clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.smoothBlinking&&i.removeCssClass(this.element,"ace_smooth-blinking"),e(!0),this.isBlinking&&this.blinkInterval&&this.isVisible){this.smoothBlinking&&setTimeout(function(){i.addCssClass(this.element,"ace_smooth-blinking")}.bind(this));var t=function(){this.timeoutId=setTimeout((function(){e(!1)}),.6*this.blinkInterval)}.bind(this);this.intervalId=setInterval((function(){e(!0),t()}),this.blinkInterval),t()}},this.getPixelPosition=function(e,t){if(!this.config||!this.session)return{left:0,top:0};e||(e=this.session.selection.getCursor());var n=this.session.documentToScreenPosition(e);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,e.row)?this.session.$bidiHandler.getPosLeft(n.column):n.column*this.config.characterWidth),top:(n.row-(t?this.config.firstRowScreen:0))*this.config.lineHeight}},this.update=function(e){this.config=e;var t=this.session.$selectionMarkers,n=0,r=0;void 0!==t&&0!==t.length||(t=[{cursor:null}]);n=0;for(var i=t.length;n<i;n++){var o=this.getPixelPosition(t[n].cursor,!0);if(!((o.top>e.height+e.offset||o.top<0)&&n>1)){var a=(this.cursors[r++]||this.addCursor()).style;this.drawCursor?this.drawCursor(a,o,e,t[n],this.session):(a.left=o.left+"px",a.top=o.top+"px",a.width=e.characterWidth+"px",a.height=e.lineHeight+"px")}}for(;this.cursors.length>r;)this.removeCursor();var s=this.session.getOverwrite();this.$setOverwrite(s),this.$pixelPos=o,this.restartTimer()},this.drawCursor=null,this.$setOverwrite=function(e){e!=this.overwrite&&(this.overwrite=e,e?i.addCssClass(this.element,"ace_overwrite-cursors"):i.removeCssClass(this.element,"ace_overwrite-cursors"))},this.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)}}).call(o.prototype),t.Cursor=o})),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./lib/dom"),o=e("./lib/event"),a=e("./lib/event_emitter").EventEmitter,s=function(e){this.element=i.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+this.classSuffix,this.inner=i.createElement("div"),this.inner.className="ace_scrollbar-inner",this.element.appendChild(this.inner),e.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,o.addListener(this.element,"scroll",this.onScroll.bind(this)),o.addListener(this.element,"mousedown",o.preventDefault)};(function(){r.implement(this,a),this.setVisible=function(e){this.element.style.display=e?"":"none",this.isVisible=e,this.coeff=1}}).call(s.prototype);var c=function(e,t){s.call(this,e),this.scrollTop=0,this.scrollHeight=0,t.$scrollbarWidth=this.width=i.scrollbarWidth(e.ownerDocument),this.inner.style.width=this.element.style.width=(this.width||15)+5+"px",this.$minWidth=0};r.inherits(c,s),function(){this.classSuffix="-v",this.onScroll=function(){if(!this.skipEvent){if(this.scrollTop=this.element.scrollTop,1!=this.coeff){var e=this.element.clientHeight/this.scrollHeight;this.scrollTop=this.scrollTop*(1-e)/(this.coeff-e)}this._emit("scroll",{data:this.scrollTop})}this.skipEvent=!1},this.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},this.setHeight=function(e){this.element.style.height=e+"px"},this.setInnerHeight=this.setScrollHeight=function(e){this.scrollHeight=e,e>32768?(this.coeff=32768/e,e=32768):1!=this.coeff&&(this.coeff=1),this.inner.style.height=e+"px"},this.setScrollTop=function(e){this.scrollTop!=e&&(this.skipEvent=!0,this.scrollTop=e,this.element.scrollTop=e*this.coeff)}}.call(c.prototype);var l=function(e,t){s.call(this,e),this.scrollLeft=0,this.height=t.$scrollbarWidth,this.inner.style.height=this.element.style.height=(this.height||15)+5+"px"};r.inherits(l,s),function(){this.classSuffix="-h",this.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},this.getHeight=function(){return this.isVisible?this.height:0},this.setWidth=function(e){this.element.style.width=e+"px"},this.setInnerWidth=function(e){this.inner.style.width=e+"px"},this.setScrollWidth=function(e){this.inner.style.width=e+"px"},this.setScrollLeft=function(e){this.scrollLeft!=e&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=e)}}.call(l.prototype),t.ScrollBar=c,t.ScrollBarV=c,t.ScrollBarH=l,t.VScrollBar=c,t.HScrollBar=l})),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],(function(e,t,n){"use strict";var r=e("./lib/event"),i=function(e,t){this.onRender=e,this.pending=!1,this.changes=0,this.window=t||window};(function(){this.schedule=function(e){if(this.changes=this.changes|e,!this.pending&&this.changes){this.pending=!0;var t=this;r.nextFrame((function(){var e;for(t.pending=!1;e=t.changes;)t.changes=0,t.onRender(e)}),this.window)}}}).call(i.prototype),t.RenderLoop=i})),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/lib/event_emitter"],(function(e,t,n){var r=e("../lib/oop"),i=e("../lib/dom"),o=e("../lib/lang"),a=e("../lib/useragent"),s=e("../lib/event_emitter").EventEmitter,c=0,l=t.FontMetrics=function(e){this.el=i.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=i.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=i.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),e.appendChild(this.el),c||this.$testFractionalRect(),this.$measureNode.innerHTML=o.stringRepeat("X",c),this.$characterSize={width:0,height:0},this.checkForSizeChanges()};(function(){r.implement(this,s),this.$characterSize={width:0,height:0},this.$testFractionalRect=function(){var e=i.createElement("div");this.$setMeasureNodeStyles(e.style),e.style.width="0.2px",document.documentElement.appendChild(e);var t=e.getBoundingClientRect().width;c=t>0&&t<1?50:100,e.parentNode.removeChild(e)},this.$setMeasureNodeStyles=function(e,t){e.width=e.height="auto",e.left=e.top="0px",e.visibility="hidden",e.position="absolute",e.whiteSpace="pre",a.isIE<8?e["font-family"]="inherit":e.font="inherit",e.overflow=t?"hidden":"visible"},this.checkForSizeChanges=function(){var e=this.$measureSizes();if(e&&(this.$characterSize.width!==e.width||this.$characterSize.height!==e.height)){this.$measureNode.style.fontWeight="bold";var t=this.$measureSizes();this.$measureNode.style.fontWeight="",this.$characterSize=e,this.charSizes=Object.create(null),this.allowBoldFonts=t&&t.width===e.width&&t.height===e.height,this._emit("changeCharacterSize",{data:e})}},this.$pollSizeChanges=function(){if(this.$pollSizeChangesTimer)return this.$pollSizeChangesTimer;var e=this;return this.$pollSizeChangesTimer=setInterval((function(){e.checkForSizeChanges()}),500)},this.setPolling=function(e){e?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},this.$measureSizes=function(){if(50===c){var e=null;try{e=this.$measureNode.getBoundingClientRect()}catch(t){e={width:0,height:0}}var t={height:e.height,width:e.width/c}}else t={height:this.$measureNode.clientHeight,width:this.$measureNode.clientWidth/c};return 0===t.width||0===t.height?null:t},this.$measureCharWidth=function(e){return this.$main.innerHTML=o.stringRepeat(e,c),this.$main.getBoundingClientRect().width/c},this.getCharacterWidth=function(e){var t=this.charSizes[e];return void 0===t&&(t=this.charSizes[e]=this.$measureCharWidth(e)/this.$characterSize.width),t},this.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)}}).call(l.prototype)})),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/config","ace/lib/useragent","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter"],(function(e,t,n){"use strict";var r=e("./lib/oop"),i=e("./lib/dom"),o=e("./config"),a=e("./lib/useragent"),s=e("./layer/gutter").Gutter,c=e("./layer/marker").Marker,l=e("./layer/text").Text,u=e("./layer/cursor").Cursor,h=e("./scrollbar").HScrollBar,d=e("./scrollbar").VScrollBar,f=e("./renderloop").RenderLoop,p=e("./layer/font_metrics").FontMetrics,m=e("./lib/event_emitter").EventEmitter;i.importCssString('.ace_editor {position: relative;overflow: hidden;font: 12px/normal \'Monaco\', \'Menlo\', \'Ubuntu Mono\', \'Consolas\', \'source-code-pro\', monospace;direction: ltr;text-align: left;-webkit-tap-highlight-color: rgba(0, 0, 0, 0);}.ace_scroller {position: absolute;overflow: hidden;top: 0;bottom: 0;background-color: inherit;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;cursor: text;}.ace_content {position: absolute;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;min-width: 100%;}.ace_dragging .ace_scroller:before{position: absolute;top: 0;left: 0;right: 0;bottom: 0;content: \'\';background: rgba(250, 250, 250, 0.01);z-index: 1000;}.ace_dragging.ace_dark .ace_scroller:before{background: rgba(0, 0, 0, 0.01);}.ace_selecting, .ace_selecting * {cursor: text !important;}.ace_gutter {position: absolute;overflow : hidden;width: auto;top: 0;bottom: 0;left: 0;cursor: default;z-index: 4;-ms-user-select: none;-moz-user-select: none;-webkit-user-select: none;user-select: none;}.ace_gutter-active-line {position: absolute;left: 0;right: 0;}.ace_scroller.ace_scroll-left {box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;}.ace_gutter-cell {padding-left: 19px;padding-right: 6px;background-repeat: no-repeat;}.ace_gutter-cell.ace_error {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: 2px center;}.ace_gutter-cell.ace_warning {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");background-position: 2px center;}.ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");background-position: 2px center;}.ace_dark .ace_gutter-cell.ace_info {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");}.ace_scrollbar {position: absolute;right: 0;bottom: 0;z-index: 6;}.ace_scrollbar-inner {position: absolute;cursor: text;left: 0;top: 0;}.ace_scrollbar-v{overflow-x: hidden;overflow-y: scroll;top: 0;}.ace_scrollbar-h {overflow-x: scroll;overflow-y: hidden;left: 0;}.ace_print-margin {position: absolute;height: 100%;}.ace_text-input {position: absolute;z-index: 0;width: 0.5em;height: 1em;opacity: 0;background: transparent;-moz-appearance: none;appearance: none;border: none;resize: none;outline: none;overflow: hidden;font: inherit;padding: 0 1px;margin: 0 -1px;text-indent: -1em;-ms-user-select: text;-moz-user-select: text;-webkit-user-select: text;user-select: text;white-space: pre!important;}.ace_text-input.ace_composition {background: inherit;color: inherit;z-index: 1000;opacity: 1;text-indent: 0;}.ace_layer {z-index: 1;position: absolute;overflow: hidden;word-wrap: normal;white-space: pre;height: 100%;width: 100%;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;pointer-events: none;}.ace_gutter-layer {position: relative;width: auto;text-align: right;pointer-events: auto;}.ace_text-layer {font: inherit !important;}.ace_cjk {display: inline-block;text-align: center;}.ace_cursor-layer {z-index: 4;}.ace_cursor {z-index: 4;position: absolute;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;border-left: 2px solid;transform: translatez(0);}.ace_multiselect .ace_cursor {border-left-width: 1px;}.ace_slim-cursors .ace_cursor {border-left-width: 1px;}.ace_overwrite-cursors .ace_cursor {border-left-width: 0;border-bottom: 1px solid;}.ace_hidden-cursors .ace_cursor {opacity: 0.2;}.ace_smooth-blinking .ace_cursor {-webkit-transition: opacity 0.18s;transition: opacity 0.18s;}.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {position: absolute;z-index: 3;}.ace_marker-layer .ace_selection {position: absolute;z-index: 5;}.ace_marker-layer .ace_bracket {position: absolute;z-index: 6;}.ace_marker-layer .ace_active-line {position: absolute;z-index: 2;}.ace_marker-layer .ace_selected-word {position: absolute;z-index: 4;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;}.ace_line .ace_fold {-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;display: inline-block;height: 11px;margin-top: -2px;vertical-align: middle;background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");background-repeat: no-repeat, repeat-x;background-position: center center, top left;color: transparent;border: 1px solid black;border-radius: 2px;cursor: pointer;pointer-events: auto;}.ace_dark .ace_fold {}.ace_fold:hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");}.ace_tooltip {background-color: #FFF;background-image: -webkit-linear-gradient(top, transparent, rgba(0, 0, 0, 0.1));background-image: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.1));border: 1px solid gray;border-radius: 1px;box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);color: black;max-width: 100%;padding: 3px 4px;position: fixed;z-index: 999999;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;cursor: default;white-space: pre;word-wrap: break-word;line-height: normal;font-style: normal;font-weight: normal;letter-spacing: normal;pointer-events: none;}.ace_folding-enabled > .ace_gutter-cell {padding-right: 13px;}.ace_fold-widget {-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;margin: 0 -12px 0 1px;display: none;width: 11px;vertical-align: top;background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");background-repeat: no-repeat;background-position: center;border-radius: 3px;border: 1px solid transparent;cursor: pointer;}.ace_folding-enabled .ace_fold-widget {display: inline-block;   }.ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");}.ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");}.ace_fold-widget:hover {border: 1px solid rgba(0, 0, 0, 0.3);background-color: rgba(255, 255, 255, 0.2);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);}.ace_fold-widget:active {border: 1px solid rgba(0, 0, 0, 0.4);background-color: rgba(0, 0, 0, 0.05);box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);}.ace_dark .ace_fold-widget {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");}.ace_dark .ace_fold-widget.ace_end {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget.ace_closed {background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");}.ace_dark .ace_fold-widget:hover {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);background-color: rgba(255, 255, 255, 0.1);}.ace_dark .ace_fold-widget:active {box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);}.ace_fold-widget.ace_invalid {background-color: #FFB4B4;border-color: #DE5555;}.ace_fade-fold-widgets .ace_fold-widget {-webkit-transition: opacity 0.4s ease 0.05s;transition: opacity 0.4s ease 0.05s;opacity: 0;}.ace_fade-fold-widgets:hover .ace_fold-widget {-webkit-transition: opacity 0.05s ease 0.05s;transition: opacity 0.05s ease 0.05s;opacity:1;}.ace_underline {text-decoration: underline;}.ace_bold {font-weight: bold;}.ace_nobold .ace_bold {font-weight: normal;}.ace_italic {font-style: italic;}.ace_error-marker {background-color: rgba(255, 0, 0,0.2);position: absolute;z-index: 9;}.ace_highlight-marker {background-color: rgba(255, 255, 0,0.2);position: absolute;z-index: 8;}.ace_br1 {border-top-left-radius    : 3px;}.ace_br2 {border-top-right-radius   : 3px;}.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}.ace_br4 {border-bottom-right-radius: 3px;}.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}.ace_br8 {border-bottom-left-radius : 3px;}.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}.ace_text-input-ios {position: absolute !important;top: -100000px !important;left: -100000px !important;}',"ace_editor.css");var g=function(e,t){var n=this;this.container=e||i.createElement("div"),this.$keepTextAreaAtCursor=!a.isOldIE,i.addCssClass(this.container,"ace_editor"),this.setTheme(t),this.$gutter=i.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=i.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=i.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new s(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new c(this.content);var r=this.$textLayer=new l(this.content);this.canvas=r.element,this.$markerFront=new c(this.content),this.$cursorLayer=new u(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new d(this.container,this),this.scrollBarH=new h(this.container,this),this.scrollBarV.addEventListener("scroll",(function(e){n.$scrollAnimation||n.session.setScrollTop(e.data-n.scrollMargin.top)})),this.scrollBarH.addEventListener("scroll",(function(e){n.$scrollAnimation||n.session.setScrollLeft(e.data-n.scrollMargin.left)})),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new p(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.addEventListener("changeCharacterSize",(function(e){n.updateCharacterSize(),n.onResize(!0,n.gutterWidth,n.$size.width,n.$size.height),n._signal("changeCharacterSize",e)})),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$loop=new f(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),o.resetOptions(this),o._emit("renderer",this)};(function(){this.CHANGE_CURSOR=1,this.CHANGE_MARKER=2,this.CHANGE_GUTTER=4,this.CHANGE_SCROLL=8,this.CHANGE_LINES=16,this.CHANGE_TEXT=32,this.CHANGE_SIZE=64,this.CHANGE_MARKER_BACK=128,this.CHANGE_MARKER_FRONT=256,this.CHANGE_FULL=512,this.CHANGE_H_SCROLL=1024,r.implement(this,m),this.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin()},this.setSession=function(e){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),this.session=e,e&&this.scrollMargin.top&&e.getScrollTop()<=0&&e.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(e),this.$markerBack.setSession(e),this.$markerFront.setSession(e),this.$gutterLayer.setSession(e),this.$textLayer.setSession(e),e&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},this.updateLines=function(e,t,n){if(void 0===t&&(t=1/0),this.$changedLines?(this.$changedLines.firstRow>e&&(this.$changedLines.firstRow=e),this.$changedLines.lastRow<t&&(this.$changedLines.lastRow=t)):this.$changedLines={firstRow:e,lastRow:t},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!n)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},this.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},this.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},this.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},this.updateFull=function(e){e?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},this.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},this.$changes=0,this.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},this.onResize=function(e,t,n,r){if(!(this.resizing>2)){this.resizing>0?this.resizing++:this.resizing=e?1:0;var i=this.container;r||(r=i.clientHeight||i.scrollHeight),n||(n=i.clientWidth||i.scrollWidth);var o=this.$updateCachedSize(e,t,n,r);if(!this.$size.scrollerHeight||!n&&!r)return this.resizing=0;e&&(this.$gutterLayer.$padding=null),e?this.$renderChanges(o|this.$changes,!0):this.$loop.schedule(o|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarV.scrollLeft=this.scrollBarV.scrollTop=null}},this.$updateCachedSize=function(e,t,n,r){r-=this.$extraHeight||0;var i=0,o=this.$size,a={width:o.width,height:o.height,scrollerHeight:o.scrollerHeight,scrollerWidth:o.scrollerWidth};return r&&(e||o.height!=r)&&(o.height=r,i|=this.CHANGE_SIZE,o.scrollerHeight=o.height,this.$horizScroll&&(o.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",i|=this.CHANGE_SCROLL),n&&(e||o.width!=n)&&(i|=this.CHANGE_SIZE,o.width=n,null==t&&(t=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=t,this.scrollBarH.element.style.left=this.scroller.style.left=t+"px",o.scrollerWidth=Math.max(0,n-t-this.scrollBarV.getWidth()),this.scrollBarH.element.style.right=this.scroller.style.right=this.scrollBarV.getWidth()+"px",this.scroller.style.bottom=this.scrollBarH.getHeight()+"px",(this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||e)&&(i|=this.CHANGE_FULL)),o.$dirty=!n||!r,i&&this._signal("resize",a),i},this.onGutterResize=function(){var e=this.$showGutter?this.$gutter.offsetWidth:0;e!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,e,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):(this.$computeLayerConfig(),this.$loop.schedule(this.CHANGE_MARKER))},this.adjustWrapLimit=function(){var e=this.$size.scrollerWidth-2*this.$padding,t=Math.floor(e/this.characterWidth);return this.session.adjustWrapLimit(t,this.$showPrintMargin&&this.$printMarginColumn)},this.setAnimatedScroll=function(e){this.setOption("animatedScroll",e)},this.getAnimatedScroll=function(){return this.$animatedScroll},this.setShowInvisibles=function(e){this.setOption("showInvisibles",e),this.session.$bidiHandler.setShowInvisibles(e)},this.getShowInvisibles=function(){return this.getOption("showInvisibles")},this.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},this.setDisplayIndentGuides=function(e){this.setOption("displayIndentGuides",e)},this.setShowPrintMargin=function(e){this.setOption("showPrintMargin",e)},this.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},this.setPrintMarginColumn=function(e){this.setOption("printMarginColumn",e)},this.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},this.getShowGutter=function(){return this.getOption("showGutter")},this.setShowGutter=function(e){return this.setOption("showGutter",e)},this.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},this.setFadeFoldWidgets=function(e){this.setOption("fadeFoldWidgets",e)},this.setHighlightGutterLine=function(e){this.setOption("highlightGutterLine",e)},this.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},this.$updateGutterLineHighlight=function(){var e=this.$cursorLayer.$pixelPos,t=this.layerConfig.lineHeight;if(this.session.getUseWrapMode()){var n=this.session.selection.getCursor();n.column=0,e=this.$cursorLayer.getPixelPosition(n,!0),t*=this.session.getRowLength(n.row)}this.$gutterLineHighlight.style.top=e.top-this.layerConfig.offset+"px",this.$gutterLineHighlight.style.height=t+"px"},this.$updatePrintMargin=function(){if(this.$showPrintMargin||this.$printMarginEl){if(!this.$printMarginEl){var e=i.createElement("div");e.className="ace_layer ace_print-margin-layer",this.$printMarginEl=i.createElement("div"),this.$printMarginEl.className="ace_print-margin",e.appendChild(this.$printMarginEl),this.content.insertBefore(e,this.content.firstChild)}var t=this.$printMarginEl.style;t.left=this.characterWidth*this.$printMarginColumn+this.$padding+"px",t.visibility=this.$showPrintMargin?"visible":"hidden",this.session&&-1==this.session.$wrap&&this.adjustWrapLimit()}},this.getContainerElement=function(){return this.container},this.getMouseEventTarget=function(){return this.scroller},this.getTextAreaContainer=function(){return this.container},this.$moveTextAreaToCursor=function(){if(this.$keepTextAreaAtCursor){var e=this.layerConfig,t=this.$cursorLayer.$pixelPos.top,n=this.$cursorLayer.$pixelPos.left;t-=e.offset;var r=this.textarea.style,i=this.lineHeight;if(t<0||t>e.height-i)r.top=r.left="0";else{var o=this.characterWidth;if(this.$composition){var a=this.textarea.value.replace(/^\x01+/,"");o*=this.session.$getStringScreenWidth(a)[0]+2,i+=2}(n-=this.scrollLeft)>this.$size.scrollerWidth-o&&(n=this.$size.scrollerWidth-o),n+=this.gutterWidth,r.height=i+"px",r.width=o+"px",r.left=Math.min(n,this.$size.scrollerWidth-o)+"px",r.top=Math.min(t,this.$size.height-i)+"px"}}},this.getFirstVisibleRow=function(){return this.layerConfig.firstRow},this.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(0===this.layerConfig.offset?0:1)},this.getLastFullyVisibleRow=function(){var e=this.layerConfig,t=e.lastRow;return this.session.documentToScreenRow(t,0)*e.lineHeight-this.session.getScrollTop()>e.height-e.lineHeight?t-1:t},this.getLastVisibleRow=function(){return this.layerConfig.lastRow},this.$padding=null,this.setPadding=function(e){this.$padding=e,this.$textLayer.setPadding(e),this.$cursorLayer.setPadding(e),this.$markerFront.setPadding(e),this.$markerBack.setPadding(e),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},this.setScrollMargin=function(e,t,n,r){var i=this.scrollMargin;i.top=0|e,i.bottom=0|t,i.right=0|r,i.left=0|n,i.v=i.top+i.bottom,i.h=i.left+i.right,i.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-i.top),this.updateFull()},this.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},this.setHScrollBarAlwaysVisible=function(e){this.setOption("hScrollBarAlwaysVisible",e)},this.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},this.setVScrollBarAlwaysVisible=function(e){this.setOption("vScrollBarAlwaysVisible",e)},this.$updateScrollBarV=function(){var e=this.layerConfig.maxHeight,t=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(e-=(t-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>e-t&&(e=this.scrollTop+t,this.scrollBarV.scrollTop=null)),this.scrollBarV.setScrollHeight(e+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},this.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},this.$frozen=!1,this.freeze=function(){this.$frozen=!0},this.unfreeze=function(){this.$frozen=!1},this.$renderChanges=function(e,t){if(this.$changes&&(e|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(e||t)){if(this.$size.$dirty)return this.$changes|=e,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender"),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var n=this.layerConfig;if(e&this.CHANGE_FULL||e&this.CHANGE_SIZE||e&this.CHANGE_TEXT||e&this.CHANGE_LINES||e&this.CHANGE_SCROLL||e&this.CHANGE_H_SCROLL){if(e|=this.$computeLayerConfig(),n.firstRow!=this.layerConfig.firstRow&&n.firstRowScreen==this.layerConfig.firstRowScreen){var r=this.scrollTop+(n.firstRow-this.layerConfig.firstRow)*this.lineHeight;r>0&&(this.scrollTop=r,e|=this.CHANGE_SCROLL,e|=this.$computeLayerConfig())}n=this.layerConfig,this.$updateScrollBarV(),e&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),this.$gutterLayer.element.style.marginTop=-n.offset+"px",this.content.style.marginTop=-n.offset+"px",this.content.style.width=n.width+2*this.$padding+"px",this.content.style.height=n.minHeight+"px"}if(e&this.CHANGE_H_SCROLL&&(this.content.style.marginLeft=-this.scrollLeft+"px",this.scroller.className=this.scrollLeft<=0?"ace_scroller":"ace_scroller ace_scroll-left"),e&this.CHANGE_FULL)return this.$textLayer.update(n),this.$showGutter&&this.$gutterLayer.update(n),this.$markerBack.update(n),this.$markerFront.update(n),this.$cursorLayer.update(n),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),void this._signal("afterRender");if(e&this.CHANGE_SCROLL)return e&this.CHANGE_TEXT||e&this.CHANGE_LINES?this.$textLayer.update(n):this.$textLayer.scrollLines(n),this.$showGutter&&this.$gutterLayer.update(n),this.$markerBack.update(n),this.$markerFront.update(n),this.$cursorLayer.update(n),this.$highlightGutterLine&&this.$updateGutterLineHighlight(),this.$moveTextAreaToCursor(),void this._signal("afterRender");e&this.CHANGE_TEXT?(this.$textLayer.update(n),this.$showGutter&&this.$gutterLayer.update(n)):e&this.CHANGE_LINES?(this.$updateLines()||e&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(n):(e&this.CHANGE_TEXT||e&this.CHANGE_GUTTER)&&this.$showGutter&&this.$gutterLayer.update(n),e&this.CHANGE_CURSOR&&(this.$cursorLayer.update(n),this.$moveTextAreaToCursor(),this.$highlightGutterLine&&this.$updateGutterLineHighlight()),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(n),e&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(n),this._signal("afterRender")}else this.$changes|=e},this.$autosize=function(){var e=this.session.getScreenLength()*this.lineHeight,t=this.$maxLines*this.lineHeight,n=Math.min(t,Math.max((this.$minLines||1)*this.lineHeight,e))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(n+=this.scrollBarH.getHeight()),this.$maxPixelHeight&&n>this.$maxPixelHeight&&(n=this.$maxPixelHeight);var r=e>t;if(n!=this.desiredHeight||this.$size.height!=this.desiredHeight||r!=this.$vScroll){r!=this.$vScroll&&(this.$vScroll=r,this.scrollBarV.setVisible(r));var i=this.container.clientWidth;this.container.style.height=n+"px",this.$updateCachedSize(!0,this.$gutterWidth,i,n),this.desiredHeight=n,this._signal("autosize")}},this.$computeLayerConfig=function(){var e=this.session,t=this.$size,n=t.height<=2*this.lineHeight,r=this.session.getScreenLength()*this.lineHeight,i=this.$getLongestLine(),o=!n&&(this.$hScrollBarAlwaysVisible||t.scrollerWidth-i-2*this.$padding<0),a=this.$horizScroll!==o;a&&(this.$horizScroll=o,this.scrollBarH.setVisible(o));var s=this.$vScroll;this.$maxLines&&this.lineHeight>1&&this.$autosize();var c=this.scrollTop%this.lineHeight,l=t.scrollerHeight+this.lineHeight,u=!this.$maxLines&&this.$scrollPastEnd?(t.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0;r+=u;var h=this.scrollMargin;this.session.setScrollTop(Math.max(-h.top,Math.min(this.scrollTop,r-t.scrollerHeight+h.bottom))),this.session.setScrollLeft(Math.max(-h.left,Math.min(this.scrollLeft,i+2*this.$padding-t.scrollerWidth+h.right)));var d=!n&&(this.$vScrollBarAlwaysVisible||t.scrollerHeight-r+u<0||this.scrollTop>h.top),f=s!==d;f&&(this.$vScroll=d,this.scrollBarV.setVisible(d));var p,m,g=Math.ceil(l/this.lineHeight)-1,v=Math.max(0,Math.round((this.scrollTop-c)/this.lineHeight)),y=v+g,b=this.lineHeight;v=e.screenToDocumentRow(v,0);var w=e.getFoldLine(v);w&&(v=w.start.row),p=e.documentToScreenRow(v,0),m=e.getRowLength(v)*b,y=Math.min(e.screenToDocumentRow(y,0),e.getLength()-1),l=t.scrollerHeight+e.getRowLength(y)*b+m,c=this.scrollTop-p*b;var x=0;return this.layerConfig.width!=i&&(x=this.CHANGE_H_SCROLL),(a||f)&&(x=this.$updateCachedSize(!0,this.gutterWidth,t.width,t.height),this._signal("scrollbarVisibilityChanged"),f&&(i=this.$getLongestLine())),this.layerConfig={width:i,padding:this.$padding,firstRow:v,firstRowScreen:p,lastRow:y,lineHeight:b,characterWidth:this.characterWidth,minHeight:l,maxHeight:r,offset:c,gutterOffset:b?Math.max(0,Math.ceil((c+t.height-t.scrollerHeight)/b)):0,height:this.$size.scrollerHeight},x},this.$updateLines=function(){if(this.$changedLines){var e=this.$changedLines.firstRow,t=this.$changedLines.lastRow;this.$changedLines=null;var n=this.layerConfig;if(!(e>n.lastRow+1||t<n.firstRow))return t===1/0?(this.$showGutter&&this.$gutterLayer.update(n),void this.$textLayer.update(n)):(this.$textLayer.updateLines(n,e,t),!0)}},this.$getLongestLine=function(){var e=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(e+=1),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(e*this.characterWidth))},this.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},this.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},this.addGutterDecoration=function(e,t){this.$gutterLayer.addGutterDecoration(e,t)},this.removeGutterDecoration=function(e,t){this.$gutterLayer.removeGutterDecoration(e,t)},this.updateBreakpoints=function(e){this.$loop.schedule(this.CHANGE_GUTTER)},this.setAnnotations=function(e){this.$gutterLayer.setAnnotations(e),this.$loop.schedule(this.CHANGE_GUTTER)},this.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},this.hideCursor=function(){this.$cursorLayer.hideCursor()},this.showCursor=function(){this.$cursorLayer.showCursor()},this.scrollSelectionIntoView=function(e,t,n){this.scrollCursorIntoView(e,n),this.scrollCursorIntoView(t,n)},this.scrollCursorIntoView=function(e,t,n){if(0!==this.$size.scrollerHeight){var r=this.$cursorLayer.getPixelPosition(e),i=r.left,o=r.top,a=n&&n.top||0,s=n&&n.bottom||0,c=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop;c+a>o?(t&&c+a>o+this.lineHeight&&(o-=t*this.$size.scrollerHeight),0===o&&(o=-this.scrollMargin.top),this.session.setScrollTop(o)):c+this.$size.scrollerHeight-s<o+this.lineHeight&&(t&&c+this.$size.scrollerHeight-s<o-this.lineHeight&&(o+=t*this.$size.scrollerHeight),this.session.setScrollTop(o+this.lineHeight-this.$size.scrollerHeight));var l=this.scrollLeft;l>i?(i<this.$padding+2*this.layerConfig.characterWidth&&(i=-this.scrollMargin.left),this.session.setScrollLeft(i)):l+this.$size.scrollerWidth<i+this.characterWidth?this.session.setScrollLeft(Math.round(i+this.characterWidth-this.$size.scrollerWidth)):l<=this.$padding&&i-l<this.characterWidth&&this.session.setScrollLeft(0)}},this.getScrollTop=function(){return this.session.getScrollTop()},this.getScrollLeft=function(){return this.session.getScrollLeft()},this.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},this.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},this.scrollToRow=function(e){this.session.setScrollTop(e*this.lineHeight)},this.alignCursor=function(e,t){"number"==typeof e&&(e={row:e,column:0});var n=this.$cursorLayer.getPixelPosition(e),r=this.$size.scrollerHeight-this.lineHeight,i=n.top-r*(t||0);return this.session.setScrollTop(i),i},this.STEPS=8,this.$calcSteps=function(e,t){var n,r,i=0,o=this.STEPS,a=[];for(i=0;i<o;++i)a.push((n=i/this.STEPS,r=e,(t-e)*(Math.pow(n-1,3)+1)+r));return a},this.scrollToLine=function(e,t,n,r){var i=this.$cursorLayer.getPixelPosition({row:e,column:0}).top;t&&(i-=this.$size.scrollerHeight/2);var o=this.scrollTop;this.session.setScrollTop(i),!1!==n&&this.animateScrolling(o,r)},this.animateScrolling=function(e,t){var n=this.scrollTop;if(this.$animatedScroll){var r=this;if(e!=n){if(this.$scrollAnimation){var i=this.$scrollAnimation.steps;if(i.length&&(e=i[0])==n)return}var o=r.$calcSteps(e,n);this.$scrollAnimation={from:e,to:n,steps:o},clearInterval(this.$timer),r.session.setScrollTop(o.shift()),r.session.$scrollTop=n,this.$timer=setInterval((function(){o.length?(r.session.setScrollTop(o.shift()),r.session.$scrollTop=n):null!=n?(r.session.$scrollTop=-1,r.session.setScrollTop(n),n=null):(r.$timer=clearInterval(r.$timer),r.$scrollAnimation=null,t&&t())}),10)}}},this.scrollToY=function(e){this.scrollTop!==e&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=e)},this.scrollToX=function(e){this.scrollLeft!==e&&(this.scrollLeft=e),this.$loop.schedule(this.CHANGE_H_SCROLL)},this.scrollTo=function(e,t){this.session.setScrollTop(t),this.session.setScrollLeft(t)},this.scrollBy=function(e,t){t&&this.session.setScrollTop(this.session.getScrollTop()+t),e&&this.session.setScrollLeft(this.session.getScrollLeft()+e)},this.isScrollableBy=function(e,t){return t<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||(t>0&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||(e<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||(e>0&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0)))},this.pixelToScreenCoordinates=function(e,t){var n=this.scroller.getBoundingClientRect(),r=e+this.scrollLeft-n.left-this.$padding,i=r/this.characterWidth,o=Math.floor((t+this.scrollTop-n.top)/this.lineHeight),a=Math.round(i);return{row:o,column:a,side:i-a>0?1:-1,offsetX:r}},this.screenToTextCoordinates=function(e,t){var n=this.scroller.getBoundingClientRect(),r=e+this.scrollLeft-n.left-this.$padding,i=Math.round(r/this.characterWidth),o=(t+this.scrollTop-n.top)/this.lineHeight;return this.session.screenToDocumentPosition(o,Math.max(i,0),r)},this.textToScreenCoordinates=function(e,t){var n=this.scroller.getBoundingClientRect(),r=this.session.documentToScreenPosition(e,t),i=this.$padding+(this.session.$bidiHandler.isBidiRow(r.row,e)?this.session.$bidiHandler.getPosLeft(r.column):Math.round(r.column*this.characterWidth)),o=r.row*this.lineHeight;return{pageX:n.left+i-this.scrollLeft,pageY:n.top+o-this.scrollTop}},this.visualizeFocus=function(){i.addCssClass(this.container,"ace_focus")},this.visualizeBlur=function(){i.removeCssClass(this.container,"ace_focus")},this.showComposition=function(e){this.$composition||(this.$composition={keepTextAreaAtCursor:this.$keepTextAreaAtCursor,cssText:this.textarea.style.cssText}),this.$keepTextAreaAtCursor=!0,i.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor()},this.setCompositionText=function(e){this.$moveTextAreaToCursor()},this.hideComposition=function(){this.$composition&&(i.removeCssClass(this.textarea,"ace_composition"),this.$keepTextAreaAtCursor=this.$composition.keepTextAreaAtCursor,this.textarea.style.cssText=this.$composition.cssText,this.$composition=null)},this.setTheme=function(e,t){var n=this;if(this.$themeId=e,n._dispatchEvent("themeChange",{theme:e}),e&&"string"!=typeof e)a(e);else{var r=e||this.$options.theme.initialValue;o.loadModule(["theme",r],a)}function a(r){if(n.$themeId!=e)return t&&t();if(!r||!r.cssClass)throw new Error("couldn't load module "+e+" or it didn't call define");i.importCssString(r.cssText,r.cssClass,n.container.ownerDocument),n.theme&&i.removeCssClass(n.container,n.theme.cssClass);var o="padding"in r?r.padding:"padding"in(n.theme||{})?4:n.$padding;n.$padding&&o!=n.$padding&&n.setPadding(o),n.$theme=r.cssClass,n.theme=r,i.addCssClass(n.container,r.cssClass),i.setCssClass(n.container,"ace_dark",r.isDark),n.$size&&(n.$size.width=0,n.$updateSizeAsync()),n._dispatchEvent("themeLoaded",{theme:r}),t&&t()}},this.getTheme=function(){return this.$themeId},this.setStyle=function(e,t){i.setCssClass(this.container,e,!1!==t)},this.unsetStyle=function(e){i.removeCssClass(this.container,e)},this.setCursorStyle=function(e){this.scroller.style.cursor!=e&&(this.scroller.style.cursor=e)},this.setMouseCursor=function(e){this.scroller.style.cursor=e},this.destroy=function(){this.$textLayer.destroy(),this.$cursorLayer.destroy()}}).call(g.prototype),o.defineOptions(g.prototype,"renderer",{animatedScroll:{initialValue:!1},showInvisibles:{set:function(e){this.$textLayer.setShowInvisibles(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(e){"number"==typeof e&&(this.$printMarginColumn=e),this.$showPrintMargin=!!e,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(e){this.$gutter.style.display=e?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},fadeFoldWidgets:{set:function(e){i.setCssClass(this.$gutter,"ace_fade-fold-widgets",e)},initialValue:!1},showFoldWidgets:{set:function(e){this.$gutterLayer.setShowFoldWidgets(e)},initialValue:!0},showLineNumbers:{set:function(e){this.$gutterLayer.setShowLineNumbers(e),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(e){this.$textLayer.setDisplayIndentGuides(e)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightGutterLine:{set:function(e){if(!this.$gutterLineHighlight)return this.$gutterLineHighlight=i.createElement("div"),this.$gutterLineHighlight.className="ace_gutter-active-line",void this.$gutter.appendChild(this.$gutterLineHighlight);this.$gutterLineHighlight.style.display=e?"":"none",this.$cursorLayer.$pixelPos&&this.$updateGutterLineHighlight()},initialValue:!1,value:!0},hScrollBarAlwaysVisible:{set:function(e){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(e){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(e){"number"==typeof e&&(e+="px"),this.container.style.fontSize=e,this.updateFontSize()},initialValue:12},fontFamily:{set:function(e){this.container.style.fontFamily=e,this.updateFontSize()}},maxLines:{set:function(e){this.updateFull()}},minLines:{set:function(e){this.updateFull()}},maxPixelHeight:{set:function(e){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(e){e=+e||0,this.$scrollPastEnd!=e&&(this.$scrollPastEnd=e,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(e){this.$gutterLayer.$fixedWidth=!!e,this.$loop.schedule(this.CHANGE_GUTTER)}},theme:{set:function(e){this.setTheme(e)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0}}),t.VirtualRenderer=g})),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],(function(e,t,n){"use strict";var r=e("../lib/oop"),i=e("../lib/net"),o=e("../lib/event_emitter").EventEmitter,a=e("../config");function s(e,t){var n=function(e,t){var n=t.src;i.qualifyURL(e);try{return new Blob([n],{type:"application/javascript"})}catch(e){var r=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return r.append(n),r.getBlob("application/javascript")}}(e,t),r=(window.URL||window.webkitURL).createObjectURL(n);return new Worker(r)}var c=function(t,n,r,i,o){if(this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),e.nameToUrl&&!e.toUrl&&(e.toUrl=e.nameToUrl),a.get("packaged")||!e.toUrl)i=i||a.moduleUrl(n.id,"worker");else{var c=this.$normalizePath;i=i||c(e.toUrl("ace/worker/worker.js",null,"_"));var l={};t.forEach((function(t){l[t]=c(e.toUrl(t,null,"_").replace(/(\.js)?(\?.*)?$/,""))}))}this.$worker=s(i,n),o&&this.send("importScripts",o),this.$worker.postMessage({init:!0,tlns:l,module:n.id,classname:r}),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage};(function(){r.implement(this,o),this.onMessage=function(e){var t=e.data;switch(t.type){case"event":this._signal(t.name,{data:t.data});break;case"call":var n=this.callbacks[t.id];n&&(n(t.data),delete this.callbacks[t.id]);break;case"error":this.reportError(t.data);break;case"log":window.console&&console.log&&console.log.apply(console,t.data)}},this.reportError=function(e){window.console&&console.error&&console.error(e)},this.$normalizePath=function(e){return i.qualifyURL(e)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(e,t){this.$worker.postMessage({command:e,args:t})},this.call=function(e,t,n){if(n){var r=this.callbackId++;this.callbacks[r]=n,t.push(r)}this.send(e,t)},this.emit=function(e,t){try{this.$worker.postMessage({event:e,data:{data:t.data}})}catch(e){console.error(e.stack)}},this.attachToDocument=function(e){this.$doc&&this.terminate(),this.$doc=e,this.call("setValue",[e.getValue()]),e.on("change",this.changeListener)},this.changeListener=function(e){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),"insert"==e.action?this.deltaQueue.push(e.start,e.lines):this.deltaQueue.push(e.start,e.end)},this.$sendDeltaQueue=function(){var e=this.deltaQueue;e&&(this.deltaQueue=null,e.length>50&&e.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:e}))}}).call(c.prototype);var l=function(e,t,n){this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.callbackId=1,this.callbacks={},this.messageBuffer=[];var r=null,i=!1,s=Object.create(o),c=this;this.$worker={},this.$worker.terminate=function(){},this.$worker.postMessage=function(e){c.messageBuffer.push(e),r&&(i?setTimeout(l):l())},this.setEmitSync=function(e){i=e};var l=function(){var e=c.messageBuffer.shift();e.command?r[e.command].apply(r,e.args):e.event&&s._signal(e.event,e.data)};s.postMessage=function(e){c.onMessage({data:e})},s.callback=function(e,t){this.postMessage({type:"call",id:t,data:e})},s.emit=function(e,t){this.postMessage({type:"event",name:e,data:t})},a.loadModule(["worker",t],(function(e){for(r=new e[n](s);c.messageBuffer.length;)l()}))};l.prototype=c.prototype,t.UIWorkerClient=l,t.WorkerClient=c,t.createWorker=s})),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],(function(e,t,n){"use strict";var r=e("./range").Range,i=e("./lib/event_emitter").EventEmitter,o=e("./lib/oop"),a=function(e,t,n,r,i,o){var a=this;this.length=t,this.session=e,this.doc=e.getDocument(),this.mainClass=i,this.othersClass=o,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate),this.$others=r,this.$onCursorChange=function(){setTimeout((function(){a.onCursorChange()}))},this.$pos=n;var s=e.getUndoManager().$undoStack||e.getUndoManager().$undostack||{length:-1};this.$undoStackDepth=s.length,this.setup(),e.selection.on("changeCursor",this.$onCursorChange)};(function(){o.implement(this,i),this.setup=function(){var e=this,t=this.doc,n=this.session;this.selectionBefore=n.selection.toJSON(),n.selection.inMultiSelectMode&&n.selection.toSingleRange(),this.pos=t.createAnchor(this.$pos.row,this.$pos.column);var i=this.pos;i.$insertRight=!0,i.detach(),i.markerId=n.addMarker(new r(i.row,i.column,i.row,i.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach((function(n){var r=t.createAnchor(n.row,n.column);r.$insertRight=!0,r.detach(),e.others.push(r)})),n.setUndoSelect(!1)},this.showOtherMarkers=function(){if(!this.othersActive){var e=this.session,t=this;this.othersActive=!0,this.others.forEach((function(n){n.markerId=e.addMarker(new r(n.row,n.column,n.row,n.column+t.length),t.othersClass,null,!1)}))}},this.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var e=0;e<this.others.length;e++)this.session.removeMarker(this.others[e].markerId)}},this.onUpdate=function(e){if(this.$updating)return this.updateAnchors(e);var t=e;if(t.start.row===t.end.row&&t.start.row===this.pos.row){this.$updating=!0;var n="insert"===e.action?t.end.column-t.start.column:t.start.column-t.end.column,i=t.start.column>=this.pos.column&&t.start.column<=this.pos.column+this.length+1,o=t.start.column-this.pos.column;if(this.updateAnchors(e),i&&(this.length+=n),i&&!this.session.$fromUndo)if("insert"===e.action)for(var a=this.others.length-1;a>=0;a--){var s={row:(c=this.others[a]).row,column:c.column+o};this.doc.insertMergedLines(s,e.lines)}else if("remove"===e.action)for(a=this.others.length-1;a>=0;a--){var c;s={row:(c=this.others[a]).row,column:c.column+o};this.doc.remove(new r(s.row,s.column,s.row,s.column-n))}this.$updating=!1,this.updateMarkers()}},this.updateAnchors=function(e){this.pos.onChange(e);for(var t=this.others.length;t--;)this.others[t].onChange(e);this.updateMarkers()},this.updateMarkers=function(){if(!this.$updating){var e=this,t=this.session,n=function(n,i){t.removeMarker(n.markerId),n.markerId=t.addMarker(new r(n.row,n.column,n.row,n.column+e.length),i,null,!1)};n(this.pos,this.mainClass);for(var i=this.others.length;i--;)n(this.others[i],this.othersClass)}},this.onCursorChange=function(e){if(!this.$updating&&this.session){var t=this.session.selection.getCursor();t.row===this.pos.row&&t.column>=this.pos.column&&t.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",e)):(this.hideOtherMarkers(),this._emit("cursorLeave",e))}},this.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.removeEventListener("change",this.$onUpdate),this.session.selection.removeEventListener("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},this.cancel=function(){if(-1!==this.$undoStackDepth){for(var e=this.session.getUndoManager(),t=(e.$undoStack||e.$undostack).length-this.$undoStackDepth,n=0;n<t;n++)e.undo(!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}}}).call(a.prototype),t.PlaceHolder=a})),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],(function(e,t,n){var r=e("../lib/event"),i=e("../lib/useragent");function o(e,t){return e.row==t.row&&e.column==t.column}t.onMouseDown=function(e){var t=e.domEvent,n=t.altKey,a=t.shiftKey,s=t.ctrlKey,c=e.getAccelKey(),l=e.getButton();if(s&&i.isMac&&(l=t.button),e.editor.inMultiSelectMode&&2==l)e.editor.textInput.onContextMenu(e.domEvent);else if(s||n||c){if(0===l){var u,h=e.editor,d=h.selection,f=h.inMultiSelectMode,p=e.getDocumentPosition(),m=d.getCursor(),g=e.inSelection()||d.isEmpty()&&o(p,m),v=e.x,y=e.y,b=h.session,w=h.renderer.pixelToScreenCoordinates(v,y),x=w;if(h.$mouseHandler.$enableJumpToDef)s&&n||c&&n?u=a?"block":"add":n&&h.$blockSelectEnabled&&(u="block");else if(c&&!n){if(u="add",!f&&a)return}else n&&h.$blockSelectEnabled&&(u="block");if(u&&i.isMac&&t.ctrlKey&&h.$mouseHandler.cancelContextMenu(),"add"==u){if(!f&&g)return;if(!f){var _=d.toOrientedRange();h.addSelectionMarker(_)}var E=d.rangeList.rangeAtPoint(p);h.$blockScrolling++,h.inVirtualSelectionMode=!0,a&&(E=null,_=d.ranges[0]||_,h.removeSelectionMarker(_)),h.once("mouseup",(function(){var e=d.toOrientedRange();E&&e.isEmpty()&&o(E.cursor,e.cursor)?d.substractPoint(e.cursor):(a?d.substractPoint(_.cursor):_&&(h.removeSelectionMarker(_),d.addRange(_)),d.addRange(e)),h.$blockScrolling--,h.inVirtualSelectionMode=!1}))}else if("block"==u){var S;e.stop(),h.inVirtualSelectionMode=!0;var C=[];h.$blockScrolling++,f&&!c?d.toSingleRange():!f&&c&&(S=d.toOrientedRange(),h.addSelectionMarker(S)),a?w=b.documentToScreenPosition(d.lead):d.moveToPosition(p),h.$blockScrolling--,x={row:-1,column:-1};var A=function(){var e=h.renderer.pixelToScreenCoordinates(v,y),t=b.screenToDocumentPosition(e.row,e.column,e.offsetX);o(x,e)&&o(t,d.lead)||(x=e,h.$blockScrolling++,h.selection.moveToPosition(t),h.renderer.scrollCursorIntoView(),h.removeSelectionMarkers(C),C=d.rectangularRangeBlock(x,w),h.$mouseHandler.$clickSelection&&1==C.length&&C[0].isEmpty()&&(C[0]=h.$mouseHandler.$clickSelection.clone()),C.forEach(h.addSelectionMarker,h),h.updateSelectionMarkers(),h.$blockScrolling--)};r.capture(h.container,(function(e){v=e.clientX,y=e.clientY}),(function(e){clearInterval(T),h.removeSelectionMarkers(C),C.length||(C=[d.toOrientedRange()]),h.$blockScrolling++,S&&(h.removeSelectionMarker(S),d.toSingleRange(S));for(var t=0;t<C.length;t++)d.addRange(C[t]);h.inVirtualSelectionMode=!1,h.$mouseHandler.$clickSelection=null,h.$blockScrolling--}));var T=setInterval((function(){A()}),20);return e.preventDefault()}}}else 0===l&&e.editor.inMultiSelectMode&&e.editor.exitMultiSelectMode()}})),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],(function(e,t,n){t.defaultCommands=[{name:"addCursorAbove",exec:function(e){e.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",exec:function(e){e.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",exec:function(e){e.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",exec:function(e){e.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",exec:function(e){e.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",exec:function(e){e.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",exec:function(e){e.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",exec:function(e){e.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"splitIntoLines",exec:function(e){e.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"alignCursors",exec:function(e){e.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",exec:function(e){e.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],t.multiSelectCommands=[{name:"singleSelection",bindKey:"esc",exec:function(e){e.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(e){return e&&e.inMultiSelectMode}}];var r=e("../keyboard/hash_handler").HashHandler;t.keyboardHandler=new r(t.multiSelectCommands)})),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],(function(e,t,n){var r=e("./range_list").RangeList,i=e("./range").Range,o=e("./selection").Selection,a=e("./mouse/multi_select_handler").onMouseDown,s=e("./lib/event"),c=e("./lib/lang"),l=e("./commands/multi_select_commands");t.commands=l.defaultCommands.concat(l.multiSelectCommands);var u=new(0,e("./search").Search);var h=e("./edit_session").EditSession;(function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(h.prototype),function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&0===this.rangeCount){var n=this.toOrientedRange();if(this.rangeList.add(n),this.rangeList.add(e),2!=this.rangeList.ranges.length)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(n),this.$onAddRange(n)}e.cursor||(e.cursor=e.end);var r=this.rangeList.add(e);return this.$onAddRange(e),r.length&&this.$onRemoveRange(r),this.rangeCount>1&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){var t=this.rangeList.substractPoint(e);if(t)return this.$onRemoveRange(t),t[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length?this.$onRemoveRange(e):this.ranges[0]&&this.fromOrientedRange(this.ranges[0])},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){if(this.rangeCount=this.rangeList.ranges.length,1==this.rangeCount&&this.inMultiSelectMode){var t=this.rangeList.ranges.pop();e.push(t),this.rangeCount=0}for(var n=e.length;n--;){var r=this.ranges.indexOf(e[n]);this.ranges.splice(r,1)}this._signal("removeRange",{ranges:e}),0===this.rangeCount&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new r,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],n=i.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(n,t.cursor==t.start)}else{n=this.getRange();var r=this.isBackwards(),o=n.start.row,a=n.end.row;if(o==a){if(r)var s=n.end,c=n.start;else s=n.start,c=n.end;return this.addRange(i.fromPoints(c,c)),void this.addRange(i.fromPoints(s,s))}var l=[],u=this.getLineRange(o,!0);u.start.column=n.start.column,l.push(u);for(var h=o+1;h<a;h++)l.push(this.getLineRange(h,!0));(u=this.getLineRange(a,!0)).end.column=n.end.column,l.push(u),l.forEach(this.addRange,this)}},this.toggleBlockSelection=function(){if(this.rangeCount>1){var e=this.rangeList.ranges,t=e[e.length-1],n=i.fromPoints(e[0].start,t.end);this.toSingleRange(),this.setSelectionRange(n,t.cursor==t.start)}else{var r=this.session.documentToScreenPosition(this.selectionLead),o=this.session.documentToScreenPosition(this.selectionAnchor);this.rectangularRangeBlock(r,o).forEach(this.addRange,this)}},this.rectangularRangeBlock=function(e,t,n){var r=[],o=e.column<t.column;if(o)var a=e.column,s=t.column,c=e.offsetX,l=t.offsetX;else a=t.column,s=e.column,c=t.offsetX,l=e.offsetX;var u,h,d=e.row<t.row;if(d)var f=e.row,p=t.row;else f=t.row,p=e.row;a<0&&(a=0),f<0&&(f=0),f==p&&(n=!0);for(var m=f;m<=p;m++){var g=i.fromPoints(this.session.screenToDocumentPosition(m,a,c),this.session.screenToDocumentPosition(m,s,l));if(g.isEmpty()){if(v&&(u=g.end,h=v,u.row==h.row&&u.column==h.column))break;var v=g.end}g.cursor=o?g.start:g.end,r.push(g)}if(d&&r.reverse(),!n){for(var y=r.length-1;r[y].isEmpty()&&y>0;)y--;if(y>0)for(var b=0;r[b].isEmpty();)b++;for(var w=y;w>=b;w--)r[w].isEmpty()&&r.splice(w,1)}return r}}.call(o.prototype);var d=e("./editor").Editor;function f(e){e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=t.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",a),e.commands.addCommands(l.defaultCommands),function(e){var t=e.textInput.getElement(),n=!1;function r(t){n&&(e.renderer.setMouseCursor(""),n=!1)}s.addListener(t,"keydown",(function(t){var i=18==t.keyCode&&!(t.ctrlKey||t.shiftKey||t.metaKey);e.$blockSelectEnabled&&i?n||(e.renderer.setMouseCursor("crosshair"),n=!0):n&&r()})),s.addListener(t,"keyup",r),s.addListener(t,"blur",r)}(e))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){if(e.marker){this.session.removeMarker(e.marker);var t=this.session.$selectionMarkers.indexOf(e);-1!=t&&this.session.$selectionMarkers.splice(t,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length}},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,n=e.length;n--;){var r=e[n];if(r.marker){this.session.removeMarker(r.marker);var i=t.indexOf(r);-1!=i&&t.splice(i,1)}}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(l.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(l.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t=e.command,n=e.editor;if(n.multiSelect){if(t.multiSelectAction)"forEach"==t.multiSelectAction?r=n.forEachSelection(t,e.args):"forEachLine"==t.multiSelectAction?r=n.forEachSelection(t,e.args,!0):"single"==t.multiSelectAction?(n.exitMultiSelectMode(),r=t.exec(n,e.args||{})):r=t.multiSelectAction(n,e.args||{});else{var r=t.exec(n,e.args||{});n.multiSelect.addRange(n.multiSelect.toOrientedRange()),n.multiSelect.mergeOverlappingRanges()}return r}},this.forEachSelection=function(e,t,n){if(!this.inVirtualSelectionMode){var r,i=n&&n.keepOrder,a=1==n||n&&n.$byLines,s=this.session,c=this.selection,l=c.rangeList,u=(i?c:l).ranges;if(!u.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var h=c._eventRegistry;c._eventRegistry={};var d=new o(s);this.inVirtualSelectionMode=!0;for(var f=u.length;f--;){if(a)for(;f>0&&u[f].start.row==u[f-1].end.row;)f--;d.fromOrientedRange(u[f]),d.index=f,this.selection=s.selection=d;var p=e.exec?e.exec(this,t||{}):e(this,t||{});r||void 0===p||(r=p),d.toOrientedRange(u[f])}d.detach(),this.selection=s.selection=c,this.inVirtualSelectionMode=!1,c._eventRegistry=h,c.mergeOverlappingRanges();var m=this.renderer.$scrollAnimation;return this.onCursorChange(),this.onSelectionChange(),m&&m.from==m.to&&this.renderer.animateScrolling(m.from),r}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,n=[],r=0;r<t.length;r++)n.push(this.session.getTextRange(t[r]));var i=this.session.getDocument().getNewLineCharacter();(e=n.join(i)).length==(n.length-1)*i.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){var n=this.multiSelect.ranges[0];if(this.multiSelect.isEmpty()&&t==this.multiSelect.anchor)return;var r=t==this.multiSelect.anchor?n.cursor==n.start?n.end:n.start:n.cursor;r.row==t.row&&this.session.$clipPositionToDocument(r.row,r.column).column==t.column||this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange())}},this.findAll=function(e,t,n){if((t=t||{}).needle=e||t.needle,null==t.needle){var r=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange();t.needle=this.session.getTextRange(r)}this.$search.set(t);var i=this.$search.findAll(this.session);if(!i.length)return 0;this.$blockScrolling+=1;var o=this.multiSelect;n||o.toSingleRange(i[0]);for(var a=i.length;a--;)o.addRange(i[a],!0);return r&&o.rangeList.rangeAtPoint(r.start)&&o.addRange(r,!0),this.$blockScrolling-=1,i.length},this.selectMoreLines=function(e,t){var n=this.selection.toOrientedRange(),r=n.cursor==n.end,o=this.session.documentToScreenPosition(n.cursor);this.selection.$desiredColumn&&(o.column=this.selection.$desiredColumn);var a,s=this.session.screenToDocumentPosition(o.row+e,o.column);if(n.isEmpty())l=s;else var c=this.session.documentToScreenPosition(r?n.end:n.start),l=this.session.screenToDocumentPosition(c.row+e,c.column);r?(a=i.fromPoints(s,l)).cursor=a.start:(a=i.fromPoints(l,s)).cursor=a.end;if(a.desiredColumn=o.column,this.selection.inMultiSelectMode){if(t)var u=n.cursor}else this.selection.addRange(n);this.selection.addRange(a),u&&this.selection.substractPoint(u)},this.transposeSelections=function(e){for(var t=this.session,n=t.multiSelect,r=n.ranges,i=r.length;i--;){if((s=r[i]).isEmpty()){var o=t.getWordRange(s.start.row,s.start.column);s.start.row=o.start.row,s.start.column=o.start.column,s.end.row=o.end.row,s.end.column=o.end.column}}n.mergeOverlappingRanges();var a=[];for(i=r.length;i--;){var s=r[i];a.unshift(t.getTextRange(s))}e<0?a.unshift(a.pop()):a.push(a.shift());for(i=r.length;i--;){o=(s=r[i]).clone();t.replace(s,a[i]),s.start.row=o.start.row,s.start.column=o.start.column}},this.selectMore=function(e,t,n){var r=this.session,i=r.multiSelect.toOrientedRange();if(!i.isEmpty()||((i=r.getWordRange(i.start.row,i.start.column)).cursor=-1==e?i.start:i.end,this.multiSelect.addRange(i),!n)){var o=r.getTextRange(i),a=function(e,t,n){return u.$options.wrap=!0,u.$options.needle=t,u.$options.backwards=-1==n,u.find(e)}(r,o,e);a&&(a.cursor=-1==e?a.start:a.end,this.$blockScrolling+=1,this.session.unfold(a),this.multiSelect.addRange(a),this.$blockScrolling-=1,this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(i.cursor)}},this.alignCursors=function(){var e=this.session,t=e.multiSelect,n=t.ranges,r=-1,o=n.filter((function(e){if(e.cursor.row==r)return!0;r=e.cursor.row}));if(n.length&&o.length!=n.length-1){o.forEach((function(e){t.substractPoint(e.cursor)}));var a=0,s=1/0,l=n.map((function(t){var n=t.cursor,r=e.getLine(n.row).substr(n.column).search(/\S/g);return-1==r&&(r=0),n.column>a&&(a=n.column),r<s&&(s=r),r}));n.forEach((function(t,n){var r=t.cursor,o=a-r.column,u=l[n]-s;o>u?e.insert(r,c.stringRepeat(" ",o-u)):e.remove(new i(r.row,r.column,r.row,r.column-o+u)),t.start.column=t.end.column=a,t.start.row=t.end.row=r.row,t.cursor=t.end})),t.fromOrientedRange(n[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var u=this.selection.getRange(),h=u.start.row,d=u.end.row,f=h==d;if(f){var p,m=this.session.getLength();do{p=this.session.getLine(d)}while(/[=:]/.test(p)&&++d<m);do{p=this.session.getLine(h)}while(/[=:]/.test(p)&&--h>0);h<0&&(h=0),d>=m&&(d=m-1)}var g=this.session.removeFullLines(h,d);g=this.$reAlignText(g,f),this.session.insert({row:h,column:0},g.join("\n")+"\n"),f||(u.start.column=0,u.end.column=g[g.length-1].length),this.selection.setRange(u)}},this.$reAlignText=function(e,t){var n,r,i,o=!0,a=!0;return e.map((function(e){var t=e.match(/(\s*)(.*?)(\s*)([=:].*)/);return t?null==n?(n=t[1].length,r=t[2].length,i=t[3].length,t):(n+r+i!=t[1].length+t[2].length+t[3].length&&(a=!1),n!=t[1].length&&(o=!1),n>t[1].length&&(n=t[1].length),r<t[2].length&&(r=t[2].length),i>t[3].length&&(i=t[3].length),t):[e]})).map(t?l:o?a?function(e){return e[2]?s(n+r-e[2].length)+e[2]+s(i)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}:l:function(e){return e[2]?s(n)+e[2]+s(i)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]});function s(e){return c.stringRepeat(" ",e)}function l(e){return e[2]?s(n)+e[2]+s(r-e[2].length+i)+e[4].replace(/^([=:])\s+/,"$1 "):e[0]}}}).call(d.prototype),t.onSessionChange=function(e){var t=e.session;t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect;var n=e.oldSession;n&&(n.multiSelect.off("addRange",this.$onAddRange),n.multiSelect.off("removeRange",this.$onRemoveRange),n.multiSelect.off("multiSelect",this.$onMultiSelect),n.multiSelect.off("singleSelect",this.$onSingleSelect),n.multiSelect.lead.off("change",this.$checkMultiselectChange),n.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},t.MultiSelect=f,e("./config").defineOptions(d.prototype,"editor",{enableMultiselect:{set:function(e){f(this),e?(this.on("changeSession",this.$multiselectOnSessionChange),this.on("mousedown",a)):(this.off("changeSession",this.$multiselectOnSessionChange),this.off("mousedown",a))},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})})),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],(function(e,t,n){"use strict";var r=e("../../range").Range,i=t.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(e,t,n){var r=e.getLine(n);return this.foldingStartMarker.test(r)?"start":"markbeginend"==t&&this.foldingStopMarker&&this.foldingStopMarker.test(r)?"end":""},this.getFoldWidgetRange=function(e,t,n){return null},this.indentationBlock=function(e,t,n){var i=/\S/,o=e.getLine(t),a=o.search(i);if(-1!=a){for(var s=n||o.length,c=e.getLength(),l=t,u=t;++t<c;){var h=e.getLine(t).search(i);if(-1!=h){if(h<=a)break;u=t}}if(u>l){var d=e.getLine(u).length;return new r(l,s,u,d)}}},this.openingBracketBlock=function(e,t,n,i,o){var a={row:n,column:i+1},s=e.$findClosingBracket(t,a,o);if(s){var c=e.foldWidgets[s.row];return null==c&&(c=e.getFoldWidget(s.row)),"start"==c&&s.row>a.row&&(s.row--,s.column=e.getLine(s.row).length),r.fromPoints(a,s)}},this.closingBracketBlock=function(e,t,n,i,o){var a={row:n,column:i},s=e.$findOpeningBracket(t,a);if(s)return s.column++,a.column--,r.fromPoints(s,a)}}).call(i.prototype)})),ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],(function(e,t,n){"use strict";t.isDark=!1,t.cssClass="ace-tm",t.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}',e("../lib/dom").importCssString(t.cssText,t.cssClass)})),ace.define("ace/line_widgets",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/range"],(function(e,t,n){"use strict";e("./lib/oop");var r=e("./lib/dom");e("./range").Range;function i(e){this.session=e,this.session.widgetManager=this,this.session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}(function(){this.getRowLength=function(e){var t;return t=this.lineWidgets&&this.lineWidgets[e]&&this.lineWidgets[e].rowCount||0,this.$useWrapMode&&this.$wrapData[e]?this.$wrapData[e].length+1+t:1+t},this.$getWidgetScreenLength=function(){var e=0;return this.lineWidgets.forEach((function(t){t&&t.rowCount&&!t.hidden&&(e+=t.rowCount)})),e},this.$onChangeEditor=function(e){this.attach(e.editor)},this.attach=function(e){e&&e.widgetManager&&e.widgetManager!=this&&e.widgetManager.detach(),this.editor!=e&&(this.detach(),this.editor=e,e&&(e.widgetManager=this,e.renderer.on("beforeRender",this.measureWidgets),e.renderer.on("afterRender",this.renderWidgets)))},this.detach=function(e){var t=this.editor;if(t){this.editor=null,t.widgetManager=null,t.renderer.off("beforeRender",this.measureWidgets),t.renderer.off("afterRender",this.renderWidgets);var n=this.session.lineWidgets;n&&n.forEach((function(e){e&&e.el&&e.el.parentNode&&(e._inDocument=!1,e.el.parentNode.removeChild(e.el))}))}},this.updateOnFold=function(e,t){var n=t.lineWidgets;if(n&&e.action){for(var r=e.data,i=r.start.row,o=r.end.row,a="add"==e.action,s=i+1;s<o;s++)n[s]&&(n[s].hidden=a);n[o]&&(a?n[i]?n[o].hidden=a:n[i]=n[o]:(n[i]==n[o]&&(n[i]=void 0),n[o].hidden=a))}},this.updateOnChange=function(e){var t=this.session.lineWidgets;if(t){var n=e.start.row,r=e.end.row-n;if(0===r);else if("remove"==e.action){t.splice(n+1,r).forEach((function(e){e&&this.removeLineWidget(e)}),this),this.$updateRows()}else{var i=new Array(r);i.unshift(n,0),t.splice.apply(t,i),this.$updateRows()}}},this.$updateRows=function(){var e=this.session.lineWidgets;if(e){var t=!0;e.forEach((function(e,n){if(e)for(t=!1,e.row=n;e.$oldWidget;)e.$oldWidget.row=n,e=e.$oldWidget})),t&&(this.session.lineWidgets=null)}},this.addLineWidget=function(e){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var t=this.session.lineWidgets[e.row];t&&(e.$oldWidget=t,t.el&&t.el.parentNode&&(t.el.parentNode.removeChild(t.el),t._inDocument=!1)),this.session.lineWidgets[e.row]=e,e.session=this.session;var n=this.editor.renderer;e.html&&!e.el&&(e.el=r.createElement("div"),e.el.innerHTML=e.html),e.el&&(r.addCssClass(e.el,"ace_lineWidgetContainer"),e.el.style.position="absolute",e.el.style.zIndex=5,n.container.appendChild(e.el),e._inDocument=!0),e.coverGutter||(e.el.style.zIndex=3),null==e.pixelHeight&&(e.pixelHeight=e.el.offsetHeight),null==e.rowCount&&(e.rowCount=e.pixelHeight/n.layerConfig.lineHeight);var i=this.session.getFoldAt(e.row,0);if(e.$fold=i,i){var o=this.session.lineWidgets;e.row!=i.end.row||o[i.start.row]?e.hidden=!0:o[i.start.row]=e}return this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows(),this.renderWidgets(null,n),this.onWidgetChanged(e),e},this.removeLineWidget=function(e){if(e._inDocument=!1,e.session=null,e.el&&e.el.parentNode&&e.el.parentNode.removeChild(e.el),e.editor&&e.editor.destroy)try{e.editor.destroy()}catch(e){}if(this.session.lineWidgets){var t=this.session.lineWidgets[e.row];if(t==e)this.session.lineWidgets[e.row]=e.$oldWidget,e.$oldWidget&&this.onWidgetChanged(e.$oldWidget);else for(;t;){if(t.$oldWidget==e){t.$oldWidget=e.$oldWidget;break}t=t.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:e.row}}}),this.$updateRows()},this.getWidgetsAtRow=function(e){for(var t=this.session.lineWidgets,n=t&&t[e],r=[];n;)r.push(n),n=n.$oldWidget;return r},this.onWidgetChanged=function(e){this.session._changedWidgets.push(e),this.editor&&this.editor.renderer.updateFull()},this.measureWidgets=function(e,t){var n=this.session._changedWidgets,r=t.layerConfig;if(n&&n.length){for(var i=1/0,o=0;o<n.length;o++){var a=n[o];if(a&&a.el&&a.session==this.session){if(!a._inDocument){if(this.session.lineWidgets[a.row]!=a)continue;a._inDocument=!0,t.container.appendChild(a.el)}a.h=a.el.offsetHeight,a.fixedWidth||(a.w=a.el.offsetWidth,a.screenWidth=Math.ceil(a.w/r.characterWidth));var s=a.h/r.lineHeight;a.coverLine&&(s-=this.session.getRowLineCount(a.row))<0&&(s=0),a.rowCount!=s&&(a.rowCount=s,a.row<i&&(i=a.row))}}i!=1/0&&(this.session._emit("changeFold",{data:{start:{row:i}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},this.renderWidgets=function(e,t){var n=t.layerConfig,r=this.session.lineWidgets;if(r){for(var i=Math.min(this.firstRow,n.firstRow),o=Math.max(this.lastRow,n.lastRow,r.length);i>0&&!r[i];)i--;this.firstRow=n.firstRow,this.lastRow=n.lastRow,t.$cursorLayer.config=n;for(var a=i;a<=o;a++){var s=r[a];if(s&&s.el)if(s.hidden)s.el.style.top=-100-(s.pixelHeight||0)+"px";else{s._inDocument||(s._inDocument=!0,t.container.appendChild(s.el));var c=t.$cursorLayer.getPixelPosition({row:a,column:0},!0).top;s.coverLine||(c+=n.lineHeight*this.session.getRowLineCount(s.row)),s.el.style.top=c-n.offset+"px";var l=s.coverGutter?0:t.gutterWidth;s.fixedWidth||(l-=t.scrollLeft),s.el.style.left=l+"px",s.fullWidth&&s.screenWidth&&(s.el.style.minWidth=n.width+2*n.padding+"px"),s.fixedWidth?s.el.style.right=t.scrollBar.getWidth()+"px":s.el.style.right=""}}}}}).call(i.prototype),t.LineWidgets=i})),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range"],(function(e,t,n){"use strict";var r=e("../line_widgets").LineWidgets,i=e("../lib/dom"),o=e("../range").Range;t.showErrorMarker=function(e,t){var n=e.session;n.widgetManager||(n.widgetManager=new r(n),n.widgetManager.attach(e));var a=e.getCursorPosition(),s=a.row,c=n.widgetManager.getWidgetsAtRow(s).filter((function(e){return"errorMarker"==e.type}))[0];c?c.destroy():s-=t;var l,u=function(e,t,n){var r=e.getAnnotations().sort(o.comparePoints);if(r.length){var i=function(e,t,n){for(var r=0,i=e.length-1;r<=i;){var o=r+i>>1,a=n(t,e[o]);if(a>0)r=o+1;else{if(!(a<0))return o;i=o-1}}return-(r+1)}(r,{row:t,column:-1},o.comparePoints);i<0&&(i=-i-1),i>=r.length?i=n>0?0:r.length-1:0===i&&n<0&&(i=r.length-1);var a=r[i];if(a&&n){if(a.row===t){do{a=r[i+=n]}while(a&&a.row===t);if(!a)return r.slice()}var s=[];t=a.row;do{s[n<0?"unshift":"push"](a),a=r[i+=n]}while(a&&a.row==t);return s.length&&s}}}(n,s,t);if(u){var h=u[0];a.column=(h.pos&&"number"!=typeof h.column?h.pos.sc:h.column)||0,a.row=h.row,l=e.renderer.$gutterLayer.$annotations[a.row]}else{if(c)return;l={text:["Looks good!"],className:"ace_ok"}}e.session.unfold(a.row),e.selection.moveToPosition(a);var d={row:a.row,fixedWidth:!0,coverGutter:!0,el:i.createElement("div"),type:"errorMarker"},f=d.el.appendChild(i.createElement("div")),p=d.el.appendChild(i.createElement("div"));p.className="error_widget_arrow "+l.className;var m=e.renderer.$cursorLayer.getPixelPosition(a).left;p.style.left=m+e.renderer.gutterWidth-5+"px",d.el.className="error_widget_wrapper",f.className="error_widget "+l.className,f.innerHTML=l.text.join("<br>"),f.appendChild(i.createElement("div"));var g=function(e,t,n){if(0===t&&("esc"===n||"return"===n))return d.destroy(),{command:"null"}};d.destroy=function(){e.$mouseHandler.isMousePressed||(e.keyBinding.removeKeyboardHandler(g),n.widgetManager.removeLineWidget(d),e.off("changeSelection",d.destroy),e.off("changeSession",d.destroy),e.off("mouseup",d.destroy),e.off("change",d.destroy))},e.keyBinding.addKeyboardHandler(g),e.on("changeSelection",d.destroy),e.on("changeSession",d.destroy),e.on("mouseup",d.destroy),e.on("change",d.destroy),e.session.widgetManager.addLineWidget(d),d.el.onmousedown=e.focus.bind(e),e.renderer.scrollCursorIntoView(null,.5,{bottom:d.el.offsetHeight})},i.importCssString("    .error_widget_wrapper {        background: inherit;        color: inherit;        border:none    }    .error_widget {        border-top: solid 2px;        border-bottom: solid 2px;        margin: 5px 0;        padding: 10px 40px;        white-space: pre-wrap;    }    .error_widget.ace_error, .error_widget_arrow.ace_error{        border-color: #ff5a5a    }    .error_widget.ace_warning, .error_widget_arrow.ace_warning{        border-color: #F1D817    }    .error_widget.ace_info, .error_widget_arrow.ace_info{        border-color: #5a5a5a    }    .error_widget.ace_ok, .error_widget_arrow.ace_ok{        border-color: #5aaa5a    }    .error_widget_arrow {        position: absolute;        border: solid 5px;        border-top-color: transparent!important;        border-right-color: transparent!important;        border-left-color: transparent!important;        top: -5px;    }","")})),ace.define("ace/ace",["require","exports","module","ace/lib/fixoldbrowsers","ace/lib/dom","ace/lib/event","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config"],(function(e,t,r){"use strict";e("./lib/fixoldbrowsers");var i=e("./lib/dom"),o=e("./lib/event"),a=e("./editor").Editor,s=e("./edit_session").EditSession,c=e("./undomanager").UndoManager,l=e("./virtual_renderer").VirtualRenderer;e("./worker/worker_client"),e("./keyboard/hash_handler"),e("./placeholder"),e("./multi_select"),e("./mode/folding/fold_mode"),e("./theme/textmate"),e("./ext/error_marker"),t.config=e("./config"),t.acequire=e,t.define=n("B9Yq"),t.edit=function(e){if("string"==typeof e){var n=e;if(!(e=document.getElementById(n)))throw new Error("ace.edit can't find div #"+n)}if(e&&e.env&&e.env.editor instanceof a)return e.env.editor;var r="";if(e&&/input|textarea/i.test(e.tagName)){var s=e;r=s.value,e=i.createElement("pre"),s.parentNode.replaceChild(e,s)}else e&&(r=i.getInnerText(e),e.innerHTML="");var c=t.createEditSession(r),u=new a(new l(e));u.setSession(c);var h={document:c,editor:u,onResize:u.resize.bind(u,null)};return s&&(h.textarea=s),o.addListener(window,"resize",h.onResize),u.on("destroy",(function(){o.removeListener(window,"resize",h.onResize),h.editor.container.env=null})),u.container.env=u.env=h,u},t.createEditSession=function(e,t){var n=new s(e,t);return n.setUndoManager(new c),n},t.EditSession=s,t.UndoManager=c,t.version="1.2.9"})),ace.acequire(["ace/ace"],(function(e){for(var t in e&&(e.config.init(!0),e.define=ace.define),window.ace||(window.ace=e),e)e.hasOwnProperty(t)&&(window.ace[t]=e[t])})),e.exports=window.ace.acequire("ace/ace")},BiGR:function(e,t,n){var r=n("nmnc"),i=n("03A+"),o=n("Z0cm"),a=r?r.isConcatSpreadable:void 0;e.exports=function(e){return o(e)||i(e)||!!(a&&e&&e[a])}},BjVE:function(e,t,n){"use strict";e.exports=function(e,t){var n=e.indexOf("**",t),r=e.indexOf("__",t);if(-1===r)return n;if(-1===n)return r;return r<n?r:n}},BkRI:function(e,t,n){var r=n("OBhP");e.exports=function(e){return r(e,5)}},Bnag:function(e,t){e.exports=function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")},e.exports.default=e.exports,e.exports.__esModule=!0},Brp5:function(e,t,n){"use strict";e.exports=function(e,t){return e.indexOf("`",t)}},C4tZ:function(e,t,n){"use strict";var r=n("6Ekc").longestPath,i=n("GEWS"),o=n("dOj1");e.exports=function(e){switch(e.graph().ranker){case"network-simplex":s(e);break;case"tight-tree":!function(e){r(e),i(e)}(e);break;case"longest-path":a(e);break;default:s(e)}};var a=r;function s(e){o(e)}},CH3K:function(e,t){e.exports=function(e,t){for(var n=-1,r=t.length,i=e.length;++n<r;)e[i+n]=t[n];return e}},CMye:function(e,t,n){var r=n("GoyQ");e.exports=function(e){return e==e&&!r(e)}},CRs9:function(e,t,n){"use strict";e.exports=function(e,t){var n=e.indexOf("*",t),r=e.indexOf("_",t);if(-1===r)return n;if(-1===n)return r;return r<n?r:n}},CZoQ:function(e,t){e.exports=function(e,t,n){for(var r=n-1,i=e.length;++r<i;)if(e[r]===t)return r;return-1}},ChrQ:function(e,t,n){var r=n("y7/N");e.exports=function(e){this.name=e.xml.getAttribute("name"),this.visuals=[];for(var t=e.xml.getElementsByTagName("visual"),n=0;n<t.length;n++)this.visuals.push(new r({xml:t[n]}))}},Cwc5:function(e,t,n){var r=n("NKxu"),i=n("Npjl");e.exports=function(e,t){var n=i(e,t);return r(n)?n:void 0}},DSRE:function(e,t,n){(function(e){var r=n("Kz5y"),i=n("B8du"),o=t&&!t.nodeType&&t,a=o&&"object"==typeof e&&e&&!e.nodeType&&e,s=a&&a.exports===o?r.Buffer:void 0,c=(s?s.isBuffer:void 0)||i;e.exports=c}).call(this,n("YuTi")(e))},"Dw+G":function(e,t,n){var r=n("juv8"),i=n("mTTR");e.exports=function(e,t){return e&&r(t,i(t),e)}},"E+oP":function(e,t,n){var r=n("A90E"),i=n("QqLw"),o=n("03A+"),a=n("Z0cm"),s=n("MMmD"),c=n("DSRE"),l=n("6sVZ"),u=n("c6wG"),h=Object.prototype.hasOwnProperty;e.exports=function(e){if(null==e)return!0;if(s(e)&&(a(e)||"string"==typeof e||"function"==typeof e.splice||c(e)||u(e)||o(e)))return!e.length;var t=i(e);if("[object Map]"==t||"[object Set]"==t)return!e.size;if(l(e))return!r(e).length;for(var n in e)if(h.call(e,n))return!1;return!0}},E2jh:function(e,t,n){var r,i=n("2gN3"),o=(r=/[^.]+$/.exec(i&&i.keys&&i.keys.IE_PROTO||""))?"Symbol(src)_1."+r:"";e.exports=function(e){return!!o&&o in e}},E9ZH:function(e,t){e.exports={URDF_SPHERE:0,URDF_BOX:1,URDF_CYLINDER:2,URDF_MESH:3}},EA7m:function(e,t,n){var r=n("zZ0H"),i=n("Ioao"),o=n("wclG");e.exports=function(e,t){return o(i(e,t,r),e+"")}},EBzq:function(e,t,n){"use strict";var r=[].slice;e.exports=function(e,t){var n;return function(){var t,a=r.call(arguments,0),s=e.length>a.length;s&&a.push(i);try{t=e.apply(null,a)}catch(e){if(s&&n)throw e;return i(e)}s||(t&&"function"==typeof t.then?t.then(o,i):t instanceof Error?i(t):o(t))};function i(){n||(n=!0,t.apply(null,arguments))}function o(e){i(null,e)}}},ECyS:function(e,t,n){"use strict";function r(e){return Object.prototype.toString.call(e).slice(8,-1)}function i(e){return"Undefined"===r(e)}function o(e){return"Null"===r(e)}function a(e){return"Object"===r(e)&&(e.constructor===Object&&Object.getPrototypeOf(e)===Object.prototype)}function s(e){return"Array"===r(e)}function c(e){return"Symbol"===r(e)}var l,u,h,d,f;l=o,u=i;
/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
function p(){for(var e=0,t=0,n=arguments.length;t<n;t++)e+=arguments[t].length;var r=Array(e),i=0;for(t=0;t<n;t++)for(var o=arguments[t],a=0,s=o.length;a<s;a++,i++)r[i]=o[a];return r}function m(e,t,n,r){var i=r.propertyIsEnumerable(t)?"enumerable":"nonenumerable";"enumerable"===i&&(e[t]=n),"nonenumerable"===i&&Object.defineProperty(e,t,{value:n,enumerable:!1,writable:!0,configurable:!0})}function g(e,t,n){if(!a(t))return n&&s(n)&&n.forEach((function(n){t=n(e,t)})),t;var r={};a(e)&&(r=p(Object.getOwnPropertyNames(e),Object.getOwnPropertySymbols(e)).reduce((function(n,r){var i=e[r];return(!c(r)&&!Object.getOwnPropertyNames(t).includes(r)||c(r)&&!Object.getOwnPropertySymbols(t).includes(r))&&m(n,r,i,e),n}),{}));return p(Object.getOwnPropertyNames(t),Object.getOwnPropertySymbols(t)).reduce((function(r,i){var o=t[i],c=a(e)?e[i]:void 0;return n&&s(n)&&n.forEach((function(e){o=e(c,o)})),void 0!==c&&a(o)&&(o=g(c,o,n)),m(r,i,o,t),r}),r)}t.a=function(e){for(var t=[],n=1;n<arguments.length;n++)t[n-1]=arguments[n];var r=null,i=e;return a(e)&&e.extensions&&1===Object.keys(e).length&&(i={},r=e.extensions),t.reduce((function(e,t){return g(e,t,r)}),i)}},EEGq:function(e,t,n){var r=n("juv8"),i=n("oCl/");e.exports=function(e,t){return r(e,i(e),t)}},EFJG:function(e,t){e.exports="0.6.4"},EQPF:function(e,t,n){"use strict";e.exports=function(e,t){return function(n){var r,i=0,o=n.indexOf("\\"),a=e[t],s=[];for(;-1!==o;)s.push(n.slice(i,o)),i=o+1,(r=n.charAt(i))&&-1!==a.indexOf(r)||s.push("\\"),o=n.indexOf("\\",i);return s.push(n.slice(i)),s.join("")}}},"EV5+":function(e,t,n){"use strict";var r=n("PEyx"),i=n("Ve/E"),o=n("lU+G");e.exports=function(e,t){function n(e){var n=t.edge(e);return o.has(n,"x")?"translate("+n.x+","+n.y+")":""}e.filter((function(){return!i.select(this).classed("update")})).attr("transform",n),r.applyTransition(e,t).style("opacity",1).attr("transform",n)}},EZfD:function(e,t,n){(function(t){e.exports=function(e,r,i,o,a,s,c,l,u,h,d){"use strict";var f=Math.pow,p=Math.abs,m=Math.round,g=Math.floor,v=Math.max,y=Math.min,b=Math.sin,w=Math.cos,x=Math.PI;function _(e,t){function n(){this.constructor=e}U(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}function E(e,t,n,r){return new(n||(n=Promise))((function(i,o){function a(e){try{c(r.next(e))}catch(e){o(e)}}function s(e){try{c(r.throw(e))}catch(e){o(e)}}function c(e){e.done?i(e.value):new n((function(t){t(e.value)})).then(a,s)}c((r=r.apply(e,t||[])).next())}))}function S(e,t){function n(e){return function(t){return r([e,t])}}function r(n){if(i)throw new TypeError("Generator is already executing.");for(;c;)try{if(i=1,o&&(a=2&n[0]?o.return:n[0]?o.throw||((a=o.return)&&a.call(o),0):o.next)&&!(a=a.call(o,n[1])).done)return a;switch(o=0,a&&(n=[2&n[0],a.value]),n[0]){case 0:case 1:a=n;break;case 4:return c.label++,{value:n[1],done:!1};case 5:c.label++,o=n[1],n=[0];continue;case 7:n=c.ops.pop(),c.trys.pop();continue;default:if(!((a=0<(a=c.trys).length&&a[a.length-1])||6!==n[0]&&2!==n[0])){c=0;continue}if(3===n[0]&&(!a||n[1]>a[0]&&n[1]<a[3])){c.label=n[1];break}if(6===n[0]&&c.label<a[1]){c.label=a[1],a=n;break}if(a&&c.label<a[2]){c.label=a[2],c.ops.push(n);break}a[2]&&c.ops.pop(),c.trys.pop();continue}n=t.call(e,c)}catch(e){n=[6,e],o=0}finally{i=a=0}if(5&n[0])throw n[1];return{value:n[0]?n[1]:void 0,done:!0}}var i,o,a,s,c={label:0,sent:function(){if(1&a[0])throw a[1];return a[1]},trys:[],ops:[]};return s={next:n(0),throw:n(1),return:n(2)},"function"==typeof Symbol&&(s[Symbol.iterator]=function(){return this}),s}function C(e){var t="function"==typeof Symbol&&e[Symbol.iterator],n=0;return t?t.call(e):{next:function(){return e&&n>=e.length&&(e=void 0),{value:e&&e[n++],done:!e}}}}function A(e,t){var n="function"==typeof Symbol&&e[Symbol.iterator];if(!n)return e;var r,i,o=n.call(e),a=[];try{for(;(void 0===t||0<t--)&&!(r=o.next()).done;)a.push(r.value)}catch(e){i={error:e}}finally{try{r&&!r.done&&(n=o.return)&&n.call(o)}finally{if(i)throw i.error}}return a}function T(){for(var e=[],t=0;t<arguments.length;t++)e=e.concat(A(arguments[t]));return e}function M(e){if(null==e)throw new TypeError("Expected 'val' to be defined, but received "+e)}function O(e){if(!(e instanceof i.Mesh))throw new TypeError("Expected 'val' to be mesh")}function k(e){if(!(e instanceof i.Material))throw new TypeError("Expected 'val' to be Material")}function R(e){if(void 0===e.length)throw new TypeError("Expected 'val' to be an array")}function P(e){return e instanceof i.Object3D}function L(e){return e instanceof HTMLElement}function F(e){if(!(e instanceof i.TorusGeometry))throw new Error("the provided geometry was not TorusGeometry")}function j(e){if(!(e instanceof HTMLVideoElement))throw new Error("the provided element must be an HTMLVideoElement")}function D(e){if(!(e instanceof i.BufferGeometry))throw new Error("the provided attribute must be an BufferGeometry")}function N(e){if(!(e instanceof i.BufferAttribute))throw new Error("the provided attribute must be an BufferAttribute")}function I(e,t){return e(t={exports:{}},t.exports),t.exports}var B="default"in e?e.default:e;r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r;var z="default"in i?i.default:i;o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,c=c&&Object.prototype.hasOwnProperty.call(c,"default")?c.default:c,u=u&&Object.prototype.hasOwnProperty.call(u,"default")?u.default:u,d=d&&Object.prototype.hasOwnProperty.call(d,"default")?d.default:d;var U=function(e,t){return(U=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},H=function(){return(H=Object.assign||function(e){for(var t,n=1,r=arguments.length;n<r;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}).apply(this,arguments)},V=function(t){var n,i=this;this.createdAt=new Date,this.isStreamLive=!1,this.isStreamPaused=!1,this.internalListener=null,this.listeners=new Set,this.rosConnectionHook=null,this.rosCloseHook=null,this.rosErrorHook=null,this.addRosHealthHooks=function(){i.rosCloseHook=function(){i.isStreamLive=!1,i.cleanStream("complete")},i.rosErrorHook=function(e){i.isStreamLive=!1,i.cleanStream("error",e)},i.ros.on("error",i.rosErrorHook),i.ros.on("close",i.rosCloseHook)},this.removeRosHealthHooks=function(){i.ros.off("error",i.rosErrorHook),i.ros.off("close",i.rosCloseHook),i.rosErrorHook=null,i.rosCloseHook=null},this.addListener=function(e){return i.listeners.has(e)?{success:!1,reason:"listener already present"}:(i.listeners.add(e),i.isStreamLive&&i.stream.addListener(e),{success:!0})},this.removeListener=function(e){return i.listeners.has(e)?(i.listeners.delete(e),i.stream.removeListener(e),{success:!0}):{success:!1,reason:"listener not present"}},this.cleanStream=function(e,t){"error"===e?i.stream.shamefullySendError(t):i.stream.shamefullySendComplete(),i.listeners.forEach((function(e){i.stream.removeListener(e)}))},this.removeAllListeners=function(){return i.listeners.forEach((function(e){i.stream.removeListener(e)})),i.listeners.clear(),{success:!0}},this.pause=function(){return i.isStreamPaused=!0,{success:!0}},this.resume=function(){return i.isStreamPaused=!1,{success:!0}},this.ros=t.ros,this.hasMemory=!(null===(n=t.memory)||void 0===n)&&n;var o={ros:this.ros,name:t.topicName,messageType:t.messageType};t.compression&&(o.compression=t.compression),t.queueSize&&(o.queue_size=t.queueSize),t.queueLength&&(o.queue_length=t.queueLength),this.topic=new e.Topic(o),this.producer={start:function(e){i.rosCloseHook||i.rosErrorHook||i.addRosHealthHooks(),i.internalListener=function(t){i.isStreamPaused||e.next(t)},i.topic.subscribe(i.internalListener)},stop:function(){i.topic.unsubscribe(i.internalListener),i.removeRosHealthHooks()}},this.stream=this.hasMemory?r.createWithMemory(this.producer):r.create(this.producer),this.isStreamLive=!0,this.rosConnectionHook=function(){i.isStreamLive||(i.stream=i.hasMemory?r.createWithMemory(i.producer):r.create(i.producer),i.isStreamLive=!0,i.listeners.forEach((function(e){i.stream.addListener(e)})))},this.ros.on("connection",this.rosConnectionHook)},$="Arrow",W="ArrowWithCircle",G="Axes",q="FlatArrow",Y=5e6,X=15790320,K={INHERIT:0,FIXED:1,VIEW_FACING:2},Z=[K.VIEW_FACING],J={NONE:0,MENU:1,BUTTON:2,MOVE_AXIS:3,MOVE_PLANE:4,ROTATE_AXIS:5,MOVE_ROTATE:6,MOVE_3D:7,ROTATE_3D:8,MOVE_ROTATE_3D:9},Q="robot_description",ee="geometry_msgs/AccelStamped",te="geometry_msgs/PolygonStamped",ne="geometry_msgs/PoseArray",re="geometry_msgs/PoseWithCovariance",ie="geometry_msgs/PoseStamped",oe="geometry_msgs/TwistStamped",ae="geometry_msgs/Vector3Stamped",se="geometry_msgs/WrenchStamped",ce="moveit_msgs/BoundingVolume",le="moveit_msgs/CollisionObject",ue="moveit_msgs/DisplayRobotState",he="moveit_msgs/DisplayTrajectory",de="moveit_msgs/PlanningScene",fe="nav_msgs/OccupancyGrid",pe="nav_msgs/Odometry",me="nav_msgs/Path",ge="sensor_msgs/CompressedImage",ve="sensor_msgs/JointState",ye="sensor_msgs/Image",be="sensor_msgs/LaserScan",we="sensor_msgs/MagneticField",xe="sensor_msgs/PointCloud",_e="sensor_msgs/PointCloud2",Ee="sensor_msgs/Range",Se="tf/tfMessage",Ce="tf2_msgs/TFMessage",Ae="visualization_msgs/Marker",Te="visualization_msgs/MarkerArray",Me="visualization_msgs/InteractiveMarkerInit",Oe="visualization_msgs/InteractiveMarkerFeedback",ke={INT8:1,UINT8:2,INT16:3,UINT16:4,INT32:5,UINT32:6,FLOAT32:7,FLOAT64:8},Re={ADD:0,REMOVE:1,APPEND:2,MOVE:3},Pe={BOX:1,SPHERE:2,CYLINDER:3,CONE:4},Le={ARROW:0,CUBE:1,SPHERE:2,CYLINDER:3,LINE_STRIP:4,LINE_LIST:5,CUBE_LIST:6,SPHERE_LIST:7,POINTS:8,TEXT_VIEW_FACING:9,MESH_RESOURCE:10,TRIANGLE_LIST:11},Fe={MAP:"map",CONST_MAP:"constmap",RAW:"raw"},je={SQUARES:"squares",POINTS:"points",FLAT_SQUARES:"flat_squares",SPHERES:"spheres",BOXES:"boxes"},De={INTENSITY:"Intensity",AXIS_COLOR:"AxisColor",FLAT_COLOR:"FlatColor"},Ne={RGB:"rgb",INTENSITY:"intensity"},Ie={X:"x",Y:"y",Z:"z"},Be=H({INTENSITY:"intensity"},Ie),ze={arrow:$,axes:G},Ue={arrow:$,axes:G,flatArrow:q},He={arrow:$,arrowWithCircle:W},Ve="#ff0000",$e="#008000",We="#0000ff",Ge="#f0ff00",qe="#f0ff00",Ye={backgroundColor:X,gridSize:30,gridDivisions:30,gridColor:11184810,gridCenterlineColor:7368816},Xe={selectedFrame:""},Ke={shaftLength:1,shaftRadius:.05,headLength:.3,headRadius:.1},Ze={axesLength:1,axesRadius:.1},Je={arrowLength:.3},Qe={robot:new i.Group,loop:!0},et={channelName:Be.INTENSITY,useRainbow:!1,invertRainbow:!1,minColor:"#000000",maxColor:"#ffffff",autocomputeIntensityBounds:!1,maxIntensity:3730,minIntensity:388},tt={},nt={axis:Ie.X,autocomputeValueBounds:!1,useFixedFrame:!1,minAxisValue:0,maxAxisValue:0},rt={streamType:"mjpeg",f:526,maxDepthPerTile:1,pointSize:3,width:1024,height:1024,whiteness:0,varianceThreshold:16667e-9},it={queueSize:1,width:320,height:240,compression:"cbor"},ot={width:320,height:240},at=H(H({selectable:!1,style:je.FLAT_SQUARES,size:.05,alpha:1,decayTime:0,queueSize:10,compression:"cbor",colorTransformer:De.INTENSITY,flatColor:"#ffffff"},et),nt),st={alpha:1,colorScheme:Fe.MAP,compression:"cbor",drawBehind:!1},ct={queueSize:1,namespaces:[]},lt={queueSize:1,namespaces:[],throttleRate:0},ut={queueSize:1,namespaces:[],throttleRate:0,publishThrottleRate:0,hideOtherHandlesOnSelect:!0,hideOtherControlsInstancesOnSelect:!0},ht=H(H(H(H({type:$,color:Ve,alpha:1},Ke),Ze),Je),{positionTolerance:.1,angleTolerance:.1,keep:100}),dt={color:"#ffffff",alpha:1},ft={},pt={compression:"cbor",colorChannel:Ne.RGB,size:.0125,useRainbow:!0,queueSize:1},mt={color:"#ff0000",alpha:1,radius:.2},gt={color:"#ffffff",alpha:1},vt=H(H(H({color:Ve,alpha:1},Ke),Ze),{type:Ue.arrow}),yt={circleRadius:.3,tube:.03,radialSegments:16,tubularSegments:100,arc:1.7*x},bt=H(H(H({},Ke),yt),{circleConeLength:.1,circleConeRadius:.1}),wt=H(H({forceColor:Ve,torqueColor:Ge,alpha:1,forceArrowScale:1,torqueArrowScale:1,arrowWidth:1},bt),{type:He.arrow}),xt=H(H(H(H({color:Ve,alpha:1},Ke),Ze),Je),{type:Ue.arrow}),_t={color:Ve,alpha:1},Et={},St={},Ct=Object.freeze({__proto__:null,OBJECT_TYPE_ARROW:$,OBJECT_TYPE_ARROW_WITH_CIRCLE:W,OBJECT_TYPE_AXES:G,OBJECT_TYPE_FLAT_ARROW:q,MAX_POINTCLOUD_POINTS:Y,DEFAULT_BACKGROUND_COLOR:X,DEFAULT_GRID_SIZE:30,DEFAULT_GRID_DIVISIONS:30,DEFAULT_GRID_COLOR:11184810,DEFAULT_GRID_COLOR_CENTERLINE:7368816,INTERACTIVE_MARKER_ORIENTATION_MODES:K,UNSUPPORTED_INTERACTIVE_MARKER_ORIENTATION_MODES:Z,INTERACTIVE_MARKER_INTERACTION_MODES:J,MESSAGE_TYPE_ROBOT_MODEL:Q,MESSAGE_TYPE_ACCELSTAMPED:ee,MESSAGE_TYPE_POINTSTAMPED:"geometry_msgs/PointStamped",MESSAGE_TYPE_POLYGONSTAMPED:te,MESSAGE_TYPE_POSEARRAY:ne,MESSAGE_TYPE_POSECOVARIANCE:re,MESSAGE_TYPE_POSESTAMPED:ie,MESSAGE_TYPE_TWISTSTAMPED:oe,MESSAGE_TYPE_VECTOR3STAMPED:ae,MESSAGE_TYPE_WRENCHSTAMPED:se,MESSAGE_TYPE_BOUNDINGVOLUME:ce,MESSAGE_TYPE_COLLISION_OBJECT:le,MESSAGE_TYPE_DISPLAYROBOTSTATE:ue,MESSAGE_TYPE_DISPLAYTRAJECTORY:he,MESSAGE_TYPE_PLANNINGSCENE:de,MESSAGE_TYPE_OCCUPANCYGRID:fe,MESSAGE_TYPE_ODOMETRY:pe,MESSAGE_TYPE_PATH:me,MESSAGE_TYPE_COMPRESSEDIMAGE:ge,MESSAGE_TYPE_DISPLAYJOINTSTATE:ve,MESSAGE_TYPE_IMAGE:ye,MESSAGE_TYPE_LASERSCAN:be,MESSAGE_TYPE_MAGNETICFIELD:we,MESSAGE_TYPE_POINTCLOUD:xe,MESSAGE_TYPE_POINTCLOUD2:_e,MESSAGE_TYPE_RANGE:Ee,MESSAGE_TYPE_TF:Se,MESSAGE_TYPE_TF2:Ce,MESSAGE_TYPE_MARKER:Ae,MESSAGE_TYPE_MARKERARRAY:Te,MESSAGE_TYPE_INTERACTIVEMARKER:Me,MESSAGE_TYPE_INTERACTIVEMARKER_UPDATE:"visualization_msgs/InteractiveMarkerUpdate",MESSAGE_TYPE_INTERACTIVEMARKER_FEEDBACK:Oe,VIZ_TYPE_IMAGE:"Image",VIZ_TYPE_INTERACTIVEMARKER:"InteractiveMarker",VIZ_TYPE_LASERSCAN:"LaserScan",VIZ_TYPE_MAP:"Map",VIZ_TYPE_MARKER:"Marker",VIZ_TYPE_MARKERARRAY:"MarkerArray",VIZ_TYPE_ODOMETRY:"Odometry",VIZ_TYPE_PATH:"Path",VIZ_TYPE_POINT:"Point",VIZ_TYPE_POINTCLOUD:"PointCloud",VIZ_TYPE_POLYGON:"Polygon",VIZ_TYPE_POSE:"Pose",VIZ_TYPE_POSEARRAY:"PoseArray",VIZ_TYPE_RANGE:"Range",VIZ_TYPE_ROBOTMODEL:"RobotModel",VIZ_TYPE_TF:"Tf",VIZ_TYPE_WRENCH:"Wrench",POINT_FIELD_DATATYPES:ke,COLLISION_OBJECT_OPERATIONS:Re,SOLID_PRIMITIVE_TYPES:Pe,MARKER_OBJECT_TYPES:Le,LINE_STYLES:{LINES:"Lines",BILLBOARDS:"Billboards"},MAP_COLOR_SCHEMES:Fe,LASERSCAN_STYLES:je,COLOR_TRANSFORMERS:De,POINTCLOUD_COLOR_CHANNELS:Ne,AXES:Ie,INTENSITY_CHANNEL_OPTIONS:Be,ODOMETRY_OBJECT_TYPES:ze,POSE_OBJECT_TYPES:Ue,WRENCH_OBJECT_TYPES:He,DEFAULT_CYLINDER_HEIGHT:1,DEFAULT_CYLINDER_RADIUS:1,DEFAULT_RADIAL_SEGMENTS:32,DEFAULT_CONE_HEIGHT:1,DEFAULT_CONE_RADIUS:1,DEFAULT_COLOR_X_AXIS:Ve,DEFAULT_COLOR_Y_AXIS:$e,DEFAULT_COLOR_Z_AXIS:We,DEFAULT_COLOR_ARROW:Ge,DEFAULT_COLOR_LINE:qe,DEFAULT_OPTIONS_SCENE:Ye,DEFAULT_OPTIONS_TF_VIEWER:Xe,DEFAULT_OPTIONS_ARROW:Ke,DEFAULT_OPTIONS_AXES:Ze,DEFAULT_OPTIONS_FLATARROW:Je,DEFAULT_OPTIONS_DISPLAYTRAJECTORY:Qe,DEFAULT_OPTIONS_COLLISION_OBJECT:tt,DEFAULT_OPTIONS_DEPTHCLOUD:rt,DEFAULT_OPTIONS_IMAGE:it,DEFAULT_OPTIONS_IMAGE_STREAM:ot,DEFAULT_OPTIONS_LASERSCAN:at,DEFAULT_OPTIONS_MAP:st,DEFAULT_OPTIONS_MARKER:ct,DEFAULT_OPTIONS_MARKERARRAY:lt,DEFAULT_OPTIONS_INTERACTIVE_MARKER:ut,DEFAULT_OPTIONS_ODOMETRY:ht,DEFAULT_OPTIONS_PATH:dt,DEFAULT_OPTIONS_PLANNINGSCENE:ft,DEFAULT_OPTIONS_POINTCLOUD:pt,DEFAULT_OPTIONS_POINT:mt,DEFAULT_OPTIONS_POLYGON:gt,DEFAULT_OPTIONS_POSE:vt,DEFAULT_OPTIONS_TORUS:yt,DEFAULT_OPTIONS_ARROW_WITH_CIRCLE:bt,DEFAULT_OPTIONS_WRENCH:wt,DEFAULT_OPTIONS_POSEARRAY:xt,DEFAULT_OPTIONS_RANGE:_t,DEFAULT_OPTIONS_ROBOTMODEL:Et,DEFAULT_OPTIONS_TF:St,SUPPORTED_MESSAGE_TYPES:[ye,be,Ae,Te,fe,pe,me,de,_e,te,ie,ne,ie,Q,Se,Ce],UNSUPPORTED_MESSAGE_TYPES:[ee,ce,ge,ve,ue,he,Me,we,xe,re,Ee,oe,ae,se]}),At=function(e,t){switch(t.type){case $:var n=t.alpha,r=t.color,o=t.headLength,a=t.headRadius,s=t.shaftLength,c=t.shaftRadius;e.setHeadDimensions({radius:a,length:o}),e.setShaftDimensions({radius:c,length:s}),e.setAlpha(n),e.setColor({cone:new i.Color(r),cylinder:new i.Color(r)});break;case G:var l=t.axesLength,u=t.axesRadius;e.setLength(l),e.setRadius(u);break;case q:var h=t.arrowLength,d=t.color;e.setLength(h),e.setColor(new i.Color(d));break;case W:var f=t.alpha,p=t.circleConeLength,m=t.circleConeRadius,g=t.circleRadius,v=t.color,y=t.headLength,b=t.headRadius,w=t.shaftLength,x=t.shaftRadius,_=t.tube;e.setHeadDimensions({radius:b,length:y}),e.setShaftDimensions({radius:x,length:w}),e.setTorusDimensions({radius:g,tube:_}),e.setCircleConeDimensions({radius:m,length:p}),e.setAlpha(f),e.setColor({cone:new i.Color(v),cylinder:new i.Color(v),torus:new i.Color(v),circleCone:new i.Color(v)})}},Tt=function(){function e(e,t,n,r){void 0===r&&(r={});var i=r.onHeaderChange;this.options=r,this.ros=e,this.headerFrameId="",e&&t&&this.changeTopic(t,n,!1),this.onHeaderChange=i||function(){},this.update=this.update.bind(this)}return e.prototype.hide=function(){M(this.object),this.object.visible=!1},e.prototype.show=function(){M(this.object),this.object.visible=!0},e.prototype.destroy=function(){this.unsubscribe(),this.object&&this.object.parent&&(this.object.parent.remove(this.object),this.object=null)},e.prototype.reset=function(){},e.prototype.subscribe=function(){var e=this;this.dataSourceInstances&&this.dataSourceInstances.forEach((function(t){var n={next:e.update,error:function(e){return console.log(e)},complete:function(){return console.log("stream complete")}};t.addListener(n)}))},e.prototype.unsubscribe=function(){this.dataSourceInstances&&this.dataSourceInstances.forEach((function(e){e.removeAllListeners()}))},e.prototype.update=function(e){var t=e.header?e.header.frame_id:"";t!==this.headerFrameId&&(this.headerFrameId=t,this.onHeaderChange(this.headerFrameId))},e.prototype.updateOptions=function(e){this.options=H(H({},this.options),e)},e.prototype.changeTopic=function(e,t,n){var r=this;void 0===n&&(n=!0);var i=this.options,o=i.compression,a=i.queueSize,s=i.throttleRate;n&&this.unsubscribe(),this.topicName=e,this.messageType=t||this.messageType,this.dataSourceInstances=(Array.isArray(e)?e:[{name:e,messageType:t}]).map((function(e){var t=e.name,n=e.messageType;return new V({ros:r.ros,topicName:t,messageType:n,compression:o||"none",throttleRate:s||0,queueSize:a||10})})),n&&(this.reset(),this.subscribe())},e}(),Mt=function(e,t){var n=t.translation,r=n.x,o=n.y,a=n.z,s=t.rotation,c=s.w,l=s.x,u=s.y,h=s.z;e.position.set(r,o,a),e.quaternion.copy(new i.Quaternion(l,u,h,c).normalize())},Ot=function(e,t){var n=t.x,r=t.y,i=t.z;e.scale.set(n,r,i)},kt=function(e,t){(function(e){if(!("color"in e))throw new TypeError("Expected 'val' to be MeshBasicMaterial with color")})(e.material),"string"==typeof t||"number"==typeof t?e.material.color=new i.Color(t):e.material.color.setRGB(t.r,t.g,t.b)},Rt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return _(t,e),t.prototype.setTransform=function(e){Mt(this,e)},t.prototype.setScale=function(e){Ot(this,e)},t.prototype.setColor=function(e){this.children.forEach((function(t){kt(t,e)}))},t}(i.Group),Pt=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return _(t,e),t.prototype.setTransform=function(e){Mt(this,e)},t.prototype.setScale=function(e){e&&Ot(this,e)},t.prototype.setColor=function(e){e&&kt(this,e)},t.prototype.setAlpha=function(e){Array.isArray(this.material)?this.material.forEach((function(t){t.opacity=i.MathUtils.clamp(e,0,1)})):this.material.opacity=i.MathUtils.clamp(e,0,1)},t}(i.Mesh),Lt=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.BoxGeometry,t.material=new i.MeshStandardMaterial,t}return _(t,e),t}(Pt),Ft=function(e){function t(t,n,r){void 0===r&&(r=tt);var i=e.call(this,null!=t?t:null,null!=n?n:null,le,H(H({},tt),r))||this;return i.object=new Rt,i.updateOptions(H(H({},tt),r)),i}return _(t,e),t.prototype.update=function(n){var r,i;e.prototype.update.call(this,n);var o=n.id,a=n.operation,s=n.primitive_poses,c=n.primitives,l=this.object.getObjectByName(o);switch(a){case Re.ADD:l&&(null===(r=l.parent)||void 0===r||r.remove(l));var u=new Rt;u.name=o,c.forEach((function(e,n){var r=t.getNewPrimitive(e);null==r||r.setTransform({translation:s[n].position,rotation:s[n].orientation}),r&&u.add(r)})),this.object.add(u);break;case Re.REMOVE:l&&(null===(i=l.parent)||void 0===i||i.remove(l));break;case Re.APPEND:c.forEach((function(e,n){var r=t.getNewPrimitive(e);null==r||r.setTransform({translation:s[n].position,rotation:s[n].orientation}),r&&(null==l||l.add(r))}))}},t.getNewPrimitive=function(e){var t=e.type,n=e.dimensions;switch(t){case Pe.BOX:var r=new Lt,i=A(n,3),o=i[0],a=i[1],s=i[2];return r.setScale({x:o,y:a,z:s}),r;default:return null}},t}(Tt),jt=function(e){function t(t,n,r){void 0===r&&(r=Qe);var o=e.call(this,t,n,he,r)||this;o.pointsUpdateIds=[],o.object=new Rt,o.updateOptions(H(H({},Qe),r));var a=o.options.robot;return o.robotClone=a.clone(!0),Object.keys(o.robotClone.links).forEach((function(e){o.robotClone.links[e].traverse((function(e){e.material&&(e.material=new i.MeshPhongMaterial({color:"#ff0000"}))}))})),o}return _(t,e),t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t),t.loop&&this.lastMessage?this.update(this.lastMessage,!0):this.resetLoopback()},t.prototype.resetLoopback=function(){clearTimeout(this.loopbackId),clearTimeout(this.poseRemovalId),this.pointsUpdateIds&&this.pointsUpdateIds.map((function(e){return clearTimeout(e)})),this.pointsUpdateIds=[],this.robotClone&&this.robotClone.parent&&this.robotClone.parent.remove(this.robotClone)},t.prototype.update=function(t,n){var r,i=this,o=this.options.loop;this.resetLoopback(),n||(this.lastMessage=t),e.prototype.update.call(this,t);var a=A(t.trajectory,1)[0].joint_trajectory,s=a.joint_names,c=a.points,l=t.trajectory_start.joint_state,u=l.name,h=l.position;if(null===(r=this.object)||void 0===r||r.add(this.robotClone),u.forEach((function(e,t){var n=i.robotClone.getObjectByName(e);n&&n.setAngle(h[t])})),c.forEach((function(e){var t=e.positions,n=e.time_from_start,r=n.nsec,o=n.secs;i.pointsUpdateIds.push(window.setTimeout((function(){s.forEach((function(e,n){var r=i.robotClone.getObjectByName(e);r&&r.setAngle(t[n])}))}),1e3*o+r/1e6))})),0<c.length){var d=c[c.length-1].time_from_start,f=d.nsec,p=d.secs;this.poseRemovalId=window.setTimeout((function(){var e;null===(e=i.robotClone.parent)||void 0===e||e.remove(i.robotClone),o&&(i.loopbackId=window.setTimeout((function(){i.lastMessage&&i.update(i.lastMessage,!0)}),1e3))}),1e3*p+f/1e6)}},t}(Tt),Dt=function(e){function t(t,n,r){void 0===r&&(r=ft);var i=e.call(this,t,n,de,H(H({},ft),r))||this;return i.collisionObjectViz=new Ft,i.attachedCollisionObjects=new Map,i.object=new Rt,i.object.add(i.collisionObjectViz.object),i.updateOptions(H(H({},ft),r)),i}return _(t,e),t.prototype.update=function(t){var n,r,i=this;e.prototype.update.call(this,t);var o=t.robot_state,a=o.attached_collision_objects,s=void 0===a?[]:a,c=o.is_diff,l=o.joint_state,u=l.name,h=l.position;if(t.world.collision_objects.forEach((function(e){i.collisionObjectViz.update(e)})),s.length&&s.map((function(e){var t,n=e.link_name,r=e.object,o=new Ft,a=null===(t=i.object)||void 0===t?void 0:t.getObjectByName(n);M(a),o.object=a,o.update(r),i.attachedCollisionObjects.set(r.id,o)})),!c){var d=s.map((function(e){return e.object.id}));try{for(var f=C(this.attachedCollisionObjects.entries()),p=f.next();!p.done;p=f.next()){var m=A(p.value,2),g=m[0],v=m[1];-1===d.indexOf(g)&&(v.update({id:g,operation:Re.REMOVE}),this.attachedCollisionObjects.delete(g))}}catch(e){n={error:e}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(n)throw n.error}}}u.forEach((function(e,t){var n,r=null===(n=i.object)||void 0===n?void 0:n.getObjectByName(e);r&&r.setAngle(h[t])}))},t}(Tt),Nt=function(e){function t(t,n,r){void 0===t&&(t=Ge),void 0===n&&(n=1),void 0===r&&(r=1);var o=e.call(this)||this;return o.geometry=new i.CylinderGeometry(n,n,r,32),o.material=new i.MeshStandardMaterial({color:t}),o.material.transparent=!0,o.rotateX(x/2),o}return _(t,e),t}(Pt),It=function(e){function t(t){void 0===t&&(t=Ve);var n=e.call(this)||this;return n.geometry=new i.ConeGeometry(1,1,32),n.material=new i.MeshStandardMaterial({color:t}),n.material.transparent=!0,n}return _(t,e),t}(Pt),Bt=function(e){function t(){var t=e.call(this)||this;return t.cone=new It(Ve),t.cylinder=new Nt(Ve),t.cone.rotateZ(-x/2),t.cylinder.rotateZ(-x/2),t.cone.setScale({x:1,y:1,z:1}),t.cylinder.setScale({x:1,y:1,z:1}),t.cylinder.translateY(t.cylinder.scale.y/2),t.cone.translateY(t.cylinder.scale.y+t.cone.scale.y/2),t.add(t.cone),t.add(t.cylinder),t}return _(t,e),t.prototype.setTransform=function(e){Mt(this,e)},t.prototype.setColor=function(e){var t=e.cone,n=e.cylinder;t&&this.cone.setColor(t),n&&this.cylinder.setColor(n)},t.prototype.setHeadDimensions=function(e){var t=e.radius,n=e.length;if(t){var r=this.cone.scale.y;this.cone.setScale({x:t,y:r,z:t})}if(n){var i=this.cone.scale,o=i.x,a=i.z;this.cone.setScale({x:o,y:n,z:a}),this.cone.position.set(0,0,0),this.cone.translateY(this.cylinder.scale.y+n/2)}},t.prototype.setShaftDimensions=function(e){var t=e.radius,n=e.length;if(t){var r=this.cylinder.scale.y;this.cylinder.setScale({x:t,y:r,z:t})}if(n){var i=this.cylinder.scale,o=i.x,a=i.z;this.cylinder.setScale({x:o,y:n,z:a}),this.cylinder.position.set(0,0,0),this.cylinder.translateY(n/2),this.setHeadDimensions({length:this.cone.scale.y})}},t.prototype.setAlpha=function(e){this.cylinder.setAlpha(e),this.cone.setAlpha(e)},t.prototype.setScale=function(e){var t=e.x,n=A([t/2,t/2],2),r=n[0],i=n[1];Ot(this,{x:t,y:r,z:i})},t}(i.Group),zt=function(e){function t(t,n){void 0===t&&(t=1),void 0===n&&(n=1);var r=e.call(this)||this;return r.objectType=G,r.x=new Nt(Ve,t,n),r.y=new Nt($e,t,n),r.z=new Nt(We,t,n),r.x.translateX(n/2),r.y.translateZ(-n/2),r.z.translateY(n/2),r.x.rotateZ(-x/2),r.y.rotateX(x/2),r.add(r.x),r.add(r.y),r.add(r.z),r}return _(t,e),t.prototype.setLength=function(e){var t=+(""+e);[this.x,this.y,this.z].forEach((function(e){e.position.set(0,0,0),e.scale.setY(t)})),this.x.translateY(t/2),this.y.translateY(-t/2),this.z.translateY(t/2)},t.prototype.setRadius=function(e){var t=+(""+e);this.children.forEach((function(e){e.scale.setX(t),e.scale.setZ(t)}))},t}(Rt),Ut=function(e){function t(t,n){void 0===t&&(t=qe),void 0===n&&(n=!1);var r=e.call(this)||this;r.geometry=new i.Geometry,r.geometry.vertices.push(new i.Vector3(0,0,0));var o={};return n||(o.vertexColors=i.VertexColors),r.material=new i.LineBasicMaterial(H({},o)),r.material.transparent=!0,r.setColor(t),r}return _(t,e),t.prototype.setColor=function(e){e&&kt(this,e)},t.prototype.updatePoints=function(e,t){void 0===t&&(t=[]),this.geometry.vertices=e.map((function(e){var t=e.x,n=e.y,r=e.z;return new i.Vector3(t,n,r)})),this.geometry.verticesNeedUpdate=!0;var n=[];t.forEach((function(e){if("string"==typeof e||"number"==typeof e)n.push(new i.Color(e));else if(e){var t=e.r,r=e.g,o=e.b;n.push(new i.Color(t,r,o))}})),this.geometry.colors=n,this.geometry.colorsNeedUpdate=!0},t.prototype.setTransform=function(e){Mt(this,e)},t.prototype.setAlpha=function(e){k(this.material),this.material.opacity=e},t}(i.Line),Ht=function(e){function t(){var t=e.call(this)||this;return t.objectType=q,t.arrowTop=new Ut(16711680,!0),t.topPoints=[],t.arrowLength=new Ut(16711680,!0),t.topPoints.push(new i.Vector3(2,1,0)),t.topPoints.push(new i.Vector3(3,0,0)),t.topPoints.push(new i.Vector3(2,-1,0)),t.arrowTop.updatePoints(t.topPoints),t.add(t.arrowTop),t.arrowLength.updatePoints([new i.Vector3(0,0,0),new i.Vector3(3,0,0)]),t.add(t.arrowLength),t.scale.set(.1,.1,.1),t}return _(t,e),t.prototype.setLength=function(e){this.scale.set(e,e,e)},t.prototype.setColor=function(e){var t=e.r,n=e.g,r=e.b;this.arrowTop.material.color.setRGB(t,n,r),this.arrowLength.material.color.setRGB(t,n,r)},t}(Rt),Vt=function(){function e(e){var t,n=this;this.onHeaderChange=function(){},this.headerFrameId="",this.hide=function(){M(n.object),P(n.object)?n.object.visible=!1:L(n.object)&&(n.object.style.visibility="hidden")},this.show=function(){M(n.object),P(n.object)?n.object.visible=!0:L(n.object)&&(n.object.style.visibility="visible")},this.destroy=function(){var e,t,r,i;n.unsubscribe(),P(n.object)?null===(t=null===(e=n.object)||void 0===e?void 0:e.parent)||void 0===t||t.remove(n.object):L(n.object)&&(null===(i=null===(r=n.object)||void 0===r?void 0:r.parentElement)||void 0===i||i.removeChild(n.object)),n.object=void 0},this.reset=function(){},this.subscribe=function(){n.sources.forEach((function(e){var t={next:n.update,error:function(e){return console.log(e)},complete:function(){}};e.addListener(t)}))},this.unsubscribe=function(){n.sources.forEach((function(e){e.removeAllListeners()}))},this.sources=e.sources,this.options=null!==(t=e.options)&&void 0!==t?t:{},this.update=this.update.bind(this),this.updateOptions=this.updateOptions.bind(this)}return e.prototype.update=function(e){var t,n,r=null!==(n=null===(t=e.header)||void 0===t?void 0:t.frame_id)&&void 0!==n?n:"";r!==this.headerFrameId&&(this.headerFrameId=r,this.onHeaderChange(this.headerFrameId))},e.prototype.updateOptions=function(e){this.options=H(H({},this.options),e)},e.prototype.changeSources=function(e){this.unsubscribe(),this.sources=e,this.subscribe()},e}(),$t=function(e){function t(t,n){void 0===n&&(n=vt);var r=e.call(this,{sources:[t],options:H(H({},vt),n)})||this;return r.object=new i.Group,r.primitive=null,r.updateOptions(H(H({},vt),n)),r}return _(t,e),t.getNewPrimitive=function(e){var t=e.type,n=null;return t===Ue.arrow?n=new Bt:t===Ue.axes?n=new zt:t===Ue.flatArrow&&(n=new Ht),n},t.prototype.updateOptions=function(n){var r,i,o;e.prototype.updateOptions.call(this,n);var a=this.options.type;if((null===(r=this.primitive)||void 0===r?void 0:r.type)!==a&&(null===(i=this.object)||void 0===i||i.remove(this.primitive),this.primitive=null),!this.primitive){var s=t.getNewPrimitive(this.options);s&&(this.primitive=s,null===(o=this.object)||void 0===o||o.add(this.primitive))}At(this.primitive,this.options)},t.prototype.update=function(t){var n;e.prototype.update.call(this,t);var r=t.pose,i=r.orientation,o=r.position;null===(n=this.primitive)||void 0===n||n.setTransform({translation:o,rotation:i})},t}(Vt),Wt=function(e){function t(){var t=e.call(this)||this;t.circleCone=new It(Ve),t.material=new i.MeshStandardMaterial({color:t.cone.material.color}),t.add(t.circleCone),t.material.transparent=!0;var n=yt,r=new i.TorusGeometry(n.circleRadius,n.tube,n.radialSegments,n.tubularSegments,n.arc);return t.torus=new Pt(r,t.material),t.add(t.torus),t.circleCone.rotateX(r.parameters.arc),t.circleCone.translateZ(-w(-r.parameters.arc)*r.parameters.radius),t.circleCone.translateY(-b(-r.parameters.arc)*r.parameters.radius),t.circleCone.translateX(t.cylinder.scale.y/2),t.torus.translateX(t.cylinder.scale.y/2),t.torus.rotateY(x/2),t}return _(t,e),t.prototype.setTorusDimensions=function(e){var t=e.radius,n=e.tube,r=yt;this.torus.geometry=new i.TorusGeometry(t,n,r.radialSegments,r.tubularSegments,r.arc),this.torus.position.set(0,0,0),this.torus.rotation.set(0,0,0),this.torus.translateX(this.cylinder.scale.y/2),this.torus.rotateY(x/2)},t.prototype.setCircleConeDimensions=function(e){var t=e.radius,n=+(""+e.length);if(F(this.torus.geometry),+(""+t)){var r=this.circleCone.scale.y;this.circleCone.setScale({x:t,y:r,z:t})}if(n){var i=this.circleCone.scale,o=i.x,a=i.z;this.circleCone.setScale({x:o,y:n,z:a})}this.circleCone.position.set(0,0,0),this.circleCone.rotation.set(0,0,0),this.circleCone.translateX(this.cylinder.scale.y/2),this.circleCone.translateZ(-w(-this.torus.geometry.parameters.arc)*this.torus.geometry.parameters.radius),this.circleCone.translateY(-b(-this.torus.geometry.parameters.arc)*this.torus.geometry.parameters.radius),this.circleCone.rotateX(this.torus.geometry.parameters.arc)},t.prototype.setColor=function(e){var t=e.cone,n=e.cylinder,r=e.torus,i=e.circleCone;t&&this.cone.setColor(t),n&&this.cylinder.setColor(n),r&&kt(this.torus,this.cone.material.color),i&&this.circleCone.setColor(i)},t.prototype.setAlpha=function(t){e.prototype.setAlpha.call(this,t),k(this.torus.material),this.torus.material.opacity=i.MathUtils.clamp(t,0,1),this.circleCone.setAlpha(t)},t}(Bt),Gt=function(e){function t(t,n){void 0===n&&(n=wt);var r=e.call(this,{sources:[t],options:H(H({},wt),n)})||this;return r.primitiveX=null,r.primitiveY=null,r.object=new i.Group,r}return _(t,e),t.getNewPrimitive=function(e){var t=e.type,n=null;return t===He.arrow?n=new Bt:t===He.arrowWithCircle&&(n=new Wt),n},t.prototype.getOrUpdatePrimitive=function(e,n){var r,i;if(null===e||(null==e?void 0:e.type)!==n){e&&(null===(r=this.object)||void 0===r||r.remove(e));var o=t.getNewPrimitive({type:n});return o&&(null===(i=this.object)||void 0===i||i.add(o)),o}return e},t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t),this.primitiveX=this.getOrUpdatePrimitive(this.primitiveX,He.arrow),this.primitiveY=this.getOrUpdatePrimitive(this.primitiveY,He.arrowWithCircle);var n={color:this.options.forceColor,alpha:this.options.alpha,headLength:this.options.headLength*this.options.forceArrowScale,headRadius:this.options.headRadius*this.options.arrowWidth,shaftLength:this.options.shaftLength*this.options.forceArrowScale,shaftRadius:this.options.shaftRadius*this.options.arrowWidth,type:He.arrow},r={color:this.options.torqueColor,alpha:this.options.alpha,arc:this.options.arc,circleConeRadius:this.options.circleConeRadius*this.options.arrowWidth,circleConeLength:this.options.circleConeLength*this.options.arrowWidth,circleRadius:this.options.circleRadius*this.options.torqueArrowScale,headLength:this.options.headLength*this.options.torqueArrowScale,headRadius:this.options.headRadius*this.options.arrowWidth,shaftLength:this.options.shaftLength*this.options.torqueArrowScale,shaftRadius:this.options.shaftRadius*this.options.arrowWidth,tube:this.options.tube*this.options.arrowWidth,tubularSegments:this.options.tubularSegments,type:He.arrowWithCircle};At(this.primitiveX,n),At(this.primitiveY,r)},t.prototype.update=function(t){var n,r;e.prototype.update.call(this,t);var o=t.wrench,a=o.force,s=o.torque,c=new i.Vector3(1,0,0),l=new i.Vector3(a.x,a.y,a.z).normalize(),u=new i.Vector3(s.x,s.y,s.z).normalize(),h=(new i.Quaternion).setFromUnitVectors(c,l),d=(new i.Quaternion).setFromUnitVectors(c,u);null===(n=this.primitiveX)||void 0===n||n.setTransform({translation:{y:0,x:0,z:0},rotation:h}),null===(r=this.primitiveY)||void 0===r||r.setTransform({translation:{y:0,x:0,z:0},rotation:d})},t}(Vt),qt=function(e){function t(t,n,r){void 0===r&&(r=gt);var i=e.call(this,t,n,te,H(H({},gt),r))||this;return i.object=new Rt,i.line=new Ut(null,!0),i.updateOptions(H(H({},gt),r)),i}return _(t,e),t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t);var n=this.options,r=n.alpha,o=n.color;this.line.setColor(new i.Color(o)),this.line.setAlpha(r)},t.prototype.update=function(t){e.prototype.update.call(this,t);var n=t.polygon.points;n.push(n[0]),this.line.updatePoints(n),this.object.add(this.line)},t}(Tt),Yt=function(e){function t(t){var n=e.call(this)||this;n.geometry=new i.Geometry,n.material=new i.Material;var r=new i.FontLoader;return n.material=new i.MeshBasicMaterial({color:14540253}),r.load("https://raw.githubusercontent.com/mrdoob/three.js/dev/examples/fonts/helvetiker_regular.typeface.json",(function(e){n.geometry=new i.TextGeometry(t,{font:e,size:.05,height:.005,curveSegments:12,bevelEnabled:!1,bevelThickness:10,bevelSize:8,bevelSegments:5})})),n.rotateX(x/2),n.rotateY(Math.PI),n}return _(t,e),t}(Pt),Xt=function(e){function t(n){var r=e.call(this)||this;r.arrow=new Bt,r.add(new zt(.015,.25));var o=new Yt(n);return o.rotateY(Math.PI).translateX(.03).translateY(.03),r.add(o),r.arrow.setHeadDimensions({length:.15,radius:.05}),r.arrow.setShaftDimensions({length:.85,radius:.05/6}),r.arrow.setColor({cone:new i.Color("#FF1493"),cylinder:new i.Color(Ge)}),r.add(r.arrow),r.name=t.getName(n),r}return _(t,e),t.getName=function(e){return"tf-"+e},t}(Rt),Kt=function(e){function t(t,n){void 0===n&&(n=St);var r=e.call(this,{sources:[t],options:H(H({},St),n)})||this;return r.object=new i.Group,r.object.name="tf-tree",r}return _(t,e),t.prototype.update=function(e){var t,n=this;e.transforms.forEach((function(e){var t=e.header.frame_id,r=e.child_frame_id,o=e.transform,a=A([n.getFrameOrCreate(r),n.getFrameOrCreate(t)],2),s=a[0],c=a[1];if(c.add(s),s.setTransform(o),.1>s.position.length())s.arrow.visible=!1;else{s.arrow.lookAt(c.getWorldPosition(new i.Vector3)),s.arrow.rotateY(-x/2),s.arrow.visible=!0;var l=s.arrow.cone.scale.y;s.arrow.setShaftDimensions({length:s.position.length()-l})}})),null===(t=this.object)||void 0===t||t.children.forEach((function(e){e.arrow.visible=!1}))},t.prototype.getFrameOrCreate=function(e){var t,n,r=null===(t=this.object)||void 0===t?void 0:t.getObjectByName(Xt.getName(e));if(r)return r;var i=new Xt(e);return null===(n=this.object)||void 0===n||n.add(i),i},t}(Vt),Zt=("undefined"==typeof globalThis?"undefined"==typeof window?void 0===t&&("undefined"==typeof self||self):window:globalThis,function(e){function t(t,n,r){void 0===r&&(r=Et);var i=e.call(this,t,n,r)||this;return i.object=new Rt,i.updateOptions(H(H({},Et),r)),i}return _(t,e),t}(function(e){function t(t,n,r){void 0===r&&(r=Et);var o=e.call(this,i.DefaultLoadingManager)||this;return o.packages={},o.hide=function(){var e,t;M(o.object),Object.values(null!==(t=null===(e=o.urdfObject)||void 0===e?void 0:e.links)&&void 0!==t?t:[]).forEach((function(e){e.hide()}))},o.show=function(){var e,t;M(o.object),Object.values(null!==(t=null===(e=o.urdfObject)||void 0===e?void 0:e.links)&&void 0!==t?t:[]).forEach((function(e){e.show()}))},o.destroy=function(){var e,t,n,r;Object.values(null!==(t=null===(e=o.urdfObject)||void 0===e?void 0:e.links)&&void 0!==t?t:[]).forEach((function(e){e.delete()})),null===(r=null===(n=o.object)||void 0===n?void 0:n.parent)||void 0===r||r.remove(o.object),o.object=void 0},o.reset=function(){},o.options=r,o.packages=r.packages,o.param=new B.Param({ros:t,name:n}),o.updateOptions=o.updateOptions.bind(o),o.getPackages=o.getPackages.bind(o),o.defaultLoadMeshCallback=o.defaultLoadMeshCallback.bind(o),o.onComplete=o.onComplete.bind(o),o.loadURDF=o.loadURDF.bind(o),o.loadFromParam=o.loadFromParam.bind(o),o}return _(t,e),t.prototype.onComplete=function(){},t.prototype.loadFromParam=function(e,t){var n=this;void 0===e&&(e=this.onComplete),void 0===t&&(t={}),this.param.get((function(r){n.loadURDF(r,e,t)}))},t.prototype.loadURDF=function(t,n,r){void 0===n&&(n=this.onComplete);var i=e.prototype.parse.call(this,t,H({packages:r.packages||this.packages,loadMeshCb:r.loadMeshCb||this.defaultLoadMeshCallback,fetchOptions:{mode:"cors",credentials:"same-origin"}},r));M(this.object),this.urdfObject=i,this.object.add(i),this.object.name=i.robotName,n(this.object)},t.prototype.defaultLoadMeshCallback=function(t,n,r){e.prototype.defaultMeshLoader.call(this,t,n,(function(e){r(e)}))},t.prototype.getPackages=function(e){this.param.get((function(t){var n=(new DOMParser).parseFromString(t,"text/xml"),r=T(Array.from(n.querySelectorAll("mesh"))).map((function(e){var t;return A(null===(t=null==e?void 0:e.getAttribute("filename"))||void 0===t?void 0:t.replace(/^package:\/\//,"").split(/\/(.+)/),1)[0]}));e(T(new Set(r)))}))},t.prototype.updateOptions=function(e){this.options=H(H({},this.options),e)},t}(function(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}(I((function(e){e.exports=function(e,t,n,r){function i(e){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function a(e,t){for(var n,r=0;r<t.length;r++)(n=t[r]).enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}function s(e,t,n){return t&&a(e.prototype,t),n&&a(e,n),e}function c(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&u(e,t)}function l(e){return(l=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function u(e,t){return(u=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function h(e,t){return!t||"object"!=typeof t&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e):t}function d(e,t,n){return(d="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(e,t,n){var r=function(e,t){for(;!Object.prototype.hasOwnProperty.call(e,t)&&null!==(e=l(e)););return e}(e,t);if(r){var i=Object.getOwnPropertyDescriptor(r,t);return i.get?i.get.call(n):i.value}})(e,t,n||e)}function f(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e)){var n=[],r=!0,i=!1,o=void 0;try{for(var a,s=e[Symbol.iterator]();!(r=(a=s.next()).done)&&(n.push(a.value),!t||n.length!==t);r=!0);}catch(e){i=!0,o=e}finally{try{r||null==s.return||s.return()}finally{if(i)throw o}}return n}}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}function p(e){return function(e){if(Array.isArray(e)){for(var t=0,n=Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}function m(){for(var e,t=Object.getPrototypeOf(this),n=arguments.length,r=Array(n),i=0;i<n;i++)r[i]=arguments[i];var o=(e=t.clone).call.apply(e,[this].concat(r));return o.isURDFCollider=!0,o}function g(e){e.isURDFCollider=!0,e.clone=m}function b(e){return e?e.trim().split(/\s+/g).map((function(e){return parseFloat(e)})):[0,0,0]}function w(e,t){var n=!!(2<arguments.length&&void 0!==arguments[2])&&arguments[2];n||e.rotation.set(0,0,0),A.set(t[0],t[1],t[2],"ZYX"),C.setFromEuler(A),C.multiply(e.quaternion),e.quaternion.copy(C)}var _=function(e){function t(){var e,n;o(this,t);for(var r=arguments.length,i=Array(r),a=0;a<r;a++)i[a]=arguments[a];return(n=h(this,(e=l(t)).call.apply(e,[this].concat(i)))).isURDFLink=!0,n.type="URDFLink",n.urdfNode=null,n}return c(t,e),s(t,[{key:"show",value:function(){this.visible=!0}},{key:"hide",value:function(){this.visible=!1}},{key:"delete",value:function(){var e=this;this.parent.remove(this),this.children.map((function(t){e.remove(t)}))}},{key:"copy",value:function(e,n){return d(l(t.prototype),"copy",this).call(this,e,n),this.urdfNode=e.urdfNode,this}}]),t}(e.Object3D),E=function(t){function n(){var e,t;o(this,n);for(var r=arguments.length,i=Array(r),a=0;a<r;a++)i[a]=arguments[a];return(t=h(this,(e=l(n)).call.apply(e,[this].concat(i)))).isURDFJoint=!0,t.type="URDFJoint",t.urdfNode=null,t.jointValue=null,t.jointType="fixed",t.axis=null,t.limit={lower:0,upper:0},t.ignoreLimits=!1,t.origPosition=null,t.origQuaternion=null,t}return c(n,t),s(n,[{key:"jointType",get:function(){return this._jointType},set:function(e){this.jointType!==e&&(this._jointType=e,"fixed"===e||"continuous"===e||"revolute"===e||"prismatic"===e?this.jointValue=0:"planar"===e?this.jointValue=[,,].fill(0):"floating"===e&&(this.jointValue=[,,,,,,].fill(0)))}},{key:"angle",get:function(){return this.jointValue}}]),s(n,[{key:"copy",value:function(e,t){return d(l(n.prototype),"copy",this).call(this,e,t),this.urdfNode=e.urdfNode,this.jointType=e.jointType,this.axis=e.axis?e.axis.clone():null,this.limit.lower=e.limit.lower,this.limit.upper=e.limit.upper,this.ignoreLimits=!1,this.jointValue=Array.isArray(e.jointValue)?p(e.jointValue):e.jointValue,this.origPosition=e.origPosition?e.origPosition.clone():null,this.origQuaternion=e.origQuaternion?e.origQuaternion.clone():null,this}},{key:"setAngle",value:function(){return this.setOffset.apply(this,arguments)}},{key:"setOffset",value:function(){for(var t=arguments.length,n=Array(t),r=0;r<t;r++)n[r]=arguments[r];switch(n=n.map((function(e){return parseFloat(e)})),this.origPosition&&this.origQuaternion||(this.origPosition=this.position.clone(),this.origQuaternion=this.quaternion.clone()),this.jointType){case"fixed":break;case"continuous":case"revolute":var i=n[0];if(null==i)break;if(i===this.jointValue)break;this.ignoreLimits||"revolute"!==this.jointType||(i=y(this.limit.upper,i),i=v(this.limit.lower,i));var o=(new e.Quaternion).setFromAxisAngle(this.axis,i);this.quaternion.multiplyQuaternions(this.origQuaternion,o),this.jointValue=i,this.matrixWorldNeedsUpdate=!0;break;case"prismatic":var a=n[0];if(null==a)break;if(a===this.jointValue)break;this.ignoreLimits||(a=y(this.limit.upper,a),a=v(this.limit.lower,a)),this.position.copy(this.origPosition),this.position.addScaledVector(this.axis,a),this.jointValue=a,this.worldMatrixNeedsUpdate=!0;break;case"floating":case"planar":console.warn("'".concat(this.jointType,"' joint not yet supported"))}return this.jointValue}}]),n}(e.Object3D),S=function(e){function t(){var e,n;o(this,t);for(var r=arguments.length,i=Array(r),a=0;a<r;a++)i[a]=arguments[a];return(n=h(this,(e=l(t)).call.apply(e,[this].concat(i)))).isURDFRobot=!0,n.urdfNode=null,n.urdfRobotNode=null,n.robotName=null,n.links=null,n.joints=null,n}return c(t,e),s(t,[{key:"copy",value:function(e,n){var r=this;return d(l(t.prototype),"copy",this).call(this,e,n),this.urdfRobotNode=e.urdfRobotNode,this.robotName=e.robotName,this.links={},this.joints={},this.traverse((function(t){t.isURDFJoint&&t.name in e.joints&&(r.joints[t.name]=t),t.isURDFLink&&t.name in e.links&&(r.links[t.name]=t)})),this}},{key:"setAngle",value:function(e){var t=this.joints[e];if(t){for(var n=arguments.length,r=Array(1<n?n-1:0),i=1;i<n;i++)r[i-1]=arguments[i];return t.setAngle.apply(t,r)}return null}},{key:"setAngles",value:function(e){for(var t in e)this.setAngle(t,e[t])}}]),t}(_),C=new e.Quaternion,A=new e.Euler;return function(){function a(t){var n=!!(1<arguments.length&&void 0!==arguments[1])&&arguments[1];o(this,a),this.manager=t||e.DefaultLoadingManager,this.allowMeshBVH=n,this.retryMap={}}return s(a,[{key:"load",value:function(t,n,r,i,o){var a,s=this,c=this.manager,l=e.LoaderUtils.extractUrlBase(t),u=this.manager.resolveURL(t),h={},d=function(){},f=function(){},p=function(){};c.onError&&(d=c.onProgress.bind(c)),c.onProgress&&(f=c.onProgress.bind(c)),c.onLoad&&(p=c.onLoad.bind(c));var m=this;c.onError=function(e){h[e]="Error in loading resource",i&&i({url:e,retry:m.retryMap[e]}),d(e)},c.onProgress=function(e,t,n){r&&r(e,t,n),f(e,t,n)},c.onLoad=function(){if(n){var e=0===Object.keys(h).length?void 0:h;n(a,e)}p()},o=Object.assign({workingPath:l},o),c.itemStart(u),fetch(u,o.fetchOptions).then((function(e){return e.text()})).then((function(e){a=s.parse(e,o),window.model=a,c.itemEnd(u)})).catch((function(e){console.error("URDFLoader: Error parsing file.",e),c.itemError(u),c.itemEnd(u)}))}},{key:"parse",value:function(t){function n(e){if(!/^package:\/\//.test(e))return v?v+e:e;var t=f(e.replace(/^package:\/\//,"").split(/\/(.+)/),2),n=t[0],r=t[1];return"string"==typeof d?d.endsWith(n)?d+"/"+r:d+"/"+n+"/"+r:"object"===i(d)?n in d?d[n]+"/"+r:(console.error("URDFLoader : ".concat(n," not found in provided package list.")),null):void 0}function o(e){var t=this,n=p(e.children),r=n.filter((function(e){return"link"===e.nodeName.toLowerCase()})),i=n.filter((function(e){return"joint"===e.nodeName.toLowerCase()})),o=n.filter((function(e){return"material"===e.nodeName.toLowerCase()})),l=new S;return l.robotName=e.getAttribute("name"),l.urdfRobotNode=e,o.forEach((function(e){var n=e.getAttribute("name");O[n]=c.call(t,e)})),r.forEach((function(n){var r=n.getAttribute("name"),i=null===e.querySelector('child[link="'.concat(r,'"]'));T[r]=s.call(t,n,i?l:null)})),i.forEach((function(e){var n=e.getAttribute("name");M[n]=a.call(t,e)})),l.joints=M,l.links=T,l}function a(t){var n=p(t.children),r=t.getAttribute("type"),i=new E;i.urdfNode=t,i.name=t.getAttribute("name"),i.jointType=r;var o=null,a=null,s=[0,0,0],c=[0,0,0];n.forEach((function(e){var t=e.nodeName.toLowerCase();"origin"===t?(s=b(e.getAttribute("xyz")),c=b(e.getAttribute("rpy"))):"child"===t?a=T[e.getAttribute("link")]:"parent"===t?o=T[e.getAttribute("link")]:"limit"===t&&(i.limit.lower=parseFloat(e.getAttribute("lower")||i.limit.lower),i.limit.upper=parseFloat(e.getAttribute("upper")||i.limit.upper))})),o.add(i),i.add(a),w(i,c),i.position.set(s[0],s[1],s[2]);var l=n.filter((function(e){return"axis"===e.nodeName.toLowerCase()}))[0];if(l){var u=l.getAttribute("xyz").split(/\s+/g).map((function(e){return parseFloat(e)}));i.axis=new e.Vector3(u[0],u[1],u[2]),i.axis.normalize()}return i}function s(e){var t=this,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;null===n&&(n=new _);var r=p(e.children);if(n.name=e.getAttribute("name"),n.urdfNode=e,y){var i=r.filter((function(e){return"visual"===e.nodeName.toLowerCase()}));i.forEach((function(e){return l.call(t,e,n,O)}))}if(C){var o=r.filter((function(e){return"collision"===e.nodeName.toLowerCase()}));o.forEach((function(e){return l.call(t,e,n)}))}return n}function c(t){var r=this,i=p(t.children),o=new e.MeshPhongMaterial;return o.name=t.getAttribute("name")||"",i.forEach((function(t){var i=t.nodeName.toLowerCase();if("color"===i){var a=t.getAttribute("rgba").split(/\s/g).map((function(e){return parseFloat(e)}));o.color.setRGB(a[0],a[1],a[2]),o.opacity=a[3],o.transparent=1>a[3]}else if("texture"===i){var s=new e.TextureLoader(A),c=n(t.getAttribute("filename"));o.map=s.load(c,(function(){return null}),(function(){return null}),(function e(){r.retryMap[c]=function(){return s.load(c,(function(){return null}),(function(){return null}),e)}}))}})),o}function l(t,i){var o=this,a=2<arguments.length&&void 0!==arguments[2]?arguments[2]:{},s="collision"===t.nodeName.toLowerCase(),l=[0,0,0],u=[0,0,0],h=[1,1,1],d=p(t.children),f=null,v=null,y=d.filter((function(e){return"material"===e.nodeName.toLowerCase()}))[0];if(y){var _=y.getAttribute("name");f=_&&_ in a?a[_]:c.call(this,y)}else f=new e.MeshPhongMaterial;d.forEach((function(t){var a=t.nodeName.toLowerCase();if("geometry"===a){var c=t.children[0].nodeName.toLowerCase();if("mesh"===c){var d=n(t.children[0].getAttribute("filename"));if(null!==d){var p=t.children[0].getAttribute("scale");p&&(h=b(p)),m(d,A,(function t(n,a){a?(console.error("URDFLoader: Error loading mesh.",a),o.retryMap[d]=function(){return m(d,A,t)}):n&&(n instanceof e.Mesh&&(n.material=f,o.allowMeshBVH&&(n.raycast=r.acceleratedRaycast,n.geometry.boundsTree=new r.MeshBVH(n.geometry))),i.add(n),n.position.set(l[0],l[1],l[2]),n.rotation.set(0,0,0),n.scale.x*=h[0],n.scale.y*=h[1],n.scale.z*=h[2],w(n,u),s&&g(n))}))}}else if("box"===c){(v=new e.Mesh).geometry=new e.BoxBufferGeometry(1,1,1),v.material=f,o.allowMeshBVH&&(v.raycast=r.acceleratedRaycast,v.geometry.boundsTree=new r.MeshBVH(v.geometry));var y=b(t.children[0].getAttribute("size"));i.add(v),v.scale.set(y[0],y[1],y[2]),s&&g(v)}else if("sphere"===c){(v=new e.Mesh).geometry=new e.SphereBufferGeometry(1,30,30),v.material=f,o.allowMeshBVH&&(v.raycast=r.acceleratedRaycast,v.geometry.boundsTree=new r.MeshBVH(v.geometry));var _=parseFloat(t.children[0].getAttribute("radius"))||0;v.scale.set(_,_,_),i.add(v),s&&g(v)}else if("cylinder"===c){(v=new e.Mesh).geometry=new e.CylinderBufferGeometry(1,1,1,30),v.material=f,o.allowMeshBVH&&(v.raycast=r.acceleratedRaycast,v.geometry.boundsTree=new r.MeshBVH(v.geometry));var E=parseFloat(t.children[0].getAttribute("radius"))||0,S=parseFloat(t.children[0].getAttribute("length"))||0;v.scale.set(E,S,E),v.rotation.set(x/2,0,0),i.add(v),s&&g(v)}}else"origin"===a&&(l=b(t.getAttribute("xyz")),u=b(t.getAttribute("rpy")))})),v&&(w(v,u,!0),v.position.set(l[0],l[1],l[2]))}var u=this,h=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},d=h.packages||"",m=h.loadMeshCb||this.defaultMeshLoader.bind(this),v=h.workingPath||"",y=!("parseVisual"in h)||h.parseVisual,C=h.parseCollision||!1,A=this.manager,T={},M={},O={};return function(e){var t=p((new DOMParser).parseFromString(e,"text/xml").children).filter((function(e){return"robot"===e.nodeName})).pop();return o.call(u,t)}(t)}},{key:"defaultMeshLoader",value:function(r,i,o){/\.stl(?:\?|$)/i.test(r)?new t.STLLoader(i).load(r,(function(t){var n=new e.Mesh(t,new e.MeshPhongMaterial);o(n)})):/\.dae(?:\?|$)/i.test(r)?new n.ColladaLoader(i).load(r,(function(e){return o(e.scene)})):console.warn("URDFLoader: Could not load model at ".concat(r,".\nNo loader available"))}}]),a}()}(z,o,a,s)})))))),Jt=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.SphereGeometry(1,32,32),t.material=new i.MeshStandardMaterial,t.material.transparent=!0,t}return _(t,e),t}(Pt),Qt=function(e){function t(t,n){void 0===n&&(n=mt);var r=e.call(this,{sources:[t],options:H(H({},mt),n)})||this,i=r.options,o=i.alpha,a=i.color,s=i.radius;return r.object=new Rt,r.sphere=new Jt,r.object.add(r.sphere),r.sphere.setColor(a),r.sphere.setAlpha(o),r.sphere.setScale({x:s,y:s,z:s}),r}return _(t,e),t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t)},t.prototype.update=function(t){var n;e.prototype.update.call(this,t);var r=t.point,i=r.x,o=r.y,a=r.z;null===(n=this.object)||void 0===n||n.position.set(i,o,a)},t}(Vt);window.WebAssembly||n.e(2).then(n.bind(null,"So+1")).then(e=>{tn.attachDecoder(e)});var en=function(e,t,n,r){var i=e.attributes[t];N(i),i.updateRange={offset:0,count:3*r},i.count=r,i.array=n,i.needsUpdate=!0},tn=function(){function e(){}return e.decode=function(e,t,n){var r=e.height*e.width,o=new Float32Array(3*r),a=new Float32Array(3*r),s=new Float32Array(3*r),c=Uint8Array.from(e.data).buffer,l=new DataView(c),u={},h={},d=new i.Color;e.fields.forEach((function(e){u[e.name]=e.offset,h[e.name]=function(e,t){switch(t){case ke.INT8:return e.getInt8;case ke.UINT8:return e.getUint8;case ke.INT16:return e.getInt16;case ke.UINT16:return e.getUint16;case ke.INT32:return e.getInt32;case ke.UINT32:return e.getUint32;case ke.FLOAT64:return e.getFloat64;case ke.FLOAT32:default:return e.getFloat32}}(l,e.datatype)}));for(var f,p=0;p<r;p++){if(f=p*e.point_step,void 0!==u.x&&void 0!==u.y&&void 0!==u.z&&(o[3*p]=h.x.call(l,f+u.x,!e.is_bigendian),o[3*p+1]=h.y.call(l,f+u.y,!e.is_bigendian),o[3*p+2]=h.z.call(l,f+u.z,!e.is_bigendian)),void 0!==u.rgb&&t===Ne.RGB&&(a[3*p]=l.getUint8(f+u.rgb+2)/255,a[3*p+1]=l.getUint8(f+u.rgb+1)/255,a[3*p+2]=l.getUint8(f+u.rgb)/255),void 0!==u.intensity&&t===Ne.INTENSITY){var m=h.intensity.call(l,f+u.intensity,!e.is_bigendian),g=y(m,360)/360;if(n){var v=d.setHSL(g,1,.5).toArray().map((function(e){return 255*e}));a[3*p]=v[0]/255,a[3*p+1]=v[1]/255,a[3*p+2]=v[2]/255}else a[3*p]=g/360,a[3*p+1]=g/360,a[3*p+2]=g/360}void 0!==u.normal_x&&void 0!==u.normal_y&&void 0!==u.normal_z&&(s[3*p]=h.normal_x.call(l,f+u.normal_x,!e.is_bigendian),s[3*p+1]=h.normal_y.call(l,f+u.normal_y,!e.is_bigendian),s[3*p+2]=h.normal_z.call(l,f+u.normal_z,!e.is_bigendian))}return{positions:o,colors:a,normals:s}},e.attachDecoder=function(t){var n=t.get_memory,r=new(0,t.PCLDecoder),i=n();e.decode=function(e,t,n){var o=e.height*e.width,a={},s=new Float32Array(3*o);e.fields.forEach((function(e){a[e.name]=e.offset}));var c=new Uint8Array(i.buffer),l=r.get_copy_memory_ptr();c.set(e.data,l),r.compute(o,e.point_step,a.x,a.y,a.z,a.rgb||0,a.intensity||0,t===Ne.INTENSITY,n);var u=r.get_position_memory_ptr(),h=r.get_color_memory_ptr();return{positions:new Float32Array(i.buffer,u,3*o),colors:t===Ne.INTENSITY&&!a.intensity||t===Ne.RGB&&!a.rgb?new Float32Array(3*o):new Float32Array(i.buffer,h,3*o),normals:s}}},e}(),nn=function(e){function t(t,n){void 0===n&&(n=pt);var r=e.call(this,{sources:[t],options:H(H({},pt),n)})||this;r.update=function(t){e.prototype.update.call(r,t);var n=function(e,t){if(void 0===t&&(t=pt),!e)return{positions:new Float32Array(0),colors:new Float32Array(0),normals:new Float32Array(0)};var n=t.colorChannel,r=t.useRainbow,i=tn.decode(e,n,r),o=i.colors,a=i.normals;return{positions:i.positions,colors:o,normals:a}}(t,r.options),i=n.colors,o=n.normals,a=n.positions;r.updatePointCloudGeometry(a,i,o)};var o=new i.PointsMaterial({size:r.options.size,color:i.VertexColors}),a=new i.BufferGeometry;return a.setAttribute("position",new i.BufferAttribute(new Float32Array(3*Y),3).setUsage(i.DynamicDrawUsage)),a.setAttribute("color",new i.BufferAttribute(new Float32Array(3*Y),3).setUsage(i.DynamicDrawUsage)),a.setAttribute("normal",new i.BufferAttribute(new Float32Array(3*Y),3).setUsage(i.DynamicDrawUsage)),a.setDrawRange(0,0),a.computeBoundingSphere(),r.object=new i.Points(a,o),r.object.frustumCulled=!1,r.updateOptions(H(H({},pt),n)),r}return _(t,e),t.prototype.updatePointCloudGeometry=function(e,t,n){var r=Number.isNaN;M(this.object);var i=this.object,o=i.geometry,a=i.material;a.size===this.options.size||r(this.options.size)||(a.size=this.options.size,a.needsUpdate=!0);var s=y(Y,g(e.length/3));D(o),o.setDrawRange(0,s),en(o,"position",e,s),en(o,"color",t,s),en(o,"normal",n,s)},t}(Vt),rn=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.BoxGeometry,t.material=new i.MeshStandardMaterial,t}return _(t,e),t}(Pt),on=function(e){function t(t,n){void 0===n&&(n=5);var r=e.call(this)||this;return r.geometry=new i.Geometry,r.material=new i.LineBasicMaterial({linewidth:n,color:i.VertexColors}),r}return _(t,e),t.prototype.isValid=function(e){return e.length<=this.geometry.vertices.length},t.prototype.setColor=function(e){kt(this,e)},t.prototype.updatePoints=function(e,t){this.geometry.vertices=e.map((function(e){var t=e.x,n=e.y,r=e.z;return new i.Vector3(t,n,r)})),this.geometry.verticesNeedUpdate=!0,0<t.length&&(this.geometry.colors=t.map((function(e){var t=e.r,n=e.g,r=e.b;return new i.Color(t,n,r)})),this.geometry.colorsNeedUpdate=!0)},t.prototype.setTransform=function(e){Mt(this,e)},t}(i.LineSegments),an=function(){function e(e,t){this.objectPool=e,this.Primitive=t}return e.prototype.setObjectDimension=function(e,t,n,r){var i=t.x,o=t.y,a=t.z;e.setColor(n),e.setScale(r),e.position.set(i,o,a)},e.prototype.reusePool=function(e,t,n){for(var r,i=n.scale,o=e.length,a=0;a<o;a++)r=this.objectPool.children[a],this.setObjectDimension(r,e[a],t[a],i);for(a=o;a<this.objectPool.children.length;a++)this.objectPool.children[a].visible=!1},e.prototype.increasePool=function(e,t,n){for(var r,i=this.objectPool.children.length,o=n.scale,a=0;a<i;a++)r=this.objectPool.children[a],this.setObjectDimension(r,e[a],t[a],o);for(a=i;a<e.length;a++){var s=new this.Primitive,c=e[a],l=c.x,u=c.y,h=c.z;s.setColor(t[a]),s.setScale(o),s.position.set(l,u,h),this.objectPool.add(s)}},e}(),sn=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.Geometry,t.material=new i.MeshBasicMaterial,t.objectCacher=new an(t,Jt),t}return _(t,e),t.prototype.updatePoints=function(e,t,n){var r=H(H({},n),{subtype:Le.SPHERE});e.length<this.children.length?this.objectCacher.reusePool(e,t,r):this.objectCacher.increasePool(e,t,r)},t}(Pt),cn=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.Geometry,t.material=new i.PointsMaterial({color:i.VertexColors}),t}return _(t,e),t.prototype.setTransform=function(e){Mt(this,e)},t.prototype.updatePoints=function(e,t,n){var r=n.scale.x;this.material.size=r,this.geometry.vertices=e.map((function(e){return new i.Vector3(e.x,e.y,e.z)})),this.geometry.verticesNeedUpdate=!0,0<t.length&&(this.geometry.colors=t.map((function(e){return new i.Color(e.r,e.g,e.b)})),this.geometry.colorsNeedUpdate=!0)},t.prototype.setScale=function(e){this.material.size="number"==typeof e?e:e.x},t}(i.Points),ln=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.Geometry,t.material=new i.MeshBasicMaterial({color:i.FaceColors}),t.material.side=i.DoubleSide,t}return _(t,e),t.prototype.updatePoints=function(e,t,n){void 0===t&&(t=[]);var r=[],o=[],a=n.scale,s=a.x,c=a.y,l=a.z;this.scale.set(s,c,l);for(var u=0,h=e.length/3;u<h;u++){[e[3*u],e[3*u+1],e[3*u+2]].map((function(e){r.push(new i.Vector3(e.x,e.y,e.z))}));var d=0===t.length?{r:1,g:0,b:0}:t[3*u];o.push(new i.Face3(3*u,3*u+2,3*u+1,new i.Vector3,new i.Color(d.r,d.g,d.b)))}this.geometry.vertices=r,this.geometry.faces=o,this.geometry.computeFaceNormals(),this.geometry.computeVertexNormals(),this.geometry.elementsNeedUpdate=!0,this.geometry.verticesNeedUpdate=!0},t}(Pt),un=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.Geometry,t.material=new i.MeshBasicMaterial,t.objectCacher=new an(t,rn),t}return _(t,e),t.prototype.updatePoints=function(e,t,n){var r=H(H({},n),{subType:Le.CUBE});e.length<this.children.length?this.objectCacher.reusePool(e,t,r):this.objectCacher.increasePool(e,t,r)},t}(Pt),hn=function(e){function t(t){var n=e.call(this)||this;return n.color=new i.Color(1,1,1),n.text=new c(t,1,"#"+n.color.getHexString()),n.add(n.text),n}return _(t,e),t.prototype.setColor=function(e){var t=e.b,n=e.g,r=e.r;this.color.r===r&&this.color.g===n&&this.color.b===t||(this.color=new i.Color(r,n,t),this.text.color="#"+this.color.getHexString())},t}(Pt),dn=function(e){switch(e.type){case Le.CUBE:return new rn;case Le.SPHERE:return new Jt;case Le.CYLINDER:var t=new Rt;return t.add(new Nt),t;case Le.LINE_LIST:return new on;case Le.LINE_STRIP:return new Ut;case Le.SPHERE_LIST:return new sn;case Le.POINTS:return new cn;case Le.TRIANGLE_LIST:return new ln;case Le.CUBE_LIST:return new un;case Le.TEXT_VIEW_FACING:return new hn(e.text);case Le.ARROW:default:var n=new Bt;return n.setHeadDimensions({radius:.1,length:.3}),n.setShaftDimensions({radius:.05,length:.7}),n}},fn=function(){function e(e){this.timeouts={},this.timeouts={},this.onTimeout=e}return e.prototype.track=function(e,t){var n=this;clearInterval(this.timeouts[e]),0===t||(this.timeouts[e]=window.setTimeout((function(){n.onTimeout(e)}),1e3*t))},e.prototype.untrack=function(e){clearInterval(this.timeouts[e]),delete this.timeouts[e]},e.prototype.destroy=function(){var e,t,n=Object.keys(this.timeouts);try{for(var r,i=C(n),o=i.next();!o.done;o=i.next())r=o.value,clearInterval(this.timeouts[r]),delete this.timeouts[r]}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}},e}(),pn=function(){function e(e,t){this.objectMap={},this.namespaces={},this.object=e,this.onChangeCb=t,this.markerLifetime=new fn(this.onMarkerLifetimeOver.bind(this))}return e.prototype.onMarkerLifetimeOver=function(e){this.objectMap[e]&&this.removeObject(e)},e.prototype.getMarkerOrCreate=function(t){var n=e.getId(t);if(this.objectMap[n])this.objectMap[n]instanceof on&&!this.objectMap[n].isValid(t.points)&&(this.removeObject(n),this.objectMap[n]=dn(t),this.object.add(this.objectMap[n]));else{var r=dn(t);this.objectMap[n]=r,this.object.add(r)}return this.objectMap[n].visible=this.namespaces[t.ns],this.objectMap[n]},e.prototype.extractNameSpace=function(e){return e.split("-")[0]},e.prototype.updateOptions=function(e){var t=e.namespaces;for(var n in this.namespaces=t,this.objectMap)if(this.objectMap.hasOwnProperty(n)){var r=this.extractNameSpace(n);this.objectMap[n].visible=this.namespaces[r]}},e.prototype.onChange=function(){this.onChangeCb()},e.prototype.updateMarker=function(t){var n=t.color,r=t.colors,i=t.lifetime,o=t.points,a=t.pose,s=a.orientation,c=a.position,l=t.scale,u=this.getMarkerOrCreate(t),h=e.getId(t);this.markerLifetime.track(h,i.secs),u.updatePoints&&u.updatePoints(o,r,t),u.setTransform({translation:c,rotation:s}),u.setScale&&!u.updatePoints&&u.setScale({x:l.x,y:l.y,z:l.z}),u.setColor&&0>=r.length&&u.setColor(n);var d=t.ns;d in this.namespaces||(this.namespaces[d]=!0,this.onChange())},e.prototype.removeObject=function(e){var t,n=this.objectMap[e];null===(t=n.parent)||void 0===t||t.remove(n),delete this.objectMap[e]},e.prototype.reset=function(){var e=this;this.namespaces={},this.markerLifetime.destroy(),this.onChange(),Object.keys(this.objectMap).forEach((function(t){e.removeObject(t)}))},e.getId=function(e){return e.ns+"-"+e.id},e}(),mn=function(e){function t(t,n){void 0===n&&(n=lt);var r,i=e.call(this,{sources:[t],options:H(H({},lt),n)})||this;return i.reset=function(){i.markerManager.reset()},i.object=new Rt,i.markerManager=new pn(i.object,null!==(r=i.onNameSpaceChange)&&void 0!==r?r:function(){return null}),i}return _(t,e),t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t),this.markerManager.updateOptions(this.options)},t.prototype.update=function(t){var n=this;e.prototype.update.call(this,t),t.markers.forEach((function(e){n.markerManager.updateMarker(e)}))},t}(Vt),gn=function(){function e(e){void 0===e&&(e={}),this.maxPts=e.max_pts||1e4,this.rootObject=e.rootObject||new i.Object3D}return e.prototype.setup=function(e,t,n){var r=this;this.rootObject.children.forEach((function(e){r.rootObject.remove(e)})),this.positions=new i.BufferAttribute(new Float32Array(3*this.maxPts),3,!1),this.colors=new i.BufferAttribute(new Float32Array(3*this.maxPts),3,!1);var o={};e===je.POINTS&&(o={map:(new i.TextureLoader).load("https://raw.githubusercontent.com/mrdoob/three.js/master/examples/textures/sprites/circle.png"),alphaTest:.5}),this.geometry=new i.BufferGeometry,this.geometry.setAttribute("position",this.positions.setUsage(i.DynamicDrawUsage)),this.geometry.setAttribute("color",this.colors.setUsage(i.DynamicDrawUsage)),this.material=new i.PointsMaterial(H({color:8947848,size:t},o)),this.material.transparent=!0,this.material.opacity=n,this.object=new i.Points(this.geometry,this.material),this.rootObject.add(this.object)},e.prototype.update=function(e){M(this.geometry),M(this.positions),M(this.colors),this.geometry.setDrawRange(0,e),this.positions.needsUpdate=!0,this.colors.needsUpdate=!0,this.positions.updateRange.count=e*this.positions.itemSize,this.colors.updateRange.count=e*this.colors.itemSize},e.prototype.setAlpha=function(e){M(this.material),this.material.opacity=e},e.prototype.setSize=function(e){M(this.material),this.material.size=e},e}(),vn=function(e){function t(t,n){void 0===n&&(n=at);var r=e.call(this,{sources:[t],options:H(H({},at),n)})||this;return r.cachedMessage=null,r.points=new gn,r.sphereList=new sn,r.cubeList=new un,r.object=new Rt,r.object.add(r.points.rootObject),r.object.add(r.sphereList),r.object.add(r.cubeList),r}return _(t,e),t.prototype.getNormalizedIntensity=function(e){var t=this.options,n=t.maxIntensity,r=t.minIntensity;return(e-r)/(n-r)},t.prototype.applyIntensityTransform=function(e,t){var n,r=this.options,o=r.channelName,a=r.maxColor,s=r.minColor,c=t.x,l=t.y,u=t.z;o===Be.INTENSITY?n=this.getNormalizedIntensity(e):o===Be.X?n=this.getNormalizedIntensity(c):o===Be.Y?n=this.getNormalizedIntensity(l):o===Be.Z&&(n=this.getNormalizedIntensity(u));var h=new i.Color(s),d=new i.Color(a);M(n);var f=n*d.getHex()+(1-n)*h.getHex();return new i.Color(f)},t.prototype.getNormalizedAxisValue=function(e){var t=this.options,n=t.maxAxisValue,r=t.minAxisValue;return(e-r)/(n-r)},t.prototype.applyAxisColorTransform=function(e,t){var n,r=this.options,o=r.axis,a=r.maxAxisValue,s=r.minAxisValue,c=t.x,l=t.y,u=t.z;o===Ie.X?n=this.getNormalizedAxisValue(c):o===Ie.Y?n=this.getNormalizedAxisValue(l):o===Ie.Z&&(n=this.getNormalizedAxisValue(u)),M(n);var h=n*a+(1-n)*s;return new i.Color(h)},t.prototype.colorTransformer=function(e,t){var n=this.options,r=n.colorTransformer,o=n.flatColor;return r===De.INTENSITY?this.applyIntensityTransform(e,t):r===De.AXIS_COLOR?this.applyAxisColorTransform(e,t):r===De.FLAT_COLOR?new i.Color(o):null},t.prototype.setupPoints=function(e,t,n){M(n),M(this.points.colors),M(this.points.positions),R(this.points.colors.array),R(this.points.positions.array),this.points.colors.array[e]=n.r,this.points.positions.array[e++]=t.x,this.points.colors.array[e]=n.g,this.points.positions.array[e++]=t.y,this.points.colors.array[e]=n.b,this.points.positions.array[e++]=t.z},t.prototype.hideAllObjects=function(){this.points.rootObject.visible=!1,this.sphereList.visible=!1,this.cubeList.visible=!1},t.prototype.setStyleDimensions=function(e){var t=this.options,n=t.alpha,r=t.style,i=this.options.size,o=e.intensities,a=e.ranges.length,s=[],c=[];if(!(.001>i)&&i){this.hideAllObjects(),this.points.setup(r,i,n);for(var l,u=0,h=0;h<a;h++)if((l=e.ranges[h])>=e.range_min&&l<=e.range_max){var d=e.angle_min+h*e.angle_increment,f={x:l*w(d),y:l*b(d),z:0},p=this.colorTransformer(o[h],f);switch(r){case je.POINTS:case je.SQUARES:case je.FLAT_SQUARES:this.setupPoints(u,f,p),u+=3;break;default:s.push(f),c.push(p)}}var m={scale:{x:i,y:i,z:i}};switch(r){case je.SPHERES:this.sphereList.visible=!0,this.sphereList.updatePoints(s,c,m);break;case je.BOXES:this.cubeList.visible=!0,this.cubeList.updatePoints(s,c,m);break;default:this.points.rootObject.visible=!0,this.points.update(u/3)}}},t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t),this.cachedMessage&&this.setStyleDimensions(this.cachedMessage)},t.prototype.update=function(t){e.prototype.update.call(this,t),this.setStyleDimensions(t),this.cachedMessage=t},t}(Vt),yn=function(e){var t=document.createElement("canvas");t.width=e.width,t.height=e.height;var n=t.getContext("2d");return null==n||n.putImageData(e,0,0),t},bn=function(e,t,n,r){for(var i=e.data,o=e.height,a=e.step,s=Uint8Array.from(i),c=new DataView(s.buffer),l=0,u=0;u<a*o;u+=t){for(var h=0;h<n.length;h++)r.data[l++]=c.getUint8(u+n[h]);3===n.length&&(r.data[l++]=255)}},wn=function(e){function t(){var t=e.call(this)||this;return t.geometry=new i.PlaneGeometry,t.material=new i.MeshBasicMaterial,t}return _(t,e),t}(Pt),xn=function(e){function t(t,n){void 0===n&&(n=st);var r=e.call(this,{sources:[t],options:H(H({},st),n)})||this;return r.cachedMessage=null,r.object=new wn,O(r.object),k(r.object.material),r.object.material.transparent=!0,r.updateOptions(H(H({},st),n)),r}return _(t,e),t.prototype.updateOptions=function(t){O(this.object),k(this.object.material),e.prototype.updateOptions.call(this,t);var n=this.options,r=n.alpha,o=n.drawBehind;this.object.material.opacity=r,this.object.material.side=o?i.DoubleSide:i.FrontSide,this.object.material.needsUpdate=!0,this.cachedMessage&&this.setCanvasData(this.cachedMessage)},t.prototype.updateCanvasDimensions=function(e){var t,n,r,o=e.info,a=o.height,s=o.origin,c=s.orientation,l=c.w,u=c.x,h=c.y,d=c.z,f=s.position,p=f.x,m=f.y,g=f.z,v=o.resolution,y=o.width;null===(t=this.object)||void 0===t||t.scale.set(y*v,-1*a*v,1),null===(n=this.object)||void 0===n||n.position.set(y*v/2+p,a*v/2+m,g||.01),null===(r=this.object)||void 0===r||r.quaternion.copy(new i.Quaternion(u,h,d,l).normalize())},t.prototype.setCanvasData=function(e){var t=this.options.colorScheme,n=e.data,r=e.info,o=r.height,a=r.width,s=new ImageData(a,o),c=null;t===Fe.MAP?(function(e,t,n,r){for(var i=0;i<n;i++)for(var o=0;o<t;o++){var a=r[o+(n-i-1)*t],s=new DataView(Uint8Array.from([a]).buffer).getUint8(0),c=4*(o+i*t);if(0<=s&&100>=s){var l=255-255*s/100;e.data[c]=l,e.data[++c]=l,e.data[++c]=l,e.data[++c]=255}else 101<=s&&127>=s?(e.data[c]=0,e.data[++c]=255,e.data[++c]=0,e.data[++c]=255):128<=s&&254>=s?(e.data[c]=255,e.data[++c]=255*(s-128)/126,e.data[++c]=0,e.data[++c]=255):(e.data[c]=112,e.data[++c]=137,e.data[++c]=134,e.data[++c]=255)}}(s,a,o,n),c=yn(s)):t===Fe.CONST_MAP?(function(e,t,n,r){for(var i=0;i<n;i++)for(var o=0;o<t;o++){var a=r[o+(n-i-1)*t],s=new DataView(Uint8Array.from([a]).buffer).getUint8(0),c=4*(o+i*t);if(0===s)e.data[c]=0,e.data[++c]=0,e.data[++c]=0,e.data[++c]=0;else if(1<=s&&98>=s){var l=255*s/100;e.data[c]=l,e.data[++c]=0,e.data[++c]=255-l,e.data[++c]=255}else 99===s?(e.data[c]=0,e.data[++c]=255,e.data[++c]=255,e.data[++c]=255):100===s?(e.data[c]=255,e.data[++c]=0,e.data[++c]=255,e.data[++c]=255):100<s&&127>=s?(e.data[c]=0,e.data[++c]=255,e.data[++c]=0,e.data[++c]=255):128<=s&&254>=s?(e.data[c]=255,e.data[++c]=255*(s-128)/126,e.data[++c]=0,e.data[++c]=255):(e.data[c]=112,e.data[++c]=137,e.data[++c]=134,e.data[++c]=255)}}(s,a,o,n),c=yn(s)):t===Fe.RAW&&(function(e,t,n,r){for(var i=0;i<n;i++)for(var o=0;o<t;o++){var a=r[o+(n-i-1)*t],s=4*(o+i*t),c=new DataView(Uint8Array.from([a]).buffer).getUint8(0);e.data[s]=c,e.data[++s]=c,e.data[++s]=c,e.data[++s]=255}}(s,a,o,n),c=yn(s)),O(this.object),function(e){if(!(e instanceof i.MeshBasicMaterial))throw new TypeError("Expected 'val' to be MeshBasicMaterial")}(this.object.material),c&&(this.object.material.map=new i.CanvasTexture(c),this.object.material.map.minFilter=i.NearestFilter,this.object.material.map.magFilter=i.NearestFilter,this.object.material.needsUpdate=!0),this.updateCanvasDimensions(e)},t.prototype.update=function(t){e.prototype.update.call(this,t),this.setCanvasData(t),this.cachedMessage=t},t}(Vt),_n=function(e){function t(t,n){void 0===n&&(n=ht);var r=e.call(this,{sources:[t],options:H(H({},ht),n)})||this;return r.objectPool=[],r.keepSize=100,r.currentObjectIndex=-1,r.object=new Rt,r}return _(t,e),t.prototype.setKeepSize=function(e){var t,n=[];if(0!==e){if(e<this.keepSize&&e<this.objectPool.length){for(var r=this.objectPool.length-e,i=0;i<r;i++)null===(t=this.object)||void 0===t||t.remove(this.objectPool[i]);n=T(this.objectPool.slice(this.objectPool.length-e,this.objectPool.length))}else n=T(this.objectPool);this.objectPool=n,this.keepSize=e,this.currentObjectIndex=this.objectPool.length-1}else this.keepSize=0},t.prototype.removeAllObjects=function(){var e=this;this.objectPool.forEach((function(t,n){var r;null===(r=t.parent)||void 0===r||r.remove(t),delete e.objectPool[n]})),this.objectPool=[]},t.prototype.checkToleranceThresholdExceed=function(e){return 0===this.objectPool.length||function(e,t,n){var r=n.angleTolerance,i=n.positionTolerance,o=t.position,a=t.quaternion,s=e.position,c=e.quaternion,l=s.distanceTo(o)>i,u=c.angleTo(a)>r;return l||u}({position:this.objectPool[this.currentObjectIndex].position,quaternion:this.objectPool[this.currentObjectIndex].quaternion},e,this.options)},t.prototype.getObject=function(){var e=this.options.type;return e===ze.arrow?new Bt:e===ze.axes?new zt:new i.Object3D},t.prototype.changeObjectPoolType=function(){var e=this,t=[];this.objectPool.forEach((function(n,r){var i,o,a=n.position,s=n.quaternion;null===(i=n.parent)||void 0===i||i.remove(n),delete e.objectPool[r];var c=e.getObject();c.position.set(a.x,a.y,a.z),c.quaternion.set(s.x,s.y,s.z,s.w),t.push(c),null===(o=e.object)||void 0===o||o.add(c),At(c,e.options)})),this.objectPool=t},t.prototype.updateOptions=function(t){var n=this,r=this.options.type;e.prototype.updateOptions.call(this,t);var i=this.options,o=i.keep;i.type!==r&&this.changeObjectPoolType(),this.objectPool.forEach((function(e){At(e,n.options)})),this.setKeepSize(o)},t.prototype.update=function(t){var n,r;if(e.prototype.update.call(this,t),this.keepSize){var o=t.pose.pose,a=o.orientation,s=o.position,c={position:new i.Vector3(s.x,s.y,s.z),quaternion:new i.Quaternion(a.x,a.y,a.z,a.w)};if(this.checkToleranceThresholdExceed(c)){var l=this.getObject();if(At(l,this.options),this.objectPool.push(l),this.currentObjectIndex+=1,this.currentObjectIndex=i.MathUtils.clamp(this.currentObjectIndex,0,this.keepSize-1),null===(n=this.object)||void 0===n||n.add(l),Mt(l,{translation:s,rotation:a}),this.objectPool.length>this.keepSize){var u=this.objectPool[0];null===(r=this.object)||void 0===r||r.remove(u),delete this.objectPool[0];var h=this.objectPool.slice(1);this.objectPool=T(h)}}}else this.removeAllObjects()},t}(Vt),En=function(e){function t(t,n){void 0===n&&(n=xt);var r=e.call(this,{sources:[t],options:H(H({},xt),n)})||this;return r.object=new i.Group,r}return _(t,e),t.prototype.update=function(t){M(this.object),e.prototype.update.call(this,t),this.object.children.forEach((function(e){var t;null===(t=e.parent)||void 0===t||t.remove(e)})),this.object.children=[];for(var n,r=0;r<t.poses.length;r++)(n=$t.getNewPrimitive(this.options))&&(Mt(n,{translation:t.poses[r].position,rotation:t.poses[r].orientation}),At(n,this.options),this.object.add(n))},t}(Vt),Sn=function(e){function t(t,n){void 0===n&&(n=dt);var r=e.call(this,{sources:[t],options:H(H({},dt),n)})||this,o=r.options,a=o.alpha,s=o.color;return r.object=new Rt,r.line=new Ut(null,!0),r.line.setColor(new i.Color(s)),r.line.setAlpha(a),r}return _(t,e),t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t);var n=this.options,r=n.alpha,o=n.color;this.line.setColor(new i.Color(o)),this.line.setAlpha(r)},t.prototype.update=function(t){var n;e.prototype.update.call(this,t);var r=(t.poses||[]).map((function(e){return e.pose.position}));this.line.updatePoints(r),null===(n=this.object)||void 0===n||n.add(this.line)},t}(Vt),Cn=function(e){function t(t,n){void 0===n&&(n=it);var r=e.call(this,{sources:[t],options:H(H({},it),n)})||this;r.hide=function(){M(r.object),r.object.style.visibility="hidden"},r.show=function(){M(r.object),r.object.style.visibility="visible"};var i=r.options,o=i.height,a=i.width;return r.object=document.createElement("canvas"),r.shadowObject=document.createElement("canvas"),r.object.width=a,r.object.height=o,r}return _(t,e),t.prototype.applyImageData=function(e){var t=e.encoding,n=e.height,r=e.width;M(this.object);var i=this.object.getContext("2d");M(i);var o=this.shadowObject.getContext("2d");M(o);var a=o.createImageData(r,n),s=r/n;switch(t){case"bayer_rggb8":case"bayer_bggr8":case"bayer_gbrg8":case"bayer_grbg8":case"bayer_rggb16":case"bayer_bggr16":case"bayer_gbrg16":case"bayer_grbg16":case"8UC1":case"8SC1":case"mono8":bn(e,1,[0,0,0],a);break;case"8UC3":case"8SC3":case"bgr8":bn(e,3,[2,1,0],a);break;case"8UC4":case"8SC4":case"bgra8":bn(e,4,[2,1,0,3],a);break;case"rgb8":bn(e,3,[0,1,2],a);break;case"rgba8":bn(e,4,[0,1,2,3],a)}i.clearRect(0,0,this.object.width,this.object.height),i.fillStyle="#000",i.fillRect(0,0,this.object.width,this.object.height),o.clearRect(0,0,this.shadowObject.width,this.shadowObject.height),o.putImageData(a,0,0);var c=this.object.width/s,l=this.object.height*s;s>=this.object.width/this.object.height?i.drawImage(this.shadowObject,0,0,r,n,0,(this.object.height-c)/2,this.object.width,c):i.drawImage(this.shadowObject,0,0,r,n,(this.object.width-l)/2,0,l,this.object.height)},t.prototype.updateDimensions=function(e,t){M(this.object),this.object.width=e,this.object.height=t},t.prototype.update=function(e){var t=e.height,n=e.width;this.shadowObject.width=n,this.shadowObject.height=t,this.applyImageData(e)},t}(Vt),An=function(e){function t(t,n){void 0===n&&(n=ot);var r=e.call(this,{options:H(H({},ot),n)})||this;r.hide=function(){M(r.object),r.object.style.visibility="hidden"},r.show=function(){M(r.object),r.object.style.visibility="visible"};var i=r.options,o=i.height,a=i.width;return r.url=t,r.object=document.createElement("img"),r.object.src=r.url,r.object.setAttribute("draggable","false"),r.object.width=a,r.object.height=o,r}return _(t,e),t}(function(){function e(e){var t,n=this;this.hide=function(){M(n.object),P(n.object)?n.object.visible=!1:L(n.object)&&(n.object.style.visibility="hidden")},this.show=function(){M(n.object),P(n.object)?n.object.visible=!0:L(n.object)&&(n.object.style.visibility="visible")},this.destroy=function(){var e,t,r,i;P(n.object)?null===(t=null===(e=n.object)||void 0===e?void 0:e.parent)||void 0===t||t.remove(n.object):L(n.object)&&(null===(i=null===(r=n.object)||void 0===r?void 0:r.parentElement)||void 0===i||i.removeChild(n.object)),n.object=void 0},this.reset=function(){},this.options=null!==(t=e.options)&&void 0!==t?t:{},this.updateOptions=this.updateOptions.bind(this)}return e.prototype.updateOptions=function(e){this.options=H(H({},this.options),e)},e}()),Tn=function(e){function t(t,n){void 0===n&&(n=ct);var r,i=e.call(this,{sources:[t],options:H(H({},ct),n)})||this;return i.reset=function(){i.markerManager.reset()},i.object=new Rt,i.markerManager=new pn(i.object,null!==(r=i.onNameSpaceChange)&&void 0!==r?r:function(){return null}),i.updateOptions(H(H({},ct),n)),i}return _(t,e),t.prototype.updateOptions=function(t){e.prototype.updateOptions.call(this,t),this.markerManager.updateOptions(this.options)},t.prototype.update=function(t){e.prototype.update.call(this,t),this.markerManager.updateMarker(t)},t}(Vt),Mn=function(e){function t(t,n){void 0===n&&(n=_t);var r=e.call(this,{sources:[t],options:H(H({},_t),n)})||this,o=r.options,a=o.alpha,s=o.color;return r.object=new Rt,r.cylinder=new Nt(r.options.color,.01,.01),r.cylinder.rotateZ(x/2),r.object.add(r.cylinder),r.cylinder.setAlpha(a),r.cylinder.setColor(new i.Color(s)),r}return _(t,e),t.prototype.update=function(t){var n=Math.tan;e.prototype.update.call(this,t);var r=t.field_of_view,o=t.max_range,a=t.min_range;this.cylinder.geometry=new i.CylinderGeometry(a*n(r)/4,o*n(r)/4,o-a,32,32),this.cylinder.geometry.verticesNeedUpdate=!0,this.cylinder.position.setX(.5*(a+o))},t}(Vt),On=I((function(e){e.exports=function(){var e=function(){function t(e){return i.appendChild(e.dom),e}function n(e){for(var t=0;t<i.children.length;t++)i.children[t].style.display=t===e?"block":"none";r=e}var r=0,i=document.createElement("div");i.style.cssText="position:fixed;top:0;left:0;cursor:pointer;opacity:0.9;z-index:10000",i.addEventListener("click",(function(e){e.preventDefault(),n(++r%i.children.length)}),!1);var o=(performance||Date).now(),a=o,s=0,c=t(new e.Panel("FPS","#0ff","#002")),l=t(new e.Panel("MS","#0f0","#020"));if(self.performance&&self.performance.memory)var u=t(new e.Panel("MB","#f08","#201"));return n(0),{REVISION:16,dom:i,addPanel:t,showPanel:n,begin:function(){o=(performance||Date).now()},end:function(){s++;var e=(performance||Date).now();if(l.update(e-o,200),a+1e3<=e&&(c.update(1e3*s/(e-a),100),a=e,s=0,u)){var t=performance.memory;u.update(t.usedJSHeapSize/1048576,t.jsHeapSizeLimit/1048576)}return e},update:function(){o=this.end()},domElement:i,setMode:n}};return e.Panel=function(e,t,n){var r=1/0,i=0,o=m,a=o(window.devicePixelRatio||1),s=80*a,c=48*a,l=3*a,u=2*a,h=3*a,d=15*a,f=74*a,p=30*a,g=document.createElement("canvas");g.width=s,g.height=c,g.style.cssText="width:80px;height:48px";var b=g.getContext("2d");return b.font="bold "+9*a+"px Helvetica,Arial,sans-serif",b.textBaseline="top",b.fillStyle=n,b.fillRect(0,0,s,c),b.fillStyle=t,b.fillText(e,l,u),b.fillRect(h,d,f,p),b.fillStyle=n,b.globalAlpha=.9,b.fillRect(h,d,f,p),{dom:g,update:function(c,m){r=y(r,c),i=v(i,c),b.fillStyle=n,b.globalAlpha=1,b.fillRect(0,0,s,d),b.fillStyle=t,b.fillText(o(c)+" "+e+" ("+o(r)+"-"+o(i)+")",l,u),b.drawImage(g,h+a,d,f-a,p,h,d,f-a,p),b.fillRect(h+f-a,d,a,p),b.fillStyle=n,b.globalAlpha=.9,b.fillRect(h+f-a,d,a,o((1-c/m)*p))}}},e}()})),kn=function(e){function t(t){void 0===t&&(t=Ye);var n=e.call(this)||this;return n.options=Ye,n.vizWrapper=new i.Group,n.add(n.vizWrapper),n.stats=new On,n.stats.showPanel(0),n.initLights(),n.initGrid(),n.updateOptions(t),n}return _(t,e),t.prototype.initLights=function(){var e=this;[[-1,0],[1,0],[0,-1],[0,1]].forEach((function(t){var n,r=new i.DirectionalLight(16777215,.4);n=A(t,2),r.position.x=n[0],r.position.y=n[1],r.position.z=1,e.add(r)}));var t=new i.AmbientLight(16777215,.2);this.add(t)},t.prototype.initGrid=function(){this.grid=new i.GridHelper(0,0),this.add(this.grid)},t.prototype.addObject=function(e){this.vizWrapper.add(e)},t.prototype.addVisualization=function(e){var t=e.object;t&&(this.vizWrapper.getObjectById(t.id)||this.addObject(t))},t.prototype.getObjectByName=function(e){return this.vizWrapper.getObjectByName(e)},t.prototype.updateOptions=function(e){var t,n;void 0===e&&(e=Ye),this.options=H(H({},Ye),e);var r=this.options,o=r.backgroundColor,a=r.gridCenterlineColor,s=r.gridColor,c=r.gridDivisions,l=r.gridSize;null===(t=this.grid)||void 0===t||t.copy(new i.GridHelper(l,c,a,s)),null===(n=this.grid)||void 0===n||n.rotateX(-x/2),this.background=new i.Color(o)},t}(i.Scene),Rn=function(e){function t(t,n){void 0===n&&(n=rt);var r=e.call(this)||this;return r.options=rt,r.metaLoaded=!1,r.options=H(H({},rt),n),r.url=t,r.animate=r.animate.bind(r),r.onMetaLoaded=r.onMetaLoaded.bind(r),r}return _(t,e),t.prototype.onMetaLoaded=function(){this.metaLoaded=!0,this.initStreamer()},t.prototype.isMjpeg=function(){return"mjpeg"===this.options.streamType.toLowerCase()},t.prototype.initVideo=function(){var e=this.options,t=e.height,n=e.width;this.video=document.createElement(this.isMjpeg()?"img":"video"),this.video.width=n,this.video.height=t,this.video.addEventListener(this.isMjpeg()?"load":"loadedmetadata",this.onMetaLoaded,!1),this.isMjpeg()||(j(this.video),this.video.loop=!0),this.video.src=this.url,this.video.crossOrigin="Anonymous",this.video.setAttribute("crossorigin","Anonymous")},t.prototype.initStreamer=function(){var e=this.options,t=e.f,n=e.height,r=e.maxDepthPerTile,o=e.pointSize,a=e.varianceThreshold,s=e.whiteness,c=e.width,l=v(c,n)/1024;if(this.metaLoaded){this.texture=new i.Texture(this.video),this.geometry=new i.Geometry;for(var u=c/2,h=n/2,d=0;d<u*h;d+=1)this.geometry.vertices.push(new i.Vector3(d%u,d/u,0));this.material=new i.ShaderMaterial({uniforms:{map:{value:this.texture},width:{value:u},height:{value:h},focallength:{value:t},pointSize:{value:o},zOffset:{value:0},whiteness:{value:s},varianceThreshold:{value:a},maxDepthPerTile:{value:r},resolutionFactor:{value:l}},vertexShader:"uniform sampler2D map;\n\nuniform float width;\nuniform float height;\nuniform float nearClipping, farClipping;\n\nuniform float pointSize;\nuniform float zOffset;\n\nuniform float focallength;\nuniform float maxDepthPerTile;\nuniform float resolutionFactor;\n\nvarying vec2 vUvP;\nvarying vec2 colorP;\n\nvarying float depthVariance;\nvarying float maskVal;\n\nfloat sampleDepth(vec2 pos)\n  {\n    float depth;\n\n    vec2 vUv = vec2( pos.x / (width*2.0), pos.y / (height*2.0)+0.5 );\n    vec2 vUv2 = vec2( pos.x / (width*2.0)+0.5, pos.y / (height*2.0)+0.5 );\n\n    vec4 depthColor = texture2D( map, vUv );\n\n    depth = ( depthColor.r + depthColor.g + depthColor.b ) / 3.0 ;\n\n    if (depth>0.99)\n    {\n      vec4 depthColor2 = texture2D( map, vUv2 );\n      float depth2 = ( depthColor2.r + depthColor2.g + depthColor2.b ) / 3.0 ;\n      depth = 0.99+depth2;\n    }\n\n    return depth;\n  }\n\nfloat median(float a, float b, float c)\n  {\n    float r=a;\n\n    if ( (a<b) && (b<c) )\n    {\n      r = b;\n    }\n    if ( (a<c) && (c<b) )\n    {\n      r = c;\n    }\n    return r;\n  }\n\nfloat variance(float d1, float d2, float d3, float d4, float d5, float d6, float d7, float d8, float d9)\n  {\n    float mean = (d1 + d2 + d3 + d4 + d5 + d6 + d7 + d8 + d9) / 9.0;\n    float t1 = (d1-mean);\n    float t2 = (d2-mean);\n    float t3 = (d3-mean);\n    float t4 = (d4-mean);\n    float t5 = (d5-mean);\n    float t6 = (d6-mean);\n    float t7 = (d7-mean);\n    float t8 = (d8-mean);\n    float t9 = (d9-mean);\n    float v = (t1*t1+t2*t2+t3*t3+t4*t4+t5*t5+t6*t6+t7*t7+t8*t8+t9*t9)/9.0;\n    return v;\n  }\n\nvec2 decodeDepth(vec2 pos)\n  {\n    vec2 ret;\n\n\n    float depth1 = sampleDepth(vec2(position.x-1.0, position.y-1.0));\n    float depth2 = sampleDepth(vec2(position.x, position.y-1.0));\n    float depth3 = sampleDepth(vec2(position.x+1.0, position.y-1.0));\n    float depth4 = sampleDepth(vec2(position.x-1.0, position.y));\n    float depth5 = sampleDepth(vec2(position.x, position.y));\n    float depth6 = sampleDepth(vec2(position.x+1.0, position.y));\n    float depth7 = sampleDepth(vec2(position.x-1.0, position.y+1.0));\n    float depth8 = sampleDepth(vec2(position.x, position.y+1.0));\n    float depth9 = sampleDepth(vec2(position.x+1.0, position.y+1.0));\n\n    float median1 = median(depth1, depth2, depth3);\n    float median2 = median(depth4, depth5, depth6);\n    float median3 = median(depth7, depth8, depth9);\n\n    ret.x = median(median1, median2, median3);\n    ret.y = variance(depth1, depth2, depth3, depth4, depth5, depth6, depth7, depth8, depth9);\n\n    return ret;\n\n  }\n\n\nvoid main() {\n\n  vUvP = vec2( position.x / (width*2.0), position.y / (height*2.0)+0.5 );\n  colorP = vec2( position.x / (width*2.0)+0.5 , position.y / (height*2.0)  );\n\n  vec4 pos = vec4(0.0,0.0,0.0,0.0);\n  depthVariance = 0.0;\n\n  if ( (vUvP.x<0.0)|| (vUvP.x>0.5) || (vUvP.y<0.5) || (vUvP.y>0.0))\n  {\n    vec2 smp = decodeDepth(vec2(position.x, position.y));\n    float depth = smp.x;\n    depthVariance = smp.y;\n\n    float z = -depth;\n\n    pos = vec4(\n      ( position.x / width - 0.5 ) * z * 0.5 * maxDepthPerTile * resolutionFactor * (1000.0/focallength) * -1.0,\n      ( position.y / height - 0.5 ) * z * 0.5 * maxDepthPerTile * resolutionFactor * (1000.0/focallength),\n      (- z + zOffset / 1000.0) * maxDepthPerTile,\n      1.0);\n\n    vec2 maskP = vec2( position.x / (width*2.0), position.y / (height*2.0)  );\n    vec4 maskColor = texture2D( map, maskP );\n    maskVal = ( maskColor.r + maskColor.g + maskColor.b ) / 3.0 ;\n  }\n\n  gl_PointSize = pointSize;\n  gl_Position = projectionMatrix * modelViewMatrix * pos;\n\n}",fragmentShader:"uniform sampler2D map;\nuniform float varianceThreshold;\nuniform float whiteness;\n\nvarying vec2 vUvP;\nvarying vec2 colorP;\n\nvarying float depthVariance;\nvarying float maskVal;\n\n\nvoid main() {\n\n  vec4 color;\n\n  if ( (depthVariance>varianceThreshold) || (maskVal>0.5) ||(vUvP.x<0.0)|| (vUvP.x>0.5) || (vUvP.y<0.5) || (vUvP.y>1.0))\n  {\n    discard;\n  }\n  else\n  {\n    color = texture2D( map, colorP );\n\n    float fader = whiteness /100.0;\n\n    color.r = color.r * (1.0-fader)+ fader;\n\n    color.g = color.g * (1.0-fader)+ fader;\n\n    color.b = color.b * (1.0-fader)+ fader;\n\n    color.a = 1.0;//smoothstep( 20000.0, -20000.0, gl_FragCoord.z / gl_FragCoord.w );\n  }\n\n  gl_FragColor = vec4( color.r, color.g, color.b, color.a );\n\n}"}),this.mesh=new i.Points(this.geometry,this.material),this.mesh.frustumCulled=!1,this.mesh.position.set(0,0,0),this.add(this.mesh),requestAnimationFrame(this.animate)}},t.prototype.animate=function(){var e;this.texture&&(this.isMjpeg()?this.texture.needsUpdate=!0:(j(this.video),this.video.readyState===this.video.HAVE_ENOUGH_DATA&&(this.texture.needsUpdate=!0)),(null===(e=this.video)||void 0===e?void 0:e.src)&&requestAnimationFrame(this.animate))},t.prototype.startStream=function(){this.isMjpeg()||(j(this.video),this.video.play())},t.prototype.stopStream=function(){var e;this.isMjpeg()||(j(this.video),this.video.pause()),null===(e=this.video)||void 0===e||e.removeAttribute("src")},t}(i.Object3D),Pn=function(e){function t(t,n){void 0===n&&(n=rt);var r=e.call(this,{sources:[],options:H(H({},rt),n)})||this;return r.subscribe=function(){var e,t;null===(e=r.object)||void 0===e||e.initVideo(),null===(t=r.object)||void 0===t||t.startStream()},r.unsubscribe=function(){var e;null===(e=r.object)||void 0===e||e.stopStream()},r.url=t,r.object=new Rn(t,n),r}return _(t,e),t}(Vt),Ln=function(e,t){function n(e){if(!1!==u.enabled){y.set(e.clientX,e.clientY);var t=y.x-b.x,n=y.y-b.y;m===p.ROTATE?u.rotate(d.set(-t,-n,0)):m===p.ZOOM?u.zoom(d.set(0,0,n)):m===p.PAN&&u.pan(d.set(-t,n,0)),b.set(e.clientX,e.clientY)}}function r(){t.removeEventListener("mousemove",n,!1),t.removeEventListener("mouseup",r,!1),t.removeEventListener("mouseout",r,!1),t.removeEventListener("dblclick",r,!1),m=p.NONE}function o(e){e.preventDefault(),u.zoom(d.set(0,0,0<e.deltaY?1:-1))}function a(e){!1===u.enabled||(0===e.button?m=p.ROTATE:1===e.button?m=p.ZOOM:2===e.button&&(m=p.PAN),b.set(e.clientX,e.clientY),t.addEventListener("mousemove",n,!1),t.addEventListener("mouseup",r,!1),t.addEventListener("mouseout",r,!1),t.addEventListener("dblclick",r,!1))}function s(e){e.preventDefault()}function c(e){if(!1!==u.enabled){switch(e.touches.length){case 1:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio);break;case 2:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[1].pageX,e.touches[1].pageY,0).divideScalar(window.devicePixelRatio),C=E[0].distanceTo(E[1])}S[0].copy(E[0]),S[1].copy(E[1])}}function l(e){function t(e,t){var n=t[0];for(var r in t)n.distanceTo(e)>t[r].distanceTo(e)&&(n=t[r]);return n}if(!1!==u.enabled){switch(e.preventDefault(),e.stopPropagation(),e.touches.length){case 1:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),u.rotate(E[0].sub(t(E[0],S)).multiplyScalar(-1));break;case 2:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[1].pageX,e.touches[1].pageY,0).divideScalar(window.devicePixelRatio);var n=E[0].distanceTo(E[1]);u.zoom(d.set(0,0,C-n)),C=n;var r=E[0].clone().sub(t(E[0],S)),i=E[1].clone().sub(t(E[1],S));r.x=-r.x,i.x=-i.x,u.pan(r.add(i))}S[0].copy(E[0]),S[1].copy(E[1])}}t=void 0===t?document:t,this.enabled=!0,this.center=new i.Vector3,this.panSpeed=.01,this.zoomSpeed=.05,this.rotationSpeed=.005;var u=this,h=new i.Vector3,d=new i.Vector3,f=new i.Box3,p={NONE:-1,ROTATE:0,ZOOM:1,PAN:2},m=p.NONE,g=this.center,v=new i.Matrix3,y=new i.Vector2,b=new i.Vector2,w=new i.Spherical,x=new i.Sphere,_={type:"change"};this.focus=function(t){var n;f.setFromObject(t),!1===f.isEmpty()?(f.getCenter(g),n=f.getBoundingSphere(x).radius):(g.setFromMatrixPosition(t.matrixWorld),n=.1),d.set(0,0,1),d.applyQuaternion(e.quaternion),d.multiplyScalar(4*n),e.position.copy(g).add(d),u.dispatchEvent(_)},this.pan=function(t){var n=e.zoom;t.multiplyScalar(u.panSpeed/n),t.applyMatrix3(v.getNormalMatrix(e.matrix)),e.position.add(t),g.add(t),u.dispatchEvent(_)},this.zoom=function(t){e.zoom-=(t.z||0)*e.zoom*.1,e.updateProjectionMatrix(),u.dispatchEvent(_)},this.rotate=function(t){h.copy(e.position).sub(g),w.setFromCartesianCoords(-1*h.x,h.z,h.y),w.theta+=t.x*u.rotationSpeed,w.makeSafe();var n=h.setFromSpherical(w);h.set(-1*n.x,n.z,n.y),e.position.copy(g).add(h),e.lookAt(g),u.dispatchEvent(_)},t.addEventListener("contextmenu",s,!1),t.addEventListener("mousedown",a,!1),t.addEventListener("wheel",o,!1);var E=[new i.Vector3,new i.Vector3,new i.Vector3],S=[new i.Vector3,new i.Vector3,new i.Vector3],C=null;t.addEventListener("touchstart",c,!1),t.addEventListener("touchmove",l,!1),this.dispose=function(){t.removeEventListener("contextmenu",s,!1),t.removeEventListener("mousedown",a,!1),t.removeEventListener("wheel",o,!1),t.removeEventListener("mousemove",n,!1),t.removeEventListener("mouseup",r,!1),t.removeEventListener("mouseout",r,!1),t.removeEventListener("dblclick",r,!1),t.removeEventListener("touchstart",c,!1),t.removeEventListener("touchmove",l,!1)}};(Ln.prototype=Object.create(i.EventDispatcher.prototype)).constructor=Ln;var Fn=window.ResizeObserver||l.ResizeObserver,jn=function(){function e(e,t){var n=this;void 0===t&&(t=Ye),this.options=Ye,this.previousWidth=0,this.previousHeight=0,this.options=H(H({},Ye),t),this.scene=e||new kn,this.ro=new Fn((function(e){0<e.length&&n.onWindowResize()})),this.initCamera(),this.animate=this.animate.bind(this),this.onWindowResize=this.onWindowResize.bind(this)}return e.prototype.animate=function(){var e;this.scene.stats.begin(),this.scene.updateMatrixWorld(),M(this.camera),null===(e=this.renderer)||void 0===e||e.render(this.scene,this.camera),this.scene.stats.end(),requestAnimationFrame(this.animate)},e.prototype.initCamera=function(){this.camera=new i.OrthographicCamera(-100,100,100,-100,.1,1e3),this.camera.zoom=.5,this.camera.position.set(0,0,10),this.camera.up=new i.Vector3(0,0,1),this.camera.lookAt(new i.Vector3),this.scene.add(this.camera)},e.prototype.setContainer=function(e){this.container=e,this.initRenderer(e),this.controls=new Ln(this.camera,this.container),this.controls.enableDamping=!0,this.ro.observe(this.container),requestAnimationFrame(this.animate),this.onWindowResize()},e.prototype.initRenderer=function(){var e=new i.WebGLRenderer({antialias:!0});e.autoClear=!1,e.setPixelRatio(window.devicePixelRatio),M(this.container),e.setSize(this.container.offsetWidth,this.container.offsetHeight),this.renderer=e,this.container.appendChild(e.domElement)},e.prototype.updateOptions=function(e){void 0===e&&(e=Ye),this.options=H(H({},this.options),e),this.scene.updateOptions(this.options)},e.prototype.destroy=function(){this.ro.unobserve(this.container)},e.prototype.onWindowResize=function(){var e;M(this.container),M(this.camera);var t=this.container,n=t.offsetHeight,r=t.offsetWidth;if(10<p(r-this.previousWidth)||10<p(n-this.previousHeight)){var i=A([r/100,n/100],2),o=i[0],a=i[1];this.camera.left=-o/2,this.camera.right=o/2,this.camera.top=a/2,this.camera.bottom=-a/2,this.camera.updateProjectionMatrix(),null===(e=this.renderer)||void 0===e||e.setSize(r,n),this.previousWidth=r,this.previousHeight=n}},e.prototype.addVisualization=function(e){this.scene.addVisualization(e)},e}(),Dn=function(e,t){function n(e){!1===u.enabled||(0===e.button?m=p.ROTATE:1===e.button?m=p.ZOOM:2===e.button&&(m=p.PAN),b.set(e.clientX,e.clientY),t.addEventListener("mousemove",r,!1),t.addEventListener("mouseup",o,!1),t.addEventListener("mouseout",o,!1),t.addEventListener("dblclick",o,!1))}function r(e){if(!1!==u.enabled){y.set(e.clientX,e.clientY);var t=y.x-b.x,n=y.y-b.y;m===p.ROTATE?u.rotate(d.set(-t,-n,0)):m===p.ZOOM?u.zoom(d.set(0,0,n)):m===p.PAN&&u.pan(d.set(-t,n,0)),b.set(e.clientX,e.clientY)}}function o(){t.removeEventListener("mousemove",r,!1),t.removeEventListener("mouseup",o,!1),t.removeEventListener("mouseout",o,!1),t.removeEventListener("dblclick",o,!1),m=p.NONE}function a(e){e.preventDefault(),u.zoom(d.set(0,0,0<e.deltaY?1:-1))}function s(e){e.preventDefault()}function c(e){if(!1!==u.enabled){switch(e.touches.length){case 1:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio);break;case 2:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[1].pageX,e.touches[1].pageY,0).divideScalar(window.devicePixelRatio),C=E[0].distanceTo(E[1])}S[0].copy(E[0]),S[1].copy(E[1])}}function l(e){function t(e,t){var n=t[0];for(var r in t)n.distanceTo(e)>t[r].distanceTo(e)&&(n=t[r]);return n}if(!1!==u.enabled){switch(e.preventDefault(),e.stopPropagation(),e.touches.length){case 1:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),u.rotate(E[0].sub(t(E[0],S)).multiplyScalar(-1));break;case 2:E[0].set(e.touches[0].pageX,e.touches[0].pageY,0).divideScalar(window.devicePixelRatio),E[1].set(e.touches[1].pageX,e.touches[1].pageY,0).divideScalar(window.devicePixelRatio);var n=E[0].distanceTo(E[1]);u.zoom(d.set(0,0,C-n)),C=n;var r=E[0].clone().sub(t(E[0],S)),i=E[1].clone().sub(t(E[1],S));r.x=-r.x,i.x=-i.x,u.pan(r.add(i))}S[0].copy(E[0]),S[1].copy(E[1])}}t=void 0===t?document:t,this.enabled=!0,this.center=new i.Vector3,this.panSpeed=.002,this.zoomSpeed=.1,this.rotationSpeed=.005;var u=this,h=new i.Vector3,d=new i.Vector3,f=new i.Box3,p={NONE:-1,ROTATE:0,ZOOM:1,PAN:2},m=p.NONE,g=this.center,v=new i.Matrix3,y=new i.Vector2,b=new i.Vector2,w=new i.Spherical,x=new i.Sphere,_={type:"change"};this.focus=function(t){var n;f.setFromObject(t),!1===f.isEmpty()?(f.getCenter(g),n=f.getBoundingSphere(x).radius):(g.setFromMatrixPosition(t.matrixWorld),n=.1),d.set(0,0,1),d.applyQuaternion(e.quaternion),d.multiplyScalar(4*n),e.position.copy(g).add(d),u.dispatchEvent(_)},this.pan=function(t){var n=e.position.distanceTo(g);t.multiplyScalar(n*u.panSpeed),t.applyMatrix3(v.getNormalMatrix(e.matrix)),e.position.add(t),g.add(t),u.dispatchEvent(_)},this.zoom=function(t){var n=e.position.distanceTo(g);t.multiplyScalar(n*u.zoomSpeed),t.length()>n||(t.applyMatrix3(v.getNormalMatrix(e.matrix)),e.position.add(t),u.dispatchEvent(_))},this.rotate=function(t){h.copy(e.position).sub(g),w.setFromCartesianCoords(-1*h.x,h.z,h.y),w.theta+=t.x*u.rotationSpeed,w.phi+=t.y*u.rotationSpeed,w.makeSafe();var n=h.setFromSpherical(w);h.set(-1*n.x,n.z,n.y),e.position.copy(g).add(h),e.lookAt(g),u.dispatchEvent(_)},this.dispose=function(){t.removeEventListener("contextmenu",s,!1),t.removeEventListener("mousedown",n,!1),t.removeEventListener("wheel",a,!1),t.removeEventListener("mousemove",r,!1),t.removeEventListener("mouseup",o,!1),t.removeEventListener("mouseout",o,!1),t.removeEventListener("dblclick",o,!1),t.removeEventListener("touchstart",c,!1),t.removeEventListener("touchmove",l,!1)},t.addEventListener("contextmenu",s,!1),t.addEventListener("mousedown",n,!1),t.addEventListener("wheel",a,!1);var E=[new i.Vector3,new i.Vector3,new i.Vector3],S=[new i.Vector3,new i.Vector3,new i.Vector3],C=null;t.addEventListener("touchstart",c,!1),t.addEventListener("touchmove",l,!1)};(Dn.prototype=Object.create(i.EventDispatcher.prototype)).constructor=Dn;var Nn=window.ResizeObserver||l.ResizeObserver,In=function(){function e(e,t){var n=this;void 0===t&&(t={}),this.options={},this.previousWidth=0,this.previousHeight=0,this.options=H(H({},Ye),t),this.scene=e||new kn(this.options),this.ro=new Nn((function(e){0<e.length&&n.onWindowResize()})),this.initCamera(),this.animate=this.animate.bind(this),this.onWindowResize=this.onWindowResize.bind(this)}return e.prototype.animate=function(){var e;this.scene.stats.begin(),this.scene.updateMatrixWorld(),M(this.camera),null===(e=this.renderer)||void 0===e||e.render(this.scene,this.camera),this.scene.stats.end(),requestAnimationFrame(this.animate)},e.prototype.initCamera=function(){this.camera=new i.PerspectiveCamera(50,1,.01,1e3),this.camera.position.set(0,5,10),this.camera.up=new i.Vector3(0,0,1),this.camera.lookAt(new i.Vector3),this.scene.add(this.camera)},e.prototype.setContainer=function(e){this.container=e,this.initRenderer(),this.controls=new Dn(this.camera,this.container),this.controls.enableDamping=!0,this.ro.observe(this.container),requestAnimationFrame(this.animate),this.onWindowResize()},e.prototype.initRenderer=function(){var e=new i.WebGLRenderer({antialias:!0});e.autoClear=!1,e.setPixelRatio(window.devicePixelRatio),M(this.container),e.setSize(this.container.offsetWidth,this.container.offsetHeight),this.renderer=e,this.container.appendChild(e.domElement)},e.prototype.updateOptions=function(e){void 0===e&&(e=Ye),this.options=H(H({},this.options),e),this.scene.updateOptions(this.options)},e.prototype.destroy=function(){this.ro.unobserve(this.container)},e.prototype.onWindowResize=function(){var e;M(this.container),M(this.camera);var t=this.container,n=t.offsetHeight,r=t.offsetWidth;(10<p(r-this.previousWidth)||10<p(n-this.previousHeight))&&(this.camera.aspect=r/n,this.camera.updateProjectionMatrix(),null===(e=this.renderer)||void 0===e||e.setSize(r,n),this.previousWidth=r,this.previousHeight=n)},e.prototype.addVisualization=function(e){this.scene.addVisualization(e)},e}(),Bn=function(e){function t(t,n){void 0===n&&(n={});var r=e.call(this,null,H(H({},Xe),n))||this;return r.options={},r.framesList=[],r.ros=t,r.onFramesListUpdate=n.onFramesListUpdate||function(){},r.initRosEvents(),r.getTFMessages=r.getTFMessages.bind(r),r.setFrameTransform=r.setFrameTransform.bind(r),r.addRobot=r.addRobot.bind(r),r.onRosConnection=r.onRosConnection.bind(r),r}return _(t,e),t.prototype.initRosEvents=function(){var e=this;this.ros.on("connection",(function(){e.onRosConnection()})),this.ros.isConnected&&this.onRosConnection()},t.prototype.onRosConnection=function(){var e=this;this.ros.getTopics((function(t){["/tf","/tf_static"].forEach((function(n){new B.Topic({ros:e.ros,name:n,messageType:t.types[t.topics.indexOf(n)]}).subscribe(e.getTFMessages)}))}))},t.prototype.getTFMessages=function(e){var t=this;e.transforms.forEach((function(e){var n=e.header.frame_id,r=e.child_frame_id,i=e.transform,o=i.rotation,a=o.w,s=o.x,c=o.y,l=o.z,u=i.translation,h=u.x,d=u.y,f=u.z,p=A([t.getObjectOrCreate(r+"-tf-connector"),t.getObjectOrCreate(n+"-tf-connector")],2),m=p[0];p[1].add(m),m.position.set(h,d,f),m.quaternion.set(s,c,l,a),[n,r].forEach((function(e){-1===t.framesList.indexOf(e+"-tf-connector")&&t.framesList.push(e+"-tf-connector")}))})),this.setFrameTransform()},t.prototype.getObjectOrCreate=function(e){var t=this.scene.vizWrapper;-1===this.framesList.indexOf(e)&&(this.framesList.push(e),this.onFramesListUpdate(this.framesList));var n=t.getObjectByName(e);if(n)return n;var r=new i.Group;return r.name=e,this.scene.addObject(r),r},t.prototype.setFrameTransform=function(){var e=this.options.selectedFrame,t=this.scene.vizWrapper;if(e){var n=this.getObjectOrCreate(e);if(n){t.position.set(0,0,0),t.quaternion.set(0,0,0,1),t.updateMatrixWorld();var r=new i.Vector3,o=new i.Quaternion;n.getWorldQuaternion(o);var a=o.w,s=o.x,c=o.y,l=o.z;t.quaternion.set(-s,-c,-l,a),t.updateMatrixWorld(),n.getWorldPosition(r);var u=r.negate();t.position.set(u.x,u.y,u.z)}}},t.prototype.addVisualization=function(t){var n=this;e.prototype.addVisualization.call(this,t),t.onHeaderChange=function(e){n.getObjectOrCreate(e+"-tf-connector").add(t.object)}},t.prototype.attachObjectOutsideTree=function(e){e.frameId&&this.getObjectOrCreate(e.frameId+"-tf-connector").attach(e)},t.prototype.addRobot=function(t){var n=this;t.loadFromParam((function(){var r;e.prototype.addVisualization.call(n,t);var i=(null===(r=t.object)||void 0===r?void 0:r.children[0]).links;Object.keys(i).map((function(e){var t=i[e];n.getObjectOrCreate(e+"-tf-connector").add(t)}))}))},t.prototype.setFixedFrame=function(){},t}(In),zn=function(){function e(e,t,n){this.markerManagerMap={},this.controlsMap={},this.objectMap={},this.namespaces={},this.callback=function(){return null},this.object=e,this.viewer=t,this.hideOtherHandlesOnSelect=n.hideOtherHandlesOnSelect,this.hideOtherControlsInstancesOnSelect=n.hideOtherControlsInstancesOnSelect,this.visible=n.visible,this.onChange=this.onChange.bind(this)}return e.prototype.getMarkerManagerOrCreate=function(e){var t=e;if(!this.markerManagerMap[t]||!this.objectMap[t]){var n=new Rt;n.name=t||"",this.markerManagerMap[t]=new pn(n,this.onChange),this.objectMap[t]=n,this.object.add(n)}return{manager:this.markerManagerMap[t],object:this.objectMap[t]}},e.prototype.onChange=function(){this.callback&&this.callback()},e.prototype.onNamespaceChange=function(e){this.callback=e},e.prototype.initMarkers=function(t,n,r){var i=this,o=t.controls,a=t.header.frame_id,s=t.name,c=t.pose,l=c.orientation,u=c.position,f=t.scale;0===f&&(f=1);var p=this.getMarkerManagerOrCreate(s),m=p.manager,g=p.object;g.visible=r,g.frameId=a,this.viewer.attachObjectOutsideTree&&this.viewer.attachObjectOutsideTree(g),g.setTransform({translation:u,rotation:l}),g.userData.control={frameId:t.header.frame_id,markerName:t.name},g.userData.handlesControlsMap={},o.forEach((function(t,a){var c,l,u=s;if(void 0===i.controlsMap[u]&&(i.controlsMap[u]=[]),(null===(c=i.controlsMap[u])||void 0===c?void 0:c.length)!==o.length){var p=t.orientation_mode===K.FIXED?h.ANCHOR_MODE.FIXED:h.ANCHOR_MODE.INHERIT,v=n.anchor(g,{separationT:{x:.4,y:.4,z:.4},orientation:t.orientation,mode:p,hideOtherHandlesOnSelect:i.hideOtherHandlesOnSelect,hideOtherControlsInstancesOnSelect:i.hideOtherControlsInstancesOnSelect,showHelperPlane:!0});v.scale.set(f,f,f),v.visible=r,e.enableControls(g,t.interaction_mode,t.orientation_mode,t.name,v,d({seed:u+"-"+t.name+"-"+2*a})),null===(l=i.controlsMap[u])||void 0===l||l.push(v)}0<t.markers.length&&t.markers.forEach((function(e){m.updateMarker(e)}))}))},e.prototype.setVisible=function(e){this.visible=e,Object.values(this.controlsMap).map((function(t){null==t||t.map((function(t){t.visible=e,t.object.visible=e}))}))},e.prototype.updatePose=function(e){var t=e.name,n=e.pose,r=this.objectMap[t];if(r&&n){var i=n.orientation,o=n.position;r.setTransform({translation:o,rotation:i})}},e.enableControls=function(t,n,r,o,a,s){var c;a.showAll(!1);var l=new i.Quaternion;a.getWorldQuaternion(l);var u=(new i.Euler).setFromQuaternion(l),d=e.getAlignmentColor(u),f=null!=d?d:s;if(-1!==Z.indexOf(r)&&n===J.ROTATE_AXIS)return t.userData.handlesControlsMap=H(H({},t.userData.handlesControlsMap),((c={})[h.DEFAULT_HANDLE_GROUP_NAME.ER]=o,c)),void a.showByNames([h.DEFAULT_HANDLE_GROUP_NAME.ER],!0);var p=[];switch(n){case J.NONE:case J.MENU:case J.BUTTON:break;case J.MOVE_AXIS:p=[h.DEFAULT_HANDLE_GROUP_NAME.XPT,h.DEFAULT_HANDLE_GROUP_NAME.XNT],a.translationXP.setColor(f),a.translationXN.setColor(f);break;case J.MOVE_PLANE:p=[h.DEFAULT_HANDLE_GROUP_NAME.PICK_PLANE_YZ],a.pickPlaneYZ.setColor(f);break;case J.ROTATE_AXIS:p=[h.DEFAULT_HANDLE_GROUP_NAME.XR],a.rotationX.setColor(f);break;case J.MOVE_ROTATE:p=[h.DEFAULT_HANDLE_GROUP_NAME.XR,h.DEFAULT_HANDLE_GROUP_NAME.PICK_PLANE_YZ],a.pickPlaneYZ.setColor(f),a.rotationX.setColor(f);break;case J.MOVE_3D:p=[h.DEFAULT_HANDLE_GROUP_NAME.XPT,h.DEFAULT_HANDLE_GROUP_NAME.XNT,h.DEFAULT_HANDLE_GROUP_NAME.YPT,h.DEFAULT_HANDLE_GROUP_NAME.YNT,h.DEFAULT_HANDLE_GROUP_NAME.ZPT,h.DEFAULT_HANDLE_GROUP_NAME.ZNT,h.DEFAULT_HANDLE_GROUP_NAME.PICK];break;case J.ROTATE_3D:p=[h.DEFAULT_HANDLE_GROUP_NAME.XR,h.DEFAULT_HANDLE_GROUP_NAME.YR,h.DEFAULT_HANDLE_GROUP_NAME.ZR];break;case J.MOVE_ROTATE_3D:p=[h.DEFAULT_HANDLE_GROUP_NAME.PICK]}p.map((function(e){t.userData.handlesControlsMap[e]=o})),a.showByNames(p,!0)},e.getAlignmentColor=function(e){for(var t,n=f(10,-3),r=A(e.toArray(),3),i=r[0],o=r[1],a=r[2],s=-4;4>=s;s++){if(p(i-(t=s*x/2))<n&&p(o)<n&&p(a)<n)return"red";if(p(o-t)<n&&p(i)<n&&p(a)<n)return"green";if(p(a-t)<n&&p(o)<n&&p(i)<n)return"blue"}return null},e.prototype.removeObject=function(e){var t,n=this.objectMap[e];null===(t=n.parent)||void 0===t||t.remove(n),delete this.objectMap[e]},e.prototype.reset=function(e){var t=this;this.onChange(),e&&Object.keys(this.objectMap).forEach((function(e){t.removeObject(e)}))},e}(),Un=function(e){function t(t,n,r,i){void 0===i&&(i=ut);var o=e.call(this,t,n,Me,H(H({},ut),i))||this;o.init=!1,o.object=new Rt,o.interactiveMarkersNames=new Set,o.interactiveMarkersFrameIds=new Set,o.clientId="amphion-"+m(Math.random()*f(10,8)),o.messageSequence=0,o.feedbackTopic=null,o.init=!1,o.viewer=r,o.updateOptions(H(H({},ut),i)),o.interactiveMarkerManager=new zn(o.object,r,o.options);var a=o.options.publishThrottleRate;return o.debouncedPublish=u(o.publish.bind(o),a&&0<a?a:0),o.initFreeformControls(),o.publishManual=o.publishManual.bind(o),o}return _(t,e),t.prototype.hide=function(){e.prototype.hide.call(this),this.interactiveMarkerManager.setVisible(!1)},t.prototype.show=function(){e.prototype.show.call(this),this.interactiveMarkerManager.setVisible(!0)},t.prototype.destroy=function(){var t;e.prototype.destroy.call(this),null===(t=this.freeformControls)||void 0===t||t.destroy(),this.freeformControls=null,this.interactiveMarkerManager.reset(!0),this.interactiveMarkersNames=new Set},t.prototype.initFreeformControls=function(){var e=this,t=this.viewer,n=t.camera,r=t.controls,i=t.renderer,o=t.scene;M(n),M(i),this.freeformControls=new h.ControlsManager(n,i.domElement),o.add(this.freeformControls),this.freeformControls.listen(h.RAYCASTER_EVENTS.DRAG_START,(function(){r.enabled=!1})),this.freeformControls.listen(h.RAYCASTER_EVENTS.DRAG,(function(t,n){return e.debouncedPublish(t,n)})),this.freeformControls.listen(h.RAYCASTER_EVENTS.DRAG_STOP,(function(t,n){e.debouncedPublish(t,n),r.enabled=!0}))},t.makeInteractiveMarkerFeedbackMessage=function(e){var t=e.seq,n=e.frame_id,r=e.client_id,i=e.marker_name,o=e.control_name,a=e.position,s=e.quaternion;return new B.Message({header:{seq:t,frame_id:n,stamp:{secs:0,nsecs:0}},client_id:r,marker_name:i,control_name:o,pose:{position:{x:a.x,y:a.y,z:a.z},orientation:{x:s.x,y:s.y,z:s.z,w:s.w}},event_type:1,menu_entry_id:0,mouse_point:{x:0,y:0,z:0},mouse_point_valid:!1})},t.makeInteractiveMarkerFeedbackTopic=function(e,t){return new B.Topic({ros:e,name:t,messageType:Oe})},t.prototype.publish=function(e,n){var r;if(e){var i=e.userData.control,o=i.frameId,a=i.markerName,s=e.userData.handlesControlsMap[n],c=t.makeInteractiveMarkerFeedbackMessage({seq:this.messageSequence,client_id:this.clientId,frame_id:o,marker_name:a,control_name:s,position:e.position,quaternion:e.quaternion});null!==this.feedbackTopic&&(null===(r=this.feedbackTopic)||void 0===r||r.publish(c)),this.messageSequence++}},t.prototype.publishManual=function(e){var n=t.makeInteractiveMarkerFeedbackMessage(H(H({seq:this.messageSequence,client_id:this.clientId},e),{frame_id:Array.from(this.interactiveMarkersFrameIds)[0],marker_name:Array.from(this.interactiveMarkersNames)[0]}));null!==this.feedbackTopic&&this.feedbackTopic.publish(n),this.messageSequence++},t.prototype.updateOptions=function(n){void 0===n.feedbackTopicName?this.feedbackTopic=null:(!this.feedbackTopic||this.feedbackTopic.name!==n.feedbackTopicName.name)&&(M(this.ros),this.feedbackTopic=t.makeInteractiveMarkerFeedbackTopic(this.ros,n.feedbackTopicName));var r=this.options.updateTopicName!==n.topicName&&this.init,i=this.topicName===this.options.updateTopicName;if(r&&void 0!==n.updateTopicName){var o=n.updateTopicName,a=o.messageType,s=o.name;this.changeTopic(s,a,!0)}else r&&i&&this.unsubscribe();e.prototype.updateOptions.call(this,n)},t.prototype.update=function(t){var n=this;if(e.prototype.update.call(this,t),t.markers&&0<t.markers.length&&(t.markers.forEach((function(e){n.interactiveMarkersNames.has(e.name)||n.interactiveMarkerManager.initMarkers(e,n.freeformControls,n.options.visible),n.interactiveMarkersNames.add(e.name),e.header&&n.interactiveMarkersFrameIds.add(e.header.frame_id),t.markers.forEach((function(e){n.interactiveMarkerManager.updatePose(e)}))})),!this.init))if(this.init=!0,void 0!==this.options.updateTopicName){var r=this.options.updateTopicName,i=r.messageType,o=r.name;this.init=!0,this.changeTopic(o,i,!0)}else this.unsubscribe();t.poses&&0<t.poses.length&&t.poses.forEach((function(e){n.interactiveMarkerManager.updatePose(e)})),t.erases},t.prototype.reset=function(){this.interactiveMarkerManager.reset(!1)},t}(Tt),Hn=n("HLpx").open,Vn=function(){function e(){var e=this;this.files=new Set,this.topics=[],this.readers={},this.addFile=function(t){return E(e,void 0,void 0,(function(){return S(this,(function(e){switch(e.label){case 0:if(this.files.has(t))throw new Error("file already exists in the bucket");return this.files.add(t),this.readers[t.name]={topics:{},queue:[]},[4,this.processFile(t)];case 1:return e.sent(),[2]}}))}))},this.removeFile=function(t,n){return E(e,void 0,void 0,(function(){return S(this,(function(){if(!this.files.has(t))throw new Error("file does not exist in the bucket");return this.files.delete(t),clearTimeout(this.readers[t.name].timer),clearTimeout(this.readers[t.name].queueStartWaitTimer),this.readers[t.name]={topics:{},queue:[]},this.topics=this.topics.filter((function(e){return e.rosbagFileName!==t.name})),n(),[2]}))}))},this.addReader=function(t,n,r){var i,o=e.readers[n].topics;if(!o)throw new Error("add "+n+" to the bucket first");o[t]||(o[t]=new Set),null===(i=o[t])||void 0===i||i.add(r)},this.removeReader=function(t,n,r){var i,o,a=e.readers[n].topics;if(!a)throw new Error("add "+n+" to the bucket first");if(null===(i=a[t])||void 0===i||!i.has(r))throw new Error("reader has not yet been added to the bucket");null===(o=a[t])||void 0===o||o.delete(r)},this.processQueue=function(t){return 0===e.readers[t.name].queue.length?void(e.readers[t.name].queueStartWaitTimer=window.setTimeout((function(){e.processQueue(t)}),500)):void e.enqueueProcessing(0,t)},this.enqueueProcessing=function(t,n){var r=e.readers[n.name].queue,i=r[t],o=r[t+1];if(e.processBagReadResult(i,n),o){var a=i.timestamp,s=a.sec,c=a.nsec,l=o.timestamp,u=l.sec,h=l.nsec,d=g(s*f(10,3)+c/f(10,6)),p=g(u*f(10,3)+h/f(10,6)),m=0;p>d&&(m=p-d),4>m?e.enqueueProcessing(t+1,n):e.readers[n.name].timer=window.setTimeout((function(){e.enqueueProcessing(t+1,n)}),m)}else e.enqueueProcessing(0,n)},this.processBagReadResult=function(t,n){var r=e.readers[n.name].topics,i=r["*"],o=r[t.topic];null==i||i.forEach((function(e){return e(n,t)})),null==o||o.forEach((function(e){return e(n,t)}))}}return e.prototype.processFile=function(e){return E(this,void 0,void 0,(function(){var t,n=this;return S(this,(function(r){switch(r.label){case 0:return[4,Hn(e)];case 1:return t=r.sent(),Object.keys(t.connections).forEach((function(r){var i=t.connections[r],o=i.topic,a=i.type;-1===n.topics.findIndex((function(t){return t.name===o&&t.rosbagFileName===e.name}))&&n.topics.push({name:o,messageType:a,rosbagFileName:e.name})})),t.readMessages({},(function(t){n.readers[e.name].queue.push(t)})),this.processQueue(e),[2]}}))}))},e}(),$n=function(e){var t,n=this;this.createdAt=new Date,this.isStreamPaused=!1,this.internalListener=null,this.listeners=new Set,this.addListener=function(e){return n.listeners.has(e)?{success:!1,reason:"listener already present"}:(n.listeners.add(e),n.stream.addListener(e),{success:!0})},this.removeListener=function(e){return n.listeners.has(e)?(n.listeners.delete(e),n.stream.removeListener(e),{success:!0}):{success:!1,reason:"listener not present"}},this.removeAllListeners=function(){return n.listeners.forEach((function(e){n.stream.removeListener(e)})),n.listeners.clear(),{success:!0}},this.pause=function(){return n.isStreamPaused=!0,{success:!0}},this.resume=function(){return n.isStreamPaused=!1,{success:!0}},this.hasMemory=!(null===(t=e.memory)||void 0===t)&&t,this.bucket=e.bucket,this.producer={start:function(t){n.internalListener=function(e,r){n.isStreamPaused||t.next(r.message)},n.bucket.addReader(e.topicName,e.fileName,n.internalListener)},stop:function(){n.internalListener&&n.bucket.removeReader(e.topicName,e.fileName,n.internalListener)}},this.stream=this.hasMemory?r.createWithMemory(this.producer):r.create(this.producer)};return{EditorControls:Dn,CollisionObject:Ft,DepthCloud:Pn,DisplayTrajectory:jt,PlanningScene:Dt,Point:Qt,PointCloud:nn,Polygon:qt,Pose:$t,Wrench:Gt,PoseArray:En,Tf:Kt,RobotModel:Zt,MarkerArray:mn,LaserScan:vn,Map:xn,Odometry:_n,Path:Sn,Image:Cn,ImageStream:An,Marker:Tn,Range:Mn,Scene:kn,Viewer2d:jn,Viewer3d:In,TfViewer:Bn,InteractiveMarkers:Un,RosbagBucket:Vn,RosTopicDataSource:V,RosbagDataSource:$n,CONSTANTS:Ct}}(n("6GvM"),n("scx0"),n("Womt"),n("UY5k"),n("uLOr"),n("+3EO"),n("ilox"),n("0CBx"),n("9/5/"),n("3cg9"),n("/Zut"))}).call(this,n("yLpj"))},EbDI:function(e,t){e.exports=function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)},e.exports.default=e.exports,e.exports.__esModule=!0},EiaH:function(e,t,n){
/**
 * @license
 * Copyright (c) 2012-2013 Chris Pettitt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
e.exports={graphlib:n("Xdfk"),dagre:n("yLCY"),intersect:n("U4bP"),render:n("cSR1"),util:n("PEyx"),version:n("EFJG")}},Eidx:function(e,t,n){"use strict";var r=n("IPAr");e.exports=function(e,t,n){var i,o,a,s,c=t.charAt(0);if("\n"!==c)return;if(n)return!0;s=1,i=t.length,o=c,a="";for(;s<i&&(c=t.charAt(s),r(c));)a+=c,"\n"===c&&(o+=a,a=""),s++;e(o)}},EmYC:function(e,t,n){"use strict";e.exports=function(e,t){var n=e.indexOf("[",t),r=e.indexOf("![",t);if(-1===r)return n;return n<r?n:r}},EpBk:function(e,t){e.exports=function(e){var t=typeof e;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==e:null===e}},Esvb:function(e,t,n){"use strict";var r=n("aCXt"),i=n("+XMi");e.exports=i;var o=i.prototype;function a(e,t,n){var i=this.path,o=new r(e,t,n);return i&&(o.name=i+":"+o.name,o.file=i),o.fatal=!1,this.messages.push(o),o}o.message=a,o.info=function(){var e=this.message.apply(this,arguments);return e.fatal=null,e},o.fail=function(){var e=this.message.apply(this,arguments);throw e.fatal=!0,e},o.warn=a},EwQA:function(e,t,n){var r=n("zZ0H");e.exports=function(e){return"function"==typeof e?e:r}},ExA7:function(e,t){e.exports=function(e){return null!=e&&"object"==typeof e}},F9We:function(e,t,n){var r;try{r=n("4Ai+")}catch(e){}r||(r=window.graphlib),e.exports=r},FUBA:function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var r=Object.assign||function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},i=function(){function e(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}return function(t,n,r){return n&&e(t.prototype,n),r&&e(t,r),t}}(),o=n("q1tI"),a=c(o),s=c(n("17x9"));function c(e){return e&&e.__esModule?e:{default:e}}var l={position:"absolute",top:0,left:0,visibility:"hidden",height:0,overflow:"scroll",whiteSpace:"pre"},u=["extraWidth","injectStyles","inputClassName","inputRef","inputStyle","minWidth","onAutosize","placeholderIsMinWidth"],h=function(e,t){t.style.fontSize=e.fontSize,t.style.fontFamily=e.fontFamily,t.style.fontWeight=e.fontWeight,t.style.fontStyle=e.fontStyle,t.style.letterSpacing=e.letterSpacing,t.style.textTransform=e.textTransform},d=!("undefined"==typeof window||!window.navigator)&&/MSIE |Trident\/|Edge\//.test(window.navigator.userAgent),f=function(){return d?"_"+Math.random().toString(36).substr(2,12):void 0},p=function(e){function t(e){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);var n=function(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}(this,(t.__proto__||Object.getPrototypeOf(t)).call(this,e));return n.inputRef=function(e){n.input=e,"function"==typeof n.props.inputRef&&n.props.inputRef(e)},n.placeHolderSizerRef=function(e){n.placeHolderSizer=e},n.sizerRef=function(e){n.sizer=e},n.state={inputWidth:e.minWidth,inputId:e.id||f(),prevId:e.id},n}return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}(t,e),i(t,null,[{key:"getDerivedStateFromProps",value:function(e,t){var n=e.id;return n!==t.prevId?{inputId:n||f(),prevId:n}:null}}]),i(t,[{key:"componentDidMount",value:function(){this.mounted=!0,this.copyInputStyles(),this.updateInputWidth()}},{key:"componentDidUpdate",value:function(e,t){t.inputWidth!==this.state.inputWidth&&"function"==typeof this.props.onAutosize&&this.props.onAutosize(this.state.inputWidth),this.updateInputWidth()}},{key:"componentWillUnmount",value:function(){this.mounted=!1}},{key:"copyInputStyles",value:function(){if(this.mounted&&window.getComputedStyle){var e=this.input&&window.getComputedStyle(this.input);e&&(h(e,this.sizer),this.placeHolderSizer&&h(e,this.placeHolderSizer))}}},{key:"updateInputWidth",value:function(){if(this.mounted&&this.sizer&&void 0!==this.sizer.scrollWidth){var e=void 0;e=this.props.placeholder&&(!this.props.value||this.props.value&&this.props.placeholderIsMinWidth)?Math.max(this.sizer.scrollWidth,this.placeHolderSizer.scrollWidth)+2:this.sizer.scrollWidth+2,(e+="number"===this.props.type&&void 0===this.props.extraWidth?16:parseInt(this.props.extraWidth)||0)<this.props.minWidth&&(e=this.props.minWidth),e!==this.state.inputWidth&&this.setState({inputWidth:e})}}},{key:"getInput",value:function(){return this.input}},{key:"focus",value:function(){this.input.focus()}},{key:"blur",value:function(){this.input.blur()}},{key:"select",value:function(){this.input.select()}},{key:"renderStyles",value:function(){var e=this.props.injectStyles;return d&&e?a.default.createElement("style",{dangerouslySetInnerHTML:{__html:"input#"+this.state.inputId+"::-ms-clear {display: none;}"}}):null}},{key:"render",value:function(){var e=[this.props.defaultValue,this.props.value,""].reduce((function(e,t){return null!=e?e:t})),t=r({},this.props.style);t.display||(t.display="inline-block");var n=r({boxSizing:"content-box",width:this.state.inputWidth+"px"},this.props.inputStyle),i=function(e,t){var n={};for(var r in e)t.indexOf(r)>=0||Object.prototype.hasOwnProperty.call(e,r)&&(n[r]=e[r]);return n}(this.props,[]);return function(e){u.forEach((function(t){return delete e[t]}))}(i),i.className=this.props.inputClassName,i.id=this.state.inputId,i.style=n,a.default.createElement("div",{className:this.props.className,style:t},this.renderStyles(),a.default.createElement("input",r({},i,{ref:this.inputRef})),a.default.createElement("div",{ref:this.sizerRef,style:l},e),this.props.placeholder?a.default.createElement("div",{ref:this.placeHolderSizerRef,style:l},this.props.placeholder):null)}}]),t}(o.Component);p.propTypes={className:s.default.string,defaultValue:s.default.any,extraWidth:s.default.oneOfType([s.default.number,s.default.string]),id:s.default.string,injectStyles:s.default.bool,inputClassName:s.default.string,inputRef:s.default.func,inputStyle:s.default.object,minWidth:s.default.oneOfType([s.default.number,s.default.string]),onAutosize:s.default.func,onChange:s.default.func,placeholder:s.default.string,placeholderIsMinWidth:s.default.bool,style:s.default.object,value:s.default.any},p.defaultProps={minWidth:1,injectStyles:!0},t.default=p},FZoo:function(e,t,n){var r=n("MrPd"),i=n("4uTw"),o=n("wJg7"),a=n("GoyQ"),s=n("9Nap");e.exports=function(e,t,n,c){if(!a(e))return e;for(var l=-1,u=(t=i(t,e)).length,h=u-1,d=e;null!=d&&++l<u;){var f=s(t[l]),p=n;if("__proto__"===f||"constructor"===f||"prototype"===f)return e;if(l!=h){var m=d[f];void 0===(p=c?c(m,f,d):void 0)&&(p=a(m)?m:o(t[l+1])?[]:{})}r(d,f,p),d=d[f]}return e}},FfPP:function(e,t,n){var r=n("idmN"),i=n("hgQt");e.exports=function(e,t){return r(e,t,(function(t,n){return i(e,n)}))}},"G+a2":function(e,t,n){var r=n("E9ZH");e.exports=function(e){this.type=r.URDF_CYLINDER,this.length=parseFloat(e.xml.getAttribute("length")),this.radius=parseFloat(e.xml.getAttribute("radius"))}},G6z8:function(e,t,n){var r=n("fR/l"),i=n("oCl/"),o=n("mTTR");e.exports=function(e){return r(e,o,i)}},GDhZ:function(e,t,n){var r=n("wF/u"),i=n("mwIZ"),o=n("hgQt"),a=n("9ggG"),s=n("CMye"),c=n("IOzZ"),l=n("9Nap");e.exports=function(e,t){return a(e)&&s(t)?c(l(e),t):function(n){var a=i(n,e);return void 0===a&&a===t?o(n,e):r(t,a,3)}}},GEWS:function(e,t,n){"use strict";var r=n("b5wT"),i=n("F9We").Graph,o=n("6Ekc").slack;function a(e,t){return r.forEach(e.nodes(),(function n(i){r.forEach(t.nodeEdges(i),(function(r){var a=r.v,s=i===a?r.w:a;e.hasNode(s)||o(t,r)||(e.setNode(s,{}),e.setEdge(i,s,{}),n(s))}))})),e.nodeCount()}function s(e,t){return r.minBy(t.edges(),(function(n){if(e.hasNode(n.v)!==e.hasNode(n.w))return o(t,n)}))}function c(e,t,n){r.forEach(e.nodes(),(function(e){t.node(e).rank+=n}))}e.exports=function(e){var t,n,r=new i({directed:!1}),l=e.nodes()[0],u=e.nodeCount();r.setNode(l,{});for(;a(r,e)<u;)t=s(r,e),n=r.hasNode(t.v)?o(e,t):-o(e,t),c(r,e,n);return r}},GNiM:function(e,t,n){var r=n("I01J"),i=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,o=/\\(\\)?/g,a=r((function(e){var t=[];return 46===e.charCodeAt(0)&&t.push(""),e.replace(i,(function(e,n,r,i){t.push(r?i.replace(o,"$1"):n||e)})),t}));e.exports=a},Ga4A:function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getPrefix=i,t.browserPrefixToKey=o,t.browserPrefixToStyle=function(e,t){return t?"-".concat(t.toLowerCase(),"-").concat(e):e},t.default=void 0;var r=["Moz","Webkit","O","ms"];function i(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"transform";if("undefined"==typeof window||void 0===window.document)return"";var t=window.document.documentElement.style;if(e in t)return"";for(var n=0;n<r.length;n++)if(o(e,r[n])in t)return r[n];return""}function o(e,t){return t?"".concat(t).concat(function(e){for(var t="",n=!0,r=0;r<e.length;r++)n?(t+=e[r].toUpperCase(),n=!1):"-"===e[r]?n=!0:t+=e[r];return t}(e)):e}var a=i();t.default=a},GbLa:function(e,t,n){var r=n("M96O"),i=n("lnHP");function o(e){return r.map(e.nodes(),(function(t){var n=e.node(t),i=e.parent(t),o={v:t};return r.isUndefined(n)||(o.value=n),r.isUndefined(i)||(o.parent=i),o}))}function a(e){return r.map(e.edges(),(function(t){var n=e.edge(t),i={v:t.v,w:t.w};return r.isUndefined(t.name)||(i.name=t.name),r.isUndefined(n)||(i.value=n),i}))}e.exports={write:function(e){var t={options:{directed:e.isDirected(),multigraph:e.isMultigraph(),compound:e.isCompound()},nodes:o(e),edges:a(e)};r.isUndefined(e.graph())||(t.value=r.clone(e.graph()));return t},read:function(e){var t=new i(e.options).setGraph(e.value);return r.each(e.nodes,(function(e){t.setNode(e.v,e.value),e.parent&&t.setParent(e.v,e.parent)})),r.each(e.edges,(function(e){t.setEdge({v:e.v,w:e.w,name:e.name},e.value)})),t}}},Gdbo:function(e,t,n){"use strict";e.exports=function(e){if(e)throw e}},Gi0A:function(e,t,n){var r=n("QqLw"),i=n("ExA7");e.exports=function(e){return i(e)&&"[object Map]"==r(e)}},GoyQ:function(e,t){e.exports=function(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)}},Gqj6:function(e,t,n){"use strict";var r=n("3GlI");e.exports=function(e,t,n){var i,o,a,s,c,l,u,h,d,f,p,m=this.options,g=t.length+1,v=0,y="";if(!m.gfm)return;for(;v<g&&(" "===(a=t.charAt(v))||"\t"===a);)y+=a,v++;if(f=v,"~"!==(a=t.charAt(v))&&"`"!==a)return;v++,o=a,i=1,y+=a;for(;v<g&&(a=t.charAt(v))===o;)y+=a,i++,v++;if(i<3)return;for(;v<g&&(" "===(a=t.charAt(v))||"\t"===a);)y+=a,v++;s="",c="";for(;v<g&&"\n"!==(a=t.charAt(v))&&"~"!==a&&"`"!==a;)" "===a||"\t"===a?c+=a:(s+=c+a,c=""),v++;if((a=t.charAt(v))&&"\n"!==a)return;if(n)return!0;(p=e.now()).column+=y.length,p.offset+=y.length,y+=s,s=this.decode.raw(this.unescape(s),p),c&&(y+=c);c="",h="",d="",l="",u="";for(;v<g;)if(a=t.charAt(v),l+=h,u+=d,h="",d="","\n"===a){for(l?(h+=a,d+=a):y+=a,c="",v++;v<g&&" "===(a=t.charAt(v));)c+=a,v++;if(h+=c,d+=c.slice(f),!(c.length>=4)){for(c="";v<g&&(a=t.charAt(v))===o;)c+=a,v++;if(h+=c,d+=c,!(c.length<i)){for(c="";v<g&&(" "===(a=t.charAt(v))||"\t"===a);)h+=a,d+=a,v++;if(!a||"\n"===a)break}}}else l+=a,d+=a,v++;return e(y+=l+h)({type:"code",lang:s||null,value:r(u)})}},H8j4:function(e,t,n){var r=n("QkVE");e.exports=function(e,t){var n=r(this,e),i=n.size;return n.set(e,t),this.size+=n.size==i?0:1,this}},HDyB:function(e,t,n){var r=n("nmnc"),i=n("JHRd"),o=n("ljhN"),a=n("or5M"),s=n("7fqy"),c=n("rEGp"),l=r?r.prototype:void 0,u=l?l.valueOf:void 0;e.exports=function(e,t,n,r,l,h,d){switch(n){case"[object DataView]":if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case"[object ArrayBuffer]":return!(e.byteLength!=t.byteLength||!h(new i(e),new i(t)));case"[object Boolean]":case"[object Date]":case"[object Number]":return o(+e,+t);case"[object Error]":return e.name==t.name&&e.message==t.message;case"[object RegExp]":case"[object String]":return e==t+"";case"[object Map]":var f=s;case"[object Set]":var p=1&r;if(f||(f=c),e.size!=t.size&&!p)return!1;var m=d.get(e);if(m)return m==t;r|=2,d.set(e,t);var g=a(f(e),f(t),r,l,h,d);return d.delete(e),g;case"[object Symbol]":if(u)return u.call(e)==u.call(t)}return!1}},HLpx:function(module,exports,__webpack_require__){var factory;"undefined"!=typeof self&&self,factory=function(){return function(e){var t={};function n(r){if(t[r])return t[r].exports;var i=t[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,n),i.l=!0,i.exports}return n.m=e,n.c=t,n.d=function(e,t,r){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(n.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var i in e)n.d(r,i,function(t){return e[t]}.bind(null,i));return r},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="",n(n.s="./src/web/index.js")}({"./node_modules/base64-js/index.js":
/*!*****************************************!*\
  !*** ./node_modules/base64-js/index.js ***!
  \*****************************************/
/*! no static exports found */function(e,t,n){"use strict";t.byteLength=function(e){var t=l(e),n=t[0],r=t[1];return 3*(n+r)/4-r},t.toByteArray=function(e){for(var t,n=l(e),r=n[0],a=n[1],s=new o(function(e,t,n){return 3*(t+n)/4-n}(0,r,a)),c=0,u=a>0?r-4:r,h=0;h<u;h+=4)t=i[e.charCodeAt(h)]<<18|i[e.charCodeAt(h+1)]<<12|i[e.charCodeAt(h+2)]<<6|i[e.charCodeAt(h+3)],s[c++]=t>>16&255,s[c++]=t>>8&255,s[c++]=255&t;return 2===a&&(t=i[e.charCodeAt(h)]<<2|i[e.charCodeAt(h+1)]>>4,s[c++]=255&t),1===a&&(t=i[e.charCodeAt(h)]<<10|i[e.charCodeAt(h+1)]<<4|i[e.charCodeAt(h+2)]>>2,s[c++]=t>>8&255,s[c++]=255&t),s},t.fromByteArray=function(e){for(var t,n=e.length,i=n%3,o=[],a=0,s=n-i;a<s;a+=16383)o.push(u(e,a,a+16383>s?s:a+16383));return 1===i?(t=e[n-1],o.push(r[t>>2]+r[t<<4&63]+"==")):2===i&&(t=(e[n-2]<<8)+e[n-1],o.push(r[t>>10]+r[t>>4&63]+r[t<<2&63]+"=")),o.join("")};for(var r=[],i=[],o="undefined"!=typeof Uint8Array?Uint8Array:Array,a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",s=0,c=a.length;s<c;++s)r[s]=a[s],i[a.charCodeAt(s)]=s;function l(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var n=e.indexOf("=");return-1===n&&(n=t),[n,n===t?0:4-n%4]}function u(e,t,n){for(var i,o,a=[],s=t;s<n;s+=3)i=(e[s]<<16&16711680)+(e[s+1]<<8&65280)+(255&e[s+2]),a.push(r[(o=i)>>18&63]+r[o>>12&63]+r[o>>6&63]+r[63&o]);return a.join("")}i["-".charCodeAt(0)]=62,i["_".charCodeAt(0)]=63},"./node_modules/heap/index.js":
/*!************************************!*\
  !*** ./node_modules/heap/index.js ***!
  \************************************/
/*! no static exports found */function(e,t,n){e.exports=n(/*! ./lib/heap */"./node_modules/heap/lib/heap.js")},"./node_modules/heap/lib/heap.js":
/*!***************************************!*\
  !*** ./node_modules/heap/lib/heap.js ***!
  \***************************************/
/*! no static exports found */function(e,t,n){var r,i,o;(function(){var n,a,s,c,l,u,h,d,f,p,m,g,v,y,b;s=Math.floor,p=Math.min,a=function(e,t){return e<t?-1:e>t?1:0},f=function(e,t,n,r,i){var o;if(null==n&&(n=0),null==i&&(i=a),n<0)throw new Error("lo must be non-negative");for(null==r&&(r=e.length);n<r;)i(t,e[o=s((n+r)/2)])<0?r=o:n=o+1;return[].splice.apply(e,[n,n-n].concat(t)),t},u=function(e,t,n){return null==n&&(n=a),e.push(t),y(e,0,e.length-1,n)},l=function(e,t){var n,r;return null==t&&(t=a),n=e.pop(),e.length?(r=e[0],e[0]=n,b(e,0,t)):r=n,r},d=function(e,t,n){var r;return null==n&&(n=a),r=e[0],e[0]=t,b(e,0,n),r},h=function(e,t,n){var r;return null==n&&(n=a),e.length&&n(e[0],t)<0&&(t=(r=[e[0],t])[0],e[0]=r[1],b(e,0,n)),t},c=function(e,t){var n,r,i,o,c,l;for(null==t&&(t=a),c=[],r=0,i=(o=function(){l=[];for(var t=0,n=s(e.length/2);0<=n?t<n:t>n;0<=n?t++:t--)l.push(t);return l}.apply(this).reverse()).length;r<i;r++)n=o[r],c.push(b(e,n,t));return c},v=function(e,t,n){var r;if(null==n&&(n=a),-1!==(r=e.indexOf(t)))return y(e,0,r,n),b(e,r,n)},m=function(e,t,n){var r,i,o,s,l;if(null==n&&(n=a),!(i=e.slice(0,t)).length)return i;for(c(i,n),o=0,s=(l=e.slice(t)).length;o<s;o++)r=l[o],h(i,r,n);return i.sort(n).reverse()},g=function(e,t,n){var r,i,o,s,u,h,d,m,g;if(null==n&&(n=a),10*t<=e.length){if(!(o=e.slice(0,t).sort(n)).length)return o;for(i=o[o.length-1],s=0,h=(d=e.slice(t)).length;s<h;s++)n(r=d[s],i)<0&&(f(o,r,0,null,n),o.pop(),i=o[o.length-1]);return o}for(c(e,n),g=[],u=0,m=p(t,e.length);0<=m?u<m:u>m;0<=m?++u:--u)g.push(l(e,n));return g},y=function(e,t,n,r){var i,o,s;for(null==r&&(r=a),i=e[n];n>t&&r(i,o=e[s=n-1>>1])<0;)e[n]=o,n=s;return e[n]=i},b=function(e,t,n){var r,i,o,s,c;for(null==n&&(n=a),i=e.length,c=t,o=e[t],r=2*t+1;r<i;)(s=r+1)<i&&!(n(e[r],e[s])<0)&&(r=s),e[t]=e[r],r=2*(t=r)+1;return e[t]=o,y(e,c,t,n)},n=function(){function e(e){this.cmp=null!=e?e:a,this.nodes=[]}return e.push=u,e.pop=l,e.replace=d,e.pushpop=h,e.heapify=c,e.updateItem=v,e.nlargest=m,e.nsmallest=g,e.prototype.push=function(e){return u(this.nodes,e,this.cmp)},e.prototype.pop=function(){return l(this.nodes,this.cmp)},e.prototype.peek=function(){return this.nodes[0]},e.prototype.contains=function(e){return-1!==this.nodes.indexOf(e)},e.prototype.replace=function(e){return d(this.nodes,e,this.cmp)},e.prototype.pushpop=function(e){return h(this.nodes,e,this.cmp)},e.prototype.heapify=function(){return c(this.nodes,this.cmp)},e.prototype.updateItem=function(e){return v(this.nodes,e,this.cmp)},e.prototype.clear=function(){return this.nodes=[]},e.prototype.empty=function(){return 0===this.nodes.length},e.prototype.size=function(){return this.nodes.length},e.prototype.clone=function(){var t;return(t=new e).nodes=this.nodes.slice(0),t},e.prototype.toArray=function(){return this.nodes.slice(0)},e.prototype.insert=e.prototype.push,e.prototype.top=e.prototype.peek,e.prototype.front=e.prototype.peek,e.prototype.has=e.prototype.contains,e.prototype.copy=e.prototype.clone,e}(),i=[],void 0===(o="function"==typeof(r=function(){return n})?r.apply(t,i):r)||(e.exports=o)}).call(this)},"./node_modules/ieee754/index.js":
/*!***************************************!*\
  !*** ./node_modules/ieee754/index.js ***!
  \***************************************/
/*! no static exports found */function(e,t){t.read=function(e,t,n,r,i){var o,a,s=8*i-r-1,c=(1<<s)-1,l=c>>1,u=-7,h=n?i-1:0,d=n?-1:1,f=e[t+h];for(h+=d,o=f&(1<<-u)-1,f>>=-u,u+=s;u>0;o=256*o+e[t+h],h+=d,u-=8);for(a=o&(1<<-u)-1,o>>=-u,u+=r;u>0;a=256*a+e[t+h],h+=d,u-=8);if(0===o)o=1-l;else{if(o===c)return a?NaN:1/0*(f?-1:1);a+=Math.pow(2,r),o-=l}return(f?-1:1)*a*Math.pow(2,o-r)},t.write=function(e,t,n,r,i,o){var a,s,c,l=8*o-i-1,u=(1<<l)-1,h=u>>1,d=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,f=r?0:o-1,p=r?1:-1,m=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,a=u):(a=Math.floor(Math.log(t)/Math.LN2),t*(c=Math.pow(2,-a))<1&&(a--,c*=2),(t+=a+h>=1?d/c:d*Math.pow(2,1-h))*c>=2&&(a++,c/=2),a+h>=u?(s=0,a=u):a+h>=1?(s=(t*c-1)*Math.pow(2,i),a+=h):(s=t*Math.pow(2,h-1)*Math.pow(2,i),a=0));i>=8;e[n+f]=255&s,f+=p,s/=256,i-=8);for(a=a<<i|s,l+=i;l>0;e[n+f]=255&a,f+=p,a/=256,l-=8);e[n+f-p]|=128*m}},"./node_modules/int53/index.js":
/*!*************************************!*\
  !*** ./node_modules/int53/index.js ***!
  \*************************************/
/*! no static exports found */function(e,t){var n={};function r(e,t){if(!e)throw new Error(t)}function i(e){return(e=~e)<0&&(e=2147483648+(2147483647&e)),e}function o(e){r(e>-1&&e<=9007199254740991,"number out of range"),r(Math.floor(e)===e,"number must be an integer");var t=0,n=4294967295&e,i=n<0?2147483648+(2147483647&e):n;return e>4294967295&&(t=(e-i)/4294967296),[t,i]}function a(e){if(e>-1)return o(e);var t=o(-e),n=i(t[0]),r=i(t[1]);return 4294967295===r?(n+=1,r=0):r+=1,[n,r]}function s(e,t,n){return n&&0!=(2147483648&e)?(e=i(e),t=i(t),r(e<2097152,"number too small"),-(4294967296*e+t+1)):(r(e<2097152,"number too large"),4294967296*e+t)}n.readInt64BE=function(e,t){return t=t||0,s(e.readUInt32BE(t),e.readUInt32BE(t+4),!0)},n.readInt64LE=function(e,t){t=t||0;var n=e.readUInt32LE(t);return s(e.readUInt32LE(t+4),n,!0)},n.readUInt64BE=function(e,t){return t=t||0,s(e.readUInt32BE(t),e.readUInt32BE(t+4),!1)},n.readUInt64LE=function(e,t){t=t||0;var n=e.readUInt32LE(t);return s(e.readUInt32LE(t+4),n,!1)},n.writeInt64BE=function(e,t,n){n=n||0;var r=a(e);t.writeUInt32BE(r[0],n),t.writeUInt32BE(r[1],n+4)},n.writeInt64LE=function(e,t,n){n=n||0;var r=a(e);t.writeUInt32LE(r[1],n),t.writeUInt32LE(r[0],n+4)},n.writeUInt64BE=function(e,t,n){n=n||0;var r=o(e);t.writeUInt32BE(r[0],n),t.writeUInt32BE(r[1],n+4)},n.writeUInt64LE=function(e,t,n){n=n||0;var r=o(e);t.writeUInt32LE(r[1],n),t.writeUInt32LE(r[0],n+4)},e.exports=n},"./node_modules/isarray/index.js":
/*!***************************************!*\
  !*** ./node_modules/isarray/index.js ***!
  \***************************************/
/*! no static exports found */function(e,t){var n={}.toString;e.exports=Array.isArray||function(e){return"[object Array]"==n.call(e)}},"./node_modules/node-libs-browser/node_modules/buffer/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/node-libs-browser/node_modules/buffer/index.js ***!
  \*********************************************************************/
/*! no static exports found */function(e,t,n){"use strict";(function(e){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
var r=n(/*! base64-js */"./node_modules/base64-js/index.js"),i=n(/*! ieee754 */"./node_modules/ieee754/index.js"),o=n(/*! isarray */"./node_modules/isarray/index.js");function a(){return c.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function s(e,t){if(a()<t)throw new RangeError("Invalid typed array length");return c.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t)).__proto__=c.prototype:(null===e&&(e=new c(t)),e.length=t),e}function c(e,t,n){if(!(c.TYPED_ARRAY_SUPPORT||this instanceof c))return new c(e,t,n);if("number"==typeof e){if("string"==typeof t)throw new Error("If encoding is specified then the first argument must be a string");return h(this,e)}return l(this,e,t,n)}function l(e,t,n,r){if("number"==typeof t)throw new TypeError('"value" argument must not be a number');return"undefined"!=typeof ArrayBuffer&&t instanceof ArrayBuffer?function(e,t,n,r){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return t=void 0===n&&void 0===r?new Uint8Array(t):void 0===r?new Uint8Array(t,n):new Uint8Array(t,n,r),c.TYPED_ARRAY_SUPPORT?(e=t).__proto__=c.prototype:e=d(e,t),e}(e,t,n,r):"string"==typeof t?function(e,t,n){if("string"==typeof n&&""!==n||(n="utf8"),!c.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=0|p(t,n),i=(e=s(e,r)).write(t,n);return i!==r&&(e=e.slice(0,i)),e}(e,t,n):function(e,t){if(c.isBuffer(t)){var n=0|f(t.length);return 0===(e=s(e,n)).length||t.copy(e,0,0,n),e}if(t){if("undefined"!=typeof ArrayBuffer&&t.buffer instanceof ArrayBuffer||"length"in t)return"number"!=typeof t.length||(r=t.length)!=r?s(e,0):d(e,t);if("Buffer"===t.type&&o(t.data))return d(e,t.data)}var r;throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}(e,t)}function u(e){if("number"!=typeof e)throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function h(e,t){if(u(t),e=s(e,t<0?0:0|f(t)),!c.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function d(e,t){var n=t.length<0?0:0|f(t.length);e=s(e,n);for(var r=0;r<n;r+=1)e[r]=255&t[r];return e}function f(e){if(e>=a())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+a().toString(16)+" bytes");return 0|e}function p(e,t){if(c.isBuffer(e))return e.length;if("undefined"!=typeof ArrayBuffer&&"function"==typeof ArrayBuffer.isView&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;"string"!=typeof e&&(e=""+e);var n=e.length;if(0===n)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return B(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return z(e).length;default:if(r)return B(e).length;t=(""+t).toLowerCase(),r=!0}}function m(e,t,n){var r=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),n<=0)return"";if((n>>>=0)<=(t>>>=0))return"";for(e||(e="utf8");;)switch(e){case"hex":return O(this,t,n);case"utf8":case"utf-8":return A(this,t,n);case"ascii":return T(this,t,n);case"latin1":case"binary":return M(this,t,n);case"base64":return C(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return k(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function g(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function v(e,t,n,r,i){if(0===e.length)return-1;if("string"==typeof n?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=i?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(i)return-1;n=e.length-1}else if(n<0){if(!i)return-1;n=0}if("string"==typeof t&&(t=c.from(t,r)),c.isBuffer(t))return 0===t.length?-1:y(e,t,n,r,i);if("number"==typeof t)return t&=255,c.TYPED_ARRAY_SUPPORT&&"function"==typeof Uint8Array.prototype.indexOf?i?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):y(e,[t],n,r,i);throw new TypeError("val must be string, number or Buffer")}function y(e,t,n,r,i){var o,a=1,s=e.length,c=t.length;if(void 0!==r&&("ucs2"===(r=String(r).toLowerCase())||"ucs-2"===r||"utf16le"===r||"utf-16le"===r)){if(e.length<2||t.length<2)return-1;a=2,s/=2,c/=2,n/=2}function l(e,t){return 1===a?e[t]:e.readUInt16BE(t*a)}if(i){var u=-1;for(o=n;o<s;o++)if(l(e,o)===l(t,-1===u?0:o-u)){if(-1===u&&(u=o),o-u+1===c)return u*a}else-1!==u&&(o-=o-u),u=-1}else for(n+c>s&&(n=s-c),o=n;o>=0;o--){for(var h=!0,d=0;d<c;d++)if(l(e,o+d)!==l(t,d)){h=!1;break}if(h)return o}return-1}function b(e,t,n,r){n=Number(n)||0;var i=e.length-n;r?(r=Number(r))>i&&(r=i):r=i;var o=t.length;if(o%2!=0)throw new TypeError("Invalid hex string");r>o/2&&(r=o/2);for(var a=0;a<r;++a){var s=parseInt(t.substr(2*a,2),16);if(isNaN(s))return a;e[n+a]=s}return a}function w(e,t,n,r){return U(B(t,e.length-n),e,n,r)}function x(e,t,n,r){return U(function(e){for(var t=[],n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}(t),e,n,r)}function _(e,t,n,r){return x(e,t,n,r)}function E(e,t,n,r){return U(z(t),e,n,r)}function S(e,t,n,r){return U(function(e,t){for(var n,r,i,o=[],a=0;a<e.length&&!((t-=2)<0);++a)n=e.charCodeAt(a),r=n>>8,i=n%256,o.push(i),o.push(r);return o}(t,e.length-n),e,n,r)}function C(e,t,n){return 0===t&&n===e.length?r.fromByteArray(e):r.fromByteArray(e.slice(t,n))}function A(e,t,n){n=Math.min(e.length,n);for(var r=[],i=t;i<n;){var o,a,s,c,l=e[i],u=null,h=l>239?4:l>223?3:l>191?2:1;if(i+h<=n)switch(h){case 1:l<128&&(u=l);break;case 2:128==(192&(o=e[i+1]))&&(c=(31&l)<<6|63&o)>127&&(u=c);break;case 3:o=e[i+1],a=e[i+2],128==(192&o)&&128==(192&a)&&(c=(15&l)<<12|(63&o)<<6|63&a)>2047&&(c<55296||c>57343)&&(u=c);break;case 4:o=e[i+1],a=e[i+2],s=e[i+3],128==(192&o)&&128==(192&a)&&128==(192&s)&&(c=(15&l)<<18|(63&o)<<12|(63&a)<<6|63&s)>65535&&c<1114112&&(u=c)}null===u?(u=65533,h=1):u>65535&&(u-=65536,r.push(u>>>10&1023|55296),u=56320|1023&u),r.push(u),i+=h}return function(e){var t=e.length;if(t<=4096)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.apply(String,e.slice(r,r+=4096));return n}(r)}function T(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;i<n;++i)r+=String.fromCharCode(127&e[i]);return r}function M(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;i<n;++i)r+=String.fromCharCode(e[i]);return r}function O(e,t,n){var r,i=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>i)&&(n=i);for(var o="",a=t;a<n;++a)o+=(r=e[a])<16?"0"+r.toString(16):r.toString(16);return o}function k(e,t,n){for(var r=e.slice(t,n),i="",o=0;o<r.length;o+=2)i+=String.fromCharCode(r[o]+256*r[o+1]);return i}function R(e,t,n){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function P(e,t,n,r,i,o){if(!c.isBuffer(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>i||t<o)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function L(e,t,n,r){t<0&&(t=65535+t+1);for(var i=0,o=Math.min(e.length-n,2);i<o;++i)e[n+i]=(t&255<<8*(r?i:1-i))>>>8*(r?i:1-i)}function F(e,t,n,r){t<0&&(t=4294967295+t+1);for(var i=0,o=Math.min(e.length-n,4);i<o;++i)e[n+i]=t>>>8*(r?i:3-i)&255}function j(e,t,n,r,i,o){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function D(e,t,n,r,o){return o||j(e,0,n,4),i.write(e,t,n,r,23,4),n+4}function N(e,t,n,r,o){return o||j(e,0,n,8),i.write(e,t,n,r,52,8),n+8}t.Buffer=c,t.SlowBuffer=function(e){return+e!=e&&(e=0),c.alloc(+e)},t.INSPECT_MAX_BYTES=50,c.TYPED_ARRAY_SUPPORT=void 0!==e.TYPED_ARRAY_SUPPORT?e.TYPED_ARRAY_SUPPORT:function(){try{var e=new Uint8Array(1);return e.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}},42===e.foo()&&"function"==typeof e.subarray&&0===e.subarray(1,1).byteLength}catch(e){return!1}}(),t.kMaxLength=a(),c.poolSize=8192,c._augment=function(e){return e.__proto__=c.prototype,e},c.from=function(e,t,n){return l(null,e,t,n)},c.TYPED_ARRAY_SUPPORT&&(c.prototype.__proto__=Uint8Array.prototype,c.__proto__=Uint8Array,"undefined"!=typeof Symbol&&Symbol.species&&c[Symbol.species]===c&&Object.defineProperty(c,Symbol.species,{value:null,configurable:!0})),c.alloc=function(e,t,n){return function(e,t,n,r){return u(t),t<=0?s(e,t):void 0!==n?"string"==typeof r?s(e,t).fill(n,r):s(e,t).fill(n):s(e,t)}(null,e,t,n)},c.allocUnsafe=function(e){return h(null,e)},c.allocUnsafeSlow=function(e){return h(null,e)},c.isBuffer=function(e){return!(null==e||!e._isBuffer)},c.compare=function(e,t){if(!c.isBuffer(e)||!c.isBuffer(t))throw new TypeError("Arguments must be Buffers");if(e===t)return 0;for(var n=e.length,r=t.length,i=0,o=Math.min(n,r);i<o;++i)if(e[i]!==t[i]){n=e[i],r=t[i];break}return n<r?-1:r<n?1:0},c.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},c.concat=function(e,t){if(!o(e))throw new TypeError('"list" argument must be an Array of Buffers');if(0===e.length)return c.alloc(0);var n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;var r=c.allocUnsafe(t),i=0;for(n=0;n<e.length;++n){var a=e[n];if(!c.isBuffer(a))throw new TypeError('"list" argument must be an Array of Buffers');a.copy(r,i),i+=a.length}return r},c.byteLength=p,c.prototype._isBuffer=!0,c.prototype.swap16=function(){var e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;t<e;t+=2)g(this,t,t+1);return this},c.prototype.swap32=function(){var e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var t=0;t<e;t+=4)g(this,t,t+3),g(this,t+1,t+2);return this},c.prototype.swap64=function(){var e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;t<e;t+=8)g(this,t,t+7),g(this,t+1,t+6),g(this,t+2,t+5),g(this,t+3,t+4);return this},c.prototype.toString=function(){var e=0|this.length;return 0===e?"":0===arguments.length?A(this,0,e):m.apply(this,arguments)},c.prototype.equals=function(e){if(!c.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===c.compare(this,e)},c.prototype.inspect=function(){var e="",n=t.INSPECT_MAX_BYTES;return this.length>0&&(e=this.toString("hex",0,n).match(/.{2}/g).join(" "),this.length>n&&(e+=" ... ")),"<Buffer "+e+">"},c.prototype.compare=function(e,t,n,r,i){if(!c.isBuffer(e))throw new TypeError("Argument must be a Buffer");if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),void 0===r&&(r=0),void 0===i&&(i=this.length),t<0||n>e.length||r<0||i>this.length)throw new RangeError("out of range index");if(r>=i&&t>=n)return 0;if(r>=i)return-1;if(t>=n)return 1;if(this===e)return 0;for(var o=(i>>>=0)-(r>>>=0),a=(n>>>=0)-(t>>>=0),s=Math.min(o,a),l=this.slice(r,i),u=e.slice(t,n),h=0;h<s;++h)if(l[h]!==u[h]){o=l[h],a=u[h];break}return o<a?-1:a<o?1:0},c.prototype.includes=function(e,t,n){return-1!==this.indexOf(e,t,n)},c.prototype.indexOf=function(e,t,n){return v(this,e,t,n,!0)},c.prototype.lastIndexOf=function(e,t,n){return v(this,e,t,n,!1)},c.prototype.write=function(e,t,n,r){if(void 0===t)r="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)r=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t|=0,isFinite(n)?(n|=0,void 0===r&&(r="utf8")):(r=n,n=void 0)}var i=this.length-t;if((void 0===n||n>i)&&(n=i),e.length>0&&(n<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");r||(r="utf8");for(var o=!1;;)switch(r){case"hex":return b(this,e,t,n);case"utf8":case"utf-8":return w(this,e,t,n);case"ascii":return x(this,e,t,n);case"latin1":case"binary":return _(this,e,t,n);case"base64":return E(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return S(this,e,t,n);default:if(o)throw new TypeError("Unknown encoding: "+r);r=(""+r).toLowerCase(),o=!0}},c.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},c.prototype.slice=function(e,t){var n,r=this.length;if((e=~~e)<0?(e+=r)<0&&(e=0):e>r&&(e=r),(t=void 0===t?r:~~t)<0?(t+=r)<0&&(t=0):t>r&&(t=r),t<e&&(t=e),c.TYPED_ARRAY_SUPPORT)(n=this.subarray(e,t)).__proto__=c.prototype;else{var i=t-e;n=new c(i,void 0);for(var o=0;o<i;++o)n[o]=this[o+e]}return n},c.prototype.readUIntLE=function(e,t,n){e|=0,t|=0,n||R(e,t,this.length);for(var r=this[e],i=1,o=0;++o<t&&(i*=256);)r+=this[e+o]*i;return r},c.prototype.readUIntBE=function(e,t,n){e|=0,t|=0,n||R(e,t,this.length);for(var r=this[e+--t],i=1;t>0&&(i*=256);)r+=this[e+--t]*i;return r},c.prototype.readUInt8=function(e,t){return t||R(e,1,this.length),this[e]},c.prototype.readUInt16LE=function(e,t){return t||R(e,2,this.length),this[e]|this[e+1]<<8},c.prototype.readUInt16BE=function(e,t){return t||R(e,2,this.length),this[e]<<8|this[e+1]},c.prototype.readUInt32LE=function(e,t){return t||R(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},c.prototype.readUInt32BE=function(e,t){return t||R(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},c.prototype.readIntLE=function(e,t,n){e|=0,t|=0,n||R(e,t,this.length);for(var r=this[e],i=1,o=0;++o<t&&(i*=256);)r+=this[e+o]*i;return r>=(i*=128)&&(r-=Math.pow(2,8*t)),r},c.prototype.readIntBE=function(e,t,n){e|=0,t|=0,n||R(e,t,this.length);for(var r=t,i=1,o=this[e+--r];r>0&&(i*=256);)o+=this[e+--r]*i;return o>=(i*=128)&&(o-=Math.pow(2,8*t)),o},c.prototype.readInt8=function(e,t){return t||R(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},c.prototype.readInt16LE=function(e,t){t||R(e,2,this.length);var n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},c.prototype.readInt16BE=function(e,t){t||R(e,2,this.length);var n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},c.prototype.readInt32LE=function(e,t){return t||R(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},c.prototype.readInt32BE=function(e,t){return t||R(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},c.prototype.readFloatLE=function(e,t){return t||R(e,4,this.length),i.read(this,e,!0,23,4)},c.prototype.readFloatBE=function(e,t){return t||R(e,4,this.length),i.read(this,e,!1,23,4)},c.prototype.readDoubleLE=function(e,t){return t||R(e,8,this.length),i.read(this,e,!0,52,8)},c.prototype.readDoubleBE=function(e,t){return t||R(e,8,this.length),i.read(this,e,!1,52,8)},c.prototype.writeUIntLE=function(e,t,n,r){e=+e,t|=0,n|=0,r||P(this,e,t,n,Math.pow(2,8*n)-1,0);var i=1,o=0;for(this[t]=255&e;++o<n&&(i*=256);)this[t+o]=e/i&255;return t+n},c.prototype.writeUIntBE=function(e,t,n,r){e=+e,t|=0,n|=0,r||P(this,e,t,n,Math.pow(2,8*n)-1,0);var i=n-1,o=1;for(this[t+i]=255&e;--i>=0&&(o*=256);)this[t+i]=e/o&255;return t+n},c.prototype.writeUInt8=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,1,255,0),c.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),this[t]=255&e,t+1},c.prototype.writeUInt16LE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,2,65535,0),c.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):L(this,e,t,!0),t+2},c.prototype.writeUInt16BE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,2,65535,0),c.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):L(this,e,t,!1),t+2},c.prototype.writeUInt32LE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,4,4294967295,0),c.TYPED_ARRAY_SUPPORT?(this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e):F(this,e,t,!0),t+4},c.prototype.writeUInt32BE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,4,4294967295,0),c.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):F(this,e,t,!1),t+4},c.prototype.writeIntLE=function(e,t,n,r){if(e=+e,t|=0,!r){var i=Math.pow(2,8*n-1);P(this,e,t,n,i-1,-i)}var o=0,a=1,s=0;for(this[t]=255&e;++o<n&&(a*=256);)e<0&&0===s&&0!==this[t+o-1]&&(s=1),this[t+o]=(e/a>>0)-s&255;return t+n},c.prototype.writeIntBE=function(e,t,n,r){if(e=+e,t|=0,!r){var i=Math.pow(2,8*n-1);P(this,e,t,n,i-1,-i)}var o=n-1,a=1,s=0;for(this[t+o]=255&e;--o>=0&&(a*=256);)e<0&&0===s&&0!==this[t+o+1]&&(s=1),this[t+o]=(e/a>>0)-s&255;return t+n},c.prototype.writeInt8=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,1,127,-128),c.TYPED_ARRAY_SUPPORT||(e=Math.floor(e)),e<0&&(e=255+e+1),this[t]=255&e,t+1},c.prototype.writeInt16LE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,2,32767,-32768),c.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8):L(this,e,t,!0),t+2},c.prototype.writeInt16BE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,2,32767,-32768),c.TYPED_ARRAY_SUPPORT?(this[t]=e>>>8,this[t+1]=255&e):L(this,e,t,!1),t+2},c.prototype.writeInt32LE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,4,2147483647,-2147483648),c.TYPED_ARRAY_SUPPORT?(this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24):F(this,e,t,!0),t+4},c.prototype.writeInt32BE=function(e,t,n){return e=+e,t|=0,n||P(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),c.TYPED_ARRAY_SUPPORT?(this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e):F(this,e,t,!1),t+4},c.prototype.writeFloatLE=function(e,t,n){return D(this,e,t,!0,n)},c.prototype.writeFloatBE=function(e,t,n){return D(this,e,t,!1,n)},c.prototype.writeDoubleLE=function(e,t,n){return N(this,e,t,!0,n)},c.prototype.writeDoubleBE=function(e,t,n){return N(this,e,t,!1,n)},c.prototype.copy=function(e,t,n,r){if(n||(n=0),r||0===r||(r=this.length),t>=e.length&&(t=e.length),t||(t=0),r>0&&r<n&&(r=n),r===n)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("sourceStart out of bounds");if(r<0)throw new RangeError("sourceEnd out of bounds");r>this.length&&(r=this.length),e.length-t<r-n&&(r=e.length-t+n);var i,o=r-n;if(this===e&&n<t&&t<r)for(i=o-1;i>=0;--i)e[i+t]=this[i+n];else if(o<1e3||!c.TYPED_ARRAY_SUPPORT)for(i=0;i<o;++i)e[i+t]=this[i+n];else Uint8Array.prototype.set.call(e,this.subarray(n,n+o),t);return o},c.prototype.fill=function(e,t,n,r){if("string"==typeof e){if("string"==typeof t?(r=t,t=0,n=this.length):"string"==typeof n&&(r=n,n=this.length),1===e.length){var i=e.charCodeAt(0);i<256&&(e=i)}if(void 0!==r&&"string"!=typeof r)throw new TypeError("encoding must be a string");if("string"==typeof r&&!c.isEncoding(r))throw new TypeError("Unknown encoding: "+r)}else"number"==typeof e&&(e&=255);if(t<0||this.length<t||this.length<n)throw new RangeError("Out of range index");if(n<=t)return this;var o;if(t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0),"number"==typeof e)for(o=t;o<n;++o)this[o]=e;else{var a=c.isBuffer(e)?e:B(new c(e,r).toString()),s=a.length;for(o=0;o<n-t;++o)this[o+t]=a[o%s]}return this};var I=/[^+\/0-9A-Za-z-_]/g;function B(e,t){var n;t=t||1/0;for(var r=e.length,i=null,o=[],a=0;a<r;++a){if((n=e.charCodeAt(a))>55295&&n<57344){if(!i){if(n>56319){(t-=3)>-1&&o.push(239,191,189);continue}if(a+1===r){(t-=3)>-1&&o.push(239,191,189);continue}i=n;continue}if(n<56320){(t-=3)>-1&&o.push(239,191,189),i=n;continue}n=65536+(i-55296<<10|n-56320)}else i&&(t-=3)>-1&&o.push(239,191,189);if(i=null,n<128){if((t-=1)<0)break;o.push(n)}else if(n<2048){if((t-=2)<0)break;o.push(n>>6|192,63&n|128)}else if(n<65536){if((t-=3)<0)break;o.push(n>>12|224,n>>6&63|128,63&n|128)}else{if(!(n<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;o.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return o}function z(e){return r.toByteArray(function(e){if((e=function(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}(e).replace(I,"")).length<2)return"";for(;e.length%4!=0;)e+="=";return e}(e))}function U(e,t,n,r){for(var i=0;i<r&&!(i+n>=t.length||i>=e.length);++i)t[i+n]=e[i];return i}}).call(this,n(/*! ./../../../webpack/buildin/global.js */"./node_modules/webpack/buildin/global.js"))},"./node_modules/process/browser.js":
/*!*****************************************!*\
  !*** ./node_modules/process/browser.js ***!
  \*****************************************/
/*! no static exports found */function(e,t){var n,r,i=e.exports={};function o(){throw new Error("setTimeout has not been defined")}function a(){throw new Error("clearTimeout has not been defined")}function s(e){if(n===setTimeout)return setTimeout(e,0);if((n===o||!n)&&setTimeout)return n=setTimeout,setTimeout(e,0);try{return n(e,0)}catch(t){try{return n.call(null,e,0)}catch(t){return n.call(this,e,0)}}}!function(){try{n="function"==typeof setTimeout?setTimeout:o}catch(e){n=o}try{r="function"==typeof clearTimeout?clearTimeout:a}catch(e){r=a}}();var c,l=[],u=!1,h=-1;function d(){u&&c&&(u=!1,c.length?l=c.concat(l):h=-1,l.length&&f())}function f(){if(!u){var e=s(d);u=!0;for(var t=l.length;t;){for(c=l,l=[];++h<t;)c&&c[h].run();h=-1,t=l.length}c=null,u=!1,function(e){if(r===clearTimeout)return clearTimeout(e);if((r===a||!r)&&clearTimeout)return r=clearTimeout,clearTimeout(e);try{r(e)}catch(t){try{return r.call(null,e)}catch(t){return r.call(this,e)}}}(e)}}function p(e,t){this.fun=e,this.array=t}function m(){}i.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];l.push(new p(e,t)),1!==l.length||u||s(f)},p.prototype.run=function(){this.fun.apply(null,this.array)},i.title="browser",i.browser=!0,i.env={},i.argv=[],i.version="",i.versions={},i.on=m,i.addListener=m,i.once=m,i.off=m,i.removeListener=m,i.removeAllListeners=m,i.emit=m,i.prependListener=m,i.prependOnceListener=m,i.listeners=function(e){return[]},i.binding=function(e){throw new Error("process.binding is not supported")},i.cwd=function(){return"/"},i.chdir=function(e){throw new Error("process.chdir is not supported")},i.umask=function(){return 0}},"./node_modules/setimmediate/setImmediate.js":
/*!***************************************************!*\
  !*** ./node_modules/setimmediate/setImmediate.js ***!
  \***************************************************/
/*! no static exports found */function(e,t,n){(function(e,t){!function(e,n){"use strict";if(!e.setImmediate){var r,i,o,a,s,c=1,l={},u=!1,h=e.document,d=Object.getPrototypeOf&&Object.getPrototypeOf(e);d=d&&d.setTimeout?d:e,"[object process]"==={}.toString.call(e.process)?r=function(e){t.nextTick((function(){p(e)}))}:function(){if(e.postMessage&&!e.importScripts){var t=!0,n=e.onmessage;return e.onmessage=function(){t=!1},e.postMessage("","*"),e.onmessage=n,t}}()?(a="setImmediate$"+Math.random()+"$",s=function(t){t.source===e&&"string"==typeof t.data&&0===t.data.indexOf(a)&&p(+t.data.slice(a.length))},e.addEventListener?e.addEventListener("message",s,!1):e.attachEvent("onmessage",s),r=function(t){e.postMessage(a+t,"*")}):e.MessageChannel?((o=new MessageChannel).port1.onmessage=function(e){p(e.data)},r=function(e){o.port2.postMessage(e)}):h&&"onreadystatechange"in h.createElement("script")?(i=h.documentElement,r=function(e){var t=h.createElement("script");t.onreadystatechange=function(){p(e),t.onreadystatechange=null,i.removeChild(t),t=null},i.appendChild(t)}):r=function(e){setTimeout(p,0,e)},d.setImmediate=function(e){"function"!=typeof e&&(e=new Function(""+e));for(var t=new Array(arguments.length-1),n=0;n<t.length;n++)t[n]=arguments[n+1];var i={callback:e,args:t};return l[c]=i,r(c),c++},d.clearImmediate=f}function f(e){delete l[e]}function p(e){if(u)setTimeout(p,0,e);else{var t=l[e];if(t){u=!0;try{!function(e){var t=e.callback,n=e.args;switch(n.length){case 0:t();break;case 1:t(n[0]);break;case 2:t(n[0],n[1]);break;case 3:t(n[0],n[1],n[2]);break;default:t.apply(void 0,n)}}(t)}finally{f(e),u=!1}}}}}("undefined"==typeof self?void 0===e?this:e:self)}).call(this,n(/*! ./../webpack/buildin/global.js */"./node_modules/webpack/buildin/global.js"),n(/*! ./../process/browser.js */"./node_modules/process/browser.js"))},"./node_modules/timers-browserify/main.js":
/*!************************************************!*\
  !*** ./node_modules/timers-browserify/main.js ***!
  \************************************************/
/*! no static exports found */function(e,t,n){(function(e){var r=void 0!==e&&e||"undefined"!=typeof self&&self||window,i=Function.prototype.apply;function o(e,t){this._id=e,this._clearFn=t}t.setTimeout=function(){return new o(i.call(setTimeout,r,arguments),clearTimeout)},t.setInterval=function(){return new o(i.call(setInterval,r,arguments),clearInterval)},t.clearTimeout=t.clearInterval=function(e){e&&e.close()},o.prototype.unref=o.prototype.ref=function(){},o.prototype.close=function(){this._clearFn.call(r,this._id)},t.enroll=function(e,t){clearTimeout(e._idleTimeoutId),e._idleTimeout=t},t.unenroll=function(e){clearTimeout(e._idleTimeoutId),e._idleTimeout=-1},t._unrefActive=t.active=function(e){clearTimeout(e._idleTimeoutId);var t=e._idleTimeout;t>=0&&(e._idleTimeoutId=setTimeout((function(){e._onTimeout&&e._onTimeout()}),t))},n(/*! setimmediate */"./node_modules/setimmediate/setImmediate.js"),t.setImmediate="undefined"!=typeof self&&self.setImmediate||void 0!==e&&e.setImmediate||this&&this.setImmediate,t.clearImmediate="undefined"!=typeof self&&self.clearImmediate||void 0!==e&&e.clearImmediate||this&&this.clearImmediate}).call(this,n(/*! ./../webpack/buildin/global.js */"./node_modules/webpack/buildin/global.js"))},"./node_modules/webpack/buildin/global.js":
/*!***********************************!*\
  !*** (webpack)/buildin/global.js ***!
  \***********************************/
/*! no static exports found */function(e,t){var n;n=function(){return this}();try{n=n||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(n=window)}e.exports=n},"./src/BagReader.js":
/*!**************************!*\
  !*** ./src/BagReader.js ***!
  \**************************/
/*! exports provided: default */function(e,t,n){"use strict";n.r(t),function(e){n.d(t,"default",(function(){return c}));var r=n(/*! ./header */"./src/header.js"),i=n(/*! ./nmerge */"./src/nmerge.js"),o=n(/*! ./record */"./src/record.js"),a=n(/*! ./TimeUtil */"./src/TimeUtil.js");function s(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class c{constructor(e){s(this,"_lastReadResult",void 0),s(this,"_file",void 0),s(this,"_lastChunkInfo",void 0),this._file=e,this._lastChunkInfo=void 0}verifyBagHeader(e,t){this._file.read(0,13,(n,r)=>n||!r?e(n||new Error("Missing both error and buffer")):this._file.size()<13?e(new Error("Missing file header.")):"#ROSBAG V2.0\n"!==r.toString()?e(new Error("Cannot identify bag format.")):void t())}readHeader(e){this.verifyBagHeader(e,()=>this._file.read(13,4096,(t,n)=>{if(t||!n)return e(t||new Error("Missing both error and buffer"));const r=n.length;if(r<8)return e(new Error("Record at position 13 is truncated."));const i=n.readInt32LE(0);if(r<i+8)return e(new Error(`Record at position 13 header too large: ${i}.`));try{const t=this.readRecordFromBuffer(n,13,o.BagHeader);return e(null,t)}catch(t){return e(new Error("Could not read header from rosbag file buffer - "+t.message))}}))}readHeaderAsync(){return new Promise((e,t)=>this.readHeader((n,r)=>n||!r?t(n):e(r)))}readConnectionsAndChunkInfo(e,t,n,r){this._file.read(e,this._file.size()-e,(i,a)=>{if(i||!a)return r(i||new Error("Missing both error and buffer"));if(0===t)return r(null,{connections:[],chunkInfos:[]});const s=this.readRecordsFromBuffer(a,t,e,o.Connection),c=s[t-1].end-s[0].offset,l=this.readRecordsFromBuffer(a.slice(c),n,e+c,o.ChunkInfo);if(n>0){for(let e=0;e<n-1;e++)l[e].nextChunk=l[e+1];l[n-1].nextChunk=null}return r(null,{connections:s,chunkInfos:l})})}readConnectionsAndChunkInfoAsync(e,t,n){return new Promise((r,i)=>{this.readConnectionsAndChunkInfo(e,t,n,(e,t)=>e||!t?i(e):r(t))})}readChunkMessages(e,t,n,r,s,c){const l=n||{sec:0,nsec:0},u=r||{sec:Number.MAX_VALUE,nsec:Number.MAX_VALUE},h=t||e.connections.map(e=>e.conn);this.readChunk(e,s,(e,t)=>{if(e||!t)return c(e||new Error("Missing both error and result"));const n=t.chunk,r={};t.indices.forEach(e=>{r[e.conn]=e});const s=h.filter(e=>void 0!==r[e]).map(e=>r[e].indices[Symbol.iterator]()),d=Object(i.default)((e,t)=>a.compare(e.time,t.time),...s),f=[];let p=d.next();for(;!p.done;){const{value:e}=p;if(p=d.next(),e&&!a.isGreaterThan(l,e.time)){if(a.isGreaterThan(e.time,u))break;f.push(e)}}const m=f.map(e=>this.readRecordFromBuffer(n.data.slice(e.offset),n.dataOffset,o.MessageData));return c(null,m)})}readChunkMessagesAsync(e,t,n,r,i){return new Promise((o,a)=>{this.readChunkMessages(e,t,n,r,i,(e,t)=>e||!t?a(e):o(t))})}readChunk(t,n,r){if(t===this._lastChunkInfo&&this._lastReadResult){const t=this._lastReadResult;return e(()=>r(null,t))}const{nextChunk:i}=t,a=i?i.chunkPosition-t.chunkPosition:this._file.size()-t.chunkPosition;this._file.read(t.chunkPosition,a,(e,i)=>{if(e||!i)return r(e||new Error("Missing both error and buffer"));const a=this.readRecordFromBuffer(i,t.chunkPosition,o.Chunk),{compression:s}=a;if("none"!==s){const e=n[s];if(!e)return r(new Error("Unsupported compression type "+a.compression));const t=e(a.data,a.size);a.data=t}const c=this.readRecordsFromBuffer(i.slice(a.length),t.count,t.chunkPosition+a.length,o.IndexData);return this._lastChunkInfo=t,this._lastReadResult={chunk:a,indices:c},r(null,this._lastReadResult)})}readRecordsFromBuffer(e,t,n,r){const i=[];let o=0;for(let a=0;a<t;a++){const t=this.readRecordFromBuffer(e.slice(o),n+o,r);o+=t.end-t.offset,i.push(t)}return i}readRecordFromBuffer(e,t,n){const i=e.readInt32LE(0),o=Object(r.parseHeader)(e.slice(4,4+i),n),a=4+i+4,s=e.readInt32LE(4+i),c=e.slice(a,a+s);return o.parseData(c),o.offset=t,o.dataOffset=o.offset+4+i+4,o.end=o.dataOffset+s,o.length=o.end-o.offset,o}}}.call(this,n(/*! ./../node_modules/timers-browserify/main.js */"./node_modules/timers-browserify/main.js").setImmediate)},"./src/MessageReader.js":
/*!******************************!*\
  !*** ./src/MessageReader.js ***!
  \******************************/
/*! exports provided: MessageReader */function(module,__webpack_exports__,__nested_webpack_require_722459__){"use strict";__nested_webpack_require_722459__.r(__webpack_exports__),function(global){__nested_webpack_require_722459__.d(__webpack_exports__,"MessageReader",(function(){return MessageReader}));var int53__WEBPACK_IMPORTED_MODULE_0__=__nested_webpack_require_722459__(/*! int53 */"./node_modules/int53/index.js"),int53__WEBPACK_IMPORTED_MODULE_0___default=__nested_webpack_require_722459__.n(int53__WEBPACK_IMPORTED_MODULE_0__),_fields__WEBPACK_IMPORTED_MODULE_1__=__nested_webpack_require_722459__(/*! ./fields */"./src/fields.js"),_parseMessageDefinition__WEBPACK_IMPORTED_MODULE_2__=__nested_webpack_require_722459__(/*! ./parseMessageDefinition */"./src/parseMessageDefinition.js");function _defineProperty(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class StandardTypeReader{constructor(e){_defineProperty(this,"buffer",void 0),_defineProperty(this,"offset",void 0),_defineProperty(this,"view",void 0),_defineProperty(this,"_decoder",void 0),_defineProperty(this,"_decoderStatus","NOT_INITIALIZED"),this.buffer=e,this.offset=0,this.view=new DataView(e.buffer,e.byteOffset)}_intializeTextDecoder(){if(void 0!==global.TextDecoder)try{this._decoder=new global.TextDecoder("ascii"),this._decoderStatus="INITIALIZED"}catch(e){this._decoderStatus="NOT_AVAILABLE"}else this._decoderStatus="NOT_AVAILABLE"}json(){const e=this.string();try{return JSON.parse(e)}catch(t){return"Could not parse "+e}}string(){const e=this.int32(),t=new Uint8Array(this.buffer.buffer,this.buffer.byteOffset+this.offset,e);if(this.offset+=e,t.length<1e3)return String.fromCharCode.apply(null,t);if("NOT_INITIALIZED"===this._decoderStatus&&this._intializeTextDecoder(),this._decoder)return this._decoder.decode(t);let n="";for(let r=0;r<e;r++)n+=String.fromCharCode(t[r]);return n}bool(){return 0!==this.uint8()}int8(){return this.view.getInt8(this.offset++)}uint8(){return this.view.getUint8(this.offset++)}typedArray(e,t){const n=null==e?this.uint32():e,r=new t(this.view.buffer,this.offset+this.view.byteOffset,n);return this.offset+=n,r}int16(){const e=this.view.getInt16(this.offset,!0);return this.offset+=2,e}uint16(){const e=this.view.getUint16(this.offset,!0);return this.offset+=2,e}int32(){const e=this.view.getInt32(this.offset,!0);return this.offset+=4,e}uint32(){const e=this.view.getUint32(this.offset,!0);return this.offset+=4,e}float32(){const e=this.view.getFloat32(this.offset,!0);return this.offset+=4,e}float64(){const e=this.view.getFloat64(this.offset,!0);return this.offset+=8,e}int64(){const e=this.offset;return this.offset+=8,int53__WEBPACK_IMPORTED_MODULE_0___default.a.readInt64LE(this.buffer,e)}uint64(){const e=this.offset;return this.offset+=8,int53__WEBPACK_IMPORTED_MODULE_0___default.a.readUInt64LE(this.buffer,e)}time(){const e=this.offset;return this.offset+=8,Object(_fields__WEBPACK_IMPORTED_MODULE_1__.extractTime)(this.buffer,e)}duration(){const e=this.offset;return this.offset+=8,Object(_fields__WEBPACK_IMPORTED_MODULE_1__.extractTime)(this.buffer,e)}}const findTypeByName=(e,t="")=>{let n="";const r=e.filter(e=>{const r=e.name||"";if(!t)return!r;const i=t.indexOf("/")>-1?t:"/"+t;return!!r.endsWith(i)&&(n=r,!0)});if(1!==r.length)throw new Error(`Expected 1 top level type definition for '${t}' but found ${r.length}.`);return{...r[0],name:n}},friendlyName=e=>e.replace(/\//g,"_"),createParser=(types,freeze)=>{const unnamedTypes=types.filter(e=>!e.name);if(1!==unnamedTypes.length)throw new Error("multiple unnamed types");const[unnamedType]=unnamedTypes,namedTypes=types.filter(e=>!!e.name),constructorBody=e=>{const t=[];return e.definitions.forEach(e=>{if(!e.isConstant)if(e.isArray){if("uint8"===e.type||"int8"===e.type){const n="uint8"===e.type?"Uint8Array":"Int8Array";return void t.push(`this.${e.name} = reader.typedArray(${String(e.arrayLength)}, ${n});`)}const n="length_"+e.name;t.push(`var ${n} = ${e.arrayLength?e.arrayLength:"reader.uint32();"}`);const r="this."+e.name;if(t.push(`${r} = new Array(${n})`),t.push(`for (var i = 0; i < ${n}; i++) {`),e.isComplex){const n=findTypeByName(types,e.type);t.push(`  ${r}[i] = new Record.${friendlyName(n.name)}(reader);`)}else t.push(`  ${r}[i] = reader.${e.type}();`);t.push("}")}else if(e.isComplex){const n=findTypeByName(types,e.type);t.push(`this.${e.name} = new Record.${friendlyName(n.name)}(reader);`)}else t.push(`this.${e.name} = reader.${e.type}();`)}),freeze&&t.push("Object.freeze(this);"),t.join("\n    ")};let js=`\n  var Record = function (reader) {\n    ${constructorBody(unnamedType)}\n  };\n`,_read;namedTypes.forEach(e=>{js+=`\n  Record.${friendlyName(e.name)} = function(reader) {\n    ${constructorBody(e)}\n  };\n`}),js+="\n  return function read(reader) {\n    return new Record(reader);\n  };";try{_read=eval(`(function buildReader() { ${js} })()`)}catch(e){throw console.error("error building parser:",js),e}return function(e){const t=new StandardTypeReader(e);return _read(t)}};class MessageReader{constructor(e,t={}){_defineProperty(this,"reader",void 0);let n=e;"string"==typeof n&&(console.warn("Passing string message defintions to MessageReader is deprecated. Instead call `parseMessageDefinition` on it and pass in the resulting parsed message definition object."),n=Object(_parseMessageDefinition__WEBPACK_IMPORTED_MODULE_2__.parseMessageDefinition)(n)),this.reader=createParser(n,!!t.freeze)}readMessage(e){return this.reader(e)}}}.call(this,__nested_webpack_require_722459__(/*! ./../node_modules/webpack/buildin/global.js */"./node_modules/webpack/buildin/global.js"))},"./src/MessageWriter.js":
/*!******************************!*\
  !*** ./src/MessageWriter.js ***!
  \******************************/
/*! exports provided: MessageWriter */function(module,__webpack_exports__,__nested_webpack_require_728139__){"use strict";__nested_webpack_require_728139__.r(__webpack_exports__),function(Buffer){__nested_webpack_require_728139__.d(__webpack_exports__,"MessageWriter",(function(){return MessageWriter}));var int53__WEBPACK_IMPORTED_MODULE_0__=__nested_webpack_require_728139__(/*! int53 */"./node_modules/int53/index.js"),int53__WEBPACK_IMPORTED_MODULE_0___default=__nested_webpack_require_728139__.n(int53__WEBPACK_IMPORTED_MODULE_0__);function _defineProperty(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function writeTime(e,t,n){t.writeUInt32LE(e.sec,n),t.writeUInt32LE(e.nsec,n+4)}class StandardTypeOffsetCalculator{constructor(){_defineProperty(this,"offset",0)}_incrementAndReturn(e){const t=this.offset;return this.offset+=e,t}json(e){return this.string(JSON.stringify(e))}string(e){const t=4+e.length;return this._incrementAndReturn(t)}bool(){return this.uint8()}int8(){return this._incrementAndReturn(1)}uint8(){return this._incrementAndReturn(1)}int16(){return this._incrementAndReturn(2)}uint16(){return this._incrementAndReturn(2)}int32(){return this._incrementAndReturn(4)}uint32(){return this._incrementAndReturn(4)}float32(){return this._incrementAndReturn(4)}float64(){return this._incrementAndReturn(8)}int64(){return this._incrementAndReturn(8)}uint64(){return this._incrementAndReturn(8)}time(){return this._incrementAndReturn(8)}duration(){return this._incrementAndReturn(8)}}class StandardTypeWriter{constructor(e){_defineProperty(this,"buffer",void 0),_defineProperty(this,"view",void 0),_defineProperty(this,"offsetCalculator",void 0),this.buffer=e,this.view=new DataView(e.buffer,e.byteOffset),this.offsetCalculator=new StandardTypeOffsetCalculator}json(e){this.string(JSON.stringify(e))}string(e){const t=this.offsetCalculator.string(e);this.view.setInt32(t,e.length,!0),this.buffer.write(e,t+4,e.length,"ascii")}bool(e){this.uint8(e?1:0)}int8(e){this.view.setInt8(this.offsetCalculator.int8(),e)}uint8(e){this.view.setUint8(this.offsetCalculator.uint8(),e)}int16(e){this.view.setInt16(this.offsetCalculator.int16(),e,!0)}uint16(e){this.view.setUint16(this.offsetCalculator.uint16(),e,!0)}int32(e){this.view.setInt32(this.offsetCalculator.int32(),e,!0)}uint32(e){this.view.setUint32(this.offsetCalculator.uint32(),e,!0)}float32(e){this.view.setFloat32(this.offsetCalculator.float32(),e,!0)}float64(e){this.view.setFloat64(this.offsetCalculator.float64(),e,!0)}int64(e){int53__WEBPACK_IMPORTED_MODULE_0___default.a.writeInt64LE(e,this.buffer,this.offsetCalculator.int64())}uint64(e){int53__WEBPACK_IMPORTED_MODULE_0___default.a.writeUInt64LE(e,this.buffer,this.offsetCalculator.uint64())}time(e){writeTime(e,this.buffer,this.offsetCalculator.time())}duration(e){writeTime(e,this.buffer,this.offsetCalculator.time())}}const findTypeByName=(e,t="")=>{let n="";const r=e.filter(e=>{const r=e.name||"";if(!t)return!r;const i=t.indexOf("/")>-1?t:"/"+t;return!!r.endsWith(i)&&(n=r,!0)});if(1!==r.length)throw new Error(`Expected 1 top level type definition for '${t}' but found ${r.length}.`);return{...r[0],name:n}},friendlyName=e=>e.replace(/\//g,"_");function createWriterAndSizeCalculator(types){const unnamedTypes=types.filter(e=>!e.name);if(1!==unnamedTypes.length)throw new Error("multiple unnamed types");const[unnamedType]=unnamedTypes,namedTypes=types.filter(e=>!!e.name),constructorBody=(e,t)=>{const n=[];return e.definitions.forEach(e=>{if(e.isConstant)return;const r=`message["${e.name}"]`;if(e.isArray){const i="length_"+e.name;if(e.arrayLength?n.push(`var ${i} = ${e.arrayLength};`):(n.push(`var ${i} = ${r}.length;`),n.push(`${t}.uint32(${i});`)),n.push(`for (var i = 0; i < ${i}; i++) {`),e.isComplex){const i=findTypeByName(types,e.type);n.push(`  ${friendlyName(i.name)}(${t}, ${r}[i]);`)}else n.push(`  ${t}.${e.type}(${r}[i]);`);n.push("}")}else if(e.isComplex){const i=findTypeByName(types,e.type);n.push(`${friendlyName(i.name)}(${t}, ${r});`)}else n.push(`${t}.${e.type}(${r});`)}),n.join("\n    ")};let writerJs="",calculateSizeJs="",_write,_calculateSize;namedTypes.forEach(e=>{writerJs+=`\n  function ${friendlyName(e.name)}(writer, message) {\n    ${constructorBody(e,"writer")}\n  };\n`,calculateSizeJs+=`\n  function ${friendlyName(e.name)}(offsetCalculator, message) {\n    ${constructorBody(e,"offsetCalculator")}\n  };\n`}),writerJs+=`\n  return function write(writer, message) {\n    ${constructorBody(unnamedType,"writer")}\n    return writer.buffer;\n  };`,calculateSizeJs+=`\n  return function calculateSize(offsetCalculator, message) {\n    ${constructorBody(unnamedType,"offsetCalculator")}\n    return offsetCalculator.offset;\n  };`;try{_write=eval(`(function buildWriter() { ${writerJs} })()`)}catch(e){throw console.error("error building writer:",writerJs),e}try{_calculateSize=eval(`(function buildSizeCalculator() { ${calculateSizeJs} })()`)}catch(e){throw console.error("error building size calculator:",calculateSizeJs),e}return{writer:function(e,t){const n=new StandardTypeWriter(t);return _write(n,e)},bufferSizeCalculator(e){const t=new StandardTypeOffsetCalculator;return _calculateSize(t,e)}}}class MessageWriter{constructor(e){_defineProperty(this,"writer",void 0),_defineProperty(this,"bufferSizeCalculator",void 0);const{writer:t,bufferSizeCalculator:n}=createWriterAndSizeCalculator(e);this.writer=t,this.bufferSizeCalculator=n}calculateBufferSize(e){return this.bufferSizeCalculator(e)}writeMessage(e,t){let n=t;if(!n){const t=this.calculateBufferSize(e);n=Buffer.allocUnsafe(t)}return this.writer(e,n)}}}.call(this,__nested_webpack_require_728139__(/*! ./../node_modules/node-libs-browser/node_modules/buffer/index.js */"./node_modules/node-libs-browser/node_modules/buffer/index.js").Buffer)},"./src/ReadResult.js":
/*!***************************!*\
  !*** ./src/ReadResult.js ***!
  \***************************/
/*! exports provided: default */function(e,t,n){"use strict";function r(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}n.r(t),n.d(t,"default",(function(){return i}));class i{constructor(e,t,n,i,o,a,s){r(this,"topic",void 0),r(this,"message",void 0),r(this,"timestamp",void 0),r(this,"data",void 0),r(this,"chunkOffset",void 0),r(this,"totalChunks",void 0),this.topic=e,this.message=t,this.timestamp=n,this.data=i,this.chunkOffset=o,this.totalChunks=a,s&&(Object.freeze(n),Object.freeze(this))}}},"./src/TimeUtil.js":
/*!*************************!*\
  !*** ./src/TimeUtil.js ***!
  \*************************/
/*! exports provided: fromDate, toDate, compare, isLessThan, isGreaterThan, areSame, add */function(e,t,n){"use strict";function r(e){return{sec:Math.floor(e.getTime()/1e3),nsec:1e6*e.getMilliseconds()}}function i(e){return new Date(1e3*e.sec+e.nsec/1e6)}function o(e,t){return e.sec-t.sec||e.nsec-t.nsec}function a(e,t){return this.compare(e,t)<0}function s(e,t){return this.compare(e,t)>0}function c(e,t){return e.sec===t.sec&&e.nsec===t.nsec}function l(e){return`{${e.sec}, ${e.nsec}}`}function u(e,t){const n=e.nsec+t.nsec,r=Math.floor(n/1e9),i=n%1e9,o={sec:e.sec+t.sec+r,nsec:Math.abs(-1===Math.sign(i)?1e9+i:i)};if(o.sec<0||o.nsec<0)throw new Error(`Invalid time: ${l(o)} produced from TimeUtil.add(${l(e)}, ${l(t)}})`);return o}n.r(t),n.d(t,"fromDate",(function(){return r})),n.d(t,"toDate",(function(){return i})),n.d(t,"compare",(function(){return o})),n.d(t,"isLessThan",(function(){return a})),n.d(t,"isGreaterThan",(function(){return s})),n.d(t,"areSame",(function(){return c})),n.d(t,"add",(function(){return u}))},"./src/bag.js":
/*!********************!*\
  !*** ./src/bag.js ***!
  \********************/
/*! exports provided: default */function(e,t,n){"use strict";n.r(t),n.d(t,"default",(function(){return c})),n(/*! ./BagReader */"./src/BagReader.js");var r=n(/*! ./MessageReader */"./src/MessageReader.js"),i=n(/*! ./ReadResult */"./src/ReadResult.js"),o=(n(/*! ./record */"./src/record.js"),n(/*! ./TimeUtil */"./src/TimeUtil.js")),a=n(/*! ./parseMessageDefinition */"./src/parseMessageDefinition.js");function s(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class c{constructor(e){s(this,"reader",void 0),s(this,"header",void 0),s(this,"connections",void 0),s(this,"chunkInfos",void 0),s(this,"startTime",void 0),s(this,"endTime",void 0),this.reader=e}async open(){this.header=await this.reader.readHeaderAsync();const{connectionCount:e,chunkCount:t,indexPosition:n}=this.header,r=await this.reader.readConnectionsAndChunkInfoAsync(n,e,t);this.connections={},r.connections.forEach(e=>{this.connections[e.conn]=e}),this.chunkInfos=r.chunkInfos,t>0&&(this.startTime=this.chunkInfos[0].startTime,this.endTime=this.chunkInfos[t-1].endTime)}async readMessages(e,t){const n=this.connections,s=e.startTime||{sec:0,nsec:0},c=e.endTime||{sec:Number.MAX_VALUE,nsec:Number.MAX_VALUE},l=e.topics||Object.keys(n).map(e=>n[e].topic),u=Object.keys(n).filter(e=>-1!==l.indexOf(n[e].topic)).map(e=>+e),{decompress:h={}}=e,d=this.chunkInfos.filter(e=>o.compare(e.startTime,c)<=0&&o.compare(s,e.endTime)<=0);function f(t,o){const s=n[t.conn],{topic:c}=s,{data:l,time:u}=t;let h=null;return e.noParse||(s.reader=s.reader||new r.MessageReader(Object(a.parseMessageDefinition)(s.messageDefinition),{freeze:e.freeze}),h=s.reader.readMessage(l)),new i.default(c,h,u,l,o,d.length,e.freeze)}for(let e=0;e<d.length;e++){const n=d[e];(await this.reader.readChunkMessagesAsync(n,u,s,c,h)).forEach(n=>t(f(n,e)))}}}s(c,"open",e=>{throw new Error("This method should have been overridden based on the environment. Make sure you are correctly importing the node or web version of Bag.")})},"./src/fields.js":
/*!***********************!*\
  !*** ./src/fields.js ***!
  \***********************/
/*! exports provided: extractFields, extractTime */function(e,t,n){"use strict";n.r(t),n.d(t,"extractFields",(function(){return i})),n.d(t,"extractTime",(function(){return o}));const r="=".charCodeAt(0);function i(e){if(e.length<4)throw new Error("Header fields are truncated.");let t=0;const n={};for(;t<e.length;){const i=e.readInt32LE(t);if(t+=4,t+i>e.length)throw new Error("Header fields are corrupt.");const o=e.slice(t,t+i),a=o.indexOf(r);if(-1===a)throw new Error("Header field is missing equals sign.");n[o.slice(0,a).toString()]=o.slice(a+1),t+=i}return n}function o(e,t){return{sec:e.readUInt32LE(t),nsec:e.readUInt32LE(t+4)}}},"./src/header.js":
/*!***********************!*\
  !*** ./src/header.js ***!
  \***********************/
/*! exports provided: parseHeader */function(e,t,n){"use strict";n.r(t),n.d(t,"parseHeader",(function(){return i}));var r=n(/*! ./fields */"./src/fields.js");function i(e,t){const n=Object(r.extractFields)(e);if(void 0===n.op)throw new Error("Header is missing 'op' field.");const i=n.op.readUInt8(0);if(i!==t.opcode)throw new Error(`Expected ${t.name} (${t.opcode}) but found ${i}`);return new t(n)}n(/*! ./record */"./src/record.js")},"./src/index.js":
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
/*! no static exports found */function(e,t,n){"use strict";n.r(t);var r=n(/*! ./TimeUtil */"./src/TimeUtil.js");n.d(t,"TimeUtil",(function(){return r})),n(/*! ./bag */"./src/bag.js"),n(/*! ./BagReader */"./src/BagReader.js");var i=n(/*! ./MessageReader */"./src/MessageReader.js");n.d(t,"MessageReader",(function(){return i.MessageReader}));var o=n(/*! ./MessageWriter */"./src/MessageWriter.js");n.d(t,"MessageWriter",(function(){return o.MessageWriter}));var a=n(/*! ./parseMessageDefinition */"./src/parseMessageDefinition.js");n.d(t,"rosPrimitiveTypes",(function(){return a.rosPrimitiveTypes})),n.d(t,"parseMessageDefinition",(function(){return a.parseMessageDefinition}));var s=n(/*! ./types */"./src/types.js");for(var c in s)["TimeUtil","default","MessageReader","MessageWriter","rosPrimitiveTypes","parseMessageDefinition","default"].indexOf(c)<0&&function(e){n.d(t,e,(function(){return s[e]}))}(c);var l=n(/*! ./fields */"./src/fields.js");n.d(t,"extractFields",(function(){return l.extractFields})),n.d(t,"extractTime",(function(){return l.extractTime}))},"./src/nmerge.js":
/*!***********************!*\
  !*** ./src/nmerge.js ***!
  \***********************/
/*! exports provided: default */function(e,t,n){"use strict";n.r(t);var r=n(/*! heap */"./node_modules/heap/index.js"),i=n.n(r);t.default=function(e,...t){const n=new i.a((t,n)=>e(t.value,n.value));for(let e=0;e<t.length;e++){const{value:r,done:i}=t[e].next();i||n.push({i:e,value:r})}return{next:()=>{if(n.empty())return{done:!0};const{i:e}=n.front(),r=t[e].next();return r.done?{value:n.pop().value,done:!1}:{value:n.replace({i:e,value:r.value}).value,done:!1}}}}},"./src/parseMessageDefinition.js":
/*!***************************************!*\
  !*** ./src/parseMessageDefinition.js ***!
  \***************************************/
/*! exports provided: rosPrimitiveTypes, parseMessageDefinition */function(e,t,n){"use strict";n.r(t),n.d(t,"rosPrimitiveTypes",(function(){return r})),n.d(t,"parseMessageDefinition",(function(){return a}));const r=new Set(["string","bool","int8","uint8","int16","uint16","int32","uint32","float32","float64","int64","uint64","time","duration","json"]);function i(e){let t=e;return"char"===e&&(t="uint8"),"byte"===e&&(t="int8"),t}const o=e=>{const t=[];let n;return e.forEach(({isJson:e,line:o})=>{const a=o.replace(/#.*/gi,"").split(" ").filter(e=>e);if(!a[1])return;const s=a[0].trim(),c=a[1].trim();if("MSG:"===s)n=c;else if(c.indexOf("=")>-1||a.indexOf("=")>-1){const e=o.match(/(\S+)\s*=\s*(.*)\s*/);if(!e)throw new Error("Malformed line: "+o);let n=e[2];if("string"!==s){n=n.replace(/True/gi,"true"),n=n.replace(/False/gi,"false");try{n=JSON.parse(n.replace(/\s*#.*/g,""))}catch(e){throw console.warn("Error in this constant definition: "+o),e}"bool"===s&&(n=Boolean(n))}(s.includes("int")&&n>Number.MAX_SAFE_INTEGER||n<Number.MIN_SAFE_INTEGER)&&console.warn("Found integer constant outside safe integer range: "+o),t.push({type:i(s),name:e[1],isConstant:!0,value:n})}else if(s.indexOf("]")===s.length-1){const e=s.split("["),n=e[0],o=e[1].replace("]","");t.push(function(e,t,n){const o=i(e);return{type:o,name:t,isArray:!0,arrayLength:null===n?void 0:n,isComplex:!r.has(o)}}(n,c,o?parseInt(o,10):void 0))}else t.push(function(e,t){const n=i(e);return{type:n,name:t,isArray:!1,isComplex:!r.has(n)}}(e?"json":s,c))}),{name:n,definitions:t}};function a(e){const t=e.split("\n").map(e=>e.trim()).filter(e=>e);let n=[];const r=[];let i=!1;return t.forEach(e=>{e.startsWith("#")?e.startsWith("#pragma rosbag_parse_json")&&(i=!0):e.startsWith("==")?(i=!1,r.push(o(n)),n=[]):(n.push({isJson:i,line:e}),i=!1)}),r.push(o(n)),r.forEach(({definitions:e})=>{e.forEach(e=>{if(e.isComplex){const t=((e,t)=>{const n=e.filter(e=>{const n=e.name||"";if(!t)return!n;const r=t.indexOf("/")>-1?t:"/"+t;return n.endsWith(r)});if(1!==n.length)throw new Error(`Expected 1 top level type definition for '${t}' but found ${n.length}`);return n[0]})(r,e.type).name;if(void 0===t)throw new Error("Missing type definition for "+e.type);e.type=t}})}),r}},"./src/record.js":
/*!***********************!*\
  !*** ./src/record.js ***!
  \***********************/
/*! exports provided: Record, BagHeader, Chunk, Connection, MessageData, IndexData, ChunkInfo */function(e,t,n){"use strict";n.r(t),n.d(t,"Record",(function(){return c})),n.d(t,"BagHeader",(function(){return l})),n.d(t,"Chunk",(function(){return u})),n.d(t,"Connection",(function(){return d})),n.d(t,"MessageData",(function(){return f})),n.d(t,"IndexData",(function(){return p})),n.d(t,"ChunkInfo",(function(){return m}));var r=n(/*! int53 */"./node_modules/int53/index.js"),i=n.n(r),o=n(/*! ./fields */"./src/fields.js");function a(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}n(/*! ./MessageReader */"./src/MessageReader.js");const s=e=>i.a.readUInt64LE(e,0);class c{constructor(e){a(this,"offset",void 0),a(this,"dataOffset",void 0),a(this,"end",void 0),a(this,"length",void 0)}parseData(e){}}class l extends c{constructor(e){super(e),a(this,"indexPosition",void 0),a(this,"connectionCount",void 0),a(this,"chunkCount",void 0),this.indexPosition=s(e.index_pos),this.connectionCount=e.conn_count.readInt32LE(0),this.chunkCount=e.chunk_count.readInt32LE(0)}}a(l,"opcode",3);class u extends c{constructor(e){super(e),a(this,"compression",void 0),a(this,"size",void 0),a(this,"data",void 0),this.compression=e.compression.toString(),this.size=e.size.readUInt32LE(0)}parseData(e){this.data=e}}a(u,"opcode",5);const h=(e,t)=>{if(void 0===e[t])throw new Error(`Connection header is missing ${t}.`);return e[t].toString()};class d extends c{constructor(e){super(e),a(this,"conn",void 0),a(this,"topic",void 0),a(this,"type",void 0),a(this,"md5sum",void 0),a(this,"messageDefinition",void 0),a(this,"callerid",void 0),a(this,"latching",void 0),a(this,"reader",void 0),this.conn=e.conn.readUInt32LE(0),this.topic=e.topic.toString(),this.type=void 0,this.md5sum=void 0,this.messageDefinition=""}parseData(e){const t=Object(o.extractFields)(e);this.type=h(t,"type"),this.md5sum=h(t,"md5sum"),this.messageDefinition=h(t,"message_definition"),void 0!==t.callerid&&(this.callerid=t.callerid.toString()),void 0!==t.latching&&(this.latching="1"===t.latching.toString())}}a(d,"opcode",7);class f extends c{constructor(e){super(e),a(this,"conn",void 0),a(this,"time",void 0),a(this,"data",void 0),this.conn=e.conn.readUInt32LE(0),this.time=Object(o.extractTime)(e.time,0)}parseData(e){this.data=e}}a(f,"opcode",2);class p extends c{constructor(e){super(e),a(this,"ver",void 0),a(this,"conn",void 0),a(this,"count",void 0),a(this,"indices",void 0),this.ver=e.ver.readUInt32LE(0),this.conn=e.conn.readUInt32LE(0),this.count=e.count.readUInt32LE(0)}parseData(e){this.indices=[];for(let t=0;t<this.count;t++)this.indices.push({time:Object(o.extractTime)(e,12*t),offset:e.readUInt32LE(12*t+8)})}}a(p,"opcode",4);class m extends c{constructor(e){super(e),a(this,"ver",void 0),a(this,"chunkPosition",void 0),a(this,"startTime",void 0),a(this,"endTime",void 0),a(this,"count",void 0),a(this,"connections",void 0),a(this,"nextChunk",void 0),this.ver=e.ver.readUInt32LE(0),this.chunkPosition=s(e.chunk_pos),this.startTime=Object(o.extractTime)(e.start_time,0),this.endTime=Object(o.extractTime)(e.end_time,0),this.count=e.count.readUInt32LE(0)}parseData(e){this.connections=[];for(let t=0;t<this.count;t++)this.connections.push({conn:e.readUInt32LE(8*t),count:e.readUInt32LE(8*t+4)})}}a(m,"opcode",6)},"./src/types.js":
/*!**********************!*\
  !*** ./src/types.js ***!
  \**********************/
/*! no static exports found */function(e,t){},"./src/web/index.js":
/*!**************************!*\
  !*** ./src/web/index.js ***!
  \**************************/
/*! no static exports found */function(e,t,n){"use strict";n.r(t),function(e){n.d(t,"Reader",(function(){return u})),n.d(t,"open",(function(){return h}));var r=n(/*! buffer */"./node_modules/node-libs-browser/node_modules/buffer/index.js"),i=n(/*! ../index */"./src/index.js");n.d(t,"TimeUtil",(function(){return i.TimeUtil})),n.d(t,"MessageReader",(function(){return i.MessageReader})),n.d(t,"MessageWriter",(function(){return i.MessageWriter})),n.d(t,"parseMessageDefinition",(function(){return i.parseMessageDefinition})),n.d(t,"rosPrimitiveTypes",(function(){return i.rosPrimitiveTypes})),n.d(t,"extractFields",(function(){return i.extractFields})),n.d(t,"extractTime",(function(){return i.extractTime}));var o=n(/*! ../bag */"./src/bag.js"),a=n(/*! ../BagReader */"./src/BagReader.js");n.d(t,"BagReader",(function(){return a.default}));var s=n(/*! ../types */"./src/types.js");for(var c in s)["Reader","TimeUtil","BagReader","MessageReader","MessageWriter","open","parseMessageDefinition","rosPrimitiveTypes","extractFields","extractTime","default"].indexOf(c)<0&&function(e){n.d(t,e,(function(){return s[e]}))}(c);function l(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class u{constructor(e){l(this,"_blob",void 0),l(this,"_size",void 0),this._blob=e,this._size=e.size}read(t,n,i){const o=new FileReader;o.onload=function(){o.onload=null,o.onerror=null,e(i,null,r.Buffer.from(o.result))},o.onerror=function(){o.onload=null,o.onerror=null,e(i,new Error(o.error))},o.readAsArrayBuffer(this._blob.slice(t,t+n))}size(){return this._size}}const h=async e=>{if(!(e instanceof Blob))throw new Error("Expected file to be a File or Blob. Make sure you are correctly importing the node or web version of Bag.");const t=new o.default(new a.default(new u(e)));return await t.open(),t};o.default.open=h,t.default=o.default}.call(this,n(/*! ./../../node_modules/timers-browserify/main.js */"./node_modules/timers-browserify/main.js").setImmediate)}})},module.exports=factory()},HLqC:function(e,t,n){var r=n("R5Y4"),i=n("mv/X"),o=n("ZCgT");e.exports=function(e){return function(t,n,a){return a&&"number"!=typeof a&&i(t,n,a)&&(n=a=void 0),t=o(t),void 0===n?(n=t,t=0):n=o(n),a=void 0===a?t<n?1:-1:o(a),r(t,n,a,e)}}},HOxn:function(e,t,n){var r=n("Cwc5")(n("Kz5y"),"Promise");e.exports=r},HRR4:function(e,t,n){"use strict";var r=n("IPAr"),i=n("kaWx");e.exports=o,o.notInList=!0,o.notInBlock=!0;function o(e,t,n){for(var r,o,c,l,u,h,d,f,p=this.options.commonmark,m=0,g=t.length,v="";m<g&&(" "===(l=t.charAt(m))||"\t"===l);)v+=l,m++;if("["===(l=t.charAt(m))){for(m++,v+=l,c="";m<g&&"]"!==(l=t.charAt(m));)"\\"===l&&(c+=l,m++,l=t.charAt(m)),c+=l,m++;if(c&&"]"===t.charAt(m)&&":"===t.charAt(m+1)){for(h=c,m=(v+=c+"]:").length,c="";m<g&&("\t"===(l=t.charAt(m))||" "===l||"\n"===l);)v+=l,m++;if(c="",r=v,"<"===(l=t.charAt(m))){for(m++;m<g&&a(l=t.charAt(m));)c+=l,m++;if((l=t.charAt(m))===a.delimiter)v+="<"+c+l,m++;else{if(p)return;m-=c.length+1,c=""}}if(!c){for(;m<g&&s(l=t.charAt(m));)c+=l,m++;v+=c}if(c){for(d=c,c="";m<g&&("\t"===(l=t.charAt(m))||" "===l||"\n"===l);)c+=l,m++;if(u=null,'"'===(l=t.charAt(m))?u='"':"'"===l?u="'":"("===l&&(u=")"),u){if(!c)return;for(m=(v+=c+l).length,c="";m<g&&(l=t.charAt(m))!==u;){if("\n"===l){if(m++,"\n"===(l=t.charAt(m))||l===u)return;c+="\n"}c+=l,m++}if((l=t.charAt(m))!==u)return;o=v,v+=c+l,m++,f=c,c=""}else c="",m=v.length;for(;m<g&&("\t"===(l=t.charAt(m))||" "===l);)v+=l,m++;return(l=t.charAt(m))&&"\n"!==l?void 0:!!n||(r=e(r).test().end,d=this.decode.raw(this.unescape(d),r,{nonTerminated:!1}),f&&(o=e(o).test().end,f=this.decode.raw(this.unescape(f),o)),e(v)({type:"definition",identifier:i(h),title:f||null,url:d}))}}}}function a(e){return">"!==e&&"["!==e&&"]"!==e}function s(e){return"["!==e&&"]"!==e&&!r(e)}a.delimiter=">"},HeW1:function(e,t,n){"use strict";e.exports=function(e,t){return t||(t={}),"string"!=typeof(e=e&&e.__esModule?e.default:e)?e:(/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e)}},Hvzi:function(e,t){e.exports=function(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}},HzoJ:function(e,t,n){var r=n("b5wT");e.exports=function(e,t){return r.map(t,(function(t){var n=e.inEdges(t);if(n.length){var i=r.reduce(n,(function(t,n){var r=e.edge(n),i=e.node(n.v);return{sum:t.sum+r.weight*i.order,weight:t.weight+r.weight}}),{sum:0,weight:0});return{v:t,barycenter:i.sum/i.weight,weight:i.weight}}return{v:t}}))}},I01J:function(e,t,n){var r=n("44Ds");e.exports=function(e){var t=r(e,(function(e){return 500===n.size&&n.clear(),e})),n=t.cache;return t}},IOzZ:function(e,t){e.exports=function(e,t){return function(n){return null!=n&&(n[e]===t&&(void 0!==t||e in Object(n)))}}},IPAr:function(e,t,n){"use strict";e.exports=function(e){return i.test("number"==typeof e?r(e):e.charAt(0))};var r=String.fromCharCode,i=/\s/},IRYA:function(e,t){var n=Object.prototype.toString;e.exports=function(e){return"[object String]"===n.call(e)}},IWTy:function(e,t,n){var r=n("yue5");e.exports=function(e,t,n){for(var i=-1,o=e.criteria,a=t.criteria,s=o.length,c=n.length;++i<s;){var l=r(o[i],a[i]);if(l)return i>=c?l:l*("desc"==n[i]?-1:1)}return e.index-t.index}},Ig6t:function(e,t,n){var r=n("b5wT"),i=n("tQ6r");function o(e,t,n,r,o,a){var s={width:0,height:0,rank:a,borderType:t},c=o[t][a-1],l=i.addDummyNode(e,"border",s,n);o[t][a]=l,e.setParent(l,r),c&&e.setEdge(c,l,{weight:1})}e.exports=function(e){r.forEach(e.children(),(function t(n){var i=e.children(n),a=e.node(n);if(i.length&&r.forEach(i,t),r.has(a,"minRank")){a.borderLeft=[],a.borderRight=[];for(var s=a.minRank,c=a.maxRank+1;s<c;++s)o(e,"borderLeft","_bl",n,a,s),o(e,"borderRight","_br",n,a,s)}}))}},Ijbi:function(e,t,n){var r=n("WkPL");e.exports=function(e){if(Array.isArray(e))return r(e)},e.exports.default=e.exports,e.exports.__esModule=!0},Ioao:function(e,t,n){var r=n("heNW"),i=Math.max;e.exports=function(e,t,n){return t=i(void 0===t?e.length-1:t,0),function(){for(var o=arguments,a=-1,s=i(o.length-t,0),c=Array(s);++a<s;)c[a]=o[t+a];a=-1;for(var l=Array(t+1);++a<t;)l[a]=o[a];return l[t]=n(c),r(e,this,l)}}},IoeE:function(e,t,n){"use strict";e.exports=function e(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return(t.children||[]).reduce((function(t,n){return"definition"===n.type&&(t[n.identifier]={href:n.url,title:n.title}),e(n,t)}),n)}},IujW:function(e,t,n){"use strict";function r(e){return function(e){if(Array.isArray(e)){for(var t=0,n=new Array(e.length);t<e.length;t++)n[t]=e[t];return n}}(e)||function(e){if(Symbol.iterator in Object(e)||"[object Arguments]"===Object.prototype.toString.call(e))return Array.from(e)}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance")}()}var i=n("U6jy"),o=n("1VtT"),a=n("fUUT"),s=n("17x9"),c=n("wnOJ"),l=n("cVWj"),u=n("u3i/"),h=n("UV+P"),d=n("9Z5P"),f=n("IoeE"),p=n("Nw8X"),m=n("3m36"),g=n("h9ck"),v=Object.keys(m),y=function(e){var t=e.source||e.children||"",n=e.parserOptions;if(e.allowedTypes&&e.disallowedTypes)throw new Error("Only one of `allowedTypes` and `disallowedTypes` should be defined");var r=i(m,e.renderers),s=[[a,n]].concat(e.plugins||[]).reduce(b,o()),p=s.parse(t),y=i(e,{renderers:r,definitions:f(p)}),w=function(e){var t=[d,c()],n=e.disallowedTypes;e.allowedTypes&&(n=v.filter((function(t){return"root"!==t&&-1===e.allowedTypes.indexOf(t)})));var r=e.unwrapDisallowed?"unwrap":"remove";n&&n.length>0&&t.push(u.ofType(n,r));e.allowNode&&t.push(u.ifNotMatch(e.allowNode,r));var i=!e.escapeHtml&&!e.skipHtml,o=(e.astPlugins||[]).some((function(e){return(Array.isArray(e)?e[0]:e).identity===g.HtmlParser}));i&&!o&&t.push(l);return e.astPlugins?t.concat(e.astPlugins):t}(e),x=s.runSync(p),_=w.reduce((function(e,t){return t(e,y)}),x);return h(_,y)};function b(e,t){return Array.isArray(t)?e.use.apply(e,r(t)):e.use(t)}y.defaultProps={renderers:{},escapeHtml:!0,skipHtml:!1,sourcePos:!1,rawSourcePos:!1,transformLinkUri:p,astPlugins:[],plugins:[],parserOptions:{}},y.propTypes={className:s.string,source:s.string,children:s.string,sourcePos:s.bool,rawSourcePos:s.bool,escapeHtml:s.bool,skipHtml:s.bool,allowNode:s.func,allowedTypes:s.arrayOf(s.oneOf(v)),disallowedTypes:s.arrayOf(s.oneOf(v)),transformLinkUri:s.oneOfType([s.func,s.bool]),linkTarget:s.oneOfType([s.func,s.string]),transformImageUri:s.func,astPlugins:s.arrayOf(s.func),unwrapDisallowed:s.bool,renderers:s.object,plugins:s.array,parserOptions:s.object},y.types=v,y.renderers=m,y.uriTransformer=p,e.exports=y},Ivbl:function(e,t,n){var r=n("epdU"),i=e.exports={Ros:n("U1bi"),Topic:n("cqyl"),Message:n("PjQo"),Param:n("WQ2p"),Service:n("US93"),ServiceRequest:n("kAvd"),ServiceResponse:n("b3Az")};r(i.Ros,["Param","Service","Topic"],i)},IyW0:function(e,t,n){"use strict";var r=n("b5wT"),i=n("tQ6r"),o=n("jFXE").positionX;e.exports=function(e){(function(e){var t=i.buildLayerMatrix(e),n=e.graph().ranksep,o=0;r.forEach(t,(function(t){var i=r.max(r.map(t,(function(t){return e.node(t).height})));r.forEach(t,(function(t){e.node(t).y=o+i/2})),o+=i+n}))})(e=i.asNonCompoundGraph(e)),r.forEach(o(e),(function(t,n){e.node(n).x=t}))}},J2m7:function(e,t,n){var r=n("XKAG")(n("UfWW"));e.exports=r},J4zp:function(e,t,n){var r=n("wTVA"),i=n("m0LI"),o=n("ZhPi"),a=n("wkBT");e.exports=function(e,t){return r(e)||i(e,t)||o(e,t)||a()},e.exports.default=e.exports,e.exports.__esModule=!0},J5yW:function(e,t,n){"use strict";var r=n("1iAE"),i=n("ZONP");e.exports=function(e){return r(e)||i(e)}},JC6p:function(e,t,n){var r=n("cq/+"),i=n("7GkX");e.exports=function(e,t){return e&&r(e,t,i)}},JHRd:function(e,t,n){var r=n("Kz5y").Uint8Array;e.exports=r},JHgL:function(e,t,n){var r=n("QkVE");e.exports=function(e){return r(this,e).get(e)}},JPst:function(e,t,n){"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var n=function(e,t){var n=e[1]||"",r=e[3];if(!r)return n;if(t&&"function"==typeof btoa){var i=(a=r,s=btoa(unescape(encodeURIComponent(JSON.stringify(a)))),c="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(s),"/*# ".concat(c," */")),o=r.sources.map((function(e){return"/*# sourceURL=".concat(r.sourceRoot||"").concat(e," */")}));return[n].concat(o).concat([i]).join("\n")}var a,s,c;return[n].join("\n")}(t,e);return t[2]?"@media ".concat(t[2]," {").concat(n,"}"):n})).join("")},t.i=function(e,n,r){"string"==typeof e&&(e=[[null,e,""]]);var i={};if(r)for(var o=0;o<this.length;o++){var a=this[o][0];null!=a&&(i[a]=!0)}for(var s=0;s<e.length;s++){var c=[].concat(e[s]);r&&i[c[0]]||(n&&(c[2]?c[2]="".concat(n," and ").concat(c[2]):c[2]=n),t.push(c))}},t}},JRpN:function(e,t,n){var r=n("b5wT"),i=n("tQ6r");e.exports={run:function(e){var t=i.addDummyNode(e,"root",{},"_root"),n=function(e){var t={};return r.forEach(e.children(),(function(n){!function n(i,o){var a=e.children(i);a&&a.length&&r.forEach(a,(function(e){n(e,o+1)}));t[i]=o}(n,1)})),t}(e),o=r.max(r.values(n))-1,a=2*o+1;e.graph().nestingRoot=t,r.forEach(e.edges(),(function(t){e.edge(t).minlen*=a}));var s=function(e){return r.reduce(e.edges(),(function(t,n){return t+e.edge(n).weight}),0)}(e)+1;r.forEach(e.children(),(function(c){!function e(t,n,o,a,s,c,l){var u=t.children(l);if(!u.length)return void(l!==n&&t.setEdge(n,l,{weight:0,minlen:o}));var h=i.addBorderNode(t,"_bt"),d=i.addBorderNode(t,"_bb"),f=t.node(l);t.setParent(h,l),f.borderTop=h,t.setParent(d,l),f.borderBottom=d,r.forEach(u,(function(r){e(t,n,o,a,s,c,r);var i=t.node(r),u=i.borderTop?i.borderTop:r,f=i.borderBottom?i.borderBottom:r,p=i.borderTop?a:2*a,m=u!==f?1:s-c[l]+1;t.setEdge(h,u,{weight:p,minlen:m,nestingEdge:!0}),t.setEdge(f,d,{weight:p,minlen:m,nestingEdge:!0})})),t.parent(l)||t.setEdge(n,h,{weight:0,minlen:s+c[l]})}(e,t,a,s,o,n,c)})),e.graph().nodeRankFactor=a},cleanup:function(e){var t=e.graph();e.removeNode(t.nestingRoot),delete t.nestingRoot,r.forEach(e.edges(),(function(t){e.edge(t).nestingEdge&&e.removeEdge(t)}))}}},JSQU:function(e,t,n){var r=n("YESw");e.exports=function(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=r&&void 0===t?"__lodash_hash_undefined__":t,this}},JTzB:function(e,t,n){var r=n("NykK"),i=n("ExA7");e.exports=function(e){return i(e)&&"[object Arguments]"==r(e)}},JZM8:function(e,t,n){var r=n("FfPP"),i=n("xs/l")((function(e,t){return null==e?{}:r(e,t)}));e.exports=i},JlFY:function(e,t,n){"use strict";var r=n("IPAr"),i=n("Brp5");e.exports=o,o.locator=i;function o(e,t,n){for(var i,o,a,s,c,l,u,h,d=t.length,f=0,p="",m="";f<d&&"`"===t.charAt(f);)p+="`",f++;if(p){for(c=p,s=f,p="",h=t.charAt(f),a=0;f<d;){if(l=h,h=t.charAt(f+1),"`"===l?(a++,m+=l):(a=0,p+=l),a&&"`"!==h){if(a===s){c+=p+m,u=!0;break}p+=m,m=""}f++}if(!u){if(s%2!=0)return;p=""}if(n)return!0;for(i="",o="",d=p.length,f=-1;++f<d;)l=p.charAt(f),r(l)?o+=l:(o&&(i&&(i+=o),o=""),i+=l);return e(c)({type:"inlineCode",value:i})}}},JmpY:function(e,t,n){var r=n("eUgh");e.exports=function(e,t){return r(t,(function(t){return e[t]}))}},JqBK:function(e,t,n){"use strict";e.exports=function(e){return String(e).replace(/\s+/g," ")}},Juji:function(e,t){e.exports=function(e,t){return null!=e&&t in Object(e)}},K2KW:function(e,t,n){"use strict";var r=n("RjOF"),i=n("3GlI");e.exports=function(e,t,n){var r,a,s,c=-1,l=t.length,u="",h="",d="",f="";for(;++c<l;)if(r=t.charAt(c),s)if(s=!1,u+=d,h+=f,d="",f="","\n"===r)d=r,f=r;else for(u+=r,h+=r;++c<l;){if(!(r=t.charAt(c))||"\n"===r){f=r,d=r;break}u+=r,h+=r}else if(" "===r&&t.charAt(c+1)===r&&t.charAt(c+2)===r&&t.charAt(c+3)===r)d+=o,c+=3,s=!0;else if("\t"===r)d+=r,s=!0;else{for(a="";"\t"===r||" "===r;)a+=r,r=t.charAt(++c);if("\n"!==r)break;d+=a+r,f+=r}if(h)return!!n||e(u)({type:"code",lang:null,value:i(h)})};var o=r(" ",4)},KJAg:function(e,t,n){"use strict";e.exports=function(e,t,n,r){var i,o,a,s,c,l,u=["pedantic","commonmark"],h=u.length,d=e.length,f=-1;for(;++f<d;){for(i=e[f],o=i[1]||{},a=i[0],s=-1,l=!1;++s<h;)if(void 0!==o[c=u[s]]&&o[c]!==n.options[c]){l=!0;break}if(!l&&t[a].apply(n,r))return!0}return!1}},KMkd:function(e,t){e.exports=function(){this.__data__=[],this.size=0}},KX5q:function(e,t,n){"use strict";var r=n("RsFJ"),i=n("IPAr"),o=n("BjVE");e.exports=a,a.locator=o;function a(e,t,n){var o,a,s,c,l,u,h,d=0,f=t.charAt(d);if(!("*"!==f&&"_"!==f||t.charAt(++d)!==f||(a=this.options.pedantic,l=(s=f)+s,u=t.length,d++,c="",f="",a&&i(t.charAt(d)))))for(;d<u;){if(h=f,!((f=t.charAt(d))!==s||t.charAt(d+1)!==s||a&&i(h))&&(f=t.charAt(d+2))!==s){if(!r(c))return;return!!n||((o=e.now()).column+=2,o.offset+=2,e(l+c+l)({type:"strong",children:this.tokenizeInline(c,o)}))}a||"\\"!==f||(c+=f,f=t.charAt(++d)),c+=f,d++}}},"KZ/l":function(e,t,n){var r=n("b5wT"),i=n("F9We").Graph,o=n("RYnF");e.exports=function(e,t){if(e.nodeCount()<=1)return[];var n=function(e,t){var n=new i,a=0,s=0;r.forEach(e.nodes(),(function(e){n.setNode(e,{v:e,in:0,out:0})})),r.forEach(e.edges(),(function(e){var r=n.edge(e.v,e.w)||0,i=t(e),o=r+i;n.setEdge(e.v,e.w,o),s=Math.max(s,n.node(e.v).out+=i),a=Math.max(a,n.node(e.w).in+=i)}));var l=r.range(s+a+3).map((function(){return new o})),u=a+1;return r.forEach(n.nodes(),(function(e){c(l,u,n.node(e))})),{graph:n,buckets:l,zeroIdx:u}}(e,t||a),l=function(e,t,n){var r,i=[],o=t[t.length-1],a=t[0];for(;e.nodeCount();){for(;r=a.dequeue();)s(e,t,n,r);for(;r=o.dequeue();)s(e,t,n,r);if(e.nodeCount())for(var c=t.length-2;c>0;--c)if(r=t[c].dequeue()){i=i.concat(s(e,t,n,r,!0));break}}return i}(n.graph,n.buckets,n.zeroIdx);return r.flatten(r.map(l,(function(t){return e.outEdges(t.v,t.w)})),!0)};var a=r.constant(1);function s(e,t,n,i,o){var a=o?[]:void 0;return r.forEach(e.inEdges(i.v),(function(r){var i=e.edge(r),s=e.node(r.v);o&&a.push({v:r.v,w:r.w}),s.out-=i,c(t,n,s)})),r.forEach(e.outEdges(i.v),(function(r){var i=e.edge(r),o=r.w,a=e.node(o);a.in-=i,c(t,n,a)})),e.removeNode(i.v),a}function c(e,t,n){n.out?n.in?e[n.out-n.in+t].enqueue(n):e[e.length-1].enqueue(n):e[0].enqueue(n)}},KfNM:function(e,t){var n=Object.prototype.toString;e.exports=function(e){return n.call(e)}},Kp9H:function(e,t,n){"use strict";var r=n("b5wT"),i=n("5jIi"),o=n("14Cm"),a=n("OOL/"),s=n("iBet"),c=n("1PPP"),l=n("F9We").Graph,u=n("tQ6r");function h(e,t,n){return r.map(t,(function(t){return s(e,t,n)}))}function d(e,t){var n=new l;r.forEach(e,(function(e){var i=e.graph().root,o=a(e,i,n,t);r.forEach(o.vs,(function(t,n){e.node(t).order=n})),c(e,n,o.vs)}))}function f(e,t){r.forEach(t,(function(t){r.forEach(t,(function(t,n){e.node(t).order=n}))}))}e.exports=function(e){var t=u.maxRank(e),n=h(e,r.range(1,t+1),"inEdges"),a=h(e,r.range(t-1,-1,-1),"outEdges"),s=i(e);f(e,s);for(var c,l=Number.POSITIVE_INFINITY,p=0,m=0;m<4;++p,++m){d(p%2?n:a,p%4>=2),s=u.buildLayerMatrix(e);var g=o(e,s);g<l&&(m=0,c=r.cloneDeep(s),l=g)}f(e,c)}},Kq0i:function(e,t,n){var r=n("RF+X");e.exports=function(e,t,n){var i=e.x,o=e.y,a=[],s=Number.POSITIVE_INFINITY,c=Number.POSITIVE_INFINITY;t.forEach((function(e){s=Math.min(s,e.x),c=Math.min(c,e.y)}));for(var l=i-e.width/2-s,u=o-e.height/2-c,h=0;h<t.length;h++){var d=t[h],f=t[h<t.length-1?h+1:0],p=r(e,n,{x:l+d.x,y:u+d.y},{x:l+f.x,y:u+f.y});p&&a.push(p)}if(!a.length)return console.log("NO INTERSECTION FOUND, RETURN NODE CENTER",e),e;a.length>1&&a.sort((function(e,t){var r=e.x-n.x,i=e.y-n.y,o=Math.sqrt(r*r+i*i),a=t.x-n.x,s=t.y-n.y,c=Math.sqrt(a*a+s*s);return o<c?-1:o===c?0:1}));return a[0]}},KwMD:function(e,t){e.exports=function(e,t,n,r){for(var i=e.length,o=n+(r?1:-1);r?o--:++o<i;)if(t(e[o],o,e))return o;return-1}},Kz5y:function(e,t,n){var r=n("WFqU"),i="object"==typeof self&&self&&self.Object===Object&&self,o=r||i||Function("return this")();e.exports=o},L24B:function(e,t,n){e.exports=n("BPfq")},L8xA:function(e,t){e.exports=function(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n}},LGYb:function(e,t,n){var r=n("1hJj"),i=n("jbM+"),o=n("Xt/L"),a=n("xYSL"),s=n("dQpi"),c=n("rEGp");e.exports=function(e,t,n){var l=-1,u=i,h=e.length,d=!0,f=[],p=f;if(n)d=!1,u=o;else if(h>=200){var m=t?null:s(e);if(m)return c(m);d=!1,u=a,p=new r}else p=t?[]:f;e:for(;++l<h;){var g=e[l],v=t?t(g):g;if(g=n||0!==g?g:0,d&&v==v){for(var y=p.length;y--;)if(p[y]===v)continue e;t&&p.push(v),f.push(g)}else u(p,v,n)||(p!==f&&p.push(v),f.push(g))}return f}},LXxW:function(e,t){e.exports=function(e,t){for(var n=-1,r=null==e?0:e.length,i=0,o=[];++n<r;){var a=e[n];t(a,n,e)&&(o[i++]=a)}return o}},LboF:function(e,t,n){"use strict";var r,i=function(){return void 0===r&&(r=Boolean(window&&document&&document.all&&!window.atob)),r},o=function(){var e={};return function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(e){n=null}e[t]=n}return e[t]}}(),a=[];function s(e){for(var t=-1,n=0;n<a.length;n++)if(a[n].identifier===e){t=n;break}return t}function c(e,t){for(var n={},r=[],i=0;i<e.length;i++){var o=e[i],c=t.base?o[0]+t.base:o[0],l=n[c]||0,u="".concat(c," ").concat(l);n[c]=l+1;var h=s(u),d={css:o[1],media:o[2],sourceMap:o[3]};-1!==h?(a[h].references++,a[h].updater(d)):a.push({identifier:u,updater:g(d,t),references:1}),r.push(u)}return r}function l(e){var t=document.createElement("style"),r=e.attributes||{};if(void 0===r.nonce){var i=n.nc;i&&(r.nonce=i)}if(Object.keys(r).forEach((function(e){t.setAttribute(e,r[e])})),"function"==typeof e.insert)e.insert(t);else{var a=o(e.insert||"head");if(!a)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");a.appendChild(t)}return t}var u,h=(u=[],function(e,t){return u[e]=t,u.filter(Boolean).join("\n")});function d(e,t,n,r){var i=n?"":r.media?"@media ".concat(r.media," {").concat(r.css,"}"):r.css;if(e.styleSheet)e.styleSheet.cssText=h(t,i);else{var o=document.createTextNode(i),a=e.childNodes;a[t]&&e.removeChild(a[t]),a.length?e.insertBefore(o,a[t]):e.appendChild(o)}}function f(e,t,n){var r=n.css,i=n.media,o=n.sourceMap;if(i?e.setAttribute("media",i):e.removeAttribute("media"),o&&"undefined"!=typeof btoa&&(r+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(o))))," */")),e.styleSheet)e.styleSheet.cssText=r;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(r))}}var p=null,m=0;function g(e,t){var n,r,i;if(t.singleton){var o=m++;n=p||(p=l(t)),r=d.bind(null,n,o,!1),i=d.bind(null,n,o,!0)}else n=l(t),r=f.bind(null,n,t),i=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e)}(n)};return r(e),function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;r(e=t)}else i()}}e.exports=function(e,t){(t=t||{}).singleton||"boolean"==typeof t.singleton||(t.singleton=i());var n=c(e=e||[],t);return function(e){if(e=e||[],"[object Array]"===Object.prototype.toString.call(e)){for(var r=0;r<n.length;r++){var i=s(n[r]);a[i].references--}for(var o=c(e,t),l=0;l<n.length;l++){var u=s(n[l]);0===a[u].references&&(a[u].updater(),a.splice(u,1))}n=o}}}},LcsW:function(e,t,n){var r=n("kekF")(Object.getPrototypeOf,Object);e.exports=r},LsHQ:function(e,t,n){var r=n("EA7m"),i=n("mv/X");e.exports=function(e){return r((function(t,n){var r=-1,o=n.length,a=o>1?n[o-1]:void 0,s=o>2?n[2]:void 0;for(a=e.length>3&&"function"==typeof a?(o--,a):void 0,s&&i(n[0],n[1],s)&&(a=o<3?void 0:a,o=1),t=Object(t);++r<o;){var c=n[r];c&&e(t,c,r,a)}return t}))}},LvDl:function(e,t,n){(function(e,r){var i;
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */(function(){var o="Expected a function",a="__lodash_placeholder__",s=[["ary",128],["bind",1],["bindKey",2],["curry",8],["curryRight",16],["flip",512],["partial",32],["partialRight",64],["rearg",256]],c="[object Arguments]",l="[object Array]",u="[object Boolean]",h="[object Date]",d="[object Error]",f="[object Function]",p="[object GeneratorFunction]",m="[object Map]",g="[object Number]",v="[object Object]",y="[object RegExp]",b="[object Set]",w="[object String]",x="[object Symbol]",_="[object WeakMap]",E="[object ArrayBuffer]",S="[object DataView]",C="[object Float32Array]",A="[object Float64Array]",T="[object Int8Array]",M="[object Int16Array]",O="[object Int32Array]",k="[object Uint8Array]",R="[object Uint16Array]",P="[object Uint32Array]",L=/\b__p \+= '';/g,F=/\b(__p \+=) '' \+/g,j=/(__e\(.*?\)|\b__t\)) \+\n'';/g,D=/&(?:amp|lt|gt|quot|#39);/g,N=/[&<>"']/g,I=RegExp(D.source),B=RegExp(N.source),z=/<%-([\s\S]+?)%>/g,U=/<%([\s\S]+?)%>/g,H=/<%=([\s\S]+?)%>/g,V=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,$=/^\w*$/,W=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,G=/[\\^$.*+?()[\]{}|]/g,q=RegExp(G.source),Y=/^\s+/,X=/\s/,K=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,Z=/\{\n\/\* \[wrapped with (.+)\] \*/,J=/,? & /,Q=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,ee=/[()=,{}\[\]\/\s]/,te=/\\(\\)?/g,ne=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,re=/\w*$/,ie=/^[-+]0x[0-9a-f]+$/i,oe=/^0b[01]+$/i,ae=/^\[object .+?Constructor\]$/,se=/^0o[0-7]+$/i,ce=/^(?:0|[1-9]\d*)$/,le=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,ue=/($^)/,he=/['\n\r\u2028\u2029\\]/g,de="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",fe="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",pe="[\\ud800-\\udfff]",me="["+fe+"]",ge="["+de+"]",ve="\\d+",ye="[\\u2700-\\u27bf]",be="[a-z\\xdf-\\xf6\\xf8-\\xff]",we="[^\\ud800-\\udfff"+fe+ve+"\\u2700-\\u27bfa-z\\xdf-\\xf6\\xf8-\\xffA-Z\\xc0-\\xd6\\xd8-\\xde]",xe="\\ud83c[\\udffb-\\udfff]",_e="[^\\ud800-\\udfff]",Ee="(?:\\ud83c[\\udde6-\\uddff]){2}",Se="[\\ud800-\\udbff][\\udc00-\\udfff]",Ce="[A-Z\\xc0-\\xd6\\xd8-\\xde]",Ae="(?:"+be+"|"+we+")",Te="(?:"+Ce+"|"+we+")",Me="(?:"+ge+"|"+xe+")"+"?",Oe="[\\ufe0e\\ufe0f]?"+Me+("(?:\\u200d(?:"+[_e,Ee,Se].join("|")+")[\\ufe0e\\ufe0f]?"+Me+")*"),ke="(?:"+[ye,Ee,Se].join("|")+")"+Oe,Re="(?:"+[_e+ge+"?",ge,Ee,Se,pe].join("|")+")",Pe=RegExp("['’]","g"),Le=RegExp(ge,"g"),Fe=RegExp(xe+"(?="+xe+")|"+Re+Oe,"g"),je=RegExp([Ce+"?"+be+"+(?:['’](?:d|ll|m|re|s|t|ve))?(?="+[me,Ce,"$"].join("|")+")",Te+"+(?:['’](?:D|LL|M|RE|S|T|VE))?(?="+[me,Ce+Ae,"$"].join("|")+")",Ce+"?"+Ae+"+(?:['’](?:d|ll|m|re|s|t|ve))?",Ce+"+(?:['’](?:D|LL|M|RE|S|T|VE))?","\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",ve,ke].join("|"),"g"),De=RegExp("[\\u200d\\ud800-\\udfff"+de+"\\ufe0e\\ufe0f]"),Ne=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,Ie=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],Be=-1,ze={};ze[C]=ze[A]=ze[T]=ze[M]=ze[O]=ze[k]=ze["[object Uint8ClampedArray]"]=ze[R]=ze[P]=!0,ze[c]=ze[l]=ze[E]=ze[u]=ze[S]=ze[h]=ze[d]=ze[f]=ze[m]=ze[g]=ze[v]=ze[y]=ze[b]=ze[w]=ze[_]=!1;var Ue={};Ue[c]=Ue[l]=Ue[E]=Ue[S]=Ue[u]=Ue[h]=Ue[C]=Ue[A]=Ue[T]=Ue[M]=Ue[O]=Ue[m]=Ue[g]=Ue[v]=Ue[y]=Ue[b]=Ue[w]=Ue[x]=Ue[k]=Ue["[object Uint8ClampedArray]"]=Ue[R]=Ue[P]=!0,Ue[d]=Ue[f]=Ue[_]=!1;var He={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},Ve=parseFloat,$e=parseInt,We="object"==typeof e&&e&&e.Object===Object&&e,Ge="object"==typeof self&&self&&self.Object===Object&&self,qe=We||Ge||Function("return this")(),Ye=t&&!t.nodeType&&t,Xe=Ye&&"object"==typeof r&&r&&!r.nodeType&&r,Ke=Xe&&Xe.exports===Ye,Ze=Ke&&We.process,Je=function(){try{var e=Xe&&Xe.require&&Xe.require("util").types;return e||Ze&&Ze.binding&&Ze.binding("util")}catch(e){}}(),Qe=Je&&Je.isArrayBuffer,et=Je&&Je.isDate,tt=Je&&Je.isMap,nt=Je&&Je.isRegExp,rt=Je&&Je.isSet,it=Je&&Je.isTypedArray;function ot(e,t,n){switch(n.length){case 0:return e.call(t);case 1:return e.call(t,n[0]);case 2:return e.call(t,n[0],n[1]);case 3:return e.call(t,n[0],n[1],n[2])}return e.apply(t,n)}function at(e,t,n,r){for(var i=-1,o=null==e?0:e.length;++i<o;){var a=e[i];t(r,a,n(a),e)}return r}function st(e,t){for(var n=-1,r=null==e?0:e.length;++n<r&&!1!==t(e[n],n,e););return e}function ct(e,t){for(var n=null==e?0:e.length;n--&&!1!==t(e[n],n,e););return e}function lt(e,t){for(var n=-1,r=null==e?0:e.length;++n<r;)if(!t(e[n],n,e))return!1;return!0}function ut(e,t){for(var n=-1,r=null==e?0:e.length,i=0,o=[];++n<r;){var a=e[n];t(a,n,e)&&(o[i++]=a)}return o}function ht(e,t){return!!(null==e?0:e.length)&&xt(e,t,0)>-1}function dt(e,t,n){for(var r=-1,i=null==e?0:e.length;++r<i;)if(n(t,e[r]))return!0;return!1}function ft(e,t){for(var n=-1,r=null==e?0:e.length,i=Array(r);++n<r;)i[n]=t(e[n],n,e);return i}function pt(e,t){for(var n=-1,r=t.length,i=e.length;++n<r;)e[i+n]=t[n];return e}function mt(e,t,n,r){var i=-1,o=null==e?0:e.length;for(r&&o&&(n=e[++i]);++i<o;)n=t(n,e[i],i,e);return n}function gt(e,t,n,r){var i=null==e?0:e.length;for(r&&i&&(n=e[--i]);i--;)n=t(n,e[i],i,e);return n}function vt(e,t){for(var n=-1,r=null==e?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}var yt=Ct("length");function bt(e,t,n){var r;return n(e,(function(e,n,i){if(t(e,n,i))return r=n,!1})),r}function wt(e,t,n,r){for(var i=e.length,o=n+(r?1:-1);r?o--:++o<i;)if(t(e[o],o,e))return o;return-1}function xt(e,t,n){return t==t?function(e,t,n){var r=n-1,i=e.length;for(;++r<i;)if(e[r]===t)return r;return-1}(e,t,n):wt(e,Et,n)}function _t(e,t,n,r){for(var i=n-1,o=e.length;++i<o;)if(r(e[i],t))return i;return-1}function Et(e){return e!=e}function St(e,t){var n=null==e?0:e.length;return n?Mt(e,t)/n:NaN}function Ct(e){return function(t){return null==t?void 0:t[e]}}function At(e){return function(t){return null==e?void 0:e[t]}}function Tt(e,t,n,r,i){return i(e,(function(e,i,o){n=r?(r=!1,e):t(n,e,i,o)})),n}function Mt(e,t){for(var n,r=-1,i=e.length;++r<i;){var o=t(e[r]);void 0!==o&&(n=void 0===n?o:n+o)}return n}function Ot(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}function kt(e){return e?e.slice(0,Yt(e)+1).replace(Y,""):e}function Rt(e){return function(t){return e(t)}}function Pt(e,t){return ft(t,(function(t){return e[t]}))}function Lt(e,t){return e.has(t)}function Ft(e,t){for(var n=-1,r=e.length;++n<r&&xt(t,e[n],0)>-1;);return n}function jt(e,t){for(var n=e.length;n--&&xt(t,e[n],0)>-1;);return n}function Dt(e,t){for(var n=e.length,r=0;n--;)e[n]===t&&++r;return r}var Nt=At({"À":"A","Á":"A","Â":"A","Ã":"A","Ä":"A","Å":"A","à":"a","á":"a","â":"a","ã":"a","ä":"a","å":"a","Ç":"C","ç":"c","Ð":"D","ð":"d","È":"E","É":"E","Ê":"E","Ë":"E","è":"e","é":"e","ê":"e","ë":"e","Ì":"I","Í":"I","Î":"I","Ï":"I","ì":"i","í":"i","î":"i","ï":"i","Ñ":"N","ñ":"n","Ò":"O","Ó":"O","Ô":"O","Õ":"O","Ö":"O","Ø":"O","ò":"o","ó":"o","ô":"o","õ":"o","ö":"o","ø":"o","Ù":"U","Ú":"U","Û":"U","Ü":"U","ù":"u","ú":"u","û":"u","ü":"u","Ý":"Y","ý":"y","ÿ":"y","Æ":"Ae","æ":"ae","Þ":"Th","þ":"th","ß":"ss","Ā":"A","Ă":"A","Ą":"A","ā":"a","ă":"a","ą":"a","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","ć":"c","ĉ":"c","ċ":"c","č":"c","Ď":"D","Đ":"D","ď":"d","đ":"d","Ē":"E","Ĕ":"E","Ė":"E","Ę":"E","Ě":"E","ē":"e","ĕ":"e","ė":"e","ę":"e","ě":"e","Ĝ":"G","Ğ":"G","Ġ":"G","Ģ":"G","ĝ":"g","ğ":"g","ġ":"g","ģ":"g","Ĥ":"H","Ħ":"H","ĥ":"h","ħ":"h","Ĩ":"I","Ī":"I","Ĭ":"I","Į":"I","İ":"I","ĩ":"i","ī":"i","ĭ":"i","į":"i","ı":"i","Ĵ":"J","ĵ":"j","Ķ":"K","ķ":"k","ĸ":"k","Ĺ":"L","Ļ":"L","Ľ":"L","Ŀ":"L","Ł":"L","ĺ":"l","ļ":"l","ľ":"l","ŀ":"l","ł":"l","Ń":"N","Ņ":"N","Ň":"N","Ŋ":"N","ń":"n","ņ":"n","ň":"n","ŋ":"n","Ō":"O","Ŏ":"O","Ő":"O","ō":"o","ŏ":"o","ő":"o","Ŕ":"R","Ŗ":"R","Ř":"R","ŕ":"r","ŗ":"r","ř":"r","Ś":"S","Ŝ":"S","Ş":"S","Š":"S","ś":"s","ŝ":"s","ş":"s","š":"s","Ţ":"T","Ť":"T","Ŧ":"T","ţ":"t","ť":"t","ŧ":"t","Ũ":"U","Ū":"U","Ŭ":"U","Ů":"U","Ű":"U","Ų":"U","ũ":"u","ū":"u","ŭ":"u","ů":"u","ű":"u","ų":"u","Ŵ":"W","ŵ":"w","Ŷ":"Y","ŷ":"y","Ÿ":"Y","Ź":"Z","Ż":"Z","Ž":"Z","ź":"z","ż":"z","ž":"z","Ĳ":"IJ","ĳ":"ij","Œ":"Oe","œ":"oe","ŉ":"'n","ſ":"s"}),It=At({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});function Bt(e){return"\\"+He[e]}function zt(e){return De.test(e)}function Ut(e){var t=-1,n=Array(e.size);return e.forEach((function(e,r){n[++t]=[r,e]})),n}function Ht(e,t){return function(n){return e(t(n))}}function Vt(e,t){for(var n=-1,r=e.length,i=0,o=[];++n<r;){var s=e[n];s!==t&&s!==a||(e[n]=a,o[i++]=n)}return o}function $t(e){var t=-1,n=Array(e.size);return e.forEach((function(e){n[++t]=e})),n}function Wt(e){var t=-1,n=Array(e.size);return e.forEach((function(e){n[++t]=[e,e]})),n}function Gt(e){return zt(e)?function(e){var t=Fe.lastIndex=0;for(;Fe.test(e);)++t;return t}(e):yt(e)}function qt(e){return zt(e)?function(e){return e.match(Fe)||[]}(e):function(e){return e.split("")}(e)}function Yt(e){for(var t=e.length;t--&&X.test(e.charAt(t)););return t}var Xt=At({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"});var Kt=function e(t){var n,r=(t=null==t?qe:Kt.defaults(qe.Object(),t,Kt.pick(qe,Ie))).Array,i=t.Date,X=t.Error,de=t.Function,fe=t.Math,pe=t.Object,me=t.RegExp,ge=t.String,ve=t.TypeError,ye=r.prototype,be=de.prototype,we=pe.prototype,xe=t["__core-js_shared__"],_e=be.toString,Ee=we.hasOwnProperty,Se=0,Ce=(n=/[^.]+$/.exec(xe&&xe.keys&&xe.keys.IE_PROTO||""))?"Symbol(src)_1."+n:"",Ae=we.toString,Te=_e.call(pe),Me=qe._,Oe=me("^"+_e.call(Ee).replace(G,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),ke=Ke?t.Buffer:void 0,Re=t.Symbol,Fe=t.Uint8Array,De=ke?ke.allocUnsafe:void 0,He=Ht(pe.getPrototypeOf,pe),We=pe.create,Ge=we.propertyIsEnumerable,Ye=ye.splice,Xe=Re?Re.isConcatSpreadable:void 0,Ze=Re?Re.iterator:void 0,Je=Re?Re.toStringTag:void 0,yt=function(){try{var e=eo(pe,"defineProperty");return e({},"",{}),e}catch(e){}}(),At=t.clearTimeout!==qe.clearTimeout&&t.clearTimeout,Zt=i&&i.now!==qe.Date.now&&i.now,Jt=t.setTimeout!==qe.setTimeout&&t.setTimeout,Qt=fe.ceil,en=fe.floor,tn=pe.getOwnPropertySymbols,nn=ke?ke.isBuffer:void 0,rn=t.isFinite,on=ye.join,an=Ht(pe.keys,pe),sn=fe.max,cn=fe.min,ln=i.now,un=t.parseInt,hn=fe.random,dn=ye.reverse,fn=eo(t,"DataView"),pn=eo(t,"Map"),mn=eo(t,"Promise"),gn=eo(t,"Set"),vn=eo(t,"WeakMap"),yn=eo(pe,"create"),bn=vn&&new vn,wn={},xn=Mo(fn),_n=Mo(pn),En=Mo(mn),Sn=Mo(gn),Cn=Mo(vn),An=Re?Re.prototype:void 0,Tn=An?An.valueOf:void 0,Mn=An?An.toString:void 0;function On(e){if(Wa(e)&&!Fa(e)&&!(e instanceof Ln)){if(e instanceof Pn)return e;if(Ee.call(e,"__wrapped__"))return Oo(e)}return new Pn(e)}var kn=function(){function e(){}return function(t){if(!$a(t))return{};if(We)return We(t);e.prototype=t;var n=new e;return e.prototype=void 0,n}}();function Rn(){}function Pn(e,t){this.__wrapped__=e,this.__actions__=[],this.__chain__=!!t,this.__index__=0,this.__values__=void 0}function Ln(e){this.__wrapped__=e,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=4294967295,this.__views__=[]}function Fn(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function jn(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function Dn(e){var t=-1,n=null==e?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}function Nn(e){var t=-1,n=null==e?0:e.length;for(this.__data__=new Dn;++t<n;)this.add(e[t])}function In(e){var t=this.__data__=new jn(e);this.size=t.size}function Bn(e,t){var n=Fa(e),r=!n&&La(e),i=!n&&!r&&Ia(e),o=!n&&!r&&!i&&Qa(e),a=n||r||i||o,s=a?Ot(e.length,ge):[],c=s.length;for(var l in e)!t&&!Ee.call(e,l)||a&&("length"==l||i&&("offset"==l||"parent"==l)||o&&("buffer"==l||"byteLength"==l||"byteOffset"==l)||so(l,c))||s.push(l);return s}function zn(e){var t=e.length;return t?e[Nr(0,t-1)]:void 0}function Un(e,t){return Co(yi(e),Kn(t,0,e.length))}function Hn(e){return Co(yi(e))}function Vn(e,t,n){(void 0!==n&&!ka(e[t],n)||void 0===n&&!(t in e))&&Yn(e,t,n)}function $n(e,t,n){var r=e[t];Ee.call(e,t)&&ka(r,n)&&(void 0!==n||t in e)||Yn(e,t,n)}function Wn(e,t){for(var n=e.length;n--;)if(ka(e[n][0],t))return n;return-1}function Gn(e,t,n,r){return tr(e,(function(e,i,o){t(r,e,n(e),o)})),r}function qn(e,t){return e&&bi(t,xs(t),e)}function Yn(e,t,n){"__proto__"==t&&yt?yt(e,t,{configurable:!0,enumerable:!0,value:n,writable:!0}):e[t]=n}function Xn(e,t){for(var n=-1,i=t.length,o=r(i),a=null==e;++n<i;)o[n]=a?void 0:gs(e,t[n]);return o}function Kn(e,t,n){return e==e&&(void 0!==n&&(e=e<=n?e:n),void 0!==t&&(e=e>=t?e:t)),e}function Zn(e,t,n,r,i,o){var a,s=1&t,l=2&t,d=4&t;if(n&&(a=i?n(e,r,i,o):n(e)),void 0!==a)return a;if(!$a(e))return e;var _=Fa(e);if(_){if(a=function(e){var t=e.length,n=new e.constructor(t);t&&"string"==typeof e[0]&&Ee.call(e,"index")&&(n.index=e.index,n.input=e.input);return n}(e),!s)return yi(e,a)}else{var L=ro(e),F=L==f||L==p;if(Ia(e))return di(e,s);if(L==v||L==c||F&&!i){if(a=l||F?{}:oo(e),!s)return l?function(e,t){return bi(e,no(e),t)}(e,function(e,t){return e&&bi(t,_s(t),e)}(a,e)):function(e,t){return bi(e,to(e),t)}(e,qn(a,e))}else{if(!Ue[L])return i?e:{};a=function(e,t,n){var r=e.constructor;switch(t){case E:return fi(e);case u:case h:return new r(+e);case S:return function(e,t){var n=t?fi(e.buffer):e.buffer;return new e.constructor(n,e.byteOffset,e.byteLength)}(e,n);case C:case A:case T:case M:case O:case k:case"[object Uint8ClampedArray]":case R:case P:return pi(e,n);case m:return new r;case g:case w:return new r(e);case y:return function(e){var t=new e.constructor(e.source,re.exec(e));return t.lastIndex=e.lastIndex,t}(e);case b:return new r;case x:return i=e,Tn?pe(Tn.call(i)):{}}var i}(e,L,s)}}o||(o=new In);var j=o.get(e);if(j)return j;o.set(e,a),Ka(e)?e.forEach((function(r){a.add(Zn(r,t,n,r,e,o))})):Ga(e)&&e.forEach((function(r,i){a.set(i,Zn(r,t,n,i,e,o))}));var D=_?void 0:(d?l?qi:Gi:l?_s:xs)(e);return st(D||e,(function(r,i){D&&(r=e[i=r]),$n(a,i,Zn(r,t,n,i,e,o))})),a}function Jn(e,t,n){var r=n.length;if(null==e)return!r;for(e=pe(e);r--;){var i=n[r],o=t[i],a=e[i];if(void 0===a&&!(i in e)||!o(a))return!1}return!0}function Qn(e,t,n){if("function"!=typeof e)throw new ve(o);return xo((function(){e.apply(void 0,n)}),t)}function er(e,t,n,r){var i=-1,o=ht,a=!0,s=e.length,c=[],l=t.length;if(!s)return c;n&&(t=ft(t,Rt(n))),r?(o=dt,a=!1):t.length>=200&&(o=Lt,a=!1,t=new Nn(t));e:for(;++i<s;){var u=e[i],h=null==n?u:n(u);if(u=r||0!==u?u:0,a&&h==h){for(var d=l;d--;)if(t[d]===h)continue e;c.push(u)}else o(t,h,r)||c.push(u)}return c}On.templateSettings={escape:z,evaluate:U,interpolate:H,variable:"",imports:{_:On}},On.prototype=Rn.prototype,On.prototype.constructor=On,Pn.prototype=kn(Rn.prototype),Pn.prototype.constructor=Pn,Ln.prototype=kn(Rn.prototype),Ln.prototype.constructor=Ln,Fn.prototype.clear=function(){this.__data__=yn?yn(null):{},this.size=0},Fn.prototype.delete=function(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t},Fn.prototype.get=function(e){var t=this.__data__;if(yn){var n=t[e];return"__lodash_hash_undefined__"===n?void 0:n}return Ee.call(t,e)?t[e]:void 0},Fn.prototype.has=function(e){var t=this.__data__;return yn?void 0!==t[e]:Ee.call(t,e)},Fn.prototype.set=function(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=yn&&void 0===t?"__lodash_hash_undefined__":t,this},jn.prototype.clear=function(){this.__data__=[],this.size=0},jn.prototype.delete=function(e){var t=this.__data__,n=Wn(t,e);return!(n<0)&&(n==t.length-1?t.pop():Ye.call(t,n,1),--this.size,!0)},jn.prototype.get=function(e){var t=this.__data__,n=Wn(t,e);return n<0?void 0:t[n][1]},jn.prototype.has=function(e){return Wn(this.__data__,e)>-1},jn.prototype.set=function(e,t){var n=this.__data__,r=Wn(n,e);return r<0?(++this.size,n.push([e,t])):n[r][1]=t,this},Dn.prototype.clear=function(){this.size=0,this.__data__={hash:new Fn,map:new(pn||jn),string:new Fn}},Dn.prototype.delete=function(e){var t=Ji(this,e).delete(e);return this.size-=t?1:0,t},Dn.prototype.get=function(e){return Ji(this,e).get(e)},Dn.prototype.has=function(e){return Ji(this,e).has(e)},Dn.prototype.set=function(e,t){var n=Ji(this,e),r=n.size;return n.set(e,t),this.size+=n.size==r?0:1,this},Nn.prototype.add=Nn.prototype.push=function(e){return this.__data__.set(e,"__lodash_hash_undefined__"),this},Nn.prototype.has=function(e){return this.__data__.has(e)},In.prototype.clear=function(){this.__data__=new jn,this.size=0},In.prototype.delete=function(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n},In.prototype.get=function(e){return this.__data__.get(e)},In.prototype.has=function(e){return this.__data__.has(e)},In.prototype.set=function(e,t){var n=this.__data__;if(n instanceof jn){var r=n.__data__;if(!pn||r.length<199)return r.push([e,t]),this.size=++n.size,this;n=this.__data__=new Dn(r)}return n.set(e,t),this.size=n.size,this};var tr=_i(lr),nr=_i(ur,!0);function rr(e,t){var n=!0;return tr(e,(function(e,r,i){return n=!!t(e,r,i)})),n}function ir(e,t,n){for(var r=-1,i=e.length;++r<i;){var o=e[r],a=t(o);if(null!=a&&(void 0===s?a==a&&!Ja(a):n(a,s)))var s=a,c=o}return c}function or(e,t){var n=[];return tr(e,(function(e,r,i){t(e,r,i)&&n.push(e)})),n}function ar(e,t,n,r,i){var o=-1,a=e.length;for(n||(n=ao),i||(i=[]);++o<a;){var s=e[o];t>0&&n(s)?t>1?ar(s,t-1,n,r,i):pt(i,s):r||(i[i.length]=s)}return i}var sr=Ei(),cr=Ei(!0);function lr(e,t){return e&&sr(e,t,xs)}function ur(e,t){return e&&cr(e,t,xs)}function hr(e,t){return ut(t,(function(t){return Ua(e[t])}))}function dr(e,t){for(var n=0,r=(t=ci(t,e)).length;null!=e&&n<r;)e=e[To(t[n++])];return n&&n==r?e:void 0}function fr(e,t,n){var r=t(e);return Fa(e)?r:pt(r,n(e))}function pr(e){return null==e?void 0===e?"[object Undefined]":"[object Null]":Je&&Je in pe(e)?function(e){var t=Ee.call(e,Je),n=e[Je];try{e[Je]=void 0;var r=!0}catch(e){}var i=Ae.call(e);r&&(t?e[Je]=n:delete e[Je]);return i}(e):function(e){return Ae.call(e)}(e)}function mr(e,t){return e>t}function gr(e,t){return null!=e&&Ee.call(e,t)}function vr(e,t){return null!=e&&t in pe(e)}function yr(e,t,n){for(var i=n?dt:ht,o=e[0].length,a=e.length,s=a,c=r(a),l=1/0,u=[];s--;){var h=e[s];s&&t&&(h=ft(h,Rt(t))),l=cn(h.length,l),c[s]=!n&&(t||o>=120&&h.length>=120)?new Nn(s&&h):void 0}h=e[0];var d=-1,f=c[0];e:for(;++d<o&&u.length<l;){var p=h[d],m=t?t(p):p;if(p=n||0!==p?p:0,!(f?Lt(f,m):i(u,m,n))){for(s=a;--s;){var g=c[s];if(!(g?Lt(g,m):i(e[s],m,n)))continue e}f&&f.push(m),u.push(p)}}return u}function br(e,t,n){var r=null==(e=vo(e,t=ci(t,e)))?e:e[To(zo(t))];return null==r?void 0:ot(r,e,n)}function wr(e){return Wa(e)&&pr(e)==c}function xr(e,t,n,r,i){return e===t||(null==e||null==t||!Wa(e)&&!Wa(t)?e!=e&&t!=t:function(e,t,n,r,i,o){var a=Fa(e),s=Fa(t),f=a?l:ro(e),p=s?l:ro(t),_=(f=f==c?v:f)==v,C=(p=p==c?v:p)==v,A=f==p;if(A&&Ia(e)){if(!Ia(t))return!1;a=!0,_=!1}if(A&&!_)return o||(o=new In),a||Qa(e)?$i(e,t,n,r,i,o):function(e,t,n,r,i,o,a){switch(n){case S:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case E:return!(e.byteLength!=t.byteLength||!o(new Fe(e),new Fe(t)));case u:case h:case g:return ka(+e,+t);case d:return e.name==t.name&&e.message==t.message;case y:case w:return e==t+"";case m:var s=Ut;case b:var c=1&r;if(s||(s=$t),e.size!=t.size&&!c)return!1;var l=a.get(e);if(l)return l==t;r|=2,a.set(e,t);var f=$i(s(e),s(t),r,i,o,a);return a.delete(e),f;case x:if(Tn)return Tn.call(e)==Tn.call(t)}return!1}(e,t,f,n,r,i,o);if(!(1&n)){var T=_&&Ee.call(e,"__wrapped__"),M=C&&Ee.call(t,"__wrapped__");if(T||M){var O=T?e.value():e,k=M?t.value():t;return o||(o=new In),i(O,k,n,r,o)}}if(!A)return!1;return o||(o=new In),function(e,t,n,r,i,o){var a=1&n,s=Gi(e),c=s.length,l=Gi(t).length;if(c!=l&&!a)return!1;var u=c;for(;u--;){var h=s[u];if(!(a?h in t:Ee.call(t,h)))return!1}var d=o.get(e),f=o.get(t);if(d&&f)return d==t&&f==e;var p=!0;o.set(e,t),o.set(t,e);var m=a;for(;++u<c;){h=s[u];var g=e[h],v=t[h];if(r)var y=a?r(v,g,h,t,e,o):r(g,v,h,e,t,o);if(!(void 0===y?g===v||i(g,v,n,r,o):y)){p=!1;break}m||(m="constructor"==h)}if(p&&!m){var b=e.constructor,w=t.constructor;b==w||!("constructor"in e)||!("constructor"in t)||"function"==typeof b&&b instanceof b&&"function"==typeof w&&w instanceof w||(p=!1)}return o.delete(e),o.delete(t),p}(e,t,n,r,i,o)}(e,t,n,r,xr,i))}function _r(e,t,n,r){var i=n.length,o=i,a=!r;if(null==e)return!o;for(e=pe(e);i--;){var s=n[i];if(a&&s[2]?s[1]!==e[s[0]]:!(s[0]in e))return!1}for(;++i<o;){var c=(s=n[i])[0],l=e[c],u=s[1];if(a&&s[2]){if(void 0===l&&!(c in e))return!1}else{var h=new In;if(r)var d=r(l,u,c,e,t,h);if(!(void 0===d?xr(u,l,3,r,h):d))return!1}}return!0}function Er(e){return!(!$a(e)||(t=e,Ce&&Ce in t))&&(Ua(e)?Oe:ae).test(Mo(e));var t}function Sr(e){return"function"==typeof e?e:null==e?qs:"object"==typeof e?Fa(e)?kr(e[0],e[1]):Or(e):nc(e)}function Cr(e){if(!fo(e))return an(e);var t=[];for(var n in pe(e))Ee.call(e,n)&&"constructor"!=n&&t.push(n);return t}function Ar(e){if(!$a(e))return function(e){var t=[];if(null!=e)for(var n in pe(e))t.push(n);return t}(e);var t=fo(e),n=[];for(var r in e)("constructor"!=r||!t&&Ee.call(e,r))&&n.push(r);return n}function Tr(e,t){return e<t}function Mr(e,t){var n=-1,i=Da(e)?r(e.length):[];return tr(e,(function(e,r,o){i[++n]=t(e,r,o)})),i}function Or(e){var t=Qi(e);return 1==t.length&&t[0][2]?mo(t[0][0],t[0][1]):function(n){return n===e||_r(n,e,t)}}function kr(e,t){return lo(e)&&po(t)?mo(To(e),t):function(n){var r=gs(n,e);return void 0===r&&r===t?vs(n,e):xr(t,r,3)}}function Rr(e,t,n,r,i){e!==t&&sr(t,(function(o,a){if(i||(i=new In),$a(o))!function(e,t,n,r,i,o,a){var s=bo(e,n),c=bo(t,n),l=a.get(c);if(l)return void Vn(e,n,l);var u=o?o(s,c,n+"",e,t,a):void 0,h=void 0===u;if(h){var d=Fa(c),f=!d&&Ia(c),p=!d&&!f&&Qa(c);u=c,d||f||p?Fa(s)?u=s:Na(s)?u=yi(s):f?(h=!1,u=di(c,!0)):p?(h=!1,u=pi(c,!0)):u=[]:Ya(c)||La(c)?(u=s,La(s)?u=ss(s):$a(s)&&!Ua(s)||(u=oo(c))):h=!1}h&&(a.set(c,u),i(u,c,r,o,a),a.delete(c));Vn(e,n,u)}(e,t,a,n,Rr,r,i);else{var s=r?r(bo(e,a),o,a+"",e,t,i):void 0;void 0===s&&(s=o),Vn(e,a,s)}}),_s)}function Pr(e,t){var n=e.length;if(n)return so(t+=t<0?n:0,n)?e[t]:void 0}function Lr(e,t,n){t=t.length?ft(t,(function(e){return Fa(e)?function(t){return dr(t,1===e.length?e[0]:e)}:e})):[qs];var r=-1;return t=ft(t,Rt(Zi())),function(e,t){var n=e.length;for(e.sort(t);n--;)e[n]=e[n].value;return e}(Mr(e,(function(e,n,i){return{criteria:ft(t,(function(t){return t(e)})),index:++r,value:e}})),(function(e,t){return function(e,t,n){var r=-1,i=e.criteria,o=t.criteria,a=i.length,s=n.length;for(;++r<a;){var c=mi(i[r],o[r]);if(c){if(r>=s)return c;var l=n[r];return c*("desc"==l?-1:1)}}return e.index-t.index}(e,t,n)}))}function Fr(e,t,n){for(var r=-1,i=t.length,o={};++r<i;){var a=t[r],s=dr(e,a);n(s,a)&&Hr(o,ci(a,e),s)}return o}function jr(e,t,n,r){var i=r?_t:xt,o=-1,a=t.length,s=e;for(e===t&&(t=yi(t)),n&&(s=ft(e,Rt(n)));++o<a;)for(var c=0,l=t[o],u=n?n(l):l;(c=i(s,u,c,r))>-1;)s!==e&&Ye.call(s,c,1),Ye.call(e,c,1);return e}function Dr(e,t){for(var n=e?t.length:0,r=n-1;n--;){var i=t[n];if(n==r||i!==o){var o=i;so(i)?Ye.call(e,i,1):ei(e,i)}}return e}function Nr(e,t){return e+en(hn()*(t-e+1))}function Ir(e,t){var n="";if(!e||t<1||t>9007199254740991)return n;do{t%2&&(n+=e),(t=en(t/2))&&(e+=e)}while(t);return n}function Br(e,t){return _o(go(e,t,qs),e+"")}function zr(e){return zn(ks(e))}function Ur(e,t){var n=ks(e);return Co(n,Kn(t,0,n.length))}function Hr(e,t,n,r){if(!$a(e))return e;for(var i=-1,o=(t=ci(t,e)).length,a=o-1,s=e;null!=s&&++i<o;){var c=To(t[i]),l=n;if("__proto__"===c||"constructor"===c||"prototype"===c)return e;if(i!=a){var u=s[c];void 0===(l=r?r(u,c,s):void 0)&&(l=$a(u)?u:so(t[i+1])?[]:{})}$n(s,c,l),s=s[c]}return e}var Vr=bn?function(e,t){return bn.set(e,t),e}:qs,$r=yt?function(e,t){return yt(e,"toString",{configurable:!0,enumerable:!1,value:$s(t),writable:!0})}:qs;function Wr(e){return Co(ks(e))}function Gr(e,t,n){var i=-1,o=e.length;t<0&&(t=-t>o?0:o+t),(n=n>o?o:n)<0&&(n+=o),o=t>n?0:n-t>>>0,t>>>=0;for(var a=r(o);++i<o;)a[i]=e[i+t];return a}function qr(e,t){var n;return tr(e,(function(e,r,i){return!(n=t(e,r,i))})),!!n}function Yr(e,t,n){var r=0,i=null==e?r:e.length;if("number"==typeof t&&t==t&&i<=2147483647){for(;r<i;){var o=r+i>>>1,a=e[o];null!==a&&!Ja(a)&&(n?a<=t:a<t)?r=o+1:i=o}return i}return Xr(e,t,qs,n)}function Xr(e,t,n,r){var i=0,o=null==e?0:e.length;if(0===o)return 0;for(var a=(t=n(t))!=t,s=null===t,c=Ja(t),l=void 0===t;i<o;){var u=en((i+o)/2),h=n(e[u]),d=void 0!==h,f=null===h,p=h==h,m=Ja(h);if(a)var g=r||p;else g=l?p&&(r||d):s?p&&d&&(r||!f):c?p&&d&&!f&&(r||!m):!f&&!m&&(r?h<=t:h<t);g?i=u+1:o=u}return cn(o,4294967294)}function Kr(e,t){for(var n=-1,r=e.length,i=0,o=[];++n<r;){var a=e[n],s=t?t(a):a;if(!n||!ka(s,c)){var c=s;o[i++]=0===a?0:a}}return o}function Zr(e){return"number"==typeof e?e:Ja(e)?NaN:+e}function Jr(e){if("string"==typeof e)return e;if(Fa(e))return ft(e,Jr)+"";if(Ja(e))return Mn?Mn.call(e):"";var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}function Qr(e,t,n){var r=-1,i=ht,o=e.length,a=!0,s=[],c=s;if(n)a=!1,i=dt;else if(o>=200){var l=t?null:Ii(e);if(l)return $t(l);a=!1,i=Lt,c=new Nn}else c=t?[]:s;e:for(;++r<o;){var u=e[r],h=t?t(u):u;if(u=n||0!==u?u:0,a&&h==h){for(var d=c.length;d--;)if(c[d]===h)continue e;t&&c.push(h),s.push(u)}else i(c,h,n)||(c!==s&&c.push(h),s.push(u))}return s}function ei(e,t){return null==(e=vo(e,t=ci(t,e)))||delete e[To(zo(t))]}function ti(e,t,n,r){return Hr(e,t,n(dr(e,t)),r)}function ni(e,t,n,r){for(var i=e.length,o=r?i:-1;(r?o--:++o<i)&&t(e[o],o,e););return n?Gr(e,r?0:o,r?o+1:i):Gr(e,r?o+1:0,r?i:o)}function ri(e,t){var n=e;return n instanceof Ln&&(n=n.value()),mt(t,(function(e,t){return t.func.apply(t.thisArg,pt([e],t.args))}),n)}function ii(e,t,n){var i=e.length;if(i<2)return i?Qr(e[0]):[];for(var o=-1,a=r(i);++o<i;)for(var s=e[o],c=-1;++c<i;)c!=o&&(a[o]=er(a[o]||s,e[c],t,n));return Qr(ar(a,1),t,n)}function oi(e,t,n){for(var r=-1,i=e.length,o=t.length,a={};++r<i;){var s=r<o?t[r]:void 0;n(a,e[r],s)}return a}function ai(e){return Na(e)?e:[]}function si(e){return"function"==typeof e?e:qs}function ci(e,t){return Fa(e)?e:lo(e,t)?[e]:Ao(cs(e))}var li=Br;function ui(e,t,n){var r=e.length;return n=void 0===n?r:n,!t&&n>=r?e:Gr(e,t,n)}var hi=At||function(e){return qe.clearTimeout(e)};function di(e,t){if(t)return e.slice();var n=e.length,r=De?De(n):new e.constructor(n);return e.copy(r),r}function fi(e){var t=new e.constructor(e.byteLength);return new Fe(t).set(new Fe(e)),t}function pi(e,t){var n=t?fi(e.buffer):e.buffer;return new e.constructor(n,e.byteOffset,e.length)}function mi(e,t){if(e!==t){var n=void 0!==e,r=null===e,i=e==e,o=Ja(e),a=void 0!==t,s=null===t,c=t==t,l=Ja(t);if(!s&&!l&&!o&&e>t||o&&a&&c&&!s&&!l||r&&a&&c||!n&&c||!i)return 1;if(!r&&!o&&!l&&e<t||l&&n&&i&&!r&&!o||s&&n&&i||!a&&i||!c)return-1}return 0}function gi(e,t,n,i){for(var o=-1,a=e.length,s=n.length,c=-1,l=t.length,u=sn(a-s,0),h=r(l+u),d=!i;++c<l;)h[c]=t[c];for(;++o<s;)(d||o<a)&&(h[n[o]]=e[o]);for(;u--;)h[c++]=e[o++];return h}function vi(e,t,n,i){for(var o=-1,a=e.length,s=-1,c=n.length,l=-1,u=t.length,h=sn(a-c,0),d=r(h+u),f=!i;++o<h;)d[o]=e[o];for(var p=o;++l<u;)d[p+l]=t[l];for(;++s<c;)(f||o<a)&&(d[p+n[s]]=e[o++]);return d}function yi(e,t){var n=-1,i=e.length;for(t||(t=r(i));++n<i;)t[n]=e[n];return t}function bi(e,t,n,r){var i=!n;n||(n={});for(var o=-1,a=t.length;++o<a;){var s=t[o],c=r?r(n[s],e[s],s,n,e):void 0;void 0===c&&(c=e[s]),i?Yn(n,s,c):$n(n,s,c)}return n}function wi(e,t){return function(n,r){var i=Fa(n)?at:Gn,o=t?t():{};return i(n,e,Zi(r,2),o)}}function xi(e){return Br((function(t,n){var r=-1,i=n.length,o=i>1?n[i-1]:void 0,a=i>2?n[2]:void 0;for(o=e.length>3&&"function"==typeof o?(i--,o):void 0,a&&co(n[0],n[1],a)&&(o=i<3?void 0:o,i=1),t=pe(t);++r<i;){var s=n[r];s&&e(t,s,r,o)}return t}))}function _i(e,t){return function(n,r){if(null==n)return n;if(!Da(n))return e(n,r);for(var i=n.length,o=t?i:-1,a=pe(n);(t?o--:++o<i)&&!1!==r(a[o],o,a););return n}}function Ei(e){return function(t,n,r){for(var i=-1,o=pe(t),a=r(t),s=a.length;s--;){var c=a[e?s:++i];if(!1===n(o[c],c,o))break}return t}}function Si(e){return function(t){var n=zt(t=cs(t))?qt(t):void 0,r=n?n[0]:t.charAt(0),i=n?ui(n,1).join(""):t.slice(1);return r[e]()+i}}function Ci(e){return function(t){return mt(Us(Ls(t).replace(Pe,"")),e,"")}}function Ai(e){return function(){var t=arguments;switch(t.length){case 0:return new e;case 1:return new e(t[0]);case 2:return new e(t[0],t[1]);case 3:return new e(t[0],t[1],t[2]);case 4:return new e(t[0],t[1],t[2],t[3]);case 5:return new e(t[0],t[1],t[2],t[3],t[4]);case 6:return new e(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new e(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}var n=kn(e.prototype),r=e.apply(n,t);return $a(r)?r:n}}function Ti(e){return function(t,n,r){var i=pe(t);if(!Da(t)){var o=Zi(n,3);t=xs(t),n=function(e){return o(i[e],e,i)}}var a=e(t,n,r);return a>-1?i[o?t[a]:a]:void 0}}function Mi(e){return Wi((function(t){var n=t.length,r=n,i=Pn.prototype.thru;for(e&&t.reverse();r--;){var a=t[r];if("function"!=typeof a)throw new ve(o);if(i&&!s&&"wrapper"==Xi(a))var s=new Pn([],!0)}for(r=s?r:n;++r<n;){var c=Xi(a=t[r]),l="wrapper"==c?Yi(a):void 0;s=l&&uo(l[0])&&424==l[1]&&!l[4].length&&1==l[9]?s[Xi(l[0])].apply(s,l[3]):1==a.length&&uo(a)?s[c]():s.thru(a)}return function(){var e=arguments,r=e[0];if(s&&1==e.length&&Fa(r))return s.plant(r).value();for(var i=0,o=n?t[i].apply(this,e):r;++i<n;)o=t[i].call(this,o);return o}}))}function Oi(e,t,n,i,o,a,s,c,l,u){var h=128&t,d=1&t,f=2&t,p=24&t,m=512&t,g=f?void 0:Ai(e);return function v(){for(var y=arguments.length,b=r(y),w=y;w--;)b[w]=arguments[w];if(p)var x=Ki(v),_=Dt(b,x);if(i&&(b=gi(b,i,o,p)),a&&(b=vi(b,a,s,p)),y-=_,p&&y<u){var E=Vt(b,x);return Di(e,t,Oi,v.placeholder,n,b,E,c,l,u-y)}var S=d?n:this,C=f?S[e]:e;return y=b.length,c?b=yo(b,c):m&&y>1&&b.reverse(),h&&l<y&&(b.length=l),this&&this!==qe&&this instanceof v&&(C=g||Ai(C)),C.apply(S,b)}}function ki(e,t){return function(n,r){return function(e,t,n,r){return lr(e,(function(e,i,o){t(r,n(e),i,o)})),r}(n,e,t(r),{})}}function Ri(e,t){return function(n,r){var i;if(void 0===n&&void 0===r)return t;if(void 0!==n&&(i=n),void 0!==r){if(void 0===i)return r;"string"==typeof n||"string"==typeof r?(n=Jr(n),r=Jr(r)):(n=Zr(n),r=Zr(r)),i=e(n,r)}return i}}function Pi(e){return Wi((function(t){return t=ft(t,Rt(Zi())),Br((function(n){var r=this;return e(t,(function(e){return ot(e,r,n)}))}))}))}function Li(e,t){var n=(t=void 0===t?" ":Jr(t)).length;if(n<2)return n?Ir(t,e):t;var r=Ir(t,Qt(e/Gt(t)));return zt(t)?ui(qt(r),0,e).join(""):r.slice(0,e)}function Fi(e){return function(t,n,i){return i&&"number"!=typeof i&&co(t,n,i)&&(n=i=void 0),t=rs(t),void 0===n?(n=t,t=0):n=rs(n),function(e,t,n,i){for(var o=-1,a=sn(Qt((t-e)/(n||1)),0),s=r(a);a--;)s[i?a:++o]=e,e+=n;return s}(t,n,i=void 0===i?t<n?1:-1:rs(i),e)}}function ji(e){return function(t,n){return"string"==typeof t&&"string"==typeof n||(t=as(t),n=as(n)),e(t,n)}}function Di(e,t,n,r,i,o,a,s,c,l){var u=8&t;t|=u?32:64,4&(t&=~(u?64:32))||(t&=-4);var h=[e,t,i,u?o:void 0,u?a:void 0,u?void 0:o,u?void 0:a,s,c,l],d=n.apply(void 0,h);return uo(e)&&wo(d,h),d.placeholder=r,Eo(d,e,t)}function Ni(e){var t=fe[e];return function(e,n){if(e=as(e),(n=null==n?0:cn(is(n),292))&&rn(e)){var r=(cs(e)+"e").split("e");return+((r=(cs(t(r[0]+"e"+(+r[1]+n)))+"e").split("e"))[0]+"e"+(+r[1]-n))}return t(e)}}var Ii=gn&&1/$t(new gn([,-0]))[1]==1/0?function(e){return new gn(e)}:Js;function Bi(e){return function(t){var n=ro(t);return n==m?Ut(t):n==b?Wt(t):function(e,t){return ft(t,(function(t){return[t,e[t]]}))}(t,e(t))}}function zi(e,t,n,i,s,c,l,u){var h=2&t;if(!h&&"function"!=typeof e)throw new ve(o);var d=i?i.length:0;if(d||(t&=-97,i=s=void 0),l=void 0===l?l:sn(is(l),0),u=void 0===u?u:is(u),d-=s?s.length:0,64&t){var f=i,p=s;i=s=void 0}var m=h?void 0:Yi(e),g=[e,t,n,i,s,f,p,c,l,u];if(m&&function(e,t){var n=e[1],r=t[1],i=n|r,o=i<131,s=128==r&&8==n||128==r&&256==n&&e[7].length<=t[8]||384==r&&t[7].length<=t[8]&&8==n;if(!o&&!s)return e;1&r&&(e[2]=t[2],i|=1&n?0:4);var c=t[3];if(c){var l=e[3];e[3]=l?gi(l,c,t[4]):c,e[4]=l?Vt(e[3],a):t[4]}(c=t[5])&&(l=e[5],e[5]=l?vi(l,c,t[6]):c,e[6]=l?Vt(e[5],a):t[6]);(c=t[7])&&(e[7]=c);128&r&&(e[8]=null==e[8]?t[8]:cn(e[8],t[8]));null==e[9]&&(e[9]=t[9]);e[0]=t[0],e[1]=i}(g,m),e=g[0],t=g[1],n=g[2],i=g[3],s=g[4],!(u=g[9]=void 0===g[9]?h?0:e.length:sn(g[9]-d,0))&&24&t&&(t&=-25),t&&1!=t)v=8==t||16==t?function(e,t,n){var i=Ai(e);return function o(){for(var a=arguments.length,s=r(a),c=a,l=Ki(o);c--;)s[c]=arguments[c];var u=a<3&&s[0]!==l&&s[a-1]!==l?[]:Vt(s,l);if((a-=u.length)<n)return Di(e,t,Oi,o.placeholder,void 0,s,u,void 0,void 0,n-a);var h=this&&this!==qe&&this instanceof o?i:e;return ot(h,this,s)}}(e,t,u):32!=t&&33!=t||s.length?Oi.apply(void 0,g):function(e,t,n,i){var o=1&t,a=Ai(e);return function t(){for(var s=-1,c=arguments.length,l=-1,u=i.length,h=r(u+c),d=this&&this!==qe&&this instanceof t?a:e;++l<u;)h[l]=i[l];for(;c--;)h[l++]=arguments[++s];return ot(d,o?n:this,h)}}(e,t,n,i);else var v=function(e,t,n){var r=1&t,i=Ai(e);return function t(){var o=this&&this!==qe&&this instanceof t?i:e;return o.apply(r?n:this,arguments)}}(e,t,n);return Eo((m?Vr:wo)(v,g),e,t)}function Ui(e,t,n,r){return void 0===e||ka(e,we[n])&&!Ee.call(r,n)?t:e}function Hi(e,t,n,r,i,o){return $a(e)&&$a(t)&&(o.set(t,e),Rr(e,t,void 0,Hi,o),o.delete(t)),e}function Vi(e){return Ya(e)?void 0:e}function $i(e,t,n,r,i,o){var a=1&n,s=e.length,c=t.length;if(s!=c&&!(a&&c>s))return!1;var l=o.get(e),u=o.get(t);if(l&&u)return l==t&&u==e;var h=-1,d=!0,f=2&n?new Nn:void 0;for(o.set(e,t),o.set(t,e);++h<s;){var p=e[h],m=t[h];if(r)var g=a?r(m,p,h,t,e,o):r(p,m,h,e,t,o);if(void 0!==g){if(g)continue;d=!1;break}if(f){if(!vt(t,(function(e,t){if(!Lt(f,t)&&(p===e||i(p,e,n,r,o)))return f.push(t)}))){d=!1;break}}else if(p!==m&&!i(p,m,n,r,o)){d=!1;break}}return o.delete(e),o.delete(t),d}function Wi(e){return _o(go(e,void 0,jo),e+"")}function Gi(e){return fr(e,xs,to)}function qi(e){return fr(e,_s,no)}var Yi=bn?function(e){return bn.get(e)}:Js;function Xi(e){for(var t=e.name+"",n=wn[t],r=Ee.call(wn,t)?n.length:0;r--;){var i=n[r],o=i.func;if(null==o||o==e)return i.name}return t}function Ki(e){return(Ee.call(On,"placeholder")?On:e).placeholder}function Zi(){var e=On.iteratee||Ys;return e=e===Ys?Sr:e,arguments.length?e(arguments[0],arguments[1]):e}function Ji(e,t){var n,r,i=e.__data__;return("string"==(r=typeof(n=t))||"number"==r||"symbol"==r||"boolean"==r?"__proto__"!==n:null===n)?i["string"==typeof t?"string":"hash"]:i.map}function Qi(e){for(var t=xs(e),n=t.length;n--;){var r=t[n],i=e[r];t[n]=[r,i,po(i)]}return t}function eo(e,t){var n=function(e,t){return null==e?void 0:e[t]}(e,t);return Er(n)?n:void 0}var to=tn?function(e){return null==e?[]:(e=pe(e),ut(tn(e),(function(t){return Ge.call(e,t)})))}:oc,no=tn?function(e){for(var t=[];e;)pt(t,to(e)),e=He(e);return t}:oc,ro=pr;function io(e,t,n){for(var r=-1,i=(t=ci(t,e)).length,o=!1;++r<i;){var a=To(t[r]);if(!(o=null!=e&&n(e,a)))break;e=e[a]}return o||++r!=i?o:!!(i=null==e?0:e.length)&&Va(i)&&so(a,i)&&(Fa(e)||La(e))}function oo(e){return"function"!=typeof e.constructor||fo(e)?{}:kn(He(e))}function ao(e){return Fa(e)||La(e)||!!(Xe&&e&&e[Xe])}function so(e,t){var n=typeof e;return!!(t=null==t?9007199254740991:t)&&("number"==n||"symbol"!=n&&ce.test(e))&&e>-1&&e%1==0&&e<t}function co(e,t,n){if(!$a(n))return!1;var r=typeof t;return!!("number"==r?Da(n)&&so(t,n.length):"string"==r&&t in n)&&ka(n[t],e)}function lo(e,t){if(Fa(e))return!1;var n=typeof e;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=e&&!Ja(e))||($.test(e)||!V.test(e)||null!=t&&e in pe(t))}function uo(e){var t=Xi(e),n=On[t];if("function"!=typeof n||!(t in Ln.prototype))return!1;if(e===n)return!0;var r=Yi(n);return!!r&&e===r[0]}(fn&&ro(new fn(new ArrayBuffer(1)))!=S||pn&&ro(new pn)!=m||mn&&"[object Promise]"!=ro(mn.resolve())||gn&&ro(new gn)!=b||vn&&ro(new vn)!=_)&&(ro=function(e){var t=pr(e),n=t==v?e.constructor:void 0,r=n?Mo(n):"";if(r)switch(r){case xn:return S;case _n:return m;case En:return"[object Promise]";case Sn:return b;case Cn:return _}return t});var ho=xe?Ua:ac;function fo(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||we)}function po(e){return e==e&&!$a(e)}function mo(e,t){return function(n){return null!=n&&(n[e]===t&&(void 0!==t||e in pe(n)))}}function go(e,t,n){return t=sn(void 0===t?e.length-1:t,0),function(){for(var i=arguments,o=-1,a=sn(i.length-t,0),s=r(a);++o<a;)s[o]=i[t+o];o=-1;for(var c=r(t+1);++o<t;)c[o]=i[o];return c[t]=n(s),ot(e,this,c)}}function vo(e,t){return t.length<2?e:dr(e,Gr(t,0,-1))}function yo(e,t){for(var n=e.length,r=cn(t.length,n),i=yi(e);r--;){var o=t[r];e[r]=so(o,n)?i[o]:void 0}return e}function bo(e,t){if(("constructor"!==t||"function"!=typeof e[t])&&"__proto__"!=t)return e[t]}var wo=So(Vr),xo=Jt||function(e,t){return qe.setTimeout(e,t)},_o=So($r);function Eo(e,t,n){var r=t+"";return _o(e,function(e,t){var n=t.length;if(!n)return e;var r=n-1;return t[r]=(n>1?"& ":"")+t[r],t=t.join(n>2?", ":" "),e.replace(K,"{\n/* [wrapped with "+t+"] */\n")}(r,function(e,t){return st(s,(function(n){var r="_."+n[0];t&n[1]&&!ht(e,r)&&e.push(r)})),e.sort()}(function(e){var t=e.match(Z);return t?t[1].split(J):[]}(r),n)))}function So(e){var t=0,n=0;return function(){var r=ln(),i=16-(r-n);if(n=r,i>0){if(++t>=800)return arguments[0]}else t=0;return e.apply(void 0,arguments)}}function Co(e,t){var n=-1,r=e.length,i=r-1;for(t=void 0===t?r:t;++n<t;){var o=Nr(n,i),a=e[o];e[o]=e[n],e[n]=a}return e.length=t,e}var Ao=function(e){var t=Sa(e,(function(e){return 500===n.size&&n.clear(),e})),n=t.cache;return t}((function(e){var t=[];return 46===e.charCodeAt(0)&&t.push(""),e.replace(W,(function(e,n,r,i){t.push(r?i.replace(te,"$1"):n||e)})),t}));function To(e){if("string"==typeof e||Ja(e))return e;var t=e+"";return"0"==t&&1/e==-1/0?"-0":t}function Mo(e){if(null!=e){try{return _e.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function Oo(e){if(e instanceof Ln)return e.clone();var t=new Pn(e.__wrapped__,e.__chain__);return t.__actions__=yi(e.__actions__),t.__index__=e.__index__,t.__values__=e.__values__,t}var ko=Br((function(e,t){return Na(e)?er(e,ar(t,1,Na,!0)):[]})),Ro=Br((function(e,t){var n=zo(t);return Na(n)&&(n=void 0),Na(e)?er(e,ar(t,1,Na,!0),Zi(n,2)):[]})),Po=Br((function(e,t){var n=zo(t);return Na(n)&&(n=void 0),Na(e)?er(e,ar(t,1,Na,!0),void 0,n):[]}));function Lo(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var i=null==n?0:is(n);return i<0&&(i=sn(r+i,0)),wt(e,Zi(t,3),i)}function Fo(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var i=r-1;return void 0!==n&&(i=is(n),i=n<0?sn(r+i,0):cn(i,r-1)),wt(e,Zi(t,3),i,!0)}function jo(e){return(null==e?0:e.length)?ar(e,1):[]}function Do(e){return e&&e.length?e[0]:void 0}var No=Br((function(e){var t=ft(e,ai);return t.length&&t[0]===e[0]?yr(t):[]})),Io=Br((function(e){var t=zo(e),n=ft(e,ai);return t===zo(n)?t=void 0:n.pop(),n.length&&n[0]===e[0]?yr(n,Zi(t,2)):[]})),Bo=Br((function(e){var t=zo(e),n=ft(e,ai);return(t="function"==typeof t?t:void 0)&&n.pop(),n.length&&n[0]===e[0]?yr(n,void 0,t):[]}));function zo(e){var t=null==e?0:e.length;return t?e[t-1]:void 0}var Uo=Br(Ho);function Ho(e,t){return e&&e.length&&t&&t.length?jr(e,t):e}var Vo=Wi((function(e,t){var n=null==e?0:e.length,r=Xn(e,t);return Dr(e,ft(t,(function(e){return so(e,n)?+e:e})).sort(mi)),r}));function $o(e){return null==e?e:dn.call(e)}var Wo=Br((function(e){return Qr(ar(e,1,Na,!0))})),Go=Br((function(e){var t=zo(e);return Na(t)&&(t=void 0),Qr(ar(e,1,Na,!0),Zi(t,2))})),qo=Br((function(e){var t=zo(e);return t="function"==typeof t?t:void 0,Qr(ar(e,1,Na,!0),void 0,t)}));function Yo(e){if(!e||!e.length)return[];var t=0;return e=ut(e,(function(e){if(Na(e))return t=sn(e.length,t),!0})),Ot(t,(function(t){return ft(e,Ct(t))}))}function Xo(e,t){if(!e||!e.length)return[];var n=Yo(e);return null==t?n:ft(n,(function(e){return ot(t,void 0,e)}))}var Ko=Br((function(e,t){return Na(e)?er(e,t):[]})),Zo=Br((function(e){return ii(ut(e,Na))})),Jo=Br((function(e){var t=zo(e);return Na(t)&&(t=void 0),ii(ut(e,Na),Zi(t,2))})),Qo=Br((function(e){var t=zo(e);return t="function"==typeof t?t:void 0,ii(ut(e,Na),void 0,t)})),ea=Br(Yo);var ta=Br((function(e){var t=e.length,n=t>1?e[t-1]:void 0;return n="function"==typeof n?(e.pop(),n):void 0,Xo(e,n)}));function na(e){var t=On(e);return t.__chain__=!0,t}function ra(e,t){return t(e)}var ia=Wi((function(e){var t=e.length,n=t?e[0]:0,r=this.__wrapped__,i=function(t){return Xn(t,e)};return!(t>1||this.__actions__.length)&&r instanceof Ln&&so(n)?((r=r.slice(n,+n+(t?1:0))).__actions__.push({func:ra,args:[i],thisArg:void 0}),new Pn(r,this.__chain__).thru((function(e){return t&&!e.length&&e.push(void 0),e}))):this.thru(i)}));var oa=wi((function(e,t,n){Ee.call(e,n)?++e[n]:Yn(e,n,1)}));var aa=Ti(Lo),sa=Ti(Fo);function ca(e,t){return(Fa(e)?st:tr)(e,Zi(t,3))}function la(e,t){return(Fa(e)?ct:nr)(e,Zi(t,3))}var ua=wi((function(e,t,n){Ee.call(e,n)?e[n].push(t):Yn(e,n,[t])}));var ha=Br((function(e,t,n){var i=-1,o="function"==typeof t,a=Da(e)?r(e.length):[];return tr(e,(function(e){a[++i]=o?ot(t,e,n):br(e,t,n)})),a})),da=wi((function(e,t,n){Yn(e,n,t)}));function fa(e,t){return(Fa(e)?ft:Mr)(e,Zi(t,3))}var pa=wi((function(e,t,n){e[n?0:1].push(t)}),(function(){return[[],[]]}));var ma=Br((function(e,t){if(null==e)return[];var n=t.length;return n>1&&co(e,t[0],t[1])?t=[]:n>2&&co(t[0],t[1],t[2])&&(t=[t[0]]),Lr(e,ar(t,1),[])})),ga=Zt||function(){return qe.Date.now()};function va(e,t,n){return t=n?void 0:t,zi(e,128,void 0,void 0,void 0,void 0,t=e&&null==t?e.length:t)}function ya(e,t){var n;if("function"!=typeof t)throw new ve(o);return e=is(e),function(){return--e>0&&(n=t.apply(this,arguments)),e<=1&&(t=void 0),n}}var ba=Br((function(e,t,n){var r=1;if(n.length){var i=Vt(n,Ki(ba));r|=32}return zi(e,r,t,n,i)})),wa=Br((function(e,t,n){var r=3;if(n.length){var i=Vt(n,Ki(wa));r|=32}return zi(t,r,e,n,i)}));function xa(e,t,n){var r,i,a,s,c,l,u=0,h=!1,d=!1,f=!0;if("function"!=typeof e)throw new ve(o);function p(t){var n=r,o=i;return r=i=void 0,u=t,s=e.apply(o,n)}function m(e){return u=e,c=xo(v,t),h?p(e):s}function g(e){var n=e-l;return void 0===l||n>=t||n<0||d&&e-u>=a}function v(){var e=ga();if(g(e))return y(e);c=xo(v,function(e){var n=t-(e-l);return d?cn(n,a-(e-u)):n}(e))}function y(e){return c=void 0,f&&r?p(e):(r=i=void 0,s)}function b(){var e=ga(),n=g(e);if(r=arguments,i=this,l=e,n){if(void 0===c)return m(l);if(d)return hi(c),c=xo(v,t),p(l)}return void 0===c&&(c=xo(v,t)),s}return t=as(t)||0,$a(n)&&(h=!!n.leading,a=(d="maxWait"in n)?sn(as(n.maxWait)||0,t):a,f="trailing"in n?!!n.trailing:f),b.cancel=function(){void 0!==c&&hi(c),u=0,r=l=i=c=void 0},b.flush=function(){return void 0===c?s:y(ga())},b}var _a=Br((function(e,t){return Qn(e,1,t)})),Ea=Br((function(e,t,n){return Qn(e,as(t)||0,n)}));function Sa(e,t){if("function"!=typeof e||null!=t&&"function"!=typeof t)throw new ve(o);var n=function(){var r=arguments,i=t?t.apply(this,r):r[0],o=n.cache;if(o.has(i))return o.get(i);var a=e.apply(this,r);return n.cache=o.set(i,a)||o,a};return n.cache=new(Sa.Cache||Dn),n}function Ca(e){if("function"!=typeof e)throw new ve(o);return function(){var t=arguments;switch(t.length){case 0:return!e.call(this);case 1:return!e.call(this,t[0]);case 2:return!e.call(this,t[0],t[1]);case 3:return!e.call(this,t[0],t[1],t[2])}return!e.apply(this,t)}}Sa.Cache=Dn;var Aa=li((function(e,t){var n=(t=1==t.length&&Fa(t[0])?ft(t[0],Rt(Zi())):ft(ar(t,1),Rt(Zi()))).length;return Br((function(r){for(var i=-1,o=cn(r.length,n);++i<o;)r[i]=t[i].call(this,r[i]);return ot(e,this,r)}))})),Ta=Br((function(e,t){return zi(e,32,void 0,t,Vt(t,Ki(Ta)))})),Ma=Br((function(e,t){return zi(e,64,void 0,t,Vt(t,Ki(Ma)))})),Oa=Wi((function(e,t){return zi(e,256,void 0,void 0,void 0,t)}));function ka(e,t){return e===t||e!=e&&t!=t}var Ra=ji(mr),Pa=ji((function(e,t){return e>=t})),La=wr(function(){return arguments}())?wr:function(e){return Wa(e)&&Ee.call(e,"callee")&&!Ge.call(e,"callee")},Fa=r.isArray,ja=Qe?Rt(Qe):function(e){return Wa(e)&&pr(e)==E};function Da(e){return null!=e&&Va(e.length)&&!Ua(e)}function Na(e){return Wa(e)&&Da(e)}var Ia=nn||ac,Ba=et?Rt(et):function(e){return Wa(e)&&pr(e)==h};function za(e){if(!Wa(e))return!1;var t=pr(e);return t==d||"[object DOMException]"==t||"string"==typeof e.message&&"string"==typeof e.name&&!Ya(e)}function Ua(e){if(!$a(e))return!1;var t=pr(e);return t==f||t==p||"[object AsyncFunction]"==t||"[object Proxy]"==t}function Ha(e){return"number"==typeof e&&e==is(e)}function Va(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=9007199254740991}function $a(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)}function Wa(e){return null!=e&&"object"==typeof e}var Ga=tt?Rt(tt):function(e){return Wa(e)&&ro(e)==m};function qa(e){return"number"==typeof e||Wa(e)&&pr(e)==g}function Ya(e){if(!Wa(e)||pr(e)!=v)return!1;var t=He(e);if(null===t)return!0;var n=Ee.call(t,"constructor")&&t.constructor;return"function"==typeof n&&n instanceof n&&_e.call(n)==Te}var Xa=nt?Rt(nt):function(e){return Wa(e)&&pr(e)==y};var Ka=rt?Rt(rt):function(e){return Wa(e)&&ro(e)==b};function Za(e){return"string"==typeof e||!Fa(e)&&Wa(e)&&pr(e)==w}function Ja(e){return"symbol"==typeof e||Wa(e)&&pr(e)==x}var Qa=it?Rt(it):function(e){return Wa(e)&&Va(e.length)&&!!ze[pr(e)]};var es=ji(Tr),ts=ji((function(e,t){return e<=t}));function ns(e){if(!e)return[];if(Da(e))return Za(e)?qt(e):yi(e);if(Ze&&e[Ze])return function(e){for(var t,n=[];!(t=e.next()).done;)n.push(t.value);return n}(e[Ze]());var t=ro(e);return(t==m?Ut:t==b?$t:ks)(e)}function rs(e){return e?(e=as(e))===1/0||e===-1/0?17976931348623157e292*(e<0?-1:1):e==e?e:0:0===e?e:0}function is(e){var t=rs(e),n=t%1;return t==t?n?t-n:t:0}function os(e){return e?Kn(is(e),0,4294967295):0}function as(e){if("number"==typeof e)return e;if(Ja(e))return NaN;if($a(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=$a(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=kt(e);var n=oe.test(e);return n||se.test(e)?$e(e.slice(2),n?2:8):ie.test(e)?NaN:+e}function ss(e){return bi(e,_s(e))}function cs(e){return null==e?"":Jr(e)}var ls=xi((function(e,t){if(fo(t)||Da(t))bi(t,xs(t),e);else for(var n in t)Ee.call(t,n)&&$n(e,n,t[n])})),us=xi((function(e,t){bi(t,_s(t),e)})),hs=xi((function(e,t,n,r){bi(t,_s(t),e,r)})),ds=xi((function(e,t,n,r){bi(t,xs(t),e,r)})),fs=Wi(Xn);var ps=Br((function(e,t){e=pe(e);var n=-1,r=t.length,i=r>2?t[2]:void 0;for(i&&co(t[0],t[1],i)&&(r=1);++n<r;)for(var o=t[n],a=_s(o),s=-1,c=a.length;++s<c;){var l=a[s],u=e[l];(void 0===u||ka(u,we[l])&&!Ee.call(e,l))&&(e[l]=o[l])}return e})),ms=Br((function(e){return e.push(void 0,Hi),ot(Ss,void 0,e)}));function gs(e,t,n){var r=null==e?void 0:dr(e,t);return void 0===r?n:r}function vs(e,t){return null!=e&&io(e,t,vr)}var ys=ki((function(e,t,n){null!=t&&"function"!=typeof t.toString&&(t=Ae.call(t)),e[t]=n}),$s(qs)),bs=ki((function(e,t,n){null!=t&&"function"!=typeof t.toString&&(t=Ae.call(t)),Ee.call(e,t)?e[t].push(n):e[t]=[n]}),Zi),ws=Br(br);function xs(e){return Da(e)?Bn(e):Cr(e)}function _s(e){return Da(e)?Bn(e,!0):Ar(e)}var Es=xi((function(e,t,n){Rr(e,t,n)})),Ss=xi((function(e,t,n,r){Rr(e,t,n,r)})),Cs=Wi((function(e,t){var n={};if(null==e)return n;var r=!1;t=ft(t,(function(t){return t=ci(t,e),r||(r=t.length>1),t})),bi(e,qi(e),n),r&&(n=Zn(n,7,Vi));for(var i=t.length;i--;)ei(n,t[i]);return n}));var As=Wi((function(e,t){return null==e?{}:function(e,t){return Fr(e,t,(function(t,n){return vs(e,n)}))}(e,t)}));function Ts(e,t){if(null==e)return{};var n=ft(qi(e),(function(e){return[e]}));return t=Zi(t),Fr(e,n,(function(e,n){return t(e,n[0])}))}var Ms=Bi(xs),Os=Bi(_s);function ks(e){return null==e?[]:Pt(e,xs(e))}var Rs=Ci((function(e,t,n){return t=t.toLowerCase(),e+(n?Ps(t):t)}));function Ps(e){return zs(cs(e).toLowerCase())}function Ls(e){return(e=cs(e))&&e.replace(le,Nt).replace(Le,"")}var Fs=Ci((function(e,t,n){return e+(n?"-":"")+t.toLowerCase()})),js=Ci((function(e,t,n){return e+(n?" ":"")+t.toLowerCase()})),Ds=Si("toLowerCase");var Ns=Ci((function(e,t,n){return e+(n?"_":"")+t.toLowerCase()}));var Is=Ci((function(e,t,n){return e+(n?" ":"")+zs(t)}));var Bs=Ci((function(e,t,n){return e+(n?" ":"")+t.toUpperCase()})),zs=Si("toUpperCase");function Us(e,t,n){return e=cs(e),void 0===(t=n?void 0:t)?function(e){return Ne.test(e)}(e)?function(e){return e.match(je)||[]}(e):function(e){return e.match(Q)||[]}(e):e.match(t)||[]}var Hs=Br((function(e,t){try{return ot(e,void 0,t)}catch(e){return za(e)?e:new X(e)}})),Vs=Wi((function(e,t){return st(t,(function(t){t=To(t),Yn(e,t,ba(e[t],e))})),e}));function $s(e){return function(){return e}}var Ws=Mi(),Gs=Mi(!0);function qs(e){return e}function Ys(e){return Sr("function"==typeof e?e:Zn(e,1))}var Xs=Br((function(e,t){return function(n){return br(n,e,t)}})),Ks=Br((function(e,t){return function(n){return br(e,n,t)}}));function Zs(e,t,n){var r=xs(t),i=hr(t,r);null!=n||$a(t)&&(i.length||!r.length)||(n=t,t=e,e=this,i=hr(t,xs(t)));var o=!($a(n)&&"chain"in n&&!n.chain),a=Ua(e);return st(i,(function(n){var r=t[n];e[n]=r,a&&(e.prototype[n]=function(){var t=this.__chain__;if(o||t){var n=e(this.__wrapped__),i=n.__actions__=yi(this.__actions__);return i.push({func:r,args:arguments,thisArg:e}),n.__chain__=t,n}return r.apply(e,pt([this.value()],arguments))})})),e}function Js(){}var Qs=Pi(ft),ec=Pi(lt),tc=Pi(vt);function nc(e){return lo(e)?Ct(To(e)):function(e){return function(t){return dr(t,e)}}(e)}var rc=Fi(),ic=Fi(!0);function oc(){return[]}function ac(){return!1}var sc=Ri((function(e,t){return e+t}),0),cc=Ni("ceil"),lc=Ri((function(e,t){return e/t}),1),uc=Ni("floor");var hc,dc=Ri((function(e,t){return e*t}),1),fc=Ni("round"),pc=Ri((function(e,t){return e-t}),0);return On.after=function(e,t){if("function"!=typeof t)throw new ve(o);return e=is(e),function(){if(--e<1)return t.apply(this,arguments)}},On.ary=va,On.assign=ls,On.assignIn=us,On.assignInWith=hs,On.assignWith=ds,On.at=fs,On.before=ya,On.bind=ba,On.bindAll=Vs,On.bindKey=wa,On.castArray=function(){if(!arguments.length)return[];var e=arguments[0];return Fa(e)?e:[e]},On.chain=na,On.chunk=function(e,t,n){t=(n?co(e,t,n):void 0===t)?1:sn(is(t),0);var i=null==e?0:e.length;if(!i||t<1)return[];for(var o=0,a=0,s=r(Qt(i/t));o<i;)s[a++]=Gr(e,o,o+=t);return s},On.compact=function(e){for(var t=-1,n=null==e?0:e.length,r=0,i=[];++t<n;){var o=e[t];o&&(i[r++]=o)}return i},On.concat=function(){var e=arguments.length;if(!e)return[];for(var t=r(e-1),n=arguments[0],i=e;i--;)t[i-1]=arguments[i];return pt(Fa(n)?yi(n):[n],ar(t,1))},On.cond=function(e){var t=null==e?0:e.length,n=Zi();return e=t?ft(e,(function(e){if("function"!=typeof e[1])throw new ve(o);return[n(e[0]),e[1]]})):[],Br((function(n){for(var r=-1;++r<t;){var i=e[r];if(ot(i[0],this,n))return ot(i[1],this,n)}}))},On.conforms=function(e){return function(e){var t=xs(e);return function(n){return Jn(n,e,t)}}(Zn(e,1))},On.constant=$s,On.countBy=oa,On.create=function(e,t){var n=kn(e);return null==t?n:qn(n,t)},On.curry=function e(t,n,r){var i=zi(t,8,void 0,void 0,void 0,void 0,void 0,n=r?void 0:n);return i.placeholder=e.placeholder,i},On.curryRight=function e(t,n,r){var i=zi(t,16,void 0,void 0,void 0,void 0,void 0,n=r?void 0:n);return i.placeholder=e.placeholder,i},On.debounce=xa,On.defaults=ps,On.defaultsDeep=ms,On.defer=_a,On.delay=Ea,On.difference=ko,On.differenceBy=Ro,On.differenceWith=Po,On.drop=function(e,t,n){var r=null==e?0:e.length;return r?Gr(e,(t=n||void 0===t?1:is(t))<0?0:t,r):[]},On.dropRight=function(e,t,n){var r=null==e?0:e.length;return r?Gr(e,0,(t=r-(t=n||void 0===t?1:is(t)))<0?0:t):[]},On.dropRightWhile=function(e,t){return e&&e.length?ni(e,Zi(t,3),!0,!0):[]},On.dropWhile=function(e,t){return e&&e.length?ni(e,Zi(t,3),!0):[]},On.fill=function(e,t,n,r){var i=null==e?0:e.length;return i?(n&&"number"!=typeof n&&co(e,t,n)&&(n=0,r=i),function(e,t,n,r){var i=e.length;for((n=is(n))<0&&(n=-n>i?0:i+n),(r=void 0===r||r>i?i:is(r))<0&&(r+=i),r=n>r?0:os(r);n<r;)e[n++]=t;return e}(e,t,n,r)):[]},On.filter=function(e,t){return(Fa(e)?ut:or)(e,Zi(t,3))},On.flatMap=function(e,t){return ar(fa(e,t),1)},On.flatMapDeep=function(e,t){return ar(fa(e,t),1/0)},On.flatMapDepth=function(e,t,n){return n=void 0===n?1:is(n),ar(fa(e,t),n)},On.flatten=jo,On.flattenDeep=function(e){return(null==e?0:e.length)?ar(e,1/0):[]},On.flattenDepth=function(e,t){return(null==e?0:e.length)?ar(e,t=void 0===t?1:is(t)):[]},On.flip=function(e){return zi(e,512)},On.flow=Ws,On.flowRight=Gs,On.fromPairs=function(e){for(var t=-1,n=null==e?0:e.length,r={};++t<n;){var i=e[t];r[i[0]]=i[1]}return r},On.functions=function(e){return null==e?[]:hr(e,xs(e))},On.functionsIn=function(e){return null==e?[]:hr(e,_s(e))},On.groupBy=ua,On.initial=function(e){return(null==e?0:e.length)?Gr(e,0,-1):[]},On.intersection=No,On.intersectionBy=Io,On.intersectionWith=Bo,On.invert=ys,On.invertBy=bs,On.invokeMap=ha,On.iteratee=Ys,On.keyBy=da,On.keys=xs,On.keysIn=_s,On.map=fa,On.mapKeys=function(e,t){var n={};return t=Zi(t,3),lr(e,(function(e,r,i){Yn(n,t(e,r,i),e)})),n},On.mapValues=function(e,t){var n={};return t=Zi(t,3),lr(e,(function(e,r,i){Yn(n,r,t(e,r,i))})),n},On.matches=function(e){return Or(Zn(e,1))},On.matchesProperty=function(e,t){return kr(e,Zn(t,1))},On.memoize=Sa,On.merge=Es,On.mergeWith=Ss,On.method=Xs,On.methodOf=Ks,On.mixin=Zs,On.negate=Ca,On.nthArg=function(e){return e=is(e),Br((function(t){return Pr(t,e)}))},On.omit=Cs,On.omitBy=function(e,t){return Ts(e,Ca(Zi(t)))},On.once=function(e){return ya(2,e)},On.orderBy=function(e,t,n,r){return null==e?[]:(Fa(t)||(t=null==t?[]:[t]),Fa(n=r?void 0:n)||(n=null==n?[]:[n]),Lr(e,t,n))},On.over=Qs,On.overArgs=Aa,On.overEvery=ec,On.overSome=tc,On.partial=Ta,On.partialRight=Ma,On.partition=pa,On.pick=As,On.pickBy=Ts,On.property=nc,On.propertyOf=function(e){return function(t){return null==e?void 0:dr(e,t)}},On.pull=Uo,On.pullAll=Ho,On.pullAllBy=function(e,t,n){return e&&e.length&&t&&t.length?jr(e,t,Zi(n,2)):e},On.pullAllWith=function(e,t,n){return e&&e.length&&t&&t.length?jr(e,t,void 0,n):e},On.pullAt=Vo,On.range=rc,On.rangeRight=ic,On.rearg=Oa,On.reject=function(e,t){return(Fa(e)?ut:or)(e,Ca(Zi(t,3)))},On.remove=function(e,t){var n=[];if(!e||!e.length)return n;var r=-1,i=[],o=e.length;for(t=Zi(t,3);++r<o;){var a=e[r];t(a,r,e)&&(n.push(a),i.push(r))}return Dr(e,i),n},On.rest=function(e,t){if("function"!=typeof e)throw new ve(o);return Br(e,t=void 0===t?t:is(t))},On.reverse=$o,On.sampleSize=function(e,t,n){return t=(n?co(e,t,n):void 0===t)?1:is(t),(Fa(e)?Un:Ur)(e,t)},On.set=function(e,t,n){return null==e?e:Hr(e,t,n)},On.setWith=function(e,t,n,r){return r="function"==typeof r?r:void 0,null==e?e:Hr(e,t,n,r)},On.shuffle=function(e){return(Fa(e)?Hn:Wr)(e)},On.slice=function(e,t,n){var r=null==e?0:e.length;return r?(n&&"number"!=typeof n&&co(e,t,n)?(t=0,n=r):(t=null==t?0:is(t),n=void 0===n?r:is(n)),Gr(e,t,n)):[]},On.sortBy=ma,On.sortedUniq=function(e){return e&&e.length?Kr(e):[]},On.sortedUniqBy=function(e,t){return e&&e.length?Kr(e,Zi(t,2)):[]},On.split=function(e,t,n){return n&&"number"!=typeof n&&co(e,t,n)&&(t=n=void 0),(n=void 0===n?4294967295:n>>>0)?(e=cs(e))&&("string"==typeof t||null!=t&&!Xa(t))&&!(t=Jr(t))&&zt(e)?ui(qt(e),0,n):e.split(t,n):[]},On.spread=function(e,t){if("function"!=typeof e)throw new ve(o);return t=null==t?0:sn(is(t),0),Br((function(n){var r=n[t],i=ui(n,0,t);return r&&pt(i,r),ot(e,this,i)}))},On.tail=function(e){var t=null==e?0:e.length;return t?Gr(e,1,t):[]},On.take=function(e,t,n){return e&&e.length?Gr(e,0,(t=n||void 0===t?1:is(t))<0?0:t):[]},On.takeRight=function(e,t,n){var r=null==e?0:e.length;return r?Gr(e,(t=r-(t=n||void 0===t?1:is(t)))<0?0:t,r):[]},On.takeRightWhile=function(e,t){return e&&e.length?ni(e,Zi(t,3),!1,!0):[]},On.takeWhile=function(e,t){return e&&e.length?ni(e,Zi(t,3)):[]},On.tap=function(e,t){return t(e),e},On.throttle=function(e,t,n){var r=!0,i=!0;if("function"!=typeof e)throw new ve(o);return $a(n)&&(r="leading"in n?!!n.leading:r,i="trailing"in n?!!n.trailing:i),xa(e,t,{leading:r,maxWait:t,trailing:i})},On.thru=ra,On.toArray=ns,On.toPairs=Ms,On.toPairsIn=Os,On.toPath=function(e){return Fa(e)?ft(e,To):Ja(e)?[e]:yi(Ao(cs(e)))},On.toPlainObject=ss,On.transform=function(e,t,n){var r=Fa(e),i=r||Ia(e)||Qa(e);if(t=Zi(t,4),null==n){var o=e&&e.constructor;n=i?r?new o:[]:$a(e)&&Ua(o)?kn(He(e)):{}}return(i?st:lr)(e,(function(e,r,i){return t(n,e,r,i)})),n},On.unary=function(e){return va(e,1)},On.union=Wo,On.unionBy=Go,On.unionWith=qo,On.uniq=function(e){return e&&e.length?Qr(e):[]},On.uniqBy=function(e,t){return e&&e.length?Qr(e,Zi(t,2)):[]},On.uniqWith=function(e,t){return t="function"==typeof t?t:void 0,e&&e.length?Qr(e,void 0,t):[]},On.unset=function(e,t){return null==e||ei(e,t)},On.unzip=Yo,On.unzipWith=Xo,On.update=function(e,t,n){return null==e?e:ti(e,t,si(n))},On.updateWith=function(e,t,n,r){return r="function"==typeof r?r:void 0,null==e?e:ti(e,t,si(n),r)},On.values=ks,On.valuesIn=function(e){return null==e?[]:Pt(e,_s(e))},On.without=Ko,On.words=Us,On.wrap=function(e,t){return Ta(si(t),e)},On.xor=Zo,On.xorBy=Jo,On.xorWith=Qo,On.zip=ea,On.zipObject=function(e,t){return oi(e||[],t||[],$n)},On.zipObjectDeep=function(e,t){return oi(e||[],t||[],Hr)},On.zipWith=ta,On.entries=Ms,On.entriesIn=Os,On.extend=us,On.extendWith=hs,Zs(On,On),On.add=sc,On.attempt=Hs,On.camelCase=Rs,On.capitalize=Ps,On.ceil=cc,On.clamp=function(e,t,n){return void 0===n&&(n=t,t=void 0),void 0!==n&&(n=(n=as(n))==n?n:0),void 0!==t&&(t=(t=as(t))==t?t:0),Kn(as(e),t,n)},On.clone=function(e){return Zn(e,4)},On.cloneDeep=function(e){return Zn(e,5)},On.cloneDeepWith=function(e,t){return Zn(e,5,t="function"==typeof t?t:void 0)},On.cloneWith=function(e,t){return Zn(e,4,t="function"==typeof t?t:void 0)},On.conformsTo=function(e,t){return null==t||Jn(e,t,xs(t))},On.deburr=Ls,On.defaultTo=function(e,t){return null==e||e!=e?t:e},On.divide=lc,On.endsWith=function(e,t,n){e=cs(e),t=Jr(t);var r=e.length,i=n=void 0===n?r:Kn(is(n),0,r);return(n-=t.length)>=0&&e.slice(n,i)==t},On.eq=ka,On.escape=function(e){return(e=cs(e))&&B.test(e)?e.replace(N,It):e},On.escapeRegExp=function(e){return(e=cs(e))&&q.test(e)?e.replace(G,"\\$&"):e},On.every=function(e,t,n){var r=Fa(e)?lt:rr;return n&&co(e,t,n)&&(t=void 0),r(e,Zi(t,3))},On.find=aa,On.findIndex=Lo,On.findKey=function(e,t){return bt(e,Zi(t,3),lr)},On.findLast=sa,On.findLastIndex=Fo,On.findLastKey=function(e,t){return bt(e,Zi(t,3),ur)},On.floor=uc,On.forEach=ca,On.forEachRight=la,On.forIn=function(e,t){return null==e?e:sr(e,Zi(t,3),_s)},On.forInRight=function(e,t){return null==e?e:cr(e,Zi(t,3),_s)},On.forOwn=function(e,t){return e&&lr(e,Zi(t,3))},On.forOwnRight=function(e,t){return e&&ur(e,Zi(t,3))},On.get=gs,On.gt=Ra,On.gte=Pa,On.has=function(e,t){return null!=e&&io(e,t,gr)},On.hasIn=vs,On.head=Do,On.identity=qs,On.includes=function(e,t,n,r){e=Da(e)?e:ks(e),n=n&&!r?is(n):0;var i=e.length;return n<0&&(n=sn(i+n,0)),Za(e)?n<=i&&e.indexOf(t,n)>-1:!!i&&xt(e,t,n)>-1},On.indexOf=function(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var i=null==n?0:is(n);return i<0&&(i=sn(r+i,0)),xt(e,t,i)},On.inRange=function(e,t,n){return t=rs(t),void 0===n?(n=t,t=0):n=rs(n),function(e,t,n){return e>=cn(t,n)&&e<sn(t,n)}(e=as(e),t,n)},On.invoke=ws,On.isArguments=La,On.isArray=Fa,On.isArrayBuffer=ja,On.isArrayLike=Da,On.isArrayLikeObject=Na,On.isBoolean=function(e){return!0===e||!1===e||Wa(e)&&pr(e)==u},On.isBuffer=Ia,On.isDate=Ba,On.isElement=function(e){return Wa(e)&&1===e.nodeType&&!Ya(e)},On.isEmpty=function(e){if(null==e)return!0;if(Da(e)&&(Fa(e)||"string"==typeof e||"function"==typeof e.splice||Ia(e)||Qa(e)||La(e)))return!e.length;var t=ro(e);if(t==m||t==b)return!e.size;if(fo(e))return!Cr(e).length;for(var n in e)if(Ee.call(e,n))return!1;return!0},On.isEqual=function(e,t){return xr(e,t)},On.isEqualWith=function(e,t,n){var r=(n="function"==typeof n?n:void 0)?n(e,t):void 0;return void 0===r?xr(e,t,void 0,n):!!r},On.isError=za,On.isFinite=function(e){return"number"==typeof e&&rn(e)},On.isFunction=Ua,On.isInteger=Ha,On.isLength=Va,On.isMap=Ga,On.isMatch=function(e,t){return e===t||_r(e,t,Qi(t))},On.isMatchWith=function(e,t,n){return n="function"==typeof n?n:void 0,_r(e,t,Qi(t),n)},On.isNaN=function(e){return qa(e)&&e!=+e},On.isNative=function(e){if(ho(e))throw new X("Unsupported core-js use. Try https://npms.io/search?q=ponyfill.");return Er(e)},On.isNil=function(e){return null==e},On.isNull=function(e){return null===e},On.isNumber=qa,On.isObject=$a,On.isObjectLike=Wa,On.isPlainObject=Ya,On.isRegExp=Xa,On.isSafeInteger=function(e){return Ha(e)&&e>=-9007199254740991&&e<=9007199254740991},On.isSet=Ka,On.isString=Za,On.isSymbol=Ja,On.isTypedArray=Qa,On.isUndefined=function(e){return void 0===e},On.isWeakMap=function(e){return Wa(e)&&ro(e)==_},On.isWeakSet=function(e){return Wa(e)&&"[object WeakSet]"==pr(e)},On.join=function(e,t){return null==e?"":on.call(e,t)},On.kebabCase=Fs,On.last=zo,On.lastIndexOf=function(e,t,n){var r=null==e?0:e.length;if(!r)return-1;var i=r;return void 0!==n&&(i=(i=is(n))<0?sn(r+i,0):cn(i,r-1)),t==t?function(e,t,n){for(var r=n+1;r--;)if(e[r]===t)return r;return r}(e,t,i):wt(e,Et,i,!0)},On.lowerCase=js,On.lowerFirst=Ds,On.lt=es,On.lte=ts,On.max=function(e){return e&&e.length?ir(e,qs,mr):void 0},On.maxBy=function(e,t){return e&&e.length?ir(e,Zi(t,2),mr):void 0},On.mean=function(e){return St(e,qs)},On.meanBy=function(e,t){return St(e,Zi(t,2))},On.min=function(e){return e&&e.length?ir(e,qs,Tr):void 0},On.minBy=function(e,t){return e&&e.length?ir(e,Zi(t,2),Tr):void 0},On.stubArray=oc,On.stubFalse=ac,On.stubObject=function(){return{}},On.stubString=function(){return""},On.stubTrue=function(){return!0},On.multiply=dc,On.nth=function(e,t){return e&&e.length?Pr(e,is(t)):void 0},On.noConflict=function(){return qe._===this&&(qe._=Me),this},On.noop=Js,On.now=ga,On.pad=function(e,t,n){e=cs(e);var r=(t=is(t))?Gt(e):0;if(!t||r>=t)return e;var i=(t-r)/2;return Li(en(i),n)+e+Li(Qt(i),n)},On.padEnd=function(e,t,n){e=cs(e);var r=(t=is(t))?Gt(e):0;return t&&r<t?e+Li(t-r,n):e},On.padStart=function(e,t,n){e=cs(e);var r=(t=is(t))?Gt(e):0;return t&&r<t?Li(t-r,n)+e:e},On.parseInt=function(e,t,n){return n||null==t?t=0:t&&(t=+t),un(cs(e).replace(Y,""),t||0)},On.random=function(e,t,n){if(n&&"boolean"!=typeof n&&co(e,t,n)&&(t=n=void 0),void 0===n&&("boolean"==typeof t?(n=t,t=void 0):"boolean"==typeof e&&(n=e,e=void 0)),void 0===e&&void 0===t?(e=0,t=1):(e=rs(e),void 0===t?(t=e,e=0):t=rs(t)),e>t){var r=e;e=t,t=r}if(n||e%1||t%1){var i=hn();return cn(e+i*(t-e+Ve("1e-"+((i+"").length-1))),t)}return Nr(e,t)},On.reduce=function(e,t,n){var r=Fa(e)?mt:Tt,i=arguments.length<3;return r(e,Zi(t,4),n,i,tr)},On.reduceRight=function(e,t,n){var r=Fa(e)?gt:Tt,i=arguments.length<3;return r(e,Zi(t,4),n,i,nr)},On.repeat=function(e,t,n){return t=(n?co(e,t,n):void 0===t)?1:is(t),Ir(cs(e),t)},On.replace=function(){var e=arguments,t=cs(e[0]);return e.length<3?t:t.replace(e[1],e[2])},On.result=function(e,t,n){var r=-1,i=(t=ci(t,e)).length;for(i||(i=1,e=void 0);++r<i;){var o=null==e?void 0:e[To(t[r])];void 0===o&&(r=i,o=n),e=Ua(o)?o.call(e):o}return e},On.round=fc,On.runInContext=e,On.sample=function(e){return(Fa(e)?zn:zr)(e)},On.size=function(e){if(null==e)return 0;if(Da(e))return Za(e)?Gt(e):e.length;var t=ro(e);return t==m||t==b?e.size:Cr(e).length},On.snakeCase=Ns,On.some=function(e,t,n){var r=Fa(e)?vt:qr;return n&&co(e,t,n)&&(t=void 0),r(e,Zi(t,3))},On.sortedIndex=function(e,t){return Yr(e,t)},On.sortedIndexBy=function(e,t,n){return Xr(e,t,Zi(n,2))},On.sortedIndexOf=function(e,t){var n=null==e?0:e.length;if(n){var r=Yr(e,t);if(r<n&&ka(e[r],t))return r}return-1},On.sortedLastIndex=function(e,t){return Yr(e,t,!0)},On.sortedLastIndexBy=function(e,t,n){return Xr(e,t,Zi(n,2),!0)},On.sortedLastIndexOf=function(e,t){if(null==e?0:e.length){var n=Yr(e,t,!0)-1;if(ka(e[n],t))return n}return-1},On.startCase=Is,On.startsWith=function(e,t,n){return e=cs(e),n=null==n?0:Kn(is(n),0,e.length),t=Jr(t),e.slice(n,n+t.length)==t},On.subtract=pc,On.sum=function(e){return e&&e.length?Mt(e,qs):0},On.sumBy=function(e,t){return e&&e.length?Mt(e,Zi(t,2)):0},On.template=function(e,t,n){var r=On.templateSettings;n&&co(e,t,n)&&(t=void 0),e=cs(e),t=hs({},t,r,Ui);var i,o,a=hs({},t.imports,r.imports,Ui),s=xs(a),c=Pt(a,s),l=0,u=t.interpolate||ue,h="__p += '",d=me((t.escape||ue).source+"|"+u.source+"|"+(u===H?ne:ue).source+"|"+(t.evaluate||ue).source+"|$","g"),f="//# sourceURL="+(Ee.call(t,"sourceURL")?(t.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++Be+"]")+"\n";e.replace(d,(function(t,n,r,a,s,c){return r||(r=a),h+=e.slice(l,c).replace(he,Bt),n&&(i=!0,h+="' +\n__e("+n+") +\n'"),s&&(o=!0,h+="';\n"+s+";\n__p += '"),r&&(h+="' +\n((__t = ("+r+")) == null ? '' : __t) +\n'"),l=c+t.length,t})),h+="';\n";var p=Ee.call(t,"variable")&&t.variable;if(p){if(ee.test(p))throw new X("Invalid `variable` option passed into `_.template`")}else h="with (obj) {\n"+h+"\n}\n";h=(o?h.replace(L,""):h).replace(F,"$1").replace(j,"$1;"),h="function("+(p||"obj")+") {\n"+(p?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(i?", __e = _.escape":"")+(o?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+h+"return __p\n}";var m=Hs((function(){return de(s,f+"return "+h).apply(void 0,c)}));if(m.source=h,za(m))throw m;return m},On.times=function(e,t){if((e=is(e))<1||e>9007199254740991)return[];var n=4294967295,r=cn(e,4294967295);e-=4294967295;for(var i=Ot(r,t=Zi(t));++n<e;)t(n);return i},On.toFinite=rs,On.toInteger=is,On.toLength=os,On.toLower=function(e){return cs(e).toLowerCase()},On.toNumber=as,On.toSafeInteger=function(e){return e?Kn(is(e),-9007199254740991,9007199254740991):0===e?e:0},On.toString=cs,On.toUpper=function(e){return cs(e).toUpperCase()},On.trim=function(e,t,n){if((e=cs(e))&&(n||void 0===t))return kt(e);if(!e||!(t=Jr(t)))return e;var r=qt(e),i=qt(t);return ui(r,Ft(r,i),jt(r,i)+1).join("")},On.trimEnd=function(e,t,n){if((e=cs(e))&&(n||void 0===t))return e.slice(0,Yt(e)+1);if(!e||!(t=Jr(t)))return e;var r=qt(e);return ui(r,0,jt(r,qt(t))+1).join("")},On.trimStart=function(e,t,n){if((e=cs(e))&&(n||void 0===t))return e.replace(Y,"");if(!e||!(t=Jr(t)))return e;var r=qt(e);return ui(r,Ft(r,qt(t))).join("")},On.truncate=function(e,t){var n=30,r="...";if($a(t)){var i="separator"in t?t.separator:i;n="length"in t?is(t.length):n,r="omission"in t?Jr(t.omission):r}var o=(e=cs(e)).length;if(zt(e)){var a=qt(e);o=a.length}if(n>=o)return e;var s=n-Gt(r);if(s<1)return r;var c=a?ui(a,0,s).join(""):e.slice(0,s);if(void 0===i)return c+r;if(a&&(s+=c.length-s),Xa(i)){if(e.slice(s).search(i)){var l,u=c;for(i.global||(i=me(i.source,cs(re.exec(i))+"g")),i.lastIndex=0;l=i.exec(u);)var h=l.index;c=c.slice(0,void 0===h?s:h)}}else if(e.indexOf(Jr(i),s)!=s){var d=c.lastIndexOf(i);d>-1&&(c=c.slice(0,d))}return c+r},On.unescape=function(e){return(e=cs(e))&&I.test(e)?e.replace(D,Xt):e},On.uniqueId=function(e){var t=++Se;return cs(e)+t},On.upperCase=Bs,On.upperFirst=zs,On.each=ca,On.eachRight=la,On.first=Do,Zs(On,(hc={},lr(On,(function(e,t){Ee.call(On.prototype,t)||(hc[t]=e)})),hc),{chain:!1}),On.VERSION="4.17.21",st(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(e){On[e].placeholder=On})),st(["drop","take"],(function(e,t){Ln.prototype[e]=function(n){n=void 0===n?1:sn(is(n),0);var r=this.__filtered__&&!t?new Ln(this):this.clone();return r.__filtered__?r.__takeCount__=cn(n,r.__takeCount__):r.__views__.push({size:cn(n,4294967295),type:e+(r.__dir__<0?"Right":"")}),r},Ln.prototype[e+"Right"]=function(t){return this.reverse()[e](t).reverse()}})),st(["filter","map","takeWhile"],(function(e,t){var n=t+1,r=1==n||3==n;Ln.prototype[e]=function(e){var t=this.clone();return t.__iteratees__.push({iteratee:Zi(e,3),type:n}),t.__filtered__=t.__filtered__||r,t}})),st(["head","last"],(function(e,t){var n="take"+(t?"Right":"");Ln.prototype[e]=function(){return this[n](1).value()[0]}})),st(["initial","tail"],(function(e,t){var n="drop"+(t?"":"Right");Ln.prototype[e]=function(){return this.__filtered__?new Ln(this):this[n](1)}})),Ln.prototype.compact=function(){return this.filter(qs)},Ln.prototype.find=function(e){return this.filter(e).head()},Ln.prototype.findLast=function(e){return this.reverse().find(e)},Ln.prototype.invokeMap=Br((function(e,t){return"function"==typeof e?new Ln(this):this.map((function(n){return br(n,e,t)}))})),Ln.prototype.reject=function(e){return this.filter(Ca(Zi(e)))},Ln.prototype.slice=function(e,t){e=is(e);var n=this;return n.__filtered__&&(e>0||t<0)?new Ln(n):(e<0?n=n.takeRight(-e):e&&(n=n.drop(e)),void 0!==t&&(n=(t=is(t))<0?n.dropRight(-t):n.take(t-e)),n)},Ln.prototype.takeRightWhile=function(e){return this.reverse().takeWhile(e).reverse()},Ln.prototype.toArray=function(){return this.take(4294967295)},lr(Ln.prototype,(function(e,t){var n=/^(?:filter|find|map|reject)|While$/.test(t),r=/^(?:head|last)$/.test(t),i=On[r?"take"+("last"==t?"Right":""):t],o=r||/^find/.test(t);i&&(On.prototype[t]=function(){var t=this.__wrapped__,a=r?[1]:arguments,s=t instanceof Ln,c=a[0],l=s||Fa(t),u=function(e){var t=i.apply(On,pt([e],a));return r&&h?t[0]:t};l&&n&&"function"==typeof c&&1!=c.length&&(s=l=!1);var h=this.__chain__,d=!!this.__actions__.length,f=o&&!h,p=s&&!d;if(!o&&l){t=p?t:new Ln(this);var m=e.apply(t,a);return m.__actions__.push({func:ra,args:[u],thisArg:void 0}),new Pn(m,h)}return f&&p?e.apply(this,a):(m=this.thru(u),f?r?m.value()[0]:m.value():m)})})),st(["pop","push","shift","sort","splice","unshift"],(function(e){var t=ye[e],n=/^(?:push|sort|unshift)$/.test(e)?"tap":"thru",r=/^(?:pop|shift)$/.test(e);On.prototype[e]=function(){var e=arguments;if(r&&!this.__chain__){var i=this.value();return t.apply(Fa(i)?i:[],e)}return this[n]((function(n){return t.apply(Fa(n)?n:[],e)}))}})),lr(Ln.prototype,(function(e,t){var n=On[t];if(n){var r=n.name+"";Ee.call(wn,r)||(wn[r]=[]),wn[r].push({name:t,func:n})}})),wn[Oi(void 0,2).name]=[{name:"wrapper",func:void 0}],Ln.prototype.clone=function(){var e=new Ln(this.__wrapped__);return e.__actions__=yi(this.__actions__),e.__dir__=this.__dir__,e.__filtered__=this.__filtered__,e.__iteratees__=yi(this.__iteratees__),e.__takeCount__=this.__takeCount__,e.__views__=yi(this.__views__),e},Ln.prototype.reverse=function(){if(this.__filtered__){var e=new Ln(this);e.__dir__=-1,e.__filtered__=!0}else(e=this.clone()).__dir__*=-1;return e},Ln.prototype.value=function(){var e=this.__wrapped__.value(),t=this.__dir__,n=Fa(e),r=t<0,i=n?e.length:0,o=function(e,t,n){var r=-1,i=n.length;for(;++r<i;){var o=n[r],a=o.size;switch(o.type){case"drop":e+=a;break;case"dropRight":t-=a;break;case"take":t=cn(t,e+a);break;case"takeRight":e=sn(e,t-a)}}return{start:e,end:t}}(0,i,this.__views__),a=o.start,s=o.end,c=s-a,l=r?s:a-1,u=this.__iteratees__,h=u.length,d=0,f=cn(c,this.__takeCount__);if(!n||!r&&i==c&&f==c)return ri(e,this.__actions__);var p=[];e:for(;c--&&d<f;){for(var m=-1,g=e[l+=t];++m<h;){var v=u[m],y=v.iteratee,b=v.type,w=y(g);if(2==b)g=w;else if(!w){if(1==b)continue e;break e}}p[d++]=g}return p},On.prototype.at=ia,On.prototype.chain=function(){return na(this)},On.prototype.commit=function(){return new Pn(this.value(),this.__chain__)},On.prototype.next=function(){void 0===this.__values__&&(this.__values__=ns(this.value()));var e=this.__index__>=this.__values__.length;return{done:e,value:e?void 0:this.__values__[this.__index__++]}},On.prototype.plant=function(e){for(var t,n=this;n instanceof Rn;){var r=Oo(n);r.__index__=0,r.__values__=void 0,t?i.__wrapped__=r:t=r;var i=r;n=n.__wrapped__}return i.__wrapped__=e,t},On.prototype.reverse=function(){var e=this.__wrapped__;if(e instanceof Ln){var t=e;return this.__actions__.length&&(t=new Ln(this)),(t=t.reverse()).__actions__.push({func:ra,args:[$o],thisArg:void 0}),new Pn(t,this.__chain__)}return this.thru($o)},On.prototype.toJSON=On.prototype.valueOf=On.prototype.value=function(){return ri(this.__wrapped__,this.__actions__)},On.prototype.first=On.prototype.head,Ze&&(On.prototype[Ze]=function(){return this}),On}();qe._=Kt,void 0===(i=function(){return Kt}.call(t,n,t,r))||(r.exports=i)}).call(this)}).call(this,n("yLpj"),n("YuTi")(e))},M96O:function(e,t,n){var r;try{r={clone:n("uM7l"),constant:n("cvCv"),each:n("xkGU"),filter:n("k4Da"),has:n("OFL0"),isArray:n("Z0cm"),isEmpty:n("E+oP"),isFunction:n("lSCD"),isUndefined:n("TP7S"),keys:n("7GkX"),map:n("3WF5"),reduce:n("xaJk"),size:n("1iNE"),transform:n("UMpK"),union:n("v8eK"),values:n("P/G1")}}catch(e){}r||(r=window._),e.exports=r},ME5O:function(e,t,n){"use strict";t.a={animationIterationCount:1,borderImageOutset:1,borderImageSlice:1,borderImageWidth:1,boxFlex:1,boxFlexGroup:1,boxOrdinalGroup:1,columnCount:1,columns:1,flex:1,flexGrow:1,flexPositive:1,flexShrink:1,flexNegative:1,flexOrder:1,gridRow:1,gridRowEnd:1,gridRowSpan:1,gridRowStart:1,gridColumn:1,gridColumnEnd:1,gridColumnSpan:1,gridColumnStart:1,msGridRow:1,msGridRowSpan:1,msGridColumn:1,msGridColumnSpan:1,fontWeight:1,lineHeight:1,opacity:1,order:1,orphans:1,tabSize:1,widows:1,zIndex:1,zoom:1,WebkitLineClamp:1,fillOpacity:1,floodOpacity:1,stopOpacity:1,strokeDasharray:1,strokeDashoffset:1,strokeMiterlimit:1,strokeOpacity:1,strokeWidth:1}},MHMH:function(e,t,n){"use strict";e.exports=function(e,t,n){var r,i,o,a=this.options,s=t.length+1,c=-1,l=e.now(),u="",h="";for(;++c<s;){if(" "!==(r=t.charAt(c))&&"\t"!==r){c--;break}u+=r}o=0;for(;++c<=s;){if("#"!==(r=t.charAt(c))){c--;break}u+=r,o++}if(o>6)return;if(!o||!a.pedantic&&"#"===t.charAt(c+1))return;s=t.length+1,i="";for(;++c<s;){if(" "!==(r=t.charAt(c))&&"\t"!==r){c--;break}i+=r}if(!a.pedantic&&0===i.length&&r&&"\n"!==r)return;if(n)return!0;u+=i,i="",h="";for(;++c<s&&(r=t.charAt(c))&&"\n"!==r;)if(" "===r||"\t"===r||"#"===r){for(;" "===r||"\t"===r;)i+=r,r=t.charAt(++c);for(;"#"===r;)i+=r,r=t.charAt(++c);for(;" "===r||"\t"===r;)i+=r,r=t.charAt(++c);c--}else h+=i+r,i="";return l.column+=u.length,l.offset+=u.length,e(u+=h+i)({type:"heading",depth:o,children:this.tokenizeInline(h,l)})}},MMmD:function(e,t,n){var r=n("lSCD"),i=n("shjB");e.exports=function(e){return null!=e&&i(e.length)&&!r(e)}},"MQ5/":function(e,t,n){"use strict";e.exports=a;var r=["\\","`","*","{","}","[","]","(",")","#","+","-",".","!","_",">"],i=r.concat(["~","|"]),o=i.concat(["\n",'"',"$","%","&","'",",","/",":",";","<","=","?","@","^"]);function a(e){var t=e||{};return t.commonmark?o:t.gfm?i:r}a.default=r,a.gfm=i,a.commonmark=o},MaiH:function(e,t,n){"use strict";e.exports=function(e,t){return e.indexOf("~~",t)}},MgzW:function(e,t,n){"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/var r=Object.getOwnPropertySymbols,i=Object.prototype.hasOwnProperty,o=Object.prototype.propertyIsEnumerable;function a(e){if(null==e)throw new TypeError("Object.assign cannot be called with null or undefined");return Object(e)}e.exports=function(){try{if(!Object.assign)return!1;var e=new String("abc");if(e[5]="de","5"===Object.getOwnPropertyNames(e)[0])return!1;for(var t={},n=0;n<10;n++)t["_"+String.fromCharCode(n)]=n;if("0123456789"!==Object.getOwnPropertyNames(t).map((function(e){return t[e]})).join(""))return!1;var r={};return"abcdefghijklmnopqrst".split("").forEach((function(e){r[e]=e})),"abcdefghijklmnopqrst"===Object.keys(Object.assign({},r)).join("")}catch(e){return!1}}()?Object.assign:function(e,t){for(var n,s,c=a(e),l=1;l<arguments.length;l++){for(var u in n=Object(arguments[l]))i.call(n,u)&&(c[u]=n[u]);if(r){s=r(n);for(var h=0;h<s.length;h++)o.call(n,s[h])&&(c[s[h]]=n[s[h]])}}return c}},MrPd:function(e,t,n){var r=n("hypo"),i=n("ljhN"),o=Object.prototype.hasOwnProperty;e.exports=function(e,t,n){var a=e[t];o.call(e,t)&&i(a,n)&&(void 0!==n||t in e)||r(e,t,n)}},MvSz:function(e,t,n){var r=n("LXxW"),i=n("0ycA"),o=Object.prototype.propertyIsEnumerable,a=Object.getOwnPropertySymbols,s=a?function(e){return null==e?[]:(e=Object(e),r(a(e),(function(t){return o.call(e,t)})))}:i;e.exports=s},"N6n/":function(e,t,n){var r=n("OEc2"),i=n("ACFR");function o(e){e=e||{},this.position=new r(e.position),this.orientation=new i(e.orientation)}o.prototype.applyTransform=function(e){this.position.multiplyQuaternion(e.rotation),this.position.add(e.translation);var t=e.rotation.clone();t.multiply(this.orientation),this.orientation=t},o.prototype.clone=function(){return new o(this)},o.prototype.multiply=function(e){var t=e.clone();return t.applyTransform({rotation:this.orientation,translation:this.position}),t},o.prototype.getInverse=function(){var e=this.clone();return e.orientation.invert(),e.position.multiplyQuaternion(e.orientation),e.position.x*=-1,e.position.y*=-1,e.position.z*=-1,e},e.exports=o},NFD0:function(e,t,n){"use strict";e.exports=function(e,t){return e.indexOf("\\",t)}},NKxu:function(e,t,n){var r=n("lSCD"),i=n("E2jh"),o=n("GoyQ"),a=n("3Fdi"),s=/^\[object .+?Constructor\]$/,c=Function.prototype,l=Object.prototype,u=c.toString,h=l.hasOwnProperty,d=RegExp("^"+u.call(h).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");e.exports=function(e){return!(!o(e)||i(e))&&(r(e)?d:s).test(a(e))}},NS2H:function(e,t,n){"use strict";e.exports=function(e,t,n){var i,o,a,s,c,l=e.now(),u=t.length,h=-1,d="";for(;++h<u;){if(" "!==(a=t.charAt(h))||h>=3){h--;break}d+=a}i="",o="";for(;++h<u;){if("\n"===(a=t.charAt(h))){h--;break}" "===a||"\t"===a?o+=a:(i+=o+a,o="")}if(l.column+=d.length,l.offset+=d.length,d+=i+o,a=t.charAt(++h),s=t.charAt(++h),"\n"!==a||!r[s])return;d+=a,o=s,c=r[s];for(;++h<u;){if((a=t.charAt(h))!==s){if("\n"!==a)return;h--;break}o+=a}if(n)return!0;return e(d+o)({type:"heading",depth:c,children:this.tokenizeInline(i,l)})};var r={};r["="]=1,r["-"]=2},"NkL+":function(e,t,n){"use strict";var r=Object.prototype.toString;e.exports=function(e){var t;return"[object Object]"===r.call(e)&&(null===(t=Object.getPrototypeOf(e))||t===Object.getPrototypeOf({}))}},NlNu:function(e,t){t.DOMImplementation=window.DOMImplementation,t.XMLSerializer=window.XMLSerializer,t.DOMParser=window.DOMParser},Npjl:function(e,t){e.exports=function(e,t){return null==e?void 0:e[t]}},Nsbk:function(e,t){function n(t){return e.exports=n=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},e.exports.default=e.exports,e.exports.__esModule=!0,n(t)}e.exports=n,e.exports.default=e.exports,e.exports.__esModule=!0},Nw8X:function(e,t,n){"use strict";var r=["http","https","mailto","tel"];e.exports=function(e){var t=(e||"").trim(),n=t.charAt(0);if("#"===n||"/"===n)return t;var i=t.indexOf(":");if(-1===i)return t;for(var o=r.length,a=-1;++a<o;){var s=r[a];if(i===s.length&&t.slice(0,s.length).toLowerCase()===s)return t}return-1!==(a=t.indexOf("?"))&&i>a||-1!==(a=t.indexOf("#"))&&i>a?t:"javascript:void(0)"}},NykK:function(e,t,n){var r=n("nmnc"),i=n("AP2z"),o=n("KfNM"),a=r?r.toStringTag:void 0;e.exports=function(e){return null==e?void 0===e?"[object Undefined]":"[object Null]":a&&a in Object(e)?i(e):o(e)}},O0oS:function(e,t,n){var r=n("Cwc5"),i=function(){try{var e=r(Object,"defineProperty");return e({},"",{}),e}catch(e){}}();e.exports=i},O7RO:function(e,t,n){var r=n("CMye"),i=n("7GkX");e.exports=function(e){for(var t=i(e),n=t.length;n--;){var o=t[n],a=e[o];t[n]=[o,a,r(a)]}return t}},OBhP:function(e,t,n){var r=n("fmRc"),i=n("gFfm"),o=n("MrPd"),a=n("WwFo"),s=n("Dw+G"),c=n("5Tg0"),l=n("Q1l4"),u=n("VOtZ"),h=n("EEGq"),d=n("qZTm"),f=n("G6z8"),p=n("QqLw"),m=n("yHx3"),g=n("wrZu"),v=n("+iFO"),y=n("Z0cm"),b=n("DSRE"),w=n("zEVN"),x=n("GoyQ"),_=n("1+5i"),E=n("7GkX"),S=n("mTTR"),C={};C["[object Arguments]"]=C["[object Array]"]=C["[object ArrayBuffer]"]=C["[object DataView]"]=C["[object Boolean]"]=C["[object Date]"]=C["[object Float32Array]"]=C["[object Float64Array]"]=C["[object Int8Array]"]=C["[object Int16Array]"]=C["[object Int32Array]"]=C["[object Map]"]=C["[object Number]"]=C["[object Object]"]=C["[object RegExp]"]=C["[object Set]"]=C["[object String]"]=C["[object Symbol]"]=C["[object Uint8Array]"]=C["[object Uint8ClampedArray]"]=C["[object Uint16Array]"]=C["[object Uint32Array]"]=!0,C["[object Error]"]=C["[object Function]"]=C["[object WeakMap]"]=!1,e.exports=function e(t,n,A,T,M,O){var k,R=1&n,P=2&n,L=4&n;if(A&&(k=M?A(t,T,M,O):A(t)),void 0!==k)return k;if(!x(t))return t;var F=y(t);if(F){if(k=m(t),!R)return l(t,k)}else{var j=p(t),D="[object Function]"==j||"[object GeneratorFunction]"==j;if(b(t))return c(t,R);if("[object Object]"==j||"[object Arguments]"==j||D&&!M){if(k=P||D?{}:v(t),!R)return P?h(t,s(k,t)):u(t,a(k,t))}else{if(!C[j])return M?t:{};k=g(t,j,R)}}O||(O=new r);var N=O.get(t);if(N)return N;O.set(t,k),_(t)?t.forEach((function(r){k.add(e(r,n,A,r,t,O))})):w(t)&&t.forEach((function(r,i){k.set(i,e(r,n,A,i,t,O))}));var I=F?void 0:(L?P?f:d:P?S:E)(t);return i(I||t,(function(r,i){I&&(r=t[i=r]),o(k,i,e(r,n,A,i,t,O))})),k}},OEc2:function(e,t){function n(e){e=e||{},this.x=e.x||0,this.y=e.y||0,this.z=e.z||0}n.prototype.add=function(e){this.x+=e.x,this.y+=e.y,this.z+=e.z},n.prototype.subtract=function(e){this.x-=e.x,this.y-=e.y,this.z-=e.z},n.prototype.multiplyQuaternion=function(e){var t=e.w*this.x+e.y*this.z-e.z*this.y,n=e.w*this.y+e.z*this.x-e.x*this.z,r=e.w*this.z+e.x*this.y-e.y*this.x,i=-e.x*this.x-e.y*this.y-e.z*this.z;this.x=t*e.w+i*-e.x+n*-e.z-r*-e.y,this.y=n*e.w+i*-e.y+r*-e.x-t*-e.z,this.z=r*e.w+i*-e.z+t*-e.y-n*-e.x},n.prototype.clone=function(){return new n(this)},e.exports=n},OFL0:function(e,t,n){var r=n("lvO4"),i=n("4sDh");e.exports=function(e,t){return null!=e&&i(e,t,r)}},OHWT:function(e,t,n){e.exports=n("MgzW")({UrdfBox:n("Oj8Q"),UrdfColor:n("BHpa"),UrdfCylinder:n("G+a2"),UrdfLink:n("ChrQ"),UrdfMaterial:n("tfBy"),UrdfMesh:n("XqU8"),UrdfModel:n("um8h"),UrdfSphere:n("55cE"),UrdfVisual:n("y7/N")},n("E9ZH"))},"OOL/":function(e,t,n){var r=n("b5wT"),i=n("HzoJ"),o=n("2fNS"),a=n("81LO");e.exports=function e(t,n,s,c){var l=t.children(n),u=t.node(n),h=u?u.borderLeft:void 0,d=u?u.borderRight:void 0,f={};h&&(l=r.filter(l,(function(e){return e!==h&&e!==d})));var p=i(t,l);r.forEach(p,(function(n){if(t.children(n.v).length){var i=e(t,n.v,s,c);f[n.v]=i,r.has(i,"barycenter")&&(o=n,a=i,r.isUndefined(o.barycenter)?(o.barycenter=a.barycenter,o.weight=a.weight):(o.barycenter=(o.barycenter*o.weight+a.barycenter*a.weight)/(o.weight+a.weight),o.weight+=a.weight))}var o,a}));var m=o(p,s);!function(e,t){r.forEach(e,(function(e){e.vs=r.flatten(e.vs.map((function(e){return t[e]?t[e].vs:e})),!0)}))}(m,f);var g=a(m,c);if(h&&(g.vs=r.flatten([h,g.vs,d],!0),t.predecessors(h).length)){var v=t.node(t.predecessors(h)[0]),y=t.node(t.predecessors(d)[0]);r.has(g,"barycenter")||(g.barycenter=0,g.weight=0),g.barycenter=(g.barycenter*g.weight+v.order+y.order)/(g.weight+2),g.weight+=2}return g}},"Of+w":function(e,t,n){var r=n("Cwc5")(n("Kz5y"),"WeakMap");e.exports=r},Oj8Q:function(e,t,n){var r=n("OEc2"),i=n("E9ZH");e.exports=function(e){this.dimension=null,this.type=i.URDF_BOX;var t=e.xml.getAttribute("size").split(" ");this.dimension=new r({x:parseFloat(t[0]),y:parseFloat(t[1]),z:parseFloat(t[2])})}},Olrm:function(e,t,n){"use strict";var r=n("U6jy"),i=n("ZWk2");e.exports=function(e){return o.raw=function(e,o,a){return i(e,r(a,{position:t(o),warning:n}))},o;function t(t){for(var n=e.offset,r=t.line,i=[];++r&&r in n;)i.push((n[r]||0)+1);return{start:t,indent:i}}function n(t,n,r){3!==r&&e.file.message(t,n)}function o(r,o,a){i(r,{position:t(o),warning:n,text:a,reference:a,textContext:e,referenceContext:e})}}},"P/G1":function(e,t,n){var r=n("JmpY"),i=n("7GkX");e.exports=function(e){return null==e?[]:r(e,i(e))}},P7XM:function(e,t){"function"==typeof Object.create?e.exports=function(e,t){t&&(e.super_=t,e.prototype=Object.create(t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}))}:e.exports=function(e,t){if(t){e.super_=t;var n=function(){};n.prototype=t.prototype,e.prototype=new n,e.prototype.constructor=e}}},PEyx:function(e,t,n){var r=n("lU+G");e.exports={isSubgraph:function(e,t){return!!e.children(t).length},edgeToId:function(e){return o(e.v)+":"+o(e.w)+":"+o(e.name)},applyStyle:function(e,t){t&&e.attr("style",t)},applyClass:function(e,t,n){t&&e.attr("class",t).attr("class",n+" "+e.attr("class"))},applyTransition:function(e,t){var n=t.graph();if(r.isPlainObject(n)){var i=n.transition;if(r.isFunction(i))return i(e)}return e}};var i=/:/g;function o(e){return e?String(e).replace(i,"\\:"):""}},PIlL:function(e,t,n){"use strict";var r=n("RsFJ"),i=n("KJAg");e.exports=function(e,t,n){var o,a,s,c,l,u,h,d,f,p=this.offset,m=this.blockTokenizers,g=this.interruptBlockquote,v=e.now(),y=v.line,b=t.length,w=[],x=[],_=[],E=0;for(;E<b&&(" "===(a=t.charAt(E))||"\t"===a);)E++;if(">"!==t.charAt(E))return;if(n)return!0;E=0;for(;E<b;){for(c=t.indexOf("\n",E),h=E,d=!1,-1===c&&(c=b);E<b&&(" "===(a=t.charAt(E))||"\t"===a);)E++;if(">"===t.charAt(E)?(E++,d=!0," "===t.charAt(E)&&E++):E=h,l=t.slice(E,c),!d&&!r(l)){E=h;break}if(!d&&(s=t.slice(E),i(g,m,this,[e,s,!0])))break;u=h===E?l:t.slice(h,c),_.push(E-h),w.push(u),x.push(l),E=c+1}E=-1,b=_.length,o=e(w.join("\n"));for(;++E<b;)p[y]=(p[y]||0)+_[E],y++;return f=this.enterBlock(),x=this.tokenizeBlock(x.join("\n"),v),f(),o({type:"blockquote",children:x})}},PJYZ:function(e,t){e.exports=function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e},e.exports.default=e.exports,e.exports.__esModule=!0},PjQo:function(e,t,n){var r=n("MgzW");e.exports=function(e){r(this,e)}},"Q+g8":function(e,t,n){var r=n("gYXE");e.exports=function(e){try{r(e)}catch(e){if(e instanceof r.CycleException)return!1;throw e}return!0}},Q1Og:function(e,t,n){var r=n("JPst"),i=n("HeW1"),o=n("eeiS");t=r(!1);var a=i(o);t.push([e.i,'.ace_editor{min-height:150px}.jsoneditor .search input{height:auto;border:inherit;border:0;box-shadow:none}.jsoneditor table{border-collapse:collapse;width:auto}.jsoneditor td,.jsoneditor th{padding:0;display:table-cell;text-align:left;vertical-align:inherit;border-radius:inherit}.jsoneditor{color:#1a1a1a;border:thin solid #3883fa;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;width:100%;height:100%;position:relative;padding:0;line-height:100%}div.jsoneditor-field,div.jsoneditor-value,div.jsoneditor-readonly,div.jsoneditor-default{border:1px solid transparent;min-height:16px;min-width:32px;padding:2px;margin:1px;word-wrap:break-word;float:left}div.jsoneditor-field p,div.jsoneditor-value p{margin:0}div.jsoneditor-value{word-break:break-word}div.jsoneditor-value.jsoneditor-empty::after{content:"value"}div.jsoneditor-value.jsoneditor-string{color:#006000}div.jsoneditor-value.jsoneditor-number{color:#ee422e}div.jsoneditor-value.jsoneditor-boolean{color:#ff8c00}div.jsoneditor-value.jsoneditor-null{color:#004ed0}div.jsoneditor-value.jsoneditor-invalid{color:#000}div.jsoneditor-readonly{min-width:16px;color:gray}div.jsoneditor-empty{border-color:#d3d3d3;border-style:dashed;border-radius:2px}div.jsoneditor-field.jsoneditor-empty::after{content:"field"}div.jsoneditor td{vertical-align:top}div.jsoneditor td.jsoneditor-separator{padding:3px 0;vertical-align:top;color:gray}div.jsoneditor td.jsoneditor-tree{vertical-align:top}div.jsoneditor div.jsoneditor-anchor{cursor:pointer}div.jsoneditor div.jsoneditor-anchor .picker_wrapper.popup.popup_bottom{top:28px;left:-10px}div.jsoneditor.busy pre.jsoneditor-preview{background:#f5f5f5;color:gray}div.jsoneditor.busy div.jsoneditor-busy{display:inherit}div.jsoneditor code.jsoneditor-preview{background:0}div.jsoneditor.jsoneditor-mode-preview pre.jsoneditor-preview{width:100%;height:100%;box-sizing:border-box;overflow:auto;padding:2px;margin:0;white-space:pre-wrap;word-break:break-all}div.jsoneditor-default{color:gray;padding-left:10px}div.jsoneditor-tree{width:100%;height:100%;position:relative;overflow:auto}div.jsoneditor-tree button.jsoneditor-button{width:24px;height:24px;padding:0;margin:0;border:0;cursor:pointer;background:transparent url('+a+")}div.jsoneditor-tree button.jsoneditor-button:focus{background-color:#f5f5f5;outline:#e5e5e5 solid 1px}div.jsoneditor-tree button.jsoneditor-collapsed{background-position:0 -48px}div.jsoneditor-tree button.jsoneditor-expanded{background-position:0 -72px}div.jsoneditor-tree button.jsoneditor-contextmenu{background-position:-48px -72px}div.jsoneditor-tree button.jsoneditor-invisible{visibility:hidden;background:0}div.jsoneditor-tree button.jsoneditor-dragarea{background:url("+a+") -72px -72px;cursor:move}div.jsoneditor-tree *:focus{outline:0}div.jsoneditor-tree div.jsoneditor-show-more{display:inline-block;padding:3px 4px;margin:2px 0;background-color:#e5e5e5;border-radius:3px;color:gray;font-family:arial,sans-serif;font-size:10pt}div.jsoneditor-tree div.jsoneditor-show-more a{display:inline-block;color:gray}div.jsoneditor-tree div.jsoneditor-color{display:inline-block;width:12px;height:12px;margin:4px;border:1px solid gray;cursor:pointer}div.jsoneditor-tree div.jsoneditor-date{background:#a1a1a1;color:#fff;font-family:arial,sans-serif;border-radius:3px;display:inline-block;padding:3px;margin:0 3px}div.jsoneditor-tree table.jsoneditor-tree{border-collapse:collapse;border-spacing:0;width:100%}div.jsoneditor-tree .jsoneditor-button.jsoneditor-schema-error{width:24px;height:24px;padding:0;margin:0 4px 0 0;background:url("+a+') -168px -48px}div.jsoneditor-outer{position:static;width:100%;height:100%;margin:0;padding:0;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box}div.jsoneditor-outer.has-nav-bar{margin-top:-26px;padding-top:26px}div.jsoneditor-outer.has-nav-bar.has-main-menu-bar{margin-top:-61px;padding-top:61px}div.jsoneditor-outer.has-status-bar{margin-bottom:-26px;padding-bottom:26px}div.jsoneditor-outer.has-main-menu-bar{margin-top:-35px;padding-top:35px}div.jsoneditor-busy{position:absolute;top:15%;left:0;box-sizing:border-box;width:100%;text-align:center;display:none}div.jsoneditor-busy span{background-color:#ffffab;border:1px solid #fe0;border-radius:3px;padding:5px 15px;box-shadow:0 0 5px rgba(0,0,0,0.4)}div.jsoneditor-field.jsoneditor-empty::after,div.jsoneditor-value.jsoneditor-empty::after{pointer-events:none;color:#d3d3d3;font-size:8pt}div.jsoneditor-value.jsoneditor-url,a.jsoneditor-value.jsoneditor-url{color:#006000;text-decoration:underline}a.jsoneditor-value.jsoneditor-url{display:inline-block;padding:2px;margin:2px}a.jsoneditor-value.jsoneditor-url:hover,a.jsoneditor-value.jsoneditor-url:focus{color:#ee422e}div.jsoneditor-field[contenteditable="true"]:focus,div.jsoneditor-field[contenteditable="true"]:hover,div.jsoneditor-value[contenteditable="true"]:focus,div.jsoneditor-value[contenteditable="true"]:hover,div.jsoneditor-field.jsoneditor-highlight,div.jsoneditor-value.jsoneditor-highlight{background-color:#ffffab;border:1px solid #fe0;border-radius:2px}div.jsoneditor-field.jsoneditor-highlight-active,div.jsoneditor-field.jsoneditor-highlight-active:focus,div.jsoneditor-field.jsoneditor-highlight-active:hover,div.jsoneditor-value.jsoneditor-highlight-active,div.jsoneditor-value.jsoneditor-highlight-active:focus,div.jsoneditor-value.jsoneditor-highlight-active:hover{background-color:#fe0;border:1px solid #ffc700;border-radius:2px}div.jsoneditor-value.jsoneditor-object,div.jsoneditor-value.jsoneditor-array{min-width:16px}div.jsoneditor-mode-view tr.jsoneditor-expandable td.jsoneditor-tree,div.jsoneditor-mode-form tr.jsoneditor-expandable td.jsoneditor-tree{cursor:pointer}div.jsoneditor-tree button.jsoneditor-contextmenu:hover,div.jsoneditor-tree button.jsoneditor-contextmenu:focus,div.jsoneditor-tree button.jsoneditor-contextmenu.jsoneditor-selected,tr.jsoneditor-selected.jsoneditor-first button.jsoneditor-contextmenu{background-position:-48px -48px}div.jsoneditor-tree div.jsoneditor-show-more a:hover,div.jsoneditor-tree div.jsoneditor-show-more a:focus{color:#ee422e}textarea.jsoneditor-text,.ace-jsoneditor{min-height:150px}textarea.jsoneditor-text{width:100%;height:100%;margin:0;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;outline-width:0;border:0;background-color:#fff;resize:none}tr.jsoneditor-highlight,tr.jsoneditor-selected{background-color:#d3d3d3}tr.jsoneditor-selected button.jsoneditor-dragarea,tr.jsoneditor-selected button.jsoneditor-contextmenu{visibility:hidden}tr.jsoneditor-selected.jsoneditor-first button.jsoneditor-dragarea,tr.jsoneditor-selected.jsoneditor-first button.jsoneditor-contextmenu{visibility:visible}div.jsoneditor-tree button.jsoneditor-dragarea:hover,div.jsoneditor-tree button.jsoneditor-dragarea:focus,tr.jsoneditor-selected.jsoneditor-first button.jsoneditor-dragarea{background-position:-72px -48px}div.jsoneditor tr,div.jsoneditor th,div.jsoneditor td{padding:0;margin:0}div.jsoneditor-field,div.jsoneditor-value,div.jsoneditor td,div.jsoneditor th,div.jsoneditor textarea,pre.jsoneditor-preview,.jsoneditor-schema-error,.jsoneditor-popover{font-family:"dejavu sans mono","droid sans mono",consolas,monaco,"lucida console","courier new",courier,monospace,sans-serif;font-size:10pt;color:#1a1a1a}.jsoneditor-schema-error{cursor:default;display:inline-block;height:24px;line-height:24px;position:relative;text-align:center;width:24px}.jsoneditor-popover{background-color:#4c4c4c;border-radius:3px;box-shadow:0 0 5px rgba(0,0,0,0.4);color:#fff;padding:7px 10px;position:absolute;cursor:auto;width:200px;z-index:999}.jsoneditor-popover.jsoneditor-above{bottom:32px;left:-98px}.jsoneditor-popover.jsoneditor-above:before{border-top:7px solid #4c4c4c;bottom:-7px}.jsoneditor-popover.jsoneditor-below{top:32px;left:-98px}.jsoneditor-popover.jsoneditor-below:before{border-bottom:7px solid #4c4c4c;top:-7px}.jsoneditor-popover.jsoneditor-left{top:-7px;right:32px}.jsoneditor-popover.jsoneditor-left:before{border-left:7px solid #4c4c4c;border-top:7px solid transparent;border-bottom:7px solid transparent;content:"";top:19px;right:-14px;left:inherit;margin-left:inherit;margin-top:-7px;position:absolute}.jsoneditor-popover.jsoneditor-right{top:-7px;left:32px}.jsoneditor-popover.jsoneditor-right:before{border-right:7px solid #4c4c4c;border-top:7px solid transparent;border-bottom:7px solid transparent;content:"";top:19px;left:-14px;margin-left:inherit;margin-top:-7px;position:absolute}.jsoneditor-popover:before{border-right:7px solid transparent;border-left:7px solid transparent;content:"";display:block;left:50%;margin-left:-7px;position:absolute}.jsoneditor-text-errors tr.jump-to-line:hover{text-decoration:underline;cursor:pointer}.jsoneditor-schema-error:hover .jsoneditor-popover,.jsoneditor-schema-error:focus .jsoneditor-popover{display:block;animation:fade-in .3s linear 1,move-up .3s linear 1}@keyframes fade-in{from{opacity:0}to{opacity:1}}.jsoneditor .jsoneditor-validation-errors-container{max-height:130px;overflow-y:auto}.jsoneditor .jsoneditor-validation-errors{width:100%;overflow:hidden}.jsoneditor .jsoneditor-additional-errors{position:absolute;margin:auto;bottom:31px;left:calc(50% - 92px);color:gray;background-color:#ebebeb;padding:7px 15px;border-radius:8px}.jsoneditor .jsoneditor-additional-errors.visible{visibility:visible;opacity:1;transition:opacity 2s linear}.jsoneditor .jsoneditor-additional-errors.hidden{visibility:hidden;opacity:0;transition:visibility 0s 2s,opacity 2s linear}.jsoneditor .jsoneditor-text-errors{width:100%;border-collapse:collapse;border-top:1px solid #ffc700}.jsoneditor .jsoneditor-text-errors td{padding:3px 6px;vertical-align:middle}.jsoneditor .jsoneditor-text-errors td pre{margin:0;white-space:normal}.jsoneditor .jsoneditor-text-errors tr{background-color:#ffffab}.jsoneditor .jsoneditor-text-errors tr.parse-error{background-color:#ee2e2e70}.jsoneditor-text-errors .jsoneditor-schema-error{border:0;width:24px;height:24px;padding:0;margin:0 4px 0 0;cursor:pointer}.jsoneditor-text-errors tr .jsoneditor-schema-error{background:url('+a+") -168px -48px}.jsoneditor-text-errors tr.parse-error .jsoneditor-schema-error{background:url("+a+") -25px 0}.fadein{-webkit-animation:fadein .3s;animation:fadein .3s;-moz-animation:fadein .3s;-o-animation:fadein .3s}@keyframes fadein{0%{opacity:0}100%{opacity:1}}.jsoneditor-contextmenu-root{position:relative;width:0;height:0}.jsoneditor-contextmenu{position:absolute;box-sizing:content-box;z-index:99}.jsoneditor-contextmenu .jsoneditor-menu{position:relative;left:0;top:0;width:128px;height:auto;background:#fff;border:1px solid #d3d3d3;box-shadow:2px 2px 12px rgba(128,128,128,0.3);list-style:none;margin:0;padding:0}.jsoneditor-contextmenu .jsoneditor-menu button{position:relative;padding:0 4px 0 0;margin:0;width:128px;height:auto;border:0;cursor:pointer;color:#4d4d4d;background:transparent;font-size:10pt;font-family:arial,sans-serif;box-sizing:border-box;text-align:left}.jsoneditor-contextmenu .jsoneditor-menu button::-moz-focus-inner{padding:0;border:0}.jsoneditor-contextmenu .jsoneditor-menu button.jsoneditor-default{width:96px}.jsoneditor-contextmenu .jsoneditor-menu button.jsoneditor-expand{float:right;width:32px;height:24px;border-left:1px solid #e5e5e5}.jsoneditor-contextmenu .jsoneditor-menu li{overflow:hidden}.jsoneditor-contextmenu .jsoneditor-menu li ul{display:none;position:relative;left:-10px;top:0;border:0;box-shadow:inset 0 0 10px rgba(128,128,128,0.5);padding:0 10px;-webkit-transition:all .3s ease-out;-moz-transition:all .3s ease-out;-o-transition:all .3s ease-out;transition:all .3s ease-out}.jsoneditor-contextmenu .jsoneditor-menu li ul .jsoneditor-icon{margin-left:24px}.jsoneditor-contextmenu .jsoneditor-menu li ul li button{padding-left:24px;animation:all ease-in-out 1s}.jsoneditor-contextmenu .jsoneditor-menu li button .jsoneditor-expand{position:absolute;top:0;right:0;width:24px;height:24px;padding:0;margin:0 4px 0 0;background:url("+a+") 0 -72px}.jsoneditor-contextmenu .jsoneditor-icon{position:absolute;top:0;left:0;width:24px;height:24px;border:0;padding:0;margin:0;background-image:url("+a+')}.jsoneditor-contextmenu .jsoneditor-text{padding:4px 0 4px 24px;word-wrap:break-word}.jsoneditor-contextmenu .jsoneditor-text.jsoneditor-right-margin{padding-right:24px}.jsoneditor-contextmenu .jsoneditor-separator{height:0;border-top:1px solid #e5e5e5;padding-top:5px;margin-top:5px}.jsoneditor-contextmenu button.jsoneditor-remove .jsoneditor-icon{background-position:-24px 0}.jsoneditor-contextmenu button.jsoneditor-append .jsoneditor-icon{background-position:0 0}.jsoneditor-contextmenu button.jsoneditor-insert .jsoneditor-icon{background-position:0 0}.jsoneditor-contextmenu button.jsoneditor-duplicate .jsoneditor-icon{background-position:-48px 0}.jsoneditor-contextmenu button.jsoneditor-sort-asc .jsoneditor-icon{background-position:-168px 0}.jsoneditor-contextmenu button.jsoneditor-sort-desc .jsoneditor-icon{background-position:-192px 0}.jsoneditor-contextmenu button.jsoneditor-transform .jsoneditor-icon{background-position:-216px 0}.jsoneditor-contextmenu button.jsoneditor-extract .jsoneditor-icon{background-position:0 -24px}.jsoneditor-contextmenu button.jsoneditor-type-string .jsoneditor-icon{background-position:-144px 0}.jsoneditor-contextmenu button.jsoneditor-type-auto .jsoneditor-icon{background-position:-120px 0}.jsoneditor-contextmenu button.jsoneditor-type-object .jsoneditor-icon{background-position:-72px 0}.jsoneditor-contextmenu button.jsoneditor-type-array .jsoneditor-icon{background-position:-96px 0}.jsoneditor-contextmenu button.jsoneditor-type-modes .jsoneditor-icon{background-image:none;width:6px}.jsoneditor-contextmenu ul,.jsoneditor-contextmenu li{box-sizing:content-box;position:relative}.jsoneditor-contextmenu .jsoneditor-menu button:hover,.jsoneditor-contextmenu .jsoneditor-menu button:focus{color:#1a1a1a;background-color:#f5f5f5;outline:0}.jsoneditor-contextmenu .jsoneditor-menu li button.jsoneditor-selected,.jsoneditor-contextmenu .jsoneditor-menu li button.jsoneditor-selected:hover,.jsoneditor-contextmenu .jsoneditor-menu li button.jsoneditor-selected:focus{color:#fff;background-color:#ee422e}.jsoneditor-contextmenu .jsoneditor-menu li ul li button:hover,.jsoneditor-contextmenu .jsoneditor-menu li ul li button:focus{background-color:#f5f5f5}.jsoneditor-modal{max-width:95%;border-radius:2px !important;padding:45px 15px 15px 15px !important;box-shadow:2px 2px 12px rgba(128,128,128,0.3);color:#4d4d4d;line-height:1.3em}.jsoneditor-modal.jsoneditor-modal-transform{width:600px !important}.jsoneditor-modal .pico-modal-header{position:absolute;box-sizing:border-box;top:0;left:0;width:100%;padding:0 10px;height:30px;line-height:30px;font-family:arial,sans-serif;font-size:11pt;background:#3883fa;color:#fff}.jsoneditor-modal table{width:100%}.jsoneditor-modal table td{padding:3px 0}.jsoneditor-modal table td.jsoneditor-modal-input{text-align:right;padding-right:0;white-space:nowrap}.jsoneditor-modal table td.jsoneditor-modal-actions{padding-top:15px}.jsoneditor-modal table th{vertical-align:middle}.jsoneditor-modal p:first-child{margin-top:0}.jsoneditor-modal a{color:#3883fa}.jsoneditor-modal .jsoneditor-jmespath-block{margin-bottom:10px}.jsoneditor-modal .pico-close{background:none !important;font-size:24px !important;top:7px !important;right:7px !important;color:#fff}.jsoneditor-modal input{padding:4px}.jsoneditor-modal input[type="text"]{cursor:inherit}.jsoneditor-modal input[disabled]{background:#d3d3d3;color:gray}.jsoneditor-modal .jsoneditor-select-wrapper{position:relative;display:inline-block}.jsoneditor-modal .jsoneditor-select-wrapper:after{content:"";width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:6px solid #666;position:absolute;right:8px;top:14px;pointer-events:none}.jsoneditor-modal select{padding:3px 24px 3px 10px;min-width:180px;max-width:350px;-webkit-appearance:none;-moz-appearance:none;appearance:none;text-indent:0;text-overflow:"";font-size:10pt;line-height:1.5em}.jsoneditor-modal select::-ms-expand{display:none}.jsoneditor-modal .jsoneditor-button-group input{padding:4px 10px;margin:0;border-radius:0;border-left-style:none}.jsoneditor-modal .jsoneditor-button-group input.jsoneditor-button-first{border-top-left-radius:3px;border-bottom-left-radius:3px;border-left-style:solid}.jsoneditor-modal .jsoneditor-button-group input.jsoneditor-button-last{border-top-right-radius:3px;border-bottom-right-radius:3px}.jsoneditor-modal .jsoneditor-transform-preview{background:#f5f5f5;height:200px}.jsoneditor-modal .jsoneditor-transform-preview.jsoneditor-error{color:#ee422e}.jsoneditor-modal .jsoneditor-jmespath-wizard{line-height:1.2em;width:100%;padding:0;border-radius:3px}.jsoneditor-modal .jsoneditor-jmespath-label{font-weight:bold;color:dodgerblue;margin-top:20px;margin-bottom:5px}.jsoneditor-modal .jsoneditor-jmespath-wizard-table{width:100%;border-collapse:collapse}.jsoneditor-modal .jsoneditor-jmespath-wizard-label{font-style:italic;margin:4px 0 2px 0}.jsoneditor-modal .jsoneditor-inline{position:relative;display:inline-block;width:100%;padding-top:2px;padding-bottom:2px}.jsoneditor-modal .jsoneditor-inline:not(:last-child){padding-right:2px}.jsoneditor-modal .jsoneditor-jmespath-filter{display:flex;flex-wrap:wrap}.jsoneditor-modal .jsoneditor-jmespath-filter-field{width:180px}.jsoneditor-modal .jsoneditor-jmespath-filter-relation{width:100px}.jsoneditor-modal .jsoneditor-jmespath-filter-value{min-width:180px;flex:1}.jsoneditor-modal .jsoneditor-jmespath-sort-field{width:170px}.jsoneditor-modal .jsoneditor-jmespath-sort-order{width:150px}.jsoneditor-modal .jsoneditor-jmespath-select-fields{width:100%}.jsoneditor-modal .selectr-selected{border-color:#d3d3d3;padding:4px 28px 4px 8px}.jsoneditor-modal .selectr-selected .selectr-tag{background-color:#3883fa;border-radius:5px}.jsoneditor-modal table th,.jsoneditor-modal table td{text-align:left;vertical-align:middle;font-weight:normal;color:#4d4d4d;border-spacing:0;border-collapse:collapse}.jsoneditor-modal select,.jsoneditor-modal textarea,.jsoneditor-modal input,.jsoneditor-modal #query{background:#fff;border:1px solid #d3d3d3;color:#4d4d4d;border-radius:3px;padding:4px}.jsoneditor-modal,.jsoneditor-modal table td,.jsoneditor-modal table th,.jsoneditor-modal select,.jsoneditor-modal option,.jsoneditor-modal textarea,.jsoneditor-modal input,.jsoneditor-modal #query{font-size:10.5pt;font-family:arial,sans-serif}.jsoneditor-modal #query,.jsoneditor-modal .jsoneditor-transform-preview{font-family:"dejavu sans mono","droid sans mono",consolas,monaco,"lucida console","courier new",courier,monospace,sans-serif;font-size:10pt;width:100%;box-sizing:border-box}.jsoneditor-modal input[type="button"],.jsoneditor-modal input[type="submit"]{background:#f5f5f5;padding:4px 20px}.jsoneditor-modal select,.jsoneditor-modal input{cursor:pointer}.jsoneditor-modal .jsoneditor-button-group.jsoneditor-button-group-value-asc input.jsoneditor-button-asc,.jsoneditor-modal .jsoneditor-button-group.jsoneditor-button-group-value-desc input.jsoneditor-button-desc{background:#3883fa;border-color:#3883fa;color:#fff}.jsoneditor-menu{width:100%;height:35px;padding:2px;margin:0;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;color:#fff;background-color:#3883fa;border-bottom:1px solid #3883fa}.jsoneditor-menu>button,.jsoneditor-menu>.jsoneditor-modes>button{width:26px;height:26px;margin:2px;padding:0;border-radius:2px;border:1px solid transparent;background:transparent url('+a+");color:#fff;opacity:.8;font-family:arial,sans-serif;font-size:10pt;float:left}.jsoneditor-menu>button:hover,.jsoneditor-menu>.jsoneditor-modes>button:hover{background-color:rgba(255,255,255,0.2);border:1px solid rgba(255,255,255,0.4)}.jsoneditor-menu>button:focus,.jsoneditor-menu>button:active,.jsoneditor-menu>.jsoneditor-modes>button:focus,.jsoneditor-menu>.jsoneditor-modes>button:active{background-color:rgba(255,255,255,0.3)}.jsoneditor-menu>button:disabled,.jsoneditor-menu>.jsoneditor-modes>button:disabled{opacity:.5;background-color:transparent;border:0}.jsoneditor-menu>button.jsoneditor-collapse-all{background-position:0 -96px}.jsoneditor-menu>button.jsoneditor-expand-all{background-position:0 -120px}.jsoneditor-menu>button.jsoneditor-sort{background-position:-120px -96px}.jsoneditor-menu>button.jsoneditor-transform{background-position:-144px -96px}.jsoneditor.jsoneditor-mode-view>.jsoneditor-menu>button.jsoneditor-sort,.jsoneditor.jsoneditor-mode-form>.jsoneditor-menu>button.jsoneditor-sort,.jsoneditor.jsoneditor-mode-view>.jsoneditor-menu>button.jsoneditor-transform,.jsoneditor.jsoneditor-mode-form>.jsoneditor-menu>button.jsoneditor-transform{display:none}.jsoneditor-menu>button.jsoneditor-undo{background-position:-24px -96px}.jsoneditor-menu>button.jsoneditor-undo:disabled{background-position:-24px -120px}.jsoneditor-menu>button.jsoneditor-redo{background-position:-48px -96px}.jsoneditor-menu>button.jsoneditor-redo:disabled{background-position:-48px -120px}.jsoneditor-menu>button.jsoneditor-compact{background-position:-72px -96px}.jsoneditor-menu>button.jsoneditor-format{background-position:-72px -120px}.jsoneditor-menu>button.jsoneditor-repair{background-position:-96px -96px}.jsoneditor-menu>.jsoneditor-modes{display:inline-block;float:left}.jsoneditor-menu>.jsoneditor-modes>button{background-image:none;width:auto;padding-left:6px;padding-right:6px}.jsoneditor-menu>button.jsoneditor-separator,.jsoneditor-menu>.jsoneditor-modes>button.jsoneditor-separator{margin-left:10px}.jsoneditor-menu a{font-family:arial,sans-serif;font-size:10pt;color:#fff;opacity:.8;vertical-align:middle}.jsoneditor-menu a:hover{opacity:1}.jsoneditor-menu a.jsoneditor-poweredBy{font-size:8pt;position:absolute;right:0;top:0;padding:10px}.jsoneditor-search{font-family:arial,sans-serif;position:absolute;right:4px;top:4px;border-collapse:collapse;border-spacing:0;display:flex}.jsoneditor-search input{color:#1a1a1a;width:120px;border:0;outline:0;margin:1px;line-height:20px}.jsoneditor-search button{width:16px;height:24px;padding:0;margin:0;border:0;background:url("+a+');vertical-align:top}.jsoneditor-search button:hover{background-color:transparent}.jsoneditor-search button.jsoneditor-refresh{width:18px;background-position:-99px -73px}.jsoneditor-search button.jsoneditor-next{cursor:pointer;background-position:-124px -73px}.jsoneditor-search button.jsoneditor-next:hover{background-position:-124px -49px}.jsoneditor-search button.jsoneditor-previous{cursor:pointer;background-position:-148px -73px;margin-right:2px}.jsoneditor-search button.jsoneditor-previous:hover{background-position:-148px -49px}.jsoneditor-results{font-family:arial,sans-serif;color:#fff;padding-right:5px;line-height:26px}.jsoneditor-frame{border:1px solid transparent;background-color:#fff;padding:0 2px;margin:0}.jsoneditor .autocomplete.dropdown{position:absolute;background:#fff;box-shadow:2px 2px 12px rgba(128,128,128,0.3);border:1px solid #d3d3d3;z-index:100;overflow-x:hidden;overflow-y:auto;cursor:default;margin:0;padding:5px;text-align:left;outline:0;font-family:"dejavu sans mono","droid sans mono",consolas,monaco,"lucida console","courier new",courier,monospace,sans-serif;font-size:10pt}.jsoneditor .autocomplete.dropdown .item{color:#333}.jsoneditor .autocomplete.dropdown .item.hover{background-color:#ddd}.jsoneditor .autocomplete.hint{color:#aaa;top:4px;left:4px}.jsoneditor-treepath{padding:0 5px;overflow:hidden;white-space:nowrap;outline:0}.jsoneditor-treepath.show-all{word-wrap:break-word;white-space:normal;position:absolute;background-color:#ebebeb;z-index:999;box-shadow:2px 2px 12px rgba(128,128,128,0.3)}.jsoneditor-treepath.show-all span.jsoneditor-treepath-show-all-btn{display:none}.jsoneditor-treepath div.jsoneditor-contextmenu-root{position:absolute;left:0}.jsoneditor-treepath .jsoneditor-treepath-show-all-btn{position:absolute;background-color:#ebebeb;left:0;height:20px;padding:0 3px;cursor:pointer}.jsoneditor-treepath .jsoneditor-treepath-element{margin:1px;font-family:arial,sans-serif;font-size:10pt}.jsoneditor-treepath .jsoneditor-treepath-seperator{margin:2px;font-size:9pt;font-family:arial,sans-serif}.jsoneditor-treepath span.jsoneditor-treepath-element:hover,.jsoneditor-treepath span.jsoneditor-treepath-seperator:hover{cursor:pointer;text-decoration:underline}.jsoneditor-statusbar{line-height:26px;height:26px;color:gray;background-color:#ebebeb;border-top:1px solid #d3d3d3;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;font-size:10pt}.jsoneditor-statusbar>.jsoneditor-curserinfo-val{margin-right:12px}.jsoneditor-statusbar>.jsoneditor-curserinfo-count{margin-left:4px}.jsoneditor-statusbar>.jsoneditor-validation-error-icon{float:right;width:24px;height:24px;padding:0;margin-top:1px;background:url('+a+") -168px -48px;cursor:pointer}.jsoneditor-statusbar>.jsoneditor-validation-error-count{float:right;margin:0 4px 0 0;cursor:pointer}.jsoneditor-statusbar>.jsoneditor-parse-error-icon{float:right;width:24px;height:24px;padding:0;margin:1px;background:url("+a+") -25px 0}.jsoneditor-statusbar .jsoneditor-array-info a{color:inherit}div.jsoneditor-statusbar>.jsoneditor-curserinfo-label,div.jsoneditor-statusbar>.jsoneditor-size-info{margin:0 4px}.jsoneditor-navigation-bar{width:100%;height:26px;line-height:26px;padding:0;margin:0;border-bottom:1px solid #d3d3d3;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;box-sizing:border-box;color:gray;background-color:#ebebeb;overflow:hidden;font-family:arial,sans-serif;font-size:10pt}/*!\n * Selectr 2.4.0\n * https://github.com/Mobius1/Selectr\n *\n * Released under the MIT license\n */.selectr-container{position:relative}.selectr-container li{list-style:none}.selectr-hidden{position:absolute;overflow:hidden;clip:rect(0,0,0,0);width:1px;height:1px;margin:-1px;padding:0;border:0 none}.selectr-visible{position:absolute;left:0;top:0;width:100%;height:100%;opacity:0;z-index:11}.selectr-desktop.multiple .selectr-visible{display:none}.selectr-desktop.multiple.native-open .selectr-visible{top:100%;min-height:200px !important;height:auto;opacity:1;display:block}.selectr-container.multiple.selectr-mobile .selectr-selected{z-index:0}.selectr-selected{position:relative;z-index:1;box-sizing:border-box;width:100%;padding:7px 28px 7px 14px;cursor:pointer;border:1px solid #999;border-radius:3px;background-color:#fff}.selectr-selected::before{position:absolute;top:50%;right:10px;width:0;height:0;content:'';-o-transform:rotate(0) translate3d(0,-50%,0);-ms-transform:rotate(0) translate3d(0,-50%,0);-moz-transform:rotate(0) translate3d(0,-50%,0);-webkit-transform:rotate(0) translate3d(0,-50%,0);transform:rotate(0) translate3d(0,-50%,0);border-width:4px 4px 0 4px;border-style:solid;border-color:#6c7a86 transparent transparent}.selectr-container.open .selectr-selected::before,.selectr-container.native-open .selectr-selected::before{border-width:0 4px 4px 4px;border-style:solid;border-color:transparent transparent #6c7a86}.selectr-label{display:none;overflow:hidden;width:100%;white-space:nowrap;text-overflow:ellipsis}.selectr-placeholder{color:#6c7a86}.selectr-tags{margin:0;padding:0;white-space:normal}.has-selected .selectr-tags{margin:0 0 -2px}.selectr-tag{list-style:none;position:relative;float:left;padding:2px 25px 2px 8px;margin:0 2px 2px 0;cursor:default;color:#fff;border:medium none;border-radius:10px;background:#acb7bf none repeat scroll 0 0}.selectr-container.multiple.has-selected .selectr-selected{padding:5px 28px 5px 5px}.selectr-options-container{position:absolute;z-index:10000;top:calc(100% - 1px);left:0;display:none;box-sizing:border-box;width:100%;border-width:0 1px 1px;border-style:solid;border-color:transparent #999 #999;border-radius:0 0 3px 3px;background-color:#fff}.selectr-container.open .selectr-options-container{display:block}.selectr-input-container{position:relative;display:none}.selectr-clear,.selectr-input-clear,.selectr-tag-remove{position:absolute;top:50%;right:22px;width:20px;height:20px;padding:0;cursor:pointer;-o-transform:translate3d(0,-50%,0);-ms-transform:translate3d(0,-50%,0);-moz-transform:translate3d(0,-50%,0);-webkit-transform:translate3d(0,-50%,0);transform:translate3d(0,-50%,0);border:medium none;background-color:transparent;z-index:11}.selectr-clear,.selectr-input-clear{display:none}.selectr-container.has-selected .selectr-clear,.selectr-input-container.active .selectr-input-clear{display:block}.selectr-selected .selectr-tag-remove{right:2px}.selectr-clear::before,.selectr-clear::after,.selectr-input-clear::before,.selectr-input-clear::after,.selectr-tag-remove::before,.selectr-tag-remove::after{position:absolute;top:5px;left:9px;width:2px;height:10px;content:' ';background-color:#6c7a86}.selectr-tag-remove::before,.selectr-tag-remove::after{top:4px;width:3px;height:12px;background-color:#fff}.selectr-clear:before,.selectr-input-clear::before,.selectr-tag-remove::before{-o-transform:rotate(45deg);-ms-transform:rotate(45deg);-moz-transform:rotate(45deg);-webkit-transform:rotate(45deg);transform:rotate(45deg)}.selectr-clear:after,.selectr-input-clear::after,.selectr-tag-remove::after{-o-transform:rotate(-45deg);-ms-transform:rotate(-45deg);-moz-transform:rotate(-45deg);-webkit-transform:rotate(-45deg);transform:rotate(-45deg)}.selectr-input-container.active,.selectr-input-container.active .selectr-clear{display:block}.selectr-input{top:5px;left:5px;box-sizing:border-box;width:calc(100% - 30px);margin:10px 15px;padding:7px 30px 7px 9px;border:1px solid #999;border-radius:3px}.selectr-notice{display:none;box-sizing:border-box;width:100%;padding:8px 16px;border-top:1px solid #999;border-radius:0 0 3px 3px;background-color:#fff}.selectr-container.notice .selectr-notice{display:block}.selectr-container.notice .selectr-selected{border-radius:3px 3px 0 0}.selectr-options{position:relative;top:calc(100% + 2px);display:none;overflow-x:auto;overflow-y:scroll;max-height:200px;margin:0;padding:0}.selectr-container.open .selectr-options,.selectr-container.open .selectr-input-container,.selectr-container.notice .selectr-options-container{display:block}.selectr-option{position:relative;display:block;padding:5px 20px;list-style:outside none none;cursor:pointer;font-weight:normal}.selectr-options.optgroups>.selectr-option{padding-left:25px}.selectr-optgroup{font-weight:bold;padding:0}.selectr-optgroup--label{font-weight:bold;margin-top:10px;padding:5px 15px}.selectr-match{text-decoration:underline}.selectr-option.selected{background-color:#ddd}.selectr-option.active{color:#fff;background-color:#5897fb}.selectr-option.disabled{opacity:.4}.selectr-option.excluded{display:none}.selectr-container.open .selectr-selected{border-color:#999 #999 transparent #999;border-radius:3px 3px 0 0}.selectr-container.open .selectr-selected::after{-o-transform:rotate(180deg) translate3d(0,50%,0);-ms-transform:rotate(180deg) translate3d(0,50%,0);-moz-transform:rotate(180deg) translate3d(0,50%,0);-webkit-transform:rotate(180deg) translate3d(0,50%,0);transform:rotate(180deg) translate3d(0,50%,0)}.selectr-disabled{opacity:.6}.selectr-empty,.has-selected .selectr-placeholder{display:none}.has-selected .selectr-label{display:block}.taggable .selectr-selected{padding:4px 28px 4px 4px}.taggable .selectr-selected::after{display:table;content:\" \";clear:both}.taggable .selectr-label{width:auto}.taggable .selectr-tags{float:left;display:block}.taggable .selectr-placeholder{display:none}.input-tag{float:left;min-width:90px;width:auto}.selectr-tag-input{border:medium none;padding:3px 10px;width:100%;font-family:inherit;font-weight:inherit;font-size:inherit}.selectr-input-container.loading::after{position:absolute;top:50%;right:20px;width:20px;height:20px;content:'';-o-transform:translate3d(0,-50%,0);-ms-transform:translate3d(0,-50%,0);-moz-transform:translate3d(0,-50%,0);-webkit-transform:translate3d(0,-50%,0);transform:translate3d(0,-50%,0);-o-transform-origin:50% 0 0;-ms-transform-origin:50% 0 0;-moz-transform-origin:50% 0 0;-webkit-transform-origin:50% 0 0;transform-origin:50% 0 0;-moz-animation:500ms linear 0s normal forwards infinite running spin;-webkit-animation:500ms linear 0s normal forwards infinite running spin;animation:500ms linear 0s normal forwards infinite running spin;border-width:3px;border-style:solid;border-color:#aaa #ddd #ddd;border-radius:50%}@-webkit-keyframes spin{0%{-webkit-transform:rotate(0) translate3d(0,-50%,0);transform:rotate(0) translate3d(0,-50%,0)}100%{-webkit-transform:rotate(360deg) translate3d(0,-50%,0);transform:rotate(360deg) translate3d(0,-50%,0)}}@keyframes spin{0%{-webkit-transform:rotate(0) translate3d(0,-50%,0);transform:rotate(0) translate3d(0,-50%,0)}100%{-webkit-transform:rotate(360deg) translate3d(0,-50%,0);transform:rotate(360deg) translate3d(0,-50%,0)}}.selectr-container.open.inverted .selectr-selected{border-color:transparent #999 #999;border-radius:0 0 3px 3px}.selectr-container.inverted .selectr-options-container{border-width:1px 1px 0;border-color:#999 #999 transparent;border-radius:3px 3px 0 0;background-color:#fff}.selectr-container.inverted .selectr-options-container{top:auto;bottom:calc(100% - 1px)}.selectr-container ::-webkit-input-placeholder{color:#6c7a86;opacity:1}.selectr-container ::-moz-placeholder{color:#6c7a86;opacity:1}.selectr-container :-ms-input-placeholder{color:#6c7a86;opacity:1}.selectr-container ::placeholder{color:#6c7a86;opacity:1}\n",""]),e.exports=t},Q1l4:function(e,t){e.exports=function(e,t){var n=-1,r=e.length;for(t||(t=Array(r));++n<r;)t[n]=e[n];return t}},QCnb:function(e,t,n){"use strict";e.exports=n("+wdc")},QILm:function(e,t,n){var r=n("8OQS");e.exports=function(e,t){if(null==e)return{};var n,i,o=r(e,t);if(Object.getOwnPropertySymbols){var a=Object.getOwnPropertySymbols(e);for(i=0;i<a.length;i++)n=a[i],t.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(e,n)&&(o[n]=e[n])}return o},e.exports.default=e.exports,e.exports.__esModule=!0},QIyF:function(e,t,n){var r=n("Kz5y");e.exports=function(){return r.Date.now()}},QRi6:function(e,t){e.exports=function(e,t){var n,r,i=e.x,o=e.y,a=t.x-i,s=t.y-o,c=e.width/2,l=e.height/2;Math.abs(s)*c>Math.abs(a)*l?(s<0&&(l=-l),n=0===s?0:l*a/s,r=l):(a<0&&(c=-c),n=c,r=0===a?0:c*s/a);return{x:i+n,y:o+r}}},QcOe:function(e,t,n){var r=n("GoyQ"),i=n("6sVZ"),o=n("7Ix3"),a=Object.prototype.hasOwnProperty;e.exports=function(e){if(!r(e))return o(e);var t=i(e),n=[];for(var s in e)("constructor"!=s||!t&&a.call(e,s))&&n.push(s);return n}},QkVE:function(e,t,n){var r=n("EpBk");e.exports=function(e,t){var n=e.__data__;return r(t)?n["string"==typeof t?"string":"hash"]:n.map}},QkVN:function(e,t,n){var r=n("+Qka"),i=n("LsHQ")((function(e,t,n){r(e,t,n)}));e.exports=i},QoRX:function(e,t){e.exports=function(e,t){for(var n=-1,r=null==e?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}},QqLw:function(e,t,n){var r=n("tadb"),i=n("ebwN"),o=n("HOxn"),a=n("yGk4"),s=n("Of+w"),c=n("NykK"),l=n("3Fdi"),u=l(r),h=l(i),d=l(o),f=l(a),p=l(s),m=c;(r&&"[object DataView]"!=m(new r(new ArrayBuffer(1)))||i&&"[object Map]"!=m(new i)||o&&"[object Promise]"!=m(o.resolve())||a&&"[object Set]"!=m(new a)||s&&"[object WeakMap]"!=m(new s))&&(m=function(e){var t=c(e),n="[object Object]"==t?e.constructor:void 0,r=n?l(n):"";if(r)switch(r){case u:return"[object DataView]";case h:return"[object Map]";case d:return"[object Promise]";case f:return"[object Set]";case p:return"[object WeakMap]"}return t}),e.exports=m},"R/W3":function(e,t,n){var r=n("KwMD"),i=n("2ajD"),o=n("CZoQ");e.exports=function(e,t,n){return t==t?o(e,t,n):r(e,i,n)}},R155:function(e,t,n){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r=function(e){if(e&&e.__esModule)return e;if(null===e||"object"!==d(e)&&"function"!=typeof e)return{default:e};var t=h();if(t&&t.has(e))return t.get(e);var n={},r=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var i in e)if(Object.prototype.hasOwnProperty.call(e,i)){var o=r?Object.getOwnPropertyDescriptor(e,i):null;o&&(o.get||o.set)?Object.defineProperty(n,i,o):n[i]=e[i]}n.default=e,t&&t.set(e,n);return n}(n("q1tI")),i=u(n("17x9")),o=u(n("i8i4")),a=n("8N4D"),s=n("fJi3"),c=n("gbW8"),l=u(n("sS6v"));function u(e){return e&&e.__esModule?e:{default:e}}function h(){if("function"!=typeof WeakMap)return null;var e=new WeakMap;return h=function(){return e},e}function d(e){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function f(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){if("undefined"==typeof Symbol||!(Symbol.iterator in Object(e)))return;var n=[],r=!0,i=!1,o=void 0;try{for(var a,s=e[Symbol.iterator]();!(r=(a=s.next()).done)&&(n.push(a.value),!t||n.length!==t);r=!0);}catch(e){i=!0,o=e}finally{try{r||null==s.return||s.return()}finally{if(i)throw o}}return n}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return p(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);"Object"===n&&e.constructor&&(n=e.constructor.name);if("Map"===n||"Set"===n)return Array.from(e);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return p(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function p(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function m(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function g(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function v(e,t){return(v=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e})(e,t)}function y(e){var t=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],(function(){}))),!0}catch(e){return!1}}();return function(){var n,r=x(e);if(t){var i=x(this).constructor;n=Reflect.construct(r,arguments,i)}else n=r.apply(this,arguments);return b(this,n)}}function b(e,t){return!t||"object"!==d(t)&&"function"!=typeof t?w(e):t}function w(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function x(e){return(x=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function _(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}var E={start:"touchstart",move:"touchmove",stop:"touchend"},S={start:"mousedown",move:"mousemove",stop:"mouseup"},C=S,A=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&v(e,t)}(u,e);var t,n,i,c=y(u);function u(){var e;m(this,u);for(var t=arguments.length,n=new Array(t),r=0;r<t;r++)n[r]=arguments[r];return _(w(e=c.call.apply(c,[this].concat(n))),"state",{dragging:!1,lastX:NaN,lastY:NaN,touchIdentifier:null}),_(w(e),"mounted",!1),_(w(e),"handleDragStart",(function(t){if(e.props.onMouseDown(t),!e.props.allowAnyClick&&"number"==typeof t.button&&0!==t.button)return!1;var n=e.findDOMNode();if(!n||!n.ownerDocument||!n.ownerDocument.body)throw new Error("<DraggableCore> not mounted on DragStart!");var r=n.ownerDocument;if(!(e.props.disabled||!(t.target instanceof r.defaultView.Node)||e.props.handle&&!(0,a.matchesSelectorAndParentsTo)(t.target,e.props.handle,n)||e.props.cancel&&(0,a.matchesSelectorAndParentsTo)(t.target,e.props.cancel,n))){"touchstart"===t.type&&t.preventDefault();var i=(0,a.getTouchIdentifier)(t);e.setState({touchIdentifier:i});var o=(0,s.getControlPosition)(t,i,w(e));if(null!=o){var c=o.x,u=o.y,h=(0,s.createCoreData)(w(e),c,u);(0,l.default)("DraggableCore: handleDragStart: %j",h),(0,l.default)("calling",e.props.onStart),!1!==e.props.onStart(t,h)&&!1!==e.mounted&&(e.props.enableUserSelectHack&&(0,a.addUserSelectStyles)(r),e.setState({dragging:!0,lastX:c,lastY:u}),(0,a.addEvent)(r,C.move,e.handleDrag),(0,a.addEvent)(r,C.stop,e.handleDragStop))}}})),_(w(e),"handleDrag",(function(t){var n=(0,s.getControlPosition)(t,e.state.touchIdentifier,w(e));if(null!=n){var r=n.x,i=n.y;if(Array.isArray(e.props.grid)){var o=r-e.state.lastX,a=i-e.state.lastY,c=f((0,s.snapToGrid)(e.props.grid,o,a),2);if(o=c[0],a=c[1],!o&&!a)return;r=e.state.lastX+o,i=e.state.lastY+a}var u=(0,s.createCoreData)(w(e),r,i);if((0,l.default)("DraggableCore: handleDrag: %j",u),!1!==e.props.onDrag(t,u)&&!1!==e.mounted)e.setState({lastX:r,lastY:i});else try{e.handleDragStop(new MouseEvent("mouseup"))}catch(t){var h=document.createEvent("MouseEvents");h.initMouseEvent("mouseup",!0,!0,window,0,0,0,0,0,!1,!1,!1,!1,0,null),e.handleDragStop(h)}}})),_(w(e),"handleDragStop",(function(t){if(e.state.dragging){var n=(0,s.getControlPosition)(t,e.state.touchIdentifier,w(e));if(null!=n){var r=n.x,i=n.y,o=(0,s.createCoreData)(w(e),r,i);if(!1===e.props.onStop(t,o)||!1===e.mounted)return!1;var c=e.findDOMNode();c&&e.props.enableUserSelectHack&&(0,a.removeUserSelectStyles)(c.ownerDocument),(0,l.default)("DraggableCore: handleDragStop: %j",o),e.setState({dragging:!1,lastX:NaN,lastY:NaN}),c&&((0,l.default)("DraggableCore: Removing handlers"),(0,a.removeEvent)(c.ownerDocument,C.move,e.handleDrag),(0,a.removeEvent)(c.ownerDocument,C.stop,e.handleDragStop))}}})),_(w(e),"onMouseDown",(function(t){return C=S,e.handleDragStart(t)})),_(w(e),"onMouseUp",(function(t){return C=S,e.handleDragStop(t)})),_(w(e),"onTouchStart",(function(t){return C=E,e.handleDragStart(t)})),_(w(e),"onTouchEnd",(function(t){return C=E,e.handleDragStop(t)})),e}return t=u,(n=[{key:"componentDidMount",value:function(){this.mounted=!0;var e=this.findDOMNode();e&&(0,a.addEvent)(e,E.start,this.onTouchStart,{passive:!1})}},{key:"componentWillUnmount",value:function(){this.mounted=!1;var e=this.findDOMNode();if(e){var t=e.ownerDocument;(0,a.removeEvent)(t,S.move,this.handleDrag),(0,a.removeEvent)(t,E.move,this.handleDrag),(0,a.removeEvent)(t,S.stop,this.handleDragStop),(0,a.removeEvent)(t,E.stop,this.handleDragStop),(0,a.removeEvent)(e,E.start,this.onTouchStart,{passive:!1}),this.props.enableUserSelectHack&&(0,a.removeUserSelectStyles)(t)}}},{key:"findDOMNode",value:function(){return this.props.nodeRef?this.props.nodeRef.current:o.default.findDOMNode(this)}},{key:"render",value:function(){return r.cloneElement(r.Children.only(this.props.children),{onMouseDown:this.onMouseDown,onMouseUp:this.onMouseUp,onTouchEnd:this.onTouchEnd})}}])&&g(t.prototype,n),i&&g(t,i),u}(r.Component);t.default=A,_(A,"displayName","DraggableCore"),_(A,"propTypes",{allowAnyClick:i.default.bool,disabled:i.default.bool,enableUserSelectHack:i.default.bool,offsetParent:function(e,t){if(e[t]&&1!==e[t].nodeType)throw new Error("Draggable's offsetParent must be a DOM Node.")},grid:i.default.arrayOf(i.default.number),handle:i.default.string,cancel:i.default.string,nodeRef:i.default.object,onStart:i.default.func,onDrag:i.default.func,onStop:i.default.func,onMouseDown:i.default.func,scale:i.default.number,className:c.dontSetMe,style:c.dontSetMe,transform:c.dontSetMe}),_(A,"defaultProps",{allowAnyClick:!1,cancel:null,disabled:!1,enableUserSelectHack:!0,offsetParent:null,handle:null,grid:null,transform:null,onStart:function(){},onDrag:function(){},onStop:function(){},onMouseDown:function(){},scale:1})},R5Y4:function(e,t){var n=Math.ceil,r=Math.max;e.exports=function(e,t,i,o){for(var a=-1,s=r(n((t-e)/(i||1)),0),c=Array(s);s--;)c[o?s:++a]=e,e+=i;return c}},RBan:function(e,t){e.exports=function(e){var t=null==e?0:e.length;return t?e[t-1]:void 0}},"RF+X":function(e,t){function n(e,t){return e*t>0}e.exports=function(e,t,r,i){var o,a,s,c,l,u,h,d,f,p,m,g,v;if(o=t.y-e.y,s=e.x-t.x,l=t.x*e.y-e.x*t.y,f=o*r.x+s*r.y+l,p=o*i.x+s*i.y+l,0!==f&&0!==p&&n(f,p))return;if(a=i.y-r.y,c=r.x-i.x,u=i.x*r.y-r.x*i.y,h=a*e.x+c*e.y+u,d=a*t.x+c*t.y+u,0!==h&&0!==d&&n(h,d))return;if(0===(m=o*c-a*s))return;return g=Math.abs(m/2),{x:(v=s*u-c*l)<0?(v-g)/m:(v+g)/m,y:(v=a*l-o*u)<0?(v-g)/m:(v+g)/m}}},RIqP:function(e,t,n){var r=n("Ijbi"),i=n("EbDI"),o=n("ZhPi"),a=n("Bnag");e.exports=function(e){return r(e)||i(e)||o(e)||a()},e.exports.default=e.exports,e.exports.__esModule=!0},RSXs:function(e,t,n){"use strict";var r=n("RsFJ"),i=n("ZONP"),o=n("3GlI"),a=n("KJAg");e.exports=function(e,t,n){var s,c,l,u,h,d=this.options,f=d.commonmark,p=d.gfm,m=this.blockTokenizers,g=this.interruptParagraph,v=t.indexOf("\n"),y=t.length;for(;v<y;){if(-1===v){v=y;break}if("\n"===t.charAt(v+1))break;if(f){for(u=0,s=v+1;s<y;){if("\t"===(l=t.charAt(s))){u=4;break}if(" "!==l)break;u++,s++}if(u>=4){v=t.indexOf("\n",v+1);continue}}if(c=t.slice(v+1),a(g,m,this,[e,c,!0]))break;if(m.list.call(this,e,c,!0)&&(this.inList||f||p&&!i(r.left(c).charAt(0))))break;if(s=v,-1!==(v=t.indexOf("\n",v+1))&&""===r(t.slice(s,v))){v=s;break}}if(c=t.slice(0,v),""===r(c))return e(c),null;if(n)return!0;return h=e.now(),c=o(c),e(c)({type:"paragraph",children:this.tokenizeInline(c,h)})}},RYnF:function(e,t){function n(){var e={};e._next=e._prev=e,this._sentinel=e}function r(e){e._prev._next=e._next,e._next._prev=e._prev,delete e._next,delete e._prev}function i(e,t){if("_next"!==e&&"_prev"!==e)return t}e.exports=n,n.prototype.dequeue=function(){var e=this._sentinel,t=e._prev;if(t!==e)return r(t),t},n.prototype.enqueue=function(e){var t=this._sentinel;e._prev&&e._next&&r(e),e._next=t._next,t._next._prev=e,t._next=e,e._prev=t},n.prototype.toString=function(){for(var e=[],t=this._sentinel,n=t._prev;n!==t;)e.push(JSON.stringify(n,i)),n=n._prev;return"["+e.join(", ")+"]"}},Re5C:function(e,t,n){"use strict";var r=n("b5wT"),i=n("tQ6r");e.exports={run:function(e){e.graph().dummyChains=[],r.forEach(e.edges(),(function(t){!function(e,t){var n,r,o,a=t.v,s=e.node(a).rank,c=t.w,l=e.node(c).rank,u=t.name,h=e.edge(t),d=h.labelRank;if(l===s+1)return;for(e.removeEdge(t),o=0,++s;s<l;++o,++s)h.points=[],r={width:0,height:0,edgeLabel:h,edgeObj:t,rank:s},n=i.addDummyNode(e,"edge",r,"_d"),s===d&&(r.width=h.width,r.height=h.height,r.dummy="edge-label",r.labelpos=h.labelpos),e.setEdge(a,n,{weight:h.weight},u),0===o&&e.graph().dummyChains.push(n),a=n;e.setEdge(a,c,{weight:h.weight},u)}(e,t)}))},undo:function(e){r.forEach(e.graph().dummyChains,(function(t){var n,r=e.node(t),i=r.edgeLabel;for(e.setEdge(r.edgeObj,i);r.dummy;)n=e.successors(t)[0],e.removeNode(t),i.points.push({x:r.x,y:r.y}),"edge-label"===r.dummy&&(i.x=r.x,i.y=r.y,i.width=r.width,i.height=r.height),t=n,r=e.node(t)}))}}},Rh56:function(e,t,n){"use strict";var r=n("ABHV"),i=n("ztPK"),o=n("aTrP"),a=null;"undefined"!=typeof bson&&(a=bson().BSON),e.exports=function(e){function t(t){"publish"===t.op?e.emit(t.topic,t.msg):"service_response"===t.op?e.emit(t.id,t):"call_service"===t.op?e.emit(t.service,t):"status"===t.op&&(t.id?e.emit("status:"+t.id,t):e.emit("status",t))}function n(e,t){"png"===e.op?r(e.data,t):t(e)}return{onopen:function(t){e.isConnected=!0,e.emit("connection",t)},onclose:function(t){e.isConnected=!1,e.emit("close",t)},onerror:function(t){e.emit("error",t)},onmessage:function(e){if("undefined"!=typeof Blob&&e.data instanceof Blob)!function(e,t){if(!a)throw"Cannot process BSON encoded message without BSON header.";var n=new FileReader;n.onload=function(){var e=new Uint8Array(this.result),n=a.deserialize(e);t(n)},n.readAsArrayBuffer(e)}(e.data,(function(e){n(e,t)}));else if(e.data instanceof ArrayBuffer){t(i.decode(e.data,o))}else{n(JSON.parse("string"==typeof e?e:e.data),t)}}}}},RjOF:function(e,t,n){"use strict";
/*!
 * repeat-string <https://github.com/jonschlinkert/repeat-string>
 *
 * Copyright (c) 2014-2015, Jon Schlinkert.
 * Licensed under the MIT License.
 */var r,i="";e.exports=function(e,t){if("string"!=typeof e)throw new TypeError("expected a string");if(1===t)return e;if(2===t)return e+e;var n=e.length*t;if(r!==e||void 0===r)r=e,i="";else if(i.length>=n)return i.substr(0,n);for(;n>i.length&&t>1;)1&t&&(i+=e),t>>=1,e+=e;return i=(i+=e).substr(0,n)}},RsFJ:function(e,t){(t=e.exports=function(e){return e.replace(/^\s*|\s*$/g,"")}).left=function(e){return e.replace(/^\s*/,"")},t.right=function(e){return e.replace(/\s*$/,"")}},SKAX:function(e,t,n){var r=n("JC6p"),i=n("lQqw")(r);e.exports=i},SbiQ:function(e,t,n){"use strict";e.exports=function(e,t,n){var r,i,o,a,s,c,l,u,h,d;if(n)return!0;r=this.inlineMethods,a=r.length,i=this.inlineTokenizers,o=-1,h=t.length;for(;++o<a;)"text"!==(u=r[o])&&i[u]&&((l=i[u].locator)||e.file.fail("Missing locator: `"+u+"`"),-1!==(c=l.call(this,t,1))&&c<h&&(h=c));s=t.slice(0,h),d=e.now(),this.decode(s,d,(function(t,n,r){e(r||t)({type:"text",value:t})}))}},Sdz8:function(e,t){e.exports=function(e,t,n,r){var i=e.x,o=e.y,a=i-r.x,s=o-r.y,c=Math.sqrt(t*t*s*s+n*n*a*a),l=Math.abs(t*n*a/c);r.x<i&&(l=-l);var u=Math.abs(t*n*s/c);r.y<o&&(u=-u);return{x:i+l,y:o+u}}},SfRM:function(e,t,n){var r=n("YESw");e.exports=function(){this.__data__=r?r(null):{},this.size=0}},SksO:function(e,t){function n(t,r){return e.exports=n=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},e.exports.default=e.exports,e.exports.__esModule=!0,n(t,r)}e.exports=n,e.exports.default=e.exports,e.exports.__esModule=!0},Sxd8:function(e,t,n){var r=n("ZCgT");e.exports=function(e){var t=r(e),n=t%1;return t==t?n?t-n:t:0}},T1AV:function(e,t,n){var r=n("t2Dn"),i=n("5Tg0"),o=n("yP5f"),a=n("Q1l4"),s=n("+iFO"),c=n("03A+"),l=n("Z0cm"),u=n("3L66"),h=n("DSRE"),d=n("lSCD"),f=n("GoyQ"),p=n("YO3V"),m=n("c6wG"),g=n("itsj"),v=n("jeLo");e.exports=function(e,t,n,y,b,w,x){var _=g(e,n),E=g(t,n),S=x.get(E);if(S)r(e,n,S);else{var C=w?w(_,E,n+"",e,t,x):void 0,A=void 0===C;if(A){var T=l(E),M=!T&&h(E),O=!T&&!M&&m(E);C=E,T||M||O?l(_)?C=_:u(_)?C=a(_):M?(A=!1,C=i(E,!0)):O?(A=!1,C=o(E,!0)):C=[]:p(E)||c(E)?(C=_,c(_)?C=v(_):f(_)&&!d(_)||(C=s(E))):A=!1}A&&(x.set(E,C),b(C,E,y,w,x),x.delete(E)),r(e,n,C)}}},TAZq:function(e,t,n){e.exports=function(){"use strict";return function(e){function t(t){if(t)try{e(t+"}")}catch(e){}}return function(n,r,i,o,a,s,c,l,u,h){switch(n){case 1:if(0===u&&64===r.charCodeAt(0))return e(r+";"),"";break;case 2:if(0===l)return r+"/*|*/";break;case 3:switch(l){case 102:case 112:return e(i[0]+r),"";default:return r+(0===h?"/*|*/":"")}case-2:r.split("/*|*/}").forEach(t)}}}}()},TO8r:function(e,t){var n=/\s/;e.exports=function(e){for(var t=e.length;t--&&n.test(e.charAt(t)););return t}},TOwV:function(e,t,n){"use strict";e.exports=n("qT12")},TP7S:function(e,t){e.exports=function(e){return void 0===e}},TSYQ:function(e,t,n){var r;
/*!
  Copyright (c) 2018 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/!function(){"use strict";var n={}.hasOwnProperty;function i(){for(var e=[],t=0;t<arguments.length;t++){var r=arguments[t];if(r){var o=typeof r;if("string"===o||"number"===o)e.push(r);else if(Array.isArray(r)){if(r.length){var a=i.apply(null,r);a&&e.push(a)}}else if("object"===o)if(r.toString===Object.prototype.toString)for(var s in r)n.call(r,s)&&r[s]&&e.push(s);else e.push(r.toString())}}return e.join(" ")}e.exports?(i.default=i,e.exports=i):void 0===(r=function(){return i}.apply(t,[]))||(e.exports=r)}()},TYy9:function(e,t,n){var r=n("XGnz");e.exports=function(e){return(null==e?0:e.length)?r(e,1):[]}},TjP8:function(e,t,n){"use strict";var r="<[A-Za-z][A-Za-z0-9\\-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\u0000-\\u0020]+|'[^']*'|\"[^\"]*\"))?)*\\s*\\/?>",i="<\\/[A-Za-z][A-Za-z0-9\\-]*\\s*>";t.openCloseTag=new RegExp("^(?:"+r+"|"+i+")"),t.tag=new RegExp("^(?:"+r+"|"+i+"|\x3c!----\x3e|\x3c!--(?:-?[^>-])(?:-?[^-])*--\x3e|<[?].*?[?]>|<![A-Za-z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)")},Txda:function(e,t,n){var r=n("3y7U");e.exports=function(e,t){return r(e,t,"post")}},U1bi:function(e,t,n){var r=n("Uks8"),i=n("Rh56"),o=n("US93"),a=n("kAvd"),s=n("MgzW"),c=n("cjKa").EventEmitter2;function l(e){e=e||{},this.socket=null,this.idCounter=0,this.isConnected=!1,this.transportLibrary=e.transportLibrary||"websocket",this.transportOptions=e.transportOptions||{},void 0===e.groovyCompatibility?this.groovyCompatibility=!0:this.groovyCompatibility=e.groovyCompatibility,this.setMaxListeners(0),e.url&&this.connect(e.url)}l.prototype.__proto__=c.prototype,l.prototype.connect=function(e){if("socket.io"===this.transportLibrary)this.socket=s(io(e,{"force new connection":!0}),i(this)),this.socket.on("connect",this.socket.onopen),this.socket.on("data",this.socket.onmessage),this.socket.on("close",this.socket.onclose),this.socket.on("error",this.socket.onerror);else if("RTCPeerConnection"===this.transportLibrary.constructor.name)this.socket=s(this.transportLibrary.createDataChannel(e,this.transportOptions),i(this));else if("websocket"===this.transportLibrary){if(!this.socket||this.socket.readyState===WebSocket.CLOSED){var t=new WebSocket(e);t.binaryType="arraybuffer",this.socket=s(t,i(this))}}else{if("workersocket"!==this.transportLibrary)throw"Unknown transportLibrary: "+this.transportLibrary.toString();this.socket=s(new r(e),i(this))}},l.prototype.close=function(){this.socket&&this.socket.close()},l.prototype.authenticate=function(e,t,n,r,i,o,a){var s={op:"auth",mac:e,client:t,dest:n,rand:r,t:i,level:o,end:a};this.callOnConnection(s)},l.prototype.callOnConnection=function(e){var t=this,n=JSON.stringify(e),r=null;r="socket.io"===this.transportLibrary?function(e){t.socket.emit("operation",e)}:function(e){t.socket.send(e)},this.isConnected?r(n):t.once("connection",(function(){r(n)}))},l.prototype.setStatusLevel=function(e,t){var n={op:"set_level",level:e,id:t};this.callOnConnection(n)},l.prototype.getActionServers=function(e,t){var n=new o({ros:this,name:"/rosapi/action_servers",serviceType:"rosapi/GetActionServers"}),r=new a({});"function"==typeof t?n.callService(r,(function(t){e(t.action_servers)}),(function(e){t(e)})):n.callService(r,(function(t){e(t.action_servers)}))},l.prototype.getTopics=function(e,t){var n=new o({ros:this,name:"/rosapi/topics",serviceType:"rosapi/Topics"}),r=new a;"function"==typeof t?n.callService(r,(function(t){e(t)}),(function(e){t(e)})):n.callService(r,(function(t){e(t)}))},l.prototype.getTopicsForType=function(e,t,n){var r=new o({ros:this,name:"/rosapi/topics_for_type",serviceType:"rosapi/TopicsForType"}),i=new a({type:e});"function"==typeof n?r.callService(i,(function(e){t(e.topics)}),(function(e){n(e)})):r.callService(i,(function(e){t(e.topics)}))},l.prototype.getServices=function(e,t){var n=new o({ros:this,name:"/rosapi/services",serviceType:"rosapi/Services"}),r=new a;"function"==typeof t?n.callService(r,(function(t){e(t.services)}),(function(e){t(e)})):n.callService(r,(function(t){e(t.services)}))},l.prototype.getServicesForType=function(e,t,n){var r=new o({ros:this,name:"/rosapi/services_for_type",serviceType:"rosapi/ServicesForType"}),i=new a({type:e});"function"==typeof n?r.callService(i,(function(e){t(e.services)}),(function(e){n(e)})):r.callService(i,(function(e){t(e.services)}))},l.prototype.getServiceRequestDetails=function(e,t,n){var r=new o({ros:this,name:"/rosapi/service_request_details",serviceType:"rosapi/ServiceRequestDetails"}),i=new a({type:e});"function"==typeof n?r.callService(i,(function(e){t(e)}),(function(e){n(e)})):r.callService(i,(function(e){t(e)}))},l.prototype.getServiceResponseDetails=function(e,t,n){var r=new o({ros:this,name:"/rosapi/service_response_details",serviceType:"rosapi/ServiceResponseDetails"}),i=new a({type:e});"function"==typeof n?r.callService(i,(function(e){t(e)}),(function(e){n(e)})):r.callService(i,(function(e){t(e)}))},l.prototype.getNodes=function(e,t){var n=new o({ros:this,name:"/rosapi/nodes",serviceType:"rosapi/Nodes"}),r=new a;"function"==typeof t?n.callService(r,(function(t){e(t.nodes)}),(function(e){t(e)})):n.callService(r,(function(t){e(t.nodes)}))},l.prototype.getNodeDetails=function(e,t,n){var r=new o({ros:this,name:"/rosapi/node_details",serviceType:"rosapi/NodeDetails"}),i=new a({node:e});"function"==typeof n?r.callService(i,(function(e){t(e.subscribing,e.publishing,e.services)}),(function(e){n(e)})):r.callService(i,(function(e){t(e)}))},l.prototype.getParams=function(e,t){var n=new o({ros:this,name:"/rosapi/get_param_names",serviceType:"rosapi/GetParamNames"}),r=new a;"function"==typeof t?n.callService(r,(function(t){e(t.names)}),(function(e){t(e)})):n.callService(r,(function(t){e(t.names)}))},l.prototype.getTopicType=function(e,t,n){var r=new o({ros:this,name:"/rosapi/topic_type",serviceType:"rosapi/TopicType"}),i=new a({topic:e});"function"==typeof n?r.callService(i,(function(e){t(e.type)}),(function(e){n(e)})):r.callService(i,(function(e){t(e.type)}))},l.prototype.getServiceType=function(e,t,n){var r=new o({ros:this,name:"/rosapi/service_type",serviceType:"rosapi/ServiceType"}),i=new a({service:e});"function"==typeof n?r.callService(i,(function(e){t(e.type)}),(function(e){n(e)})):r.callService(i,(function(e){t(e.type)}))},l.prototype.getMessageDetails=function(e,t,n){var r=new o({ros:this,name:"/rosapi/message_details",serviceType:"rosapi/MessageDetails"}),i=new a({type:e});"function"==typeof n?r.callService(i,(function(e){t(e.typedefs)}),(function(e){n(e)})):r.callService(i,(function(e){t(e.typedefs)}))},l.prototype.decodeTypeDefs=function(e){var t=this,n=function(e,r){for(var i={},o=0;o<e.fieldnames.length;o++){var a=e.fieldarraylen[o],s=e.fieldnames[o],c=e.fieldtypes[o];if(-1===c.indexOf("/"))i[s]=-1===a?c:[c];else{for(var l=!1,u=0;u<r.length;u++)if(r[u].type.toString()===c.toString()){l=r[u];break}if(l){var h=n(l,r);-1===a||(i[s]=[h])}else t.emit("error","Cannot find "+c+" in decodeTypeDefs")}}return i};return n(e[0],e)},l.prototype.getTopicsAndRawTypes=function(e,t){var n=new o({ros:this,name:"/rosapi/topics_and_raw_types",serviceType:"rosapi/TopicsAndRawTypes"}),r=new a;"function"==typeof t?n.callService(r,(function(t){e(t)}),(function(e){t(e)})):n.callService(r,(function(t){e(t)}))},e.exports=l},U4bP:function(e,t,n){e.exports={node:n("YLuR"),circle:n("3th9"),ellipse:n("Sdz8"),polygon:n("Kq0i"),rect:n("QRi6")}},U6jy:function(e,t){e.exports=function(){for(var e={},t=0;t<arguments.length;t++){var r=arguments[t];for(var i in r)n.call(r,i)&&(e[i]=r[i])}return e};var n=Object.prototype.hasOwnProperty},UBI6:function(e,t,n){"use strict";var r=n("ZWk2"),i=n("IPAr"),o=n("VSQ+");e.exports=c,c.locator=o,c.notInLink=!0;var a=["http://","https://","mailto:"],s=a.length;function c(e,t,n){var o,c,l,u,h,d,f,p,m,g,v,y;if(this.options.gfm){for(o="",u=-1,p=s;++u<p;)if(d=a[u],(f=t.slice(0,d.length)).toLowerCase()===d){o=f;break}if(o){for(u=o.length,p=t.length,m="",g=0;u<p&&(l=t.charAt(u),!i(l)&&"<"!==l)&&("."!==l&&","!==l&&":"!==l&&";"!==l&&'"'!==l&&"'"!==l&&")"!==l&&"]"!==l||(v=t.charAt(u+1))&&!i(v))&&("("!==l&&"["!==l||g++,")"!==l&&"]"!==l||!(--g<0));)m+=l,u++;if(m){if(c=o+=m,"mailto:"===d){if(-1===(h=m.indexOf("@"))||h===p-1)return;c=c.substr("mailto:".length)}return!!n||(y=this.enterLink(),c=this.tokenizeInline(c,e.now()),y(),e(o)({type:"link",title:null,url:r(o,{nonTerminated:!1}),children:c}))}}}}},UIh7:function(e,t,n){"use strict";var r=n("IPAr"),i=n("MaiH");e.exports=o,o.locator=i;function o(e,t,n){var i,o,a,s="",c="",l="",u="";if(this.options.gfm&&"~"===t.charAt(0)&&"~"===t.charAt(1)&&!r(t.charAt(2)))for(i=1,o=t.length,(a=e.now()).column+=2,a.offset+=2;++i<o;){if(!("~"!==(s=t.charAt(i))||"~"!==c||l&&r(l)))return!!n||e("~~"+u+"~~")({type:"delete",children:this.tokenizeInline(u,a)});u+=c,l=c,c=s}}},UMpK:function(e,t,n){var r=n("gFfm"),i=n("dTAl"),o=n("JC6p"),a=n("ut/Y"),s=n("LcsW"),c=n("Z0cm"),l=n("DSRE"),u=n("lSCD"),h=n("GoyQ"),d=n("c6wG");e.exports=function(e,t,n){var f=c(e),p=f||l(e)||d(e);if(t=a(t,4),null==n){var m=e&&e.constructor;n=p?f?new m:[]:h(e)&&u(m)?i(s(e)):{}}return(p?r:o)(e,(function(e,r,i){return t(n,e,r,i)})),n}},"UNi/":function(e,t){e.exports=function(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}},US93:function(e,t,n){var r=n("b3Az"),i=(n("kAvd"),n("cjKa").EventEmitter2);function o(e){e=e||{},this.ros=e.ros,this.name=e.name,this.serviceType=e.serviceType,this.isAdvertised=!1,this._serviceCallback=null}o.prototype.__proto__=i.prototype,o.prototype.callService=function(e,t,n){if(!this.isAdvertised){var i="call_service:"+this.name+":"+ ++this.ros.idCounter;(t||n)&&this.ros.once(i,(function(e){void 0!==e.result&&!1===e.result?"function"==typeof n&&n(e.values):"function"==typeof t&&t(new r(e.values))}));var o={op:"call_service",id:i,service:this.name,type:this.serviceType,args:e};this.ros.callOnConnection(o)}},o.prototype.advertise=function(e){this.isAdvertised||"function"!=typeof e||(this._serviceCallback=e,this.ros.on(this.name,this._serviceResponse.bind(this)),this.ros.callOnConnection({op:"advertise_service",type:this.serviceType,service:this.name}),this.isAdvertised=!0)},o.prototype.unadvertise=function(){this.isAdvertised&&(this.ros.callOnConnection({op:"unadvertise_service",service:this.name}),this.isAdvertised=!1)},o.prototype._serviceResponse=function(e){var t={},n=this._serviceCallback(e.args,t),i={op:"service_response",service:this.name,values:new r(t),result:n};e.id&&(i.id=e.id),this.ros.callOnConnection(i)},e.exports=o},"UV+P":function(e,t,n){"use strict";var r=n("q1tI"),i=n("U6jy"),o=n("TOwV"),a={start:{line:1,column:1,offset:0},end:{line:1,column:1,offset:0}};function s(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,l=t.renderers[e.type];void 0===e.position&&(e.position=n.node&&n.node.position||a);var u=e.position.start,h=[e.type,u.line,u.column,i].join("-");if(!o.isValidElementType(l))throw new Error("Renderer for type `".concat(e.type,"` not defined or is not renderable"));var d=c(e,h,t,l,n,i);return r.createElement(l,d,d.children||f()||void 0);function f(){return e.children&&e.children.map((function(n,r){return s(n,t,{node:e,props:d},r)}))}}function c(e,t,n,o,a,c){var u,h={key:t},d="string"==typeof o;n.sourcePos&&e.position&&(h["data-sourcepos"]=[(u=e.position).start.line,":",u.start.column,"-",u.end.line,":",u.end.column].map(String).join("")),n.rawSourcePos&&!d&&(h.sourcePosition=e.position),n.includeNodeIndex&&a.node&&a.node.children&&!d&&(h.index=a.node.children.indexOf(e),h.parentChildCount=a.node.children.length);var f=null!==e.identifier&&void 0!==e.identifier?n.definitions[e.identifier]||{}:null;switch(e.type){case"root":l(h,{className:n.className});break;case"text":h.nodeKey=t,h.children=e.value;break;case"heading":h.level=e.depth;break;case"list":h.start=e.start,h.ordered=e.ordered,h.tight=!e.loose,h.depth=e.depth;break;case"listItem":h.checked=e.checked,h.tight=!e.loose,h.ordered=e.ordered,h.index=e.index,h.children=function(e,t){if(e.loose)return e.children;if(t.node&&e.index>0&&t.node.children[e.index-1].loose)return e.children;return function(e){return e.children.reduce((function(e,t){return e.concat("paragraph"===t.type?t.children||[]:[t])}),[])}(e)}(e,a).map((function(t,r){return s(t,n,{node:e,props:h},r)}));break;case"definition":l(h,{identifier:e.identifier,title:e.title,url:e.url});break;case"code":l(h,{language:e.lang&&e.lang.split(/\s/,1)[0]});break;case"inlineCode":h.children=e.value,h.inline=!0;break;case"link":l(h,{title:e.title||void 0,target:"function"==typeof n.linkTarget?n.linkTarget(e.url,e.children,e.title):n.linkTarget,href:n.transformLinkUri?n.transformLinkUri(e.url,e.children,e.title):e.url});break;case"image":l(h,{alt:e.alt||void 0,title:e.title||void 0,src:n.transformImageUri?n.transformImageUri(e.url,e.children,e.title,e.alt):e.url});break;case"linkReference":l(h,i(f,{href:n.transformLinkUri?n.transformLinkUri(f.href):f.href}));break;case"imageReference":l(h,{src:n.transformImageUri&&f.href?n.transformImageUri(f.href,e.children,f.title,e.alt):f.href,title:f.title||void 0,alt:e.alt||void 0});break;case"table":case"tableHead":case"tableBody":h.columnAlignment=e.align;break;case"tableRow":h.isHeader="tableHead"===a.node.type,h.columnAlignment=a.props.columnAlignment;break;case"tableCell":l(h,{isHeader:a.props.isHeader,align:a.props.columnAlignment[c]});break;case"virtualHtml":h.tag=e.tag;break;case"html":h.isBlock=e.position.start.line!==e.position.end.line,h.escapeHtml=n.escapeHtml,h.skipHtml=n.skipHtml;break;case"parsedHtml":var p;e.children&&(p=e.children.map((function(t,r){return s(t,n,{node:e,props:h},r)}))),h.escapeHtml=n.escapeHtml,h.skipHtml=n.skipHtml,h.element=function(e,t){var n=e.element;if(Array.isArray(n)){var i=r.Fragment||"div";return r.createElement(i,null,n)}if(n.props.children||t){var o=r.Children.toArray(n.props.children).concat(t);return r.cloneElement(n,null,o)}return r.cloneElement(n,null)}(e,p);break;default:l(h,i(e,{type:void 0,position:void 0,children:void 0}))}return!d&&e.value&&(h.value=e.value),h}function l(e,t){for(var n in t)void 0!==t[n]&&(e[n]=t[n])}e.exports=s},UY5k:function(e,t,n){"use strict";n.r(t),n.d(t,"STLLoader",(function(){return i}));var r=n("Womt"),i=function(e){r.Loader.call(this,e)};i.prototype=Object.assign(Object.create(r.Loader.prototype),{constructor:i,load:function(e,t,n,i){var o=this,a=new r.FileLoader(o.manager);a.setPath(o.path),a.setResponseType("arraybuffer"),a.load(e,(function(n){try{t(o.parse(n))}catch(t){i?i(t):console.error(t),o.manager.itemError(e)}}),n,i)},parse:function(e){function t(e,t,n){for(var r=0,i=e.length;r<i;r++)if(e[r]!==t.getUint8(n+r,!1))return!1;return!0}var n,i=function(e){if("string"==typeof e){for(var t=new Uint8Array(e.length),n=0;n<e.length;n++)t[n]=255&e.charCodeAt(n);return t.buffer||t}return e}(e);return function(e){var n;if(50,84+50*(n=new DataView(e)).getUint32(80,!0)===n.byteLength)return!0;for(var r=[115,111,108,105,100],i=0;i<5;i++)if(t(r,n,i))return!1;return!0}(i)?function(e){for(var t,n,i,o,a,s,c,l,u=new DataView(e),h=u.getUint32(80,!0),d=!1,f=0;f<70;f++)1129270351==u.getUint32(f,!1)&&82==u.getUint8(f+4)&&61==u.getUint8(f+5)&&(d=!0,o=new Float32Array(3*h*3),a=u.getUint8(f+6)/255,s=u.getUint8(f+7)/255,c=u.getUint8(f+8)/255,l=u.getUint8(f+9)/255);for(var p=new r.BufferGeometry,m=new Float32Array(3*h*3),g=new Float32Array(3*h*3),v=0;v<h;v++){var y=84+50*v,b=u.getFloat32(y,!0),w=u.getFloat32(y+4,!0),x=u.getFloat32(y+8,!0);if(d){var _=u.getUint16(y+48,!0);0==(32768&_)?(t=(31&_)/31,n=(_>>5&31)/31,i=(_>>10&31)/31):(t=a,n=s,i=c)}for(var E=1;E<=3;E++){var S=y+12*E,C=3*v*3+3*(E-1);m[C]=u.getFloat32(S,!0),m[C+1]=u.getFloat32(S+4,!0),m[C+2]=u.getFloat32(S+8,!0),g[C]=b,g[C+1]=w,g[C+2]=x,d&&(o[C]=t,o[C+1]=n,o[C+2]=i)}}return p.setAttribute("position",new r.BufferAttribute(m,3)),p.setAttribute("normal",new r.BufferAttribute(g,3)),d&&(p.setAttribute("color",new r.BufferAttribute(o,3)),p.hasColors=!0,p.alpha=l),p}(i):function(e){for(var t,n=new r.BufferGeometry,i=/solid([\s\S]*?)endsolid/g,o=/facet([\s\S]*?)endfacet/g,a=0,s=/[\s]+([+-]?(?:\d*)(?:\.\d*)?(?:[eE][+-]?\d+)?)/.source,c=new RegExp("vertex"+s+s+s,"g"),l=new RegExp("normal"+s+s+s,"g"),u=[],h=[],d=new r.Vector3,f=0,p=0,m=0;null!==(t=i.exec(e));){p=m;for(var g=t[0];null!==(t=o.exec(g));){for(var v=0,y=0,b=t[0];null!==(t=l.exec(b));)d.x=parseFloat(t[1]),d.y=parseFloat(t[2]),d.z=parseFloat(t[3]),y++;for(;null!==(t=c.exec(b));)u.push(parseFloat(t[1]),parseFloat(t[2]),parseFloat(t[3])),h.push(d.x,d.y,d.z),v++,m++;1!==y&&console.error("THREE.STLLoader: Something isn't right with the normal of face number "+a),3!==v&&console.error("THREE.STLLoader: Something isn't right with the vertices of face number "+a),a++}var w=p,x=m-p;n.addGroup(w,x,f),f++}return n.setAttribute("position",new r.Float32BufferAttribute(u,3)),n.setAttribute("normal",new r.Float32BufferAttribute(h,3)),n}("string"!=typeof(n=e)?r.LoaderUtils.decodeText(new Uint8Array(n)):n)}})},UfWW:function(e,t,n){var r=n("KwMD"),i=n("ut/Y"),o=n("Sxd8"),a=Math.max;e.exports=function(e,t,n){var s=null==e?0:e.length;if(!s)return-1;var c=null==n?0:o(n);return c<0&&(c=a(s+c,0)),r(e,i(t,3),c)}},Uks8:function(e,t,n){var r=n("rmmL"),i=n("nw8D");function o(e){this.socket_=r(i),this.socket_.addEventListener("message",this.handleWorkerMessage_.bind(this)),this.socket_.postMessage({uri:e})}o.prototype.handleWorkerMessage_=function(e){var t=e.data;if(t instanceof ArrayBuffer||"string"==typeof t)this.onmessage(e);else{var n=t.type;if("close"===n)this.onclose(null);else if("open"===n)this.onopen(null);else{if("error"!==n)throw"Unknown message from workersocket";this.onerror(null)}}},o.prototype.send=function(e){this.socket_.postMessage(e)},o.prototype.close=function(){this.socket_.postMessage({close:!0})},e.exports=o},V5Ta:function(e,t,n){"use strict";var r=n("lU+G"),i=n("YLuR"),o=n("PEyx"),a=n("Ve/E");function s(e,t){var n=(a.line||a.svg.line)().x((function(e){return e.x})).y((function(e){return e.y}));return(n.curve||n.interpolate)(e.curve),n(t)}e.exports=function(e,t,n){var c=e.selectAll("g.edgePath").data(t.edges(),(function(e){return o.edgeToId(e)})).classed("update",!0),l=function(e,t){var n=e.enter().append("g").attr("class","edgePath").style("opacity",0);return n.append("path").attr("class","path").attr("d",(function(e){var n=t.edge(e),i=t.node(e.v).elem;return s(n,r.range(n.points.length).map((function(){return t=(e=i).getBBox(),{x:(n=e.ownerSVGElement.getScreenCTM().inverse().multiply(e.getScreenCTM()).translate(t.width/2,t.height/2)).e,y:n.f};var e,t,n})))})),n.append("defs"),n}(c,t);!function(e,t){var n=e.exit();o.applyTransition(n,t).style("opacity",0).remove()}(c,t);var u=void 0!==c.merge?c.merge(l):c;return o.applyTransition(u,t).style("opacity",1),u.each((function(e){var n=a.select(this),r=t.edge(e);r.elem=this,r.id&&n.attr("id",r.id),o.applyClass(n,r.class,(n.classed("update")?"update ":"")+"edgePath")})),u.selectAll("path.path").each((function(e){var n=t.edge(e);n.arrowheadId=r.uniqueId("arrowhead");var c=a.select(this).attr("marker-end",(function(){return"url("+(e=location.href,t=n.arrowheadId,e.split("#")[0]+"#"+t+")");var e,t})).style("fill","none");o.applyTransition(c,t).attr("d",(function(e){return function(e,t){var n=e.edge(t),r=e.node(t.v),o=e.node(t.w),a=n.points.slice(1,n.points.length-1);return a.unshift(i(r,a[0])),a.push(i(o,a[a.length-1])),s(n,a)}(t,e)})),o.applyStyle(c,n.style)})),u.selectAll("defs *").remove(),u.selectAll("defs").each((function(e){var r=t.edge(e);(0,n[r.arrowhead])(a.select(this),r.arrowheadId,r,"arrowhead")})),u}},V6Ve:function(e,t,n){var r=n("kekF")(Object.keys,Object);e.exports=r},V9xz:function(e,t){e.exports=function(e,t){return e>t}},VJLA:function(e,t,n){var r=n("MrPd"),i=n("1w02");e.exports=function(e,t){return i(e||[],t||[],r)}},VOtZ:function(e,t,n){var r=n("juv8"),i=n("MvSz");e.exports=function(e,t){return r(e,i(e),t)}},VRSw:function(e,t,n){"use strict";var r=n("1iAE"),i=n("afWh"),o=n("TjP8").tag;e.exports=c,c.locator=i;var a=/^<a /i,s=/^<\/a>/i;function c(e,t,n){var i,c,l=t.length;if(!("<"!==t.charAt(0)||l<3)&&(i=t.charAt(1),(r(i)||"?"===i||"!"===i||"/"===i)&&(c=t.match(o))))return!!n||(c=c[0],!this.inLink&&a.test(c)?this.inLink=!0:this.inLink&&s.test(c)&&(this.inLink=!1),e(c)({type:"html",value:c}))}},"VSQ+":function(e,t,n){"use strict";e.exports=function(e,t){var n,i=r.length,o=-1,a=-1;if(!this.options.gfm)return-1;for(;++o<i;)-1!==(n=e.indexOf(r[o],t))&&(n<a||-1===a)&&(a=n);return a};var r=["https://","http://","mailto:"]},VaNO:function(e,t){e.exports=function(e){return this.__data__.has(e)}},VbXa:function(e,t,n){var r=n("SksO");e.exports=function(e,t){e.prototype=Object.create(t.prototype),e.prototype.constructor=e,r(e,t)},e.exports.default=e.exports,e.exports.__esModule=!0},"Ve/E":function(e,t,n){var r;if(!r)try{r=n("VphZ")}catch(e){}r||(r=window.d3),e.exports=r},VkAN:function(e,t){e.exports=function(e,t){return t||(t=e.slice(0)),Object.freeze(Object.defineProperties(e,{raw:{value:Object.freeze(t)}}))},e.exports.default=e.exports,e.exports.__esModule=!0},VphZ:function(e,t,n){"use strict";n.r(t),n.d(t,"version",(function(){return r})),n.d(t,"bisect",(function(){return l})),n.d(t,"bisectRight",(function(){return s})),n.d(t,"bisectLeft",(function(){return c})),n.d(t,"ascending",(function(){return i})),n.d(t,"bisector",(function(){return o})),n.d(t,"cross",(function(){return d})),n.d(t,"descending",(function(){return f})),n.d(t,"deviation",(function(){return g})),n.d(t,"extent",(function(){return v})),n.d(t,"histogram",(function(){return R})),n.d(t,"thresholdFreedmanDiaconis",(function(){return L})),n.d(t,"thresholdScott",(function(){return F})),n.d(t,"thresholdSturges",(function(){return k})),n.d(t,"max",(function(){return j})),n.d(t,"mean",(function(){return D})),n.d(t,"median",(function(){return N})),n.d(t,"merge",(function(){return I})),n.d(t,"min",(function(){return B})),n.d(t,"pairs",(function(){return u})),n.d(t,"permute",(function(){return z})),n.d(t,"quantile",(function(){return P})),n.d(t,"range",(function(){return E})),n.d(t,"scan",(function(){return U})),n.d(t,"shuffle",(function(){return H})),n.d(t,"sum",(function(){return V})),n.d(t,"ticks",(function(){return T})),n.d(t,"tickIncrement",(function(){return M})),n.d(t,"tickStep",(function(){return O})),n.d(t,"transpose",(function(){return $})),n.d(t,"variance",(function(){return m})),n.d(t,"zip",(function(){return G})),n.d(t,"axisTop",(function(){return te})),n.d(t,"axisRight",(function(){return ne})),n.d(t,"axisBottom",(function(){return re})),n.d(t,"axisLeft",(function(){return ie})),n.d(t,"brush",(function(){return Ai})),n.d(t,"brushX",(function(){return Si})),n.d(t,"brushY",(function(){return Ci})),n.d(t,"brushSelection",(function(){return Ei})),n.d(t,"chord",(function(){return ji})),n.d(t,"ribbon",(function(){return Xi})),n.d(t,"nest",(function(){return Qi})),n.d(t,"set",(function(){return so})),n.d(t,"map",(function(){return Ji})),n.d(t,"keys",(function(){return co})),n.d(t,"values",(function(){return lo})),n.d(t,"entries",(function(){return uo})),n.d(t,"color",(function(){return $t})),n.d(t,"rgb",(function(){return Yt})),n.d(t,"hsl",(function(){return tn})),n.d(t,"lab",(function(){return go})),n.d(t,"hcl",(function(){return So})),n.d(t,"lch",(function(){return Eo})),n.d(t,"gray",(function(){return mo})),n.d(t,"cubehelix",(function(){return Po})),n.d(t,"contours",(function(){return Ho})),n.d(t,"contourDensity",(function(){return Yo})),n.d(t,"dispatch",(function(){return he})),n.d(t,"drag",(function(){return ta})),n.d(t,"dragDisable",(function(){return At})),n.d(t,"dragEnable",(function(){return Tt})),n.d(t,"dsvFormat",(function(){return ca})),n.d(t,"csvParse",(function(){return ua})),n.d(t,"csvParseRows",(function(){return ha})),n.d(t,"csvFormat",(function(){return da})),n.d(t,"csvFormatBody",(function(){return fa})),n.d(t,"csvFormatRows",(function(){return pa})),n.d(t,"csvFormatRow",(function(){return ma})),n.d(t,"csvFormatValue",(function(){return ga})),n.d(t,"tsvParse",(function(){return ya})),n.d(t,"tsvParseRows",(function(){return ba})),n.d(t,"tsvFormat",(function(){return wa})),n.d(t,"tsvFormatBody",(function(){return xa})),n.d(t,"tsvFormatRows",(function(){return _a})),n.d(t,"tsvFormatRow",(function(){return Ea})),n.d(t,"tsvFormatValue",(function(){return Sa})),n.d(t,"autoType",(function(){return Ca})),n.d(t,"easeLinear",(function(){return Ta})),n.d(t,"easeQuad",(function(){return ka})),n.d(t,"easeQuadIn",(function(){return Ma})),n.d(t,"easeQuadOut",(function(){return Oa})),n.d(t,"easeQuadInOut",(function(){return ka})),n.d(t,"easeCubic",(function(){return qr})),n.d(t,"easeCubicIn",(function(){return Wr})),n.d(t,"easeCubicOut",(function(){return Gr})),n.d(t,"easeCubicInOut",(function(){return qr})),n.d(t,"easePoly",(function(){return La})),n.d(t,"easePolyIn",(function(){return Ra})),n.d(t,"easePolyOut",(function(){return Pa})),n.d(t,"easePolyInOut",(function(){return La})),n.d(t,"easeSin",(function(){return Ia})),n.d(t,"easeSinIn",(function(){return Da})),n.d(t,"easeSinOut",(function(){return Na})),n.d(t,"easeSinInOut",(function(){return Ia})),n.d(t,"easeExp",(function(){return Ha})),n.d(t,"easeExpIn",(function(){return za})),n.d(t,"easeExpOut",(function(){return Ua})),n.d(t,"easeExpInOut",(function(){return Ha})),n.d(t,"easeCircle",(function(){return Wa})),n.d(t,"easeCircleIn",(function(){return Va})),n.d(t,"easeCircleOut",(function(){return $a})),n.d(t,"easeCircleInOut",(function(){return Wa})),n.d(t,"easeBounce",(function(){return qa})),n.d(t,"easeBounceIn",(function(){return Ga})),n.d(t,"easeBounceOut",(function(){return qa})),n.d(t,"easeBounceInOut",(function(){return Ya})),n.d(t,"easeBack",(function(){return Za})),n.d(t,"easeBackIn",(function(){return Xa})),n.d(t,"easeBackOut",(function(){return Ka})),n.d(t,"easeBackInOut",(function(){return Za})),n.d(t,"easeElastic",(function(){return es})),n.d(t,"easeElasticIn",(function(){return Qa})),n.d(t,"easeElasticOut",(function(){return es})),n.d(t,"easeElasticInOut",(function(){return ts})),n.d(t,"blob",(function(){return rs})),n.d(t,"buffer",(function(){return os})),n.d(t,"dsv",(function(){return ls})),n.d(t,"csv",(function(){return us})),n.d(t,"tsv",(function(){return hs})),n.d(t,"image",(function(){return ds})),n.d(t,"json",(function(){return ps})),n.d(t,"text",(function(){return ss})),n.d(t,"xml",(function(){return gs})),n.d(t,"html",(function(){return vs})),n.d(t,"svg",(function(){return ys})),n.d(t,"forceCenter",(function(){return bs})),n.d(t,"forceCollide",(function(){return Ps})),n.d(t,"forceLink",(function(){return js})),n.d(t,"forceManyBody",(function(){return zs})),n.d(t,"forceRadial",(function(){return Us})),n.d(t,"forceSimulation",(function(){return Bs})),n.d(t,"forceX",(function(){return Hs})),n.d(t,"forceY",(function(){return Vs})),n.d(t,"formatDefaultLocale",(function(){return oc})),n.d(t,"format",(function(){return Zs})),n.d(t,"formatPrefix",(function(){return Js})),n.d(t,"formatLocale",(function(){return ic})),n.d(t,"formatSpecifier",(function(){return qs})),n.d(t,"FormatSpecifier",(function(){return Ys})),n.d(t,"precisionFixed",(function(){return ac})),n.d(t,"precisionPrefix",(function(){return sc})),n.d(t,"precisionRound",(function(){return cc})),n.d(t,"geoArea",(function(){return Qc})),n.d(t,"geoBounds",(function(){return Wl})),n.d(t,"geoCentroid",(function(){return ru})),n.d(t,"geoCircle",(function(){return pu})),n.d(t,"geoClipAntimeridian",(function(){return Au})),n.d(t,"geoClipCircle",(function(){return Tu})),n.d(t,"geoClipExtent",(function(){return Pu})),n.d(t,"geoClipRectangle",(function(){return Mu})),n.d(t,"geoContains",(function(){return Ku})),n.d(t,"geoDistance",(function(){return Uu})),n.d(t,"geoGraticule",(function(){return Qu})),n.d(t,"geoGraticule10",(function(){return eh})),n.d(t,"geoInterpolate",(function(){return oh})),n.d(t,"geoLength",(function(){return Iu})),n.d(t,"geoPath",(function(){return rd})),n.d(t,"geoAlbers",(function(){return _d})),n.d(t,"geoAlbersUsa",(function(){return Ed})),n.d(t,"geoAzimuthalEqualArea",(function(){return Td})),n.d(t,"geoAzimuthalEqualAreaRaw",(function(){return Ad})),n.d(t,"geoAzimuthalEquidistant",(function(){return Od})),n.d(t,"geoAzimuthalEquidistantRaw",(function(){return Md})),n.d(t,"geoConicConformal",(function(){return jd})),n.d(t,"geoConicConformalRaw",(function(){return Fd})),n.d(t,"geoConicEqualArea",(function(){return xd})),n.d(t,"geoConicEqualAreaRaw",(function(){return wd})),n.d(t,"geoConicEquidistant",(function(){return Bd})),n.d(t,"geoConicEquidistantRaw",(function(){return Id})),n.d(t,"geoEqualEarth",(function(){return Gd})),n.d(t,"geoEqualEarthRaw",(function(){return Wd})),n.d(t,"geoEquirectangular",(function(){return Nd})),n.d(t,"geoEquirectangularRaw",(function(){return Dd})),n.d(t,"geoGnomonic",(function(){return Yd})),n.d(t,"geoGnomonicRaw",(function(){return qd})),n.d(t,"geoIdentity",(function(){return Xd})),n.d(t,"geoProjection",(function(){return vd})),n.d(t,"geoProjectionMutator",(function(){return yd})),n.d(t,"geoMercator",(function(){return Rd})),n.d(t,"geoMercatorRaw",(function(){return kd})),n.d(t,"geoNaturalEarth1",(function(){return Zd})),n.d(t,"geoNaturalEarth1Raw",(function(){return Kd})),n.d(t,"geoOrthographic",(function(){return Qd})),n.d(t,"geoOrthographicRaw",(function(){return Jd})),n.d(t,"geoStereographic",(function(){return tf})),n.d(t,"geoStereographicRaw",(function(){return ef})),n.d(t,"geoTransverseMercator",(function(){return rf})),n.d(t,"geoTransverseMercatorRaw",(function(){return nf})),n.d(t,"geoRotation",(function(){return hu})),n.d(t,"geoStream",(function(){return Wc})),n.d(t,"geoTransform",(function(){return id})),n.d(t,"cluster",(function(){return cf})),n.d(t,"hierarchy",(function(){return uf})),n.d(t,"pack",(function(){return jf})),n.d(t,"packSiblings",(function(){return Of})),n.d(t,"packEnclose",(function(){return gf})),n.d(t,"partition",(function(){return Uf})),n.d(t,"stratify",(function(){return Gf})),n.d(t,"tree",(function(){return Qf})),n.d(t,"treemap",(function(){return ip})),n.d(t,"treemapBinary",(function(){return op})),n.d(t,"treemapDice",(function(){return zf})),n.d(t,"treemapSlice",(function(){return ep})),n.d(t,"treemapSliceDice",(function(){return ap})),n.d(t,"treemapSquarify",(function(){return rp})),n.d(t,"treemapResquarify",(function(){return sp})),n.d(t,"interpolate",(function(){return On})),n.d(t,"interpolateArray",(function(){return bn})),n.d(t,"interpolateBasis",(function(){return an})),n.d(t,"interpolateBasisClosed",(function(){return sn})),n.d(t,"interpolateDate",(function(){return xn})),n.d(t,"interpolateDiscrete",(function(){return cp})),n.d(t,"interpolateHue",(function(){return lp})),n.d(t,"interpolateNumber",(function(){return _n})),n.d(t,"interpolateNumberArray",(function(){return vn})),n.d(t,"interpolateObject",(function(){return En})),n.d(t,"interpolateRound",(function(){return up})),n.d(t,"interpolateString",(function(){return Mn})),n.d(t,"interpolateTransformCss",(function(){return dr})),n.d(t,"interpolateTransformSvg",(function(){return fr})),n.d(t,"interpolateZoom",(function(){return fp})),n.d(t,"interpolateRgb",(function(){return fn})),n.d(t,"interpolateRgbBasis",(function(){return mn})),n.d(t,"interpolateRgbBasisClosed",(function(){return gn})),n.d(t,"interpolateHsl",(function(){return mp})),n.d(t,"interpolateHslLong",(function(){return gp})),n.d(t,"interpolateLab",(function(){return vp})),n.d(t,"interpolateHcl",(function(){return bp})),n.d(t,"interpolateHclLong",(function(){return wp})),n.d(t,"interpolateCubehelix",(function(){return _p})),n.d(t,"interpolateCubehelixLong",(function(){return Ep})),n.d(t,"piecewise",(function(){return Sp})),n.d(t,"quantize",(function(){return Cp})),n.d(t,"path",(function(){return Vi})),n.d(t,"polygonArea",(function(){return Ap})),n.d(t,"polygonCentroid",(function(){return Tp})),n.d(t,"polygonHull",(function(){return kp})),n.d(t,"polygonContains",(function(){return Rp})),n.d(t,"polygonLength",(function(){return Pp})),n.d(t,"quadtree",(function(){return As})),n.d(t,"randomUniform",(function(){return Fp})),n.d(t,"randomNormal",(function(){return jp})),n.d(t,"randomLogNormal",(function(){return Dp})),n.d(t,"randomBates",(function(){return Ip})),n.d(t,"randomIrwinHall",(function(){return Np})),n.d(t,"randomExponential",(function(){return Bp})),n.d(t,"scaleBand",(function(){return qp})),n.d(t,"scalePoint",(function(){return Xp})),n.d(t,"scaleIdentity",(function(){return lm})),n.d(t,"scaleLinear",(function(){return cm})),n.d(t,"scaleLog",(function(){return ym})),n.d(t,"scaleSymlog",(function(){return _m})),n.d(t,"scaleOrdinal",(function(){return Gp})),n.d(t,"scaleImplicit",(function(){return Wp})),n.d(t,"scalePow",(function(){return Tm})),n.d(t,"scaleSqrt",(function(){return Mm})),n.d(t,"scaleQuantile",(function(){return Om})),n.d(t,"scaleQuantize",(function(){return km})),n.d(t,"scaleThreshold",(function(){return Rm})),n.d(t,"scaleTime",(function(){return py})),n.d(t,"scaleUtc",(function(){return Sy})),n.d(t,"scaleSequential",(function(){return Ty})),n.d(t,"scaleSequentialLog",(function(){return My})),n.d(t,"scaleSequentialPow",(function(){return ky})),n.d(t,"scaleSequentialSqrt",(function(){return Ry})),n.d(t,"scaleSequentialSymlog",(function(){return Oy})),n.d(t,"scaleSequentialQuantile",(function(){return Py})),n.d(t,"scaleDiverging",(function(){return Fy})),n.d(t,"scaleDivergingLog",(function(){return jy})),n.d(t,"scaleDivergingPow",(function(){return Ny})),n.d(t,"scaleDivergingSqrt",(function(){return Iy})),n.d(t,"scaleDivergingSymlog",(function(){return Dy})),n.d(t,"tickFormat",(function(){return am})),n.d(t,"schemeCategory10",(function(){return zy})),n.d(t,"schemeAccent",(function(){return Uy})),n.d(t,"schemeDark2",(function(){return Hy})),n.d(t,"schemePaired",(function(){return Vy})),n.d(t,"schemePastel1",(function(){return $y})),n.d(t,"schemePastel2",(function(){return Wy})),n.d(t,"schemeSet1",(function(){return Gy})),n.d(t,"schemeSet2",(function(){return qy})),n.d(t,"schemeSet3",(function(){return Yy})),n.d(t,"schemeTableau10",(function(){return Xy})),n.d(t,"interpolateBrBG",(function(){return Jy})),n.d(t,"schemeBrBG",(function(){return Zy})),n.d(t,"interpolatePRGn",(function(){return eb})),n.d(t,"schemePRGn",(function(){return Qy})),n.d(t,"interpolatePiYG",(function(){return nb})),n.d(t,"schemePiYG",(function(){return tb})),n.d(t,"interpolatePuOr",(function(){return ib})),n.d(t,"schemePuOr",(function(){return rb})),n.d(t,"interpolateRdBu",(function(){return ab})),n.d(t,"schemeRdBu",(function(){return ob})),n.d(t,"interpolateRdGy",(function(){return cb})),n.d(t,"schemeRdGy",(function(){return sb})),n.d(t,"interpolateRdYlBu",(function(){return ub})),n.d(t,"schemeRdYlBu",(function(){return lb})),n.d(t,"interpolateRdYlGn",(function(){return db})),n.d(t,"schemeRdYlGn",(function(){return hb})),n.d(t,"interpolateSpectral",(function(){return pb})),n.d(t,"schemeSpectral",(function(){return fb})),n.d(t,"interpolateBuGn",(function(){return gb})),n.d(t,"schemeBuGn",(function(){return mb})),n.d(t,"interpolateBuPu",(function(){return yb})),n.d(t,"schemeBuPu",(function(){return vb})),n.d(t,"interpolateGnBu",(function(){return wb})),n.d(t,"schemeGnBu",(function(){return bb})),n.d(t,"interpolateOrRd",(function(){return _b})),n.d(t,"schemeOrRd",(function(){return xb})),n.d(t,"interpolatePuBuGn",(function(){return Sb})),n.d(t,"schemePuBuGn",(function(){return Eb})),n.d(t,"interpolatePuBu",(function(){return Ab})),n.d(t,"schemePuBu",(function(){return Cb})),n.d(t,"interpolatePuRd",(function(){return Mb})),n.d(t,"schemePuRd",(function(){return Tb})),n.d(t,"interpolateRdPu",(function(){return kb})),n.d(t,"schemeRdPu",(function(){return Ob})),n.d(t,"interpolateYlGnBu",(function(){return Pb})),n.d(t,"schemeYlGnBu",(function(){return Rb})),n.d(t,"interpolateYlGn",(function(){return Fb})),n.d(t,"schemeYlGn",(function(){return Lb})),n.d(t,"interpolateYlOrBr",(function(){return Db})),n.d(t,"schemeYlOrBr",(function(){return jb})),n.d(t,"interpolateYlOrRd",(function(){return Ib})),n.d(t,"schemeYlOrRd",(function(){return Nb})),n.d(t,"interpolateBlues",(function(){return zb})),n.d(t,"schemeBlues",(function(){return Bb})),n.d(t,"interpolateGreens",(function(){return Hb})),n.d(t,"schemeGreens",(function(){return Ub})),n.d(t,"interpolateGreys",(function(){return $b})),n.d(t,"schemeGreys",(function(){return Vb})),n.d(t,"interpolatePurples",(function(){return Gb})),n.d(t,"schemePurples",(function(){return Wb})),n.d(t,"interpolateReds",(function(){return Yb})),n.d(t,"schemeReds",(function(){return qb})),n.d(t,"interpolateOranges",(function(){return Kb})),n.d(t,"schemeOranges",(function(){return Xb})),n.d(t,"interpolateCividis",(function(){return Zb})),n.d(t,"interpolateCubehelixDefault",(function(){return Jb})),n.d(t,"interpolateRainbow",(function(){return nw})),n.d(t,"interpolateWarm",(function(){return Qb})),n.d(t,"interpolateCool",(function(){return ew})),n.d(t,"interpolateSinebow",(function(){return aw})),n.d(t,"interpolateTurbo",(function(){return sw})),n.d(t,"interpolateViridis",(function(){return lw})),n.d(t,"interpolateMagma",(function(){return uw})),n.d(t,"interpolateInferno",(function(){return hw})),n.d(t,"interpolatePlasma",(function(){return dw})),n.d(t,"create",(function(){return fw})),n.d(t,"creator",(function(){return rt})),n.d(t,"local",(function(){return mw})),n.d(t,"matcher",(function(){return ge})),n.d(t,"mouse",(function(){return Ln})),n.d(t,"namespace",(function(){return Se})),n.d(t,"namespaces",(function(){return Ee})),n.d(t,"clientPoint",(function(){return Rn})),n.d(t,"select",(function(){return Et})),n.d(t,"selectAll",(function(){return vw})),n.d(t,"selection",(function(){return _t})),n.d(t,"selector",(function(){return fe})),n.d(t,"selectorAll",(function(){return me})),n.d(t,"style",(function(){return je})),n.d(t,"touch",(function(){return Pn})),n.d(t,"touches",(function(){return yw})),n.d(t,"window",(function(){return Re})),n.d(t,"event",(function(){return lt})),n.d(t,"customEvent",(function(){return mt})),n.d(t,"arc",(function(){return Bw})),n.d(t,"area",(function(){return Ww})),n.d(t,"line",(function(){return $w})),n.d(t,"pie",(function(){return Yw})),n.d(t,"areaRadial",(function(){return ex})),n.d(t,"radialArea",(function(){return ex})),n.d(t,"lineRadial",(function(){return Qw})),n.d(t,"radialLine",(function(){return Qw})),n.d(t,"pointRadial",(function(){return tx})),n.d(t,"linkHorizontal",(function(){return lx})),n.d(t,"linkVertical",(function(){return ux})),n.d(t,"linkRadial",(function(){return hx})),n.d(t,"symbol",(function(){return Ox})),n.d(t,"symbols",(function(){return Mx})),n.d(t,"symbolCircle",(function(){return dx})),n.d(t,"symbolCross",(function(){return fx})),n.d(t,"symbolDiamond",(function(){return gx})),n.d(t,"symbolSquare",(function(){return xx})),n.d(t,"symbolStar",(function(){return wx})),n.d(t,"symbolTriangle",(function(){return Ex})),n.d(t,"symbolWye",(function(){return Tx})),n.d(t,"curveBasisClosed",(function(){return jx})),n.d(t,"curveBasisOpen",(function(){return Nx})),n.d(t,"curveBasis",(function(){return Lx})),n.d(t,"curveBundle",(function(){return Bx})),n.d(t,"curveCardinalClosed",(function(){return $x})),n.d(t,"curveCardinalOpen",(function(){return Gx})),n.d(t,"curveCardinal",(function(){return Hx})),n.d(t,"curveCatmullRomClosed",(function(){return Zx})),n.d(t,"curveCatmullRomOpen",(function(){return Qx})),n.d(t,"curveCatmullRom",(function(){return Xx})),n.d(t,"curveLinearClosed",(function(){return t_})),n.d(t,"curveLinear",(function(){return Uw})),n.d(t,"curveMonotoneX",(function(){return l_})),n.d(t,"curveMonotoneY",(function(){return u_})),n.d(t,"curveNatural",(function(){return f_})),n.d(t,"curveStep",(function(){return m_})),n.d(t,"curveStepAfter",(function(){return v_})),n.d(t,"curveStepBefore",(function(){return g_})),n.d(t,"stack",(function(){return x_})),n.d(t,"stackOffsetExpand",(function(){return __})),n.d(t,"stackOffsetDiverging",(function(){return E_})),n.d(t,"stackOffsetNone",(function(){return y_})),n.d(t,"stackOffsetSilhouette",(function(){return S_})),n.d(t,"stackOffsetWiggle",(function(){return C_})),n.d(t,"stackOrderAppearance",(function(){return A_})),n.d(t,"stackOrderAscending",(function(){return M_})),n.d(t,"stackOrderDescending",(function(){return k_})),n.d(t,"stackOrderInsideOut",(function(){return R_})),n.d(t,"stackOrderNone",(function(){return b_})),n.d(t,"stackOrderReverse",(function(){return P_})),n.d(t,"timeInterval",(function(){return Fm})),n.d(t,"timeMillisecond",(function(){return mg})),n.d(t,"timeMilliseconds",(function(){return gg})),n.d(t,"utcMillisecond",(function(){return mg})),n.d(t,"utcMilliseconds",(function(){return gg})),n.d(t,"timeSecond",(function(){return dg})),n.d(t,"timeSeconds",(function(){return fg})),n.d(t,"utcSecond",(function(){return dg})),n.d(t,"utcSeconds",(function(){return fg})),n.d(t,"timeMinute",(function(){return lg})),n.d(t,"timeMinutes",(function(){return ug})),n.d(t,"timeHour",(function(){return ag})),n.d(t,"timeHours",(function(){return sg})),n.d(t,"timeDay",(function(){return rg})),n.d(t,"timeDays",(function(){return ig})),n.d(t,"timeWeek",(function(){return Hm})),n.d(t,"timeWeeks",(function(){return Xm})),n.d(t,"timeSunday",(function(){return Hm})),n.d(t,"timeSundays",(function(){return Xm})),n.d(t,"timeMonday",(function(){return Vm})),n.d(t,"timeMondays",(function(){return Km})),n.d(t,"timeTuesday",(function(){return $m})),n.d(t,"timeTuesdays",(function(){return Zm})),n.d(t,"timeWednesday",(function(){return Wm})),n.d(t,"timeWednesdays",(function(){return Jm})),n.d(t,"timeThursday",(function(){return Gm})),n.d(t,"timeThursdays",(function(){return Qm})),n.d(t,"timeFriday",(function(){return qm})),n.d(t,"timeFridays",(function(){return eg})),n.d(t,"timeSaturday",(function(){return Ym})),n.d(t,"timeSaturdays",(function(){return tg})),n.d(t,"timeMonth",(function(){return Bm})),n.d(t,"timeMonths",(function(){return zm})),n.d(t,"timeYear",(function(){return Dm})),n.d(t,"timeYears",(function(){return Nm})),n.d(t,"utcMinute",(function(){return _y})),n.d(t,"utcMinutes",(function(){return Ey})),n.d(t,"utcHour",(function(){return by})),n.d(t,"utcHours",(function(){return wy})),n.d(t,"utcDay",(function(){return Lg})),n.d(t,"utcDays",(function(){return Fg})),n.d(t,"utcWeek",(function(){return yg})),n.d(t,"utcWeeks",(function(){return Cg})),n.d(t,"utcSunday",(function(){return yg})),n.d(t,"utcSundays",(function(){return Cg})),n.d(t,"utcMonday",(function(){return bg})),n.d(t,"utcMondays",(function(){return Ag})),n.d(t,"utcTuesday",(function(){return wg})),n.d(t,"utcTuesdays",(function(){return Tg})),n.d(t,"utcWednesday",(function(){return xg})),n.d(t,"utcWednesdays",(function(){return Mg})),n.d(t,"utcThursday",(function(){return _g})),n.d(t,"utcThursdays",(function(){return Og})),n.d(t,"utcFriday",(function(){return Eg})),n.d(t,"utcFridays",(function(){return kg})),n.d(t,"utcSaturday",(function(){return Sg})),n.d(t,"utcSaturdays",(function(){return Rg})),n.d(t,"utcMonth",(function(){return gy})),n.d(t,"utcMonths",(function(){return vy})),n.d(t,"utcYear",(function(){return Dg})),n.d(t,"utcYears",(function(){return Ng})),n.d(t,"timeFormatDefaultLocale",(function(){return uy})),n.d(t,"timeFormat",(function(){return Vg})),n.d(t,"timeParse",(function(){return $g})),n.d(t,"utcFormat",(function(){return Wg})),n.d(t,"utcParse",(function(){return Gg})),n.d(t,"timeFormatLocale",(function(){return Ug})),n.d(t,"isoFormat",(function(){return L_})),n.d(t,"isoParse",(function(){return F_})),n.d(t,"now",(function(){return Hn})),n.d(t,"timer",(function(){return Wn})),n.d(t,"timerFlush",(function(){return Gn})),n.d(t,"timeout",(function(){return Kn})),n.d(t,"interval",(function(){return j_})),n.d(t,"transition",(function(){return Hr})),n.d(t,"active",(function(){return Zr})),n.d(t,"interrupt",(function(){return sr})),n.d(t,"voronoi",(function(){return wE})),n.d(t,"zoom",(function(){return FE})),n.d(t,"zoomTransform",(function(){return CE})),n.d(t,"zoomIdentity",(function(){return SE}));var r="5.16.0",i=function(e,t){return e<t?-1:e>t?1:e>=t?0:NaN},o=function(e){var t;return 1===e.length&&(t=e,e=function(e,n){return i(t(e),n)}),{left:function(t,n,r,i){for(null==r&&(r=0),null==i&&(i=t.length);r<i;){var o=r+i>>>1;e(t[o],n)<0?r=o+1:i=o}return r},right:function(t,n,r,i){for(null==r&&(r=0),null==i&&(i=t.length);r<i;){var o=r+i>>>1;e(t[o],n)>0?i=o:r=o+1}return r}}};var a=o(i),s=a.right,c=a.left,l=s,u=function(e,t){null==t&&(t=h);for(var n=0,r=e.length-1,i=e[0],o=new Array(r<0?0:r);n<r;)o[n]=t(i,i=e[++n]);return o};function h(e,t){return[e,t]}var d=function(e,t,n){var r,i,o,a,s=e.length,c=t.length,l=new Array(s*c);for(null==n&&(n=h),r=o=0;r<s;++r)for(a=e[r],i=0;i<c;++i,++o)l[o]=n(a,t[i]);return l},f=function(e,t){return t<e?-1:t>e?1:t>=e?0:NaN},p=function(e){return null===e?NaN:+e},m=function(e,t){var n,r,i=e.length,o=0,a=-1,s=0,c=0;if(null==t)for(;++a<i;)isNaN(n=p(e[a]))||(c+=(r=n-s)*(n-(s+=r/++o)));else for(;++a<i;)isNaN(n=p(t(e[a],a,e)))||(c+=(r=n-s)*(n-(s+=r/++o)));if(o>1)return c/(o-1)},g=function(e,t){var n=m(e,t);return n?Math.sqrt(n):n},v=function(e,t){var n,r,i,o=e.length,a=-1;if(null==t){for(;++a<o;)if(null!=(n=e[a])&&n>=n)for(r=i=n;++a<o;)null!=(n=e[a])&&(r>n&&(r=n),i<n&&(i=n))}else for(;++a<o;)if(null!=(n=t(e[a],a,e))&&n>=n)for(r=i=n;++a<o;)null!=(n=t(e[a],a,e))&&(r>n&&(r=n),i<n&&(i=n));return[r,i]},y=Array.prototype,b=y.slice,w=y.map,x=function(e){return function(){return e}},_=function(e){return e},E=function(e,t,n){e=+e,t=+t,n=(i=arguments.length)<2?(t=e,e=0,1):i<3?1:+n;for(var r=-1,i=0|Math.max(0,Math.ceil((t-e)/n)),o=new Array(i);++r<i;)o[r]=e+r*n;return o},S=Math.sqrt(50),C=Math.sqrt(10),A=Math.sqrt(2),T=function(e,t,n){var r,i,o,a,s=-1;if(n=+n,(e=+e)===(t=+t)&&n>0)return[e];if((r=t<e)&&(i=e,e=t,t=i),0===(a=M(e,t,n))||!isFinite(a))return[];if(a>0)for(e=Math.ceil(e/a),t=Math.floor(t/a),o=new Array(i=Math.ceil(t-e+1));++s<i;)o[s]=(e+s)*a;else for(e=Math.floor(e*a),t=Math.ceil(t*a),o=new Array(i=Math.ceil(e-t+1));++s<i;)o[s]=(e-s)/a;return r&&o.reverse(),o};function M(e,t,n){var r=(t-e)/Math.max(0,n),i=Math.floor(Math.log(r)/Math.LN10),o=r/Math.pow(10,i);return i>=0?(o>=S?10:o>=C?5:o>=A?2:1)*Math.pow(10,i):-Math.pow(10,-i)/(o>=S?10:o>=C?5:o>=A?2:1)}function O(e,t,n){var r=Math.abs(t-e)/Math.max(0,n),i=Math.pow(10,Math.floor(Math.log(r)/Math.LN10)),o=r/i;return o>=S?i*=10:o>=C?i*=5:o>=A&&(i*=2),t<e?-i:i}var k=function(e){return Math.ceil(Math.log(e.length)/Math.LN2)+1},R=function(){var e=_,t=v,n=k;function r(r){var i,o,a=r.length,s=new Array(a);for(i=0;i<a;++i)s[i]=e(r[i],i,r);var c=t(s),u=c[0],h=c[1],d=n(s,u,h);Array.isArray(d)||(d=O(u,h,d),d=E(Math.ceil(u/d)*d,h,d));for(var f=d.length;d[0]<=u;)d.shift(),--f;for(;d[f-1]>h;)d.pop(),--f;var p,m=new Array(f+1);for(i=0;i<=f;++i)(p=m[i]=[]).x0=i>0?d[i-1]:u,p.x1=i<f?d[i]:h;for(i=0;i<a;++i)u<=(o=s[i])&&o<=h&&m[l(d,o,0,f)].push(r[i]);return m}return r.value=function(t){return arguments.length?(e="function"==typeof t?t:x(t),r):e},r.domain=function(e){return arguments.length?(t="function"==typeof e?e:x([e[0],e[1]]),r):t},r.thresholds=function(e){return arguments.length?(n="function"==typeof e?e:Array.isArray(e)?x(b.call(e)):x(e),r):n},r},P=function(e,t,n){if(null==n&&(n=p),r=e.length){if((t=+t)<=0||r<2)return+n(e[0],0,e);if(t>=1)return+n(e[r-1],r-1,e);var r,i=(r-1)*t,o=Math.floor(i),a=+n(e[o],o,e);return a+(+n(e[o+1],o+1,e)-a)*(i-o)}},L=function(e,t,n){return e=w.call(e,p).sort(i),Math.ceil((n-t)/(2*(P(e,.75)-P(e,.25))*Math.pow(e.length,-1/3)))},F=function(e,t,n){return Math.ceil((n-t)/(3.5*g(e)*Math.pow(e.length,-1/3)))},j=function(e,t){var n,r,i=e.length,o=-1;if(null==t){for(;++o<i;)if(null!=(n=e[o])&&n>=n)for(r=n;++o<i;)null!=(n=e[o])&&n>r&&(r=n)}else for(;++o<i;)if(null!=(n=t(e[o],o,e))&&n>=n)for(r=n;++o<i;)null!=(n=t(e[o],o,e))&&n>r&&(r=n);return r},D=function(e,t){var n,r=e.length,i=r,o=-1,a=0;if(null==t)for(;++o<r;)isNaN(n=p(e[o]))?--i:a+=n;else for(;++o<r;)isNaN(n=p(t(e[o],o,e)))?--i:a+=n;if(i)return a/i},N=function(e,t){var n,r=e.length,o=-1,a=[];if(null==t)for(;++o<r;)isNaN(n=p(e[o]))||a.push(n);else for(;++o<r;)isNaN(n=p(t(e[o],o,e)))||a.push(n);return P(a.sort(i),.5)},I=function(e){for(var t,n,r,i=e.length,o=-1,a=0;++o<i;)a+=e[o].length;for(n=new Array(a);--i>=0;)for(t=(r=e[i]).length;--t>=0;)n[--a]=r[t];return n},B=function(e,t){var n,r,i=e.length,o=-1;if(null==t){for(;++o<i;)if(null!=(n=e[o])&&n>=n)for(r=n;++o<i;)null!=(n=e[o])&&r>n&&(r=n)}else for(;++o<i;)if(null!=(n=t(e[o],o,e))&&n>=n)for(r=n;++o<i;)null!=(n=t(e[o],o,e))&&r>n&&(r=n);return r},z=function(e,t){for(var n=t.length,r=new Array(n);n--;)r[n]=e[t[n]];return r},U=function(e,t){if(n=e.length){var n,r,o=0,a=0,s=e[a];for(null==t&&(t=i);++o<n;)(t(r=e[o],s)<0||0!==t(s,s))&&(s=r,a=o);return 0===t(s,s)?a:void 0}},H=function(e,t,n){for(var r,i,o=(null==n?e.length:n)-(t=null==t?0:+t);o;)i=Math.random()*o--|0,r=e[o+t],e[o+t]=e[i+t],e[i+t]=r;return e},V=function(e,t){var n,r=e.length,i=-1,o=0;if(null==t)for(;++i<r;)(n=+e[i])&&(o+=n);else for(;++i<r;)(n=+t(e[i],i,e))&&(o+=n);return o},$=function(e){if(!(i=e.length))return[];for(var t=-1,n=B(e,W),r=new Array(n);++t<n;)for(var i,o=-1,a=r[t]=new Array(i);++o<i;)a[o]=e[o][t];return r};function W(e){return e.length}var G=function(){return $(arguments)},q=Array.prototype.slice,Y=function(e){return e};function X(e){return"translate("+(e+.5)+",0)"}function K(e){return"translate(0,"+(e+.5)+")"}function Z(e){return function(t){return+e(t)}}function J(e){var t=Math.max(0,e.bandwidth()-1)/2;return e.round()&&(t=Math.round(t)),function(n){return+e(n)+t}}function Q(){return!this.__axis}function ee(e,t){var n=[],r=null,i=null,o=6,a=6,s=3,c=1===e||4===e?-1:1,l=4===e||2===e?"x":"y",u=1===e||3===e?X:K;function h(h){var d=null==r?t.ticks?t.ticks.apply(t,n):t.domain():r,f=null==i?t.tickFormat?t.tickFormat.apply(t,n):Y:i,p=Math.max(o,0)+s,m=t.range(),g=+m[0]+.5,v=+m[m.length-1]+.5,y=(t.bandwidth?J:Z)(t.copy()),b=h.selection?h.selection():h,w=b.selectAll(".domain").data([null]),x=b.selectAll(".tick").data(d,t).order(),_=x.exit(),E=x.enter().append("g").attr("class","tick"),S=x.select("line"),C=x.select("text");w=w.merge(w.enter().insert("path",".tick").attr("class","domain").attr("stroke","currentColor")),x=x.merge(E),S=S.merge(E.append("line").attr("stroke","currentColor").attr(l+"2",c*o)),C=C.merge(E.append("text").attr("fill","currentColor").attr(l,c*p).attr("dy",1===e?"0em":3===e?"0.71em":"0.32em")),h!==b&&(w=w.transition(h),x=x.transition(h),S=S.transition(h),C=C.transition(h),_=_.transition(h).attr("opacity",1e-6).attr("transform",(function(e){return isFinite(e=y(e))?u(e):this.getAttribute("transform")})),E.attr("opacity",1e-6).attr("transform",(function(e){var t=this.parentNode.__axis;return u(t&&isFinite(t=t(e))?t:y(e))}))),_.remove(),w.attr("d",4===e||2==e?a?"M"+c*a+","+g+"H0.5V"+v+"H"+c*a:"M0.5,"+g+"V"+v:a?"M"+g+","+c*a+"V0.5H"+v+"V"+c*a:"M"+g+",0.5H"+v),x.attr("opacity",1).attr("transform",(function(e){return u(y(e))})),S.attr(l+"2",c*o),C.attr(l,c*p).text(f),b.filter(Q).attr("fill","none").attr("font-size",10).attr("font-family","sans-serif").attr("text-anchor",2===e?"start":4===e?"end":"middle"),b.each((function(){this.__axis=y}))}return h.scale=function(e){return arguments.length?(t=e,h):t},h.ticks=function(){return n=q.call(arguments),h},h.tickArguments=function(e){return arguments.length?(n=null==e?[]:q.call(e),h):n.slice()},h.tickValues=function(e){return arguments.length?(r=null==e?null:q.call(e),h):r&&r.slice()},h.tickFormat=function(e){return arguments.length?(i=e,h):i},h.tickSize=function(e){return arguments.length?(o=a=+e,h):o},h.tickSizeInner=function(e){return arguments.length?(o=+e,h):o},h.tickSizeOuter=function(e){return arguments.length?(a=+e,h):a},h.tickPadding=function(e){return arguments.length?(s=+e,h):s},h}function te(e){return ee(1,e)}function ne(e){return ee(2,e)}function re(e){return ee(3,e)}function ie(e){return ee(4,e)}var oe={value:function(){}};function ae(){for(var e,t=0,n=arguments.length,r={};t<n;++t){if(!(e=arguments[t]+"")||e in r||/[\s.]/.test(e))throw new Error("illegal type: "+e);r[e]=[]}return new se(r)}function se(e){this._=e}function ce(e,t){return e.trim().split(/^|\s+/).map((function(e){var n="",r=e.indexOf(".");if(r>=0&&(n=e.slice(r+1),e=e.slice(0,r)),e&&!t.hasOwnProperty(e))throw new Error("unknown type: "+e);return{type:e,name:n}}))}function le(e,t){for(var n,r=0,i=e.length;r<i;++r)if((n=e[r]).name===t)return n.value}function ue(e,t,n){for(var r=0,i=e.length;r<i;++r)if(e[r].name===t){e[r]=oe,e=e.slice(0,r).concat(e.slice(r+1));break}return null!=n&&e.push({name:t,value:n}),e}se.prototype=ae.prototype={constructor:se,on:function(e,t){var n,r=this._,i=ce(e+"",r),o=-1,a=i.length;if(!(arguments.length<2)){if(null!=t&&"function"!=typeof t)throw new Error("invalid callback: "+t);for(;++o<a;)if(n=(e=i[o]).type)r[n]=ue(r[n],e.name,t);else if(null==t)for(n in r)r[n]=ue(r[n],e.name,null);return this}for(;++o<a;)if((n=(e=i[o]).type)&&(n=le(r[n],e.name)))return n},copy:function(){var e={},t=this._;for(var n in t)e[n]=t[n].slice();return new se(e)},call:function(e,t){if((n=arguments.length-2)>0)for(var n,r,i=new Array(n),o=0;o<n;++o)i[o]=arguments[o+2];if(!this._.hasOwnProperty(e))throw new Error("unknown type: "+e);for(o=0,n=(r=this._[e]).length;o<n;++o)r[o].value.apply(t,i)},apply:function(e,t,n){if(!this._.hasOwnProperty(e))throw new Error("unknown type: "+e);for(var r=this._[e],i=0,o=r.length;i<o;++i)r[i].value.apply(t,n)}};var he=ae;function de(){}var fe=function(e){return null==e?de:function(){return this.querySelector(e)}};function pe(){return[]}var me=function(e){return null==e?pe:function(){return this.querySelectorAll(e)}},ge=function(e){return function(){return this.matches(e)}},ve=function(e){return new Array(e.length)};function ye(e,t){this.ownerDocument=e.ownerDocument,this.namespaceURI=e.namespaceURI,this._next=null,this._parent=e,this.__data__=t}ye.prototype={constructor:ye,appendChild:function(e){return this._parent.insertBefore(e,this._next)},insertBefore:function(e,t){return this._parent.insertBefore(e,t)},querySelector:function(e){return this._parent.querySelector(e)},querySelectorAll:function(e){return this._parent.querySelectorAll(e)}};function be(e,t,n,r,i,o){for(var a,s=0,c=t.length,l=o.length;s<l;++s)(a=t[s])?(a.__data__=o[s],r[s]=a):n[s]=new ye(e,o[s]);for(;s<c;++s)(a=t[s])&&(i[s]=a)}function we(e,t,n,r,i,o,a){var s,c,l,u={},h=t.length,d=o.length,f=new Array(h);for(s=0;s<h;++s)(c=t[s])&&(f[s]=l="$"+a.call(c,c.__data__,s,t),l in u?i[s]=c:u[l]=c);for(s=0;s<d;++s)(c=u[l="$"+a.call(e,o[s],s,o)])?(r[s]=c,c.__data__=o[s],u[l]=null):n[s]=new ye(e,o[s]);for(s=0;s<h;++s)(c=t[s])&&u[f[s]]===c&&(i[s]=c)}function xe(e,t){return e<t?-1:e>t?1:e>=t?0:NaN}var _e="http://www.w3.org/1999/xhtml",Ee={svg:"http://www.w3.org/2000/svg",xhtml:_e,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"},Se=function(e){var t=e+="",n=t.indexOf(":");return n>=0&&"xmlns"!==(t=e.slice(0,n))&&(e=e.slice(n+1)),Ee.hasOwnProperty(t)?{space:Ee[t],local:e}:e};function Ce(e){return function(){this.removeAttribute(e)}}function Ae(e){return function(){this.removeAttributeNS(e.space,e.local)}}function Te(e,t){return function(){this.setAttribute(e,t)}}function Me(e,t){return function(){this.setAttributeNS(e.space,e.local,t)}}function Oe(e,t){return function(){var n=t.apply(this,arguments);null==n?this.removeAttribute(e):this.setAttribute(e,n)}}function ke(e,t){return function(){var n=t.apply(this,arguments);null==n?this.removeAttributeNS(e.space,e.local):this.setAttributeNS(e.space,e.local,n)}}var Re=function(e){return e.ownerDocument&&e.ownerDocument.defaultView||e.document&&e||e.defaultView};function Pe(e){return function(){this.style.removeProperty(e)}}function Le(e,t,n){return function(){this.style.setProperty(e,t,n)}}function Fe(e,t,n){return function(){var r=t.apply(this,arguments);null==r?this.style.removeProperty(e):this.style.setProperty(e,r,n)}}function je(e,t){return e.style.getPropertyValue(t)||Re(e).getComputedStyle(e,null).getPropertyValue(t)}function De(e){return function(){delete this[e]}}function Ne(e,t){return function(){this[e]=t}}function Ie(e,t){return function(){var n=t.apply(this,arguments);null==n?delete this[e]:this[e]=n}}function Be(e){return e.trim().split(/^|\s+/)}function ze(e){return e.classList||new Ue(e)}function Ue(e){this._node=e,this._names=Be(e.getAttribute("class")||"")}function He(e,t){for(var n=ze(e),r=-1,i=t.length;++r<i;)n.add(t[r])}function Ve(e,t){for(var n=ze(e),r=-1,i=t.length;++r<i;)n.remove(t[r])}function $e(e){return function(){He(this,e)}}function We(e){return function(){Ve(this,e)}}function Ge(e,t){return function(){(t.apply(this,arguments)?He:Ve)(this,e)}}Ue.prototype={add:function(e){this._names.indexOf(e)<0&&(this._names.push(e),this._node.setAttribute("class",this._names.join(" ")))},remove:function(e){var t=this._names.indexOf(e);t>=0&&(this._names.splice(t,1),this._node.setAttribute("class",this._names.join(" ")))},contains:function(e){return this._names.indexOf(e)>=0}};function qe(){this.textContent=""}functi