# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.8
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.





from sys import version_info
if version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_libfdt', [dirname(__file__)])
        except ImportError:
            import _libfdt
            return _libfdt
        if fp is not None:
            try:
                _mod = imp.load_module('_libfdt', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _libfdt = swig_import_helper()
    del swig_import_helper
else:
    import _libfdt
del version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.


def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr_nondynamic(self, class_type, name, static=1):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    if (not static):
        return object.__getattr__(self, name)
    else:
        raise AttributeError(name)

def _swig_getattr(self, class_type, name):
    return _swig_getattr_nondynamic(self, class_type, name, 0)


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object:
        pass
    _newclass = 0




import struct

# Error codes, corresponding to FDT_ERR_... in libfdt.h
(NOTFOUND,
        EXISTS,
        NOSPACE,
        BADOFFSET,
        BADPATH,
        BADPHANDLE,
        BADSTATE,
        TRUNCATED,
        BADMAGIC,
        BADVERSION,
        BADSTRUCTURE,
        BADLAYOUT,
        INTERNAL,
        BADNCELLS,
        BADVALUE,
        BADOVERLAY,
        NOPHANDLES) = QUIET_ALL = range(1, 18)
# QUIET_ALL can be passed as the 'quiet' parameter to avoid exceptions
# altogether. All # functions passed this value will return an error instead
# of raising an exception.

# Pass this as the 'quiet' parameter to return -ENOTFOUND on NOTFOUND errors,
# instead of raising an exception.
QUIET_NOTFOUND = (NOTFOUND,)
QUIET_NOSPACE = (NOSPACE,)


class FdtException(Exception):
    """An exception caused by an error such as one of the codes above"""
    def __init__(self, err):
        self.err = err

    def __str__(self):
        return 'pylibfdt error %d: %s' % (self.err, fdt_strerror(self.err))

def strerror(fdt_err):
    """Get the string for an error number

    Args:
        fdt_err: Error number (-ve)

    Returns:
        String containing the associated error
    """
    return fdt_strerror(fdt_err)

def check_err(val, quiet=()):
    """Raise an error if the return value is -ve

    This is used to check for errors returned by libfdt C functions.

    Args:
        val: Return value from a libfdt function
        quiet: Errors to ignore (empty to raise on all errors)

    Returns:
        val if val >= 0

    Raises
        FdtException if val < 0
    """
    if isinstance(val, int) and val < 0:
        if -val not in quiet:
            raise FdtException(val)
    return val

def check_err_null(val, quiet=()):
    """Raise an error if the return value is NULL

    This is used to check for a NULL return value from certain libfdt C
    functions

    Args:
        val: Return value from a libfdt function
        quiet: Errors to ignore (empty to raise on all errors)

    Returns:
        val if val is a list, None if not

    Raises
        FdtException if val indicates an error was reported and the error
        is not in @quiet.
    """
# Normally a list is returned which contains the data and its length.
# If we get just an integer error code, it means the function failed.
    if not isinstance(val, list):
        if -val not in quiet:
            raise FdtException(val)
    return val

class FdtRo(object):
    """Class for a read-only device-tree

    This is a base class used by FdtRw (read-write access) and FdtSw
    (sequential-write access). It implements read-only access to the
    device tree.

    Here are the three classes and when you should use them:

        FdtRo - read-only access to an existing FDT
        FdtRw - read-write access to an existing FDT (most common case)
        FdtSw - for creating a new FDT, as well as allowing read-only access
    """
    def __init__(self, data):
        self._fdt = bytearray(data)
        check_err(fdt_check_header(self._fdt));

    def as_bytearray(self):
        """Get the device tree contents as a bytearray

        This can be passed directly to libfdt functions that access a
        const void * for the device tree.

        Returns:
            bytearray containing the device tree
        """
        return bytearray(self._fdt)

    def next_node(self, nodeoffset, depth, quiet=()):
        """Find the next subnode

        Args:
            nodeoffset: Node offset of previous node
            depth: The depth of the node at nodeoffset. This is used to
                calculate the depth of the returned node
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Typle:
                Offset of the next node, if any, else a -ve error
                Depth of the returned node, if any, else undefined

        Raises:
            FdtException if no more nodes found or other error occurs
        """
        return check_err(fdt_next_node(self._fdt, nodeoffset, depth), quiet)

    def first_subnode(self, nodeoffset, quiet=()):
        """Find the first subnode of a parent node

        Args:
            nodeoffset: Node offset of parent node
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            The offset of the first subnode, if any

        Raises:
            FdtException if no subnodes found or other error occurs
        """
        return check_err(fdt_first_subnode(self._fdt, nodeoffset), quiet)

    def next_subnode(self, nodeoffset, quiet=()):
        """Find the next subnode

        Args:
            nodeoffset: Node offset of previous subnode
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            The offset of the next subnode, if any

        Raises:
            FdtException if no more subnodes found or other error occurs
        """
        return check_err(fdt_next_subnode(self._fdt, nodeoffset), quiet)

    def magic(self):
        """Return the magic word from the header

        Returns:
            Magic word
        """
        return fdt_magic(self._fdt)

    def totalsize(self):
        """Return the total size of the device tree

        Returns:
            Total tree size in bytes
        """
        return fdt_totalsize(self._fdt)

    def off_dt_struct(self):
        """Return the start of the device-tree struct area

        Returns:
            Start offset of struct area
        """
        return fdt_off_dt_struct(self._fdt)

    def off_dt_strings(self):
        """Return the start of the device-tree string area

        Returns:
            Start offset of string area
        """
        return fdt_off_dt_strings(self._fdt)

    def off_mem_rsvmap(self):
        """Return the start of the memory reserve map

        Returns:
            Start offset of memory reserve map
        """
        return fdt_off_mem_rsvmap(self._fdt)

    def version(self):
        """Return the version of the device tree

        Returns:
            Version number of the device tree
        """
        return fdt_version(self._fdt)

    def last_comp_version(self):
        """Return the last compatible version of the device tree

        Returns:
            Last compatible version number of the device tree
        """
        return fdt_last_comp_version(self._fdt)

    def boot_cpuid_phys(self):
        """Return the physical boot CPU ID

        Returns:
            Physical boot CPU ID
        """
        return fdt_boot_cpuid_phys(self._fdt)

    def size_dt_strings(self):
        """Return the start of the device-tree string area

        Returns:
            Start offset of string area
        """
        return fdt_size_dt_strings(self._fdt)

    def size_dt_struct(self):
        """Return the start of the device-tree struct area

        Returns:
            Start offset of struct area
        """
        return fdt_size_dt_struct(self._fdt)

    def num_mem_rsv(self, quiet=()):
        """Return the number of memory reserve-map records

        Returns:
            Number of memory reserve-map records
        """
        return check_err(fdt_num_mem_rsv(self._fdt), quiet)

    def get_mem_rsv(self, index, quiet=()):
        """Return the indexed memory reserve-map record

        Args:
            index: Record to return (0=first)

        Returns:
            Number of memory reserve-map records
        """
        return check_err(fdt_get_mem_rsv(self._fdt, index), quiet)

    def subnode_offset(self, parentoffset, name, quiet=()):
        """Get the offset of a named subnode

        Args:
            parentoffset: Offset of the parent node to check
            name: Name of the required subnode, e.g. 'subnode@1'
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            The node offset of the found node, if any

        Raises
            FdtException if there is no node with that name, or other error
        """
        return check_err(fdt_subnode_offset(self._fdt, parentoffset, name),
                         quiet)

    def path_offset(self, path, quiet=()):
        """Get the offset for a given path

        Args:
            path: Path to the required node, e.g. '/node@3/subnode@1'
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Node offset

        Raises
            FdtException if the path is not valid or not found
        """
        return check_err(fdt_path_offset(self._fdt, path), quiet)

    def get_name(self, nodeoffset):
        """Get the name of a node

        Args:
            nodeoffset: Offset of node to check

        Returns:
            Node name

        Raises:
            FdtException on error (e.g. nodeoffset is invalid)
        """
        return check_err_null(fdt_get_name(self._fdt, nodeoffset))[0]

    def first_property_offset(self, nodeoffset, quiet=()):
        """Get the offset of the first property in a node offset

        Args:
            nodeoffset: Offset to the node to check
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Offset of the first property

        Raises
            FdtException if the associated node has no properties, or some
                other error occurred
        """
        return check_err(fdt_first_property_offset(self._fdt, nodeoffset),
                         quiet)

    def next_property_offset(self, prop_offset, quiet=()):
        """Get the next property in a node

        Args:
            prop_offset: Offset of the previous property
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Offset of the next property

        Raises:
            FdtException if the associated node has no more properties, or
                some other error occurred
        """
        return check_err(fdt_next_property_offset(self._fdt, prop_offset),
                         quiet)

    def get_property_by_offset(self, prop_offset, quiet=()):
        """Obtains a property that can be examined

        Args:
            prop_offset: Offset of property (e.g. from first_property_offset())
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Property object, or None if not found

        Raises:
            FdtException on error (e.g. invalid prop_offset or device
            tree format)
        """
        pdata = check_err_null(
                fdt_get_property_by_offset(self._fdt, prop_offset), quiet)
        if isinstance(pdata, (int)):
            return pdata
        return Property(pdata[0], pdata[1])

    def getprop(self, nodeoffset, prop_name, quiet=()):
        """Get a property from a node

        Args:
            nodeoffset: Node offset containing property to get
            prop_name: Name of property to get
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Value of property as a Property object (which can be used as a
               bytearray/string), or -ve error number. On failure, returns an
               integer error

        Raises:
            FdtError if any error occurs (e.g. the property is not found)
        """
        pdata = check_err_null(fdt_getprop(self._fdt, nodeoffset, prop_name),
                               quiet)
        if isinstance(pdata, (int)):
            return pdata
        return Property(prop_name, bytearray(pdata[0]))

    def get_phandle(self, nodeoffset):
        """Get the phandle of a node

        Args:
            nodeoffset: Node offset to check

        Returns:
            phandle of node, or 0 if the node has no phandle or another error
            occurs
        """
        return fdt_get_phandle(self._fdt, nodeoffset)

    def parent_offset(self, nodeoffset, quiet=()):
        """Get the offset of a node's parent

        Args:
            nodeoffset: Node offset to check
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            The offset of the parent node, if any

        Raises:
            FdtException if no parent found or other error occurs
        """
        return check_err(fdt_parent_offset(self._fdt, nodeoffset), quiet)

    def node_offset_by_phandle(self, phandle, quiet=()):
        """Get the offset of a node with the given phandle

        Args:
            phandle: Phandle to search for
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            The offset of node with that phandle, if any

        Raises:
            FdtException if no node found or other error occurs
        """
        return check_err(fdt_node_offset_by_phandle(self._fdt, phandle), quiet)


class Fdt(FdtRo):
    """Device tree class, supporting all operations

    The Fdt object is created is created from a device tree binary file,
    e.g. with something like:

       fdt = Fdt(open("filename.dtb").read())

    Operations can then be performed using the methods in this class. Each
    method xxx(args...) corresponds to a libfdt function fdt_xxx(fdt, args...).

    All methods raise an FdtException if an error occurs. To avoid this
    behaviour a 'quiet' parameter is provided for some functions. This
    defaults to empty, but you can pass a list of errors that you expect.
    If one of these errors occurs, the function will return an error number
    (e.g. -NOTFOUND).
    """
    def __init__(self, data):
        FdtRo.__init__(self, data)

    @staticmethod
    def create_empty_tree(size, quiet=()):
        """Create an empty device tree ready for use

        Args:
            size: Size of device tree in bytes

        Returns:
            Fdt object containing the device tree
        """
        data = bytearray(size)
        err = check_err(fdt_create_empty_tree(data, size), quiet)
        if err:
            return err
        return Fdt(data)

    def resize(self, size, quiet=()):
        """Move the device tree into a larger or smaller space

        This creates a new device tree of size @size and moves the existing
        device tree contents over to that. It can be used to create more space
        in a device tree. Note that the Fdt object remains the same, but it
        now has a new bytearray holding the contents.

        Args:
            size: Required new size of device tree in bytes
        """
        fdt = bytearray(size)
        err = check_err(fdt_open_into(self._fdt, fdt, size), quiet)
        if err:
            return err
        self._fdt = fdt

    def pack(self, quiet=()):
        """Pack the device tree to remove unused space

        This adjusts the tree in place.

        Args:
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtException if any error occurs
        """
        err = check_err(fdt_pack(self._fdt), quiet)
        if err:
            return err
        del self._fdt[self.totalsize():]
        return err

    def set_name(self, nodeoffset, name, quiet=()):
        """Set the name of a node

        Args:
            nodeoffset: Node offset of node to update
            name: New node name (string without \0)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtException if no parent found or other error occurs
        """
        if chr(0) in name:
            raise ValueError('Property contains embedded nul characters')
        return check_err(fdt_set_name(self._fdt, nodeoffset, name), quiet)

    def setprop(self, nodeoffset, prop_name, val, quiet=()):
        """Set the value of a property

        Args:
            nodeoffset: Node offset containing the property to create/update
            prop_name: Name of property
            val: Value to write (string or bytearray)
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtException if no parent found or other error occurs
        """
        return check_err(fdt_setprop(self._fdt, nodeoffset, prop_name, val,
                                     len(val)), quiet)

    def setprop_u32(self, nodeoffset, prop_name, val, quiet=()):
        """Set the value of a property

        Args:
            nodeoffset: Node offset containing the property to create/update
            prop_name: Name of property
            val: Value to write (integer)
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtException if no parent found or other error occurs
        """
        return check_err(fdt_setprop_u32(self._fdt, nodeoffset, prop_name, val),
                         quiet)

    def setprop_u64(self, nodeoffset, prop_name, val, quiet=()):
        """Set the value of a property

        Args:
            nodeoffset: Node offset containing the property to create/update
            prop_name: Name of property
            val: Value to write (integer)
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtException if no parent found or other error occurs
        """
        return check_err(fdt_setprop_u64(self._fdt, nodeoffset, prop_name, val),
                         quiet)

    def setprop_str(self, nodeoffset, prop_name, val, quiet=()):
        """Set the string value of a property

        The property is set to the string, with a nul terminator added

        Args:
            nodeoffset: Node offset containing the property to create/update
            prop_name: Name of property
            val: Value to write (string without nul terminator). Unicode is
                supposed by encoding to UTF-8
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtException if no parent found or other error occurs
        """
        val = val.encode('utf-8') + b'\0'
        return check_err(fdt_setprop(self._fdt, nodeoffset, prop_name,
                                     val, len(val)), quiet)

    def delprop(self, nodeoffset, prop_name, quiet=()):
        """Delete a property from a node

        Args:
            nodeoffset: Node offset containing property to delete
            prop_name: Name of property to delete
            quiet: Errors to ignore (empty to raise on all errors)

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtError if the property does not exist, or another error occurs
        """
        return check_err(fdt_delprop(self._fdt, nodeoffset, prop_name), quiet)

    def add_subnode(self, parentoffset, name, quiet=()):
        """Add a new subnode to a node

        Args:
            parentoffset: Parent offset to add the subnode to
            name: Name of node to add

        Returns:
            offset of the node created, or negative error code on failure

        Raises:
            FdtError if there is not enough space, or another error occurs
        """
        return check_err(fdt_add_subnode(self._fdt, parentoffset, name), quiet)

    def del_node(self, nodeoffset, quiet=()):
        """Delete a node

        Args:
            nodeoffset: Offset of node to delete

        Returns:
            Error code, or 0 if OK

        Raises:
            FdtError if an error occurs
        """
        return check_err(fdt_del_node(self._fdt, nodeoffset), quiet)


class Property(bytearray):
    """Holds a device tree property name and value.

    This holds a copy of a property taken from the device tree. It does not
    reference the device tree, so if anything changes in the device tree,
    a Property object will remain valid.

    Properties:
        name: Property name
        value: Property value as a bytearray
    """
    def __init__(self, name, value):
        bytearray.__init__(self, value)
        self.name = name

    def as_cell(self, fmt):
        return struct.unpack('>' + fmt, self)[0]

    def as_uint32(self):
        return self.as_cell('L')

    def as_int32(self):
        return self.as_cell('l')

    def as_uint64(self):
        return self.as_cell('Q')

    def as_int64(self):
        return self.as_cell('q')

    def as_str(self):
        """Unicode is supported by decoding from UTF-8"""
        if self[-1] != 0:
            raise ValueError('Property lacks nul termination')
        if 0 in self[:-1]:
            raise ValueError('Property contains embedded nul characters')
        return self[:-1].decode('utf-8')


class FdtSw(FdtRo):
    """Software interface to create a device tree from scratch

    The methods in this class work by adding to an existing 'partial' device
    tree buffer of a fixed size created by instantiating this class. When the
    tree is complete, call as_fdt() to obtain a device tree ready to be used.

    Similarly with nodes, a new node is started with begin_node() and finished
    with end_node().

    The context manager functions can be used to make this a bit easier:

# First create the device tree with a node and property:
    sw = FdtSw()
    with sw.add_node('node'):
        sw.property_u32('reg', 2)
    fdt = sw.as_fdt()

# Now we can use it as a real device tree
    fdt.setprop_u32(0, 'reg', 3)

    The size hint provides a starting size for the space to be used by the
    device tree. This will be increased automatically as needed as new items
    are added to the tree.
    """
    INC_SIZE = 1024  # Expand size by this much when out of space

    def __init__(self, size_hint=None):
        """Create a new FdtSw object

        Args:
            size_hint: A hint as to the initial size to use

        Raises:
            ValueError if size_hint is negative

        Returns:
            FdtSw object on success, else integer error code (if not raising)
        """
        if not size_hint:
            size_hint = self.INC_SIZE
        fdtsw = bytearray(size_hint)
        err = check_err(fdt_create(fdtsw, size_hint))
        if err:
            return err
        self._fdt = fdtsw

    def as_fdt(self):
        """Convert a FdtSw into an Fdt so it can be accessed as normal

        Creates a new Fdt object from the work-in-progress device tree. This
        does not call fdt_finish() on the current object, so it is possible to
        add more nodes/properties and call as_fdt() again to get an updated
        tree.

        Returns:
            Fdt object allowing access to the newly created device tree
        """
        fdtsw = bytearray(self._fdt)
        check_err(fdt_finish(fdtsw))
        return Fdt(fdtsw)

    def check_space(self, val):
        """Check if we need to add more space to the FDT

        This should be called with the error code from an operation. If this is
        -NOSPACE then the FDT will be expanded to have more space, and True will
        be returned, indicating that the operation needs to be tried again.

        Args:
            val: Return value from the operation that was attempted

        Returns:
            True if the operation must be retried, else False
        """
        if check_err(val, QUIET_NOSPACE) < 0:
            self.resize(len(self._fdt) + self.INC_SIZE)
            return True
        return False

    def resize(self, size):
        """Resize the buffer to accommodate a larger tree

        Args:
            size: New size of tree

        Raises:
            FdtException on any error
        """
        fdt = bytearray(size)
        err = check_err(fdt_resize(self._fdt, fdt, size))
        self._fdt = fdt

    def add_reservemap_entry(self, addr, size):
        """Add a new memory reserve map entry

        Once finished adding, you must call finish_reservemap().

        Args:
            addr: 64-bit start address
            size: 64-bit size

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_add_reservemap_entry(self._fdt, addr,
                                                        size)):
            pass

    def finish_reservemap(self):
        """Indicate that there are no more reserve map entries to add

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_finish_reservemap(self._fdt)):
            pass

    def begin_node(self, name):
        """Begin a new node

        Use this before adding properties to the node. Then call end_node() to
        finish it. You can also use the context manager as shown in the FdtSw
        class comment.

        Args:
            name: Name of node to begin

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_begin_node(self._fdt, name)):
            pass

    def property_string(self, name, string):
        """Add a property with a string value

        The string will be nul-terminated when written to the device tree

        Args:
            name: Name of property to add
            string: String value of property

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_property_string(self._fdt, name, string)):
            pass

    def property_u32(self, name, val):
        """Add a property with a 32-bit value

        Write a single-cell value to the device tree

        Args:
            name: Name of property to add
            val: Value of property

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_property_u32(self._fdt, name, val)):
            pass

    def property_u64(self, name, val):
        """Add a property with a 64-bit value

        Write a double-cell value to the device tree in big-endian format

        Args:
            name: Name of property to add
            val: Value of property

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_property_u64(self._fdt, name, val)):
            pass

    def property_cell(self, name, val):
        """Add a property with a single-cell value

        Write a single-cell value to the device tree

        Args:
            name: Name of property to add
            val: Value of property
            quiet: Errors to ignore (empty to raise on all errors)

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_property_cell(self._fdt, name, val)):
            pass

    def property(self, name, val):
        """Add a property

        Write a new property with the given value to the device tree. The value
        is taken as is and is not nul-terminated

        Args:
            name: Name of property to add
            val: Value of property
            quiet: Errors to ignore (empty to raise on all errors)

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_property_stub(self._fdt, name, val,
                                                 len(val))):
            pass

    def end_node(self):
        """End a node

        Use this after adding properties to a node to close it off. You can also
        use the context manager as shown in the FdtSw class comment.

        Args:
            quiet: Errors to ignore (empty to raise on all errors)

        Raises:
            FdtException on any error
        """
        while self.check_space(fdt_end_node(self._fdt)):
            pass

    def add_node(self, name):
        """Create a new context for adding a node

        When used in a 'with' clause this starts a new node and finishes it
        afterward.

        Args:
            name: Name of node to add
        """
        return NodeAdder(self, name)


class NodeAdder():
    """Class to provide a node context

    This allows you to add nodes in a more natural way:

        with fdtsw.add_node('name'):
            fdtsw.property_string('test', 'value')

    The node is automatically completed with a call to end_node() when the
    context exits.
    """
    def __init__(self, fdtsw, name):
        self._fdt = fdtsw
        self._name = name

    def __enter__(self):
        self._fdt.begin_node(self._name)

    def __exit__(self, type, value, traceback):
        self._fdt.end_node()

class fdt_header(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, fdt_header, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, fdt_header, name)
    __repr__ = _swig_repr
    __swig_setmethods__["magic"] = _libfdt.fdt_header_magic_set
    __swig_getmethods__["magic"] = _libfdt.fdt_header_magic_get
    if _newclass:
        magic = _swig_property(_libfdt.fdt_header_magic_get, _libfdt.fdt_header_magic_set)
    __swig_setmethods__["totalsize"] = _libfdt.fdt_header_totalsize_set
    __swig_getmethods__["totalsize"] = _libfdt.fdt_header_totalsize_get
    if _newclass:
        totalsize = _swig_property(_libfdt.fdt_header_totalsize_get, _libfdt.fdt_header_totalsize_set)
    __swig_setmethods__["off_dt_struct"] = _libfdt.fdt_header_off_dt_struct_set
    __swig_getmethods__["off_dt_struct"] = _libfdt.fdt_header_off_dt_struct_get
    if _newclass:
        off_dt_struct = _swig_property(_libfdt.fdt_header_off_dt_struct_get, _libfdt.fdt_header_off_dt_struct_set)
    __swig_setmethods__["off_dt_strings"] = _libfdt.fdt_header_off_dt_strings_set
    __swig_getmethods__["off_dt_strings"] = _libfdt.fdt_header_off_dt_strings_get
    if _newclass:
        off_dt_strings = _swig_property(_libfdt.fdt_header_off_dt_strings_get, _libfdt.fdt_header_off_dt_strings_set)
    __swig_setmethods__["off_mem_rsvmap"] = _libfdt.fdt_header_off_mem_rsvmap_set
    __swig_getmethods__["off_mem_rsvmap"] = _libfdt.fdt_header_off_mem_rsvmap_get
    if _newclass:
        off_mem_rsvmap = _swig_property(_libfdt.fdt_header_off_mem_rsvmap_get, _libfdt.fdt_header_off_mem_rsvmap_set)
    __swig_setmethods__["version"] = _libfdt.fdt_header_version_set
    __swig_getmethods__["version"] = _libfdt.fdt_header_version_get
    if _newclass:
        version = _swig_property(_libfdt.fdt_header_version_get, _libfdt.fdt_header_version_set)
    __swig_setmethods__["last_comp_version"] = _libfdt.fdt_header_last_comp_version_set
    __swig_getmethods__["last_comp_version"] = _libfdt.fdt_header_last_comp_version_get
    if _newclass:
        last_comp_version = _swig_property(_libfdt.fdt_header_last_comp_version_get, _libfdt.fdt_header_last_comp_version_set)
    __swig_setmethods__["boot_cpuid_phys"] = _libfdt.fdt_header_boot_cpuid_phys_set
    __swig_getmethods__["boot_cpuid_phys"] = _libfdt.fdt_header_boot_cpuid_phys_get
    if _newclass:
        boot_cpuid_phys = _swig_property(_libfdt.fdt_header_boot_cpuid_phys_get, _libfdt.fdt_header_boot_cpuid_phys_set)
    __swig_setmethods__["size_dt_strings"] = _libfdt.fdt_header_size_dt_strings_set
    __swig_getmethods__["size_dt_strings"] = _libfdt.fdt_header_size_dt_strings_get
    if _newclass:
        size_dt_strings = _swig_property(_libfdt.fdt_header_size_dt_strings_get, _libfdt.fdt_header_size_dt_strings_set)
    __swig_setmethods__["size_dt_struct"] = _libfdt.fdt_header_size_dt_struct_set
    __swig_getmethods__["size_dt_struct"] = _libfdt.fdt_header_size_dt_struct_get
    if _newclass:
        size_dt_struct = _swig_property(_libfdt.fdt_header_size_dt_struct_get, _libfdt.fdt_header_size_dt_struct_set)

    def __init__(self):
        this = _libfdt.new_fdt_header()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _libfdt.delete_fdt_header
    __del__ = lambda self: None
fdt_header_swigregister = _libfdt.fdt_header_swigregister
fdt_header_swigregister(fdt_header)

class fdt_reserve_entry(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, fdt_reserve_entry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, fdt_reserve_entry, name)
    __repr__ = _swig_repr
    __swig_setmethods__["address"] = _libfdt.fdt_reserve_entry_address_set
    __swig_getmethods__["address"] = _libfdt.fdt_reserve_entry_address_get
    if _newclass:
        address = _swig_property(_libfdt.fdt_reserve_entry_address_get, _libfdt.fdt_reserve_entry_address_set)
    __swig_setmethods__["size"] = _libfdt.fdt_reserve_entry_size_set
    __swig_getmethods__["size"] = _libfdt.fdt_reserve_entry_size_get
    if _newclass:
        size = _swig_property(_libfdt.fdt_reserve_entry_size_get, _libfdt.fdt_reserve_entry_size_set)

    def __init__(self):
        this = _libfdt.new_fdt_reserve_entry()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _libfdt.delete_fdt_reserve_entry
    __del__ = lambda self: None
fdt_reserve_entry_swigregister = _libfdt.fdt_reserve_entry_swigregister
fdt_reserve_entry_swigregister(fdt_reserve_entry)

class fdt_node_header(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, fdt_node_header, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, fdt_node_header, name)
    __repr__ = _swig_repr
    __swig_setmethods__["tag"] = _libfdt.fdt_node_header_tag_set
    __swig_getmethods__["tag"] = _libfdt.fdt_node_header_tag_get
    if _newclass:
        tag = _swig_property(_libfdt.fdt_node_header_tag_get, _libfdt.fdt_node_header_tag_set)
    __swig_setmethods__["name"] = _libfdt.fdt_node_header_name_set
    __swig_getmethods__["name"] = _libfdt.fdt_node_header_name_get
    if _newclass:
        name = _swig_property(_libfdt.fdt_node_header_name_get, _libfdt.fdt_node_header_name_set)

    def __init__(self):
        this = _libfdt.new_fdt_node_header()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _libfdt.delete_fdt_node_header
    __del__ = lambda self: None
fdt_node_header_swigregister = _libfdt.fdt_node_header_swigregister
fdt_node_header_swigregister(fdt_node_header)

class fdt_property(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, fdt_property, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, fdt_property, name)
    __repr__ = _swig_repr
    __swig_setmethods__["tag"] = _libfdt.fdt_property_tag_set
    __swig_getmethods__["tag"] = _libfdt.fdt_property_tag_get
    if _newclass:
        tag = _swig_property(_libfdt.fdt_property_tag_get, _libfdt.fdt_property_tag_set)
    __swig_setmethods__["len"] = _libfdt.fdt_property_len_set
    __swig_getmethods__["len"] = _libfdt.fdt_property_len_get
    if _newclass:
        len = _swig_property(_libfdt.fdt_property_len_get, _libfdt.fdt_property_len_set)
    __swig_setmethods__["nameoff"] = _libfdt.fdt_property_nameoff_set
    __swig_getmethods__["nameoff"] = _libfdt.fdt_property_nameoff_get
    if _newclass:
        nameoff = _swig_property(_libfdt.fdt_property_nameoff_get, _libfdt.fdt_property_nameoff_set)
    __swig_setmethods__["data"] = _libfdt.fdt_property_data_set
    __swig_getmethods__["data"] = _libfdt.fdt_property_data_get
    if _newclass:
        data = _swig_property(_libfdt.fdt_property_data_get, _libfdt.fdt_property_data_set)

    def __init__(self):
        this = _libfdt.new_fdt_property()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _libfdt.delete_fdt_property
    __del__ = lambda self: None
fdt_property_swigregister = _libfdt.fdt_property_swigregister
fdt_property_swigregister(fdt_property)


_libfdt.FDT_MAGIC_swigconstant(_libfdt)
FDT_MAGIC = _libfdt.FDT_MAGIC

_libfdt.FDT_BEGIN_NODE_swigconstant(_libfdt)
FDT_BEGIN_NODE = _libfdt.FDT_BEGIN_NODE

_libfdt.FDT_END_NODE_swigconstant(_libfdt)
FDT_END_NODE = _libfdt.FDT_END_NODE

_libfdt.FDT_PROP_swigconstant(_libfdt)
FDT_PROP = _libfdt.FDT_PROP

_libfdt.FDT_NOP_swigconstant(_libfdt)
FDT_NOP = _libfdt.FDT_NOP

_libfdt.FDT_END_swigconstant(_libfdt)
FDT_END = _libfdt.FDT_END

def fdt_magic(fdt):
    return _libfdt.fdt_magic(fdt)
fdt_magic = _libfdt.fdt_magic

def fdt_totalsize(fdt):
    return _libfdt.fdt_totalsize(fdt)
fdt_totalsize = _libfdt.fdt_totalsize

def fdt_off_dt_struct(fdt):
    return _libfdt.fdt_off_dt_struct(fdt)
fdt_off_dt_struct = _libfdt.fdt_off_dt_struct

def fdt_off_dt_strings(fdt):
    return _libfdt.fdt_off_dt_strings(fdt)
fdt_off_dt_strings = _libfdt.fdt_off_dt_strings

def fdt_off_mem_rsvmap(fdt):
    return _libfdt.fdt_off_mem_rsvmap(fdt)
fdt_off_mem_rsvmap = _libfdt.fdt_off_mem_rsvmap

def fdt_version(fdt):
    return _libfdt.fdt_version(fdt)
fdt_version = _libfdt.fdt_version

def fdt_last_comp_version(fdt):
    return _libfdt.fdt_last_comp_version(fdt)
fdt_last_comp_version = _libfdt.fdt_last_comp_version

def fdt_boot_cpuid_phys(fdt):
    return _libfdt.fdt_boot_cpuid_phys(fdt)
fdt_boot_cpuid_phys = _libfdt.fdt_boot_cpuid_phys

def fdt_size_dt_strings(fdt):
    return _libfdt.fdt_size_dt_strings(fdt)
fdt_size_dt_strings = _libfdt.fdt_size_dt_strings

def fdt_size_dt_struct(fdt):
    return _libfdt.fdt_size_dt_struct(fdt)
fdt_size_dt_struct = _libfdt.fdt_size_dt_struct

def fdt_property_string(fdt, name, val):
    return _libfdt.fdt_property_string(fdt, name, val)
fdt_property_string = _libfdt.fdt_property_string

def fdt_property_cell(fdt, name, val):
    return _libfdt.fdt_property_cell(fdt, name, val)
fdt_property_cell = _libfdt.fdt_property_cell

def fdt_property_stub(fdt, name, val, len):
    return _libfdt.fdt_property_stub(fdt, name, val, len)
fdt_property_stub = _libfdt.fdt_property_stub

_libfdt.FDT_FIRST_SUPPORTED_VERSION_swigconstant(_libfdt)
FDT_FIRST_SUPPORTED_VERSION = _libfdt.FDT_FIRST_SUPPORTED_VERSION

_libfdt.FDT_LAST_SUPPORTED_VERSION_swigconstant(_libfdt)
FDT_LAST_SUPPORTED_VERSION = _libfdt.FDT_LAST_SUPPORTED_VERSION

_libfdt.FDT_ERR_NOTFOUND_swigconstant(_libfdt)
FDT_ERR_NOTFOUND = _libfdt.FDT_ERR_NOTFOUND

_libfdt.FDT_ERR_EXISTS_swigconstant(_libfdt)
FDT_ERR_EXISTS = _libfdt.FDT_ERR_EXISTS

_libfdt.FDT_ERR_NOSPACE_swigconstant(_libfdt)
FDT_ERR_NOSPACE = _libfdt.FDT_ERR_NOSPACE

_libfdt.FDT_ERR_BADOFFSET_swigconstant(_libfdt)
FDT_ERR_BADOFFSET = _libfdt.FDT_ERR_BADOFFSET

_libfdt.FDT_ERR_BADPATH_swigconstant(_libfdt)
FDT_ERR_BADPATH = _libfdt.FDT_ERR_BADPATH

_libfdt.FDT_ERR_BADPHANDLE_swigconstant(_libfdt)
FDT_ERR_BADPHANDLE = _libfdt.FDT_ERR_BADPHANDLE

_libfdt.FDT_ERR_BADSTATE_swigconstant(_libfdt)
FDT_ERR_BADSTATE = _libfdt.FDT_ERR_BADSTATE

_libfdt.FDT_ERR_TRUNCATED_swigconstant(_libfdt)
FDT_ERR_TRUNCATED = _libfdt.FDT_ERR_TRUNCATED

_libfdt.FDT_ERR_BADMAGIC_swigconstant(_libfdt)
FDT_ERR_BADMAGIC = _libfdt.FDT_ERR_BADMAGIC

_libfdt.FDT_ERR_BADVERSION_swigconstant(_libfdt)
FDT_ERR_BADVERSION = _libfdt.FDT_ERR_BADVERSION

_libfdt.FDT_ERR_BADSTRUCTURE_swigconstant(_libfdt)
FDT_ERR_BADSTRUCTURE = _libfdt.FDT_ERR_BADSTRUCTURE

_libfdt.FDT_ERR_BADLAYOUT_swigconstant(_libfdt)
FDT_ERR_BADLAYOUT = _libfdt.FDT_ERR_BADLAYOUT

_libfdt.FDT_ERR_INTERNAL_swigconstant(_libfdt)
FDT_ERR_INTERNAL = _libfdt.FDT_ERR_INTERNAL

_libfdt.FDT_ERR_BADNCELLS_swigconstant(_libfdt)
FDT_ERR_BADNCELLS = _libfdt.FDT_ERR_BADNCELLS

_libfdt.FDT_ERR_BADVALUE_swigconstant(_libfdt)
FDT_ERR_BADVALUE = _libfdt.FDT_ERR_BADVALUE

_libfdt.FDT_ERR_BADOVERLAY_swigconstant(_libfdt)
FDT_ERR_BADOVERLAY = _libfdt.FDT_ERR_BADOVERLAY

_libfdt.FDT_ERR_NOPHANDLES_swigconstant(_libfdt)
FDT_ERR_NOPHANDLES = _libfdt.FDT_ERR_NOPHANDLES

_libfdt.FDT_ERR_MAX_swigconstant(_libfdt)
FDT_ERR_MAX = _libfdt.FDT_ERR_MAX

def fdt_offset_ptr_w(fdt, offset, checklen):
    return _libfdt.fdt_offset_ptr_w(fdt, offset, checklen)
fdt_offset_ptr_w = _libfdt.fdt_offset_ptr_w

def fdt_next_tag(fdt, offset, nextoffset):
    return _libfdt.fdt_next_tag(fdt, offset, nextoffset)
fdt_next_tag = _libfdt.fdt_next_tag

def fdt32_ld(p):
    return _libfdt.fdt32_ld(p)
fdt32_ld = _libfdt.fdt32_ld

def fdt64_ld(p):
    return _libfdt.fdt64_ld(p)
fdt64_ld = _libfdt.fdt64_ld

def fdt_next_node(fdt, offset, depth):
    return _libfdt.fdt_next_node(fdt, offset, depth)
fdt_next_node = _libfdt.fdt_next_node

def fdt_first_subnode(fdt, offset):
    return _libfdt.fdt_first_subnode(fdt, offset)
fdt_first_subnode = _libfdt.fdt_first_subnode

def fdt_next_subnode(fdt, offset):
    return _libfdt.fdt_next_subnode(fdt, offset)
fdt_next_subnode = _libfdt.fdt_next_subnode

def fdt_set_magic(fdt, val):
    return _libfdt.fdt_set_magic(fdt, val)
fdt_set_magic = _libfdt.fdt_set_magic

def fdt_set_totalsize(fdt, val):
    return _libfdt.fdt_set_totalsize(fdt, val)
fdt_set_totalsize = _libfdt.fdt_set_totalsize

def fdt_set_off_dt_struct(fdt, val):
    return _libfdt.fdt_set_off_dt_struct(fdt, val)
fdt_set_off_dt_struct = _libfdt.fdt_set_off_dt_struct

def fdt_set_off_dt_strings(fdt, val):
    return _libfdt.fdt_set_off_dt_strings(fdt, val)
fdt_set_off_dt_strings = _libfdt.fdt_set_off_dt_strings

def fdt_set_off_mem_rsvmap(fdt, val):
    return _libfdt.fdt_set_off_mem_rsvmap(fdt, val)
fdt_set_off_mem_rsvmap = _libfdt.fdt_set_off_mem_rsvmap

def fdt_set_version(fdt, val):
    return _libfdt.fdt_set_version(fdt, val)
fdt_set_version = _libfdt.fdt_set_version

def fdt_set_last_comp_version(fdt, val):
    return _libfdt.fdt_set_last_comp_version(fdt, val)
fdt_set_last_comp_version = _libfdt.fdt_set_last_comp_version

def fdt_set_boot_cpuid_phys(fdt, val):
    return _libfdt.fdt_set_boot_cpuid_phys(fdt, val)
fdt_set_boot_cpuid_phys = _libfdt.fdt_set_boot_cpuid_phys

def fdt_set_size_dt_strings(fdt, val):
    return _libfdt.fdt_set_size_dt_strings(fdt, val)
fdt_set_size_dt_strings = _libfdt.fdt_set_size_dt_strings

def fdt_set_size_dt_struct(fdt, val):
    return _libfdt.fdt_set_size_dt_struct(fdt, val)
fdt_set_size_dt_struct = _libfdt.fdt_set_size_dt_struct

def fdt_header_size_(version):
    return _libfdt.fdt_header_size_(version)
fdt_header_size_ = _libfdt.fdt_header_size_

def fdt_header_size(fdt):
    return _libfdt.fdt_header_size(fdt)
fdt_header_size = _libfdt.fdt_header_size

def fdt_check_header(fdt):
    return _libfdt.fdt_check_header(fdt)
fdt_check_header = _libfdt.fdt_check_header

def fdt_move(fdt, buf, bufsize):
    return _libfdt.fdt_move(fdt, buf, bufsize)
fdt_move = _libfdt.fdt_move

def fdt_check_full(fdt, bufsize):
    return _libfdt.fdt_check_full(fdt, bufsize)
fdt_check_full = _libfdt.fdt_check_full

def fdt_get_string(fdt, stroffset):
    return _libfdt.fdt_get_string(fdt, stroffset)
fdt_get_string = _libfdt.fdt_get_string

def fdt_string(fdt, stroffset):
    return _libfdt.fdt_string(fdt, stroffset)
fdt_string = _libfdt.fdt_string

def fdt_get_max_phandle(fdt):
    return _libfdt.fdt_get_max_phandle(fdt)
fdt_get_max_phandle = _libfdt.fdt_get_max_phandle

def fdt_num_mem_rsv(fdt):
    return _libfdt.fdt_num_mem_rsv(fdt)
fdt_num_mem_rsv = _libfdt.fdt_num_mem_rsv

def fdt_get_mem_rsv(fdt, n):
    return _libfdt.fdt_get_mem_rsv(fdt, n)
fdt_get_mem_rsv = _libfdt.fdt_get_mem_rsv

def fdt_subnode_offset(fdt, parentoffset, name):
    return _libfdt.fdt_subnode_offset(fdt, parentoffset, name)
fdt_subnode_offset = _libfdt.fdt_subnode_offset

def fdt_path_offset(fdt, path):
    return _libfdt.fdt_path_offset(fdt, path)
fdt_path_offset = _libfdt.fdt_path_offset

def fdt_get_name(fdt, nodeoffset):
    return _libfdt.fdt_get_name(fdt, nodeoffset)
fdt_get_name = _libfdt.fdt_get_name

def fdt_first_property_offset(fdt, nodeoffset):
    return _libfdt.fdt_first_property_offset(fdt, nodeoffset)
fdt_first_property_offset = _libfdt.fdt_first_property_offset

def fdt_next_property_offset(fdt, offset):
    return _libfdt.fdt_next_property_offset(fdt, offset)
fdt_next_property_offset = _libfdt.fdt_next_property_offset

def fdt_get_property_by_offset(fdt, offset):
    return _libfdt.fdt_get_property_by_offset(fdt, offset)
fdt_get_property_by_offset = _libfdt.fdt_get_property_by_offset

def fdt_get_property(fdt, nodeoffset, name):
    return _libfdt.fdt_get_property(fdt, nodeoffset, name)
fdt_get_property = _libfdt.fdt_get_property

def fdt_get_property_w(fdt, nodeoffset, name):
    return _libfdt.fdt_get_property_w(fdt, nodeoffset, name)
fdt_get_property_w = _libfdt.fdt_get_property_w

def fdt_getprop(fdt, nodeoffset, name):
    return _libfdt.fdt_getprop(fdt, nodeoffset, name)
fdt_getprop = _libfdt.fdt_getprop

def fdt_getprop_w(fdt, nodeoffset, name):
    return _libfdt.fdt_getprop_w(fdt, nodeoffset, name)
fdt_getprop_w = _libfdt.fdt_getprop_w

def fdt_get_phandle(fdt, nodeoffset):
    return _libfdt.fdt_get_phandle(fdt, nodeoffset)
fdt_get_phandle = _libfdt.fdt_get_phandle

def fdt_get_alias(fdt, name):
    return _libfdt.fdt_get_alias(fdt, name)
fdt_get_alias = _libfdt.fdt_get_alias

def fdt_get_path(fdt, nodeoffset, buf, buflen):
    return _libfdt.fdt_get_path(fdt, nodeoffset, buf, buflen)
fdt_get_path = _libfdt.fdt_get_path

def fdt_supernode_atdepth_offset(fdt, nodeoffset, supernodedepth, nodedepth):
    return _libfdt.fdt_supernode_atdepth_offset(fdt, nodeoffset, supernodedepth, nodedepth)
fdt_supernode_atdepth_offset = _libfdt.fdt_supernode_atdepth_offset

def fdt_node_depth(fdt, nodeoffset):
    return _libfdt.fdt_node_depth(fdt, nodeoffset)
fdt_node_depth = _libfdt.fdt_node_depth

def fdt_parent_offset(fdt, nodeoffset):
    return _libfdt.fdt_parent_offset(fdt, nodeoffset)
fdt_parent_offset = _libfdt.fdt_parent_offset

def fdt_node_offset_by_prop_value(fdt, startoffset, propname, propval, proplen):
    return _libfdt.fdt_node_offset_by_prop_value(fdt, startoffset, propname, propval, proplen)
fdt_node_offset_by_prop_value = _libfdt.fdt_node_offset_by_prop_value

def fdt_node_offset_by_phandle(fdt, phandle):
    return _libfdt.fdt_node_offset_by_phandle(fdt, phandle)
fdt_node_offset_by_phandle = _libfdt.fdt_node_offset_by_phandle

def fdt_node_check_compatible(fdt, nodeoffset, compatible):
    return _libfdt.fdt_node_check_compatible(fdt, nodeoffset, compatible)
fdt_node_check_compatible = _libfdt.fdt_node_check_compatible

def fdt_node_offset_by_compatible(fdt, startoffset, compatible):
    return _libfdt.fdt_node_offset_by_compatible(fdt, startoffset, compatible)
fdt_node_offset_by_compatible = _libfdt.fdt_node_offset_by_compatible

def fdt_stringlist_contains(strlist, listlen, str):
    return _libfdt.fdt_stringlist_contains(strlist, listlen, str)
fdt_stringlist_contains = _libfdt.fdt_stringlist_contains

def fdt_stringlist_count(fdt, nodeoffset, property):
    return _libfdt.fdt_stringlist_count(fdt, nodeoffset, property)
fdt_stringlist_count = _libfdt.fdt_stringlist_count

def fdt_stringlist_search(fdt, nodeoffset, property, string):
    return _libfdt.fdt_stringlist_search(fdt, nodeoffset, property, string)
fdt_stringlist_search = _libfdt.fdt_stringlist_search

def fdt_stringlist_get(fdt, nodeoffset, property, index):
    return _libfdt.fdt_stringlist_get(fdt, nodeoffset, property, index)
fdt_stringlist_get = _libfdt.fdt_stringlist_get

_libfdt.FDT_MAX_NCELLS_swigconstant(_libfdt)
FDT_MAX_NCELLS = _libfdt.FDT_MAX_NCELLS

def fdt_address_cells(fdt, nodeoffset):
    return _libfdt.fdt_address_cells(fdt, nodeoffset)
fdt_address_cells = _libfdt.fdt_address_cells

def fdt_size_cells(fdt, nodeoffset):
    return _libfdt.fdt_size_cells(fdt, nodeoffset)
fdt_size_cells = _libfdt.fdt_size_cells

def fdt_setprop_inplace_u32(fdt, nodeoffset, name, val):
    return _libfdt.fdt_setprop_inplace_u32(fdt, nodeoffset, name, val)
fdt_setprop_inplace_u32 = _libfdt.fdt_setprop_inplace_u32

def fdt_setprop_inplace_u64(fdt, nodeoffset, name, val):
    return _libfdt.fdt_setprop_inplace_u64(fdt, nodeoffset, name, val)
fdt_setprop_inplace_u64 = _libfdt.fdt_setprop_inplace_u64

def fdt_setprop_inplace_cell(fdt, nodeoffset, name, val):
    return _libfdt.fdt_setprop_inplace_cell(fdt, nodeoffset, name, val)
fdt_setprop_inplace_cell = _libfdt.fdt_setprop_inplace_cell

def fdt_nop_property(fdt, nodeoffset, name):
    return _libfdt.fdt_nop_property(fdt, nodeoffset, name)
fdt_nop_property = _libfdt.fdt_nop_property

def fdt_nop_node(fdt, nodeoffset):
    return _libfdt.fdt_nop_node(fdt, nodeoffset)
fdt_nop_node = _libfdt.fdt_nop_node

def fdt_create(buf, bufsize):
    return _libfdt.fdt_create(buf, bufsize)
fdt_create = _libfdt.fdt_create

def fdt_resize(fdt, buf, bufsize):
    return _libfdt.fdt_resize(fdt, buf, bufsize)
fdt_resize = _libfdt.fdt_resize

def fdt_add_reservemap_entry(fdt, addr, size):
    return _libfdt.fdt_add_reservemap_entry(fdt, addr, size)
fdt_add_reservemap_entry = _libfdt.fdt_add_reservemap_entry

def fdt_finish_reservemap(fdt):
    return _libfdt.fdt_finish_reservemap(fdt)
fdt_finish_reservemap = _libfdt.fdt_finish_reservemap

def fdt_begin_node(fdt, name):
    return _libfdt.fdt_begin_node(fdt, name)
fdt_begin_node = _libfdt.fdt_begin_node

def fdt_property_u32(fdt, name, val):
    return _libfdt.fdt_property_u32(fdt, name, val)
fdt_property_u32 = _libfdt.fdt_property_u32

def fdt_property_u64(fdt, name, val):
    return _libfdt.fdt_property_u64(fdt, name, val)
fdt_property_u64 = _libfdt.fdt_property_u64

def fdt_property_placeholder(fdt, name, len, valp):
    return _libfdt.fdt_property_placeholder(fdt, name, len, valp)
fdt_property_placeholder = _libfdt.fdt_property_placeholder

def fdt_end_node(fdt):
    return _libfdt.fdt_end_node(fdt)
fdt_end_node = _libfdt.fdt_end_node

def fdt_finish(fdt):
    return _libfdt.fdt_finish(fdt)
fdt_finish = _libfdt.fdt_finish

def fdt_create_empty_tree(buf, bufsize):
    return _libfdt.fdt_create_empty_tree(buf, bufsize)
fdt_create_empty_tree = _libfdt.fdt_create_empty_tree

def fdt_open_into(fdt, buf, bufsize):
    return _libfdt.fdt_open_into(fdt, buf, bufsize)
fdt_open_into = _libfdt.fdt_open_into

def fdt_pack(fdt):
    return _libfdt.fdt_pack(fdt)
fdt_pack = _libfdt.fdt_pack

def fdt_add_mem_rsv(fdt, address, size):
    return _libfdt.fdt_add_mem_rsv(fdt, address, size)
fdt_add_mem_rsv = _libfdt.fdt_add_mem_rsv

def fdt_del_mem_rsv(fdt, n):
    return _libfdt.fdt_del_mem_rsv(fdt, n)
fdt_del_mem_rsv = _libfdt.fdt_del_mem_rsv

def fdt_set_name(fdt, nodeoffset, name):
    return _libfdt.fdt_set_name(fdt, nodeoffset, name)
fdt_set_name = _libfdt.fdt_set_name

def fdt_setprop(fdt, nodeoffset, name, val, len):
    return _libfdt.fdt_setprop(fdt, nodeoffset, name, val, len)
fdt_setprop = _libfdt.fdt_setprop

def fdt_setprop_placeholder(fdt, nodeoffset, name, len, prop_data):
    return _libfdt.fdt_setprop_placeholder(fdt, nodeoffset, name, len, prop_data)
fdt_setprop_placeholder = _libfdt.fdt_setprop_placeholder

def fdt_setprop_u32(fdt, nodeoffset, name, val):
    return _libfdt.fdt_setprop_u32(fdt, nodeoffset, name, val)
fdt_setprop_u32 = _libfdt.fdt_setprop_u32

def fdt_setprop_u64(fdt, nodeoffset, name, val):
    return _libfdt.fdt_setprop_u64(fdt, nodeoffset, name, val)
fdt_setprop_u64 = _libfdt.fdt_setprop_u64

def fdt_setprop_cell(fdt, nodeoffset, name, val):
    return _libfdt.fdt_setprop_cell(fdt, nodeoffset, name, val)
fdt_setprop_cell = _libfdt.fdt_setprop_cell

def fdt_appendprop(fdt, nodeoffset, name, val, len):
    return _libfdt.fdt_appendprop(fdt, nodeoffset, name, val, len)
fdt_appendprop = _libfdt.fdt_appendprop

def fdt_appendprop_u32(fdt, nodeoffset, name, val):
    return _libfdt.fdt_appendprop_u32(fdt, nodeoffset, name, val)
fdt_appendprop_u32 = _libfdt.fdt_appendprop_u32

def fdt_appendprop_u64(fdt, nodeoffset, name, val):
    return _libfdt.fdt_appendprop_u64(fdt, nodeoffset, name, val)
fdt_appendprop_u64 = _libfdt.fdt_appendprop_u64

def fdt_appendprop_cell(fdt, nodeoffset, name, val):
    return _libfdt.fdt_appendprop_cell(fdt, nodeoffset, name, val)
fdt_appendprop_cell = _libfdt.fdt_appendprop_cell

def fdt_delprop(fdt, nodeoffset, name):
    return _libfdt.fdt_delprop(fdt, nodeoffset, name)
fdt_delprop = _libfdt.fdt_delprop

def fdt_add_subnode(fdt, parentoffset, name):
    return _libfdt.fdt_add_subnode(fdt, parentoffset, name)
fdt_add_subnode = _libfdt.fdt_add_subnode

def fdt_del_node(fdt, nodeoffset):
    return _libfdt.fdt_del_node(fdt, nodeoffset)
fdt_del_node = _libfdt.fdt_del_node

def fdt_overlay_apply(fdt, fdto):
    return _libfdt.fdt_overlay_apply(fdt, fdto)
fdt_overlay_apply = _libfdt.fdt_overlay_apply

def fdt_strerror(errval):
    return _libfdt.fdt_strerror(errval)
fdt_strerror = _libfdt.fdt_strerror
# This file is compatible with both classic and new-style classes.


