############################################################################
#  This Python file is part of PyFEM, the code that accompanies the book:  #
#                                                                          #
#    'Non-Linear Finite Element Analysis of Solids and Structures'         #
#    R. de Borst, M.A. Crisfield, J.J.C. Remmers and C.V. Verhoosel        #
#    John Wiley and Sons, 2012, ISBN 978-0470666449                        #
#                                                                          #
#  The code is written by J.J.C. Remmers, C.V. Verhoosel and R. de Borst.  #
#                                                                          #
#  The latest stable version can be downloaded from the web-site:          #
#     http://www.wiley.com/go/deborst                                      #
#                                                                          #
#  A github repository, with the most up to date version of the code,      #
#  can be found here:                                                      #
#     https://github.com/jjcremmers/PyFEM                                  #
#                                                                          #
#  The code is open source and intended for educational and scientific     #
#  purposes only. If you use PyFEM in your research, the developers would  #
#  be grateful if you could cite the book.                                 #  
#                                                                          #
#  Disclaimer:                                                             #
#  The authors reserve all rights but do not guarantee that the code is    #
#  free from errors. Furthermore, the authors shall not be liable in any   #
#  event caused by the use of the program.                                 #
############################################################################

from pyfem.materials.BaseMaterial import BaseMaterial
from numpy import zeros, dot

class SandwichCore( BaseMaterial ):

  def __init__ ( self, props ):

    #Call the BaseMaterial constructor
    BaseMaterial.__init__( self, props )

    if not hasattr( props , "factor" ):
      self.factor = 0.001

    if not hasattr( props , "G13" ):
      self.G13 = self.G

    if not hasattr( props , "G23" ):
      self.G23 = self.G

    self.H = zeros( (6,6) )

    self.H[0,0] = self.factor * self.E3
    self.H[1,1] = self.factor * self.E3
    self.H[2,2] = self.E3
    self.H[3,3] = self.factor * (self.G13 + self. G23)*0.5                               
    self.H[4,4] = self.G23                                  
    self.H[5,5] = self.G13                                 

  def getStress( self, deformation ):

    sigma = dot( self.H, deformation.eps )

    return sigma, self.H

  def getTangent( self ):
  
    return self.H

