"""Type checking on source code."""

import shutil

from invoke import task
from pipfile import Pipfile

from tasks.utils import PROJECT_INFO, print_header


@task()
def build(ctx):
    print_header("Running build", icon="🔨")

    print("Cleanup the 'build' directory")
    shutil.rmtree("build", ignore_errors=True)

    print_header("Generate requirements.txt file", icon="⚙", level=2)
    parsed_pipfile = Pipfile.load("Pipfile")
    requirements_file = "\n".join(
        ["# DON'T CHANGE THIS FILE! It is generated by `inv build`.\n", *list(parsed_pipfile.data["default"].keys())]
    )
    print(requirements_file)

    with open("requirements.txt", "w") as fd:
        fd.write(requirements_file)

    print_header("Build packages", icon="🔨", level=2)
    ctx.run("python setup.py sdist bdist_wheel", pty=True, env={"PYTHONPATH": PROJECT_INFO.source_directory})

    print_header("Check PyPI description", icon="👀", level=2)
    ctx.run("twine check dist/*")
