//
// This file is part of libdebug Python library (https://github.com/libdebug/libdebug).
// Copyright (c) 2024 Roberto Alessandro Bertolini. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for details.
//

#include <stdio.h>
#include <stdlib.h>

#pragma GCC optimize ("O0")

void register_test()
{
    asm volatile (
        "sub sp, sp, #96\n\t"
        "stp x19, x20, [sp, #0]\n\t"
        "stp x21, x22, [sp, #16]\n\t"
        "stp x23, x24, [sp, #32]\n\t"
        "stp x25, x26, [sp, #48]\n\t"
        "stp x27, x28, [sp, #64]\n\t"
        "stp x29, x30, [sp, #80]\n\t"
        "nop\n\t"
        "movk x0, #0x1111, lsl #0\n\t"
        "movk x0, #0x2222, lsl #16\n\t"
        "movk x0, #0x3333, lsl #32\n\t"
        "movk x0, #0x4444, lsl #48\n\t"
        "movk x1, #0x5555, lsl #0\n\t"
        "movk x1, #0x6666, lsl #16\n\t"
        "movk x1, #0x7777, lsl #32\n\t"
        "movk x1, #0x8888, lsl #48\n\t"
        "movk x2, #0x9999, lsl #0\n\t"
        "movk x2, #0xaaaa, lsl #16\n\t"
        "movk x2, #0xbbbb, lsl #32\n\t"
        "movk x2, #0xcccc, lsl #48\n\t"
        "movk x3, #0xdddd, lsl #0\n\t"
        "movk x3, #0xeeee, lsl #16\n\t"
        "movk x3, #0xffff, lsl #32\n\t"
        "movk x3, #0x1111, lsl #48\n\t"
        "movk x4, #0x2222, lsl #0\n\t"
        "movk x4, #0x3333, lsl #16\n\t"
        "movk x4, #0x4444, lsl #32\n\t"
        "movk x4, #0x5555, lsl #48\n\t"
        "movk x5, #0x6666, lsl #0\n\t"
        "movk x5, #0x7777, lsl #16\n\t"
        "movk x5, #0x8888, lsl #32\n\t"
        "movk x5, #0x9999, lsl #48\n\t"
        "movk x6, #0xaaaa, lsl #0\n\t"
        "movk x6, #0xbbbb, lsl #16\n\t"
        "movk x6, #0xcccc, lsl #32\n\t"
        "movk x6, #0xdddd, lsl #48\n\t"
        "movk x7, #0xeeee, lsl #0\n\t"
        "movk x7, #0xffff, lsl #16\n\t"
        "movk x7, #0x1111, lsl #32\n\t"
        "movk x7, #0x2222, lsl #48\n\t"
        "movk x8, #0x3333, lsl #0\n\t"
        "movk x8, #0x4444, lsl #16\n\t"
        "movk x8, #0x5555, lsl #32\n\t"
        "movk x8, #0x6666, lsl #48\n\t"
        "movk x9, #0x7777, lsl #0\n\t"
        "movk x9, #0x8888, lsl #16\n\t"
        "movk x9, #0x9999, lsl #32\n\t"
        "movk x9, #0xaaaa, lsl #48\n\t"
        "movk x10, #0xbbbb, lsl #0\n\t"
        "movk x10, #0xcccc, lsl #16\n\t"
        "movk x10, #0xdddd, lsl #32\n\t"
        "movk x10, #0xeeee, lsl #48\n\t"
        "movk x11, #0xffff, lsl #0\n\t"
        "movk x11, #0x1111, lsl #16\n\t"
        "movk x11, #0x2222, lsl #32\n\t"
        "movk x11, #0x3333, lsl #48\n\t"
        "movk x12, #0x4444, lsl #0\n\t"
        "movk x12, #0x5555, lsl #16\n\t"
        "movk x12, #0x6666, lsl #32\n\t"
        "movk x12, #0x7777, lsl #48\n\t"
        "movk x13, #0x8888, lsl #0\n\t"
        "movk x13, #0x9999, lsl #16\n\t"
        "movk x13, #0xaaaa, lsl #32\n\t"
        "movk x13, #0xbbbb, lsl #48\n\t"
        "movk x14, #0xcccc, lsl #0\n\t"
        "movk x14, #0xdddd, lsl #16\n\t"
        "movk x14, #0xeeee, lsl #32\n\t"
        "movk x14, #0xffff, lsl #48\n\t"
        "movk x15, #0x1111, lsl #0\n\t"
        "movk x15, #0x2222, lsl #16\n\t"
        "movk x15, #0x3333, lsl #32\n\t"
        "movk x15, #0x4444, lsl #48\n\t"
        "movk x16, #0x5555, lsl #0\n\t"
        "movk x16, #0x6666, lsl #16\n\t"
        "movk x16, #0x7777, lsl #32\n\t"
        "movk x16, #0x8888, lsl #48\n\t"
        "movk x17, #0x9999, lsl #0\n\t"
        "movk x17, #0xaaaa, lsl #16\n\t"
        "movk x17, #0xbbbb, lsl #32\n\t"
        "movk x17, #0xcccc, lsl #48\n\t"
        "movk x18, #0xdddd, lsl #0\n\t"
        "movk x18, #0xeeee, lsl #16\n\t"
        "movk x18, #0xffff, lsl #32\n\t"
        "movk x18, #0x1111, lsl #48\n\t"
        "movk x19, #0x2222, lsl #0\n\t"
        "movk x19, #0x3333, lsl #16\n\t"
        "movk x19, #0x4444, lsl #32\n\t"
        "movk x19, #0x5555, lsl #48\n\t"
        "movk x20, #0x6666, lsl #0\n\t"
        "movk x20, #0x7777, lsl #16\n\t"
        "movk x20, #0x8888, lsl #32\n\t"
        "movk x20, #0x9999, lsl #48\n\t"
        "movk x21, #0xaaaa, lsl #0\n\t"
        "movk x21, #0xbbbb, lsl #16\n\t"
        "movk x21, #0xcccc, lsl #32\n\t"
        "movk x21, #0xdddd, lsl #48\n\t"
        "movk x22, #0xeeee, lsl #0\n\t"
        "movk x22, #0xffff, lsl #16\n\t"
        "movk x22, #0x1111, lsl #32\n\t"
        "movk x22, #0x2222, lsl #48\n\t"
        "movk x23, #0x3333, lsl #0\n\t"
        "movk x23, #0x4444, lsl #16\n\t"
        "movk x23, #0x5555, lsl #32\n\t"
        "movk x23, #0x6666, lsl #48\n\t"
        "movk x24, #0x7777, lsl #0\n\t"
        "movk x24, #0x8888, lsl #16\n\t"
        "movk x24, #0x9999, lsl #32\n\t"
        "movk x24, #0xaaaa, lsl #48\n\t"
        "movk x25, #0xbbbb, lsl #0\n\t"
        "movk x25, #0xcccc, lsl #16\n\t"
        "movk x25, #0xdddd, lsl #32\n\t"
        "movk x25, #0xeeee, lsl #48\n\t"
        "movk x26, #0xffff, lsl #0\n\t"
        "movk x26, #0x1111, lsl #16\n\t"
        "movk x26, #0x2222, lsl #32\n\t"
        "movk x26, #0x3333, lsl #48\n\t"
        "movk x27, #0x4444, lsl #0\n\t"
        "movk x27, #0x5555, lsl #16\n\t"
        "movk x27, #0x6666, lsl #32\n\t"
        "movk x27, #0x7777, lsl #48\n\t"
        "movk x28, #0x8888, lsl #0\n\t"
        "movk x28, #0x9999, lsl #16\n\t"
        "movk x28, #0xaaaa, lsl #32\n\t"
        "movk x28, #0xbbbb, lsl #48\n\t"
        "movk x29, #0xcccc, lsl #0\n\t"
        "movk x29, #0xdddd, lsl #16\n\t"
        "movk x29, #0xeeee, lsl #32\n\t"
        "movk x29, #0xffff, lsl #48\n\t"
        "movk x30, #0x1111, lsl #0\n\t"
        "movk x30, #0x2222, lsl #16\n\t"
        "movk x30, #0x3333, lsl #32\n\t"
        "movk x30, #0x4444, lsl #48\n\t"
        "nop\n\t"
        "ldp x19, x20, [sp, #0]\n\t"
        "ldp x21, x22, [sp, #16]\n\t"
        "ldp x23, x24, [sp, #32]\n\t"
        "ldp x25, x26, [sp, #48]\n\t"
        "ldp x27, x28, [sp, #64]\n\t"
        "ldp x29, x30, [sp, #80]\n\t"
        "add sp, sp, #96\n\t"
        :
        :
        : "x0", "x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x18"
    );
}

int main()
{
    printf("Provola\n");

    register_test();

    return EXIT_SUCCESS;
}
