---
authors:
    - team
date:
  created: 2025-03-26
draft: false
---

# Release 0.8 - Chutoro Nigiri
Hello, debuggers! It's been a while since our last release, but we are excited to announce **libdebug** version 0.8, codename :sushi: *Chutoro Nigiri* :sushi:. This release brings several new features, improvements, and bug fixes. Here is a summary of the changes:

## Features
- **Process/Thread Snapshots & Diffs**: Take snapshots of the execution state of the debuggee and compare them across different points in time.
- **Multiprocessing Support**: Automatically manage child processes created via `fork()`, attaching new debuggers to them. This behavior can be customized with the `Debugger` parameter `follow_children`.
- **Find References Between Memory Maps**: Introduced `d.memory.find_pointers` to identify all pointers in a memory region that reference another region, useful for detecting memory leaks in cybersecurity applictions.
- **SIGTRAP Signal Handling**: Now it is possible to catch SIGTRAP signals, excluding those directly related to debugging, exposing only unrecognized signals from the process or external sources.
- **Defaulted Fast Memory Access (`fast_memory=True`)**: Improves performance of memory access. Can be disabled using the `fast_memory` parameter in `Debugger`.
- **New Terminal Autodetection for `d.gdb(open_in_new_process=True)`**: Ensures GDB opens correctly in a newly detected terminal without user-defined commands. 
- **Automatic Symbol Resolution for Unspecified Backing Files**: When no specific file is set, symbols are resolved for all memory maps, with a warning due to potential performance impact.

## Other Improvements
- **Migration from CFFI to Nanobind**.
- **Refined Exception Handling**: Standardized across the codebase for improved consistency.
- **Improved IDE Support**: Enhancements to improve autocompletion and code suggestions.
- **Exposed `zombie` attribute in `ThreadContext`**: Allows users to check if a thread is a zombie.

## Bug Fixes
- **Fixed Memory Leaks**: Resolved multiple leaks across various libdebug modules.
- **Fixed `SymbolList` Slicing**: Properly supports slice operations.
- **Improved `debuginfod` Handling**: Enhanced caching logic when a file is not available on `debuginfod`, improving compatibility with other binaries that use `debuginfod` on your system.
- **Fixed Resource Access Issues After Detach**.
- **Resolved Object Collisions in Event Handling**: Addressed key-collision issues in event-related objects (e.g., `SyscallHandler`, `SignalCatcher`).
- **Fixed Binary Path Resolution**: Prevents incorrect binary paths in certain edge cases.
- **Improved `d.gdb` for Edge Cases**: Fixed several inconsistencies in execution.
- **Fixed `step`, `finish`, and `next` Operations in Callbacks**: Now executed correctly.
-  **Enhanced Stability & Performance Optimizations**.

## Testing & CI
- **CI Support for arm64 & Ubuntu 24.04**: Improved compatibility and test automation.

## Documentation
- **Added Documentation for New Features**.
- **Updated Contributing Guidelines**.
- **Fixed Broken Links & Missing Pydocs**.
- **Added Reference to Published Research Poster at a Top Conference**.

## New Contributors
- [collodel](https://github.com/collodel)
- [myasn1k](https://github.com/myasn1k)