"use strict";
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-05-08T05:05:36.095Z","fingerprint":"4xwpM1pdz8Rz4VHBppCc8oPQIAI1ONlX4JlQF5ChiQw="}
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
/**
 * Determine whether the given properties match those of a `CfnIPSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnIPSetProps`
 *
 * @returns the result of the validation.
 */
function CfnIPSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('addresses', cdk.requiredValidator)(properties.addresses));
    errors.collect(cdk.propertyValidator('addresses', cdk.listValidator(cdk.validateString))(properties.addresses));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('ipAddressVersion', cdk.requiredValidator)(properties.ipAddressVersion));
    errors.collect(cdk.propertyValidator('ipAddressVersion', cdk.validateString)(properties.ipAddressVersion));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('scope', cdk.requiredValidator)(properties.scope));
    errors.collect(cdk.propertyValidator('scope', cdk.validateString)(properties.scope));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnIPSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::IPSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnIPSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::IPSet` resource.
 */
// @ts-ignore TS6133
function cfnIPSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIPSetPropsValidator(properties).assertSuccess();
    return {
        Addresses: cdk.listMapper(cdk.stringToCloudFormation)(properties.addresses),
        IPAddressVersion: cdk.stringToCloudFormation(properties.ipAddressVersion),
        Scope: cdk.stringToCloudFormation(properties.scope),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::WAFv2::IPSet`
 *
 * @cloudformationResource AWS::WAFv2::IPSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
 */
class CfnIPSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::WAFv2::IPSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIPSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'addresses', this);
        cdk.requireProperty(props, 'ipAddressVersion', this);
        cdk.requireProperty(props, 'scope', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.addresses = props.addresses;
        this.ipAddressVersion = props.ipAddressVersion;
        this.scope = props.scope;
        this.description = props.description;
        this.name = props.name;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::WAFv2::IPSet", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnIPSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            addresses: this.addresses,
            ipAddressVersion: this.ipAddressVersion,
            scope: this.scope,
            description: this.description,
            name: this.name,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnIPSetPropsToCloudFormation(props);
    }
}
exports.CfnIPSet = CfnIPSet;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIPSet.CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::IPSet";
/**
 * Determine whether the given properties match those of a `CfnRegexPatternSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnRegexPatternSetProps`
 *
 * @returns the result of the validation.
 */
function CfnRegexPatternSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('regularExpressionList', cdk.requiredValidator)(properties.regularExpressionList));
    errors.collect(cdk.propertyValidator('regularExpressionList', cdk.listValidator(cdk.validateString))(properties.regularExpressionList));
    errors.collect(cdk.propertyValidator('scope', cdk.requiredValidator)(properties.scope));
    errors.collect(cdk.propertyValidator('scope', cdk.validateString)(properties.scope));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnRegexPatternSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RegexPatternSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnRegexPatternSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RegexPatternSet` resource.
 */
// @ts-ignore TS6133
function cfnRegexPatternSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRegexPatternSetPropsValidator(properties).assertSuccess();
    return {
        RegularExpressionList: cdk.listMapper(cdk.stringToCloudFormation)(properties.regularExpressionList),
        Scope: cdk.stringToCloudFormation(properties.scope),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::WAFv2::RegexPatternSet`
 *
 * @cloudformationResource AWS::WAFv2::RegexPatternSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
 */
class CfnRegexPatternSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::WAFv2::RegexPatternSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRegexPatternSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'regularExpressionList', this);
        cdk.requireProperty(props, 'scope', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.regularExpressionList = props.regularExpressionList;
        this.scope = props.scope;
        this.description = props.description;
        this.name = props.name;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::WAFv2::RegexPatternSet", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRegexPatternSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            regularExpressionList: this.regularExpressionList,
            scope: this.scope,
            description: this.description,
            name: this.name,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnRegexPatternSetPropsToCloudFormation(props);
    }
}
exports.CfnRegexPatternSet = CfnRegexPatternSet;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRegexPatternSet.CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::RegexPatternSet";
/**
 * Determine whether the given properties match those of a `CfnRuleGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnRuleGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('capacity', cdk.requiredValidator)(properties.capacity));
    errors.collect(cdk.propertyValidator('capacity', cdk.validateNumber)(properties.capacity));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('rules', cdk.listValidator(CfnRuleGroup_RulePropertyValidator))(properties.rules));
    errors.collect(cdk.propertyValidator('scope', cdk.requiredValidator)(properties.scope));
    errors.collect(cdk.propertyValidator('scope', cdk.validateString)(properties.scope));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('visibilityConfig', cdk.requiredValidator)(properties.visibilityConfig));
    errors.collect(cdk.propertyValidator('visibilityConfig', CfnRuleGroup_VisibilityConfigPropertyValidator)(properties.visibilityConfig));
    return errors.wrap('supplied properties not correct for "CfnRuleGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnRuleGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroupPropsValidator(properties).assertSuccess();
    return {
        Capacity: cdk.numberToCloudFormation(properties.capacity),
        Scope: cdk.stringToCloudFormation(properties.scope),
        VisibilityConfig: cfnRuleGroupVisibilityConfigPropertyToCloudFormation(properties.visibilityConfig),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        Rules: cdk.listMapper(cfnRuleGroupRulePropertyToCloudFormation)(properties.rules),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::WAFv2::RuleGroup`
 *
 * @cloudformationResource AWS::WAFv2::RuleGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
 */
class CfnRuleGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::WAFv2::RuleGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRuleGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'capacity', this);
        cdk.requireProperty(props, 'scope', this);
        cdk.requireProperty(props, 'visibilityConfig', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.capacity = props.capacity;
        this.scope = props.scope;
        this.visibilityConfig = props.visibilityConfig;
        this.description = props.description;
        this.name = props.name;
        this.rules = props.rules;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::WAFv2::RuleGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnRuleGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            capacity: this.capacity,
            scope: this.scope,
            visibilityConfig: this.visibilityConfig,
            description: this.description,
            name: this.name,
            rules: this.rules,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnRuleGroupPropsToCloudFormation(props);
    }
}
exports.CfnRuleGroup = CfnRuleGroup;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnRuleGroup.CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::RuleGroup";
/**
 * Determine whether the given properties match those of a `AndStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `AndStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_AndStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnRuleGroup_StatementTwoPropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "AndStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.AndStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `AndStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.AndStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupAndStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_AndStatementOnePropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnRuleGroupStatementTwoPropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `AndStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `AndStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_AndStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnRuleGroup_StatementThreePropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "AndStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.AndStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `AndStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.AndStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupAndStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_AndStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnRuleGroupStatementThreePropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `ByteMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `ByteMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_ByteMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnRuleGroup_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('positionalConstraint', cdk.requiredValidator)(properties.positionalConstraint));
    errors.collect(cdk.propertyValidator('positionalConstraint', cdk.validateString)(properties.positionalConstraint));
    errors.collect(cdk.propertyValidator('searchString', cdk.validateString)(properties.searchString));
    errors.collect(cdk.propertyValidator('searchStringBase64', cdk.validateString)(properties.searchStringBase64));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnRuleGroup_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "ByteMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.ByteMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `ByteMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.ByteMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupByteMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_ByteMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        FieldToMatch: cfnRuleGroupFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        PositionalConstraint: cdk.stringToCloudFormation(properties.positionalConstraint),
        SearchString: cdk.stringToCloudFormation(properties.searchString),
        SearchStringBase64: cdk.stringToCloudFormation(properties.searchStringBase64),
        TextTransformations: cdk.listMapper(cfnRuleGroupTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `FieldToMatchProperty`
 *
 * @param properties - the TypeScript properties of a `FieldToMatchProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_FieldToMatchPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allQueryArguments', cdk.validateObject)(properties.allQueryArguments));
    errors.collect(cdk.propertyValidator('body', cdk.validateObject)(properties.body));
    errors.collect(cdk.propertyValidator('method', cdk.validateObject)(properties.method));
    errors.collect(cdk.propertyValidator('queryString', cdk.validateObject)(properties.queryString));
    errors.collect(cdk.propertyValidator('singleHeader', cdk.validateObject)(properties.singleHeader));
    errors.collect(cdk.propertyValidator('singleQueryArgument', cdk.validateObject)(properties.singleQueryArgument));
    errors.collect(cdk.propertyValidator('uriPath', cdk.validateObject)(properties.uriPath));
    return errors.wrap('supplied properties not correct for "FieldToMatchProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.FieldToMatch` resource
 *
 * @param properties - the TypeScript properties of a `FieldToMatchProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.FieldToMatch` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupFieldToMatchPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_FieldToMatchPropertyValidator(properties).assertSuccess();
    return {
        AllQueryArguments: cdk.objectToCloudFormation(properties.allQueryArguments),
        Body: cdk.objectToCloudFormation(properties.body),
        Method: cdk.objectToCloudFormation(properties.method),
        QueryString: cdk.objectToCloudFormation(properties.queryString),
        SingleHeader: cdk.objectToCloudFormation(properties.singleHeader),
        SingleQueryArgument: cdk.objectToCloudFormation(properties.singleQueryArgument),
        UriPath: cdk.objectToCloudFormation(properties.uriPath),
    };
}
/**
 * Determine whether the given properties match those of a `GeoMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `GeoMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_GeoMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('countryCodes', cdk.listValidator(cdk.validateString))(properties.countryCodes));
    return errors.wrap('supplied properties not correct for "GeoMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.GeoMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `GeoMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.GeoMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupGeoMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_GeoMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        CountryCodes: cdk.listMapper(cdk.stringToCloudFormation)(properties.countryCodes),
    };
}
/**
 * Determine whether the given properties match those of a `IPSetReferenceStatementProperty`
 *
 * @param properties - the TypeScript properties of a `IPSetReferenceStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_IPSetReferenceStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('arn', cdk.requiredValidator)(properties.arn));
    errors.collect(cdk.propertyValidator('arn', cdk.validateString)(properties.arn));
    return errors.wrap('supplied properties not correct for "IPSetReferenceStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.IPSetReferenceStatement` resource
 *
 * @param properties - the TypeScript properties of a `IPSetReferenceStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.IPSetReferenceStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupIPSetReferenceStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_IPSetReferenceStatementPropertyValidator(properties).assertSuccess();
    return {
        Arn: cdk.stringToCloudFormation(properties.arn),
    };
}
/**
 * Determine whether the given properties match those of a `NotStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `NotStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_NotStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statement', cdk.requiredValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('statement', CfnRuleGroup_StatementTwoPropertyValidator)(properties.statement));
    return errors.wrap('supplied properties not correct for "NotStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.NotStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `NotStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.NotStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupNotStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_NotStatementOnePropertyValidator(properties).assertSuccess();
    return {
        Statement: cfnRuleGroupStatementTwoPropertyToCloudFormation(properties.statement),
    };
}
/**
 * Determine whether the given properties match those of a `NotStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `NotStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_NotStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statement', cdk.requiredValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('statement', CfnRuleGroup_StatementThreePropertyValidator)(properties.statement));
    return errors.wrap('supplied properties not correct for "NotStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.NotStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `NotStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.NotStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupNotStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_NotStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        Statement: cfnRuleGroupStatementThreePropertyToCloudFormation(properties.statement),
    };
}
/**
 * Determine whether the given properties match those of a `OrStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `OrStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_OrStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnRuleGroup_StatementTwoPropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "OrStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.OrStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `OrStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.OrStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupOrStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_OrStatementOnePropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnRuleGroupStatementTwoPropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `OrStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `OrStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_OrStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnRuleGroup_StatementThreePropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "OrStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.OrStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `OrStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.OrStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupOrStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_OrStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnRuleGroupStatementThreePropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `RateBasedStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_RateBasedStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.requiredValidator)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.validateString)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('limit', cdk.requiredValidator)(properties.limit));
    errors.collect(cdk.propertyValidator('limit', cdk.validateNumber)(properties.limit));
    errors.collect(cdk.propertyValidator('scopeDownStatement', CfnRuleGroup_StatementTwoPropertyValidator)(properties.scopeDownStatement));
    return errors.wrap('supplied properties not correct for "RateBasedStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RateBasedStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RateBasedStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupRateBasedStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_RateBasedStatementOnePropertyValidator(properties).assertSuccess();
    return {
        AggregateKeyType: cdk.stringToCloudFormation(properties.aggregateKeyType),
        Limit: cdk.numberToCloudFormation(properties.limit),
        ScopeDownStatement: cfnRuleGroupStatementTwoPropertyToCloudFormation(properties.scopeDownStatement),
    };
}
/**
 * Determine whether the given properties match those of a `RateBasedStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_RateBasedStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.requiredValidator)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.validateString)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('limit', cdk.requiredValidator)(properties.limit));
    errors.collect(cdk.propertyValidator('limit', cdk.validateNumber)(properties.limit));
    errors.collect(cdk.propertyValidator('scopeDownStatement', CfnRuleGroup_StatementThreePropertyValidator)(properties.scopeDownStatement));
    return errors.wrap('supplied properties not correct for "RateBasedStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RateBasedStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RateBasedStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupRateBasedStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_RateBasedStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        AggregateKeyType: cdk.stringToCloudFormation(properties.aggregateKeyType),
        Limit: cdk.numberToCloudFormation(properties.limit),
        ScopeDownStatement: cfnRuleGroupStatementThreePropertyToCloudFormation(properties.scopeDownStatement),
    };
}
/**
 * Determine whether the given properties match those of a `RegexPatternSetReferenceStatementProperty`
 *
 * @param properties - the TypeScript properties of a `RegexPatternSetReferenceStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_RegexPatternSetReferenceStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('arn', cdk.requiredValidator)(properties.arn));
    errors.collect(cdk.propertyValidator('arn', cdk.validateString)(properties.arn));
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnRuleGroup_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnRuleGroup_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "RegexPatternSetReferenceStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RegexPatternSetReferenceStatement` resource
 *
 * @param properties - the TypeScript properties of a `RegexPatternSetReferenceStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RegexPatternSetReferenceStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupRegexPatternSetReferenceStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_RegexPatternSetReferenceStatementPropertyValidator(properties).assertSuccess();
    return {
        Arn: cdk.stringToCloudFormation(properties.arn),
        FieldToMatch: cfnRuleGroupFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        TextTransformations: cdk.listMapper(cfnRuleGroupTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `RuleProperty`
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_RulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('action', CfnRuleGroup_RuleActionPropertyValidator)(properties.action));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('priority', cdk.requiredValidator)(properties.priority));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    errors.collect(cdk.propertyValidator('statement', cdk.requiredValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('statement', CfnRuleGroup_StatementOnePropertyValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('visibilityConfig', cdk.requiredValidator)(properties.visibilityConfig));
    errors.collect(cdk.propertyValidator('visibilityConfig', CfnRuleGroup_VisibilityConfigPropertyValidator)(properties.visibilityConfig));
    return errors.wrap('supplied properties not correct for "RuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.Rule` resource
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.Rule` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_RulePropertyValidator(properties).assertSuccess();
    return {
        Action: cfnRuleGroupRuleActionPropertyToCloudFormation(properties.action),
        Name: cdk.stringToCloudFormation(properties.name),
        Priority: cdk.numberToCloudFormation(properties.priority),
        Statement: cfnRuleGroupStatementOnePropertyToCloudFormation(properties.statement),
        VisibilityConfig: cfnRuleGroupVisibilityConfigPropertyToCloudFormation(properties.visibilityConfig),
    };
}
/**
 * Determine whether the given properties match those of a `RuleActionProperty`
 *
 * @param properties - the TypeScript properties of a `RuleActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_RuleActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allow', cdk.validateObject)(properties.allow));
    errors.collect(cdk.propertyValidator('block', cdk.validateObject)(properties.block));
    errors.collect(cdk.propertyValidator('count', cdk.validateObject)(properties.count));
    return errors.wrap('supplied properties not correct for "RuleActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RuleAction` resource
 *
 * @param properties - the TypeScript properties of a `RuleActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.RuleAction` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupRuleActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_RuleActionPropertyValidator(properties).assertSuccess();
    return {
        Allow: cdk.objectToCloudFormation(properties.allow),
        Block: cdk.objectToCloudFormation(properties.block),
        Count: cdk.objectToCloudFormation(properties.count),
    };
}
/**
 * Determine whether the given properties match those of a `SizeConstraintStatementProperty`
 *
 * @param properties - the TypeScript properties of a `SizeConstraintStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_SizeConstraintStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.requiredValidator)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.validateString)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnRuleGroup_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('size', cdk.requiredValidator)(properties.size));
    errors.collect(cdk.propertyValidator('size', cdk.validateNumber)(properties.size));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnRuleGroup_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "SizeConstraintStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.SizeConstraintStatement` resource
 *
 * @param properties - the TypeScript properties of a `SizeConstraintStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.SizeConstraintStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupSizeConstraintStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_SizeConstraintStatementPropertyValidator(properties).assertSuccess();
    return {
        ComparisonOperator: cdk.stringToCloudFormation(properties.comparisonOperator),
        FieldToMatch: cfnRuleGroupFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        Size: cdk.numberToCloudFormation(properties.size),
        TextTransformations: cdk.listMapper(cfnRuleGroupTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `SqliMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `SqliMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_SqliMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnRuleGroup_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnRuleGroup_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "SqliMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.SqliMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `SqliMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.SqliMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupSqliMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_SqliMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        FieldToMatch: cfnRuleGroupFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        TextTransformations: cdk.listMapper(cfnRuleGroupTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `StatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `StatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_StatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('andStatement', CfnRuleGroup_AndStatementOnePropertyValidator)(properties.andStatement));
    errors.collect(cdk.propertyValidator('byteMatchStatement', CfnRuleGroup_ByteMatchStatementPropertyValidator)(properties.byteMatchStatement));
    errors.collect(cdk.propertyValidator('geoMatchStatement', CfnRuleGroup_GeoMatchStatementPropertyValidator)(properties.geoMatchStatement));
    errors.collect(cdk.propertyValidator('ipSetReferenceStatement', CfnRuleGroup_IPSetReferenceStatementPropertyValidator)(properties.ipSetReferenceStatement));
    errors.collect(cdk.propertyValidator('notStatement', CfnRuleGroup_NotStatementOnePropertyValidator)(properties.notStatement));
    errors.collect(cdk.propertyValidator('orStatement', CfnRuleGroup_OrStatementOnePropertyValidator)(properties.orStatement));
    errors.collect(cdk.propertyValidator('rateBasedStatement', CfnRuleGroup_RateBasedStatementOnePropertyValidator)(properties.rateBasedStatement));
    errors.collect(cdk.propertyValidator('regexPatternSetReferenceStatement', CfnRuleGroup_RegexPatternSetReferenceStatementPropertyValidator)(properties.regexPatternSetReferenceStatement));
    errors.collect(cdk.propertyValidator('sizeConstraintStatement', CfnRuleGroup_SizeConstraintStatementPropertyValidator)(properties.sizeConstraintStatement));
    errors.collect(cdk.propertyValidator('sqliMatchStatement', CfnRuleGroup_SqliMatchStatementPropertyValidator)(properties.sqliMatchStatement));
    errors.collect(cdk.propertyValidator('xssMatchStatement', CfnRuleGroup_XssMatchStatementPropertyValidator)(properties.xssMatchStatement));
    return errors.wrap('supplied properties not correct for "StatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.StatementOne` resource
 *
 * @param properties - the TypeScript properties of a `StatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.StatementOne` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_StatementOnePropertyValidator(properties).assertSuccess();
    return {
        AndStatement: cfnRuleGroupAndStatementOnePropertyToCloudFormation(properties.andStatement),
        ByteMatchStatement: cfnRuleGroupByteMatchStatementPropertyToCloudFormation(properties.byteMatchStatement),
        GeoMatchStatement: cfnRuleGroupGeoMatchStatementPropertyToCloudFormation(properties.geoMatchStatement),
        IPSetReferenceStatement: cfnRuleGroupIPSetReferenceStatementPropertyToCloudFormation(properties.ipSetReferenceStatement),
        NotStatement: cfnRuleGroupNotStatementOnePropertyToCloudFormation(properties.notStatement),
        OrStatement: cfnRuleGroupOrStatementOnePropertyToCloudFormation(properties.orStatement),
        RateBasedStatement: cfnRuleGroupRateBasedStatementOnePropertyToCloudFormation(properties.rateBasedStatement),
        RegexPatternSetReferenceStatement: cfnRuleGroupRegexPatternSetReferenceStatementPropertyToCloudFormation(properties.regexPatternSetReferenceStatement),
        SizeConstraintStatement: cfnRuleGroupSizeConstraintStatementPropertyToCloudFormation(properties.sizeConstraintStatement),
        SqliMatchStatement: cfnRuleGroupSqliMatchStatementPropertyToCloudFormation(properties.sqliMatchStatement),
        XssMatchStatement: cfnRuleGroupXssMatchStatementPropertyToCloudFormation(properties.xssMatchStatement),
    };
}
/**
 * Determine whether the given properties match those of a `StatementThreeProperty`
 *
 * @param properties - the TypeScript properties of a `StatementThreeProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_StatementThreePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('byteMatchStatement', CfnRuleGroup_ByteMatchStatementPropertyValidator)(properties.byteMatchStatement));
    errors.collect(cdk.propertyValidator('geoMatchStatement', CfnRuleGroup_GeoMatchStatementPropertyValidator)(properties.geoMatchStatement));
    errors.collect(cdk.propertyValidator('ipSetReferenceStatement', CfnRuleGroup_IPSetReferenceStatementPropertyValidator)(properties.ipSetReferenceStatement));
    errors.collect(cdk.propertyValidator('regexPatternSetReferenceStatement', CfnRuleGroup_RegexPatternSetReferenceStatementPropertyValidator)(properties.regexPatternSetReferenceStatement));
    errors.collect(cdk.propertyValidator('sizeConstraintStatement', CfnRuleGroup_SizeConstraintStatementPropertyValidator)(properties.sizeConstraintStatement));
    errors.collect(cdk.propertyValidator('sqliMatchStatement', CfnRuleGroup_SqliMatchStatementPropertyValidator)(properties.sqliMatchStatement));
    errors.collect(cdk.propertyValidator('xssMatchStatement', CfnRuleGroup_XssMatchStatementPropertyValidator)(properties.xssMatchStatement));
    return errors.wrap('supplied properties not correct for "StatementThreeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.StatementThree` resource
 *
 * @param properties - the TypeScript properties of a `StatementThreeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.StatementThree` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupStatementThreePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_StatementThreePropertyValidator(properties).assertSuccess();
    return {
        ByteMatchStatement: cfnRuleGroupByteMatchStatementPropertyToCloudFormation(properties.byteMatchStatement),
        GeoMatchStatement: cfnRuleGroupGeoMatchStatementPropertyToCloudFormation(properties.geoMatchStatement),
        IPSetReferenceStatement: cfnRuleGroupIPSetReferenceStatementPropertyToCloudFormation(properties.ipSetReferenceStatement),
        RegexPatternSetReferenceStatement: cfnRuleGroupRegexPatternSetReferenceStatementPropertyToCloudFormation(properties.regexPatternSetReferenceStatement),
        SizeConstraintStatement: cfnRuleGroupSizeConstraintStatementPropertyToCloudFormation(properties.sizeConstraintStatement),
        SqliMatchStatement: cfnRuleGroupSqliMatchStatementPropertyToCloudFormation(properties.sqliMatchStatement),
        XssMatchStatement: cfnRuleGroupXssMatchStatementPropertyToCloudFormation(properties.xssMatchStatement),
    };
}
/**
 * Determine whether the given properties match those of a `StatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `StatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_StatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('andStatement', CfnRuleGroup_AndStatementTwoPropertyValidator)(properties.andStatement));
    errors.collect(cdk.propertyValidator('byteMatchStatement', CfnRuleGroup_ByteMatchStatementPropertyValidator)(properties.byteMatchStatement));
    errors.collect(cdk.propertyValidator('geoMatchStatement', CfnRuleGroup_GeoMatchStatementPropertyValidator)(properties.geoMatchStatement));
    errors.collect(cdk.propertyValidator('ipSetReferenceStatement', CfnRuleGroup_IPSetReferenceStatementPropertyValidator)(properties.ipSetReferenceStatement));
    errors.collect(cdk.propertyValidator('notStatement', CfnRuleGroup_NotStatementTwoPropertyValidator)(properties.notStatement));
    errors.collect(cdk.propertyValidator('orStatement', CfnRuleGroup_OrStatementTwoPropertyValidator)(properties.orStatement));
    errors.collect(cdk.propertyValidator('rateBasedStatement', CfnRuleGroup_RateBasedStatementTwoPropertyValidator)(properties.rateBasedStatement));
    errors.collect(cdk.propertyValidator('regexPatternSetReferenceStatement', CfnRuleGroup_RegexPatternSetReferenceStatementPropertyValidator)(properties.regexPatternSetReferenceStatement));
    errors.collect(cdk.propertyValidator('sizeConstraintStatement', CfnRuleGroup_SizeConstraintStatementPropertyValidator)(properties.sizeConstraintStatement));
    errors.collect(cdk.propertyValidator('sqliMatchStatement', CfnRuleGroup_SqliMatchStatementPropertyValidator)(properties.sqliMatchStatement));
    errors.collect(cdk.propertyValidator('xssMatchStatement', CfnRuleGroup_XssMatchStatementPropertyValidator)(properties.xssMatchStatement));
    return errors.wrap('supplied properties not correct for "StatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.StatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `StatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.StatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_StatementTwoPropertyValidator(properties).assertSuccess();
    return {
        AndStatement: cfnRuleGroupAndStatementTwoPropertyToCloudFormation(properties.andStatement),
        ByteMatchStatement: cfnRuleGroupByteMatchStatementPropertyToCloudFormation(properties.byteMatchStatement),
        GeoMatchStatement: cfnRuleGroupGeoMatchStatementPropertyToCloudFormation(properties.geoMatchStatement),
        IPSetReferenceStatement: cfnRuleGroupIPSetReferenceStatementPropertyToCloudFormation(properties.ipSetReferenceStatement),
        NotStatement: cfnRuleGroupNotStatementTwoPropertyToCloudFormation(properties.notStatement),
        OrStatement: cfnRuleGroupOrStatementTwoPropertyToCloudFormation(properties.orStatement),
        RateBasedStatement: cfnRuleGroupRateBasedStatementTwoPropertyToCloudFormation(properties.rateBasedStatement),
        RegexPatternSetReferenceStatement: cfnRuleGroupRegexPatternSetReferenceStatementPropertyToCloudFormation(properties.regexPatternSetReferenceStatement),
        SizeConstraintStatement: cfnRuleGroupSizeConstraintStatementPropertyToCloudFormation(properties.sizeConstraintStatement),
        SqliMatchStatement: cfnRuleGroupSqliMatchStatementPropertyToCloudFormation(properties.sqliMatchStatement),
        XssMatchStatement: cfnRuleGroupXssMatchStatementPropertyToCloudFormation(properties.xssMatchStatement),
    };
}
/**
 * Determine whether the given properties match those of a `TextTransformationProperty`
 *
 * @param properties - the TypeScript properties of a `TextTransformationProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_TextTransformationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('priority', cdk.requiredValidator)(properties.priority));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "TextTransformationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.TextTransformation` resource
 *
 * @param properties - the TypeScript properties of a `TextTransformationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.TextTransformation` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupTextTransformationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_TextTransformationPropertyValidator(properties).assertSuccess();
    return {
        Priority: cdk.numberToCloudFormation(properties.priority),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
/**
 * Determine whether the given properties match those of a `VisibilityConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VisibilityConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_VisibilityConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('cloudWatchMetricsEnabled', cdk.requiredValidator)(properties.cloudWatchMetricsEnabled));
    errors.collect(cdk.propertyValidator('cloudWatchMetricsEnabled', cdk.validateBoolean)(properties.cloudWatchMetricsEnabled));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('sampledRequestsEnabled', cdk.requiredValidator)(properties.sampledRequestsEnabled));
    errors.collect(cdk.propertyValidator('sampledRequestsEnabled', cdk.validateBoolean)(properties.sampledRequestsEnabled));
    return errors.wrap('supplied properties not correct for "VisibilityConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.VisibilityConfig` resource
 *
 * @param properties - the TypeScript properties of a `VisibilityConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.VisibilityConfig` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupVisibilityConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_VisibilityConfigPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchMetricsEnabled: cdk.booleanToCloudFormation(properties.cloudWatchMetricsEnabled),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        SampledRequestsEnabled: cdk.booleanToCloudFormation(properties.sampledRequestsEnabled),
    };
}
/**
 * Determine whether the given properties match those of a `XssMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `XssMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnRuleGroup_XssMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnRuleGroup_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnRuleGroup_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "XssMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.XssMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `XssMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::RuleGroup.XssMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnRuleGroupXssMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnRuleGroup_XssMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        FieldToMatch: cfnRuleGroupFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        TextTransformations: cdk.listMapper(cfnRuleGroupTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `CfnWebACLProps`
 *
 * @param properties - the TypeScript properties of a `CfnWebACLProps`
 *
 * @returns the result of the validation.
 */
function CfnWebACLPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('defaultAction', cdk.requiredValidator)(properties.defaultAction));
    errors.collect(cdk.propertyValidator('defaultAction', CfnWebACL_DefaultActionPropertyValidator)(properties.defaultAction));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('rules', cdk.listValidator(CfnWebACL_RulePropertyValidator))(properties.rules));
    errors.collect(cdk.propertyValidator('scope', cdk.requiredValidator)(properties.scope));
    errors.collect(cdk.propertyValidator('scope', cdk.validateString)(properties.scope));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('visibilityConfig', cdk.requiredValidator)(properties.visibilityConfig));
    errors.collect(cdk.propertyValidator('visibilityConfig', CfnWebACL_VisibilityConfigPropertyValidator)(properties.visibilityConfig));
    return errors.wrap('supplied properties not correct for "CfnWebACLProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL` resource
 *
 * @param properties - the TypeScript properties of a `CfnWebACLProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL` resource.
 */
// @ts-ignore TS6133
function cfnWebACLPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACLPropsValidator(properties).assertSuccess();
    return {
        DefaultAction: cfnWebACLDefaultActionPropertyToCloudFormation(properties.defaultAction),
        Scope: cdk.stringToCloudFormation(properties.scope),
        VisibilityConfig: cfnWebACLVisibilityConfigPropertyToCloudFormation(properties.visibilityConfig),
        Description: cdk.stringToCloudFormation(properties.description),
        Name: cdk.stringToCloudFormation(properties.name),
        Rules: cdk.listMapper(cfnWebACLRulePropertyToCloudFormation)(properties.rules),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
/**
 * A CloudFormation `AWS::WAFv2::WebACL`
 *
 * @cloudformationResource AWS::WAFv2::WebACL
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html
 */
class CfnWebACL extends cdk.CfnResource {
    /**
     * Create a new `AWS::WAFv2::WebACL`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnWebACL.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'defaultAction', this);
        cdk.requireProperty(props, 'scope', this);
        cdk.requireProperty(props, 'visibilityConfig', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCapacity = cdk.Token.asNumber(this.getAtt('Capacity'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.defaultAction = props.defaultAction;
        this.scope = props.scope;
        this.visibilityConfig = props.visibilityConfig;
        this.description = props.description;
        this.name = props.name;
        this.rules = props.rules;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::WAFv2::WebACL", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnWebACL.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            defaultAction: this.defaultAction,
            scope: this.scope,
            visibilityConfig: this.visibilityConfig,
            description: this.description,
            name: this.name,
            rules: this.rules,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnWebACLPropsToCloudFormation(props);
    }
}
exports.CfnWebACL = CfnWebACL;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnWebACL.CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::WebACL";
/**
 * Determine whether the given properties match those of a `AndStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `AndStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_AndStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnWebACL_StatementTwoPropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "AndStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.AndStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `AndStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.AndStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnWebACLAndStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_AndStatementOnePropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnWebACLStatementTwoPropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `AndStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `AndStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_AndStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnWebACL_StatementThreePropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "AndStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.AndStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `AndStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.AndStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnWebACLAndStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_AndStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnWebACLStatementThreePropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `ByteMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `ByteMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_ByteMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnWebACL_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('positionalConstraint', cdk.requiredValidator)(properties.positionalConstraint));
    errors.collect(cdk.propertyValidator('positionalConstraint', cdk.validateString)(properties.positionalConstraint));
    errors.collect(cdk.propertyValidator('searchString', cdk.validateString)(properties.searchString));
    errors.collect(cdk.propertyValidator('searchStringBase64', cdk.validateString)(properties.searchStringBase64));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnWebACL_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "ByteMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.ByteMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `ByteMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.ByteMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLByteMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_ByteMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        FieldToMatch: cfnWebACLFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        PositionalConstraint: cdk.stringToCloudFormation(properties.positionalConstraint),
        SearchString: cdk.stringToCloudFormation(properties.searchString),
        SearchStringBase64: cdk.stringToCloudFormation(properties.searchStringBase64),
        TextTransformations: cdk.listMapper(cfnWebACLTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `DefaultActionProperty`
 *
 * @param properties - the TypeScript properties of a `DefaultActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_DefaultActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allow', cdk.validateObject)(properties.allow));
    errors.collect(cdk.propertyValidator('block', cdk.validateObject)(properties.block));
    return errors.wrap('supplied properties not correct for "DefaultActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.DefaultAction` resource
 *
 * @param properties - the TypeScript properties of a `DefaultActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.DefaultAction` resource.
 */
// @ts-ignore TS6133
function cfnWebACLDefaultActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_DefaultActionPropertyValidator(properties).assertSuccess();
    return {
        Allow: cdk.objectToCloudFormation(properties.allow),
        Block: cdk.objectToCloudFormation(properties.block),
    };
}
/**
 * Determine whether the given properties match those of a `ExcludedRuleProperty`
 *
 * @param properties - the TypeScript properties of a `ExcludedRuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_ExcludedRulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "ExcludedRuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.ExcludedRule` resource
 *
 * @param properties - the TypeScript properties of a `ExcludedRuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.ExcludedRule` resource.
 */
// @ts-ignore TS6133
function cfnWebACLExcludedRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_ExcludedRulePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
/**
 * Determine whether the given properties match those of a `FieldToMatchProperty`
 *
 * @param properties - the TypeScript properties of a `FieldToMatchProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_FieldToMatchPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allQueryArguments', cdk.validateObject)(properties.allQueryArguments));
    errors.collect(cdk.propertyValidator('body', cdk.validateObject)(properties.body));
    errors.collect(cdk.propertyValidator('method', cdk.validateObject)(properties.method));
    errors.collect(cdk.propertyValidator('queryString', cdk.validateObject)(properties.queryString));
    errors.collect(cdk.propertyValidator('singleHeader', cdk.validateObject)(properties.singleHeader));
    errors.collect(cdk.propertyValidator('singleQueryArgument', cdk.validateObject)(properties.singleQueryArgument));
    errors.collect(cdk.propertyValidator('uriPath', cdk.validateObject)(properties.uriPath));
    return errors.wrap('supplied properties not correct for "FieldToMatchProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.FieldToMatch` resource
 *
 * @param properties - the TypeScript properties of a `FieldToMatchProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.FieldToMatch` resource.
 */
// @ts-ignore TS6133
function cfnWebACLFieldToMatchPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_FieldToMatchPropertyValidator(properties).assertSuccess();
    return {
        AllQueryArguments: cdk.objectToCloudFormation(properties.allQueryArguments),
        Body: cdk.objectToCloudFormation(properties.body),
        Method: cdk.objectToCloudFormation(properties.method),
        QueryString: cdk.objectToCloudFormation(properties.queryString),
        SingleHeader: cdk.objectToCloudFormation(properties.singleHeader),
        SingleQueryArgument: cdk.objectToCloudFormation(properties.singleQueryArgument),
        UriPath: cdk.objectToCloudFormation(properties.uriPath),
    };
}
/**
 * Determine whether the given properties match those of a `GeoMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `GeoMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_GeoMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('countryCodes', cdk.listValidator(cdk.validateString))(properties.countryCodes));
    return errors.wrap('supplied properties not correct for "GeoMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.GeoMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `GeoMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.GeoMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLGeoMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_GeoMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        CountryCodes: cdk.listMapper(cdk.stringToCloudFormation)(properties.countryCodes),
    };
}
/**
 * Determine whether the given properties match those of a `IPSetReferenceStatementProperty`
 *
 * @param properties - the TypeScript properties of a `IPSetReferenceStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_IPSetReferenceStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('arn', cdk.requiredValidator)(properties.arn));
    errors.collect(cdk.propertyValidator('arn', cdk.validateString)(properties.arn));
    return errors.wrap('supplied properties not correct for "IPSetReferenceStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.IPSetReferenceStatement` resource
 *
 * @param properties - the TypeScript properties of a `IPSetReferenceStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.IPSetReferenceStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLIPSetReferenceStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_IPSetReferenceStatementPropertyValidator(properties).assertSuccess();
    return {
        Arn: cdk.stringToCloudFormation(properties.arn),
    };
}
/**
 * Determine whether the given properties match those of a `ManagedRuleGroupStatementProperty`
 *
 * @param properties - the TypeScript properties of a `ManagedRuleGroupStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_ManagedRuleGroupStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('excludedRules', cdk.listValidator(CfnWebACL_ExcludedRulePropertyValidator))(properties.excludedRules));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('vendorName', cdk.requiredValidator)(properties.vendorName));
    errors.collect(cdk.propertyValidator('vendorName', cdk.validateString)(properties.vendorName));
    return errors.wrap('supplied properties not correct for "ManagedRuleGroupStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.ManagedRuleGroupStatement` resource
 *
 * @param properties - the TypeScript properties of a `ManagedRuleGroupStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.ManagedRuleGroupStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLManagedRuleGroupStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_ManagedRuleGroupStatementPropertyValidator(properties).assertSuccess();
    return {
        ExcludedRules: cdk.listMapper(cfnWebACLExcludedRulePropertyToCloudFormation)(properties.excludedRules),
        Name: cdk.stringToCloudFormation(properties.name),
        VendorName: cdk.stringToCloudFormation(properties.vendorName),
    };
}
/**
 * Determine whether the given properties match those of a `NotStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `NotStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_NotStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statement', cdk.requiredValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('statement', CfnWebACL_StatementTwoPropertyValidator)(properties.statement));
    return errors.wrap('supplied properties not correct for "NotStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.NotStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `NotStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.NotStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnWebACLNotStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_NotStatementOnePropertyValidator(properties).assertSuccess();
    return {
        Statement: cfnWebACLStatementTwoPropertyToCloudFormation(properties.statement),
    };
}
/**
 * Determine whether the given properties match those of a `NotStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `NotStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_NotStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statement', cdk.requiredValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('statement', CfnWebACL_StatementThreePropertyValidator)(properties.statement));
    return errors.wrap('supplied properties not correct for "NotStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.NotStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `NotStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.NotStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnWebACLNotStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_NotStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        Statement: cfnWebACLStatementThreePropertyToCloudFormation(properties.statement),
    };
}
/**
 * Determine whether the given properties match those of a `OrStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `OrStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_OrStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnWebACL_StatementTwoPropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "OrStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.OrStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `OrStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.OrStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnWebACLOrStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_OrStatementOnePropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnWebACLStatementTwoPropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `OrStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `OrStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_OrStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('statements', cdk.requiredValidator)(properties.statements));
    errors.collect(cdk.propertyValidator('statements', cdk.listValidator(CfnWebACL_StatementThreePropertyValidator))(properties.statements));
    return errors.wrap('supplied properties not correct for "OrStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.OrStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `OrStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.OrStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnWebACLOrStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_OrStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        Statements: cdk.listMapper(cfnWebACLStatementThreePropertyToCloudFormation)(properties.statements),
    };
}
/**
 * Determine whether the given properties match those of a `OverrideActionProperty`
 *
 * @param properties - the TypeScript properties of a `OverrideActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_OverrideActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('count', cdk.validateObject)(properties.count));
    errors.collect(cdk.propertyValidator('none', cdk.validateObject)(properties.none));
    return errors.wrap('supplied properties not correct for "OverrideActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.OverrideAction` resource
 *
 * @param properties - the TypeScript properties of a `OverrideActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.OverrideAction` resource.
 */
// @ts-ignore TS6133
function cfnWebACLOverrideActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_OverrideActionPropertyValidator(properties).assertSuccess();
    return {
        Count: cdk.objectToCloudFormation(properties.count),
        None: cdk.objectToCloudFormation(properties.none),
    };
}
/**
 * Determine whether the given properties match those of a `RateBasedStatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_RateBasedStatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.requiredValidator)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.validateString)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('limit', cdk.requiredValidator)(properties.limit));
    errors.collect(cdk.propertyValidator('limit', cdk.validateNumber)(properties.limit));
    errors.collect(cdk.propertyValidator('scopeDownStatement', CfnWebACL_StatementTwoPropertyValidator)(properties.scopeDownStatement));
    return errors.wrap('supplied properties not correct for "RateBasedStatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RateBasedStatementOne` resource
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RateBasedStatementOne` resource.
 */
// @ts-ignore TS6133
function cfnWebACLRateBasedStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_RateBasedStatementOnePropertyValidator(properties).assertSuccess();
    return {
        AggregateKeyType: cdk.stringToCloudFormation(properties.aggregateKeyType),
        Limit: cdk.numberToCloudFormation(properties.limit),
        ScopeDownStatement: cfnWebACLStatementTwoPropertyToCloudFormation(properties.scopeDownStatement),
    };
}
/**
 * Determine whether the given properties match those of a `RateBasedStatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_RateBasedStatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.requiredValidator)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('aggregateKeyType', cdk.validateString)(properties.aggregateKeyType));
    errors.collect(cdk.propertyValidator('limit', cdk.requiredValidator)(properties.limit));
    errors.collect(cdk.propertyValidator('limit', cdk.validateNumber)(properties.limit));
    errors.collect(cdk.propertyValidator('scopeDownStatement', CfnWebACL_StatementThreePropertyValidator)(properties.scopeDownStatement));
    return errors.wrap('supplied properties not correct for "RateBasedStatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RateBasedStatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `RateBasedStatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RateBasedStatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnWebACLRateBasedStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_RateBasedStatementTwoPropertyValidator(properties).assertSuccess();
    return {
        AggregateKeyType: cdk.stringToCloudFormation(properties.aggregateKeyType),
        Limit: cdk.numberToCloudFormation(properties.limit),
        ScopeDownStatement: cfnWebACLStatementThreePropertyToCloudFormation(properties.scopeDownStatement),
    };
}
/**
 * Determine whether the given properties match those of a `RegexPatternSetReferenceStatementProperty`
 *
 * @param properties - the TypeScript properties of a `RegexPatternSetReferenceStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_RegexPatternSetReferenceStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('arn', cdk.requiredValidator)(properties.arn));
    errors.collect(cdk.propertyValidator('arn', cdk.validateString)(properties.arn));
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnWebACL_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnWebACL_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "RegexPatternSetReferenceStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RegexPatternSetReferenceStatement` resource
 *
 * @param properties - the TypeScript properties of a `RegexPatternSetReferenceStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RegexPatternSetReferenceStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLRegexPatternSetReferenceStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_RegexPatternSetReferenceStatementPropertyValidator(properties).assertSuccess();
    return {
        Arn: cdk.stringToCloudFormation(properties.arn),
        FieldToMatch: cfnWebACLFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        TextTransformations: cdk.listMapper(cfnWebACLTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `RuleProperty`
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_RulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('action', CfnWebACL_RuleActionPropertyValidator)(properties.action));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('overrideAction', CfnWebACL_OverrideActionPropertyValidator)(properties.overrideAction));
    errors.collect(cdk.propertyValidator('priority', cdk.requiredValidator)(properties.priority));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    errors.collect(cdk.propertyValidator('statement', cdk.requiredValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('statement', CfnWebACL_StatementOnePropertyValidator)(properties.statement));
    errors.collect(cdk.propertyValidator('visibilityConfig', cdk.requiredValidator)(properties.visibilityConfig));
    errors.collect(cdk.propertyValidator('visibilityConfig', CfnWebACL_VisibilityConfigPropertyValidator)(properties.visibilityConfig));
    return errors.wrap('supplied properties not correct for "RuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.Rule` resource
 *
 * @param properties - the TypeScript properties of a `RuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.Rule` resource.
 */
// @ts-ignore TS6133
function cfnWebACLRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_RulePropertyValidator(properties).assertSuccess();
    return {
        Action: cfnWebACLRuleActionPropertyToCloudFormation(properties.action),
        Name: cdk.stringToCloudFormation(properties.name),
        OverrideAction: cfnWebACLOverrideActionPropertyToCloudFormation(properties.overrideAction),
        Priority: cdk.numberToCloudFormation(properties.priority),
        Statement: cfnWebACLStatementOnePropertyToCloudFormation(properties.statement),
        VisibilityConfig: cfnWebACLVisibilityConfigPropertyToCloudFormation(properties.visibilityConfig),
    };
}
/**
 * Determine whether the given properties match those of a `RuleActionProperty`
 *
 * @param properties - the TypeScript properties of a `RuleActionProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_RuleActionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('allow', cdk.validateObject)(properties.allow));
    errors.collect(cdk.propertyValidator('block', cdk.validateObject)(properties.block));
    errors.collect(cdk.propertyValidator('count', cdk.validateObject)(properties.count));
    return errors.wrap('supplied properties not correct for "RuleActionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RuleAction` resource
 *
 * @param properties - the TypeScript properties of a `RuleActionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RuleAction` resource.
 */
// @ts-ignore TS6133
function cfnWebACLRuleActionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_RuleActionPropertyValidator(properties).assertSuccess();
    return {
        Allow: cdk.objectToCloudFormation(properties.allow),
        Block: cdk.objectToCloudFormation(properties.block),
        Count: cdk.objectToCloudFormation(properties.count),
    };
}
/**
 * Determine whether the given properties match those of a `RuleGroupReferenceStatementProperty`
 *
 * @param properties - the TypeScript properties of a `RuleGroupReferenceStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_RuleGroupReferenceStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('arn', cdk.requiredValidator)(properties.arn));
    errors.collect(cdk.propertyValidator('arn', cdk.validateString)(properties.arn));
    errors.collect(cdk.propertyValidator('excludedRules', cdk.listValidator(CfnWebACL_ExcludedRulePropertyValidator))(properties.excludedRules));
    return errors.wrap('supplied properties not correct for "RuleGroupReferenceStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RuleGroupReferenceStatement` resource
 *
 * @param properties - the TypeScript properties of a `RuleGroupReferenceStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.RuleGroupReferenceStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLRuleGroupReferenceStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_RuleGroupReferenceStatementPropertyValidator(properties).assertSuccess();
    return {
        Arn: cdk.stringToCloudFormation(properties.arn),
        ExcludedRules: cdk.listMapper(cfnWebACLExcludedRulePropertyToCloudFormation)(properties.excludedRules),
    };
}
/**
 * Determine whether the given properties match those of a `SizeConstraintStatementProperty`
 *
 * @param properties - the TypeScript properties of a `SizeConstraintStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_SizeConstraintStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.requiredValidator)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('comparisonOperator', cdk.validateString)(properties.comparisonOperator));
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnWebACL_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('size', cdk.requiredValidator)(properties.size));
    errors.collect(cdk.propertyValidator('size', cdk.validateNumber)(properties.size));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnWebACL_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "SizeConstraintStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.SizeConstraintStatement` resource
 *
 * @param properties - the TypeScript properties of a `SizeConstraintStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.SizeConstraintStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLSizeConstraintStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_SizeConstraintStatementPropertyValidator(properties).assertSuccess();
    return {
        ComparisonOperator: cdk.stringToCloudFormation(properties.comparisonOperator),
        FieldToMatch: cfnWebACLFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        Size: cdk.numberToCloudFormation(properties.size),
        TextTransformations: cdk.listMapper(cfnWebACLTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `SqliMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `SqliMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_SqliMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnWebACL_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnWebACL_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "SqliMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.SqliMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `SqliMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.SqliMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLSqliMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_SqliMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        FieldToMatch: cfnWebACLFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        TextTransformations: cdk.listMapper(cfnWebACLTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `StatementOneProperty`
 *
 * @param properties - the TypeScript properties of a `StatementOneProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_StatementOnePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('andStatement', CfnWebACL_AndStatementOnePropertyValidator)(properties.andStatement));
    errors.collect(cdk.propertyValidator('byteMatchStatement', CfnWebACL_ByteMatchStatementPropertyValidator)(properties.byteMatchStatement));
    errors.collect(cdk.propertyValidator('geoMatchStatement', CfnWebACL_GeoMatchStatementPropertyValidator)(properties.geoMatchStatement));
    errors.collect(cdk.propertyValidator('ipSetReferenceStatement', CfnWebACL_IPSetReferenceStatementPropertyValidator)(properties.ipSetReferenceStatement));
    errors.collect(cdk.propertyValidator('managedRuleGroupStatement', CfnWebACL_ManagedRuleGroupStatementPropertyValidator)(properties.managedRuleGroupStatement));
    errors.collect(cdk.propertyValidator('notStatement', CfnWebACL_NotStatementOnePropertyValidator)(properties.notStatement));
    errors.collect(cdk.propertyValidator('orStatement', CfnWebACL_OrStatementOnePropertyValidator)(properties.orStatement));
    errors.collect(cdk.propertyValidator('rateBasedStatement', CfnWebACL_RateBasedStatementOnePropertyValidator)(properties.rateBasedStatement));
    errors.collect(cdk.propertyValidator('regexPatternSetReferenceStatement', CfnWebACL_RegexPatternSetReferenceStatementPropertyValidator)(properties.regexPatternSetReferenceStatement));
    errors.collect(cdk.propertyValidator('ruleGroupReferenceStatement', CfnWebACL_RuleGroupReferenceStatementPropertyValidator)(properties.ruleGroupReferenceStatement));
    errors.collect(cdk.propertyValidator('sizeConstraintStatement', CfnWebACL_SizeConstraintStatementPropertyValidator)(properties.sizeConstraintStatement));
    errors.collect(cdk.propertyValidator('sqliMatchStatement', CfnWebACL_SqliMatchStatementPropertyValidator)(properties.sqliMatchStatement));
    errors.collect(cdk.propertyValidator('xssMatchStatement', CfnWebACL_XssMatchStatementPropertyValidator)(properties.xssMatchStatement));
    return errors.wrap('supplied properties not correct for "StatementOneProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.StatementOne` resource
 *
 * @param properties - the TypeScript properties of a `StatementOneProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.StatementOne` resource.
 */
// @ts-ignore TS6133
function cfnWebACLStatementOnePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_StatementOnePropertyValidator(properties).assertSuccess();
    return {
        AndStatement: cfnWebACLAndStatementOnePropertyToCloudFormation(properties.andStatement),
        ByteMatchStatement: cfnWebACLByteMatchStatementPropertyToCloudFormation(properties.byteMatchStatement),
        GeoMatchStatement: cfnWebACLGeoMatchStatementPropertyToCloudFormation(properties.geoMatchStatement),
        IPSetReferenceStatement: cfnWebACLIPSetReferenceStatementPropertyToCloudFormation(properties.ipSetReferenceStatement),
        ManagedRuleGroupStatement: cfnWebACLManagedRuleGroupStatementPropertyToCloudFormation(properties.managedRuleGroupStatement),
        NotStatement: cfnWebACLNotStatementOnePropertyToCloudFormation(properties.notStatement),
        OrStatement: cfnWebACLOrStatementOnePropertyToCloudFormation(properties.orStatement),
        RateBasedStatement: cfnWebACLRateBasedStatementOnePropertyToCloudFormation(properties.rateBasedStatement),
        RegexPatternSetReferenceStatement: cfnWebACLRegexPatternSetReferenceStatementPropertyToCloudFormation(properties.regexPatternSetReferenceStatement),
        RuleGroupReferenceStatement: cfnWebACLRuleGroupReferenceStatementPropertyToCloudFormation(properties.ruleGroupReferenceStatement),
        SizeConstraintStatement: cfnWebACLSizeConstraintStatementPropertyToCloudFormation(properties.sizeConstraintStatement),
        SqliMatchStatement: cfnWebACLSqliMatchStatementPropertyToCloudFormation(properties.sqliMatchStatement),
        XssMatchStatement: cfnWebACLXssMatchStatementPropertyToCloudFormation(properties.xssMatchStatement),
    };
}
/**
 * Determine whether the given properties match those of a `StatementThreeProperty`
 *
 * @param properties - the TypeScript properties of a `StatementThreeProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_StatementThreePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('byteMatchStatement', CfnWebACL_ByteMatchStatementPropertyValidator)(properties.byteMatchStatement));
    errors.collect(cdk.propertyValidator('geoMatchStatement', CfnWebACL_GeoMatchStatementPropertyValidator)(properties.geoMatchStatement));
    errors.collect(cdk.propertyValidator('ipSetReferenceStatement', CfnWebACL_IPSetReferenceStatementPropertyValidator)(properties.ipSetReferenceStatement));
    errors.collect(cdk.propertyValidator('managedRuleGroupStatement', CfnWebACL_ManagedRuleGroupStatementPropertyValidator)(properties.managedRuleGroupStatement));
    errors.collect(cdk.propertyValidator('regexPatternSetReferenceStatement', CfnWebACL_RegexPatternSetReferenceStatementPropertyValidator)(properties.regexPatternSetReferenceStatement));
    errors.collect(cdk.propertyValidator('ruleGroupReferenceStatement', CfnWebACL_RuleGroupReferenceStatementPropertyValidator)(properties.ruleGroupReferenceStatement));
    errors.collect(cdk.propertyValidator('sizeConstraintStatement', CfnWebACL_SizeConstraintStatementPropertyValidator)(properties.sizeConstraintStatement));
    errors.collect(cdk.propertyValidator('sqliMatchStatement', CfnWebACL_SqliMatchStatementPropertyValidator)(properties.sqliMatchStatement));
    errors.collect(cdk.propertyValidator('xssMatchStatement', CfnWebACL_XssMatchStatementPropertyValidator)(properties.xssMatchStatement));
    return errors.wrap('supplied properties not correct for "StatementThreeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.StatementThree` resource
 *
 * @param properties - the TypeScript properties of a `StatementThreeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.StatementThree` resource.
 */
// @ts-ignore TS6133
function cfnWebACLStatementThreePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_StatementThreePropertyValidator(properties).assertSuccess();
    return {
        ByteMatchStatement: cfnWebACLByteMatchStatementPropertyToCloudFormation(properties.byteMatchStatement),
        GeoMatchStatement: cfnWebACLGeoMatchStatementPropertyToCloudFormation(properties.geoMatchStatement),
        IPSetReferenceStatement: cfnWebACLIPSetReferenceStatementPropertyToCloudFormation(properties.ipSetReferenceStatement),
        ManagedRuleGroupStatement: cfnWebACLManagedRuleGroupStatementPropertyToCloudFormation(properties.managedRuleGroupStatement),
        RegexPatternSetReferenceStatement: cfnWebACLRegexPatternSetReferenceStatementPropertyToCloudFormation(properties.regexPatternSetReferenceStatement),
        RuleGroupReferenceStatement: cfnWebACLRuleGroupReferenceStatementPropertyToCloudFormation(properties.ruleGroupReferenceStatement),
        SizeConstraintStatement: cfnWebACLSizeConstraintStatementPropertyToCloudFormation(properties.sizeConstraintStatement),
        SqliMatchStatement: cfnWebACLSqliMatchStatementPropertyToCloudFormation(properties.sqliMatchStatement),
        XssMatchStatement: cfnWebACLXssMatchStatementPropertyToCloudFormation(properties.xssMatchStatement),
    };
}
/**
 * Determine whether the given properties match those of a `StatementTwoProperty`
 *
 * @param properties - the TypeScript properties of a `StatementTwoProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_StatementTwoPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('andStatement', CfnWebACL_AndStatementTwoPropertyValidator)(properties.andStatement));
    errors.collect(cdk.propertyValidator('byteMatchStatement', CfnWebACL_ByteMatchStatementPropertyValidator)(properties.byteMatchStatement));
    errors.collect(cdk.propertyValidator('geoMatchStatement', CfnWebACL_GeoMatchStatementPropertyValidator)(properties.geoMatchStatement));
    errors.collect(cdk.propertyValidator('ipSetReferenceStatement', CfnWebACL_IPSetReferenceStatementPropertyValidator)(properties.ipSetReferenceStatement));
    errors.collect(cdk.propertyValidator('managedRuleGroupStatement', CfnWebACL_ManagedRuleGroupStatementPropertyValidator)(properties.managedRuleGroupStatement));
    errors.collect(cdk.propertyValidator('notStatement', CfnWebACL_NotStatementTwoPropertyValidator)(properties.notStatement));
    errors.collect(cdk.propertyValidator('orStatement', CfnWebACL_OrStatementTwoPropertyValidator)(properties.orStatement));
    errors.collect(cdk.propertyValidator('rateBasedStatement', CfnWebACL_RateBasedStatementTwoPropertyValidator)(properties.rateBasedStatement));
    errors.collect(cdk.propertyValidator('regexPatternSetReferenceStatement', CfnWebACL_RegexPatternSetReferenceStatementPropertyValidator)(properties.regexPatternSetReferenceStatement));
    errors.collect(cdk.propertyValidator('ruleGroupReferenceStatement', CfnWebACL_RuleGroupReferenceStatementPropertyValidator)(properties.ruleGroupReferenceStatement));
    errors.collect(cdk.propertyValidator('sizeConstraintStatement', CfnWebACL_SizeConstraintStatementPropertyValidator)(properties.sizeConstraintStatement));
    errors.collect(cdk.propertyValidator('sqliMatchStatement', CfnWebACL_SqliMatchStatementPropertyValidator)(properties.sqliMatchStatement));
    errors.collect(cdk.propertyValidator('xssMatchStatement', CfnWebACL_XssMatchStatementPropertyValidator)(properties.xssMatchStatement));
    return errors.wrap('supplied properties not correct for "StatementTwoProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.StatementTwo` resource
 *
 * @param properties - the TypeScript properties of a `StatementTwoProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.StatementTwo` resource.
 */
// @ts-ignore TS6133
function cfnWebACLStatementTwoPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_StatementTwoPropertyValidator(properties).assertSuccess();
    return {
        AndStatement: cfnWebACLAndStatementTwoPropertyToCloudFormation(properties.andStatement),
        ByteMatchStatement: cfnWebACLByteMatchStatementPropertyToCloudFormation(properties.byteMatchStatement),
        GeoMatchStatement: cfnWebACLGeoMatchStatementPropertyToCloudFormation(properties.geoMatchStatement),
        IPSetReferenceStatement: cfnWebACLIPSetReferenceStatementPropertyToCloudFormation(properties.ipSetReferenceStatement),
        ManagedRuleGroupStatement: cfnWebACLManagedRuleGroupStatementPropertyToCloudFormation(properties.managedRuleGroupStatement),
        NotStatement: cfnWebACLNotStatementTwoPropertyToCloudFormation(properties.notStatement),
        OrStatement: cfnWebACLOrStatementTwoPropertyToCloudFormation(properties.orStatement),
        RateBasedStatement: cfnWebACLRateBasedStatementTwoPropertyToCloudFormation(properties.rateBasedStatement),
        RegexPatternSetReferenceStatement: cfnWebACLRegexPatternSetReferenceStatementPropertyToCloudFormation(properties.regexPatternSetReferenceStatement),
        RuleGroupReferenceStatement: cfnWebACLRuleGroupReferenceStatementPropertyToCloudFormation(properties.ruleGroupReferenceStatement),
        SizeConstraintStatement: cfnWebACLSizeConstraintStatementPropertyToCloudFormation(properties.sizeConstraintStatement),
        SqliMatchStatement: cfnWebACLSqliMatchStatementPropertyToCloudFormation(properties.sqliMatchStatement),
        XssMatchStatement: cfnWebACLXssMatchStatementPropertyToCloudFormation(properties.xssMatchStatement),
    };
}
/**
 * Determine whether the given properties match those of a `TextTransformationProperty`
 *
 * @param properties - the TypeScript properties of a `TextTransformationProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_TextTransformationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('priority', cdk.requiredValidator)(properties.priority));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "TextTransformationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.TextTransformation` resource
 *
 * @param properties - the TypeScript properties of a `TextTransformationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.TextTransformation` resource.
 */
// @ts-ignore TS6133
function cfnWebACLTextTransformationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_TextTransformationPropertyValidator(properties).assertSuccess();
    return {
        Priority: cdk.numberToCloudFormation(properties.priority),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
/**
 * Determine whether the given properties match those of a `VisibilityConfigProperty`
 *
 * @param properties - the TypeScript properties of a `VisibilityConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_VisibilityConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('cloudWatchMetricsEnabled', cdk.requiredValidator)(properties.cloudWatchMetricsEnabled));
    errors.collect(cdk.propertyValidator('cloudWatchMetricsEnabled', cdk.validateBoolean)(properties.cloudWatchMetricsEnabled));
    errors.collect(cdk.propertyValidator('metricName', cdk.requiredValidator)(properties.metricName));
    errors.collect(cdk.propertyValidator('metricName', cdk.validateString)(properties.metricName));
    errors.collect(cdk.propertyValidator('sampledRequestsEnabled', cdk.requiredValidator)(properties.sampledRequestsEnabled));
    errors.collect(cdk.propertyValidator('sampledRequestsEnabled', cdk.validateBoolean)(properties.sampledRequestsEnabled));
    return errors.wrap('supplied properties not correct for "VisibilityConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.VisibilityConfig` resource
 *
 * @param properties - the TypeScript properties of a `VisibilityConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.VisibilityConfig` resource.
 */
// @ts-ignore TS6133
function cfnWebACLVisibilityConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_VisibilityConfigPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchMetricsEnabled: cdk.booleanToCloudFormation(properties.cloudWatchMetricsEnabled),
        MetricName: cdk.stringToCloudFormation(properties.metricName),
        SampledRequestsEnabled: cdk.booleanToCloudFormation(properties.sampledRequestsEnabled),
    };
}
/**
 * Determine whether the given properties match those of a `XssMatchStatementProperty`
 *
 * @param properties - the TypeScript properties of a `XssMatchStatementProperty`
 *
 * @returns the result of the validation.
 */
function CfnWebACL_XssMatchStatementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('fieldToMatch', cdk.requiredValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('fieldToMatch', CfnWebACL_FieldToMatchPropertyValidator)(properties.fieldToMatch));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.requiredValidator)(properties.textTransformations));
    errors.collect(cdk.propertyValidator('textTransformations', cdk.listValidator(CfnWebACL_TextTransformationPropertyValidator))(properties.textTransformations));
    return errors.wrap('supplied properties not correct for "XssMatchStatementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.XssMatchStatement` resource
 *
 * @param properties - the TypeScript properties of a `XssMatchStatementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACL.XssMatchStatement` resource.
 */
// @ts-ignore TS6133
function cfnWebACLXssMatchStatementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACL_XssMatchStatementPropertyValidator(properties).assertSuccess();
    return {
        FieldToMatch: cfnWebACLFieldToMatchPropertyToCloudFormation(properties.fieldToMatch),
        TextTransformations: cdk.listMapper(cfnWebACLTextTransformationPropertyToCloudFormation)(properties.textTransformations),
    };
}
/**
 * Determine whether the given properties match those of a `CfnWebACLAssociationProps`
 *
 * @param properties - the TypeScript properties of a `CfnWebACLAssociationProps`
 *
 * @returns the result of the validation.
 */
function CfnWebACLAssociationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('resourceArn', cdk.requiredValidator)(properties.resourceArn));
    errors.collect(cdk.propertyValidator('resourceArn', cdk.validateString)(properties.resourceArn));
    errors.collect(cdk.propertyValidator('webAclArn', cdk.requiredValidator)(properties.webAclArn));
    errors.collect(cdk.propertyValidator('webAclArn', cdk.validateString)(properties.webAclArn));
    return errors.wrap('supplied properties not correct for "CfnWebACLAssociationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::WAFv2::WebACLAssociation` resource
 *
 * @param properties - the TypeScript properties of a `CfnWebACLAssociationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::WAFv2::WebACLAssociation` resource.
 */
// @ts-ignore TS6133
function cfnWebACLAssociationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnWebACLAssociationPropsValidator(properties).assertSuccess();
    return {
        ResourceArn: cdk.stringToCloudFormation(properties.resourceArn),
        WebACLArn: cdk.stringToCloudFormation(properties.webAclArn),
    };
}
/**
 * A CloudFormation `AWS::WAFv2::WebACLAssociation`
 *
 * @cloudformationResource AWS::WAFv2::WebACLAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html
 */
class CfnWebACLAssociation extends cdk.CfnResource {
    /**
     * Create a new `AWS::WAFv2::WebACLAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnWebACLAssociation.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'resourceArn', this);
        cdk.requireProperty(props, 'webAclArn', this);
        this.resourceArn = props.resourceArn;
        this.webAclArn = props.webAclArn;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnWebACLAssociation.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            resourceArn: this.resourceArn,
            webAclArn: this.webAclArn,
        };
    }
    renderProperties(props) {
        return cfnWebACLAssociationPropsToCloudFormation(props);
    }
}
exports.CfnWebACLAssociation = CfnWebACLAssociation;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnWebACLAssociation.CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::WebACLAssociation";
//# sourceMappingURL=data:application/json;base64,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