import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::WAFv2::IPSet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
 */
export interface CfnIPSetProps {
    /**
     * `AWS::WAFv2::IPSet.Addresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
     */
    readonly addresses: string[];
    /**
     * `AWS::WAFv2::IPSet.IPAddressVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
     */
    readonly ipAddressVersion: string;
    /**
     * `AWS::WAFv2::IPSet.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
     */
    readonly scope: string;
    /**
     * `AWS::WAFv2::IPSet.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
     */
    readonly description?: string;
    /**
     * `AWS::WAFv2::IPSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
     */
    readonly name?: string;
    /**
     * `AWS::WAFv2::IPSet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::WAFv2::IPSet`
 *
 * @cloudformationResource AWS::WAFv2::IPSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html
 */
export declare class CfnIPSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::IPSet";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::WAFv2::IPSet.Addresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-addresses
     */
    addresses: string[];
    /**
     * `AWS::WAFv2::IPSet.IPAddressVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-ipaddressversion
     */
    ipAddressVersion: string;
    /**
     * `AWS::WAFv2::IPSet.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-scope
     */
    scope: string;
    /**
     * `AWS::WAFv2::IPSet.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-description
     */
    description: string | undefined;
    /**
     * `AWS::WAFv2::IPSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-name
     */
    name: string | undefined;
    /**
     * `AWS::WAFv2::IPSet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-ipset.html#cfn-wafv2-ipset-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::WAFv2::IPSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIPSetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::WAFv2::RegexPatternSet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
 */
export interface CfnRegexPatternSetProps {
    /**
     * `AWS::WAFv2::RegexPatternSet.RegularExpressionList`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
     */
    readonly regularExpressionList: string[];
    /**
     * `AWS::WAFv2::RegexPatternSet.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
     */
    readonly scope: string;
    /**
     * `AWS::WAFv2::RegexPatternSet.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
     */
    readonly description?: string;
    /**
     * `AWS::WAFv2::RegexPatternSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
     */
    readonly name?: string;
    /**
     * `AWS::WAFv2::RegexPatternSet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::WAFv2::RegexPatternSet`
 *
 * @cloudformationResource AWS::WAFv2::RegexPatternSet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html
 */
export declare class CfnRegexPatternSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::RegexPatternSet";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::WAFv2::RegexPatternSet.RegularExpressionList`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-regularexpressionlist
     */
    regularExpressionList: string[];
    /**
     * `AWS::WAFv2::RegexPatternSet.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-scope
     */
    scope: string;
    /**
     * `AWS::WAFv2::RegexPatternSet.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-description
     */
    description: string | undefined;
    /**
     * `AWS::WAFv2::RegexPatternSet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-name
     */
    name: string | undefined;
    /**
     * `AWS::WAFv2::RegexPatternSet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-regexpatternset.html#cfn-wafv2-regexpatternset-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::WAFv2::RegexPatternSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRegexPatternSetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::WAFv2::RuleGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
 */
export interface CfnRuleGroupProps {
    /**
     * `AWS::WAFv2::RuleGroup.Capacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
     */
    readonly capacity: number;
    /**
     * `AWS::WAFv2::RuleGroup.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
     */
    readonly scope: string;
    /**
     * `AWS::WAFv2::RuleGroup.VisibilityConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
     */
    readonly visibilityConfig: CfnRuleGroup.VisibilityConfigProperty | cdk.IResolvable;
    /**
     * `AWS::WAFv2::RuleGroup.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
     */
    readonly description?: string;
    /**
     * `AWS::WAFv2::RuleGroup.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
     */
    readonly name?: string;
    /**
     * `AWS::WAFv2::RuleGroup.Rules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
     */
    readonly rules?: Array<CfnRuleGroup.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::WAFv2::RuleGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::WAFv2::RuleGroup`
 *
 * @cloudformationResource AWS::WAFv2::RuleGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html
 */
export declare class CfnRuleGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::RuleGroup";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::WAFv2::RuleGroup.Capacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity
     */
    capacity: number;
    /**
     * `AWS::WAFv2::RuleGroup.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope
     */
    scope: string;
    /**
     * `AWS::WAFv2::RuleGroup.VisibilityConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig
     */
    visibilityConfig: CfnRuleGroup.VisibilityConfigProperty | cdk.IResolvable;
    /**
     * `AWS::WAFv2::RuleGroup.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description
     */
    description: string | undefined;
    /**
     * `AWS::WAFv2::RuleGroup.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name
     */
    name: string | undefined;
    /**
     * `AWS::WAFv2::RuleGroup.Rules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules
     */
    rules: Array<CfnRuleGroup.RuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::WAFv2::RuleGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::WAFv2::RuleGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRuleGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatementone.html
     */
    interface AndStatementOneProperty {
        /**
         * `CfnRuleGroup.AndStatementOneProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatementone.html#cfn-wafv2-rulegroup-andstatementone-statements
         */
        readonly statements: Array<CfnRuleGroup.StatementTwoProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatementtwo.html
     */
    interface AndStatementTwoProperty {
        /**
         * `CfnRuleGroup.AndStatementTwoProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-andstatementtwo.html#cfn-wafv2-rulegroup-andstatementtwo-statements
         */
        readonly statements: Array<CfnRuleGroup.StatementThreeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html
     */
    interface ByteMatchStatementProperty {
        /**
         * `CfnRuleGroup.ByteMatchStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnRuleGroup.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.ByteMatchStatementProperty.PositionalConstraint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-positionalconstraint
         */
        readonly positionalConstraint: string;
        /**
         * `CfnRuleGroup.ByteMatchStatementProperty.SearchString`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstring
         */
        readonly searchString?: string;
        /**
         * `CfnRuleGroup.ByteMatchStatementProperty.SearchStringBase64`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-searchstringbase64
         */
        readonly searchStringBase64?: string;
        /**
         * `CfnRuleGroup.ByteMatchStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-bytematchstatement.html#cfn-wafv2-rulegroup-bytematchstatement-texttransformations
         */
        readonly textTransformations: Array<CfnRuleGroup.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html
     */
    interface FieldToMatchProperty {
        /**
         * `CfnRuleGroup.FieldToMatchProperty.AllQueryArguments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-allqueryarguments
         */
        readonly allQueryArguments?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.FieldToMatchProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-body
         */
        readonly body?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.FieldToMatchProperty.Method`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-method
         */
        readonly method?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.FieldToMatchProperty.QueryString`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-querystring
         */
        readonly queryString?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.FieldToMatchProperty.SingleHeader`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singleheader
         */
        readonly singleHeader?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.FieldToMatchProperty.SingleQueryArgument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-singlequeryargument
         */
        readonly singleQueryArgument?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.FieldToMatchProperty.UriPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-fieldtomatch.html#cfn-wafv2-rulegroup-fieldtomatch-uripath
         */
        readonly uriPath?: any | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html
     */
    interface GeoMatchStatementProperty {
        /**
         * `CfnRuleGroup.GeoMatchStatementProperty.CountryCodes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-geomatchstatement.html#cfn-wafv2-rulegroup-geomatchstatement-countrycodes
         */
        readonly countryCodes?: string[];
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html
     */
    interface IPSetReferenceStatementProperty {
        /**
         * `CfnRuleGroup.IPSetReferenceStatementProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ipsetreferencestatement.html#cfn-wafv2-rulegroup-ipsetreferencestatement-arn
         */
        readonly arn: string;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatementone.html
     */
    interface NotStatementOneProperty {
        /**
         * `CfnRuleGroup.NotStatementOneProperty.Statement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatementone.html#cfn-wafv2-rulegroup-notstatementone-statement
         */
        readonly statement: CfnRuleGroup.StatementTwoProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatementtwo.html
     */
    interface NotStatementTwoProperty {
        /**
         * `CfnRuleGroup.NotStatementTwoProperty.Statement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-notstatementtwo.html#cfn-wafv2-rulegroup-notstatementtwo-statement
         */
        readonly statement: CfnRuleGroup.StatementThreeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatementone.html
     */
    interface OrStatementOneProperty {
        /**
         * `CfnRuleGroup.OrStatementOneProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatementone.html#cfn-wafv2-rulegroup-orstatementone-statements
         */
        readonly statements: Array<CfnRuleGroup.StatementTwoProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatementtwo.html
     */
    interface OrStatementTwoProperty {
        /**
         * `CfnRuleGroup.OrStatementTwoProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-orstatementtwo.html#cfn-wafv2-rulegroup-orstatementtwo-statements
         */
        readonly statements: Array<CfnRuleGroup.StatementThreeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementone.html
     */
    interface RateBasedStatementOneProperty {
        /**
         * `CfnRuleGroup.RateBasedStatementOneProperty.AggregateKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementone.html#cfn-wafv2-rulegroup-ratebasedstatementone-aggregatekeytype
         */
        readonly aggregateKeyType: string;
        /**
         * `CfnRuleGroup.RateBasedStatementOneProperty.Limit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementone.html#cfn-wafv2-rulegroup-ratebasedstatementone-limit
         */
        readonly limit: number;
        /**
         * `CfnRuleGroup.RateBasedStatementOneProperty.ScopeDownStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementone.html#cfn-wafv2-rulegroup-ratebasedstatementone-scopedownstatement
         */
        readonly scopeDownStatement?: CfnRuleGroup.StatementTwoProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementtwo.html
     */
    interface RateBasedStatementTwoProperty {
        /**
         * `CfnRuleGroup.RateBasedStatementTwoProperty.AggregateKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementtwo.html#cfn-wafv2-rulegroup-ratebasedstatementtwo-aggregatekeytype
         */
        readonly aggregateKeyType: string;
        /**
         * `CfnRuleGroup.RateBasedStatementTwoProperty.Limit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementtwo.html#cfn-wafv2-rulegroup-ratebasedstatementtwo-limit
         */
        readonly limit: number;
        /**
         * `CfnRuleGroup.RateBasedStatementTwoProperty.ScopeDownStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ratebasedstatementtwo.html#cfn-wafv2-rulegroup-ratebasedstatementtwo-scopedownstatement
         */
        readonly scopeDownStatement?: CfnRuleGroup.StatementThreeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html
     */
    interface RegexPatternSetReferenceStatementProperty {
        /**
         * `CfnRuleGroup.RegexPatternSetReferenceStatementProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-arn
         */
        readonly arn: string;
        /**
         * `CfnRuleGroup.RegexPatternSetReferenceStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-fieldtomatch
         */
        readonly fieldToMatch: CfnRuleGroup.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RegexPatternSetReferenceStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-regexpatternsetreferencestatement.html#cfn-wafv2-rulegroup-regexpatternsetreferencestatement-texttransformations
         */
        readonly textTransformations: Array<CfnRuleGroup.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html
     */
    interface RuleProperty {
        /**
         * `CfnRuleGroup.RuleProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-action
         */
        readonly action?: CfnRuleGroup.RuleActionProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-name
         */
        readonly name: string;
        /**
         * `CfnRuleGroup.RuleProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-priority
         */
        readonly priority: number;
        /**
         * `CfnRuleGroup.RuleProperty.Statement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-statement
         */
        readonly statement: CfnRuleGroup.StatementOneProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleProperty.VisibilityConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-rule.html#cfn-wafv2-rulegroup-rule-visibilityconfig
         */
        readonly visibilityConfig: CfnRuleGroup.VisibilityConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html
     */
    interface RuleActionProperty {
        /**
         * `CfnRuleGroup.RuleActionProperty.Allow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-allow
         */
        readonly allow?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleActionProperty.Block`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-block
         */
        readonly block?: any | cdk.IResolvable;
        /**
         * `CfnRuleGroup.RuleActionProperty.Count`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-ruleaction.html#cfn-wafv2-rulegroup-ruleaction-count
         */
        readonly count?: any | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html
     */
    interface SizeConstraintStatementProperty {
        /**
         * `CfnRuleGroup.SizeConstraintStatementProperty.ComparisonOperator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-comparisonoperator
         */
        readonly comparisonOperator: string;
        /**
         * `CfnRuleGroup.SizeConstraintStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnRuleGroup.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.SizeConstraintStatementProperty.Size`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-size
         */
        readonly size: number;
        /**
         * `CfnRuleGroup.SizeConstraintStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sizeconstraintstatement.html#cfn-wafv2-rulegroup-sizeconstraintstatement-texttransformations
         */
        readonly textTransformations: Array<CfnRuleGroup.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html
     */
    interface SqliMatchStatementProperty {
        /**
         * `CfnRuleGroup.SqliMatchStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnRuleGroup.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.SqliMatchStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-sqlimatchstatement.html#cfn-wafv2-rulegroup-sqlimatchstatement-texttransformations
         */
        readonly textTransformations: Array<CfnRuleGroup.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html
     */
    interface StatementOneProperty {
        /**
         * `CfnRuleGroup.StatementOneProperty.AndStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-andstatement
         */
        readonly andStatement?: CfnRuleGroup.AndStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.ByteMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-bytematchstatement
         */
        readonly byteMatchStatement?: CfnRuleGroup.ByteMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.GeoMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-geomatchstatement
         */
        readonly geoMatchStatement?: CfnRuleGroup.GeoMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.IPSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-ipsetreferencestatement
         */
        readonly ipSetReferenceStatement?: CfnRuleGroup.IPSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.NotStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-notstatement
         */
        readonly notStatement?: CfnRuleGroup.NotStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.OrStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-orstatement
         */
        readonly orStatement?: CfnRuleGroup.OrStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.RateBasedStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-ratebasedstatement
         */
        readonly rateBasedStatement?: CfnRuleGroup.RateBasedStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.RegexPatternSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-regexpatternsetreferencestatement
         */
        readonly regexPatternSetReferenceStatement?: CfnRuleGroup.RegexPatternSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.SizeConstraintStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-sizeconstraintstatement
         */
        readonly sizeConstraintStatement?: CfnRuleGroup.SizeConstraintStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.SqliMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-sqlimatchstatement
         */
        readonly sqliMatchStatement?: CfnRuleGroup.SqliMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementOneProperty.XssMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementone.html#cfn-wafv2-rulegroup-statementone-xssmatchstatement
         */
        readonly xssMatchStatement?: CfnRuleGroup.XssMatchStatementProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html
     */
    interface StatementThreeProperty {
        /**
         * `CfnRuleGroup.StatementThreeProperty.ByteMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-bytematchstatement
         */
        readonly byteMatchStatement?: CfnRuleGroup.ByteMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementThreeProperty.GeoMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-geomatchstatement
         */
        readonly geoMatchStatement?: CfnRuleGroup.GeoMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementThreeProperty.IPSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-ipsetreferencestatement
         */
        readonly ipSetReferenceStatement?: CfnRuleGroup.IPSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementThreeProperty.RegexPatternSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-regexpatternsetreferencestatement
         */
        readonly regexPatternSetReferenceStatement?: CfnRuleGroup.RegexPatternSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementThreeProperty.SizeConstraintStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-sizeconstraintstatement
         */
        readonly sizeConstraintStatement?: CfnRuleGroup.SizeConstraintStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementThreeProperty.SqliMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-sqlimatchstatement
         */
        readonly sqliMatchStatement?: CfnRuleGroup.SqliMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementThreeProperty.XssMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementthree.html#cfn-wafv2-rulegroup-statementthree-xssmatchstatement
         */
        readonly xssMatchStatement?: CfnRuleGroup.XssMatchStatementProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html
     */
    interface StatementTwoProperty {
        /**
         * `CfnRuleGroup.StatementTwoProperty.AndStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-andstatement
         */
        readonly andStatement?: CfnRuleGroup.AndStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.ByteMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-bytematchstatement
         */
        readonly byteMatchStatement?: CfnRuleGroup.ByteMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.GeoMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-geomatchstatement
         */
        readonly geoMatchStatement?: CfnRuleGroup.GeoMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.IPSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-ipsetreferencestatement
         */
        readonly ipSetReferenceStatement?: CfnRuleGroup.IPSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.NotStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-notstatement
         */
        readonly notStatement?: CfnRuleGroup.NotStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.OrStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-orstatement
         */
        readonly orStatement?: CfnRuleGroup.OrStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.RateBasedStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-ratebasedstatement
         */
        readonly rateBasedStatement?: CfnRuleGroup.RateBasedStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.RegexPatternSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-regexpatternsetreferencestatement
         */
        readonly regexPatternSetReferenceStatement?: CfnRuleGroup.RegexPatternSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.SizeConstraintStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-sizeconstraintstatement
         */
        readonly sizeConstraintStatement?: CfnRuleGroup.SizeConstraintStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.SqliMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-sqlimatchstatement
         */
        readonly sqliMatchStatement?: CfnRuleGroup.SqliMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.StatementTwoProperty.XssMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-statementtwo.html#cfn-wafv2-rulegroup-statementtwo-xssmatchstatement
         */
        readonly xssMatchStatement?: CfnRuleGroup.XssMatchStatementProperty | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html
     */
    interface TextTransformationProperty {
        /**
         * `CfnRuleGroup.TextTransformationProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-priority
         */
        readonly priority: number;
        /**
         * `CfnRuleGroup.TextTransformationProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-texttransformation.html#cfn-wafv2-rulegroup-texttransformation-type
         */
        readonly type: string;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html
     */
    interface VisibilityConfigProperty {
        /**
         * `CfnRuleGroup.VisibilityConfigProperty.CloudWatchMetricsEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-cloudwatchmetricsenabled
         */
        readonly cloudWatchMetricsEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnRuleGroup.VisibilityConfigProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-metricname
         */
        readonly metricName: string;
        /**
         * `CfnRuleGroup.VisibilityConfigProperty.SampledRequestsEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-visibilityconfig.html#cfn-wafv2-rulegroup-visibilityconfig-sampledrequestsenabled
         */
        readonly sampledRequestsEnabled: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnRuleGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html
     */
    interface XssMatchStatementProperty {
        /**
         * `CfnRuleGroup.XssMatchStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnRuleGroup.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnRuleGroup.XssMatchStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-rulegroup-xssmatchstatement.html#cfn-wafv2-rulegroup-xssmatchstatement-texttransformations
         */
        readonly textTransformations: Array<CfnRuleGroup.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::WAFv2::WebACL`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html
 */
export interface CfnWebACLProps {
    /**
     * `AWS::WAFv2::WebACL.DefaultAction`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-defaultaction
     */
    readonly defaultAction: CfnWebACL.DefaultActionProperty | cdk.IResolvable;
    /**
     * `AWS::WAFv2::WebACL.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-scope
     */
    readonly scope: string;
    /**
     * `AWS::WAFv2::WebACL.VisibilityConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-visibilityconfig
     */
    readonly visibilityConfig: CfnWebACL.VisibilityConfigProperty | cdk.IResolvable;
    /**
     * `AWS::WAFv2::WebACL.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-description
     */
    readonly description?: string;
    /**
     * `AWS::WAFv2::WebACL.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-name
     */
    readonly name?: string;
    /**
     * `AWS::WAFv2::WebACL.Rules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-rules
     */
    readonly rules?: Array<CfnWebACL.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::WAFv2::WebACL.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::WAFv2::WebACL`
 *
 * @cloudformationResource AWS::WAFv2::WebACL
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html
 */
export declare class CfnWebACL extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::WebACL";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Capacity
     */
    readonly attrCapacity: number;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::WAFv2::WebACL.DefaultAction`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-defaultaction
     */
    defaultAction: CfnWebACL.DefaultActionProperty | cdk.IResolvable;
    /**
     * `AWS::WAFv2::WebACL.Scope`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-scope
     */
    scope: string;
    /**
     * `AWS::WAFv2::WebACL.VisibilityConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-visibilityconfig
     */
    visibilityConfig: CfnWebACL.VisibilityConfigProperty | cdk.IResolvable;
    /**
     * `AWS::WAFv2::WebACL.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-description
     */
    description: string | undefined;
    /**
     * `AWS::WAFv2::WebACL.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-name
     */
    name: string | undefined;
    /**
     * `AWS::WAFv2::WebACL.Rules`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-rules
     */
    rules: Array<CfnWebACL.RuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::WAFv2::WebACL.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::WAFv2::WebACL`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWebACLProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatementone.html
     */
    interface AndStatementOneProperty {
        /**
         * `CfnWebACL.AndStatementOneProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatementone.html#cfn-wafv2-webacl-andstatementone-statements
         */
        readonly statements: Array<CfnWebACL.StatementTwoProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatementtwo.html
     */
    interface AndStatementTwoProperty {
        /**
         * `CfnWebACL.AndStatementTwoProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatementtwo.html#cfn-wafv2-webacl-andstatementtwo-statements
         */
        readonly statements: Array<CfnWebACL.StatementThreeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html
     */
    interface ByteMatchStatementProperty {
        /**
         * `CfnWebACL.ByteMatchStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnWebACL.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.ByteMatchStatementProperty.PositionalConstraint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-positionalconstraint
         */
        readonly positionalConstraint: string;
        /**
         * `CfnWebACL.ByteMatchStatementProperty.SearchString`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstring
         */
        readonly searchString?: string;
        /**
         * `CfnWebACL.ByteMatchStatementProperty.SearchStringBase64`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstringbase64
         */
        readonly searchStringBase64?: string;
        /**
         * `CfnWebACL.ByteMatchStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-texttransformations
         */
        readonly textTransformations: Array<CfnWebACL.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html
     */
    interface DefaultActionProperty {
        /**
         * `CfnWebACL.DefaultActionProperty.Allow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-allow
         */
        readonly allow?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.DefaultActionProperty.Block`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-block
         */
        readonly block?: any | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html
     */
    interface ExcludedRuleProperty {
        /**
         * `CfnWebACL.ExcludedRuleProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html#cfn-wafv2-webacl-excludedrule-name
         */
        readonly name: string;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html
     */
    interface FieldToMatchProperty {
        /**
         * `CfnWebACL.FieldToMatchProperty.AllQueryArguments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-allqueryarguments
         */
        readonly allQueryArguments?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.FieldToMatchProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-body
         */
        readonly body?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.FieldToMatchProperty.Method`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-method
         */
        readonly method?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.FieldToMatchProperty.QueryString`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-querystring
         */
        readonly queryString?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.FieldToMatchProperty.SingleHeader`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singleheader
         */
        readonly singleHeader?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.FieldToMatchProperty.SingleQueryArgument`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singlequeryargument
         */
        readonly singleQueryArgument?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.FieldToMatchProperty.UriPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-uripath
         */
        readonly uriPath?: any | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html
     */
    interface GeoMatchStatementProperty {
        /**
         * `CfnWebACL.GeoMatchStatementProperty.CountryCodes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-countrycodes
         */
        readonly countryCodes?: string[];
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html
     */
    interface IPSetReferenceStatementProperty {
        /**
         * `CfnWebACL.IPSetReferenceStatementProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-arn
         */
        readonly arn: string;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html
     */
    interface ManagedRuleGroupStatementProperty {
        /**
         * `CfnWebACL.ManagedRuleGroupStatementProperty.ExcludedRules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-excludedrules
         */
        readonly excludedRules?: Array<CfnWebACL.ExcludedRuleProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnWebACL.ManagedRuleGroupStatementProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-name
         */
        readonly name: string;
        /**
         * `CfnWebACL.ManagedRuleGroupStatementProperty.VendorName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-vendorname
         */
        readonly vendorName: string;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatementone.html
     */
    interface NotStatementOneProperty {
        /**
         * `CfnWebACL.NotStatementOneProperty.Statement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatementone.html#cfn-wafv2-webacl-notstatementone-statement
         */
        readonly statement: CfnWebACL.StatementTwoProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatementtwo.html
     */
    interface NotStatementTwoProperty {
        /**
         * `CfnWebACL.NotStatementTwoProperty.Statement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatementtwo.html#cfn-wafv2-webacl-notstatementtwo-statement
         */
        readonly statement: CfnWebACL.StatementThreeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatementone.html
     */
    interface OrStatementOneProperty {
        /**
         * `CfnWebACL.OrStatementOneProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatementone.html#cfn-wafv2-webacl-orstatementone-statements
         */
        readonly statements: Array<CfnWebACL.StatementTwoProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatementtwo.html
     */
    interface OrStatementTwoProperty {
        /**
         * `CfnWebACL.OrStatementTwoProperty.Statements`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatementtwo.html#cfn-wafv2-webacl-orstatementtwo-statements
         */
        readonly statements: Array<CfnWebACL.StatementThreeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html
     */
    interface OverrideActionProperty {
        /**
         * `CfnWebACL.OverrideActionProperty.Count`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-count
         */
        readonly count?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.OverrideActionProperty.None`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-none
         */
        readonly none?: any | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementone.html
     */
    interface RateBasedStatementOneProperty {
        /**
         * `CfnWebACL.RateBasedStatementOneProperty.AggregateKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementone.html#cfn-wafv2-webacl-ratebasedstatementone-aggregatekeytype
         */
        readonly aggregateKeyType: string;
        /**
         * `CfnWebACL.RateBasedStatementOneProperty.Limit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementone.html#cfn-wafv2-webacl-ratebasedstatementone-limit
         */
        readonly limit: number;
        /**
         * `CfnWebACL.RateBasedStatementOneProperty.ScopeDownStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementone.html#cfn-wafv2-webacl-ratebasedstatementone-scopedownstatement
         */
        readonly scopeDownStatement?: CfnWebACL.StatementTwoProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementtwo.html
     */
    interface RateBasedStatementTwoProperty {
        /**
         * `CfnWebACL.RateBasedStatementTwoProperty.AggregateKeyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementtwo.html#cfn-wafv2-webacl-ratebasedstatementtwo-aggregatekeytype
         */
        readonly aggregateKeyType: string;
        /**
         * `CfnWebACL.RateBasedStatementTwoProperty.Limit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementtwo.html#cfn-wafv2-webacl-ratebasedstatementtwo-limit
         */
        readonly limit: number;
        /**
         * `CfnWebACL.RateBasedStatementTwoProperty.ScopeDownStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementtwo.html#cfn-wafv2-webacl-ratebasedstatementtwo-scopedownstatement
         */
        readonly scopeDownStatement?: CfnWebACL.StatementThreeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html
     */
    interface RegexPatternSetReferenceStatementProperty {
        /**
         * `CfnWebACL.RegexPatternSetReferenceStatementProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-arn
         */
        readonly arn: string;
        /**
         * `CfnWebACL.RegexPatternSetReferenceStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-fieldtomatch
         */
        readonly fieldToMatch: CfnWebACL.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.RegexPatternSetReferenceStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-texttransformations
         */
        readonly textTransformations: Array<CfnWebACL.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html
     */
    interface RuleProperty {
        /**
         * `CfnWebACL.RuleProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-action
         */
        readonly action?: CfnWebACL.RuleActionProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.RuleProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-name
         */
        readonly name: string;
        /**
         * `CfnWebACL.RuleProperty.OverrideAction`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-overrideaction
         */
        readonly overrideAction?: CfnWebACL.OverrideActionProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.RuleProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-priority
         */
        readonly priority: number;
        /**
         * `CfnWebACL.RuleProperty.Statement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-statement
         */
        readonly statement: CfnWebACL.StatementOneProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.RuleProperty.VisibilityConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rule.html#cfn-wafv2-webacl-rule-visibilityconfig
         */
        readonly visibilityConfig: CfnWebACL.VisibilityConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html
     */
    interface RuleActionProperty {
        /**
         * `CfnWebACL.RuleActionProperty.Allow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-allow
         */
        readonly allow?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.RuleActionProperty.Block`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-block
         */
        readonly block?: any | cdk.IResolvable;
        /**
         * `CfnWebACL.RuleActionProperty.Count`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ruleaction.html#cfn-wafv2-webacl-ruleaction-count
         */
        readonly count?: any | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html
     */
    interface RuleGroupReferenceStatementProperty {
        /**
         * `CfnWebACL.RuleGroupReferenceStatementProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html#cfn-wafv2-webacl-rulegroupreferencestatement-arn
         */
        readonly arn: string;
        /**
         * `CfnWebACL.RuleGroupReferenceStatementProperty.ExcludedRules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-rulegroupreferencestatement.html#cfn-wafv2-webacl-rulegroupreferencestatement-excludedrules
         */
        readonly excludedRules?: Array<CfnWebACL.ExcludedRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html
     */
    interface SizeConstraintStatementProperty {
        /**
         * `CfnWebACL.SizeConstraintStatementProperty.ComparisonOperator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-comparisonoperator
         */
        readonly comparisonOperator: string;
        /**
         * `CfnWebACL.SizeConstraintStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnWebACL.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.SizeConstraintStatementProperty.Size`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-size
         */
        readonly size: number;
        /**
         * `CfnWebACL.SizeConstraintStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sizeconstraintstatement.html#cfn-wafv2-webacl-sizeconstraintstatement-texttransformations
         */
        readonly textTransformations: Array<CfnWebACL.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sqlimatchstatement.html
     */
    interface SqliMatchStatementProperty {
        /**
         * `CfnWebACL.SqliMatchStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sqlimatchstatement.html#cfn-wafv2-webacl-sqlimatchstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnWebACL.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.SqliMatchStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-sqlimatchstatement.html#cfn-wafv2-webacl-sqlimatchstatement-texttransformations
         */
        readonly textTransformations: Array<CfnWebACL.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html
     */
    interface StatementOneProperty {
        /**
         * `CfnWebACL.StatementOneProperty.AndStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-andstatement
         */
        readonly andStatement?: CfnWebACL.AndStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.ByteMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-bytematchstatement
         */
        readonly byteMatchStatement?: CfnWebACL.ByteMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.GeoMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-geomatchstatement
         */
        readonly geoMatchStatement?: CfnWebACL.GeoMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.IPSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-ipsetreferencestatement
         */
        readonly ipSetReferenceStatement?: CfnWebACL.IPSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.ManagedRuleGroupStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-managedrulegroupstatement
         */
        readonly managedRuleGroupStatement?: CfnWebACL.ManagedRuleGroupStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.NotStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-notstatement
         */
        readonly notStatement?: CfnWebACL.NotStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.OrStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-orstatement
         */
        readonly orStatement?: CfnWebACL.OrStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.RateBasedStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-ratebasedstatement
         */
        readonly rateBasedStatement?: CfnWebACL.RateBasedStatementOneProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.RegexPatternSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-regexpatternsetreferencestatement
         */
        readonly regexPatternSetReferenceStatement?: CfnWebACL.RegexPatternSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.RuleGroupReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-rulegroupreferencestatement
         */
        readonly ruleGroupReferenceStatement?: CfnWebACL.RuleGroupReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.SizeConstraintStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-sizeconstraintstatement
         */
        readonly sizeConstraintStatement?: CfnWebACL.SizeConstraintStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.SqliMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-sqlimatchstatement
         */
        readonly sqliMatchStatement?: CfnWebACL.SqliMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementOneProperty.XssMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementone.html#cfn-wafv2-webacl-statementone-xssmatchstatement
         */
        readonly xssMatchStatement?: CfnWebACL.XssMatchStatementProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html
     */
    interface StatementThreeProperty {
        /**
         * `CfnWebACL.StatementThreeProperty.ByteMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-bytematchstatement
         */
        readonly byteMatchStatement?: CfnWebACL.ByteMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.GeoMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-geomatchstatement
         */
        readonly geoMatchStatement?: CfnWebACL.GeoMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.IPSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-ipsetreferencestatement
         */
        readonly ipSetReferenceStatement?: CfnWebACL.IPSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.ManagedRuleGroupStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-managedrulegroupstatement
         */
        readonly managedRuleGroupStatement?: CfnWebACL.ManagedRuleGroupStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.RegexPatternSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-regexpatternsetreferencestatement
         */
        readonly regexPatternSetReferenceStatement?: CfnWebACL.RegexPatternSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.RuleGroupReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-rulegroupreferencestatement
         */
        readonly ruleGroupReferenceStatement?: CfnWebACL.RuleGroupReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.SizeConstraintStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-sizeconstraintstatement
         */
        readonly sizeConstraintStatement?: CfnWebACL.SizeConstraintStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.SqliMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-sqlimatchstatement
         */
        readonly sqliMatchStatement?: CfnWebACL.SqliMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementThreeProperty.XssMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementthree.html#cfn-wafv2-webacl-statementthree-xssmatchstatement
         */
        readonly xssMatchStatement?: CfnWebACL.XssMatchStatementProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html
     */
    interface StatementTwoProperty {
        /**
         * `CfnWebACL.StatementTwoProperty.AndStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-andstatement
         */
        readonly andStatement?: CfnWebACL.AndStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.ByteMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-bytematchstatement
         */
        readonly byteMatchStatement?: CfnWebACL.ByteMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.GeoMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-geomatchstatement
         */
        readonly geoMatchStatement?: CfnWebACL.GeoMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.IPSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-ipsetreferencestatement
         */
        readonly ipSetReferenceStatement?: CfnWebACL.IPSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.ManagedRuleGroupStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-managedrulegroupstatement
         */
        readonly managedRuleGroupStatement?: CfnWebACL.ManagedRuleGroupStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.NotStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-notstatement
         */
        readonly notStatement?: CfnWebACL.NotStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.OrStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-orstatement
         */
        readonly orStatement?: CfnWebACL.OrStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.RateBasedStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-ratebasedstatement
         */
        readonly rateBasedStatement?: CfnWebACL.RateBasedStatementTwoProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.RegexPatternSetReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-regexpatternsetreferencestatement
         */
        readonly regexPatternSetReferenceStatement?: CfnWebACL.RegexPatternSetReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.RuleGroupReferenceStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-rulegroupreferencestatement
         */
        readonly ruleGroupReferenceStatement?: CfnWebACL.RuleGroupReferenceStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.SizeConstraintStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-sizeconstraintstatement
         */
        readonly sizeConstraintStatement?: CfnWebACL.SizeConstraintStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.SqliMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-sqlimatchstatement
         */
        readonly sqliMatchStatement?: CfnWebACL.SqliMatchStatementProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.StatementTwoProperty.XssMatchStatement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-statementtwo.html#cfn-wafv2-webacl-statementtwo-xssmatchstatement
         */
        readonly xssMatchStatement?: CfnWebACL.XssMatchStatementProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-texttransformation.html
     */
    interface TextTransformationProperty {
        /**
         * `CfnWebACL.TextTransformationProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-texttransformation.html#cfn-wafv2-webacl-texttransformation-priority
         */
        readonly priority: number;
        /**
         * `CfnWebACL.TextTransformationProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-texttransformation.html#cfn-wafv2-webacl-texttransformation-type
         */
        readonly type: string;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-visibilityconfig.html
     */
    interface VisibilityConfigProperty {
        /**
         * `CfnWebACL.VisibilityConfigProperty.CloudWatchMetricsEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-visibilityconfig.html#cfn-wafv2-webacl-visibilityconfig-cloudwatchmetricsenabled
         */
        readonly cloudWatchMetricsEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnWebACL.VisibilityConfigProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-visibilityconfig.html#cfn-wafv2-webacl-visibilityconfig-metricname
         */
        readonly metricName: string;
        /**
         * `CfnWebACL.VisibilityConfigProperty.SampledRequestsEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-visibilityconfig.html#cfn-wafv2-webacl-visibilityconfig-sampledrequestsenabled
         */
        readonly sampledRequestsEnabled: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnWebACL {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-xssmatchstatement.html
     */
    interface XssMatchStatementProperty {
        /**
         * `CfnWebACL.XssMatchStatementProperty.FieldToMatch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-xssmatchstatement.html#cfn-wafv2-webacl-xssmatchstatement-fieldtomatch
         */
        readonly fieldToMatch: CfnWebACL.FieldToMatchProperty | cdk.IResolvable;
        /**
         * `CfnWebACL.XssMatchStatementProperty.TextTransformations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-xssmatchstatement.html#cfn-wafv2-webacl-xssmatchstatement-texttransformations
         */
        readonly textTransformations: Array<CfnWebACL.TextTransformationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::WAFv2::WebACLAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html
 */
export interface CfnWebACLAssociationProps {
    /**
     * `AWS::WAFv2::WebACLAssociation.ResourceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html#cfn-wafv2-webaclassociation-resourcearn
     */
    readonly resourceArn: string;
    /**
     * `AWS::WAFv2::WebACLAssociation.WebACLArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html#cfn-wafv2-webaclassociation-webaclarn
     */
    readonly webAclArn: string;
}
/**
 * A CloudFormation `AWS::WAFv2::WebACLAssociation`
 *
 * @cloudformationResource AWS::WAFv2::WebACLAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html
 */
export declare class CfnWebACLAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WAFv2::WebACLAssociation";
    /**
     * `AWS::WAFv2::WebACLAssociation.ResourceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html#cfn-wafv2-webaclassociation-resourcearn
     */
    resourceArn: string;
    /**
     * `AWS::WAFv2::WebACLAssociation.WebACLArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webaclassociation.html#cfn-wafv2-webaclassociation-webaclarn
     */
    webAclArn: string;
    /**
     * Create a new `AWS::WAFv2::WebACLAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWebACLAssociationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
