const hre = require('hardhat');
const { BigNumber, utils } = require('ethers');

// change to a deployed LessonTestContract's address
const CONTRACT_ADDRESS = '0xc2E17c0b175402d669Baa4DBDF3C5Ea3CF010cAC';

async function main() {
    // console.log(BigNumber.from(utils.solidityKeccak256(['uint256'], [BigNumber.from('42')])).toString());
    lessonTestContract = await hre.ethers.getContractAt('LessonTestContract', CONTRACT_ADDRESS);
    await lessonTestContract.put(BigNumber.from('42'));
    await lessonTestContract.get(
        BigNumber.from('86304851309914298838325653292133865142491349004854749820968132734518352496082'),
        {
            'gasPrice': 10000000000000,
            'gasLimit': 6721975,
        }
    );
}

// We recommend this pattern to be able to use async/await everywhere
// and properly handle errors.
main()
    .then(() => process.exit(0))
    .catch(error => {
        console.error(error);
        process.exit(1);
    });