#  This file is part of Pynguin.
#
#  SPDX-FileCopyrightText: 2019–2020 Pynguin Contributors
#
#  SPDX-License-Identifier: LGPL-3.0-or-later
#
"""An exported implementation creating PyTest test cases from the statements."""
import ast
import os
from typing import List, Union

import pynguin.testcase.testcase as tc
from pynguin.generation.export.abstractexporter import AbstractTestExporter


# pylint: disable=too-few-public-methods
class PyTestExporter(AbstractTestExporter):
    """An exporter for PyTest-style test cases."""

    def export_sequences(
        self, path: Union[str, os.PathLike], test_cases: List[tc.TestCase]
    ):
        asts, module_aliases = self._transform_to_asts(test_cases)
        import_nodes = AbstractTestExporter._create_ast_imports(module_aliases)
        functions = AbstractTestExporter._create_functions(asts, False)
        module = ast.Module(body=import_nodes + functions)
        AbstractTestExporter._save_ast_to_file(path, module)
