# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (12,12,0,4,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        45 93
        152 65
        64 154
        115 72
        50 29
        41 153
        58 76
        130 47
        115 70
        18 148
        145 40
        77 105
        62 133
        78 52
        29 135
        137 150
        30 151
        5 154
        75 48
        7 39
        134 97
        95 139
        128 125
        13 108
        121 35
        74 1
        114 61
        124 91
        69 45
        35 2
        44 66
        82 33
        55 144
        132 30
        54 3
        1 54
        27 134
        117 148
        109 68
        36 63
        27 151
        44 28
        121 52
        76 151
        70 3
        106 0
        74 102
        92 36
        91 25
        131 86
        89 51
        84 28
        14 137
        146 79
        0 53
        74 6
        11 80
        82 117
        95 159
        4 34
        88 21
        17 104
        92 21
        90 1
        24 15
        48 52
        142 99
        155 102
        121 56
        87 5
        31 21
        115 28
        108 39
        101 137
        146 49
        135 15
        90 58
        8 139
        155 96
        13 81
        148 153
        116 107
        101 130
        44 86
        62 57
        57 71
        23 117
        17 66
        24 120
        84 65
        140 37
        103 78
        68 41
        131 142
        22 39
        75 56
        2 112
        152 78
        140 12
        50 47
        87 94
        83 14
        16 10
        53 78
        159 141
        97 142
        62 54
        28 46
        47 158
        73 11
        97 1
        144 72
        0 94
        104 71
        83 153
        116 6
        87 138
        138 93
        150 25
        155 66
        24 131
        26 124
        3 157
        31 57
        113 48
        62 6
        8 69
        14 38
        98 43
        81 64
        18 88
        100 7
        9 101
        115 143
        10 31
        42 118
        80 57
        129 63
        89 141
        69 4
        44 110
        26 136
        18 22
        144 135
        7 46
        102 60
        7 76
        16 126
        119 105
        82 124
        151 140
        111 146
        157 81
        128 45
        22 40
        59 79
        88 83
        60 148
        75 43
        111 122
        42 141
        34 81
        132 37
        26 95
        121 135
        116 33
        53 35
        106 5
        143 86
        109 126
        20 59
        137 147
        88 16
        61 56
        110 104
        129 158
        112 105
        76 104
        113 15
        128 120
        21 38
        79 61
        14 63
        9 111
        141 136
        55 70
        19 118
        29 138
        75 4
        32 38
        19 112
        98 79
        40 54
        33 123
        90 68
        142 3
        72 65
        73 63
        60 133
        19 32
        56 49
        23 116
        9 123
        149 34
        154 114
        26 150
        91 92
        107 67
        106 69
        55 131
        16 39
        94 122
        155 11
        146 156
        145 157
        25 38
        77 150
        36 80
        32 96
        94 50
        117 136
        140 110
        107 156
        159 43
        20 45
        143 157
        138 37
        60 40
        58 134
        100 84
        6 11
        70 71
        119 118
        51 49
        85 86
        42 156
        144 37
        55 110
        100 30
        128 34
        24 149
        123 147
        95 111
        127 92
        51 2
        147 153
        149 143
        114 120
        106 152
        113 103
        136 147
        119 103
        158 2
        83 109
        107 51
        139 77
        93 152
        27 99
        30 64
        67 118
        113 98
        99 120
        25 112
        130 77
        149 48
        33 41
        53 105
        23 133
        8 43
        101 129
        156 123
        129 91
        82 127
        50 35
        97 85
        10 66
        27 125
        67 158
        125 12
        58 126
        119 47
        68 127
        145 85
        85 102
        108 134
        98 42
        22 90
        19 89
        87 20
        93 12
        13 100
        109 36
        73 67
        64 99
        8 59
        4 154
        9 124
        13 125
        122 59
        10 46
        5 132
        17 80
        72 52
        20 114
        18 127
        32 73
        122 130
        17 126
        31 96
        132 65
        89 23
        108 145
        84 12
        159 49
        74 41
        29 103
        46 71
        0 139
        96 133
        15 61
        """

        self.waters="""
        0.375 0.4485 0.39998
        0.6875 0.9648 0.75819
        0.5 0.57879 0.1196
        0.5 0.07879 0.8804
        0.3125 0.3235 0.69725
        0.5 0.3235 0.46632
        0.6875 0.8398 0.94185
        0.375 0.0515 0.39998
        0.125 0.4485 0.60002
        0.6875 0.63029 0.56685
        0.1875 0.9648 0.24182
        0.8125 0.8398 0.05815
        0.0 0.20379 0.3696
        0.1875 0.13029 0.56685
        0.0 0.75 0.3663
        0.8125 0.3398 0.94185
        0.125 0.9485 0.39998
        0.8125 0.9648 0.24182
        0.3125 0.86971 0.56685
        0.1875 0.66021 0.05815
        0.8125 0.36971 0.56685
        0.3125 0.8235 0.30275
        0.375 0.9485 0.60002
        0.375 0.75 0.8837
        0.875 0.25 0.8837
        0.3125 0.6765 0.30275
        0.3125 0.63029 0.56685
        0.8125 0.13029 0.56685
        0.1875 0.114 0.17775
        0.8125 0.386 0.17775
        0.5 0.1765 0.46632
        0.3125 0.886 0.17775
        0.125 0.75 0.1163
        0.6875 0.75 0.73093
        0.1875 0.25 0.73093
        0.5 0.48109 0.14998
        0.6875 0.8235 0.30275
        0.6875 0.25 0.26907
        0.1875 0.75 0.26907
        0.25 0.0 0.5
        0.3125 0.9648 0.75819
        0.8125 0.8235 0.69725
        0.0 0.57879 0.8804
        0.1875 0.4648 0.75819
        0.0 0.07879 0.1196
        0.0 0.3235 0.53368
        0.3125 0.03521 0.24182
        0.8125 0.53521 0.24182
        0.1875 0.3398 0.94185
        0.5 0.51891 0.85002
        0.6875 0.4648 0.24182
        0.5 0.59771 0.96962
        0.3125 0.3398 0.05815
        0.3125 0.4648 0.24182
        0.5 0.98109 0.85002
        0.6875 0.16021 0.05815
        0.5 0.42121 0.8804
        0.5 0.92121 0.1196
        0.75 0.0 0.5
        0.875 0.4485 0.60002
        0.1875 0.886 0.82225
        0.6875 0.386 0.82225
        0.5 0.9023 0.96962
        0.8125 0.75 0.26907
        0.5 0.20379 0.6304
        0.3125 0.25 0.26907
        0.0 0.98109 0.14998
        0.8125 0.66021 0.05815
        0.6875 0.86971 0.56685
        0.1875 0.36971 0.56685
        0.5 0.09771 0.03038
        0.5 0.01891 0.14998
        0.375 0.25 0.1163
        0.875 0.75 0.1163
        0.8125 0.886 0.82225
        0.3125 0.386 0.82225
        0.625 0.0515 0.39998
        0.125 0.5515 0.39998
        0.1875 0.386 0.17775
        0.8125 0.4648 0.75819
        0.6875 0.886 0.17775
        0.3125 0.1765 0.69725
        0.5 0.75 0.6337
        0.0 0.8235 0.46632
        0.1875 0.1765 0.30275
        0.0 0.01891 0.85002
        0.0 0.09771 0.96962
        0.6875 0.36971 0.43315
        0.1875 0.86971 0.43315
        0.3125 0.66021 0.94185
        0.625 0.9485 0.60002
        0.5 0.70379 0.3696
        0.5 0.79621 0.3696
        0.0 0.29621 0.3696
        0.625 0.4485 0.39998
        0.375 0.5515 0.60002
        0.1875 0.8398 0.05815
        0.8125 0.03521 0.75819
        0.0 0.48109 0.85002
        0.6875 0.1765 0.69725
        0.3125 0.13029 0.43315
        0.8125 0.63029 0.43315
        0.0 0.92121 0.8804
        0.0 0.42121 0.1196
        0.6875 0.03521 0.24182
        0.1875 0.53521 0.24182
        0.3125 0.36971 0.43315
        0.6875 0.66021 0.94185
        0.125 0.0515 0.60002
        0.8125 0.86971 0.43315
        0.8125 0.114 0.17775
        0.625 0.5515 0.60002
        0.3125 0.614 0.17775
        0.0 0.4023 0.96962
        0.6875 0.3235 0.69725
        0.3125 0.16021 0.05815
        0.625 0.75 0.8837
        0.3125 0.75 0.73093
        0.0 0.59771 0.03038
        0.0 0.51891 0.14998
        0.8125 0.25 0.73093
        0.5 0.4023 0.03038
        0.75 0.5 0.5
        0.8125 0.6765 0.69725
        0.5 0.6765 0.53368
        0.0 0.1765 0.53368
        0.875 0.9485 0.39998
        0.5 0.8235 0.53368
        0.0 0.25 0.6337
        0.6875 0.6765 0.30275
        0.875 0.5515 0.39998
        0.8125 0.16021 0.94185
        0.5 0.25 0.3663
        0.3125 0.8398 0.94185
        0.875 0.0515 0.60002
        0.6875 0.3398 0.05815
        0.1875 0.6765 0.69725
        0.0 0.6765 0.46632
        0.8125 0.3235 0.30275
        0.25 0.5 0.5
        0.8125 0.1765 0.30275
        0.1875 0.614 0.82225
        0.6875 0.114 0.82225
        0.1875 0.16021 0.94185
        0.625 0.25 0.1163
        0.1875 0.03521 0.75819
        0.6875 0.53521 0.75819
        0.0 0.70379 0.6304
        0.1875 0.8235 0.69725
        0.125 0.25 0.8837
        0.1875 0.63029 0.43315
        0.6875 0.13029 0.43315
        0.1875 0.3235 0.30275
        0.0 0.79621 0.6304
        0.5 0.29621 0.6304
        0.0 0.9023 0.03038
        0.8125 0.614 0.82225
        0.3125 0.114 0.82225
        0.6875 0.614 0.17775
        0.3125 0.53521 0.75819
        """

        self.coord= "relative"

        self.cages="""
        12 -0.5 0.35918 0.2326
        12 0.25 0.75 -0.5
        12 0.5 0.14082 0.2326
        16 0.0 0.75 -0.11108
        14 0.0 -0.06517 -0.36733
        14 0.0 0.43483 0.36733
        14 0.0 0.56517 -0.36733
        16 0.0 0.25 0.11108
        14 -0.25 0.5 0.0
        14 -0.25 0.0 0.0
        12 0.0 0.85918 0.2326
        12 -0.25 0.25 0.5
        12 1.0 0.64082 0.2326
        12 0.0 0.35918 -0.2326
        16 0.5 1.25 -0.11108
        14 0.25 0.0 0.0
        14 0.5 0.56517 0.36733
        14 0.5 1.06517 -0.36733
        12 0.0 1.14082 -0.2326
        14 0.5 0.93483 0.36733
        12 0.25 0.25 0.5
        12 -0.25 0.75 -0.5
        14 0.5 0.43483 -0.36733
        14 0.0 0.06517 0.36733
        14 0.25 -0.5 0.0
        12 -0.5 0.64082 -0.2326
        12 -0.5 -0.14082 -0.2326
        16 0.5 0.75 0.11108
        """

        self.bondlen = 3


        self.cell = """
        13.817910069259103 32.229872932267654 19.6134386277113
        """

        self.density = 0.5475162843656168



        self.cell = cellvectors(a=13.817910069259103,
                           b=32.229872932267654,
                           c=19.6134386277113)
