<p align="center">
  <img src="https://github.com/UlionTse/translators/blob/master/docs/translators_logo.png" width="500"/>
</p>
<p align="center">
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Version" src="https://img.shields.io/pypi/v/translators.svg"></a>
  <a href="https://anaconda.org/conda-forge/translators"><img alt="Conda - Version" src="https://img.shields.io/conda/vn/conda-forge/translators.svg"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - License" src="https://img.shields.io/pypi/l/translators.svg"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Python" src="https://img.shields.io/pypi/pyversions/translators.svg"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Status" src="https://img.shields.io/pypi/status/translators.svg"></a>
  <a href="https://pypi.org/project/translators"><img alt="PyPI - Wheel" src="https://img.shields.io/badge/wheel-yes-brightgreen.svg"></a>
  <a href="https://pypi.org/project/translators"><img alt="Downloads" src="https://pepy.tech/badge/translators"></a>
</p>

* * *

**Translators** is a library which aims to bring **free, multiple, enjoyable** translation to individuals and students in Python. (Currently, [**26**](#more-about-translators) translation services are supported.)

- [Installation](#installation)
  - [From PyPI](#from-pypi)
  - [From Conda](#from-conda)
  - [From Source](#from-source)
- [Getting Started](#getting-started)
  - [Import Library](#import-library)
  - [Usage](#usage)
    - [preaccelerate](#preaccelerate)
    - [translate_text](#translate_text)
    - [translate_html](#translate_html)
  - [Common Parameters and Functions](#common-parameters-and-functions)
    - [Query Text](#query-text)
    - [Language](#language)
    - [Detail Result](#detail-result)
    - [Professional Field](#professional-field)
    - [Host Config](#host-config)
    - [Request Config](#request-config)
    - [Session Update](#session-update)
    - [Time Stat](#time-stat)
    - [Old Server](#old-server)
  - [Property](#property)
- [More About Translators](#more-about-translators)
  - [Features](#features)
  - [Supported Language](#supported-language)
  - [About Chinese Language](#about-Chinese-language)
- [Debug Tips](#debug-tips)
  - [Linux Runtime Environment](#linux-runtime-environment)
  - [Supported Country or Region Service](#supported-country-or-region-service)
  - [HttpError 4xx](#httperror-4xx)
  - [NetworkError or ProxyError](#network-error-or-proxy-error)
- [License](#license)

## Installation

### From PyPI

```sh
pip install --upgrade translators
```

### From Conda

```sh
conda install -c conda-forge translators
```

### From Source

```sh
git clone https://github.com/UlionTse/translators.git
cd translators
python setup.py install
```

## Getting Started

```python
import translators as ts
import translators.server as tss

wyw_text = '季姬寂，集鸡，鸡即棘鸡。棘鸡饥叽，季姬及箕稷济鸡。'
chs_text = '季姬感到寂寞，罗集了一些鸡来养，鸡是出自荆棘丛中的野鸡。野鸡饿了唧唧叫，季姬就拿竹箕中的谷物喂鸡。'
chs_html = '''
<!DOCTYPE html>
<html>
<head>
    <title>《季姬击鸡记》</title>
</head>
<body>
<p>还有另一篇文章《施氏食狮史》。其它有《羿裔熠》、《侄治痔》等。</p>
</body>
</html>
'''
### usage
ts.preaccelerate()  #Caching sessions in advance, which can help improve access speed.

print(ts.translators_pool)
print(ts.translate_text(chs_text))
print(ts.translate_html(chs_html, translator='iciba'))

### common parameters and functions
## query text
print(ts.translate_text(chs_text, if_ignore_empty_query=False, if_ignore_limit_of_length=False, limit_of_length=5000))

## language
# input language
from_language, to_language = ('zh', 'en')
print(tss.google(wyw_text, from_language, to_language))
# check input language with language_map
assert from_language in tss._google.language_map  # request once first, then ...

## detail result
print(tss.sogou(wyw_text, is_detail_result=True))

## professional field
print(tss.alibaba(wyw_text, professional_field='general'))  # ("general","message","offer")
print(tss.baidu(wyw_text, professional_field='common'))  # ('common','medicine','electronics','mechanics')
print(tss.caiyun(wyw_text, professional_field=None))  # (None,"medicine","law","machinery")

## host config
# cn
print(tss.google(wyw_text, if_use_cn_host=False))
print(tss.bing(wyw_text, if_use_cn_host=True))
# reset host
print(tss.google(wyw_text, reset_host_url=None))
print(tss.yandex(wyw_text, reset_host_url=None))
# host pool
print(tss._argos.host_pool)
print(tss.argos(wyw_text, reset_host_url=None))

## request config
print(tss.lingvanex(wyw_text, sleep_seconds=5, timeout=None, proxies=None))

## session update
print(tss.itranslate(wyw_text, update_session_after_freq=1000, update_session_after_seconds=1.5e3))

## time stat
print(tss.reverso(wyw_text, if_show_time_stat=True, show_time_stat_precision=4, sleep_seconds=0.1))

## old server
baidu_v1 = tss.BaiduV1().baidu_api
baidu_v2 = tss.BaiduV2().baidu_api
assert baidu_v1(wyw_text) == baidu_v2(wyw_text)

### property
print(dir(tss._deepl))
help(tss.papago)
```

## More About Translators

### Features

| ID  | Translator                                                    | Number of Supported Languages | Advantage                                                                                   | Service                                                                                                | Status                                          |
| --- | ------------------------------------------------------------- | ----------------------------- | ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------ | ----------------------------------------------- |
| 1   | [Niutrans](https://niutrans.com/trans)                        | 302                           | support the most languages in the world                                                     | [Northeastern University](http://english.neu.edu.cn/) / [Niutrans](https://github.com/NiuTrans), China | /                                               |
| 2   | [Alibaba](https://translate.alibaba.com)                      | 221                           | support most languages, support professional field                                          | [Alibaba](https://damo.alibaba.com/about?lang=en), China                                               | stable                                          |
| 3   | [Baidu](https://fanyi.baidu.com)                              | 201                           | support most languages, support professional field, support Classical Chinese               | [Baidu](https://ir.baidu.com/company-overview), China                                                  | stable                                          |
| 4   | [Iciba](https://www.iciba.com/fy)                             | 187                           | support the most languages in the world                                                     | [Kingsoft](https://www.wps.com/about-us/) / [Xiaomi](https://www.mi.com/us/about/), China              | stable                                          |
| 5   | [MyMemory](https://mymemory.translated.net)                   | 151                           | support the most languages in the world, good at Creole English, Creole French              | [Translated](https://translatedlabs.com/welcome), Italy                                                | stable                                          |
| 6   | [Iflytek](https://fanyi.xfyun.cn/console/trans/text)          | 140                           | support the most languages in the world                                                     | [Iflytek](https://www.iflytek.com/en/about-us.html), China                                             | /                                               |
| 7   | [Google](https://translate.google.com)                        | 134                           | support more languages in the world                                                         | [Google](https://about.google/), America                                                               | stable(offline in inland of China on Oct. 2022) |
| 8   | [VolcEngine](https://translate.volcengine.com)                | 122                           | support more languages in the world, support professional field                             | [VolcEngine](https://www.volcengine.com/about) / [ByteDance](https://www.bytedance.com/en/), China     | /                                               |
| 9   | [Lingvanex](https://lingvanex.com/demo)                       | 112                           | support translation of different regions but the same language                              | [Lingvanex](https://lingvanex.com/about-us/), Cyprus                                                   | stable                                          |
| 10  | [Bing](https://www.bing.com/Translator)                       | 110                           | support more languages in the world                                                         | [Microsoft](https://www.microsoft.com/en-us/about), America                                            | stable                                          |
| 11  | [Yandex](https://translate.yandex.com)                        | 102                           | support more languages in the world, support word to emoji                                  | [Yandex](https://yandex.com/company/), Russia                                                          | /                                               |
| 12  | [Itranslate](https://itranslate.com/webapp)                   | 101                           | support translation of different regions but the same language, such as en-US, en-UK, en-AU | [Itranslate](https://itranslate.com/about), Austria                                                    | stable                                          |
| 13  | [Sogou](https://fanyi.sogou.com)                              | 61                            | support more languages in the world                                                         | [Sogou / tencent](https://www.tencent.com/en-us/about.html), China                                     | stable                                          |
| 14  | [ModernMt](https://www.modernmt.com/translate)                | 56                            | open-source, support more languages in the world                                            | [Modernmt](https://github.com/modernmt) / [Translated](https://translatedlabs.com/welcome), Italy      | stable                                          |
| 15  | [Reverso](https://www.reverso.net/text-translation)           | 42                            | popular on Mac and Iphone                                                                   | [Reverso](https://www.corporate-translation.reverso.com/about-us), France                              | stable                                          |
| 16  | [Deepl](https://www.deepl.com/translator)                     | 27                            | high quality to translate but response slowly                                               | [Deepl](https://jobs.deepl.com/l/en), Germany                                                          | stable                                          |
| 17  | [QQTranSmart](https://transmart.qq.com)                       | 22                            | support main languages                                                                      | [Tencent](https://www.tencent.com/en-us/about.html), China                                             | stable                                          |
| 18  | [QQFanyi](https://fanyi.qq.com)                               | 17                            | support main languages                                                                      | [Tencent](https://www.tencent.com/en-us/about.html), China                                             | stable                                          |
| 19  | [Argos](https://translate.argosopentech.com)                  | 17                            | open-source                                                                                 | [Argos](https://github.com/argosopentech) / [Libre](https://github.com/LibreTranslate), America        | stable                                          |
| 20  | [Youdao](https://ai.youdao.com/product-fanyi-text.s)          | 15                            | support main languages, high quality                                                        | [Netease](https://ir.netease.com/company-overview/corporate-profile), China                            | stable                                          |
| 21  | [Papago](https://papago.naver.com)                            | 15                            | good at Korean translation                                                                  | [Naver](https://www.navercorp.com/en/naver/company), South Korea                                       | stable                                          |
| 22  | [Iflyrec](https://fanyi.iflyrec.com)                          | 12                            | good at Chinese translation                                                                 | [Iflytek](https://www.iflytek.com/en/about-us.html), China                                             | stable                                          |
| 23  | [Caiyun](https://fanyi.caiyunapp.com)                         | 7                             | high quality to translate but response slowly, support professional field                   | [ColorfulClouds](http://caiyunapp.com/jobs/), China                                                    | stable                                          |
| 24  | [Mglip](http://fy.mglip.com/pc)                               | 3                             | good at Mongolia translation                                                                | [Inner Mongolia University](https://www.imu.edu.cn/yw/Home.htm), China                                 | stable                                          |
| 25  | [Utibet](http://mt.utibet.edu.cn/mt)                          | 2                             | good at Tibet translation                                                                   | [Tibet University](http://www.utibet.edu.cn/), China                                                   | stable                                          |
| 26  | [TranslateCom](https://www.translate.com/machine-translation) | -                             | ~~from Microsoft~~                                                                          | [TranslateCom](https://www.translate.com/about-us), America                                            | stable                                          |

### Supported Language

| Language             | Language of Translator | [Google](https://translate.google.com) | [Yandex](https://translate.yandex.com) | [Bing](https://www.bing.com/Translator) | [Baidu](https://fanyi.baidu.com) | [Alibaba](https://translate.alibaba.com) | [Tencent](https://fanyi.qq.com) | [Youdao](https://fanyi.youdao.com) | [Sogou](https://fanyi.sogou.com) | [Deepl](https://www.deepl.com/translator) | [Caiyun](https://fanyi.caiyunapp.com) | [Argos](https://translate.argosopentech.com) | others... |
| -------------------- | ---------------------- | -------------------------------------- | -------------------------------------- | --------------------------------------- | -------------------------------- | ---------------------------------------- | ------------------------------- | ---------------------------------- | -------------------------------- | ----------------------------------------- | ------------------------------------- | -------------------------------------------- | --------- |
| english              | en                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            | ...       |
| chinese              | zh                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| arabic               | ar                     | Y                                      | Y                                      | Y                                       | Y(ara)                           | Y                                        | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| russian              | ru                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| french               | fr                     | Y                                      | Y                                      | Y                                       | Y(fra)                           | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| german               | de                     | Y                                      | Y                                      | Y                                       | Y                                |                                          | Y                               | Y                                  | Y                                | Y                                         |                                       | Y                                            |           |
| spanish              | es                     | Y                                      | Y                                      | Y                                       | Y(spa)                           | Y                                        | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| portuguese           | pt                     | Y                                      | Y                                      | Y(pt/pt-pt)                             | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         |                                       | Y                                            |           |
| italian              | it                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               | Y                                  | Y                                | Y                                         |                                       | Y                                            |           |
| japanese             | ja                     | Y                                      | Y                                      | Y                                       | Y(jp)                            |                                          | Y                               | Y                                  | Y                                | Y                                         | Y                                     | Y                                            |           |
| korean               | ko                     | Y                                      | Y                                      | Y                                       | Y(kor)                           |                                          | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| greek                | el                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| dutch                | nl                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 | Y                                  | Y                                | Y                                         |                                       |                                              |           |
| hindi                | hi                     | Y                                      | Y                                      | Y                                       |                                  |                                          | Y                               |                                    | Y                                |                                           |                                       | Y                                            |           |
| turkish              | tr                     | Y                                      | Y                                      | Y                                       |                                  | Y                                        | Y                               |                                    | Y                                |                                           |                                       | Y                                            |           |
| malay                | ms                     | Y                                      | Y                                      | Y                                       |                                  |                                          | Y                               |                                    | Y                                |                                           |                                       |                                              |           |
| thai                 | th                     | Y                                      | Y                                      | Y                                       | Y                                | Y                                        | Y                               |                                    | Y                                |                                           |                                       |                                              |           |
| vietnamese           | vi                     | Y                                      | Y                                      | Y                                       | Y(vie)                           | Y                                        | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| indonesian           | id                     | Y                                      | Y                                      | Y                                       |                                  | Y                                        | Y                               | Y                                  | Y                                |                                           |                                       | Y                                            |           |
| hebrew               | he                     | Y(iw)                                  | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| polish               | pl                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       | Y                                            |           |
| mongolian            | mn                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| czech                | cs                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| hungarian            | hu                     | Y                                      | Y                                      | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| estonian             | et                     | Y                                      | Y                                      | Y                                       | Y(est)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| bulgarian            | bg                     | Y                                      | Y                                      | Y                                       | Y(bul)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| danish               | da                     | Y                                      | Y                                      | Y                                       | Y(dan)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| finnish              | fi                     | Y                                      | Y                                      | Y                                       | Y(fin)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| romanian             | ro                     | Y                                      | Y                                      | Y                                       | Y(rom)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| swedish              | sv                     | Y                                      | Y                                      | Y                                       | Y(swe)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| slovenian            | sl                     | Y                                      | Y                                      | Y                                       | Y(slo)                           |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| persian/farsi        | fa                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| bosnian              | bs                     | Y                                      | Y                                      | Y(bs-Latn)                              |                                  |                                          |                                 |                                    | Y(bs-Latn)                       |                                           |                                       |                                              |           |
| serbian              | sr                     | Y                                      | Y                                      | Y(sr-Latn/sr-Cyrl)                      |                                  |                                          |                                 |                                    | Y(sr-Latn/sr-Cyrl)               |                                           |                                       |                                              |           |
| fijian               | fj                     |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| filipino             | tl                     | Y                                      | Y                                      | Y(fil)                                  |                                  |                                          |                                 |                                    | Y(fil)                           |                                           |                                       |                                              |           |
| haitiancreole        | ht                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| catalan              | ca                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| croatian             | hr                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| latvian              | lv                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| lithuanian           | lt                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| urdu                 | ur                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| ukrainian            | uk                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| welsh                | cy                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| tahiti               | ty                     |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| tongan               | to                     |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| swahili              | sw                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| samoan               | sm                     | Y                                      |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| slovak               | sk                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                         |                                       |                                              |           |
| afrikaans            | af                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| norwegian            | no                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| bengali              | bn                     | Y                                      | Y                                      | Y(bn-BD)                                |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| malagasy             | mg                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| maltese              | mt                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| queretaro otomi      | otq                    |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| klingon/tlhingan hol | tlh                    |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                |                                           |                                       |                                              |           |
| gujarati             | gu                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| tamil                | ta                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| telugu               | te                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| punjabi              | pa                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| amharic              | am                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| azerbaijani          | az                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| bashkir              | ba                     |                                        | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| belarusian           | be                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| cebuano              | ceb                    | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| chuvash              | cv                     |                                        | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| esperanto            | eo                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| basque               | eu                     | Y                                      | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| irish                | ga                     | Y                                      | Y                                      | Y                                       |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| emoji                | emj                    |                                        | Y                                      |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |
| ...                  | ...                    |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                           |                                       |                                              |           |

### About Chinese Language

| Language      | Language of Translator | [Google](https://translate.google.com) | [Yandex](https://translate.yandex.com) | [Bing](https://www.bing.com/Translator) | [Baidu](https://fanyi.baidu.com) | [Alibaba](https://translate.alibaba.com) | [Tencent](https://fanyi.qq.com) | [Youdao](https://fanyi.youdao.com) | [Sogou](https://fanyi.sogou.com) | [Iciba](https://www.iciba.com/fy) | [Iflytek](https://fanyi.xfyun.cn/console/trans/text) | [Caiyun](https://fanyi.caiyunapp.com) | [Deepl](https://www.deepl.com/translator) | [Argos](https://translate.argosopentech.com) | [Itranslate](https://itranslate.com/webapp) | [Reverso](https://www.reverso.net/text-translation) | [TranslateCom](https://www.translate.com/machine-translation) | [Papago](https://papago.naver.com) | [Utibet](http://mt.utibet.edu.cn/mt) |
| ------------- | ---------------------- | -------------------------------------- | -------------------------------------- | --------------------------------------- | -------------------------------- | ---------------------------------------- | ------------------------------- | ---------------------------------- | -------------------------------- | --------------------------------- | ---------------------------------------------------- | ------------------------------------- | ----------------------------------------- | -------------------------------------------- | ------------------------------------------- | --------------------------------------------------- | ------------------------------------------------------------- | ---------------------------------- | ------------------------------------ |
| Chinese(简体)   | zh-CHS                 | Y(zh-CN)                               | Y(zh)                                  | Y(zh-Hans)                              | Y(zh)                            | Y(zh)                                    | Y(zh)                           | Y                                  | Y                                | Y(zh)                             | Y(zh)                                                | Y(zh)                                 | Y(zh)                                     | Y(zh)                                        | Y(zh-CN)                                    | Y(zh/chi)                                           | ...                                                           | Y(zh-CN)                           | Y(zh)                                |
| Chinese(繁体)   | zh-CHT                 | Y(zh-TW)                               |                                        | Y(zh-Hant)                              | Y(cht)                           | Y(zh-TW)                                 |                                 |                                    | Y                                | Y(cnt)                            |                                                      |                                       |                                           |                                              | Y(zh-TW)                                    |                                                     |                                                               | Y(zh-TW)                           |                                      |
| Chinese(文言文)  | wyw                    |                                        |                                        |                                         | Y                                |                                          |                                 |                                    |                                  |                                   |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(粤语)   | yue                    |                                        |                                        | Y                                       | Y                                |                                          |                                 |                                    | Y                                | Y                                 | Y                                                    |                                       |                                           |                                              | Y(zh-HK)                                    |                                                     |                                                               |                                    |                                      |
| Chinese(内蒙语)  | mn                     | N[外蒙]                                  | N[外蒙]                                  |                                         |                                  |                                          |                                 |                                    |                                  |                                   | Y[内蒙]                                                |                                       |                                           |                                              | N[外蒙]                                       |                                                     |                                                               |                                    |                                      |
| Chinese(维吾尔语) | uy                     |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  | Y                                 |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(藏语)   | ti                     |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  | Y                                 |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    | Y                                    |
| Chinese(白苗文)  | mww                    |                                        |                                        | Y                                       |                                  |                                          |                                 |                                    | Y                                | Y                                 |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(彝语)   | ii                     |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                   | Y                                                    |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |
| Chinese(苗语)   | hmn                    |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                   |                                                      |                                       |                                           |                                              | Y                                           |                                                     |                                                               |                                    |                                      |
| Chinese(壮语)   | zyb                    |                                        |                                        |                                         |                                  |                                          |                                 |                                    |                                  |                                   |                                                      |                                       |                                           |                                              |                                             |                                                     |                                                               |                                    |                                      |

## Debug Tips

### Linux Runtime Environment

1. To support javascript runtime environment, you should [download and install Node.js](https://nodejs.org/en/download/).
2. PS, `tss.baidu()` doesn't work on Linux without desktop.

### Supported Country and Region Service

1. If you have requests error, please check whether this service is provided in your country or region.
2. Check the website about `eg: help(tss.google)`.

### HttpError 4xx

1. Check whether you made high frequency requests.
2. Check whether this service is provided in your country or region.
3. Detail to solve [HttpError](https://developer.mozilla.org/en-US/docs/Web/HTTP/Status) itself.
4. [Issue me](https://github.com/UlionTse/translators/issues), thanks.

### NetworkError or ProxyError

1. Check whether the network is connected correctly.
2. Check the proxy are enabled on your computer. If it is enabled, try turning it off or otherwise. 

## License

[MIT Llicense](https://github.com/uliontse/translators/blob/master/LICENSE)
