/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#include <yarp/dev/OdometryData6D.h>

namespace yarp::dev {

// Constructor with field values
OdometryData6D::OdometryData6D(const double odom_x,
                               const double odom_y,
                               const double odom_z,
                               const double odom_roll,
                               const double odom_pitch,
                               const double odom_yaw,
                               const double base_vel_x,
                               const double base_vel_y,
                               const double base_vel_z,
                               const double base_vel_roll,
                               const double base_vel_pitch,
                               const double base_vel_yaw,
                               const double odom_vel_x,
                               const double odom_vel_y,
                               const double odom_vel_z,
                               const double odom_vel_roll,
                               const double odom_vel_pitch,
                               const double odom_vel_yaw) :
        WirePortable(),
        odom_x(odom_x),
        odom_y(odom_y),
        odom_z(odom_z),
        odom_roll(odom_roll),
        odom_pitch(odom_pitch),
        odom_yaw(odom_yaw),
        base_vel_x(base_vel_x),
        base_vel_y(base_vel_y),
        base_vel_z(base_vel_z),
        base_vel_roll(base_vel_roll),
        base_vel_pitch(base_vel_pitch),
        base_vel_yaw(base_vel_yaw),
        odom_vel_x(odom_vel_x),
        odom_vel_y(odom_vel_y),
        odom_vel_z(odom_vel_z),
        odom_vel_roll(odom_vel_roll),
        odom_vel_pitch(odom_vel_pitch),
        odom_vel_yaw(odom_vel_yaw)
{
}

// Read structure on a Wire
bool OdometryData6D::read(yarp::os::idl::WireReader& reader)
{
    if (!read_odom_x(reader)) {
        return false;
    }
    if (!read_odom_y(reader)) {
        return false;
    }
    if (!read_odom_z(reader)) {
        return false;
    }
    if (!read_odom_roll(reader)) {
        return false;
    }
    if (!read_odom_pitch(reader)) {
        return false;
    }
    if (!read_odom_yaw(reader)) {
        return false;
    }
    if (!read_base_vel_x(reader)) {
        return false;
    }
    if (!read_base_vel_y(reader)) {
        return false;
    }
    if (!read_base_vel_z(reader)) {
        return false;
    }
    if (!read_base_vel_roll(reader)) {
        return false;
    }
    if (!read_base_vel_pitch(reader)) {
        return false;
    }
    if (!read_base_vel_yaw(reader)) {
        return false;
    }
    if (!read_odom_vel_x(reader)) {
        return false;
    }
    if (!read_odom_vel_y(reader)) {
        return false;
    }
    if (!read_odom_vel_z(reader)) {
        return false;
    }
    if (!read_odom_vel_roll(reader)) {
        return false;
    }
    if (!read_odom_vel_pitch(reader)) {
        return false;
    }
    if (!read_odom_vel_yaw(reader)) {
        return false;
    }
    return !reader.isError();
}

// Read structure on a Connection
bool OdometryData6D::read(yarp::os::ConnectionReader& connection)
{
    yarp::os::idl::WireReader reader(connection);
    if (!reader.readListHeader(18)) {
        return false;
    }
    return read(reader);
}

// Write structure on a Wire
bool OdometryData6D::write(const yarp::os::idl::WireWriter& writer) const
{
    if (!write_odom_x(writer)) {
        return false;
    }
    if (!write_odom_y(writer)) {
        return false;
    }
    if (!write_odom_z(writer)) {
        return false;
    }
    if (!write_odom_roll(writer)) {
        return false;
    }
    if (!write_odom_pitch(writer)) {
        return false;
    }
    if (!write_odom_yaw(writer)) {
        return false;
    }
    if (!write_base_vel_x(writer)) {
        return false;
    }
    if (!write_base_vel_y(writer)) {
        return false;
    }
    if (!write_base_vel_z(writer)) {
        return false;
    }
    if (!write_base_vel_roll(writer)) {
        return false;
    }
    if (!write_base_vel_pitch(writer)) {
        return false;
    }
    if (!write_base_vel_yaw(writer)) {
        return false;
    }
    if (!write_odom_vel_x(writer)) {
        return false;
    }
    if (!write_odom_vel_y(writer)) {
        return false;
    }
    if (!write_odom_vel_z(writer)) {
        return false;
    }
    if (!write_odom_vel_roll(writer)) {
        return false;
    }
    if (!write_odom_vel_pitch(writer)) {
        return false;
    }
    if (!write_odom_vel_yaw(writer)) {
        return false;
    }
    return !writer.isError();
}

// Write structure on a Connection
bool OdometryData6D::write(yarp::os::ConnectionWriter& connection) const
{
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(18)) {
        return false;
    }
    return write(writer);
}

// Convert to a printable string
std::string OdometryData6D::toString() const
{
    yarp::os::Bottle b;
    b.read(*this);
    return b.toString();
}

// Editor: default constructor
OdometryData6D::Editor::Editor()
{
    group = 0;
    obj_owned = true;
    obj = new OdometryData6D;
    dirty_flags(false);
    yarp().setOwner(*this);
}

// Editor: constructor with base class
OdometryData6D::Editor::Editor(OdometryData6D& obj)
{
    group = 0;
    obj_owned = false;
    edit(obj, false);
    yarp().setOwner(*this);
}

// Editor: destructor
OdometryData6D::Editor::~Editor()
{
    if (obj_owned) {
        delete obj;
    }
}

// Editor: edit
bool OdometryData6D::Editor::edit(OdometryData6D& obj, bool dirty)
{
    if (obj_owned) {
        delete this->obj;
    }
    this->obj = &obj;
    obj_owned = false;
    dirty_flags(dirty);
    return true;
}

// Editor: validity check
bool OdometryData6D::Editor::isValid() const
{
    return obj != nullptr;
}

// Editor: state
OdometryData6D& OdometryData6D::Editor::state()
{
    return *obj;
}

// Editor: grouping begin
void OdometryData6D::Editor::start_editing()
{
    group++;
}

// Editor: grouping end
void OdometryData6D::Editor::stop_editing()
{
    group--;
    if (group == 0 && is_dirty) {
        communicate();
    }
}
// Editor: odom_x setter
void OdometryData6D::Editor::set_odom_x(const double odom_x)
{
    will_set_odom_x();
    obj->odom_x = odom_x;
    mark_dirty_odom_x();
    communicate();
    did_set_odom_x();
}

// Editor: odom_x getter
double OdometryData6D::Editor::get_odom_x() const
{
    return obj->odom_x;
}

// Editor: odom_x will_set
bool OdometryData6D::Editor::will_set_odom_x()
{
    return true;
}

// Editor: odom_x did_set
bool OdometryData6D::Editor::did_set_odom_x()
{
    return true;
}

// Editor: odom_y setter
void OdometryData6D::Editor::set_odom_y(const double odom_y)
{
    will_set_odom_y();
    obj->odom_y = odom_y;
    mark_dirty_odom_y();
    communicate();
    did_set_odom_y();
}

// Editor: odom_y getter
double OdometryData6D::Editor::get_odom_y() const
{
    return obj->odom_y;
}

// Editor: odom_y will_set
bool OdometryData6D::Editor::will_set_odom_y()
{
    return true;
}

// Editor: odom_y did_set
bool OdometryData6D::Editor::did_set_odom_y()
{
    return true;
}

// Editor: odom_z setter
void OdometryData6D::Editor::set_odom_z(const double odom_z)
{
    will_set_odom_z();
    obj->odom_z = odom_z;
    mark_dirty_odom_z();
    communicate();
    did_set_odom_z();
}

// Editor: odom_z getter
double OdometryData6D::Editor::get_odom_z() const
{
    return obj->odom_z;
}

// Editor: odom_z will_set
bool OdometryData6D::Editor::will_set_odom_z()
{
    return true;
}

// Editor: odom_z did_set
bool OdometryData6D::Editor::did_set_odom_z()
{
    return true;
}

// Editor: odom_roll setter
void OdometryData6D::Editor::set_odom_roll(const double odom_roll)
{
    will_set_odom_roll();
    obj->odom_roll = odom_roll;
    mark_dirty_odom_roll();
    communicate();
    did_set_odom_roll();
}

// Editor: odom_roll getter
double OdometryData6D::Editor::get_odom_roll() const
{
    return obj->odom_roll;
}

// Editor: odom_roll will_set
bool OdometryData6D::Editor::will_set_odom_roll()
{
    return true;
}

// Editor: odom_roll did_set
bool OdometryData6D::Editor::did_set_odom_roll()
{
    return true;
}

// Editor: odom_pitch setter
void OdometryData6D::Editor::set_odom_pitch(const double odom_pitch)
{
    will_set_odom_pitch();
    obj->odom_pitch = odom_pitch;
    mark_dirty_odom_pitch();
    communicate();
    did_set_odom_pitch();
}

// Editor: odom_pitch getter
double OdometryData6D::Editor::get_odom_pitch() const
{
    return obj->odom_pitch;
}

// Editor: odom_pitch will_set
bool OdometryData6D::Editor::will_set_odom_pitch()
{
    return true;
}

// Editor: odom_pitch did_set
bool OdometryData6D::Editor::did_set_odom_pitch()
{
    return true;
}

// Editor: odom_yaw setter
void OdometryData6D::Editor::set_odom_yaw(const double odom_yaw)
{
    will_set_odom_yaw();
    obj->odom_yaw = odom_yaw;
    mark_dirty_odom_yaw();
    communicate();
    did_set_odom_yaw();
}

// Editor: odom_yaw getter
double OdometryData6D::Editor::get_odom_yaw() const
{
    return obj->odom_yaw;
}

// Editor: odom_yaw will_set
bool OdometryData6D::Editor::will_set_odom_yaw()
{
    return true;
}

// Editor: odom_yaw did_set
bool OdometryData6D::Editor::did_set_odom_yaw()
{
    return true;
}

// Editor: base_vel_x setter
void OdometryData6D::Editor::set_base_vel_x(const double base_vel_x)
{
    will_set_base_vel_x();
    obj->base_vel_x = base_vel_x;
    mark_dirty_base_vel_x();
    communicate();
    did_set_base_vel_x();
}

// Editor: base_vel_x getter
double OdometryData6D::Editor::get_base_vel_x() const
{
    return obj->base_vel_x;
}

// Editor: base_vel_x will_set
bool OdometryData6D::Editor::will_set_base_vel_x()
{
    return true;
}

// Editor: base_vel_x did_set
bool OdometryData6D::Editor::did_set_base_vel_x()
{
    return true;
}

// Editor: base_vel_y setter
void OdometryData6D::Editor::set_base_vel_y(const double base_vel_y)
{
    will_set_base_vel_y();
    obj->base_vel_y = base_vel_y;
    mark_dirty_base_vel_y();
    communicate();
    did_set_base_vel_y();
}

// Editor: base_vel_y getter
double OdometryData6D::Editor::get_base_vel_y() const
{
    return obj->base_vel_y;
}

// Editor: base_vel_y will_set
bool OdometryData6D::Editor::will_set_base_vel_y()
{
    return true;
}

// Editor: base_vel_y did_set
bool OdometryData6D::Editor::did_set_base_vel_y()
{
    return true;
}

// Editor: base_vel_z setter
void OdometryData6D::Editor::set_base_vel_z(const double base_vel_z)
{
    will_set_base_vel_z();
    obj->base_vel_z = base_vel_z;
    mark_dirty_base_vel_z();
    communicate();
    did_set_base_vel_z();
}

// Editor: base_vel_z getter
double OdometryData6D::Editor::get_base_vel_z() const
{
    return obj->base_vel_z;
}

// Editor: base_vel_z will_set
bool OdometryData6D::Editor::will_set_base_vel_z()
{
    return true;
}

// Editor: base_vel_z did_set
bool OdometryData6D::Editor::did_set_base_vel_z()
{
    return true;
}

// Editor: base_vel_roll setter
void OdometryData6D::Editor::set_base_vel_roll(const double base_vel_roll)
{
    will_set_base_vel_roll();
    obj->base_vel_roll = base_vel_roll;
    mark_dirty_base_vel_roll();
    communicate();
    did_set_base_vel_roll();
}

// Editor: base_vel_roll getter
double OdometryData6D::Editor::get_base_vel_roll() const
{
    return obj->base_vel_roll;
}

// Editor: base_vel_roll will_set
bool OdometryData6D::Editor::will_set_base_vel_roll()
{
    return true;
}

// Editor: base_vel_roll did_set
bool OdometryData6D::Editor::did_set_base_vel_roll()
{
    return true;
}

// Editor: base_vel_pitch setter
void OdometryData6D::Editor::set_base_vel_pitch(const double base_vel_pitch)
{
    will_set_base_vel_pitch();
    obj->base_vel_pitch = base_vel_pitch;
    mark_dirty_base_vel_pitch();
    communicate();
    did_set_base_vel_pitch();
}

// Editor: base_vel_pitch getter
double OdometryData6D::Editor::get_base_vel_pitch() const
{
    return obj->base_vel_pitch;
}

// Editor: base_vel_pitch will_set
bool OdometryData6D::Editor::will_set_base_vel_pitch()
{
    return true;
}

// Editor: base_vel_pitch did_set
bool OdometryData6D::Editor::did_set_base_vel_pitch()
{
    return true;
}

// Editor: base_vel_yaw setter
void OdometryData6D::Editor::set_base_vel_yaw(const double base_vel_yaw)
{
    will_set_base_vel_yaw();
    obj->base_vel_yaw = base_vel_yaw;
    mark_dirty_base_vel_yaw();
    communicate();
    did_set_base_vel_yaw();
}

// Editor: base_vel_yaw getter
double OdometryData6D::Editor::get_base_vel_yaw() const
{
    return obj->base_vel_yaw;
}

// Editor: base_vel_yaw will_set
bool OdometryData6D::Editor::will_set_base_vel_yaw()
{
    return true;
}

// Editor: base_vel_yaw did_set
bool OdometryData6D::Editor::did_set_base_vel_yaw()
{
    return true;
}

// Editor: odom_vel_x setter
void OdometryData6D::Editor::set_odom_vel_x(const double odom_vel_x)
{
    will_set_odom_vel_x();
    obj->odom_vel_x = odom_vel_x;
    mark_dirty_odom_vel_x();
    communicate();
    did_set_odom_vel_x();
}

// Editor: odom_vel_x getter
double OdometryData6D::Editor::get_odom_vel_x() const
{
    return obj->odom_vel_x;
}

// Editor: odom_vel_x will_set
bool OdometryData6D::Editor::will_set_odom_vel_x()
{
    return true;
}

// Editor: odom_vel_x did_set
bool OdometryData6D::Editor::did_set_odom_vel_x()
{
    return true;
}

// Editor: odom_vel_y setter
void OdometryData6D::Editor::set_odom_vel_y(const double odom_vel_y)
{
    will_set_odom_vel_y();
    obj->odom_vel_y = odom_vel_y;
    mark_dirty_odom_vel_y();
    communicate();
    did_set_odom_vel_y();
}

// Editor: odom_vel_y getter
double OdometryData6D::Editor::get_odom_vel_y() const
{
    return obj->odom_vel_y;
}

// Editor: odom_vel_y will_set
bool OdometryData6D::Editor::will_set_odom_vel_y()
{
    return true;
}

// Editor: odom_vel_y did_set
bool OdometryData6D::Editor::did_set_odom_vel_y()
{
    return true;
}

// Editor: odom_vel_z setter
void OdometryData6D::Editor::set_odom_vel_z(const double odom_vel_z)
{
    will_set_odom_vel_z();
    obj->odom_vel_z = odom_vel_z;
    mark_dirty_odom_vel_z();
    communicate();
    did_set_odom_vel_z();
}

// Editor: odom_vel_z getter
double OdometryData6D::Editor::get_odom_vel_z() const
{
    return obj->odom_vel_z;
}

// Editor: odom_vel_z will_set
bool OdometryData6D::Editor::will_set_odom_vel_z()
{
    return true;
}

// Editor: odom_vel_z did_set
bool OdometryData6D::Editor::did_set_odom_vel_z()
{
    return true;
}

// Editor: odom_vel_roll setter
void OdometryData6D::Editor::set_odom_vel_roll(const double odom_vel_roll)
{
    will_set_odom_vel_roll();
    obj->odom_vel_roll = odom_vel_roll;
    mark_dirty_odom_vel_roll();
    communicate();
    did_set_odom_vel_roll();
}

// Editor: odom_vel_roll getter
double OdometryData6D::Editor::get_odom_vel_roll() const
{
    return obj->odom_vel_roll;
}

// Editor: odom_vel_roll will_set
bool OdometryData6D::Editor::will_set_odom_vel_roll()
{
    return true;
}

// Editor: odom_vel_roll did_set
bool OdometryData6D::Editor::did_set_odom_vel_roll()
{
    return true;
}

// Editor: odom_vel_pitch setter
void OdometryData6D::Editor::set_odom_vel_pitch(const double odom_vel_pitch)
{
    will_set_odom_vel_pitch();
    obj->odom_vel_pitch = odom_vel_pitch;
    mark_dirty_odom_vel_pitch();
    communicate();
    did_set_odom_vel_pitch();
}

// Editor: odom_vel_pitch getter
double OdometryData6D::Editor::get_odom_vel_pitch() const
{
    return obj->odom_vel_pitch;
}

// Editor: odom_vel_pitch will_set
bool OdometryData6D::Editor::will_set_odom_vel_pitch()
{
    return true;
}

// Editor: odom_vel_pitch did_set
bool OdometryData6D::Editor::did_set_odom_vel_pitch()
{
    return true;
}

// Editor: odom_vel_yaw setter
void OdometryData6D::Editor::set_odom_vel_yaw(const double odom_vel_yaw)
{
    will_set_odom_vel_yaw();
    obj->odom_vel_yaw = odom_vel_yaw;
    mark_dirty_odom_vel_yaw();
    communicate();
    did_set_odom_vel_yaw();
}

// Editor: odom_vel_yaw getter
double OdometryData6D::Editor::get_odom_vel_yaw() const
{
    return obj->odom_vel_yaw;
}

// Editor: odom_vel_yaw will_set
bool OdometryData6D::Editor::will_set_odom_vel_yaw()
{
    return true;
}

// Editor: odom_vel_yaw did_set
bool OdometryData6D::Editor::did_set_odom_vel_yaw()
{
    return true;
}

// Editor: clean
void OdometryData6D::Editor::clean()
{
    dirty_flags(false);
}

// Editor: read
bool OdometryData6D::Editor::read(yarp::os::ConnectionReader& connection)
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireReader reader(connection);
    reader.expectAccept();
    if (!reader.readListHeader()) {
        return false;
    }
    int len = reader.getLength();
    if (len == 0) {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(1)) {
            return false;
        }
        writer.writeString("send: 'help' or 'patch (param1 val1) (param2 val2)'");
        return true;
    }
    std::string tag;
    if (!reader.readString(tag)) {
        return false;
    }
    if (tag == "help") {
        yarp::os::idl::WireWriter writer(reader);
        if (writer.isNull()) {
            return true;
        }
        if (!writer.writeListHeader(2)) {
            return false;
        }
        if (!writer.writeTag("many", 1, 0)) {
            return false;
        }
        if (reader.getLength() > 0) {
            std::string field;
            if (!reader.readString(field)) {
                return false;
            }
            if (field == "odom_x") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_x")) {
                    return false;
                }
                if (!writer.writeString("position of the robot [m], expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_y") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_y")) {
                    return false;
                }
                if (!writer.writeString("position of the robot [m], expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_z") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_z")) {
                    return false;
                }
                if (!writer.writeString("position of the robot [m], expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_roll") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_roll")) {
                    return false;
                }
                if (!writer.writeString("orientation the robot [deg], expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_pitch") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_pitch")) {
                    return false;
                }
                if (!writer.writeString("orientation the robot [deg], expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_yaw") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_yaw")) {
                    return false;
                }
                if (!writer.writeString("orientation the robot [deg], expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "base_vel_x") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double base_vel_x")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s] expressed in the robot reference frame")) {
                    return false;
                }
            }
            if (field == "base_vel_y") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double base_vel_y")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s] expressed in the robot reference frame")) {
                    return false;
                }
            }
            if (field == "base_vel_z") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double base_vel_z")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s] expressed in the robot reference frame")) {
                    return false;
                }
            }
            if (field == "base_vel_roll") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double base_vel_roll")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s] expressed in the robot reference frame")) {
                    return false;
                }
            }
            if (field == "base_vel_pitch") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double base_vel_pitch")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s] expressed in the robot reference frame")) {
                    return false;
                }
            }
            if (field == "base_vel_yaw") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double base_vel_yaw")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s] expressed in the robot reference frame")) {
                    return false;
                }
            }
            if (field == "odom_vel_x") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_vel_x")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s] expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_vel_y") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_vel_y")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s] expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_vel_z") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_vel_z")) {
                    return false;
                }
                if (!writer.writeString("velocity of the robot [m/s] expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_vel_roll") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_vel_roll")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s] expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_vel_pitch") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_vel_pitch")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s] expressed in the world reference frame")) {
                    return false;
                }
            }
            if (field == "odom_vel_yaw") {
                if (!writer.writeListHeader(2)) {
                    return false;
                }
                if (!writer.writeString("double odom_vel_yaw")) {
                    return false;
                }
                if (!writer.writeString("angular velocity of the robot [deg/s] expressed in the world reference frame")) {
                    return false;
                }
            }
        }
        if (!writer.writeListHeader(19)) {
            return false;
        }
        writer.writeString("*** Available fields:");
        writer.writeString("odom_x");
        writer.writeString("odom_y");
        writer.writeString("odom_z");
        writer.writeString("odom_roll");
        writer.writeString("odom_pitch");
        writer.writeString("odom_yaw");
        writer.writeString("base_vel_x");
        writer.writeString("base_vel_y");
        writer.writeString("base_vel_z");
        writer.writeString("base_vel_roll");
        writer.writeString("base_vel_pitch");
        writer.writeString("base_vel_yaw");
        writer.writeString("odom_vel_x");
        writer.writeString("odom_vel_y");
        writer.writeString("odom_vel_z");
        writer.writeString("odom_vel_roll");
        writer.writeString("odom_vel_pitch");
        writer.writeString("odom_vel_yaw");
        return true;
    }
    bool nested = true;
    bool have_act = false;
    if (tag != "patch") {
        if (((len - 1) % 2) != 0) {
            return false;
        }
        len = 1 + ((len - 1) / 2);
        nested = false;
        have_act = true;
    }
    for (int i = 1; i < len; ++i) {
        if (nested && !reader.readListHeader(3)) {
            return false;
        }
        std::string act;
        std::string key;
        if (have_act) {
            act = tag;
        } else if (!reader.readString(act)) {
            return false;
        }
        if (!reader.readString(key)) {
            return false;
        }
        if (key == "odom_x") {
            will_set_odom_x();
            if (!obj->nested_read_odom_x(reader)) {
                return false;
            }
            did_set_odom_x();
        } else if (key == "odom_y") {
            will_set_odom_y();
            if (!obj->nested_read_odom_y(reader)) {
                return false;
            }
            did_set_odom_y();
        } else if (key == "odom_z") {
            will_set_odom_z();
            if (!obj->nested_read_odom_z(reader)) {
                return false;
            }
            did_set_odom_z();
        } else if (key == "odom_roll") {
            will_set_odom_roll();
            if (!obj->nested_read_odom_roll(reader)) {
                return false;
            }
            did_set_odom_roll();
        } else if (key == "odom_pitch") {
            will_set_odom_pitch();
            if (!obj->nested_read_odom_pitch(reader)) {
                return false;
            }
            did_set_odom_pitch();
        } else if (key == "odom_yaw") {
            will_set_odom_yaw();
            if (!obj->nested_read_odom_yaw(reader)) {
                return false;
            }
            did_set_odom_yaw();
        } else if (key == "base_vel_x") {
            will_set_base_vel_x();
            if (!obj->nested_read_base_vel_x(reader)) {
                return false;
            }
            did_set_base_vel_x();
        } else if (key == "base_vel_y") {
            will_set_base_vel_y();
            if (!obj->nested_read_base_vel_y(reader)) {
                return false;
            }
            did_set_base_vel_y();
        } else if (key == "base_vel_z") {
            will_set_base_vel_z();
            if (!obj->nested_read_base_vel_z(reader)) {
                return false;
            }
            did_set_base_vel_z();
        } else if (key == "base_vel_roll") {
            will_set_base_vel_roll();
            if (!obj->nested_read_base_vel_roll(reader)) {
                return false;
            }
            did_set_base_vel_roll();
        } else if (key == "base_vel_pitch") {
            will_set_base_vel_pitch();
            if (!obj->nested_read_base_vel_pitch(reader)) {
                return false;
            }
            did_set_base_vel_pitch();
        } else if (key == "base_vel_yaw") {
            will_set_base_vel_yaw();
            if (!obj->nested_read_base_vel_yaw(reader)) {
                return false;
            }
            did_set_base_vel_yaw();
        } else if (key == "odom_vel_x") {
            will_set_odom_vel_x();
            if (!obj->nested_read_odom_vel_x(reader)) {
                return false;
            }
            did_set_odom_vel_x();
        } else if (key == "odom_vel_y") {
            will_set_odom_vel_y();
            if (!obj->nested_read_odom_vel_y(reader)) {
                return false;
            }
            did_set_odom_vel_y();
        } else if (key == "odom_vel_z") {
            will_set_odom_vel_z();
            if (!obj->nested_read_odom_vel_z(reader)) {
                return false;
            }
            did_set_odom_vel_z();
        } else if (key == "odom_vel_roll") {
            will_set_odom_vel_roll();
            if (!obj->nested_read_odom_vel_roll(reader)) {
                return false;
            }
            did_set_odom_vel_roll();
        } else if (key == "odom_vel_pitch") {
            will_set_odom_vel_pitch();
            if (!obj->nested_read_odom_vel_pitch(reader)) {
                return false;
            }
            did_set_odom_vel_pitch();
        } else if (key == "odom_vel_yaw") {
            will_set_odom_vel_yaw();
            if (!obj->nested_read_odom_vel_yaw(reader)) {
                return false;
            }
            did_set_odom_vel_yaw();
        } else {
            // would be useful to have a fallback here
        }
    }
    reader.accept();
    yarp::os::idl::WireWriter writer(reader);
    if (writer.isNull()) {
        return true;
    }
    writer.writeListHeader(1);
    writer.writeVocab32('o', 'k');
    return true;
}

// Editor: write
bool OdometryData6D::Editor::write(yarp::os::ConnectionWriter& connection) const
{
    if (!isValid()) {
        return false;
    }
    yarp::os::idl::WireWriter writer(connection);
    if (!writer.writeListHeader(dirty_count + 1)) {
        return false;
    }
    if (!writer.writeString("patch")) {
        return false;
    }
    if (is_dirty_odom_x) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_x")) {
            return false;
        }
        if (!obj->nested_write_odom_x(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_y) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_y")) {
            return false;
        }
        if (!obj->nested_write_odom_y(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_z) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_z")) {
            return false;
        }
        if (!obj->nested_write_odom_z(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_roll) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_roll")) {
            return false;
        }
        if (!obj->nested_write_odom_roll(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_pitch) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_pitch")) {
            return false;
        }
        if (!obj->nested_write_odom_pitch(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_yaw) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_yaw")) {
            return false;
        }
        if (!obj->nested_write_odom_yaw(writer)) {
            return false;
        }
    }
    if (is_dirty_base_vel_x) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("base_vel_x")) {
            return false;
        }
        if (!obj->nested_write_base_vel_x(writer)) {
            return false;
        }
    }
    if (is_dirty_base_vel_y) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("base_vel_y")) {
            return false;
        }
        if (!obj->nested_write_base_vel_y(writer)) {
            return false;
        }
    }
    if (is_dirty_base_vel_z) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("base_vel_z")) {
            return false;
        }
        if (!obj->nested_write_base_vel_z(writer)) {
            return false;
        }
    }
    if (is_dirty_base_vel_roll) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("base_vel_roll")) {
            return false;
        }
        if (!obj->nested_write_base_vel_roll(writer)) {
            return false;
        }
    }
    if (is_dirty_base_vel_pitch) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("base_vel_pitch")) {
            return false;
        }
        if (!obj->nested_write_base_vel_pitch(writer)) {
            return false;
        }
    }
    if (is_dirty_base_vel_yaw) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("base_vel_yaw")) {
            return false;
        }
        if (!obj->nested_write_base_vel_yaw(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_vel_x) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_vel_x")) {
            return false;
        }
        if (!obj->nested_write_odom_vel_x(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_vel_y) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_vel_y")) {
            return false;
        }
        if (!obj->nested_write_odom_vel_y(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_vel_z) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_vel_z")) {
            return false;
        }
        if (!obj->nested_write_odom_vel_z(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_vel_roll) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_vel_roll")) {
            return false;
        }
        if (!obj->nested_write_odom_vel_roll(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_vel_pitch) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_vel_pitch")) {
            return false;
        }
        if (!obj->nested_write_odom_vel_pitch(writer)) {
            return false;
        }
    }
    if (is_dirty_odom_vel_yaw) {
        if (!writer.writeListHeader(3)) {
            return false;
        }
        if (!writer.writeString("set")) {
            return false;
        }
        if (!writer.writeString("odom_vel_yaw")) {
            return false;
        }
        if (!obj->nested_write_odom_vel_yaw(writer)) {
            return false;
        }
    }
    return !writer.isError();
}

// Editor: send if possible
void OdometryData6D::Editor::communicate()
{
    if (group != 0) {
        return;
    }
    if (yarp().canWrite()) {
        yarp().write(*this);
        clean();
    }
}

// Editor: mark dirty overall
void OdometryData6D::Editor::mark_dirty()
{
    is_dirty = true;
}

// Editor: odom_x mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_x()
{
    if (is_dirty_odom_x) {
        return;
    }
    dirty_count++;
    is_dirty_odom_x = true;
    mark_dirty();
}

// Editor: odom_y mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_y()
{
    if (is_dirty_odom_y) {
        return;
    }
    dirty_count++;
    is_dirty_odom_y = true;
    mark_dirty();
}

// Editor: odom_z mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_z()
{
    if (is_dirty_odom_z) {
        return;
    }
    dirty_count++;
    is_dirty_odom_z = true;
    mark_dirty();
}

// Editor: odom_roll mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_roll()
{
    if (is_dirty_odom_roll) {
        return;
    }
    dirty_count++;
    is_dirty_odom_roll = true;
    mark_dirty();
}

// Editor: odom_pitch mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_pitch()
{
    if (is_dirty_odom_pitch) {
        return;
    }
    dirty_count++;
    is_dirty_odom_pitch = true;
    mark_dirty();
}

// Editor: odom_yaw mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_yaw()
{
    if (is_dirty_odom_yaw) {
        return;
    }
    dirty_count++;
    is_dirty_odom_yaw = true;
    mark_dirty();
}

// Editor: base_vel_x mark_dirty
void OdometryData6D::Editor::mark_dirty_base_vel_x()
{
    if (is_dirty_base_vel_x) {
        return;
    }
    dirty_count++;
    is_dirty_base_vel_x = true;
    mark_dirty();
}

// Editor: base_vel_y mark_dirty
void OdometryData6D::Editor::mark_dirty_base_vel_y()
{
    if (is_dirty_base_vel_y) {
        return;
    }
    dirty_count++;
    is_dirty_base_vel_y = true;
    mark_dirty();
}

// Editor: base_vel_z mark_dirty
void OdometryData6D::Editor::mark_dirty_base_vel_z()
{
    if (is_dirty_base_vel_z) {
        return;
    }
    dirty_count++;
    is_dirty_base_vel_z = true;
    mark_dirty();
}

// Editor: base_vel_roll mark_dirty
void OdometryData6D::Editor::mark_dirty_base_vel_roll()
{
    if (is_dirty_base_vel_roll) {
        return;
    }
    dirty_count++;
    is_dirty_base_vel_roll = true;
    mark_dirty();
}

// Editor: base_vel_pitch mark_dirty
void OdometryData6D::Editor::mark_dirty_base_vel_pitch()
{
    if (is_dirty_base_vel_pitch) {
        return;
    }
    dirty_count++;
    is_dirty_base_vel_pitch = true;
    mark_dirty();
}

// Editor: base_vel_yaw mark_dirty
void OdometryData6D::Editor::mark_dirty_base_vel_yaw()
{
    if (is_dirty_base_vel_yaw) {
        return;
    }
    dirty_count++;
    is_dirty_base_vel_yaw = true;
    mark_dirty();
}

// Editor: odom_vel_x mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_vel_x()
{
    if (is_dirty_odom_vel_x) {
        return;
    }
    dirty_count++;
    is_dirty_odom_vel_x = true;
    mark_dirty();
}

// Editor: odom_vel_y mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_vel_y()
{
    if (is_dirty_odom_vel_y) {
        return;
    }
    dirty_count++;
    is_dirty_odom_vel_y = true;
    mark_dirty();
}

// Editor: odom_vel_z mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_vel_z()
{
    if (is_dirty_odom_vel_z) {
        return;
    }
    dirty_count++;
    is_dirty_odom_vel_z = true;
    mark_dirty();
}

// Editor: odom_vel_roll mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_vel_roll()
{
    if (is_dirty_odom_vel_roll) {
        return;
    }
    dirty_count++;
    is_dirty_odom_vel_roll = true;
    mark_dirty();
}

// Editor: odom_vel_pitch mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_vel_pitch()
{
    if (is_dirty_odom_vel_pitch) {
        return;
    }
    dirty_count++;
    is_dirty_odom_vel_pitch = true;
    mark_dirty();
}

// Editor: odom_vel_yaw mark_dirty
void OdometryData6D::Editor::mark_dirty_odom_vel_yaw()
{
    if (is_dirty_odom_vel_yaw) {
        return;
    }
    dirty_count++;
    is_dirty_odom_vel_yaw = true;
    mark_dirty();
}

// Editor: dirty_flags
void OdometryData6D::Editor::dirty_flags(bool flag)
{
    is_dirty = flag;
    is_dirty_odom_x = flag;
    is_dirty_odom_y = flag;
    is_dirty_odom_z = flag;
    is_dirty_odom_roll = flag;
    is_dirty_odom_pitch = flag;
    is_dirty_odom_yaw = flag;
    is_dirty_base_vel_x = flag;
    is_dirty_base_vel_y = flag;
    is_dirty_base_vel_z = flag;
    is_dirty_base_vel_roll = flag;
    is_dirty_base_vel_pitch = flag;
    is_dirty_base_vel_yaw = flag;
    is_dirty_odom_vel_x = flag;
    is_dirty_odom_vel_y = flag;
    is_dirty_odom_vel_z = flag;
    is_dirty_odom_vel_roll = flag;
    is_dirty_odom_vel_pitch = flag;
    is_dirty_odom_vel_yaw = flag;
    dirty_count = flag ? 18 : 0;
}

// read odom_x field
bool OdometryData6D::read_odom_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_x field
bool OdometryData6D::write_odom_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_x)) {
        return false;
    }
    return true;
}

// read (nested) odom_x field
bool OdometryData6D::nested_read_odom_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_x field
bool OdometryData6D::nested_write_odom_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_x)) {
        return false;
    }
    return true;
}

// read odom_y field
bool OdometryData6D::read_odom_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_y field
bool OdometryData6D::write_odom_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_y)) {
        return false;
    }
    return true;
}

// read (nested) odom_y field
bool OdometryData6D::nested_read_odom_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_y field
bool OdometryData6D::nested_write_odom_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_y)) {
        return false;
    }
    return true;
}

// read odom_z field
bool OdometryData6D::read_odom_z(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_z)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_z field
bool OdometryData6D::write_odom_z(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_z)) {
        return false;
    }
    return true;
}

// read (nested) odom_z field
bool OdometryData6D::nested_read_odom_z(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_z)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_z field
bool OdometryData6D::nested_write_odom_z(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_z)) {
        return false;
    }
    return true;
}

// read odom_roll field
bool OdometryData6D::read_odom_roll(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_roll)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_roll field
bool OdometryData6D::write_odom_roll(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_roll)) {
        return false;
    }
    return true;
}

// read (nested) odom_roll field
bool OdometryData6D::nested_read_odom_roll(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_roll)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_roll field
bool OdometryData6D::nested_write_odom_roll(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_roll)) {
        return false;
    }
    return true;
}

// read odom_pitch field
bool OdometryData6D::read_odom_pitch(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_pitch)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_pitch field
bool OdometryData6D::write_odom_pitch(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_pitch)) {
        return false;
    }
    return true;
}

// read (nested) odom_pitch field
bool OdometryData6D::nested_read_odom_pitch(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_pitch)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_pitch field
bool OdometryData6D::nested_write_odom_pitch(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_pitch)) {
        return false;
    }
    return true;
}

// read odom_yaw field
bool OdometryData6D::read_odom_yaw(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_yaw)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_yaw field
bool OdometryData6D::write_odom_yaw(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_yaw)) {
        return false;
    }
    return true;
}

// read (nested) odom_yaw field
bool OdometryData6D::nested_read_odom_yaw(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_yaw)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_yaw field
bool OdometryData6D::nested_write_odom_yaw(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_yaw)) {
        return false;
    }
    return true;
}

// read base_vel_x field
bool OdometryData6D::read_base_vel_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write base_vel_x field
bool OdometryData6D::write_base_vel_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_x)) {
        return false;
    }
    return true;
}

// read (nested) base_vel_x field
bool OdometryData6D::nested_read_base_vel_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) base_vel_x field
bool OdometryData6D::nested_write_base_vel_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_x)) {
        return false;
    }
    return true;
}

// read base_vel_y field
bool OdometryData6D::read_base_vel_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write base_vel_y field
bool OdometryData6D::write_base_vel_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_y)) {
        return false;
    }
    return true;
}

// read (nested) base_vel_y field
bool OdometryData6D::nested_read_base_vel_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) base_vel_y field
bool OdometryData6D::nested_write_base_vel_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_y)) {
        return false;
    }
    return true;
}

// read base_vel_z field
bool OdometryData6D::read_base_vel_z(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_z)) {
        reader.fail();
        return false;
    }
    return true;
}

// write base_vel_z field
bool OdometryData6D::write_base_vel_z(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_z)) {
        return false;
    }
    return true;
}

// read (nested) base_vel_z field
bool OdometryData6D::nested_read_base_vel_z(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_z)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) base_vel_z field
bool OdometryData6D::nested_write_base_vel_z(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_z)) {
        return false;
    }
    return true;
}

// read base_vel_roll field
bool OdometryData6D::read_base_vel_roll(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_roll)) {
        reader.fail();
        return false;
    }
    return true;
}

// write base_vel_roll field
bool OdometryData6D::write_base_vel_roll(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_roll)) {
        return false;
    }
    return true;
}

// read (nested) base_vel_roll field
bool OdometryData6D::nested_read_base_vel_roll(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_roll)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) base_vel_roll field
bool OdometryData6D::nested_write_base_vel_roll(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_roll)) {
        return false;
    }
    return true;
}

// read base_vel_pitch field
bool OdometryData6D::read_base_vel_pitch(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_pitch)) {
        reader.fail();
        return false;
    }
    return true;
}

// write base_vel_pitch field
bool OdometryData6D::write_base_vel_pitch(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_pitch)) {
        return false;
    }
    return true;
}

// read (nested) base_vel_pitch field
bool OdometryData6D::nested_read_base_vel_pitch(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_pitch)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) base_vel_pitch field
bool OdometryData6D::nested_write_base_vel_pitch(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_pitch)) {
        return false;
    }
    return true;
}

// read base_vel_yaw field
bool OdometryData6D::read_base_vel_yaw(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_yaw)) {
        reader.fail();
        return false;
    }
    return true;
}

// write base_vel_yaw field
bool OdometryData6D::write_base_vel_yaw(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_yaw)) {
        return false;
    }
    return true;
}

// read (nested) base_vel_yaw field
bool OdometryData6D::nested_read_base_vel_yaw(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(base_vel_yaw)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) base_vel_yaw field
bool OdometryData6D::nested_write_base_vel_yaw(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(base_vel_yaw)) {
        return false;
    }
    return true;
}

// read odom_vel_x field
bool OdometryData6D::read_odom_vel_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_vel_x field
bool OdometryData6D::write_odom_vel_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_x)) {
        return false;
    }
    return true;
}

// read (nested) odom_vel_x field
bool OdometryData6D::nested_read_odom_vel_x(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_x)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_vel_x field
bool OdometryData6D::nested_write_odom_vel_x(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_x)) {
        return false;
    }
    return true;
}

// read odom_vel_y field
bool OdometryData6D::read_odom_vel_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_vel_y field
bool OdometryData6D::write_odom_vel_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_y)) {
        return false;
    }
    return true;
}

// read (nested) odom_vel_y field
bool OdometryData6D::nested_read_odom_vel_y(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_y)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_vel_y field
bool OdometryData6D::nested_write_odom_vel_y(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_y)) {
        return false;
    }
    return true;
}

// read odom_vel_z field
bool OdometryData6D::read_odom_vel_z(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_z)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_vel_z field
bool OdometryData6D::write_odom_vel_z(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_z)) {
        return false;
    }
    return true;
}

// read (nested) odom_vel_z field
bool OdometryData6D::nested_read_odom_vel_z(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_z)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_vel_z field
bool OdometryData6D::nested_write_odom_vel_z(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_z)) {
        return false;
    }
    return true;
}

// read odom_vel_roll field
bool OdometryData6D::read_odom_vel_roll(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_roll)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_vel_roll field
bool OdometryData6D::write_odom_vel_roll(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_roll)) {
        return false;
    }
    return true;
}

// read (nested) odom_vel_roll field
bool OdometryData6D::nested_read_odom_vel_roll(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_roll)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_vel_roll field
bool OdometryData6D::nested_write_odom_vel_roll(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_roll)) {
        return false;
    }
    return true;
}

// read odom_vel_pitch field
bool OdometryData6D::read_odom_vel_pitch(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_pitch)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_vel_pitch field
bool OdometryData6D::write_odom_vel_pitch(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_pitch)) {
        return false;
    }
    return true;
}

// read (nested) odom_vel_pitch field
bool OdometryData6D::nested_read_odom_vel_pitch(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_pitch)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_vel_pitch field
bool OdometryData6D::nested_write_odom_vel_pitch(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_pitch)) {
        return false;
    }
    return true;
}

// read odom_vel_yaw field
bool OdometryData6D::read_odom_vel_yaw(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_yaw)) {
        reader.fail();
        return false;
    }
    return true;
}

// write odom_vel_yaw field
bool OdometryData6D::write_odom_vel_yaw(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_yaw)) {
        return false;
    }
    return true;
}

// read (nested) odom_vel_yaw field
bool OdometryData6D::nested_read_odom_vel_yaw(yarp::os::idl::WireReader& reader)
{
    if (reader.noMore()) {
        reader.fail();
        return false;
    }
    if (!reader.readFloat64(odom_vel_yaw)) {
        reader.fail();
        return false;
    }
    return true;
}

// write (nested) odom_vel_yaw field
bool OdometryData6D::nested_write_odom_vel_yaw(const yarp::os::idl::WireWriter& writer) const
{
    if (!writer.writeFloat64(odom_vel_yaw)) {
        return false;
    }
    return true;
}

} // namespace yarp::dev
