YARP 3.1.1 (2019-04-18)                                                {#v3_1_1}
=======================

[TOC]

YARP 3.1.1 Release Notes
========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v3.1.1%22).


New Features
------------

### Build System

* Added `YARP_DISABLE_VERSION_SOURCE` cmake variable to disable version source
  when building YARP. This is an useful option for developers, since it
  avoids rebuilding everything whenever the commit or the dirty state changes.
  Please disable this option when including YARP version in bugs reports.


Bug Fixes
---------

### CMake Modules

#### `YarpInstallationHelpers`

* Changed `/` in `\` path.d under Windows (#1513).


### Libraries

#### `YARP_OS`

* Fixed `write()` in BufferedPort after interrupting-resuming(#1834).
* Fixed assertion when `YARP_FORWARD_LOG_ENABLE=1` (#1851).
* Fixed `impl/PlatformSysStat.h` installation.
* Fixed Port from performing resume() operations if not interrupted(#1896).
* Fixes missing initialization value for Network Clock port

#### `YARP_dev`

* Fixed `IControlLimits.h` not being a self-sufficient header (#1845).
* Added missing `YARP_dev_API` to `IRobotDescription`.
* Made optional the view of `IFrameGrabberControls` in `RGBDSensorWrapper`
  (#1875).
* Fixed header inclusion in `ImplementControlLimits2.h`.
* Fixed interface pointer checks in ControlBoardWrapper.
* Added timeout check in all data streamed by `*\stateExt:o` ports (#1833).

#### `YARP_companion`

* Fixed `api.h` installation.

#### `YARP_sig`

* Fixed element contruction when calling `VectorOf<T>::push_back()`.
* Fixed build when ZFP is installed.
* Fixed possible buffer overrun in `PointCloudTypes`


### Tools

#### yarpidl_thrift

* Fixed serialisation / deserialisation of maps (#1802).


### Bindings

* Fixed usage of methods that take in input a yarp::sig::Vector in bindings
  (#1828).
* Disabled extended analog sensor interfaces in C# to allow compilation of these
  bindings (#1830).
* Added bindings for yarp::os::Wire and yarp::os::WireLink


### GUIs

#### `yarpdataplayer`

* Fixed memory leak when using `cvLoad(...)`.

### Devices

#### `RemoteControlBoard`

* Added `timeout` parameter.

#### `realsense2`

* Fixed `set/getDepthAccuracy` methods (#1877).

#### `ffmpeg`

* Fixed compilation on debian testing (#1849).

#### `imuBosch_BNO055`

* Fixed runtime linking issue.
* Fixed shifted read from i2c.

Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v3.1.0..v3.1.1`):

```
   113	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    33	Nicolò Genesio <nicolo.genesio@iit.it>
     8	Damiano Enerli <damiano.enerli@iit.it>
     7	Alberto Cardellino <alberto.cardellino@iit.it>
     6	Silvio Traversaro <silvio.traversaro@iit.it>
     3	Bartek Łukawski <bwmn.peter@gmail.com>
     3	Marco Randazzo <marco.randazzo@iit.it>
     2	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     2	Arren Glover <arren.glover@iit.it>
     2	Diego Ferigo <diego.ferigo@iit.it>
     2	Nuno Guedelha <nuno.guedelha@iit.it>
     2	Tobias Fischer <t.fischer@imperial.ac.uk>
     2	Ugo Pattacini <ugo.pattacini@iit.it>
     1	Claudio Fantacci <claudio.fantacci@iit.it>
     1	Matteo Brunettini <matteo.brunettini@iit.it>
     1	Mohamed Babiker Mohamed Elobaid <mohamed.elobaid@iit.it>
     1	Valentina Gaggero <valentina.gaggero@iit.it>
```
