(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     51013,       1475]
NotebookOptionsPosition[     45096,       1359]
NotebookOutlinePosition[     45520,       1376]
CellTagsIndexPosition[     45477,       1373]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Remember that the py-pde package uses a different order of the coordinates \
when defining the components! Mathematica uses (r, \[Theta],  z) while py-pde \
uses (r, z, \[CurlyPhi])\
\>", "Text",
 CellChangeTimes->{{3.836550901123584*^9, 
  3.8365509687358313`*^9}},ExpressionUUID->"650e2b65-43ea-4c05-9c82-\
7881d48a333b"],

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"EvaluationNotebook", "[", "]"}], ",", 
   RowBox[{"CellContext", "\[Rule]", "Notebook"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.83637182481455*^9, 3.836371824815637*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"6490e92c-354d-4b7d-bbda-9fa6bc118791"],

Cell[BoxData[
 RowBox[{"Import", "[", 
  "\"\<https://raw.githubusercontent.com/zwicker-group/MathematicaToPython/\
master/ToPython.wl\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.836371070591913*^9, 3.83637109729657*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"d8ccbffb-7fdc-4cd0-800f-608fd7fe2321"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cs", "=", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "z"}], "}"}]}], ";", 
  RowBox[{"css", "=", 
   RowBox[{"ToString", "/@", "cs"}]}]}]], "Input",
 CellChangeTimes->{{3.836369954315196*^9, 3.836369960763295*^9}, 
   3.8363718310778503`*^9, 3.836444302749177*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"27cf09c3-e0f9-44f9-9397-fc6f153aa1ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"r\"\>", ",", "\<\"\[Theta]\"\>", ",", "\<\"z\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8363699658626347`*^9, 3.8363700422911*^9, {3.836370976064389*^9, 
   3.8363709774311533`*^9}, 3.836371623652684*^9, {3.836371827054821*^9, 
   3.836371848038763*^9}, 3.836444304948358*^9, 3.83654340647231*^9, 
   3.836550790866767*^9, 3.837079737338674*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"b71541e2-3027-40f7-92b8-4ba8f9e6cdaf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar fields", "Section",
 CellChangeTimes->{{3.836371867491858*^9, 
  3.836371871207691*^9}},ExpressionUUID->"752a9a5b-318b-4b33-a799-\
2b60b3ff4b06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grad", "[", 
   RowBox[{
    RowBox[{"s", "[", 
     RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", "\"\<Cylindrical\>\""}], 
   "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8363699708374*^9, 3.836369985165965*^9}, 
   3.8363701599949017`*^9, 3.8363718394927673`*^9, {3.8364443223270197`*^9, 
   3.836444322466217*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"78c971c1-e81c-4e91-b5ae-b2af0866856f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"1", ",", "0"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"r", ",", "z"}], "]"}]},
      {"0"},
      {
       RowBox[{
        SuperscriptBox["s", 
         TagBox[
          RowBox[{"(", 
           RowBox[{"0", ",", "1"}], ")"}],
          Derivative],
         MultilineFunction->None], "[", 
        RowBox[{"r", ",", "z"}], "]"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.836369985555266*^9, {3.836370074172127*^9, 3.836370125015613*^9}, 
   3.836370160217512*^9, 3.8363709775676527`*^9, 3.836371625581029*^9, 
   3.8363718574480762`*^9, {3.836444309431652*^9, 3.836444322915578*^9}, 
   3.836543406561528*^9, 3.836550790897451*^9, 3.837079737368115*^9},
 CellLabel->
  "Out[13]//MatrixForm=",ExpressionUUID->"db21d36b-427f-4396-bb58-\
ec4b68ba8550"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gradSq", "=", 
  RowBox[{
   RowBox[{"Grad", "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", "\"\<Cylindrical\>\""}],
     "]"}], ".", 
   RowBox[{"Grad", "[", 
    RowBox[{
     RowBox[{"s", "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", "\"\<Cylindrical\>\""}],
     "]"}]}]}]], "Input",
 CellChangeTimes->{{3.836444314815589*^9, 3.836444328405328*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"6bb62075-6ada-4b45-8459-f4fc4e969959"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"r", ",", "z"}], "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"r", ",", "z"}], "]"}], "2"]}]], "Output",
 CellChangeTimes->{3.836444328661373*^9, 3.836543406606427*^9, 
  3.836550790921679*^9, 3.8370797373844423`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"38ce5f8e-6774-4a28-9642-39a4d7aee5cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", "\"\<Cylindrical\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8363701285502*^9, 3.836370135842626*^9}, 
   3.8363718395019627`*^9, {3.836444330307044*^9, 3.836444330361224*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"bb39561b-7268-4107-8e1d-157174194579"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "2"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"r", ",", "z"}], "]"}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["s", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"r", ",", "z"}], "]"}], "r"], "+", 
  RowBox[{
   SuperscriptBox["s", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"r", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{3.836370136147089*^9, 3.836370977648357*^9, 
  3.836371860450674*^9, 3.8364443306135473`*^9, 3.836543406664468*^9, 
  3.836550790941704*^9, 3.837079737400285*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"133b61e0-e911-4be1-8506-300fb0e410e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellChangeTimes->{{3.836372195143363*^9, 
  3.836372196929399*^9}},ExpressionUUID->"91dc8d72-9e93-4fef-a3df-\
0a4c6fc56c45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grad", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"r", "^", "3"}], "*", 
     RowBox[{"Sin", "[", "z", "]"}]}], ",", "cs", ",", 
    "\"\<Cylindrical\>\""}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.836372736942079*^9, 3.8363727375520687`*^9}, {
  3.836384485111569*^9, 3.836384487593574*^9}, {3.836444391351879*^9, 
  3.83644439726009*^9}, {3.836532606717073*^9, 3.8365326071546993`*^9}, {
  3.836533377083055*^9, 3.836533378475288*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"a148d1fa-7214-40cb-b03e-6c8540d61c48"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"3", " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]},
      {"0"},
      {
       RowBox[{
        SuperscriptBox["r", "3"], " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836372737877419*^9, 3.8363727472519484`*^9}, 
   3.836384489679385*^9, 3.836444398263541*^9, 3.836532607361257*^9, 
   3.836533378870757*^9, 3.836543406673356*^9, 3.836550790956851*^9, 
   3.837079737406027*^9},
 CellLabel->
  "Out[16]//MatrixForm=",ExpressionUUID->"876209f7-161e-45a0-95a7-\
d12d299b57b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gradSq", "/.", 
  RowBox[{"s", "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{"r", "^", "3"}], "*", 
      RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.836385485083066*^9, 3.8363854923616753`*^9}, {
  3.8364444031768503`*^9, 3.836444407403858*^9}, {3.836532610270146*^9, 
  3.836532610685955*^9}, {3.8365333810163918`*^9, 3.83653338279699*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"05c3377f-c85f-4244-868e-8fffdb435aae"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["r", "6"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "z", "]"}], "2"]}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["r", "4"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "z", "]"}], "2"]}]}]], "Output",
 CellChangeTimes->{3.836385492671417*^9, 3.836444409117015*^9, 
  3.8365326109369907`*^9, 3.8365333831061783`*^9, 3.836543406886921*^9, 
  3.836550790966255*^9, 3.8370797374218063`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"cc17514e-db6d-49e6-bfaa-af64628cdc93"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"r", "^", "3"}], "*", 
    RowBox[{"Sin", "[", "z", "]"}]}], ",", "cs", ",", "\"\<Cylindrical\>\""}],
   "]"}]], "Input",
 CellChangeTimes->{{3.836372200940014*^9, 3.836372212035387*^9}, {
  3.836372255314764*^9, 3.836372297833495*^9}, {3.836372347308304*^9, 
  3.836372377108037*^9}, {3.836372717497493*^9, 3.836372719180459*^9}, {
  3.836384496489346*^9, 3.8363844997025337`*^9}, {3.836444412057293*^9, 
  3.836444415729026*^9}, {3.8365325932700377`*^9, 3.836532593842709*^9}, {
  3.8365333844771357`*^9, 3.8365333861535263`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"f6a3537c-65d4-4711-9462-3626540bd6e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"9", " ", "r", " ", 
   RowBox[{"Sin", "[", "z", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["r", "3"], " ", 
   RowBox[{"Sin", "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.836372371116045*^9, 3.8363723774457197`*^9}, {
   3.836372719634886*^9, 3.8363727477739887`*^9}, 3.8363845001150227`*^9, 
   3.8364444162053757`*^9, 3.836532594335144*^9, 3.8365333864081306`*^9, 
   3.8365434069426737`*^9, 3.836550790981483*^9, 3.837079737440585*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"bf3ee482-c839-40ae-851c-15393b0b9315"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector fields", "Section",
 CellChangeTimes->{{3.836371875544259*^9, 
  3.83637187964915*^9}},ExpressionUUID->"10a6a951-c2ec-4510-9025-\
b114352779c7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vec", "[", 
   RowBox[{"r_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"f", ",", "i"}], "]"}], "[", 
     RowBox[{"r", ",", "z"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "css"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"vec", "[", 
  RowBox[{"r", ",", "z"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8363699901621637`*^9, 3.836370104025691*^9}, {
  3.836444333482431*^9, 3.8364443378693123`*^9}, {3.836548719072796*^9, 
  3.836548720829526*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"a8d2c5cb-fb65-4db0-8825-4b0e42b073d2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "[", 
    RowBox[{"r", ",", "z"}], "]"}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"\[Theta]\"\>"], "[", 
    RowBox[{"r", ",", "z"}], "]"}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"z\"\>"], "[", 
    RowBox[{"r", ",", "z"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.836370104413557*^9, 3.836370977514279*^9, 
  3.836371624654104*^9, 3.836371850274251*^9, 3.836371891488089*^9, 
  3.836444338210415*^9, 3.836543406951395*^9, 3.83654872244847*^9, 
  3.836548864580715*^9, 3.836550790987589*^9, 3.837079737446371*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"88d0c5aa-3430-4abe-8ca5-1a7a28d79e72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecDiv", "=", 
  RowBox[{"FullSimplify", "@", 
   RowBox[{"Div", "[", 
    RowBox[{
     RowBox[{"vec", "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", "\"\<Cylindrical\>\""}],
     "]"}]}]}]], "Input",
 CellChangeTimes->{{3.836369987083974*^9, 3.836369988094116*^9}, {
   3.836370077016363*^9, 3.836370081951086*^9}, {3.836371637099867*^9, 
   3.836371641271962*^9}, 3.8363718394976807`*^9, {3.8364443409514093`*^9, 
   3.8364443433218327`*^9}, {3.836444482907802*^9, 3.836444485794238*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"34922ada-c7b6-4ba1-8293-d801a26bbd09"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "[", 
    RowBox[{"r", ",", "z"}], "]"}], "r"], "+", 
  RowBox[{
   SuperscriptBox[
    SubscriptBox["f", "\<\"z\"\>"], 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "1"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"r", ",", "z"}], "]"}], "+", 
  RowBox[{
   SuperscriptBox[
    SubscriptBox["f", "\<\"r\"\>"], 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{"r", ",", "z"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.8363700821985693`*^9, 3.836370125387701*^9}, 
   3.836370977609374*^9, {3.83637162606951*^9, 3.8363716415076847`*^9}, 
   3.8363718590892973`*^9, 3.836371892137411*^9, {3.836444341396282*^9, 
   3.8364443435950108`*^9}, 3.83644448622211*^9, 3.8365434070061703`*^9, 
   3.836548865050107*^9, 3.836550791017046*^9, 3.837079737494597*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"ed50346a-6e54-4287-beb9-51eeb0c30350"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"vecLap", "=", 
    RowBox[{"FullSimplify", "@", 
     RowBox[{"Laplacian", "[", 
      RowBox[{
       RowBox[{"vec", "[", 
        RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", 
       "\"\<Cylindrical\>\""}], "]"}]}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.836547022486969*^9, 3.836547023346229*^9}, {
  3.836547057488023*^9, 3.836547062444078*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"77c6adae-599f-433e-bcb6-28f28897e69c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"r\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SubscriptBox["f", "\<\"r\"\>"], "[", 
            RowBox[{"r", ",", "z"}], "]"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{
            SuperscriptBox[
             SubscriptBox["f", "\<\"r\"\>"], 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"r", ",", "z"}], "]"}]}]}], 
         SuperscriptBox["r", "2"]], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"r\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}]}]},
      {
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"\[Theta]\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            SubscriptBox["f", "\<\"\[Theta]\"\>"], "[", 
            RowBox[{"r", ",", "z"}], "]"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{
            SuperscriptBox[
             SubscriptBox["f", "\<\"\[Theta]\"\>"], 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"r", ",", "z"}], "]"}]}]}], 
         SuperscriptBox["r", "2"]], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"\[Theta]\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}]}]},
      {
       RowBox[{
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"z\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           SubscriptBox["f", "\<\"z\"\>"], 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"r", ",", "z"}], "]"}], "r"], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"z\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"2", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836547019682592*^9, 3.8365470234339523`*^9}, 
   3.836547062682592*^9, 3.836548865519792*^9, 3.8365507911310062`*^9, 
   3.837079737607842*^9},
 CellLabel->
  "Out[22]//MatrixForm=",ExpressionUUID->"2f356f35-ad7d-40b9-890d-\
7d1dd914b2cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"vecLap", "\[Equal]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Laplacian", "[", 
      RowBox[{"v", ",", "cs", ",", "\"\<Cylindrical\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"vec", "[", 
        RowBox[{"r", ",", "z"}], "]"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.83654696165478*^9, 3.836547014735557*^9}, {
  3.836547065799234*^9, 3.836547066877986*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"28f224d4-dd95-42af-a11f-4808ebfbd1a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SubscriptBox["f", "\<\"r\"\>"], "[", 
       RowBox[{"r", ",", "z"}], "]"}], 
      SuperscriptBox["r", "2"]]}], ",", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SubscriptBox["f", "\<\"\[Theta]\"\>"], "[", 
       RowBox[{"r", ",", "z"}], "]"}], 
      SuperscriptBox["r", "2"]]}], ",", "0"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]], "Output",
 CellChangeTimes->{{3.8365469693560123`*^9, 3.836546973034019*^9}, 
   3.836547003754612*^9, 3.836547067210589*^9, 3.836548866007945*^9, 
   3.836550791173235*^9, 3.837079737642776*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"5ee3154f-e5b4-4425-8537-84cdcb91c12e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"vecGrad", "=", 
    RowBox[{"Grad", "[", 
     RowBox[{
      RowBox[{"vec", "[", 
       RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", 
      "\"\<Cylindrical\>\""}], "]"}]}], ")"}], "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.8363701383494577`*^9, 3.836370150533133*^9}, 
   3.8363718395052567`*^9, {3.8364443456597223`*^9, 3.836444345705119*^9}, {
   3.8364444883715963`*^9, 3.8364444912115173`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"59e9d153-6012-44b9-8592-f5d31e6a3597"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"r\"\>"], 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "z"}], "]"}], 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SubscriptBox["f", "\<\"\[Theta]\"\>"], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "r"]}], 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"r\"\>"], 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "z"}], "]"}]},
     {
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"\[Theta]\"\>"], 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "z"}], "]"}], 
      FractionBox[
       RowBox[{
        SubscriptBox["f", "\<\"r\"\>"], "[", 
        RowBox[{"r", ",", "z"}], "]"}], "r"], 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"\[Theta]\"\>"], 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "z"}], "]"}]},
     {
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"z\"\>"], 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "z"}], "]"}], "0", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["f", "\<\"z\"\>"], 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"r", ",", "z"}], "]"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8363701470255013`*^9, 3.836370150682934*^9}, 
   3.836370977688388*^9, 3.836371892734676*^9, 3.836444346010643*^9, 
   3.836444491486013*^9, 3.836543407067046*^9, 3.836548866457506*^9, 
   3.836550791191782*^9, 3.837079737662691*^9},
 CellLabel->
  "Out[24]//MatrixForm=",ExpressionUUID->"0dc2ae95-4612-4cf9-b62c-\
b6ba95379bf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellChangeTimes->{{3.836372195143363*^9, 
  3.836372196929399*^9}},ExpressionUUID->"35125b05-6e69-419b-bdbe-\
04e7b4cd477b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecRepl", "=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "\"\<r\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "z"}], "}"}], ",", 
       RowBox[{
        RowBox[{"r", "^", "3"}], "*", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     SubscriptBox["f", "\"\<\[Theta]\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "z"}], "}"}], ",", 
       RowBox[{
        RowBox[{"r", "^", "2"}], "*", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     SubscriptBox["f", "\"\<z\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "z"}], "}"}], ",", 
       RowBox[{
        RowBox[{"r", "^", "4"}], "*", 
        RowBox[{"Cos", "[", "z", "]"}]}]}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.836372390000723*^9, 3.836372550681477*^9}, {
   3.836372711766611*^9, 3.836372745637924*^9}, {3.836384885223749*^9, 
   3.8363848933245687`*^9}, {3.836386618598819*^9, 3.836386655647317*^9}, {
   3.836444437318962*^9, 3.8364444656587763`*^9}, 3.83644450499084*^9, {
   3.836533241742188*^9, 3.83653324888227*^9}, {3.83653331389948*^9, 
   3.836533323021142*^9}, {3.836542805106461*^9, 3.836542808896599*^9}, {
   3.836543730400292*^9, 3.836543733956311*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"776c6622-5b11-44b0-8a04-a7e4f663fd3a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "z"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"\[Theta]\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "z"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"z\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "z"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       RowBox[{"Cos", "[", "z", "]"}]}]}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8365430151642447`*^9, 3.836543022187851*^9}, {
   3.83654339505094*^9, 3.8365434070772457`*^9}, {3.8365437325512733`*^9, 
   3.836543734165649*^9}, 3.836547546762577*^9, 3.836548867248398*^9, 
   3.836550791201247*^9, 3.837079737670052*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"ecafe414-da54-4edc-8562-f82654665f5c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecDiv", "/.", "vecRepl"}]], "Input",
 CellChangeTimes->{{3.836384935880455*^9, 3.836384939063075*^9}, {
  3.836444476950574*^9, 3.8364444774804907`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"6ee32a86-c11c-4f0a-9fee-f08df6cdf9b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["r", "2"], " ", 
   RowBox[{"Sin", "[", "z", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["r", "4"], " ", 
   RowBox[{"Sin", "[", "z", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.836384939308898*^9, 3.836386657877061*^9, 3.8363867144385223`*^9, {
   3.836444477766951*^9, 3.836444506251142*^9}, 3.836533250239242*^9, 
   3.83653332481563*^9, {3.836543012902286*^9, 3.8365430236496363`*^9}, {
   3.836543395718783*^9, 3.836543407131234*^9}, 3.836543735587865*^9, 
   3.836547547350878*^9, 3.836548868025853*^9, 3.836550791221023*^9, 
   3.837079737689455*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"9faf6fa1-233a-4993-873e-b9fb887b6d66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecRepl", "=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "\"\<r\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "z"}], "}"}], ",", 
       RowBox[{
        RowBox[{"r", "^", "3"}], "*", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     SubscriptBox["f", "\"\<\[Theta]\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "z"}], "}"}], ",", 
       RowBox[{
        RowBox[{"r", "^", "3"}], "*", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     SubscriptBox["f", "\"\<z\>\""], "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "z"}], "}"}], ",", 
       RowBox[{
        RowBox[{"r", "^", "3"}], "*", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.836372390000723*^9, 3.836372550681477*^9}, {
   3.836372711766611*^9, 3.836372745637924*^9}, {3.836384885223749*^9, 
   3.8363848933245687`*^9}, {3.836386618598819*^9, 3.836386655647317*^9}, {
   3.836444437318962*^9, 3.8364444656587763`*^9}, 3.83644450499084*^9, {
   3.836533241742188*^9, 3.83653324888227*^9}, {3.83653331389948*^9, 
   3.836533323021142*^9}, {3.836542805106461*^9, 3.836542808896599*^9}, {
   3.836543730400292*^9, 3.836543733956311*^9}, {3.836544290709469*^9, 
   3.836544292127389*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"619da92c-fde4-4ff2-8a98-d5937c505f10"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["f", "\<\"r\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "z"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"\[Theta]\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "z"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}], ",", 
   RowBox[{
    SubscriptBox["f", "\<\"z\"\>"], "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "z"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.836547685037149*^9, 3.836548868515094*^9, 
  3.8365507912313967`*^9, 3.837079737695525*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"1b5148df-31b4-4a8f-bafa-bb1e1ff461c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"vecLap", "/.", "vecRepl"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.836547548096434*^9, 3.836547552854141*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"cda2d3d7-d55b-4e36-b38a-6aa7999957bb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"8", " ", "r", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{"8", " ", "r", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{"9", " ", "r", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}], "-", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"Sin", "[", "z", "]"}]}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836547549622942*^9, 3.836547553011126*^9}, 
   3.8365476859190493`*^9, 3.83654886923175*^9, 3.8365507912479486`*^9, 
   3.83707973771453*^9},
 CellLabel->
  "Out[28]//MatrixForm=",ExpressionUUID->"372a5297-6bdc-4173-8406-\
59b28a343c29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"vecGrad", "/.", "vecRepl"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.8363849434963617`*^9, 3.836384949601533*^9}, {
  3.836444510073618*^9, 3.8364445105442867`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"47ef04bd-c87c-42e5-b9ba-69d029d87127"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"3", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["r", "2"]}], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Cos", "[", "z", "]"}]}]},
     {
      RowBox[{"3", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Cos", "[", "z", "]"}]}]},
     {
      RowBox[{"3", " ", 
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "0", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       RowBox[{"Cos", "[", "z", "]"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836384945449993*^9, 3.836384949826185*^9}, 
   3.836386658661292*^9, 3.836386714750093*^9, {3.836444494909408*^9, 
   3.836444510768249*^9}, 3.836533251282049*^9, 3.836533325295681*^9, {
   3.836543013424139*^9, 3.8365430245472813`*^9}, 3.836543407185042*^9, 
   3.836543736190178*^9, 3.8365442934712477`*^9, 3.8365476879030046`*^9, 
   3.836550791271933*^9, 3.837079737741893*^9},
 CellLabel->
  "Out[29]//MatrixForm=",ExpressionUUID->"a99588ec-e437-4260-aed6-\
41025a2562e6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tensor fields", "Section",
 CellChangeTimes->{{3.836371885306631*^9, 
  3.836371888891665*^9}},ExpressionUUID->"9146df12-be82-41bb-8649-\
212b7f936243"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ten", "[", 
   RowBox[{"r_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"f", ",", 
       RowBox[{"i", "<>", "j"}]}], "]"}], "[", 
     RowBox[{"r", ",", "z"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "css"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "css"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ten", "[", 
  RowBox[{"r", ",", "z"}], "]"}]}], "Input",
 CellChangeTimes->{{3.83637010952188*^9, 3.836370119247219*^9}, {
  3.8364443509322243`*^9, 3.836444369091947*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"16d8340c-be44-464c-a026-527051e116ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "\<\"rr\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", 
     RowBox[{
      SubscriptBox["f", "\<\"r\[Theta]\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", 
     RowBox[{
      SubscriptBox["f", "\<\"rz\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "\<\"\[Theta]r\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", 
     RowBox[{
      SubscriptBox["f", "\<\"\[Theta]\[Theta]\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", 
     RowBox[{
      SubscriptBox["f", "\<\"\[Theta]z\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "\<\"zr\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", 
     RowBox[{
      SubscriptBox["f", "\<\"z\[Theta]\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}], ",", 
     RowBox[{
      SubscriptBox["f", "\<\"zz\"\>"], "[", 
      RowBox[{"r", ",", "z"}], "]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.836370120606689*^9, 3.836370977520944*^9, 3.836371625092572*^9, 
   3.836371852112905*^9, 3.836371894867639*^9, {3.83644435828708*^9, 
   3.836444369341807*^9}, 3.836444528969818*^9, 3.836543407192951*^9, 
   3.8365507912825527`*^9, 3.837079737748011*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"5c12f5a0-9a1e-4d8c-9c93-182e66696126"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"tenDiv", "=", 
    RowBox[{"FullSimplify", "@", 
     RowBox[{"Div", "[", 
      RowBox[{
       RowBox[{"ten", "[", 
        RowBox[{"r", ",", "z"}], "]"}], ",", "cs", ",", 
       "\"\<Cylindrical\>\""}], "]"}]}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8363701665733557`*^9, 3.836370178993874*^9}, {
   3.836370247943989*^9, 3.836370249907168*^9}, {3.836370836040866*^9, 
   3.836370858626197*^9}, 3.836371839508522*^9, {3.836444371365603*^9, 
   3.836444371480999*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"9a0a1130-fd4d-44f0-b2cc-825134f49813"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{
           SubscriptBox["f", "\<\"rr\"\>"], "[", 
           RowBox[{"r", ",", "z"}], "]"}], "-", 
          RowBox[{
           SubscriptBox["f", "\<\"\[Theta]\[Theta]\"\>"], "[", 
           RowBox[{"r", ",", "z"}], "]"}]}], "r"], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"rz\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"rr\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{
           SubscriptBox["f", "\<\"r\[Theta]\"\>"], "[", 
           RowBox[{"r", ",", "z"}], "]"}], "+", 
          RowBox[{
           SubscriptBox["f", "\<\"\[Theta]r\"\>"], "[", 
           RowBox[{"r", ",", "z"}], "]"}]}], "r"], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"\[Theta]z\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"\[Theta]r\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          SubscriptBox["f", "\<\"zr\"\>"], "[", 
          RowBox[{"r", ",", "z"}], "]"}], "r"], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"zz\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "1"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}], "+", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["f", "\<\"zr\"\>"], 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"r", ",", "z"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836370173124909*^9, 3.83637017920778*^9}, 
   3.836370250978726*^9, {3.836370838524267*^9, 3.836370858886882*^9}, 
   3.8363709777313013`*^9, 3.836371895480771*^9, 3.836444371912244*^9, 
   3.836444531331296*^9, 3.836543407285304*^9, 3.836550791375662*^9, 
   3.837079737817741*^9},
 CellLabel->
  "Out[32]//MatrixForm=",ExpressionUUID->"cbb40e83-c791-42d2-b0fd-\
25eadb2ed26e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
 CellChangeTimes->{{3.836372195143363*^9, 
  3.836372196929399*^9}},ExpressionUUID->"7b07b0e8-0e7a-4ff0-bf23-\
7c95e2df6b97"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tenRepl", "=", 
   RowBox[{"Flatten", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "=", "i"}], ",", 
          RowBox[{"j", "=", "j"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Subscript", "[", 
          RowBox[{"f", ",", 
           RowBox[{
            RowBox[{"css", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "<>", 
            RowBox[{"css", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}]}], "]"}], "\[RuleDelayed]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"r", ",", "z"}], "}"}], ",", 
           RowBox[{
            RowBox[{"r", "^", "3"}], "*", 
            RowBox[{"Sin", "[", "z", "]"}]}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.836372390000723*^9, 3.836372550681477*^9}, {
  3.836372711766611*^9, 3.836372745637924*^9}, {3.836444541062179*^9, 
  3.836444567196067*^9}, {3.8364446023557873`*^9, 3.836444619789522*^9}, {
  3.836444692861246*^9, 3.836444742742708*^9}, {3.836546451093486*^9, 
  3.8365464568297987`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"68cbb6ff-6206-4d10-99fe-8d37028c2063"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"tenDiv", "/.", "tenRepl"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellChangeTimes->{{3.836372200940014*^9, 3.836372212035387*^9}, {
  3.836372255314764*^9, 3.836372297833495*^9}, {3.836372347308304*^9, 
  3.836372377108037*^9}, {3.836372717497493*^9, 3.836372719180459*^9}, {
  3.836444554159276*^9, 3.83644455545781*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"298785ef-d682-4aef-bf43-97774a37b751"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "z", "]"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "z", "]"}]}], "+", 
          RowBox[{"5", " ", 
           RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"r", " ", 
           RowBox[{"Cos", "[", "z", "]"}]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.836372371116045*^9, 3.8363723774457197`*^9}, {
   3.836372719634886*^9, 3.8363727477739887`*^9}, 3.836388251805581*^9, {
   3.8364445519469852`*^9, 3.8364445680471087`*^9}, 3.836444624003525*^9, {
   3.8364447247222853`*^9, 3.836444744211628*^9}, 3.836543407352449*^9, 
   3.83654645804513*^9, 3.8365507914335012`*^9, 3.8370797378581743`*^9},
 CellLabel->
  "Out[34]//MatrixForm=",ExpressionUUID->"8dbf50cc-3540-46dd-83a1-\
089738323709"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1680, 1005},
WindowMargins->{{-490, Automatic}, {Automatic, -1050}},
CellContext->Notebook,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 13, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"4e03a47a-5eca-47fc-8b50-7b0256346c88"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 333, 7, 35, "Text",ExpressionUUID->"650e2b65-43ea-4c05-9c82-7881d48a333b"],
Cell[894, 29, 318, 6, 30, "Input",ExpressionUUID->"6490e92c-354d-4b7d-bbda-9fa6bc118791"],
Cell[1215, 37, 301, 5, 30, "Input",ExpressionUUID->"d8ccbffb-7fdc-4cd0-800f-608fd7fe2321"],
Cell[CellGroupData[{
Cell[1541, 46, 392, 9, 30, "Input",ExpressionUUID->"27cf09c3-e0f9-44f9-9397-fc6f153aa1ac"],
Cell[1936, 57, 478, 9, 34, "Output",ExpressionUUID->"b71541e2-3027-40f7-92b8-4ba8f9e6cdaf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2451, 71, 158, 3, 67, "Section",ExpressionUUID->"752a9a5b-318b-4b33-a799-2b60b3ff4b06"],
Cell[CellGroupData[{
Cell[2634, 78, 450, 10, 30, "Input",ExpressionUUID->"78c971c1-e81c-4e91-b5ae-b2af0866856f"],
Cell[3087, 90, 1396, 42, 82, "Output",ExpressionUUID->"db21d36b-427f-4396-bb58-ec4b68ba8550"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4520, 137, 520, 14, 30, "Input",ExpressionUUID->"6bb62075-6ada-4b45-8459-f4fc4e969959"],
Cell[5043, 153, 684, 22, 34, "Output",ExpressionUUID->"38ce5f8e-6774-4a28-9642-39a4d7aee5cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5764, 180, 388, 8, 30, "Input",ExpressionUUID->"bb39561b-7268-4107-8e1d-157174194579"],
Cell[6155, 190, 917, 30, 53, "Output",ExpressionUUID->"133b61e0-e911-4be1-8506-300fb0e410e0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7109, 225, 155, 3, 54, "Subsection",ExpressionUUID->"91dc8d72-9e93-4fef-a3df-0a4c6fc56c45"],
Cell[CellGroupData[{
Cell[7289, 232, 573, 12, 30, "Input",ExpressionUUID->"a148d1fa-7214-40cb-b03e-6c8540d61c48"],
Cell[7865, 246, 1063, 31, 82, "Output",ExpressionUUID->"876209f7-161e-45a0-95a7-d12d299b57b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8965, 282, 579, 13, 30, "Input",ExpressionUUID->"05c3377f-c85f-4244-868e-8fffdb435aae"],
Cell[9547, 297, 535, 13, 34, "Output",ExpressionUUID->"cc17514e-db6d-49e6-bfaa-af64628cdc93"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10119, 315, 688, 13, 30, "Input",ExpressionUUID->"f6a3537c-65d4-4711-9462-3626540bd6e3"],
Cell[10810, 330, 562, 11, 34, "Output",ExpressionUUID->"bf3ee482-c839-40ae-851c-15393b0b9315"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11433, 348, 157, 3, 67, "Section",ExpressionUUID->"10a6a951-c2ec-4510-9025-b114352779c7"],
Cell[CellGroupData[{
Cell[11615, 355, 666, 17, 52, "Input",ExpressionUUID->"a8d2c5cb-fb65-4db0-8825-4b0e42b073d2"],
Cell[12284, 374, 697, 16, 36, "Output",ExpressionUUID->"88d0c5aa-3430-4abe-8ca5-1a7a28d79e72"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13018, 395, 607, 12, 30, "Input",ExpressionUUID->"34922ada-c7b6-4ba1-8293-d801a26bbd09"],
Cell[13628, 409, 1046, 29, 51, "Output",ExpressionUUID->"ed50346a-6e54-4287-beb9-51eeb0c30350"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14711, 443, 511, 13, 30, "Input",ExpressionUUID->"77c6adae-599f-433e-bcb6-28f28897e69c"],
Cell[15225, 458, 4014, 125, 122, "Output",ExpressionUUID->"2f356f35-ad7d-40b9-890d-7d1dd914b2cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19276, 588, 563, 13, 30, "Input",ExpressionUUID->"28f224d4-dd95-42af-a11f-4808ebfbd1a9"],
Cell[19842, 603, 777, 21, 53, "Output",ExpressionUUID->"5ee3154f-e5b4-4425-8537-84cdcb91c12e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20656, 629, 548, 13, 30, "Input",ExpressionUUID->"59e9d153-6012-44b9-8592-f5d31e6a3597"],
Cell[21207, 644, 2701, 86, 102, "Output",ExpressionUUID->"0dc2ae95-4612-4cf9-b62c-b6ba95379bf3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23945, 735, 155, 3, 54, "Subsection",ExpressionUUID->"35125b05-6e69-419b-bdbe-04e7b4cd477b"],
Cell[CellGroupData[{
Cell[24125, 742, 1595, 40, 94, "Input",ExpressionUUID->"776c6622-5b11-44b0-8a04-a7e4f663fd3a"],
Cell[25723, 784, 1245, 34, 37, "Output",ExpressionUUID->"ecafe414-da54-4edc-8562-f82654665f5c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27005, 823, 257, 4, 30, "Input",ExpressionUUID->"6ee32a86-c11c-4f0a-9fee-f08df6cdf9b6"],
Cell[27265, 829, 701, 15, 34, "Output",ExpressionUUID->"9faf6fa1-233a-4993-873e-b9fb887b6d66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28003, 849, 1645, 41, 94, "Input",ExpressionUUID->"619da92c-fde4-4ff2-8a98-d5937c505f10"],
Cell[29651, 892, 1095, 32, 37, "Output",ExpressionUUID->"1b5148df-31b4-4a8f-bafa-bb1e1ff461c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30783, 929, 239, 4, 30, "Input",ExpressionUUID->"cda2d3d7-d55b-4e36-b38a-6aa7999957bb"],
Cell[31025, 935, 1398, 42, 86, "Output",ExpressionUUID->"372a5297-6bdc-4173-8406-59b28a343c29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32460, 982, 335, 7, 30, "Input",ExpressionUUID->"47ef04bd-c87c-42e5-b9ba-69d029d87127"],
Cell[32798, 991, 1796, 50, 86, "Output",ExpressionUUID->"a99588ec-e437-4260-aed6-41025a2562e6"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34655, 1048, 158, 3, 67, "Section",ExpressionUUID->"9146df12-be82-41bb-8649-212b7f936243"],
Cell[CellGroupData[{
Cell[34838, 1055, 706, 19, 52, "Input",ExpressionUUID->"16d8340c-be44-464c-a026-527051e116ac"],
Cell[35547, 1076, 1498, 41, 36, "Output",ExpressionUUID->"5c12f5a0-9a1e-4d8c-9c93-182e66696126"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37082, 1122, 630, 15, 30, "Input",ExpressionUUID->"9a0a1130-fd4d-44f0-b2cc-825134f49813"],
Cell[37715, 1139, 3426, 103, 112, "Output",ExpressionUUID->"cbb40e83-c791-42d2-b0fd-25eadb2ed26e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41178, 1247, 155, 3, 54, "Subsection",ExpressionUUID->"7b07b0e8-0e7a-4ff0-bf23-7c95e2df6b97"],
Cell[41336, 1252, 1452, 37, 73, "Input",ExpressionUUID->"68cbb6ff-6206-4d10-99fe-8d37028c2063"],
Cell[CellGroupData[{
Cell[42813, 1293, 473, 9, 30, "Input",ExpressionUUID->"298785ef-d682-4aef-bf43-97774a37b751"],
Cell[43289, 1304, 1767, 50, 86, "Output",ExpressionUUID->"8dbf50cc-3540-46dd-83a1-089738323709"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

