# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ec2pricing']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.18.40,<2.0.0', 'click>=8.0.1,<9.0.0', 'prettytable>=2.2.0,<3.0.0']

entry_points = \
{'console_scripts': ['ec2pricing = ec2pricing:cli']}

setup_kwargs = {
    'name': 'aws-ec2-pricing',
    'version': '0.1.10',
    'description': 'CLI tool to build SQLite table from AWS EC2 prices.',
    'long_description': '# aws-ec2-pricing\n\n![Table of AWS EC2 prices in SQL](/docs/example-query.png)\n\nCollect AWS EC2 prices from AWS API to SQL table to analyze them.\n\n<a href="https://pypi.org/project/aws-ec2-pricing/"><img alt="PyPI" src="https://img.shields.io/pypi/v/aws-ec2-pricing?logo=pypi&color=blue"></a>\n\n**Table of contents**:\n\n* <a href="#usage">Usage</a>\n  * <a href="#download">download</a>\n  * <a href="#build">build</a>\n* <a href="#installation">Installation</a>\n* <a href="#working">Working with data</a>\n  * <a href="#table">Table columns and meaning</a>\n  * <a href="#queries">How to run queries</a>\n* <a href="#limitations">Limitations</a>\n* <a href="#future">Future plans</a>\n\n<a id="usage"></a>\n\n## Usage\n\nMake sure AWS credentials are set as environment variables or are available otherwise to `boto3` library\nwhich this program uses to connect to AWS API.\n\n```shell\nUsage: ec2pricing [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --version  Show the version and exit.\n  --help     Show this message and exit.\n\nCommands:\n  build     Build SQLite database with prices from given JSON\n  download  Download EC2 prices to JSON file\n```\n\n<a id="download"></a>\nDownload all "On Demand" prices for all regions for "Shared" instances into a JSON file.\n\n\n```shell\nec2pricing download\n```\n\n<a id="build"></a>\nBuild a SQLite database from that JSON file.\n\n*You can see an example of built database in `examples/prices.db` file in this repo.*\n\n```shell\nec2pricing build\n```\n\n<a id="working"></a>\n\nThe resulting file is a SQLite database with a single `prices` table in it.\n\n<a id="table"></a>\nResulting table `prices` in the `prices.db` file has following columns:\n\n<table>\n    <tr><th>Name</th><th>Description</th><th>Examples</th></tr>\n    <tr><td><b>family</b></td><td>Instace family</td><td>General purpose, Compute optimized</td></tr>\n    <tr><td><b>type</b></td><td>Instace type group</td><td>a1, t3a, c5</td></tr>\n    <tr><td><b>size</b></td><td>Instace size</td><td>nano, micro, xlarge, 32xlarge</td></tr>\n    <tr><td>burst</td><td>Is instance burstable?</td><td>Yes, No</td></tr>\n    <tr><td>base</td><td>Baseline performance of CPU (%)</td><td>5, 10, 100</td></tr>\n    <tr><td>processor</td><td>Name of the physical CPU</td><td>AWS Graviton, AMD EPYC</td></tr>\n    <tr><td>bit</td><td>CPU bitness</td><td>32-bit, 64-bit</td></tr>\n    <tr><td><b>arch</b></td><td>CPU architecture</td><td>arm, x86</td></tr>\n    <tr><td>tenancy</td><td>Instance tenancy</td><td>Shared, Dedicated, Host</td></tr>\n    <tr><td><b>region</b></td><td>AWS Region</td><td>US East (Ohio), EU (Ireland)</td></tr>\n    <tr><td><b>vcpu</b></td><td>Number of virtual cores</td><td>1, 2, 32</td></tr>\n    <tr><td><b>memory</b></td><td>Amount of RAM</td><td>0.5 GiB, 128 GiB</td></tr>\n    <tr><td>storage</td><td>Storage type</td><td>EBS only, 1x60GB NVM</td></tr>\n    <tr><td>os</td><td>Operating System</td><td>Linux</td></tr>\n    <tr><td>norm</td><td>Normalization scale factor (used by AWS to compare instances)</td><td>0.5, 1.0, 8.0</td></tr>\n    <tr><td>speed</td><td>Declared CPU clock speed</td><td>2.5 GHz, Up to 3.2 Ghz. 0 GHz</td></tr>\n    <tr><td><b>actual</b></td><td>Actual CPU clock speed multiplied by baseline</td><td>0.125 GHz, 2.5 Ghz</td></tr>\n    <tr><td>network</td><td>Network performance</td><td>Up to 3500 MiB</td></tr>\n    <tr><td>gen</td><td>Is it current generation of instances?</td><td>Yes, No</td></tr>\n    <tr><td>cur</td><td>Price currency</td><td>USD, CNY</td></tr>\n    <tr><td><b>hourly</b></td><td>Hourly price</td><td>0.0255</td></tr>\n    <tr><td><b>montly</b></td><td>Monthly price (hourly * 24 * 30)</td><td>3.844</td></tr>\n    <tr><td>starting</td><td>Date from which Amazon offers this price</td><td>2021-09-01T00:00:00Z</td></tr>\n\n</table>\n\n<a id="queries"></a>\nThe built database can be opened in any SQL IDE, for example, DBeaver (open source SQL editor) or in any other way.\nYou can then run queries in it.\n\n**Show cheapest x86-64 virtual machines**:\n\n```sql\nSELECT * FROM prices WHERE arch = \'x86\'\n ORDER BY monthly;\n```\n\n**Show cheapest ARM machines in Ireland**:\n\n```sql\nSELECT * FROM prices\n WHERE arch = \'arm\' AND region = "EU (Ireland)"\n ORDER BY monthly;\n```\n\n**Sort all machines alpabetically by their family, type and power**:\n\n```sql\nSELECT * FROM prices\n ORDER BY family, type, norm;\n```\n\n<a id="limitations"></a>\n\n## Limitations\n\nCurrently, downloaded prices are limited to instances with:\n\n* "Shared" tenancy\n* "Linux" operating system\n* Support for VPC networking\n* Only "On Demand" pricing, no reserved instances or saving plans\n* "Used" capacity reservation\n\nAll these are default settings for EC2 instances when you check prices for them on AWS pricng website.\n\n<a id="installation"></a>\n\n## Installation\n\nThis program is written in Python and can be installed via `pip`.\n\n```shell\npip install aws-ec2-pricing\n```\n\n## Build it and run it yourself\n\n### Set up via pip and virtual environemnt\n\n* Create a virtual environment\n\n  ```shell\n  python3 -m venv .venv\n  source ./.venv/bin/activate\n  ```\n\n* Install requirements into it\n\n  ```shell\n  pip install -r requirements.txt\n  ```\n\n* Run the program\n\n  ```shell\n  python3 ec2pricing/__init__.py download\n  ```\n\n### Set up via poetry\n\n* Tell poetry which version of python available in your system to use\n\n  ```shell\n  poetry env use 3.9.7\n  ```\n\n* Install dependencies and create virtual environment\n\n  ```shell\n  poetry install\n  ```\n\n* Run program\n\n  ```shell\n  poetry run ec2pricing download\n  ```\n\n<a id="future"></a>\n\n## Feature plans\n\n* [ ] Static website that displays the table along with the filters\n* [ ] Add search filters as key-value pairs for initial price download\n* [ ] Search for instances other than shared or Linux based\n* [ ] Support saving plans, reserved instances, free tier\n\n## Copyright & License\n\n* This program is distributed under Apache 2 License.\n* All AWS and Amazon related trademarks or symbols are not mine.\n* Prices obtained through this program are not an offer and should not be treated as official.\n',
    'author': 'vduseev',
    'author_email': 'vagiz@duseev.com',
    'maintainer': 'vduseev',
    'maintainer_email': 'vagiz@duseev.com',
    'url': 'https://github.com/vduseev/aws-ec2-pricing',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
