from ccxt.base.types import Entry


class ImplicitAPI:
    rest_iridium_public_get_markets = restIridiumPublicGetMarkets = Entry('/markets', ['rest', 'iridium', 'public'], 'GET', {'cost': 1})
    rest_iridium_public_get_history_klines = restIridiumPublicGetHistoryKlines = Entry('/history/klines', ['rest', 'iridium', 'public'], 'GET', {'cost': 1})
    rest_iridium_public_get_points_loyalty_leaderboard = restIridiumPublicGetPointsLoyaltyLeaderboard = Entry('/points/loyalty-leaderboard', ['rest', 'iridium', 'public'], 'GET', {'cost': 1})
    rest_iridium_public_get_points_referral_leaderboard = restIridiumPublicGetPointsReferralLeaderboard = Entry('/points/referral-leaderboard', ['rest', 'iridium', 'public'], 'GET', {'cost': 1})
    rest_iridium_public_get_points_blocks_leaderboard = restIridiumPublicGetPointsBlocksLeaderboard = Entry('/points/blocks-leaderboard', ['rest', 'iridium', 'public'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_check = restIridiumPrivateGetUsersCheck = Entry('/users/check', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_info = restIridiumPrivateGetUsersInfo = Entry('/users/info', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccounts = restIridiumPrivateGetUsersSubaccounts = Entry('/users/subaccounts', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid = restIridiumPrivateGetUsersSubaccountSubaccountId = Entry('/users/subaccount/{subaccountId}', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid_positions = restIridiumPrivateGetUsersSubaccountSubaccountIdPositions = Entry('/users/subaccount/{subaccountId}/positions', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid_transfers = restIridiumPrivateGetUsersSubaccountSubaccountIdTransfers = Entry('/users/subaccount/{subaccountId}/transfers', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid_deposits = restIridiumPrivateGetUsersSubaccountSubaccountIdDeposits = Entry('/users/subaccount/{subaccountId}/deposits', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid_withdrawals = restIridiumPrivateGetUsersSubaccountSubaccountIdWithdrawals = Entry('/users/subaccount/{subaccountId}/withdrawals', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid_orders = restIridiumPrivateGetUsersSubaccountSubaccountIdOrders = Entry('/users/subaccount/{subaccountId}/orders', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_subaccount_subaccountid_fills = restIridiumPrivateGetUsersSubaccountSubaccountIdFills = Entry('/users/subaccount/{subaccountId}/fills', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_fee_estimate_market_id = restIridiumPrivateGetUsersFeeEstimateMarketId = Entry('/users/fee-estimate/{market_id}', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_address = restIridiumPrivateGetUsersAddress = Entry('/users/address', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_address_settings = restIridiumPrivateGetUsersAddressSettings = Entry('/users/address/settings', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_loot_boxes = restIridiumPrivateGetUsersLootBoxes = Entry('/users/loot-boxes', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_invites = restIridiumPrivateGetUsersInvites = Entry('/users/invites', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_daily_loyalty = restIridiumPrivateGetUsersDailyLoyalty = Entry('/users/daily-loyalty', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_get_users_user_tier = restIridiumPrivateGetUsersUserTier = Entry('/users/user-tier', ['rest', 'iridium', 'private'], 'GET', {'cost': 1})
    rest_iridium_private_post_users_withdraw = restIridiumPrivatePostUsersWithdraw = Entry('/users/withdraw', ['rest', 'iridium', 'private'], 'POST', {'cost': 1})
    rest_iridium_private_post_users_subaccounts = restIridiumPrivatePostUsersSubaccounts = Entry('/users/subaccounts', ['rest', 'iridium', 'private'], 'POST', {'cost': 1})
    rest_iridium_private_patch_users_subaccount_subaccountid = restIridiumPrivatePatchUsersSubaccountSubaccountId = Entry('/users/subaccount/{subaccountId}', ['rest', 'iridium', 'private'], 'PATCH', {'cost': 1})
    rest_mendelev_public_get_book_market_id_snapshot = restMendelevPublicGetBookMarketIdSnapshot = Entry('/book/{market_id}/snapshot', ['rest', 'mendelev', 'public'], 'GET', {'cost': 1})
    rest_mendelev_public_get_parsed_book_market_symbol_snapshot = restMendelevPublicGetParsedBookMarketSymbolSnapshot = Entry('/parsed/book/{market_symbol}/snapshot', ['rest', 'mendelev', 'public'], 'GET', {'cost': 1})
    rest_mendelev_public_get_book_market_id_recent_trades = restMendelevPublicGetBookMarketIdRecentTrades = Entry('/book/{market_id}/recent-trades', ['rest', 'mendelev', 'public'], 'GET', {'cost': 1})
    rest_mendelev_public_get_parsed_book_market_symbol_recent_trades = restMendelevPublicGetParsedBookMarketSymbolRecentTrades = Entry('/parsed/book/{market_symbol}/recent-trades', ['rest', 'mendelev', 'public'], 'GET', {'cost': 1})
    rest_mendelev_public_get_tickers_snapshot = restMendelevPublicGetTickersSnapshot = Entry('/tickers/snapshot', ['rest', 'mendelev', 'public'], 'GET', {'cost': 1})
    rest_mendelev_public_get_parsed_tickers = restMendelevPublicGetParsedTickers = Entry('/parsed/tickers', ['rest', 'mendelev', 'public'], 'GET', {'cost': 1})
    rest_osmium_private_get_orders = restOsmiumPrivateGetOrders = Entry('/orders', ['rest', 'osmium', 'private'], 'GET', {'cost': 1})
    rest_osmium_private_get_positions = restOsmiumPrivateGetPositions = Entry('/positions', ['rest', 'osmium', 'private'], 'GET', {'cost': 1})
    rest_osmium_private_delete_orders = restOsmiumPrivateDeleteOrders = Entry('/orders', ['rest', 'osmium', 'private'], 'DELETE', {'cost': 1})
    rest_osmium_private_delete_order = restOsmiumPrivateDeleteOrder = Entry('/order', ['rest', 'osmium', 'private'], 'DELETE', {'cost': 1})
    rest_osmium_private_post_order = restOsmiumPrivatePostOrder = Entry('/order', ['rest', 'osmium', 'private'], 'POST', {'cost': 1})
    rest_osmium_private_patch_order = restOsmiumPrivatePatchOrder = Entry('/order', ['rest', 'osmium', 'private'], 'PATCH', {'cost': 1})
