# DO NOT EDIT! This file is automatically generated
import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import CreatedBy, LastModifiedBy
    from ._customer import CustomerReference, CustomerResourceIdentifier
    from ._product import ProductReference, ProductResourceIdentifier
    from ._state import StateReference, StateResourceIdentifier
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "Review",
    "ReviewDraft",
    "ReviewPagedQueryResponse",
    "ReviewRatingStatistics",
    "ReviewReference",
    "ReviewResourceIdentifier",
    "ReviewSetAuthorNameAction",
    "ReviewSetCustomFieldAction",
    "ReviewSetCustomTypeAction",
    "ReviewSetCustomerAction",
    "ReviewSetKeyAction",
    "ReviewSetLocaleAction",
    "ReviewSetRatingAction",
    "ReviewSetTargetAction",
    "ReviewSetTextAction",
    "ReviewSetTitleAction",
    "ReviewTransitionStateAction",
    "ReviewUpdate",
    "ReviewUpdateAction",
]


class Review(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``uniquenessValue`` `in Commercetools)`
    uniqueness_value: typing.Optional[str]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``authorName`` `in Commercetools)`
    author_name: typing.Optional[str]
    #: Optional :class:`str`
    title: typing.Optional[str]
    #: Optional :class:`str`
    text: typing.Optional[str]
    #: Optional :class:`commercetools.types.ProductReference`
    target: typing.Optional["ProductReference"]
    #: :class:`bool` `(Named` ``includedInStatistics`` `in Commercetools)`
    included_in_statistics: bool
    #: Optional :class:`int`
    rating: typing.Optional[int]
    #: Optional :class:`commercetools.types.StateReference`
    state: typing.Optional["StateReference"]
    #: Optional :class:`commercetools.types.CustomerReference`
    customer: typing.Optional["CustomerReference"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        included_in_statistics: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        uniqueness_value: typing.Optional[str] = None,
        locale: typing.Optional[str] = None,
        author_name: typing.Optional[str] = None,
        title: typing.Optional[str] = None,
        text: typing.Optional[str] = None,
        target: typing.Optional["ProductReference"] = None,
        rating: typing.Optional[int] = None,
        state: typing.Optional["StateReference"] = None,
        customer: typing.Optional["CustomerReference"] = None,
        custom: typing.Optional["CustomFields"] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.uniqueness_value = uniqueness_value
        self.locale = locale
        self.author_name = author_name
        self.title = title
        self.text = text
        self.target = target
        self.included_in_statistics = included_in_statistics
        self.rating = rating
        self.state = state
        self.customer = customer
        self.custom = custom
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "Review(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, uniqueness_value=%r, locale=%r, author_name=%r, title=%r, text=%r, target=%r, included_in_statistics=%r, rating=%r, state=%r, customer=%r, custom=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.uniqueness_value,
                self.locale,
                self.author_name,
                self.title,
                self.text,
                self.target,
                self.included_in_statistics,
                self.rating,
                self.state,
                self.customer,
                self.custom,
            )
        )


class ReviewDraft(_BaseType):
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``uniquenessValue`` `in Commercetools)`
    uniqueness_value: typing.Optional[str]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``authorName`` `in Commercetools)`
    author_name: typing.Optional[str]
    #: Optional :class:`str`
    title: typing.Optional[str]
    #: Optional :class:`str`
    text: typing.Optional[str]
    #: Optional :class:`commercetools.types.ProductResourceIdentifier`
    target: typing.Optional["ProductResourceIdentifier"]
    #: Optional :class:`commercetools.types.StateResourceIdentifier`
    state: typing.Optional["StateResourceIdentifier"]
    #: Optional :class:`int`
    rating: typing.Optional[int]
    #: Optional :class:`commercetools.types.CustomerResourceIdentifier`
    customer: typing.Optional["CustomerResourceIdentifier"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]

    def __init__(
        self,
        *,
        key: typing.Optional[str] = None,
        uniqueness_value: typing.Optional[str] = None,
        locale: typing.Optional[str] = None,
        author_name: typing.Optional[str] = None,
        title: typing.Optional[str] = None,
        text: typing.Optional[str] = None,
        target: typing.Optional["ProductResourceIdentifier"] = None,
        state: typing.Optional["StateResourceIdentifier"] = None,
        rating: typing.Optional[int] = None,
        customer: typing.Optional["CustomerResourceIdentifier"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None
    ) -> None:
        self.key = key
        self.uniqueness_value = uniqueness_value
        self.locale = locale
        self.author_name = author_name
        self.title = title
        self.text = text
        self.target = target
        self.state = state
        self.rating = rating
        self.customer = customer
        self.custom = custom
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ReviewDraft(key=%r, uniqueness_value=%r, locale=%r, author_name=%r, title=%r, text=%r, target=%r, state=%r, rating=%r, customer=%r, custom=%r)"
            % (
                self.key,
                self.uniqueness_value,
                self.locale,
                self.author_name,
                self.title,
                self.text,
                self.target,
                self.state,
                self.rating,
                self.customer,
                self.custom,
            )
        )


class ReviewPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.Review`
    results: typing.Sequence["Review"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["Review"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ReviewPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class ReviewRatingStatistics(_BaseType):
    #: :class:`int` `(Named` ``averageRating`` `in Commercetools)`
    average_rating: int
    #: :class:`int` `(Named` ``highestRating`` `in Commercetools)`
    highest_rating: int
    #: :class:`int` `(Named` ``lowestRating`` `in Commercetools)`
    lowest_rating: int
    #: :class:`int`
    count: int
    #: :class:`object` `(Named` ``ratingsDistribution`` `in Commercetools)`
    ratings_distribution: object

    def __init__(
        self,
        *,
        average_rating: int,
        highest_rating: int,
        lowest_rating: int,
        count: int,
        ratings_distribution: object
    ) -> None:
        self.average_rating = average_rating
        self.highest_rating = highest_rating
        self.lowest_rating = lowest_rating
        self.count = count
        self.ratings_distribution = ratings_distribution
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ReviewRatingStatistics(average_rating=%r, highest_rating=%r, lowest_rating=%r, count=%r, ratings_distribution=%r)"
            % (
                self.average_rating,
                self.highest_rating,
                self.lowest_rating,
                self.count,
                self.ratings_distribution,
            )
        )


class ReviewReference(Reference):
    #: Optional :class:`commercetools.types.Review`
    obj: typing.Optional["Review"]

    def __init__(self, *, id: str, obj: typing.Optional["Review"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.REVIEW, id=id)

    def __repr__(self) -> str:
        return "ReviewReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class ReviewResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.REVIEW, id=id, key=key)

    def __repr__(self) -> str:
        return "ReviewResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class ReviewUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "ReviewUpdate(version=%r, actions=%r)" % (self.version, self.actions)


class ReviewUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "ReviewUpdateAction(action=%r)" % (self.action,)


class ReviewSetAuthorNameAction(ReviewUpdateAction):
    #: Optional :class:`str` `(Named` ``authorName`` `in Commercetools)`
    author_name: typing.Optional[str]

    def __init__(self, *, author_name: typing.Optional[str] = None) -> None:
        self.author_name = author_name
        super().__init__(action="setAuthorName")

    def __repr__(self) -> str:
        return "ReviewSetAuthorNameAction(action=%r, author_name=%r)" % (
            self.action,
            self.author_name,
        )


class ReviewSetCustomFieldAction(ReviewUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "ReviewSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class ReviewSetCustomTypeAction(ReviewUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "ReviewSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class ReviewSetCustomerAction(ReviewUpdateAction):
    #: Optional :class:`commercetools.types.CustomerResourceIdentifier`
    customer: typing.Optional["CustomerResourceIdentifier"]

    def __init__(
        self, *, customer: typing.Optional["CustomerResourceIdentifier"] = None
    ) -> None:
        self.customer = customer
        super().__init__(action="setCustomer")

    def __repr__(self) -> str:
        return "ReviewSetCustomerAction(action=%r, customer=%r)" % (
            self.action,
            self.customer,
        )


class ReviewSetKeyAction(ReviewUpdateAction):
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(self, *, key: typing.Optional[str] = None) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "ReviewSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class ReviewSetLocaleAction(ReviewUpdateAction):
    #: Optional :class:`str`
    locale: typing.Optional[str]

    def __init__(self, *, locale: typing.Optional[str] = None) -> None:
        self.locale = locale
        super().__init__(action="setLocale")

    def __repr__(self) -> str:
        return "ReviewSetLocaleAction(action=%r, locale=%r)" % (
            self.action,
            self.locale,
        )


class ReviewSetRatingAction(ReviewUpdateAction):
    #: Optional :class:`int`
    rating: typing.Optional[int]

    def __init__(self, *, rating: typing.Optional[int] = None) -> None:
        self.rating = rating
        super().__init__(action="setRating")

    def __repr__(self) -> str:
        return "ReviewSetRatingAction(action=%r, rating=%r)" % (
            self.action,
            self.rating,
        )


class ReviewSetTargetAction(ReviewUpdateAction):
    #: :class:`commercetools.types.ProductResourceIdentifier`
    target: "ProductResourceIdentifier"

    def __init__(self, *, target: "ProductResourceIdentifier") -> None:
        self.target = target
        super().__init__(action="setTarget")

    def __repr__(self) -> str:
        return "ReviewSetTargetAction(action=%r, target=%r)" % (
            self.action,
            self.target,
        )


class ReviewSetTextAction(ReviewUpdateAction):
    #: Optional :class:`str`
    text: typing.Optional[str]

    def __init__(self, *, text: typing.Optional[str] = None) -> None:
        self.text = text
        super().__init__(action="setText")

    def __repr__(self) -> str:
        return "ReviewSetTextAction(action=%r, text=%r)" % (self.action, self.text)


class ReviewSetTitleAction(ReviewUpdateAction):
    #: Optional :class:`str`
    title: typing.Optional[str]

    def __init__(self, *, title: typing.Optional[str] = None) -> None:
        self.title = title
        super().__init__(action="setTitle")

    def __repr__(self) -> str:
        return "ReviewSetTitleAction(action=%r, title=%r)" % (self.action, self.title)


class ReviewTransitionStateAction(ReviewUpdateAction):
    #: :class:`commercetools.types.StateResourceIdentifier`
    state: "StateResourceIdentifier"
    #: Optional :class:`bool`
    force: typing.Optional[bool]

    def __init__(
        self, *, state: "StateResourceIdentifier", force: typing.Optional[bool] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(action="transitionState")

    def __repr__(self) -> str:
        return "ReviewTransitionStateAction(action=%r, state=%r, force=%r)" % (
            self.action,
            self.state,
            self.force,
        )
