# DO NOT EDIT! This file is automatically generated
import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import (
        CreatedBy,
        LastModifiedBy,
        LocalizedString,
        Money,
        QueryPrice,
        TypedMoney,
    )
__all__ = [
    "ProductDiscount",
    "ProductDiscountChangeIsActiveAction",
    "ProductDiscountChangeNameAction",
    "ProductDiscountChangePredicateAction",
    "ProductDiscountChangeSortOrderAction",
    "ProductDiscountChangeValueAction",
    "ProductDiscountDraft",
    "ProductDiscountMatchQuery",
    "ProductDiscountPagedQueryResponse",
    "ProductDiscountReference",
    "ProductDiscountResourceIdentifier",
    "ProductDiscountSetDescriptionAction",
    "ProductDiscountSetKeyAction",
    "ProductDiscountSetValidFromAction",
    "ProductDiscountSetValidFromAndUntilAction",
    "ProductDiscountSetValidUntilAction",
    "ProductDiscountUpdate",
    "ProductDiscountUpdateAction",
    "ProductDiscountValue",
    "ProductDiscountValueAbsolute",
    "ProductDiscountValueAbsoluteDraft",
    "ProductDiscountValueDraft",
    "ProductDiscountValueExternal",
    "ProductDiscountValueExternalDraft",
    "ProductDiscountValueRelative",
    "ProductDiscountValueRelativeDraft",
]


class ProductDiscount(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.ProductDiscountValue`
    value: "ProductDiscountValue"
    #: :class:`str`
    predicate: str
    #: :class:`str` `(Named` ``sortOrder`` `in Commercetools)`
    sort_order: str
    #: :class:`bool` `(Named` ``isActive`` `in Commercetools)`
    is_active: bool
    #: List of :class:`commercetools.types.Reference`
    references: typing.List["Reference"]
    #: Optional :class:`datetime.datetime` `(Named` ``validFrom`` `in Commercetools)`
    valid_from: typing.Optional[datetime.datetime]
    #: Optional :class:`datetime.datetime` `(Named` ``validUntil`` `in Commercetools)`
    valid_until: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        name: "LocalizedString",
        value: "ProductDiscountValue",
        predicate: str,
        sort_order: str,
        is_active: bool,
        references: typing.List["Reference"],
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None,
        valid_from: typing.Optional[datetime.datetime] = None,
        valid_until: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.name = name
        self.key = key
        self.description = description
        self.value = value
        self.predicate = predicate
        self.sort_order = sort_order
        self.is_active = is_active
        self.references = references
        self.valid_from = valid_from
        self.valid_until = valid_until
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "ProductDiscount(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, name=%r, key=%r, description=%r, value=%r, predicate=%r, sort_order=%r, is_active=%r, references=%r, valid_from=%r, valid_until=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.name,
                self.key,
                self.description,
                self.value,
                self.predicate,
                self.sort_order,
                self.is_active,
                self.references,
                self.valid_from,
                self.valid_until,
            )
        )


class ProductDiscountDraft(_BaseType):
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.ProductDiscountValueDraft`
    value: "ProductDiscountValueDraft"
    #: :class:`str`
    predicate: str
    #: :class:`str` `(Named` ``sortOrder`` `in Commercetools)`
    sort_order: str
    #: :class:`bool` `(Named` ``isActive`` `in Commercetools)`
    is_active: bool
    #: Optional :class:`datetime.datetime` `(Named` ``validFrom`` `in Commercetools)`
    valid_from: typing.Optional[datetime.datetime]
    #: Optional :class:`datetime.datetime` `(Named` ``validUntil`` `in Commercetools)`
    valid_until: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        name: "LocalizedString",
        value: "ProductDiscountValueDraft",
        predicate: str,
        sort_order: str,
        is_active: bool,
        key: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None,
        valid_from: typing.Optional[datetime.datetime] = None,
        valid_until: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.name = name
        self.key = key
        self.description = description
        self.value = value
        self.predicate = predicate
        self.sort_order = sort_order
        self.is_active = is_active
        self.valid_from = valid_from
        self.valid_until = valid_until
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductDiscountDraft(name=%r, key=%r, description=%r, value=%r, predicate=%r, sort_order=%r, is_active=%r, valid_from=%r, valid_until=%r)"
            % (
                self.name,
                self.key,
                self.description,
                self.value,
                self.predicate,
                self.sort_order,
                self.is_active,
                self.valid_from,
                self.valid_until,
            )
        )


class ProductDiscountMatchQuery(_BaseType):
    #: :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: str
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: int
    #: :class:`bool`
    staged: bool
    #: :class:`commercetools.types.QueryPrice`
    price: "QueryPrice"

    def __init__(
        self, *, product_id: str, variant_id: int, staged: bool, price: "QueryPrice"
    ) -> None:
        self.product_id = product_id
        self.variant_id = variant_id
        self.staged = staged
        self.price = price
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductDiscountMatchQuery(product_id=%r, variant_id=%r, staged=%r, price=%r)"
            % (self.product_id, self.variant_id, self.staged, self.price)
        )


class ProductDiscountPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.ProductDiscount`
    results: typing.Sequence["ProductDiscount"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["ProductDiscount"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductDiscountPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class ProductDiscountReference(Reference):
    #: Optional :class:`commercetools.types.ProductDiscount`
    obj: typing.Optional["ProductDiscount"]

    def __init__(
        self, *, id: str, obj: typing.Optional["ProductDiscount"] = None
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.PRODUCT_DISCOUNT, id=id)

    def __repr__(self) -> str:
        return "ProductDiscountReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class ProductDiscountResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.PRODUCT_DISCOUNT, id=id, key=key)

    def __repr__(self) -> str:
        return "ProductDiscountResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class ProductDiscountUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "ProductDiscountUpdate(version=%r, actions=%r)" % (
            self.version,
            self.actions,
        )


class ProductDiscountUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "ProductDiscountUpdateAction(action=%r)" % (self.action,)


class ProductDiscountValue(_BaseType):
    #: :class:`str`
    type: str

    def __init__(self, *, type: str) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "ProductDiscountValue(type=%r)" % (self.type,)


class ProductDiscountValueDraft(_BaseType):
    #: :class:`str`
    type: str

    def __init__(self, *, type: str) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "ProductDiscountValueDraft(type=%r)" % (self.type,)


class ProductDiscountChangeIsActiveAction(ProductDiscountUpdateAction):
    #: :class:`bool` `(Named` ``isActive`` `in Commercetools)`
    is_active: bool

    def __init__(self, *, is_active: bool) -> None:
        self.is_active = is_active
        super().__init__(action="changeIsActive")

    def __repr__(self) -> str:
        return "ProductDiscountChangeIsActiveAction(action=%r, is_active=%r)" % (
            self.action,
            self.is_active,
        )


class ProductDiscountChangeNameAction(ProductDiscountUpdateAction):
    #: :class:`commercetools.types.LocalizedString`
    name: "LocalizedString"

    def __init__(self, *, name: "LocalizedString") -> None:
        self.name = name
        super().__init__(action="changeName")

    def __repr__(self) -> str:
        return "ProductDiscountChangeNameAction(action=%r, name=%r)" % (
            self.action,
            self.name,
        )


class ProductDiscountChangePredicateAction(ProductDiscountUpdateAction):
    #: :class:`str`
    predicate: str

    def __init__(self, *, predicate: str) -> None:
        self.predicate = predicate
        super().__init__(action="changePredicate")

    def __repr__(self) -> str:
        return "ProductDiscountChangePredicateAction(action=%r, predicate=%r)" % (
            self.action,
            self.predicate,
        )


class ProductDiscountChangeSortOrderAction(ProductDiscountUpdateAction):
    #: :class:`str` `(Named` ``sortOrder`` `in Commercetools)`
    sort_order: str

    def __init__(self, *, sort_order: str) -> None:
        self.sort_order = sort_order
        super().__init__(action="changeSortOrder")

    def __repr__(self) -> str:
        return "ProductDiscountChangeSortOrderAction(action=%r, sort_order=%r)" % (
            self.action,
            self.sort_order,
        )


class ProductDiscountChangeValueAction(ProductDiscountUpdateAction):
    #: :class:`commercetools.types.ProductDiscountValueDraft`
    value: "ProductDiscountValueDraft"

    def __init__(self, *, value: "ProductDiscountValueDraft") -> None:
        self.value = value
        super().__init__(action="changeValue")

    def __repr__(self) -> str:
        return "ProductDiscountChangeValueAction(action=%r, value=%r)" % (
            self.action,
            self.value,
        )


class ProductDiscountSetDescriptionAction(ProductDiscountUpdateAction):
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]

    def __init__(
        self, *, description: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.description = description
        super().__init__(action="setDescription")

    def __repr__(self) -> str:
        return "ProductDiscountSetDescriptionAction(action=%r, description=%r)" % (
            self.action,
            self.description,
        )


class ProductDiscountSetKeyAction(ProductDiscountUpdateAction):
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(self, *, key: typing.Optional[str] = None) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "ProductDiscountSetKeyAction(action=%r, key=%r)" % (
            self.action,
            self.key,
        )


class ProductDiscountSetValidFromAction(ProductDiscountUpdateAction):
    #: Optional :class:`datetime.datetime` `(Named` ``validFrom`` `in Commercetools)`
    valid_from: typing.Optional[datetime.datetime]

    def __init__(
        self, *, valid_from: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.valid_from = valid_from
        super().__init__(action="setValidFrom")

    def __repr__(self) -> str:
        return "ProductDiscountSetValidFromAction(action=%r, valid_from=%r)" % (
            self.action,
            self.valid_from,
        )


class ProductDiscountSetValidFromAndUntilAction(ProductDiscountUpdateAction):
    #: Optional :class:`datetime.datetime` `(Named` ``validFrom`` `in Commercetools)`
    valid_from: typing.Optional[datetime.datetime]
    #: Optional :class:`datetime.datetime` `(Named` ``validUntil`` `in Commercetools)`
    valid_until: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        valid_from: typing.Optional[datetime.datetime] = None,
        valid_until: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.valid_from = valid_from
        self.valid_until = valid_until
        super().__init__(action="setValidFromAndUntil")

    def __repr__(self) -> str:
        return (
            "ProductDiscountSetValidFromAndUntilAction(action=%r, valid_from=%r, valid_until=%r)"
            % (self.action, self.valid_from, self.valid_until)
        )


class ProductDiscountSetValidUntilAction(ProductDiscountUpdateAction):
    #: Optional :class:`datetime.datetime` `(Named` ``validUntil`` `in Commercetools)`
    valid_until: typing.Optional[datetime.datetime]

    def __init__(
        self, *, valid_until: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.valid_until = valid_until
        super().__init__(action="setValidUntil")

    def __repr__(self) -> str:
        return "ProductDiscountSetValidUntilAction(action=%r, valid_until=%r)" % (
            self.action,
            self.valid_until,
        )


class ProductDiscountValueAbsolute(ProductDiscountValue):
    #: List of :class:`commercetools.types.TypedMoney`
    money: typing.List["TypedMoney"]

    def __init__(self, *, money: typing.List["TypedMoney"]) -> None:
        self.money = money
        super().__init__(type="absolute")

    def __repr__(self) -> str:
        return "ProductDiscountValueAbsolute(type=%r, money=%r)" % (
            self.type,
            self.money,
        )


class ProductDiscountValueAbsoluteDraft(ProductDiscountValueDraft):
    #: List of :class:`commercetools.types.Money`
    money: typing.List["Money"]

    def __init__(self, *, money: typing.List["Money"]) -> None:
        self.money = money
        super().__init__(type="absolute")

    def __repr__(self) -> str:
        return "ProductDiscountValueAbsoluteDraft(type=%r, money=%r)" % (
            self.type,
            self.money,
        )


class ProductDiscountValueExternal(ProductDiscountValue):
    def __init__(self) -> None:
        super().__init__(type="external")

    def __repr__(self) -> str:
        return "ProductDiscountValueExternal(type=%r)" % (self.type,)


class ProductDiscountValueExternalDraft(ProductDiscountValueDraft):
    def __init__(self) -> None:
        super().__init__(type="external")

    def __repr__(self) -> str:
        return "ProductDiscountValueExternalDraft(type=%r)" % (self.type,)


class ProductDiscountValueRelative(ProductDiscountValue):
    #: :class:`int`
    permyriad: int

    def __init__(self, *, permyriad: int) -> None:
        self.permyriad = permyriad
        super().__init__(type="relative")

    def __repr__(self) -> str:
        return "ProductDiscountValueRelative(type=%r, permyriad=%r)" % (
            self.type,
            self.permyriad,
        )


class ProductDiscountValueRelativeDraft(ProductDiscountValueDraft):
    #: :class:`int`
    permyriad: int

    def __init__(self, *, permyriad: int) -> None:
        self.permyriad = permyriad
        super().__init__(type="relative")

    def __repr__(self) -> str:
        return "ProductDiscountValueRelativeDraft(type=%r, permyriad=%r)" % (
            self.type,
            self.permyriad,
        )
