# DO NOT EDIT! This file is automatically generated
import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import BaseResource, Reference, ReferenceTypeId

if typing.TYPE_CHECKING:
    from ._common import CreatedBy, LastModifiedBy
__all__ = [
    "CustomObject",
    "CustomObjectDraft",
    "CustomObjectPagedQueryResponse",
    "CustomObjectReference",
]


class CustomObject(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: :class:`str`
    container: str
    #: :class:`str`
    key: str
    #: :class:`typing.Any`
    value: typing.Any

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        container: str,
        key: str,
        value: typing.Any,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.container = container
        self.key = key
        self.value = value
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "CustomObject(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, container=%r, key=%r, value=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.container,
                self.key,
                self.value,
            )
        )


class CustomObjectDraft(_BaseType):
    #: :class:`str`
    container: str
    #: :class:`str`
    key: str
    #: :class:`typing.Any`
    value: typing.Any
    #: Optional :class:`int`
    version: typing.Optional[int]

    def __init__(
        self,
        *,
        container: str,
        key: str,
        value: typing.Any,
        version: typing.Optional[int] = None
    ) -> None:
        self.container = container
        self.key = key
        self.value = value
        self.version = version
        super().__init__()

    def __repr__(self) -> str:
        return "CustomObjectDraft(container=%r, key=%r, value=%r, version=%r)" % (
            self.container,
            self.key,
            self.value,
            self.version,
        )


class CustomObjectPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.CustomObject`
    results: typing.Sequence["CustomObject"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["CustomObject"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomObjectPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class CustomObjectReference(Reference):
    #: Optional :class:`commercetools.types.CustomObject`
    obj: typing.Optional["CustomObject"]

    def __init__(self, *, id: str, obj: typing.Optional["CustomObject"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.KEY_VALUE_DOCUMENT, id=id)

    def __repr__(self) -> str:
        return "CustomObjectReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )
