# DO NOT EDIT! This file is automatically generated
import typing

from commercetools._schemas._extension import (
    ExtensionDraftSchema,
    ExtensionPagedQueryResponseSchema,
    ExtensionSchema,
    ExtensionUpdateSchema,
)
from commercetools.helpers import RemoveEmptyValuesMixin
from commercetools.types._extension import (
    Extension,
    ExtensionDraft,
    ExtensionPagedQueryResponse,
    ExtensionUpdate,
    ExtensionUpdateAction,
)
from commercetools.typing import OptionalListStr

from . import abstract, traits


class _ExtensionQuerySchema(
    traits.ExpandableSchema,
    traits.SortableSchema,
    traits.PagingSchema,
    traits.QuerySchema,
):
    pass


class _ExtensionUpdateSchema(traits.ExpandableSchema, traits.VersionedSchema):
    pass


class _ExtensionDeleteSchema(traits.VersionedSchema, traits.ExpandableSchema):
    pass


class ExtensionService(abstract.AbstractService):
    """Extend the behavior of an API with your business logic"""

    def get_by_id(self, id: str, *, expand: OptionalListStr = None) -> Extension:
        """Retrieves the representation of an extension by its id."""
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"extensions/{id}", params=params, schema_cls=ExtensionSchema
        )

    def get_by_key(self, key: str, *, expand: OptionalListStr = None) -> Extension:
        """Retrieves the representation of an extension by its key."""
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._get(
            endpoint=f"extensions/key={key}", params=params, schema_cls=ExtensionSchema
        )

    def query(
        self,
        *,
        expand: OptionalListStr = None,
        sort: OptionalListStr = None,
        limit: int = None,
        offset: int = None,
        with_total: bool = None,
        where: OptionalListStr = None,
        predicate_var: typing.Dict[str, str] = None,
    ) -> ExtensionPagedQueryResponse:
        """Extend the behavior of an API with your business logic
        """
        params = self._serialize_params(
            {
                "expand": expand,
                "sort": sort,
                "limit": limit,
                "offset": offset,
                "with_total": with_total,
                "where": where,
                "predicate_var": predicate_var,
            },
            _ExtensionQuerySchema,
        )
        return self._client._get(
            endpoint="extensions",
            params=params,
            schema_cls=ExtensionPagedQueryResponseSchema,
        )

    def create(
        self, draft: ExtensionDraft, *, expand: OptionalListStr = None
    ) -> Extension:
        """Currently, a maximum of 25 extensions can be created per project.

        Extend the behavior of an API with your business logic
        """
        params = self._serialize_params({"expand": expand}, traits.ExpandableSchema)
        return self._client._post(
            endpoint="extensions",
            params=params,
            data_object=draft,
            request_schema_cls=ExtensionDraftSchema,
            response_schema_cls=ExtensionSchema,
        )

    def update_by_id(
        self,
        id: str,
        version: int,
        actions: typing.List[ExtensionUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Extension:
        params = self._serialize_params({"expand": expand}, _ExtensionUpdateSchema)
        update_action = ExtensionUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"extensions/{id}",
            params=params,
            data_object=update_action,
            request_schema_cls=ExtensionUpdateSchema,
            response_schema_cls=ExtensionSchema,
            force_update=force_update,
        )

    def update_by_key(
        self,
        key: str,
        version: int,
        actions: typing.List[ExtensionUpdateAction],
        *,
        expand: OptionalListStr = None,
        force_update: bool = False,
    ) -> Extension:
        params = self._serialize_params({"expand": expand}, _ExtensionUpdateSchema)
        update_action = ExtensionUpdate(version=version, actions=actions)
        return self._client._post(
            endpoint=f"extensions/key={key}",
            params=params,
            data_object=update_action,
            request_schema_cls=ExtensionUpdateSchema,
            response_schema_cls=ExtensionSchema,
            force_update=force_update,
        )

    def delete_by_id(
        self,
        id: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> Extension:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _ExtensionDeleteSchema
        )
        return self._client._delete(
            endpoint=f"extensions/{id}",
            params=params,
            response_schema_cls=ExtensionSchema,
            force_delete=force_delete,
        )

    def delete_by_key(
        self,
        key: str,
        version: int,
        *,
        expand: OptionalListStr = None,
        force_delete: bool = False,
    ) -> Extension:
        params = self._serialize_params(
            {"version": version, "expand": expand}, _ExtensionDeleteSchema
        )
        return self._client._delete(
            endpoint=f"extensions/key={key}",
            params=params,
            response_schema_cls=ExtensionSchema,
            force_delete=force_delete,
        )
