# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)

__all__ = [
    "CustomFieldBooleanTypeSchema",
    "CustomFieldDateTimeTypeSchema",
    "CustomFieldDateTypeSchema",
    "CustomFieldEnumTypeSchema",
    "CustomFieldEnumValueSchema",
    "CustomFieldLocalizedEnumTypeSchema",
    "CustomFieldLocalizedEnumValueSchema",
    "CustomFieldLocalizedStringTypeSchema",
    "CustomFieldMoneyTypeSchema",
    "CustomFieldNumberTypeSchema",
    "CustomFieldReferenceTypeSchema",
    "CustomFieldSetTypeSchema",
    "CustomFieldStringTypeSchema",
    "CustomFieldTimeTypeSchema",
    "CustomFieldsDraftSchema",
    "CustomFieldsSchema",
    "FieldDefinitionSchema",
    "FieldTypeSchema",
    "TypeAddEnumValueActionSchema",
    "TypeAddFieldDefinitionActionSchema",
    "TypeAddLocalizedEnumValueActionSchema",
    "TypeChangeEnumValueLabelActionSchema",
    "TypeChangeEnumValueOrderActionSchema",
    "TypeChangeFieldDefinitionLabelActionSchema",
    "TypeChangeFieldDefinitionOrderActionSchema",
    "TypeChangeInputHintActionSchema",
    "TypeChangeKeyActionSchema",
    "TypeChangeLabelActionSchema",
    "TypeChangeLocalizedEnumValueLabelActionSchema",
    "TypeChangeLocalizedEnumValueOrderActionSchema",
    "TypeChangeNameActionSchema",
    "TypeDraftSchema",
    "TypePagedQueryResponseSchema",
    "TypeReferenceSchema",
    "TypeRemoveFieldDefinitionActionSchema",
    "TypeResourceIdentifierSchema",
    "TypeSchema",
    "TypeSetDescriptionActionSchema",
    "TypeUpdateActionSchema",
    "TypeUpdateSchema",
]


class FieldContainerField(marshmallow.fields.Dict):
    def _deserialize(self, value, attr, data, **kwargs):
        result = super()._deserialize(value, attr, data)
        return types.FieldContainer(**result)


class CustomFieldEnumValueSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldEnumValue`."""

    key = marshmallow.fields.String(allow_none=True)
    label = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CustomFieldEnumValue(**data)


class CustomFieldLocalizedEnumValueSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldLocalizedEnumValue`."""

    key = marshmallow.fields.String(allow_none=True)
    label = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CustomFieldLocalizedEnumValue(**data)


class CustomFieldsDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldsDraft`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CustomFieldsDraft(**data)


class CustomFieldsSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CustomFields`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    fields = FieldContainerField(allow_none=True)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CustomFields(**data)


class FieldDefinitionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.FieldDefinition`."""

    type = helpers.Discriminator(
        discriminator_field=("name", "name"),
        discriminator_schemas={
            "Boolean": "commercetools._schemas._type.CustomFieldBooleanTypeSchema",
            "DateTime": "commercetools._schemas._type.CustomFieldDateTimeTypeSchema",
            "Date": "commercetools._schemas._type.CustomFieldDateTypeSchema",
            "Enum": "commercetools._schemas._type.CustomFieldEnumTypeSchema",
            "LocalizedEnum": "commercetools._schemas._type.CustomFieldLocalizedEnumTypeSchema",
            "LocalizedString": "commercetools._schemas._type.CustomFieldLocalizedStringTypeSchema",
            "Money": "commercetools._schemas._type.CustomFieldMoneyTypeSchema",
            "Number": "commercetools._schemas._type.CustomFieldNumberTypeSchema",
            "Reference": "commercetools._schemas._type.CustomFieldReferenceTypeSchema",
            "Set": "commercetools._schemas._type.CustomFieldSetTypeSchema",
            "String": "commercetools._schemas._type.CustomFieldStringTypeSchema",
            "Time": "commercetools._schemas._type.CustomFieldTimeTypeSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    name = marshmallow.fields.String(allow_none=True)
    label = LocalizedStringField(allow_none=True)
    required = marshmallow.fields.Bool(allow_none=True)
    input_hint = marshmallow_enum.EnumField(
        types.TypeTextInputHint, by_value=True, missing=None, data_key="inputHint"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.FieldDefinition(**data)


class FieldTypeSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.FieldType`."""

    name = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.FieldType(**data)


class TypeDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TypeDraft`."""

    key = marshmallow.fields.String(allow_none=True)
    name = LocalizedStringField(allow_none=True)
    description = LocalizedStringField(allow_none=True, missing=None)
    resource_type_ids = marshmallow.fields.List(
        marshmallow_enum.EnumField(types.ResourceTypeId, by_value=True),
        data_key="resourceTypeIds",
    )
    field_definitions = helpers.LazyNestedField(
        nested="commercetools._schemas._type.FieldDefinitionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="fieldDefinitions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TypeDraft(**data)


class TypePagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TypePagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TypePagedQueryResponse(**data)


class TypeReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.TypeReference(**data)


class TypeResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.TypeResourceIdentifier(**data)


class TypeSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.Type`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    key = marshmallow.fields.String(allow_none=True)
    name = LocalizedStringField(allow_none=True)
    description = LocalizedStringField(allow_none=True, missing=None)
    resource_type_ids = marshmallow.fields.List(
        marshmallow_enum.EnumField(types.ResourceTypeId, by_value=True),
        data_key="resourceTypeIds",
    )
    field_definitions = helpers.LazyNestedField(
        nested="commercetools._schemas._type.FieldDefinitionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="fieldDefinitions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Type(**data)


class TypeUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TypeUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeUpdateAction(**data)


class TypeUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TypeUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addEnumValue": "commercetools._schemas._type.TypeAddEnumValueActionSchema",
                "addFieldDefinition": "commercetools._schemas._type.TypeAddFieldDefinitionActionSchema",
                "addLocalizedEnumValue": "commercetools._schemas._type.TypeAddLocalizedEnumValueActionSchema",
                "changeEnumValueLabel": "commercetools._schemas._type.TypeChangeEnumValueLabelActionSchema",
                "changeEnumValueOrder": "commercetools._schemas._type.TypeChangeEnumValueOrderActionSchema",
                "changeFieldDefinitionLabel": "commercetools._schemas._type.TypeChangeFieldDefinitionLabelActionSchema",
                "changeFieldDefinitionOrder": "commercetools._schemas._type.TypeChangeFieldDefinitionOrderActionSchema",
                "changeInputHint": "commercetools._schemas._type.TypeChangeInputHintActionSchema",
                "changeKey": "commercetools._schemas._type.TypeChangeKeyActionSchema",
                "changeLabel": "commercetools._schemas._type.TypeChangeLabelActionSchema",
                "changeLocalizedEnumValueLabel": "commercetools._schemas._type.TypeChangeLocalizedEnumValueLabelActionSchema",
                "changeLocalizedEnumValueOrder": "commercetools._schemas._type.TypeChangeLocalizedEnumValueOrderActionSchema",
                "changeName": "commercetools._schemas._type.TypeChangeNameActionSchema",
                "removeFieldDefinition": "commercetools._schemas._type.TypeRemoveFieldDefinitionActionSchema",
                "setDescription": "commercetools._schemas._type.TypeSetDescriptionActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TypeUpdate(**data)


class CustomFieldBooleanTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldBooleanType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldBooleanType()


class CustomFieldDateTimeTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldDateTimeType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldDateTimeType()


class CustomFieldDateTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldDateType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldDateType()


class CustomFieldEnumTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldEnumType`."""

    values = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldEnumValueSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldEnumType(**data)


class CustomFieldLocalizedEnumTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldLocalizedEnumType`."""

    values = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldLocalizedEnumValueSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldLocalizedEnumType(**data)


class CustomFieldLocalizedStringTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldLocalizedStringType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldLocalizedStringType()


class CustomFieldMoneyTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldMoneyType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldMoneyType()


class CustomFieldNumberTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldNumberType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldNumberType()


class CustomFieldReferenceTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldReferenceType`."""

    reference_type_id = marshmallow_enum.EnumField(
        types.ReferenceTypeId, by_value=True, data_key="referenceTypeId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldReferenceType(**data)


class CustomFieldSetTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldSetType`."""

    element_type = helpers.Discriminator(
        discriminator_field=("name", "name"),
        discriminator_schemas={
            "Boolean": "commercetools._schemas._type.CustomFieldBooleanTypeSchema",
            "DateTime": "commercetools._schemas._type.CustomFieldDateTimeTypeSchema",
            "Date": "commercetools._schemas._type.CustomFieldDateTypeSchema",
            "Enum": "commercetools._schemas._type.CustomFieldEnumTypeSchema",
            "LocalizedEnum": "commercetools._schemas._type.CustomFieldLocalizedEnumTypeSchema",
            "LocalizedString": "commercetools._schemas._type.CustomFieldLocalizedStringTypeSchema",
            "Money": "commercetools._schemas._type.CustomFieldMoneyTypeSchema",
            "Number": "commercetools._schemas._type.CustomFieldNumberTypeSchema",
            "Reference": "commercetools._schemas._type.CustomFieldReferenceTypeSchema",
            "Set": "commercetools._schemas._type.CustomFieldSetTypeSchema",
            "String": "commercetools._schemas._type.CustomFieldStringTypeSchema",
            "Time": "commercetools._schemas._type.CustomFieldTimeTypeSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="elementType",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldSetType(**data)


class CustomFieldStringTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldStringType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldStringType()


class CustomFieldTimeTypeSchema(FieldTypeSchema):
    """Marshmallow schema for :class:`commercetools.types.CustomFieldTimeType`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["name"]
        return types.CustomFieldTimeType()


class TypeAddEnumValueActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeAddEnumValueAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    value = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldEnumValueSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeAddEnumValueAction(**data)


class TypeAddFieldDefinitionActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeAddFieldDefinitionAction`."""

    field_definition = helpers.LazyNestedField(
        nested="commercetools._schemas._type.FieldDefinitionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fieldDefinition",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeAddFieldDefinitionAction(**data)


class TypeAddLocalizedEnumValueActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeAddLocalizedEnumValueAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    value = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldLocalizedEnumValueSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeAddLocalizedEnumValueAction(**data)


class TypeChangeEnumValueLabelActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeEnumValueLabelAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    value = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldEnumValueSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeEnumValueLabelAction(**data)


class TypeChangeEnumValueOrderActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeEnumValueOrderAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    keys = marshmallow.fields.List(marshmallow.fields.String(allow_none=True))

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeEnumValueOrderAction(**data)


class TypeChangeFieldDefinitionLabelActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeFieldDefinitionLabelAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    label = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeFieldDefinitionLabelAction(**data)


class TypeChangeFieldDefinitionOrderActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeFieldDefinitionOrderAction`."""

    field_names = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True), data_key="fieldNames"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeFieldDefinitionOrderAction(**data)


class TypeChangeInputHintActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeInputHintAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    input_hint = marshmallow_enum.EnumField(
        types.TypeTextInputHint, by_value=True, data_key="inputHint"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeInputHintAction(**data)


class TypeChangeKeyActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeKeyAction`."""

    key = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeKeyAction(**data)


class TypeChangeLabelActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeLabelAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    label = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeLabelAction(**data)


class TypeChangeLocalizedEnumValueLabelActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeLocalizedEnumValueLabelAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    value = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldLocalizedEnumValueSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeLocalizedEnumValueLabelAction(**data)


class TypeChangeLocalizedEnumValueOrderActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeLocalizedEnumValueOrderAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")
    keys = marshmallow.fields.List(marshmallow.fields.String(allow_none=True))

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeLocalizedEnumValueOrderAction(**data)


class TypeChangeNameActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeChangeNameAction`."""

    name = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeChangeNameAction(**data)


class TypeRemoveFieldDefinitionActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeRemoveFieldDefinitionAction`."""

    field_name = marshmallow.fields.String(allow_none=True, data_key="fieldName")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeRemoveFieldDefinitionAction(**data)


class TypeSetDescriptionActionSchema(TypeUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.TypeSetDescriptionAction`."""

    description = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.TypeSetDescriptionAction(**data)
