# DO NOT EDIT! This file is automatically generated
import marshmallow

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)

__all__ = [
    "ProductDiscountChangeIsActiveActionSchema",
    "ProductDiscountChangeNameActionSchema",
    "ProductDiscountChangePredicateActionSchema",
    "ProductDiscountChangeSortOrderActionSchema",
    "ProductDiscountChangeValueActionSchema",
    "ProductDiscountDraftSchema",
    "ProductDiscountMatchQuerySchema",
    "ProductDiscountPagedQueryResponseSchema",
    "ProductDiscountReferenceSchema",
    "ProductDiscountResourceIdentifierSchema",
    "ProductDiscountSchema",
    "ProductDiscountSetDescriptionActionSchema",
    "ProductDiscountSetKeyActionSchema",
    "ProductDiscountSetValidFromActionSchema",
    "ProductDiscountSetValidFromAndUntilActionSchema",
    "ProductDiscountSetValidUntilActionSchema",
    "ProductDiscountUpdateActionSchema",
    "ProductDiscountUpdateSchema",
    "ProductDiscountValueAbsoluteDraftSchema",
    "ProductDiscountValueAbsoluteSchema",
    "ProductDiscountValueDraftSchema",
    "ProductDiscountValueExternalDraftSchema",
    "ProductDiscountValueExternalSchema",
    "ProductDiscountValueRelativeDraftSchema",
    "ProductDiscountValueRelativeSchema",
    "ProductDiscountValueSchema",
]


class ProductDiscountDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountDraft`."""

    name = LocalizedStringField(allow_none=True)
    key = marshmallow.fields.String(allow_none=True, missing=None)
    description = LocalizedStringField(allow_none=True, missing=None)
    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "absolute": "commercetools._schemas._product_discount.ProductDiscountValueAbsoluteDraftSchema",
            "external": "commercetools._schemas._product_discount.ProductDiscountValueExternalDraftSchema",
            "relative": "commercetools._schemas._product_discount.ProductDiscountValueRelativeDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    predicate = marshmallow.fields.String(allow_none=True)
    sort_order = marshmallow.fields.String(allow_none=True, data_key="sortOrder")
    is_active = marshmallow.fields.Bool(allow_none=True, data_key="isActive")
    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductDiscountDraft(**data)


class ProductDiscountMatchQuerySchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountMatchQuery`."""

    product_id = marshmallow.fields.String(allow_none=True, data_key="productId")
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    staged = marshmallow.fields.Bool(allow_none=True)
    price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.QueryPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductDiscountMatchQuery(**data)


class ProductDiscountPagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountPagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._product_discount.ProductDiscountSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductDiscountPagedQueryResponse(**data)


class ProductDiscountReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._product_discount.ProductDiscountSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.ProductDiscountReference(**data)


class ProductDiscountResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.ProductDiscountResourceIdentifier(**data)


class ProductDiscountSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscount`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    name = LocalizedStringField(allow_none=True)
    key = marshmallow.fields.String(allow_none=True, missing=None)
    description = LocalizedStringField(allow_none=True, missing=None)
    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "absolute": "commercetools._schemas._product_discount.ProductDiscountValueAbsoluteSchema",
            "external": "commercetools._schemas._product_discount.ProductDiscountValueExternalSchema",
            "relative": "commercetools._schemas._product_discount.ProductDiscountValueRelativeSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    predicate = marshmallow.fields.String(allow_none=True)
    sort_order = marshmallow.fields.String(allow_none=True, data_key="sortOrder")
    is_active = marshmallow.fields.Bool(allow_none=True, data_key="isActive")
    references = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("typeId", "type_id"),
            discriminator_schemas={
                "cart-discount": "commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
                "cart": "commercetools._schemas._cart.CartReferenceSchema",
                "category": "commercetools._schemas._category.CategoryReferenceSchema",
                "channel": "commercetools._schemas._channel.ChannelReferenceSchema",
                "key-value-document": "commercetools._schemas._custom_object.CustomObjectReferenceSchema",
                "customer-group": "commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
                "customer": "commercetools._schemas._customer.CustomerReferenceSchema",
                "discount-code": "commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
                "inventory-entry": "commercetools._schemas._inventory.InventoryEntryReferenceSchema",
                "order-edit": "commercetools._schemas._order_edit.OrderEditReferenceSchema",
                "order": "commercetools._schemas._order.OrderReferenceSchema",
                "payment": "commercetools._schemas._payment.PaymentReferenceSchema",
                "product-discount": "commercetools._schemas._product_discount.ProductDiscountReferenceSchema",
                "product-type": "commercetools._schemas._product_type.ProductTypeReferenceSchema",
                "product": "commercetools._schemas._product.ProductReferenceSchema",
                "review": "commercetools._schemas._review.ReviewReferenceSchema",
                "shipping-method": "commercetools._schemas._shipping_method.ShippingMethodReferenceSchema",
                "shopping-list": "commercetools._schemas._shopping_list.ShoppingListReferenceSchema",
                "state": "commercetools._schemas._state.StateReferenceSchema",
                "store": "commercetools._schemas._store.StoreReferenceSchema",
                "tax-category": "commercetools._schemas._tax_category.TaxCategoryReferenceSchema",
                "type": "commercetools._schemas._type.TypeReferenceSchema",
                "zone": "commercetools._schemas._zone.ZoneReferenceSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )
    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductDiscount(**data)


class ProductDiscountUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountUpdateAction(**data)


class ProductDiscountUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "changeIsActive": "commercetools._schemas._product_discount.ProductDiscountChangeIsActiveActionSchema",
                "changeName": "commercetools._schemas._product_discount.ProductDiscountChangeNameActionSchema",
                "changePredicate": "commercetools._schemas._product_discount.ProductDiscountChangePredicateActionSchema",
                "changeSortOrder": "commercetools._schemas._product_discount.ProductDiscountChangeSortOrderActionSchema",
                "changeValue": "commercetools._schemas._product_discount.ProductDiscountChangeValueActionSchema",
                "setDescription": "commercetools._schemas._product_discount.ProductDiscountSetDescriptionActionSchema",
                "setKey": "commercetools._schemas._product_discount.ProductDiscountSetKeyActionSchema",
                "setValidFrom": "commercetools._schemas._product_discount.ProductDiscountSetValidFromActionSchema",
                "setValidFromAndUntil": "commercetools._schemas._product_discount.ProductDiscountSetValidFromAndUntilActionSchema",
                "setValidUntil": "commercetools._schemas._product_discount.ProductDiscountSetValidUntilActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductDiscountUpdate(**data)


class ProductDiscountValueDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueDraft`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueDraft(**data)


class ProductDiscountValueSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValue`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValue(**data)


class ProductDiscountChangeIsActiveActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountChangeIsActiveAction`."""

    is_active = marshmallow.fields.Bool(allow_none=True, data_key="isActive")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountChangeIsActiveAction(**data)


class ProductDiscountChangeNameActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountChangeNameAction`."""

    name = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountChangeNameAction(**data)


class ProductDiscountChangePredicateActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountChangePredicateAction`."""

    predicate = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountChangePredicateAction(**data)


class ProductDiscountChangeSortOrderActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountChangeSortOrderAction`."""

    sort_order = marshmallow.fields.String(allow_none=True, data_key="sortOrder")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountChangeSortOrderAction(**data)


class ProductDiscountChangeValueActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountChangeValueAction`."""

    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "absolute": "commercetools._schemas._product_discount.ProductDiscountValueAbsoluteDraftSchema",
            "external": "commercetools._schemas._product_discount.ProductDiscountValueExternalDraftSchema",
            "relative": "commercetools._schemas._product_discount.ProductDiscountValueRelativeDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountChangeValueAction(**data)


class ProductDiscountSetDescriptionActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountSetDescriptionAction`."""

    description = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountSetDescriptionAction(**data)


class ProductDiscountSetKeyActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountSetKeyAction`."""

    key = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountSetKeyAction(**data)


class ProductDiscountSetValidFromActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountSetValidFromAction`."""

    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountSetValidFromAction(**data)


class ProductDiscountSetValidFromAndUntilActionSchema(
    ProductDiscountUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountSetValidFromAndUntilAction`."""

    valid_from = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validFrom"
    )
    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountSetValidFromAndUntilAction(**data)


class ProductDiscountSetValidUntilActionSchema(ProductDiscountUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountSetValidUntilAction`."""

    valid_until = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="validUntil"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.ProductDiscountSetValidUntilAction(**data)


class ProductDiscountValueAbsoluteDraftSchema(ProductDiscountValueDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueAbsoluteDraft`."""

    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueAbsoluteDraft(**data)


class ProductDiscountValueAbsoluteSchema(ProductDiscountValueSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueAbsolute`."""

    money = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("type", "type"),
            discriminator_schemas={
                "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
                "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueAbsolute(**data)


class ProductDiscountValueExternalDraftSchema(ProductDiscountValueDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueExternalDraft`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueExternalDraft()


class ProductDiscountValueExternalSchema(ProductDiscountValueSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueExternal`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueExternal()


class ProductDiscountValueRelativeDraftSchema(ProductDiscountValueDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueRelativeDraft`."""

    permyriad = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueRelativeDraft(**data)


class ProductDiscountValueRelativeSchema(ProductDiscountValueSchema):
    """Marshmallow schema for :class:`commercetools.types.ProductDiscountValueRelative`."""

    permyriad = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDiscountValueRelative(**data)
