# coding: utf-8

"""
    Stitch Connect

    https://www.stitchdata.com/docs/developers/stitch-connect/api  # noqa: E501

    The version of the OpenAPI document: 0.4.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from stitch_connect_client.configuration import Configuration


class ConnectionCheck(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "mode": "str",
        "status": "str",
        "start_time": "str",
        "completion_time": "str",
        "error": "bool",
        "check_exit_status": "int",
        "discovery_exit_status": "int",
        "discovery_error_message": "str",
        "tap_exit_status": "int",
        "tap_error_message": "str",
        "target_exit_status": "int",
        "target_error_message": "str",
    }

    attribute_map = {
        "name": "name",
        "mode": "mode",
        "status": "status",
        "start_time": "start_time",
        "completion_time": "completion_time",
        "error": "error",
        "check_exit_status": "check_exit_status",
        "discovery_exit_status": "discovery_exit_status",
        "discovery_error_message": "discovery_error_message",
        "tap_exit_status": "tap_exit_status",
        "tap_error_message": "tap_error_message",
        "target_exit_status": "target_exit_status",
        "target_error_message": "target_error_message",
    }

    def __init__(
        self,
        name=None,
        mode=None,
        status=None,
        start_time=None,
        completion_time=None,
        error=None,
        check_exit_status=None,
        discovery_exit_status=None,
        discovery_error_message=None,
        tap_exit_status=None,
        tap_error_message=None,
        target_exit_status=None,
        target_error_message=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ConnectionCheck - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._mode = None
        self._status = None
        self._start_time = None
        self._completion_time = None
        self._error = None
        self._check_exit_status = None
        self._discovery_exit_status = None
        self._discovery_error_message = None
        self._tap_exit_status = None
        self._tap_error_message = None
        self._target_exit_status = None
        self._target_error_message = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if mode is not None:
            self.mode = mode
        if status is not None:
            self.status = status
        if start_time is not None:
            self.start_time = start_time
        if completion_time is not None:
            self.completion_time = completion_time
        if error is not None:
            self.error = error
        if check_exit_status is not None:
            self.check_exit_status = check_exit_status
        if discovery_exit_status is not None:
            self.discovery_exit_status = discovery_exit_status
        if discovery_error_message is not None:
            self.discovery_error_message = discovery_error_message
        if tap_exit_status is not None:
            self.tap_exit_status = tap_exit_status
        if tap_error_message is not None:
            self.tap_error_message = tap_error_message
        if target_exit_status is not None:
            self.target_exit_status = target_exit_status
        if target_error_message is not None:
            self.target_error_message = target_error_message

    @property
    def name(self):
        """Gets the name of this ConnectionCheck.  # noqa: E501

        The name of the connection check job.  # noqa: E501

        :return: The name of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ConnectionCheck.

        The name of the connection check job.  # noqa: E501

        :param name: The name of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def mode(self):
        """Gets the mode of this ConnectionCheck.  # noqa: E501

        This value will always be `check`.  # noqa: E501

        :return: The mode of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this ConnectionCheck.

        This value will always be `check`.  # noqa: E501

        :param mode: The mode of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._mode = mode

    @property
    def status(self):
        """Gets the status of this ConnectionCheck.  # noqa: E501

        The status of the connection check job. Possible values are: - running - succeeded - failed   # noqa: E501

        :return: The status of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ConnectionCheck.

        The status of the connection check job. Possible values are: - running - succeeded - failed   # noqa: E501

        :param status: The status of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def start_time(self):
        """Gets the start_time of this ConnectionCheck.  # noqa: E501

        The date and time the connection check job started.  # noqa: E501

        :return: The start_time of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this ConnectionCheck.

        The date and time the connection check job started.  # noqa: E501

        :param start_time: The start_time of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._start_time = start_time

    @property
    def completion_time(self):
        """Gets the completion_time of this ConnectionCheck.  # noqa: E501

        The date and time the connection check job was completed.  # noqa: E501

        :return: The completion_time of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._completion_time

    @completion_time.setter
    def completion_time(self, completion_time):
        """Sets the completion_time of this ConnectionCheck.

        The date and time the connection check job was completed.  # noqa: E501

        :param completion_time: The completion_time of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._completion_time = completion_time

    @property
    def error(self):
        """Gets the error of this ConnectionCheck.  # noqa: E501

        Indicates if the connection check job resulted in an error. This will be true if any of the exit_status properties are non-zero.   # noqa: E501

        :return: The error of this ConnectionCheck.  # noqa: E501
        :rtype: bool
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ConnectionCheck.

        Indicates if the connection check job resulted in an error. This will be true if any of the exit_status properties are non-zero.   # noqa: E501

        :param error: The error of this ConnectionCheck.  # noqa: E501
        :type: bool
        """

        self._error = error

    @property
    def check_exit_status(self):
        """Gets the check_exit_status of this ConnectionCheck.  # noqa: E501

        The exit status of the connection check job. Possible values are: null - The connection check job is still running 0 - The connection check job was successful 1 - The connection check job was unsuccessful   # noqa: E501

        :return: The check_exit_status of this ConnectionCheck.  # noqa: E501
        :rtype: int
        """
        return self._check_exit_status

    @check_exit_status.setter
    def check_exit_status(self, check_exit_status):
        """Sets the check_exit_status of this ConnectionCheck.

        The exit status of the connection check job. Possible values are: null - The connection check job is still running 0 - The connection check job was successful 1 - The connection check job was unsuccessful   # noqa: E501

        :param check_exit_status: The check_exit_status of this ConnectionCheck.  # noqa: E501
        :type: int
        """

        self._check_exit_status = check_exit_status

    @property
    def discovery_exit_status(self):
        """Gets the discovery_exit_status of this ConnectionCheck.  # noqa: E501

        The exit status of the discovery portion of the connection check job. Possible values are: null - Job is still running 0 - Job was successful Any non-zero value - Discovery failed   # noqa: E501

        :return: The discovery_exit_status of this ConnectionCheck.  # noqa: E501
        :rtype: int
        """
        return self._discovery_exit_status

    @discovery_exit_status.setter
    def discovery_exit_status(self, discovery_exit_status):
        """Sets the discovery_exit_status of this ConnectionCheck.

        The exit status of the discovery portion of the connection check job. Possible values are: null - Job is still running 0 - Job was successful Any non-zero value - Discovery failed   # noqa: E501

        :param discovery_exit_status: The discovery_exit_status of this ConnectionCheck.  # noqa: E501
        :type: int
        """

        self._discovery_exit_status = discovery_exit_status

    @property
    def discovery_error_message(self):
        """Gets the discovery_error_message of this ConnectionCheck.  # noqa: E501

        Exception message raised when discovery failed during the connection check job. If successful, this will be null.   # noqa: E501

        :return: The discovery_error_message of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._discovery_error_message

    @discovery_error_message.setter
    def discovery_error_message(self, discovery_error_message):
        """Sets the discovery_error_message of this ConnectionCheck.

        Exception message raised when discovery failed during the connection check job. If successful, this will be null.   # noqa: E501

        :param discovery_error_message: The discovery_error_message of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._discovery_error_message = discovery_error_message

    @property
    def tap_exit_status(self):
        """Gets the tap_exit_status of this ConnectionCheck.  # noqa: E501

        The exit status of the tap. Possible values are: null - Tap is still running 0 - Tap was successful Any non-zero value - Tap failed   # noqa: E501

        :return: The tap_exit_status of this ConnectionCheck.  # noqa: E501
        :rtype: int
        """
        return self._tap_exit_status

    @tap_exit_status.setter
    def tap_exit_status(self, tap_exit_status):
        """Sets the tap_exit_status of this ConnectionCheck.

        The exit status of the tap. Possible values are: null - Tap is still running 0 - Tap was successful Any non-zero value - Tap failed   # noqa: E501

        :param tap_exit_status: The tap_exit_status of this ConnectionCheck.  # noqa: E501
        :type: int
        """

        self._tap_exit_status = tap_exit_status

    @property
    def tap_error_message(self):
        """Gets the tap_error_message of this ConnectionCheck.  # noqa: E501

        Exception message raised when extraction failed during the job. If successful, this will be null.   # noqa: E501

        :return: The tap_error_message of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._tap_error_message

    @tap_error_message.setter
    def tap_error_message(self, tap_error_message):
        """Sets the tap_error_message of this ConnectionCheck.

        Exception message raised when extraction failed during the job. If successful, this will be null.   # noqa: E501

        :param tap_error_message: The tap_error_message of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._tap_error_message = tap_error_message

    @property
    def target_exit_status(self):
        """Gets the target_exit_status of this ConnectionCheck.  # noqa: E501

        The exit status of the target portion of the connection check job. Possible values are: null - Target is still running 0 - Target was successful Any non-zero value - Target failed   # noqa: E501

        :return: The target_exit_status of this ConnectionCheck.  # noqa: E501
        :rtype: int
        """
        return self._target_exit_status

    @target_exit_status.setter
    def target_exit_status(self, target_exit_status):
        """Sets the target_exit_status of this ConnectionCheck.

        The exit status of the target portion of the connection check job. Possible values are: null - Target is still running 0 - Target was successful Any non-zero value - Target failed   # noqa: E501

        :param target_exit_status: The target_exit_status of this ConnectionCheck.  # noqa: E501
        :type: int
        """

        self._target_exit_status = target_exit_status

    @property
    def target_error_message(self):
        """Gets the target_error_message of this ConnectionCheck.  # noqa: E501

        This value will always be null.  # noqa: E501

        :return: The target_error_message of this ConnectionCheck.  # noqa: E501
        :rtype: str
        """
        return self._target_error_message

    @target_error_message.setter
    def target_error_message(self, target_error_message):
        """Sets the target_error_message of this ConnectionCheck.

        This value will always be null.  # noqa: E501

        :param target_error_message: The target_error_message of this ConnectionCheck.  # noqa: E501
        :type: str
        """

        self._target_error_message = target_error_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConnectionCheck):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConnectionCheck):
            return True

        return self.to_dict() != other.to_dict()
