/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api.backend;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ReaderBackendUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MemoryReaderBackend
implements ReaderBackend {
    private final Map<String, byte[]> files;

    private MemoryReaderBackend(Map<String, byte[]> files) {
        this.files = files;
    }

    public static ReaderBackend open(Map<String, byte[]> files) {
        return new MemoryReaderBackend(files);
    }

    public static ReaderBackend fromZipStream(InputStream is) throws IOException {
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getSize() > Integer.MAX_VALUE) {
                    throw new IOException("File is too large: " + entry.getName());
                }
                if (!entry.isDirectory()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ReaderBackendUtils.copy(zis, baos, 8192);
                    files.put(entry.getName(), baos.toByteArray());
                }
                zis.closeEntry();
            }
        }
        return MemoryReaderBackend.open(files);
    }

    public void put(String resourceName, byte[] bytes) {
        this.files.put(resourceName, bytes);
    }

    @Override
    public InputStream getInputStream(String resourceName) throws FileNotFoundException {
        byte[] bytes = this.files.get(resourceName);
        if (bytes == null) {
            throw new FileNotFoundException(resourceName);
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public boolean exists(String resourceName) {
        return this.files.containsKey(resourceName);
    }

    @Override
    public Collection<String> list() {
        return this.files.keySet();
    }

    @Override
    public void close() {
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.files.size());
    }
}

