/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryImpl;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.StringConverter;
import ai.h2o.mojos.runtime.frame.StringToDateConverter;
import ai.h2o.mojos.runtime.transforms.J;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilder;
import ai.h2o.mojos.runtime.transforms.c;
import ai.h2o.mojos.runtime.transforms.l;
import ai.h2o.mojos.runtime.utils.DateParser;
import ai.h2o.mojos.runtime.utils.MojoDateTimeParserFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class MojoPipelineProtoImpl
extends MojoPipeline {
    private MojoFrameMeta inputFrameMetaLazy;
    private MojoFrameMeta outputFrameMetaLazy;
    final List<MojoTransformMeta> transforms;
    private final MojoPipelineMeta pipelineMetainfo;
    private final Map<String, StringConverter> dateTimeConverters = new HashMap<String, StringConverter>(0);
    private boolean shapEnabled = false;
    private Collection<String> shapColumnNamesLazy;

    public MojoPipelineProtoImpl(List<MojoTransformMeta> transforms, MojoPipelineMeta pipelineMetainfo) {
        super(pipelineMetainfo.uuid, pipelineMetainfo.creationTime, pipelineMetainfo.license);
        this.transforms = transforms;
        this.pipelineMetainfo = pipelineMetainfo;
        if (pipelineMetainfo.datetimeStringFormats != null) {
            for (Map.Entry<String, String> entry : pipelineMetainfo.datetimeStringFormats.entrySet()) {
                DateParser dateParser = new DateParser(MojoDateTimeParserFactory.forPattern(entry.getValue()));
                this.dateTimeConverters.put(entry.getKey(), new StringToDateConverter(dateParser));
            }
        }
    }

    @Override
    protected MojoFrameBuilder getFrameBuilder(MojoColumn.Kind kind) {
        return new MojoFrameBuilder(this.getMeta(kind), Arrays.asList(this.pipelineMetainfo.missingValues), this.dateTimeConverters);
    }

    @Override
    protected MojoFrameMeta getMeta(MojoColumn.Kind kind) {
        switch (kind) {
            case Feature: {
                if (this.inputFrameMetaLazy == null) {
                    this.inputFrameMetaLazy = this.pipelineMetainfo.createInputMeta();
                }
                return this.inputFrameMetaLazy;
            }
            case Output: {
                if (this.outputFrameMetaLazy == null) {
                    this.outputFrameMetaLazy = this.shapEnabled ? this.shapCreatePredictContribFrame() : this.pipelineMetainfo.createOutputMeta();
                }
                if (this.outputFrameMetaLazy.size() == 0) {
                    throw new IllegalStateException("No columns in output frame");
                }
                return this.outputFrameMetaLazy;
            }
        }
        throw new UnsupportedOperationException("Cannot generate meta for interim frame");
    }

    MojoFrame constructGlobalFrame(MojoFrame inputFrame, MojoFrame outputFrame) {
        ArrayList<MojoColumn> arrayList = new ArrayList<MojoColumn>();
        MojoFrameMeta mojoFrameMeta = inputFrame.getMeta();
        MojoFrameMeta mojoFrameMeta2 = outputFrame.getMeta();
        ArrayList<MojoColumnMeta> arrayList2 = new ArrayList<MojoColumnMeta>(this.pipelineMetainfo.getColumns());
        if (this.shapEnabled) {
            for (String object2 : this.shapCollectColumnNames()) {
                arrayList2.add(MojoColumnMeta.newOutput(object2, MojoColumn.Type.Float64));
            }
        }
        int n2 = inputFrame.getNrows();
        MojoColumnFactoryImpl mojoColumnFactoryImpl = new MojoColumnFactoryImpl();
        for (MojoColumnMeta mojoColumnMeta : arrayList2) {
            String string = mojoColumnMeta.getColumnName();
            Integer n3 = mojoFrameMeta.indexOf(string);
            if (n3 != null) {
                arrayList.add(inputFrame.getColumn(n3));
                continue;
            }
            Integer n4 = mojoFrameMeta2.indexOf(string);
            if (n4 != null) {
                arrayList.add(outputFrame.getColumn(n4));
                continue;
            }
            MojoColumn mojoColumn = mojoColumnFactoryImpl.create(mojoColumnMeta.getColumnType(), n2);
            arrayList.add(mojoColumn);
        }
        return MojoFrameBuilder.fromColumns(new MojoFrameMeta(arrayList2), arrayList.toArray(new MojoColumn[0]));
    }

    @Override
    public MojoFrame transform(MojoFrame inputFrame, MojoFrame outputFrame) {
        assert (outputFrame.getNcols() > 0);
        MojoFrame mojoFrame = this.constructGlobalFrame(inputFrame, outputFrame);
        if (!this.shapEnabled) {
            for (MojoTransformMeta mojoTransformMeta : this.transforms) {
                MojoTransform mojoTransform = mojoTransformMeta.getTransform();
                mojoTransform.transform(mojoFrame);
            }
        } else {
            for (MojoTransformMeta mojoTransformMeta : this.transforms) {
                mojoTransformMeta.getTransform().transform(mojoFrame);
                J j2 = MojoPipelineProtoImpl.toShapCapable(mojoTransformMeta);
                if (j2 == null) continue;
                j2.a(mojoFrame, outputFrame);
            }
        }
        return outputFrame;
    }

    private static J toShapCapable(MojoTransformMeta transformMeta) throws UnsupportedOperationException {
        MojoTransform mojoTransform = transformMeta.getTransform();
        if (!(mojoTransform instanceof c)) {
            return null;
        }
        if (!(mojoTransform instanceof J)) {
            throw new UnsupportedOperationException(String.format("SHAP is not implemented for %s model", transformMeta.getName()));
        }
        J j2 = (J)((Object)mojoTransform);
        if (!j2.b()) {
            throw new UnsupportedOperationException(String.format("Missing SHAP data in %s model", transformMeta.getName()));
        }
        return j2;
    }

    @Override
    public void setShapPredictContrib(boolean enable) {
        if (enable == this.shapEnabled) {
            return;
        }
        if (this.outputFrameMetaLazy != null) {
            throw new IllegalStateException("Cannot change SHAP flag after internal output columns have been created");
        }
        this.shapEnabled = enable;
    }

    private Collection<String> shapCollectColumnNames() {
        if (this.shapColumnNamesLazy == null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (MojoTransformMeta mojoTransformMeta : this.transforms) {
                J j2;
                MojoTransformBuilder mojoTransformBuilder = mojoTransformMeta.getTransformBuilder();
                if (mojoTransformBuilder instanceof l || (j2 = MojoPipelineProtoImpl.toShapCapable(mojoTransformMeta)) == null) continue;
                linkedHashSet.addAll(j2.a());
            }
            this.shapColumnNamesLazy = linkedHashSet;
        }
        return this.shapColumnNamesLazy;
    }

    private MojoFrameMeta shapCreatePredictContribFrame() {
        String[] stringArray = this.shapCollectColumnNames().toArray(new String[0]);
        MojoColumn.Type[] typeArray = new MojoColumn.Type[stringArray.length];
        Arrays.fill((Object[])typeArray, (Object)MojoColumn.Type.Float64);
        return new MojoFrameMeta(MojoColumnMeta.toColumns(stringArray, typeArray, MojoColumn.Kind.Output));
    }

    public static class MojoPipelineMeta {
        public MojoFrameMeta globalMeta;
        public int[] inputIndices;
        public int[] outputIndices;
        public String uuid;
        public DateTime creationTime;
        public String license;
        public String[] missingValues;
        public Map<String, String> datetimeStringFormats;

        public MojoFrameMeta createInputMeta() {
            String[] stringArray = new String[this.inputIndices.length];
            MojoColumn.Type[] typeArray = new MojoColumn.Type[this.inputIndices.length];
            for (int i2 = 0; i2 < this.inputIndices.length; ++i2) {
                int n2 = this.inputIndices[i2];
                stringArray[i2] = this.globalMeta.getColumnName(n2);
                typeArray[i2] = this.globalMeta.getColumnType(n2);
            }
            return new MojoFrameMeta(MojoColumnMeta.toColumns(stringArray, typeArray, MojoColumn.Kind.Feature));
        }

        public MojoFrameMeta createOutputMeta() {
            String[] stringArray = new String[this.outputIndices.length];
            MojoColumn.Type[] typeArray = new MojoColumn.Type[this.outputIndices.length];
            for (int i2 = 0; i2 < this.outputIndices.length; ++i2) {
                int n2 = this.outputIndices[i2];
                stringArray[i2] = this.globalMeta.getColumnName(n2);
                typeArray[i2] = this.globalMeta.getColumnType(n2);
            }
            return new MojoFrameMeta(MojoColumnMeta.toColumns(stringArray, typeArray, MojoColumn.Kind.Output));
        }

        public List<MojoColumnMeta> getColumns() {
            return this.globalMeta.getColumns();
        }
    }
}

