import enum


class ItemType(enum.IntEnum):
    """List of all available Terraria item types.

    From https://github.com/tModLoader/tModLoader/wiki/Vanilla-Item-IDs ."""

    YELLOW_PHASESABER_OLD = -24
    WHITE_PHASESABER_OLD = -23
    PURPLE_PHASESABER_OLD = -22
    GREEN_PHASESABER_OLD = -21
    RED_PHASESABER_OLD = -20
    BLUE_PHASESABER_OLD = -19
    PLATINUM_BOW_OLD = -48
    PLATINUM_HAMMER_OLD = -47
    PLATINUM_AXE_OLD = -46
    PLATINUM_SHORTSWORD_OLD = -45
    PLATINUM_BROADSWORD_OLD = -44
    PLATINUM_PICKAXE_OLD = -43
    TUNGSTEN_BOW_OLD = -42
    TUNGSTEN_HAMMER_OLD = -41
    TUNGSTEN_AXE_OLD = -40
    TUNGSTEN_SHORTSWORD_OLD = -39
    TUNGSTEN_BROADSWORD_OLD = -38
    TUNGSTEN_PICKAXE_OLD = -37
    LEAD_BOW_OLD = -36
    LEAD_HAMMER_OLD = -35
    LEAD_AXE_OLD = -34
    LEAD_SHORTSWORD_OLD = -33
    LEAD_BROADSWORD_OLD = -32
    LEAD_PICKAXE_OLD = -31
    TIN_BOW_OLD = -30
    TIN_HAMMER_OLD = -29
    TIN_AXE_OLD = -28
    TIN_SHORTSWORD_OLD = -27
    TIN_BROADSWORD_OLD = -26
    TIN_PICKAXE_OLD = -25
    COPPER_BOW_OLD = -18
    COPPER_HAMMER_OLD = -17
    COPPER_AXE_OLD = -16
    COPPER_SHORTSWORD_OLD = -15
    COPPER_BROADSWORD_OLD = -14
    COPPER_PICKAXE_OLD = -13
    SILVER_BOW_OLD = -12
    SILVER_HAMMER_OLD = -11
    SILVER_AXE_OLD = -10
    SILVER_SHORTSWORD_OLD = -9
    SILVER_BROADSWORD_OLD = -8
    SILVER_PICKAXE_OLD = -7
    GOLD_BOW_OLD = -6
    GOLD_HAMMER_OLD = -5
    GOLD_AXE_OLD = -4
    GOLD_SHORTSWORD_OLD = -3
    GOLD_BROADSWORD_OLD = -2
    GOLD_PICKAXE_OLD = -1
    NONE = 0
    IRON_PICKAXE = 1
    DIRT_BLOCK = 2
    STONE_BLOCK = 3
    IRON_BROADSWORD = 4
    MUSHROOM = 5
    IRON_SHORTSWORD = 6
    IRON_HAMMER = 7
    TORCH = 8
    WOOD = 9
    IRON_AXE = 10
    IRON_ORE = 11
    COPPER_ORE = 12
    GOLD_ORE = 13
    SILVER_ORE = 14
    COPPER_WATCH = 15
    SILVER_WATCH = 16
    GOLD_WATCH = 17
    DEPTH_METER = 18
    GOLD_BAR = 19
    COPPER_BAR = 20
    SILVER_BAR = 21
    IRON_BAR = 22
    GEL = 23
    WOODEN_SWORD = 24
    WOODEN_DOOR = 25
    STONE_WALL = 26
    ACORN = 27
    LESSER_HEALING_POTION = 28
    LIFE_CRYSTAL = 29
    DIRT_WALL = 30
    BOTTLE = 31
    WOODEN_TABLE = 32
    FURNACE = 33
    WOODEN_CHAIR = 34
    IRON_ANVIL = 35
    WORK_BENCH = 36
    GOGGLES = 37
    LENS = 38
    WOODEN_BOW = 39
    WOODEN_ARROW = 40
    FLAMING_ARROW = 41
    SHURIKEN = 42
    SUSPICIOUS_LOOKING_EYE = 43
    DEMON_BOW = 44
    WAR_AXEOFTHE_NIGHT = 45
    LIGHTS_BANE = 46
    UNHOLY_ARROW = 47
    CHEST = 48
    BANDOF_REGENERATION = 49
    MAGIC_MIRROR = 50
    JESTERS_ARROW = 51
    ANGEL_STATUE = 52
    CLOUDINA_BOTTLE = 53
    HERMES_BOOTS = 54
    ENCHANTED_BOOMERANG = 55
    DEMONITE_ORE = 56
    DEMONITE_BAR = 57
    HEART = 58
    CORRUPT_SEEDS = 59
    VILE_MUSHROOM = 60
    EBONSTONE_BLOCK = 61
    GRASS_SEEDS = 62
    SUNFLOWER = 63
    VILETHORN = 64
    STARFURY = 65
    PURIFICATION_POWDER = 66
    VILE_POWDER = 67
    ROTTEN_CHUNK = 68
    WORM_TOOTH = 69
    WORM_FOOD = 70
    COPPER_COIN = 71
    SILVER_COIN = 72
    GOLD_COIN = 73
    PLATINUM_COIN = 74
    FALLEN_STAR = 75
    COPPER_GREAVES = 76
    IRON_GREAVES = 77
    SILVER_GREAVES = 78
    GOLD_GREAVES = 79
    COPPER_CHAINMAIL = 80
    IRON_CHAINMAIL = 81
    SILVER_CHAINMAIL = 82
    GOLD_CHAINMAIL = 83
    GRAPPLING_HOOK = 84
    CHAIN = 85
    SHADOW_SCALE = 86
    PIGGY_BANK = 87
    MINING_HELMET = 88
    COPPER_HELMET = 89
    IRON_HELMET = 90
    SILVER_HELMET = 91
    GOLD_HELMET = 92
    WOOD_WALL = 93
    WOOD_PLATFORM = 94
    FLINTLOCK_PISTOL = 95
    MUSKET = 96
    MUSKET_BALL = 97
    MINISHARK = 98
    IRON_BOW = 99
    SHADOW_GREAVES = 100
    SHADOW_SCALEMAIL = 101
    SHADOW_HELMET = 102
    NIGHTMARE_PICKAXE = 103
    THE_BREAKER = 104
    CANDLE = 105
    COPPER_CHANDELIER = 106
    SILVER_CHANDELIER = 107
    GOLD_CHANDELIER = 108
    MANA_CRYSTAL = 109
    LESSER_MANA_POTION = 110
    BANDOF_STARPOWER = 111
    FLOWEROF_FIRE = 112
    MAGIC_MISSILE = 113
    DIRT_ROD = 114
    SHADOW_ORB = 115
    METEORITE = 116
    METEORITE_BAR = 117
    HOOK = 118
    FLAMARANG = 119
    MOLTEN_FURY = 120
    FIERY_GREATSWORD = 121
    MOLTEN_PICKAXE = 122
    METEOR_HELMET = 123
    METEOR_SUIT = 124
    METEOR_LEGGINGS = 125
    BOTTLED_WATER = 126
    SPACE_GUN = 127
    ROCKET_BOOTS = 128
    GRAY_BRICK = 129
    GRAY_BRICK_WALL = 130
    RED_BRICK = 131
    RED_BRICK_WALL = 132
    CLAY_BLOCK = 133
    BLUE_BRICK = 134
    BLUE_BRICK_WALL = 135
    CHAIN_LANTERN = 136
    GREEN_BRICK = 137
    GREEN_BRICK_WALL = 138
    PINK_BRICK = 139
    PINK_BRICK_WALL = 140
    GOLD_BRICK = 141
    GOLD_BRICK_WALL = 142
    SILVER_BRICK = 143
    SILVER_BRICK_WALL = 144
    COPPER_BRICK = 145
    COPPER_BRICK_WALL = 146
    SPIKE = 147
    WATER_CANDLE = 148
    BOOK = 149
    COBWEB = 150
    NECRO_HELMET = 151
    NECRO_BREASTPLATE = 152
    NECRO_GREAVES = 153
    BONE = 154
    MURAMASA = 155
    COBALT_SHIELD = 156
    AQUA_SCEPTER = 157
    LUCKY_HORSESHOE = 158
    SHINY_RED_BALLOON = 159
    HARPOON = 160
    SPIKY_BALL = 161
    BALL_OHURT = 162
    BLUE_MOON = 163
    HANDGUN = 164
    WATER_BOLT = 165
    BOMB = 166
    DYNAMITE = 167
    GRENADE = 168
    SAND_BLOCK = 169
    GLASS = 170
    SIGN = 171
    ASH_BLOCK = 172
    OBSIDIAN = 173
    HELLSTONE = 174
    HELLSTONE_BAR = 175
    MUD_BLOCK = 176
    SAPPHIRE = 177
    RUBY = 178
    EMERALD = 179
    TOPAZ = 180
    AMETHYST = 181
    DIAMOND = 182
    GLOWING_MUSHROOM = 183
    STAR = 184
    IVY_WHIP = 185
    BREATHING_REED = 186
    FLIPPER = 187
    HEALING_POTION = 188
    MANA_POTION = 189
    BLADEOF_GRASS = 190
    THORN_CHAKRAM = 191
    OBSIDIAN_BRICK = 192
    OBSIDIAN_SKULL = 193
    MUSHROOM_GRASS_SEEDS = 194
    JUNGLE_GRASS_SEEDS = 195
    WOODEN_HAMMER = 196
    STAR_CANNON = 197
    BLUE_PHASEBLADE = 198
    RED_PHASEBLADE = 199
    GREEN_PHASEBLADE = 200
    PURPLE_PHASEBLADE = 201
    WHITE_PHASEBLADE = 202
    YELLOW_PHASEBLADE = 203
    METEOR_HAMAXE = 204
    EMPTY_BUCKET = 205
    WATER_BUCKET = 206
    LAVA_BUCKET = 207
    JUNGLE_ROSE = 208
    STINGER = 209
    VINE = 210
    FERAL_CLAWS = 211
    ANKLETOFTHE_WIND = 212
    STAFFOF_REGROWTH = 213
    HELLSTONE_BRICK = 214
    WHOOPIE_CUSHION = 215
    SHACKLE = 216
    MOLTEN_HAMAXE = 217
    FLAMELASH = 218
    PHOENIX_BLASTER = 219
    SUNFURY = 220
    HELLFORGE = 221
    CLAY_POT = 222
    NATURES_GIFT = 223
    BED = 224
    SILK = 225
    LESSER_RESTORATION_POTION = 226
    RESTORATION_POTION = 227
    JUNGLE_HAT = 228
    JUNGLE_SHIRT = 229
    JUNGLE_PANTS = 230
    MOLTEN_HELMET = 231
    MOLTEN_BREASTPLATE = 232
    MOLTEN_GREAVES = 233
    METEOR_SHOT = 234
    STICKY_BOMB = 235
    BLACK_LENS = 236
    SUNGLASSES = 237
    WIZARD_HAT = 238
    TOP_HAT = 239
    TUXEDO_SHIRT = 240
    TUXEDO_PANTS = 241
    SUMMER_HAT = 242
    BUNNY_HOOD = 243
    PLUMBERS_HAT = 244
    PLUMBERS_SHIRT = 245
    PLUMBERS_PANTS = 246
    HEROS_HAT = 247
    HEROS_SHIRT = 248
    HEROS_PANTS = 249
    FISH_BOWL = 250
    ARCHAEOLOGISTS_HAT = 251
    ARCHAEOLOGISTS_JACKET = 252
    ARCHAEOLOGISTS_PANTS = 253
    BLACK_THREAD = 254
    GREEN_THREAD = 255
    NINJA_HOOD = 256
    NINJA_SHIRT = 257
    NINJA_PANTS = 258
    LEATHER = 259
    RED_HAT = 260
    GOLDFISH = 261
    ROBE = 262
    ROBOT_HAT = 263
    GOLD_CROWN = 264
    HELLFIRE_ARROW = 265
    SANDGUN = 266
    GUIDE_VOODOO_DOLL = 267
    DIVING_HELMET = 268
    FAMILIAR_SHIRT = 269
    FAMILIAR_PANTS = 270
    FAMILIAR_WIG = 271
    DEMON_SCYTHE = 272
    NIGHTS_EDGE = 273
    DARK_LANCE = 274
    CORAL = 275
    CACTUS = 276
    TRIDENT = 277
    SILVER_BULLET = 278
    THROWING_KNIFE = 279
    SPEAR = 280
    BLOWPIPE = 281
    GLOWSTICK = 282
    SEED = 283
    WOODEN_BOOMERANG = 284
    AGLET = 285
    STICKY_GLOWSTICK = 286
    POISONED_KNIFE = 287
    OBSIDIAN_SKIN_POTION = 288
    REGENERATION_POTION = 289
    SWIFTNESS_POTION = 290
    GILLS_POTION = 291
    IRONSKIN_POTION = 292
    MANA_REGENERATION_POTION = 293
    MAGIC_POWER_POTION = 294
    FEATHERFALL_POTION = 295
    SPELUNKER_POTION = 296
    INVISIBILITY_POTION = 297
    SHINE_POTION = 298
    NIGHT_OWL_POTION = 299
    BATTLE_POTION = 300
    THORNS_POTION = 301
    WATER_WALKING_POTION = 302
    ARCHERY_POTION = 303
    HUNTER_POTION = 304
    GRAVITATION_POTION = 305
    GOLD_CHEST = 306
    DAYBLOOM_SEEDS = 307
    MOONGLOW_SEEDS = 308
    BLINKROOT_SEEDS = 309
    DEATHWEED_SEEDS = 310
    WATERLEAF_SEEDS = 311
    FIREBLOSSOM_SEEDS = 312
    DAYBLOOM = 313
    MOONGLOW = 314
    BLINKROOT = 315
    DEATHWEED = 316
    WATERLEAF = 317
    FIREBLOSSOM = 318
    SHARK_FIN = 319
    FEATHER = 320
    TOMBSTONE = 321
    MIME_MASK = 322
    ANTLION_MANDIBLE = 323
    ILLEGAL_GUN_PARTS = 324
    THE_DOCTORS_SHIRT = 325
    THE_DOCTORS_PANTS = 326
    GOLDEN_KEY = 327
    SHADOW_CHEST = 328
    SHADOW_KEY = 329
    OBSIDIAN_BRICK_WALL = 330
    JUNGLE_SPORES = 331
    LOOM = 332
    PIANO = 333
    DRESSER = 334
    BENCH = 335
    BATHTUB = 336
    RED_BANNER = 337
    GREEN_BANNER = 338
    BLUE_BANNER = 339
    YELLOW_BANNER = 340
    LAMP_POST = 341
    TIKI_TORCH = 342
    BARREL = 343
    CHINESE_LANTERN = 344
    COOKING_POT = 345
    SAFE = 346
    SKULL_LANTERN = 347
    TRASH_CAN = 348
    CANDELABRA = 349
    PINK_VASE = 350
    MUG = 351
    KEG = 352
    ALE = 353
    BOOKCASE = 354
    THRONE = 355
    BOWL = 356
    BOWLOF_SOUP = 357
    TOILET = 358
    GRANDFATHER_CLOCK = 359
    ARMOR_STATUE = 360
    GOBLIN_BATTLE_STANDARD = 361
    TATTERED_CLOTH = 362
    SAWMILL = 363
    COBALT_ORE = 364
    MYTHRIL_ORE = 365
    ADAMANTITE_ORE = 366
    PWNHAMMER = 367
    EXCALIBUR = 368
    HALLOWED_SEEDS = 369
    EBONSAND_BLOCK = 370
    COBALT_HAT = 371
    COBALT_HELMET = 372
    COBALT_MASK = 373
    COBALT_BREASTPLATE = 374
    COBALT_LEGGINGS = 375
    MYTHRIL_HOOD = 376
    MYTHRIL_HELMET = 377
    MYTHRIL_HAT = 378
    MYTHRIL_CHAINMAIL = 379
    MYTHRIL_GREAVES = 380
    COBALT_BAR = 381
    MYTHRIL_BAR = 382
    COBALT_CHAINSAW = 383
    MYTHRIL_CHAINSAW = 384
    COBALT_DRILL = 385
    MYTHRIL_DRILL = 386
    ADAMANTITE_CHAINSAW = 387
    ADAMANTITE_DRILL = 388
    DAOOF_POW = 389
    MYTHRIL_HALBERD = 390
    ADAMANTITE_BAR = 391
    GLASS_WALL = 392
    COMPASS = 393
    DIVING_GEAR = 394
    GPS = 395
    OBSIDIAN_HORSESHOE = 396
    OBSIDIAN_SHIELD = 397
    TINKERERS_WORKSHOP = 398
    CLOUDINA_BALLOON = 399
    ADAMANTITE_HEADGEAR = 400
    ADAMANTITE_HELMET = 401
    ADAMANTITE_MASK = 402
    ADAMANTITE_BREASTPLATE = 403
    ADAMANTITE_LEGGINGS = 404
    SPECTRE_BOOTS = 405
    ADAMANTITE_GLAIVE = 406
    TOOLBELT = 407
    PEARLSAND_BLOCK = 408
    PEARLSTONE_BLOCK = 409
    MINING_SHIRT = 410
    MINING_PANTS = 411
    PEARLSTONE_BRICK = 412
    IRIDESCENT_BRICK = 413
    MUDSTONE_BLOCK = 414
    COBALT_BRICK = 415
    MYTHRIL_BRICK = 416
    PEARLSTONE_BRICK_WALL = 417
    IRIDESCENT_BRICK_WALL = 418
    MUDSTONE_BRICK_WALL = 419
    COBALT_BRICK_WALL = 420
    MYTHRIL_BRICK_WALL = 421
    HOLY_WATER = 422
    UNHOLY_WATER = 423
    SILT_BLOCK = 424
    FAIRY_BELL = 425
    BREAKER_BLADE = 426
    BLUE_TORCH = 427
    RED_TORCH = 428
    GREEN_TORCH = 429
    PURPLE_TORCH = 430
    WHITE_TORCH = 431
    YELLOW_TORCH = 432
    DEMON_TORCH = 433
    CLOCKWORK_ASSAULT_RIFLE = 434
    COBALT_REPEATER = 435
    MYTHRIL_REPEATER = 436
    DUAL_HOOK = 437
    STAR_STATUE = 438
    SWORD_STATUE = 439
    SLIME_STATUE = 440
    GOBLIN_STATUE = 441
    SHIELD_STATUE = 442
    BAT_STATUE = 443
    FISH_STATUE = 444
    BUNNY_STATUE = 445
    SKELETON_STATUE = 446
    REAPER_STATUE = 447
    WOMAN_STATUE = 448
    IMP_STATUE = 449
    GARGOYLE_STATUE = 450
    GLOOM_STATUE = 451
    HORNET_STATUE = 452
    BOMB_STATUE = 453
    CRAB_STATUE = 454
    HAMMER_STATUE = 455
    POTION_STATUE = 456
    SPEAR_STATUE = 457
    CROSS_STATUE = 458
    JELLYFISH_STATUE = 459
    BOW_STATUE = 460
    BOOMERANG_STATUE = 461
    BOOT_STATUE = 462
    CHEST_STATUE = 463
    BIRD_STATUE = 464
    AXE_STATUE = 465
    CORRUPT_STATUE = 466
    TREE_STATUE = 467
    ANVIL_STATUE = 468
    PICKAXE_STATUE = 469
    MUSHROOM_STATUE = 470
    EYEBALL_STATUE = 471
    PILLAR_STATUE = 472
    HEART_STATUE = 473
    POT_STATUE = 474
    SUNFLOWER_STATUE = 475
    KING_STATUE = 476
    QUEEN_STATUE = 477
    PIRANHA_STATUE = 478
    PLANKED_WALL = 479
    WOODEN_BEAM = 480
    ADAMANTITE_REPEATER = 481
    ADAMANTITE_SWORD = 482
    COBALT_SWORD = 483
    MYTHRIL_SWORD = 484
    MOON_CHARM = 485
    RULER = 486
    CRYSTAL_BALL = 487
    DISCO_BALL = 488
    SORCERER_EMBLEM = 489
    WARRIOR_EMBLEM = 490
    RANGER_EMBLEM = 491
    DEMON_WINGS = 492
    ANGEL_WINGS = 493
    MAGICAL_HARP = 494
    RAINBOW_ROD = 495
    ICE_ROD = 496
    NEPTUNES_SHELL = 497
    MANNEQUIN = 498
    GREATER_HEALING_POTION = 499
    GREATER_MANA_POTION = 500
    PIXIE_DUST = 501
    CRYSTAL_SHARD = 502
    CLOWN_HAT = 503
    CLOWN_SHIRT = 504
    CLOWN_PANTS = 505
    FLAMETHROWER = 506
    BELL = 507
    HARP = 508
    WRENCH = 509
    WIRE_CUTTER = 510
    ACTIVE_STONE_BLOCK = 511
    INACTIVE_STONE_BLOCK = 512
    LEVER = 513
    LASER_RIFLE = 514
    CRYSTAL_BULLET = 515
    HOLY_ARROW = 516
    MAGIC_DAGGER = 517
    CRYSTAL_STORM = 518
    CURSED_FLAMES = 519
    SOULOF_LIGHT = 520
    SOULOF_NIGHT = 521
    CURSED_FLAME = 522
    CURSED_TORCH = 523
    ADAMANTITE_FORGE = 524
    MYTHRIL_ANVIL = 525
    UNICORN_HORN = 526
    DARK_SHARD = 527
    LIGHT_SHARD = 528
    RED_PRESSURE_PLATE = 529
    WIRE = 530
    SPELL_TOME = 531
    STAR_CLOAK = 532
    MEGASHARK = 533
    SHOTGUN = 534
    PHILOSOPHERS_STONE = 535
    TITAN_GLOVE = 536
    COBALT_NAGINATA = 537
    SWITCH = 538
    DART_TRAP = 539
    BOULDER = 540
    GREEN_PRESSURE_PLATE = 541
    GRAY_PRESSURE_PLATE = 542
    BROWN_PRESSURE_PLATE = 543
    MECHANICAL_EYE = 544
    CURSED_ARROW = 545
    CURSED_BULLET = 546
    SOULOF_FRIGHT = 547
    SOULOF_MIGHT = 548
    SOULOF_SIGHT = 549
    GUNGNIR = 550
    HALLOWED_PLATE_MAIL = 551
    HALLOWED_GREAVES = 552
    HALLOWED_HELMET = 553
    CROSS_NECKLACE = 554
    MANA_FLOWER = 555
    MECHANICAL_WORM = 556
    MECHANICAL_SKULL = 557
    HALLOWED_HEADGEAR = 558
    HALLOWED_MASK = 559
    SLIME_CROWN = 560
    LIGHT_DISC = 561
    MUSIC_BOX_OVERWORLD_DAY = 562
    MUSIC_BOX_EERIE = 563
    MUSIC_BOX_NIGHT = 564
    MUSIC_BOX_TITLE = 565
    MUSIC_BOX_UNDERGROUND = 566
    MUSIC_BOX_BOSS1 = 567
    MUSIC_BOX_JUNGLE = 568
    MUSIC_BOX_CORRUPTION = 569
    MUSIC_BOX_UNDERGROUND_CORRUPTION = 570
    MUSIC_BOX_THE_HALLOW = 571
    MUSIC_BOX_BOSS2 = 572
    MUSIC_BOX_UNDERGROUND_HALLOW = 573
    MUSIC_BOX_BOSS3 = 574
    SOULOF_FLIGHT = 575
    MUSIC_BOX = 576
    DEMONITE_BRICK = 577
    HALLOWED_REPEATER = 578
    DRAX = 579
    EXPLOSIVES = 580
    INLET_PUMP = 581
    OUTLET_PUMP = 582
    TIMER1SECOND = 583
    TIMER3SECOND = 584
    TIMER5SECOND = 585
    CANDY_CANE_BLOCK = 586
    CANDY_CANE_WALL = 587
    SANTA_HAT = 588
    SANTA_SHIRT = 589
    SANTA_PANTS = 590
    GREEN_CANDY_CANE_BLOCK = 591
    GREEN_CANDY_CANE_WALL = 592
    SNOW_BLOCK = 593
    SNOW_BRICK = 594
    SNOW_BRICK_WALL = 595
    BLUE_LIGHT = 596
    RED_LIGHT = 597
    GREEN_LIGHT = 598
    BLUE_PRESENT = 599
    GREEN_PRESENT = 600
    YELLOW_PRESENT = 601
    SNOW_GLOBE = 602
    CARROT = 603
    ADAMANTITE_BEAM = 604
    ADAMANTITE_BEAM_WALL = 605
    DEMONITE_BRICK_WALL = 606
    SANDSTONE_BRICK = 607
    SANDSTONE_BRICK_WALL = 608
    EBONSTONE_BRICK = 609
    EBONSTONE_BRICK_WALL = 610
    RED_STUCCO = 611
    YELLOW_STUCCO = 612
    GREEN_STUCCO = 613
    GRAY_STUCCO = 614
    RED_STUCCO_WALL = 615
    YELLOW_STUCCO_WALL = 616
    GREEN_STUCCO_WALL = 617
    GRAY_STUCCO_WALL = 618
    EBONWOOD = 619
    RICH_MAHOGANY = 620
    PEARLWOOD = 621
    EBONWOOD_WALL = 622
    RICH_MAHOGANY_WALL = 623
    PEARLWOOD_WALL = 624
    EBONWOOD_CHEST = 625
    RICH_MAHOGANY_CHEST = 626
    PEARLWOOD_CHEST = 627
    EBONWOOD_CHAIR = 628
    RICH_MAHOGANY_CHAIR = 629
    PEARLWOOD_CHAIR = 630
    EBONWOOD_PLATFORM = 631
    RICH_MAHOGANY_PLATFORM = 632
    PEARLWOOD_PLATFORM = 633
    BONE_PLATFORM = 634
    EBONWOOD_WORK_BENCH = 635
    RICH_MAHOGANY_WORK_BENCH = 636
    PEARLWOOD_WORK_BENCH = 637
    EBONWOOD_TABLE = 638
    RICH_MAHOGANY_TABLE = 639
    PEARLWOOD_TABLE = 640
    EBONWOOD_PIANO = 641
    RICH_MAHOGANY_PIANO = 642
    PEARLWOOD_PIANO = 643
    EBONWOOD_BED = 644
    RICH_MAHOGANY_BED = 645
    PEARLWOOD_BED = 646
    EBONWOOD_DRESSER = 647
    RICH_MAHOGANY_DRESSER = 648
    PEARLWOOD_DRESSER = 649
    EBONWOOD_DOOR = 650
    RICH_MAHOGANY_DOOR = 651
    PEARLWOOD_DOOR = 652
    EBONWOOD_SWORD = 653
    EBONWOOD_HAMMER = 654
    EBONWOOD_BOW = 655
    RICH_MAHOGANY_SWORD = 656
    RICH_MAHOGANY_HAMMER = 657
    RICH_MAHOGANY_BOW = 658
    PEARLWOOD_SWORD = 659
    PEARLWOOD_HAMMER = 660
    PEARLWOOD_BOW = 661
    RAINBOW_BRICK = 662
    RAINBOW_BRICK_WALL = 663
    ICE_BLOCK = 664
    REDS_WINGS = 665
    REDS_HELMET = 666
    REDS_BREASTPLATE = 667
    REDS_LEGGINGS = 668
    FISH = 669
    ICE_BOOMERANG = 670
    KEYBRAND = 671
    CUTLASS = 672
    BOREAL_WOOD_WORK_BENCH = 673
    TRUE_EXCALIBUR = 674
    TRUE_NIGHTS_EDGE = 675
    FROSTBRAND = 676
    BOREAL_WOOD_TABLE = 677
    RED_POTION = 678
    TACTICAL_SHOTGUN = 679
    IVY_CHEST = 680
    ICE_CHEST = 681
    MARROW = 682
    UNHOLY_TRIDENT = 683
    FROST_HELMET = 684
    FROST_BREASTPLATE = 685
    FROST_LEGGINGS = 686
    TIN_HELMET = 687
    TIN_CHAINMAIL = 688
    TIN_GREAVES = 689
    LEAD_HELMET = 690
    LEAD_CHAINMAIL = 691
    LEAD_GREAVES = 692
    TUNGSTEN_HELMET = 693
    TUNGSTEN_CHAINMAIL = 694
    TUNGSTEN_GREAVES = 695
    PLATINUM_HELMET = 696
    PLATINUM_CHAINMAIL = 697
    PLATINUM_GREAVES = 698
    TIN_ORE = 699
    LEAD_ORE = 700
    TUNGSTEN_ORE = 701
    PLATINUM_ORE = 702
    TIN_BAR = 703
    LEAD_BAR = 704
    TUNGSTEN_BAR = 705
    PLATINUM_BAR = 706
    TIN_WATCH = 707
    TUNGSTEN_WATCH = 708
    PLATINUM_WATCH = 709
    TIN_CHANDELIER = 710
    TUNGSTEN_CHANDELIER = 711
    PLATINUM_CHANDELIER = 712
    PLATINUM_CANDLE = 713
    PLATINUM_CANDELABRA = 714
    PLATINUM_CROWN = 715
    LEAD_ANVIL = 716
    TIN_BRICK = 717
    TUNGSTEN_BRICK = 718
    PLATINUM_BRICK = 719
    TIN_BRICK_WALL = 720
    TUNGSTEN_BRICK_WALL = 721
    PLATINUM_BRICK_WALL = 722
    BEAM_SWORD = 723
    ICE_BLADE = 724
    ICE_BOW = 725
    FROST_STAFF = 726
    WOOD_HELMET = 727
    WOOD_BREASTPLATE = 728
    WOOD_GREAVES = 729
    EBONWOOD_HELMET = 730
    EBONWOOD_BREASTPLATE = 731
    EBONWOOD_GREAVES = 732
    RICH_MAHOGANY_HELMET = 733
    RICH_MAHOGANY_BREASTPLATE = 734
    RICH_MAHOGANY_GREAVES = 735
    PEARLWOOD_HELMET = 736
    PEARLWOOD_BREASTPLATE = 737
    PEARLWOOD_GREAVES = 738
    AMETHYST_STAFF = 739
    TOPAZ_STAFF = 740
    SAPPHIRE_STAFF = 741
    EMERALD_STAFF = 742
    RUBY_STAFF = 743
    DIAMOND_STAFF = 744
    GRASS_WALL = 745
    JUNGLE_WALL = 746
    FLOWER_WALL = 747
    JETPACK = 748
    BUTTERFLY_WINGS = 749
    CACTUS_WALL = 750
    CLOUD = 751
    CLOUD_WALL = 752
    SEAWEED = 753
    RUNE_HAT = 754
    RUNE_ROBE = 755
    MUSHROOM_SPEAR = 756
    TERRA_BLADE = 757
    GRENADE_LAUNCHER = 758
    ROCKET_LAUNCHER = 759
    PROXIMITY_MINE_LAUNCHER = 760
    FAIRY_WINGS = 761
    SLIME_BLOCK = 762
    FLESH_BLOCK = 763
    MUSHROOM_WALL = 764
    RAIN_CLOUD = 765
    BONE_BLOCK = 766
    FROZEN_SLIME_BLOCK = 767
    BONE_BLOCK_WALL = 768
    SLIME_BLOCK_WALL = 769
    FLESH_BLOCK_WALL = 770
    ROCKET_I = 771
    ROCKET_II = 772
    ROCKET_III = 773
    ROCKET_IV = 774
    ASPHALT_BLOCK = 775
    COBALT_PICKAXE = 776
    MYTHRIL_PICKAXE = 777
    ADAMANTITE_PICKAXE = 778
    CLENTAMINATOR = 779
    GREEN_SOLUTION = 780
    BLUE_SOLUTION = 781
    PURPLE_SOLUTION = 782
    DARK_BLUE_SOLUTION = 783
    RED_SOLUTION = 784
    HARPY_WINGS = 785
    BONE_WINGS = 786
    HAMMUSH = 787
    NETTLE_BURST = 788
    ANKH_BANNER = 789
    SNAKE_BANNER = 790
    OMEGA_BANNER = 791
    CRIMSON_HELMET = 792
    CRIMSON_SCALEMAIL = 793
    CRIMSON_GREAVES = 794
    BLOOD_BUTCHERER = 795
    TENDON_BOW = 796
    FLESH_GRINDER = 797
    DEATHBRINGER_PICKAXE = 798
    BLOOD_LUST_CLUSTER = 799
    THE_UNDERTAKER = 800
    THE_MEATBALL = 801
    THE_ROTTED_FORK = 802
    ESKIMO_HOOD = 803
    ESKIMO_COAT = 804
    ESKIMO_PANTS = 805
    LIVING_WOOD_CHAIR = 806
    CACTUS_CHAIR = 807
    BONE_CHAIR = 808
    FLESH_CHAIR = 809
    MUSHROOM_CHAIR = 810
    BONE_WORK_BENCH = 811
    CACTUS_WORK_BENCH = 812
    FLESH_WORK_BENCH = 813
    MUSHROOM_WORK_BENCH = 814
    SLIME_WORK_BENCH = 815
    CACTUS_DOOR = 816
    FLESH_DOOR = 817
    MUSHROOM_DOOR = 818
    LIVING_WOOD_DOOR = 819
    BONE_DOOR = 820
    FLAME_WINGS = 821
    FROZEN_WINGS = 822
    GHOST_WINGS = 823
    SUNPLATE_BLOCK = 824
    DISC_WALL = 825
    SKYWARE_CHAIR = 826
    BONE_TABLE = 827
    FLESH_TABLE = 828
    LIVING_WOOD_TABLE = 829
    SKYWARE_TABLE = 830
    LIVING_WOOD_CHEST = 831
    LIVING_WOOD_WAND = 832
    PURPLE_ICE_BLOCK = 833
    PINK_ICE_BLOCK = 834
    RED_ICE_BLOCK = 835
    CRIMSTONE_BLOCK = 836
    SKYWARE_DOOR = 837
    SKYWARE_CHEST = 838
    STEAMPUNK_HAT = 839
    STEAMPUNK_SHIRT = 840
    STEAMPUNK_PANTS = 841
    BEE_HAT = 842
    BEE_SHIRT = 843
    BEE_PANTS = 844
    WORLD_BANNER = 845
    SUN_BANNER = 846
    GRAVITY_BANNER = 847
    PHARAOHS_MASK = 848
    ACTUATOR = 849
    BLUE_WRENCH = 850
    GREEN_WRENCH = 851
    BLUE_PRESSURE_PLATE = 852
    YELLOW_PRESSURE_PLATE = 853
    DISCOUNT_CARD = 854
    LUCKY_COIN = 855
    UNICORNONA_STICK = 856
    SANDSTORMINA_BOTTLE = 857
    BOREAL_WOOD_SOFA = 858
    BEACH_BALL = 859
    CHARMOF_MYTHS = 860
    MOON_SHELL = 861
    STAR_VEIL = 862
    WATER_WALKING_BOOTS = 863
    TIARA = 864
    PRINCESS_DRESS = 865
    PHARAOHS_ROBE = 866
    GREEN_CAP = 867
    MUSHROOM_CAP = 868
    TAM_OSHANTER = 869
    MUMMY_MASK = 870
    MUMMY_SHIRT = 871
    MUMMY_PANTS = 872
    COWBOY_HAT = 873
    COWBOY_JACKET = 874
    COWBOY_PANTS = 875
    PIRATE_HAT = 876
    PIRATE_SHIRT = 877
    PIRATE_PANTS = 878
    VIKING_HELMET = 879
    CRIMTANE_ORE = 880
    CACTUS_SWORD = 881
    CACTUS_PICKAXE = 882
    ICE_BRICK = 883
    ICE_BRICK_WALL = 884
    ADHESIVE_BANDAGE = 885
    ARMOR_POLISH = 886
    BEZOAR = 887
    BLINDFOLD = 888
    FAST_CLOCK = 889
    MEGAPHONE = 890
    NAZAR = 891
    VITAMINS = 892
    TRIFOLD_MAP = 893
    CACTUS_HELMET = 894
    CACTUS_BREASTPLATE = 895
    CACTUS_LEGGINGS = 896
    POWER_GLOVE = 897
    LIGHTNING_BOOTS = 898
    SUN_STONE = 899
    MOON_STONE = 900
    ARMOR_BRACING = 901
    MEDICATED_BANDAGE = 902
    THE_PLAN = 903
    COUNTERCURSE_MANTRA = 904
    COIN_GUN = 905
    LAVA_CHARM = 906
    OBSIDIAN_WATER_WALKING_BOOTS = 907
    LAVA_WADERS = 908
    PURE_WATER_FOUNTAIN = 909
    DESERT_WATER_FOUNTAIN = 910
    SHADEWOOD = 911
    SHADEWOOD_DOOR = 912
    SHADEWOOD_PLATFORM = 913
    SHADEWOOD_CHEST = 914
    SHADEWOOD_CHAIR = 915
    SHADEWOOD_WORK_BENCH = 916
    SHADEWOOD_TABLE = 917
    SHADEWOOD_DRESSER = 918
    SHADEWOOD_PIANO = 919
    SHADEWOOD_BED = 920
    SHADEWOOD_SWORD = 921
    SHADEWOOD_HAMMER = 922
    SHADEWOOD_BOW = 923
    SHADEWOOD_HELMET = 924
    SHADEWOOD_BREASTPLATE = 925
    SHADEWOOD_GREAVES = 926
    SHADEWOOD_WALL = 927
    CANNON = 928
    CANNONBALL = 929
    FLARE_GUN = 930
    FLARE = 931
    BONE_WAND = 932
    LEAF_WAND = 933
    FLYING_CARPET = 934
    AVENGER_EMBLEM = 935
    MECHANICAL_GLOVE = 936
    LAND_MINE = 937
    PALADINS_SHIELD = 938
    WEB_SLINGER = 939
    JUNGLE_WATER_FOUNTAIN = 940
    ICY_WATER_FOUNTAIN = 941
    CORRUPT_WATER_FOUNTAIN = 942
    CRIMSON_WATER_FOUNTAIN = 943
    HALLOWED_WATER_FOUNTAIN = 944
    BLOOD_WATER_FOUNTAIN = 945
    UMBRELLA = 946
    CHLOROPHYTE_ORE = 947
    STEAMPUNK_WINGS = 948
    SNOWBALL = 949
    ICE_SKATES = 950
    SNOWBALL_LAUNCHER = 951
    WEB_COVERED_CHEST = 952
    CLIMBING_CLAWS = 953
    ANCIENT_IRON_HELMET = 954
    ANCIENT_GOLD_HELMET = 955
    ANCIENT_SHADOW_HELMET = 956
    ANCIENT_SHADOW_SCALEMAIL = 957
    ANCIENT_SHADOW_GREAVES = 958
    ANCIENT_NECRO_HELMET = 959
    ANCIENT_COBALT_HELMET = 960
    ANCIENT_COBALT_BREASTPLATE = 961
    ANCIENT_COBALT_LEGGINGS = 962
    BLACK_BELT = 963
    BOOMSTICK = 964
    ROPE = 965
    CAMPFIRE = 966
    MARSHMALLOW = 967
    MARSHMALLOWONA_STICK = 968
    COOKED_MARSHMALLOW = 969
    RED_ROCKET = 970
    GREEN_ROCKET = 971
    BLUE_ROCKET = 972
    YELLOW_ROCKET = 973
    ICE_TORCH = 974
    SHOE_SPIKES = 975
    TIGER_CLIMBING_GEAR = 976
    TABI = 977
    PINK_ESKIMO_HOOD = 978
    PINK_ESKIMO_COAT = 979
    PINK_ESKIMO_PANTS = 980
    PINK_THREAD = 981
    MANA_REGENERATION_BAND = 982
    SANDSTORMINA_BALLOON = 983
    MASTER_NINJA_GEAR = 984
    ROPE_COIL = 985
    BLOWGUN = 986
    BLIZZARDINA_BOTTLE = 987
    FROSTBURN_ARROW = 988
    ENCHANTED_SWORD = 989
    PICKAXE_AXE = 990
    COBALT_WARAXE = 991
    MYTHRIL_WARAXE = 992
    ADAMANTITE_WARAXE = 993
    EATERS_BONE = 994
    BLEND_OMATIC = 995
    MEAT_GRINDER = 996
    EXTRACTINATOR = 997
    SOLIDIFIER = 998
    AMBER = 999
    CONFETTI_GUN = 1000
    CHLOROPHYTE_MASK = 1001
    CHLOROPHYTE_HELMET = 1002
    CHLOROPHYTE_HEADGEAR = 1003
    CHLOROPHYTE_PLATE_MAIL = 1004
    CHLOROPHYTE_GREAVES = 1005
    CHLOROPHYTE_BAR = 1006
    RED_DYE = 1007
    ORANGE_DYE = 1008
    YELLOW_DYE = 1009
    LIME_DYE = 1010
    GREEN_DYE = 1011
    TEAL_DYE = 1012
    CYAN_DYE = 1013
    SKY_BLUE_DYE = 1014
    BLUE_DYE = 1015
    PURPLE_DYE = 1016
    VIOLET_DYE = 1017
    PINK_DYE = 1018
    REDAND_BLACK_DYE = 1019
    ORANGEAND_BLACK_DYE = 1020
    YELLOWAND_BLACK_DYE = 1021
    LIMEAND_BLACK_DYE = 1022
    GREENAND_BLACK_DYE = 1023
    TEALAND_BLACK_DYE = 1024
    CYANAND_BLACK_DYE = 1025
    SKY_BLUEAND_BLACK_DYE = 1026
    BLUEAND_BLACK_DYE = 1027
    PURPLEAND_BLACK_DYE = 1028
    VIOLETAND_BLACK_DYE = 1029
    PINKAND_BLACK_DYE = 1030
    FLAME_DYE = 1031
    FLAME_AND_BLACK_DYE = 1032
    GREEN_FLAME_DYE = 1033
    GREEN_FLAME_AND_BLACK_DYE = 1034
    BLUE_FLAME_DYE = 1035
    BLUE_FLAME_AND_BLACK_DYE = 1036
    SILVER_DYE = 1037
    BRIGHT_RED_DYE = 1038
    BRIGHT_ORANGE_DYE = 1039
    BRIGHT_YELLOW_DYE = 1040
    BRIGHT_LIME_DYE = 1041
    BRIGHT_GREEN_DYE = 1042
    BRIGHT_TEAL_DYE = 1043
    BRIGHT_CYAN_DYE = 1044
    BRIGHT_SKY_BLUE_DYE = 1045
    BRIGHT_BLUE_DYE = 1046
    BRIGHT_PURPLE_DYE = 1047
    BRIGHT_VIOLET_DYE = 1048
    BRIGHT_PINK_DYE = 1049
    BLACK_DYE = 1050
    REDAND_SILVER_DYE = 1051
    ORANGEAND_SILVER_DYE = 1052
    YELLOWAND_SILVER_DYE = 1053
    LIMEAND_SILVER_DYE = 1054
    GREENAND_SILVER_DYE = 1055
    TEALAND_SILVER_DYE = 1056
    CYANAND_SILVER_DYE = 1057
    SKY_BLUEAND_SILVER_DYE = 1058
    BLUEAND_SILVER_DYE = 1059
    PURPLEAND_SILVER_DYE = 1060
    VIOLETAND_SILVER_DYE = 1061
    PINKAND_SILVER_DYE = 1062
    INTENSE_FLAME_DYE = 1063
    INTENSE_GREEN_FLAME_DYE = 1064
    INTENSE_BLUE_FLAME_DYE = 1065
    RAINBOW_DYE = 1066
    INTENSE_RAINBOW_DYE = 1067
    YELLOW_GRADIENT_DYE = 1068
    CYAN_GRADIENT_DYE = 1069
    VIOLET_GRADIENT_DYE = 1070
    PAINTBRUSH = 1071
    PAINT_ROLLER = 1072
    RED_PAINT = 1073
    ORANGE_PAINT = 1074
    YELLOW_PAINT = 1075
    LIME_PAINT = 1076
    GREEN_PAINT = 1077
    TEAL_PAINT = 1078
    CYAN_PAINT = 1079
    SKY_BLUE_PAINT = 1080
    BLUE_PAINT = 1081
    PURPLE_PAINT = 1082
    VIOLET_PAINT = 1083
    PINK_PAINT = 1084
    DEEP_RED_PAINT = 1085
    DEEP_ORANGE_PAINT = 1086
    DEEP_YELLOW_PAINT = 1087
    DEEP_LIME_PAINT = 1088
    DEEP_GREEN_PAINT = 1089
    DEEP_TEAL_PAINT = 1090
    DEEP_CYAN_PAINT = 1091
    DEEP_SKY_BLUE_PAINT = 1092
    DEEP_BLUE_PAINT = 1093
    DEEP_PURPLE_PAINT = 1094
    DEEP_VIOLET_PAINT = 1095
    DEEP_PINK_PAINT = 1096
    BLACK_PAINT = 1097
    WHITE_PAINT = 1098
    GRAY_PAINT = 1099
    PAINT_SCRAPER = 1100
    LIHZAHRD_BRICK = 1101
    LIHZAHRD_BRICK_WALL = 1102
    SLUSH_BLOCK = 1103
    PALLADIUM_ORE = 1104
    ORICHALCUM_ORE = 1105
    TITANIUM_ORE = 1106
    TEAL_MUSHROOM = 1107
    GREEN_MUSHROOM = 1108
    SKY_BLUE_FLOWER = 1109
    YELLOW_MARIGOLD = 1110
    BLUE_BERRIES = 1111
    LIME_KELP = 1112
    PINK_PRICKLY_PEAR = 1113
    ORANGE_BLOODROOT = 1114
    RED_HUSK = 1115
    CYAN_HUSK = 1116
    VIOLET_HUSK = 1117
    PURPLE_MUCOS = 1118
    BLACK_INK = 1119
    DYE_VAT = 1120
    BEE_GUN = 1121
    POSSESSED_HATCHET = 1122
    BEE_KEEPER = 1123
    HIVE = 1124
    HONEY_BLOCK = 1125
    HIVE_WALL = 1126
    CRISPY_HONEY_BLOCK = 1127
    HONEY_BUCKET = 1128
    HIVE_WAND = 1129
    BEENADE = 1130
    GRAVITY_GLOBE = 1131
    HONEY_COMB = 1132
    ABEEMINATION = 1133
    BOTTLED_HONEY = 1134
    RAIN_HAT = 1135
    RAIN_COAT = 1136
    LIHZAHRD_DOOR = 1137
    DUNGEON_DOOR = 1138
    LEAD_DOOR = 1139
    IRON_DOOR = 1140
    TEMPLE_KEY = 1141
    LIHZAHRD_CHEST = 1142
    LIHZAHRD_CHAIR = 1143
    LIHZAHRD_TABLE = 1144
    LIHZAHRD_WORK_BENCH = 1145
    SUPER_DART_TRAP = 1146
    FLAME_TRAP = 1147
    SPIKY_BALL_TRAP = 1148
    SPEAR_TRAP = 1149
    WOODEN_SPIKE = 1150
    LIHZAHRD_PRESSURE_PLATE = 1151
    LIHZAHRD_STATUE = 1152
    LIHZAHRD_WATCHER_STATUE = 1153
    LIHZAHRD_GUARDIAN_STATUE = 1154
    WASP_GUN = 1155
    PIRANHA_GUN = 1156
    PYGMY_STAFF = 1157
    PYGMY_NECKLACE = 1158
    TIKI_MASK = 1159
    TIKI_SHIRT = 1160
    TIKI_PANTS = 1161
    LEAF_WINGS = 1162
    BLIZZARDINA_BALLOON = 1163
    BUNDLEOF_BALLOONS = 1164
    BAT_WINGS = 1165
    BONE_SWORD = 1166
    HERCULES_BEETLE = 1167
    SMOKE_BOMB = 1168
    BONE_KEY = 1169
    NECTAR = 1170
    TIKI_TOTEM = 1171
    LIZARD_EGG = 1172
    GRAVE_MARKER = 1173
    CROSS_GRAVE_MARKER = 1174
    HEADSTONE = 1175
    GRAVESTONE = 1176
    OBELISK = 1177
    LEAF_BLOWER = 1178
    CHLOROPHYTE_BULLET = 1179
    PARROT_CRACKER = 1180
    STRANGE_GLOWING_MUSHROOM = 1181
    SEEDLING = 1182
    WISPINA_BOTTLE = 1183
    PALLADIUM_BAR = 1184
    PALLADIUM_SWORD = 1185
    PALLADIUM_PIKE = 1186
    PALLADIUM_REPEATER = 1187
    PALLADIUM_PICKAXE = 1188
    PALLADIUM_DRILL = 1189
    PALLADIUM_CHAINSAW = 1190
    ORICHALCUM_BAR = 1191
    ORICHALCUM_SWORD = 1192
    ORICHALCUM_HALBERD = 1193
    ORICHALCUM_REPEATER = 1194
    ORICHALCUM_PICKAXE = 1195
    ORICHALCUM_DRILL = 1196
    ORICHALCUM_CHAINSAW = 1197
    TITANIUM_BAR = 1198
    TITANIUM_SWORD = 1199
    TITANIUM_TRIDENT = 1200
    TITANIUM_REPEATER = 1201
    TITANIUM_PICKAXE = 1202
    TITANIUM_DRILL = 1203
    TITANIUM_CHAINSAW = 1204
    PALLADIUM_MASK = 1205
    PALLADIUM_HELMET = 1206
    PALLADIUM_HEADGEAR = 1207
    PALLADIUM_BREASTPLATE = 1208
    PALLADIUM_LEGGINGS = 1209
    ORICHALCUM_MASK = 1210
    ORICHALCUM_HELMET = 1211
    ORICHALCUM_HEADGEAR = 1212
    ORICHALCUM_BREASTPLATE = 1213
    ORICHALCUM_LEGGINGS = 1214
    TITANIUM_MASK = 1215
    TITANIUM_HELMET = 1216
    TITANIUM_HEADGEAR = 1217
    TITANIUM_BREASTPLATE = 1218
    TITANIUM_LEGGINGS = 1219
    ORICHALCUM_ANVIL = 1220
    TITANIUM_FORGE = 1221
    PALLADIUM_WARAXE = 1222
    ORICHALCUM_WARAXE = 1223
    TITANIUM_WARAXE = 1224
    HALLOWED_BAR = 1225
    CHLOROPHYTE_CLAYMORE = 1226
    CHLOROPHYTE_SABER = 1227
    CHLOROPHYTE_PARTISAN = 1228
    CHLOROPHYTE_SHOTBOW = 1229
    CHLOROPHYTE_PICKAXE = 1230
    CHLOROPHYTE_DRILL = 1231
    CHLOROPHYTE_CHAINSAW = 1232
    CHLOROPHYTE_GREATAXE = 1233
    CHLOROPHYTE_WARHAMMER = 1234
    CHLOROPHYTE_ARROW = 1235
    AMETHYST_HOOK = 1236
    TOPAZ_HOOK = 1237
    SAPPHIRE_HOOK = 1238
    EMERALD_HOOK = 1239
    RUBY_HOOK = 1240
    DIAMOND_HOOK = 1241
    AMBER_MOSQUITO = 1242
    UMBRELLA_HAT = 1243
    NIMBUS_ROD = 1244
    ORANGE_TORCH = 1245
    CRIMSAND_BLOCK = 1246
    BEE_CLOAK = 1247
    EYEOFTHE_GOLEM = 1248
    HONEY_BALLOON = 1249
    BLUE_HORSESHOE_BALLOON = 1250
    WHITE_HORSESHOE_BALLOON = 1251
    YELLOW_HORSESHOE_BALLOON = 1252
    FROZEN_TURTLE_SHELL = 1253
    SNIPER_RIFLE = 1254
    VENUS_MAGNUM = 1255
    CRIMSON_ROD = 1256
    CRIMTANE_BAR = 1257
    STYNGER = 1258
    FLOWER_POW = 1259
    RAINBOW_GUN = 1260
    STYNGER_BOLT = 1261
    CHLOROPHYTE_JACKHAMMER = 1262
    TELEPORTER = 1263
    FLOWEROF_FROST = 1264
    UZI = 1265
    MAGNET_SPHERE = 1266
    PURPLE_STAINED_GLASS = 1267
    YELLOW_STAINED_GLASS = 1268
    BLUE_STAINED_GLASS = 1269
    GREEN_STAINED_GLASS = 1270
    RED_STAINED_GLASS = 1271
    MULTICOLORED_STAINED_GLASS = 1272
    SKELETRON_HAND = 1273
    SKULL = 1274
    BALLA_HAT = 1275
    GANGSTA_HAT = 1276
    SAILOR_HAT = 1277
    EYE_PATCH = 1278
    SAILOR_SHIRT = 1279
    SAILOR_PANTS = 1280
    SKELETRON_MASK = 1281
    AMETHYST_ROBE = 1282
    TOPAZ_ROBE = 1283
    SAPPHIRE_ROBE = 1284
    EMERALD_ROBE = 1285
    RUBY_ROBE = 1286
    DIAMOND_ROBE = 1287
    WHITE_TUXEDO_SHIRT = 1288
    WHITE_TUXEDO_PANTS = 1289
    PANIC_NECKLACE = 1290
    LIFE_FRUIT = 1291
    LIHZAHRD_ALTAR = 1292
    LIHZAHRD_POWER_CELL = 1293
    PICKSAW = 1294
    HEAT_RAY = 1295
    STAFFOF_EARTH = 1296
    GOLEM_FIST = 1297
    WATER_CHEST = 1298
    BINOCULARS = 1299
    RIFLE_SCOPE = 1300
    DESTROYER_EMBLEM = 1301
    HIGH_VELOCITY_BULLET = 1302
    JELLYFISH_NECKLACE = 1303
    ZOMBIE_ARM = 1304
    THE_AXE = 1305
    ICE_SICKLE = 1306
    CLOTHIER_VOODOO_DOLL = 1307
    POISON_STAFF = 1308
    SLIME_STAFF = 1309
    POISON_DART = 1310
    EYE_SPRING = 1311
    TOY_SLED = 1312
    BOOKOF_SKULLS = 1313
    KOCANNON = 1314
    PIRATE_MAP = 1315
    TURTLE_HELMET = 1316
    TURTLE_SCALE_MAIL = 1317
    TURTLE_LEGGINGS = 1318
    SNOWBALL_CANNON = 1319
    BONE_PICKAXE = 1320
    MAGIC_QUIVER = 1321
    MAGMA_STONE = 1322
    OBSIDIAN_ROSE = 1323
    BANANARANG = 1324
    CHAIN_KNIFE = 1325
    RODOF_DISCORD = 1326
    DEATH_SICKLE = 1327
    TURTLE_SHELL = 1328
    TISSUE_SAMPLE = 1329
    VERTEBRAE = 1330
    BLOODY_SPINE = 1331
    ICHOR = 1332
    ICHOR_TORCH = 1333
    ICHOR_ARROW = 1334
    ICHOR_BULLET = 1335
    GOLDEN_SHOWER = 1336
    BUNNY_CANNON = 1337
    EXPLOSIVE_BUNNY = 1338
    VIALOF_VENOM = 1339
    FLASKOF_VENOM = 1340
    VENOM_ARROW = 1341
    VENOM_BULLET = 1342
    FIRE_GAUNTLET = 1343
    COG = 1344
    CONFETTI = 1345
    NANITES = 1346
    EXPLOSIVE_POWDER = 1347
    GOLD_DUST = 1348
    PARTY_BULLET = 1349
    NANO_BULLET = 1350
    EXPLODING_BULLET = 1351
    GOLDEN_BULLET = 1352
    FLASKOF_CURSED_FLAMES = 1353
    FLASKOF_FIRE = 1354
    FLASKOF_GOLD = 1355
    FLASKOF_ICHOR = 1356
    FLASKOF_NANITES = 1357
    FLASKOF_PARTY = 1358
    FLASKOF_POISON = 1359
    EYEOF_CTHULHU_TROPHY = 1360
    EATEROF_WORLDS_TROPHY = 1361
    BRAINOF_CTHULHU_TROPHY = 1362
    SKELETRON_TROPHY = 1363
    QUEEN_BEE_TROPHY = 1364
    WALLOF_FLESH_TROPHY = 1365
    DESTROYER_TROPHY = 1366
    SKELETRON_PRIME_TROPHY = 1367
    RETINAZER_TROPHY = 1368
    SPAZMATISM_TROPHY = 1369
    PLANTERA_TROPHY = 1370
    GOLEM_TROPHY = 1371
    BLOOD_MOON_RISING = 1372
    THE_HANGED_MAN = 1373
    GLORYOFTHE_FIRE = 1374
    BONE_WARP = 1375
    WALL_SKELETON = 1376
    HANGING_SKELETON = 1377
    BLUE_SLAB_WALL = 1378
    BLUE_TILED_WALL = 1379
    PINK_SLAB_WALL = 1380
    PINK_TILED_WALL = 1381
    GREEN_SLAB_WALL = 1382
    GREEN_TILED_WALL = 1383
    BLUE_BRICK_PLATFORM = 1384
    PINK_BRICK_PLATFORM = 1385
    GREEN_BRICK_PLATFORM = 1386
    METAL_SHELF = 1387
    BRASS_SHELF = 1388
    WOOD_SHELF = 1389
    BRASS_LANTERN = 1390
    CAGED_LANTERN = 1391
    CARRIAGE_LANTERN = 1392
    ALCHEMY_LANTERN = 1393
    DIABLOST_LAMP = 1394
    OIL_RAG_SCONSE = 1395
    BLUE_DUNGEON_CHAIR = 1396
    BLUE_DUNGEON_TABLE = 1397
    BLUE_DUNGEON_WORK_BENCH = 1398
    GREEN_DUNGEON_CHAIR = 1399
    GREEN_DUNGEON_TABLE = 1400
    GREEN_DUNGEON_WORK_BENCH = 1401
    PINK_DUNGEON_CHAIR = 1402
    PINK_DUNGEON_TABLE = 1403
    PINK_DUNGEON_WORK_BENCH = 1404
    BLUE_DUNGEON_CANDLE = 1405
    GREEN_DUNGEON_CANDLE = 1406
    PINK_DUNGEON_CANDLE = 1407
    BLUE_DUNGEON_VASE = 1408
    GREEN_DUNGEON_VASE = 1409
    PINK_DUNGEON_VASE = 1410
    BLUE_DUNGEON_DOOR = 1411
    GREEN_DUNGEON_DOOR = 1412
    PINK_DUNGEON_DOOR = 1413
    BLUE_DUNGEON_BOOKCASE = 1414
    GREEN_DUNGEON_BOOKCASE = 1415
    PINK_DUNGEON_BOOKCASE = 1416
    CATACOMB = 1417
    DUNGEON_SHELF = 1418
    SKELLINGTON_JSKELLINGSWORTH = 1419
    THE_CURSED_MAN = 1420
    THE_EYE_SEESTHE_END = 1421
    SOMETHING_EVILIS_WATCHING_YOU = 1422
    THE_TWINS_HAVE_AWOKEN = 1423
    THE_SCREAMER = 1424
    GOBLINS_PLAYING_POKER = 1425
    DRYADISQUE = 1426
    SUNFLOWERS = 1427
    TERRARIAN_GOTHIC = 1428
    BEANIE = 1429
    IMBUING_STATION = 1430
    STARINA_BOTTLE = 1431
    EMPTY_BULLET = 1432
    IMPACT = 1433
    POWEREDBY_BIRDS = 1434
    THE_DESTROYER = 1435
    THE_PERSISTENCYOF_EYES = 1436
    UNICORN_CROSSINGTHE_HALLOWS = 1437
    GREAT_WAVE = 1438
    STARRY_NIGHT = 1439
    GUIDE_PICASSO = 1440
    THE_GUARDIANS_GAZE = 1441
    FATHEROF_SOMEONE = 1442
    NURSE_LISA = 1443
    SHADOWBEAM_STAFF = 1444
    INFERNO_FORK = 1445
    SPECTRE_STAFF = 1446
    WOODEN_FENCE = 1447
    LEAD_FENCE = 1448
    BUBBLE_MACHINE = 1449
    BUBBLE_WAND = 1450
    MARCHING_BONES_BANNER = 1451
    NECROMANTIC_SIGN = 1452
    RUSTED_COMPANY_STANDARD = 1453
    RAGGED_BROTHERHOOD_SIGIL = 1454
    MOLTEN_LEGION_FLAG = 1455
    DIABOLIC_SIGIL = 1456
    OBSIDIAN_PLATFORM = 1457
    OBSIDIAN_DOOR = 1458
    OBSIDIAN_CHAIR = 1459
    OBSIDIAN_TABLE = 1460
    OBSIDIAN_WORK_BENCH = 1461
    OBSIDIAN_VASE = 1462
    OBSIDIAN_BOOKCASE = 1463
    HELLBOUND_BANNER = 1464
    HELL_HAMMER_BANNER = 1465
    HELLTOWER_BANNER = 1466
    LOST_HOPESOF_MAN_BANNER = 1467
    OBSIDIAN_WATCHER_BANNER = 1468
    LAVA_ERUPTS_BANNER = 1469
    BLUE_DUNGEON_BED = 1470
    GREEN_DUNGEON_BED = 1471
    PINK_DUNGEON_BED = 1472
    OBSIDIAN_BED = 1473
    WALDO = 1474
    DARKNESS = 1475
    DARK_SOUL_REAPER = 1476
    LAND = 1477
    TRAPPED_GHOST = 1478
    DEMONS_EYE = 1479
    FINDING_GOLD = 1480
    FIRST_ENCOUNTER = 1481
    GOOD_MORNING = 1482
    UNDERGROUND_REWARD = 1483
    THROUGHTHE_WINDOW = 1484
    PLACE_ABOVETHE_CLOUDS = 1485
    DO_NOT_STEPONTHE_GRASS = 1486
    COLD_WATERSINTHE_WHITE_LAND = 1487
    LIGHTLESS_CHASMS = 1488
    THE_LANDOF_DECEIVING_LOOKS = 1489
    DAYLIGHT = 1490
    SECRETOFTHE_SANDS = 1491
    DEADLAND_COMES_ALIVE = 1492
    EVIL_PRESENCE = 1493
    SKY_GUARDIAN = 1494
    AMERICAN_EXPLOSIVE = 1495
    DISCOVER = 1496
    HAND_EARTH = 1497
    OLD_MINER = 1498
    SKELEHEAD = 1499
    FACINGTHE_CEREBRAL_MASTERMIND = 1500
    LAKEOF_FIRE = 1501
    TRIO_SUPER_HEROES = 1502
    SPECTRE_HOOD = 1503
    SPECTRE_ROBE = 1504
    SPECTRE_PANTS = 1505
    SPECTRE_PICKAXE = 1506
    SPECTRE_HAMAXE = 1507
    ECTOPLASM = 1508
    GOTHIC_CHAIR = 1509
    GOTHIC_TABLE = 1510
    GOTHIC_WORK_BENCH = 1511
    GOTHIC_BOOKCASE = 1512
    PALADINS_HAMMER = 1513
    SWATHELMET = 1514
    BEE_WINGS = 1515
    GIANT_HARPY_FEATHER = 1516
    BONE_FEATHER = 1517
    FIRE_FEATHER = 1518
    ICE_FEATHER = 1519
    BROKEN_BAT_WING = 1520
    TATTERED_BEE_WING = 1521
    LARGE_AMETHYST = 1522
    LARGE_TOPAZ = 1523
    LARGE_SAPPHIRE = 1524
    LARGE_EMERALD = 1525
    LARGE_RUBY = 1526
    LARGE_DIAMOND = 1527
    JUNGLE_CHEST = 1528
    CORRUPTION_CHEST = 1529
    CRIMSON_CHEST = 1530
    HALLOWED_CHEST = 1531
    FROZEN_CHEST = 1532
    JUNGLE_KEY = 1533
    CORRUPTION_KEY = 1534
    CRIMSON_KEY = 1535
    HALLOWED_KEY = 1536
    FROZEN_KEY = 1537
    IMP_FACE = 1538
    OMINOUS_PRESENCE = 1539
    SHINING_MOON = 1540
    LIVING_GORE = 1541
    FLOWING_MAGMA = 1542
    SPECTRE_PAINTBRUSH = 1543
    SPECTRE_PAINT_ROLLER = 1544
    SPECTRE_PAINT_SCRAPER = 1545
    SHROOMITE_HEADGEAR = 1546
    SHROOMITE_MASK = 1547
    SHROOMITE_HELMET = 1548
    SHROOMITE_BREASTPLATE = 1549
    SHROOMITE_LEGGINGS = 1550
    AUTOHAMMER = 1551
    SHROOMITE_BAR = 1552
    SDMG = 1553
    CENXS_TIARA = 1554
    CENXS_BREASTPLATE = 1555
    CENXS_LEGGINGS = 1556
    CROWNOS_MASK = 1557
    CROWNOS_BREASTPLATE = 1558
    CROWNOS_LEGGINGS = 1559
    WILLS_HELMET = 1560
    WILLS_BREASTPLATE = 1561
    WILLS_LEGGINGS = 1562
    JIMS_HELMET = 1563
    JIMS_BREASTPLATE = 1564
    JIMS_LEGGINGS = 1565
    AARONS_HELMET = 1566
    AARONS_BREASTPLATE = 1567
    AARONS_LEGGINGS = 1568
    VAMPIRE_KNIVES = 1569
    BROKEN_HERO_SWORD = 1570
    SCOURGEOFTHE_CORRUPTOR = 1571
    STAFFOFTHE_FROST_HYDRA = 1572
    THE_CREATIONOFTHE_GUIDE = 1573
    THE_MERCHANT = 1574
    CROWNO_DEVOURS_HIS_LUNCH = 1575
    RARE_ENCHANTMENT = 1576
    GLORIOUS_NIGHT = 1577
    SWEETHEART_NECKLACE = 1578
    FLURRY_BOOTS = 1579
    DTOWNS_HELMET = 1580
    DTOWNS_BREASTPLATE = 1581
    DTOWNS_LEGGINGS = 1582
    DTOWNS_WINGS = 1583
    WILLS_WINGS = 1584
    CROWNOS_WINGS = 1585
    CENXS_WINGS = 1586
    CENXS_DRESS = 1587
    CENXS_DRESS_PANTS = 1588
    PALLADIUM_COLUMN = 1589
    PALLADIUM_COLUMN_WALL = 1590
    BUBBLEGUM_BLOCK = 1591
    BUBBLEGUM_BLOCK_WALL = 1592
    TITANSTONE_BLOCK = 1593
    TITANSTONE_BLOCK_WALL = 1594
    MAGIC_CUFFS = 1595
    MUSIC_BOX_SNOW = 1596
    MUSIC_BOX_SPACE = 1597
    MUSIC_BOX_CRIMSON = 1598
    MUSIC_BOX_BOSS4 = 1599
    MUSIC_BOX_ALT_OVERWORLD_DAY = 1600
    MUSIC_BOX_RAIN = 1601
    MUSIC_BOX_ICE = 1602
    MUSIC_BOX_DESERT = 1603
    MUSIC_BOX_OCEAN = 1604
    MUSIC_BOX_DUNGEON = 1605
    MUSIC_BOX_PLANTERA = 1606
    MUSIC_BOX_BOSS5 = 1607
    MUSIC_BOX_TEMPLE = 1608
    MUSIC_BOX_ECLIPSE = 1609
    MUSIC_BOX_MUSHROOMS = 1610
    BUTTERFLY_DUST = 1611
    ANKH_CHARM = 1612
    ANKH_SHIELD = 1613
    BLUE_FLARE = 1614
    ANGLER_FISH_BANNER = 1615
    ANGRY_NIMBUS_BANNER = 1616
    ANOMURA_FUNGUS_BANNER = 1617
    ANTLION_BANNER = 1618
    ARAPAIMA_BANNER = 1619
    ARMORED_SKELETON_BANNER = 1620
    BAT_BANNER = 1621
    BIRD_BANNER = 1622
    BLACK_RECLUSE_BANNER = 1623
    BLOOD_FEEDER_BANNER = 1624
    BLOOD_JELLY_BANNER = 1625
    BLOOD_CRAWLER_BANNER = 1626
    BONE_SERPENT_BANNER = 1627
    BUNNY_BANNER = 1628
    CHAOS_ELEMENTAL_BANNER = 1629
    MIMIC_BANNER = 1630
    CLOWN_BANNER = 1631
    CORRUPT_BUNNY_BANNER = 1632
    CORRUPT_GOLDFISH_BANNER = 1633
    CRAB_BANNER = 1634
    CRIMERA_BANNER = 1635
    CRIMSON_AXE_BANNER = 1636
    CURSED_HAMMER_BANNER = 1637
    DEMON_BANNER = 1638
    DEMON_EYE_BANNER = 1639
    DERPLING_BANNER = 1640
    EATEROF_SOULS_BANNER = 1641
    ENCHANTED_SWORD_BANNER = 1642
    ZOMBIE_ESKIMO_BANNER = 1643
    FACE_MONSTER_BANNER = 1644
    FLOATY_GROSS_BANNER = 1645
    FLYING_FISH_BANNER = 1646
    FLYING_SNAKE_BANNER = 1647
    FRANKENSTEIN_BANNER = 1648
    FUNGI_BULB_BANNER = 1649
    FUNGO_FISH_BANNER = 1650
    GASTROPOD_BANNER = 1651
    GOBLIN_THIEF_BANNER = 1652
    GOBLIN_SORCERER_BANNER = 1653
    GOBLIN_PEON_BANNER = 1654
    GOBLIN_SCOUT_BANNER = 1655
    GOBLIN_WARRIOR_BANNER = 1656
    GOLDFISH_BANNER = 1657
    HARPY_BANNER = 1658
    HELLBAT_BANNER = 1659
    HERPLING_BANNER = 1660
    HORNET_BANNER = 1661
    ICE_ELEMENTAL_BANNER = 1662
    ICY_MERMAN_BANNER = 1663
    FIRE_IMP_BANNER = 1664
    JELLYFISH_BANNER = 1665
    JUNGLE_CREEPER_BANNER = 1666
    LIHZAHRD_BANNER = 1667
    MAN_EATER_BANNER = 1668
    METEOR_HEAD_BANNER = 1669
    MOTH_BANNER = 1670
    MUMMY_BANNER = 1671
    MUSHI_LADYBUG_BANNER = 1672
    PARROT_BANNER = 1673
    PIGRON_BANNER = 1674
    PIRANHA_BANNER = 1675
    PIRATE_BANNER = 1676
    PIXIE_BANNER = 1677
    RAINCOAT_ZOMBIE_BANNER = 1678
    REAPER_BANNER = 1679
    SHARK_BANNER = 1680
    SKELETON_BANNER = 1681
    SKELETON_MAGE_BANNER = 1682
    SLIME_BANNER = 1683
    SNOW_FLINX_BANNER = 1684
    SPIDER_BANNER = 1685
    SPORE_ZOMBIE_BANNER = 1686
    SWAMP_THING_BANNER = 1687
    TORTOISE_BANNER = 1688
    TOXIC_SLUDGE_BANNER = 1689
    UMBRELLA_SLIME_BANNER = 1690
    UNICORN_BANNER = 1691
    VAMPIRE_BANNER = 1692
    VULTURE_BANNER = 1693
    NYPMH_BANNER = 1694
    WEREWOLF_BANNER = 1695
    WOLF_BANNER = 1696
    WORLD_FEEDER_BANNER = 1697
    WORM_BANNER = 1698
    WRAITH_BANNER = 1699
    WYVERN_BANNER = 1700
    ZOMBIE_BANNER = 1701
    GLASS_PLATFORM = 1702
    GLASS_CHAIR = 1703
    GOLDEN_CHAIR = 1704
    GOLDEN_TOILET = 1705
    BAR_STOOL = 1706
    HONEY_CHAIR = 1707
    STEAMPUNK_CHAIR = 1708
    GLASS_DOOR = 1709
    GOLDEN_DOOR = 1710
    HONEY_DOOR = 1711
    STEAMPUNK_DOOR = 1712
    GLASS_TABLE = 1713
    BANQUET_TABLE = 1714
    BAR = 1715
    GOLDEN_TABLE = 1716
    HONEY_TABLE = 1717
    STEAMPUNK_TABLE = 1718
    GLASS_BED = 1719
    GOLDEN_BED = 1720
    HONEY_BED = 1721
    STEAMPUNK_BED = 1722
    LIVING_WOOD_WALL = 1723
    FARTINA_JAR = 1724
    PUMPKIN = 1725
    PUMPKIN_WALL = 1726
    HAY = 1727
    HAY_WALL = 1728
    SPOOKY_WOOD = 1729
    SPOOKY_WOOD_WALL = 1730
    PUMPKIN_HELMET = 1731
    PUMPKIN_BREASTPLATE = 1732
    PUMPKIN_LEGGINGS = 1733
    CANDY_APPLE = 1734
    SOUL_CAKE = 1735
    NURSE_HAT = 1736
    NURSE_SHIRT = 1737
    NURSE_PANTS = 1738
    WIZARDS_HAT = 1739
    GUY_FAWKES_MASK = 1740
    DYE_TRADER_ROBE = 1741
    STEAMPUNK_GOGGLES = 1742
    CYBORG_HELMET = 1743
    CYBORG_SHIRT = 1744
    CYBORG_PANTS = 1745
    CREEPER_MASK = 1746
    CREEPER_SHIRT = 1747
    CREEPER_PANTS = 1748
    CAT_MASK = 1749
    CAT_SHIRT = 1750
    CAT_PANTS = 1751
    GHOST_MASK = 1752
    GHOST_SHIRT = 1753
    PUMPKIN_MASK = 1754
    PUMPKIN_SHIRT = 1755
    PUMPKIN_PANTS = 1756
    ROBOT_MASK = 1757
    ROBOT_SHIRT = 1758
    ROBOT_PANTS = 1759
    UNICORN_MASK = 1760
    UNICORN_SHIRT = 1761
    UNICORN_PANTS = 1762
    VAMPIRE_MASK = 1763
    VAMPIRE_SHIRT = 1764
    VAMPIRE_PANTS = 1765
    WITCH_HAT = 1766
    LEPRECHAUN_HAT = 1767
    LEPRECHAUN_SHIRT = 1768
    LEPRECHAUN_PANTS = 1769
    PIXIE_SHIRT = 1770
    PIXIE_PANTS = 1771
    PRINCESS_HAT = 1772
    PRINCESS_DRESS_NEW = 1773
    GOODIE_BAG = 1774
    WITCH_DRESS = 1775
    WITCH_BOOTS = 1776
    BRIDEOF_FRANKENSTEIN_MASK = 1777
    BRIDEOF_FRANKENSTEIN_DRESS = 1778
    KARATE_TORTOISE_MASK = 1779
    KARATE_TORTOISE_SHIRT = 1780
    KARATE_TORTOISE_PANTS = 1781
    CANDY_CORN_RIFLE = 1782
    CANDY_CORN = 1783
    JACK_OLANTERN_LAUNCHER = 1784
    EXPLOSIVE_JACK_OLANTERN = 1785
    SICKLE = 1786
    PUMPKIN_PIE = 1787
    SCARECROW_HAT = 1788
    SCARECROW_SHIRT = 1789
    SCARECROW_PANTS = 1790
    CAULDRON = 1791
    PUMPKIN_CHAIR = 1792
    PUMPKIN_DOOR = 1793
    PUMPKIN_TABLE = 1794
    PUMPKIN_WORK_BENCH = 1795
    PUMPKIN_PLATFORM = 1796
    TATTERED_FAIRY_WINGS = 1797
    SPIDER_EGG = 1798
    MAGICAL_PUMPKIN_SEED = 1799
    BAT_HOOK = 1800
    BAT_SCEPTER = 1801
    RAVEN_STAFF = 1802
    JUNGLE_KEY_MOLD = 1803
    CORRUPTION_KEY_MOLD = 1804
    CRIMSON_KEY_MOLD = 1805
    HALLOWED_KEY_MOLD = 1806
    FROZEN_KEY_MOLD = 1807
    HANGING_JACK_OLANTERN = 1808
    ROTTEN_EGG = 1809
    UNLUCKY_YARN = 1810
    BLACK_FAIRY_DUST = 1811
    JACKELIER = 1812
    JACK_OLANTERN = 1813
    SPOOKY_CHAIR = 1814
    SPOOKY_DOOR = 1815
    SPOOKY_TABLE = 1816
    SPOOKY_WORK_BENCH = 1817
    SPOOKY_PLATFORM = 1818
    REAPER_HOOD = 1819
    REAPER_ROBE = 1820
    FOX_MASK = 1821
    FOX_SHIRT = 1822
    FOX_PANTS = 1823
    CAT_EARS = 1824
    BLOODY_MACHETE = 1825
    THE_HORSEMANS_BLADE = 1826
    BLADED_GLOVE = 1827
    PUMPKIN_SEED = 1828
    SPOOKY_HOOK = 1829
    SPOOKY_WINGS = 1830
    SPOOKY_TWIG = 1831
    SPOOKY_HELMET = 1832
    SPOOKY_BREASTPLATE = 1833
    SPOOKY_LEGGINGS = 1834
    STAKE_LAUNCHER = 1835
    STAKE = 1836
    CURSED_SAPLING = 1837
    SPACE_CREATURE_MASK = 1838
    SPACE_CREATURE_SHIRT = 1839
    SPACE_CREATURE_PANTS = 1840
    WOLF_MASK = 1841
    WOLF_SHIRT = 1842
    WOLF_PANTS = 1843
    PUMPKIN_MOON_MEDALLION = 1844
    NECROMANTIC_SCROLL = 1845
    JACKING_SKELETRON = 1846
    BITTER_HARVEST = 1847
    BLOOD_MOON_COUNTESS = 1848
    HALLOWS_EVE = 1849
    MORBID_CURIOSITY = 1850
    TREASURE_HUNTER_SHIRT = 1851
    TREASURE_HUNTER_PANTS = 1852
    DRYAD_COVERINGS = 1853
    DRYAD_LOINCLOTH = 1854
    MOURNING_WOOD_TROPHY = 1855
    PUMPKING_TROPHY = 1856
    JACK_OLANTERN_MASK = 1857
    SNIPER_SCOPE = 1858
    HEART_LANTERN = 1859
    JELLYFISH_DIVING_GEAR = 1860
    ARCTIC_DIVING_GEAR = 1861
    FROSTSPARK_BOOTS = 1862
    FART_IN_ABALLOON = 1863
    PAPYRUS_SCARAB = 1864
    CELESTIAL_STONE = 1865
    HOVERBOARD = 1866
    CANDY_CANE = 1867
    SUGAR_PLUM = 1868
    PRESENT = 1869
    RED_RYDER = 1870
    FESTIVE_WINGS = 1871
    PINE_TREE_BLOCK = 1872
    CHRISTMAS_TREE = 1873
    STAR_TOPPER1 = 1874
    STAR_TOPPER2 = 1875
    STAR_TOPPER3 = 1876
    BOW_TOPPER = 1877
    WHITE_GARLAND = 1878
    WHITE_AND_RED_GARLAND = 1879
    RED_GARDLAND = 1880
    RED_AND_GREEN_GARDLAND = 1881
    GREEN_GARDLAND = 1882
    GREEN_AND_WHITE_GARLAND = 1883
    MULTICOLORED_BULB = 1884
    RED_BULB = 1885
    YELLOW_BULB = 1886
    GREEN_BULB = 1887
    RED_AND_GREEN_BULB = 1888
    YELLOW_AND_GREEN_BULB = 1889
    RED_AND_YELLOW_BULB = 1890
    WHITE_BULB = 1891
    WHITE_AND_RED_BULB = 1892
    WHITE_AND_YELLOW_BULB = 1893
    WHITE_AND_GREEN_BULB = 1894
    MULTICOLORED_LIGHTS = 1895
    RED_LIGHTS = 1896
    GREEN_LIGHTS = 1897
    BLUE_LIGHTS = 1898
    YELLOW_LIGHTS = 1899
    RED_AND_YELLOW_LIGHTS = 1900
    RED_AND_GREEN_LIGHTS = 1901
    YELLOW_AND_GREEN_LIGHTS = 1902
    BLUE_AND_GREEN_LIGHTS = 1903
    RED_AND_BLUE_LIGHTS = 1904
    BLUE_AND_YELLOW_LIGHTS = 1905
    GIANT_BOW = 1906
    REINDEER_ANTLERS = 1907
    HOLLY = 1908
    CANDY_CANE_SWORD = 1909
    ELD_MELTER = 1910
    CHRISTMAS_PUDDING = 1911
    EGGNOG = 1912
    STAR_ANISE = 1913
    REINDEER_BELLS = 1914
    CANDY_CANE_HOOK = 1915
    CHRISTMAS_HOOK = 1916
    CNADY_CANE_PICKAXE = 1917
    FRUITCAKE_CHAKRAM = 1918
    SUGAR_COOKIE = 1919
    GINGERBREAD_COOKIE = 1920
    HAND_WARMER = 1921
    COAL = 1922
    TOOLBOX = 1923
    PINE_DOOR = 1924
    PINE_CHAIR = 1925
    PINE_TABLE = 1926
    DOG_WHISTLE = 1927
    CHRISTMAS_TREE_SWORD = 1928
    CHAIN_GUN = 1929
    RAZORPINE = 1930
    BLIZZARD_STAFF = 1931
    MRS_CLAUSE_HAT = 1932
    MRS_CLAUSE_SHIRT = 1933
    MRS_CLAUSE_HEELS = 1934
    PARKA_HOOD = 1935
    PARKA_COAT = 1936
    PARKA_PANTS = 1937
    SNOW_HAT = 1938
    UGLY_SWEATER = 1939
    TREE_MASK = 1940
    TREE_SHIRT = 1941
    TREE_TRUNKS = 1942
    ELF_HAT = 1943
    ELF_SHIRT = 1944
    ELF_PANTS = 1945
    SNOWMAN_CANNON = 1946
    NORTH_POLE = 1947
    CHRISTMAS_TREE_WALLPAPER = 1948
    ORNAMENT_WALLPAPER = 1949
    CANDY_CANE_WALLPAPER = 1950
    FESTIVE_WALLPAPER = 1951
    STARS_WALLPAPER = 1952
    SQUIGGLES_WALLPAPER = 1953
    SNOWFLAKE_WALLPAPER = 1954
    KRAMPUS_HORN_WALLPAPER = 1955
    BLUEGREEN_WALLPAPER = 1956
    GRINCH_FINGER_WALLPAPER = 1957
    NAUGHTY_PRESENT = 1958
    BABY_GRINCH_MISCHIEF_WHISTLE = 1959
    ICE_QUEEN_TROPHY = 1960
    SANTA_NK1TROPHY = 1961
    EVERSCREAM_TROPHY = 1962
    MUSIC_BOX_PUMPKIN_MOON = 1963
    MUSIC_BOX_ALT_UNDERGROUND = 1964
    MUSIC_BOX_FROST_MOON = 1965
    BROWN_PAINT = 1966
    SHADOW_PAINT = 1967
    NEGATIVE_PAINT = 1968
    TEAM_DYE = 1969
    AMETHYST_GEMSPARK_BLOCK = 1970
    TOPAZ_GEMSPARK_BLOCK = 1971
    SAPPHIRE_GEMSPARK_BLOCK = 1972
    EMERALD_GEMSPARK_BLOCK = 1973
    RUBY_GEMSPARK_BLOCK = 1974
    DIAMOND_GEMSPARK_BLOCK = 1975
    AMBER_GEMSPARK_BLOCK = 1976
    LIFE_HAIR_DYE = 1977
    MANA_HAIR_DYE = 1978
    DEPTH_HAIR_DYE = 1979
    MONEY_HAIR_DYE = 1980
    TIME_HAIR_DYE = 1981
    TEAM_HAIR_DYE = 1982
    BIOME_HAIR_DYE = 1983
    PARTY_HAIR_DYE = 1984
    RAINBOW_HAIR_DYE = 1985
    SPEED_HAIR_DYE = 1986
    ANGEL_HALO = 1987
    FEZ = 1988
    WOMANNQUIN = 1989
    HAIR_DYE_REMOVER = 1990
    BUG_NET = 1991
    FIREFLY = 1992
    FIREFLYINA_BOTTLE = 1993
    MONARCH_BUTTERFLY = 1994
    PURPLE_EMPEROR_BUTTERFLY = 1995
    RED_ADMIRAL_BUTTERFLY = 1996
    ULYSSES_BUTTERFLY = 1997
    SULPHUR_BUTTERFLY = 1998
    TREE_NYMPH_BUTTERFLY = 1999
    ZEBRA_SWALLOWTAIL_BUTTERFLY = 2000
    JULIA_BUTTERFLY = 2001
    WORM = 2002
    MOUSE = 2003
    LIGHTNING_BUG = 2004
    LIGHTNING_BUGINA_BOTTLE = 2005
    SNAIL = 2006
    GLOWING_SNAIL = 2007
    FANCY_GREY_WALLPAPER = 2008
    ICE_FLOE_WALLPAPER = 2009
    MUSIC_WALLPAPER = 2010
    PURPLE_RAIN_WALLPAPER = 2011
    RAINBOW_WALLPAPER = 2012
    SPARKLE_STONE_WALLPAPER = 2013
    STARLIT_HEAVEN_WALLPAPER = 2014
    BIRD = 2015
    BLUE_JAY = 2016
    CARDINAL = 2017
    SQUIRREL = 2018
    BUNNY = 2019
    CACTUS_BOOKCASE = 2020
    EBONWOOD_BOOKCASE = 2021
    FLESH_BOOKCASE = 2022
    HONEY_BOOKCASE = 2023
    STEAMPUNK_BOOKCASE = 2024
    GLASS_BOOKCASE = 2025
    RICH_MAHOGANY_BOOKCASE = 2026
    PEARLWOOD_BOOKCASE = 2027
    SPOOKY_BOOKCASE = 2028
    SKYWARE_BOOKCASE = 2029
    LIHZAHRD_BOOKCASE = 2030
    FROZEN_BOOKCASE = 2031
    CACTUS_LANTERN = 2032
    EBONWOOD_LANTERN = 2033
    FLESH_LANTERN = 2034
    HONEY_LANTERN = 2035
    STEAMPUNK_LANTERN = 2036
    GLASS_LANTERN = 2037
    RICH_MAHOGANY_LANTERN = 2038
    PEARLWOOD_LANTERN = 2039
    FROZEN_LANTERN = 2040
    LIHZAHRD_LANTERN = 2041
    SKYWARE_LANTERN = 2042
    SPOOKY_LANTERN = 2043
    FROZEN_DOOR = 2044
    CACTUS_CANDLE = 2045
    EBONWOOD_CANDLE = 2046
    FLESH_CANDLE = 2047
    GLASS_CANDLE = 2048
    FROZEN_CANDLE = 2049
    RICH_MAHOGANY_CANDLE = 2050
    PEARLWOOD_CANDLE = 2051
    LIHZAHRD_CANDLE = 2052
    SKYWARE_CANDLE = 2053
    PUMPKIN_CANDLE = 2054
    CACTUS_CHANDELIER = 2055
    EBONWOOD_CHANDELIER = 2056
    FLESH_CHANDELIER = 2057
    HONEY_CHANDELIER = 2058
    FROZEN_CHANDELIER = 2059
    RICH_MAHOGANY_CHANDELIER = 2060
    PEARLWOOD_CHANDELIER = 2061
    LIHZAHRD_CHANDELIER = 2062
    SKYWARE_CHANDELIER = 2063
    SPOOKY_CHANDELIER = 2064
    GLASS_CHANDELIER = 2065
    CACTUS_BED = 2066
    FLESH_BED = 2067
    FROZEN_BED = 2068
    LIHZAHRD_BED = 2069
    SKYWARE_BED = 2070
    SPOOKY_BED = 2071
    CACTUS_BATHTUB = 2072
    EBONWOOD_BATHTUB = 2073
    FLESH_BATHTUB = 2074
    GLASS_BATHTUB = 2075
    FROZEN_BATHTUB = 2076
    RICH_MAHOGANY_BATHTUB = 2077
    PEARLWOOD_BATHTUB = 2078
    LIHZAHRD_BATHTUB = 2079
    SKYWARE_BATHTUB = 2080
    SPOOKY_BATHTUB = 2081
    CACTUS_LAMP = 2082
    EBONWOOD_LAMP = 2083
    FLESH_LAMP = 2084
    GLASS_LAMP = 2085
    FROZEN_LAMP = 2086
    RICH_MAHOGANY_LAMP = 2087
    PEARLWOOD_LAMP = 2088
    LIHZAHRD_LAMP = 2089
    SKYWARE_LAMP = 2090
    SPOOKY_LAMP = 2091
    CACTUS_CANDELABRA = 2092
    EBONWOOD_CANDELABRA = 2093
    FLESH_CANDELABRA = 2094
    HONEY_CANDELABRA = 2095
    STEAMPUNK_CANDELABRA = 2096
    GLASS_CANDELABRA = 2097
    RICH_MAHOGANY_CANDELABRA = 2098
    PEARLWOOD_CANDELABRA = 2099
    FROZEN_CANDELABRA = 2100
    LIHZAHRD_CANDELABRA = 2101
    SKYWARE_CANDELABRA = 2102
    SPOOKY_CANDELABRA = 2103
    BRAIN_MASK = 2104
    FLESH_MASK = 2105
    TWIN_MASK = 2106
    SKELETRON_PRIME_MASK = 2107
    BEE_MASK = 2108
    PLANTERA_MASK = 2109
    GOLEM_MASK = 2110
    EATER_MASK = 2111
    EYE_MASK = 2112
    DESTROYER_MASK = 2113
    BLACKSMITH_RACK = 2114
    CARPENTRY_RACK = 2115
    HELMET_RACK = 2116
    SPEAR_RACK = 2117
    SWORD_RACK = 2118
    STONE_SLAB = 2119
    SANDSTONE_SLAB = 2120
    FROG = 2121
    MALLARD_DUCK = 2122
    DUCK = 2123
    HONEY_BATHTUB = 2124
    STEAMPUNK_BATHTUB = 2125
    LIVING_WOOD_BATHTUB = 2126
    SHADEWOOD_BATHTUB = 2127
    BONE_BATHTUB = 2128
    HONEY_LAMP = 2129
    STEAMPUNK_LAMP = 2130
    LIVING_WOOD_LAMP = 2131
    SHADEWOOD_LAMP = 2132
    GOLDEN_LAMP = 2133
    BONE_LAMP = 2134
    LIVING_WOOD_BOOKCASE = 2135
    SHADEWOOD_BOOKCASE = 2136
    GOLDEN_BOOKCASE = 2137
    BONE_BOOKCASE = 2138
    LIVING_WOOD_BED = 2139
    BONE_BED = 2140
    LIVING_WOOD_CHANDELIER = 2141
    SHADEWOOD_CHANDELIER = 2142
    GOLDEN_CHANDELIER = 2143
    BONE_CHANDELIER = 2144
    LIVING_WOOD_LANTERN = 2145
    SHADEWOOD_LANTERN = 2146
    GOLDEN_LANTERN = 2147
    BONE_LANTERN = 2148
    LIVING_WOOD_CANDELABRA = 2149
    SHADEWOOD_CANDELABRA = 2150
    GOLDEN_CANDELABRA = 2151
    BONE_CANDELABRA = 2152
    LIVING_WOOD_CANDLE = 2153
    SHADEWOOD_CANDLE = 2154
    GOLDEN_CANDLE = 2155
    BLACK_SCORPION = 2156
    SCORPION = 2157
    BUBBLE_WALLPAPER = 2158
    COPPER_PIPE_WALLPAPER = 2159
    DUCKY_WALLPAPER = 2160
    FROST_CORE = 2161
    BUNNY_CAGE = 2162
    SQUIRREL_CAGE = 2163
    MALLARD_DUCK_CAGE = 2164
    DUCK_CAGE = 2165
    BIRD_CAGE = 2166
    BLUE_JAY_CAGE = 2167
    CARDINAL_CAGE = 2168
    WATERFALL_WALL = 2169
    LAVAFALL_WALL = 2170
    CRIMSON_SEEDS = 2171
    HEAVY_WORK_BENCH = 2172
    COPPER_PLATING = 2173
    SNAIL_CAGE = 2174
    GLOWING_SNAIL_CAGE = 2175
    SHROOMITE_DIGGING_CLAW = 2176
    AMMO_BOX = 2177
    MONARCH_BUTTERFLY_JAR = 2178
    PURPLE_EMPEROR_BUTTERFLY_JAR = 2179
    RED_ADMIRAL_BUTTERFLY_JAR = 2180
    ULYSSES_BUTTERFLY_JAR = 2181
    SULPHUR_BUTTERFLY_JAR = 2182
    TREE_NYMPH_BUTTERFLY_JAR = 2183
    ZEBRA_SWALLOWTAIL_BUTTERFLY_JAR = 2184
    JULIA_BUTTERFLY_JAR = 2185
    SCORPION_CAGE = 2186
    BLACK_SCORPION_CAGE = 2187
    VENOM_STAFF = 2188
    SPECTRE_MASK = 2189
    FROG_CAGE = 2190
    MOUSE_CAGE = 2191
    BONE_WELDER = 2192
    FLESH_CLONING_VAAT = 2193
    GLASS_KILN = 2194
    LIHZAHRD_FURNACE = 2195
    LIVING_LOOM = 2196
    SKY_MILL = 2197
    ICE_MACHINE = 2198
    BEETLE_HELMET = 2199
    BEETLE_SCALE_MAIL = 2200
    BEETLE_SHELL = 2201
    BEETLE_LEGGINGS = 2202
    STEAMPUNK_BOILER = 2203
    HONEY_DISPENSER = 2204
    PENGUIN = 2205
    PENGUIN_CAGE = 2206
    WORM_CAGE = 2207
    TERRARIUM = 2208
    SUPER_MANA_POTION = 2209
    EBONWOOD_FENCE = 2210
    RICH_MAHOGANY_FENCE = 2211
    PEARLWOOD_FENCE = 2212
    SHADEWOOD_FENCE = 2213
    BRICK_LAYER = 2214
    EXTENDO_GRIP = 2215
    PAINT_SPRAYER = 2216
    PORTABLE_CEMENT_MIXER = 2217
    BEETLE_HUSK = 2218
    CELESTIAL_MAGNET = 2219
    CELESTIAL_EMBLEM = 2220
    CELESTIAL_CUFFS = 2221
    PEDDLERS_HAT = 2222
    PULSE_BOW = 2223
    DYNASTY_CHANDELIER = 2224
    DYNASTY_LAMP = 2225
    DYNASTY_LANTERN = 2226
    DYNASTY_CANDELABRA = 2227
    DYNASTY_CHAIR = 2228
    DYNASTY_WORK_BENCH = 2229
    DYNASTY_CHEST = 2230
    DYNASTY_BED = 2231
    DYNASTY_BATHTUB = 2232
    DYNASTY_BOOKCASE = 2233
    DYNASTY_CUP = 2234
    DYNASTY_BOWL = 2235
    DYNASTY_CANDLE = 2236
    DYNASTY_CLOCK = 2237
    GOLDEN_CLOCK = 2238
    GLASS_CLOCK = 2239
    HONEY_CLOCK = 2240
    STEAMPUNK_CLOCK = 2241
    FANCY_DISHES = 2242
    GLASS_BOWL = 2243
    WINE_GLASS = 2244
    LIVING_WOOD_PIANO = 2245
    FLESH_PIANO = 2246
    FROZEN_PIANO = 2247
    FROZEN_TABLE = 2248
    HONEY_CHEST = 2249
    STEAMPUNK_CHEST = 2250
    HONEY_WORK_BENCH = 2251
    FROZEN_WORK_BENCH = 2252
    STEAMPUNK_WORK_BENCH = 2253
    GLASS_PIANO = 2254
    HONEY_PIANO = 2255
    STEAMPUNK_PIANO = 2256
    HONEY_CUP = 2257
    STEAMPUNK_CUP = 2258
    DYNASTY_TABLE = 2259
    DYNASTY_WOOD = 2260
    RED_DYNASTY_SHINGLES = 2261
    BLUE_DYNASTY_SHINGLES = 2262
    WHITE_DYNASTY_WALL = 2263
    BLUE_DYNASTY_WALL = 2264
    DYNASTY_DOOR = 2265
    SAKE = 2266
    PAD_THAI = 2267
    PHO = 2268
    REVOLVER = 2269
    GATLIGATOR = 2270
    ARCANE_RUNE_WALL = 2271
    WATER_GUN = 2272
    KATANA = 2273
    ULTRABRIGHT_TORCH = 2274
    MAGIC_HAT = 2275
    DIAMOND_RING = 2276
    GI = 2277
    KIMONO = 2278
    GYPSY_ROBE = 2279
    BEETLE_WINGS = 2280
    TIGER_SKIN = 2281
    LEOPARD_SKIN = 2282
    ZEBRA_SKIN = 2283
    CRIMSON_CLOAK = 2284
    MYSTERIOUS_CAPE = 2285
    RED_CAPE = 2286
    WINTER_CAPE = 2287
    FROZEN_CHAIR = 2288
    WOOD_FISHING_POLE = 2289
    BASS = 2290
    REINFORCED_FISHING_POLE = 2291
    FIBERGLASS_FISHING_POLE = 2292
    FISHEROF_SOULS = 2293
    GOLDEN_FISHING_ROD = 2294
    MECHANICS_ROD = 2295
    SITTING_DUCKS_FISHING_ROD = 2296
    TROUT = 2297
    SALMON = 2298
    ATLANTIC_COD = 2299
    TUNA = 2300
    RED_SNAPPER = 2301
    NEON_TETRA = 2302
    ARMORED_CAVEFISH = 2303
    DAMSELFISH = 2304
    CRIMSON_TIGERFISH = 2305
    FROST_MINNOW = 2306
    PRINCESS_FISH = 2307
    GOLDEN_CARP = 2308
    SPECULAR_FISH = 2309
    PRISMITE = 2310
    VARIEGATED_LARDFISH = 2311
    FLAREFIN_KOI = 2312
    DOUBLE_COD = 2313
    HONEYFIN = 2314
    OBSIDIFISH = 2315
    SHRIMP = 2316
    CHAOS_FISH = 2317
    EBONKOI = 2318
    HEMOPIRANHA = 2319
    ROCKFISH = 2320
    STINKFISH = 2321
    MINING_POTION = 2322
    HEARTREACH_POTION = 2323
    CALMING_POTION = 2324
    BUILDER_POTION = 2325
    TITAN_POTION = 2326
    FLIPPER_POTION = 2327
    SUMMONING_POTION = 2328
    TRAPSIGHT_POTION = 2329
    PURPLE_CLUBBERFISH = 2330
    OBSIDIAN_SWORDFISH = 2331
    SWORDFISH = 2332
    IRON_FENCE = 2333
    WOODEN_CRATE = 2334
    IRON_CRATE = 2335
    GOLDEN_CRATE = 2336
    OLD_SHOE = 2337
    FISHING_SEAWEED = 2338
    TIN_CAN = 2339
    MINECART_TRACK = 2340
    REAVER_SHARK = 2341
    SAWTOOTH_SHARK = 2342
    MINECART = 2343
    AMMO_RESERVATION_POTION = 2344
    LIFEFORCE_POTION = 2345
    ENDURANCE_POTION = 2346
    RAGE_POTION = 2347
    INFERNO_POTION = 2348
    WRATH_POTION = 2349
    RECALL_POTION = 2350
    TELEPORTATION_POTION = 2351
    LOVE_POTION = 2352
    STINK_POTION = 2353
    FISHING_POTION = 2354
    SONAR_POTION = 2355
    CRATE_POTION = 2356
    SHIVERTHORN_SEEDS = 2357
    SHIVERTHORN = 2358
    WARMTH_POTION = 2359
    FISH_HOOK = 2360
    BEE_HEADGEAR = 2361
    BEE_BREASTPLATE = 2362
    BEE_GREAVES = 2363
    HORNET_STAFF = 2364
    IMP_STAFF = 2365
    QUEEN_SPIDER_STAFF = 2366
    ANGLER_HAT = 2367
    ANGLER_VEST = 2368
    ANGLER_PANTS = 2369
    SPIDER_MASK = 2370
    SPIDER_BREASTPLATE = 2371
    SPIDER_GREAVES = 2372
    HIGH_TEST_FISHING_LINE = 2373
    ANGLER_EARRING = 2374
    TACKLE_BOX = 2375
    BLUE_DUNGEON_PIANO = 2376
    GREEN_DUNGEON_PIANO = 2377
    PINK_DUNGEON_PIANO = 2378
    GOLDEN_PIANO = 2379
    OBSIDIAN_PIANO = 2380
    BONE_PIANO = 2381
    CACTUS_PIANO = 2382
    SPOOKY_PIANO = 2383
    SKYWARE_PIANO = 2384
    LIHZAHRD_PIANO = 2385
    BLUE_DUNGEON_DRESSER = 2386
    GREEN_DUNGEON_DRESSER = 2387
    PINK_DUNGEON_DRESSER = 2388
    GOLDEN_DRESSER = 2389
    OBSIDIAN_DRESSER = 2390
    BONE_DRESSER = 2391
    CACTUS_DRESSER = 2392
    SPOOKY_DRESSER = 2393
    SKYWARE_DRESSER = 2394
    HONEY_DRESSER = 2395
    LIHZAHRD_DRESSER = 2396
    SOFA = 2397
    EBONWOOD_SOFA = 2398
    RICH_MAHOGANY_SOFA = 2399
    PEARLWOOD_SOFA = 2400
    SHADEWOOD_SOFA = 2401
    BLUE_DUNGEON_SOFA = 2402
    GREEN_DUNGEON_SOFA = 2403
    PINK_DUNGEON_SOFA = 2404
    GOLDEN_SOFA = 2405
    OBSIDIAN_SOFA = 2406
    BONE_SOFA = 2407
    CACTUS_SOFA = 2408
    SPOOKY_SOFA = 2409
    SKYWARE_SOFA = 2410
    HONEY_SOFA = 2411
    STEAMPUNK_SOFA = 2412
    MUSHROOM_SOFA = 2413
    GLASS_SOFA = 2414
    PUMPKIN_SOFA = 2415
    LIHZAHRD_SOFA = 2416
    SEASHELL_HAIRPIN = 2417
    MERMAID_ADORNMENT = 2418
    MERMAID_TAIL = 2419
    ZEPHYR_FISH = 2420
    FLESHCATCHER = 2421
    HOTLINE_FISHING_HOOK = 2422
    FROG_LEG = 2423
    ANCHOR = 2424
    COOKED_FISH = 2425
    COOKED_SHRIMP = 2426
    SASHIMI = 2427
    FUZZY_CARROT = 2428
    SCALY_TRUFFLE = 2429
    SLIMY_SADDLE = 2430
    BEE_WAX = 2431
    COPPER_PLATING_WALL = 2432
    STONE_SLAB_WALL = 2433
    SAIL = 2434
    CORALSTONE_BLOCK = 2435
    BLUE_JELLYFISH = 2436
    GREEN_JELLYFISH = 2437
    PINK_JELLYFISH = 2438
    BLUE_JELLYFISH_JAR = 2439
    GREEN_JELLYFISH_JAR = 2440
    PINK_JELLYFISH_JAR = 2441
    LIFE_PRESERVER = 2442
    SHIPS_WHEEL = 2443
    COMPASS_ROSE = 2444
    WALL_ANCHOR = 2445
    GOLDFISH_TROPHY = 2446
    BUNNYFISH_TROPHY = 2447
    SWORDFISH_TROPHY = 2448
    SHARKTEETH_TROPHY = 2449
    BATFISH = 2450
    BUMBLEBEE_TUNA = 2451
    CATFISH = 2452
    CLOUDFISH = 2453
    CURSEDFISH = 2454
    DIRTFISH = 2455
    DYNAMITE_FISH = 2456
    EATEROF_PLANKTON = 2457
    FALLEN_STARFISH = 2458
    THE_FISHOF_CTHULU = 2459
    FISHOTRON = 2460
    HARPYFISH = 2461
    HUNGERFISH = 2462
    ICHORFISH = 2463
    JEWELFISH = 2464
    MIRAGE_FISH = 2465
    MUTANT_FLINXFIN = 2466
    PENGFISH = 2467
    PIXIEFISH = 2468
    SPIDERFISH = 2469
    TUNDRA_TROUT = 2470
    UNICORN_FISH = 2471
    GUIDE_VOODOO_FISH = 2472
    WYVERNTAIL = 2473
    ZOMBIE_FISH = 2474
    AMANITIA_FUNGIFIN = 2475
    ANGELFISH = 2476
    BLOODY_MANOWAR = 2477
    BONEFISH = 2478
    BUNNYFISH = 2479
    CAPN_TUNABEARD = 2480
    CLOWNFISH = 2481
    DEMONIC_HELLFISH = 2482
    DERPFISH = 2483
    FISHRON = 2484
    INFECTED_SCABBARDFISH = 2485
    MUDFISH = 2486
    SLIMEFISH = 2487
    TROPICAL_BARRACUDA = 2488
    KING_SLIME_TROPHY = 2489
    SHIP_IN_ABOTTLE = 2490
    HARDY_SADDLE = 2491
    PRESSURE_TRACK = 2492
    KING_SLIME_MASK = 2493
    FIN_WINGS = 2494
    TREASURE_MAP = 2495
    SEAWEED_PLANTER = 2496
    PILLAGIN_ME_PIXELS = 2497
    FISH_COSTUME_MASK = 2498
    FISH_COSTUME_SHIRT = 2499
    FISH_COSTUME_FINSKIRT = 2500
    GINGER_BEARD = 2501
    HONEYED_GOGGLES = 2502
    BOREAL_WOOD = 2503
    PALM_WOOD = 2504
    BOREAL_WOOD_WALL = 2505
    PALM_WOOD_WALL = 2506
    BOREAL_WOOD_FENCE = 2507
    PALM_WOOD_FENCE = 2508
    BOREAL_WOOD_HELMET = 2509
    BOREAL_WOOD_BREASTPLATE = 2510
    BOREAL_WOOD_GREAVES = 2511
    PALM_WOOD_HELMET = 2512
    PALM_WOOD_BREASTPLATE = 2513
    PALM_WOOD_GREAVES = 2514
    PALM_WOOD_BOW = 2515
    PALM_WOOD_HAMMER = 2516
    PALM_WOOD_SWORD = 2517
    PALM_WOOD_PLATFORM = 2518
    PALM_WOOD_BATHTUB = 2519
    PALM_WOOD_BED = 2520
    PALM_WOOD_BENCH = 2521
    PALM_WOOD_CANDELABRA = 2522
    PALM_WOOD_CANDLE = 2523
    PALM_WOOD_CHAIR = 2524
    PALM_WOOD_CHANDELIER = 2525
    PALM_WOOD_CHEST = 2526
    PALM_WOOD_SOFA = 2527
    PALM_WOOD_DOOR = 2528
    PALM_WOOD_DRESSER = 2529
    PALM_WOOD_LANTERN = 2530
    PALM_WOOD_PIANO = 2531
    PALM_WOOD_TABLE = 2532
    PALM_WOOD_LAMP = 2533
    PALM_WOOD_WORK_BENCH = 2534
    OPTIC_STAFF = 2535
    PALM_WOOD_BOOKCASE = 2536
    MUSHROOM_BATHTUB = 2537
    MUSHROOM_BED = 2538
    MUSHROOM_BENCH = 2539
    MUSHROOM_BOOKCASE = 2540
    MUSHROOM_CANDELABRA = 2541
    MUSHROOM_CANDLE = 2542
    MUSHROOM_CHANDELIER = 2543
    MUSHROOM_CHEST = 2544
    MUSHROOM_DRESSER = 2545
    MUSHROOM_LANTERN = 2546
    MUSHROOM_LAMP = 2547
    MUSHROOM_PIANO = 2548
    MUSHROOM_PLATFORM = 2549
    MUSHROOM_TABLE = 2550
    SPIDER_STAFF = 2551
    BOREAL_WOOD_BATHTUB = 2552
    BOREAL_WOOD_BED = 2553
    BOREAL_WOOD_BOOKCASE = 2554
    BOREAL_WOOD_CANDELABRA = 2555
    BOREAL_WOOD_CANDLE = 2556
    BOREAL_WOOD_CHAIR = 2557
    BOREAL_WOOD_CHANDELIER = 2558
    BOREAL_WOOD_CHEST = 2559
    BOREAL_WOOD_CLOCK = 2560
    BOREAL_WOOD_DOOR = 2561
    BOREAL_WOOD_DRESSER = 2562
    BOREAL_WOOD_LAMP = 2563
    BOREAL_WOOD_LANTERN = 2564
    BOREAL_WOOD_PIANO = 2565
    BOREAL_WOOD_PLATFORM = 2566
    SLIME_BATHTUB = 2567
    SLIME_BED = 2568
    SLIME_BOOKCASE = 2569
    SLIME_CANDELABRA = 2570
    SLIME_CANDLE = 2571
    SLIME_CHAIR = 2572
    SLIME_CHANDELIER = 2573
    SLIME_CHEST = 2574
    SLIME_CLOCK = 2575
    SLIME_DOOR = 2576
    SLIME_DRESSER = 2577
    SLIME_LAMP = 2578
    SLIME_LANTERN = 2579
    SLIME_PIANO = 2580
    SLIME_PLATFORM = 2581
    SLIME_SOFA = 2582
    SLIME_TABLE = 2583
    PIRATE_STAFF = 2584
    SLIME_HOOK = 2585
    STICKY_GRENADE = 2586
    TARTAR_SAUCE = 2587
    DUKE_FISHRON_MASK = 2588
    DUKE_FISHRON_TROPHY = 2589
    MOLOTOV_COCKTAIL = 2590
    BONE_CLOCK = 2591
    CACTUS_CLOCK = 2592
    EBONWOOD_CLOCK = 2593
    FROZEN_CLOCK = 2594
    LIHZAHRD_CLOCK = 2595
    LIVING_WOOD_CLOCK = 2596
    RICH_MAHOGANY_CLOCK = 2597
    FLESH_CLOCK = 2598
    MUSHROOM_CLOCK = 2599
    OBSIDIAN_CLOCK = 2600
    PALM_WOOD_CLOCK = 2601
    PEARLWOOD_CLOCK = 2602
    PUMPKIN_CLOCK = 2603
    SHADEWOOD_CLOCK = 2604
    SPOOKY_CLOCK = 2605
    SKYWARE_CLOCK = 2606
    SPIDER_FANG = 2607
    FALCON_BLADE = 2608
    FISHRON_WINGS = 2609
    SLIME_GUN = 2610
    FLAIRON = 2611
    GREEN_DUNGEON_CHEST = 2612
    PINK_DUNGEON_CHEST = 2613
    BLUE_DUNGEON_CHEST = 2614
    BONE_CHEST = 2615
    CACTUS_CHEST = 2616
    FLESH_CHEST = 2617
    OBSIDIAN_CHEST = 2618
    PUMPKIN_CHEST = 2619
    SPOOKY_CHEST = 2620
    TEMPEST_STAFF = 2621
    RAZORBLADE_TYPHOON = 2622
    BUBBLE_GUN = 2623
    TSUNAMI = 2624
    SEASHELL = 2625
    STARFISH = 2626
    STEAMPUNK_PLATFORM = 2627
    SKYWARE_PLATFORM = 2628
    LIVING_WOOD_PLATFORM = 2629
    HONEY_PLATFORM = 2630
    SKYWARE_WORKBENCH = 2631
    GLASS_WORK_BENCH = 2632
    LIVING_WOOD_WORK_BENCH = 2633
    FLESH_SOFA = 2634
    FROZEN_SOFA = 2635
    LIVING_WOOD_SOFA = 2636
    PUMPKIN_DRESSER = 2637
    STEAMPUNK_DRESSER = 2638
    GLASS_DRESSER = 2639
    FLESH_DRESSER = 2640
    PUMPKIN_LANTERN = 2641
    OBSIDIAN_LANTERN = 2642
    PUMPKIN_LAMP = 2643
    OBSIDIAN_LAMP = 2644
    BLUE_DUNGEON_LAMP = 2645
    GREEN_DUNGEON_LAMP = 2646
    PINK_DUNGEON_LAMP = 2647
    HONEY_CANDLE = 2648
    STEAMPUNK_CANDLE = 2649
    SPOOKY_CANDLE = 2650
    OBSIDIAN_CANDLE = 2651
    BLUE_DUNGEON_CHANDELIER = 2652
    GREEN_DUNGEON_CHANDELIER = 2653
    PINK_DUNGEON_CHANDELIER = 2654
    STEAMPUNK_CHANDELIER = 2655
    PUMPKIN_CHANDELIER = 2656
    OBSIDIAN_CHANDELIER = 2657
    BLUE_DUNGEON_BATHTUB = 2658
    GREEN_DUNGEON_BATHTUB = 2659
    PINK_DUNGEON_BATHTUB = 2660
    PUMPKIN_BATHTUB = 2661
    OBSIDIAN_BATHTUB = 2662
    GOLDEN_BATHTUB = 2663
    BLUE_DUNGEON_CANDELABRA = 2664
    GREEN_DUNGEON_CANDELABRA = 2665
    PINK_DUNGEON_CANDELABRA = 2666
    OBSIDIAN_CANDELABRA = 2667
    PUMPKIN_CANDELABRA = 2668
    PUMPKIN_BED = 2669
    PUMPKIN_BOOKCASE = 2670
    PUMPKIN_PIANO = 2671
    SHARK_STATUE = 2672
    TRUFFLE_WORM = 2673
    APPRENTICE_BAIT = 2674
    JOURNEYMAN_BAIT = 2675
    MASTER_BAIT = 2676
    AMBER_GEMSPARK_WALL = 2677
    AMBER_GEMSPARK_WALL_OFF = 2678
    AMETHYST_GEMSPARK_WALL = 2679
    AMETHYST_GEMSPARK_WALL_OFF = 2680
    DIAMOND_GEMSPARK_WALL = 2681
    DIAMOND_GEMSPARK_WALL_OFF = 2682
    EMERALD_GEMSPARK_WALL = 2683
    EMERALD_GEMSPARK_WALL_OFF = 2684
    RUBY_GEMSPARK_WALL = 2685
    RUBY_GEMSPARK_WALL_OFF = 2686
    SAPPHIRE_GEMSPARK_WALL = 2687
    SAPPHIRE_GEMSPARK_WALL_OFF = 2688
    TOPAZ_GEMSPARK_WALL = 2689
    TOPAZ_GEMSPARK_WALL_OFF = 2690
    TIN_PLATING_WALL = 2691
    TIN_PLATING = 2692
    WATERFALL_BLOCK = 2693
    LAVAFALL_BLOCK = 2694
    CONFETTI_BLOCK = 2695
    CONFETTI_WALL = 2696
    CONFETTI_BLOCK_BLACK = 2697
    CONFETTI_WALL_BLACK = 2698
    WEAPON_RACK = 2699
    FIREWORKS_BOX = 2700
    LIVING_FIRE_BLOCK = 2701
    ALPHABET_STATUE0 = 2702
    ALPHABET_STATUE1 = 2703
    ALPHABET_STATUE2 = 2704
    ALPHABET_STATUE3 = 2705
    ALPHABET_STATUE4 = 2706
    ALPHABET_STATUE5 = 2707
    ALPHABET_STATUE6 = 2708
    ALPHABET_STATUE7 = 2709
    ALPHABET_STATUE8 = 2710
    ALPHABET_STATUE9 = 2711
    ALPHABET_STATUE_A = 2712
    ALPHABET_STATUE_B = 2713
    ALPHABET_STATUE_C = 2714
    ALPHABET_STATUE_D = 2715
    ALPHABET_STATUE_E = 2716
    ALPHABET_STATUE_F = 2717
    ALPHABET_STATUE_G = 2718
    ALPHABET_STATUE_H = 2719
    ALPHABET_STATUE_I = 2720
    ALPHABET_STATUE_J = 2721
    ALPHABET_STATUE_K = 2722
    ALPHABET_STATUE_L = 2723
    ALPHABET_STATUE_M = 2724
    ALPHABET_STATUE_N = 2725
    ALPHABET_STATUE_O = 2726
    ALPHABET_STATUE_P = 2727
    ALPHABET_STATUE_Q = 2728
    ALPHABET_STATUE_R = 2729
    ALPHABET_STATUE_S = 2730
    ALPHABET_STATUE_T = 2731
    ALPHABET_STATUE_U = 2732
    ALPHABET_STATUE_V = 2733
    ALPHABET_STATUE_W = 2734
    ALPHABET_STATUE_X = 2735
    ALPHABET_STATUE_Y = 2736
    ALPHABET_STATUE_Z = 2737
    FIREWORK_FOUNTAIN = 2738
    BOOSTER_TRACK = 2739
    GRASSHOPPER = 2740
    GRASSHOPPER_CAGE = 2741
    MUSIC_BOX_UNDERGROUND_CRIMSON = 2742
    CACTUS_TABLE = 2743
    CACTUS_PLATFORM = 2744
    BOREAL_WOOD_SWORD = 2745
    BOREAL_WOOD_HAMMER = 2746
    BOREAL_WOOD_BOW = 2747
    GLASS_CHEST = 2748
    XENO_STAFF = 2749
    METEOR_STAFF = 2750
    LIVING_CURSED_FIRE_BLOCK = 2751
    LIVING_DEMON_FIRE_BLOCK = 2752
    LIVING_FROST_FIRE_BLOCK = 2753
    LIVING_ICHOR_BLOCK = 2754
    LIVING_ULTRABRIGHT_FIRE_BLOCK = 2755
    GENDER_CHANGE_POTION = 2756
    VORTEX_HELMET = 2757
    VORTEX_BREASTPLATE = 2758
    VORTEX_LEGGINGS = 2759
    NEBULA_HELMET = 2760
    NEBULA_BREASTPLATE = 2761
    NEBULA_LEGGINGS = 2762
    SOLAR_FLARE_HELMET = 2763
    SOLAR_FLARE_BREASTPLATE = 2764
    SOLAR_FLARE_LEGGINGS = 2765
    LUNAR_TABLET_FRAGMENT = 2766
    SOLAR_TABLET = 2767
    DRILL_CONTAINMENT_UNIT = 2768
    COSMIC_CAR_KEY = 2769
    MOTHRON_WINGS = 2770
    BRAIN_SCRAMBLER = 2771
    VORTEX_AXE = 2772
    VORTEX_CHAINSAW = 2773
    VORTEX_DRILL = 2774
    VORTEX_HAMMER = 2775
    VORTEX_PICKAXE = 2776
    NEBULA_AXE = 2777
    NEBULA_CHAINSAW = 2778
    NEBULA_DRILL = 2779
    NEBULA_HAMMER = 2780
    NEBULA_PICKAXE = 2781
    SOLAR_FLARE_AXE = 2782
    SOLAR_FLARE_CHAINSAW = 2783
    SOLAR_FLARE_DRILL = 2784
    SOLAR_FLARE_HAMMER = 2785
    SOLAR_FLARE_PICKAXE = 2786
    HONEYFALL_BLOCK = 2787
    HONEYFALL_WALL = 2788
    CHLOROPHYTE_BRICK_WALL = 2789
    CRIMTANE_BRICK_WALL = 2790
    SHROOMITE_PLATING_WALL = 2791
    CHLOROPHYTE_BRICK = 2792
    CRIMTANE_BRICK = 2793
    SHROOMITE_PLATING = 2794
    LASER_MACHINEGUN = 2795
    ELECTROSPHERE_LAUNCHER = 2796
    XENOPOPPER = 2797
    LASER_DRILL = 2798
    LASER_RULER = 2799
    ANTI_GRAVITY_HOOK = 2800
    MOON_MASK = 2801
    SUN_MASK = 2802
    MARTIAN_COSTUME_MASK = 2803
    MARTIAN_COSTUME_SHIRT = 2804
    MARTIAN_COSTUME_PANTS = 2805
    MARTIAN_UNIFORM_HELMET = 2806
    MARTIAN_UNIFORM_TORSO = 2807
    MARTIAN_UNIFORM_PANTS = 2808
    MARTIAN_ASTRO_CLOCK = 2809
    MARTIAN_BATHTUB = 2810
    MARTIAN_BED = 2811
    MARTIAN_HOVER_CHAIR = 2812
    MARTIAN_CHANDELIER = 2813
    MARTIAN_CHEST = 2814
    MARTIAN_DOOR = 2815
    MARTIAN_DRESSER = 2816
    MARTIAN_HOLOBOOKCASE = 2817
    MARTIAN_HOVER_CANDLE = 2818
    MARTIAN_LAMPPOST = 2819
    MARTIAN_LANTERN = 2820
    MARTIAN_PIANO = 2821
    MARTIAN_PLATFORM = 2822
    MARTIAN_SOFA = 2823
    MARTIAN_TABLE = 2824
    MARTIAN_TABLE_LAMP = 2825
    MARTIAN_WORK_BENCH = 2826
    WOODEN_SINK = 2827
    EBONWOOD_SINK = 2828
    RICH_MAHOGANY_SINK = 2829
    PEARLWOOD_SINK = 2830
    BONE_SINK = 2831
    FLESH_SINK = 2832
    LIVING_WOOD_SINK = 2833
    SKYWARE_SINK = 2834
    SHADEWOOD_SINK = 2835
    LIHZAHRD_SINK = 2836
    BLUE_DUNGEON_SINK = 2837
    GREEN_DUNGEON_SINK = 2838
    PINK_DUNGEON_SINK = 2839
    OBSIDIAN_SINK = 2840
    METAL_SINK = 2841
    GLASS_SINK = 2842
    GOLDEN_SINK = 2843
    HONEY_SINK = 2844
    STEAMPUNK_SINK = 2845
    PUMPKIN_SINK = 2846
    SPOOKY_SINK = 2847
    FROZEN_SINK = 2848
    DYNASTY_SINK = 2849
    PALM_WOOD_SINK = 2850
    MUSHROOM_SINK = 2851
    BOREAL_WOOD_SINK = 2852
    SLIME_SINK = 2853
    CACTUS_SINK = 2854
    MARTIAN_SINK = 2855
    WHITE_LUNATIC_HOOD = 2856
    BLUE_LUNATIC_HOOD = 2857
    WHITE_LUNATIC_ROBE = 2858
    BLUE_LUNATIC_ROBE = 2859
    MARTIAN_CONDUIT_PLATING = 2860
    MARTIAN_CONDUIT_WALL = 2861
    HI_TEK_SUNGLASSES = 2862
    MARTIAN_HAIR_DYE = 2863
    MARTIAN_ARMOR_DYE = 2864
    PAINTING_CASTLE_MARSBERG = 2865
    PAINTING_MARTIA_LISA = 2866
    PAINTING_THE_TRUTH_IS_UP_THERE = 2867
    SMOKE_BLOCK = 2868
    LIVING_FLAME_DYE = 2869
    LIVING_RAINBOW_DYE = 2870
    SHADOW_DYE = 2871
    NEGATIVE_DYE = 2872
    LIVING_OCEAN_DYE = 2873
    BROWN_DYE = 2874
    BROWN_AND_BLACK_DYE = 2875
    BRIGHT_BROWN_DYE = 2876
    BROWN_AND_SILVER_DYE = 2877
    WISP_DYE = 2878
    PIXIE_DYE = 2879
    INFLUX_WAVER = 2880
    PHASIC_WARP_EJECTOR = 2881
    CHARGED_BLASTER_CANNON = 2882
    CHLOROPHYTE_DYE = 2883
    UNICORN_WISP_DYE = 2884
    INFERNAL_WISP_DYE = 2885
    VICIOUS_POWDER = 2886
    VICIOUS_MUSHROOM = 2887
    BEES_KNEES = 2888
    GOLD_BIRD = 2889
    GOLD_BUNNY = 2890
    GOLD_BUTTERFLY = 2891
    GOLD_FROG = 2892
    GOLD_GRASSHOPPER = 2893
    GOLD_MOUSE = 2894
    GOLD_WORM = 2895
    STICKY_DYNAMITE = 2896
    ANGRY_TRAPPER_BANNER = 2897
    ARMORED_VIKING_BANNER = 2898
    BLACK_SLIME_BANNER = 2899
    BLUE_ARMORED_BONES_BANNER = 2900
    BLUE_CULTIST_ARCHER_BANNER = 2901
    BLUE_CULTIST_CASTER_BANNER = 2902
    BLUE_CULTIST_FIGHTER_BANNER = 2903
    BONE_LEE_BANNER = 2904
    CLINGER_BANNER = 2905
    COCHINEAL_BEETLE_BANNER = 2906
    CORRUPT_PENGUIN_BANNER = 2907
    CORRUPT_SLIME_BANNER = 2908
    CORRUPTOR_BANNER = 2909
    CRIMSLIME_BANNER = 2910
    CURSED_SKULL_BANNER = 2911
    CYAN_BEETLE_BANNER = 2912
    DEVOURER_BANNER = 2913
    DIABLOLIST_BANNER = 2914
    DOCTOR_BONES_BANNER = 2915
    DUNGEON_SLIME_BANNER = 2916
    DUNGEON_SPIRIT_BANNER = 2917
    ELF_ARCHER_BANNER = 2918
    ELF_COPTER_BANNER = 2919
    EYEZOR_BANNER = 2920
    FLOCKO_BANNER = 2921
    GHOST_BANNER = 2922
    GIANT_BAT_BANNER = 2923
    GIANT_CURSED_SKULL_BANNER = 2924
    GIANT_FLYING_FOX_BANNER = 2925
    GINGERBREAD_MAN_BANNER = 2926
    GOBLIN_ARCHER_BANNER = 2927
    GREEN_SLIME_BANNER = 2928
    HEADLESS_HORSEMAN_BANNER = 2929
    HELL_ARMORED_BONES_BANNER = 2930
    HELLHOUND_BANNER = 2931
    HOPPIN_JACK_BANNER = 2932
    ICE_BAT_BANNER = 2933
    ICE_GOLEM_BANNER = 2934
    ICE_SLIME_BANNER = 2935
    ICHOR_STICKER_BANNER = 2936
    ILLUMINANT_BAT_BANNER = 2937
    ILLUMINANT_SLIME_BANNER = 2938
    JUNGLE_BAT_BANNER = 2939
    JUNGLE_SLIME_BANNER = 2940
    KRAMPUS_BANNER = 2941
    LAC_BEETLE_BANNER = 2942
    LAVA_BAT_BANNER = 2943
    LAVA_SLIME_BANNER = 2944
    MARTIAN_BRAINSCRAMBLER_BANNER = 2945
    MARTIAN_DRONE_BANNER = 2946
    MARTIAN_ENGINEER_BANNER = 2947
    MARTIAN_GIGAZAPPER_BANNER = 2948
    MARTIAN_GREY_GRUNT_BANNER = 2949
    MARTIAN_OFFICER_BANNER = 2950
    MARTIAN_RAYGUNNER_BANNER = 2951
    MARTIAN_SCUTLIX_GUNNER_BANNER = 2952
    MARTIAN_TESLA_TURRET_BANNER = 2953
    MISTER_STABBY_BANNER = 2954
    MOTHER_SLIME_BANNER = 2955
    NECROMANCER_BANNER = 2956
    NUTCRACKER_BANNER = 2957
    PALADIN_BANNER = 2958
    PENGUIN_BANNER = 2959
    PINKY_BANNER = 2960
    POLTERGEIST_BANNER = 2961
    POSSESSED_ARMOR_BANNER = 2962
    PRESENT_MIMIC_BANNER = 2963
    PURPLE_SLIME_BANNER = 2964
    RAGGED_CASTER_BANNER = 2965
    RAINBOW_SLIME_BANNER = 2966
    RAVEN_BANNER = 2967
    RED_SLIME_BANNER = 2968
    RUNE_WIZARD_BANNER = 2969
    RUSTY_ARMORED_BONES_BANNER = 2970
    SCARECROW_BANNER = 2971
    SCUTLIX_BANNER = 2972
    SKELETON_ARCHER_BANNER = 2973
    SKELETON_COMMANDO_BANNER = 2974
    SKELETON_SNIPER_BANNER = 2975
    SLIMER_BANNER = 2976
    SNATCHER_BANNER = 2977
    SNOW_BALLA_BANNER = 2978
    SNOWMAN_GANGSTA_BANNER = 2979
    SPIKED_ICE_SLIME_BANNER = 2980
    SPIKED_JUNGLE_SLIME_BANNER = 2981
    SPLINTERLING_BANNER = 2982
    SQUID_BANNER = 2983
    TACTICAL_SKELETON_BANNER = 2984
    THE_GROOM_BANNER = 2985
    TIM_BANNER = 2986
    UNDEAD_MINER_BANNER = 2987
    UNDEAD_VIKING_BANNER = 2988
    WHITE_CULTIST_ARCHER_BANNER = 2989
    WHITE_CULTIST_CASTER_BANNER = 2990
    WHITE_CULTIST_FIGHTER_BANNER = 2991
    YELLOW_SLIME_BANNER = 2992
    YETI_BANNER = 2993
    ZOMBIE_ELF_BANNER = 2994
    SPARKY_PAINTING = 2995
    VINE_ROPE = 2996
    WORMHOLE_POTION = 2997
    SUMMONER_EMBLEM = 2998
    BEWITCHING_TABLE = 2999
    ALCHEMY_TABLE = 3000
    STRANGE_BREW = 3001
    SPELUNKER_GLOWSTICK = 3002
    BONE_ARROW = 3003
    BONE_TORCH = 3004
    VINE_ROPE_COIL = 3005
    SOUL_DRAIN = 3006
    DART_PISTOL = 3007
    DART_RIFLE = 3008
    CRYSTAL_DART = 3009
    CURSED_DART = 3010
    ICHOR_DART = 3011
    CHAIN_GUILLOTINES = 3012
    FETID_BAGHNAKHS = 3013
    CLINGER_STAFF = 3014
    PUTRID_SCENT = 3015
    FLESH_KNUCKLES = 3016
    FLOWER_BOOTS = 3017
    SEEDLER = 3018
    HELLWING_BOW = 3019
    TENDON_HOOK = 3020
    THORN_HOOK = 3021
    ILLUMINANT_HOOK = 3022
    WORM_HOOK = 3023
    DEV_DYE = 3024
    PURPLE_OOZE_DYE = 3025
    REFLECTIVE_SILVER_DYE = 3026
    REFLECTIVE_GOLD_DYE = 3027
    BLUE_ACID_DYE = 3028
    DAEDALUS_STORMBOW = 3029
    FLYING_KNIFE = 3030
    BOTTOMLESS_BUCKET = 3031
    SUPER_ABSORBANT_SPONGE = 3032
    GOLD_RING = 3033
    COIN_RING = 3034
    GREEDY_RING = 3035
    FISH_FINDER = 3036
    WEATHER_RADIO = 3037
    HADES_DYE = 3038
    TWILIGHT_DYE = 3039
    ACID_DYE = 3040
    MUSHROOM_DYE = 3041
    PHASE_DYE = 3042
    MAGIC_LANTERN = 3043
    MUSIC_BOX_LUNAR_BOSS = 3044
    RAINBOW_TORCH = 3045
    CURSED_CAMPFIRE = 3046
    DEMON_CAMPFIRE = 3047
    FROZEN_CAMPFIRE = 3048
    ICHOR_CAMPFIRE = 3049
    RAINBOW_CAMPFIRE = 3050
    CRYSTAL_VILE_SHARD = 3051
    SHADOW_FLAME_BOW = 3052
    SHADOW_FLAME_HEX_DOLL = 3053
    SHADOW_FLAME_KNIFE = 3054
    PAINTING_ACORNS = 3055
    PAINTING_COLD_SNAP = 3056
    PAINTING_CURSED_SAINT = 3057
    PAINTING_SNOWFELLAS = 3058
    PAINTING_THE_SEASON = 3059
    BONE_RATTLE = 3060
    ARCHITECT_GIZMO_PACK = 3061
    CRIMSON_HEART = 3062
    MEOWMERE = 3063
    SUNDIAL = 3064
    STAR_WRATH = 3065
    MARBLE_BLOCK = 3066
    HELLSTONE_BRICK_WALL = 3067
    CORDAGE_GUIDE = 3068
    WANDOF_SPARKING = 3069
    GOLD_BIRD_CAGE = 3070
    GOLD_BUNNY_CAGE = 3071
    GOLD_BUTTERFLY_CAGE = 3072
    GOLD_FROG_CAGE = 3073
    GOLD_GRASSHOPPER_CAGE = 3074
    GOLD_MOUSE_CAGE = 3075
    GOLD_WORM_CAGE = 3076
    SILK_ROPE = 3077
    WEB_ROPE = 3078
    SILK_ROPE_COIL = 3079
    WEB_ROPE_COIL = 3080
    MARBLE = 3081
    MARBLE_WALL = 3082
    MARBLE_BLOCK_WALL = 3083
    RADAR = 3084
    LOCK_BOX = 3085
    GRANITE = 3086
    GRANITE_BLOCK = 3087
    GRANITE_WALL = 3088
    GRANITE_BLOCK_WALL = 3089
    ROYAL_GEL = 3090
    NIGHT_KEY = 3091
    LIGHT_KEY = 3092
    HERB_BAG = 3093
    JAVELIN = 3094
    TALLY_COUNTER = 3095
    SEXTANT = 3096
    EO_CSHIELD = 3097
    BUTCHERS_CHAINSAW = 3098
    STOPWATCH = 3099
    METEORITE_BRICK = 3100
    METEORITE_BRICK_WALL = 3101
    METAL_DETECTOR = 3102
    ENDLESS_QUIVER = 3103
    ENDLESS_MUSKET_POUCH = 3104
    TOXIC_FLASK = 3105
    PSYCHO_KNIFE = 3106
    NAIL_GUN = 3107
    NAIL = 3108
    NIGHT_VISION_HELMET = 3109
    CELESTIAL_SHELL = 3110
    PINK_GEL = 3111
    BOUNCY_GLOWSTICK = 3112
    PINK_SLIME_BLOCK = 3113
    PINK_TORCH = 3114
    BOUNCY_BOMB = 3115
    BOUNCY_GRENADE = 3116
    PEACE_CANDLE = 3117
    LIFEFORM_ANALYZER = 3118
    DPSMETER = 3119
    FISHERMANS_GUIDE = 3120
    GOBLIN_TECH = 3121
    REK = 3122
    PDA = 3123
    CELL_PHONE = 3124
    GRANITE_CHEST = 3125
    METEORITE_CLOCK = 3126
    MARBLE_CLOCK = 3127
    GRANITE_CLOCK = 3128
    METEORITE_DOOR = 3129
    MARBLE_DOOR = 3130
    GRANITE_DOOR = 3131
    METEORITE_DRESSER = 3132
    MARBLE_DRESSER = 3133
    GRANITE_DRESSER = 3134
    METEORITE_LAMP = 3135
    MARBLE_LAMP = 3136
    GRANITE_LAMP = 3137
    METEORITE_LANTERN = 3138
    MARBLE_LANTERN = 3139
    GRANITE_LANTERN = 3140
    METEORITE_PIANO = 3141
    MARBLE_PIANO = 3142
    GRANITE_PIANO = 3143
    METEORITE_PLATFORM = 3144
    MARBLE_PLATFORM = 3145
    GRANITE_PLATFORM = 3146
    METEORITE_SINK = 3147
    MARBLE_SINK = 3148
    GRANITE_SINK = 3149
    METEORITE_SOFA = 3150
    MARBLE_SOFA = 3151
    GRANITE_SOFA = 3152
    METEORITE_TABLE = 3153
    MARBLE_TABLE = 3154
    GRANITE_TABLE = 3155
    METEORITE_WORK_BENCH = 3156
    MARBLE_WORK_BENCH = 3157
    GRANITE_WORK_BENCH = 3158
    METEORITE_BATHTUB = 3159
    MARBLE_BATHTUB = 3160
    GRANITE_BATHTUB = 3161
    METEORITE_BED = 3162
    MARBLE_BED = 3163
    GRANITE_BED = 3164
    METEORITE_BOOKCASE = 3165
    MARBLE_BOOKCASE = 3166
    GRANITE_BOOKCASE = 3167
    METEORITE_CANDELABRA = 3168
    MARBLE_CANDELABRA = 3169
    GRANITE_CANDELABRA = 3170
    METEORITE_CANDLE = 3171
    MARBLE_CANDLE = 3172
    GRANITE_CANDLE = 3173
    METEORITE_CHAIR = 3174
    MARBLE_CHAIR = 3175
    GRANITE_CHAIR = 3176
    METEORITE_CHANDELIER = 3177
    MARBLE_CHANDELIER = 3178
    GRANITE_CHANDELIER = 3179
    METEORITE_CHEST = 3180
    MARBLE_CHEST = 3181
    MAGIC_WATER_DROPPER = 3182
    GOLDEN_BUG_NET = 3183
    MAGIC_LAVA_DROPPER = 3184
    MAGIC_HONEY_DROPPER = 3185
    EMPTY_DROPPER = 3186
    GLADIATOR_HELMET = 3187
    GLADIATOR_BREASTPLATE = 3188
    GLADIATOR_LEGGINGS = 3189
    REFLECTIVE_DYE = 3190
    ENCHANTED_NIGHTCRAWLER = 3191
    GRUBBY = 3192
    SLUGGY = 3193
    BUGGY = 3194
    GRUB_SOUP = 3195
    BOMB_FISH = 3196
    FROST_DAGGERFISH = 3197
    SHARPENING_STATION = 3198
    ICE_MIRROR = 3199
    SAILFISH_BOOTS = 3200
    TSUNAMI_IN_ABOTTLE = 3201
    TARGET_DUMMY = 3202
    CORRUPT_FISHING_CRATE = 3203
    CRIMSON_FISHING_CRATE = 3204
    DUNGEON_FISHING_CRATE = 3205
    FLOATING_ISLAND_FISHING_CRATE = 3206
    HALLOWED_FISHING_CRATE = 3207
    JUNGLE_FISHING_CRATE = 3208
    CRYSTAL_SERPENT = 3209
    TOXIKARP = 3210
    BLADETONGUE = 3211
    SHARK_TOOTH_NECKLACE = 3212
    MONEY_TROUGH = 3213
    BUBBLE = 3214
    DAY_BLOOM_PLANTER_BOX = 3215
    MOONGLOW_PLANTER_BOX = 3216
    CORRUPT_PLANTER_BOX = 3217
    CRIMSON_PLANTER_BOX = 3218
    BLINKROOT_PLANTER_BOX = 3219
    WATERLEAF_PLANTER_BOX = 3220
    SHIVERTHORN_PLANTER_BOX = 3221
    FIRE_BLOSSOM_PLANTER_BOX = 3222
    BRAIN_OF_CONFUSION = 3223
    WORM_SCARF = 3224
    BALLOON_PUFFERFISH = 3225
    BEJEWELED_VALKYRIE_HEAD = 3226
    BEJEWELED_VALKYRIE_BODY = 3227
    BEJEWELED_VALKYRIE_WING = 3228
    RICH_GRAVESTONE1 = 3229
    RICH_GRAVESTONE2 = 3230
    RICH_GRAVESTONE3 = 3231
    RICH_GRAVESTONE4 = 3232
    RICH_GRAVESTONE5 = 3233
    CRYSTAL_BLOCK = 3234
    MUSIC_BOX_MARTIANS = 3235
    MUSIC_BOX_PIRATES = 3236
    MUSIC_BOX_HELL = 3237
    CRYSTAL_BLOCK_WALL = 3238
    TRAPDOOR = 3239
    TALL_GATE = 3240
    SHARKRON_BALLOON = 3241
    TAX_COLLECTOR_HAT = 3242
    TAX_COLLECTOR_SUIT = 3243
    TAX_COLLECTOR_PANTS = 3244
    BONE_GLOVE = 3245
    CLOTHIER_JACKET = 3246
    CLOTHIER_PANTS = 3247
    DYE_TRADER_TURBAN = 3248
    DEADLY_SPHERE_STAFF = 3249
    BALLOON_HORSESHOE_FART = 3250
    BALLOON_HORSESHOE_HONEY = 3251
    BALLOON_HORSESHOE_SHARKRON = 3252
    LAVA_LAMP = 3253
    CAGE_ENCHANTED_NIGHTCRAWLER = 3254
    CAGE_BUGGY = 3255
    CAGE_GRUBBY = 3256
    CAGE_SLUGGY = 3257
    SLAP_HAND = 3258
    TWILIGHT_HAIR_DYE = 3259
    BLESSED_APPLE = 3260
    SPECTRE_BAR = 3261
    CODE1 = 3262
    BUCCANEER_BANDANA = 3263
    BUCCANEER_SHIRT = 3264
    BUCCANEER_PANTS = 3265
    OBSIDIAN_HELM = 3266
    OBSIDIAN_SHIRT = 3267
    OBSIDIAN_PANTS = 3268
    MEDUSA_HEAD = 3269
    ITEM_FRAME = 3270
    SANDSTONE = 3271
    HARDENED_SAND = 3272
    SANDSTONE_WALL = 3273
    CORRUPT_HARDENED_SAND = 3274
    CRIMSON_HARDENED_SAND = 3275
    CORRUPT_SANDSTONE = 3276
    CRIMSON_SANDSTONE = 3277
    WOOD_YOYO = 3278
    CORRUPT_YOYO = 3279
    CRIMSON_YOYO = 3280
    JUNGLE_YOYO = 3281
    CASCADE = 3282
    CHIK = 3283
    CODE2 = 3284
    RALLY = 3285
    YELETS = 3286
    REDS_YOYO = 3287
    VALKYRIE_YOYO = 3288
    AMAROK = 3289
    HEL_FIRE = 3290
    KRAKEN = 3291
    THE_EYE_OF_CTHULHU = 3292
    RED_STRING = 3293
    ORANGE_STRING = 3294
    YELLOW_STRING = 3295
    LIME_STRING = 3296
    GREEN_STRING = 3297
    TEAL_STRING = 3298
    CYAN_STRING = 3299
    SKY_BLUE_STRING = 3300
    BLUE_STRING = 3301
    PURPLE_STRING = 3302
    VIOLET_STRING = 3303
    PINK_STRING = 3304
    BROWN_STRING = 3305
    WHITE_STRING = 3306
    RAINBOW_STRING = 3307
    BLACK_STRING = 3308
    BLACK_COUNTERWEIGHT = 3309
    BLUE_COUNTERWEIGHT = 3310
    GREEN_COUNTERWEIGHT = 3311
    PURPLE_COUNTERWEIGHT = 3312
    RED_COUNTERWEIGHT = 3313
    YELLOW_COUNTERWEIGHT = 3314
    FORMAT_C = 3315
    GRADIENT = 3316
    VALOR = 3317
    KING_SLIME_BOSS_BAG = 3318
    EYE_OF_CTHULHU_BOSS_BAG = 3319
    EATER_OF_WORLDS_BOSS_BAG = 3320
    BRAIN_OF_CTHULHU_BOSS_BAG = 3321
    QUEEN_BEE_BOSS_BAG = 3322
    SKELETRON_BOSS_BAG = 3323
    WALL_OF_FLESH_BOSS_BAG = 3324
    DESTROYER_BOSS_BAG = 3325
    TWINS_BOSS_BAG = 3326
    SKELETRON_PRIME_BOSS_BAG = 3327
    PLANTERA_BOSS_BAG = 3328
    GOLEM_BOSS_BAG = 3329
    FISHRON_BOSS_BAG = 3330
    CULTIST_BOSS_BAG = 3331
    MOON_LORD_BOSS_BAG = 3332
    HIVE_BACKPACK = 3333
    YO_YO_GLOVE = 3334
    DEMON_HEART = 3335
    SPORE_SAC = 3336
    SHINY_STONE = 3337
    HALLOW_HARDENED_SAND = 3338
    HALLOW_SANDSTONE = 3339
    HARDENED_SAND_WALL = 3340
    CORRUPT_HARDENED_SAND_WALL = 3341
    CRIMSON_HARDENED_SAND_WALL = 3342
    HALLOW_HARDENED_SAND_WALL = 3343
    CORRUPT_SANDSTONE_WALL = 3344
    CRIMSON_SANDSTONE_WALL = 3345
    HALLOW_SANDSTONE_WALL = 3346
    DESERT_FOSSIL = 3347
    DESERT_FOSSIL_WALL = 3348
    DYE_TRADERS_SCIMITAR = 3349
    PAINTER_PAINTBALL_GUN = 3350
    TAX_COLLECTORS_STICK_OF_DOOM = 3351
    STYLIST_KIL_LA_KILL_SCISSORS_IWISH = 3352
    MINECART_MECH = 3353
    MECHANICAL_WHEEL_PIECE = 3354
    MECHANICAL_WAGON_PIECE = 3355
    MECHANICAL_BATTERY_PIECE = 3356
    ANCIENT_CULTIST_TROPHY = 3357
    MARTIAN_SAUCER_TROPHY = 3358
    FLYING_DUTCHMAN_TROPHY = 3359
    LIVING_MAHOGANY_WAND = 3360
    LIVING_MAHOGANY_LEAF_WAND = 3361
    FALLEN_TUXEDO_SHIRT = 3362
    FALLEN_TUXEDO_PANTS = 3363
    FIREPLACE = 3364
    CHIMNEY = 3365
    YOYO_BAG = 3366
    SHRIMPY_TRUFFLE = 3367
    ARKHALIS = 3368
    CONFETTI_CANNON = 3369
    MUSIC_BOX_TOWERS = 3370
    MUSIC_BOX_GOBLINS = 3371
    BOSS_MASK_CULTIST = 3372
    BOSS_MASK_MOONLORD = 3373
    FOSSIL_HELM = 3374
    FOSSIL_SHIRT = 3375
    FOSSIL_PANTS = 3376
    AMBER_STAFF = 3377
    BONE_JAVELIN = 3378
    BONE_DAGGER = 3379
    FOSSIL_ORE = 3380
    STARDUST_HELMET = 3381
    STARDUST_BREASTPLATE = 3382
    STARDUST_LEGGINGS = 3383
    PORTAL_GUN = 3384
    STRANGE_PLANT1 = 3385
    STRANGE_PLANT2 = 3386
    STRANGE_PLANT3 = 3387
    STRANGE_PLANT4 = 3388
    TERRARIAN = 3389
    GOBLIN_SUMMONER_BANNER = 3390
    SALAMANDER_BANNER = 3391
    GIANT_SHELLY_BANNER = 3392
    CRAWDAD_BANNER = 3393
    FRITZ_BANNER = 3394
    CREATURE_FROM_THE_DEEP_BANNER = 3395
    DR_MAN_FLY_BANNER = 3396
    MOTHRON_BANNER = 3397
    SEVERED_HAND_BANNER = 3398
    THE_POSSESSED_BANNER = 3399
    BUTCHER_BANNER = 3400
    PSYCHO_BANNER = 3401
    DEADLY_SPHERE_BANNER = 3402
    NAILHEAD_BANNER = 3403
    POISONOUS_SPORE_BANNER = 3404
    MEDUSA_BANNER = 3405
    GREEK_SKELETON_BANNER = 3406
    GRANITE_FLYER_BANNER = 3407
    GRANITE_GOLEM_BANNER = 3408
    BLOOD_ZOMBIE_BANNER = 3409
    DRIPPLER_BANNER = 3410
    TOMB_CRAWLER_BANNER = 3411
    DUNE_SPLICER_BANNER = 3412
    FLYING_ANTLION_BANNER = 3413
    WALKING_ANTLION_BANNER = 3414
    DESERT_GHOUL_BANNER = 3415
    DESERT_LAMIA_BANNER = 3416
    DESERT_DJINN_BANNER = 3417
    DESERT_BASILISK_BANNER = 3418
    RAVAGER_SCORPION_BANNER = 3419
    STARDUST_SOLDIER_BANNER = 3420
    STARDUST_WORM_BANNER = 3421
    STARDUST_JELLYFISH_BANNER = 3422
    STARDUST_SPIDER_BANNER = 3423
    STARDUST_SMALL_CELL_BANNER = 3424
    STARDUST_LARGE_CELL_BANNER = 3425
    SOLAR_CORITE_BANNER = 3426
    SOLAR_SROLLER_BANNER = 3427
    SOLAR_CRAWLTIPEDE_BANNER = 3428
    SOLAR_DRAKOMIRE_RIDER_BANNER = 3429
    SOLAR_DRAKOMIRE_BANNER = 3430
    SOLAR_SOLENIAN_BANNER = 3431
    NEBULA_SOLDIER_BANNER = 3432
    NEBULA_HEADCRAB_BANNER = 3433
    NEBULA_BRAIN_BANNER = 3434
    NEBULA_BEAST_BANNER = 3435
    VORTEX_LARVA_BANNER = 3436
    VORTEX_HORNET_QUEEN_BANNER = 3437
    VORTEX_HORNET_BANNER = 3438
    VORTEX_SOLDIER_BANNER = 3439
    VORTEX_RIFLEMAN_BANNER = 3440
    PIRATE_CAPTAIN_BANNER = 3441
    PIRATE_DEADEYE_BANNER = 3442
    PIRATE_CORSAIR_BANNER = 3443
    PIRATE_CROSSBOWER_BANNER = 3444
    MARTIAN_WALKER_BANNER = 3445
    RED_DEVIL_BANNER = 3446
    PINK_JELLYFISH_BANNER = 3447
    GREEN_JELLYFISH_BANNER = 3448
    DARK_MUMMY_BANNER = 3449
    LIGHT_MUMMY_BANNER = 3450
    ANGRY_BONES_BANNER = 3451
    ICE_TORTOISE_BANNER = 3452
    NEBULA_PICKUP1 = 3453
    NEBULA_PICKUP2 = 3454
    NEBULA_PICKUP3 = 3455
    FRAGMENT_VORTEX = 3456
    FRAGMENT_NEBULA = 3457
    FRAGMENT_SOLAR = 3458
    FRAGMENT_STARDUST = 3459
    LUNAR_ORE = 3460
    LUNAR_BRICK = 3461
    STARDUST_AXE = 3462
    STARDUST_CHAINSAW = 3463
    STARDUST_DRILL = 3464
    STARDUST_HAMMER = 3465
    STARDUST_PICKAXE = 3466
    LUNAR_BAR = 3467
    WINGS_SOLAR = 3468
    WINGS_VORTEX = 3469
    WINGS_NEBULA = 3470
    WINGS_STARDUST = 3471
    LUNAR_BRICK_WALL = 3472
    SOLAR_ERUPTION = 3473
    STARDUST_CELL_STAFF = 3474
    VORTEX_BEATER = 3475
    NEBULA_ARCANUM = 3476
    BLOOD_WATER = 3477
    THE_BRIDE_HAT = 3478
    THE_BRIDE_DRESS = 3479
    PLATINUM_BOW = 3480
    PLATINUM_HAMMER = 3481
    PLATINUM_AXE = 3482
    PLATINUM_SHORTSWORD = 3483
    PLATINUM_BROADSWORD = 3484
    PLATINUM_PICKAXE = 3485
    TUNGSTEN_BOW = 3486
    TUNGSTEN_HAMMER = 3487
    TUNGSTEN_AXE = 3488
    TUNGSTEN_SHORTSWORD = 3489
    TUNGSTEN_BROADSWORD = 3490
    TUNGSTEN_PICKAXE = 3491
    LEAD_BOW = 3492
    LEAD_HAMMER = 3493
    LEAD_AXE = 3494
    LEAD_SHORTSWORD = 3495
    LEAD_BROADSWORD = 3496
    LEAD_PICKAXE = 3497
    TIN_BOW = 3498
    TIN_HAMMER = 3499
    TIN_AXE = 3500
    TIN_SHORTSWORD = 3501
    TIN_BROADSWORD = 3502
    TIN_PICKAXE = 3503
    COPPER_BOW = 3504
    COPPER_HAMMER = 3505
    COPPER_AXE = 3506
    COPPER_SHORTSWORD = 3507
    COPPER_BROADSWORD = 3508
    COPPER_PICKAXE = 3509
    SILVER_BOW = 3510
    SILVER_HAMMER = 3511
    SILVER_AXE = 3512
    SILVER_SHORTSWORD = 3513
    SILVER_BROADSWORD = 3514
    SILVER_PICKAXE = 3515
    GOLD_BOW = 3516
    GOLD_HAMMER = 3517
    GOLD_AXE = 3518
    GOLD_SHORTSWORD = 3519
    GOLD_BROADSWORD = 3520
    GOLD_PICKAXE = 3521
    LUNAR_HAMAXE_SOLAR = 3522
    LUNAR_HAMAXE_VORTEX = 3523
    LUNAR_HAMAXE_NEBULA = 3524
    LUNAR_HAMAXE_STARDUST = 3525
    SOLAR_DYE = 3526
    NEBULA_DYE = 3527
    VORTEX_DYE = 3528
    STARDUST_DYE = 3529
    VOID_DYE = 3530
    STARDUST_DRAGON_STAFF = 3531
    BACON = 3532
    SHIFTING_SANDS_DYE = 3533
    MIRAGE_DYE = 3534
    SHIFTING_PEARL_SANDS_DYE = 3535
    VORTEX_MONOLITH = 3536
    NEBULA_MONOLITH = 3537
    STARDUST_MONOLITH = 3538
    SOLAR_MONOLITH = 3539
    PHANTASM = 3540
    LAST_PRISM = 3541
    NEBULA_BLAZE = 3542
    DAY_BREAK = 3543
    SUPER_HEALING_POTION = 3544
    DETONATOR = 3545
    FIREWORKS_LAUNCHER = 3546
    BOUNCY_DYNAMITE = 3547
    PARTY_GIRL_GRENADE = 3548
    LUNAR_CRAFTING_STATION = 3549
    FLAME_AND_SILVER_DYE = 3550
    GREEN_FLAME_AND_SILVER_DYE = 3551
    BLUE_FLAME_AND_SILVER_DYE = 3552
    REFLECTIVE_COPPER_DYE = 3553
    REFLECTIVE_OBSIDIAN_DYE = 3554
    REFLECTIVE_METAL_DYE = 3555
    MIDNIGHT_RAINBOW_DYE = 3556
    BLACK_AND_WHITE_DYE = 3557
    BRIGHT_SILVER_DYE = 3558
    SILVER_AND_BLACK_DYE = 3559
    RED_ACID_DYE = 3560
    GEL_DYE = 3561
    PINK_GEL_DYE = 3562
    SQUIRREL_RED = 3563
    SQUIRREL_GOLD = 3564
    SQUIRREL_ORANGE_CAGE = 3565
    SQUIRREL_GOLD_CAGE = 3566
    MOONLORD_BULLET = 3567
    MOONLORD_ARROW = 3568
    MOONLORD_TURRET_STAFF = 3569
    LUNAR_FLARE_BOOK = 3570
    RAINBOW_CRYSTAL_STAFF = 3571
    LUNAR_HOOK = 3572
    LUNAR_BLOCK_SOLAR = 3573
    LUNAR_BLOCK_VORTEX = 3574
    LUNAR_BLOCK_NEBULA = 3575
    LUNAR_BLOCK_STARDUST = 3576
    SUSPICIOUS_LOOKING_TENTACLE = 3577
    YORAIZ0R_SHIRT = 3578
    YORAIZ0R_PANTS = 3579
    YORAIZ0R_WINGS = 3580
    YORAIZ0R_DARKNESS = 3581
    JIMS_WINGS = 3582
    YORAIZ0R_HEAD = 3583
    LIVING_LEAF_WALL = 3584
    SKIPHS_HELM = 3585
    SKIPHS_SHIRT = 3586
    SKIPHS_PANTS = 3587
    SKIPHS_WINGS = 3588
    LOKIS_HELM = 3589
    LOKIS_SHIRT = 3590
    LOKIS_PANTS = 3591
    LOKIS_WINGS = 3592
    SAND_SLIME_BANNER = 3593
    SEA_SNAIL_BANNER = 3594
    MOON_LORD_TROPHY = 3595
    MOON_LORD_PAINTING = 3596
    BURNING_HADES_DYE = 3597
    GRIM_DYE = 3598
    LOKIS_DYE = 3599
    SHADOWFLAME_HADES_DYE = 3600
    CELESTIAL_SIGIL = 3601
    LOGIC_GATE_LAMP_OFF = 3602
    LOGIC_GATE_AND = 3603
    LOGIC_GATE_OR = 3604
    LOGIC_GATE_NAND = 3605
    LOGIC_GATE_NOR = 3606
    LOGIC_GATE_XOR = 3607
    LOGIC_GATE_NXOR = 3608
    CONVEYOR_BELT_LEFT = 3609
    CONVEYOR_BELT_RIGHT = 3610
    WIRE_KITE = 3611
    YELLOW_WRENCH = 3612
    LOGIC_SENSOR_SUN = 3613
    LOGIC_SENSOR_MOON = 3614
    LOGIC_SENSOR_ABOVE = 3615
    WIRE_PIPE = 3616
    ANNOUNCEMENT_BOX = 3617
    LOGIC_GATE_LAMP_ON = 3618
    MECHANICAL_LENS = 3619
    ACTUATION_ROD = 3620
    TEAM_BLOCK_RED = 3621
    TEAM_BLOCK_RED_PLATFORM = 3622
    STATIC_HOOK = 3623
    ACTUATION_ACCESSORY = 3624
    MULTICOLOR_WRENCH = 3625
    WEIGHTED_PRESSURE_PLATE_PINK = 3626
    ENGINEERING_HELMET = 3627
    COMPANION_CUBE = 3628
    WIRE_BULB = 3629
    WEIGHTED_PRESSURE_PLATE_ORANGE = 3630
    WEIGHTED_PRESSURE_PLATE_PURPLE = 3631
    WEIGHTED_PRESSURE_PLATE_CYAN = 3632
    TEAM_BLOCK_GREEN = 3633
    TEAM_BLOCK_BLUE = 3634
    TEAM_BLOCK_YELLOW = 3635
    TEAM_BLOCK_PINK = 3636
    TEAM_BLOCK_WHITE = 3637
    TEAM_BLOCK_GREEN_PLATFORM = 3638
    TEAM_BLOCK_BLUE_PLATFORM = 3639
    TEAM_BLOCK_YELLOW_PLATFORM = 3640
    TEAM_BLOCK_PINK_PLATFORM = 3641
    TEAM_BLOCK_WHITE_PLATFORM = 3642
    LARGE_AMBER = 3643
    GEM_LOCK_RUBY = 3644
    GEM_LOCK_SAPPHIRE = 3645
    GEM_LOCK_EMERALD = 3646
    GEM_LOCK_TOPAZ = 3647
    GEM_LOCK_AMETHYST = 3648
    GEM_LOCK_DIAMOND = 3649
    GEM_LOCK_AMBER = 3650
    SQUIRREL_STATUE = 3651
    BUTTERFLY_STATUE = 3652
    WORM_STATUE = 3653
    FIREFLY_STATUE = 3654
    SCORPION_STATUE = 3655
    SNAIL_STATUE = 3656
    GRASSHOPPER_STATUE = 3657
    MOUSE_STATUE = 3658
    DUCK_STATUE = 3659
    PENGUIN_STATUE = 3660
    FROG_STATUE = 3661
    BUGGY_STATUE = 3662
    LOGIC_GATE_LAMP_FAULTY = 3663
    PORTAL_GUN_STATION = 3664
    FAKE_CHEST = 3665
    FAKE_GOLD_CHEST = 3666
    FAKE_SHADOW_CHEST = 3667
    FAKE_EBONWOOD_CHEST = 3668
    FAKE_RICH_MAHOGANY_CHEST = 3669
    FAKE_PEARLWOOD_CHEST = 3670
    FAKE_IVY_CHEST = 3671
    FAKE_ICE_CHEST = 3672
    FAKE_LIVING_WOOD_CHEST = 3673
    FAKE_SKYWARE_CHEST = 3674
    FAKE_SHADEWOOD_CHEST = 3675
    FAKE_WEB_COVERED_CHEST = 3676
    FAKE_LIHZAHRD_CHEST = 3677
    FAKE_WATER_CHEST = 3678
    FAKE_JUNGLE_CHEST = 3679
    FAKE_CORRUPTION_CHEST = 3680
    FAKE_CRIMSON_CHEST = 3681
    FAKE_HALLOWED_CHEST = 3682
    FAKE_FROZEN_CHEST = 3683
    FAKE_DYNASTY_CHEST = 3684
    FAKE_HONEY_CHEST = 3685
    FAKE_STEAMPUNK_CHEST = 3686
    FAKE_PALM_WOOD_CHEST = 3687
    FAKE_MUSHROOM_CHEST = 3688
    FAKE_BOREAL_WOOD_CHEST = 3689
    FAKE_SLIME_CHEST = 3690
    FAKE_GREEN_DUNGEON_CHEST = 3691
    FAKE_PINK_DUNGEON_CHEST = 3692
    FAKE_BLUE_DUNGEON_CHEST = 3693
    FAKE_BONE_CHEST = 3694
    FAKE_CACTUS_CHEST = 3695
    FAKE_FLESH_CHEST = 3696
    FAKE_OBSIDIAN_CHEST = 3697
    FAKE_PUMPKIN_CHEST = 3698
    FAKE_SPOOKY_CHEST = 3699
    FAKE_GLASS_CHEST = 3700
    FAKE_MARTIAN_CHEST = 3701
    FAKE_METEORITE_CHEST = 3702
    FAKE_GRANITE_CHEST = 3703
    FAKE_MARBLE_CHEST = 3704
    FAKE_NEWCHEST1 = 3705
    FAKE_NEWCHEST2 = 3706
    PROJECTILE_PRESSURE_PAD = 3707
    WALL_CREEPER_STATUE = 3708
    UNICORN_STATUE = 3709
    DRIPPLER_STATUE = 3710
    WRAITH_STATUE = 3711
    BONE_SKELETON_STATUE = 3712
    UNDEAD_VIKING_STATUE = 3713
    MEDUSA_STATUE = 3714
    HARPY_STATUE = 3715
    PIGRON_STATUE = 3716
    HOPLITE_STATUE = 3717
    GRANITE_GOLEM_STATUE = 3718
    ZOMBIE_ARM_STATUE = 3719
    BLOOD_ZOMBIE_STATUE = 3720
    ANGLER_TACKLE_BAG = 3721
    GEYSER_TRAP = 3722
    ULTRA_BRIGHT_CAMPFIRE = 3723
    BONE_CAMPFIRE = 3724
    PIXEL_BOX = 3725
    LOGIC_SENSOR_WATER = 3726
    LOGIC_SENSOR_LAVA = 3727
    LOGIC_SENSOR_HONEY = 3728
    LOGIC_SENSOR_LIQUID = 3729
    PARTY_BUNDLE_OF_BALLOONS_ACCESSORY = 3730
    PARTY_BALLOON_ANIMAL = 3731
    PARTY_HAT = 3732
    FLOWER_BOY_HAT = 3733
    FLOWER_BOY_SHIRT = 3734
    FLOWER_BOY_PANTS = 3735
    SILLY_BALLOON_PINK = 3736
    SILLY_BALLOON_PURPLE = 3737
    SILLY_BALLOON_GREEN = 3738
    SILLY_STREAMER_BLUE = 3739
    SILLY_STREAMER_GREEN = 3740
    SILLY_STREAMER_PINK = 3741
    SILLY_BALLOON_MACHINE = 3742
    SILLY_BALLOON_TIED_PINK = 3743
    SILLY_BALLOON_TIED_PURPLE = 3744
    SILLY_BALLOON_TIED_GREEN = 3745
    PIGRONATA = 3746
    PARTY_MONOLITH = 3747
    PARTY_BUNDLE_OF_BALLOON_TILE = 3748
    PARTY_PRESENT = 3749
    SLICE_OF_CAKE = 3750
    COG_WALL = 3751
    SAND_FALL_WALL = 3752
    SNOW_FALL_WALL = 3753
    SAND_FALL_BLOCK = 3754
    SNOW_FALL_BLOCK = 3755
    SNOW_CLOUD_BLOCK = 3756
    PEDGUIN_HAT = 3757
    PEDGUIN_SHIRT = 3758
    PEDGUIN_PANTS = 3759
    SILLY_BALLOON_PINK_WALL = 3760
    SILLY_BALLOON_PURPLE_WALL = 3761
    SILLY_BALLOON_GREEN_WALL = 3762
    AVIATOR_SUNGLASSES = 3763
    BLUE_PHASESABER = 3764
    RED_PHASESABER = 3765
    GREEN_PHASESABER = 3766
    PURPLE_PHASESABER = 3767
    WHITE_PHASESABER = 3768
    YELLOW_PHASESABER = 3769
    DJINNS_CURSE = 3770
    ANCIENT_HORN = 3771
    ANTLION_CLAW = 3772
    ANCIENT_ARMOR_HAT = 3773
    ANCIENT_ARMOR_SHIRT = 3774
    ANCIENT_ARMOR_PANTS = 3775
    ANCIENT_BATTLE_ARMOR_HAT = 3776
    ANCIENT_BATTLE_ARMOR_SHIRT = 3777
    ANCIENT_BATTLE_ARMOR_PANTS = 3778
    SPIRIT_FLAME = 3779
    SAND_ELEMENTAL_BANNER = 3780
    POCKET_MIRROR = 3781
    MAGIC_SAND_DROPPER = 3782
    ANCIENT_BATTLE_ARMOR_MATERIAL = 3783
    LAMIA_PANTS = 3784
    LAMIA_SHIRT = 3785
    LAMIA_HAT = 3786
    SKY_FRACTURE = 3787
    ONYX_BLASTER = 3788
    SANDSHARK_BANNER = 3789
    SANDSHARK_CORRUPT_BANNER = 3790
    SANDSHARK_CRIMSON_BANNER = 3791
    SANDSHARK_HALLOWED_BANNER = 3792
    TUMBLEWEED_BANNER = 3793
    ANCIENT_CLOTH = 3794
    DJINN_LAMP = 3795
    MUSIC_BOX_SANDSTORM = 3796
    APPRENTICE_HAT = 3797
    APPRENTICE_ROBE = 3798
    APPRENTICE_TROUSERS = 3799
    SQUIRE_GREAT_HELM = 3800
    SQUIRE_PLATING = 3801
    SQUIRE_GREAVES = 3802
    HUNTRESS_WIG = 3803
    HUNTRESS_JERKIN = 3804
    HUNTRESS_PANTS = 3805
    MONK_BROWS = 3806
    MONK_SHIRT = 3807
    MONK_PANTS = 3808
    APPRENTICE_SCARF = 3809
    SQUIRE_SHIELD = 3810
    HUNTRESS_BUCKLER = 3811
    MONK_BELT = 3812
    DEFENDERS_FORGE = 3813
    WAR_TABLE = 3814
    WAR_TABLE_BANNER = 3815
    DD2ELDER_CRYSTAL_STAND = 3816
    DEFENDER_MEDAL = 3817
    DD2FLAMEBURST_TOWER_T1POPPER = 3818
    DD2FLAMEBURST_TOWER_T2POPPER = 3819
    DD2FLAMEBURST_TOWER_T3POPPER = 3820
    ALE_THROWING_GLOVE = 3821
    DD2ENERGY_CRYSTAL = 3822
    DD2SQUIRE_DEMON_SWORD = 3823
    DD2BALLISTRA_TOWER_T1POPPER = 3824
    DD2BALLISTRA_TOWER_T2POPPER = 3825
    DD2BALLISTRA_TOWER_T3POPPER = 3826
    DD2SQUIRE_BETSY_SWORD = 3827
    DD2ELDER_CRYSTAL = 3828
    DD2LIGHTNING_AURA_T1POPPER = 3829
    DD2LIGHTNING_AURA_T2POPPER = 3830
    DD2LIGHTNING_AURA_T3POPPER = 3831
    DD2EXPLOSIVE_TRAP_T1POPPER = 3832
    DD2EXPLOSIVE_TRAP_T2POPPER = 3833
    DD2EXPLOSIVE_TRAP_T3POPPER = 3834
    MONK_STAFF_T1 = 3835
    MONK_STAFF_T2 = 3836
    DD2GOBLIN_BOMBER_BANNER = 3837
    DD2GOBLIN_BANNER = 3838
    DD2SKELETON_BANNER = 3839
    DD2DRAKIN_BANNER = 3840
    DD2KOBOLD_FLYER_BANNER = 3841
    DD2KOBOLD_BANNER = 3842
    DD2WITHER_BEAST_BANNER = 3843
    DD2WYVERN_BANNER = 3844
    DD2JAVELIN_THROWER_BANNER = 3845
    DD2LIGHTNING_BUG_BANNER = 3846
    OGRE_MASK = 3847
    GOBLIN_MASK = 3848
    GOBLIN_BOMBER_CAP = 3849
    ETHERIAN_JAVELIN = 3850
    KOBOLD_DYNAMITE_BACKPACK = 3851
    BOOK_STAFF = 3852
    BORING_BOW = 3853
    DD2PHOENIX_BOW = 3854
    DD2PET_GATO = 3855
    DD2PET_GHOST = 3856
    DD2PET_DRAGON = 3857
    MONK_STAFF_T3 = 3858
    DD2BETSY_BOW = 3859
    BOSS_BAG_BETSY = 3860
    BOSS_BAG_OGRE = 3861
    BOSS_BAG_DARK_MAGE = 3862
    BOSS_MASK_BETSY = 3863
    BOSS_MASK_DARK_MAGE = 3864
    BOSS_MASK_OGRE = 3865
    BOSS_TROPHY_BETSY = 3866
    BOSS_TROPHY_DARKMAGE = 3867
    BOSS_TROPHY_OGRE = 3868
    MUSIC_BOX_DD2 = 3869
    APPRENTICE_STAFF_T3 = 3870
    SQUIRE_ALT_HEAD = 3871
    SQUIRE_ALT_SHIRT = 3872
    SQUIRE_ALT_PANTS = 3873
    APPRENTICE_ALT_HEAD = 3874
    APPRENTICE_ALT_SHIRT = 3875
    APPRENTICE_ALT_PANTS = 3876
    HUNTRESS_ALT_HEAD = 3877
    HUNTRESS_ALT_SHIRT = 3878
    HUNTRESS_ALT_PANTS = 3879
    MONK_ALT_HEAD = 3880
    MONK_ALT_SHIRT = 3881
    MONK_ALT_PANTS = 3882
    BETSY_WINGS = 3883
    CRYSTAL_CHEST = 3884
    GOLDEN_CHEST = 3885
    FAKE_CRYSTAL_CHEST = 3886
    FAKE_GOLDEN_CHEST = 3887
    CRYSTAL_DOOR = 3888
    CRYSTAL_CHAIR = 3889
    CRYSTAL_CANDLE = 3890
    CRYSTAL_LANTERN = 3891
    CRYSTAL_LAMP = 3892
    CRYSTAL_CANDELABRA = 3893
    CRYSTAL_CHANDELIER = 3894
    CRYSTAL_BATHTUB = 3895
    CRYSTAL_SINK = 3896
    CRYSTAL_BED = 3897
    CRYSTAL_CLOCK = 3898
    SKYWARE_CLOCK2 = 3899
    DUNGEON_CLOCK_BLUE = 3900
    DUNGEON_CLOCK_GREEN = 3901
    DUNGEON_CLOCK_PINK = 3902
    CRYSTAL_PLATFORM = 3903
    GOLDEN_PLATFORM = 3904
    DYNASTY_PLATFORM = 3905
    LIHZAHRD_PLATFORM = 3906
    FLESH_PLATFORM = 3907
    FROZEN_PLATFORM = 3908
    CRYSTAL_WORKBENCH = 3909
    GOLDEN_WORKBENCH = 3910
    CRYSTAL_DRESSER = 3911
    DYNASTY_DRESSER = 3912
    FROZEN_DRESSER = 3913
    LIVING_WOOD_DRESSER = 3914
    CRYSTAL_PIANO = 3915
    DYNASTY_PIANO = 3916
    CRYSTAL_BOOK_CASE = 3917
    CRYSTAL_SOFA_HOW_DOES_THAT_EVEN_WORK = 3918
    DYNASTY_SOFA = 3919
    CRYSTAL_TABLE = 3920
    ARKHALIS_HAT = 3921
    ARKHALIS_SHIRT = 3922
    ARKHALIS_PANTS = 3923
    ARKHALIS_WINGS = 3924
    LEINFORS_HAT = 3925
    LEINFORS_SHIRT = 3926
    LEINFORS_PANTS = 3927
    LEINFORS_WINGS = 3928
    LEINFORS_ACCESSORY = 3929

    # 1.4 items, adapted from: https://github.com/TerraMap/windows/blob/master/Data/tiles.xml
    CELEBRATION_MK2 = 3930
    SPIDER_BATHTUB = 3931
    SPIDER_BED = 3932
    SPIDER_BOOKCASE = 3933
    SPIDER_DRESSER = 3934
    SPIDER_CANDELABRA = 3935
    SPIDER_CANDLE = 3936
    SPIDER_CHAIR = 3937
    SPIDER_CHANDELIER = 3938
    SPIDER_CHEST = 3939
    SPIDER_CLOCK = 3940
    SPIDER_DOOR = 3941
    SPIDER_LAMP = 3942
    SPIDER_LANTERN = 3943
    SPIDER_PIANO = 3944
    SPIDER_PLATFORM = 3945
    SPIDER_SINK = 3946
    SPIDER_SOFA = 3947
    SPIDER_TABLE = 3948
    SPIDER_WORK_BENCH = 3949
    TRAPPED_SPIDER_CHEST = 3950
    IRON_BRICK = 3951
    IRON_BRICK_WALL = 3952
    LEAD_BRICK = 3953
    LEAD_BRICK_WALL = 3954
    LESION_BLOCK = 3955
    LESION_BLOCK_WALL = 3956
    LESION_PLATFORM = 3957
    LESION_BATHTUB = 3958
    LESION_BED = 3959
    LESION_BOOKCASE = 3960
    LESION_CANDELABRA = 3961
    LESION_CANDLE = 3962
    LESION_CHAIR = 3963
    LESION_CHANDELIER = 3964
    LESION_CHEST = 3965
    LESION_CLOCK = 3966
    LESION_DOOR = 3967
    LESION_DRESSER = 3968
    LESION_LAMP = 3969
    LESION_LANTERN = 3970
    LESION_PIANO = 3971
    LESION_SINK = 3972
    LESION_SOFA = 3973
    LESION_TABLE = 3974
    LESION_WORK_BENCH = 3975
    TRAPPED_LESION_CHEST = 3976
    HAT_RACK = 3977
    COLOR_ONLY_DYE = 3978
    PEARLWOOD_CRATE = 3979
    MYTHRIL_CRATE = 3980
    TITANIUM_CRATE = 3981
    DEFILED_CRATE = 3982
    HEMATIC_CRATE = 3983
    STOCKADE_CRATE = 3984
    AZURE_CRATE = 3985
    DIVINE_CRATE = 3986
    BRAMBLE_CRATE = 3987
    DEAD_MANS_CHEST = 3988
    GOLF_BALL = 3989
    AMPHIBIAN_BOOTS = 3990
    ARCANE_FLOWER = 3991
    BERSERKERS_GLOVE = 3992
    FAIRY_BOOTS = 3993
    FROG_FLIPPER = 3994
    FROG_GEAR = 3995
    FROG_WEBBING = 3996
    FROZEN_SHIELD = 3997
    HERO_SHIELD = 3998
    MAGMA_SKULL = 3999
    MAGNET_FLOWER = 4000
    MANA_CLOAK = 4001
    MOLTEN_QUIVER = 4002
    MOLTEN_SKULL_ROSE = 4003
    OBSIDIAN_SKULL_ROSE = 4004
    RECON_SCOPE = 4005
    STALKERS_QUIVER = 4006
    STINGER_NECKLACE = 4007
    ULTRABRIGHT_HELMET = 4008
    APPLE = 4009
    APPLE_PIE_SLICE = 4010
    APPLE_PIE = 4011
    BANANA_SPLIT = 4012
    BBQ_RIBS = 4013
    BUNNY_STEW = 4014
    BURGER = 4015
    CHICKEN_NUGGET = 4016
    CHOCOLATE_CHIP_COOKIE = 4017
    CREAM_SODA = 4018
    ESCARGOT = 4019
    FRIED_EGG = 4020
    FRIES = 4021
    GOLDEN_DELIGHT = 4022
    GRAPES = 4023
    GRILLED_SQUIRREL = 4024
    HOTDOG = 4025
    ICE_CREAM = 4026
    MILKSHAKE = 4027
    NACHOS = 4028
    PIZZA = 4029
    POTATO_CHIPS = 4030
    ROASTED_BIRD = 4031
    ROASTED_DUCK = 4032
    SAUTEED_FROG_LEGS = 4033
    SEAFOOD_DINNER = 4034
    SHRIMP_PO_BOY = 4035
    SPAGHETTI = 4036
    STEAK = 4037
    MOLTEN_CHARM = 4038
    GOLF_CLUB_IRON = 4039
    GOLF_CUP = 4040
    BLUE_FLOWER_SEEDS = 4041
    MAGENTA_FLOWER_SEEDS = 4042
    PINK_FLOWER_SEEDS = 4043
    RED_FLOWER_SEEDS = 4044
    YELLOW_FLOWER_SEEDS = 4045
    VIOLET_FLOWER_SEEDS = 4046
    WHITE_FLOWER_SEEDS = 4047
    TALL_GRASS_SEEDS = 4048
    LAWN_MOWER = 4049
    CRIMSTONE_BRICK = 4050
    SMOOTH_SANDSTONE = 4051
    CRIMSTONE_BRICK_WALL = 4052
    SMOOTH_SANDSTONE_WALL = 4053
    BLOOD_MOON_MONOLITH = 4054
    DUNERIDER_BOOTS = 4055
    ANCIENT_CHISEL = 4056
    RAIN_SONG = 4057
    SKULL_BOW = 4058
    FOSSIL_PICKAXE = 4059
    SUPER_STAR_SHOOTER = 4060
    STORM_SPEAR = 4061
    THUNDER_ZAPPER = 4062
    DRUM_SET = 4063
    PICNIC_TABLE = 4064
    FANCY_PICNIC_TABLE = 4065
    DESERT_MINECART = 4066
    MINECARP = 4067
    PINK_FAIRY = 4068
    GREEN_FAIRY = 4069
    BLUE_FAIRY = 4070
    JUNONIA_SHELL = 4071
    LIGHTNING_WHELK_SHELL = 4072
    TULIP_SHELL = 4073
    PIN_WHEEL = 4074
    WEATHER_VANE = 4075
    VOID_VAULT = 4076
    MUSIC_BOX_OCEAN_NIGHT = 4077
    MUSIC_BOX_SLIME_RAIN = 4078
    MUSIC_BOX_SPACE_DAY = 4079
    MUSIC_BOX_TOWN_DAY = 4080
    MUSIC_BOX_TOWN_NIGHT = 4081
    MUSIC_BOX_WINDY_DAY = 4082
    WHITE_PIN_FLAG = 4083
    RED_PIN_FLAG = 4084
    GREEN_PIN_FLAG = 4085
    BLUE_PIN_FLAG = 4086
    YELLOW_PIN_FLAG = 4087
    PURPLE_PIN_FLAG = 4088
    GOLF_TEE = 4089
    SHELL_PILE = 4090
    ANTI_PORTAL_BLOCK = 4091
    GOLF_CLUB_PUTTER = 4092
    GOLF_CLUB_WEDGE = 4093
    GOLF_CLUB_DRIVER = 4094
    GOLF_WHISTLE = 4095
    EBONWOOD_TOILET = 4096
    RICH_MAHOGANY_TOILET = 4097
    PEARLWOOD_TOILET = 4098
    LIVING_WOOD_TOILET = 4099
    CACTUS_TOILET = 4100
    BONE_TOILET = 4101
    FLESH_TOILET = 4102
    MUSHROOM_TOILET = 4103
    SKYWARE_TOILET = 4104
    SHADEWOOD_TOILET = 4105
    LIHZAHRD_TOILET = 4106
    BLUE_DUNGEON_TOILET = 4107
    GREEN_DUNGEON_TOILET = 4108
    PINK_DUNGEON_TOILET = 4109
    OBSIDIAN_TOILET = 4110
    FROZEN_TOILET = 4111
    GLASS_TOILET = 4112
    HONEY_TOILET = 4113
    STEAMPUNK_TOILET = 4114
    PUMPKIN_TOILET = 4115
    SPOOKY_TOILET = 4116
    DYNASTY_TOILET = 4117
    PALM_WOOD_TOILET = 4118
    BOREAL_WOOD_TOILET = 4119
    SLIME_TOILET = 4120
    MARTIAN_TOILET = 4121
    GRANITE_TOILET = 4122
    MARBLE_TOILET = 4123
    CRYSTAL_TOILET = 4124
    SPIDER_TOILET = 4125
    LESION_TOILET = 4126
    DIAMOND_TOILET = 4127
    MAID_BONNET = 4128
    MAID_DRESS = 4129
    MAID_SHOES = 4130
    VOID_BAG = 4131
    PINK_MAID_BONNET = 4132
    PINK_MAID_DRESS = 4133
    PINK_MAID_SHOES = 4134
    COUNTRY_CLUB_CAP = 4135
    COUNTRY_CLUB_VEST = 4136
    COUNTRY_CLUB_TROUSERS = 4137
    COUNTRY_CLUB_VISOR = 4138
    SPIDER_NEST_BLOCK = 4139
    SPIDER_NEST_WALL = 4140
    METEOR_TOILET = 4141
    DECAY_CHAMBER = 4142
    WHITE_STAR = 4143  # See: https://terraria.gamepedia.com/White_Star
    TERRAGRIM = 4144
    SOLAR_BATHTUB = 4145
    SOLAR_BED = 4146
    SOLAR_BOOKCASE = 4147
    SOLAR_DRESSER = 4148
    SOLAR_CANDELABRA = 4149
    SOLAR_CANDLE = 4150
    SOLAR_CHAIR = 4151
    SOLAR_CHANDELIER = 4152
    SOLAR_CHEST = 4153
    SOLAR_CLOCK = 4154
    SOLAR_DOOR = 4155
    SOLAR_LAMP = 4156
    SOLAR_LANTERN = 4157
    SOLAR_PIANO = 4158
    SOLAR_PLATFORM = 4159
    SOLAR_SINK = 4160
    SOLAR_SOFA = 4161
    SOLAR_TABLE = 4162
    SOLAR_WORK_BENCH = 4163
    TRAPPED_SOLAR_CHEST = 4164
    SOLAR_TOILET = 4165
    VORTEX_BATHTUB = 4166
    VORTEX_BED = 4167
    VORTEX_BOOKCASE = 4168
    VORTEX_DRESSER = 4169
    VORTEX_CANDELABRA = 4170
    VORTEX_CANDLE = 4171
    VORTEX_CHAIR = 4172
    VORTEX_CHANDELIER = 4173
    VORTEX_CHEST = 4174
    VORTEX_CLOCK = 4175
    VORTEX_DOOR = 4176
    VORTEX_LAMP = 4177
    VORTEX_LANTERN = 4178
    VORTEX_PIANO = 4179
    VORTEX_PLATFORM = 4180
    VORTEX_SINK = 4181
    VORTEX_SOFA = 4182
    VORTEX_TABLE = 4183
    VORTEX_WORK_BENCH = 4184
    TRAPPED_VORTEX_CHEST = 4185
    VORTEX_TOILET = 4186
    NEBULA_BATHTUB = 4187
    NEBULA_BED = 4188
    NEBULA_BOOKCASE = 4189
    NEBULA_DRESSER = 4190
    NEBULA_CANDELABRA = 4191
    NEBULA_CANDLE = 4192
    NEBULA_CHAIR = 4193
    NEBULA_CHANDELIER = 4194
    NEBULA_CHEST = 4195
    NEBULA_CLOCK = 4196
    NEBULA_DOOR = 4197
    NEBULA_LAMP = 4198
    NEBULA_LANTERN = 4199
    NEBULA_PIANO = 4200
    NEBULA_PLATFORM = 4201
    NEBULA_SINK = 4202
    NEBULA_SOFA = 4203
    NEBULA_TABLE = 4204
    NEBULA_WORK_BENCH = 4205
    TRAPPED_NEBULA_CHEST = 4206
    NEBULA_TOILET = 4207
    STARDUST_BATHTUB = 4208
    STARDUST_BED = 4209
    STARDUST_BOOKCASE = 4210
    STARDUST_DRESSER = 4211
    STARDUST_CANDELABRA = 4212
    STARDUST_CANDLE = 4213
    STARDUST_CHAIR = 4214
    STARDUST_CHANDELIER = 4215
    STARDUST_CHEST = 4216
    STARDUST_CLOCK = 4217
    STARDUST_DOOR = 4218
    STARDUST_LAMP = 4219
    STARDUST_LANTERN = 4220
    STARDUST_PIANO = 4221
    STARDUST_PLATFORM = 4222
    STARDUST_SINK = 4223
    STARDUST_SOFA = 4224
    STARDUST_TABLE = 4225
    STARDUST_WORK_BENCH = 4226
    TRAPPED_STARDUST_CHEST = 4227
    STARDUST_TOILET = 4228
    SOLAR_BRICK = 4229
    VORTEX_BRICK = 4230
    NEBULA_BRICK = 4231
    STARDUST_BRICK = 4232
    SOLAR_BRICK_WALL = 4233
    VORTEX_BRICK_WALL = 4234
    NEBULA_BRICK_WALL = 4235
    STARDUST_BRICK_WALL = 4236
    MUSIC_BOX_DAY_REMIX = 4237
    CRACKED_BLUE_BRICK = 4238
    CRACKED_GREEN_BRICK = 4239
    CRACKED_PINK_BRICK = 4240
    WILD_FLOWER_SEEDS = 4241
    BLACK_GOLF_BALL = 4242
    BLUE_GOLF_BALL = 4243
    BROWN_GOLF_BALL = 4244
    CYAN_GOLF_BALL = 4245
    GREEN_GOLF_BALL = 4246
    LIME_GOLF_BALL = 4247
    ORANGE_GOLF_BALL = 4248
    PINK_GOLF_BALL = 4249
    PURPLE_GOLF_BALL = 4250
    RED_GOLF_BALL = 4251
    SKY_BLUE_GOLF_BALL = 4252
    TEAL_GOLF_BALL = 4253
    VIOLET_GOLF_BALL = 4254
    YELLOW_GOLF_BALL = 4255
    AMBER_ROBE = 4256
    AMBER_HOOK = 4257
    ORANGE_PHASEBLADE = 4258
    ORANGE_PHASESABER = 4259
    ORANGE_STAINED_GLASS = 4260
    ORANGE_PRESSURE_PLATE = 4261
    SNAKE_CHARMERS_FLUTE = 4262
    MAGIC_CONCH = 4263
    GOLF_CART_KEYS = 4264
    GOLF_CHEST = 4265
    TRAPPED_GOLF_CHEST = 4266
    SANDSTONE_CHEST = 4267
    TRAPPED_SANDSTONE_CHEST = 4268
    SANGUINE_STAFF = 4269
    BLOOD_THORN = 4270
    BLOODY_TEAR = 4271
    DRIPPLER_CRIPPLER = 4272
    VAMPIRE_FROG_STAFF = 4273
    GOLD_GOLDFISH = 4274
    GOLD_FISH_BOWL = 4275
    BAST_STATUE = 4276
    GOLD_STARRY_BLOCK = 4277
    BLUE_STARRY_BLOCK = 4278
    GOLD_STARRY_WALL = 4279
    BLUE_STARRY_WALL = 4280
    FINCH_STAFF = 4281
    APRICOT = 4282
    BANANA = 4283
    BLACKCURRANT = 4284
    BLOOD_ORANGE = 4285
    CHERRY = 4286
    COCONUT = 4287
    DRAGON_FRUIT = 4288
    ELDERBERRY = 4289
    GRAPEFRUIT = 4290
    LEMON = 4291
    MANGO = 4292
    PEACH = 4293
    PINEAPPLE = 4294
    PLUM = 4295
    RAMBUTAN = 4296
    STAR_FRUIT = 4297
    SANDSTONE_BATHTUB = 4298
    SANDSTONE_BED = 4299
    SANDSTONE_BOOKCASE = 4300
    SANDSTONE_DRESSER = 4301
    SANDSTONE_CANDELABRA = 4302
    SANDSTONE_CANDLE = 4303
    SANDSTONE_CHAIR = 4304
    SANDSTONE_CHANDELIER = 4305
    SANDSTONE_CLOCK = 4306
    SANDSTONE_DOOR = 4307
    SANDSTONE_LAMP = 4308
    SANDSTONE_LANTERN = 4309
    SANDSTONE_PIANO = 4310
    SANDSTONE_PLATFORM = 4311
    SANDSTONE_SINK = 4312
    SANDSTONE_SOFA = 4313
    SANDSTONE_TABLE = 4314
    SANDSTONE_WORK_BENCH = 4315
    SANDSTONE_TOILET = 4316
    HAEMORRHAXE = 4317
    VOID_MONOLITH = 4318
    ARROW_SIGN = 4319
    PAINTED_ARROW_SIGN = 4320
    MASTER_GAMERS_JACKET = 4321
    MASTER_GAMERS_PANTS = 4322
    STAR_PRINCESS_CROWN = 4323
    STAR_PRINCESS_DRESS = 4324
    CHUM_CASTER = 4325
    PLATE = 4326
    BLACK_DRAGONFLY_JAR = 4327
    BLUE_DRAGONFLY_JAR = 4328
    GREEN_DRAGONFLY_JAR = 4329
    ORANGE_DRAGONFLY_JAR = 4330
    RED_DRAGONFLY_JAR = 4331
    YELLOW_DRAGONFLY_JAR = 4332
    GOLD_DRAGONFLY_JAR = 4333
    BLACK_DRAGONFLY = 4334
    BLUE_DRAGONFLY = 4335
    GREEN_DRAGONFLY = 4336
    ORANGE_DRAGONFLY = 4337
    RED_DRAGONFLY = 4338
    YELLOW_DRAGONFLY = 4339
    GOLD_DRAGONFLY = 4340
    STEP_STOOL = 4341
    DRAGONFLY_STATUE = 4342
    PAPER_AIRPLANE = 4343
    WHITE_PAPER_AIRPLANE = 4344
    CAN_OF_WORMS = 4345
    ENCUMBERING_STONE = 4346
    GRAY_ZAPINATOR = 4347
    ORANGE_ZAPINATOR = 4348
    GREEN_MOSS = 4349
    BROWN_MOSS = 4350
    RED_MOSS = 4351
    BLUE_MOSS = 4352
    PURPLE_MOSS = 4353
    LAVA_MOSS = 4354
    BOULDER_STATUE = 4355
    MUSIC_BOX_JOURNEYS_END = 4356
    MUSIC_BOX_STORM = 4357
    MUSIC_BOX_GRAVEYARD = 4358
    SEAGULL = 4359
    SEAGULL_STATUE = 4360
    LADYBUG = 4361
    GOLD_LADYBUG = 4362
    MAGGOT = 4363
    MAGGOT_CAGE = 4364
    CELESTIAL_WAND = 4365
    EUCALYPTUS_SAP = 4366
    BLUE_KITE = 4367
    BLUE_AND_YELLOW_KITE = 4368
    RED_KITE = 4369
    RED_AND_YELLOW_KITE = 4370
    YELLOW_KITE = 4371
    IVY = 4372
    PUPFISH = 4373
    GREBE = 4374
    RAT = 4375
    RAT_CAGE = 4376
    KRYPTON_MOSS = 4377
    XENON_MOSS = 4378
    WYVERN_KITE = 4379
    LADYBUG_CAGE = 4380
    BLOOD_RAIN_BOW = 4381
    ADVANCED_COMBAT_TECHNIQUES = 4382
    DESERT_TORCH = 4383
    CORAL_TORCH = 4384
    CORRUPT_TORCH = 4385
    CRIMSON_TORCH = 4386
    HALLOWED_TORCH = 4387
    JUNGLE_TORCH = 4388
    ARGON_MOSS = 4389
    ROLLING_CACTUS = 4390
    THIN_ICE = 4391
    ECHO_BLOCK = 4392
    SCARAB_FISH = 4393
    SCORPIO_FISH = 4394
    OWL = 4395
    OWL_CAGE = 4396
    OWL_STATUE = 4397
    PUPFISH_BOWL = 4398
    GOLD_LADYBUG_CAGE = 4399
    GEODE = 4400
    FLOUNDER = 4401
    ROCK_LOBSTER = 4402
    LOBSTER_TAIL = 4403
    INNER_TUBE = 4404
    FROZEN_CRATE = 4405
    BOREAL_CRATE = 4406
    OASIS_CRATE = 4407
    MIRAGE_CRATE = 4408
    SPECTRE_GOGGLES = 4409
    OYSTER = 4410
    SHUCKED_OYSTER = 4411
    WHITE_PEARL = 4412
    BLACK_PEARL = 4413
    PINK_PEARL = 4414
    STONE_DOOR = 4415
    STONE_PLATFORM = 4416
    OASIS_WATER_FOUNTAIN = 4417
    WATER_STRIDER = 4418
    GOLD_WATER_STRIDER = 4419
    LAWN_FLAMINGO = 4420
    MUSIC_BOX_UNDERGROUND_JUNGLE = 4421
    GRATE = 4422
    SCARAB_BOMB = 4423
    WROUGHT_IRON_FENCE = 4424
    SHARK_BAIT = 4425
    BEE_MINECART = 4426
    LADYBUG_MINECART = 4427
    PIGRON_MINECART = 4428
    SUNFLOWER_MINECART = 4429
    POTTED_FOREST_CEDAR = 4430
    POTTED_JUNGLE_CEDAR = 4431
    POTTED_HALLOW_CEDAR = 4432
    POTTED_FOREST_TREE = 4433
    POTTED_JUNGLE_TREE = 4434
    POTTED_HALLOW_TREE = 4435
    POTTED_FOREST_PALM = 4436
    POTTED_JUNGLE_PALM = 4437
    POTTED_HALLOW_PALM = 4438
    POTTED_FOREST_BAMBOO = 4439
    POTTED_JUNGLE_BAMBOO = 4440
    POTTED_HALLOW_BAMBOO = 4441
    SCARAB_FISHING_ROD = 4442
    DEMONIC_HELLCART = 4443
    WITCHS_BROOM = 4444
    CLUSTER_ROCKET_I = 4445
    CLUSTER_ROCKET_II = 4446
    WET_ROCKET = 4447
    LAVA_ROCKET = 4448
    HONEY_ROCKET = 4449
    SHROOM_MINECART = 4450
    AMETHYST_MINECART = 4451
    TOPAZ_MINECART = 4452
    SAPPHIRE_MINECART = 4453
    EMERALD_MINECART = 4454
    RUBY_MINECART = 4455
    DIAMOND_MINECART = 4456
    MINI_NUKE_I = 4457
    MINI_NUKE_II = 4458
    DRY_ROCKET = 4459
    SANDCASTLE_BUCKET = 4460
    TURTLE_CAGE = 4461
    JUNGLE_TURTLE_CAGE = 4462
    GLADIUS = 4463
    TURTLE = 4464
    JUNGLE_TURTLE = 4465
    TURTLE_STATUE = 4466
    AMBER_MINECART = 4467
    BEETLE_MINECART = 4468
    MEOWMERE_MINECART = 4469
    PARTY_WAGON = 4470
    THE_DUTCHMAN = 4471
    STEAMPUNK_MINECART = 4472
    GREBE_CAGE = 4473
    SEAGULL_CAGE = 4474
    WATER_STRIDER_CAGE = 4475
    GOLD_WATER_STRIDER_CAGE = 4476
    LESSER_LUCK_POTION = 4477
    LUCK_POTION = 4478
    GREATER_LUCK_POTION = 4479
    SEAHORSE = 4480
    SEAHORSE_CAGE = 4481
    GOLD_SEAHORSE = 4482
    GOLD_SEAHORSE_CAGE = 4483
    HALF_SECOND_TIMER = 4484
    QUARTER_SECOND_TIMER = 4485
    EBONSTONE_WALL = 4486
    MUD_WALL = 4487
    PEARLSTONE_WALL = 4488
    SNOW_WALL = 4489
    AMETHYST_STONE_WALL = 4490
    TOPAZ_STONE_WALL = 4491
    SAPPHIRE_STONE_WALL = 4492
    EMERALD_STONE_WALL = 4493
    RUBY_STONE_WALL = 4494
    DIAMOND_STONE_WALL = 4495
    GREEN_MOSSY_WALL = 4496
    BROWN_MOSSY_WALL = 4497
    RED_MOSSY_WALL = 4498
    BLUE_MOSSY_WALL = 4499
    PURPLE_MOSSY_WALL = 4500
    ROCKY_DIRT_WALL = 4501
    OLD_STONE_WALL = 4502
    SPIDER_WALL = 4503
    CORRUPT_GRASS_WALL = 4504
    HALLOWED_GRASS_WALL = 4505
    ICE_WALL = 4506
    OBSIDIAN_WALL = 4507
    CRIMSON_GRASS_WALL = 4508
    CRIMSTONE_WALL = 4509
    CAVE_DIRT_WALL = 4510
    ROUGH_DIRT_WALL = 4511
    CRAGGY_STONE_WALL = 4512
    CORRUPT_GROWTH_WALL = 4513
    CORRUPT_MASS_WALL = 4514
    CORRUPT_PUSTULE_WALL = 4515
    CORRUPT_TENDRIL_WALL = 4516
    CRIMSON_CRUST_WALL = 4517
    CRIMSON_SCAB_WALL = 4518
    CRIMSON_TEETH_WALL = 4519
    CRIMSON_BLISTER_WALL = 4520
    LAYERED_DIRT_WALL = 4521
    CRUMBLING_DIRT_WALL = 4522
    CRACKED_DIRT_WALL = 4523
    WAVY_DIRT_WALL = 4524
    HALLOWED_PRISM_WALL = 4525
    HALLOWED_CAVERN_WALL = 4526
    HALLOWED_SHARD_WALL = 4527
    HALLOWED_CRYSTALLINE_WALL = 4528
    LICHEN_STONE_WALL = 4529
    LEAFY_JUNGLE_WALL = 4530
    IVY_STONE_WALL = 4531
    JUNGLE_VINE_WALL = 4532
    EMBER_WALL = 4533
    CINDER_WALL = 4534
    MAGMA_WALL = 4535
    SMOULDERING_STONE_WALL = 4536
    WORN_STONE_WALL = 4537
    STALACTITE_STONE_WALL = 4538
    MOTTLED_STONE_WALL = 4539
    FRACTURED_STONE_WALL = 4540
    THE_BRIDE_BANNER = 4541
    ZOMBIE_MERMAN_BANNER = 4542
    WANDERING_EYE_FISH_BANNER = 4543
    BLOOD_SQUID_BANNER = 4544
    BLOOD_EEL_BANNER = 4545
    HEMOGOBLIN_SHARK_BANNER = 4546
    LARGE_BAMBOO = 4547
    LARGE_BAMBOO_WALL = 4548
    DEMON_HORNS = 4549
    BAMBOO_LEAF = 4550
    SLICE_OF_HELL_CAKE = 4551
    FOG_MACHINE = 4552
    PLASMA_LAMP = 4553
    MARBLE_COLUMN = 4554
    CHEF_HAT = 4555
    CHEF_UNIFORM = 4556
    CHEF_PANTS = 4557
    STAR_HAIRPIN = 4558
    HEART_HAIRPIN = 4559
    BUNNY_EARS = 4560
    DEVIL_HORNS = 4561
    FEDORA = 4562
    FAKE_UNICORN_HORN = 4563
    BAMBOO = 4564
    BAMBOO_WALL = 4565
    BAMBOO_BATHTUB = 4566
    BAMBOO_BED = 4567
    BAMBOO_BOOKCASE = 4568
    BAMBOO_DRESSER = 4569
    BAMBOO_CANDELABRA = 4570
    BAMBOO_CANDLE = 4571
    BAMBOO_CHAIR = 4572
    BAMBOO_CHANDELIER = 4573
    BAMBOO_CHEST = 4574
    BAMBOO_CLOCK = 4575
    BAMBOO_DOOR = 4576
    BAMBOO_LAMP = 4577
    BAMBOO_LANTERN = 4578
    BAMBOO_PIANO = 4579
    BAMBOO_PLATFORM = 4580
    BAMBOO_SINK = 4581
    BAMBOO_SOFA = 4582
    BAMBOO_TABLE = 4583
    BAMBOO_WORK_BENCH = 4584
    TRAPPED_BAMBOO_CHEST = 4585
    BAMBOO_TOILET = 4586
    WORN_GOLF_CLUB_IRON = 4587
    WORN_GOLF_CLUB_PUTTER = 4588
    WORN_GOLF_CLUB_WEDGE = 4589
    WORN_GOLF_CLUB_DRIVER = 4590
    FANCY_GOLF_CLUB_IRON = 4591
    FANCY_GOLF_CLUB_PUTTER = 4592
    FANCY_GOLF_CLUB_WEDGE = 4593
    FANCY_GOLF_CLUB_DRIVER = 4594
    PREMIUM_GOLF_CLUB_IRON = 4595
    PREMIUM_GOLF_CLUB_PUTTER = 4596
    PREMIUM_GOLF_CLUB_WEDGE = 4597
    PREMIUM_GOLF_CLUB_DRIVER = 4598
    BRONZE_GOLF_TROPHY = 4599
    SILVER_GOLF_TROPHY = 4600
    GOLD_GOLF_TROPHY = 4601
    DREADNAUTILUS_BANNER = 4602
    BIRDIE_RATTLE = 4603
    EXOTIC_CHEW_TOY = 4604
    BEDAZZLED_NECTAR = 4605
    MUSIC_BOX_JUNGLE_NIGHT = 4606
    DESERT_TIGER_STAFF = 4607
    CHUM_BUCKET = 4608
    GARDEN_GNOME = 4609
    BONE_SERPENT_KITE = 4610
    WORLD_FEEDER_KITE = 4611
    BUNNY_KITE = 4612
    PIGRON_KITE = 4613
    APPLE_JUICE = 4614
    GRAPE_JUICE = 4615
    LEMONADE = 4616
    FROZEN_BANANA_DAIQUIRI = 4617
    PEACH_SANGRIA = 4618
    PINA_COLADA = 4619
    TROPICAL_SMOOTHIE = 4620
    BLOODY_MOSCATO = 4621
    SMOOTHIE_OF_DARKNESS = 4622
    PRISMATIC_PUNCH = 4623
    FRUIT_JUICE = 4624
    FRUIT_SALAD = 4625
    ANDREW_SPHINX = 4626
    WATCHFUL_ANTLION = 4627
    BURNING_SPIRIT = 4628
    JAWS_OF_DEATH = 4629
    THE_SANDS_OF_SLIME = 4630
    SNAKES_I_HATE_SNAKES = 4631
    LIFE_ABOVE_THE_SAND = 4632
    OASIS = 4633
    PREHISTORY_PRESERVED = 4634
    ANCIENT_TABLET = 4635
    ULURU = 4636
    VISITING_THE_PYRAMIDS = 4637
    BANDAGE_BOY = 4638
    DIVINE_EYE = 4639
    AMETHYST_STONE_BLOCK = 4640
    TOPAZ_STONE_BLOCK = 4641
    SAPPHIRE_STONE_BLOCK = 4642
    EMERALD_STONE_BLOCK = 4643
    RUBY_STONE_BLOCK = 4644
    DIAMOND_STONE_BLOCK = 4645
    AMBER_STONE_BLOCK = 4646
    AMBER_STONE_WALL = 4647
    MAN_EATER_KITE = 4648
    BLUE_JELLYFISH_KITE = 4649
    PINK_JELLYFISH_KITE = 4650
    SHARK_KITE = 4651
    SUPERHERO_MASK = 4652
    SUPERHERO_COSTUME = 4653
    SUPERHERO_TIGHTS = 4654
    PINK_FAIRY_JAR = 4655
    GREEN_FAIRY_JAR = 4656
    BLUE_FAIRY_JAR = 4657
    THE_ROLLING_GREENS = 4658
    STUDY_OF_A_BALL_AT_REST = 4659
    FORE = 4660
    THE_DUPLICITY_OF_REFLECTIONS = 4661
    FOGBOUND_DYE = 4662
    BLOODBATH_DYE = 4663
    PRETTY_PINK_DRESS = 4664
    PRETTY_PINK_STOCKINGS = 4665
    PRETTY_PINK_RIBBON = 4666
    BAMBOO_FENCE = 4667
    ILLUMINANT_PAINT = 4668
    SAND_SHARK_KITE = 4669
    CORRUPT_BUNNY_KITE = 4670
    CRIMSON_BUNNY_KITE = 4671
    LEATHER_WHIP = 4672
    DRUMSTICK = 4673
    GOLDFISH_KITE = 4674
    ANGRY_TRAPPER_KITE = 4675
    KOI_KITE = 4676
    CRAWLTIPEDE_KITE = 4677
    DURENDAL = 4678
    MORNING_STAR = 4679
    DARK_HARVEST = 4680
    SPECTRUM_KITE = 4681
    RELEASE_DOVES = 4682
    WANDERING_EYE_KITE = 4683
    UNICORN_KITE = 4684
    GRAVEDIGGER_HAT = 4685
    GRAVEDIGGER_COAT = 4686
    ANGRY_DANDELION_BANNER = 4687
    GNOME_BANNER = 4688
    DESERT_CAMPFIRE = 4689
    CORAL_CAMPFIRE = 4690
    CORRUPT_CAMPFIRE = 4691
    CRIMSON_CAMPFIRE = 4692
    HALLOWED_CAMPFIRE = 4693
    JUNGLE_CAMPFIRE = 4694
    SOUL_OF_LIGHT_IN_A_BOTTLE = 4695
    SOUL_OF_NIGHT_IN_A_BOTTLE = 4696
    SOUL_OF_FLIGHT_IN_A_BOTTLE = 4697
    SOUL_OF_SIGHT_IN_A_BOTTLE = 4698
    SOUL_OF_MIGHT_IN_A_BOTTLE = 4699
    SOUL_OF_FRIGHT_IN_A_BOTTLE = 4700
    MUD_BUD = 4701
    RELEASE_LANTERN = 4702
    QUAD_BARREL_SHOTGUN = 4703
    FUNERAL_HAT = 4704
    FUNERAL_COAT = 4705
    FUNERAL_PANTS = 4706
    TRAGIC_UMBRELLA = 4707
    VICTORIAN_GOTH_HAT = 4708
    VICTORIAN_GOTH_DRESS = 4709
    TATTERED_WOOD_SIGN = 4710
    GRAVEDIGGERS_SHOVEL = 4711
    DESERT_CHEST = 4712
    TRAPPED_DESERT_CHEST = 4713
    DESERT_KEY = 4714
    STELLAR_TUNE = 4715
    MOLLUSK_WHISTLE = 4716
    BOREAL_BEAM = 4717
    RICH_MAHOGANY_BEAM = 4718
    GRANITE_COLUMN = 4719
    SANDSTONE_COLUMN = 4720
    MUSHROOM_BEAM = 4721
    FIRST_FRACTAL = 4722
    NEVERMORE = 4723
    REBORN = 4724
    GRAVEYARD = 4725
    GHOST_MANIFESTATION = 4726
    WICKED_UNDEAD = 4727
    BLOODY_GOBLET = 4728
    STILL_LIFE = 4729
    GHOSTARS_INFINITY_EIGHT = 4730
    TERRA_TOILET = 4731
    GHOSTARS_SOUL_JAR = 4732
    GHOSTARS_GARB = 4733
    GHOSTARS_TIGHTS = 4734
    BALL_O_FUSE_WIRE = 4735
    FULL_MOON_SQUEAKY_TOY = 4736
    ORNATE_SHADOW_KEY = 4737
    DR_MAN_FLY_MASK = 4738
    DR_MAN_FLYS_LAB_COAT = 4739
    BUTCHER_MASK = 4740
    BUTCHERS_BLOODSTAINED_APRON = 4741
    BUTCHERS_BLOODSTAINED_PANTS = 4742
    FOOTBALL = 4743
    HUNTER_CLOAK = 4744
    COFFIN_MINECART = 4745
    SAFEMANS_BLANKET_CAPE = 4746
    SAFEMANS_SUNNY_DAY = 4747
    SAFEMANS_SUN_DRESS = 4748
    SAFEMANS_PINK_LEGGINGS = 4749
    FOODBARBARIANS_TATTERED_DRAGON_WINGS = 4750
    FOODBARBARIANS_HORNED_HELM = 4751
    FOODBARBARIANS_WILD_WOLF_SPAULDERS = 4752
    FOODBARBARIANS_SAVAGE_GREAVES = 4753
    GROX_THE_GREATS_WINGS = 4754
    GROX_THE_GREATS_HORNED_COWL = 4755
    GROX_THE_GREATS_CHESTPLATE = 4756
    GROX_THE_GREATS_GREAVES = 4757
    BLADE_STAFF = 4758
    SQUIRREL_HOOK = 4759
    SERGEANT_UNITED_SHIELD = 4760
    ROCK_GOLEM_HEAD = 4761
    CRITTER_SHAMPOO = 4762
    DIGGING_MOLECART = 4763
    SHROOMERANG = 4764
    TREE_GLOBE = 4765
    WORLD_GLOBE = 4766
    GUIDE_TO_CRITTER_COMPANIONSHIP = 4767
    DOG_EARS = 4768
    DOG_TAIL = 4769
    FOX_EARS = 4770
    FOX_TAIL = 4771
    LIZARD_EARS = 4772
    LIZARD_TAIL = 4773
    PANDA_EARS = 4774
    BUNNY_TAIL = 4775
    FAIRY_GLOWSTICK = 4776
    LIGHTNING_CARROT = 4777
    PRISMATIC_DYE = 4778
    MUSHROOM_HAT = 4779
    MUSHROOM_VEST = 4780
    MUSHROOM_PANTS = 4781
    TREASURE_BAG = 4957
    EMPRESS_OF_LIGHT_TROPHY = 4783
    EMPRESS_OF_LIGHT_MASK = 4784
    DUSTY_RAWHIDE_SADDLE = 4785
    ROYAL_GILDED_SADDLE = 4786
    BLACK_STUDDED_SADDLE = 4787
    JOUSTING_LANCE = 4788
    SHADOW_JOUSTING_LANCE = 4789
    HALLOWED_JOUSTING_LANCE = 4790
    POGO_STICK = 4791
    THE_BLACK_SPOT = 4792
    HEXXED_BRANCH = 4793
    TOY_TANK = 4794
    GOAT_SKULL = 4795
    DARK_MAGES_TOME = 4796
    ROYAL_DELIGHT = 4797
    SUSPICIOUS_GRINNING_EYE = 4798
    WRITHING_REMAINS = 4799
    BRAIN_IN_A_JAR = 4800
    POSSESSED_SKULL = 4801
    SPARKLING_HONEY = 4802
    DEACTIVATED_PROBE = 4803
    PAIR_OF_EYEBALLS = 4804
    ROBOTIC_SKULL = 4805
    PLANTERA_SEEDLING = 4806
    GUARDIAN_GOLEM = 4807
    PORK_OF_THE_SEA = 4808
    TABLET_FRAGMENT = 4809
    PIECE_OF_MOON_SQUID = 4810
    JEWEL_OF_LIGHT = 4811
    PUMPKIN_SCENTED_CANDLE = 4812
    SHRUB_STAR = 4813
    FROZEN_CROWN = 4814
    COSMIC_SKATEBOARD = 4815
    OGRES_CLUB = 4816
    BETSYS_EGG = 4817
    COMBAT_WRENCH = 4818
    DEMON_CONCH = 4819
    BOTTOMLESS_LAVA_BUCKET = 4820
    LAVAPROOF_BUG_NET = 4821
    FLAME_WAKER_BOOTS = 4822
    EMPRESS_WINGS = 4823
    WET_BOMB = 4824
    LAVA_BOMB = 4825
    HONEY_BOMB = 4826
    DRY_BOMB = 4827
    SUPERHEATED_BLOOD = 4828
    CAT_LICENSE = 4829
    DOG_LICENSE = 4830
    AMETHYST_SQUIRREL = 4831
    TOPAZ_SQUIRREL = 4832
    SAPPHIRE_SQUIRREL = 4833
    EMERALD_SQUIRREL = 4834
    RUBY_SQUIRREL = 4835
    DIAMOND_SQUIRREL = 4836
    AMBER_SQUIRREL = 4837
    AMETHYST_BUNNY = 4838
    TOPAZ_BUNNY = 4839
    SAPPHIRE_BUNNY = 4840
    EMERALD_BUNNY = 4841
    RUBY_BUNNY = 4842
    DIAMOND_BUNNY = 4843
    AMBER_BUNNY = 4844
    HELL_BUTTERFLY = 4845
    HELL_BUTTERFLY_JAR = 4846
    LAVAFLY = 4847
    LAVAFLY_IN_A_BOTTLE = 4848
    MAGMA_SNAIL = 4849
    MAGMA_SNAIL_CAGE = 4850
    TOPAZ_GEMCORN = 4851
    AMETHYST_GEMCORN = 4852
    SAPPHIRE_GEMCORN = 4853
    EMERALD_GEMCORN = 4854
    RUBY_GEMCORN = 4855
    DIAMOND_GEMCORN = 4856
    AMBER_GEMCORN = 4857
    HANGING_POT = 4858
    HANGING_DAYBLOOM = 4859
    HANGING_MOONGLOW = 4860
    HANGING_WATERLEAF = 4861
    HANGING_SHIVERTHORN = 4862
    HANGING_BLINKROOT = 4863
    HANGING_CORRUPT_DEATHWEED = 4864
    HANGING_CRIMSON_DEATHWEED = 4865
    HANGING_FIREBLOSSOM = 4866
    HANGING_BRAZIER = 4867
    MINI_VOLCANO = 4868
    LARGE_VOLCANO = 4869
    POTION_OF_RETURN = 4870
    SAKURA_SAPLING = 4871
    LAVA_ABSORBANT_SPONGE = 4872
    HALLOWED_HOOD = 4873
    HELLFIRE_TREADS = 4874
    JUNGLE_PYLON = 4875
    FOREST_PYLON = 4876
    OBSIDIAN_CRATE = 4877
    HELLSTONE_CRATE = 4878
    OBSIDIAN_LOCK_BOX = 4879
    LAVA_SERPENT_BOWL = 4880
    LAVAPROOF_FISHING_HOOK = 4881
    AMETHYST_BUNNY_CAGE = 4882
    TOPAZ_BUNNY_CAGE = 4883
    SAPPHIRE_BUNNY_CAGE = 4884
    EMERALD_BUNNY_CAGE = 4885
    RUBY_BUNNY_CAGE = 4886
    DIAMOND_BUNNY_CAGE = 4887
    AMBER_BUNNY_CAGE = 4888
    AMETHYST_SQUIRREL_CAGE = 4889
    TOPAZ_SQUIRREL_CAGE = 4890
    SAPPHIRE_SQUIRREL_CAGE = 4891
    EMERALD_SQUIRREL_CAGE = 4892
    RUBY_SQUIRREL_CAGE = 4893
    DIAMOND_SQUIRREL_CAGE = 4894
    AMBER_SQUIRREL_CAGE = 4895
    ANCIENT_HALLOWED_MASK = 4896
    ANCIENT_HALLOWED_HELMET = 4897
    ANCIENT_HALLOWED_HEADGEAR = 4898
    ANCIENT_HALLOWED_HOOD = 4899
    ANCIENT_HALLOWED_PLATE_MAIL = 4900
    ANCIENT_HALLOWED_GREAVES = 4901
    POTTED_MAGMA_PALM = 4902
    POTTED_BRIMSTONE_BUSH = 4903
    POTTED_FIRE_BRAMBLES = 4904
    POTTED_LAVA_BULB = 4905
    POTTED_EMBER_TENDRILS = 4906
    YELLOW_WILLOW_SAPLING = 4907
    DIRT_BOMB = 4908
    STICKY_DIRT_BOMB = 4909
    BUNNY_LICENSE = 4910
    COOL_WHIP = 4911
    FIRECRACKER = 4912
    SNAPTHORN = 4913
    KALEIDOSCOPE = 4914
    TUNGSTEN_BULLET = 4915
    HALLOW_PYLON = 4916
    CAVERN_PYLON = 4917
    OCEAN_PYLON = 4918
    DESERT_PYLON = 4919
    SNOW_PYLON = 4920
    MUSHROOM_PYLON = 4921
    CAVERN_WATER_FOUNTAIN = 4922
    STARLIGHT = 4923
    EYE_OF_CTHULHU_RELIC = 4924
    EATER_OF_WORLDS_RELIC = 4925
    BRAIN_OF_CTHULHU_RELIC = 4926
    SKELETRON_RELIC = 4927
    QUEEN_BEE_RELIC = 4928
    KING_SLIME_RELIC = 4929
    WALL_OF_FLESH_RELIC = 4930
    TWINS_RELIC = 4931
    DESTROYER_RELIC = 4932
    SKELETRON_PRIME_RELIC = 4933
    PLANTERA_RELIC = 4934
    GOLEM_RELIC = 4935
    DUKE_FISHRON_RELIC = 4936
    LUNATIC_CULTIST_RELIC = 4937
    MOON_LORD_RELIC = 4938
    MARTIAN_SAUCER_RELIC = 4939
    FLYING_DUTCHMAN_RELIC = 4940
    MOURNING_WOOD_RELIC = 4941
    PUMPKING_RELIC = 4942
    ICE_QUEEN_RELIC = 4943
    EVERSCREAM_RELIC = 4944
    SANTA_NK1_RELIC = 4945
    DARK_MAGE_RELIC = 4946
    OGRE_RELIC = 4947
    BETSY_RELIC = 4948
    EMPRESS_OF_LIGHT_RELIC = 4949
    QUEEN_SLIME_RELIC = 4950
    UNIVERSAL_PYLON = 4951
    NIGHTGLOW = 4952
    EVENTIDE = 4953
    CELESTIAL_STARBOARD = 4954
    RABBIT_PERCH = 4955
    ZENITH = 4956
    QUEEN_SLIME_TROPHY = 4958
    QUEEN_SLIME_MASK = 4959
    REGAL_DELICACY = 4960
    PRISMATIC_LACEWING = 4961
    STONE_ACCENT_SLAB = 4962
    TRUFFLE_WORM_CAGE = 4963
    PRISMATIC_LACEWING_JAR = 4964
    ROCK_GOLEM_BANNER = 4965
    BLOOD_MUMMY_BANNER = 4966
    SPORE_SKELETON_BANNER = 4967
    SPORE_BAT_BANNER = 4968
    ANTLION_LARVA_BANNER = 4969
    VICIOUS_BUNNY_BANNER = 4970
    VICIOUS_GOLDFISH_BANNER = 4971
    VICIOUS_PENGUIN_BANNER = 4972
    CORRUPT_MIMIC_BANNER = 4973
    CRIMSON_MIMIC_BANNER = 4974
    HALLOWED_MIMIC_BANNER = 4975
    MOSS_HORNET_BANNER = 4976
    WANDERING_EYE_BANNER = 4977
    FLEDGLING_WINGS = 4978
    MUSIC_BOX_QUEEN_SLIME = 4979
    HOOK_OF_DISSONANCE = 4980
    GELATINOUS_PILLION = 4981
    CRYSTAL_ASSASSIN_HOOD = 4982
    CRYSTAL_ASSASSIN_SHIRT = 4983
    CRYSTAL_ASSASSIN_PANTS = 4984
    MUSIC_BOX_EMPRESS_OF_LIGHT = 4985
    SPARKLE_SLIME_BALLOON = 4986
    VOLATILE_GELATIN = 4987
    GELATIN_CRYSTAL = 4988
    SOARING_INSIGNIA = 4989
    MUSIC_BOX_DUKE_FISHRON = 4990
    MUSIC_BOX_MORNING_RAIN = 4991
    MUSIC_BOX_ALT_TITLE = 4992
    CHIPPYS_COUCH = 4993
    BLUE_GRADUATION_CAP = 4994
    MAROON_GRADUATION_CAP = 4995
    BLACK_GRADUATION_CAP = 4996
    BLUE_GRADUATION_GOWN = 4997
    MAROON_GRADUATION_GOWN = 4998
    BLACK_GRADUATION_GOWN = 4999
    TERRASPARK_BOOTS = 5000
    MOON_LORD_LEGS = 5001
    OCEAN_CRATE = 5002
    SEASIDE_CRATE = 5003
    BADGERS_HAT = 5004
    TERRAPRISMA = 5005
    MUSIC_BOX_UNDERGROUND_DESERT = 5006
    DEAD_MANS_SWEATER = 5007
    TEAPOT = 5008
    TEACUP = 5009
    TREASURE_MAGNET = 5010
    MACE = 5011
    FLAMING_MACE = 5012
    SLEEPING_ICON = 5013
    OTHERWORLDLY_MUSIC_BOX_RAIN = 5014
    OTHERWORLDLY_MUSIC_BOX_OVERWORLD_DAY = 5015
    OTHERWORLDLY_MUSIC_BOX_NIGHT = 5016
    OTHERWORLDLY_MUSIC_BOX_UNDERGROUND = 5017
    OTHERWORLDLY_MUSIC_BOX_DESERT = 5018
    OTHERWORLDLY_MUSIC_BOX_OCEAN = 5019
    OTHERWORLDLY_MUSIC_BOX_MUSHROOMS = 5020
    OTHERWORLDLY_MUSIC_BOX_DUNGEON = 5021
    OTHERWORLDLY_MUSIC_BOX_SPACE = 5022
    OTHERWORLDLY_MUSIC_BOX_UNDERWORLD = 5023
    OTHERWORLDLY_MUSIC_BOX_SNOW = 5024
    OTHERWORLDLY_MUSIC_BOX_CORRUPTION = 5025
    OTHERWORLDLY_MUSIC_BOX_UNDERGROUND_CORRUPTION = 5026
    OTHERWORLDLY_MUSIC_BOX_CRIMSON = 5027
    OTHERWORLDLY_MUSIC_BOX_UNDERGROUND_CRIMSON = 5028
    OTHERWORLDLY_MUSIC_BOX_ICE = 5029
    OTHERWORLDLY_MUSIC_BOX_UNDERGROUND_HALLOW = 5030
    OTHERWORLDLY_MUSIC_BOX_EERIE = 5031
    OTHERWORLDLY_MUSIC_BOX_BOSS_2 = 5032
    OTHERWORLDLY_MUSIC_BOX_BOSS_1 = 5033
    OTHERWORLDLY_MUSIC_BOX_INVASION = 5034
    OTHERWORLDLY_MUSIC_BOX_THE_TOWERS = 5035
    OTHERWORLDLY_MUSIC_BOX_LUNAR_BOSS = 5036
    OTHERWORLDLY_MUSIC_BOX_PLANTERA = 5037
    OTHERWORLDLY_MUSIC_BOX_JUNGLE = 5038
    OTHERWORLDLY_MUSIC_BOX_WALL_OF_FLESH = 5039
    OTHERWORLDLY_MUSIC_BOX_HALLOW = 5040
    CARTON_OF_MILK = 5041
    COFFEE = 5042
    TORCH_GODS_FAVOR = 5043
    MUSIC_BOX_JOURNEYS_END_2 = 5044
    PLAGUEBRINGERS_SKULL = 5045
    PLAGUEBRINGERS_CLOAK = 5046
    PLAGUEBRINGERS_TREADS = 5047
    WANDERING_JINGASA = 5048
    WANDERING_YUKATA = 5049
    WANDERING_GETA = 5050
    TIMELESS_TRAVELERS_HOOD = 5051
    TIMELESS_TRAVELERS_CLOAK = 5052
    TIMELESS_TRAVELERS_FOOTWEAR = 5053
    FLORET_PROTECTOR_HELMET = 5054
    FLORET_PROTECTOR_SHIRT = 5055
    FLORET_PROTECTOR_PANTS = 5056
    CAPRICORN_HELMET = 5057
    CAPRICORN_CHESTPLATE = 5058
    CAPRICORN_HOOVES = 5059
    CAPRICORN_TAIL = 5060
    VIDEO_VISAGE = 5061
    LAZER_BLAZER = 5062
    PINSTRIPE_PANTS = 5063
    LAVAPROOF_TACKLE_BAG = 5064
    RESONANCE_SCEPTER = 5065
    BEE_HIVE = 5066
    ANTLION_EGGS = 5067
    FLINX_FOR_COAT = 5068
    FLINX_STAFF = 5069
    FLINX_FUR = 5070
    ROYAL_TIARA = 5071
    ROYAL_BLOUSE = 5072
    ROYAL_DRESS = 5073
    SPINAL_TAP = 5074
    RAINBOW_CURSOR = 5075
    ROYAL_SCEPTER = 5076
    GLASS_SLIPPER = 5077
    PRINCE_UNIFORM = 5078
    PRINCE_PANTS = 5079
    PRINCE_CAPE = 5080
    POTTED_CRYSTAL_FERN = 5081
    POTTED_CRYSTAL_SPIRAL = 5082
    POTTED_CRYSTAL_TEARDROP = 5083
    POTTED_CRYSTAL_TREE = 5084
    PRINCESS_64 = 5085
    PAINTING_OF_A_LASS = 5086
    DARK_SIDE_OF_THE_HOLLOW = 5087
    BERNIES_BUTTON = 5088
    GLOMMERS_FLOWER = 5089
    DEERCLOPS_EYEBALL = 5090
    MONSTER_MEAT = 5091
    MONSTER_LASAGNA = 5092
    FROGGLE_BUNWICH = 5093
    TENTACLE_SPIKE = 5094
    LUCY_THE_AXE = 5095
    HAM_BAT = 5096
    BAT_BAT = 5097
    EYE_BONE = 5098
    GARLAND = 5099
    BONE_HELM = 5100
    EYEBRELLA = 5101
    GENTLEMANS_VEST = 5102
    GENTLEMANS_TROUSERS = 5103
    GENTLEMANS_BEARD = 5104
    GENTLEMANS_LONG_BEARD = 5105
    GENTLEMANS_MAGNIFICENT_BEARD = 5106
    MAGILUMINESCENCE = 5107
    DEERCLOPS_TROPHY = 5108
    DEERCLOPS_MASK = 5109
    DEERCLOPS_RELIC = 5110
    TREASURE_BAG_DEERCLOPS = 5111
    MUSIC_BOX_DEERCLOPS = 5112
    RADIO_THING = 5113
    ABIGAILS_FLOWER = 5114
    FIRESTARTERS_SWEATER = 5115
    FIRESTARTERS_SKIRT = 5116
    PEW_MATIC_HORN = 5117
    WEATHER_PAIN = 5118
    HOUNDIUS_SHOOTIUS = 5119
    DEER_THING = 5120
    THE_GENTLEMAN_SCIENTIST = 5121
    THE_FIRESTARTER = 5122
    THE_BEREAVED = 5123
    THE_STRONGMAN = 5124
    FART_MINECART = 5125
    HAND_OF_CREATION = 5126
    VIOLET_MOSS = 5127
    RAINBOW_MOSS = 5128
    FLYMEAL = 5129
    WOLF_MOUNT_ITEM = 5130
    RESPLENDENT_DESSERT = 5131
    STINKBUG = 5132
    STINKBUG_CAGE = 5133
    CLENTAMINATOR_2 = 5134
    VENOM_DART_TRAP = 5135
    VULKELF_EAR = 5136
    STINKBUG_HOUSING_BLOCKER = 5137
    STINKBUG_HOUSING_BLOCKER_ECHO = 5138
    FISHING_BOBBER = 5139
    FISHING_BOBBER_GLOWING_STAR = 5140
    FISHING_BOBBER_GLOWING_LAVA = 5141
    FISHING_BOBBER_GLOWING_KRYPTON = 5142
    FISHING_BOBBER_GLOWING_XENON = 5143
    FISHING_BOBBER_GLOWING_ARGON = 5144
    FISHING_BOBBER_GLOWING_VIOLET = 5145
    FISHING_BOBBER_GLOWING_RAINBOW = 5146
    WANDOF_FROSTING = 5147
    CORAL_BATHTUB = 5148
    CORAL_BED = 5149
    CORAL_BOOKCASE = 5150
    CORAL_DRESSER = 5151
    CORAL_CANDELABRA = 5152
    CORAL_CANDLE = 5153
    CORAL_CHAIR = 5154
    CORAL_CHANDELIER = 5155
    CORAL_CHEST = 5156
    CORAL_CLOCK = 5157
    CORAL_DOOR = 5158
    CORAL_LAMP = 5159
    CORAL_LANTERN = 5160
    CORAL_PIANO = 5161
    CORAL_PLATFORM = 5162
    CORAL_SINK = 5163
    CORAL_SOFA = 5164
    CORAL_TABLE = 5165
    CORAL_WORKBENCH = 5166
    FAKE_CORAL_CHEST = 5167
    CORAL_TOILET = 5168
    BALLOON_BATHTUB = 5169
    BALLOON_BED = 5170
    BALLOON_BOOKCASE = 5171
    BALLOON_DRESSER = 5172
    BALLOON_CANDELABRA = 5173
    BALLOON_CANDLE = 5174
    BALLOON_CHAIR = 5175
    BALLOON_CHANDELIER = 5176
    BALLOON_CHEST = 5177
    BALLOON_CLOCK = 5178
    BALLOON_DOOR = 5179
    BALLOON_LAMP = 5180
    BALLOON_LANTERN = 5181
    BALLOON_PIANO = 5182
    BALLOON_PLATFORM = 5183
    BALLOON_SINK = 5184
    BALLOON_SOFA = 5185
    BALLOON_TABLE = 5186
    BALLOON_WORKBENCH = 5187
    FAKE_BALLOON_CHEST = 5188
    BALLOON_TOILET = 5189
    ASH_WOOD_BATHTUB = 5190
    ASH_WOOD_BED = 5191
    ASH_WOOD_BOOKCASE = 5192
    ASH_WOOD_DRESSER = 5193
    ASH_WOOD_CANDELABRA = 5194
    ASH_WOOD_CANDLE = 5195
    ASH_WOOD_CHAIR = 5196
    ASH_WOOD_CHANDELIER = 5197
    ASH_WOOD_CHEST = 5198
    ASH_WOOD_CLOCK = 5199
    ASH_WOOD_DOOR = 5200
    ASH_WOOD_LAMP = 5201
    ASH_WOOD_LANTERN = 5202
    ASH_WOOD_PIANO = 5203
    ASH_WOOD_PLATFORM = 5204
    ASH_WOOD_SINK = 5205
    ASH_WOOD_SOFA = 5206
    ASH_WOOD_TABLE = 5207
    ASH_WOOD_WORKBENCH = 5208
    FAKE_ASH_WOOD_CHEST = 5209
    ASH_WOOD_TOILET = 5210
    BIOME_SIGHT_POTION = 5211
    SCARLET_MACAW = 5212
    SCARLET_MACAW_CAGE = 5213
    ASH_GRASS_SEEDS = 5214
    ASH_WOOD = 5215
    ASH_WOOD_WALL = 5216
    ASH_WOOD_FENCE = 5217
    OUTCAST = 5218
    FAIRY_GUIDES = 5219
    AHORRIBLE_NIGHTFOR_ALCHEMY = 5220
    MORNING_HUNT = 5221
    SUSPICIOUSLY_SPARKLY = 5222
    REQUIEM = 5223
    CAT_SWORD = 5224
    KARGOHS_SUMMON = 5225
    HIGH_PITCH = 5226
    AMACHINEFOR_TERRARIANS = 5227
    TERRA_BLADE_CHRONICLES = 5228
    BENNY_WARHOL = 5229
    LIZARD_KING = 5230
    MY_SON = 5231
    DUALITY = 5232
    PARSEC_PALS = 5233
    REMNANTSOF_DEVOTION = 5234
    NOT_SO_LOST_IN_PARADISE = 5235
    OCULAR_RESONANCE = 5236
    WINGSOF_EVIL = 5237
    CONSTELLATION = 5238
    EYEZORHEAD = 5239
    DREADOFTHE_RED_SEA = 5240
    DO_NOT_EATTHE_VILE_MUSHROOM = 5241
    YUUMA_THE_BLUE_TIGER = 5242
    MOONMANAND_COMPANY = 5243
    SUNSHINEOF_ISRAPONY = 5244
    PURITY = 5245
    SUFFICIENTLY_ADVANCED = 5246
    STRANGE_GROWTH = 5247
    HAPPY_LITTLE_TREE = 5248
    STRANGE_DEAD_FELLOWS = 5249
    SECRETS = 5250
    THUNDERBOLT = 5251
    CRUSTOGRAPHY = 5252
    THE_WEREWOLF = 5253
    BLESSINGFROM_THE_HEAVENS = 5254
    LOVEISINTHE_TRASH_SLOT = 5255
    FANGS = 5256
    HAILTOTHE_KING = 5257
    SEE_THE_WORLD_FOR_WHAT_IT_IS = 5258
    WHAT_LURKS_BELOW = 5259
    THIS_IS_GETTING_OUT_OF_HAND = 5260
    BUDDIES = 5261
    MIDNIGHT_SUN = 5262
    COUCH_GAG = 5263
    SILENT_FISH = 5264
    THE_DUKE = 5265
    ROYAL_ROMANCE = 5266
    BIOLUMINESCENCE = 5267
    WILDFLOWERS = 5268
    VIKING_VOYAGE = 5269
    BIFROST = 5270
    HEARTLANDS = 5271
    FOREST_TROLL = 5272
    AURORA_BOREALIS = 5273
    LADY_OF_THE_LAKE = 5274
    JOJA_COLA = 5275
    JUNIMO_PET_ITEM = 5276
    SPICY_PEPPER = 5277
    POMEGRANATE = 5278
    ASH_WOOD_HELMET = 5279
    ASH_WOOD_BREASTPLATE = 5280
    ASH_WOOD_GREAVES = 5281
    ASH_WOOD_BOW = 5282
    ASH_WOOD_HAMMER = 5283
    ASH_WOOD_SWORD = 5284
    MOON_GLOBE = 5285
    REPAIRED_LIFE_CRYSTAL = 5286
    REPAIRED_MANA_CRYSTAL = 5287
    TERRA_FART_MINECART = 5288
    MINECART_POWERUP = 5289
    JIMS_CAP = 5290
    ECHO_WALL = 5291
    ECHO_PLATFORM = 5292
    MUSHROOM_TORCH = 5293
    HIVE_FIVE = 5294
    ACORN_AXE = 5295
    CHLOROPHYTE_EXTRACTINATOR = 5296
    BLUE_EGG = 5297
    TRIMARANG = 5298
    MUSHROOM_CAMPFIRE = 5299
    BLUE_MACAW = 5300
    BLUE_MACAW_CAGE = 5301
    BOTTOMLESS_HONEY_BUCKET = 5302
    HONEY_ABSORBANT_SPONGE = 5303
    ULTRA_ABSORBANT_SPONGE = 5304
    GOBLORC_EAR = 5305
    REEF_BLOCK = 5306
    REEF_WALL = 5307
    PLACE_PAINTING = 5308
    DONT_HURT_NATURE_BOOK = 5309
    PRINCESS_STYLE = 5310
    TOUCAN = 5311
    YELLOW_COCKATIEL = 5312
    GRAY_COCKATIEL = 5313
    TOUCAN_CAGE = 5314
    YELLOW_COCKATIEL_CAGE = 5315
    GRAY_COCKATIEL_CAGE = 5316
    MACAW_STATUE = 5317
    TOUCAN_STATUE = 5318
    COCKATIEL_STATUE = 5319
    PLACEABLE_HEALING_POTION = 5320
    PLACEABLE_MANA_POTION = 5321
    SHADOW_CANDLE = 5322
    DONT_HURT_COMBO_BOOK = 5323
    RUBBLEMAKER_SMALL = 5324
    CLOSED_VOID_BAG = 5325
    ARTISAN_LOAF = 5326
    TNTBARREL = 5327
    CHEST_LOCK = 5328
    RUBBLEMAKER_MEDIUM = 5329
    RUBBLEMAKER_LARGE = 5330
    HORSESHOE_BUNDLE = 5331
    SPIFFO_PLUSH = 5332
    GLOW_TULIP = 5333
    MECHDUSA_SUMMON = 5334
    ROD_OF_HARMONY = 5335
    COMBAT_BOOK_VOLUME_TWO = 5336
    AEGIS_CRYSTAL = 5337
    AEGIS_FRUIT = 5338
    ARCANE_CRYSTAL = 5339
    GALAXY_PEARL = 5340
    GUMMY_WORM = 5341
    AMBROSIA = 5342
    PEDDLERS_SATCHEL = 5343
    ECHO_COATING = 5344
    ECHO_MONOLITH = 5345
    GAS_TRAP = 5346
    SHIMMER_MONOLITH = 5347
    SHIMMER_ARROW = 5348
    SHIMMER_BLOCK = 5349
    SHIMMERFLY = 5350
    SHIMMERFLYINA_BOTTLE = 5351
    SHIMMER_SLIME_BANNER = 5352
    SHIMMER_TORCH = 5353
    REFLECTIVE_SHADES = 5354
    SHIMMER_CLOAK = 5355
    USED_GAS_TRAP = 5356
    SHIMMER_CAMPFIRE = 5357
    SHELLPHONE = 5358
    SHELLPHONE_SPAWN = 5359
    SHELLPHONE_OCEAN = 5360
    SHELLPHONE_HELL = 5361
    MUSIC_BOX_SHIMMER = 5362
    SPIDER_WALL_UNSAFE = 5363
    BOTTOMLESS_SHIMMER_BUCKET = 5364
    BLUE_BRICK_WALL_UNSAFE = 5365
    BLUE_SLAB_WALL_UNSAFE = 5366
    BLUE_TILED_WALL_UNSAFE = 5367
    PINK_BRICK_WALL_UNSAFE = 5368
    PINK_SLAB_WALL_UNSAFE = 5369
    PINK_TILED_WALL_UNSAFE = 5370
    GREEN_BRICK_WALL_UNSAFE = 5371
    GREEN_SLAB_WALL_UNSAFE = 5372
    GREEN_TILED_WALL_UNSAFE = 5373
    SANDSTONE_WALL_UNSAFE = 5374
    HARDENED_SAND_WALL_UNSAFE = 5375
    LIHZAHRD_WALL_UNSAFE = 5376
    SPELUNKER_FLARE = 5377
    CURSED_FLARE = 5378
    RAINBOW_FLARE = 5379
    SHIMMER_FLARE = 5380
    MOONDIAL = 5381
    WAFFLE_IRON = 5382
    BOUNCY_BOULDER = 5383
    LIFE_CRYSTAL_BOULDER = 5384
    DIZZY_HAT = 5385
    LINCOLNS_HOODIE = 5386
    LINCOLNS_PANTS = 5387
    SUN_ORNAMENT = 5388
    HOPLITE_PIZZA = 5389
    LINCOLNS_HOOD = 5390
    UNCUMBERING_STONE = 5391
    SAND_SOLUTION = 5392
    SNOW_SOLUTION = 5393
    DIRT_SOLUTION = 5394
    POOP_BLOCK = 5395
    POOP_WALL = 5396
    SHIMMER_WALL = 5397
    SHIMMER_BRICK = 5398
    SHIMMER_BRICK_WALL = 5399
    DIRTIEST_BLOCK = 5400
    LUNAR_RUST_BRICK = 5401
    DARK_CELESTIAL_BRICK = 5402
    ASTRA_BRICK = 5403
    COSMIC_EMBER_BRICK = 5404
    CRYOCORE_BRICK = 5405
    MERCURY_BRICK = 5406
    STAR_ROYALE_BRICK = 5407
    HEAVENFORGE_BRICK = 5408
    LUNAR_RUST_BRICK_WALL = 5409
    DARK_CELESTIAL_BRICK_WALL = 5410
    ASTRA_BRICK_WALL = 5411
    COSMIC_EMBER_BRICK_WALL = 5412
    CRYOCORE_BRICK_WALL = 5413
    MERCURY_BRICK_WALL = 5414
    STAR_ROYALE_BRICK_WALL = 5415
    HEAVENFORGE_BRICK_WALL = 5416
    ANCIENT_BLUE_DUNGEON_BRICK = 5417
    ANCIENT_BLUE_DUNGEON_BRICK_WALL = 5418
    ANCIENT_GREEN_DUNGEON_BRICK = 5419
    ANCIENT_GREEN_DUNGEON_BRICK_WALL = 5420
    ANCIENT_PINK_DUNGEON_BRICK = 5421
    ANCIENT_PINK_DUNGEON_BRICK_WALL = 5422
    ANCIENT_GOLD_BRICK = 5423
    ANCIENT_GOLD_BRICK_WALL = 5424
    ANCIENT_SILVER_BRICK = 5425
    ANCIENT_SILVER_BRICK_WALL = 5426
    ANCIENT_COPPER_BRICK = 5427
    ANCIENT_COPPER_BRICK_WALL = 5428
    ANCIENT_COBALT_BRICK = 5429
    ANCIENT_COBALT_BRICK_WALL = 5430
    ANCIENT_MYTHRIL_BRICK = 5431
    ANCIENT_MYTHRIL_BRICK_WALL = 5432
    ANCIENT_OBSIDIAN_BRICK = 5433
    ANCIENT_OBSIDIAN_BRICK_WALL = 5434
    ANCIENT_HELLSTONE_BRICK = 5435
    ANCIENT_HELLSTONE_BRICK_WALL = 5436
    SHELLPHONE_DUMMY = 5437
    FERTILIZER = 5438
    LAVA_MOSS_BLOCK = 5439
    ARGON_MOSS_BLOCK = 5440
    KRYPTON_MOSS_BLOCK = 5441
    XENON_MOSS_BLOCK = 5442
    VIOLET_MOSS_BLOCK = 5443
    RAINBOW_MOSS_BLOCK = 5444
    LAVA_MOSS_BLOCK_WALL = 5445
    ARGON_MOSS_BLOCK_WALL = 5446
    KRYPTON_MOSS_BLOCK_WALL = 5447
    XENON_MOSS_BLOCK_WALL = 5448
    VIOLET_MOSS_BLOCK_WALL = 5449
    RAINBOW_MOSS_BLOCK_WALL = 5450
    JIMS_DRONE = 5451
    JIMS_DRONE_VISOR = 5452

    def __repr__(self):
        return f"{self.__class__.__name__}.{self.name}"
