'''
exceptions.py: exceptions defined by Zoinks

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2022 by Michael Hucka and the California Institute of Technology.
This code is open-source software released under a 3-clause BSD license.
Please see the file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish between
# exceptions generated by Zoinks and exceptions generated by something else.

class ZoinksException(Exception):
    '''Base class for Zoinks exceptions.'''
    pass


# Exception classes.
# .............................................................................

class ConnectionFailure(ZoinksException):
    '''Unrecoverable problem involving network operations.'''
    pass

class ZoinksError(ZoinksException):
    '''Unrecoverable problem involving Zoinks itself.'''
    pass
