"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from lob_python.exceptions import ApiAttributeError

from lob_python.model.city import City
from lob_python.model.state import State
from lob_python.model.zip_code_plus4 import ZipCodePlus4
from lob_python.model.zip_code_type import ZipCodeType
globals()['City'] = City
globals()['State'] = State
globals()['ZipCodePlus4'] = ZipCodePlus4
globals()['ZipCodeType'] = ZipCodeType


class UsComponents(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('street_predirection',): {
            'N': "N",
            'S': "S",
            'E': "E",
            'W': "W",
            'NE': "NE",
            'SW': "SW",
            'SE': "SE",
            'NW': "NW",
            'EMPTY': "",
        },
        ('street_postdirection',): {
            'N': "N",
            'S': "S",
            'E': "E",
            'W': "W",
            'NE': "NE",
            'SW': "SW",
            'SE': "SE",
            'NW': "NW",
            'EMPTY': "",
        },
        ('address_type',): {
            'RESIDENTIAL': "residential",
            'COMMERCIAL': "commercial",
            'EMPTY': "",
        },
        ('record_type',): {
            'STREET': "street",
            'HIGHRISE': "highrise",
            'FIRM': "firm",
            'PO_BOX': "po_box",
            'RURAL_ROUTE': "rural_route",
            'GENERAL_DELIVERY': "general_delivery",
            'EMPTY': "",
        },
        ('carrier_route_type',): {
            'CITY_DELIVERY': "city_delivery",
            'RURAL_ROUTE': "rural_route",
            'HIGHWAY_CONTRACT': "highway_contract",
            'PO_BOX': "po_box",
            'GENERAL_DELIVERY': "general_delivery",
            'EMPTY': "",
        },
    }

    validations = {
        ('zip_code',): {
            'regex': {
                'pattern': r'^\d{5}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'primary_number': (str,),  # noqa: E501
            'street_predirection': (str,),  # noqa: E501
            'street_name': (str,),  # noqa: E501
            'street_suffix': (str,),  # noqa: E501
            'street_postdirection': (str,),  # noqa: E501
            'secondary_designator': (str,),  # noqa: E501
            'secondary_number': (str,),  # noqa: E501
            'pmb_designator': (str,),  # noqa: E501
            'pmb_number': (str,),  # noqa: E501
            'extra_secondary_designator': (str,),  # noqa: E501
            'extra_secondary_number': (str,),  # noqa: E501
            'city': (str,),  # noqa: E501
            'state': (str,),  # noqa: E501
            'zip_code': (str,),  # noqa: E501
            'zip_code_plus_4': (str,),  # noqa: E501
            'zip_code_type': (ZipCodeType,),  # noqa: E501
            'delivery_point_barcode': (str,),  # noqa: E501
            'address_type': (str,),  # noqa: E501
            'record_type': (str,),  # noqa: E501
            'default_building_address': (bool,),  # noqa: E501
            'county': (str,),  # noqa: E501
            'county_fips': (str,),  # noqa: E501
            'carrier_route': (str,),  # noqa: E501
            'carrier_route_type': (str,),  # noqa: E501
            'latitude': (float, type(None)),  # noqa: E501
            'longitude': (float, type(None)),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'primary_number': 'primary_number',  # noqa: E501
        'street_predirection': 'street_predirection',  # noqa: E501
        'street_name': 'street_name',  # noqa: E501
        'street_suffix': 'street_suffix',  # noqa: E501
        'street_postdirection': 'street_postdirection',  # noqa: E501
        'secondary_designator': 'secondary_designator',  # noqa: E501
        'secondary_number': 'secondary_number',  # noqa: E501
        'pmb_designator': 'pmb_designator',  # noqa: E501
        'pmb_number': 'pmb_number',  # noqa: E501
        'extra_secondary_designator': 'extra_secondary_designator',  # noqa: E501
        'extra_secondary_number': 'extra_secondary_number',  # noqa: E501
        'city': 'city',  # noqa: E501
        'state': 'state',  # noqa: E501
        'zip_code': 'zip_code',  # noqa: E501
        'zip_code_plus_4': 'zip_code_plus_4',  # noqa: E501
        'zip_code_type': 'zip_code_type',  # noqa: E501
        'delivery_point_barcode': 'delivery_point_barcode',  # noqa: E501
        'address_type': 'address_type',  # noqa: E501
        'record_type': 'record_type',  # noqa: E501
        'default_building_address': 'default_building_address',  # noqa: E501
        'county': 'county',  # noqa: E501
        'county_fips': 'county_fips',  # noqa: E501
        'carrier_route': 'carrier_route',  # noqa: E501
        'carrier_route_type': 'carrier_route_type',  # noqa: E501
        'latitude': 'latitude',  # noqa: E501
        'longitude': 'longitude',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, primary_number, street_predirection, street_name, street_suffix, street_postdirection, secondary_designator, secondary_number, pmb_designator, pmb_number, extra_secondary_designator, extra_secondary_number, city, state, zip_code, zip_code_plus_4, zip_code_type, delivery_point_barcode, address_type, record_type, default_building_address, county, county_fips, carrier_route, carrier_route_type, *args, **kwargs):  # noqa: E501
        """UsComponents - a model defined in OpenAPI

        Args:
            primary_number (str): The numeric or alphanumeric part of an address preceding the street name. Often the house, building, or PO Box number.
            street_predirection (str): Geographic direction preceding a street name (`N`, `S`, `E`, `W`, `NE`, `SW`, `SE`, `NW`). 
            street_name (str): The name of the street.
            street_suffix (str): The standard USPS abbreviation for the street suffix (`ST`, `AVE`, `BLVD`, etc). 
            street_postdirection (str): Geographic direction following a street name (`N`, `S`, `E`, `W`, `NE`, `SW`, `SE`, `NW`). 
            secondary_designator (str): The standard USPS abbreviation describing the `components[secondary_number]` (`STE`, `APT`, `BLDG`, etc). 
            secondary_number (str): Number of the apartment/unit/etc. 
            pmb_designator (str): Designator of a [CMRA-authorized](https://en.wikipedia.org/wiki/Commercial_mail_receiving_agency) private mailbox. 
            pmb_number (str): Number of a [CMRA-authorized](https://en.wikipedia.org/wiki/Commercial_mail_receiving_agency) private mailbox. 
            extra_secondary_designator (str): An extra (often unnecessary) secondary designator provided with the input address. 
            extra_secondary_number (str): An extra (often unnecessary) secondary number provided with the input address. 
            city (str):
            state (str):
            zip_code (str): The 5-digit ZIP code
            zip_code_plus_4 (str):
            zip_code_type (ZipCodeType):
            delivery_point_barcode (str): A 12-digit identifier that uniquely identifies a delivery point (location where mail can be sent and received). It consists of the 5-digit ZIP code (`zip_code`), 4-digit ZIP+4 add-on (`zip_code_plus_4`), 2-digit delivery point, and 1-digit delivery point check digit. 
            address_type (str): Uses USPS's [Residential Delivery Indicator (RDI)](https://www.usps.com/nationalpremieraccounts/rdi.htm) to identify whether an address is classified as residential or business. Possible values are: * `residential` –– The address is residential or a PO Box. * `commercial` –– The address is commercial. * `''` –– Not enough information provided to be determined. 
            record_type (str): A description of the type of address. Populated if a DPV match is made (`deliverability_analysis[dpv_confirmation]` is `Y`, `S`, or `D`). For more detailed information about each record type, see [US Verification Details](#tag/US-Verification-Types). 
            default_building_address (bool): Designates whether or not the address is the default address for a building containing multiple delivery points. 
            county (str): County name of the address city.
            county_fips (str): A 5-digit [FIPS county code](https://en.wikipedia.org/wiki/FIPS_county_code) which uniquely identifies `components[county]`. It consists of a 2-digit state code and a 3-digit county code. 
            carrier_route (str): A 4-character code assigned to a mail delivery route within a ZIP code. 
            carrier_route_type (str): The type of `components[carrier_route]`. For more detailed information about each carrier route type, see [US Verification Details](#tag/US-Verification-Types). 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            latitude (float, type(None)): A positive or negative decimal indicating the geographic latitude of the address, specifying the north-to-south position of a location. This should be used with `longitude` to pinpoint locations on a map. Will not be returned for undeliverable addresses or military addresses (state is `AA`, `AE`, or `AP`). . [optional] # noqa: E501
            longitude (float, type(None)): A positive or negative decimal indicating the geographic longitude of the address, specifying the north-to-south position of a location. This should be used with `latitude` to pinpoint locations on a map. Will not be returned for undeliverable addresses or military addresses (state is `AA`, `AE`, or `AP`). . [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.primary_number = primary_number
        self.street_predirection = street_predirection
        self.street_name = street_name
        self.street_suffix = street_suffix
        self.street_postdirection = street_postdirection
        self.secondary_designator = secondary_designator
        self.secondary_number = secondary_number
        self.pmb_designator = pmb_designator
        self.pmb_number = pmb_number
        self.extra_secondary_designator = extra_secondary_designator
        self.extra_secondary_number = extra_secondary_number
        self.city = city
        self.state = state
        self.zip_code = zip_code
        self.zip_code_plus_4 = zip_code_plus_4
        self.zip_code_type = zip_code_type
        self.delivery_point_barcode = delivery_point_barcode
        self.address_type = address_type
        self.record_type = record_type
        self.default_building_address = default_building_address
        self.county = county
        self.county_fips = county_fips
        self.carrier_route = carrier_route
        self.carrier_route_type = carrier_route_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, primary_number, street_predirection, street_name, street_suffix, street_postdirection, secondary_designator, secondary_number, pmb_designator, pmb_number, extra_secondary_designator, extra_secondary_number, city, state, zip_code, zip_code_plus_4, zip_code_type, delivery_point_barcode, address_type, record_type, default_building_address, county, county_fips, carrier_route, carrier_route_type, *args, **kwargs):  # noqa: E501
        """UsComponents - a model defined in OpenAPI

        Args:
            primary_number (str): The numeric or alphanumeric part of an address preceding the street name. Often the house, building, or PO Box number.
            street_predirection (str): Geographic direction preceding a street name (`N`, `S`, `E`, `W`, `NE`, `SW`, `SE`, `NW`). 
            street_name (str): The name of the street.
            street_suffix (str): The standard USPS abbreviation for the street suffix (`ST`, `AVE`, `BLVD`, etc). 
            street_postdirection (str): Geographic direction following a street name (`N`, `S`, `E`, `W`, `NE`, `SW`, `SE`, `NW`). 
            secondary_designator (str): The standard USPS abbreviation describing the `components[secondary_number]` (`STE`, `APT`, `BLDG`, etc). 
            secondary_number (str): Number of the apartment/unit/etc. 
            pmb_designator (str): Designator of a [CMRA-authorized](https://en.wikipedia.org/wiki/Commercial_mail_receiving_agency) private mailbox. 
            pmb_number (str): Number of a [CMRA-authorized](https://en.wikipedia.org/wiki/Commercial_mail_receiving_agency) private mailbox. 
            extra_secondary_designator (str): An extra (often unnecessary) secondary designator provided with the input address. 
            extra_secondary_number (str): An extra (often unnecessary) secondary number provided with the input address. 
            city (City):
            state (State):
            zip_code (str): The 5-digit ZIP code
            zip_code_plus_4 (ZipCodePlus4):
            zip_code_type (ZipCodeType):
            delivery_point_barcode (str): A 12-digit identifier that uniquely identifies a delivery point (location where mail can be sent and received). It consists of the 5-digit ZIP code (`zip_code`), 4-digit ZIP+4 add-on (`zip_code_plus_4`), 2-digit delivery point, and 1-digit delivery point check digit. 
            address_type (str): Uses USPS's [Residential Delivery Indicator (RDI)](https://www.usps.com/nationalpremieraccounts/rdi.htm) to identify whether an address is classified as residential or business. Possible values are: * `residential` –– The address is residential or a PO Box. * `commercial` –– The address is commercial. * `''` –– Not enough information provided to be determined. 
            record_type (str): A description of the type of address. Populated if a DPV match is made (`deliverability_analysis[dpv_confirmation]` is `Y`, `S`, or `D`). For more detailed information about each record type, see [US Verification Details](#tag/US-Verification-Types). 
            default_building_address (bool): Designates whether or not the address is the default address for a building containing multiple delivery points. 
            county (str): County name of the address city.
            county_fips (str): A 5-digit [FIPS county code](https://en.wikipedia.org/wiki/FIPS_county_code) which uniquely identifies `components[county]`. It consists of a 2-digit state code and a 3-digit county code. 
            carrier_route (str): A 4-character code assigned to a mail delivery route within a ZIP code. 
            carrier_route_type (str): The type of `components[carrier_route]`. For more detailed information about each carrier route type, see [US Verification Details](#tag/US-Verification-Types). 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            latitude (float, type(None)): A positive or negative decimal indicating the geographic latitude of the address, specifying the north-to-south position of a location. This should be used with `longitude` to pinpoint locations on a map. Will not be returned for undeliverable addresses or military addresses (state is `AA`, `AE`, or `AP`). . [optional] # noqa: E501
            longitude (float, type(None)): A positive or negative decimal indicating the geographic longitude of the address, specifying the north-to-south position of a location. This should be used with `latitude` to pinpoint locations on a map. Will not be returned for undeliverable addresses or military addresses (state is `AA`, `AE`, or `AP`). . [optional] # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.primary_number = primary_number
        self.street_predirection = street_predirection
        self.street_name = street_name
        self.street_suffix = street_suffix
        self.street_postdirection = street_postdirection
        self.secondary_designator = secondary_designator
        self.secondary_number = secondary_number
        self.pmb_designator = pmb_designator
        self.pmb_number = pmb_number
        self.extra_secondary_designator = extra_secondary_designator
        self.extra_secondary_number = extra_secondary_number
        self.city = city
        self.state = state
        self.zip_code = zip_code
        self.zip_code_plus_4 = zip_code_plus_4
        self.zip_code_type = zip_code_type
        self.delivery_point_barcode = delivery_point_barcode
        self.address_type = address_type
        self.record_type = record_type
        self.default_building_address = default_building_address
        self.county = county
        self.county_fips = county_fips
        self.carrier_route = carrier_route
        self.carrier_route_type = carrier_route_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
