"""
    Lob

    The Lob API is organized around REST. Our API is designed to have predictable, resource-oriented URLs and uses HTTP response codes to indicate any API errors. <p> Looking for our [previous documentation](https://lob.github.io/legacy-docs/)?   # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: lob-openapi@lob.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lob_python.api_client import ApiClient, Endpoint as _Endpoint
from lob_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lob_python.model.include_model import IncludeModel
from lob_python.model.lob_error import LobError
from lob_python.model.template_version import TemplateVersion
from lob_python.model.template_version_deletion import TemplateVersionDeletion
from lob_python.model.template_version_list import TemplateVersionList
from lob_python.model.template_version_updatable import TemplateVersionUpdatable
from lob_python.model.template_version_writable import TemplateVersionWritable
from lob_python.model.tmpl_id import TmplId
from lob_python.model.vrsn_id import VrsnId


class TemplateVersionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_endpoint = _Endpoint(
            settings={
                'response_type': (TemplateVersion,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/templates/{tmpl_id}/versions',
                'operation_id': 'create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tmpl_id',
                    'template_version_writable',
                ],
                'required': [
                    'tmpl_id',
                    'template_version_writable',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tmpl_id':
                        (TmplId,),
                    'template_version_writable':
                        (TemplateVersionWritable,),
                },
                'attribute_map': {
                    'tmpl_id': 'tmpl_id',
                },
                'location_map': {
                    'tmpl_id': 'path',
                    'template_version_writable': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.delete_endpoint = _Endpoint(
            settings={
                'response_type': (TemplateVersionDeletion,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/templates/{tmpl_id}/versions/{vrsn_id}',
                'operation_id': 'delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'tmpl_id',
                    'vrsn_id',
                ],
                'required': [
                    'tmpl_id',
                    'vrsn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tmpl_id':
                        (TmplId,),
                    'vrsn_id':
                        (VrsnId,),
                },
                'attribute_map': {
                    'tmpl_id': 'tmpl_id',
                    'vrsn_id': 'vrsn_id',
                },
                'location_map': {
                    'tmpl_id': 'path',
                    'vrsn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_endpoint = _Endpoint(
            settings={
                'response_type': (TemplateVersion,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/templates/{tmpl_id}/versions/{vrsn_id}',
                'operation_id': 'get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tmpl_id',
                    'vrsn_id',
                ],
                'required': [
                    'tmpl_id',
                    'vrsn_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tmpl_id':
                        (TmplId,),
                    'vrsn_id':
                        (VrsnId,),
                },
                'attribute_map': {
                    'tmpl_id': 'tmpl_id',
                    'vrsn_id': 'vrsn_id',
                },
                'location_map': {
                    'tmpl_id': 'path',
                    'vrsn_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_endpoint = _Endpoint(
            settings={
                'response_type': (TemplateVersion,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/templates/{tmpl_id}/versions/{vrsn_id}',
                'operation_id': 'update',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'tmpl_id',
                    'vrsn_id',
                    'template_version_updatable',
                ],
                'required': [
                    'tmpl_id',
                    'vrsn_id',
                    'template_version_updatable',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tmpl_id':
                        (TmplId,),
                    'vrsn_id':
                        (VrsnId,),
                    'template_version_updatable':
                        (TemplateVersionUpdatable,),
                },
                'attribute_map': {
                    'tmpl_id': 'tmpl_id',
                    'vrsn_id': 'vrsn_id',
                },
                'location_map': {
                    'tmpl_id': 'path',
                    'vrsn_id': 'path',
                    'template_version_updatable': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_type': (TemplateVersionList,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/templates/{tmpl_id}/versions',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tmpl_id',
                    'limit',
                    'before',
                    'after',
                    'include',
                    'date_created',
                ],
                'required': [
                    'tmpl_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tmpl_id':
                        (TmplId,),
                    'limit':
                        (int,),
                    'before':
                        (str,),
                    'after':
                        (str,),
                    'include':
                        (IncludeModel,),
                    'date_created':
                        ({str: (datetime,)},),
                },
                'attribute_map': {
                    'tmpl_id': 'tmpl_id',
                    'limit': 'limit',
                    'before': 'before',
                    'after': 'after',
                    'include': 'include',
                    'date_created': 'date_created',
                },
                'location_map': {
                    'tmpl_id': 'path',
                    'limit': 'query',
                    'before': 'query',
                    'after': 'query',
                    'include': 'query',
                    'date_created': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create(
        self,
        tmpl_id,
        template_version_writable,
        **kwargs
    ):
        """create  # noqa: E501

        Creates a new template version attached to the specified template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create(tmpl_id, template_version_writable, async_req=True)
        >>> result = thread.get()

        Args:
            tmpl_id (TmplId): The ID of the template the new version will be attached to
            template_version_writable (TemplateVersionWritable):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TemplateVersion
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tmpl_id'] = \
            tmpl_id
        kwargs['template_version_writable'] = \
            template_version_writable
        return self.create_endpoint.call_with_http_info(**kwargs)

    def delete(
        self,
        tmpl_id,
        vrsn_id,
        **kwargs
    ):
        """delete  # noqa: E501

        Permanently deletes a template version. A template's `published_version` can not be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete(tmpl_id, vrsn_id, async_req=True)
        >>> result = thread.get()

        Args:
            tmpl_id (TmplId): The ID of the template to which the version belongs.
            vrsn_id (VrsnId): id of the template_version

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TemplateVersionDeletion
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tmpl_id'] = \
            tmpl_id
        kwargs['vrsn_id'] = \
            vrsn_id
        return self.delete_endpoint.call_with_http_info(**kwargs)

    def get(
        self,
        tmpl_id,
        vrsn_id,
        **kwargs
    ):
        """get  # noqa: E501

        Retrieves the template version with the given template and version ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get(tmpl_id, vrsn_id, async_req=True)
        >>> result = thread.get()

        Args:
            tmpl_id (TmplId): The ID of the template to which the version belongs.
            vrsn_id (VrsnId): id of the template_version

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TemplateVersion
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tmpl_id'] = \
            tmpl_id
        kwargs['vrsn_id'] = \
            vrsn_id
        return self.get_endpoint.call_with_http_info(**kwargs)

    def update(
        self,
        tmpl_id,
        vrsn_id,
        template_version_updatable,
        **kwargs
    ):
        """update  # noqa: E501

        Updates the template version with the given template and version ids.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update(tmpl_id, vrsn_id, template_version_updatable, async_req=True)
        >>> result = thread.get()

        Args:
            tmpl_id (TmplId): The ID of the template to which the version belongs.
            vrsn_id (VrsnId): id of the template_version
            template_version_updatable (TemplateVersionUpdatable):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TemplateVersion
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tmpl_id'] = \
            tmpl_id
        kwargs['vrsn_id'] = \
            vrsn_id
        kwargs['template_version_updatable'] = \
            template_version_updatable
        return self.update_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        tmpl_id,
        **kwargs
    ):
        """list  # noqa: E501

        Returns a list of template versions for the given template ID. The template versions are sorted by creation date, with the most recently created appearing first.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list(tmpl_id, async_req=True)
        >>> result = thread.get()

        Args:
            tmpl_id (TmplId): The ID of the template associated with the retrieved versions

        Keyword Args:
            limit (int): How many results to return.. [optional] if omitted the server will use the default value of 10
            before (str): A reference to a list entry used for paginating to the previous set of entries. This field is pre-populated in the `previous_url` field in the return response. . [optional]
            after (str): A reference to a list entry used for paginating to the next set of entries. This field is pre-populated in the `next_url` field in the return response. . [optional]
            include (IncludeModel): Request that the response include the total count by specifying `include[]=total_count`. . [optional]
            date_created ({str: (datetime,)}): Filter by date created.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TemplateVersionList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tmpl_id'] = \
            tmpl_id
        return self.list_endpoint.call_with_http_info(**kwargs)

