## InstructLab CLI reference

This reference provides descriptions and examples for the InstructLab CLI (`ilab`) commands.

> [!NOTE]
> To view all the available flags for each command group, use the `--help`tag after the command.

### ilab config

Command Group for Interacting with the configuration of InstructLab

#### ilab config init

Initializes environment for InstructLab

### ilab data

Command Group for Interacting with the data generated by InstructLab

#### ilab data generate

Runs the synthetic data generation (SDG) process for {ilab-title}

### ilab model

Command Group for Interacting with the models in InstructLab

#### ilab model chat

Run a chat using the modified model

#### ilab model convert

Converts model to a GGUF file

#### ilab model download

Downloads the model(s)

#### ilab model train

Runs the training process on the model

#### ilab model serve

Serves the model

### ilab taxonomy

Command Group for Interacting with the taxonomy path of InstructLab

#### ilab taxonomy diff

Lists taxonomy files that you changed and verifies that the taxonomy is valid