from ormar.exceptions import ModelDefinitionError, ModelNotSet, MultipleMatches, NoMatch
from ormar.protocols import QuerySetProtocol, RelationProtocol  # noqa: I100
from ormar.fields import (  # noqa: I100
    BigInteger,
    Boolean,
    Date,
    DateTime,
    Decimal,
    Float,
    ForeignKey,
    Integer,
    JSON,
    ManyToMany,
    String,
    Text,
    Time,
    UUID,
    UniqueColumns,
)
from ormar.models import Model
from ormar.models.metaclass import ModelMeta
from ormar.queryset import QuerySet
from ormar.relations import RelationType


class UndefinedType:  # pragma no cover
    def __repr__(self) -> str:
        return "OrmarUndefined"


Undefined = UndefinedType()

__version__ = "0.5.4"
__all__ = [
    "Integer",
    "BigInteger",
    "Boolean",
    "Time",
    "Text",
    "String",
    "JSON",
    "DateTime",
    "Date",
    "Decimal",
    "Float",
    "ManyToMany",
    "Model",
    "ModelDefinitionError",
    "ModelNotSet",
    "MultipleMatches",
    "NoMatch",
    "ForeignKey",
    "QuerySet",
    "RelationType",
    "Undefined",
    "UUID",
    "UniqueColumns",
    "QuerySetProtocol",
    "RelationProtocol",
    "ModelMeta",
]
