"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotRepublishMqttAction = exports.MqttQualityOfService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * MQTT Quality of Service (QoS) indicates the level of assurance for delivery of an MQTT Message.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html#mqtt-qos
 */
var MqttQualityOfService;
(function (MqttQualityOfService) {
    /**
     * QoS level 0. Sent zero or more times.
     * This level should be used for messages that are sent over reliable communication links or that can be missed without a problem.
     */
    MqttQualityOfService[MqttQualityOfService["ZERO_OR_MORE_TIMES"] = 0] = "ZERO_OR_MORE_TIMES";
    /**
     * QoS level 1. Sent at least one time, and then repeatedly until a PUBACK response is received.
     * The message is not considered complete until the sender receives a PUBACK response to indicate successful delivery.
     */
    MqttQualityOfService[MqttQualityOfService["AT_LEAST_ONCE"] = 1] = "AT_LEAST_ONCE";
})(MqttQualityOfService = exports.MqttQualityOfService || (exports.MqttQualityOfService = {}));
/**
 * The action to put the record from an MQTT message to republish another MQTT topic.
 */
class IotRepublishMqttAction {
    /**
     * @param topic The MQTT topic to which to republish the message.
     * @param props Optional properties to not use default.
     */
    constructor(topic, props = {}) {
        this.topic = topic;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_IotRepublishMqttActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IotRepublishMqttAction);
            }
            throw error;
        }
        this.qualityOfService = props.qualityOfService;
        this.role = props.role;
    }
    bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['iot:Publish'],
            resources: ['*'],
        }));
        return {
            configuration: {
                republish: {
                    topic: this.topic,
                    qos: this.qualityOfService,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.IotRepublishMqttAction = IotRepublishMqttAction;
_a = JSII_RTTI_SYMBOL_1;
IotRepublishMqttAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.IotRepublishMqttAction", version: "2.32.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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