/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.ArrayList;
import java.util.List;
import org.jmol.minimize.MinBond;
import org.jmol.modelset.Atom;

public class MinAtom {
    int index;
    public Atom atom;
    public double[] coord = new double[3];
    public double[] force = new double[3];
    public List<MinBond> bonds = new ArrayList<MinBond>();
    public int nBonds;
    public int hCount;
    public String type;
    int[] bondedAtoms;

    public String toString() {
        return "#" + this.index + " " + this.type;
    }

    MinAtom(int n, Atom atom, double[] dArray, String string) {
        this.index = n;
        this.atom = atom;
        this.coord = dArray;
        this.type = string;
        this.hCount = atom.getCovalentHydrogenCount();
    }

    void set() {
        this.coord[0] = this.atom.x;
        this.coord[1] = this.atom.y;
        this.coord[2] = this.atom.z;
    }

    public MinBond getBondTo(int n) {
        this.getBondedAtomIndexes();
        for (int i = 0; i < this.nBonds; ++i) {
            if (this.bondedAtoms[i] != n) continue;
            return this.bonds.get(i);
        }
        return null;
    }

    public int[] getBondedAtomIndexes() {
        if (this.bondedAtoms == null) {
            this.bondedAtoms = new int[this.nBonds];
            int n = this.nBonds;
            while (--n >= 0) {
                this.bondedAtoms[n] = this.bonds.get(n).getOtherAtom(this.index);
            }
        }
        return this.bondedAtoms;
    }

    public String getIdentity() {
        return this.atom.getInfo();
    }
}

