/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementPending;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.Token;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;
import org.jmol.viewer.binding.DragBinding;
import org.jmol.viewer.binding.JmolBinding;
import org.jmol.viewer.binding.PfaatBinding;
import org.jmol.viewer.binding.RasmolBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager {
    private static final String[] actionInfo = new String[]{GT._("center"), GT._("translate"), GT._("rotate"), GT._("rotate Z"), GT._("rotate Z (horizontal motion of mouse) or zoom (vertical motion of mouse)"), GT._("zoom"), GT._("zoom (along right edge of window)"), GT._("translate navigation point (requires {0} and {1})", new String[]{"set NAVIGATIONMODE", "set picking NAVIGATE"}), GT._("spin model (swipe and release button and stop motion simultaneously)"), GT._("click on two points to spin around axis clockwise (requires {0})", "set picking SPIN"), GT._("click on two points to spin around axis counterclockwise (requires {0})", "set picking SPIN"), GT._("adjust slab (front plane; requires {0})", "SLAB ON"), GT._("adjust depth (back plane; requires {0})", "SLAB ON"), GT._("move slab/depth window (both planes; requires {0})", "SLAB ON"), GT._("pop up the full context menu"), GT._("pop up recent context menu (click on Jmol frank)"), GT._("select an atom (requires {0})", "set pickingStyle EXTENDEDSELECT"), GT._("select NONE (requires {0})", "set pickingStyle EXTENDEDSELECT"), GT._("toggle selection (requires {0})", "set pickingStyle DRAG/EXTENDEDSELECT/RASMOL"), GT._("unselect this group of atoms (requires {0})", "set pickingStyle DRAG/EXTENDEDSELECT"), GT._("add this group of atoms to the set of selected atoms (requires {0})", "set pickingStyle DRAG/EXTENDEDSELECT"), GT._("if all are selected, unselect all, otherwise add this group of atoms to the set of selected atoms (requires {0})", "set pickingStyle DRAG"), GT._("move selected atoms (requires {0})", "set DRAGSELECTED"), GT._("select and drag atoms (requires {0})", "set DRAGSELECTED"), GT._("rotate selected atoms (requires {0})", "set DRAGSELECTED"), GT._("rotate branch around bond (requires {0})", "set picking ROTATEBOND"), GT._("move atom (requires {0})", "set picking DRAGATOM"), GT._("move atom and minimize molecule (requires {0})", "set picking DRAGMINIMIZE"), GT._("move and minimize molecule (requires {0})", "set picking DRAGMINIMIZEMOLECULE"), GT._("move label (requires {0})", "set picking LABEL"), GT._("move specific DRAW point (requires {0})", "set picking DRAW"), GT._("move whole DRAW object (requires {0})", "set picking DRAW"), GT._("pick an atom"), GT._("pick a DRAW point (for measurements) (requires {0}", "set DRAWPICKING"), GT._("pick a label to toggle it hidden/displayed (requires {0})", "set picking LABEL"), GT._("pick an atom to include it in a measurement (after starting a measurement or after {0})", "set picking DISTANCE/ANGLE/TORSION"), GT._("pick an atom to initiate or conclude a measurement"), GT._("pick an ISOSURFACE point (requires {0}", "set DRAWPICKING"), GT._("pick a point or atom to navigate to (requires {0})", "set NAVIGATIONMODE"), GT._("delete atom (requires {0})", "set picking DELETE ATOM"), GT._("delete bond (requires {0})", "set picking DELETE BOND"), GT._("connect atoms (requires {0})", "set picking CONNECT"), GT._("assign/new atom or bond (requires {0})", "set picking assignAtom_??/assignBond_?"), GT._("reset (when clicked off the model)"), GT._("stop motion (requires {0})", "set waitForMoveTo FALSE"), GT._("simulate multi-touch using the mouse)")};
    private static final String[] actionNames = new String[]{"_center", "_translate", "_rotate", "_rotateZ", "_rotateZorZoom", "_wheelZoom", "_slideZoom", "_navTranslate", "_swipe", "_spinDrawObjectCW", "_spinDrawObjectCCW", "_slab", "_depth", "_slabAndDepth", "_popupMenu", "_clickFrank", "_select", "_selectNone", "_selectToggle", "_selectAndNot", "_selectOr", "_selectToggleOr", "_dragSelected", "_selectAndDrag", "_rotateSelected", "_rotateBranch", "_dragAtom", "_dragMinimize", "_dragMinimizeMolecule", "_dragLabel", "_dragDrawPoint", "_dragDrawObject", "_pickAtom", "_pickPoint", "_pickLabel", "_pickMeasure", "_setMeasure", "_pickIsosurface", "_pickNavigate", "_deleteAtom", "_deleteBond", "_pickConnect", "_assignNew", "_reset", "_stopMotion", "_multiTouchSimulation"};
    public static final int ACTION_center = 0;
    public static final int ACTION_translate = 1;
    public static final int ACTION_rotate = 2;
    public static final int ACTION_rotateZ = 3;
    public static final int ACTION_rotateZorZoom = 4;
    public static final int ACTION_wheelZoom = 5;
    public static final int ACTION_slideZoom = 6;
    public static final int ACTION_navTranslate = 7;
    public static final int ACTION_swipe = 8;
    public static final int ACTION_spinDrawObjectCW = 9;
    public static final int ACTION_spinDrawObjectCCW = 10;
    public static final int ACTION_slab = 11;
    public static final int ACTION_depth = 12;
    public static final int ACTION_slabAndDepth = 13;
    public static final int ACTION_popupMenu = 14;
    public static final int ACTION_clickFrank = 15;
    public static final int ACTION_select = 16;
    public static final int ACTION_selectNone = 17;
    public static final int ACTION_selectToggle = 18;
    public static final int ACTION_selectAndNot = 19;
    public static final int ACTION_selectOr = 20;
    public static final int ACTION_selectToggleExtended = 21;
    public static final int ACTION_dragSelected = 22;
    public static final int ACTION_selectAndDrag = 23;
    public static final int ACTION_rotateSelected = 24;
    public static final int ACTION_rotateBranch = 25;
    public static final int ACTION_dragAtom = 26;
    public static final int ACTION_dragMinimize = 27;
    public static final int ACTION_dragMinimizeMolecule = 28;
    public static final int ACTION_dragLabel = 29;
    public static final int ACTION_dragDrawPoint = 30;
    public static final int ACTION_dragDrawObject = 31;
    public static final int ACTION_pickAtom = 32;
    public static final int ACTION_pickPoint = 33;
    public static final int ACTION_pickLabel = 34;
    public static final int ACTION_pickMeasure = 35;
    public static final int ACTION_setMeasure = 36;
    public static final int ACTION_pickIsosurface = 37;
    public static final int ACTION_pickNavigate = 38;
    public static final int ACTION_deleteAtom = 39;
    public static final int ACTION_deleteBond = 40;
    public static final int ACTION_connectAtoms = 41;
    public static final int ACTION_assignNew = 42;
    public static final int ACTION_reset = 43;
    public static final int ACTION_stopMotion = 44;
    public static final int ACTION_multiTouchSimulation = 45;
    public static final int ACTION_count = 46;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENTIFY = 1;
    public static final int PICKING_LABEL = 2;
    public static final int PICKING_CENTER = 3;
    public static final int PICKING_DRAW = 4;
    public static final int PICKING_SPIN = 5;
    public static final int PICKING_SYMMETRY = 6;
    public static final int PICKING_DELETE_ATOM = 7;
    public static final int PICKING_DELETE_BOND = 8;
    public static final int PICKING_SELECT_ATOM = 9;
    public static final int PICKING_SELECT_GROUP = 10;
    public static final int PICKING_SELECT_CHAIN = 11;
    public static final int PICKING_SELECT_MOLECULE = 12;
    public static final int PICKING_SELECT_POLYMER = 13;
    public static final int PICKING_SELECT_STRUCTURE = 14;
    public static final int PICKING_SELECT_SITE = 15;
    public static final int PICKING_SELECT_MODEL = 16;
    public static final int PICKING_SELECT_ELEMENT = 17;
    public static final int PICKING_MEASURE = 18;
    public static final int PICKING_MEASURE_DISTANCE = 19;
    public static final int PICKING_MEASURE_ANGLE = 20;
    public static final int PICKING_MEASURE_TORSION = 21;
    public static final int PICKING_MEASURE_SEQUENCE = 22;
    public static final int PICKING_NAVIGATE = 23;
    public static final int PICKING_CONNECT = 24;
    public static final int PICKING_STRUTS = 25;
    public static final int PICKING_DRAG_MOLECULE = 26;
    public static final int PICKING_DRAG_ATOM = 27;
    public static final int PICKING_DRAG_MINIMIZE = 28;
    public static final int PICKING_DRAG_MINIMIZE_MOLECULE = 29;
    public static final int PICKING_INVERT_STEREO = 30;
    public static final int PICKING_ASSIGN_ATOM = 31;
    public static final int PICKING_ASSIGN_BOND = 32;
    public static final int PICKING_ROTATE_BOND = 33;
    private static final String[] pickingModeNames;
    public static final int PICKINGSTYLE_SELECT_JMOL = 0;
    public static final int PICKINGSTYLE_SELECT_CHIME = 0;
    public static final int PICKINGSTYLE_SELECT_RASMOL = 1;
    public static final int PICKINGSTYLE_SELECT_PFAAT = 2;
    public static final int PICKINGSTYLE_SELECT_DRAG = 3;
    public static final int PICKINGSTYLE_MEASURE_ON = 4;
    public static final int PICKINGSTYLE_MEASURE_OFF = 5;
    private static final String[] pickingStyleNames;
    private static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    protected static final long MININUM_GESTURE_DELAY_MILLISECONDS = 5L;
    private static final int SLIDE_ZOOM_X_PERCENT = 98;
    public static final float DEFAULT_MOUSE_DRAG_FACTOR = 1.0f;
    public static final float DEFAULT_MOUSE_WHEEL_FACTOR = 1.15f;
    public static final float DEFAULT_GESTURE_SWIPE_FACTOR = 1.0f;
    protected Viewer viewer;
    protected Binding binding;
    Binding jmolBinding;
    Binding pfaatBinding;
    Binding dragBinding;
    Binding rasmolBinding;
    Binding predragBinding;
    protected Thread hoverWatcherThread;
    protected boolean haveMultiTouchInput = false;
    protected int xyRange = 0;
    private float gestureSwipeFactor = 1.0f;
    protected float mouseDragFactor = 1.0f;
    protected float mouseWheelFactor = 1.15f;
    protected final Mouse current = new Mouse(0);
    protected final Mouse moved = new Mouse(1);
    private final Mouse clicked = new Mouse(2);
    private final Mouse pressed = new Mouse(3);
    private final Mouse dragged = new Mouse(4);
    protected int pressedCount;
    private int pressedAtomIndex;
    protected int clickedCount;
    private boolean drawMode = false;
    private boolean labelMode = false;
    private boolean dragSelectedMode = false;
    private boolean measuresEnabled = true;
    private boolean hoverActive = false;
    private MeasurementPending measurementPending;
    private int dragAtomIndex = -1;
    private boolean rubberbandSelectionMode = false;
    private final Rectangle rectRubber = new Rectangle();
    private boolean isAltKeyReleased = true;
    private boolean keyProcessing;
    protected boolean isMultiTouchClient;
    protected boolean isMultiTouchServer;
    private boolean haveSelection;
    Map<String, TimeoutThread> timeouts;
    private MeasurementPending measurementQueued;
    private int pickingStyle;
    private int atomPickingMode = 1;
    private int pickingStyleSelect = 0;
    private int pickingStyleMeasure = 5;
    private int rootPickingStyle = 0;
    private String pickAtomAssignType = "C";
    private char pickBondAssignType = (char)112;
    private int bondPickingMode;
    private boolean isPickAtomAssignCharge;
    private boolean selectionWorking = false;
    private ScriptEvaluator eval;
    protected Gesture dragGesture = new Gesture(20);

    public static String getActionName(int n) {
        return n < actionNames.length ? actionNames[n] : null;
    }

    public static int getActionFromName(String string) {
        for (int i = 0; i < actionNames.length; ++i) {
            if (!actionNames[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public String getBindingInfo(String string) {
        return this.binding.getBindingInfo(actionInfo, string);
    }

    public static final String getPickingModeName(int n) {
        return n < 0 || n >= pickingModeNames.length ? "off" : pickingModeNames[n];
    }

    public static final int getPickingMode(String string) {
        int n = pickingModeNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingModeNames[n])) continue;
            return n;
        }
        return -1;
    }

    public static final String getPickingStyleName(int n) {
        return n < 0 || n >= pickingStyleNames.length ? "toggle" : pickingStyleNames[n];
    }

    public static final int getPickingStyle(String string) {
        int n = pickingStyleNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingStyleNames[n])) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getMouseInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<void> arrayList = new ArrayList<void>();
        for (Object object : this.binding.getBindings().values()) {
            void stringArray;
            if (object instanceof Boolean) continue;
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                String[] stringArray2 = new String[]{Binding.getMouseActionName(nArray[0], false), ActionManager.getActionName(nArray[1])};
            }
            arrayList.add(stringArray);
        }
        hashtable.put("bindings", arrayList);
        hashtable.put("bindingName", this.binding.getName());
        hashtable.put("actionNames", actionNames);
        hashtable.put("actionInfo", actionInfo);
        hashtable.put("bindingInfo", TextFormat.split(this.getBindingInfo(null), '\n'));
        return hashtable;
    }

    public void setViewer(Viewer viewer, String string) {
        this.viewer = viewer;
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
    }

    boolean isBound(int n, int n2) {
        return this.binding.isBound(n, n2);
    }

    void bindAction(String string, String string2, Point3f point3f, Point3f point3f2) {
        int n = ActionManager.getActionFromName(string2);
        int n2 = Binding.getMouseAction(string);
        if (n >= 0) {
            this.binding.bind(n2, n);
        } else {
            this.binding.bind(n2, string2);
        }
    }

    protected void clearBindings() {
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.pfaatBinding = null;
        this.dragBinding = null;
        this.rasmolBinding = null;
    }

    void unbindAction(String string, String string2) {
        if (string == null && string2 == null) {
            this.clearBindings();
            return;
        }
        int n = ActionManager.getActionFromName(string2);
        int n2 = Binding.getMouseAction(string);
        if (n >= 0) {
            this.binding.unbind(n2, n);
        } else {
            this.binding.unbind(n2, string2);
        }
        if (string2 == null) {
            this.binding.unbindUserAction(string);
        }
    }

    void setGestureSwipeFactor(float f) {
        this.gestureSwipeFactor = f;
    }

    void setMouseDragFactor(float f) {
        this.mouseDragFactor = f;
    }

    void setMouseWheelFactor(float f) {
        this.mouseWheelFactor = f;
    }

    protected void setCurrent(long l, int n, int n2, int n3) {
        this.hoverOff();
        this.current.set(l, n, n2, n3);
    }

    int getCurrentX() {
        return this.current.x;
    }

    int getCurrentY() {
        return this.current.y;
    }

    public void setMouseMode() {
        this.labelMode = false;
        this.drawMode = false;
        this.dragSelectedMode = this.viewer.getDragSelected();
        boolean bl = this.measuresEnabled = !this.dragSelectedMode;
        if (!this.dragSelectedMode) {
            switch (this.atomPickingMode) {
                default: {
                    return;
                }
                case 31: {
                    this.measuresEnabled = !this.isPickAtomAssignCharge;
                    return;
                }
                case 4: {
                    this.drawMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 2: {
                    this.labelMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 9: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.measuresEnabled = false;
                }
            }
        }
        this.exitMeasurementMode();
    }

    protected void clearMouseInfo() {
        this.clickedCount = 0;
        this.pressedCount = 0;
        this.dragGesture.setAction(0, 0L);
        this.exitMeasurementMode();
    }

    public boolean isMTClient() {
        return this.isMultiTouchClient;
    }

    public boolean isMTServer() {
        return this.isMultiTouchServer;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.startHoverWatcher(false);
        this.clearTimeouts();
        if (this.predragBinding != null) {
            this.binding = this.predragBinding;
        }
        this.viewer.setPickingMode(null, 1);
        this.viewer.setPickingStyle(null, this.rootPickingStyle);
        this.eval = null;
    }

    public synchronized void startHoverWatcher(boolean bl) {
        if (this.viewer.isPreviewOnly()) {
            return;
        }
        try {
            if (bl) {
                if (this.hoverWatcherThread != null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread = new Thread(new HoverWatcher());
                this.hoverWatcherThread.setName("HoverWatcher");
                this.hoverWatcherThread.start();
            } else {
                if (this.hoverWatcherThread == null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread.interrupt();
                this.hoverWatcherThread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModeMouse(int n) {
        if (n == -1) {
            this.startHoverWatcher(false);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.consume();
        if (this.keyProcessing) {
            return;
        }
        this.hoverOff();
        this.keyProcessing = true;
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 18: {
                if (this.dragSelectedMode && this.isAltKeyReleased) {
                    this.viewer.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false);
                }
                this.isAltKeyReleased = false;
                this.moved.modifiers |= 8;
                break;
            }
            case 16: {
                this.dragged.modifiers |= 1;
                this.moved.modifiers |= 1;
                break;
            }
            case 17: {
                this.moved.modifiers |= 2;
            }
        }
        int n2 = 272 + this.moved.modifiers;
        if (!(this.labelMode || this.binding.isUserAction(n2) || this.isSelectAction(n2))) {
            this.checkMotionRotateZoom(n2, this.current.x, 0, 0, false);
        }
        if (this.viewer.getNavigationMode()) {
            int n3 = keyEvent.getModifiers();
            switch (n) {
                case 32: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 46: {
                    this.viewer.navigate(n, n3);
                }
            }
        }
        this.keyProcessing = false;
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 18: {
                if (this.dragSelectedMode) {
                    this.viewer.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false);
                }
                this.isAltKeyReleased = true;
                this.moved.modifiers &= 0xFFFFFFF7;
                break;
            }
            case 16: {
                this.moved.modifiers &= 0xFFFFFFFE;
                break;
            }
            case 17: {
                this.moved.modifiers &= 0xFFFFFFFD;
            }
        }
        if (this.moved.modifiers == 0) {
            this.viewer.setCursor(0);
        }
        if (!this.viewer.getNavigationMode()) {
            return;
        }
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.viewer.navigate(0, 0);
            }
        }
    }

    public void mouseEntered(long l, int n, int n2) {
        this.setCurrent(l, n, n2, 0);
    }

    public void mouseExited(long l, int n, int n2) {
        this.setCurrent(l, n, n2, 0);
        this.exitMeasurementMode();
    }

    public void mouseMoved(long l, int n, int n2, int n3) {
        this.setCurrent(l, n, n2, n3);
        this.moved.setCurrent(0);
        if (this.measurementPending != null || this.hoverActive) {
            this.checkPointOrAtomClicked(n, n2, 0, 0, false, 0);
        } else if (this.isZoomArea(n)) {
            this.checkMotionRotateZoom(Binding.getMouseAction(1, 16), 0, 0, 0, false);
        } else if (this.viewer.getCursor() == 5) {
            this.viewer.setCursor(0);
        }
    }

    public void mouseWheel(long l, int n, int n2) {
        if (this.viewer.isApplet() && !this.viewer.hasFocus()) {
            return;
        }
        this.setCurrent(l, this.current.x, this.current.y, n2);
        this.checkAction(Binding.getMouseAction(0, n2), this.current.x, this.current.y, 0, n, l, 3);
    }

    public void mousePressed(long l, int n, int n2, int n3) {
        this.setCurrent(l, n, n2, n3);
        this.pressedCount = this.pressed.check(n, n2, n3, l, 700L) ? this.pressedCount + 1 : 1;
        this.pressed.setCurrent(4);
        this.dragged.setCurrent(4);
        this.viewer.setFocus();
        boolean bl = this.isBound(Binding.getMouseAction(Integer.MIN_VALUE, n3), 23);
        int n4 = Binding.getMouseAction(this.pressedCount, n3);
        this.dragGesture.setAction(n4, l);
        if (Binding.getModifiers(n4) != 0 && (n4 = this.viewer.notifyMouseClicked(n, n2, n4, 4)) == 0) {
            return;
        }
        this.pressedAtomIndex = Integer.MAX_VALUE;
        if (this.checkUserAction(n4, n, n2, 0, 0, l, 0)) {
            return;
        }
        if (this.drawMode && (this.isBound(n4, 31) || this.isBound(n4, 30)) || this.labelMode && this.isBound(n4, 29)) {
            this.viewer.checkObjectDragged(Integer.MIN_VALUE, 0, n, n2, n4);
            return;
        }
        boolean bl2 = false;
        switch (this.atomPickingMode) {
            case 31: {
                bl2 = this.isBound(n4, 42);
                break;
            }
            case 27: {
                bl2 = this.isBound(n4, 26);
                break;
            }
            case 26: {
                bl2 = this.isBound(n4, 26) || this.isBound(n4, 25);
                break;
            }
            case 28: {
                bl2 = this.isBound(n4, 27);
                break;
            }
            case 29: {
                boolean bl3 = bl2 = this.isBound(n4, 28) || this.isBound(n4, 25);
            }
        }
        if (bl2) {
            this.dragAtomIndex = this.viewer.findNearestAtomIndex(n, n2, true);
            if (this.dragAtomIndex >= 0 && (this.atomPickingMode == 31 || this.atomPickingMode == 30) && this.viewer.isAtomAssignable(this.dragAtomIndex)) {
                this.enterMeasurementMode();
                this.measurementPending.addPoint(this.dragAtomIndex, null, false);
            }
            return;
        }
        if (this.dragSelectedMode) {
            this.haveSelection = true;
            if (bl) {
                boolean bl4 = this.haveSelection = this.viewer.findNearestAtomIndex(n, n2, true) >= 0;
            }
            if (this.isBound(n4, 22) && this.haveSelection) {
                this.viewer.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false);
            }
            return;
        }
        if (this.isBound(n4, 14)) {
            int n5 = 106;
            if (this.viewer.getModelkitMode()) {
                Token token = this.viewer.checkObjectClicked(n, n2, Binding.getMouseAction(1, 16));
                n5 = token != null && token.tok == 1678770178 ? 98 : (this.viewer.findNearestAtomIndex(n, n2) >= 0 ? 97 : 109);
            }
            this.viewer.popupMenu(n, n2, (char)n5);
            return;
        }
        if (this.viewer.useArcBall()) {
            this.viewer.rotateArcBall(n, n2, 0.0f);
        }
        this.checkMotionRotateZoom(n4, n, 0, 0, true);
    }

    public void mouseDragged(long l, int n, int n2, int n3) {
        this.setMouseMode();
        int n4 = n - this.dragged.x;
        int n5 = n2 - this.dragged.y;
        this.setCurrent(l, n, n2, n3);
        this.dragged.setCurrent(1);
        if (this.atomPickingMode != 31) {
            this.exitMeasurementMode();
        }
        int n6 = Binding.getMouseAction(this.pressedCount, n3);
        this.dragGesture.add(n6, n, n2, l);
        this.checkAction(n6, n, n2, n4, n5, l, 1);
    }

    public void mouseReleased(long l, int n, int n2, int n3) {
        this.setCurrent(l, n, n2, n3);
        this.viewer.spinXYBy(0, 0, 0.0f);
        boolean bl = !this.pressed.check(n, n2, n3, l, Long.MAX_VALUE);
        this.viewer.setInMotion(false);
        this.viewer.setCursor(0);
        int n4 = Binding.getMouseAction(this.pressedCount, n3);
        this.dragGesture.add(n4, n, n2, l);
        if (bl) {
            this.viewer.setRotateBondIndex(Integer.MIN_VALUE);
        }
        if (this.dragAtomIndex >= 0 && (this.atomPickingMode == 28 || this.atomPickingMode == 29)) {
            this.minimize(true);
        }
        if (this.atomPickingMode == 31 && this.isBound(n4, 42)) {
            if (this.measurementPending == null || this.dragAtomIndex < 0) {
                return;
            }
            if (this.measurementPending.getCount() == 2) {
                this.viewer.undoAction(true, -1, 0);
                this.viewer.script("assign connect " + this.measurementPending.getMeasurementScript(" ", false));
            } else if (this.pickAtomAssignType.equals("Xx")) {
                this.exitMeasurementMode();
                this.viewer.refresh(3, "bond dropped");
            } else if (this.pressed.inRange(this.dragged.x, this.dragged.y)) {
                String string = "assign atom ({" + this.dragAtomIndex + "}) \"" + this.pickAtomAssignType + "\"";
                if (this.isPickAtomAssignCharge) {
                    string = string + ";{atomindex=" + this.dragAtomIndex + "}.label='%C'; ";
                    this.viewer.undoAction(true, this.dragAtomIndex, 4);
                } else {
                    this.viewer.undoAction(true, -1, 0);
                }
                this.viewer.script(string);
            } else if (!this.isPickAtomAssignCharge) {
                this.viewer.undoAction(true, -1, 0);
                Atom atom = this.viewer.getModelSet().atoms[this.dragAtomIndex];
                if (atom.getElementNumber() == 1) {
                    this.viewer.script("assign atom ({" + this.dragAtomIndex + "}) \"X\"");
                } else {
                    Point3f point3f = new Point3f(n, n2, atom.screenZ);
                    this.viewer.unTransformPoint(point3f, point3f);
                    this.viewer.script("assign atom ({" + this.dragAtomIndex + "}) \"" + this.pickAtomAssignType + "\" " + Escape.escape(point3f));
                }
            }
            this.exitMeasurementMode();
            return;
        }
        this.dragAtomIndex = -1;
        boolean bl2 = this.isRubberBandSelect(n4);
        if (bl2) {
            BitSet bitSet = this.viewer.findAtomsInRectangle(this.rectRubber);
            if (bitSet.length() > 0) {
                String string = Escape.escape(bitSet);
                if (this.isBound(n4, 20)) {
                    this.viewer.script("selectionHalos on;select selected or " + string);
                } else if (this.isBound(n4, 19)) {
                    this.viewer.script("selectionHalos on;select selected and not " + string);
                } else {
                    this.viewer.script("selectionHalos on;select selected tog " + string);
                }
            }
            this.viewer.refresh(3, "mouseReleased");
        }
        this.rubberbandSelectionMode = this.binding.getName() == "drag";
        this.rectRubber.x = Integer.MAX_VALUE;
        if (bl) {
            this.viewer.notifyMouseClicked(n, n2, Binding.getMouseAction(this.pressedCount, 0), 5);
        }
        if (this.drawMode && (this.isBound(n4, 31) || this.isBound(n4, 30)) || this.labelMode && this.isBound(n4, 29)) {
            this.viewer.checkObjectDragged(Integer.MAX_VALUE, 0, n, n2, n4);
            return;
        }
        if (this.dragSelectedMode && this.isBound(n4, 22) && this.haveSelection) {
            this.viewer.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false);
        }
        if (bl && this.checkUserAction(n4, n, n2, 0, 0, l, 2)) {
            return;
        }
        if (this.viewer.getAllowGestures() && this.isBound(n4, 8)) {
            float f = this.getExitRate();
            if (f > 0.0f) {
                this.viewer.spinXYBy(this.dragGesture.getDX(4, 2), this.dragGesture.getDY(4, 2), f * 30.0f * this.gestureSwipeFactor);
            }
            if (this.viewer.getLogGestures()) {
                this.viewer.log("$NOW$ swipe " + this.dragGesture + " " + f);
            }
            return;
        }
    }

    private void minimize(boolean bl) {
        BitSet bitSet = BitSetUtil.setBit(this.dragAtomIndex);
        if (bl) {
            this.dragAtomIndex = -1;
        }
        bitSet = this.viewer.getAtomBits(this.viewer.isAtomPDB(this.dragAtomIndex) ? 1087373318 : 1095761934, bitSet);
        this.viewer.stopMinimization();
        this.viewer.minimize(Integer.MAX_VALUE, 0.0f, bitSet, null, 0.0f, false, false, false);
    }

    protected float getExitRate() {
        long l = this.dragGesture.getTimeDifference(2);
        return l > 5L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(4, 2);
    }

    public void mouseClicked(long l, int n, int n2, int n3, int n4) {
        this.setMouseMode();
        this.setCurrent(l, n, n2, n3);
        this.clickedCount = n4 > 1 ? n4 : (this.clicked.check(n, n2, n3, l, 700L) ? this.clickedCount + 1 : 1);
        this.clicked.setCurrent(2);
        this.viewer.setFocus();
        boolean bl = this.isBound(Binding.getMouseAction(Integer.MIN_VALUE, n3), 23);
        if (bl && this.atomPickingMode != 9) {
            return;
        }
        this.checkPointOrAtomClicked(n, n2, n3, this.clickedCount, false, 2);
    }

    private boolean isRubberBandSelect(int n) {
        return this.rubberbandSelectionMode && (this.isBound(n, 18) || this.isBound(n, 20) || this.isBound(n, 19));
    }

    public Rectangle getRubberBand() {
        if (!this.rubberbandSelectionMode || this.rectRubber.x == Integer.MAX_VALUE) {
            return null;
        }
        return this.rectRubber;
    }

    private void calcRectRubberBand() {
        if (this.current.x < this.pressed.x) {
            this.rectRubber.x = this.current.x;
            this.rectRubber.width = this.pressed.x - this.current.x;
        } else {
            this.rectRubber.x = this.pressed.x;
            this.rectRubber.width = this.current.x - this.pressed.x;
        }
        if (this.current.y < this.pressed.y) {
            this.rectRubber.y = this.current.y;
            this.rectRubber.height = this.pressed.y - this.current.y;
        } else {
            this.rectRubber.y = this.pressed.y;
            this.rectRubber.height = this.current.y - this.pressed.y;
        }
    }

    private void checkAction(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        int n7;
        if (this.viewer.getTestFlag3()) {
            Logger.info("ActionManager checkAction(" + Integer.toHexString(n) + "," + n6 + ")");
        }
        int n8 = Binding.getModifiers(n);
        if (Binding.getModifiers(n) != 0) {
            n7 = this.viewer.notifyMouseClicked(n2, n3, Binding.getMouseAction(-this.pressedCount, n8), n6);
            if (n7 == 0) {
                return;
            }
            if (n7 > 0) {
                n = n7;
            }
        }
        if (this.isRubberBandSelect(n)) {
            this.calcRectRubberBand();
            this.viewer.refresh(3, "rubberBand selection");
            return;
        }
        if (this.checkUserAction(n, n2, n3, n4, n5, l, n6)) {
            return;
        }
        if (this.viewer.getRotateBondIndex() >= 0) {
            if (this.isBound(n, 25)) {
                this.viewer.moveSelected(n4, n5, n2, n3, null, false);
                return;
            }
            if (!this.isBound(n, 2)) {
                this.viewer.setRotateBondIndex(-1);
            }
        }
        if (this.dragAtomIndex >= 0) {
            switch (this.atomPickingMode) {
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    if (this.dragGesture.getPointCount() == 1) {
                        this.viewer.undoAction(true, this.dragAtomIndex, 2);
                    }
                    this.checkMotion(3);
                    if (this.isBound(n, 25)) {
                        BitSet bitSet = this.viewer.getAtomBits(1095761934, BitSetUtil.setBit(this.dragAtomIndex));
                        this.viewer.rotateMolecule(this.getDegrees(n4, 0), this.getDegrees(n5, 1), bitSet);
                    } else {
                        BitSet bitSet = null;
                        switch (this.atomPickingMode) {
                            case 26: 
                            case 29: {
                                bitSet = this.viewer.getAtomBits(1095761934, BitSetUtil.setBit(this.dragAtomIndex));
                            }
                        }
                        this.viewer.moveAtomWithHydrogens(this.dragAtomIndex, n4, n5, bitSet);
                    }
                    return;
                }
            }
        }
        if (this.dragAtomIndex >= 0 && this.isBound(n, 42) && this.atomPickingMode == 31) {
            n7 = this.viewer.findNearestAtomIndex(n2, n3, true);
            if (n7 >= 0) {
                if (this.measurementPending != null) {
                    this.measurementPending.setCount(1);
                } else if (this.measuresEnabled) {
                    this.enterMeasurementMode();
                }
                this.addToMeasurement(n7, null, true);
                this.measurementPending.setColix((short)20);
            } else if (this.measurementPending != null) {
                this.measurementPending.setCount(1);
                this.measurementPending.setColix((short)23);
            }
            if (this.measurementPending == null) {
                return;
            }
            this.measurementPending.traceX = n2;
            this.measurementPending.traceY = n3;
            this.viewer.refresh(3, "assignNew");
            return;
        }
        if (!this.drawMode && !this.labelMode) {
            if (this.isBound(n, 1)) {
                this.viewer.translateXYBy(n4, n5);
                return;
            }
            if (this.isBound(n, 0)) {
                Point3f point3f;
                if (this.pressedAtomIndex == Integer.MAX_VALUE) {
                    this.pressedAtomIndex = this.viewer.findNearestAtomIndex(this.pressed.x, this.pressed.y);
                }
                Point3f point3f2 = point3f = this.pressedAtomIndex < 0 ? null : this.viewer.getAtomPoint3f(this.pressedAtomIndex);
                if (point3f == null) {
                    this.viewer.translateXYBy(n4, n5);
                } else {
                    this.viewer.centerAt(n2, n3, point3f);
                }
                return;
            }
        }
        if (this.dragSelectedMode && this.isBound(n, 22) && this.haveSelection) {
            this.checkMotion(3);
            this.viewer.moveSelected(n4, n5, Integer.MIN_VALUE, Integer.MIN_VALUE, null, true);
            return;
        }
        if (this.drawMode && (this.isBound(n, 31) || this.isBound(n, 30)) || this.labelMode && this.isBound(n, 29)) {
            this.checkMotion(3);
            this.viewer.checkObjectDragged(this.dragged.x, this.dragged.y, n2, n3, n);
            return;
        }
        if (this.checkMotionRotateZoom(n, n2, n4, n5, true)) {
            this.viewer.zoomBy(n5);
            return;
        }
        n7 = this.isBound(n, 2) ? 1 : 0;
        if (n7 != 0 || this.viewer.allowRotateSelected() && this.isBound(n, 24)) {
            float f = this.getDegrees(n4, 0);
            float f2 = this.getDegrees(n5, 1);
            if (n7 != 0) {
                if (this.viewer.useArcBall()) {
                    this.viewer.rotateArcBall(n2, n3, this.mouseDragFactor);
                } else {
                    this.viewer.rotateXYBy(f, f2);
                }
            } else {
                this.checkMotion(3);
                this.viewer.rotateMolecule(f, f2, null);
            }
            return;
        }
        if (this.isBound(n, 4)) {
            if (Math.abs(n5) > 5 * Math.abs(n4)) {
                this.checkMotion(5);
                this.viewer.zoomBy(n5);
            } else if (Math.abs(n4) > 5 * Math.abs(n5)) {
                this.checkMotion(3);
                this.viewer.rotateZBy(-n4, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return;
        }
        if (this.isBound(n, 5)) {
            this.zoomByFactor(n5, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
        if (this.isBound(n, 3)) {
            this.checkMotion(3);
            this.viewer.rotateZBy(-n4, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
        if (this.viewer.getSlabEnabled()) {
            if (this.isBound(n, 12)) {
                this.viewer.depthByPixels(n5);
                return;
            }
            if (this.isBound(n, 11)) {
                this.viewer.slabByPixels(n5);
                return;
            }
            if (this.isBound(n, 13)) {
                this.viewer.slabDepthByPixels(n5);
                return;
            }
        }
    }

    protected float getDegrees(int n, int n2) {
        int n3;
        int n4 = n3 = n2 == 0 ? this.viewer.getScreenWidth() : this.viewer.getScreenHeight();
        if (n3 > 500) {
            n3 = 500;
        }
        return (float)n / (float)n3 * 180.0f * this.mouseDragFactor;
    }

    protected void zoomByFactor(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        this.checkMotion(5);
        this.viewer.zoomByFactor((float)Math.pow(this.mouseWheelFactor, n), n2, n3);
        this.viewer.setInMotion(false);
    }

    private boolean checkUserAction(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        if (!this.binding.isUserAction(n)) {
            return false;
        }
        Map<String, Object> map = this.binding.getBindings();
        Iterator<String> iterator = map.keySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object;
            String string = iterator.next();
            if (string.indexOf(n + "\t") != 0 || !((object = map.get(string)) instanceof String[])) continue;
            String string2 = ((String[])object)[1];
            string2 = TextFormat.simpleReplace(string2, "_ACTION", "" + n);
            string2 = TextFormat.simpleReplace(string2, "_X", "" + n2);
            string2 = TextFormat.simpleReplace(string2, "_Y", "" + (this.viewer.getScreenHeight() - n3));
            string2 = TextFormat.simpleReplace(string2, "_DELTAX", "" + n4);
            string2 = TextFormat.simpleReplace(string2, "_DELTAY", "" + n5);
            string2 = TextFormat.simpleReplace(string2, "_TIME", "" + l);
            string2 = TextFormat.simpleReplace(string2, "_MODE", "" + n6);
            this.viewer.evalStringQuiet(string2);
            bl = true;
        }
        return bl;
    }

    private boolean checkMotionRotateZoom(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        boolean bl2;
        boolean bl3 = this.isBound(n, 6);
        boolean bl4 = this.isBound(n, 2);
        boolean bl5 = this.isBound(n, 4);
        if (!(bl3 || bl4 || bl5)) {
            return false;
        }
        boolean bl6 = bl2 = bl5 && (n3 == 0 || Math.abs(n4) > 5 * Math.abs(n3));
        int n6 = bl2 || this.isZoomArea(this.moved.x) || this.isBound(n, 5) ? 5 : (n5 = bl4 || bl5 ? 3 : 0);
        if (this.viewer.getCursor() != 4) {
            this.viewer.setCursor(n5);
        }
        if (bl) {
            this.viewer.setInMotion(true);
        }
        return bl2 || bl3 && this.isZoomArea(this.pressed.x);
    }

    private boolean isZoomArea(int n) {
        if (this.viewer.getTestFlag3()) {
            System.out.println("ActionManager test isZoomArea " + n + " " + this.viewer.getScreenWidth() + " " + ((float)n > (float)(this.viewer.getScreenWidth() * (this.viewer.isStereoDouble() ? 2 : 1) * 98) / 100.0f));
        }
        return (float)n > (float)(this.viewer.getScreenWidth() * (this.viewer.isStereoDouble() ? 2 : 1) * 98) / 100.0f;
    }

    private boolean checkPointOrAtomClicked(int n, int n2, int n3, int n4, boolean bl, int n5) {
        boolean bl2;
        int n6;
        Token token;
        if (!this.viewer.haveModelSet()) {
            return false;
        }
        int n7 = Binding.getMouseAction(n4, n3);
        if (n7 != 0 && (n7 = this.viewer.notifyMouseClicked(n, n2, n7, n5)) == 0) {
            return false;
        }
        Point3fi point3fi = null;
        int n8 = 0;
        if (!this.drawMode && !bl && (token = this.viewer.checkObjectClicked(n, n2, n7)) != null) {
            n8 = token.tok;
            point3fi = (Point3fi)token.value;
        }
        if (n8 == 1678770178) {
            n4 = 1;
        }
        if (point3fi != null && Float.isNaN(point3fi.x)) {
            return false;
        }
        int n9 = n6 = this.drawMode || point3fi != null ? -1 : this.viewer.findNearestAtomIndex(n, n2, true);
        if (!(n6 < 0 || n4 <= 0 && this.measurementPending != null || this.viewer.isInSelectionSubset(n6))) {
            n6 = -1;
        }
        if (n4 == 0 && this.atomPickingMode != 31) {
            if (this.measurementPending == null) {
                return n6 >= 0;
            }
            if (point3fi != null || this.measurementPending.getIndexOf(n6) == 0) {
                this.measurementPending.addPoint(n6, point3fi, false);
            }
            if (this.measurementPending.haveModified()) {
                this.viewer.setPendingMeasurement(this.measurementPending);
            }
            this.viewer.refresh(3, "measurementPending");
            return n6 >= 0;
        }
        this.setMouseMode();
        if (this.isBound(n7, 44)) {
            this.viewer.stopMotion();
        }
        if (this.isBound(n7, 15) && this.viewer.frankClicked(n, n2)) {
            this.viewer.popupMenu(-n, n2, 'j');
            return false;
        }
        if (this.isBound(n7, 15) && this.viewer.frankClickedModelKit(n, n2)) {
            this.viewer.popupMenu(0, 0, 'm');
            return false;
        }
        if (this.viewer.getNavigationMode() && this.atomPickingMode == 23 && this.isBound(n7, 38)) {
            this.viewer.navTranslatePercent(0.0f, (float)n * 100.0f / (float)this.viewer.getScreenWidth() - 50.0f, (float)n2 * 100.0f / (float)this.viewer.getScreenHeight() - 50.0f);
            return false;
        }
        if (n8 == 1678770178) {
            if (this.isBound(n7, this.bondPickingMode == 33 || this.bondPickingMode == 32 ? 42 : 40)) {
                if (this.bondPickingMode == 32) {
                    this.viewer.undoAction(true, -1, 0);
                }
                switch (this.bondPickingMode) {
                    case 32: {
                        this.viewer.script("assign bond [{" + point3fi.index + "}] \"" + this.pickBondAssignType + "\"");
                        break;
                    }
                    case 33: {
                        this.viewer.setRotateBondIndex(point3fi.index);
                        break;
                    }
                    default: {
                        this.viewer.deleteBonds(BitSetUtil.setBit(point3fi.index));
                    }
                }
                return false;
            }
        } else {
            if (n8 == 135197) {
                return false;
            }
            if (this.atomPickingMode != 31 && this.measurementPending != null && this.isBound(n7, 35)) {
                this.atomOrPointPicked(n6, point3fi, n7);
                if (this.addToMeasurement(n6, point3fi, false) == 4) {
                    this.toggleMeasurement();
                }
                return false;
            }
            if (this.isBound(n7, 36)) {
                if (this.measurementPending != null) {
                    this.addToMeasurement(n6, point3fi, true);
                    this.toggleMeasurement();
                } else if (!this.drawMode && !this.labelMode && !this.dragSelectedMode && this.measuresEnabled) {
                    this.enterMeasurementMode();
                    this.addToMeasurement(n6, point3fi, true);
                }
                this.atomOrPointPicked(n6, point3fi, n7);
                return false;
            }
        }
        boolean bl3 = bl2 = this.dragSelectedMode && (this.isBound(n7, 24) || this.isBound(n7, 22));
        if (bl2 || this.isSelectAction(n7)) {
            if (n8 != 135197) {
                this.atomOrPointPicked(n6, point3fi, bl2 ? 0 : n7);
            }
            return n6 >= 0;
        }
        if (this.isBound(n7, 43)) {
            if (n6 < 0) {
                this.viewer.script("!reset");
            }
            return false;
        }
        return n6 >= 0;
    }

    private boolean isSelectAction(int n) {
        return this.isBound(n, 32) || this.isBound(n, 33) || this.isBound(n, 18) || this.isBound(n, 19) || this.isBound(n, 20) || this.isBound(n, 21) || this.isBound(n, 16);
    }

    protected void checkMotion(int n) {
        if (this.viewer.getCursor() != 4) {
            this.viewer.setCursor(n);
        }
        this.viewer.setInMotion(true);
    }

    private int addToMeasurement(int n, Point3fi point3fi, boolean bl) {
        if (n == -1 && point3fi == null) {
            this.exitMeasurementMode();
            return 0;
        }
        int n2 = this.measurementPending.getCount();
        if (this.measurementPending.traceX != Integer.MIN_VALUE && n2 == 2) {
            n2 = 1;
            this.measurementPending.setCount(1);
        }
        return n2 == 4 && !bl ? n2 : this.measurementPending.addPoint(n, point3fi, true);
    }

    private void enterMeasurementMode() {
        this.viewer.setCursor(2);
        this.measurementPending = new MeasurementPending(this.viewer.getModelSet());
        this.viewer.setPendingMeasurement(this.measurementPending);
    }

    private void exitMeasurementMode() {
        if (this.measurementPending == null) {
            return;
        }
        this.measurementPending = null;
        this.viewer.setPendingMeasurement(null);
        this.viewer.setCursor(0);
    }

    private void toggleMeasurement() {
        if (this.measurementPending == null) {
            return;
        }
        int n = this.measurementPending.getCount();
        if (n >= 2 && n <= 4) {
            this.viewer.script("!measure " + this.measurementPending.getMeasurementScript(" ", true));
        }
        this.exitMeasurementMode();
    }

    public String showTimeout(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.timeouts != null) {
            for (TimeoutThread timeoutThread : this.timeouts.values()) {
                if (string != null && !timeoutThread.name.equalsIgnoreCase(string)) continue;
                stringBuffer.append(timeoutThread.toString()).append("\n");
            }
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : "<no timeouts set>";
    }

    public void clearTimeouts() {
        if (this.timeouts == null) {
            return;
        }
        Iterator<TimeoutThread> iterator = this.timeouts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().interrupt();
        }
        this.timeouts.clear();
    }

    public void setTimeout(String string, int n, String string2) {
        if (string == null) {
            this.clearTimeouts();
            return;
        }
        if (this.timeouts == null) {
            this.timeouts = new Hashtable<String, TimeoutThread>();
        }
        if (n == 0) {
            Thread thread = this.timeouts.get(string);
            if (thread != null) {
                thread.interrupt();
                this.timeouts.remove(string);
            }
            return;
        }
        TimeoutThread timeoutThread = this.timeouts.get(string);
        if (timeoutThread != null) {
            timeoutThread.set(n, string2);
            return;
        }
        timeoutThread = new TimeoutThread(string, n, string2);
        this.timeouts.put(string, timeoutThread);
        timeoutThread.start();
    }

    public void hoverOn(int n) {
        this.viewer.hoverOn(n, Binding.getMouseAction(this.clickedCount, this.moved.modifiers));
    }

    public void hoverOff() {
        try {
            this.viewer.hoverOff();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetMeasurement() {
        this.measurementQueued = new MeasurementPending(this.viewer.getModelSet());
    }

    public String getPickingState() {
        String string = ";set modelkitMode " + this.viewer.getModelkitMode() + ";set picking " + ActionManager.getPickingModeName(this.atomPickingMode);
        if (this.atomPickingMode == 31) {
            string = string + "_" + this.pickAtomAssignType;
        }
        string = string + ";";
        if (this.bondPickingMode != 0) {
            string = string + "set picking " + ActionManager.getPickingModeName(this.bondPickingMode);
        }
        if (this.bondPickingMode == 32) {
            string = string + "_" + this.pickBondAssignType;
        }
        string = string + ";";
        return string;
    }

    public int getAtomPickingMode() {
        return this.atomPickingMode;
    }

    public int getBondPickingMode() {
        return this.bondPickingMode;
    }

    public void setPickingMode(int n) {
        switch (n) {
            case 32: 
            case 33: {
                this.viewer.setBooleanProperty("bondPicking", true);
                this.bondPickingMode = n;
                return;
            }
            case 8: {
                this.bondPickingMode = n;
                if (!this.viewer.getBondPicking()) break;
                return;
            }
        }
        this.atomPickingMode = n;
        this.resetMeasurement();
    }

    void setAtomPickingOption(String string) {
        switch (this.atomPickingMode) {
            case 31: {
                this.pickAtomAssignType = string;
                this.isPickAtomAssignCharge = this.pickAtomAssignType.equals("Pl") || this.pickAtomAssignType.equals("Mi");
            }
        }
    }

    void setBondPickingOption(String string) {
        switch (this.bondPickingMode) {
            case 32: {
                this.pickBondAssignType = Character.toLowerCase(string.charAt(0));
            }
        }
    }

    public int getPickingStyle() {
        return this.pickingStyle;
    }

    public void setPickingStyle(int n) {
        this.pickingStyle = n;
        if (n >= 4) {
            this.pickingStyleMeasure = n;
            this.resetMeasurement();
        } else {
            if (n < 3) {
                this.rootPickingStyle = n;
            }
            this.pickingStyleSelect = n;
        }
        this.rubberbandSelectionMode = false;
        switch (this.pickingStyleSelect) {
            case 2: {
                if (this.binding.getName() == "extendedSelect") break;
                this.pfaatBinding = this.pfaatBinding == null ? new PfaatBinding() : this.pfaatBinding;
                this.setBinding(this.pfaatBinding);
                break;
            }
            case 3: {
                if (this.binding.getName() != "drag") {
                    this.dragBinding = this.dragBinding == null ? new DragBinding() : this.dragBinding;
                    this.setBinding(this.dragBinding);
                }
                this.rubberbandSelectionMode = true;
                break;
            }
            case 1: {
                if (this.binding.getName() == "selectOrToggle") break;
                this.rasmolBinding = this.rasmolBinding == null ? new RasmolBinding() : this.rasmolBinding;
                this.setBinding(this.rasmolBinding);
                break;
            }
            default: {
                if (this.binding == this.jmolBinding) break;
                this.setBinding(this.jmolBinding);
            }
        }
        if (this.binding.getName() != "drag") {
            this.predragBinding = this.binding;
        }
    }

    protected void setBinding(Binding binding) {
        this.binding = binding;
    }

    private void atomOrPointPicked(int n, Point3fi point3fi, int n2) {
        if (n < 0) {
            this.resetMeasurement();
            if (this.isBound(n2, 17)) {
                this.viewer.script("select none");
                return;
            }
            if (this.atomPickingMode != 5 && this.atomPickingMode != 6) {
                return;
            }
        }
        int n3 = 2;
        switch (this.atomPickingMode) {
            case 27: 
            case 28: {
                return;
            }
            case 0: {
                return;
            }
            case 8: 
            case 24: 
            case 25: {
                boolean bl = this.atomPickingMode == 8;
                boolean bl2 = this.atomPickingMode == 25;
                if (!this.isBound(n2, bl ? 40 : 41)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.getCount() >= 2) {
                    this.resetMeasurement();
                }
                if (this.queueAtom(n, point3fi) != 2) {
                    return;
                }
                String string = bl || this.measurementQueued.isConnected(this.viewer.getModelSet().atoms, 2) ? " DELETE" : (bl2 ? "STRUTS" : "");
                this.viewer.script("connect " + this.measurementQueued.getMeasurementScript(" ", true) + string);
                return;
            }
            case 21: {
                ++n3;
            }
            case 20: {
                ++n3;
            }
            case 18: 
            case 19: 
            case 22: {
                if (!this.isBound(n2, 35)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.getCount() >= n3) {
                    this.resetMeasurement();
                }
                if (this.queueAtom(n, point3fi) < n3) {
                    return;
                }
                if (this.atomPickingMode == 22) {
                    this.getSequence();
                } else {
                    this.viewer.setStatusMeasuring("measurePicked", n3, this.measurementQueued.getStringDetail());
                }
                if (this.atomPickingMode == 18 || this.pickingStyleMeasure == 4) {
                    this.viewer.script("measure " + this.measurementQueued.getMeasurementScript(" ", true));
                }
                return;
            }
            case 3: {
                if (!this.isBound(n2, 32)) {
                    return;
                }
                if (point3fi == null) {
                    this.viewer.script("zoomTo (atomindex=" + n + ")");
                    this.viewer.setStatusAtomPicked(n, null);
                } else {
                    this.viewer.script("zoomTo " + Escape.escape(point3fi));
                }
                return;
            }
            case 5: 
            case 6: {
                this.checkTwoAtomAction(n2, point3fi, n);
            }
        }
        if (point3fi != null) {
            return;
        }
        String string = "atomindex=" + n;
        switch (this.atomPickingMode) {
            case 1: {
                if (this.isBound(n2, 32)) {
                    this.viewer.setStatusAtomPicked(n, null);
                }
                return;
            }
            case 2: {
                if (this.isBound(n2, 34)) {
                    this.viewer.script("set labeltoggle {atomindex=" + n + "}");
                    this.viewer.setStatusAtomPicked(n, null);
                }
                return;
            }
            case 30: {
                if (this.isBound(n2, 42)) {
                    BitSet bitSet = this.viewer.getAtomBitSet("connected(atomIndex=" + n + ") and !within(SMARTS,'[r50,R]')");
                    int n4 = bitSet.cardinality();
                    switch (n4) {
                        case 0: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            int[] nArray = new int[n4];
                            int[] nArray2 = new int[n4];
                            int n5 = 0;
                            int n6 = bitSet.nextSetBit(0);
                            while (n6 >= 0) {
                                nArray[n5] = this.viewer.getBranchBitSet(n6, n).cardinality();
                                nArray2[n5] = n6;
                                n6 = bitSet.nextSetBit(n6 + 1);
                                ++n5;
                            }
                            for (n6 = 0; n6 < n4 - 2; ++n6) {
                                int n7 = Integer.MIN_VALUE;
                                int n8 = 0;
                                for (int i = 0; i < n4; ++i) {
                                    if (nArray[i] < n7 || !bitSet.get(nArray2[i])) continue;
                                    n8 = nArray2[i];
                                    n7 = nArray[i];
                                }
                                bitSet.clear(n8);
                            }
                            break;
                        }
                    }
                    this.viewer.undoAction(true, n, 2);
                    this.viewer.invertSelected(null, null, n, bitSet);
                }
                return;
            }
            case 7: {
                if (this.isBound(n2, 39)) {
                    BitSet bitSet = this.getSelectionSet("(" + string + ")");
                    this.viewer.deleteAtoms(bitSet, false);
                }
                return;
            }
        }
        switch (this.atomPickingMode) {
            default: {
                return;
            }
            case 9: {
                this.applySelectStyle(string, n2);
                break;
            }
            case 10: {
                this.applySelectStyle("within(group, " + string + ")", n2);
                break;
            }
            case 11: {
                this.applySelectStyle("within(chain, " + string + ")", n2);
                break;
            }
            case 13: {
                this.applySelectStyle("within(polymer, " + string + ")", n2);
                break;
            }
            case 14: {
                this.applySelectStyle("within(structure, " + string + ")", n2);
                break;
            }
            case 12: {
                this.applySelectStyle("within(molecule, " + string + ")", n2);
                break;
            }
            case 16: {
                this.applySelectStyle("within(model, " + string + ")", n2);
                break;
            }
            case 17: {
                this.applySelectStyle("visible and within(element, " + string + ")", n2);
                break;
            }
            case 15: {
                this.applySelectStyle("visible and within(site, " + string + ")", n2);
            }
        }
        this.viewer.clearClickCount();
        this.viewer.setStatusAtomPicked(n, null);
    }

    private void getSequence() {
        int n = this.measurementQueued.getAtomIndex(1);
        int n2 = this.measurementQueued.getAtomIndex(2);
        if (n < 0 || n2 < 0) {
            return;
        }
        String string = this.viewer.getSmiles(n, n2, null, true, false, false, false);
        this.viewer.setStatusMeasuring("measureSequence", -2, string);
    }

    private void checkTwoAtomAction(int n, Point3fi point3fi, int n2) {
        int n3;
        boolean bl;
        if (!this.isBound(n, 32)) {
            return;
        }
        boolean bl2 = bl = this.atomPickingMode == 5;
        if (this.viewer.getSpinOn() || this.viewer.getNavOn() || this.viewer.getPendingMeasurement() != null) {
            this.resetMeasurement();
            this.viewer.script("spin off");
            return;
        }
        if (this.measurementQueued.getCount() >= 2) {
            this.resetMeasurement();
        }
        if ((n3 = this.measurementQueued.getCount()) == 1 && (point3fi == null ? this.measurementQueued.getAtomIndex(1) == n2 : this.measurementQueued.getAtom(1).distance(point3fi) == 0.0f)) {
            return;
        }
        if (n2 >= 0 || point3fi != null) {
            n3 = this.queueAtom(n2, point3fi);
        }
        if (n3 < 2) {
            if (bl) {
                this.viewer.scriptStatus(n3 == 1 ? GT._("pick one more atom in order to spin the model around an axis") : GT._("pick two atoms in order to spin the model around an axis"));
            } else {
                this.viewer.scriptStatus(n3 == 1 ? GT._("pick one more atom in order to display the symmetry relationship") : GT._("pick two atoms in order to display the symmetry relationship between them"));
            }
            return;
        }
        String string = this.measurementQueued.getMeasurementScript(" ", false);
        if (bl) {
            this.viewer.script("spin" + string + " " + this.viewer.getPickingSpinRate());
        } else {
            this.viewer.script("draw symop" + string + ";show symop" + string);
        }
    }

    private int queueAtom(int n, Point3fi point3fi) {
        int n2 = this.measurementQueued.addPoint(n, point3fi, true);
        if (n >= 0) {
            this.viewer.setStatusAtomPicked(n, "Atom #" + n2 + ":" + this.viewer.getAtomInfo(n));
        }
        return n2;
    }

    private void applySelectStyle(String string, int n) {
        String string2;
        if (this.measurementPending != null || this.selectionWorking) {
            return;
        }
        this.selectionWorking = true;
        String string3 = this.rubberbandSelectionMode || this.isBound(n, 18) ? "selected and not (" + string + ") or (not selected) and " : (this.isBound(n, 19) ? "selected and not " : (this.isBound(n, 20) ? "selected or " : (n == 0 || this.isBound(n, 21) ? "selected tog " : (string2 = this.isBound(n, 16) ? "" : null))));
        if (string2 != null) {
            BitSet bitSet;
            string2 = string2 + "(" + string + ")";
            if (Logger.debugging) {
                Logger.debug(string2);
            }
            if ((bitSet = this.getSelectionSet(string2)) != null) {
                this.viewer.setSelectionSet(bitSet);
                this.viewer.refresh(3, "selections set");
            }
        }
        this.selectionWorking = false;
    }

    private BitSet getSelectionSet(String string) {
        try {
            if (this.eval == null) {
                this.eval = new ScriptEvaluator(this.viewer);
            }
            return this.viewer.getAtomBitSet(this.eval, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        if (actionNames.length != 46) {
            Logger.error("ERROR IN ActionManager: actionNames length?");
        }
        if (actionInfo.length != 46) {
            Logger.error("ERROR IN ActionManager: actionInfo length?");
        }
        pickingModeNames = new String[]{"off", "identify", "label", "center", "draw", "spin", "symmetry", "deleteatom", "deletebond", "atom", "group", "chain", "molecule", "polymer", "structure", "site", "model", "element", "measure", "distance", "angle", "torsion", "sequence", "navigate", "connect", "struts", "dragmolecule", "dragatom", "dragminimize", "dragminimizemolecule", "invertstereo", "assignatom", "assignbond", "rotatebond"};
        pickingStyleNames = new String[]{"toggle", "selectOrToggle", "extendedSelect", "drag", "measure", "measureoff"};
    }

    protected class Gesture {
        private int action;
        MotionPoint[] nodes;
        private int ptNext;
        private long time0;

        Gesture(int n) {
            this.nodes = new MotionPoint[n];
            for (int i = 0; i < n; ++i) {
                this.nodes[i] = new MotionPoint();
            }
        }

        void setAction(int n, long l) {
            this.action = n;
            this.ptNext = 0;
            this.time0 = l;
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].index = -1;
            }
        }

        int getAction() {
            return this.action;
        }

        int add(int n, int n2, int n3, long l) {
            this.action = n;
            this.getNode(this.ptNext).set(this.ptNext, n2, n3, l - this.time0);
            ++this.ptNext;
            return this.ptNext;
        }

        public long getTimeDifference(int n) {
            if ((n = this.getPointCount(n, 0)) < 2) {
                return 0L;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n);
            return motionPoint.time - motionPoint2.time;
        }

        public float getSpeedPixelsPerMillisecond(int n, int n2) {
            if ((n = this.getPointCount(n, n2)) < 2) {
                return 0.0f;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
            float f = (float)(motionPoint.x - motionPoint2.x) / (float)ActionManager.this.viewer.getScreenWidth() * 360.0f;
            float f2 = (float)(motionPoint.y - motionPoint2.y) / (float)ActionManager.this.viewer.getScreenHeight() * 360.0f;
            return (float)Math.sqrt(f * f + f2 * f2) / (float)(motionPoint.time - motionPoint2.time);
        }

        int getDX(int n, int n2) {
            if ((n = this.getPointCount(n, n2)) < 2) {
                return 0;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
            return motionPoint.x - motionPoint2.x;
        }

        int getDY(int n, int n2) {
            if ((n = this.getPointCount(n, n2)) < 2) {
                return 0;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
            return motionPoint.y - motionPoint2.y;
        }

        int getPointCount() {
            return this.ptNext;
        }

        int getPointCount(int n, int n2) {
            if (n > this.nodes.length - n2) {
                n = this.nodes.length - n2;
            }
            int n3 = n + 1;
            while (--n3 >= 0 && this.getNode((int)(this.ptNext - n3 - n2)).index < 0) {
            }
            return n3;
        }

        MotionPoint getNode(int n) {
            return this.nodes[(n + this.nodes.length + this.nodes.length) % this.nodes.length];
        }

        public String toString() {
            if (this.nodes.length == 0) {
                return "" + this;
            }
            return Binding.getMouseActionName(this.action, false) + " nPoints = " + this.ptNext + " " + this.nodes[0];
        }
    }

    protected class MotionPoint {
        int index;
        int x;
        int y;
        long time;

        protected MotionPoint() {
        }

        void set(int n, int n2, int n3, long l) {
            this.index = n;
            this.x = n2;
            this.y = n3;
            this.time = l;
        }

        public String toString() {
            return "[x = " + this.x + " y = " + this.y + " time = " + this.time + " ]";
        }
    }

    class HoverWatcher
    implements Runnable {
        HoverWatcher() {
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            try {
                int n;
                while (Thread.currentThread().equals(ActionManager.this.hoverWatcherThread) && (n = ActionManager.this.viewer.getHoverDelay()) > 0) {
                    int n2;
                    long l;
                    int n3;
                    Thread.sleep(n);
                    if (ActionManager.this.current.x != ActionManager.this.moved.x || ActionManager.this.current.y != ActionManager.this.moved.y || ActionManager.this.current.time != ActionManager.this.moved.time || (n3 = (int)((l = System.currentTimeMillis()) - ActionManager.this.moved.time)) <= n || !Thread.currentThread().equals(ActionManager.this.hoverWatcherThread) || ActionManager.this.viewer.getInMotion() || ActionManager.this.viewer.getSpinOn() || ActionManager.this.viewer.getNavOn() || ActionManager.this.viewer.checkObjectHovered(ActionManager.this.current.x, ActionManager.this.current.y) || (n2 = ActionManager.this.viewer.findNearestAtomIndex(ActionManager.this.current.x, ActionManager.this.current.y)) < 0) continue;
                    ActionManager.this.hoverOn(n2);
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.debug("Hover interrupted");
            }
            catch (Exception exception) {
                Logger.debug("Hover Exception: " + exception);
            }
        }
    }

    private class TimeoutThread
    extends Thread {
        String name;
        private int ms;
        private long targetTime;
        private int status;
        private String script;

        TimeoutThread(String string, int n, String string2) {
            this.name = string;
            this.ms = n;
            this.script = string2;
            this.targetTime = System.currentTimeMillis() + (long)Math.abs(n);
        }

        void set(int n, String string) {
            this.ms = n;
            if (string != null && string.length() != 0) {
                this.script = string;
            }
        }

        public String toString() {
            return "timeout name=" + this.name + " executions=" + this.status + " mSec=" + this.ms + " secRemaining=" + (float)(this.targetTime - System.currentTimeMillis()) / 1000.0f + " script=" + this.script + " thread=" + Thread.currentThread().getName();
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 6[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    protected class Mouse {
        protected int x = -1000;
        protected int y = -1000;
        protected int modifiers = 0;
        protected long time = -1L;
        private int type;

        protected Mouse(int n) {
            this.type = n;
        }

        protected void set(long l, int n, int n2, int n3) {
            if (ActionManager.this.viewer.getTestFlag3()) {
                System.out.println("Mouse " + this.type + " set xy mod " + n + " " + n2 + " " + n3);
            }
            this.time = l;
            this.x = n;
            this.y = n2;
            this.modifiers = n3;
        }

        protected void setCurrent(int n) {
            this.time = ActionManager.this.current.time;
            this.x = ActionManager.this.current.x;
            this.y = ActionManager.this.current.y;
            this.modifiers = ActionManager.this.current.modifiers;
            if (ActionManager.this.viewer.getTestFlag3()) {
                System.out.println("Mouse " + this.type + " " + n + " set xy mod " + this.x + " " + this.y + " " + this.modifiers);
            }
        }

        public boolean inRange(int n, int n2) {
            return Math.abs(this.x - n) <= ActionManager.this.xyRange && Math.abs(this.y - n2) <= ActionManager.this.xyRange;
        }

        public boolean check(int n, int n2, int n3, long l, long l2) {
            return this.inRange(n, n2) && this.modifiers == n3 && l - this.time < l2;
        }
    }
}

