/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class MarchingSquares {
    public static final int CONTOUR_POINT = -1;
    public static final int VERTEX_POINT = -2;
    public static final int EDGE_POINT = -3;
    VertexDataServer surfaceReader;
    VolumeData volumeData;
    private static final int nContourMax = 100;
    public static final int defaultContourCount = 9;
    private int nContourSegments;
    private int contourType;
    int thisContour = 0;
    private float valueMin;
    private float valueMax;
    final Point3f pointA = new Point3f();
    final Point3f pointB = new Point3f();
    private boolean contourFromZero = true;
    private float[] contoursDiscrete;
    public int contourVertexCount;
    ContourVertex[] contourVertexes = new ContourVertex[1000];
    float contourPlaneMinimumValue;
    float contourPlaneMaximumValue;
    private float[] contourValuesUsed;
    final Point3f ptTemp = new Point3f();
    private int triangleCount = 0;
    private Triangle[] triangles = new Triangle[1000];
    Hashtable<String, Integer> htPts = new Hashtable();

    public MarchingSquares(VertexDataServer vertexDataServer, VolumeData volumeData, Point4f point4f, float[] fArray, int n, int n2, boolean bl) {
        this.surfaceReader = vertexDataServer;
        this.volumeData = volumeData;
        this.thisContour = n2;
        this.contoursDiscrete = fArray;
        this.contourFromZero = bl;
        if (fArray == null) {
            int n3 = 0;
            this.nContourSegments = (n == 0 ? 9 : n) + n3;
            if (this.nContourSegments > 100) {
                this.nContourSegments = 100;
            }
        } else {
            this.nContourSegments = n = fArray.length;
            this.contourFromZero = false;
        }
    }

    public int getContourType() {
        return this.contourType;
    }

    public void setMinMax(float f, float f2) {
        this.valueMin = f;
        this.valueMax = f2;
    }

    public int addContourVertex(int n, int n2, int n3, Point3i point3i, Point3f point3f, float f) {
        if (this.contourVertexCount == this.contourVertexes.length) {
            this.contourVertexes = (ContourVertex[])ArrayUtil.doubleLength((Object)this.contourVertexes);
        }
        if (point3i != null) {
            n += point3i.x;
            n2 += point3i.y;
            n3 += point3i.z;
        }
        int n4 = this.surfaceReader.addVertexCopy(point3f, f, -2);
        this.contourVertexes[this.contourVertexCount++] = new ContourVertex(point3f);
        return n4;
    }

    public void setContourData(int n, float f) {
        this.contourVertexes[n].setValue(f);
    }

    public float[] getContourValues() {
        return this.contourValuesUsed;
    }

    float calcContourPoint(float f, float f2, float f3, Point3f point3f) {
        return this.volumeData.calculateFractionalPoint(f, this.pointA, this.pointB, f2, f3, point3f);
    }

    public int addTriangle(int n, int n2, int n3, int n4, int n5) {
        if (this.triangleCount == this.triangles.length) {
            this.triangles = (Triangle[])ArrayUtil.doubleLength((Object)this.triangles);
        }
        this.triangles[this.triangleCount++] = new Triangle(n, n2, n3, n4, n5);
        return 0;
    }

    public int generateContourData(boolean bl, float f) {
        Logger.info((String)("generateContours: " + this.nContourSegments + " segments"));
        this.getVertexValues(bl);
        this.createContours(this.valueMin, this.valueMax, f);
        this.addAllTriangles();
        return this.contourVertexCount;
    }

    private void getVertexValues(boolean bl) {
        this.contourPlaneMinimumValue = Float.MAX_VALUE;
        this.contourPlaneMaximumValue = -3.4028235E38f;
        for (int i = 0; i < this.contourVertexCount; ++i) {
            float f;
            ContourVertex contourVertex = this.contourVertexes[i];
            if (bl) {
                f = contourVertex.value;
            } else {
                f = this.volumeData.lookupInterpolatedVoxelValue(contourVertex);
                contourVertex.setValue(f);
            }
            if (f < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = f;
            }
            if (!(f > this.contourPlaneMaximumValue)) continue;
            this.contourPlaneMaximumValue = f;
        }
    }

    private boolean createContours(float f, float f2, float f3) {
        int n;
        float f4;
        float f5 = f2 - f;
        this.contourValuesUsed = new float[this.nContourSegments];
        int n2 = this.triangleCount;
        while (--n2 >= 0) {
            this.triangles[n2].check = 0;
        }
        float f6 = Float.MAX_VALUE;
        float f7 = f4 = -3.4028235E38f;
        for (n = 0; n < this.nContourSegments; ++n) {
            float f8 = this.contoursDiscrete != null ? this.contoursDiscrete[n] : (this.contourFromZero ? f + (float)n * 1.0f / (float)this.nContourSegments * f5 : (n == 0 ? -3.4028235E38f : (f7 = n == this.nContourSegments - 1 ? Float.MAX_VALUE : f + (float)(n - 1) * 1.0f / (float)(this.nContourSegments - 1) * f5)));
            if (this.contoursDiscrete == null && Math.abs(f7) < f3) {
                f7 = f7 < 0.0f ? -f3 : f3;
            }
            this.contourValuesUsed[n] = f7;
            Logger.info((String)("#contour " + (n + 1) + " " + f7));
            int n3 = 0;
            this.htPts.clear();
            int n4 = this.triangleCount;
            while (--n4 >= 0) {
                if (this.triangles[n4].isValid) {
                    this.triangles[n4].checkContour(n, f7);
                    continue;
                }
                ++n3;
            }
            if (this.thisContour > 0) {
                if (n + 1 == this.thisContour) {
                    f4 = f7;
                    continue;
                }
                if (n != this.thisContour) continue;
                f6 = f7;
                continue;
            }
            f6 = f7;
        }
        if (this.contoursDiscrete != null) {
            f4 = this.contoursDiscrete[0];
            f6 = this.contoursDiscrete[this.contoursDiscrete.length - 1];
        }
        this.valueMin = this.contourValuesUsed[0];
        float f9 = this.valueMax = this.contourValuesUsed.length == 0 ? this.valueMin : this.contourValuesUsed[this.contourValuesUsed.length - 1];
        if (this.contourFromZero || this.contoursDiscrete != null) {
            for (n = 0; n < this.contourVertexCount; ++n) {
                float f10 = this.contourVertexes[n].value;
                if (!(f10 > f6) && !(f10 < f4)) continue;
                this.contourVertexes[n].value = Float.NaN;
            }
            n = this.triangleCount;
            while (--n >= 0) {
                this.triangles[n].setValidity();
            }
        }
        return true;
    }

    public float[] getMinMax() {
        return new float[]{this.valueMin, this.valueMax};
    }

    private void addAllTriangles() {
        for (int i = 0; i < this.triangleCount; ++i) {
            if (!this.triangles[i].isValid) continue;
            Triangle triangle = this.triangles[i];
            this.surfaceReader.addTriangleCheck(triangle.pts[0], triangle.pts[1], triangle.pts[2], triangle.check, triangle.contourIndex, false, -1);
        }
    }

    private class Triangle {
        int[] pts;
        int check;
        boolean isValid = true;
        int contourIndex;

        Triangle(int n, int n2, int n3, int n4, int n5) {
            this.pts = new int[]{n, n2, n3};
            this.check = n4;
            this.contourIndex = n5;
        }

        private int intercept(int n, float f) {
            float f2;
            String string;
            int n2 = this.pts[n];
            int n3 = this.pts[(n + 1) % 3];
            if (n2 == Integer.MAX_VALUE || n3 == Integer.MAX_VALUE) {
                return -1;
            }
            String string2 = string = n2 < n3 ? n2 + "_" + n3 : n3 + "_" + n2;
            if (MarchingSquares.this.htPts.containsKey(string)) {
                return MarchingSquares.this.htPts.get(string);
            }
            float f3 = MarchingSquares.this.contourVertexes[n2].value;
            float f4 = MarchingSquares.this.contourVertexes[n3].value;
            int n4 = -1;
            if (f3 != f4 && (f2 = (f - f3) / (f4 - f3)) >= 0.0f && f2 <= 1.0f) {
                MarchingSquares.this.pointA.set((Tuple3f)MarchingSquares.this.contourVertexes[n2]);
                MarchingSquares.this.pointB.set((Tuple3f)MarchingSquares.this.contourVertexes[n3]);
                f = MarchingSquares.this.calcContourPoint(f, f3, f4, MarchingSquares.this.ptTemp);
                if (!Float.isNaN(f)) {
                    n4 = MarchingSquares.this.addContourVertex(0, 0, 0, null, MarchingSquares.this.ptTemp, f);
                    MarchingSquares.this.contourVertexes[n4].setValue(f);
                }
            }
            MarchingSquares.this.htPts.put(string, n4);
            return n4;
        }

        protected void checkContour(int n, float f) {
            int n2 = this.intercept(0, f);
            int n3 = this.intercept(1, f);
            int n4 = this.intercept(2, f);
            int n5 = 0;
            if (n2 >= 0) {
                ++n5;
            }
            if (n3 >= 0) {
                n5 += 2;
            }
            if (n4 >= 0) {
                n5 += 4;
            }
            switch (n5) {
                case 3: {
                    MarchingSquares.this.addTriangle(this.pts[0], n2, n3, 2 | this.check & 1, n);
                    MarchingSquares.this.addTriangle(n2, this.pts[1], n3, 4 | this.check & 3, n);
                    MarchingSquares.this.addTriangle(this.pts[0], n3, this.pts[2], this.check & 6, n);
                    break;
                }
                case 5: {
                    MarchingSquares.this.addTriangle(this.pts[0], n2, n4, 2 | this.check & 5, n);
                    MarchingSquares.this.addTriangle(n2, this.pts[1], n4, 4 | this.check & 1, n);
                    MarchingSquares.this.addTriangle(n4, this.pts[1], this.pts[2], this.check & 6, n);
                    break;
                }
                case 6: {
                    MarchingSquares.this.addTriangle(this.pts[0], this.pts[1], n4, this.check & 5, n);
                    MarchingSquares.this.addTriangle(n4, this.pts[1], n3, 4 | this.check & 2, n);
                    MarchingSquares.this.addTriangle(n4, n3, this.pts[2], 1 | this.check & 6, n);
                    break;
                }
                default: {
                    return;
                }
            }
            this.isValid = false;
        }

        void setValidity() {
            this.isValid &= !Float.isNaN(MarchingSquares.this.contourVertexes[this.pts[0]].value) && !Float.isNaN(MarchingSquares.this.contourVertexes[this.pts[1]].value) && !Float.isNaN(MarchingSquares.this.contourVertexes[this.pts[2]].value);
        }
    }

    private static class ContourVertex
    extends Point3f {
        float value;

        ContourVertex(Point3f point3f) {
            this.set((Tuple3f)point3f);
        }

        void setValue(float f) {
            this.value = f;
        }
    }
}

