# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.52.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class InventoryResponsePurchase(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'warehouse_purchase_no': 'str',
        'warehouse_goods_no': 'str',
        'supplier_no': 'str',
        'po_order_status': 'str',
        'storage_status': 'str',
        'create_time': 'str',
        'complete_time': 'str',
        'product_name': 'str',
        'receive_box_number': 'str',
        'gross_weight': 'str',
        'volume': 'str',
        'po_items': 'list[InventoryPurchaseItem]',
        'qc_qualified_items': 'list[InventoryPurchaseItem]',
        'qc_unqualified_items': 'list[InventoryPurchaseItem]'
    }

    attribute_map = {
        'warehouse_purchase_no': 'warehousePurchaseNo',
        'warehouse_goods_no': 'warehouseGoodsNo',
        'supplier_no': 'supplierNo',
        'po_order_status': 'poOrderStatus',
        'storage_status': 'storageStatus',
        'create_time': 'createTime',
        'complete_time': 'completeTime',
        'product_name': 'productName',
        'receive_box_number': 'receiveBoxNumber',
        'gross_weight': 'grossWeight',
        'volume': 'volume',
        'po_items': 'poItems',
        'qc_qualified_items': 'qcQualifiedItems',
        'qc_unqualified_items': 'qcUnqualifiedItems'
    }

    def __init__(self, warehouse_purchase_no=None, warehouse_goods_no=None, supplier_no=None, po_order_status=None, storage_status=None, create_time=None, complete_time=None, product_name=None, receive_box_number=None, gross_weight=None, volume=None, po_items=None, qc_qualified_items=None, qc_unqualified_items=None, local_vars_configuration=None):  # noqa: E501
        """InventoryResponsePurchase - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._warehouse_purchase_no = None
        self._warehouse_goods_no = None
        self._supplier_no = None
        self._po_order_status = None
        self._storage_status = None
        self._create_time = None
        self._complete_time = None
        self._product_name = None
        self._receive_box_number = None
        self._gross_weight = None
        self._volume = None
        self._po_items = None
        self._qc_qualified_items = None
        self._qc_unqualified_items = None
        self.discriminator = None

        if warehouse_purchase_no is not None:
            self.warehouse_purchase_no = warehouse_purchase_no
        if warehouse_goods_no is not None:
            self.warehouse_goods_no = warehouse_goods_no
        if supplier_no is not None:
            self.supplier_no = supplier_no
        if po_order_status is not None:
            self.po_order_status = po_order_status
        if storage_status is not None:
            self.storage_status = storage_status
        if create_time is not None:
            self.create_time = create_time
        if complete_time is not None:
            self.complete_time = complete_time
        if product_name is not None:
            self.product_name = product_name
        if receive_box_number is not None:
            self.receive_box_number = receive_box_number
        if gross_weight is not None:
            self.gross_weight = gross_weight
        if volume is not None:
            self.volume = volume
        if po_items is not None:
            self.po_items = po_items
        if qc_qualified_items is not None:
            self.qc_qualified_items = qc_qualified_items
        if qc_unqualified_items is not None:
            self.qc_unqualified_items = qc_unqualified_items

    @property
    def warehouse_purchase_no(self):
        """Gets the warehouse_purchase_no of this InventoryResponsePurchase.  # noqa: E501

        Warehouse purchase No, generated by warehouse.  # noqa: E501

        :return: The warehouse_purchase_no of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._warehouse_purchase_no

    @warehouse_purchase_no.setter
    def warehouse_purchase_no(self, warehouse_purchase_no):
        """Sets the warehouse_purchase_no of this InventoryResponsePurchase.

        Warehouse purchase No, generated by warehouse.  # noqa: E501

        :param warehouse_purchase_no: The warehouse_purchase_no of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._warehouse_purchase_no = warehouse_purchase_no

    @property
    def warehouse_goods_no(self):
        """Gets the warehouse_goods_no of this InventoryResponsePurchase.  # noqa: E501

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :return: The warehouse_goods_no of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._warehouse_goods_no

    @warehouse_goods_no.setter
    def warehouse_goods_no(self, warehouse_goods_no):
        """Sets the warehouse_goods_no of this InventoryResponsePurchase.

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :param warehouse_goods_no: The warehouse_goods_no of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._warehouse_goods_no = warehouse_goods_no

    @property
    def supplier_no(self):
        """Gets the supplier_no of this InventoryResponsePurchase.  # noqa: E501

        Supplier number.  # noqa: E501

        :return: The supplier_no of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._supplier_no

    @supplier_no.setter
    def supplier_no(self, supplier_no):
        """Sets the supplier_no of this InventoryResponsePurchase.

        Supplier number.  # noqa: E501

        :param supplier_no: The supplier_no of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._supplier_no = supplier_no

    @property
    def po_order_status(self):
        """Gets the po_order_status of this InventoryResponsePurchase.  # noqa: E501


        :return: The po_order_status of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._po_order_status

    @po_order_status.setter
    def po_order_status(self, po_order_status):
        """Sets the po_order_status of this InventoryResponsePurchase.


        :param po_order_status: The po_order_status of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._po_order_status = po_order_status

    @property
    def storage_status(self):
        """Gets the storage_status of this InventoryResponsePurchase.  # noqa: E501


        :return: The storage_status of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._storage_status

    @storage_status.setter
    def storage_status(self, storage_status):
        """Sets the storage_status of this InventoryResponsePurchase.


        :param storage_status: The storage_status of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._storage_status = storage_status

    @property
    def create_time(self):
        """Gets the create_time of this InventoryResponsePurchase.  # noqa: E501


        :return: The create_time of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this InventoryResponsePurchase.


        :param create_time: The create_time of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._create_time = create_time

    @property
    def complete_time(self):
        """Gets the complete_time of this InventoryResponsePurchase.  # noqa: E501


        :return: The complete_time of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._complete_time

    @complete_time.setter
    def complete_time(self, complete_time):
        """Sets the complete_time of this InventoryResponsePurchase.


        :param complete_time: The complete_time of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._complete_time = complete_time

    @property
    def product_name(self):
        """Gets the product_name of this InventoryResponsePurchase.  # noqa: E501


        :return: The product_name of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """Sets the product_name of this InventoryResponsePurchase.


        :param product_name: The product_name of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._product_name = product_name

    @property
    def receive_box_number(self):
        """Gets the receive_box_number of this InventoryResponsePurchase.  # noqa: E501


        :return: The receive_box_number of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._receive_box_number

    @receive_box_number.setter
    def receive_box_number(self, receive_box_number):
        """Sets the receive_box_number of this InventoryResponsePurchase.


        :param receive_box_number: The receive_box_number of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._receive_box_number = receive_box_number

    @property
    def gross_weight(self):
        """Gets the gross_weight of this InventoryResponsePurchase.  # noqa: E501


        :return: The gross_weight of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._gross_weight

    @gross_weight.setter
    def gross_weight(self, gross_weight):
        """Sets the gross_weight of this InventoryResponsePurchase.


        :param gross_weight: The gross_weight of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._gross_weight = gross_weight

    @property
    def volume(self):
        """Gets the volume of this InventoryResponsePurchase.  # noqa: E501


        :return: The volume of this InventoryResponsePurchase.  # noqa: E501
        :rtype: str
        """
        return self._volume

    @volume.setter
    def volume(self, volume):
        """Sets the volume of this InventoryResponsePurchase.


        :param volume: The volume of this InventoryResponsePurchase.  # noqa: E501
        :type: str
        """

        self._volume = volume

    @property
    def po_items(self):
        """Gets the po_items of this InventoryResponsePurchase.  # noqa: E501


        :return: The po_items of this InventoryResponsePurchase.  # noqa: E501
        :rtype: list[InventoryPurchaseItem]
        """
        return self._po_items

    @po_items.setter
    def po_items(self, po_items):
        """Sets the po_items of this InventoryResponsePurchase.


        :param po_items: The po_items of this InventoryResponsePurchase.  # noqa: E501
        :type: list[InventoryPurchaseItem]
        """

        self._po_items = po_items

    @property
    def qc_qualified_items(self):
        """Gets the qc_qualified_items of this InventoryResponsePurchase.  # noqa: E501


        :return: The qc_qualified_items of this InventoryResponsePurchase.  # noqa: E501
        :rtype: list[InventoryPurchaseItem]
        """
        return self._qc_qualified_items

    @qc_qualified_items.setter
    def qc_qualified_items(self, qc_qualified_items):
        """Sets the qc_qualified_items of this InventoryResponsePurchase.


        :param qc_qualified_items: The qc_qualified_items of this InventoryResponsePurchase.  # noqa: E501
        :type: list[InventoryPurchaseItem]
        """

        self._qc_qualified_items = qc_qualified_items

    @property
    def qc_unqualified_items(self):
        """Gets the qc_unqualified_items of this InventoryResponsePurchase.  # noqa: E501


        :return: The qc_unqualified_items of this InventoryResponsePurchase.  # noqa: E501
        :rtype: list[InventoryPurchaseItem]
        """
        return self._qc_unqualified_items

    @qc_unqualified_items.setter
    def qc_unqualified_items(self, qc_unqualified_items):
        """Sets the qc_unqualified_items of this InventoryResponsePurchase.


        :param qc_unqualified_items: The qc_unqualified_items of this InventoryResponsePurchase.  # noqa: E501
        :type: list[InventoryPurchaseItem]
        """

        self._qc_unqualified_items = qc_unqualified_items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InventoryResponsePurchase):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InventoryResponsePurchase):
            return True

        return self.to_dict() != other.to_dict()
