# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.52.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class InventoryResponseProduct(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'merchant_goods_no': 'str',
        'platform_goods_no': 'str',
        'warehouse_goods_no': 'str',
        'barcodes': 'str',
        'third_category_no': 'str',
        'goods_name': 'str',
        'shop_no': 'str',
        'stock_status': 'str',
        'stock_type': 'str',
        'total_num': 'str',
        'usable_num': 'str',
        'record_count': 'str',
        'brand_name': 'str',
        'manufacturer': 'str',
        'produce_address': 'str',
        'gross_weight': 'float',
        'net_weight': 'float',
        'safe_days': 'int',
        'advent_day': 'int'
    }

    attribute_map = {
        'merchant_goods_no': 'merchantGoodsNo',
        'platform_goods_no': 'platformGoodsNo',
        'warehouse_goods_no': 'warehouseGoodsNo',
        'barcodes': 'barcodes',
        'third_category_no': 'thirdCategoryNo',
        'goods_name': 'goodsName',
        'shop_no': 'shopNo',
        'stock_status': 'stockStatus',
        'stock_type': 'stockType',
        'total_num': 'totalNum',
        'usable_num': 'usableNum',
        'record_count': 'recordCount',
        'brand_name': 'brandName',
        'manufacturer': 'manufacturer',
        'produce_address': 'produceAddress',
        'gross_weight': 'grossWeight',
        'net_weight': 'netWeight',
        'safe_days': 'safeDays',
        'advent_day': 'adventDay'
    }

    def __init__(self, merchant_goods_no=None, platform_goods_no=None, warehouse_goods_no=None, barcodes=None, third_category_no=None, goods_name=None, shop_no=None, stock_status=None, stock_type=None, total_num=None, usable_num=None, record_count=None, brand_name=None, manufacturer=None, produce_address=None, gross_weight=None, net_weight=None, safe_days=None, advent_day=None, local_vars_configuration=None):  # noqa: E501
        """InventoryResponseProduct - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._merchant_goods_no = None
        self._platform_goods_no = None
        self._warehouse_goods_no = None
        self._barcodes = None
        self._third_category_no = None
        self._goods_name = None
        self._shop_no = None
        self._stock_status = None
        self._stock_type = None
        self._total_num = None
        self._usable_num = None
        self._record_count = None
        self._brand_name = None
        self._manufacturer = None
        self._produce_address = None
        self._gross_weight = None
        self._net_weight = None
        self._safe_days = None
        self._advent_day = None
        self.discriminator = None

        if merchant_goods_no is not None:
            self.merchant_goods_no = merchant_goods_no
        if platform_goods_no is not None:
            self.platform_goods_no = platform_goods_no
        if warehouse_goods_no is not None:
            self.warehouse_goods_no = warehouse_goods_no
        if barcodes is not None:
            self.barcodes = barcodes
        if third_category_no is not None:
            self.third_category_no = third_category_no
        if goods_name is not None:
            self.goods_name = goods_name
        if shop_no is not None:
            self.shop_no = shop_no
        if stock_status is not None:
            self.stock_status = stock_status
        if stock_type is not None:
            self.stock_type = stock_type
        if total_num is not None:
            self.total_num = total_num
        if usable_num is not None:
            self.usable_num = usable_num
        if record_count is not None:
            self.record_count = record_count
        if brand_name is not None:
            self.brand_name = brand_name
        if manufacturer is not None:
            self.manufacturer = manufacturer
        if produce_address is not None:
            self.produce_address = produce_address
        if gross_weight is not None:
            self.gross_weight = gross_weight
        if net_weight is not None:
            self.net_weight = net_weight
        if safe_days is not None:
            self.safe_days = safe_days
        if advent_day is not None:
            self.advent_day = advent_day

    @property
    def merchant_goods_no(self):
        """Gets the merchant_goods_no of this InventoryResponseProduct.  # noqa: E501


        :return: The merchant_goods_no of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._merchant_goods_no

    @merchant_goods_no.setter
    def merchant_goods_no(self, merchant_goods_no):
        """Sets the merchant_goods_no of this InventoryResponseProduct.


        :param merchant_goods_no: The merchant_goods_no of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._merchant_goods_no = merchant_goods_no

    @property
    def platform_goods_no(self):
        """Gets the platform_goods_no of this InventoryResponseProduct.  # noqa: E501


        :return: The platform_goods_no of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._platform_goods_no

    @platform_goods_no.setter
    def platform_goods_no(self, platform_goods_no):
        """Sets the platform_goods_no of this InventoryResponseProduct.


        :param platform_goods_no: The platform_goods_no of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._platform_goods_no = platform_goods_no

    @property
    def warehouse_goods_no(self):
        """Gets the warehouse_goods_no of this InventoryResponseProduct.  # noqa: E501

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :return: The warehouse_goods_no of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._warehouse_goods_no

    @warehouse_goods_no.setter
    def warehouse_goods_no(self, warehouse_goods_no):
        """Sets the warehouse_goods_no of this InventoryResponseProduct.

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :param warehouse_goods_no: The warehouse_goods_no of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._warehouse_goods_no = warehouse_goods_no

    @property
    def barcodes(self):
        """Gets the barcodes of this InventoryResponseProduct.  # noqa: E501

        Barcodes, multiple bar codes are separated by commas.  # noqa: E501

        :return: The barcodes of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._barcodes

    @barcodes.setter
    def barcodes(self, barcodes):
        """Sets the barcodes of this InventoryResponseProduct.

        Barcodes, multiple bar codes are separated by commas.  # noqa: E501

        :param barcodes: The barcodes of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._barcodes = barcodes

    @property
    def third_category_no(self):
        """Gets the third_category_no of this InventoryResponseProduct.  # noqa: E501

        Goods category code of third level, required by Jingdong Logistics.  # noqa: E501

        :return: The third_category_no of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._third_category_no

    @third_category_no.setter
    def third_category_no(self, third_category_no):
        """Sets the third_category_no of this InventoryResponseProduct.

        Goods category code of third level, required by Jingdong Logistics.  # noqa: E501

        :param third_category_no: The third_category_no of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._third_category_no = third_category_no

    @property
    def goods_name(self):
        """Gets the goods_name of this InventoryResponseProduct.  # noqa: E501


        :return: The goods_name of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._goods_name

    @goods_name.setter
    def goods_name(self, goods_name):
        """Sets the goods_name of this InventoryResponseProduct.


        :param goods_name: The goods_name of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._goods_name = goods_name

    @property
    def shop_no(self):
        """Gets the shop_no of this InventoryResponseProduct.  # noqa: E501


        :return: The shop_no of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._shop_no

    @shop_no.setter
    def shop_no(self, shop_no):
        """Sets the shop_no of this InventoryResponseProduct.


        :param shop_no: The shop_no of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._shop_no = shop_no

    @property
    def stock_status(self):
        """Gets the stock_status of this InventoryResponseProduct.  # noqa: E501


        :return: The stock_status of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._stock_status

    @stock_status.setter
    def stock_status(self, stock_status):
        """Sets the stock_status of this InventoryResponseProduct.


        :param stock_status: The stock_status of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._stock_status = stock_status

    @property
    def stock_type(self):
        """Gets the stock_type of this InventoryResponseProduct.  # noqa: E501


        :return: The stock_type of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._stock_type

    @stock_type.setter
    def stock_type(self, stock_type):
        """Sets the stock_type of this InventoryResponseProduct.


        :param stock_type: The stock_type of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._stock_type = stock_type

    @property
    def total_num(self):
        """Gets the total_num of this InventoryResponseProduct.  # noqa: E501


        :return: The total_num of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._total_num

    @total_num.setter
    def total_num(self, total_num):
        """Sets the total_num of this InventoryResponseProduct.


        :param total_num: The total_num of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._total_num = total_num

    @property
    def usable_num(self):
        """Gets the usable_num of this InventoryResponseProduct.  # noqa: E501


        :return: The usable_num of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._usable_num

    @usable_num.setter
    def usable_num(self, usable_num):
        """Sets the usable_num of this InventoryResponseProduct.


        :param usable_num: The usable_num of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._usable_num = usable_num

    @property
    def record_count(self):
        """Gets the record_count of this InventoryResponseProduct.  # noqa: E501


        :return: The record_count of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._record_count

    @record_count.setter
    def record_count(self, record_count):
        """Sets the record_count of this InventoryResponseProduct.


        :param record_count: The record_count of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._record_count = record_count

    @property
    def brand_name(self):
        """Gets the brand_name of this InventoryResponseProduct.  # noqa: E501


        :return: The brand_name of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._brand_name

    @brand_name.setter
    def brand_name(self, brand_name):
        """Sets the brand_name of this InventoryResponseProduct.


        :param brand_name: The brand_name of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._brand_name = brand_name

    @property
    def manufacturer(self):
        """Gets the manufacturer of this InventoryResponseProduct.  # noqa: E501


        :return: The manufacturer of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._manufacturer

    @manufacturer.setter
    def manufacturer(self, manufacturer):
        """Sets the manufacturer of this InventoryResponseProduct.


        :param manufacturer: The manufacturer of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._manufacturer = manufacturer

    @property
    def produce_address(self):
        """Gets the produce_address of this InventoryResponseProduct.  # noqa: E501


        :return: The produce_address of this InventoryResponseProduct.  # noqa: E501
        :rtype: str
        """
        return self._produce_address

    @produce_address.setter
    def produce_address(self, produce_address):
        """Sets the produce_address of this InventoryResponseProduct.


        :param produce_address: The produce_address of this InventoryResponseProduct.  # noqa: E501
        :type: str
        """

        self._produce_address = produce_address

    @property
    def gross_weight(self):
        """Gets the gross_weight of this InventoryResponseProduct.  # noqa: E501

        Gross weight, the unit of mass is kilograms.  # noqa: E501

        :return: The gross_weight of this InventoryResponseProduct.  # noqa: E501
        :rtype: float
        """
        return self._gross_weight

    @gross_weight.setter
    def gross_weight(self, gross_weight):
        """Sets the gross_weight of this InventoryResponseProduct.

        Gross weight, the unit of mass is kilograms.  # noqa: E501

        :param gross_weight: The gross_weight of this InventoryResponseProduct.  # noqa: E501
        :type: float
        """

        self._gross_weight = gross_weight

    @property
    def net_weight(self):
        """Gets the net_weight of this InventoryResponseProduct.  # noqa: E501

        Net weight, the unit of mass is kilograms.  # noqa: E501

        :return: The net_weight of this InventoryResponseProduct.  # noqa: E501
        :rtype: float
        """
        return self._net_weight

    @net_weight.setter
    def net_weight(self, net_weight):
        """Sets the net_weight of this InventoryResponseProduct.

        Net weight, the unit of mass is kilograms.  # noqa: E501

        :param net_weight: The net_weight of this InventoryResponseProduct.  # noqa: E501
        :type: float
        """

        self._net_weight = net_weight

    @property
    def safe_days(self):
        """Gets the safe_days of this InventoryResponseProduct.  # noqa: E501


        :return: The safe_days of this InventoryResponseProduct.  # noqa: E501
        :rtype: int
        """
        return self._safe_days

    @safe_days.setter
    def safe_days(self, safe_days):
        """Sets the safe_days of this InventoryResponseProduct.


        :param safe_days: The safe_days of this InventoryResponseProduct.  # noqa: E501
        :type: int
        """

        self._safe_days = safe_days

    @property
    def advent_day(self):
        """Gets the advent_day of this InventoryResponseProduct.  # noqa: E501


        :return: The advent_day of this InventoryResponseProduct.  # noqa: E501
        :rtype: int
        """
        return self._advent_day

    @advent_day.setter
    def advent_day(self, advent_day):
        """Sets the advent_day of this InventoryResponseProduct.


        :param advent_day: The advent_day of this InventoryResponseProduct.  # noqa: E501
        :type: int
        """

        self._advent_day = advent_day

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InventoryResponseProduct):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InventoryResponseProduct):
            return True

        return self.to_dict() != other.to_dict()
