# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.52.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class InventoryPurchase(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'warehouse_goods_no': 'str',
        'purchase_order_no': 'str',
        'supplier_no': 'str',
        'goods_num': 'int',
        'goods_status': 'str'
    }

    attribute_map = {
        'warehouse_goods_no': 'warehouseGoodsNo',
        'purchase_order_no': 'purchaseOrderNo',
        'supplier_no': 'supplierNo',
        'goods_num': 'goodsNum',
        'goods_status': 'goodsStatus'
    }

    def __init__(self, warehouse_goods_no=None, purchase_order_no=None, supplier_no=None, goods_num=None, goods_status='GOOD', local_vars_configuration=None):  # noqa: E501
        """InventoryPurchase - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._warehouse_goods_no = None
        self._purchase_order_no = None
        self._supplier_no = None
        self._goods_num = None
        self._goods_status = None
        self.discriminator = None

        self.warehouse_goods_no = warehouse_goods_no
        self.purchase_order_no = purchase_order_no
        if supplier_no is not None:
            self.supplier_no = supplier_no
        self.goods_num = goods_num
        if goods_status is not None:
            self.goods_status = goods_status

    @property
    def warehouse_goods_no(self):
        """Gets the warehouse_goods_no of this InventoryPurchase.  # noqa: E501

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :return: The warehouse_goods_no of this InventoryPurchase.  # noqa: E501
        :rtype: str
        """
        return self._warehouse_goods_no

    @warehouse_goods_no.setter
    def warehouse_goods_no(self, warehouse_goods_no):
        """Sets the warehouse_goods_no of this InventoryPurchase.

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :param warehouse_goods_no: The warehouse_goods_no of this InventoryPurchase.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and warehouse_goods_no is None:  # noqa: E501
            raise ValueError("Invalid value for `warehouse_goods_no`, must not be `None`")  # noqa: E501

        self._warehouse_goods_no = warehouse_goods_no

    @property
    def purchase_order_no(self):
        """Gets the purchase_order_no of this InventoryPurchase.  # noqa: E501

        Merchant purchase order number.  # noqa: E501

        :return: The purchase_order_no of this InventoryPurchase.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_no

    @purchase_order_no.setter
    def purchase_order_no(self, purchase_order_no):
        """Sets the purchase_order_no of this InventoryPurchase.

        Merchant purchase order number.  # noqa: E501

        :param purchase_order_no: The purchase_order_no of this InventoryPurchase.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and purchase_order_no is None:  # noqa: E501
            raise ValueError("Invalid value for `purchase_order_no`, must not be `None`")  # noqa: E501

        self._purchase_order_no = purchase_order_no

    @property
    def supplier_no(self):
        """Gets the supplier_no of this InventoryPurchase.  # noqa: E501

        Supplier number.  # noqa: E501

        :return: The supplier_no of this InventoryPurchase.  # noqa: E501
        :rtype: str
        """
        return self._supplier_no

    @supplier_no.setter
    def supplier_no(self, supplier_no):
        """Sets the supplier_no of this InventoryPurchase.

        Supplier number.  # noqa: E501

        :param supplier_no: The supplier_no of this InventoryPurchase.  # noqa: E501
        :type: str
        """

        self._supplier_no = supplier_no

    @property
    def goods_num(self):
        """Gets the goods_num of this InventoryPurchase.  # noqa: E501

        Quantity of goods applied for storage.  # noqa: E501

        :return: The goods_num of this InventoryPurchase.  # noqa: E501
        :rtype: int
        """
        return self._goods_num

    @goods_num.setter
    def goods_num(self, goods_num):
        """Sets the goods_num of this InventoryPurchase.

        Quantity of goods applied for storage.  # noqa: E501

        :param goods_num: The goods_num of this InventoryPurchase.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and goods_num is None:  # noqa: E501
            raise ValueError("Invalid value for `goods_num`, must not be `None`")  # noqa: E501

        self._goods_num = goods_num

    @property
    def goods_status(self):
        """Gets the goods_status of this InventoryPurchase.  # noqa: E501

        Product status. GOOD: Good product; DEFECTIVE: Defective product; SAMPLE: Samples.  # noqa: E501

        :return: The goods_status of this InventoryPurchase.  # noqa: E501
        :rtype: str
        """
        return self._goods_status

    @goods_status.setter
    def goods_status(self, goods_status):
        """Sets the goods_status of this InventoryPurchase.

        Product status. GOOD: Good product; DEFECTIVE: Defective product; SAMPLE: Samples.  # noqa: E501

        :param goods_status: The goods_status of this InventoryPurchase.  # noqa: E501
        :type: str
        """

        self._goods_status = goods_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InventoryPurchase):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InventoryPurchase):
            return True

        return self.to_dict() != other.to_dict()
