# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.52.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class InventoryProduct(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'merchant_goods_no': 'str',
        'platform_goods_no': 'str',
        'barcodes': 'str',
        'warehouse_goods_no': 'str',
        'third_category_no': 'str',
        'goods_name': 'str',
        'gross_weight': 'float',
        'net_weight': 'float',
        'safe_days': 'int',
        'batch': 'str',
        'oversea_purchase': 'str',
        'pattern': 'str',
        'qi_record': 'str',
        'custom_record': 'str',
        'cc_provider': 'str',
        'bonded_area': 'str',
        'customs_seller_record': 'str',
        'bat_attr_ids': 'str',
        'model_number': 'str',
        'spec': 'str',
        'vat_rate': 'int',
        'tax_rate': 'int',
        'hs_code': 'str',
        'country': 'str',
        'qi_country': 'str',
        'legal_unit1': 'str',
        'legal_amount1': 'str',
        'legal_unit2': 'str',
        'legal_amount2': 'str',
        'measurement': 'str',
        'qi_measurement': 'str',
        'declaration_elements': 'str'
    }

    attribute_map = {
        'merchant_goods_no': 'merchantGoodsNo',
        'platform_goods_no': 'platformGoodsNo',
        'barcodes': 'barcodes',
        'warehouse_goods_no': 'warehouseGoodsNo',
        'third_category_no': 'thirdCategoryNo',
        'goods_name': 'goodsName',
        'gross_weight': 'grossWeight',
        'net_weight': 'netWeight',
        'safe_days': 'safeDays',
        'batch': 'batch',
        'oversea_purchase': 'overseaPurchase',
        'pattern': 'pattern',
        'qi_record': 'qiRecord',
        'custom_record': 'customRecord',
        'cc_provider': 'ccProvider',
        'bonded_area': 'bondedArea',
        'customs_seller_record': 'customsSellerRecord',
        'bat_attr_ids': 'batAttrIds',
        'model_number': 'modelNumber',
        'spec': 'spec',
        'vat_rate': 'vatRate',
        'tax_rate': 'taxRate',
        'hs_code': 'hsCode',
        'country': 'country',
        'qi_country': 'qiCountry',
        'legal_unit1': 'legalUnit1',
        'legal_amount1': 'legalAmount1',
        'legal_unit2': 'legalUnit2',
        'legal_amount2': 'legalAmount2',
        'measurement': 'measurement',
        'qi_measurement': 'qiMeasurement',
        'declaration_elements': 'declarationElements'
    }

    def __init__(self, merchant_goods_no=None, platform_goods_no=None, barcodes=None, warehouse_goods_no=None, third_category_no=None, goods_name=None, gross_weight=None, net_weight=None, safe_days=None, batch=None, oversea_purchase=None, pattern=None, qi_record=None, custom_record=None, cc_provider=None, bonded_area=None, customs_seller_record=None, bat_attr_ids=None, model_number=None, spec=None, vat_rate=None, tax_rate=None, hs_code=None, country=None, qi_country=None, legal_unit1=None, legal_amount1=None, legal_unit2=None, legal_amount2=None, measurement=None, qi_measurement=None, declaration_elements=None, local_vars_configuration=None):  # noqa: E501
        """InventoryProduct - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._merchant_goods_no = None
        self._platform_goods_no = None
        self._barcodes = None
        self._warehouse_goods_no = None
        self._third_category_no = None
        self._goods_name = None
        self._gross_weight = None
        self._net_weight = None
        self._safe_days = None
        self._batch = None
        self._oversea_purchase = None
        self._pattern = None
        self._qi_record = None
        self._custom_record = None
        self._cc_provider = None
        self._bonded_area = None
        self._customs_seller_record = None
        self._bat_attr_ids = None
        self._model_number = None
        self._spec = None
        self._vat_rate = None
        self._tax_rate = None
        self._hs_code = None
        self._country = None
        self._qi_country = None
        self._legal_unit1 = None
        self._legal_amount1 = None
        self._legal_unit2 = None
        self._legal_amount2 = None
        self._measurement = None
        self._qi_measurement = None
        self._declaration_elements = None
        self.discriminator = None

        self.merchant_goods_no = merchant_goods_no
        self.platform_goods_no = platform_goods_no
        self.barcodes = barcodes
        if warehouse_goods_no is not None:
            self.warehouse_goods_no = warehouse_goods_no
        if third_category_no is not None:
            self.third_category_no = third_category_no
        if goods_name is not None:
            self.goods_name = goods_name
        if gross_weight is not None:
            self.gross_weight = gross_weight
        if net_weight is not None:
            self.net_weight = net_weight
        if safe_days is not None:
            self.safe_days = safe_days
        if batch is not None:
            self.batch = batch
        if oversea_purchase is not None:
            self.oversea_purchase = oversea_purchase
        if pattern is not None:
            self.pattern = pattern
        if qi_record is not None:
            self.qi_record = qi_record
        if custom_record is not None:
            self.custom_record = custom_record
        if cc_provider is not None:
            self.cc_provider = cc_provider
        if bonded_area is not None:
            self.bonded_area = bonded_area
        if customs_seller_record is not None:
            self.customs_seller_record = customs_seller_record
        if bat_attr_ids is not None:
            self.bat_attr_ids = bat_attr_ids
        if model_number is not None:
            self.model_number = model_number
        if spec is not None:
            self.spec = spec
        if vat_rate is not None:
            self.vat_rate = vat_rate
        if tax_rate is not None:
            self.tax_rate = tax_rate
        if hs_code is not None:
            self.hs_code = hs_code
        if country is not None:
            self.country = country
        if qi_country is not None:
            self.qi_country = qi_country
        if legal_unit1 is not None:
            self.legal_unit1 = legal_unit1
        if legal_amount1 is not None:
            self.legal_amount1 = legal_amount1
        if legal_unit2 is not None:
            self.legal_unit2 = legal_unit2
        if legal_amount2 is not None:
            self.legal_amount2 = legal_amount2
        if measurement is not None:
            self.measurement = measurement
        if qi_measurement is not None:
            self.qi_measurement = qi_measurement
        if declaration_elements is not None:
            self.declaration_elements = declaration_elements

    @property
    def merchant_goods_no(self):
        """Gets the merchant_goods_no of this InventoryProduct.  # noqa: E501


        :return: The merchant_goods_no of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._merchant_goods_no

    @merchant_goods_no.setter
    def merchant_goods_no(self, merchant_goods_no):
        """Sets the merchant_goods_no of this InventoryProduct.


        :param merchant_goods_no: The merchant_goods_no of this InventoryProduct.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and merchant_goods_no is None:  # noqa: E501
            raise ValueError("Invalid value for `merchant_goods_no`, must not be `None`")  # noqa: E501

        self._merchant_goods_no = merchant_goods_no

    @property
    def platform_goods_no(self):
        """Gets the platform_goods_no of this InventoryProduct.  # noqa: E501


        :return: The platform_goods_no of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._platform_goods_no

    @platform_goods_no.setter
    def platform_goods_no(self, platform_goods_no):
        """Sets the platform_goods_no of this InventoryProduct.


        :param platform_goods_no: The platform_goods_no of this InventoryProduct.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and platform_goods_no is None:  # noqa: E501
            raise ValueError("Invalid value for `platform_goods_no`, must not be `None`")  # noqa: E501

        self._platform_goods_no = platform_goods_no

    @property
    def barcodes(self):
        """Gets the barcodes of this InventoryProduct.  # noqa: E501

        Barcodes, multiple bar codes are separated by commas.  # noqa: E501

        :return: The barcodes of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._barcodes

    @barcodes.setter
    def barcodes(self, barcodes):
        """Sets the barcodes of this InventoryProduct.

        Barcodes, multiple bar codes are separated by commas.  # noqa: E501

        :param barcodes: The barcodes of this InventoryProduct.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and barcodes is None:  # noqa: E501
            raise ValueError("Invalid value for `barcodes`, must not be `None`")  # noqa: E501

        self._barcodes = barcodes

    @property
    def warehouse_goods_no(self):
        """Gets the warehouse_goods_no of this InventoryProduct.  # noqa: E501

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :return: The warehouse_goods_no of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._warehouse_goods_no

    @warehouse_goods_no.setter
    def warehouse_goods_no(self, warehouse_goods_no):
        """Sets the warehouse_goods_no of this InventoryProduct.

        Warehouse goods No, generated by warehouse.  # noqa: E501

        :param warehouse_goods_no: The warehouse_goods_no of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._warehouse_goods_no = warehouse_goods_no

    @property
    def third_category_no(self):
        """Gets the third_category_no of this InventoryProduct.  # noqa: E501

        Goods category code of third level, required by Jingdong Logistics.  # noqa: E501

        :return: The third_category_no of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._third_category_no

    @third_category_no.setter
    def third_category_no(self, third_category_no):
        """Sets the third_category_no of this InventoryProduct.

        Goods category code of third level, required by Jingdong Logistics.  # noqa: E501

        :param third_category_no: The third_category_no of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._third_category_no = third_category_no

    @property
    def goods_name(self):
        """Gets the goods_name of this InventoryProduct.  # noqa: E501


        :return: The goods_name of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._goods_name

    @goods_name.setter
    def goods_name(self, goods_name):
        """Sets the goods_name of this InventoryProduct.


        :param goods_name: The goods_name of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._goods_name = goods_name

    @property
    def gross_weight(self):
        """Gets the gross_weight of this InventoryProduct.  # noqa: E501

        Gross weight, the unit of mass is kilograms.  # noqa: E501

        :return: The gross_weight of this InventoryProduct.  # noqa: E501
        :rtype: float
        """
        return self._gross_weight

    @gross_weight.setter
    def gross_weight(self, gross_weight):
        """Sets the gross_weight of this InventoryProduct.

        Gross weight, the unit of mass is kilograms.  # noqa: E501

        :param gross_weight: The gross_weight of this InventoryProduct.  # noqa: E501
        :type: float
        """

        self._gross_weight = gross_weight

    @property
    def net_weight(self):
        """Gets the net_weight of this InventoryProduct.  # noqa: E501

        Net weight, the unit of mass is kilograms.  # noqa: E501

        :return: The net_weight of this InventoryProduct.  # noqa: E501
        :rtype: float
        """
        return self._net_weight

    @net_weight.setter
    def net_weight(self, net_weight):
        """Sets the net_weight of this InventoryProduct.

        Net weight, the unit of mass is kilograms.  # noqa: E501

        :param net_weight: The net_weight of this InventoryProduct.  # noqa: E501
        :type: float
        """

        self._net_weight = net_weight

    @property
    def safe_days(self):
        """Gets the safe_days of this InventoryProduct.  # noqa: E501


        :return: The safe_days of this InventoryProduct.  # noqa: E501
        :rtype: int
        """
        return self._safe_days

    @safe_days.setter
    def safe_days(self, safe_days):
        """Sets the safe_days of this InventoryProduct.


        :param safe_days: The safe_days of this InventoryProduct.  # noqa: E501
        :type: int
        """

        self._safe_days = safe_days

    @property
    def batch(self):
        """Gets the batch of this InventoryProduct.  # noqa: E501


        :return: The batch of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._batch

    @batch.setter
    def batch(self, batch):
        """Sets the batch of this InventoryProduct.


        :param batch: The batch of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._batch = batch

    @property
    def oversea_purchase(self):
        """Gets the oversea_purchase of this InventoryProduct.  # noqa: E501


        :return: The oversea_purchase of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._oversea_purchase

    @oversea_purchase.setter
    def oversea_purchase(self, oversea_purchase):
        """Sets the oversea_purchase of this InventoryProduct.


        :param oversea_purchase: The oversea_purchase of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._oversea_purchase = oversea_purchase

    @property
    def pattern(self):
        """Gets the pattern of this InventoryProduct.  # noqa: E501

        Cross-border business type, options: BBC, BC, CC.  # noqa: E501

        :return: The pattern of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """Sets the pattern of this InventoryProduct.

        Cross-border business type, options: BBC, BC, CC.  # noqa: E501

        :param pattern: The pattern of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._pattern = pattern

    @property
    def qi_record(self):
        """Gets the qi_record of this InventoryProduct.  # noqa: E501


        :return: The qi_record of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._qi_record

    @qi_record.setter
    def qi_record(self, qi_record):
        """Sets the qi_record of this InventoryProduct.


        :param qi_record: The qi_record of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._qi_record = qi_record

    @property
    def custom_record(self):
        """Gets the custom_record of this InventoryProduct.  # noqa: E501

        Goods customs record No.  # noqa: E501

        :return: The custom_record of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._custom_record

    @custom_record.setter
    def custom_record(self, custom_record):
        """Sets the custom_record of this InventoryProduct.

        Goods customs record No.  # noqa: E501

        :param custom_record: The custom_record of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._custom_record = custom_record

    @property
    def cc_provider(self):
        """Gets the cc_provider of this InventoryProduct.  # noqa: E501

        Customs clearance service provider.  # noqa: E501

        :return: The cc_provider of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._cc_provider

    @cc_provider.setter
    def cc_provider(self, cc_provider):
        """Sets the cc_provider of this InventoryProduct.

        Customs clearance service provider.  # noqa: E501

        :param cc_provider: The cc_provider of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._cc_provider = cc_provider

    @property
    def bonded_area(self):
        """Gets the bonded_area of this InventoryProduct.  # noqa: E501


        :return: The bonded_area of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._bonded_area

    @bonded_area.setter
    def bonded_area(self, bonded_area):
        """Sets the bonded_area of this InventoryProduct.


        :param bonded_area: The bonded_area of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._bonded_area = bonded_area

    @property
    def customs_seller_record(self):
        """Gets the customs_seller_record of this InventoryProduct.  # noqa: E501

        Goods record assigned by the customs system after the commodity is registered.  # noqa: E501

        :return: The customs_seller_record of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._customs_seller_record

    @customs_seller_record.setter
    def customs_seller_record(self, customs_seller_record):
        """Sets the customs_seller_record of this InventoryProduct.

        Goods record assigned by the customs system after the commodity is registered.  # noqa: E501

        :param customs_seller_record: The customs_seller_record of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._customs_seller_record = customs_seller_record

    @property
    def bat_attr_ids(self):
        """Gets the bat_attr_ids of this InventoryProduct.  # noqa: E501

        Batch attributes, 1: purchase order number, 2: production date, 3: supplier, 4: receipt date, 5: PLU management batch attribute, 6: logistics company, 7: origin, 8: batch number, 9: manufacturer, 10: packaging batch number, 11: container number attribute, 12: unsaleable attribute. Enter the number, separate the attributes of multiple batches with commas.  # noqa: E501

        :return: The bat_attr_ids of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._bat_attr_ids

    @bat_attr_ids.setter
    def bat_attr_ids(self, bat_attr_ids):
        """Sets the bat_attr_ids of this InventoryProduct.

        Batch attributes, 1: purchase order number, 2: production date, 3: supplier, 4: receipt date, 5: PLU management batch attribute, 6: logistics company, 7: origin, 8: batch number, 9: manufacturer, 10: packaging batch number, 11: container number attribute, 12: unsaleable attribute. Enter the number, separate the attributes of multiple batches with commas.  # noqa: E501

        :param bat_attr_ids: The bat_attr_ids of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._bat_attr_ids = bat_attr_ids

    @property
    def model_number(self):
        """Gets the model_number of this InventoryProduct.  # noqa: E501


        :return: The model_number of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._model_number

    @model_number.setter
    def model_number(self, model_number):
        """Sets the model_number of this InventoryProduct.


        :param model_number: The model_number of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._model_number = model_number

    @property
    def spec(self):
        """Gets the spec of this InventoryProduct.  # noqa: E501


        :return: The spec of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._spec

    @spec.setter
    def spec(self, spec):
        """Sets the spec of this InventoryProduct.


        :param spec: The spec of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._spec = spec

    @property
    def vat_rate(self):
        """Gets the vat_rate of this InventoryProduct.  # noqa: E501

        VAT rate, fill in the integer, for example: 16% VAT, pass 16  # noqa: E501

        :return: The vat_rate of this InventoryProduct.  # noqa: E501
        :rtype: int
        """
        return self._vat_rate

    @vat_rate.setter
    def vat_rate(self, vat_rate):
        """Sets the vat_rate of this InventoryProduct.

        VAT rate, fill in the integer, for example: 16% VAT, pass 16  # noqa: E501

        :param vat_rate: The vat_rate of this InventoryProduct.  # noqa: E501
        :type: int
        """

        self._vat_rate = vat_rate

    @property
    def tax_rate(self):
        """Gets the tax_rate of this InventoryProduct.  # noqa: E501


        :return: The tax_rate of this InventoryProduct.  # noqa: E501
        :rtype: int
        """
        return self._tax_rate

    @tax_rate.setter
    def tax_rate(self, tax_rate):
        """Sets the tax_rate of this InventoryProduct.


        :param tax_rate: The tax_rate of this InventoryProduct.  # noqa: E501
        :type: int
        """

        self._tax_rate = tax_rate

    @property
    def hs_code(self):
        """Gets the hs_code of this InventoryProduct.  # noqa: E501


        :return: The hs_code of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._hs_code

    @hs_code.setter
    def hs_code(self, hs_code):
        """Sets the hs_code of this InventoryProduct.


        :param hs_code: The hs_code of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._hs_code = hs_code

    @property
    def country(self):
        """Gets the country of this InventoryProduct.  # noqa: E501

        Country of origin.  # noqa: E501

        :return: The country of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this InventoryProduct.

        Country of origin.  # noqa: E501

        :param country: The country of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def qi_country(self):
        """Gets the qi_country of this InventoryProduct.  # noqa: E501


        :return: The qi_country of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._qi_country

    @qi_country.setter
    def qi_country(self, qi_country):
        """Sets the qi_country of this InventoryProduct.


        :param qi_country: The qi_country of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._qi_country = qi_country

    @property
    def legal_unit1(self):
        """Gets the legal_unit1 of this InventoryProduct.  # noqa: E501

        The first legal unit of measurement.  # noqa: E501

        :return: The legal_unit1 of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._legal_unit1

    @legal_unit1.setter
    def legal_unit1(self, legal_unit1):
        """Sets the legal_unit1 of this InventoryProduct.

        The first legal unit of measurement.  # noqa: E501

        :param legal_unit1: The legal_unit1 of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._legal_unit1 = legal_unit1

    @property
    def legal_amount1(self):
        """Gets the legal_amount1 of this InventoryProduct.  # noqa: E501

        The first legal amount of measurement.  # noqa: E501

        :return: The legal_amount1 of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._legal_amount1

    @legal_amount1.setter
    def legal_amount1(self, legal_amount1):
        """Sets the legal_amount1 of this InventoryProduct.

        The first legal amount of measurement.  # noqa: E501

        :param legal_amount1: The legal_amount1 of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._legal_amount1 = legal_amount1

    @property
    def legal_unit2(self):
        """Gets the legal_unit2 of this InventoryProduct.  # noqa: E501

        The second legal unit of measurement.  # noqa: E501

        :return: The legal_unit2 of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._legal_unit2

    @legal_unit2.setter
    def legal_unit2(self, legal_unit2):
        """Sets the legal_unit2 of this InventoryProduct.

        The second legal unit of measurement.  # noqa: E501

        :param legal_unit2: The legal_unit2 of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._legal_unit2 = legal_unit2

    @property
    def legal_amount2(self):
        """Gets the legal_amount2 of this InventoryProduct.  # noqa: E501

        The second legal amount of measurement.  # noqa: E501

        :return: The legal_amount2 of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._legal_amount2

    @legal_amount2.setter
    def legal_amount2(self, legal_amount2):
        """Sets the legal_amount2 of this InventoryProduct.

        The second legal amount of measurement.  # noqa: E501

        :param legal_amount2: The legal_amount2 of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._legal_amount2 = legal_amount2

    @property
    def measurement(self):
        """Gets the measurement of this InventoryProduct.  # noqa: E501

        Customs unit of measurement.  # noqa: E501

        :return: The measurement of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._measurement

    @measurement.setter
    def measurement(self, measurement):
        """Sets the measurement of this InventoryProduct.

        Customs unit of measurement.  # noqa: E501

        :param measurement: The measurement of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._measurement = measurement

    @property
    def qi_measurement(self):
        """Gets the qi_measurement of this InventoryProduct.  # noqa: E501


        :return: The qi_measurement of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._qi_measurement

    @qi_measurement.setter
    def qi_measurement(self, qi_measurement):
        """Sets the qi_measurement of this InventoryProduct.


        :param qi_measurement: The qi_measurement of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._qi_measurement = qi_measurement

    @property
    def declaration_elements(self):
        """Gets the declaration_elements of this InventoryProduct.  # noqa: E501

        Customs declaration elements, separate each item with a comma.  # noqa: E501

        :return: The declaration_elements of this InventoryProduct.  # noqa: E501
        :rtype: str
        """
        return self._declaration_elements

    @declaration_elements.setter
    def declaration_elements(self, declaration_elements):
        """Sets the declaration_elements of this InventoryProduct.

        Customs declaration elements, separate each item with a comma.  # noqa: E501

        :param declaration_elements: The declaration_elements of this InventoryProduct.  # noqa: E501
        :type: str
        """

        self._declaration_elements = declaration_elements

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InventoryProduct):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InventoryProduct):
            return True

        return self.to_dict() != other.to_dict()
