# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.52.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class ApiResponseInventory(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'code': 'int',
        'message': 'str',
        'connector_responses': 'list[ApiResponseConnectorResponse]',
        'products': 'list[InventoryResponseProduct]',
        'purchases': 'list[InventoryResponsePurchase]'
    }

    attribute_map = {
        'code': 'code',
        'message': 'message',
        'connector_responses': 'connectorResponses',
        'products': 'products',
        'purchases': 'purchases'
    }

    def __init__(self, code=None, message=None, connector_responses=None, products=None, purchases=None, local_vars_configuration=None):  # noqa: E501
        """ApiResponseInventory - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._code = None
        self._message = None
        self._connector_responses = None
        self._products = None
        self._purchases = None
        self.discriminator = None

        if code is not None:
            self.code = code
        if message is not None:
            self.message = message
        if connector_responses is not None:
            self.connector_responses = connector_responses
        if products is not None:
            self.products = products
        if purchases is not None:
            self.purchases = purchases

    @property
    def code(self):
        """Gets the code of this ApiResponseInventory.  # noqa: E501


        :return: The code of this ApiResponseInventory.  # noqa: E501
        :rtype: int
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this ApiResponseInventory.


        :param code: The code of this ApiResponseInventory.  # noqa: E501
        :type: int
        """

        self._code = code

    @property
    def message(self):
        """Gets the message of this ApiResponseInventory.  # noqa: E501


        :return: The message of this ApiResponseInventory.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ApiResponseInventory.


        :param message: The message of this ApiResponseInventory.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def connector_responses(self):
        """Gets the connector_responses of this ApiResponseInventory.  # noqa: E501


        :return: The connector_responses of this ApiResponseInventory.  # noqa: E501
        :rtype: list[ApiResponseConnectorResponse]
        """
        return self._connector_responses

    @connector_responses.setter
    def connector_responses(self, connector_responses):
        """Sets the connector_responses of this ApiResponseInventory.


        :param connector_responses: The connector_responses of this ApiResponseInventory.  # noqa: E501
        :type: list[ApiResponseConnectorResponse]
        """

        self._connector_responses = connector_responses

    @property
    def products(self):
        """Gets the products of this ApiResponseInventory.  # noqa: E501


        :return: The products of this ApiResponseInventory.  # noqa: E501
        :rtype: list[InventoryResponseProduct]
        """
        return self._products

    @products.setter
    def products(self, products):
        """Sets the products of this ApiResponseInventory.


        :param products: The products of this ApiResponseInventory.  # noqa: E501
        :type: list[InventoryResponseProduct]
        """

        self._products = products

    @property
    def purchases(self):
        """Gets the purchases of this ApiResponseInventory.  # noqa: E501


        :return: The purchases of this ApiResponseInventory.  # noqa: E501
        :rtype: list[InventoryResponsePurchase]
        """
        return self._purchases

    @purchases.setter
    def purchases(self, purchases):
        """Sets the purchases of this ApiResponseInventory.


        :param purchases: The purchases of this ApiResponseInventory.  # noqa: E501
        :type: list[InventoryResponsePurchase]
        """

        self._purchases = purchases

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiResponseInventory):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApiResponseInventory):
            return True

        return self.to_dict() != other.to_dict()
