# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://www.samarkand.global/) in partnership with [SF Express](https://www.sf-express.com/), [eSinotrans](http://air.esinotrans.com/), [sto](http://sto-express.co.uk/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.52.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_pilot_cli.api_client import ApiClient
from nomad_pilot_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class InventoryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_inventory_product(self, carrier, **kwargs):  # noqa: E501
        """inventory  # noqa: E501

        Query products details from third party logistics company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inventory_product(carrier, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: The carrier name (required)
        :param str warehouse_goods_no: Product number used in warehouse.
        :param str stock_status: Stock status, options: 1, Good product; 2, Defective product; 3, Samples.
        :param str stock_type: Stock type, options: 1, Normal; 2, Product to be returned; 3, Store reservation; 4, Warehouse lock; 5, Inventory lock.
        :param str shop_no: Shop number, required for shop stock query.
        :param int page_no: Page number, between 1 and 1000
        :param int page_size: Page size, options: [1, 10, 50, 100, 1000]
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponseInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_inventory_product_with_http_info(carrier, **kwargs)  # noqa: E501

    def get_inventory_product_with_http_info(self, carrier, **kwargs):  # noqa: E501
        """inventory  # noqa: E501

        Query products details from third party logistics company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_inventory_product_with_http_info(carrier, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: The carrier name (required)
        :param str warehouse_goods_no: Product number used in warehouse.
        :param str stock_status: Stock status, options: 1, Good product; 2, Defective product; 3, Samples.
        :param str stock_type: Stock type, options: 1, Normal; 2, Product to be returned; 3, Store reservation; 4, Warehouse lock; 5, Inventory lock.
        :param str shop_no: Shop number, required for shop stock query.
        :param int page_no: Page number, between 1 and 1000
        :param int page_size: Page size, options: [1, 10, 50, 100, 1000]
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponseInventory, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'warehouse_goods_no', 'stock_status', 'stock_type', 'shop_no', 'page_no', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_inventory_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `get_inventory_product`")  # noqa: E501

        if self.api_client.client_side_validation and 'page_no' in local_var_params and local_var_params['page_no'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_no` when calling `get_inventory_product`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'page_no' in local_var_params and local_var_params['page_no'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page_no` when calling `get_inventory_product`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []
        if 'warehouse_goods_no' in local_var_params and local_var_params['warehouse_goods_no'] is not None:  # noqa: E501
            query_params.append(('warehouse_goods_no', local_var_params['warehouse_goods_no']))  # noqa: E501
        if 'stock_status' in local_var_params and local_var_params['stock_status'] is not None:  # noqa: E501
            query_params.append(('stock_status', local_var_params['stock_status']))  # noqa: E501
        if 'stock_type' in local_var_params and local_var_params['stock_type'] is not None:  # noqa: E501
            query_params.append(('stock_type', local_var_params['stock_type']))  # noqa: E501
        if 'shop_no' in local_var_params and local_var_params['shop_no'] is not None:  # noqa: E501
            query_params.append(('shop_no', local_var_params['shop_no']))  # noqa: E501
        if 'page_no' in local_var_params and local_var_params['page_no'] is not None:  # noqa: E501
            query_params.append(('page_no', local_var_params['page_no']))  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('page_size', local_var_params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/inventory/product/{carrier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseInventory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_inventory_product(self, carrier, inventory_product, **kwargs):  # noqa: E501
        """inventory  # noqa: E501

        Register products to third party logistics company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_inventory_product(carrier, inventory_product, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: The carrier name (required)
        :param InventoryProduct inventory_product: Inventory product request body. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponseInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_inventory_product_with_http_info(carrier, inventory_product, **kwargs)  # noqa: E501

    def post_inventory_product_with_http_info(self, carrier, inventory_product, **kwargs):  # noqa: E501
        """inventory  # noqa: E501

        Register products to third party logistics company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_inventory_product_with_http_info(carrier, inventory_product, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: The carrier name (required)
        :param InventoryProduct inventory_product: Inventory product request body. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponseInventory, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'inventory_product']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_inventory_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `post_inventory_product`")  # noqa: E501
        # verify the required parameter 'inventory_product' is set
        if self.api_client.client_side_validation and ('inventory_product' not in local_var_params or  # noqa: E501
                                                        local_var_params['inventory_product'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_product` when calling `post_inventory_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inventory_product' in local_var_params:
            body_params = local_var_params['inventory_product']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/inventory/product/{carrier}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseInventory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_inventory_product(self, carrier, inventory_product, **kwargs):  # noqa: E501
        """inventory  # noqa: E501

        Update products with third party logistics company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_inventory_product(carrier, inventory_product, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: The carrier name (required)
        :param InventoryProduct inventory_product: Inventory product request body. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponseInventory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_inventory_product_with_http_info(carrier, inventory_product, **kwargs)  # noqa: E501

    def put_inventory_product_with_http_info(self, carrier, inventory_product, **kwargs):  # noqa: E501
        """inventory  # noqa: E501

        Update products with third party logistics company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_inventory_product_with_http_info(carrier, inventory_product, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: The carrier name (required)
        :param InventoryProduct inventory_product: Inventory product request body. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponseInventory, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'inventory_product']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_inventory_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `put_inventory_product`")  # noqa: E501
        # verify the required parameter 'inventory_product' is set
        if self.api_client.client_side_validation and ('inventory_product' not in local_var_params or  # noqa: E501
                                                        local_var_params['inventory_product'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `inventory_product` when calling `put_inventory_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'inventory_product' in local_var_params:
            body_params = local_var_params['inventory_product']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/inventory/product/{carrier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseInventory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
