# -*- coding: utf-8 -*-

"""
apimaticcalculator

This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from apimaticcalculator.api_helper import APIHelper
from apimaticcalculator.controllers.simple_calculator_controller import SimpleCalculatorController


class SimpleCalculatorControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(SimpleCalculatorControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = SimpleCalculatorController(cls.config, cls.response_catcher)

    # Check if multiplication works
    def test_multiply(self):
        # Parameters for the API call
        options = {}
        options['operation'] = 'MULTIPLY'
        options['x'] = 4
        options['y'] = 5

        # Perform the API call through the SDK function
        result = self.controller.get_calculate(options)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)
        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        self.assertEqual('20', self.response_catcher.response.text)


